
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort

var e;e||(e=typeof Module !== 'undefined' ? Module : {});null;
e.onRuntimeInitialized=function(){function a(g,m){switch(typeof m){case "boolean":jc(g,m?1:0);break;case "number":kc(g,m);break;case "string":lc(g,m,-1,-1);break;case "object":if(null===m)mb(g);else if(null!=m.length){var n=aa(m);mc(g,n,m.length,-1);ba(n)}else Aa(g,"Wrong API use : tried to return a value of an unknown type ("+m+").",-1);break;default:mb(g)}}function b(g,m){for(var n=[],p=0;p<g;p+=1){var v=k(m+4*p,"i32"),y=nc(v);if(1===y||2===y)v=oc(v);else if(3===y)v=pc(v);else if(4===y){y=v;v=qc(y);
y=rc(y);for(var L=new Uint8Array(v),G=0;G<v;G+=1)L[G]=q[y+G];v=L}else v=null;n.push(v)}return n}function c(g,m){this.La=g;this.db=m;this.Ja=1;this.fb=[]}function d(g,m){this.db=m;m=ca(g)+1;this.Ya=da(m);if(null===this.Ya)throw Error("Unable to allocate memory for the SQL string");r(g,t,this.Ya,m);this.eb=this.Ya;this.Ua=this.ib=null}function f(g){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=g){var m=this.filename,n="/",p=m;n&&(n="string"==typeof n?n:ea(n),p=m?z(n+"/"+m):n);m=fa(!0,
!0);p=ha(p,(void 0!==m?m:438)&4095|32768,0);if(g){if("string"==typeof g){n=Array(g.length);for(var v=0,y=g.length;v<y;++v)n[v]=g.charCodeAt(v);g=n}ia(p,m|146);n=ja(p,577);ka(n,g,0,g.length,0);la(n);ia(p,m)}}this.handleError(u(this.filename,h));this.db=k(h,"i32");sc(this.db);this.Za={};this.Na={}}var h=B(4),l=e.cwrap,u=l("sqlite3_open","number",["string","number"]),x=l("sqlite3_close_v2","number",["number"]),w=l("sqlite3_exec","number",["number","string","number","number","number"]),A=l("sqlite3_changes",
"number",["number"]),S=l("sqlite3_prepare_v2","number",["number","string","number","number","number"]),pb=l("sqlite3_sql","string",["number"]),tc=l("sqlite3_normalized_sql","string",["number"]),qb=l("sqlite3_prepare_v2","number",["number","number","number","number","number"]),uc=l("sqlite3_bind_text","number",["number","number","number","number","number"]),rb=l("sqlite3_bind_blob","number",["number","number","number","number","number"]),vc=l("sqlite3_bind_double","number",["number","number","number"]),
wc=l("sqlite3_bind_int","number",["number","number","number"]),xc=l("sqlite3_bind_parameter_index","number",["number","string"]),yc=l("sqlite3_step","number",["number"]),zc=l("sqlite3_errmsg","string",["number"]),Ac=l("sqlite3_column_count","number",["number"]),Bc=l("sqlite3_data_count","number",["number"]),Cc=l("sqlite3_column_double","number",["number","number"]),sb=l("sqlite3_column_text","string",["number","number"]),Dc=l("sqlite3_column_blob","number",["number","number"]),Ec=l("sqlite3_column_bytes",
"number",["number","number"]),Fc=l("sqlite3_column_type","number",["number","number"]),Gc=l("sqlite3_column_name","string",["number","number"]),Hc=l("sqlite3_reset","number",["number"]),Ic=l("sqlite3_clear_bindings","number",["number"]),Jc=l("sqlite3_finalize","number",["number"]),tb=l("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),nc=l("sqlite3_value_type","number",["number"]),qc=l("sqlite3_value_bytes","number",["number"]),pc=l("sqlite3_value_text",
"string",["number"]),rc=l("sqlite3_value_blob","number",["number"]),oc=l("sqlite3_value_double","number",["number"]),kc=l("sqlite3_result_double","",["number","number"]),mb=l("sqlite3_result_null","",["number"]),lc=l("sqlite3_result_text","",["number","string","number","number"]),mc=l("sqlite3_result_blob","",["number","number","number","number"]),jc=l("sqlite3_result_int","",["number","number"]),Aa=l("sqlite3_result_error","",["number","string","number"]),ub=l("sqlite3_aggregate_context","number",
["number","number"]),sc=l("RegisterExtensionFunctions","number",["number"]);c.prototype.bind=function(g){if(!this.La)throw"Statement closed";this.reset();return Array.isArray(g)?this.xb(g):null!=g&&"object"===typeof g?this.yb(g):!0};c.prototype.step=function(){if(!this.La)throw"Statement closed";this.Ja=1;var g=yc(this.La);switch(g){case 100:return!0;case 101:return!1;default:throw this.db.handleError(g);}};c.prototype.sb=function(g){null==g&&(g=this.Ja,this.Ja+=1);return Cc(this.La,g)};c.prototype.Cb=
function(g){null==g&&(g=this.Ja,this.Ja+=1);g=sb(this.La,g);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(g)};c.prototype.Db=function(g){null==g&&(g=this.Ja,this.Ja+=1);return sb(this.La,g)};c.prototype.getBlob=function(g){null==g&&(g=this.Ja,this.Ja+=1);var m=Ec(this.La,g);g=Dc(this.La,g);for(var n=new Uint8Array(m),p=0;p<m;p+=1)n[p]=q[g+p];return n};c.prototype.get=function(g,m){m=m||{};null!=g&&this.bind(g)&&this.step();g=[];for(var n=Bc(this.La),p=0;p<n;p+=
1)switch(Fc(this.La,p)){case 1:var v=m.useBigInt?this.Cb(p):this.sb(p);g.push(v);break;case 2:g.push(this.sb(p));break;case 3:g.push(this.Db(p));break;case 4:g.push(this.getBlob(p));break;default:g.push(null)}return g};c.prototype.getColumnNames=function(){for(var g=[],m=Ac(this.La),n=0;n<m;n+=1)g.push(Gc(this.La,n));return g};c.prototype.getAsObject=function(g,m){g=this.get(g,m);m=this.getColumnNames();for(var n={},p=0;p<m.length;p+=1)n[m[p]]=g[p];return n};c.prototype.getSQL=function(){return pb(this.La)};
c.prototype.getNormalizedSQL=function(){return tc(this.La)};c.prototype.run=function(g){null!=g&&this.bind(g);this.step();return this.reset()};c.prototype.nb=function(g,m){null==m&&(m=this.Ja,this.Ja+=1);g=ma(g);var n=aa(g);this.fb.push(n);this.db.handleError(uc(this.La,m,n,g.length-1,0))};c.prototype.wb=function(g,m){null==m&&(m=this.Ja,this.Ja+=1);var n=aa(g);this.fb.push(n);this.db.handleError(rb(this.La,m,n,g.length,0))};c.prototype.mb=function(g,m){null==m&&(m=this.Ja,this.Ja+=1);this.db.handleError((g===
(g|0)?wc:vc)(this.La,m,g))};c.prototype.zb=function(g){null==g&&(g=this.Ja,this.Ja+=1);rb(this.La,g,0,0,0)};c.prototype.ob=function(g,m){null==m&&(m=this.Ja,this.Ja+=1);switch(typeof g){case "string":this.nb(g,m);return;case "number":this.mb(g,m);return;case "bigint":this.nb(g.toString(),m);return;case "boolean":this.mb(g+0,m);return;case "object":if(null===g){this.zb(m);return}if(null!=g.length){this.wb(g,m);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+g+").";};c.prototype.yb=
function(g){var m=this;Object.keys(g).forEach(function(n){var p=xc(m.La,n);0!==p&&m.ob(g[n],p)});return!0};c.prototype.xb=function(g){for(var m=0;m<g.length;m+=1)this.ob(g[m],m+1);return!0};c.prototype.reset=function(){this.freemem();return 0===Ic(this.La)&&0===Hc(this.La)};c.prototype.freemem=function(){for(var g;void 0!==(g=this.fb.pop());)ba(g)};c.prototype.free=function(){this.freemem();var g=0===Jc(this.La);delete this.db.Za[this.La];this.La=0;return g};d.prototype.next=function(){if(null===
this.Ya)return{done:!0};null!==this.Ua&&(this.Ua.free(),this.Ua=null);if(!this.db.db)throw this.gb(),Error("Database closed");var g=na(),m=B(4);oa(h);oa(m);try{this.db.handleError(qb(this.db.db,this.eb,-1,h,m));this.eb=k(m,"i32");var n=k(h,"i32");if(0===n)return this.gb(),{done:!0};this.Ua=new c(n,this.db);this.db.Za[n]=this.Ua;return{value:this.Ua,done:!1}}catch(p){throw this.ib=C(this.eb),this.gb(),p;}finally{pa(g)}};d.prototype.gb=function(){ba(this.Ya);this.Ya=null};d.prototype.getRemainingSQL=
function(){return null!==this.ib?this.ib:C(this.eb)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});f.prototype.run=function(g,m){if(!this.db)throw"Database closed";if(m){g=this.prepare(g,m);try{g.step()}finally{g.free()}}else this.handleError(w(this.db,g,0,0,h));return this};f.prototype.exec=function(g,m,n){if(!this.db)throw"Database closed";var p=na(),v=null;try{var y=ca(g)+1,L=B(y);r(g,q,L,y);var G=L;var I=B(4);for(g=[];0!==
k(G,"i8");){oa(h);oa(I);this.handleError(qb(this.db,G,-1,h,I));var J=k(h,"i32");G=k(I,"i32");if(0!==J){y=null;v=new c(J,this);for(null!=m&&v.bind(m);v.step();)null===y&&(y={columns:v.getColumnNames(),values:[]},g.push(y)),y.values.push(v.get(null,n));v.free()}}return g}catch(sa){throw v&&v.free(),sa;}finally{pa(p)}};f.prototype.each=function(g,m,n,p,v){"function"===typeof m&&(p=n,n=m,m=void 0);g=this.prepare(g,m);try{for(;g.step();)n(g.getAsObject(null,v))}finally{g.free()}if("function"===typeof p)return p()};
f.prototype.prepare=function(g,m){oa(h);this.handleError(S(this.db,g,-1,h,0));g=k(h,"i32");if(0===g)throw"Nothing to prepare";var n=new c(g,this);null!=m&&n.bind(m);return this.Za[g]=n};f.prototype.iterateStatements=function(g){return new d(g,this)};f.prototype["export"]=function(){Object.values(this.Za).forEach(function(m){m.free()});Object.values(this.Na).forEach(qa);this.Na={};this.handleError(x(this.db));var g=ra(this.filename);this.handleError(u(this.filename,h));this.db=k(h,"i32");return g};
f.prototype.close=function(){null!==this.db&&(Object.values(this.Za).forEach(function(g){g.free()}),Object.values(this.Na).forEach(qa),this.Na={},this.handleError(x(this.db)),ta("/"+this.filename),this.db=null)};f.prototype.handleError=function(g){if(0===g)return null;g=zc(this.db);throw Error(g);};f.prototype.getRowsModified=function(){return A(this.db)};f.prototype.create_function=function(g,m){Object.prototype.hasOwnProperty.call(this.Na,g)&&(qa(this.Na[g]),delete this.Na[g]);var n=ua(function(p,
v,y){v=b(v,y);try{var L=m.apply(null,v)}catch(G){Aa(p,G,-1);return}a(p,L)});this.Na[g]=n;this.handleError(tb(this.db,g,m.length,1,0,n,0,0,0));return this};f.prototype.create_aggregate=function(g,m){var n=m.init||function(){return null},p=m.finalize||function(I){return I},v=m.step;if(!v)throw"An aggregate function must have a step function in "+g;var y={};Object.hasOwnProperty.call(this.Na,g)&&(qa(this.Na[g]),delete this.Na[g]);m=g+"__finalize";Object.hasOwnProperty.call(this.Na,m)&&(qa(this.Na[m]),
delete this.Na[m]);var L=ua(function(I,J,sa){var Z=ub(I,1);Object.hasOwnProperty.call(y,Z)||(y[Z]=n());J=b(J,sa);J=[y[Z]].concat(J);try{y[Z]=v.apply(null,J)}catch(Lc){delete y[Z],Aa(I,Lc,-1)}}),G=ua(function(I){var J=ub(I,1);try{var sa=p(y[J])}catch(Z){delete y[J];Aa(I,Z,-1);return}a(I,sa);delete y[J]});this.Na[g]=L;this.Na[m]=G;this.handleError(tb(this.db,g,v.length-1,1,0,0,L,G,0));return this};e.Database=f};
var va=Object.assign({},e),wa="./this.program",xa="object"==typeof window,ya="function"==typeof importScripts,za="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,D="",Ba,Ca,Da,fs,Ea,Fa;
if(za)D=ya?require("path").dirname(D)+"/":__dirname+"/",Fa=()=>{Ea||(fs=require("fs"),Ea=require("path"))},Ba=function(a,b){var c=Ga(a);if(c)return b?c:c.toString();Fa();a=Ea.normalize(a);return fs.readFileSync(a,b?void 0:"utf8")},Da=a=>{a=Ba(a,!0);a.buffer||(a=new Uint8Array(a));return a},Ca=(a,b,c)=>{var d=Ga(a);d&&b(d);Fa();a=Ea.normalize(a);fs.readFile(a,function(f,h){f?c(f):b(h.buffer)})},1<process.argv.length&&(wa=process.argv[1].replace(/\\/g,"/")),process.argv.slice(2),"undefined"!=typeof module&&
(module.exports=e),e.inspect=function(){return"[Emscripten Module object]"};else if(xa||ya)ya?D=self.location.href:"undefined"!=typeof document&&document.currentScript&&(D=document.currentScript.src),D=0!==D.indexOf("blob:")?D.substr(0,D.replace(/[?#].*/,"").lastIndexOf("/")+1):"",Ba=a=>{try{var b=new XMLHttpRequest;b.open("GET",a,!1);b.send(null);return b.responseText}catch(f){if(a=Ga(a)){b=[];for(var c=0;c<a.length;c++){var d=a[c];255<d&&(Ha&&E("Character code "+d+" ("+String.fromCharCode(d)+")  at offset "+
c+" not in 0x00-0xFF."),d&=255);b.push(String.fromCharCode(d))}return b.join("")}throw f;}},ya&&(Da=a=>{try{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}catch(c){if(a=Ga(a))return a;throw c;}}),Ca=(a,b,c)=>{var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=()=>{if(200==d.status||0==d.status&&d.response)b(d.response);else{var f=Ga(a);f?b(f.buffer):c()}};d.onerror=c;d.send(null)};
var Ia=e.print||console.log.bind(console),Ja=e.printErr||console.warn.bind(console);Object.assign(e,va);va=null;e.thisProgram&&(wa=e.thisProgram);var Ka;e.wasmBinary&&(Ka=e.wasmBinary);var noExitRuntime=e.noExitRuntime||!0;function La(){this.buffer=new ArrayBuffer(Ma/65536*65536)}function Na(){this.exports=(
// EMSCRIPTEN_START_ASM
function instantiate(Ua){function e(f){f.grow=function(b){var a=this.length;this.length=this.length+b;return a};f.set=function(c,d){this[c]=d};f.get=function(c){return this[c]};return f}var g;var h=new Uint8Array(123);for(var c=25;c>=0;--c){h[48+c]=52+c;h[65+c]=c;h[97+c]=26+c}h[43]=62;h[47]=63;function n(o,p,q){var i,j,c=0,k=p,l=q.length,m=p+(l*3>>2)-(q[l-2]=="=")-(q[l-1]=="=");for(;c<l;c+=4){i=h[q.charCodeAt(c+1)];j=h[q.charCodeAt(c+2)];o[k++]=h[q.charCodeAt(c)]<<2|i>>4;if(k<m)o[k++]=i<<4|j>>2;if(k<m)o[k++]=j<<6|h[q.charCodeAt(c+3)]}}function r(s){n(g,1024,"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");n(g,29558,"4D+amZmZmZmpP3sUrkfhenQ//Knx0k1iQD8tQxzr4jYKP/Fo44i1+NQ+je21oPfGoD5Ir7ya8tdqPjqMMOKOeTU+ldYm6AsuAT4AAQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSYnKCkqKywtLi8wMTIzNDU2Nzg5Ojs8PT4/QGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6W1xdXl9gYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXp7fH1+f4CBgoOEhYaHiImKi4yNjo+QkZKTlJWWl5iZmpucnZ6foKGio6SlpqeoqaqrrK2ur7CxsrO0tba3uLm6u7y9vr/AwcLDxMXGx8jJysvMzc7P0NHS09TV1tfY2drb3N3e3+Dh4uPk5ebn6Onq6+zt7u/w8fLz9PX29/j5+vv8/f7/AQAAAQEAAAEAAQABAQABAAABAAB/AAAAgAAAAIEAAAAEBQMFAQUBBQIFAgUBBQEFBAUDBQEFAQUCBQIFAQUBBQIFAwUCBQIFAgUCBQIFAgUEBQMFAgUCBQIFAgUCBQIFqQAAAHAAAAAeAAUBXgAAAVQBAABGAAAAKj9bACVfAAE=");n(g,30025,"AQEBAQE=");n(g,30048,"AQCAAEAAAIAAAAAAAAAAAAwMDAwMDAwMDAwAAAAAAAAACgoKCgoKAgICAgICAgICAgICAgICAgICAgKAAAAAQIAqKioqKioiIiIiIiIiIiIiIiIiIiIiIiIiIgAAAAAAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEABBAMCBQ==");n(g,30288,"UkVJTkRFWEVERVNDQVBFQUNIRUNLRVlCRUZPUkVJR05PUkVHRVhQTEFJTlNURUFEREFUQUJBU0VMRUNUQUJMRUZUSEVOREVGRVJSQUJMRUxTRVhDTFVERUxFVEVNUE9SQVJZSVNOVUxMU0FWRVBPSU5URVJTRUNUSUVTTk9UTlVMTElLRVhDRVBUUkFOU0FDVElPTkFUVVJBTFRFUkFJU0VYQ0xVU0lWRVhJU1RTQ09OU1RSQUlOVE9GRlNFVFJJR0dFUkFOR0VORVJBVEVERVRBQ0hBVklOR0xPQkVHSU5ORVJFRkVSRU5DRVNVTklRVUVSWVdJVEhPVVRFUkVMRUFTRUFUVEFDSEJFVFdFRU5PVEhJTkdST1VQU0NBU0NBREVGQVVMVENBU0VDT0xMQVRFQ1JFQVRFQ1VSUkVOVF9EQVRFSU1NRURJQVRFSk9JTlNFUlRNQVRDSFBMQU5BTFlaRVBSQUdNQVRFUklBTElaRURFRkVSUkVESVNUSU5DVFVQREFURVZBTFVFU1ZJUlRVQUxXQVlTV0hFTldIRVJFQ1VSU0lWRUFCT1JUQUZURVJFTkFNRUFORFJPUEFSVElUSU9OQVVUT0lOQ1JFTUVOVENBU1RDT0xVTU5DT01NSVRDT05GTElDVENST1NTQ1VSUkVOVF9USU1FU1RBTVBSRUNFRElOR0ZBSUxBU1RGSUxURVJFUExBQ0VGSVJTVEZPTExPV0lOR0ZST01GVUxMSU1JVElGT1JERVJFU1RSSUNUT1RIRVJTT1ZFUkVUVVJOSU5HUklHSFRST0xMQkFDS1JPV1NVTkJPVU5ERURVTklPTlVTSU5HVkFDVVVNVklFV0lORE9XQllJTklUSUFMTFlQUklNQVJZAAAAAAAAAAACAAIACAAJAA4AEAAUABcAGQAZAB0AIQAkACkALgAwADUANgA7AD4AQQBDAEUATgBRAFYAWgBaAF4AYwBlAGkAbwB3AHsAewB7AH4AgQCEAIkAjgCSAJMAmACcAKAAqACuALUAuAC4ALsAvQDDAMYAzgDTANgA2wDeAOIA7ADvAPQA9AD4APwAAwEJAQ8BFQEVARsBHAEgAScBKwEyATgBRAFNAU8BVQFaAVwBYwFnAXIBeQF6AYEBhwGNAZIBmAGcAZ8BqAGtAbEBtwG5AbwBxQHHAckB0gHWAdwB4gHqAe8B7wHvAf8BCAILAg8CFAIbAiACKQItAjACNQI3AjsCQwJJAkwCVQJaAmICYgJmAm8CdAJ5An8CggKFAogCigKPApMC");n(g,31264,"BwcFBAYEBQMGBwMGBgcHAwgCBgUEBAMKBAcGCQQCBgUJCQQHAwIEBAYLBgIHBQUJBgoEBgIDBwUJBgYEBQUKBgUHBAUHBgcHBgUHAwcEBwYMCQQGBQQHBgwICAIGBgcGBAUJBQUGAwQJDQICBAYGCAURDAcJBAQGBwUJBAQFAgUIBgQJBQgEAwkFBQYEBgICCQMH");n(g,31424,"6gMAAABAAADrAwAAAAAEAPcDAAAAAACA7AMAAAAAQADtAwAAAAABAO4DAAAACAAA7wMAAAAAgADwAwAAAAAAAfEDAAAAAAAC8gMAAAAAABDzAwAAAQAACPQDAAAAAAAE9gMAAAAAACD1AwAAAAAAQPgDAAACAAAA+QMAAIAAAAAAypo7AMqaO9AHAADoAwAA9AEAAICy5g5/AAAACgAAAFDDAAD+fwAA6AMAAAAAAAADAAAAggAAAIMAAACEAAAAhQAAAIYAAACHAAAAiAAAAIkAAACKAAAAiwAAAIwAAACNAAAAjgAAAI8AAACQAAAAkQAAAJIAAACTAAAAAwAAAKoAAACDAAAAhAAAAIUAAACGAAAAhwAAAKsAAACsAAAArQAAAIsAAACMAAAAjQAAAAAAAACPAAAAkAAAAJEAAACSAAAAkwAAAAEAAACuAAAAgwAAAIQAAACFAAAAhgAAAIcAAACvAAAAsAAAALEAAACLAAAAjAAAAI0AAAAAAAAAjwAAAJAAAACRAAAAkgAAAJMAAAADAAAAsgAAALMAAAC0AAAAtQAAALYAAAC3AAAAuAAAALgAAAAAAAAAuQAAAAAAAAC6");n(g,31896,"uwAAALw=");n(g,31912,"AQAAAL0AAAC+AAAAvwAAAMAAAADBAAAAwg==");n(g,31988,"2dUF+SChY9c=");n(g,32032,"U1FMaXRlIGZvcm1hdCAzAAABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fAAECAwQFBgcICQoLDA0ODwABAgMEBQYHAAECAwABAABCSU5BUlk=");n(g,32128,"EVIAAGpXAACfTAAAzkwAAJwJAAA2CwAAiycAAJEJAABgNgAAOSoAADQiAACYMAAAzCQAAK5DAAAhMwAAdjcAAOMKAABSJAAAqTYAAPsuAAA2CQAA+zIAAKMGAAA4CQAAr0YAAJJMAACqTAAA5kYAANcpAAAIMwAAfQwAAC03AAAwNwAA9jcAAMINAADmCAAAdiIAAPUIAAD7CAAANjcAAMEHAAAXBwAAzQcAAIxMAADgRgAAqUYAAKRMAAAoJAAASDcAAFo9AADJCAAAwCoAACQlAAC6EQAAPCsAACsrAADaNgAAOyQAAAwNAADdNgAACQ0AAOA2AAA3JAAADSUAABclAAA1KgAAzAcAADUiAAAxCwAAxUIAAIMmAACJJQAALzMAAE4rAAAbCwAAeyMAAEFYAABVLgAAfSUAAFQrAAAzKwAAzUMAAFo1AABxLwAA2QQAANgEAADQBAAAqCwAAJkGAAAvJAAAYioAABkEAADrCAAAlycAANYyAADZLwAAQysAANoLAAB5KQAAsCwAAB0EAAABNwAAaQkAAKQ1AACaNQAA/QUAAEU3AAAlJAAA0AsAAMALAABQPQAAswwAAOcEAABsNgAAmyMAAAINAABlPQAASDAAAC8JAABFJAAAuQUAAP9WAACvKwAA4SkAANQIAABrJQAA4zEAACw6AAAFKgAAjwsAAIw2AADtNwAAHAkAAGorAABtMAAAZAkAANAyAAAZRAAAEUQAAPo3AAClBgAAPTcAAAwJAAAWCQAAajAAABYsAADkNwAACywAAN8EAAAfJAAA5yEAACc2AAAkQwAAeEQAAG4TAABjNQAA7wUAAPArAACiIgAAuiwAAEA9AADIKgAA8yEAAA8GAACDCwAAyjEAAIAkAAB6WQAALTAAAL0rAAC1MgAARSwAACosAABQLAAAtCkAAIYwAADeBAAA7CkAAA4qAAB4KQAAjzMAADwJAACtCgAA5jIAAEo9AACuNgAAAgoAAI0uAABNJAAAwCkAAEU0AAAAAAAAtEsAAFhMAAAXTAAA2EUAAAAAAAABAgACAgABAgEBAQIBAhAAAgI=");n(g,32945,"AQIDBAYICAAAAAAAAAEBAgIDAwQEBQUGBgcHCAgJCQoKCwsMDA0NDg4PDxAQERESEhMTFBQVFRYWFxcYGBkZGhobGxwcHR0eHh8fICAhISIiIyMkJCUlJiYnJygoKSkqKisrLCwtLS4uLy8wMDExMjIzMzQ0NTU2Njc3ODg5ORBAAkA=");n(g,33088,"pUYAABJMAACJRgAAkU4AAAJMAAAAAQIDBAYIAAAAAAB2MwAApygAABcpAAAhACAAHgAcABo=");n(g,33152,"YzAAACoIAADmLgAAuDAAAKIEAACRKwAAAQEDAAUABgAI");n(g,33208,"AQ==");n(g,33232,"HRwcHBwcHBwcBwccBwccHBwcHBwcHBwcHBwcHBwcHBwHDwgFBBYYCBESFRQXCxoQAwMDAwMDAwMDAwUTDA4NBgUBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQACAgkcHBwCCAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAICHAocGRwbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxseGxsbGxsbGxsbGxsbGxsbG1RchlJpHQAAXgBVSAA1I1YPACphNlmHEwAAjAAogQAWawAJAAB7UABOBgBBZ5MAiHMAADAAWhgAEQAbRhcaBTyObnoASVtHkT14SgAxAAspAHEAAABtCm90fQ4yfABkABJ5kDiCi1hTJR5+AABsM4OAACIAAIQAYiYnABQtdV0AYnShJzopfEMhhD4/LwJBoyYYihB2nwuDoFuAFRUrMlINiV4zE0J5L4gGHHN2okcJFHeXRUSCTVlfKJMvBXZ9ewMaUXYOIDCYXJIjH3idcRFkCI9/LgQeRmEHjC2Bi1BgnpVIGx1jLIVXfg8xJDwKJXZkZFVYKlSmSVNWjnaUEpFKXaWWdgxMS1qGkE5PpD0iQId6");n(g,33780,"BAArAABqcgAAAAIAAI8AAAANAAAAAI0AAHc0AACJDAAAPgCKAIUAACQAABxNAAAAADsALw==");n(g,33842,"RQAAAAAAkgMAOgABSwAAAB8AAAAAAH8AaABAQj8AAAAAAC4AEAg=");n(g,33890,"UWUAcBUHQwBPYHYAAEQAAGMsADcATABfICE5GQBmAABX");n(g,33940,"EAABAAEBAQMDAQEDAwMBEgkJCQkBCQkJCQkJAQEBAQEBAQEBAQEBJiYjCwEBAwMDCwsLCwsLAQMDAQEBAQAAAgIIABAQEAAQABAQAAAQEAAAAAICAgAAEh4gAAAAABAQAAAmJiYmJiYmJiYmAAASAAAQAAAAAAAAAAAQEAAAAAAAAAAQAAAEBAAAEAAQAAAQAAAAAAAQAAAGEAAEGg==");n(g,34110,"EAAAEBAC");n(g,34128,"CyQAAFE2AACAWQAA0lgAAKlYAAAoWAAA7FcAAFAKAABiOAAAFgoAAOI5AAB3Kw==");n(g,34184,"wwAAAMQAAADFAAAAAAAAAMYAAADHAAAAyAAAAMkAAADKAAAAywAAAMw=");n(g,34272,"QQsAAAEQ");n(g,34288,"RTgAAAIUAAAIAAAAAAAAABYqAAADlQ==");n(g,34320,"xwUAAAQUAAAAgAAAAAAAAOMHAAAFEDgBAAAAAAAAAAAwLwAABpU=");n(g,34368,"XisAAAeU");n(g,34384,"hjUAAAgC");n(g,34400,"iCwAAAQUAAAAACAAAAAAALhBAAAEFAAAEAAAAAAAAABcCAAACRAmAgAAAAAAAAAAwBEAAAoQ");n(g,34464,"phUAAAQUAAAAAAAAAQAAAF0oAAACGAAADwAAAAAAAABrCAAADBAvAwAAAAAAAAAAKC8AAA2VNwEAAAAAAAAAAA8NAAAEFAAAAAAIAAAAAABXEwAABBQAAAABAAAAAAAAbS4AAA4U");n(g,34576,"aiwAAA9xKwQAAAAAAAAAADIIAAAQYQAIAAAAAAAAAAAVDQAABBQAAABAAAAAAAAARgkAAAIY");n(g,34640,"GBQAAAQUAAAEAAAAAAAAAMNBAAAEFAAACAAAAAAAAABOCAAAERAbBgAAAAAAAAAAYAsAABIQ");n(g,34704,"zA0AAAQUAAAAAgAAAAAAACIqAAATAw==");n(g,34736,"VSUAABRhFQMAAAAAAAAAAEMIAAAVYSYFAAAAAAAAAAAzJQAAFGEVBgEAAAAAAAAAWiwAABZx");n(g,34800,"NzYAABeR");n(g,34816,"cAsAABiQ");n(g,34832,"TzQAAAQUAAAAAAAEAAAAAEQ2AAAakA==");n(g,34864,"VQkAABuR");n(g,34880,"Hi8AABw=");n(g,34896,"eQgAAB0QCQEAAAAAAAAAAFwvAAAeIQ==");n(g,34928,"WQkAABuR");n(g,34944,"RS8AAB+U");n(g,34960,"lwgAACAQCQEAAAAAAAAAAPAEAAAEFAAAAAAQAAAAAAB8LAAAFnE=");n(g,35008,"FDkAAAQUAAAABAAAAAAAAD0QAAAEFAAAACAAAAAAAAApDwAABBQAAAAQAAAAAAAAaigAAAIUAAABAAAAAAAAAFwwAAAhEA==");n(g,35088,"BRQAAAQUAABAAAAAAAAAAGcEAAAiAg==");n(g,35120,"UAsAACMQ");n(g,35136,"VA0AACSV");n(g,35152,"YCUAACVhCAYAAAAAAAAAAIwIAAAmIQ8GAAAAAAAAAAA/JQAAJWEIBwEAAAAAAAAAgDIAACcU");n(g,35216,"KwQAACgE");n(g,35232,"9BUAACkQ");n(g,35248,"WkQAAAQUAACAAAAAAAAAAEEoAAACFAAABgAAAAAAAABvCQAAKg==");n(g,35296,"ggkAACsBMgMAAAAAAAAAAEpEAAAEFAAAAQAACAAAAABiOAAAKyQAABA1AABQKgAA0yQAAI4wAABSMAAAqS0AAEE4AADWMwAA9jIAAPkqAADnLwAA9SsAAPIpAABxRAAA1jMAAPYyAAD0KgAAeSAAAHYMAAAtJQAAQTgAANYzAACvQQAAWSsAADUFAADWMwAAgCkAAPYyAAAQQwAABi4AAIATAACNKwAA+QUAAFotAADLCwAAexMAACskAADWMwAA4C8AAK0pAADjKwAAEDUAAN43AAAWCgAAGzgAACskAADWMwAANjQAACYEAAASLgAAdzkAAHcyAABNDQAAMC8AAOgHAAADAgE=");n(g,35572,"OwA7ADsAOwAAADsAOwA7AAAAOwA7ADsAOwAAAAAAAAA7AAAAAAA7");n(g,35620,"OwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7AAAAAAAAADsAOw==");n(g,35688,"OwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7");n(g,35952,"//3//QD////+/v79+/r/AP3/APv+AP3+//4A/Pr+AAD+/fz8/P39+/78/P/+/fwA/wD+/v39/f7+///+/f4A/v4A//75+/v2AAD9AP7///z+APf8//38//3//v/39vz7//8AAPv9+/4AAP7+APv6+Pr6AP7//f/9+/3//v38/vwAAP3+AP37/f//AP7+AAD9AP4A/vz8+gD+AP7+/Pf7+f37+fgA/vT3+/j+/v8A/f3//f///fv//////fr7/Pr7//v9/f39/f39/f79+/79/fz6+/7+/v3//vv//vv9+/v8+/v8/gD/AAD9/wD99P8AAP37/QD+/P79/gD9+/r7+v7++/X//gD///0A/v3+/f3+9/j6/fz6/////Pr9AP7//f/9+vn6//j//PgA//3//v3//v36//3//fv7+vz7//4A/fr///7//v7+AP7+/v/+/v///P77//7///79AP/+/wD+//z+//////////4A/vz+/v3/AP/////+//8A////////////AP3/AP8AAP///f4A/P4=");n(g,36368,"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");n(g,42096,"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");n(g,46304,"bwZvBm8GwwXYBEcF2ATYBNgEwwXDBcMF2ARlBWUF+AX5BNgE2ATYBNgE2ATYBNgE2ATYBNgEwgXYBNgE2ATYBBsGGwbYBNgE2ATYBNgE2ATYBNgEbgXYBHUF2ATYBNgE2ATYBMQFxQXYBNgE2AT3BfkF1AV8BXsFegV5BeYFWQVzBWwFcAW+Bb8FvQXBBcUFxAXYBG8FngWuBZ0F2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ASmBa0FrAWrBbQFqgWnBaAFnwWhBaIF2ATYBPAE2ATYBO0EIwXYBNgE2ATYBNgECwYKBtgEowXYBPkEmAWXBbEFpAWwBa8F/wU/Bj4G1QXYBNgE2ATYBNgE2AQbBtgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ARbBRsGGwbYBPkEGwYbBlwFXAX1BPUEXwXYBAYGPgU+BT4FPgVHBT4F2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE/AX6BdgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBEMF2ATYBNgE2ATYBNgE2ATYBNgE2ATYBDgG2AThBTEFQwVDBUMFQwVFBTIFMAU9BfoE3wRnBn8FdAVEBXQFZAZyBX8FfwVyBX8FRAVkBgoFTwYFBWUFZQVlBVsFWwVbBVsFXwVfBcAFRAU9BdgEZwZnBk0FTQVmBmYGTQXVBVcGiAUmBSwFLAUsBSwFTQXqBHIFVwZXBnIFiAUmBXIFJgVyBU0F6gTlBWEGTQXqBMsFTQXqBE0F6gTLBSQFJAUkBRkF2ATYBMsFJAUKBSQFGQUkBSQFLQbYBM8FzwXLBU0FJQYlBmgFaAVtBV8FxgVNBdgEbQVrBWkFcgUcBTsGOwY3BjcGNwZsBmwGBgZIBvkE+QT5BPkESAYMBQwF+gT6BPkESAbYBNgE2ATYBNgE2ARDBtgEAQbWBVEF2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBAwG2ATYBNgE2ATYBNgE2ATYBNgE2ASNBdgE2wQDBtgE2ATYBNgE2ATYBNgE2AR2BXcFUgXYBNgE2ATYBNgE2ATYBIUF2ATYBNgEgAXYBNgE2ATYBNgE2ATYBNgEYwbYBNgE2ATYBNgE2ATkBeMF2ATYBE8F2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2AQIBdgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ARqBdgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2AQqBmAF2ATYBNgE2ARaBtgE2ATYBNgE2ATYBNgE2ATYBNgE2ATYBNgE2ARTBjQFjwXYBI4FkgXuBNgE5ATYBNgECQ==");n(g,47488,"vQC9ALwAvgC/AL8AvwC/AL4AvgC+AL4AvgDDAMUAxwDHAMYAxgDEAMQAywDLAM0AzQDOANAA0ADQANEA1QDWANcA1wDXANcA1wDXANcA1wDXANcA1wDXANcA4ADgANwA3ADeAN4A4QDhAOEA4QDiAOIA4gDiAOIA3wDfAOMA4wDjAMoA5QDmAOYA5gDmAOYA6QDaANoA6gDqAOsA6wC+AO0A7QC+AL4AvgDMAMwAzADvAPIA8gDyAPAA8AD8APwA8wDzAPMA/gD0APQA9AD/AP8A9QD1AAEBAQEAAQABAAEAAQAByADIAO4A7gAGAQYBBgEGAQIBAgECAQIBAwEDAQMBCAEEAQQB+QD5AOcA5wDbANsA2wAJAQkBCQH3APcA+AD4APoA+gD6APoAvgD2APYACwELAQsBCwG+AAwBDAEMAQwBvgC+AA8BDwEPAQ8BDwEPARABDQENAQ4BDgEHAQcB2QDZANkA2QDZANgA2ADYANkA2QDZANkA2QDZANkA2ADZANkA2QDZANkA2QDZANkA2QASAdkA2QDZANkA2QDZANkA2QDZANkA2QDZABMBEwHZABQBFAHZANkA2QDZANkA2QAXARcBGAEYARYBFgEFAf0A/QAVARUBvgAZARkB3QDdAOgA6AAaARoBvgC+AL4AGwEbAb4AvgC+AL4AvgDTANQAvgAdAR8BHwEfASABIAEgASIBIgEeAR4BJAElASUBIwEjASMBIwHZANkA7ADsAOwAvgC+AL4AJwEnAb4AvgC+AL4AvgC+AL4AKAG+AL4AvgAqASwBLQEtAS4BCgEKATEBMQExATAB8QDxADIBMgEzATQBNAE0ATQBNAE0ATUBNQE1ATkBOwE7ATwBPAE6AToBPQE9AT4BPgE+AfsAEQERAREBOAE4ATcBuQC6ALoAuwC7ALsAwADAAMAAwgDCAL4AywDJAMkAwQDBAMEA0ADRANIA0gDPAM8A1wDXANcAygDkAOQA5QDpAOsA7wDwAP4A/wAIARAB2QASAQUBHAEcARwBHAEcAdMAIQEhASQBJQEmASYBKQEpASsBKwEsAS8BLwEvAQoBAAAAAAAASwAAACMACgBeAAAANAAJAIcAAABeAAEAVgAAAFAAAAAIAAsAJgACAEcAAAB6AAAAQgBDAEQARQ==");n(g,48368,"yEMAALwHAAAUQwAAcyMAAOsrAAA7SwAAbUwAACpMAAACBAgGBgAAAAAAcm93X251bWJlcgBkZW5zZV9yYW5rAHJhbmsAcGVyY2VudF9yYW5rAGN1bWVfZGlzdABudGlsZQBsZWFkAGxhZwAAAAAAABq9AABMAAAAWgAAAFUAAAAlvQAAWQAAAFoAAABVAAAAML0AAFkAAABaAAAAVQAAADW9AABcAAAAVQAAAFoAAABCvQAAXAAAAFYAAABaAAAATL0AAEwAAABVAAAAWgAAAFK9AABMAAAAWgAAAFoAAABXvQAATAAAAFoAAABVAAAAczYAAAg=");n(g,48624,"rXIAAIhGAAB0SwAApEYAABFMAAADBAMHBARDQURERUIKCgkJCAgHBwcGBgYFBQUEBAQEAwMDAwMDAgICAgICAm50aF92YWx1ZQBmaXJzdF92YWx1ZQA5NwAAAAAAAAAAqS0AAEAAAAC0QwAAQgAAAJU1AABBAAAAPiQAAEMAAAAXFRQWAAAjHxcUFhUqKCcpJiUjHw==");n(g,48784,"EyMAAEgjAACuIgAApSMAANkj");n(g,48816,"OQAAADkAAAA2AAAAOQAAADk=");n(g,48848,"bmF0dXJhbGVmdG91dGVyaWdodGZ1bGxpbm5lcmNyb3Nz");n(g,48897,"BwQGBCgKBSAOBTATBDgXBQEcBQMAAABMNwAAAwAAAK0GAAAD");n(g,48944,"MwACAH8AAABhAAIAgAAAAHo=");n(g,48976,"AgAAAGMAAQMxAQgARwACAGsBAgExAQgARwABALgAAABUAQE=");n(g,49024,"AgABAGMAAQQPAQAARgACAGQABwCsQwAAjAcAAPUrAAAABAEBAgM=");n(g,49072,"VgEAADsBBAB1AAMAVAMBAEYAAAB1AAMACAADAAAAAABhVwAAAQAAAGZXAAABAAAAfTUAAAIAAADRNgAAAwAAAHU1AAACAAAAyTYAAAMAAADlVwAAAAAAAN9X");n(g,49176,"AgABAGQAAAACAAAAYwABAFQBAQAAAAAAb25vZmZhbHNleWVzdHJ1ZXh0cmFmdWxsAAABAgQJDA8UAgIDBQMEBQQBAAAAAQEDAg==");n(g,49268,"B1cAAG01AADBNgAAJV8AAAMAAAAB");n(g,49300,"zQ==");n(g,49316,"3C0AAAAAAAB4AAAAmDoAAAAAAgB0MAAAAAAE");n(g,49360,"KiUAAAEAAABEBgAAAgAAAKdBAAAGAAAAogQAAIA=");n(g,49400,"AQAAAAE=");n(g,49416,"zg==");n(g,49432,"6i0AAAAAAABtWQAA0AwAABZYAAAAAAAAb1gAAAAAAAAEAAAAAQ==");n(g,49480,"zw==");n(g,49496,"JwsAAAAAAAACAAAAAQ==");n(g,49520,"0A==");n(g,49536,"Xy0AAAAAAAABAAAAAQ==");n(g,49560,"0Q==");n(g,49576,"VAwAAAAAAACD/90CFQPxACUBhf8//0H/Sf9F/6YA7gCFADH/Of/1/lD/+v/MAOkBQAJR/1YCrgJnAtUCXAMKAw0DWQNoAncDVwDwAED/mAFyAhwDSwNWA+sD8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f5QAFMAOQF2A3gD5AMKBCMEOQRMBF0EgASDBIsEjQSPBJEElAScBJ4EoASuBLAEvQS/BMkEywTkBOYE8AQTBRcFHAUgBS0FMAU5BTwFPwVbBV0FaAVqBYMFjAWQBZIFsgW+BcEFwwXHBfH+8f7x/vH+8f7x/vH+8f7x/vH+8f6KAMsBjAFi/9YBLgEs/wkCyQA9/6T/LwJ2AngCdgLx/ngChQM/AJcB8f7x/vH+8f6hAKEAoQD7AE8BTwPAA9QDGQJMAmoCdAKwArACWv9f/6ICFgMaAx8DUwNUA4b/qAKI/+MDDgSfARsEfQMeA8IDkAE+BAsDmwOcAwcBEQTTA94DOwRJBAcEqgRqAeIDcwTtAw0EsgS1BKsEugQ+/zgAuQB5/+gACgIwAlkCaQKdAqsCxwJYA4wDrQMYBE0EewTpBO4E8QSIAQwFNQU7BT4FQgVGBU8FXgWKBY0FnAWdBVEC8wICA+UDpQWzBbkE3AXgBewFbATbBO4F7wWgBfAFMALyBfMF9AX2BfcF+QVmBZ4FlwW8Bb0FwAXEBbkElwWXBc0F9QUDBpsFtwW/BdQFzwWjBdYFwgXMBdoFzgXeBa8F+gX7Bf0FBAYGBggG4QXiBeMF5AXxBfgF1QUBBvwFJwbQBdgFMAY6BuUF5gVABgIG/gUFBiYGKQYvBjEGMgZMBloGLQYUBhYGMwYXBkEGNAZDBjgGXwZoBg4GEQZrBm0GWQZxBnQGcgZ1BmAGZAZlBmoGYgZnBmkGbgZ4BncGegZ7Bn0GfwYYBhwGPAZFBoAGhgYdBiMGWwZmBnkGgQZXBqYGXgaCBoMGhwaJBqcGtga3BsEGwgbDBlUGVgZcBrgGsQa0BroGuwbFBrUGvAa/BsAGvQbMBgAAAQAAAJRyAAAAAAAAcyMAAOsrAAC8BwAAyEMAAA0r");n(g,50448,"MDEyMzQ1Njc4OUFCQ0RFRmxhc3RfdmFsdWUAAAwADgAYAB8AOwAPJwAAAAAAAAAABnNlY29uZAAkINNXAACAPwZtaW51dGUA2TPhVAAAcEIEaG91cgAAALA58FEAAGFFA2RheQAAAABa/KNKAMCoRwVtb250aAAAgGgsSAA0HkoEeWVhcgAAAADkZUbAmfBL");n(g,50601,"AQEAAAE=");n(g,50624,"AQ==");n(g,50856,"YnRuAGZy");n(g,50880,"DSsAANQvAADpMQAAcyMAAOsrAAC8BwAATwUAAJ8MAABCAQAAQwEAAEQBAABFAQAARgEAAEcBAABIAQAAAAAAAAEAAAAAAAAASQEAAEoBAABLAQAATAEAAE0BAABOAQAATwEAAFABAABRAQAAUgEAAFMB");n(g,51008,"TSEAAFohAAAAAAAACzwAAE85AADKOwAA3TsAAHUEAADvMQAAazkAAGohAAArOwAAoycAABIrAAAeNAAA4yoAAAAAAAD5PAAAdi4AAG07AACGLQAAyzAAAH87AAD2OwAAAAAAALU1AABpMgAAzzUAAOQ1AABUAQAAVQEAAFYBAAADAAAAVwEAAFgBAABZAQAAWgEAAFsBAABcAQAAXQEAAF4BAABfAQAAYAEAAGEBAABiAQAAYwEAAGQBAABlAQAAZgEAAGcBAABoAQAAaQEAAGoBAABrAQAAbAEAAG0BAAAAAAAAbgEAAG8BAABwAQAAcQEAAHIB");n(g,51264,"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");n(g,54208,"t1EAAKZiAAC4aAAA7WgAAAppAACTagAA1GgAACJPAACgWgAAcGMAAKtjAADqYgAA5kwAAFZNAABpUQAA0E8AAD5RAAASUAAAvF4AAONRAABAYwAAOk8AAGlPAAAaYwAArXIAAK1yAACZTwAAJWkAACFaAACFZwAAB1EAAONOAACcUAAATVAAAMZLAABHTgAAYmkAAN1NAACaTgAAylkAAAAAAAB9AQAAfgEAAH8BAACAAQAAgQE=");n(g,54400,"ggEAAIMBAACEAQAAhQEAAIYB");n(g,54432,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAAAAAQEBAAEBAQABAQEBAQABAQEBAQABAQECAQAAAAAAAEslAAAJAAAAgwUAAAYAAABXDwAACAAAAFUPAAAKAAAAlSMAAAUAAAAOCgAABwAAADQ4AAAKAAAAhDgAAAo=");n(g,54644,"AQ==");n(g,54656,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAABvSQAAAgAEANNMAAADAQMAoEYAAAMBAgCUSQAABAABAEwMAACHAQAAIQ8AAIgBAABcLwAAiQEAAEslAACKAQAADgoAABYvAACLIQAAlQ4AANgMAAAAAAAAiwEAAIsBAACMAQAAjQEAAI0BAACOAQAAjwEAAJABAACRAQAAkgEAAJMBAACUAQ==");n(g,54928,"+C0AALAQAQAdNgAAEBEBAAAAAgADAAUABgAHAAgACQCXWQAAzl0AAGFLAADGXAAAK1gAAANaAAA2XAAAmlcAAGpcAAA0SAAAgVcAAPRYAADfXAAAClkAAA1cAABrSAAArFgAAFNIAABGTAAAWFgAAIlcAAC2XAAAmVwAADZZAAD/XAAAbFcAAF5dAAAqXQAAJlwAALhYAADLVwAAdF0AABNdAACxVwAASF0AAPhbAADCRgAAFksAAINOAACrWQAASlwAAAdMAACZRgAABEcAAPtGAAC9SwAAtkYAAMZMAAC1EQAAAQABAKQBAACIKQAAAQABAKUBAAD5KQAAAQABAKYBAADVWAAAAgABAKcBAADaWAAAAgABAKcBAABpLQAAAQABAKgBAABvLQAAAQABAKkBAAB1LQAAAQABAKoBAACVNgAAAgABAKsBAADCFQAAAQABAKwBAAAhEwAAAQABAK0BAAC2EQAAAQABAK4BAACJKQAAAQABAK8BAAD6KQAAAQABALABAAArCQAAAQABALEBAABqLQAAAQABALIBAABwLQAAAQABALMBAAB2LQAAAQABALQBAAAoLQAAAQABALUBAABBJAAAAQABALYBAAASLgAAAQABALcBAACDXAAAAQABALgBAACzIQAAAgABALkBAADIKQAAAQABALoBAADwCAAAAQABALsBAAC8MgAAAQABALwBAAByKwAAAQABAL0BAAB5IQAAAQABAL4BAADyLAAAAAABAb8BAADBMAAAAgABAMABAACvBQAAAgABAMEBAACvBQAAAwABAMEBAACFIAAAAgABAMIBAAB8IAAAAgABAMMBAADVMQAAAQABAMQBAABvIgAAAQABAMUBAAB+KwAAAgABAMYBAAAQJAAAAgABAMcBAAAsQwAAAgABAMgBAAAqIgAAAgABAMkBAAAcBwAAAQAAAMoBAADLAQAAoDYAAAEAAADKAQAAzAEAAEw2AAABAAAAzQEAAM4BAAD+KQAAAQAAAM0BAADPAQAA4jMAAAEAAADNAQAA0AEAAPEzAAABAAAAzQEAANEB");n(g,55794,"AQIDAAECAAACAgQFBQABAgYCAwABAAIAAgAAAAAAAAABAgMAAQIAAAICBAUFAAECBgIDAAEAAgAC");n(g,55984,"BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAgICAgICAgICAgICAgICAgMDAwMDAwMDBAQEBAQEBAQAAAAAgDAAAIAgDgCAIMgDAAAAAID///8A+P//AAD//wAAAAAAAPA/AAAAAAAA+D8AAAAAAAAAAAbQz0Pr/Uw+");n(g,56187,"QAO44j/+gitlRxVnQAAAAAAAADhDAAD6/kIudr86O568mvcMvb39/////98/PFRVVVVVxT+RKxfPVVWlPxfQpGcREYE/AAAAAAAAyELvOfr+Qi7mPyTEgv+9v84/tfQM1whrrD/MUEbSq7KDP4Q6Tpvg11U/");n(g,56318,"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");n(g,58463,"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");n(g,61267,"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");n(g,63384,"IQQAAAAAAAAAAC8C");n(g,63416,"NQRHBFYE");n(g,63438,"oAQ=");n(g,63458,"RgVgBW4FYQYAAM8BAAAAAAAAAADJBukG+QYAAAAAAv8ABGQAIAAABP//BgABAAEAAQD//wH/Af//////Af8B/wH/Af8B/wH/Af8B//////8K/yAA//8D/wH/BP8eAAABBf//////YwAACGMA6AMCAAAA//////8AAAAB/wH//////////////w==");n(g,63609,"BA==");n(g,63622,"Af8B//////8AASAABACAAAAI//8B/wH/////////Af8G/wf/CP8J//////+8ArwCAQD//wEAAQD//wAA//////////8=");n(g,63706,"FA==");n(g,63738,"//8BAAr///////////8B/wH/AAAAAAAAAf8B/wH/");n(g,63786,"Af8AAAAAAAAB/wH/AQAAAAEAAAAB//////8AAAAAAf///wAAAAD/////////////KAAK//////8BAAr/////AP//////////");n(g,63958,"Af8B////AQD//////////////////wr//////w==");n(g,64e3,"AQAAAAEAAAEAAQAA/v//fwAAAACwBAAAKAAAAAAAAQ==");n(g,64192,"FA==");n(g,64204,"+g==");n(g,64251,"QA==");n(g,64268,"/v//f////38=");n(g,64300,"BwAAAAMAAAA0AAAAAAIAAAAAAABnBQAA1HQAAHMAAAB0AAAAdQAAAHY=");n(g,64360,"dwAAAHgAAAB5AAAAegAAAHsAAAB8AAAAfQAAAH4AAAADAAAANAAAAAACAAAAAAAAFzMAANh0AABzAAAAdAAAAHUAAAB2");n(g,64448,"dwAAAHgAAAB5AAAAegAAAHsAAAB8AAAAfQAAAH4AAAADAAAANAAAAAACAAAAAAAAADQAANx0AABzAAAAdAAAAHUAAAB2");n(g,64536,"dwAAAHgAAAB5AAAAegAAAHsAAAB8AAAAfQAAAH4AAAADAAAANAAAAAACAAAAAAAAgysAANR0AABzAAAAdAAAAHUAAAB2");n(g,64624,"dwAAAHgAAAB5AAAAegAAAHsAAAB8AAAAfQAAAH4AAAAAAABA");n(g,64672,"0ikAAJQAAAAAAAAA3TEAAJUAAAAAAAAAKxAAAJYAAAAAAAAA+jYAAJcAAAAAAAAA2AwAAJgAAAAAAAAAwgwAAJkAAAAAAAAAtzAAAJoAAAAAAAAA0ioAAJsAAAAAAAAAVT0AAJwAAAAAAAAAVD0=");n(g,64792,"UFg=");n(g,64804,"QjAAAJ0AAAAAAAAAQTA=");n(g,64828,"R1g=");n(g,64840,"IDcAAJ4AAAAAAAAArTA=");n(g,64864,"+ysAAJ8AAAAAAAAAWQQAAKAAAAAAAAAAhSEAAKEAAAAAAAAAfyEAAKIAAAAAAAAAdiUAAKMAAAAAAAAAADgAAKQAAAAAAAAApSQAAKUAAAAAAAAAniQAAKYAAAAAAAAAqiQ=");n(g,64972,"Ci8AAKcAAAAAAAAAAiwAAKgAAAAAAAAAvAwAAKkAAAAAAAAA2Co=");n(g,65032,"YCQAAFckAABkJAAA+10=");n(g,65056,"TkUAAJFOAAClRgAAhkkAABJMAACJRg==");n(g,65088,"AgAAAAFIxAABAAAAAAAAANI=");n(g,65120,"TAYAAAAAAAACAAAAAUjEAAMAAAAAAAAA0g==");n(g,65160,"wzIAAAAAAAACAAAAAUjEAAIAAAAAAAAA0g==");n(g,65200,"miAAAAAAAAABAAAAAUjEAAQAAAAAAAAA0g==");n(g,65240,"EAQAAAAAAAABAAAAASCA");n(g,65264,"0w==");n(g,65280,"/DkAAAAAAAABAAAAASCA");n(g,65304,"1A==");n(g,65320,"XQwAAAAAAAABAAAAAQzAAGMAAAAAAAAA0g==");n(g,65360,"+wQAAAAAAAACAAAAAQzAAGMAAAAAAAAA0g==");n(g,65400,"FTcAAAAAAAABAAAAAQzAAGMAAAAAAAAA0g==");n(g,65440,"/QQAAAAAAAABAAAAAQiAAAEAAAAAAAAA1Q==");n(g,65480,"byoAAAAAAAACAAAAAQiAAAEAAAAAAAAA1Q==");n(g,65520,"byoAAAAAAAABAAAAAQiAAAIAAAAAAAAA1Q==");n(g,65560,"aSoAAAAAAAACAAAAAQiAAAIAAAAAAAAA1Q==");n(g,65600,"aSoAAAAAAAABAAAAAQiAAAMAAAAAAAAA1Q==");n(g,65640,"cCoAAAAAAAACAAAAAQiAAAMAAAAAAAAA1Q==");n(g,65680,"cCoAAAAAAAD/AAAAIQiA");n(g,65704,"1g==");n(g,65720,"qSk=");n(g,65732,"IQiA");n(g,65760,"qSkAAAAAAAABAAAAIRCACAAAAAAAAAAA1wAAANgAAADZAAAAAAAAAKkpAAAAAAAA/wAAACEIgAABAAAAAAAAANY=");n(g,65840,"CwY=");n(g,65852,"IQiAAAE=");n(g,65880,"CwYAAAAAAAABAAAAIRCACAEAAAAAAAAA1wAAANgAAADZAAAAAAAAAAsGAAAAAAAAAQAAAIEIgA==");n(g,65944,"2g==");n(g,65960,"tC4AAAAAAAABAAAAgQiA");n(g,65984,"2w==");n(g,66e3,"3jIAAAAAAAABAAAAQQiA");n(g,66024,"3A==");n(g,66040,"Uy0AAAAAAAACAAAAAQiA");n(g,66064,"3Q==");n(g,66080,"jSAAAAAAAAD/AAAAAQiA");n(g,66104,"3g==");n(g,66120,"rS4AAAAAAAD/AAAAAQiA");n(g,66144,"3g==");n(g,66160,"7gwAAAAAAAABAAAAAQiA");n(g,66184,"3w==");n(g,66200,"WDYAAAAAAAD/AAAAAQiA");n(g,66224,"4A==");n(g,66240,"FSQAAAAAAAABAAAAAQiA");n(g,66264,"4Q==");n(g,66280,"/BUAAAAAAAABAAAAAQiA");n(g,66304,"4g==");n(g,66320,"JzcAAAAAAAACAAAAAQiA");n(g,66344,"4g==");n(g,66360,"JzcAAAAAAAABAAAAAQiA");n(g,66384,"4w==");n(g,66400,"aSIAAAAAAAABAAAAAQiA");n(g,66424,"5A==");n(g,66440,"uSEAAAAAAAABAAAAAQiA");n(g,66464,"5Q==");n(g,66480,"qwUAAAAAAAACAAAAAQjA");n(g,66504,"0g==");n(g,66520,"ASs=");n(g,66532,"AQCA");n(g,66544,"5g==");n(g,66560,"WyoAAAAAAAABAAAAAQCA");n(g,66584,"5w==");n(g,66600,"wkMAAAAAAAACAAAAIQiA");n(g,66624,"6A==");n(g,66640,"2y4=");n(g,66652,"ASCA");n(g,66664,"0g==");n(g,66680,"Tig=");n(g,66692,"ASCA");n(g,66704,"6Q==");n(g,66720,"VDgAAAAAAAACAAAAAQiA");n(g,66744,"6g==");n(g,66760,"Cy4AAAAAAAABAAAAAQiA");n(g,66784,"6w==");n(g,66800,"OzA=");n(g,66812,"AQCA");n(g,66824,"7A==");n(g,66840,"fDc=");n(g,66852,"AQCA");n(g,66864,"7Q==");n(g,66880,"uhU=");n(g,66892,"AQCA");n(g,66904,"7g==");n(g,66920,"tBUAAAAAAAADAAAAAQiA");n(g,66944,"7w==");n(g,66960,"uTYAAAAAAAABAAAAAQiA");n(g,66984,"8A==");n(g,67e3,"uUMAAAAAAAACAAAAAQiA");n(g,67024,"8Q==");n(g,67040,"kyAAAAAAAAADAAAAAQiA");n(g,67064,"8Q==");n(g,67080,"kyAAAAAAAAACAAAAAQiA");n(g,67104,"8Q==");n(g,67120,"Sy4AAAAAAAADAAAAAQiA");n(g,67144,"8Q==");n(g,67160,"Sy4AAAAAAAABAAAAAQCA");n(g,67184,"8gAAAPMAAADzAAAA9AAAAEAqAAAAAAAAAQAAAAEAgA==");n(g,67224,"8gAAAPUAAAD1AAAA9AAAAJ0rAAAAAAAAAQAAAAEAgA==");n(g,67264,"8gAAAPYAAAD2AAAA9AAAAAIu");n(g,67292,"AQGACAAAAAAAAAAA9wAAAPgAAAD4AAAA+QAAAF4JAAAAAAAAAQAAAAEAgAgAAAAAAAAAAPcAAAD4AAAA+AAAAPkAAABeCQAAAAAAAAEAAAABAIA=");n(g,67384,"+gAAAPsAAAD8AAAA/QAAAPUMAAAAAAAAAgAAAAEAgA==");n(g,67424,"+gAAAPsAAAD8AAAA/QAAAPUMAAAAAAAAAgAAAA0IgAA4dQAAAAAAAD4=");n(g,67480,"tEMAAAAAAAACAAAABQiAADx1AAAAAAAAPg==");n(g,67520,"lTUAAAAAAAADAAAABQiAADx1AAAAAAAAPg==");n(g,67560,"lTUAAAAAAAABAAAAAQiA");n(g,67600,"czY=");n(g,67612,"AQiA");n(g,67640,"czYAAAAAAAABAAAAAQiA");n(g,67664,"/g==");n(g,67680,"yCkAAAAAAAD/AAAAAQjA");n(g,67704,"0g==");n(g,67720,"czYAAAAAAAADAAAAAQjAAAUAAAAAAAAA0g==");n(g,67760,"4i4=");n(g,67776,"CQAAAAEIhA==");n(g,67792,"/w==");n(g,67808,"jCgAAAAAAAAHAAAAAQiE");n(g,67833,"AQ==");n(g,67848,"YjQAAAAAAAAHAAAAAQiE");n(g,67872,"AQE=");n(g,67888,"tggAAAAAAAADAAAAAQiE");n(g,67912,"AgE=");n(g,67928,"eSgAAAAAAAACAAAAAQiE");n(g,67952,"AwE=");n(g,67968,"bAU=");n(g,67988,"AQCB");n(g,68e3,"BAEAAAUBAAAFAQAAVgAAABq9");n(g,68028,"AQCB");n(g,68040,"BgEAAAcBAAAHAQAAVgAAACW9");n(g,68068,"AQCB");n(g,68080,"CAEAAAkBAAAJAQAAVgAAADC9");n(g,68108,"AQCB");n(g,68120,"CgEAAAsBAAALAQAADAEAADW9");n(g,68148,"AQCB");n(g,68160,"DQEAAA4BAAAOAQAADwEAAEK9AAAAAAAAAQAAAAEAgQ==");n(g,68200,"EAEAABEBAAARAQAAEgEAAEy9AAAAAAAAAQAAAAEAgQ==");n(g,68240,"EwEAABQBAAAVAQAAFgEAACDFAAAAAAAAAgAAAAEAgQ==");n(g,68280,"FwEAABgBAAAZAQAAVgAAADC+AAAAAAAAAQAAAAEAgQ==");n(g,68320,"GgEAABsBAAAZAQAAVgAAADq+AAAAAAAAAQAAAAEAgQ==");n(g,68360,"VgAAABkBAAAZAQAAVgAAAFK9AAAAAAAAAgAAAAEAgQ==");n(g,68400,"VgAAABkBAAAZAQAAVgAAAFK9AAAAAAAAAwAAAAEAgQ==");n(g,68440,"VgAAABkBAAAZAQAAVgAAAFK9AAAAAAAAAQAAAAEAgQ==");n(g,68480,"VgAAABkBAAAZAQAAVgAAAFe9AAAAAAAAAgAAAAEAgQ==");n(g,68520,"VgAAABkBAAAZAQAAVgAAAFe9AAAAAAAAAwAAAAEAgQ==");n(g,68560,"VgAAABkBAAAZAQAAVgAAAFe9");n(g,68592,"/wAAAAEogAAA+gAAAAAAABwB");n(g,68624,"VQUAAAAAAAD/AAAAASiAAAD6AAAAAAAAHQE=");n(g,68664,"0i0AAAAAAAD/AAAAASiAAAD6AAAAAAAAHgE=");n(g,68704,"qDAAAAAAAAD/AAAAASiAAAD6AAAAAAAAHwE=");n(g,68744,"ZTMAAAAAAAD/AAAAASiAAAD6AAAAAAAAIAE=");n(g,68784,"VDMAAAAAAAD/AAAAASiAAAD6AAAAAAAAIQE=");n(g,68824,"SzM=");n(g,68836,"ASCA");n(g,68848,"IgE=");n(g,68864,"XTM=");n(g,68876,"ASCA");n(g,68888,"IwE=");n(g,68904,"biQ=");n(g,68916,"ASCA");n(g,68928,"JAE=");n(g,68944,"oDA=");n(g,68960,"AQAAAAEIoA==");n(g,68976,"JQE=");n(g,68992,"kCUAAAAAAAD/AAAAAQig");n(g,69016,"JgE=");n(g,69032,"SgUAAAAAAAABAAAAAQig");n(g,69056,"JwE=");n(g,69072,"My0AAAAAAAACAAAAAQig");n(g,69096,"JwE=");n(g,69112,"My0AAAAAAAD/AAAAAQig");n(g,69136,"KAE=");n(g,69152,"pgwAAAAAAAACAAAAAQigAAEAAAAAAAAAKAE=");n(g,69192,"LVIAAAAAAAACAAAAAQigAAIAAAAAAAAAKAE=");n(g,69232,"KVIAAAAAAAD/AAAAAQig");n(g,69256,"KQE=");n(g,69273,"CQAAAAAAAP8AAAABCKA=");n(g,69296,"KgE=");n(g,69312,"mgwAAAAAAAACAAAAAQig");n(g,69336,"KwE=");n(g,69352,"ey0AAAAAAAABAAAAAQig");n(g,69376,"LAE=");n(g,69392,"NjAAAAAAAAD/AAAAAQig");n(g,69416,"JQE=");n(g,69432,"ZS8AAAAAAAD/AAAAAQig");n(g,69456,"LQE=");n(g,69472,"tDYAAAAAAAD/AAAAAQigAAQAAAAAAAAAKQE=");n(g,69512,"5wsAAAAAAAABAAAAAQig");n(g,69536,"LgE=");n(g,69552,"8TIAAAAAAAACAAAAAQig");n(g,69576,"LgE=");n(g,69592,"8TIAAAAAAAABAAAAAQig");n(g,69616,"LwE=");n(g,69632,"EDgAAAAAAAABAAAAAQiw");n(g,69656,"MAEAADEBAAAyAQAAMwEAADkFAAAAAAAAAgAAAAEIsA==");n(g,69696,"NAEAADUBAAA2AQAAMwEAAIgMAAAAAAAAAgAAAAAAAAAABAAAAAAAAN1DAAAAAAAANwEAAAAAAAA4AQAAOQEAADoBAAA7AQAAPAEAAD0BAAA+AQAAPwEAAAAAAABAAQAAQQE=");n(g,69816,"lQEAAJYBAACXAQAAAAAAAJgBAACZAQAAmgEAAJsBAACcAQAAnQEAAJ4B");n(g,69912,"lQEAAJYBAACXAQAAAAAAAJ8BAACZAQAAmgEAAJsBAACcAQAAnQEAAJ4B");n(g,7e4,"gBZR")}var t=new ArrayBuffer(16);var u=new Int32Array(t);var v=new Float32Array(t);var w=new Float64Array(t);function x(y){return u[y]}function z(y,A){u[y]=A}function B(){return w[0]}function C(A){w[0]=A}function Sa(Ta){var D=Ta.a;var E=D.buffer;D.grow=Qa;var F=new Int8Array(E);var G=new Int16Array(E);var H=new Int32Array(E);var I=new Uint8Array(E);var J=new Uint16Array(E);var K=new Uint32Array(E);var L=new Float32Array(E);var M=new Float64Array(E);var N=Math.imul;var O=Math.fround;var P=Math.abs;var Q=Math.clz32;var R=Math.min;var S=Math.max;var T=Math.floor;var U=Math.ceil;var V=Math.trunc;var W=Math.sqrt;var X=Ta.abort;var Y=NaN;var Z=Infinity;var _=Ta.b;var $=Ta.c;var aa=Ta.d;var ba=Ta.e;var ca=Ta.f;var da=Ta.g;var ea=Ta.h;var fa=Ta.i;var ga=Ta.j;var ha=Ta.k;var ia=Ta.l;var ja=Ta.m;var ka=Ta.n;var la=Ta.o;var ma=Ta.p;var na=Ta.q;var oa=Ta.r;var pa=Ta.s;var qa=Ta.t;var ra=Ta.u;var sa=Ta.v;var ta=Ta.w;var ua=Ta.x;var va=Ta.y;var wa=Ta.z;var xa=Ta.A;var ya=Ta.B;var za=Ta.C;var Aa=Ta.D;var Ba=Ta.E;var Ca=Ta.F;var Da=Ta.G;var Ea=Ta.H;var Fa=Ta.I;var Ga=5314176;var Ha=0;var Ia=0;var Ja=0;
// EMSCRIPTEN_START_FUNCS
function Dx(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0;j=Ga-336|0;Ga=j;o=H[a+88>>2];t=H[a+104>>2];i=H[a>>2];u=I[i+84|0];iv(a);if(H[i+368>>2]){e=H[i+376>>2];L=e-(K[a+176>>2]%(e>>>0)|0)|0;E=0}else{L=-1;E=-1}a:{b:{c:{d:{if(H[a+36>>2]==7){g=t;break d}H[a+120>>2]=0;H[a+56>>2]=0;H[a+60>>2]=0;H[a+36>>2]=0;H[i+452>>2]=0;if(H[i+296>>2]){e=9;g=t;break c}V=i+488|0;Q=a+212|0;y=a+124|0;$=a+232|0;g=N(H[a+32>>2],20)+t|0;W=j+296|4;aa=j+300|0;ba=j+304|0;e=0;while(1){h=P;b=R+1|0;h=b?h:h+1|0;R=b;P=h;e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{c=I[g|0];switch(c|0){case 154:break Oa;case 155:break Pa;case 156:break Qa;case 45:break Ra;case 46:break Sa;case 47:break Ta;case 157:break Ua;case 158:break Va;case 48:break Wa;case 159:break Xa;case 49:break Ya;case 160:break Za;case 59:break _a;case 60:break $a;case 161:case 162:break bb;case 164:case 165:break cb;case 3:break db;case 4:break eb;case 5:break fb;case 8:break g;case 61:break gb;case 166:break hb;case 167:break ib;case 168:break jb;case 169:break kb;case 170:break lb;case 171:break mb;case 172:break nb;case 173:break ob;case 174:break pb;case 6:break qb;case 175:break rb;case 62:break sb;case 176:break tb;case 7:break ub;case 177:break vb;case 178:break wb;case 65:case 66:break xb;case 179:break yb;case 180:break zb;case 63:break Ab;case 64:case 181:break Bb;case 68:break Cb;case 94:break Db;case 18:break Eb;case 51:break Fb;case 92:break Gb;case 17:break Hb;case 50:break Ib;case 16:break Jb;case 15:break Kb;case 14:break Lb;case 114:break Mb;case 19:break Nb;case 91:break Ob;case 43:case 44:break Pb;case 13:break Qb;case 90:break Rb;case 58:break Sb;case 52:case 53:case 54:case 55:case 56:case 57:break Tb;case 88:break Ub;case 87:break Vb;case 12:break Wb;case 86:break Xb;case 102:case 103:case 104:case 105:break Yb;case 85:break Zb;case 106:case 107:case 108:case 109:case 110:break _b;case 111:break $b;case 84:break ac;case 83:break bc;case 82:break cc;case 81:break dc;case 80:break ec;case 79:break fc;case 78:break gc;case 77:break hc;case 76:break ic;case 74:case 75:break jc;case 73:break kc;case 117:break lc;case 153:break mc;case 72:break nc;case 71:break oc;case 70:break pc;case 69:break qc;case 11:break rc;case 10:break sc;case 67:break tc;case 9:break uc;case 163:break vc;case 95:break D;case 96:break E;case 97:break F;case 98:break G;case 0:break J;case 1:break K;case 2:break L;case 99:break M;case 100:break N;case 112:case 113:break P;case 101:break Q;case 115:break R;case 116:case 118:break S;case 119:break T;case 120:break U;case 121:break V;case 122:break W;case 20:case 21:case 22:case 23:break Y;case 124:break Z;case 125:break _;case 24:break $;case 26:case 27:case 28:break aa;case 25:break ba;case 29:break ea;case 30:break fa;case 126:break ga;case 127:break ha;case 128:break ia;case 129:break ja;case 130:break ka;case 131:break la;case 132:break ma;case 133:break na;case 134:break oa;case 135:break pa;case 136:break qa;case 31:case 137:break ra;case 32:break sa;case 35:break ta;case 33:case 34:break ua;case 36:break wa;case 37:break xa;case 38:break ya;case 138:break za;case 139:break Aa;case 140:break Ba;case 141:case 142:break Ca;case 143:break Da;case 39:case 40:case 41:case 42:break Ea;case 144:break Fa;case 145:break Ga;case 146:break Ha;case 147:break Ia;case 148:break Ja;case 149:break Ka;case 150:break La;case 151:break Ma;case 152:break Na;default:break e}}d=H[g+16>>2];break ab}b=N(H[g+4>>2],40)+o|0;c=(g-t|0)/20|0;H[b>>2]=c;H[b+4>>2]=c>>31;G[b+16>>1]=4;break g}b=N(H[g+4>>2],40)+o|0;if(!(I[b+16|0]&4)){break e}g=N(H[b>>2],20)+t|0;break e}c=H[g+12>>2];b=N(H[g+4>>2],40)+o|0;G[b+16>>1]=4;c=c-1|0;H[b>>2]=c;H[b+4>>2]=c>>31;if(!H[g+8>>2]){break e}break h}b=N(H[g+4>>2],40)+o|0;G[b+16>>1]=4;c=H[b>>2];d=(g-t|0)/20|0;H[b>>2]=d;H[b+4>>2]=d>>31;g=N(c,20)+t|0;break e}if(!(F[(N(H[g+12>>2],40)+o|0)+16|0]&1)){break e}}c=H[g+4>>2];b=H[Q>>2];if(!(c|!b)){H[a+212>>2]=H[b+4>>2];H[a+220>>2]=H[a+220>>2]-1;cp(i,H[a+40>>2],H[a+44>>2]);b=hv(b);t=H[a+104>>2];c=t;if(H[g+8>>2]==4){b=H[(N(b,20)+t|0)+8>>2]-1|0}g=N(b,20)+c|0;o=H[a+88>>2];break e}H[a+36>>2]=c;F[a+146|0]=H[g+8>>2];if(c){b=J[g+2>>1];wc:{if(b){H[j+80>>2]=H[(b<<2)+32892>>2];_c(a,15180,j+80|0);b=H[g+16>>2];if(!b){break wc}c=H[y>>2];H[j+68>>2]=b;H[j+64>>2]=c;ja=y,ka=tb(i,6927,j- -64|0),H[ja>>2]=ka;break wc}H[j+48>>2]=H[g+16>>2];_c(a,8310,j+48|0)}b=H[g+4>>2];c=H[a+196>>2];H[j+40>>2]=H[a+124>>2];H[j+36>>2]=c;H[j+32>>2]=(g-t|0)/20;Fc(b,8244,j+32|0)}x=5;if((rk(a)|0)==5){break j}x=H[a+36>>2]?1:101;break i}b=Ec(a,g);c=H[g+4>>2];H[b>>2]=c;H[b+4>>2]=c>>31;break e}b=Ec(a,g);c=H[g+16>>2];d=H[c+4>>2];H[b>>2]=H[c>>2];H[b+4>>2]=d;break e}b=Ec(a,g);G[b+16>>1]=8;M[b>>3]=M[H[g+16>>2]>>3];break e}b=Ec(a,g);c=H[g+16>>2];d=ib(c);H[g+4>>2]=d;if((u|0)!=1){if(oe(b,c,-1,-1,1,0)){break t}if(be(b,u)){break d}e=0;H[b+24>>2]=0;G[b+16>>1]=J[b+16>>1]|8192;if(I[g+1|0]==250){_a(i,H[g+16>>2])}F[g+1|0]=250;H[g+16>>2]=H[b+8>>2];d=H[b+12>>2];H[g+4>>2]=d}if(H[i+120>>2]<(d|0)){break t}F[g|0]=73}b=Ec(a,g);G[b+16>>1]=8706;H[b+8>>2]=H[g+16>>2];c=H[g+4>>2];F[b+18|0]=u;H[b+12>>2]=c;c=H[g+12>>2];if((c|0)<=0){break e}c=N(c,40)+o|0;if(H[c>>2]!=J[g+2>>1]|H[c+4>>2]){break e}G[b+16>>1]=8720;break e}c=Ec(a,g);b=H[g+8>>2];d=H[g+12>>2];f=H[g+4>>2];H[c+12>>2]=0;f=f?257:1;G[c+16>>1]=f;d=d-b|0;while(1){if((d|0)<=0){break e}b=c+40|0;dc(b);H[c+52>>2]=0;G[c+56>>1]=f;d=d-1|0;c=b;continue}}b=N(H[g+4>>2],40)+o|0;G[b+16>>1]=J[b+16>>1]&65472|1;break e}b=Ec(a,g);c=H[g+4>>2];d=H[g+16>>2];xc:{if(!d){_p(b,c);if(!Ce(b)){break xc}break d}oe(b,d,c,c>>31,0,0)}F[b+18|0]=u;break e}c=(H[a+100>>2]+N(H[g+4>>2],40)|0)-40|0;if(bq(c)){break t}b=N(H[g+8>>2],40)+o|0;if(I[b+17|0]&144){dc(b)}d=H[c+4>>2];H[b>>2]=H[c>>2];H[b+4>>2]=d;H[b+16>>2]=H[c+16>>2];d=H[c+12>>2];H[b+8>>2]=H[c+8>>2];H[b+12>>2]=d;G[b+16>>1]=J[b+16>>1]&36799|8256;break e}c=N(H[g+8>>2],40)+o|0;d=N(H[g+4>>2],40)+o|0;f=H[g+12>>2];while(1){sx(c,d);if(I[c+17|0]&64){if(Fg(c)){break d}}c=c+40|0;d=d+40|0;f=f-1|0;if(f){continue}break}break e}c=N(H[g+8>>2],40)+o|0;d=N(H[g+4>>2],40)+o|0;f=H[g+12>>2];while(1){$g(c,d,16384);k=J[c+16>>1];if(k&16384){if(Fg(c)){break d}k=J[c+16>>1]}if(!(!(k&2048)|!(I[g+2|0]&2))){G[c+16>>1]=k&63487}if(!f){break e}d=d+40|0;c=c+40|0;f=f-1|0;continue}}$g(N(H[g+8>>2],40)+o|0,N(H[g+4>>2],40)+o|0,16384);break e}b=N(H[g+4>>2],40)+o|0;Xc(N(H[g+8>>2],40)+o|0,H[b>>2],H[b+4>>2]);break e}e=0;b=Ej(a,0);if(!b){break e}e=b;break c}H[a+28>>2]=H[a+28>>2]+2|1;H[a+120>>2]=N(H[g+4>>2],40)+o;if(I[i+87|0]){break d}if(I[i+94|0]&4){Ka[H[i+212>>2]](4,H[i+216>>2],a,0)|0}H[a+32>>2]=((g-t|0)/20|0)+1;x=100;break i}b=H[g+12>>2];l=N(b,40)+o|0;m=H[g+4>>2];f=N(m,40)+o|0;d=J[f+16>>1];h=H[g+8>>2];c=N(h,40)+o|0;if((d|J[c+16>>1])&1){dc(l);break e}yc:{zc:{if(!(d&18)){if(!ei(f,u,0)){break zc}break d}if(!(d&1024)){break yc}if(Ce(f)){break d}}d=J[f+16>>1]&-3}q=J[c+16>>1];Ac:{Bc:{if(!(q&18)){if(!ei(c,u,0)){break Bc}break d}if(!(q&1024)){break Ac}if(Ce(c)){break d}}q=J[c+16>>1]&-3}n=N(h,40)+o|0;p=N(m,40)+o|0;k=H[n+12>>2]+H[p+12>>2]|0;if((k|0)>H[i+120>>2]){break t}w=l;l=(b|0)==(h|0);if(Di(w,k+2|0,l)){break d}b=N(b,40)+o|0;G[b+16>>1]=J[b+16>>1]&62016|2;if(!l){Ya(H[b+8>>2],H[(N(h,40)+o|0)+8>>2],H[n+12>>2]);G[c+16>>1]=q}Ya(H[b+8>>2]+H[n+12>>2]|0,H[(N(m,40)+o|0)+8>>2],H[p+12>>2]);G[f+16>>1]=d;c=u>>>0>1?k&-2:k;F[c+H[b+8>>2]|0]=0;F[(c+H[b+8>>2]|0)+1|0]=0;G[b+16>>1]=J[b+16>>1]|512;F[b+18|0]=u;H[b+12>>2]=c;break e}k=N(H[g+4>>2],40)+o|0;b=Zu(k);l=N(H[g+8>>2],40)+o|0;c=Zu(l);n=H[g+12>>2];m=N(n,40)+o|0;Cc:{Dc:{if(b&c&4){b=H[k>>2];d=H[k+4>>2];c=H[l+4>>2];f=H[l>>2];H[j+296>>2]=f;H[j+300>>2]=c;Ec:{Fc:{switch(I[g|0]-106|0){case 0:if(!Dl(j+296|0,b,d)){break Ec}break Dc;case 1:c=j+296|0;Gc:{Hc:{if(!b&(d|0)==-2147483648){f=H[c>>2];d=H[c+4>>2];b=1;if((d|0)>0|(d|0)>=0){break Hc}H[c>>2]=f;H[c+4>>2]=d^-2147483648;b=0;break Gc}b=Dl(c,0-b|0,0-(((b|0)!=0)+d|0)|0)}}if(!b){break Ec}break Dc;case 2:c=H[j+296>>2];h=H[j+300>>2];Ic:{Jc:{if(!!b&(d|0)>=0|(d|0)>0){f=1;p=VK(-1,2147483647,b,d)>>>0<c>>>0;q=Ja;if(p&(q|0)<=(h|0)|(h|0)>(q|0)){break Ic}q=VK(0,-2147483648,b,d);p=0-q|0;q=0-(Ja+((q|0)!=0)|0)|0;if((q|0)<=(h|0)&c>>>0>=p>>>0|(h|0)>(q|0)){break Jc}break Ic}if((d|0)>0|(d|0)>=0){break Jc}if(!!c&(h|0)>=0|(h|0)>0){f=1;q=VK(0,-2147483648,c,h);p=0-q|0;q=0-(Ja+((q|0)!=0)|0)|0;if((d|0)==(q|0)&b>>>0>=p>>>0|d>>>0>q>>>0){break Jc}break Ic}if((h|0)>0|(h|0)>=0){break Jc}f=1;if(!b&(d|0)==-2147483648|!c&(h|0)==-2147483648){break Ic}p=VK(-1,2147483647,0-b|0,0-(((b|0)!=0)+d|0)|0);r=0-(((c|0)!=0)+h|0)|0;s=Ja;if((r|0)==(s|0)&p>>>0<0-c>>>0|r>>>0>s>>>0){break Ic}}ja=j,ka=SK(b,d,c,h),H[ja+296>>2]=ka;H[j+300>>2]=Ja;f=0}if(!f){break Ec}break Dc;case 3:if(!(b|d)){break Cc}if(!f&(c|0)==-2147483648&(b&d)==-1){break Dc}ja=j,ka=TK(f,c,b,d),H[ja+296>>2]=ka;H[j+300>>2]=Ja;break Ec;default:break Fc}}if(!(b|d)){break Cc}h=b;b=(b&d)==-1;ja=j,ka=UK(f,c,b?1:h,b?0:d),H[ja+296>>2]=ka;H[j+300>>2]=Ja}b=H[j+300>>2];H[m>>2]=H[j+296>>2];H[m+4>>2]=b;b=N(n,40)+o|0;G[b+16>>1]=J[b+16>>1]&62016|4;break e}if((J[l+16>>1]|J[k+16>>1])&1){break Cc}}B=Nb(k);S=Nb(l);Kc:{Lc:{switch(I[g|0]-106|0){case 0:B=B+S;break Kc;case 1:B=S-B;break Kc;case 2:B=B*S;break Kc;case 3:if(B==0){break Cc}B=S/B;break Kc;default:break Lc}}b=ac(k);c=Ja;d=ac(l);f=Ja;if(!(b|c)){break Cc}h=b;b=(b&c)==-1;B=+(UK(d,f,b?1:h,b?0:c)>>>0)+ +(Ja|0)*4294967296}if(Op(B)){break Cc}M[m>>3]=B;b=N(n,40)+o|0;G[b+16>>1]=J[b+16>>1]&62016|8;break e}dc(m);break e}b=H[g+4>>2];if(!b){break e}Xc(N(b,40)+o|0,0,0);break e}n=H[g+12>>2];k=N(n,40)+o|0;b=N(H[g+8>>2],40)+o|0;c=N(H[g+4>>2],40)+o|0;if((J[b+16>>1]|J[c+16>>1])&1){dc(k);break e}m=ac(b);b=Ja;c=ac(c);f=Ja;Mc:{Nc:{Oc:{Pc:{d=I[g|0];switch(d-102|0){case 1:break Oc;case 0:break Pc;default:break Nc}}m=c&m;b=b&f;break Mc}m=c|m;b=b|f;break Mc}if(!(c|f)){break Mc}h=(f|0)<0;l=h?-47-d|0:d;d=c;q=c>>>0>4294967232&(f|0)>=-1|(f|0)>=0;c=h?q?0-c|0:64:c;d=h?q?0-(((d|0)!=0)+f|0)|0:0:f;if((d|0)>=0&c>>>0>=64|(d|0)>0){b=(l&255)!=104&(b|0)<0;m=0-b|0;b=0-((b|0)!=0)|0;break Mc}if((l&255)==104){h=m;f=c&31;if((c&63)>>>0>=32){d=h<<f;m=0}else{d=(1<<f)-1&h>>>32-f|b<<f;m=h<<f}b=d;break Mc}f=m;d=c&31;if((c&63)>>>0>=32){h=0;m=b>>>d|0}else{h=b>>>d|0;m=((1<<d)-1&b)<<32-d|f>>>d}if((b|0)>0|(b|0)>=0){b=h;break Mc}b=64-c|0;c=b&31;if((b&63)>>>0>=32){b=-1<<c;d=0}else{d=-1<<c;b=d|(1<<c)-1&-1>>>32-c}m=d|m;b=b|h}H[k>>2]=m;H[k+4>>2]=b;b=N(n,40)+o|0;G[b+16>>1]=J[b+16>>1]&62016|4;break e}b=N(H[g+4>>2],40)+o|0;di(b);c=b;f=H[g+8>>2];d=f+H[b>>2]|0;b=H[b+4>>2]+(f>>31)|0;H[c>>2]=d;H[c+4>>2]=d>>>0<f>>>0?b+1|0:b;break e}Qc:{b=N(H[g+4>>2],40)+o|0;f=J[b+16>>1];if(f&4){break Qc}ci(b,67,u);f=J[b+16>>1];if(f&4){break Qc}if(H[g+8>>2]){break h}e=20;break c}G[b+16>>1]=f&62016|4;break e}b=N(H[g+4>>2],40)+o|0;if(!(I[b+16|0]&36)){break e}Xu(b);break e}Rc:{b=N(H[g+4>>2],40)+o|0;if(!(I[b+17|0]&4)){break Rc}e=Ce(b);if(!e){break Rc}break c}e=0;b=Wu(b,I[g+8|0],u);if(!b){break e}e=b;break c}k=H[g+12>>2];b=N(k,40)+o|0;d=J[b+16>>1];m=H[g+4>>2];f=N(m,40)+o|0;l=J[f+16>>1];n=d&l;if(n&4){h=H[b>>2];k=H[f>>2];b=H[b+4>>2];d=H[f+4>>2];if(h>>>0>k>>>0&(b|0)>=(d|0)|(b|0)>(d|0)){if(I[c+29848|0]){break h}z=1;break e}if(h>>>0<k>>>0&(b|0)<=(d|0)|(b|0)<(d|0)){if(I[c+29836|0]){break h}z=-1;break e}if(I[c+29842|0]){break h}break k}h=J[g+2>>1];q=d|l;if(q&1){if(h&128){z=1;if(d&256?0:n&1){break m}if(!(d&1)){break n}z=-1;h=29836;break l}if(h&16){break h}z=1;break e}c=h&71;if(c>>>0>=67){if(!(q&2)){break o}if((l&46)==2){ak(f,0);d=J[b+16>>1]}if((d&46)!=2){break o}ak(b,0);break o}if((c|0)!=66){break o}if(!(l&44)|l&2){break q}ei(f,u,1);l=J[f+16>>1]&-3520|l&3519;c=(k|0)==(m|0)?l|2:d;d=c&65535;break p}if(z){break e}z=0;break h}c=0;k=0;k=F[g+2|0]&1?H[g-4>>2]+4|0:k;b=H[g+12>>2];f=(b|0)>0?b:0;h=H[g+8>>2];l=H[g+4>>2];b=H[g+16>>2];while(1){if((c|0)==(f|0)){break e}m=I[H[b+16>>2]+c|0];d=k?H[(c<<2)+k>>2]:c;n=l+d|0;q=d+h|0;d=bi(N(n,40)+o|0,N(q,40)+o|0,H[(b+(c<<2)|0)+20>>2]);if(d){f=m&1;d=!(I[H[b+16>>2]+c|0]&2)|!(F[(N(q,40)+o|0)+16|0]&1?1:F[(N(n,40)+o|0)+16|0]&1)?d:0-d|0;z=f?0-d|0:d;break e}else{c=c+1|0;z=0;continue}}}if((z|0)<0){g=(N(H[g+4>>2],20)+t|0)-20|0;break e}if(!z){g=(N(H[g+8>>2],20)+t|0)-20|0;break k}g=(N(H[g+12>>2],20)+t|0)-20|0;break e}c=ai(N(H[g+4>>2],40)+o|0,2);d=ai(N(H[g+8>>2],40)+o|0,2);b=H[g+12>>2];c=I[(d+N(c,3)|0)+(I[g|0]==44?32912:32921)|0];if((c|0)==2){b=N(b,40)+o|0;G[b+16>>1]=J[b+16>>1]&62016|1;break e}b=N(b,40)+o|0;H[b>>2]=c;H[b+4>>2]=0;G[b+16>>1]=J[b+16>>1]&62016|4;break e}c=N(H[g+8>>2],40)+o|0;b=ai(N(H[g+4>>2],40)+o|0,H[g+12>>2])^H[g+16>>2];Xc(c,b,b>>31);break e}b=N(H[g+8>>2],40)+o|0;c=N(H[g+4>>2],40)+o|0;if(!(F[c+16|0]&1)){Xc(b,!ai(c,0),0);break e}dc(b);break e}c=H[g+4>>2];b=N(H[g+8>>2],40)+o|0;dc(b);c=N(c,40)+o|0;if(F[c+16|0]&1){break e}G[b+16>>1]=4;ja=b,ka=ac(c)^-1,H[ja>>2]=ka;H[b+4>>2]=Ja^-1;break e}b=H[a+104>>2];c=H[a+212>>2];Sc:{if(c){b=(g-b|0)/20|0;d=1<<(b&7);b=H[c+24>>2]+(b>>>3|0)|0;c=I[b|0];if(d&c){break h}F[b|0]=c|d;c=H[H[a+104>>2]+4>>2];break Sc}c=H[b+4>>2];if((c|0)==H[g+4>>2]){break h}}H[g+4>>2]=c;break e}if(ai(N(H[g+4>>2],40)+o|0,H[g+12>>2])){break h}break e}if(!ai(N(H[g+4>>2],40)+o|0,!H[g+12>>2])){break h}break e}if(F[(N(H[g+4>>2],40)+o|0)+16|0]&1){break h}break e}b=N(H[g+4>>2],40)+o|0;if(F[b+16|0]&1){break h}if((gb(b)|0)==H[g+12>>2]){break h}break e}if(F[(N(H[g+12>>2],40)+o|0)+16|0]&1?1:F[(N(H[g+4>>2],40)+o|0)+16|0]&1){dc(N(H[g+8>>2],40)+o|0);break e}Xc(N(H[g+8>>2],40)+o|0,0,0);break e}if(!(F[(N(H[g+4>>2],40)+o|0)+16|0]&1)){break h}break e}if(!I[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+2|0]){break e}dc(N(H[g+12>>2],40)+o|0);break h}c=H[a+96>>2]+(H[g+4>>2]<<2)|0;q=H[g+8>>2];Tc:while(1){p=H[c>>2];while(1){r=H[p+64>>2];Uc:{d=H[a+28>>2];if((d|0)!=H[p+24>>2]){if(I[p+2|0]){Vc:{if(I[p|0]!=3){break Vc}b=H[p+28>>2];if((b|0)<=0){break Vc}b=N(b,40)+o|0;c=H[b+12>>2];H[p+72>>2]=c;H[p+76>>2]=c;f=H[b+8>>2];H[p+68>>2]=f;break B}dc(N(H[g+12>>2],40)+o|0);break e}b=H[p+36>>2];if(I[p+3|0]){Wc:{c=H[p+8>>2];if(c){c=H[(c+(q<<2)|0)+4>>2];if(c){break Wc}}e=0;f=Vu(p);if(f){break r}break C}q=c-1|0;c=p+32|0;continue Tc}if(!lm(b)){break C}break Uc}if(lm(H[p+36>>2])){break Uc}h=J[p+54>>1];break A}e=0;f=Uu(p);if(!f){continue}break}break}break r}b=N(H[g+4>>2],40)+o|0;c=H[(N(H[b>>2],20)+t|0)+8>>2];G[b+16>>1]=0;g=(N(c,20)+t|0)-20|0;break e}b=I[i+94|0];Xc:{if(!(b&65)|I[a+147|0]==254){break Xc}d=H[g+16>>2];if(!d){d=H[a+196>>2];if(!d){break Xc}}if(b&64){b=Ga-160|0;Ga=b;H[b+156>>2]=0;k=H[a>>2];fd(b+128|0,0,0,0,H[k+120>>2]);Yc:{if(H[k+196>>2]>=2){c=d;while(1){h=I[d|0];if(!h){break Yc}while(1){Zc:{c=c+1|0;if((h&255)==10){break Zc}h=I[c|0];if(h){continue}}break}f=b+128|0;Bb(f,29308,3);Bb(f,d,c-d|0);d=c;continue}}if(J[a+16>>1]){c=1;while(1){if(!I[d|0]){break Yc}n=b+128|0;f=d;l=0;h=Ga-16|0;Ga=h;H[b+152>>2]=0;while(1){_c:{$c:{if(I[f|0]){m=bk(f,h+12|0);if(H[h+12>>2]!=156){break $c}H[b+152>>2]=m}Ga=h+16|0;break _c}f=f+m|0;l=l+m|0;continue}break}Bb(n,d,l);h=H[b+152>>2];if(!h){break Yc}d=d+l|0;ad:{if(I[d|0]==63){if((h|0)>=2){Ag(d+1|0,b+156|0);f=H[b+156>>2];break ad}H[b+156>>2]=c;f=c;break ad}f=ux(a,d,h);H[b+156>>2]=f}l=f+1|0;c=(c|0)<(l|0)?l:c;d=d+h|0;f=H[a+100>>2]+N(f-1|0,40)|0;h=J[f+16>>1];if(h&1){Bb(b+128|0,19458,4);continue}if(h&36){h=H[f+4>>2];H[b+80>>2]=H[f>>2];H[b+84>>2]=h;vb(b+128|0,14185,b+80|0);continue}if(h&8){M[b+64>>3]=M[f>>3];vb(b+128|0,11934,b- -64|0);continue}if(h&2){l=I[k+84|0];if((l|0)!=1){h=b+88|0;$a(h,0,40);H[b+108>>2]=k;m=H[f+8>>2];f=H[f+12>>2];oe(h,m,f,f>>31,l,0);if((be(h,1)|0)==7){H[b+136>>2]=0;F[b+148|0]=7}ja=b,ka=ZK(H[b+96>>2],H[b+100>>2]),H[ja+48>>2]=ka;H[b+52>>2]=Ja;vb(b+128|0,27189,b+48|0);hd(b+88|0);continue}ja=b,ka=ZK(H[f+8>>2],H[f+12>>2]),H[ja+32>>2]=ka;H[b+36>>2]=Ja;vb(b+128|0,27189,b+32|0);continue}if(h&1024){H[b+16>>2]=H[f>>2];vb(b+128|0,24656,b+16|0)}else{Bb(b+128|0,26805,2);h=0;l=H[f+12>>2];l=(l|0)>0?l:0;while(1){if((h|0)!=(l|0)){H[b>>2]=I[H[f+8>>2]+h|0];vb(b+128|0,1558,b);h=h+1|0;continue}break}Bb(b+128|0,28021,1)}continue}}Bb(b+128|0,d,ib(d))}if(I[b+148|0]){Nf(b+128|0)}c=Wd(b+128|0);Ga=b+160|0;Ka[H[i+212>>2]](H[i+216>>2],c);Wa(c);break Xc}if(H[i+196>>2]>=2){H[j+96>>2]=d;b=tb(i,8268,j+96|0);Ka[H[i+212>>2]](1,H[i+216>>2],a,b)|0;_a(i,b);break Xc}Ka[H[i+212>>2]](1,H[i+216>>2],a,d)|0}b=H[g+4>>2];if((b|0)>=H[16067]){if(I[g|0]==181){break e}c=1;b=H[a+108>>2];b=(b|0)>1?b:1;while(1){if((b|0)!=(c|0)){d=H[a+104>>2]+N(c,20)|0;if(I[d|0]==14){H[d+4>>2]=0}c=c+1|0;continue}break}H[g+4>>2]=0;b=0}H[g+4>>2]=b+1;H[a+184>>2]=H[a+184>>2]+1;break h}b=H[g+4>>2];c=Tu(o,g);b=N(b,40)+o|0;d=H[b+8>>2];b=H[b+12>>2];b=WK(c,Ja,b,b>>31);if(!(I[((Ja&7)<<29|b>>>3)+d|0]>>>(b&7)&1)){H[a+192>>2]=H[a+192>>2]+1;break h}H[a+188>>2]=H[a+188>>2]+1;break e}b=H[g+4>>2];c=Tu(o,g);b=N(b,40)+o|0;d=H[b+8>>2];b=H[b+12>>2];b=WK(c,Ja,b,b>>31);c=((Ja&7)<<29|b>>>3)+d|0;F[c|0]=I[c|0]|1<<(b&7);break e}b=N(H[g+4>>2],40)+o|0;G[b+16>>1]=J[b+16>>1]&63487;break e}bd:{f=H[g+12>>2];d=N(f,40)+o|0;b=H[g+16>>2];if((d|0)==H[b>>2]){l=I[b+26|0];break bd}F[b+24|0]=u;H[b>>2]=d;H[b+12>>2]=a;l=I[b+26|0];c=l;while(1){if((c|0)<=0){break bd}c=c-1|0;H[(b+(c<<2)|0)+28>>2]=N(H[g+8>>2]+c|0,40)+o;continue}}c=N(f,40)+o|0;G[c+16>>1]=J[c+16>>1]&62016|1;Ka[H[H[b+4>>2]+16>>2]](b,l,b+28|0);f=H[b+20>>2];if(!f){break e}c=e;if((f|0)>0){ja=j,ka=cb(d),H[ja+240>>2]=ka;_c(a,8310,j+240|0);c=H[b+20>>2]}Fl(i,$,H[b+16>>2],H[g+4>>2]);e=0;H[b+20>>2]=0;if(!c){break e}e=c;break c}c=Ec(a,g);d=H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2];b=H[g+12>>2];if(b){f=Kh(d);b=b>>>0<f>>>0?f:b}else{b=0}Jb(d);d=H[H[d+4>>2]>>2];cd:{if(!b){b=H[d+160>>2];break cd}H[d+160>>2]=b}H[c>>2]=b;H[c+4>>2]=0;break e}b=Ec(a,g);ja=b,ka=Kh(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2]),H[ja>>2]=ka;H[b+4>>2]=0;break e}H[j+296>>2]=0;H[j+300>>2]=0;if(I[i+87|0]){break d}c=6;b=H[H[g+16>>2]+8>>2];dd:{if(!b){break dd}d=H[b>>2];if(!d){break dd}if(!H[d+52>>2]){break e}c=0;f=H[g+8>>2];k=(f|0)>0?f:0;e=N(H[g+12>>2],40)+o|0;h=H[a+92>>2];l=I[i+92|0];while(1){if((c|0)!=(k|0)){H[h+(c<<2)>>2]=e;c=c+1|0;e=e+40|0;continue}break}F[i+92|0]=I[g+2|0];c=Ka[H[d+52>>2]](b,f,h,j+296|0)|0;F[i+92|0]=l;Hf(a,b);if(!c){if(H[g+4>>2]){e=H[j+300>>2];H[i+40>>2]=H[j+296>>2];H[i+44>>2]=e}h=H[a+44>>2];e=H[a+40>>2]+1|0;h=e?h:h+1|0;H[a+40>>2]=e;H[a+44>>2]=h;break I}if(!(!I[H[g+16>>2]+16|0]|(c&255)!=19)){d=2;e=0;ed:{fd:{b=J[g+2>>1];switch(b-4|0){case 0:break e;case 1:break ed;default:break fd}}d=b}F[a+146|0]=d;break dd}b=H[a+44>>2];e=H[a+40>>2]+1|0;b=e?b:b+1|0;H[a+40>>2]=e;H[a+44>>2]=b}e=c;break c}e=H[i+36>>2];d=H[i+32>>2];H[i+32>>2]=d|67108864;H[i+36>>2]=e;c=H[H[g+16>>2]+8>>2];b=N(H[g+4>>2],40)+o|0;e=be(b,1);if(e){break c}b=Ka[H[H[c>>2]+76>>2]](c,H[b+8>>2])|0;if(!(d&67108864)){e=H[i+36>>2];H[i+32>>2]=H[i+32>>2]&-67108865;H[i+36>>2]=e}Hf(a,c);F[a+150|0]=I[a+150|0]&252;e=0;if(!b){break e}e=b;break c}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(I[b+2|0]){break e}e=H[b+36>>2];d=H[e>>2];c=H[d>>2];e=Ka[H[c+36>>2]](e)|0;Hf(a,d);if(e){break c}e=0;if(!(Ka[H[c+40>>2]](H[b+36>>2])|0)){break g}break f}c=H[g+12>>2];b=N(c,40)+o|0;d=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(I[d+2|0]){dc(b);break e}f=H[H[d+36>>2]>>2];h=H[f>>2];H[W+24>>2]=0;e=W;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e>>2]=0;H[e+4>>2]=0;F[j+320|0]=u;H[j+296>>2]=b;gd:{if(F[g+2|0]&1){dc(b);G[(N(c,40)+o|0)+16>>1]=1025;H[b>>2]=0;break gd}e=N(c,40)+o|0;G[e+16>>1]=J[e+16>>1]&62016|1}d=Ka[H[h+44>>2]](H[d+36>>2],j+296|0,H[g+8>>2])|0;Hf(a,f);if(H[j+316>>2]>0){ja=j,ka=cb(b),H[ja+224>>2]=ka;_c(a,8310,j+224|0);d=H[j+316>>2]}be(b,u);e=0;if(!d){break e}e=d;break c}c=0;e=N(H[g+12>>2],40)+o|0;b=H[e+40>>2];h=(b|0)>0?b:0;k=e+40|0;l=H[e>>2];m=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];d=H[m+36>>2];n=H[d>>2];f=H[n>>2];e=H[a+92>>2];while(1){if((c|0)!=(h|0)){q=e+(c<<2)|0;c=c+1|0;H[q>>2]=k+N(c,40);continue}break}e=Ka[H[f+32>>2]](d,l,H[g+16>>2],b,e)|0;Hf(a,n);if(e){break c}e=0;b=Ka[H[f+40>>2]](d)|0;F[m+2|0]=0;if(b){break h}break e}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=Ib(8,0);if(!b){break d}H[b>>2]=H[c+36>>2];H[b+4>>2]=N(H[g+12>>2],40)+o;c=Ec(a,g);G[c+16>>1]=1;Ex(c,b,2220,3);break e}H[j+296>>2]=0;e=6;b=H[H[g+16>>2]+8>>2];if(!b){break c}c=H[b>>2];if(!c){break c}e=Ka[H[c+24>>2]](b,j+296|0)|0;Hf(a,b);if(e){break c}H[H[j+296>>2]>>2]=b;e=0;d=_g(a,H[g+4>>2],0,2);if(d){H[d+36>>2]=H[j+296>>2];H[b+4>>2]=H[b+4>>2]+1;break e}Ka[H[c+28>>2]](H[j+296>>2])|0;break d}H[i+200>>2]=H[i+200>>2]+1;c=0;e=Dc(i,H[g+16>>2],H[H[i+16>>2]+(H[g+4>>2]<<4)>>2]);hd:{if(!e|I[e+43|0]!=1){break hd}d=H[e+52>>2];if(!d){break hd}while(1){if(d){if(H[H[d+8>>2]+4>>2]>0){c=6;break hd}else{d=H[d+24>>2];continue}}break}b=gu(i,e);d=H[H[b+4>>2]>>2];c=H[d+20>>2];if(!c){c=H[d+16>>2]}H[e+24>>2]=H[e+24>>2]+1;c=Ka[c|0](H[b+8>>2])|0;if(!c){H[b+8>>2]=0;H[e+52>>2]=0;bh(b)}ie(i,e)}H[i+200>>2]=H[i+200>>2]-1;e=0;if(!c){break e}e=c;break c}e=0;b=j+296|0;$a(b,0,40);H[j+316>>2]=i;c=fk(b,N(H[g+8>>2],40)+o|0);d=cb(b);if(d){b=Ga-16|0;Ga=b;id:{jd:{d=Dc(i,d,H[H[i+16>>2]+(H[g+4>>2]<<4)>>2]);f=H[H[d+48>>2]>>2];c=Wc(i+384|0,f);kd:{if(!c){break kd}h=H[c>>2];k=H[h+4>>2];if(!k){break kd}if(H[h+20>>2]){break jd}}H[b>>2]=f;ja=y,ka=tb(i,7784,b),H[ja>>2]=ka;c=1;break id}c=Jo(i,d,c,k,y);if(c){break id}c=0;if(!Id(i,d)){break id}c=iu(i);if(c){break id}hu(i,Id(i,d));c=0}Ga=b+16|0}hd(j+296|0);if(!c){break e}e=c;break c}c=H[g+16>>2];b=c;e=0;d=H[i+380>>2];ld:{if(!(H[i+404>>2]|(d|0)<=0)){e=6;break ld}md:{if(!b){break md}f=H[H[b+8>>2]>>2];if(!H[f+56>>2]){break md}d=(d|0)>0?d:0;nd:{while(1){if((d|0)==(e|0)){break nd}h=e<<2;e=e+1|0;if((b|0)!=H[h+H[i+404>>2]>>2]){continue}break}e=0;break ld}e=iu(i);if(e){break md}e=Ka[H[f+56>>2]](H[b+8>>2])|0;if(e){break md}d=H[i+500>>2];h=H[i+504>>2];hu(i,b);e=0;d=d+h|0;if(!d){break md}f=H[f+80>>2];if(!f){break md}H[b+20>>2]=d;e=Ka[f|0](H[b+8>>2],d-1|0)|0}}b=e;if(c){Hf(a,H[c+8>>2])}e=0;if(!b){break e}e=b;break c}d=I[g+12|0];if(!(I[i+33|0]&4?d:1)){break e}e=0;b=H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2];if(I[b+9|0]){c=H[g+8>>2];Jb(b);d=d+1&255;e=Hr(b,c,d);if(!e){h=H[b+4>>2];f=h+76|0;od:{pd:{while(1){f=H[f>>2];if(f){if((c|0)==H[f+4>>2]&(b|0)==H[f>>2]){break pd}f=f+12|0;continue}break}f=Ad(16,0);e=7;if(!f){break od}H[f>>2]=b;H[f+4>>2]=c;H[f+12>>2]=H[h+76>>2];H[h+76>>2]=f}if(d>>>0>I[f+8|0]){F[f+8|0]=d}e=0}}}if(!e){break I}if((e&255)==6){H[j+208>>2]=H[g+16>>2];_c(a,8139,j+208|0)}break c}b=H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2];F[b+1|0]=I[b+1|0]&191;break e}b=H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2];F[b+1|0]=I[b+1|0]|64;break e}b=H[g+8>>2];if(!H[g+4>>2]){wg(i,b);break e}F[a+150|0]=b+1&3|I[a+150|0]&252;break e}b=H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2];e=H[b+4>>2];Jb(b);c=101;qd:{rd:{if(!I[e+17|0]){break rd}b=H[e+48>>2];d=eb(H[H[e+12>>2]+56>>2]+36|0);f=rv(e,b,d);if(!(b>>>0>d>>>0&b>>>0>=f>>>0)){b=ab(70865);break qd}if(!d){break rd}c=Jg(e,0,0);if(c){break rd}fp(e);c=qv(e,f,b,0);if(c){break rd}c=_b(H[H[e+12>>2]+72>>2]);Cb(H[H[e+12>>2]+56>>2]+28|0,H[e+48>>2])}b=c}if(!b){e=b;break e}e=0;if((b|0)==101){break h}e=b;break c}e=0;d=H[g+4>>2];b=H[g+8>>2];v=b?N(b,40)+o|0:0;l=0;r=Ga-80|0;Ga=r;sd:{if(!I[i+85|0]){kg(y,i,10030);c=1;break sd}if(H[i+184>>2]>=2){kg(y,i,4096);c=1;break sd}h=H[i+60>>2];td:{if(!v){c=29357;break td}if((gb(v)|0)!=3){kg(y,i,13181);c=1;break sd}c=cb(v);H[i+60>>2]=H[i+60>>2]&-8|6}ca=I[i+94|0];F[i+94|0]=0;X=H[i+24>>2];H[i+24>>2]=X|6;b=H[i+36>>2];da=b;Y=H[i+32>>2];H[i+32>>2]=Y&-268456450|513;H[i+36>>2]=b&-2;f=H[i+16>>2]+(d<<4)|0;b=H[f>>2];ea=H[i+112>>2];fa=H[i+116>>2];ga=H[i+104>>2];ha=H[i+108>>2];s=H[f+4>>2];k=rr(Vc(s));f=H[i+20>>2];H[r+64>>2]=c;c=xj(i,y,17379,r- -64|0);H[i+60>>2]=h;ud:{if(c){break ud}l=H[i+16>>2]+(f<<4)|0;p=H[l+4>>2];vd:{if(v){c=H[Vc(p)+64>>2];H[r+72>>2]=0;H[r+76>>2]=0;if(H[c>>2]){if(Nd(c,r+72|0)){break vd}c=H[r+76>>2];if(!!H[r+72>>2]&(c|0)>=0|(c|0)>0){break vd}}H[i+24>>2]=H[i+24>>2]|8}h=Kw(s);Lj(p,H[H[(H[i+16>>2]+(d<<4)|0)+12>>2]+80>>2]);vl(p,vl(s,0));No(p,33);c=Mo(i,y,19259);if(c){break ud}c=_f(s,!v<<1,0);if(c){break ud}if(!(v|I[Vc(s)+5|0]!=5)){H[i+100>>2]=0}c=7;if(Fh(p,df(s),h,0)){break ud}if(!k){if(Fh(p,H[i+100>>2],h,0)){break ud}}if(I[i+87|0]){break ud}c=F[i+90|0];wd:{if((c|0)>=0){c=c&255;break wd}c=Lo(s)}Ko(p,c);F[i+176|0]=f;H[r+48>>2]=b;c=xj(i,y,23416,r+48|0);if(c){break ud}H[r+32>>2]=b;c=xj(i,y,26667,r+32|0);if(c){break ud}F[i+176|0]=0;H[r+16>>2]=b;c=xj(i,y,23265,r+16|0);H[i+24>>2]=H[i+24>>2]&-5;if(c){break ud}H[r>>2]=b;c=xj(i,y,25583,r);if(c){break ud}q=0;while(1){if(q>>>0<=9){b=I[q+33176|0];Wh(s,b,r+72|0);c=q|1;q=q+2|0;c=Nk(p,b,H[r+72>>2]+I[c+33176|0]|0);if(!c){continue}break ud}break}if(!v){C=Ga-48|0;Ga=C;Jb(s);Jb(p);b=H[Vc(s)+64>>2];xd:{if(H[b>>2]){c=df(p);ja=C,ka=SK(c,c>>31,Kh(p),0),H[ja>>2]=ka;H[C+4>>2]=Ja;b=Ah(b,11,C);k=(b|0)==12?0:b;if(k){break xd}}k=0;n=$a(C,0,48);b=H[p>>2];H[n+24>>2]=p;H[n+20>>2]=b;H[n+16>>2]=1;H[n+4>>2]=s;w=0;O=0;h=Ga-16|0;Ga=h;Jb(H[n+24>>2]);if(!YB(H[n+28>>2])){b=H[n+24>>2];Z=Vc(b);A=Vc(H[n+4>>2]);yd:{if(!(!H[n>>2]|I[H[b+4>>2]+20|0]!=2)){O=1;f=5;break yd}if(Pg(b)){O=1;f=0;break yd}f=_f(b,0,0)}d=H[n+12>>2];zd:{Ad:{if(!(f|d)){f=7;if((Fh(H[n+4>>2],df(H[n+24>>2]),0,0)|0)==7){break zd}d=H[n+12>>2];break Ad}if(f){break zd}}f=0;if(d){break zd}f=_f(H[n+4>>2],2,n+8|0);if(f){break zd}H[n+12>>2]=1;f=0}b=H[n+24>>2];c=df(b);d=H[n+4>>2];m=df(d);D=I[Vc(d)+5|0];d=f?f:(D|0)==5?((c|0)!=(m|0))<<3:f;q=Kh(b);while(1){Bd:{if((w|0)==2147483647){break Bd}b=H[n+16>>2];if(b>>>0>q>>>0|d){break Bd}d=0;if((b|0)!=((K[16164]/K[H[H[n+24>>2]+4>>2]+36>>2]|0)+1|0)){d=sd(Z,b,h+12|0,2);if(!d){d=QB(n,b,H[H[h+12>>2]+4>>2],0);rd(H[h+12>>2])}b=H[n+16>>2]}H[n+16>>2]=b+1;w=w+1|0;continue}break}Cd:{Dd:{if((d|0)==101){break Dd}if(d){break Cd}H[n+36>>2]=q;b=H[n+16>>2];H[n+32>>2]=(q-b|0)+1;if(b>>>0>q>>>0){break Dd}d=0;if(H[n+40>>2]){break Cd}b=tA(Vc(H[n+24>>2]));H[n+44>>2]=H[b>>2];H[b>>2]=n;H[n+40>>2]=1;break Cd}Ed:{if(q){break Ed}q=1;b=H[n+4>>2];Jb(b);b=H[b+4>>2];H[b+48>>2]=0;d=Ar(b);if((d|0)==101){break Ed}if(d){break Cd}}d=Nk(H[n+4>>2],1,H[n+8>>2]+1|0);if(d){break Cd}b=H[n>>2];if(b){Yf(b)}if((D|0)==5){d=FB(H[n+4>>2],2);if(d){break Cd}}Fd:{if((c|0)<(m|0)){b=H[16164];d=H[H[H[n+4>>2]+4>>2]+36>>2];D=H[A+64>>2];Vr(A,h+12|0);f=(m|0)/(c|0)|0;f=((f+q|0)-1|0)/(f|0)|0;f=f-((f|0)==(((b>>>0)/(d>>>0)|0)+1|0))|0;b=q>>31;w=H[h+12>>2];d=0;while(1){if(!(f>>>0>w>>>0|d)){d=0;Gd:{if(((K[16164]/K[H[H[n+4>>2]+4>>2]+36>>2]|0)+1|0)==(f|0)){break Gd}d=sd(A,f,h+8|0,0);if(d){break Gd}d=_b(H[h+8>>2]);rd(H[h+8>>2])}f=f+1|0;continue}break}U=c>>31;w=SK(q,b,c,U);q=Ja;if(!d){d=Rr(A,0,1)}f=H[16164];m=f+m|0;b=m>>31;T=m;m=m>>>0>w>>>0&(b|0)>=(q|0)|(b|0)>(q|0);ia=m?w:T;T=m?q:b;b=c+f|0;m=b;b=b>>31;while(1){if(!((b|0)>=(T|0)&m>>>0>=ia>>>0|(b|0)>(T|0)|d)){H[h+8>>2]=0;d=sd(Z,TK(m,b,c,U)+1|0,h+8|0,0);if(!d){d=Bc(D,H[H[h+8>>2]+4>>2],c,m,b)}rd(H[h+8>>2]);b=b+U|0;m=c+m|0;b=m>>>0<c>>>0?b+1|0:b;continue}break}if(d){break Fd}b=Ga-16|0;Ga=b;f=Nd(D,b+8|0);Hd:{if(f){break Hd}f=0;c=H[b+12>>2];if((q|0)>=(c|0)&w>>>0>=K[b+8>>2]|(c|0)<(q|0)){break Hd}f=sf(D,w,q)}Ga=b+16|0;d=f;if(d){break Fd}d=Or(A,0);break Fd}dB(A,N((c|0)/(m|0)|0,q));d=Rr(A,0,0)}if(d){break Cd}b=Hk(H[n+4>>2],0);d=b?b:101}if(!O){bn(H[n+24>>2],0);Hk(H[n+24>>2],0)}H[n+28>>2]=(d|0)==3082?7:d}Ga=h+16|0;if(n){c=H[n+20>>2];Jb(H[n+24>>2]);if(H[n>>2]){b=H[n+24>>2];H[b+16>>2]=H[b+16>>2]-1}if(H[n+40>>2]){h=tA(Vc(H[n+24>>2]));while(1){b=h;d=H[b>>2];h=d+44|0;if((d|0)!=(n|0)){continue}break}H[b>>2]=H[n+44>>2]}Zq(H[n+4>>2],0,0);b=H[n+28>>2];b=(b|0)==101?0:b;d=H[n>>2];Id:{if(!d){break Id}Yc(d,b);Kn(H[n>>2]);if(!H[n>>2]){break Id}Wa(n)}Kn(c)}else{b=0}if(!b){b=H[s+4>>2];G[b+24>>1]=J[b+24>>1]&65533;break xd}c=Vc(H[n+4>>2]);if(!I[c+12|0]){eh(c)}k=b}Ga=C+48|0;c=k;if(c){break ud}}c=So(p);b=((c|0)!=0)<<1;if(!(c|v)){Ko(s,Lo(p));b=0}if(b|v){break ud}b=Kw(p);c=Fh(s,df(p),b,1);break ud}kg(y,i,3448);c=1}H[i+112>>2]=ea;H[i+116>>2]=fa;H[i+104>>2]=ga;H[i+108>>2]=ha;H[i+32>>2]=Y;H[i+36>>2]=da;H[i+24>>2]=X;F[i+94|0]=ca;F[i+176|0]=0;Fh(s,-1,0,1);F[i+85|0]=1;if(l){Gg(H[l+4>>2]);H[l+12>>2]=0;H[l+4>>2]=0}Yf(i)}Ga=r+80|0;if(!c){break e}e=c;break c}h=Ec(a,g);m=H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2];d=Vc(m);b=I[d+5|0];c=H[g+12>>2];c=(c|0)==-1?b:c;f=0;Jd:{if(I[d+17|0]>2){break Jd}if(H[H[d+68>>2]>>2]){k=H[d+84>>2];if(!!H[d+80>>2]&(k|0)>=0|(k|0)>0){break Jd}}f=1}Kd:{Ld:{Md:{k=f?c:b;Nd:{if((k|0)==5){if(!ib(Fp(d,1))){break Nd}if(!uv(d)|(b|0)==(k|0)){break Nd}break Md}if((b|0)!=(k|0)){break Md}}k=b;break Ld}if((b|0)!=5&(k|0)!=5){break Ld}if(!(H[i+188>>2]<2?I[i+85|0]:0)){H[j+192>>2]=(k|0)==5?9425:11970;_c(a,9916,j+192|0);e=1;break c}Od:{if((b|0)==5){f=Ga-16|0;Ga=f;Pd:{Qd:{if(H[d+232>>2]){break Qd}H[f+12>>2]=0;e=qg(d,1);if(e){break Pd}e=pg(H[d>>2],H[d+236>>2],0,f+12|0);if(!(e|!H[f+12>>2])){e=tv(d)}if(e){break Pd}if(H[d+232>>2]){break Qd}e=0;break Pd}e=sv(d);if(e){break Pd}e=0;c=gw(H[d+232>>2],i,I[d+11|0],H[d+168>>2],H[d+224>>2]);H[d+232>>2]=0;if(!c){break Pd}if(!I[d+4|0]){ch(d,1)}e=c}Ga=f+16|0;if(e){break Kd}$o(d,k);break Od}if((b|0)==4){$o(d,2)}if(e){break Ld}}e=FB(m,(k|0)==5?2:1);break Kd}}l=e;e=$o(d,l?b:k);G[h+16>>1]=8706;e=Su(e);H[h+8>>2]=e;e=ib(e);F[h+18|0]=1;H[h+12>>2]=e;be(h,u);e=0;if(!l){break e}e=l;break c}H[j+304>>2]=-1;H[j+296>>2]=0;H[j+300>>2]=-1;Rd:{e=Pw(i,H[g+4>>2],H[g+8>>2],aa,ba);if(e){if((e|0)!=5){break Rd}H[j+296>>2]=1}e=N(H[g+12>>2],40)+o|0;c=0;while(1){if((c|0)==3){break u}b=H[(j+296|0)+(c<<2)>>2];Xc(e,b,b>>31);e=e+40|0;c=c+1|0;continue}}break c}c=N(H[g+4>>2],40)+o|0;d=H[g+12>>2];Sd:{if(d){e=H[g+16>>2];b=Ga-32|0;Ga=b;H[b+28>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;d=N(d,40)+o|0;dc(d);H[b>>2]=d;H[b+4>>2]=e;H[b+8>>2]=c;F[b+24|0]=I[H[c+20>>2]+84|0];Ka[H[e+24>>2]](b);Ga=b+32|0;c=N(H[g+12>>2],40)+o|0;e=H[b+20>>2];break Sd}e=$u(c,H[g+16>>2])}if(!e){be(c,u);break u}ja=j,ka=cb(c),H[ja+176>>2]=ka;_c(a,8310,j+176|0);break c}b=J[g+2>>1];c=b<<2;d=Tb(i,c+68|0,0);if(!d){break d}H[d+8>>2]=0;c=(c+d|0)+28|0;H[d>>2]=c;$h(c,i,1);c=H[g+16>>2];H[d+16>>2]=(g-t|0)/20;H[d+4>>2]=c;F[d+25|0]=0;H[d+12>>2]=a;F[d+26|0]=b;F[d+24|0]=u;H[d+20>>2]=0;H[g+16>>2]=d;G[g>>1]=61859}Td:{b=N(H[g+12>>2],40)+o|0;if((b|0)==H[d+8>>2]){break Td}H[d+8>>2]=b;c=I[d+26|0];while(1){if((c|0)<=0){break Td}c=c-1|0;H[((c<<2)+d|0)+28>>2]=N(H[g+8>>2]+c|0,40)+o;continue}}H[b+12>>2]=H[b+12>>2]+1;Ka[H[H[d+4>>2]+(H[g+4>>2]?28:16)>>2]](d,I[d+26|0],d+28|0);b=H[d+20>>2];if(!b){break e}c=e;if((b|0)>0){ja=j,ka=cb(H[d>>2]),H[ja+160>>2]=ka;_c(a,8310,j+160|0);c=H[d+20>>2]}if(I[d+25|0]){e=H[g-16>>2];if(e){Xc(N(e,40)+o|0,1,0)}F[d+25|0]=0}hd(H[d>>2]);G[H[d>>2]+16>>1]=1;e=0;H[d+20>>2]=0;if(!c){break e}e=c;break c}c=N(H[g+4>>2],40)+o|0;b=H[c>>2];d=H[c+4>>2];if(!b&(d|0)==-2147483648){break e}d=d-!b|0;b=b-1|0;H[c>>2]=b;H[c+4>>2]=d;if(!(b|d)){break h}break e}c=N(H[g+4>>2],40)+o|0;b=H[c>>2];d=H[c+4>>2];if(!(b|d)){break e}if(!b&(d|0)<=0|(d|0)<0){break h}H[c>>2]=b-1;H[c+4>>2]=d-!b;break h}c=H[g+4>>2];d=H[g+12>>2];b=Ec(a,g);f=N(c,40)+o|0;c=H[f+4>>2];f=H[f>>2];H[j+296>>2]=f;H[j+300>>2]=c;if(!f&(c|0)<=0|(c|0)<0){c=-1;d=-1}else{d=N(d,40)+o|0;c=H[d+4>>2];d=H[d>>2];h=d;d=!!d&(c|0)>=0|(c|0)>0;d=Dl(j+296|0,d?h:0,d?c:0);c=d?-1:H[j+296>>2];d=d?-1:H[j+300>>2]}H[b>>2]=c;H[b+4>>2]=d;break e}c=N(H[g+4>>2],40)+o|0;b=H[c>>2];d=H[c+4>>2];if(!b&(d|0)<=0|(d|0)<0){break e}f=H[g+12>>2];H[c>>2]=b-f;H[c+4>>2]=d-((f>>31)+(b>>>0<f>>>0)|0);break h}c=H[Q>>2];if(c){while(1){b=c;c=H[b+4>>2];if(c){continue}break}b=H[b+16>>2]}else{b=o}b=b+N(H[g+4>>2],40)|0;di(b);c=N(H[g+8>>2],40)+o|0;di(c);d=H[c+4>>2];f=H[b+4>>2];c=H[c>>2];if((d|0)<=(f|0)&c>>>0<=K[b>>2]|(d|0)<(f|0)){break e}H[b>>2]=c;H[b+4>>2]=d;break e}if(H[g+4>>2]){if(H[i+512>>2]|H[i+516>>2]){break e}if(!(H[i+520>>2]|H[i+524>>2])){break h}break e}if(H[a+64>>2]|H[a+68>>2]){break e}if(!(H[i+520>>2]|H[i+524>>2])){break h}break e}if(I[i+34|0]&8){c=H[g+8>>2];b=c+H[i+520>>2]|0;d=H[i+524>>2]+(c>>31)|0;H[i+520>>2]=b;H[i+524>>2]=b>>>0<c>>>0?d+1|0:d;break e}b=H[g+8>>2];d=b>>31;if(H[g+4>>2]){h=d+H[i+516>>2]|0;c=b+H[i+512>>2]|0;h=c>>>0<b>>>0?h+1|0:h;H[i+512>>2]=c;H[i+516>>2]=h;break e}c=b;f=b+H[a+64>>2]|0;b=d+H[a+68>>2]|0;H[a+64>>2]=f;H[a+68>>2]=c>>>0>f>>>0?b+1|0:b;break e}c=Ec(a,g);b=H[a+212>>2];$g(c,H[b+16>>2]+N(H[(H[b+8>>2]+N(H[b+48>>2],20)|0)+4>>2]+H[g+4>>2]|0,40)|0,16384);break e}h=H[g+12>>2];b=H[g+16>>2];Ud:{if(!J[g+2>>1]){break Ud}f=H[b+20>>2];d=Q;while(1){c=H[d>>2];if(!c){break Ud}d=c+4|0;if((f|0)!=H[c+28>>2]){continue}break}break e}c=H[a+220>>2];if((c|0)<H[i+160>>2]){Vd:{Wd:{k=N(h,40)+o|0;if(!(I[k+16|0]&16)){c=H[b+12>>2];f=!c+(c+H[b+8>>2]|0)|0;l=((((H[b+4>>2]+7|0)/8|0)+(c<<2)|0)+N(f,40)|0)+88|0;c=l;d=yb(i,c,c>>31);if(!d){break d}c=N(h,40)+o|0;hd(c);G[k+16>>1]=4112;H[c+36>>2]=4;H[c+12>>2]=l;H[c+8>>2]=d;H[d+60>>2]=f;H[d>>2]=a;l=H[b+12>>2];H[d+48>>2]=(g-t|0)/20;H[d+64>>2]=l;H[d+16>>2]=H[a+88>>2];H[d+56>>2]=H[a+20>>2];H[d+20>>2]=H[a+96>>2];H[d+44>>2]=H[a+24>>2];H[d+8>>2]=H[a+104>>2];H[d+52>>2]=H[a+108>>2];H[d+28>>2]=H[b+20>>2];c=d+88|0;h=c+N(f,40)|0;while(1){if((c|0)==(h|0)){break Wd}H[c+20>>2]=i;G[c+16>>1]=0;c=c+40|0;continue}}d=H[k+8>>2];g=J[d+64>>1];f=H[d+60>>2];l=H[b+12>>2];break Vd}c=H[a+220>>2];g=l}H[a+220>>2]=c+1;H[d+4>>2]=H[a+212>>2];c=H[i+44>>2];H[d+32>>2]=H[i+40>>2];H[d+36>>2]=c;c=H[a+44>>2];H[d+72>>2]=H[a+40>>2];H[d+76>>2]=c;c=H[a>>2];h=H[c+108>>2];H[d+80>>2]=H[c+104>>2];H[d+84>>2]=h;H[d+40>>2]=H[a+232>>2];H[a+212>>2]=d;H[a+40>>2]=0;H[a+44>>2]=0;H[a+232>>2]=0;o=d+88|0;H[a+88>>2]=o;c=N(f,40)+o|0;H[a+96>>2]=c;H[a+24>>2]=g&65535;H[a+20>>2]=f;c=c+(l<<2)|0;H[d+24>>2]=c;$a(c,0,(H[b+4>>2]+7|0)/8|0);t=H[b>>2];H[a+104>>2]=t;H[a+108>>2]=H[b+4>>2];g=t-20|0;break f}_c(a,10268,0);e=1;break c}b=H[g+12>>2];h=H[g+16>>2];q=H[g+4>>2];c=N(q,40)+o|0;if(!(I[c+16|0]&16)){if(Ru(c)){break d}}k=N(b,40)+o|0;if(h){p=H[k>>2];m=H[k+4>>2];n=Ga-16|0;Ga=n;b=H[(N(q,40)+o|0)+8>>2];if((h|0)!=H[b+28>>2]){f=H[b+8>>2];if(f){if(!(F[b+26|0]&1)){f=mu(f)}l=b+20|0;Xd:{Yd:{while(1){c=H[l>>2];if(!c){break Yd}d=H[c+12>>2];if(d){ku(d,n+12|0,n+8|0);H[c+12>>2]=0;l=c+8|0;f=Oo(H[n+12>>2],f);continue}break}ja=c,ka=ju(f),H[ja+12>>2]=ka;break Xd}c=nu(b);H[l>>2]=c;if(!c){break Xd}H[c+8>>2]=0;H[c>>2]=0;H[c+4>>2]=0;ja=c,ka=ju(f),H[ja+12>>2]=ka}H[b+8>>2]=0;H[b+12>>2]=0;G[b+26>>1]=J[b+26>>1]|1}H[b+28>>2]=h}d=b+20|0;while(1){Zd:{c=H[d>>2];if(!c){d=0;break Zd}d=c+12|0;while(1){b=H[d>>2];if(b){f=H[b>>2];d=H[b+4>>2];if(f>>>0<p>>>0&(d|0)<=(m|0)|(d|0)<(m|0)){d=b+8|0;continue}if((d|0)<=(m|0)&f>>>0<=p>>>0|(d|0)<(m|0)){d=1;break Zd}else{d=b+12|0;continue}}break}d=c+8|0;continue}break}Ga=n+16|0;if(d){break h}if((h|0)<0){break e}}Qu(H[(N(q,40)+o|0)+8>>2],H[k>>2],H[k+4>>2]);break e}_d:{d=N(H[g+4>>2],40)+o|0;if(I[d+16|0]&16){b=H[d+8>>2];c=J[b+26>>1];if(!(c&2)){if(!(c&1)){ja=b,ka=mu(H[b+8>>2]),H[ja+8>>2]=ka;c=J[b+26>>1]}G[b+26>>1]=c|3}c=H[b+8>>2];h=0;$d:{if(!c){break $d}f=H[c+4>>2];H[j+296>>2]=H[c>>2];H[j+300>>2]=f;c=H[c+8>>2];H[b+8>>2]=c;if(!c){lu(b)}h=1}if(h){break _d}}dc(d);break g}Xc(N(H[g+12>>2],40)+o|0,H[j+296>>2],H[j+300>>2]);break f}c=H[g+8>>2];b=N(H[g+4>>2],40)+o|0;if(!(I[b+16|0]&16)){if(Ru(b)){break d}}d=H[b+8>>2];b=N(c,40)+o|0;Qu(d,H[b>>2],H[b+4>>2]);break e}p=H[g+4>>2];l=H[g+8>>2];h=N(H[g+12>>2],40)+o|0;d=H[h>>2]+1|0;k=0;c=Ga-224|0;Ga=c;q=H[(H[i+16>>2]+(J[g+2>>1]<<4)|0)+4>>2];f=H[q+4>>2];b=H[f+4>>2];m=H[g+16>>2]+4|0;n=H[m>>2];if(!n){k=H[m+4>>2]!=1}r=H[b+32>>2];s=H[b+36>>2];Jb(q);H[c+152>>2]=f;H[c+220>>2]=i;H[c+156>>2]=H[f>>2];b=H[f+48>>2];H[c+180>>2]=0;H[c+184>>2]=0;H[c+188>>2]=0;H[c+168>>2]=d;H[c+164>>2]=b;H[c+216>>2]=0;H[c+160>>2]=0;H[c+172>>2]=0;H[c+176>>2]=0;q=c+192|0;fd(q,0,c+48|0,100,1e9);F[c+213|0]=1;b=H[c+164>>2];ae:{if(!b){break ae}b=Ad((b>>>3|0)+1|0,0);H[c+160>>2]=b;be:{if(!b){break be}b=Ij(H[f+36>>2]);H[c+216>>2]=b;if(!b){break be}b=(K[16164]/K[f+36>>2]|0)+1|0;if(b>>>0<=K[c+164>>2]){pu(c+152|0,b)}if(!k){H[c+180>>2]=29238;b=H[H[f+12>>2]+56>>2];ou(c+152|0,1,eb(b+32|0),eb(b+36|0));H[c+180>>2]=0}ce:{if(!n){break ce}if(I[f+17|0]){k=0;b=(l|0)>0?l:0;d=0;while(1){if((b|0)!=(d|0)){v=H[m+(d<<2)>>2];k=k>>>0>v>>>0?k:v;d=d+1|0;continue}break}b=eb(H[H[f+12>>2]+56>>2]+52|0);if((b|0)==(k|0)){break ce}H[c+36>>2]=b;H[c+32>>2]=k;Tc(c+152|0,24669,c+32|0);break ce}if(!eb(H[H[f+12>>2]+56>>2]- -64|0)){break ce}Tc(c+152|0,9430,0)}b=H[f+4>>2];d=H[b+36>>2];H[b+32>>2]=H[b+32>>2]&-2097153;H[b+36>>2]=d;d=0;while(1){k=H[c+168>>2];if(!(!k|(d|0)>=(l|0))){k=m+(d<<2)|0;b=H[k>>2];if(b){v=c+152|0;if(!(!n|(!I[f+17|0]|(b|0)==1))){Zg(c+152|0,b,1,0);b=H[k>>2]}Qo(v,b,c+40|0,-1,2147483647)}d=d+1|0;continue}break}b=H[f+4>>2];H[b+32>>2]=r;H[b+36>>2]=s;if(!n){break ae}d=1;while(1){if(!k|K[c+164>>2]<d>>>0){break ae}de:{if(Po(c+152|0,d)){break de}if(ja=(Ud(f,d)|0)==(d|0),ka=0,la=I[f+17|0],la?ja:ka){break de}H[c+16>>2]=d;Tc(c+152|0,14870,c+16|0)}ee:{if(!Po(c+152|0,d)){break ee}if((Ud(f,d)|0)!=(d|0)|!I[f+17|0]){break ee}H[c>>2]=d;Tc(c+152|0,15646,c)}d=d+1|0;k=H[c+168>>2];continue}}H[c+176>>2]=1}Mf(H[c+216>>2]);Wa(H[c+160>>2]);fe:{if(H[c+176>>2]){Nf(q);d=H[c+172>>2]+1|0;H[c+172>>2]=d;break fe}d=H[c+172>>2]}H[j+296>>2]=d;if(!d){Nf(q)}b=Wd(q);Ga=c+224|0;c=N(p,40)+o|0;dc(c);d=H[j+296>>2];if(d){if(!b){break d}d=d-1|0;f=H[h>>2];k=H[h+4>>2]-((d>>31)+(d>>>0>f>>>0)|0)|0;H[h>>2]=f-d;H[h+4>>2]=k;oe(c,b,-1,-1,1,3)}be(c,u);break f}d=td(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+12>>2]+40|0,H[g+16>>2],0);if(d){ge:{if(H[d+20>>2]!=H[d+24>>2]){break ge}b=qu(d);if(!b){break ge}c=b+56|0;while(1){b=c;f=H[b>>2];if(!f){break ge}c=f+32|0;if((d|0)!=(f|0)){continue}break}H[b>>2]=H[d+32>>2]}ri(i,d);H[i+24>>2]=H[i+24>>2]|1}break e}d=td(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+12>>2]+24|0,H[g+16>>2],0);if(d){b=H[d+12>>2];c=H[b+8>>2];he:{ie:{if((d|0)==(c|0)){b=b+8|0;break ie}while(1){b=c;if(!b){break he}c=H[b+20>>2];if((d|0)!=(c|0)){continue}break}b=b+20|0}H[b>>2]=H[d+20>>2]}wl(i,d)}H[i+24>>2]=H[i+24>>2]|1;break e}ie(i,td(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+12>>2]+8|0,H[g+16>>2],0));H[i+24>>2]=H[i+24>>2]|1;break e}e=0;b=Pu(i,H[g+4>>2]);if(!b){break e}e=b;break c}e=H[g+4>>2];je:{ke:{if(!H[g+16>>2]){Dk(H[(H[i+16>>2]+(e<<4)|0)+12>>2]);H[i+24>>2]=H[i+24>>2]&-17;c=Hp(i,e,y,J[g+2>>1]);H[i+24>>2]=H[i+24>>2]|1;F[a+150|0]=I[a+150|0]&252;break ke}H[j+296>>2]=i;H[j+312>>2]=0;H[j+300>>2]=y;H[j+304>>2]=e;e=H[i+16>>2]+(e<<4)|0;ja=j,ka=Kh(H[e+4>>2]),H[ja+320>>2]=ka;e=H[e>>2];H[j+152>>2]=H[g+16>>2];H[j+148>>2]=8658;H[j+144>>2]=e;e=tb(i,14265,j+144|0);if(!e){c=7;break je}F[i+177|0]=1;H[j+316>>2]=0;H[j+308>>2]=0;b=Re(i,e,5,j+296|0,0);c=b?b:H[j+308>>2];if(!(c|H[j+316>>2])){c=ab(95070)}$b(i,e);F[i+177|0]=0}if(!c){break u}}Yf(i);e=c;if((c|0)!=7){break c}break d}F[i+96|0]=I[i+96|0]+1;e=0;b=Re(i,H[g+16>>2],0,0,0);F[i+96|0]=I[i+96|0]-1;if(!b){break e}e=b;break c}e=0;c=Ec(a,g);H[j+296>>2]=0;b=Nu(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2],j+296|0,H[g+12>>2]);if(!b){H[c>>2]=H[j+296>>2];H[c+4>>2]=0;break e}e=b;break c}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=H[c+36>>2];if(I[c|0]==1){dv(i,b);break e}e=0;b=Cl(H[b+8>>2],H[b+64>>2],0);if(!b){break e}e=b;break c}H[j+296>>2]=0;H[j+300>>2]=0;b=Cl(H[(H[i+16>>2]+(H[g+8>>2]<<4)|0)+4>>2],H[g+4>>2],j+296|0);c=H[g+12>>2];le:{if(!c){break le}k=H[j+300>>2];h=k+H[a+44>>2]|0;e=H[j+296>>2];f=H[a+40>>2];d=e+f|0;H[a+40>>2]=d;H[a+44>>2]=d>>>0<f>>>0?h+1|0:h;if((c|0)<=0){break le}c=N(c,40)+o|0;h=k+H[c+4>>2]|0;d=e+H[c>>2]|0;h=d>>>0<e>>>0?h+1|0:h;H[c>>2]=d;H[c+4>>2]=h}e=0;if(!b){break e}e=b;break c}h=Ec(a,g);G[h+16>>1]=1;me:{if(H[i+188>>2]>(H[i+200>>2]+1|0)){F[a+146|0]=2;f=6;break me}l=H[g+12>>2];H[j+296>>2]=0;c=H[g+4>>2];d=H[(H[i+16>>2]+(l<<4)|0)+4>>2];Jb(d);e=Ga-16|0;Ga=e;H[e+8>>2]=0;b=H[d+4>>2];ne:{if(c>>>0>K[b+48>>2]){f=ab(76777);break ne}f=Cl(d,c,0);if(f){break ne}f=xd(b,c,e+8|0,0);H[e+12>>2]=f;if(f){Gb(H[e+8>>2]);break ne}H[j+296>>2]=0;if(I[b+17|0]){Wh(d,4,e+4|0);k=H[e+4>>2];oe:{if((c|0)==(k|0)){c=H[e+8>>2];Sh(c,e+12|0);Gb(c);f=H[e+12>>2];if(!f){break oe}break ne}Gb(H[e+8>>2]);f=xd(b,k,e,0);if(f){break ne}m=H[e>>2];f=ep(b,m,1,0,c,0);Gb(m);if(f){break ne}H[e>>2]=0;ja=e,ka=xd(b,k,e,0),H[ja+12>>2]=ka;c=H[e>>2];Sh(c,e+12|0);Gb(c);f=H[e+12>>2];if(f){break ne}H[j+296>>2]=k}c=(K[16164]/K[b+36>>2]|0)+2|0;while(1){f=(c|0)==(k|0);k=k-1|0;if(f){continue}if((Ud(b,k)|0)==(k|0)){continue}break}f=Nk(d,4,k);break ne}b=H[e+8>>2];Sh(b,e+12|0);Gb(b);f=H[e+12>>2]}Ga=e+16|0;G[h+16>>1]=4;e=H[j+296>>2];H[h>>2]=e;H[h+4>>2]=e>>31;if(f){break me}if(!e){break u}b=H[g+4>>2];d=H[(H[i+16>>2]+(l<<4)|0)+12>>2];c=d+16|0;while(1){c=H[c>>2];if(c){f=H[c+8>>2];if((e|0)!=H[f+20>>2]){continue}H[f+20>>2]=b;continue}break}c=d+32|0;while(1){c=H[c>>2];if(c){d=H[c+8>>2];if((e|0)!=H[d+44>>2]){continue}H[d+44>>2]=b;continue}break}_=l+1|0;break u}e=f;break c}e=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];H[j+256>>2]=H[e+40>>2];b=H[g+16>>2];F[j+278|0]=c>>>0<41?-1:0;G[j+276>>1]=b;H[j+260>>2]=N(H[g+12>>2],40)+o;pe:{e=H[e+36>>2];b=Ai(e);if((b|0)<=0){c=ab(94818);break pe}c=j+296|0;$h(c,i,0);c=dk(e,b,c);if(c){break pe}e=0;b=_h(H[j+308>>2],H[j+304>>2],j+256|0,0);Zh(j+296|0);if(((F[g|0]&1?0-b|0:b+1|0)|0)>0){break h}break e}e=c;break c}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(!I[b+3|0]){break e}e=0;b=Vu(b);if(!b){break e}e=b;break c}qe:{b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];e=Mu(b);if(e){break qe}if(!I[b+2|0]){H[j+296>>2]=0;H[j+300>>2]=0;e=Ga-96|0;Ga=e;c=H[b+36>>2];d=Ai(c);f=e+48|0;$h(f,i,0);c=dk(c,d,f);re:{if(c){break re}f=H[e+56>>2];d=F[f|0];c=d&255;H[e+92>>2]=c;if((d|0)<0){$d(f,e+92|0);c=H[e+92>>2]}se:{if(c>>>0<3){break se}h=H[e+60>>2];if(h>>>0<c>>>0){break se}k=(c+f|0)-1|0;l=F[k|0];d=l&255;H[e+88>>2]=d;if((l|0)<0){$d(k,e+88|0);d=H[e+88>>2]}if((d|0)==7|d-10>>>0<4294967287){break se}m=c;c=I[d+32944|0];if(h>>>0<m+c>>>0){break se}qh(f+(h-c|0)|0,d,e+8|0);c=H[e+12>>2];H[j+296>>2]=H[e+8>>2];H[j+300>>2]=c;Zh(e+48|0);c=0;break re}Zh(e+48|0);c=ab(85711)}Ga=e+96|0;e=c;if(c){break qe}if(I[g|0]==141){e=H[H[a+96>>2]+(H[g+12>>2]<<2)>>2];F[e+2|0]=0;c=H[j+300>>2];d=H[j+296>>2];H[e+24>>2]=0;F[e+3|0]=1;H[e+56>>2]=d;H[e+60>>2]=c;c=H[g+16>>2];H[e+32>>2]=b;H[e+8>>2]=c;break u}e=Ec(a,g);b=H[j+300>>2];H[e>>2]=H[j+296>>2];H[e+4>>2]=b;break u}dc(N(H[g+8>>2],40)+o|0);break u}break c}e=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=H[e+36>>2];H[j+296>>2]=H[e+40>>2];c=H[g+12>>2];F[j+318|0]=0;G[j+316>>1]=c;H[j+300>>2]=N(H[g+8>>2],40)+o;te:{d=Yh(b,j+296|0,j+256|0);ue:{if(d){break ue}if(!H[j+256>>2]){d=Lu(b,4);if(d){break ue}break te}if(!J[g+2>>1]){break te}if(Jf(i)){break te}d=779;om(779,94613,9639)}e=d;break c}H[e+24>>2]=0;H[e+28>>2]=0;break u}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];ve:{q=N(H[g+8>>2],40)+o|0;if(!(I[q+17|0]&4)){break ve}e=Ce(q);if(!e){break ve}break c}e=0;l=0;p=Ga-16|0;Ga=p;d=H[b+36>>2];b=H[q+8>>2];c=F[b+1|0];f=c&255;H[p+12>>2]=f;if((c|0)<0){$d(b+1|0,p+12|0);f=H[p+12>>2]}we:{if(!((f|0)==7|f-1>>>0>8)){F[d+60|0]=F[d+60|0]&1;break we}if(!(!(f&1)|(f|0)<11)){F[d+60|0]=I[d+60|0]&2;break we}F[d+60|0]=0}r=H[q+12>>2];b=r+8|0;c=Vh(r,r>>31)+r|0;f=H[d+4>>2];xe:{if(!f){break xe}ye:{if(H[d+40>>2]){h=H[d+48>>2];if(!h){break xe}if((f|0)<(b+h|0)){break ye}break xe}h=f;f=H[d+44>>2];if((h|0)<(f|0)){break ye}if(!H[17530]|(f|0)<=H[d>>2]){break xe}}l=vu(d);H[d+44>>2]=0;H[d+48>>2]=0}H[d+44>>2]=c+H[d+44>>2];if((c|0)>H[d+8>>2]){H[d+8>>2]=c}ze:{Ae:{k=H[d+40>>2];Be:{if(k){n=H[d+48>>2];c=b+n|0;m=H[d+52>>2];if((c|0)>(m|0)){n=H[d+36>>2];s=n-k|0;f=c>>31;b=m>>31;while(1){h=b<<1|m>>>31;m=m<<1;b=h;if(c>>>0>m>>>0&(f|0)>=(b|0)|(b|0)<(f|0)){continue}break}w=k;k=H[d+4>>2];h=k>>31;D=k;k=(b|0)<=(h|0)&k>>>0>m>>>0|(b|0)<(h|0);m=k?m:D;D=c;b=k?b:h;c=c>>>0<m>>>0&(f|0)<=(b|0)|(b|0)>(f|0);h=c?m:D;k=Zd(w,h,c?b:f);if(!k){break Ae}b=n?s:-1;if((b|0)>=0){H[d+36>>2]=b+k}H[d+52>>2]=h;H[d+40>>2]=k;n=H[d+48>>2]}H[d+48>>2]=(r+15&-8)+n;f=k+n|0;b=H[d+36>>2];if(!b){break Be}H[f+4>>2]=b-k;break Be}f=xc(b,b>>31);if(!f){break Ae}H[f+4>>2]=H[d+36>>2]}Ya(f+8|0,H[q+8>>2],H[q+12>>2]);H[f>>2]=H[q+12>>2];H[d+36>>2]=f;break ze}l=7}Ga=p+16|0;if(!l){break e}e=l;break c}f=H[g+8>>2];d=N(f,40)+o|0;c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];e=J[g+2>>1];if(e&1){b=H[a+44>>2];h=H[a+40>>2]+1|0;b=h?b:b+1|0;H[a+40>>2]=h;H[a+44>>2]=b}Ce:{if(I[d+17|0]&4){e=Ce(d);if(e){break Ce}e=J[g+2>>1]}b=N(f,40)+o|0;d=H[b+12>>2];H[j+304>>2]=d;H[j+308>>2]=d>>31;H[j+296>>2]=H[b+8>>2];H[j+316>>2]=N(H[g+12>>2],40)+o;G[j+320>>1]=H[g+16>>2];e=Ku(H[c+36>>2],j+296|0,e&138,e&16?H[c+28>>2]:0);H[c+24>>2]=0;if(!e){break u}}break c}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=ek(H[c+36>>2]);break va}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=Bl(H[c+36>>2]);break va}d=Ga-16|0;Ga=d;c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];e=H[c+36>>2];De:{if(I[e+56|0]){H[d+12>>2]=0;e=uu(H[e+20>>2],d+12|0);b=e?e:H[d+12>>2]?101:e;break De}b=H[e+36>>2];H[e+36>>2]=H[b+4>>2];H[b+4>>2]=0;if(!H[e+40>>2]){bp(i,b)}b=H[e+36>>2]?0:101}Ga=d+16|0}e=0;H[c+24>>2]=0;if((b|0)!=101){if(b){e=b;break c}F[c+2|0]=0;b=(J[g+2>>1]<<2)+a|0;H[b+160>>2]=H[b+160>>2]+1;break g}F[c+2|0]=1;break f}H[a+168>>2]=H[a+168>>2]+1}p=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];H[j+296>>2]=1;Ee:{if(I[p|0]==1){e=H[p+36>>2];if(!I[e+56|0]){if(H[e+36>>2]){H[j+296>>2]=0;e=wu(e- -64|0,e+36|0);break Ee}H[j+296>>2]=1;e=0;break Ee}b=vu(e);if(b){e=b}else{k=0;n=0;O=0;s=Ga-16|0;Ga=s;H[s+12>>2]=0;c=e;e=0;q=Ga-32|0;Ga=q;while(1){Fe:{Ge:{He:{if(!k){if(I[c+59|0]<=n>>>0){break He}H[q+28>>2]=0;f=c+N(n,72)|0;D=f;k=H[f+92>>2];l=k>>31;m=16;b=0;d=0;while(1){if((b|0)<=(l|0)&k>>>0>m>>>0|(b|0)<(l|0)){d=d+1|0;h=b<<4|m>>>28;m=m<<4;b=h;continue}break}b=d;H[q+16>>2]=0;H[q+20>>2]=0;v=f- -64|0;if((k|0)<=16){k=Pt(v,k,q+16|0,q+28|0);break Ge}f=Bo(16);H[q+28>>2]=f;d=0;k=f?0:7;l=0;while(1){h=H[D+92>>2];if((h|0)<=(d|0)|k){break Ge}H[q+12>>2]=0;h=h-d|0;k=Pt(v,(h|0)<16?h:16,q+16|0,q+12|0);if(!k){k=f;A=Ga-16|0;Ga=A;w=1;C=(b|0)>1?b:1;m=Ot(v,H[q+12>>2],A+12|0);r=1;h=1;while(1){if((r|0)==(C|0)){while(1){if(!((b|0)<=(w|0)|m)){C=H[k+12>>2]+N(((l|0)/(h|0)|0)%16|0,56)|0;r=H[C+48>>2];Ie:{if(!r){m=Bo(16);if(!m){m=7;break Ie}m=Ot(v,m,C+48|0);if(m){break Ie}r=H[C+48>>2]}h=(h|0)/16|0;k=H[r+4>>2];m=0}w=w+1|0;continue}break}h=H[A+12>>2];Je:{if(!m){H[(H[k+12>>2]+N((l|0)%16|0,56)|0)+48>>2]=h;break Je}bv(h)}Ga=A+16|0}else{r=r+1|0;h=h<<4;continue}break}k=m;l=l+1|0}d=d+16|0;continue}}ah(e);e=0}H[s+12>>2]=e;Ga=q+32|0;e=k;break Fe}b=H[q+28>>2];Ke:{if(!k){e=b;break Ke}ah(b)}n=n+1|0;continue}break}Le:{Me:{if(e){O=H[s+12>>2];break Me}b=H[s+12>>2];e=Ut(c- -64|0,b);H[c+20>>2]=b;if(e){break Me}e=0;break Le}ah(O)}Ga=s+16|0;H[j+296>>2]=0}break Ee}e=Bx(H[p+36>>2],j+296|0);H[p+24>>2]=0;F[p+3|0]=0}if(!e){b=H[j+296>>2];F[p+2|0]=b;e=0;if(b){break h}break e}break c}b=H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2];e=Bx(b,j+296|0);if(!e){if(H[j+296>>2]){break X}e=Ju(b);b=Ja;if((b|0)<0){break u}if(H[g+12>>2]>(je(e,b)|0)){break X}break u}break c}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];d=H[b+36>>2];H[j+296>>2]=0;if((c|0)==137){H[b+28>>2]=-1;if(Iu(d)){break e}}e=_o(d,j+296|0);c=H[j+296>>2];H[b+24>>2]=0;F[b+3|0]=0;F[b+2|0]=c;if(!e){e=0;if(H[g+8>>2]<=0){break e}if(c){break X}break e}break c}b=H[g+4>>2];c=H[H[a+96>>2]+(b<<2)>>2];if(!c){c=_g(a,b,1,3);if(!c){break d}F[c+4|0]=1;H[c+28>>2]=0;H[c+36>>2]=70620;F[c+5|0]=I[c+5|0]|8}H[c+24>>2]=0;F[c+2|0]=1;if(I[c|0]){break e}Gl(H[c+36>>2]);break e}b=Ec(a,g);c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(I[c+2|0]){G[b+16>>1]=1;break e}Ne:{Oe:{if(I[c+3|0]){d=H[c+56>>2];c=H[c+60>>2];break Oe}if(I[c|0]==2){e=H[c+36>>2];c=H[e>>2];e=Ka[H[H[c>>2]+48>>2]](e,j+296|0)|0;Hf(a,c);if(e){break Ne}e=0;d=H[j+296>>2];c=H[j+300>>2];break Oe}e=Mu(c);if(e){break Ne}if(I[c+2|0]){G[b+16>>1]=1;break u}e=0;d=Kl(H[c+36>>2]);c=Ja}H[b>>2]=d;H[b+4>>2]=c;break e}break c}b=Ec(a,g);c=H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2];e=Ai(c);if(e>>>0>K[i+120>>2]){break t}e=dk(c,e,b);if(e){break c}e=0;if(H[g+12>>2]|!(I[b+17|0]&64)){break e}if(!Fg(b)){break e}break d}e=N(H[g+8>>2],40)+o|0;b=Ga-16|0;Ga=b;d=7;f=xu(H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2],b+12|0);c=H[b+12>>2];if(!Bi(e,c)){H[e+12>>2]=c;G[e+16>>1]=J[e+16>>1]&62016|16;Ya(H[e+8>>2],f,c);d=0}Ga=b+16|0;e=d;if(d){break c}e=0;H[H[H[a+96>>2]+(H[g+12>>2]<<2)>>2]+24>>2]=0;break e}e=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=H[g+16>>2];x=H[g+12>>2];H[j+296>>2]=0;h=N(x,40)+o|0;f=Ga-16|0;Ga=f;d=H[e+40>>2];k=H[e+36>>2];c=H[k+32>>2];Pe:{if(!c){c=Al(d);H[k+32>>2]=c;e=7;if(!c){break Pe}G[c+20>>1]=b}e=xu(k,f+12|0);Bj(d,H[f+12>>2],e,c);d=0;e=(b|0)>0?b:0;Qe:{Re:{while(1){if((d|0)==(e|0)){break Re}b=N(d,40);d=d+1|0;if(!(F[(b+H[c+4>>2]|0)+16|0]&1)){continue}break}b=-1;break Qe}b=yj(H[h+12>>2],H[h+8>>2],c)}H[j+296>>2]=b;e=0}Ga=f+16|0;switch((e?12:H[j+296>>2]?13:7)-7|0){case 0:break e;case 6:break h;case 5:break c;default:break a}}cp(i,H[a+40>>2],H[a+44>>2]);H[a+40>>2]=0;H[a+44>>2]=0;break e}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=H[g+8>>2];d=0;Se:{if(I[g+1|0]!=251){k=0;break Se}k=0;if(!H[i+248>>2]){break Se}k=H[H[i+16>>2]+(F[c+1|0]<<4)>>2];d=H[g+16>>2];if(!(I[g+2|0]&2)|!I[c+4|0]){break Se}ja=c,ka=Kl(H[c+36>>2]),H[ja+56>>2]=ka;H[c+60>>2]=Ja}e=Lu(H[c+36>>2],I[g+2|0]);H[c+24>>2]=0;H[c+28>>2]=0;if(e){break c}e=0;if(!(b&1)){break e}b=H[a+44>>2];f=H[a+40>>2]+1|0;b=f?b:b+1|0;H[a+40>>2]=f;H[a+44>>2]=b;b=H[i+248>>2];if(I[d+28|0]&128|(!b|!d)){break e}Ka[b|0](H[i+244>>2],9,k,H[d>>2],H[c+56>>2],H[c+60>>2]);break e}e=0;b=H[a+96>>2];h=H[H[b+(H[g+4>>2]<<2)>>2]+36>>2];s=H[H[b+(H[g+8>>2]<<2)>>2]+36>>2];b=H[g+12>>2];if(b){c=N(b,40)+o|0;b=H[c>>2];c=H[c+4>>2]}else{b=0;c=0}r=0;p=Ga-16|0;Ga=p;H[p+12>>2]=0;q=H[h+20>>2];d=H[q+84>>2];ii(s);f=H[s+44>>2];Te:{if(f>>>0<=127){F[d|0]=f;f=d+1|0;break Te}f=Gf(d,f,0)+d|0}if(!H[h+112>>2]){f=Gf(f,b,c)+f|0}d=J[s+48>>1];m=H[s+40>>2];n=d+m|0;v=H[H[s+116>>2]+60>>2];Ue:{if(n>>>0>v>>>0){n=ab(76188);break Ue}k=H[s+44>>2];l=H[h+116>>2];if(!((k|0)!=(d|0)|J[l+14>>1]<=d>>>0)){ja=q,ka=(Ya(f,m,d)+d|0)-H[q+84>>2]|0,H[ja+88>>2]=ka;n=0;break Ue}w=H[H[s+20>>2]>>2];H[p+8>>2]=0;h=k;A=J[l+14>>1];Ve:{if(A>>>0>=h>>>0){break Ve}b=J[l+16>>1];h=b;c=k;c=UK(c-b|0,0-(b>>>0>c>>>0)|0,H[H[l+52>>2]+40>>2]-4|0,0)+b|0;b=c;h=(b|0)>(A|0)?h:b}b=h+(f-H[q+84>>2]|0)|0;l=b+4|0;c=b;b=h>>>0<k>>>0;H[q+88>>2]=b?l:c;We:{if(d>>>0<k>>>0){if(v>>>0<n+4>>>0){break We}r=eb(n)}c=b?f+h|0:0;l=0;while(1){k=k-h|0;while(1){if(d){b=d>>>0>h>>>0?h:d;f=Ya(f,m,b);m=b+m|0;f=b+f|0;h=h-b|0;d=d-b|0}else{d=0}Xe:{if(!h){n=H[p+12>>2];b=!n;break Xe}rd(H[p+8>>2]);b=0;H[p+8>>2]=0;n=sd(w,r,p+8|0,2);H[p+12>>2]=n;if(n){break Xe}b=H[H[p+8>>2]+4>>2];m=b+4|0;r=eb(b);d=H[H[s+20>>2]+40>>2]-4|0;continue}break}if(!(!c|(!b|!k))){H[p>>2]=0;ja=p,ka=If(q,p,p+4|0,0,0),H[ja+12>>2]=ka;Cb(c,H[p+4>>2]);if(!(!I[q+17|0]|!l)){Jd(q,H[p+4>>2],4,H[l+4>>2],p+12|0)}Gb(l);l=H[p>>2];if(l){c=H[l+56>>2];Cb(c,0);b=H[q+40>>2]-4|0;h=b>>>0<k>>>0?b:k;f=c+4|0}n=H[p+12>>2]}if(n?0:k){continue}break}Gb(l);rd(H[p+8>>2]);break Ue}n=ab(76211)}Ga=p+16|0;if(!n){break e}e=n;break c}k=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];m=H[g+8>>2];e=N(H[g+12>>2],40)+o|0;c=H[e+4>>2];n=H[e>>2];H[j+304>>2]=n;H[j+308>>2]=c;f=0;d=0;Ye:{if(I[g+1|0]!=251){break Ye}d=0;if(!H[i+248>>2]){break Ye}f=H[g+16>>2];d=H[H[i+16>>2]+(F[k+1|0]<<4)>>2]}e=J[g+2>>1];if(e&1){b=H[a+44>>2];h=H[a+40>>2]+1|0;b=h?b:b+1|0;H[a+40>>2]=h;H[a+44>>2]=b}if(e&32){H[i+40>>2]=n;H[i+44>>2]=c}b=N(m,40)+o|0;H[j+312>>2]=H[b+8>>2];H[j+324>>2]=H[b+12>>2];l=0;h=0;h=e&16?H[k+28>>2]:h;l=I[b+17|0]&4?H[N(m,40)+o>>2]:l;H[j+296>>2]=0;H[j+328>>2]=l;e=Ku(H[k+36>>2],j+296|0,e&138,h);H[k+24>>2]=0;F[k+3|0]=0;if(!e){if(!f){break u}Ka[H[i+248>>2]](H[i+244>>2],J[g+2>>1]&4?23:18,d,H[f>>2],n,c);break u}break c}H[j+296>>2]=0;H[j+300>>2]=0;H[j+256>>2]=0;k=Ec(a,g);f=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];Ze:{if(!(I[f+5|0]&2)){d=_o(H[f+36>>2],j+256|0);if(d){break Ze}_e:{if(H[j+256>>2]){H[j+296>>2]=1;H[j+300>>2]=0;break _e}e=Kl(H[f+36>>2]);b=Ja;h=b;H[j+296>>2]=e;H[j+300>>2]=b;if((e|0)==-1&(b|0)==2147483647){F[f+5|0]=I[f+5|0]|2;break _e}e=e+1|0;h=e?h:h+1|0;H[j+296>>2]=e;H[j+300>>2]=h}e=0}d=H[g+12>>2];if(d){c=H[Q>>2];if(c){while(1){b=c;c=H[b+4>>2];if(c){continue}break}b=H[b+16>>2]}else{b=o}h=b+N(d,40)|0;di(h);d=13;l=H[h>>2];b=H[h+4>>2];if((l|0)==-1&(b|0)==2147483647|I[f+5|0]&2){break Ze}q=H[j+300>>2];d=q;c=H[j+296>>2];if((d|0)<=(b|0)&c>>>0<=l>>>0|(b|0)>(d|0)){c=l+1|0;b=c?b:b+1|0;H[j+296>>2]=c;q=b;H[j+300>>2]=b}H[h>>2]=c;H[h+4>>2]=q}$e:{if(I[f+5|0]&2){c=0;while(1){af:{Oe(8,j+296|0);d=H[j+300>>2]&1073741823;e=H[j+296>>2]+1|0;d=e?d:d+1|0;H[j+296>>2]=e;H[j+300>>2]=d;b=Xh(H[f+36>>2],e,d,0,j+256|0);d=H[j+256>>2];if(b|d){break af}e=c>>>0<99;c=c+1|0;if(e){continue}}break}if(b){break $e}e=0;if(!d){break $e}}H[f+24>>2]=0;F[f+3|0]=0;b=H[j+300>>2];H[k>>2]=H[j+296>>2];H[k+4>>2]=b;break e}d=b?b:13}e=d;break c}f=Ec(a,g);d=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=d;c=H[b+20>>2];d=b;b=c;h=H[d+16>>2];k=h+1|0;b=k?b:b+1|0;H[d+16>>2]=k;H[d+20>>2]=b;H[f>>2]=h;H[f+4>>2]=c;break e}c=H[g+12>>2];break da}c=H[g+12>>2];b=N(c,40)+o|0;if(I[b+16|0]&36){break da}c=j+296|0;Ya(c,b,40);ci(c,67,u);if(!(J[j+312>>1]&4)){break h}b=H[j+296>>2];f=H[j+300>>2];break ca}e=N(c,40)+o|0;b=H[e>>2];f=H[e+4>>2]}c=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];d=H[c+36>>2];e=0;H[j+292>>2]=0;d=Xh(d,b,f,0,j+292|0);H[c+24>>2]=0;H[c+56>>2]=b;H[c+60>>2]=f;G[c+2>>1]=0;b=H[j+292>>2];H[c+28>>2]=b;if(b){if(H[g+8>>2]){e=d;break h}d=ab(93552)}if(!d){break e}e=d;break c}if(H[g+16>>2]<=J[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+6>>1]){break e}}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];e=N(H[g+12>>2],40)+o|0;H[j+300>>2]=e;c=H[g+16>>2];G[j+316>>1]=c;bf:{if(c&65535){e=H[b+40>>2];F[j+318|0]=0;H[j+296>>2]=e;e=Yh(H[b+36>>2],j+296|0,b+28|0);break bf}if(I[e+17|0]&4){if(Ce(e)){break d}}c=Al(H[b+40>>2]);if(!c){break d}e=H[j+300>>2];Bj(H[b+40>>2],H[e+12>>2],H[e+8>>2],c);F[c+22|0]=0;e=Yh(H[b+36>>2],c,b+28|0);$b(i,c)}if(!e){H[b+24>>2]=0;F[b+3|0]=0;e=H[b+28>>2];F[b+2|0]=(e|0)!=0;c=I[g|0];if((c|0)==28){if(!e){break X}break u}if(e){break X}cf:{switch(c-25|0){case 1:c=0;e=H[j+300>>2];b=J[j+316>>1];while(1){if((b|0)==(c|0)){break u}d=N(c,40);c=c+1|0;if(!(F[(d+e|0)+16|0]&1)){continue}break};break X;case 0:break cf;default:break u}}G[b+6>>1]=H[g+16>>2];break u}break c}if(!H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]){break g}break e}c=H[g+8>>2];b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];d=J[b+6>>1];if((c|0)>(d|0)){G[b+6>>1]=c;break e}c=H[g+12>>2];if((c|0)>=(d|0)){break e}G[b+6>>1]=c;break e}b=H[H[a+96>>2]+(H[g+24>>2]<<2)>>2];if(!Iu(H[b+36>>2])){break e}k=g+20|0;c=H[g+4>>2];H[j+296>>2]=H[b+40>>2];e=H[g+36>>2];F[j+318|0]=0;G[j+316>>1]=e;e=H[g+32>>2];H[j+256>>2]=0;H[j+300>>2]=N(e,40)+o;df:{ef:{while(1){d=j+296|0;e=Ga-48|0;Ga=e;f=H[b+36>>2];h=Ai(f);ff:{if((h|0)<=0){H[j+256>>2]=0;f=ab(85744);break ff}l=e+8|0;$h(l,i,0);f=dk(f,h,l);if(f){break ff}f=0;ja=j,ka=_h(H[e+20>>2],H[e+16>>2],d,0),H[ja+256>>2]=ka;Zh(e+8|0)}Ga=e+48|0;if(f){break df}e=0;d=H[j+256>>2];if((d|0)>0){break ef}if(!d){k=g;break ef}if((c|0)<=0){break I}c=c-1|0;f=ek(H[b+36>>2]);if(!f){continue}break}if((f|0)!=101){break df}}g=k;break h}e=f;break c}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];H[b+24>>2]=0;G[b+2>>1]=0;gf:{hf:{jf:{kf:{if(I[b+4|0]){d=N(H[g+12>>2],40)+o|0;l=J[d+16>>1];if((l&46)==2){ak(d,0)}h=ac(d);k=Ja;f=J[d+16>>1];G[d+16>>1]=l;lf:{if(f&36){break lf}if(!(f&8)){if(f&1|c>>>0>=22){break h}h=0;e=_o(H[b+36>>2],j+256|0);if(e){break c}break jf}e=Aj(h,k,M[d>>3]);if((e|0)>0){c=c&254;break lf}c=(!(c&1)&(e|0)!=0)+c|0}f=0;e=Xh(H[b+36>>2],h,k,0,j+256|0);H[b+56>>2]=h;H[b+60>>2]=k;if(!e){break kf}break c}h=1;e=H[b+36>>2];f=I[e+3|0]>>>1&1;d=H[b+40>>2];k=H[g+16>>2];F[j+318|0]=c&1?-1:1;G[j+316>>1]=k;H[j+296>>2]=d;d=H[g+12>>2];F[j+322|0]=0;H[j+300>>2]=N(d,40)+o;e=Yh(e,j+296|0,j+256|0);if(e){break c}if(!f){break kf}if(!I[j+322|0]){break jf}}e=H[j+256>>2];if(c>>>0>=22){if(e|(c|0)!=23?(e|0)>=0:0){break gf}e=ek(H[b+36>>2]);if(!e){break gf}if((e|0)!=101){break c}break X}if(!(e|(c|0)!=20?(e|0)<=0:0)){e=Bl(H[b+36>>2]);if(!e){break gf}if((e|0)!=101){break c}break X}b=lm(H[b+36>>2]);break hf}f=h;b=H[j+256>>2]}if(b){break X}}g=N(f,20)+g|0;break u}e=0;break h}b=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(b){El(a,b)}H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]=0;break e}b=_g(a,H[g+4>>2],H[g+12>>2],3);if(!b){break d}F[b+2|0]=1;c=H[g+8>>2];H[b+36>>2]=70620;F[b+4|0]=1;H[b+28>>2]=c;break e}d=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];b=d;c=H[b+20>>2];d=b;b=c;f=H[d+16>>2];h=f+1|0;b=h?b:b+1|0;H[d+16>>2]=h;H[d+20>>2]=b;if(!(c|f)){break h}break e}b=_g(a,H[g+4>>2],H[g+8>>2],1);if(!b){break d}H[b+40>>2]=H[g+16>>2];e=0;d=H[g+12>>2];k=J[H[b+40>>2]+6>>1]<<2;c=yb(i,k+156|0,0);H[b+36>>2]=c;h=7;if(c){f=H[H[i+16>>2]+4>>2];h=c+136|0;H[c+28>>2]=h;Ya(h,H[b+40>>2],k+20|0);h=0;H[c+148>>2]=0;if(d){G[c+142>>1]=d}Jb(f);b=df(f);F[c+59|0]=1;H[c+12>>2]=b;F[c+57|0]=0;F[c+58|0]=255;H[c+72>>2]=c;H[c+24>>2]=i;mf:{if(Er(i)){break mf}d=N(b,H[16051]);H[c>>2]=d;l=H[H[H[i+16>>2]+12>>2]+80>>2];f=l>>31;m=(f|0)<0;k=b>>31;f=SK(m?-1024:b,m?-1:k,l,f);m=f;l=f>>>0<536870912;f=Ja;f=l&(f|0)<=0|(f|0)<0?m:536870912;H[c+4>>2]=(d|0)>(f|0)?d:f;if(I[64008]){break mf}H[c+52>>2]=b;b=xc(b,k);H[c+40>>2]=b;h=b?0:7}nf:{if(J[c+144>>1]>12){break nf}b=H[c+156>>2];if(I[H[c+152>>2]]&2|((b|0)!=H[i+8>>2]?b:0)){break nf}F[c+60|0]=3}}if(!h){break e}e=h;break c}e=H[g+12>>2];if((e|0)>0){e=N(e,40)+o|0;H[e+8>>2]=29357;H[e+12>>2]=0}of:{e=H[g+4>>2];c=H[H[a+96>>2]+(e<<2)>>2];if(!(!(!c|I[c+5|0]&8)&H[g+8>>2]<=G[c+52>>1])){c=_g(a,e,H[g+8>>2],0);if(!c){break d}F[c+5|0]=I[c+5|0]|1;e=Qj(H[i>>2],0,i,c+8|0,J[g+2>>1]|5,1054);if(e){break c}e=_f(H[c+8>>2],1,0);if(!e){b=H[g+16>>2];H[c+40>>2]=b;pf:{if(b){k=0;e=Nu(H[c+8>>2],c+48|0,J[g+2>>1]|2);if(e){break pf}e=zl(H[c+8>>2],H[c+48>>2],4,b,H[c+36>>2]);break pf}k=1;H[c+48>>2]=1;e=zl(H[c+8>>2],1,4,0,H[c+36>>2])}F[c+4|0]=k}F[c+5|0]=I[c+5|0]&251|(J[g+2>>1]!=8)<<2;if(!e){break of}Gg(H[c+8>>2]);break c}H[c+24>>2]=0;H[c+16>>2]=0;H[c+20>>2]=0;e=Cl(H[c+8>>2],H[c+48>>2],0);if(!e){break of}break c}F[c+2|0]=1;break u}b=H[H[a+96>>2]+(H[g+8>>2]<<2)>>2];e=_g(a,H[g+4>>2],G[b+52>>1],0);if(!e){break d}F[e+2|0]=1;c=I[e+5|0]|1;F[e+5|0]=c;H[e+40>>2]=H[b+40>>2];F[e+4|0]=I[b+4|0];H[e+48>>2]=H[b+48>>2];c=I[b+5|0]&4|c&-5;F[e+5|0]=c;d=H[b+8>>2];F[e+5|0]=c|8;H[e+8>>2]=d;F[b+5|0]=I[b+5|0]|8;e=zl(H[e+8>>2],H[e+48>>2],4,H[e+40>>2],H[e+36>>2]);break e}d=H[H[a+96>>2]+(H[g+4>>2]<<2)>>2];if(!d|H[d+48>>2]!=H[g+8>>2]){break P}Gl(H[d+36>>2]);f=e;break O}if((I[a+150|0]&3)==1){e=516;break c}h=H[g+12>>2];d=H[i+16>>2]+(h<<4)|0;k=H[d+4>>2];b=J[g+2>>1];e=H[g+8>>2];f=0;qf:{if((c|0)!=113){break qf}f=b&8|4;c=I[H[d+12>>2]+76|0];if(c>>>0>=I[a+147|0]){break qf}F[a+147|0]=c}if(b&16){e=N(e,40)+o|0;di(e);e=H[e>>2]}d=H[g+4>>2];l=I[g+1|0];rf:{if((l|0)!=253){c=0;b=0;if((l|0)!=248){break rf}c=H[g+16>>2];b=J[c+8>>1];break rf}c=0;b=H[g+16>>2]}d=_g(a,d,b,0);if(!d){break d}F[d+2|0]=1;F[d+1|0]=h;H[d+48>>2]=e;F[d+5|0]=I[d+5|0]|4;f=zl(k,e,f,c,H[d+36>>2]);H[d+40>>2]=c;F[d+4|0]=I[g+1|0]!=248}F[H[d+36>>2]+3|0]=J[g+2>>1]&3;e=0;if(!f){break e}e=f;break c}e=H[i+16>>2]+(H[g+4>>2]<<4)|0;b=Nk(H[e+4>>2],H[g+8>>2],H[g+12>>2]);sf:{tf:{switch(H[g+8>>2]-1|0){case 0:H[H[e+12>>2]>>2]=H[g+12>>2]-J[g+2>>1];H[i+24>>2]=H[i+24>>2]|1;d=H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+12>>2]+16|0;uf:while(1){d=H[d>>2];if(d){e=H[d+8>>2];if(I[e+43|0]){continue}e=e+48|0;while(1){e=H[e>>2];if(!e){continue uf}zj(i,H[e+28>>2]);H[e+28>>2]=0;zj(i,H[e+32>>2]);H[e+32>>2]=0;e=e+4|0;continue}}break};break sf;case 1:break tf;default:break sf}}F[H[e+12>>2]+76|0]=H[g+12>>2]}if(H[g+4>>2]==1){wg(i,0);F[a+150|0]=I[a+150|0]&252}e=0;if(!b){break e}e=b;break c}Wh(H[(H[i+16>>2]+(H[g+4>>2]<<4)|0)+4>>2],H[g+12>>2],j+296|0);b=Ec(a,g);c=H[j+296>>2];H[b>>2]=c;H[b+4>>2]=c>>31;break e}H[j+296>>2]=0;vf:{c=H[g+8>>2];if(!c){break vf}b=H[i+32>>2];if(!(b&1048576|H[i+36>>2]&2)){break vf}e=b&1048576?8:11;break c}f=H[i+16>>2];d=H[g+4>>2];b=H[(f+(d<<4)|0)+4>>2];wf:{if(b){x=_f(b,c,j+296|0);if(x){if((x&255)!=5){e=x;break c}H[a+36>>2]=x;H[a+32>>2]=(g-t|0)/20;break i}if(!(I[a+150|0]&32)|!H[g+8>>2]|(H[i+188>>2]<2?I[i+85|0]:0)){break wf}e=H[a+48>>2];if(!e){e=H[i+504>>2]+1|0;H[i+504>>2]=e;e=e+H[i+500>>2]|0;H[a+48>>2]=e}e=Dj(i,0,e-1|0);if(!e){e=H[a+48>>2];c=H[b+4>>2];Jb(b);e=yA(H[c>>2],e)}b=H[i+516>>2];H[a+72>>2]=H[i+512>>2];H[a+76>>2]=b;b=H[i+524>>2];H[a+80>>2]=H[i+520>>2];H[a+84>>2]=b}if(e){break c}}if(!J[g+2>>1]|H[j+296>>2]==H[g+12>>2]&H[H[(f+(d<<4)|0)+12>>2]+4>>2]==H[g+16>>2]){break u}_a(i,H[y>>2]);ja=y,ka=Xb(i,15609),H[ja>>2]=ka;e=H[g+4>>2];if(H[H[(H[i+16>>2]+(e<<4)|0)+12>>2]>>2]!=H[j+296>>2]){Xj(i,e)}F[a+150|0]=I[a+150|0]&236|1;e=17;break c}c=H[g+8>>2];b=H[g+4>>2];xf:{if((b|0)!=I[i+85|0]){yf:{if(c){Gi(i,516);c=1;break yf}if(!(!b|H[i+192>>2]<=0)){e=4041;b=5;break xf}x=Ej(a,1);if(x){break i}c=b}F[i+85|0]=c;x=5;if((rk(a)|0)==5){H[a+32>>2]=(g-t|0)/20;F[i+85|0]=1-b;break j}Dm(i);x=H[a+36>>2]?1:101;break i}e=b?c?12191:12150:9868;b=1}_c(a,e,0);e=b;break c}f=H[g+16>>2];d=0;c=V;zf:{k=H[g+4>>2];if(!k){if(H[i+192>>2]>0){_c(a,3936,0);e=5;break c}c=ib(f);b=Dj(i,0,H[i+500>>2]+H[i+504>>2]|0);if(b){e=b;break c}b=Tb(i,c+33|0,0);if(!b){break zf}d=b+32|0;H[b>>2]=d;Ya(d,f,c+1|0);Af:{if(I[i+85|0]){F[i+93|0]=1;F[i+85|0]=0;break Af}H[i+500>>2]=H[i+500>>2]+1}H[b+24>>2]=H[i+488>>2];H[i+488>>2]=b;c=H[i+516>>2];H[b+8>>2]=H[i+512>>2];H[b+12>>2]=c;c=H[i+524>>2];H[b+16>>2]=H[i+520>>2];H[b+20>>2]=c;break zf}Bf:{while(1){c=H[c>>2];if(c){if(!hb(H[c>>2],f)){break Bf}c=c+24|0;d=d+1|0;continue}break}H[j+128>>2]=f;_c(a,7105,j+128|0);e=1;break c}if(!((k|0)!=1|H[i+192>>2]<=0)){_c(a,3987,0);e=5;break c}q=0;n=0;Cf:{Df:{Ef:{Ff:{if(H[c+24>>2]){break Ff}b=I[i+93|0];n=(b|0)!=0;if(!b|(k|0)!=1){break Ff}x=Ej(a,1);if(x){break i}F[i+85|0]=1;x=5;if((rk(a)|0)==5){H[a+32>>2]=(g-t|0)/20;F[i+85|0]=0;break j}b=H[a+36>>2];if(!b){break Ef}F[i+85|0]=0;e=b;break c}l=H[i+500>>2];if((k|0)!=2){break Df}q=H[i+24>>2]&1;h=!q;f=0;while(1){if(H[i+20>>2]<=(f|0)){break Df}b=f<<4;e=0;f=f+1|0;b=jz(H[(b+H[i+16>>2]|0)+4>>2],516,h);if(!b){continue}break}e=b;break c}F[i+93|0]=0;n=1;break Cf}h=e;d=l+(d^-1)|0;f=0;Gf:{while(1){if(H[i+20>>2]<=(f|0)){break Gf}b=f<<4;h=0;f=f+1|0;b=ap(H[(b+H[i+16>>2]|0)+4>>2],k,d);if(!b){continue}break}e=b;break c}if(q){wg(i,0);Yf(i);H[i+24>>2]=H[i+24>>2]|1}if(!h){break Cf}e=h;break c}while(1){b=H[V>>2];if((b|0)!=(c|0)){H[i+488>>2]=H[b+24>>2];_a(i,b);H[i+500>>2]=H[i+500>>2]-1;continue}break}Hf:{If:{if((k|0)==1){H[i+488>>2]=H[c+24>>2];_a(i,c);if(n){break If}H[i+500>>2]=H[i+500>>2]-1;break Hf}b=H[c+12>>2];H[i+512>>2]=H[c+8>>2];H[i+516>>2]=b;b=H[c+20>>2];H[i+520>>2]=H[c+16>>2];H[i+524>>2]=b}if(!n){break Hf}if((k|0)!=2){break zf}}b=Dj(i,k,d);if(!b){break zf}e=b;break c}if(I[a+149|0]==3){break H}}e=0;break e}x=101;break i}c=H[H[H[a+96>>2]+(H[g+4>>2]<<2)>>2]+36>>2];Jf:{Kf:{if(H[g+12>>2]){m=Ju(c);H[j+296>>2]=m;b=Ja;H[j+300>>2]=b;break Kf}H[j+296>>2]=0;H[j+300>>2]=0;m=0;b=0;Lf:{Mf:{Nf:{e=c;c=ng(c);if((c|0)!=16){while(1){if(c){break Nf}if(H[i+296>>2]){break Mf}c=H[e+116>>2];Of:{if(!I[c+8|0]){d=J[c+24>>1];if(I[c+1|0]){break Of}k=d&65535;f=k+m|0;m=f;b=f>>>0<k>>>0?b+1|0:b;break Of}d=J[c+24>>1];c=d+m|0;m=c;b=c>>>0<d>>>0?b+1|0:b;while(1){if(!I[e+68|0]){H[j+296>>2]=m;H[j+300>>2]=b;c=ng(e);break Nf}Zo(e);c=H[e+116>>2];d=J[c+24>>1];f=J[e+70>>1];if(d>>>0<=f>>>0){continue}break}G[e+70>>1]=f+1}h=d;d=J[e+70>>1];Pf:{if((h|0)==(d|0)){c=eb((I[c+9|0]+H[c+56>>2]|0)+8|0);break Pf}h=H[c+56>>2];f=J[c+26>>1];c=H[c+64>>2]+(d<<1)|0;c=eb(h+(f&(I[c|0]<<8|I[c+1|0]))|0)}c=mg(e,c);continue}}H[j+296>>2]=0;H[j+300>>2]=0;break Mf}e=c;break Lf}e=0}if(e){break Jf}e=0;m=H[j+296>>2];b=H[j+300>>2]}c=Ec(a,g);H[c>>2]=m;H[c+4>>2]=b;break f}break c}k=N(H[g+4>>2],40)+o|0;h=k+N(H[g+8>>2],40)|0;s=H[g+12>>2];l=N(s,40);f=H[g+16>>2];if(f){d=I[f|0];c=k;while(1){ci(c,d<<24>>24,u);b=f;Qf:{if(I[b|0]!=69){break Qf}d=J[c+16>>1];if(!(d&4)){break Qf}G[c+16>>1]=d&65499|32}c=c+40|0;f=b+1|0;d=I[b+1|0];if(d){continue}break}}v=l+o|0;f=0;c=0;q=0;m=0;b=0;w=h-40|0;d=w;while(1){p=d;h=J[d+16>>1];Rf:{if(h&1){H[p+28>>2]=h<<21>>31&10;f=f+1|0;break Rf}if(h&36){f=f+1|0;l=H[p+4>>2];n=l;d=n>>31;r=H[p>>2];l=r^d;d=d^n;if(!d&l>>>0<=127){if(!(!n&r>>>0>1|(n|0)!=0|I[a+147|0]<4)){H[p+28>>2]=l+8;break Rf}H[p+28>>2]=1;d=m+1|0;b=d?b:b+1|0;m=d;break Rf}if(!d&l>>>0<=32767){H[p+28>>2]=2;h=b;b=m+2|0;h=b>>>0<2?h+1|0:h;m=b;b=h;break Rf}if(!d&l>>>0<=8388607){H[p+28>>2]=3;d=b;b=m+3|0;d=b>>>0<3?d+1|0:d;m=b;b=d;break Rf}if(!d&l>>>0<=2147483647){H[p+28>>2]=4;d=m+4|0;b=d>>>0<4?b+1|0:b;m=d;break Rf}if((d|0)==32767|d>>>0<32767){H[p+28>>2]=5;h=b;b=m+6|0;h=b>>>0<6?h+1|0:h;m=b;b=h;break Rf}d=b;b=m+8|0;d=b>>>0<8?d+1|0:d;m=b;b=d;if(h&32){H[p+28>>2]=7;M[p>>3]=+(r>>>0)+ +(n|0)*4294967296;G[p+16>>1]=h&65495|8;break Rf}H[p+28>>2]=6;break Rf}if(h&8){H[p+28>>2]=7;d=m+8|0;b=d>>>0<8?b+1|0:b;m=d;f=f+1|0;break Rf}n=H[p+12>>2];l=(h>>>1&1|n<<1)+12|0;Sf:{if(!(h&1024)){break Sf}d=H[p>>2];l=(d<<1)+l|0;if(b|m){if(Ce(p)){break d}n=H[p>>2]+n|0;break Sf}h=(d>>31)+q|0;c=c+d|0;h=c>>>0<d>>>0?h+1|0:h;q=h}H[p+28>>2]=l;d=m+n|0;b=d>>>0<n>>>0?b+1|0:b;m=d;f=Vh(l,0)+f|0}d=p-40|0;if((k|0)!=(p|0)){continue}break}d=b;if((f|0)<=126){b=f+1|0}else{b=f;f=Vh(f,0);b=b+f|0;b=((Vh(b,b>>31)|0)>(f|0))+b|0}f=b+m|0;m=b>>31;h=m+d|0;h=b>>>0>f>>>0?h+1|0:h;l=c+f|0;d=h+q|0;d=c>>>0>l>>>0?d+1|0:d;h=N(s,40)+o|0;n=H[h+24>>2];p=n>>31;Tf:{if((p|0)>=(d|0)&l>>>0<=n>>>0|(d|0)<(p|0)){H[h+8>>2]=H[h+32>>2];break Tf}h=H[i+120>>2];l=h>>>0<l>>>0;h=h>>31;if(l&(h|0)<=(d|0)|(d|0)>(h|0)){break t}if(Bi(v,f)){break d}}d=N(s,40)+o|0;G[d+16>>1]=16;H[d+12>>2]=f;if(c|q){H[v>>2]=c;G[d+16>>1]=1040}c=H[d+8>>2];Uf:{if((b|0)<=127){F[c|0]=b;l=c+1|0;break Uf}l=Gf(c,b,m)+c|0}d=b+c|0;while(1){f=k;c=H[f+28>>2];Vf:{if(c>>>0<=7){F[l|0]=c;l=l+1|0;if(!c){break Vf}m=H[f>>2];b=H[f+4>>2];k=I[c+32944|0];c=k;while(1){c=c-1|0;F[d+c|0]=m;h=b;b=b>>>8|0;m=(h&255)<<24|m>>>8;if(c){continue}break}d=d+k|0;break Vf}if(c>>>0<=127){F[l|0]=c;l=l+1|0;if(c>>>0<14){break Vf}b=H[f+12>>2];if((b|0)<=0){break Vf}d=Ya(d,H[f+8>>2],b)+H[f+12>>2]|0;break Vf}l=Gf(l,c,0)+l|0;b=H[f+12>>2];if(!b){break Vf}d=Ya(d,H[f+8>>2],b)+H[f+12>>2]|0}k=f+40|0;if((f|0)!=(w|0)){continue}break}break e}c=N(H[g+4>>2],40)+o|0;f=H[g+16>>2];d=I[f|0];while(1){ci(c,d<<24>>24,u);b=f;Wf:{if(I[b|0]!=69){break Wf}f=J[c+16>>1];if(!(f&4)){break Wf}h=H[c>>2];d=H[c+4>>2];Xf:{if(d+32768>>>0<65536){l=65499;d=32;break Xf}M[c>>3]=+(h>>>0)+ +(d|0)*4294967296;l=65523;d=8}G[c+16>>1]=d|f&l}c=c+40|0;f=b+1|0;d=I[b+1|0];if(d){continue}break}break e}d=N(H[g+4>>2],40)+o|0;k=H[g+16>>2];f=H[k+4>>2];c=0;while(1){if(G[k+34>>1]<=(c|0)){break e}Yf:{Zf:{b=f+N(c,12)|0;h=J[b+10>>1];if(!(h&96)){break Zf}if(h&32){break Yf}if(!H[g+12>>2]){break Zf}d=d+40|0;break Yf}ci(d,F[b+5|0],u);_f:{b=J[d+16>>1];if(b&1){break _f}$f:{ag:{bg:{cg:{dg:{h=I[(f+N(c,12)|0)+4|0]>>>4|0;switch(h-2|0){case 0:break ag;case 3:break bg;case 4:break cg;case 1:case 2:break dg;default:break _f}}if(b&4){break _f}break $f}if(b&2){break _f}break $f}eg:{fg:{if(b&4){h=H[d+4>>2];l=h;m=H[d>>2];h=h+32768|0;if((h|0)==65536|h>>>0>65536){break fg}n=65499;h=32;break eg}if(b&40){break _f}break $f}M[d>>3]=+(m>>>0)+ +(l|0)*4294967296;n=65523;h=8}G[d+16>>1]=h|b&n;break _f}if(b&16){break _f}}e=H[(gb(d)<<2)+33084>>2];b=H[(h<<2)+65052>>2];d=H[k>>2];H[j+124>>2]=H[f+N(c,12)>>2];H[j+120>>2]=d;H[j+116>>2]=b;H[j+112>>2]=e;_c(a,5869,j+112|0);e=3091;break c}d=d+40|0}c=c+1|0;continue}}ja=p,ka=Ai(b),H[ja+72>>2]=ka;f=Hu(b,p+76|0);H[p+68>>2]=f;d=H[a+28>>2]}H[p+24>>2]=d;b=F[f|0];H[r>>2]=b&255;d=1;if((b|0)<0){d=$d(f,r)}h=0;G[p+54>>1]=0;H[p+44>>2]=d;f=H[r>>2];if(f>>>0>K[p+76>>2]){H[p+76>>2]=0;H[p+68>>2]=0;b=H[r>>2];if(b>>>0>98307){break s}if(b>>>0<=K[p+72>>2]){break A}break s}l=H[p+68>>2];break z}if((h&65535)>>>0>q>>>0){break w}d=H[p+44>>2];f=H[r>>2];if(d>>>0>=f>>>0){break y}l=H[p+68>>2];if(l){break z}e=0;b=j+296|0;$a(b,0,40);f=dk(H[p+36>>2],H[r>>2],b);if(f){break r}f=H[r>>2];d=H[p+44>>2];h=J[p+54>>1];l=H[j+304>>2]}n=f+l|0;d=d+l|0;f=h&65535;m=H[r+(f<<2)>>2];b=0;while(1){k=I[d|0];H[j+256>>2]=k;c=p+(f<<2)|0;H[c+80>>2]=k;h=k<<24>>24;gg:{if((h|0)>=0){d=d+1|0;c=I[(h&255)+32944|0];break gg}h=$d(d,j+256|0);k=H[j+256>>2];H[c+80>>2]=k;d=d+h|0;c=yi(k)}m=c+m|0;b=m>>>0<c>>>0?b+1|0:b;h=f+1|0;H[r+(h<<2)>>2]=m;if(f>>>0<q>>>0){f=h;if(d>>>0<n>>>0){continue}}break}hg:{ig:{jg:{kg:{if(d>>>0<n>>>0){c=H[p+72>>2];break kg}if(d>>>0>n>>>0){break jg}c=H[p+72>>2];if((c|0)!=(m|0)|b){break jg}}if(!b&c>>>0>=m>>>0){break ig}}if(H[r>>2]){break hg}h=0;d=n}G[p+54>>1]=h;H[p+44>>2]=d-l;if(H[p+68>>2]){break x}hd(j+296|0);h=J[p+54>>1];break x}if(H[p+68>>2]){break s}hd(j+296|0);break s}k=0;H[j+256>>2]=0}if((h&65535)>>>0>q>>>0){break v}b=N(H[g+12>>2],40)+o|0;if(I[g+1|0]==246){$g(b,H[g+16>>2],8192);break e}dc(b);break e}k=H[(p+(q<<2)|0)+80>>2];H[j+256>>2]=k}c=H[g+12>>2];b=N(c,40)+o|0;if(I[b+17|0]&144){dc(b)}d=r+(q<<2)|0;if(K[p+76>>2]>=K[d+4>>2]){h=H[p+68>>2]+H[d>>2]|0;if(k>>>0<=11){qh(h,k,b);break e}d=N(c,40)+o|0;F[d+18|0]=u;f=k-12>>>1|0;H[d+12>>2]=f;k=f+2|0;lg:{if((k|0)>H[d+24>>2]){if((f|0)>H[i+120>>2]){break t}G[b+16>>1]=1;if(Di(b,k,0)){break d}d=H[(N(c,40)+o|0)+8>>2];break lg}m=d;d=H[d+32>>2];H[m+8>>2]=d}Ya(d,h,f);c=N(c,40)+o|0;F[f+H[c+8>>2]|0]=0;F[(f+H[c+8>>2]|0)+1|0]=0;G[b+16>>1]=J[((H[j+256>>2]&1)<<1)+32930>>1];break e}F[(N(c,40)+o|0)+18|0]=u;mg:{d=J[g+2>>1];if(!(!(k&1)&k>>>0>11|d&128?d&192:0)){d=yi(k);if(d){break mg}}qh(30016,k,b);break e}if((d|0)>H[i+120>>2]){break t}f=Gu(H[p+36>>2],H[r+(q<<2)>>2],d,b);if(f){break r}qh(H[(N(c,40)+o|0)+8>>2],k,b);G[b+16>>1]=J[b+16>>1]&49151}e=0;break e}_c(a,11894,0);e=18;break c}b=H[t+12>>2];if((b|0)>0){g=(N(b,20)+t|0)-20|0;break e}f=ab(91354)}e=f;break c}c=d}if(!(!(d&44)|d&2)){ei(b,u,1);d=J[b+16>>1]&-3520|c&3519;break o}d=c}z=bi(b,f,H[g+16>>2]);if((z|0)<0){c=I[g|0];h=29836;break l}c=I[g|0];if(!z){break m}}h=29848;break l}z=0;h=29842}c=I[h+(c&255)|0];G[b+16>>1]=d;G[f+16>>1]=l;if(c){break h}break e}z=0;break e}H[a+36>>2]=5}c=3;break b}g=(N(H[g+8>>2],20)+t|0)-20|0;break e}g=(N(H[g+8>>2],20)+t|0)-20|0}c=0;if(H[i+296>>2]){break b}while(1){if((E|0)==(P|0)&L>>>0>R>>>0|E>>>0>P>>>0){break e}c=H[i+368>>2];if(!c){break e}d=E;f=H[i+376>>2];b=f+L|0;L=b;E=b>>>0<f>>>0?d+1|0:d;if(!(Ka[c|0](H[i+372>>2])|0)){continue}break}c=1;break b}g=g+20|0;continue}}Mb(i);_c(a,1141,0);e=7}c=2}while(1){ng:{og:{pg:{qg:{rg:{sg:{switch(c|0){case 0:e=9;break ng;case 1:L=-1;E=-1;break pg;case 2:c=7;tg:{if(I[i+87|0]){break tg}c=e;if((c|0)!=8458){break tg}c=ab(97014)}if(!(H[a+124>>2]|(c|0)==3082)){ja=j,ka=Dg(c),H[ja+16>>2]=ka;_c(a,8310,j+16|0)}H[a+36>>2]=c;ws(i,c);b=H[a+196>>2];H[j+8>>2]=H[a+124>>2];H[j+4>>2]=b;H[j>>2]=(g-t|0)/20;Fc(c,6778,j);if(I[a+149|0]==2){rk(a)}ug:{if((c|0)!=11){if((c|0)!=3082){break ug}Mb(i);break ug}if(I[i+85|0]){break ug}b=H[i+36>>2]|2;H[i+32>>2]=H[i+32>>2];H[i+36>>2]=b}x=1;b=_&255;if(!b){_=0;break rg}Xj(i,b-1|0);break rg;default:break sg}}if((E|0)==(P|0)&L>>>0>R>>>0|E>>>0>P>>>0){break qg}c=H[i+368>>2];if(!c){break qg}h=E;d=H[i+376>>2];b=d+L|0;L=b;E=b>>>0<d>>>0?h+1|0:h;if(Ka[c|0](H[i+372>>2])|0){break og}}c=3;continue}H[a+176>>2]=R+H[a+176>>2];break a}c=0;continue}c=1;continue}c=2;continue}}Ga=j+336|0;return x}
function Vj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0;r=Ga-1264|0;Ga=r;x=H[a>>2];z=H[x+124>>2];if(!H[x+184>>2]){H[x+296>>2]=0}H[a+232>>2]=b;H[a+12>>2]=0;c=r+48|0;H[c+8>>2]=0;H[c+4>>2]=a;H[c+1208>>2]=c+1196;H[c>>2]=c+8;M=H[x+264>>2];H[x+264>>2]=a;y=-1;while(1){a:{B=bk(b,r+1260|0);z=z-B|0;if((z|0)<0){H[a+12>>2]=18;H[a+36>>2]=H[a+36>>2]+1;break a}c=H[r+1260>>2];b:{if((c|0)<164){y=c;break b}if(H[x+296>>2]){H[a+12>>2]=9;H[a+36>>2]=H[a+36>>2]+1;break a}if((c|0)==183){b=b+B|0;continue}if(!I[b|0]){B=0;c=0;c:{switch(y|0){default:c=1;break;case 1:break c;case 0:break a}}H[r+1260>>2]=c;y=c;break b}d:{e:{switch(c-164|0){case 1:c=Ga-16|0;Ga=c;H[c+12>>2]=b+4;e=59;if((y|0)==23){e=ml(c+12|0);e=(e|0)==59?165:(e|0)==22?165:59}Ga=c+16|0;c=e;break d;case 2:e=Ga-16|0;Ga=e;H[e+12>>2]=b+6;f:{if((y|0)==23){c=166;if((ml(e+12|0)|0)==22){break f}}c=59}Ga=e+16|0;break d;default:H[r+44>>2]=B;H[r+40>>2]=b;H[r+32>>2]=r+40;Za(a,28657,r+32|0);break a;case 0:break e}}e=Ga-16|0;Ga=e;H[e+12>>2]=b+6;c=59;if((ml(e+12|0)|0)==59){c=(ml(e+12|0)|0)==24?164:59}Ga=e+16|0}y=c;H[r+1260>>2]=c}H[a+200>>2]=B;H[a+196>>2]=b;c=H[a+200>>2];H[r+24>>2]=H[a+196>>2];H[r+28>>2]=c;t=Ga-32|0;Ga=t;u=r+48|0;f=H[u+4>>2];e=J[H[u>>2]>>1];g:{while(1){c=y&65535;e=e&65535;if(e>>>0<=575){h=J[(e<<1)+36368>>1];h:{i:{while(1){g=c;d=c+h|0;if((c|0)==J[(d<<1)+37520>>1]){break i}c=J[(g<<1)+35568>>1];if(c){continue}break}c=h+101|0;if(!(!(g&65535)|J[(c<<1)+37520>>1]!=101)){e=(c<<1)+42096|0;break h}e=(e<<1)+46304|0;break h}e=(d<<1)+42096|0}e=J[e>>1]}c=e&65535;if(c>>>0>=1243){if(!(I[c+34709|0]|K[u>>2]<K[u+1208>>2])){Ft(u);break g}e=H[r+28>>2];H[t>>2]=H[r+24>>2];H[t+4>>2]=e;e=0;g=0;i=0;h=0;n=0;m=Ga-176|0;Ga=m;d=H[u>>2];j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{wc:{xc:{yc:{zc:{Ac:{Bc:{Cc:{Dc:{Ec:{Fc:{Gc:{Hc:{Ic:{Jc:{Kc:{Lc:{Mc:{Nc:{Oc:{Pc:{Qc:{Rc:{Sc:{Tc:{Uc:{Vc:{Wc:{Xc:{Yc:{Zc:{_c:{$c:{ad:{bd:{cd:{dd:{ed:{fd:{gd:{hd:{id:{jd:{kd:{ld:{md:{nd:{od:{pd:{qd:{rd:{sd:{td:{ud:{vd:{wd:{xd:{yd:{zd:{Ad:{Bd:{Cd:{Dd:{Ed:{Fd:{Gd:{Hd:{Id:{Jd:{Kd:{Ld:{Md:{Nd:{Od:{Pd:{Qd:{Rd:{Sd:{Td:{Ud:{Vd:{Wd:{Xd:{Yd:{Zd:{_d:{$d:{ae:{be:{ce:{de:{ee:{fe:{ge:{he:{ie:{je:{D=c-1243|0;switch(D|0){case 255:break ya;case 254:break za;case 253:break Aa;case 252:break Ba;case 251:break Ca;case 248:break Da;case 247:break Ea;case 246:break Fa;case 243:break Ga;case 242:break Ha;case 239:break Ia;case 238:case 280:break Ja;case 237:break Ka;case 236:case 241:break La;case 234:break Ma;case 233:break Na;case 227:break Oa;case 226:break Pa;case 225:break Qa;case 224:break Ra;case 223:break Sa;case 222:break Ta;case 221:break Ua;case 220:break Va;case 217:break Wa;case 215:case 218:break Xa;case 214:break Ya;case 213:break Za;case 211:case 212:break _a;case 210:break $a;case 209:break ab;case 208:break bb;case 207:break cb;case 206:break db;case 205:break eb;case 204:break fb;case 203:break gb;case 202:break hb;case 195:case 196:case 197:case 198:case 199:case 200:case 201:break ib;case 194:break jb;case 193:break kb;case 192:break lb;case 191:break mb;case 190:break nb;case 189:break ob;case 188:break pb;case 187:break qb;case 186:break rb;case 185:break sb;case 184:break tb;case 182:case 183:break ub;case 181:break vb;case 180:break wb;case 178:case 179:break xb;case 177:break yb;case 176:break zb;case 175:break Ab;case 174:break Bb;case 173:break Cb;case 170:break Db;case 169:break Eb;case 168:break Fb;case 167:break Gb;case 166:break Hb;case 165:break Ib;case 164:break Jb;case 163:break Kb;case 162:break Lb;case 161:break Mb;case 160:break Nb;case 159:break Ob;case 158:break Pb;case 157:break Qb;case 156:break Rb;case 155:break Sb;case 150:break Tb;case 149:break Ub;case 148:break Vb;case 147:break Wb;case 145:case 152:case 154:case 228:case 249:break Xb;case 144:case 146:case 151:case 153:case 229:case 231:case 250:break Yb;case 140:break Zb;case 139:break _b;case 138:case 141:break $b;case 137:break ac;case 136:break bc;case 135:break cc;case 134:break dc;case 133:case 143:break ec;case 131:break fc;case 130:break gc;case 128:break hc;case 127:break ic;case 126:break jc;case 125:break kc;case 124:break lc;case 123:break mc;case 122:break nc;case 121:break oc;case 120:break pc;case 119:break qc;case 118:break rc;case 117:break sc;case 116:break tc;case 114:case 129:break uc;case 113:break vc;case 112:break wc;case 111:break xc;case 110:break yc;case 109:break zc;case 107:break Ac;case 106:break Bc;case 105:case 108:break Cc;case 103:case 115:case 256:case 257:break Dc;case 102:break Ec;case 101:break Fc;case 100:break Gc;case 99:case 132:case 142:case 232:case 235:case 240:break Hc;case 97:break Ic;case 96:break Jc;case 95:break Kc;case 94:break Lc;case 93:break Mc;case 92:break Nc;case 90:break Oc;case 89:case 91:break Pc;case 88:break Qc;case 87:break Rc;case 86:break Sc;case 85:break Tc;case 84:break Uc;case 83:break Vc;case 82:break Wc;case 79:break Xc;case 78:case 172:break Yc;case 77:break Zc;case 74:break _c;case 73:case 75:break $c;case 71:break ad;case 70:break bd;case 69:break cd;case 68:break dd;case 66:break ed;case 64:break fd;case 63:case 80:case 216:case 219:case 245:break gd;case 61:case 76:case 171:break hd;case 60:break id;case 59:break jd;case 58:break kd;case 57:break ld;case 56:break md;case 55:break nd;case 54:break od;case 53:break pd;case 52:break qd;case 51:break rd;case 50:break sd;case 49:break td;case 48:break ud;case 46:break vd;case 45:break wd;case 44:break xd;case 43:break yd;case 42:break zd;case 41:break Ad;case 40:break Bd;case 39:break Cd;case 38:break Dd;case 37:break Ed;case 36:break Fd;case 35:break Gd;case 34:break Hd;case 33:break Id;case 32:case 67:break Jd;case 31:break Kd;case 30:break Ld;case 29:break Md;case 28:break Nd;case 27:break Od;case 26:case 65:case 104:break Pd;case 25:break Qd;case 24:break Rd;case 23:break Sd;case 22:break Td;case 21:break Ud;case 20:break Vd;case 19:break Wd;case 17:break Xd;case 16:break Yd;case 15:case 18:case 47:case 62:case 72:case 81:case 98:case 244:break Zd;case 14:break _d;case 13:break $d;case 12:break ae;case 11:break be;case 10:break ce;case 8:case 9:break de;case 5:case 6:case 7:case 323:break ee;case 4:break fe;case 3:break ge;case 2:break he;case 1:break ie;case 0:break je;case 341:break k;case 340:break l;case 339:break m;case 338:break n;case 336:break o;case 335:break p;case 334:break q;case 332:case 333:break r;case 331:break s;case 330:break t;case 328:break u;case 325:case 327:case 329:break v;case 322:break w;case 321:break x;case 320:break y;case 319:break z;case 317:break A;case 316:break B;case 315:break C;case 314:break D;case 313:break E;case 312:break F;case 310:break G;case 309:break H;case 308:break I;case 307:break J;case 306:break K;case 305:break L;case 303:case 304:break M;case 300:case 301:case 302:break N;case 299:break O;case 298:break P;case 297:break Q;case 296:break R;case 295:break S;case 294:break T;case 293:break U;case 292:break V;case 291:break W;case 290:break X;case 289:break Y;case 288:break Z;case 287:break _;case 284:break $;case 283:break aa;case 282:break ba;case 281:break ca;case 279:break da;case 278:break ea;case 277:break fa;case 276:break ga;case 275:break ha;case 274:break ia;case 273:break ja;case 272:break ka;case 271:break la;case 270:break ma;case 269:break na;case 268:break oa;case 267:case 286:break pa;case 266:case 285:break qa;case 265:break ra;case 263:case 264:break sa;case 262:break ta;case 261:break ua;case 260:break va;case 259:break wa;case 258:break xa;default:break j}}F[f+207|0]=1;break j}F[f+207|0]=2;break j}c=0;ke:{if(I[f+18|0]){break ke}g=H[f>>2];le:{if(H[f+36>>2]){h=7;if(I[g+87|0]){break le}break ke}me:{ne:{e=H[f+8>>2];if(e){break ne}h=101;if(I[g+177|0]){break le}e=zb(f);if(e){break ne}H[f+12>>2]=1;e=0;break me}oe:{if(!I[f+149|0]){break oe}h=H[f+132>>2];if(!H[h+96>>2]){break oe}Sb(e,83);i=db(e,35,H[h+92>>2]);j=H[h+100>>2];while(1){if(H[h+96>>2]>(c|0)){Xa(e,94,H[h+92>>2],c,c+j|0);c=c+1|0;continue}break}Va(e,84,j,c);Va(e,38,H[h+92>>2],i+1|0);bb(e,i)}Sb(e,70);if(I[g+87|0]|!(H[f+68>>2]?1:H[f+84>>2])){break me}c=0;bb(e,0);while(1){pe:{if(!(H[f+84>>2]>>>c&1)){break pe}ze(e,c);h=H[(H[g+16>>2]+(c<<4)|0)+12>>2];ob(e,2,c,H[f+80>>2]>>>c&1,H[h>>2],H[h+4>>2]);if(I[g+177|0]){break pe}pb(e,1)}c=c+1|0;if((c|0)<H[g+20>>2]){continue}break}c=0;while(1){if(H[f+212>>2]>(c|0)){kb(e,170,0,0,0,Id(g,H[H[f+260>>2]+(c<<2)>>2]),-11);c=c+1|0;continue}break}c=0;H[f+212>>2]=0;g=0;i=H[f+8>>2];while(1){if(H[f+104>>2]>(g|0)){h=H[f+108>>2]+(g<<4)|0;kb(i,169,H[h>>2],H[h+4>>2],I[h+8|0],H[h+12>>2],-1);g=g+1|0;continue}break}i=f+112|0;j=H[f+8>>2];k=H[f>>2];while(1){qe:{i=H[i>>2];if(!i){break qe}h=H[i+12>>2];g=H[i+8>>2];fe(f,0,g,H[H[(H[k+16>>2]+(g<<4)|0)+12>>2]+72>>2],112);l=h-1|0;Bd(j,l,H[H[i+4>>2]>>2]);g=zg(j,12,48304);if(!g){break qe}H[g+8>>2]=h;H[g+72>>2]=h;H[g- -64>>2]=l;H[g+52>>2]=h;l=h+2|0;H[g+12>>2]=l;H[g+148>>2]=l;H[g+124>>2]=h;H[g+112>>2]=h;H[g+88>>2]=h+1;G[g+62>>1]=16;H[g+208>>2]=h;H[g+144>>2]=h;if(H[f+40>>2]){continue}H[f+40>>2]=1;continue}break}re:{g=H[f+68>>2];if(!g){break re}F[f+23|0]=0;while(1){if(H[g>>2]<=(c|0)){break re}h=g+(c<<4)|0;i=H[h+20>>2];if((i|0)>0){oc(f,H[h+8>>2],i)}c=c+1|0;continue}}se:{if(!I[f+149|0]){break se}c=H[f+132>>2];g=H[c+96>>2];if(!g){break se}Va(e,118,H[c+92>>2],g)}Yb(e,1)}h=1;if(H[f+36>>2]){break le}px(e,f);h=101}H[f+12>>2]=h}break j}c=H[d-8>>2];i=H[f>>2];te:{if(cc(f,22,19259,0,0)){break te}e=zb(f);if(!e){break te}ue:{if((c|0)==7){break ue}h=(c|0)==9?2:1;c=0;while(1){if(H[i+20>>2]<=(c|0)){break ue}j=H[(H[i+16>>2]+(c<<4)|0)+4>>2];ve:{if(j){g=0;if(Ew(j)){break ve}}g=h}Va(e,2,c,g);ze(e,c);c=c+1|0;continue}}Sb(e,1)}break j}H[d+16>>2]=7;break j}H[d+4>>2]=J[d+2>>1];break j}c=J[d-10>>1]==12;we:{if(cc(f,22,c?19498:18125,0,0)){break we}e=zb(f);if(!e){break we}Va(e,1,1,c)}break j}ro(f,0,d+4|0);break j}ro(f,1,d+4|0);break j}ro(f,2,d+4|0);break j}qo(f,d-8|0,d+4|0,H[d-44>>2],0,0,H[d-20>>2]);break j}Ct(f);break j}H[d+16>>2]=0;break j}H[d-20>>2]=1;break j}H[d+4>>2]=!I[H[f>>2]+177|0];break j}po(f,d-20|0,d-8|0,H[d+4>>2],0);break j}po(f,0,0,0,H[d+4>>2]);hc(H[f>>2],H[d+4>>2]);break j}H[d+16>>2]=0;break j}c=d-20|0;H[c>>2]=H[d+4>>2]|H[c>>2];break j}c=H[d+4>>2];xe:{e=H[d+8>>2];if((e|0)!=5){break xe}if(Fb(c,14302,5)){break xe}H[d-8>>2]=640;break j}H[d-8>>2]=0;H[m+4>>2]=c;H[m>>2]=e;Za(f,5701,m);break j}c=H[d+4>>2];ye:{ze:{e=H[d+8>>2];if((e|0)!=6){break ze}if(Fb(c,3190,6)){break ze}e=65536;break ye}H[m+20>>2]=c;H[m+16>>2]=e;Za(f,5701,m+16|0);e=0}H[d+4>>2]=e;break j}c=d-8|0;e=H[c+4>>2];H[m+40>>2]=H[c>>2];H[m+44>>2]=e;c=H[d+8>>2];H[m+32>>2]=H[d+4>>2];H[m+36>>2]=c;l=m+40|0;j=m+32|0;o=Ga-32|0;Ga=o;k=H[f+236>>2];Ae:{if(!k){break Ae}p=H[f>>2];if(H[p+128>>2]<=G[k+34>>1]){H[o+16>>2]=H[k>>2];Za(f,6133,o+16|0);break Ae}if(I[f+208|0]<=1){bt(l)}Be:{Ce:{De:{c=H[j+4>>2];Ee:{Fe:{if(c>>>0<16){break Fe}e=c-6|0;g=H[j>>2];if(Fb(e+g|0,3362,6)){break Ee}while(1){c=e;if(!c){break De}e=c-1|0;if(F[I[g+e|0]+30016|0]&1){continue}break}H[j+4>>2]=c;if(c>>>0<9){break Fe}e=c-9|0;if(Fb(g+e|0,14795,9)){break Ee}while(1){c=e;if(!c){break De}e=c-1|0;if(F[I[g+e|0]+30016|0]&1){continue}break}H[j+4>>2]=c}if(c>>>0<3){break Ce}}bt(j);g=H[j>>2];c=H[j+4>>2];h=1;e=0;while(1){i=65;if((e|0)==6){break Be}Ge:{if(I[e+48644|0]!=(c|0)){break Ge}if(Fb(g,H[(e<<2)+65056>>2],c)){break Ge}c=0;H[j+4>>2]=0;h=(e&2147483643)==1?5:1;n=(e<<4)+16|0;i=I[e+48650|0];break Be}e=e+1|0;continue}}c=0;H[j+4>>2]=0}h=1;i=65}g=0;q=H[l+4>>2];e=c+q|0;g=e>>>0<c>>>0?1:g;w=e;v=e+((c|0)!=0)|0;e=g;e=v>>>0<w>>>0?e+1|0:e;g=v+1|0;e=g?e:e+1|0;g=Uc(p,g,e);if(!g){break Ae}if(I[f+208|0]>=2){Ne(f,g,l)}e=0;l=Ya(g,H[l>>2],q);F[l+q|0]=0;Tf(l);q=Ug(l);g=G[k+34>>1];w=(g|0)>0?g:0;v=H[k+4>>2];s=g>>31;He:{Ie:{while(1){if((e|0)!=(w|0)){Je:{A=v+N(e,12)|0;if((q|0)!=I[A+7|0]){break Je}if(hb(l,H[A>>2])){break Je}H[o>>2]=l;Za(f,7728,o);break Ie}e=e+1|0;continue}break}g=SK(g,s,12,0)+12|0;e=Ja;g=Kd(p,v,g,g>>>0<12?e+1|0:e);if(g){break He}}_a(p,l);break Ae}H[k+4>>2]=g;p=G[k+34>>1];e=g+N(p,12)|0;H[e+4>>2]=0;H[e+8>>2]=0;H[e>>2]=l;F[e+7|0]=q;Ke:{if(!c){F[e+6|0]=h;F[e+4|0]=I[e+4|0]&15|n;break Ke}h=c;c=Ya((ib(l)+l|0)+1|0,H[j>>2],c);F[h+c|0]=0;Tf(c);i=nl(c,e);G[e+10>>1]=J[e+10>>1]|4}F[(g+N(p,12)|0)+5|0]=i;G[k+34>>1]=J[k+34>>1]+1;G[k+36>>1]=J[k+36>>1]+1;H[f+76>>2]=0}Ga=o+32|0;break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}c=d-36|0;H[c+8>>2]=(H[d+4>>2]+H[d+8>>2]|0)-H[c+4>>2];break j}c=d-60|0;H[c+8>>2]=(H[d+4>>2]+H[d+8>>2]|0)-H[c+4>>2];break j}c=d-12|0;H[c+8>>2]=(H[d+8>>2]+H[d+4>>2]|0)-H[c+4>>2];break j}H[d+16>>2]=H[t>>2];break j}c=H[t+4>>2];H[d+16>>2]=H[t>>2];H[d+20>>2]=c;break j}c=H[d+8>>2];H[f+72>>2]=H[d+4>>2];H[f+76>>2]=c;break j}c=d-12|0;e=H[c+4>>2];vj(f,H[d+4>>2],e,e+H[c+8>>2]|0);break j}vj(f,H[d-8>>2],H[d-20>>2]+1|0,H[d+4>>2]);break j}c=d-12|0;vj(f,H[d+4>>2],H[d-20>>2],H[c+4>>2]+H[c+8>>2]|0);break j}c=d-12|0;vj(f,mb(f,173,H[d+4>>2],0),H[d-20>>2],H[c+4>>2]+H[c+8>>2]|0);break j}c=H[d+8>>2];H[m+48>>2]=H[d+4>>2];H[m+52>>2]=c;c=cf(f,117,m+48|0);if(c){ll(c)}e=c;c=H[d+4>>2];vj(f,e,c,c+H[d+8>>2]|0);break j}g=H[d+4>>2];Le:{c=H[f+236>>2];if(!c){break Le}e=G[c+34>>1];if((e|0)<=0){break Le}e=(H[c+4>>2]+N(e&65535,12)|0)-12|0;F[e+4|0]=I[e+4|0]&240|g&15;H[c+28>>2]=H[c+28>>2]|2048;if(!(I[e+10|0]&8)){break Le}e=c+8|0;while(1){e=H[e>>2];if(!e){break Le}if(G[H[e+4>>2]>>1]==(G[c+34>>1]-1|0)){g=I[e+55|0]|I[e+56|0]<<8|8;F[e+55|0]=g;F[e+56|0]=g>>>8}e=e+20|0;continue}}break j}Bt(f,0,H[d-8>>2],H[d+4>>2],H[d-20>>2]);break j}uj(f,0,0,0,0,H[d+4>>2],0,0,0,0,1);break j}At(f,H[d-8>>2],H[d-20>>2],H[d+4>>2]);break j}zt(f,0,d-20|0,H[d-8>>2],H[d+4>>2]);break j}yt(f,H[d+4>>2]);break j}e=d+4|0;c=H[f+236>>2];Me:{if(!c|I[f+208|0]>1){break Me}i=G[c+34>>1];h=H[f>>2];g=vc(h,e);if(!g){break Me}Ne:{if(!nj(f,g)){break Ne}i=i-1|0;j=N(i,12);Xs(h,j+H[c+4>>2]|0,g);e=c+8|0;while(1){e=H[e>>2];if(!e){break Ne}if((i|0)==G[H[e+4>>2]>>1]){O=H[e+32>>2],P=Of(j+H[c+4>>2]|0),H[O>>2]=P}e=e+20|0;continue}}_a(h,g)}break j}xt(f,H[d-8>>2],0);break j}xt(f,H[d-20>>2],d+4|0);break j}H[d+4>>2]=1;break j}H[d+16>>2]=0;break j}c=d-8|0;H[c>>2]=H[d+4>>2]|H[c>>2]&(H[d+8>>2]^-1);break j}c=d-8|0;H[c>>2]=0;H[c+4>>2]=0;break j}c=d-20|0;H[c>>2]=0;H[c+4>>2]=0;break j}c=d-24|0;H[c+8>>2]=255;H[c+4>>2]=H[d+4>>2];break j}c=d-24|0;H[c+8>>2]=65280;H[c+4>>2]=H[d+4>>2]<<8;break j}H[d-8>>2]=8;break j}H[d-8>>2]=9;break j}H[d+4>>2]=10;break j}H[d+4>>2]=7;break j}H[d-8>>2]=0;break j}H[d-20>>2]=0;break j}H[d-8>>2]=H[d+4>>2];break j}H[d-8>>2]=1;break j}H[d-8>>2]=0;break j}H[f+76>>2]=0;break j}Bt(f,H[d-32>>2],H[d+4>>2],H[d-20>>2],0);break j}uj(f,0,0,0,H[d-20>>2],H[d+4>>2],0,0,0,0,1);break j}At(f,H[d-20>>2],H[d-32>>2],H[d-8>>2]);break j}zt(f,H[d-68>>2],d-32|0,H[d-20>>2],H[d-8>>2]);yt(f,H[d+4>>2]);break j}H[d+16>>2]=11;break j}H[d-20>>2]=H[d+4>>2];break j}H[d+4>>2]=4;break j}H[d+4>>2]=5;break j}wt(f,H[d+4>>2],0,H[d-8>>2]);break j}l=d-92|0;e=d-44|0;k=d-32|0;j=H[d-20>>2];c=H[d+4>>2];i=H[d-80>>2];n=H[d-56>>2];g=Ga-80|0;Ga=g;H[g+12>>2]=0;h=H[f>>2];Oe:{if(G[f+204>>1]>0){Za(f,3369,0);break Oe}qo(f,e,k,i,1,0,n);i=H[f+236>>2];if(H[f+36>>2]|!i){break Oe}H[i+28>>2]=H[i+28>>2]|512;ig(f,e,k,g+12|0);e=g+16|0;bl(e,f,Lb(h,H[i+60>>2]),1810,H[g+12>>2]);if(lc(e+4|0,c)){break Oe}H[c+4>>2]=H[c+4>>2]|2097152;Pe:{if(I[f+208|0]>1){e=c;c=0;break Pe}e=ge(h,c,1)}H[i+44>>2]=e;e=rc(h,j,1);F[i+43|0]=2;H[i+16>>2]=e;if(I[h+87|0]){break Oe}e=H[f+196>>2];i=H[l>>2];e=(e+(I[e|0]==59?0:H[f+200>>2])|0)-i|0;while(1){e=e-1|0;k=i+e|0;if(F[I[k|0]+30016|0]&1){continue}break}H[g+76>>2]=1;H[g+72>>2]=k;po(f,0,g+72|0,0,0)}hc(h,c);if(I[f+208|0]>=2){Vs(f,j)}qb(h,j);Ga=g+80|0;break j}wt(f,H[d+4>>2],1,H[d-8>>2]);break j}H[m+168>>2]=H[11870];c=H[11869];H[m+160>>2]=H[11868];H[m+164>>2]=c;c=H[11867];H[m+152>>2]=H[11866];H[m+156>>2]=c;c=H[11865];H[m+144>>2]=H[11864];H[m+148>>2]=c;Sc(f,H[d+4>>2],m+144|0);hc(H[f>>2],H[d+4>>2]);break j}O=d-20|0,P=vt(f,H[d+4>>2],H[d-8>>2]),H[O>>2]=P;break j}O=d-32|0,P=vt(f,H[d+4>>2],H[d-8>>2]),H[O>>2]=P;break j}c=H[d+4>>2];if(c){kl(f,c)}H[d+4>>2]=c;break j}g=d-20|0;e=H[g>>2];Qe:{Re:{c=H[d+4>>2];if(!c){break Re}if(H[c+52>>2]){H[m+148>>2]=0;kl(f,c);c=Hd(f,0,bf(f,0,0,0,m+144|0,c,0),0,0,0,0,0,0);if(!c){break Re}}h=d-8|0;i=H[h>>2];H[c+52>>2]=e;F[c|0]=i;if(e){H[e+4>>2]=H[e+4>>2]&-1025}H[c+4>>2]=H[c+4>>2]&-1025;if(H[h>>2]==135){break Qe}F[f+22|0]=1;break Qe}hc(H[f>>2],e);c=0}H[g>>2]=c;break j}H[d+4>>2]=J[d+2>>1];break j}H[d-8>>2]=135;break j}O=d-92|0,P=Hd(f,H[d-68>>2],H[d-56>>2],H[d-44>>2],H[d-32>>2],H[d-20>>2],H[d-8>>2],H[d-80>>2],H[d+4>>2]),H[O>>2]=P;break j}c=Hd(f,H[d-80>>2],H[d-68>>2],H[d-56>>2],H[d-44>>2],H[d-32>>2],H[d-8>>2],H[d-92>>2],H[d+4>>2]);H[d-104>>2]=c;if(c){H[c+72>>2]=H[d-20>>2];break j}Ho(H[f>>2],H[d-20>>2]);break j}O=d-32|0,P=Hd(f,H[d-8>>2],0,0,0,0,0,512,0),H[O>>2]=P;break j}g=d-44|0;c=H[g>>2];e=Hd(f,H[d-8>>2],0,0,0,0,0,1536,0);if(c){H[c+4>>2]=H[c+4>>2]&-1025}Se:{if(!e){e=c;break Se}H[e+52>>2]=c;F[e|0]=135}H[g>>2]=e;break j}H[d+4>>2]=1;break j}H[d+4>>2]=2;break j}H[d+16>>2]=0;break j}e=d-44|0;c=sb(f,H[e>>2],H[d-20>>2]);H[e>>2]=c;if(H[d+8>>2]){Wg(f,c,d+4|0,1);c=H[e>>2]}e=H[d-32>>2];g=H[d-8>>2];Te:{if(!c){break Te}c=(H[c>>2]-1<<4)+c|0;if(H[c+12>>2]){break Te}O=c,P=co(H[f>>2],e,g),H[O+12>>2]=P;e=(I[c+17|0]|I[c+18|0]<<8)&65532|1;F[c+17|0]=e;F[c+18|0]=e>>>8}break j}c=sc(H[f>>2],180,0);e=d-20|0;O=e,P=sb(f,H[e>>2],c),H[O>>2]=P;break j}c=mb(f,180,0,0);e=d-20|0;g=H[e+4>>2];H[m+56>>2]=H[e>>2];H[m+60>>2]=g;c=mb(f,141,cf(f,59,m+56|0),c);e=d-44|0;O=e,P=sb(f,H[e>>2],c),H[O>>2]=P;break j}e=H[d+8>>2];c=d-8|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;break j}H[d+16>>2]=0;break j}c=H[d+4>>2];H[d-8>>2]=c;ut(c);break j}c=H[d-8>>2];if(!c){break j}e=H[c>>2];if((e|0)<=0){break j}F[(c+(e<<6)|0)-20|0]=H[d+4>>2];break j}c=d-44|0;O=c,P=bf(f,H[c>>2],d-32|0,d-20|0,d-8|0,0,d+4|0),H[O>>2]=P;break j}e=d-56|0;c=bf(f,H[e>>2],d-44|0,d-32|0,d-20|0,0,d+4|0);H[e>>2]=c;oo(f,c,d-8|0);break j}e=d-80|0;c=bf(f,H[e>>2],d-68|0,d-56|0,d-8|0,0,d+4|0);H[e>>2]=c;tt(f,c,H[d-32>>2]);break j}c=d-56|0;O=c,P=bf(f,H[c>>2],0,0,d-8|0,H[d-32>>2],d+4|0),H[O>>2]=P;break j}c=d-56|0;e=H[c>>2];if(!(e|H[d-4>>2]|(H[d+4>>2]|H[d+8>>2]))){H[c>>2]=H[d-32>>2];break j}g=d-32|0;h=H[g>>2];if(H[h>>2]==1){e=bf(f,e,0,0,d-8|0,0,d+4|0);H[c>>2]=e;if(e){i=H[e>>2]-1|0;h=e+(i<<6)|0;c=H[g>>2];H[h+16>>2]=H[c+16>>2];H[h+12>>2]=H[c+12>>2];k=h;h=H[c+28>>2];H[k+28>>2]=h;if(!(!h|!(I[h+5|0]&8))){h=e+(i<<6)|0;j=I[h+45|0]|I[h+46|0]<<8|8192;F[h+45|0]=j;F[h+46|0]=j>>>8}if(I[c+45|0]&4){e=e+(i<<6)|0;h=c- -64|0;H[e- -64>>2]=H[h>>2];H[h>>2]=0;h=(I[c+45|0]|I[c+46|0]<<8)&65531;F[c+45|0]=h;F[c+46|0]=h>>>8;h=I[e+45|0]|I[e+46|0]<<8|4;F[e+45|0]=h;F[e+46|0]=h>>>8}H[c+28>>2]=0;H[c+12>>2]=0;H[c+16>>2]=0}Ic(H[f>>2],H[g>>2]);break j}ut(h);e=Hd(f,0,H[g>>2],0,0,0,0,2048,0);O=c,P=bf(f,H[c>>2],0,0,d-8|0,e,d+4|0),H[O>>2]=P;break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}c=d+4|0;e=Rd(f,0,c,0);if(!(!e|I[f+208|0]<2)){Ne(f,H[e+16>>2],c)}H[c>>2]=e;break j}e=d-20|0;g=d+4|0;c=Rd(f,0,e,g);if(!(!c|I[f+208|0]<2)){Ne(f,H[c+16>>2],g)}H[e>>2]=c;break j}O=d,P=Rd(f,0,d+4|0,0),H[O+4>>2]=P;break j}c=d-20|0;O=c,P=Rd(f,0,c,d+4|0),H[O>>2]=P;break j}c=d-44|0;e=Rd(f,0,c,d-20|0);H[c>>2]=e;if(!e){break j}e=vc(H[f>>2],d+4|0);H[H[c>>2]+20>>2]=e;break j}c=d-20|0;e=Rd(f,0,c,0);H[c>>2]=e;if(!e){break j}e=vc(H[f>>2],d+4|0);H[H[c>>2]+20>>2]=e;break j}H[d+4>>2]=1;break j}c=d-8|0;O=c,P=no(f,c,0,0),H[O>>2]=P;break j}c=d-20|0;O=c,P=no(f,c,d-8|0,0),H[O>>2]=P;break j}c=d-32|0;O=c,P=no(f,c,d-20|0,d-8|0),H[O>>2]=P;break j}c=d-12|0;H[c+8>>2]=0;H[c+4>>2]=H[d+4>>2];break j}c=d-36|0;H[c+4>>2]=0;H[c+8>>2]=H[d-8>>2];break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}e=H[d+8>>2];c=d-20|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;break j}c=d-8|0;H[c>>2]=0;H[c+4>>2]=1;break j}H[d-20>>2]=H[d+4>>2];break j}e=d-44|0;c=sb(f,H[e>>2],H[d-20>>2]);H[e>>2]=c;mo(c,H[d-8>>2],H[d+4>>2]);break j}e=d-20|0;c=sb(f,0,H[e>>2]);H[e>>2]=c;mo(c,H[d-8>>2],H[d+4>>2]);break j}H[d+4>>2]=0;break j}H[d+4>>2]=1;break j}H[d+16>>2]=-1;break j}H[d-8>>2]=0;break j}H[d-8>>2]=1;break j}H[d+16>>2]=0;break j}H[d-8>>2]=H[d+4>>2];break j}O=d-8|0,P=mb(f,148,H[d+4>>2],0),H[O>>2]=P;break j}O=d-32|0,P=mb(f,148,H[d-20>>2],H[d+4>>2]),H[O>>2]=P;break j}O=d-32|0,P=mb(f,148,H[d+4>>2],H[d-20>>2]),H[O>>2]=P;break j}c=d-20|0;oo(f,H[c>>2],d-8|0);lo(f,H[c>>2],H[d+4>>2]);break j}jl(f,H[d+4>>2]);H[d-8>>2]=0;break j}jl(f,H[d+4>>2]);H[d-32>>2]=H[d-20>>2];break j}e=d-56|0;oo(f,H[e>>2],d-44|0);g=d-20|0;st(f,H[g>>2],2211);c=H[d-8>>2];Ue:{if(!c){c=H[e>>2];break Ue}if(H[c>>2]>=2){c=Hd(f,0,c,0,0,0,0,2048,0);H[m+144>>2]=0;H[m+148>>2]=0;c=bf(f,0,0,0,m+144|0,c,0)}c=rt(f,H[e>>2],c);H[e>>2]=c}ko(f,c,H[g>>2],H[d+4>>2],H[d-68>>2],0);break j}e=d-44|0;c=sb(f,H[e>>2],H[d+4>>2]);H[e>>2]=c;Wg(f,c,d-20|0,1);break j}c=d-68|0;O=c,P=qt(f,H[c>>2],H[d-32>>2],H[d+4>>2]),H[O>>2]=P;break j}c=sb(f,0,H[d+4>>2]);e=d-20|0;Wg(f,c,e,1);H[e>>2]=c;break j}O=d-44|0,P=qt(f,0,H[d-32>>2],H[d+4>>2]),H[O>>2]=P;break j}jo(f,H[d-32>>2],H[d-8>>2],H[d-20>>2],H[d-56>>2],H[d+4>>2]);break j}jo(f,H[d-44>>2],0,H[d-32>>2],H[d-68>>2],0);break j}H[d+16>>2]=0;break j}H[d-8>>2]=0;jl(f,H[d+4>>2]);break j}O=d-128|0,P=tj(H[f>>2],H[d-92>>2],H[d-68>>2],H[d-20>>2],H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}O=d-92|0,P=tj(H[f>>2],H[d-56>>2],H[d-32>>2],0,0,H[d+4>>2]),H[O>>2]=P;break j}O=d-44|0,P=tj(H[f>>2],0,0,0,0,0),H[O>>2]=P;break j}O=d-80|0,P=tj(H[f>>2],0,0,H[d-20>>2],H[d-8>>2],0),H[O>>2]=P;break j}jl(f,H[d+4>>2]);break j}H[d+16>>2]=0;break j}H[d-20>>2]=H[d-8>>2];break j}c=d-20|0;O=c,P=io(f,H[c>>2],d+4|0),H[O>>2]=P;break j}O=d,P=io(f,0,d+4|0),H[O+4>>2]=P;break j}H[d-20>>2]=H[d-8>>2];break j}c=H[d+8>>2];H[m+64>>2]=H[d+4>>2];H[m+68>>2]=c;O=d,P=cf(f,59,m- -64|0),H[O+4>>2]=P;break j}c=d-20|0;e=H[c+4>>2];H[m+80>>2]=H[c>>2];H[m+84>>2]=e;e=cf(f,59,m+80|0);g=H[d+8>>2];H[m+72>>2]=H[d+4>>2];H[m+76>>2]=g;O=c,P=mb(f,141,e,cf(f,59,m+72|0)),H[O>>2]=P;break j}c=d-44|0;e=H[c+4>>2];H[m+104>>2]=H[c>>2];H[m+108>>2]=e;e=cf(f,59,m+104|0);g=d-20|0;h=H[g+4>>2];H[m+96>>2]=H[g>>2];H[m+100>>2]=h;g=cf(f,59,m+96|0);h=H[d+8>>2];H[m+88>>2]=H[d+4>>2];H[m+92>>2]=h;g=mb(f,141,g,cf(f,59,m+88|0));if(I[f+208|0]>=2){od(f,0,e)}O=c,P=mb(f,141,e,g),H[O>>2]=P;break j}c=J[d+2>>1];e=H[d+8>>2];H[m+112>>2]=H[d+4>>2];H[m+116>>2]=e;O=d,P=cf(f,c,m+112|0),H[O+4>>2]=P;break j}c=Ac(H[f>>2],155,d+4|0,1);if(c){H[c+36>>2]=H[d+4>>2]-H[f+232>>2]}H[d+4>>2]=c;break j}c=H[d+4>>2];if(!(I[c|0]==35&I[c+1|0]-58>>>0>4294967285)){n=H[d+8>>2];c=H[d+8>>2];H[m+120>>2]=H[d+4>>2];H[m+124>>2]=c;p=cf(f,156,m+120|0);H[d+4>>2]=p;o=Ga-16|0;Ga=o;Ve:{if(!p){break Ve}j=H[f>>2];e=H[p+8>>2];h=F[e+1|0];c=h>>31;i=c;We:{Xe:{if(!(c|h)){c=J[f+204>>1]+1|0;G[f+204>>1]=c;break Xe}Ye:{Ze:{if(I[e|0]==63){if((n|0)==2){c=h-48|0;h=i-(h>>>0<48)|0}else{g=(jh(e+1|0,o+8|0,n-1|0,1)|0)!=0;c=H[o+8>>2];h=H[o+12>>2]}k=g;g=c;c=h;h=H[j+156>>2];i=h>>31;if(k|(!g&(c|0)<=0|(c|0)<0)|(h>>>0<g>>>0&(i|0)<=(c|0)|(c|0)>(i|0))){break We}c=g<<16>>16;if((c|0)<=G[f+204>>1]){break Ze}G[f+204>>1]=c;g=H[f+224>>2];break Ye}g=H[f+224>>2];c=tx(g,e,n);if(c&65535){break Xe}c=J[f+204>>1]+1|0;G[f+204>>1]=c;break Ye}g=H[f+224>>2];if(vx(g,c)){break Xe}}k=e;w=c<<16>>16;h=g;q=((n|0)/4|0)+3|0;e=q;l=e;s=e>>31;_e:{$e:{if(g){e=H[h+4>>2];i=q+e|0;g=H[h>>2];if((i|0)<=(g|0)){g=h;break $e}e=g>>31;e=e<<1|g>>>31;g=g<<1}else{g=10;e=0}i=e;e=l;l=g;v=e+g|0;g=i+s|0;e=h;i=v;g=Kd(j,e,i<<2,(l>>>0>i>>>0?g+1|0:g)<<2|i>>>30);if(!g){break _e}if(h){e=H[g+4>>2]}else{H[g+4>>2]=2;e=2}H[g>>2]=i;i=e+q|0}e=(e<<2)+g|0;H[e>>2]=w;H[e+4>>2]=q;H[g+4>>2]=i;O=Ya(e+8|0,k,n)+n|0,P=0,F[O|0]=P;e=g}H[f+224>>2]=e}G[p+32>>1]=c;if(H[j+156>>2]>=c<<16>>16){break Ve}Za(f,5459,0);mh(H[f>>2],p);break Ve}H[o>>2]=h;Za(f,15799,o);mh(H[f>>2],p)}Ga=o+16|0;break j}c=H[d+8>>2];e=H[d+4>>2];H[m+144>>2]=e;H[m+148>>2]=c;if(!I[f+18|0]){H[m+128>>2]=m+144;Za(f,8474,m+128|0);H[d+4>>2]=0;break j}c=mb(f,176,0,0);H[d+4>>2]=c;if(!c){break j}Ag(e+1|0,c+28|0);break j}c=d-20|0;O=c,P=pt(f,H[c>>2],d+4|0,1),H[O>>2]=P;break j}c=Ac(H[f>>2],36,d-8|0,1);H[d-56>>2]=c;ot(H[f>>2],c,H[d-32>>2],0);break j}c=d-44|0;O=c,P=Ef(f,H[d-8>>2],c,H[d-20>>2]),H[O>>2]=P;break j}c=d-32|0;O=c,P=Ef(f,0,c,0),H[O>>2]=P;break j}c=d-56|0;e=Ef(f,H[d-20>>2],c,H[d-32>>2]);nt(f,e,H[d+4>>2]);H[c>>2]=e;break j}c=d-44|0;e=Ef(f,0,c,0);nt(f,e,H[d+4>>2]);H[c>>2]=e;break j}O=d,P=Ef(f,0,d+4|0,0),H[O+4>>2]=P;break j}c=sb(f,H[d-32>>2],H[d-8>>2]);g=d-44|0;e=mb(f,177,0,0);H[g>>2]=e;if(e){H[e+20>>2]=c;if(!H[c>>2]){break j}e=H[g>>2];H[e+4>>2]=H[e+4>>2]|H[H[c+8>>2]+4>>2]&4194824;break j}qb(H[f>>2],c);break j}c=d-20|0;O=c,P=he(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-20|0;O=c,P=mb(f,J[d-10>>1],H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}e=H[d+8>>2];g=d-12|0;H[g+4>>2]=H[d+4>>2];H[g+8>>2]=e;H[g+8>>2]=e|-2147483648;break j}c=d-4|0;e=H[c>>2];H[c>>2]=e&2147483647;g=d-20|0;c=Ef(f,sb(f,sb(f,0,H[d+4>>2]),H[g>>2]),d-8|0,0);H[g>>2]=c;if((e|0)<0){c=mb(f,19,c,0);H[g>>2]=c}if(!c){break j}H[c+4>>2]=H[c+4>>2]|256;break j}c=d-28|0;e=H[c>>2];H[c>>2]=e&2147483647;g=d-44|0;c=Ef(f,sb(f,sb(f,sb(f,0,H[d-20>>2]),H[g>>2]),H[d+4>>2]),d-32|0,0);H[g>>2]=c;if((e|0)<0){c=mb(f,19,c,0);H[g>>2]=c}if(!c){break j}H[c+4>>2]=H[c+4>>2]|256;break j}c=d-8|0;O=c,P=mb(f,J[d+2>>1],H[c>>2],0),H[O>>2]=P;break j}c=d-20|0;O=c,P=mb(f,51,H[c>>2],0),H[O>>2]=P;break j}e=d-20|0;c=mb(f,45,H[e>>2],H[d+4>>2]);H[e>>2]=c;il(f,H[d+4>>2],c,50);break j}e=d-32|0;c=mb(f,171,H[e>>2],H[d+4>>2]);H[e>>2]=c;il(f,H[d+4>>2],c,51);break j}e=d-56|0;c=mb(f,45,H[e>>2],H[d+4>>2]);H[e>>2]=c;il(f,H[d+4>>2],c,50);break j}e=d-44|0;c=mb(f,171,H[e>>2],H[d+4>>2]);H[e>>2]=c;il(f,H[d+4>>2],c,51);break j}c=d-12|0;O=c,P=mb(f,J[c+2>>1],H[d+4>>2],0),H[O+4>>2]=P;break j}c=d-12|0;O=c,P=mb(f,J[c+2>>1]==106?174:173,H[d+4>>2],0),H[O+4>>2]=P;break j}c=d-20|0;e=sb(f,0,H[c>>2]);O=c,P=Ef(f,sb(f,e,H[d+4>>2]),d-8|0,0),H[O>>2]=P;break j}H[d+4>>2]=0;break j}g=sb(f,sb(f,0,H[d-20>>2]),H[d+4>>2]);c=d-44|0;e=mb(f,48,H[c>>2],0);H[c>>2]=e;af:{if(e){H[e+20>>2]=g;break af}qb(H[f>>2],g)}if(!H[d-32>>2]){break j}O=c,P=mb(f,19,H[c>>2],0),H[O>>2]=P;break j}c=d-8|0;e=H[c>>2];if(!e){c=d-44|0;mt(f,H[c>>2]);e=c;c=sc(H[f>>2],117,H[d-32>>2]?12244:12777);H[e>>2]=c;if(!c){break j}ll(c);break j}bf:{cf:{if(H[e>>2]!=1){break cf}h=H[e+8>>2];if(!Me(h)){break cf}e=d-44|0;if(I[H[e>>2]]==177){break cf}H[H[c>>2]+8>>2]=0;qb(H[f>>2],H[c>>2]);c=mb(f,174,h,0);O=e,P=mb(f,53,H[e>>2],c),H[O>>2]=P;break bf}i=d-44|0;e=mb(f,49,H[i>>2],0);H[i>>2]=e;if(!e){qb(H[f>>2],H[c>>2]);break bf}h=H[e+12>>2];if(I[h|0]==177){l=H[H[h+20>>2]>>2];j=H[c>>2];c=0;h=Ga-16|0;Ga=h;while(1){df:{ef:{ff:{if(H[j>>2]>(g|0)){e=1;k=H[(j+(g<<4)|0)+8>>2];if(I[k|0]==177){e=H[H[k+20>>2]>>2]}if((e|0)==(l|0)){e=Hd(f,H[k+20>>2],0,0,0,0,0,512,0);H[k+20>>2]=0;if(!e){break ef}if(!c){break ff}H[e+52>>2]=c;F[e|0]=135;break ff}H[h+8>>2]=l;H[h>>2]=e;H[h+4>>2]=(e|0)>1?8311:29357;Za(f,16637,h)}if(!(!c|!H[c+52>>2])){H[c+4>>2]=H[c+4>>2]|1024}qb(H[f>>2],j);Ga=h+16|0;break df}c=e}g=g+1|0;continue}break}if(!c){break bf}kl(f,c);sj(f,H[i>>2],c);break bf}H[e+20>>2]=H[c>>2];hl(f,H[i>>2])}if(!H[d-32>>2]){break j}c=d-44|0;O=c,P=mb(f,19,H[c>>2],0),H[O>>2]=P;break j}c=mb(f,138,0,0);H[d-20>>2]=c;sj(f,c,H[d-8>>2]);break j}c=d-44|0;e=mb(f,49,H[c>>2],0);H[c>>2]=e;sj(f,e,H[d-8>>2]);if(!H[d-32>>2]){break j}O=c,P=mb(f,19,H[c>>2],0),H[O>>2]=P;break j}c=Rd(f,0,d-20|0,d-8|0);e=Hd(f,0,c,0,0,0,0,0,0);g=H[d+4>>2];if(g){tt(f,e?c:0,g)}c=d-44|0;g=mb(f,49,H[c>>2],0);H[c>>2]=g;sj(f,g,e);if(!H[d-32>>2]){break j}O=c,P=mb(f,19,H[c>>2],0),H[O>>2]=P;break j}c=mb(f,20,0,0);H[d-32>>2]=c;sj(f,c,H[d-8>>2]);break j}g=d-44|0;e=mb(f,157,H[d-32>>2],0);H[g>>2]=e;if(e){c=H[d-20>>2];h=H[d-8>>2];if(h){c=sb(f,c,h);e=H[g>>2]}H[e+20>>2]=c;hl(f,H[g>>2]);break j}qb(H[f>>2],H[d-20>>2]);fb(H[f>>2],H[d-8>>2]);break j}c=d-44|0;e=sb(f,H[c>>2],H[d-20>>2]);H[c>>2]=e;O=c,P=sb(f,e,H[d+4>>2]),H[O>>2]=P;break j}c=d-32|0;e=sb(f,0,H[d-20>>2]);H[c>>2]=e;O=c,P=sb(f,e,H[d+4>>2]),H[O>>2]=P;break j}c=d-20|0;O=c,P=sb(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}O=d,P=sb(f,0,H[d+4>>2]),H[O+4>>2]=P;break j}H[d-20>>2]=H[d-8>>2];break j}c=d-44|0;uj(f,d-80|0,d-68|0,Rd(f,0,c,0),H[d-20>>2],H[d-116>>2],d-128|0,H[d+4>>2],0,H[d-92>>2],0);if(I[f+208|0]<2){break j}e=H[f+240>>2];if(!e){break j}Ne(f,H[e>>2],c);break j}H[d+4>>2]=2;break j}H[d+16>>2]=0;break j}c=d-44|0;O=c,P=lt(f,H[c>>2],d-20|0,H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-20|0;O=c,P=lt(f,0,c,H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}h=H[d+4>>2];g=H[d-8>>2];c=Ga-48|0;Ga=c;i=H[f>>2];gf:{if(I[i+87|0]){break gf}if(kf(f)){break gf}e=Ff(i,H[h+16>>2],H[h+12>>2]);if(!e){hf:{if(!g){H[c>>2]=h+8;Za(f,18557,c);break hf}mj(f,H[h+12>>2]);el(f)}F[f+17|0]=1;break gf}if(I[e+55|0]&3){H[c+32>>2]=0;Za(f,15007,c+32|0);break gf}j=H[e+12>>2];g=Lb(i,H[e+24>>2]);k=(g|0)==1;l=H[H[i+16>>2]+(g<<4)>>2];if(cc(f,9,k?8639:8658,0,l)){break gf}if(cc(f,k?12:10,H[e>>2],H[j>>2],l)){break gf}j=zb(f);if(!j){break gf}Gd(f,1,g);k=H[H[i+16>>2]+(g<<4)>>2];H[c+20>>2]=H[e>>2];H[c+16>>2]=k;nc(f,26721,c+16|0);Ws(f,g,1529,H[e>>2]);hg(f,g);ZC(f,H[e+44>>2],g);kb(j,152,g,0,0,H[e>>2],0)}Ic(i,h);Ga=c+48|0;break j}kt(f,0,H[d+4>>2]);break j}kt(f,d-8|0,H[d+4>>2]);break j}rj(f,d-8|0,d+4|0,0,0);break j}rj(f,d-32|0,d-20|0,d+4|0,0);break j}rj(f,d-44|0,d-32|0,d-8|0,0);break j}rj(f,d-32|0,d-20|0,d+4|0,1);break j}rj(f,d-44|0,d-32|0,d-8|0,1);break j}c=H[d-32>>2];H[m+144>>2]=c;H[m+148>>2]=H[d+8>>2]+(H[d+4>>2]-c|0);g=H[d-8>>2];h=Ga-96|0;Ga=h;j=H[f>>2];c=H[f+244>>2];H[f+244>>2]=0;jf:{kf:{if(H[f+36>>2]|!c){break kf}o=H[c>>2];l=Lb(j,H[c+20>>2]);H[c+28>>2]=g;while(1){if(g){H[g+4>>2]=c;g=H[g+40>>2];continue}break}e=h+32|0;Oh(e,o);p=h+40|0;bl(p,f,l,8858,e);g=0;e=H[c+28>>2];k=p+4|0;while(1){lf:{i=0;if(!e){break lf}mf:{nf:{if(lc(k,H[e+8>>2])){break nf}if(Kb(k,H[e+20>>2])){break nf}if(gc(k,H[e+24>>2])){break nf}if($n(p,H[e+16>>2])){break nf}i=e+32|0;while(1){n=H[i>>2];if(!n){break mf}if(gc(k,H[n>>2])){break nf}if(Kb(k,H[n+4>>2])){break nf}if(gc(k,H[n+8>>2])){break nf}i=n+16|0;if(!Kb(k,H[n+12>>2])){continue}break}}i=1;break lf}e=H[e+40>>2];continue}break}if(i){break kf}if(Kb(h+44|0,H[c+12>>2])){break kf}of:{if(I[f+208|0]>=2){H[f+244>>2]=c;c=0;break of}if(I[j+177|0]){break of}i=zb(f);if(!i){break kf}Gd(f,0,l);e=me(j,H[m+144>>2],H[m+148>>2],0);k=H[H[j+16>>2]+(l<<4)>>2];n=H[c+4>>2];H[h+28>>2]=e;H[h+24>>2]=n;H[h+20>>2]=o;H[h+16>>2]=k;nc(f,26426,h+16|0);_a(j,e);hg(f,l);H[h>>2]=o;Qh(i,l,tb(j,27208,h),0)}if(!I[j+177|0]){break kf}e=td(H[(H[j+16>>2]+(l<<4)|0)+12>>2]+40|0,o,c);if(e){Mb(j);break jf}e=0;g=H[c+20>>2];if((g|0)==H[c+24>>2]){g=Wc(g+8|0,H[c+4>>2]);H[c+32>>2]=H[g+56>>2];H[g+56>>2]=c}g=0;break jf}e=c}ri(j,e);Js(j,g);Ga=h+96|0;break j}q=d-80|0;i=q;v=d-68|0;g=v;o=H[d-56>>2];c=d-48|0;A=H[c+4>>2];n=H[c+8>>2];j=H[d-20>>2];e=H[d+4>>2];C=H[d-92>>2];c=0;k=Ga-96|0;Ga=k;h=H[f>>2];pf:{qf:{rf:{p=d-116|0;w=H[p>>2];sf:{if(w){if(H[g+4>>2]){Za(f,13229,0);break qf}H[k+92>>2]=i;i=1;if(j){break sf}break rf}i=ig(f,i,g,k+92|0);if(!j|(i|0)<0){break qf}}if(I[h+87|0]){break qf}if(!(!I[h+177|0]|(i|0)==1)){_a(h,H[j+12>>2]);H[j+12>>2]=0}l=Ph(f,j);i=I[h+177|0]|(H[g+4>>2]|!l)?i:H[l+60>>2]==H[H[h+16>>2]+28>>2]?1:i;if(I[h+87|0]){break qf}g=k+40|0;s=H[k+92>>2];bl(g,f,i,8858,s);if($n(g,j)){break qf}g=0;tf:{l=Ph(f,j);uf:{if(!l){break uf}if(I[l+43|0]==1){Za(f,5232,0);break uf}c=vc(h,s);if(!c){break rf}if(gl(f,c,8858,H[l>>2])){break qf}vf:{if(I[f+208|0]>1){break vf}if(!Wc(H[(H[h+16>>2]+(i<<4)|0)+12>>2]+40|0,c)){break vf}if(!C){H[k+32>>2]=s;Za(f,3496,k+32|0);break qf}Fd(f,i);break qf}C=H[l>>2];if(!Fb(C,17563,7)){Za(f,13430,0);break pf}s=I[l+43|0];if(!((o|0)==65|(s|0)!=2)){H[k+4>>2]=j+8;H[k>>2]=(o|0)==33?19580:18816;Za(f,18575,k);break uf}if((s|0)==2|(o|0)!=65){break tf}H[k+16>>2]=j+8;Za(f,18632,k+16|0)}if(I[h+176|0]!=1){break pf}F[h+178|0]=I[h+178|0]|1;break pf}if(I[f+208|0]<=1){s=H[h+16>>2];E=Lb(h,H[l+60>>2]);L=H[s+(E<<4)>>2];g=L;g=w?H[s+16>>2]:g;s=(E|0)==1;if(cc(f,w?5:s?5:7,c,C,g)){break qf}g=0;if(cc(f,18,s?8639:8658,0,L)){break pf}}g=yb(h,36,0);if(!g){break qf}H[g>>2]=c;c=Xb(h,H[j+16>>2]);H[g+4>>2]=c;H[g+20>>2]=H[(H[h+16>>2]+(i<<4)|0)+12>>2];i=H[l+60>>2];F[g+9|0]=(o|0)==65?1:(o|0)==33?1:2;F[g+8|0]=A;H[g+24>>2]=i;wf:{if(I[f+208|0]>=2){od(f,c,H[j+16>>2]);c=e;e=0;break wf}c=nb(h,e,1)}H[g+16>>2]=n;H[g+12>>2]=c;H[f+244>>2]=g;c=0;n=0;break pf}c=0}g=0}_a(h,c);Ic(h,j);Ie(h,n);fb(h,e);if(!H[f+244>>2]){ri(h,g)}Ga=k+96|0;if(!H[d+-64>>2]){c=H[q+4>>2];H[p>>2]=H[q>>2];H[p+4>>2]=c;break j}c=H[v+4>>2];H[p>>2]=H[v>>2];H[p+4>>2]=c;break j}H[d+4>>2]=J[d+2>>1];break j}H[d-8>>2]=65;break j}H[d+16>>2]=33;break j}H[d+8>>2]=0;H[d+4>>2]=J[d+2>>1];break j}c=d-24|0;H[c+4>>2]=129;H[c+8>>2]=H[d+4>>2];break j}H[d+16>>2]=0;break j}H[d-8>>2]=H[d+4>>2];break j}c=d-20|0;e=d-8|0;H[H[H[c>>2]+44>>2]+40>>2]=H[e>>2];H[H[c>>2]+44>>2]=H[e>>2];break j}c=H[d-8>>2];H[c+44>>2]=c;break j}e=H[d+8>>2];c=d-20|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;Za(f,4345,0);break j}Za(f,4176,0);break j}Za(f,4260,0);break j}e=d-92|0;k=e;c=H[d-20>>2];g=H[d-32>>2];h=H[d-8>>2];l=I[d-80|0];j=H[f>>2];i=xs(f,129,d-68|0,H[e>>2],H[d+4>>2]);if(i){xf:{if(I[f+208|0]>=2){H[i+20>>2]=h;H[i+24>>2]=g;h=0;e=c;g=0;c=0;break xf}O=i,P=rc(j,g,1),H[O+24>>2]=P;O=i,P=nb(j,h,1),H[O+20>>2]=P;e=aj(j,c,1)}F[i+1|0]=l;H[i+16>>2]=e}qb(j,g);fb(j,h);Ic(j,c);H[k>>2]=i;break j}e=d-80|0;k=e;j=H[d-32>>2];c=H[d-20>>2];l=I[d-68|0];h=H[d-8>>2];i=H[f>>2];g=xs(f,127,d-44|0,H[e>>2],H[d+4>>2]);yf:{if(g){zf:{if(I[f+208|0]>1){e=c;c=0;break zf}e=ge(i,c,1)}H[g+32>>2]=h;H[g+28>>2]=j;H[g+8>>2]=e;F[g+1|0]=l;if(!h){break yf}cl(f,H[h>>2]);break yf}Ie(i,j);ol(i,h)}hc(i,c);H[k>>2]=g;break j}e=d-56|0;i=e;c=H[d-8>>2];h=H[f>>2];g=xs(f,128,d-32|0,H[e>>2],H[d+4>>2]);if(g){Af:{if(I[f+208|0]>1){e=c;c=0;break Af}e=nb(h,c,1)}F[g+1|0]=11;H[g+20>>2]=e}fb(h,c);H[i>>2]=g;break j}c=d-20|0;h=c;e=H[d-8>>2];i=H[c>>2];j=H[d+4>>2];g=H[f>>2];c=yb(g,48,0);Bf:{if(!c){hc(g,e);break Bf}H[c+8>>2]=e;G[c>>1]=2954;O=c,P=UC(g,i,j),H[O+36>>2]=P}H[h>>2]=c;break j}c=mb(f,71,0,0);H[d-32>>2]=c;if(!c){break j}F[c+1|0]=4;break j}c=Ac(H[f>>2],71,d-8|0,1);H[d-56>>2]=c;if(!c){break j}F[c+1|0]=H[d-32>>2];break j}H[d+4>>2]=1;break j}H[d+4>>2]=3;break j}e=H[d+4>>2];k=H[d-8>>2];c=0;h=Ga-16|0;Ga=h;g=H[f>>2];Cf:{if(I[g+87|0]){break Cf}if(kf(f)){break Cf}l=e+8|0;n=H[e+16>>2];i=H[e+12>>2];Df:{while(1){if(H[g+20>>2]>(c|0)){j=c>>>0<2^c;Ef:{if(i){if(!rl(g,j,i)){break Ef}}j=Wc(H[(H[g+16>>2]+(j<<4)|0)+12>>2]+40|0,n);if(j){break Df}}c=c+1|0;continue}break}Ff:{if(!k){H[h>>2]=l;Za(f,18612,h);break Ff}mj(f,i)}F[f+17|0]=1;break Cf}TC(f,j)}Ic(g,e);Ga=h+16|0;break j}c=H[d-32>>2];SC(f,24,49284,c,c,H[d-8>>2],H[d+4>>2]);break j}c=H[d+4>>2];SC(f,25,49400,c,0,0,c);break j}jt(f,0,0);break j}jt(f,d-8|0,d+4|0);break j}it(f,0,0);break j}it(f,d-8|0,d+4|0);break j}l=H[d-32>>2];c=d+4|0;g=Ga-144|0;Ga=g;k=H[f>>2];Gf:{if(I[k+87|0]){break Gf}j=Df(f,0,l+8|0);if(!j){break Gf}h=H[k+16>>2];n=Lb(H[f>>2],H[j+60>>2]);h=H[h+(n<<4)>>2];c=vc(k,c);if(!c){break Gf}Hf:{If:{Jf:{if(Dc(k,c,h)){break Jf}if(Ff(k,c,h)){break Jf}if(!MC(k,j,c)){break If}}H[g+128>>2]=c;Za(f,7669,g+128|0);break Hf}if(Fn(f,j)){break Hf}if(gl(f,c,13584,c)){break Hf}e=H[j>>2];if(I[j+43|0]==2){H[g>>2]=e;Za(f,14945,g);break Hf}if(cc(f,26,h,e,0)){break Hf}if(fg(f,j)){break Hf}if(I[j+43|0]==1){e=Id(k,j);i=H[H[H[e+8>>2]>>2]+76>>2]?e:0}o=zb(f);if(!o){break Hf}Rc(f);e=H[j>>2];q=gx(e);H[g+116>>2]=e;p=(n|0)==1;H[g+112>>2]=p;H[g+108>>2]=c;H[g+104>>2]=e;H[g+100>>2]=h;H[g+96>>2]=h;nc(f,27311,g+96|0);H[g+84>>2]=e;H[g+80>>2]=q;H[g+76>>2]=c;H[g+72>>2]=c;H[g+68>>2]=c;H[g+64>>2]=h;nc(f,21506,g- -64|0);if(Dc(k,13948,h)){H[g+56>>2]=H[j>>2];H[g+52>>2]=c;H[g+48>>2]=h;nc(f,18962,g+48|0)}if(!p){H[g+36>>2]=c;H[g+32>>2]=h;H[g+28>>2]=e;H[g+24>>2]=c;H[g+20>>2]=e;H[g+16>>2]=h;nc(f,26146,g+16|0)}if(i){e=H[f+44>>2]+1|0;H[f+44>>2]=e;Bd(o,e,c);kb(o,176,e,0,0,i,-11)}En(f,n,1);Vk(f,h,p,13168,0)}e=c}Ic(k,l);_a(k,e);Ga=g+144|0;break j}k=d-12|0;H[k+8>>2]=H[f+200>>2]+(H[f+196>>2]-H[k+4>>2]|0);e=Ga-48|0;Ga=e;Kf:{if(H[f+36>>2]){break Kf}i=H[f>>2];c=H[i+16>>2];g=H[f+236>>2];l=Lb(i,H[g+60>>2]);h=H[c+(l<<4)>>2];p=H[g+4>>2];o=G[g+34>>1]-1|0;q=p+N(o,12)|0;c=cd(g,q);j=H[g>>2]+16|0;if(cc(f,26,h,H[Dc(i,j,h)>>2],0)){break Kf}n=J[q+10>>1];if(n&1){Za(f,10530,0);break Kf}if(H[g+8>>2]){Za(f,10562,0);break Kf}Lf:{if(!(n&96)){c=c?I[H[c+12>>2]]==121?0:c:0;if(!(!(I[i+33|0]&64)|(!H[g+48>>2]|!c))){Dn(f,h,j,12274)}if(!(c|!(I[(p+N(o,12)|0)+4|0]&15))){Dn(f,h,j,19327)}if(!c){break Lf}H[e+44>>2]=0;if(bm(i,c,1,65,e+44|0)){break Kf}c=H[e+44>>2];if(!c){Dn(f,h,j,2797)}id(c);break Lf}if(!(n&64)){break Lf}Dn(f,h,j,10589)}n=me(i,H[k+4>>2],H[k+8>>2],0);if(n){c=(n+H[k+8>>2]|0)-1|0;while(1){Mf:{if(c>>>0<=n>>>0){break Mf}k=I[c|0];if(F[k+30016|0]&1?0:(k|0)!=59){break Mf}F[c|0]=0;c=c-1|0;continue}break}c=H[g+44>>2];H[e+32>>2]=j;H[e+28>>2]=c;H[e+24>>2]=n;H[e+20>>2]=c;H[e+16>>2]=h;nc(f,19020,e+16|0);_a(i,n)}c=zb(f);if(!c){break Kf}i=Db(f);Xa(c,99,l,i,2);ze(c,l);Va(c,86,i,-2);Va(c,49,i,H[c+108>>2]+2|0);Xa(c,100,l,2,3);xb(f,i);En(f,l,3);if(!H[g+16>>2]&(!(I[(p+N(o,12)|0)+4|0]&15)|!(I[q+10|0]&96))){break Kf}H[e+4>>2]=h;H[e>>2]=j;nc(f,27495,e)}Ga=e+48|0;break j}s=H[d-32>>2];c=d+4|0;l=Ga+-64|0;Ga=l;p=H[f>>2];Nf:{if(I[p+87|0]){break Nf}k=Df(f,0,s+8|0);if(!k){break Nf}if(Fn(f,k)){break Nf}if(LC(f,k,1)){break Nf}g=vc(p,c);if(!g){break Nf}q=vs(k,g);Of:{if((q|0)<0){H[l>>2]=c;Za(f,28636,l);break Of}c=J[(H[k+4>>2]+N(q,12)|0)+10>>1];if(c&9){H[l+52>>2]=g;H[l+48>>2]=c&1?17868:19544;Za(f,28587,l+48|0);break Of}if(G[k+34>>1]<=1){H[l+16>>2]=g;Za(f,2042,l+16|0);break Of}c=H[p+16>>2];e=Lb(p,H[k+60>>2]);c=H[c+(e<<4)>>2];if(cc(f,26,c,H[k>>2],g)){break Of}i=(e|0)==1;Vk(f,c,i,29357,0);KC(f,c,i);H[l+44>>2]=H[k>>2];H[l+40>>2]=q;H[l+36>>2]=e;H[l+32>>2]=c;nc(f,24459,l+32|0);En(f,e,2);Vk(f,c,i,10401,1);if(H[f+36>>2]|I[(H[k+4>>2]+N(q,12)|0)+10|0]&32){break Of}c=zb(f);o=H[f+40>>2];H[f+40>>2]=o+1;fe(f,o,e,k,113);A=db(c,35,o);i=H[f+44>>2];v=i+1|0;H[f+44>>2]=v;Pf:{if(!(I[k+28|0]&128)){Va(c,135,o,v);e=H[f+44>>2]+G[k+34>>1]|0;break Pf}n=tc(k);H[f+44>>2]=v+J[n+52>>1];e=0;while(1){h=J[n+50>>1];if(h>>>0>e>>>0){h=e;e=e+1|0;Xa(c,94,o,h,v+e|0);continue}break}e=H[f+44>>2]}w=e+1|0;H[f+44>>2]=w;i=i+2|0;e=0;while(1){if(G[k+34>>1]>(e|0)){Qf:{if(I[(H[k+4>>2]+N(e,12)|0)+10|0]&32|(e|0)==(q|0)){break Qf}Rf:{if(n){j=Cf(n,e<<16>>16);C=Cf(n,q<<16>>16);if((j|0)<J[n+50>>1]){break Qf}j=(i+j|0)-((j|0)>(C|0))|0;break Rf}j=h+i|0}Sf:{if(G[k+32>>1]==(e|0)){Va(c,75,0,j);break Sf}Qc(c,k,o,e,j)}h=h+1|0}e=e+1|0;continue}break}if(!h){H[f+44>>2]=H[f+44>>2]+1;Va(c,75,0,i);h=1}Xa(c,97,i,h,w);Tf:{if(n){ob(c,138,o,w,i,J[n+50>>1]);break Tf}Xa(c,128,o,w,v)}pb(c,2);Va(c,38,o,A+1|0);bb(c,A)}e=g}_a(p,e);Ic(p,s);Ga=l- -64|0;break j}Ct(f);j=H[d+4>>2];i=Ga-16|0;Ga=i;g=H[f>>2];Uf:{if(I[g+87|0]){break Uf}h=Df(f,0,j+8|0);if(!h){break Uf}Vf:{switch(I[h+43|0]-1|0){case 0:Za(f,14911,0);break Uf;case 1:Za(f,1764,0);break Uf;default:break Vf}}if(Fn(f,h)){break Uf}Rc(f);n=Lb(g,H[h+60>>2]);c=yb(g,64,0);if(!c){break Uf}H[f+236>>2]=c;H[c+24>>2]=1;e=G[h+34>>1];G[c+34>>1]=e;O=c,P=yb(g,N((e-1|0)/8|0,96)+96|0,0),H[O+4>>2]=P;H[i>>2]=H[h>>2];e=tb(g,5755,i);H[c>>2]=e;k=H[c+4>>2];if(!k|!e){break Uf}Ya(k,H[h+4>>2],N(G[c+34>>1],12));e=0;while(1){if(G[c+34>>1]>(e|0)){k=H[c+4>>2]+N(e,12)|0;l=Xb(g,H[k>>2]);H[k>>2]=l;O=k,P=Ug(l),F[O+7|0]=P;e=e+1|0;continue}break}O=c,P=rc(g,H[h+52>>2],0),H[O+52>>2]=P;H[c+60>>2]=H[(H[g+16>>2]+(n<<4)|0)+12>>2];e=H[h+44>>2];H[c+24>>2]=1;H[c+44>>2]=e}Ic(g,j);Ga=i+16|0;break j}l=d-20|0;n=d+4|0;c=0;h=Ga-80|0;Ga=h;j=H[f>>2];Wf:{Xf:{q=H[d-56>>2];i=Df(f,0,q+8|0);if(!i){break Xf}e=0;if(Fn(f,i)){break Wf}e=0;if(LC(f,i,0)){break Wf}e=H[j+16>>2];o=Lb(j,H[i+60>>2]);k=H[e+(o<<4)>>2];if(cc(f,26,k,H[i>>2],0)){break Xf}g=vc(j,l);e=0;if(!g){break Wf}p=G[i+34>>1];e=(p|0)>0?p:0;while(1){Yf:{if((c|0)!=(e|0)){if(hb(H[H[i+4>>2]+N(c,12)>>2],g)){break Yf}e=c}Zf:{_f:{$f:{if((e|0)==(p|0)){H[h>>2]=l;Za(f,28636,h);break $f}l=(o|0)==1;Vk(f,k,l,29357,0);KC(f,k,l);Rc(f);c=vc(j,n);if(c){break _f}}c=0;break Zf}n=I[H[n>>2]];p=H[i>>2];H[h+76>>2]=p;H[h+72>>2]=l;H[h- -64>>2]=c;n=I[n+30016|0]&128;H[h+68>>2]=n;H[h+60>>2]=e;H[h+56>>2]=p;H[h+52>>2]=k;H[h+48>>2]=k;nc(f,24854,h+48|0);i=H[i>>2];H[h+32>>2]=n;H[h+28>>2]=c;H[h+24>>2]=e;H[h+20>>2]=i;H[h+16>>2]=k;nc(f,26015,h+16|0);En(f,o,1);Vk(f,k,l,13168,1)}e=g;break Wf}c=c+1|0;continue}}e=0}Ic(j,q);_a(j,e);_a(j,c);Ga=h+80|0;break j}ht(f,0);break j}ht(f,d+4|0);break j}e=d+4|0;qo(f,d-32|0,d-20|0,0,0,1,H[d-44>>2]);c=H[f+236>>2];ag:{if(!c){break ag}F[c+43|0]=1;g=H[f>>2];Yg(f,c,vc(g,e));Yg(f,c,0);Yg(f,c,Xb(g,H[c>>2]));H[f+192>>2]=(H[e>>2]+H[e+4>>2]|0)-H[f+188>>2];e=H[c+48>>2];if(!e){break ag}cc(f,29,H[c>>2],H[e>>2],H[H[H[f>>2]+16>>2]+(Lb(g,H[c+60>>2])<<4)>>2])}break j}JC(f);H[f+252>>2]=0;H[f+256>>2]=0;break j}c=H[d+4>>2];e=H[f+252>>2];bg:{if(!e){H[f+252>>2]=c;e=H[d+8>>2];break bg}e=(c+H[d+8>>2]|0)-e|0}H[f+256>>2]=e;break j}ho(f,H[d+4>>2],1);break j}F[d+4|0]=1;break j}F[d-8|0]=0;break j}F[d-20|0]=2;break j}i=d-56|0;g=H[d-44>>2];h=H[d-8>>2];j=I[d-32|0];e=H[f>>2];c=yb(e,24,0);cg:{if(I[e+87|0]){qb(e,g);hc(e,h);break cg}H[c+4>>2]=g;H[c+8>>2]=h;e=vc(H[f>>2],i);F[c+20|0]=j;H[c>>2]=e}H[i>>2]=c;break j}O=d,P=gt(f,0,H[d+4>>2]),H[O+4>>2]=P;break j}c=d-20|0;O=c,P=gt(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-20|0;ft(f,H[d+4>>2],H[c>>2]);H[H[d+4>>2]+36>>2]=H[c>>2];H[c>>2]=H[d+4>>2];break j}h=d-44|0;c=d-8|0;if(H[c>>2]){g=d-48|0;g=me(H[f>>2],H[g+4>>2],H[g+8>>2],0);H[H[c>>2]>>2]=g;e=H[c>>2]}else{e=0}H[h>>2]=e;break j}O=d-44|0,P=qj(f,H[d+4>>2],H[d-20>>2],H[d-8>>2],0),H[O>>2]=P;break j}c=d-56|0;O=c,P=qj(f,H[d+4>>2],H[d-20>>2],H[d-8>>2],c),H[O>>2]=P;break j}O=d-32|0,P=qj(f,H[d+4>>2],0,H[d-8>>2],0),H[O>>2]=P;break j}c=d-44|0;O=c,P=qj(f,H[d+4>>2],0,H[d-8>>2],c),H[O>>2]=P;break j}c=d-8|0;O=c,P=qj(f,H[d+4>>2],0,0,c),H[O>>2]=P;break j}O=d,P=go(f,0,90,0,85,0,0),H[O+16>>2]=P;break j}c=d-20|0;e=c;g=H[c>>2];c=d-12|0;O=e,P=go(f,g,H[c+4>>2],H[c+8>>2],85,0,I[d+4|0]),H[O>>2]=P;break j}c=d-56|0;e=c;g=H[c>>2];c=d-36|0;h=H[c+4>>2];i=H[c+8>>2];c=d-12|0;O=e,P=go(f,g,h,i,H[c+4>>2],H[c+8>>2],I[d+4|0]),H[O>>2]=P;break j}c=d-12|0;H[c+8>>2]=0;H[c+4>>2]=J[c+2>>1];break j}c=d-12|0;H[c+8>>2]=H[c+4>>2];H[c+4>>2]=J[d+2>>1];break j}F[d+16|0]=0;break j}F[d-8|0]=I[d+4|0];break j}c=d-12|0;F[c+4|0]=I[c+2|0];break j}F[d+4|0]=I[d+2|0];break j}H[d-8>>2]=H[d+4>>2];break j}c=H[d+4>>2];dg:{if(c){H[c+40>>2]=H[d-8>>2];break dg}fb(H[f>>2],H[d-8>>2])}H[d-8>>2]=H[d+4>>2];break j}c=yb(H[f>>2],100,0);eg:{if(c){F[c+16|0]=166;H[c+40>>2]=H[d+4>>2];break eg}fb(H[f>>2],H[d+4>>2])}H[d+4>>2]=c;break j}H[d-32>>2]=H[d-8>>2];break j}c=d-8|0;e=yb(H[f>>2],100,0);H[c>>2]=e;if(!e){break j}e=me(H[f>>2],H[d+4>>2],H[d+8>>2],0);H[H[c>>2]>>2]=e;break j}H[d-44>>2]=H[d-8>>2]}c=N(F[D+35952|0],12)+d|0;e=J[c>>1];H[u>>2]=c+12;g=J[(D<<1)+47488>>1];G[c+14>>1]=g;e=J[(g+G[(e<<1)+49584>>1]<<1)+42096>>1];G[c+12>>1]=e;Ga=m+176|0;continue}break}if(c>>>0<=1239){e=H[r+28>>2];H[t+8>>2]=H[r+24>>2];H[t+12>>2]=e;f=y&65535;e=H[u>>2];g=e+12|0;H[u>>2]=g;fg:{if(g>>>0>K[u+1208>>2]){H[u>>2]=e;Ft(u);break fg}G[e+14>>1]=f;G[e+12>>1]=c>>>0>575?c+408|0:c;c=H[t+12>>2];H[e+16>>2]=H[t+8>>2];H[e+20>>2]=c}break g}if((c|0)==1241){H[u>>2]=H[u>>2]-12;break g}c=H[r+28>>2];H[t+24>>2]=H[r+24>>2];H[t+28>>2]=c;c=H[r+28>>2];H[t+16>>2]=H[r+24>>2];H[t+20>>2]=c;f=t+16|0;c=Ga-16|0;Ga=c;e=H[u+4>>2];gg:{if(I[H[t+16>>2]]){H[c>>2]=f;Za(e,8474,c);break gg}Za(e,2002,0)}H[u+4>>2]=e;Ga=c+16|0;Et(u,y&65535,t+24|0)}Ga=t+32|0;b=b+B|0;if(!H[a+12>>2]){continue}}break}c=r+48|0;e=c+8|0;while(1){if(e>>>0<K[c>>2]){Dt(c);continue}break}if(I[x+87|0]){H[a+12>>2]=7}z=H[a+4>>2];hg:{if(!z){e=H[a+12>>2];c=0;if(!e|(e|0)==101){break hg}O=r,P=Dg(e),H[O+16>>2]=P;z=tb(x,8310,r+16|0);H[a+4>>2]=z}c=H[a+12>>2];H[r+4>>2]=H[a+232>>2];H[r>>2]=z;Fc(c,28394,r);c=1}H[a+232>>2]=b;Wa(H[a+260>>2]);b=H[a+236>>2];if(!(I[a+208|0]|!b)){ie(x,b)}b=H[a+244>>2];if(!(!b|I[a+208|0]>1)){ri(x,b)}a=H[a+224>>2];if(a){$b(x,a)}H[x+264>>2]=M;Ga=r+1264|0;return c}function Sc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0;o=Ga-160|0;Ga=o;H[o+100>>2]=0;u=H[a>>2];h=1;n=zb(a);a:{if(H[a+36>>2]|!b){break a}if(cc(a,21,0,0,0)){break a}if(I[c|0]<=6){d=H[b+48>>2];if(d){we(a,33,d);H[b+48>>2]=0}H[b+4>>2]=H[b+4>>2]&-4194306|4194304}ve(a,b,0);b:{c:{if(H[a+36>>2]){break c}e=H[b+4>>2];if(e&8388608){d=H[b+32>>2];if(Us(d+8|0,d)){b=H[d+20>>2];if(!b){b=H[H[d+24>>2]>>2]}H[o+48>>2]=b;Za(a,7503,o+48|0);break c}H[b+4>>2]=e&-8388609}if(I[c|0]==9){Ts(a,b)}l=Ga-32|0;Ga=l;d:{if(H[b+52>>2]|!H[b+68>>2]|(I[b+6|0]&16|I[a+208|0]>1)){break d}s=zb(a);q=H[b+44>>2];r=H[b+40>>2];t=H[b+36>>2];j=H[b+32>>2];k=H[a>>2];H[l+28>>2]=0;f=H[b+68>>2];w=H[b+4>>2];e=yb(k,64,0);if(!e){g=7;aq(k,7);break d}RB(l,a);lc(l,b);g=H[b+4>>2];if(!(g&8)){H[l+8>>2]=0;H[l+4>>2]=42;gc(l,H[b+48>>2]);g=H[b+4>>2]}H[b+32>>2]=0;H[b+36>>2]=0;H[b+40>>2]=0;H[b+44>>2]=0;H[b+4>>2]=g&-1048585|1048576;i=Ok(a,Ok(a,0,H[f+8>>2],1),H[f+12>>2],1);e:{if(!i){break e}d=H[b+48>>2];if(!d){break e}g=H[d>>2];m=H[i>>2];if((g|0)>(m|0)){break e}H[i>>2]=g;if(!dg(i,d,-1)){qb(k,H[b+48>>2]);H[b+48>>2]=0}H[i>>2]=m}d=H[a+40>>2];H[f+48>>2]=d;H[a+40>>2]=d+4;d=l+28|0;bs(a,f,j,H[b+28>>2],e,d);bs(a,f,j,H[b+48>>2],e,d);d=H[l+28>>2];if(d){g=H[d>>2]}else{g=0}H[f+76>>2]=g;g=Ok(a,Ok(a,d,H[f+8>>2],0),H[f+12>>2],0);H[l+28>>2]=g;d=f;while(1){if(d){m=H[H[d+72>>2]+20>>2];f:{if(I[H[d+44>>2]+6|0]&16){bs(a,f,j,m,e,l+28|0);g=H[l+28>>2];if(g){m=H[g>>2]}else{m=0}F[d+96|0]=1;H[d+80>>2]=m;break f}H[d+80>>2]=g?H[g>>2]:0;g=Ok(a,g,m,0);H[l+28>>2]=g}m=H[d+40>>2];if(m){g=sb(a,g,nb(k,m,0));H[l+28>>2]=g}m=H[a+44>>2];p=m+1|0;H[d+52>>2]=p;m=m+2|0;H[a+44>>2]=m;H[d+56>>2]=m;Va(s,75,0,p);d=H[d+36>>2];continue}break}if(!g){g=sb(a,0,sc(k,155,24034));H[l+28>>2]=g}p=0;f=Hd(a,g,j,t,r,q,i,0,0);d=Rd(a,0,0,0);H[b+32>>2]=d;g:{if(d){H[d+28>>2]=f;pn(a,d);H[f+4>>2]=H[f+4>>2]|134217792;d=eo(a,f,64);H[f+4>>2]=H[f+4>>2]|w&8;if(!d){p=7;break g}e=Ya(e,d,64);H[e+28>>2]=H[e+28>>2]|16384;H[H[b+32>>2]+24>>2]=e;H[l+8>>2]=0;H[l+12>>2]=0;H[l+24>>2]=0;H[l+16>>2]=0;H[l+20>>2]=0;H[l+8>>2]=43;H[l>>2]=0;H[l+4>>2]=0;H[l+12>>2]=44;H[l+4>>2]=45;lc(l,f);e=d;break g}hc(k,f)}d=I[k+87|0];we(a,46,e);g=d?7:p}Ga=l+32|0;if(g){break c}h=H[b+32>>2];d=H[b+4>>2];$a(o+104|0,0,40);s=d>>>3&1;p=H[b+48>>2];l=b;b=0;while(1){h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{if(!H[l+52>>2]){if(H[h>>2]<=(b|0)){break t}d=(b<<6)+h|0;f=H[d+24>>2];e=H[d+28>>2];u:{if((I[d+44|0]&24)!=8){break u}if(!Zn(H[l+36>>2],H[d+48>>2])|I[u+81|0]&32){break u}F[d+44|0]=I[d+44|0]&215;$k(H[l+36>>2],H[d+48>>2],I[h+44|0]&64)}if(!e){break h}d=H[H[e+28>>2]>>2];k=G[f+34>>1];if((d|0)!=(k|0)){H[o+104>>2]=p;b=H[f>>2];H[o+8>>2]=d;H[o+4>>2]=b;H[o>>2]=k;Za(a,16281,o);break j}d=H[e+4>>2];if(d&8){break h}f=H[e+48>>2];v:{if(!f){break v}if(!(!H[l+48>>2]&H[h>>2]<2|(H[e+60>>2]|d&134217728)|(I[l+7|0]&8|I[u+82|0]&4))){we(a,33,f);H[e+48>>2]=0;break v}if(!(I[l+6|0]&4)|b){break v}if(I[h+108|0]&34|H[h>>2]==1){break i}}f=0;m=Ga-32|0;Ga=m;j=H[a>>2];x=H[j+80>>2];w:{if(H[l+68>>2]|x&1){break w}i=H[l+32>>2];g=i+(b<<6)|0;e=H[g+28>>2];if(H[e+68>>2]){break w}d=H[e+32>>2];h=H[e+60>>2];x:{if(h){if(H[l+60>>2]|H[h+16>>2]){break w}k=H[l+4>>2];if(!(k&256)){break x}break w}k=H[l+4>>2]}q=H[d>>2];if(!q){break w}t=H[e+4>>2];if(t&1){break w}y=H[a+248>>2];z=H[g+48>>2];if(H[i>>2]>1|s?h:0){break w}r=H[l+48>>2];if((H[e+48>>2]?r:0)|(H[e+48>>2]?s:0)){break w}y:{if(h){if(H[l+36>>2]|k&1){break w}if(!(t&8192)){break y}break w}if(t&8192){break w}}t=0;E=(b<<6)+i|0;h=I[E+44|0];w=h&96;if(w){if(s|(q|0)>1|I[H[d+24>>2]+43|0]==1){break w}t=1;if(k&1|h&16){break w}}if(I[d+44|0]&64?(b|0)>0:0){break w}f=(b<<6)+i|0;v=I[f+45|0]|I[f+46|0]<<8;if(!(!(v&256)|I[H[f+68>>2]+18|0])){f=0;break w}if(!(!(I[(d+(q<<6)|0)-20|0]&32)|(q|0)<2)){f=0;if(h&4|v&1024|(H[((b<<6)+i|0)+52>>2]|v&2048)){break w}}h=0;z:{if(!H[e+52>>2]){break z}f=0;if(H[e+48>>2]|((w|0)!=0|k)&1|s){break w}d=e;while(1){if(d){if(I[d+4|0]&9){break w}h=H[d+52>>2];if(I[d|0]!=135?h:0){break w}q=H[d+32>>2];if(H[d+68>>2]|H[q>>2]<=0){break w}d=h;if(!(I[q+44|0]&64)|(b|0)<=0){continue}break w}break}A:{if(!r){break A}d=0;f=H[r>>2];h=(f|0)>0?f:0;while(1){if((d|0)==(h|0)){break A}q=d<<4;f=0;d=d+1|0;if(J[(q+r|0)+20>>1]){continue}break}break w}f=0;if(k&8192){break w}h=0;if(H[i>>2]<2){break z}if(x&8388608|H[a+100>>2]>500){break w}d=H[a+40>>2];h=d>>31;f=d;d=h<<2|d>>>30;f=(f<<2)+4|0;d=f>>>0<4?d+1|0:d;h=yb(j,f,d);if(!h){h=0;break z}H[h>>2]=H[a+40>>2]}f=e+52|0;q=(b<<6)+i|0;d=q;H[a+248>>2]=H[d+16>>2];cc(a,21,0,0,0);H[a+248>>2]=y;k=H[g+28>>2];_a(j,H[d+12>>2]);_a(j,H[d+16>>2]);_a(j,H[d+20>>2]);H[d+20>>2]=0;H[d+12>>2]=0;H[d+16>>2]=0;H[g+28>>2]=0;while(1){r=H[f>>2];if(r){d=H[l+52>>2];e=H[q+24>>2];v=H[l+60>>2];x=H[l+48>>2];H[q+24>>2]=0;H[l+60>>2]=0;H[l+48>>2]=0;H[l+52>>2]=0;f=ge(j,l,0);H[l+48>>2]=x;H[l+60>>2]=v;F[l|0]=135;H[q+24>>2]=e;B:{if(!f){f=d;break B}e=H[a+100>>2]+1|0;H[a+100>>2]=e;H[f+16>>2]=e;if(!(I[j+87|0]|!h)){e=Ga-32|0;Ga=e;AB(a,h,H[f+32>>2],b);H[e+8>>2]=0;H[e+12>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=50;H[e>>2]=0;H[e+4>>2]=0;H[e+24>>2]=h;H[e+4>>2]=79;lc(e,f);Ga=e+32|0}H[f+52>>2]=d;if(d){H[d+56>>2]=f}H[f+56>>2]=l}H[l+52>>2]=f;f=r+52|0;continue}break}_a(j,h);C:{if(I[j+87|0]){H[g+28>>2]=k;break C}d=H[q+24>>2];if(d){e=H[d+24>>2];D:{if((e|0)==1){e=H[a+116>>2];we(e?e:a,48,d);break D}H[d+24>>2]=e-1}H[q+24>>2]=0}y=b+1|0;r=b<<6;d=-1;h=k;e=l;while(1){E:{if(!e){break E}C=H[h+32>>2];g=H[C>>2];q=0;q=(e|0)==(l|0)?I[E+44|0]:q;f=I[(i+r|0)+44|0];i=H[e+32>>2];if((g|0)>=2){i=Un(a,i,g-1|0,y);if(!i){break E}H[e+32>>2]=i}v=f&64;f=0;x=(g|0)>0?g:0;while(1){if((f|0)!=(x|0)){d=(b+f<<6)+i|0;if(I[d+46|0]&4){Ie(j,H[d+52>>2])}g=C+(f<<6)|0;A=g+8|0;Ya(d+8|0,A,64);F[d+44|0]=v|I[d+44|0];d=H[g+48>>2];$a(A,0,64);f=f+1|0;continue}break}f=i+r|0;F[f+44|0]=v|(I[f+44|0]&64|q);g=H[h+48>>2];if(!(!g|I[e+6|0]&64)){q=H[g>>2];f=0;while(1){if((f|0)<(q|0)){G[(g+(f<<4)|0)+20>>1]=0;f=f+1|0;continue}break}H[e+48>>2]=g;H[h+48>>2]=0}f=H[h+36>>2];H[h+36>>2]=0;if(w){Xi(f,d,1)}if(f){g=H[e+36>>2];if(g){f=mb(a,44,f,g)}H[e+36>>2]=f}if(!I[j+87|0]){H[m+12>>2]=t;H[m+8>>2]=d;H[m+4>>2]=z;H[m>>2]=a;H[m+16>>2]=H[h+28>>2];as(m,e,0)}H[e+4>>2]=H[e+4>>2]|H[h+4>>2]&256;f=H[h+60>>2];if(f){H[e+60>>2]=f;H[h+60>>2]=0}f=0;while(1){if((f|0)!=(x|0)){q=(b+f<<6)+i|0;v=q+8|0;g=Ga-32|0;Ga=g;if(H[q+24>>2]){H[g+8>>2]=0;H[g+12>>2]=0;H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=50;H[g>>2]=0;H[g+4>>2]=0;H[g+24>>2]=v;H[g+4>>2]=80;H[q+56>>2]=0;H[q+60>>2]=0;lc(g,e)}Ga=g+32|0;f=f+1|0;continue}break}h=H[h+52>>2];e=H[e+52>>2];continue}break}RB(m,a);lc(m,k);hc(j,k)}f=1}Ga=m+32|0;if(f){b=-1;if(H[a+36>>2]){break s}}if(I[u+87|0]){break s}h=H[l+32>>2];if(I[c|0]<9){break h}p=H[l+48>>2];break h}k=0;i=Ga-96|0;Ga=i;b=l;f=H[b+52>>2];p=H[a>>2];H[i+88>>2]=H[c+24>>2];d=H[c+20>>2];H[i+80>>2]=H[c+16>>2];H[i+84>>2]=d;d=H[c+12>>2];H[i+72>>2]=H[c+8>>2];H[i+76>>2]=d;d=H[c+4>>2];H[i+64>>2]=H[c>>2];H[i+68>>2]=d;n=zb(a);if(I[i+64|0]==12){Va(n,118,H[i+68>>2],H[H[b+28>>2]>>2]);F[i+64|0]=14}F:{G:{d=H[b+4>>2];if(d&1024){j=i- -64|0;h=Ga-16|0;Ga=h;d=b;m=H[b+60>>2];u=!m;g=1;H:{while(1){if(H[d+68>>2]){e=-1;break H}e=H[d+52>>2];if(e){g=g+u|0;d=e;continue}break}H[h>>2]=g;H[h+4>>2]=(g|0)==1?29357:18707;qc(a,0,5774,h);while(1){if(!d){e=0;break H}e=0;bg(a,d,-1,0,0,j,1,1);if(m){break H}G[d+2>>1]=g;d=H[d+56>>2];continue}}Ga=h+16|0;if((e|0)>=0){break G}d=H[b+4>>2]}I:{J:{if(!(d&8192)){break J}d=b;while(1){if(!(!d|!(I[d+5|0]&32))){d=H[d+52>>2];continue}break}if(!d){break J}t=i- -64|0;d=0;e=Ga-32|0;Ga=e;K:{if(H[b+68>>2]){Za(a,5493,0);break K}g=H[a+8>>2];f=H[b+32>>2];s=H[H[b+28>>2]>>2];if(cc(a,33,0,0,0)){break K}u=jb(a);G[b+2>>1]=320;kj(a,b,u);w=H[b+60>>2];H[b+60>>2]=0;v=H[b+12>>2];r=H[b+8>>2];H[b+8>>2]=0;H[b+12>>2]=0;h=H[f>>2];h=(h|0)>0?h:0;j=H[b+48>>2];while(1){L:{if((d|0)==(h|0)){h=0}else{if(!(I[(f+(d<<6)|0)+45|0]&64)){break L}h=H[(f+(d<<6)|0)+48>>2]}m=H[a+40>>2];d=m+1|0;H[a+40>>2]=d;M:{if(I[b|0]==134){H[a+40>>2]=m+2;f=j?6:5;break M}d=0;f=j?7:8}Pd(e,f,m);q=H[a+44>>2]+1|0;H[a+44>>2]=q;Xa(g,121,h,q,s);N:{if(j){f=yB(a,b);kb(g,118,m,H[j>>2]+2|0,0,f,-8);H[e+24>>2]=j;break N}Va(g,118,m,s)}O:{if(!d){s=H[b+4>>2];break O}Q=b,R=Va(g,118,d,0),H[Q+20>>2]=R;s=H[b+4>>2]|32;H[b+4>>2]=s}H[b+48>>2]=0;d=b;P:{while(1){f=d;if(s&8){Za(a,14629,0);break P}F[f|0]=135;d=H[f+52>>2];s=H[d+4>>2];if(s&8192){continue}break}H[d+56>>2]=0;qc(a,1,19166,0);s=Sc(a,d,e);H[d+56>>2]=b;if(s){break P}s=Va(g,35,m,u);db(g,136,h);Q:{if(j){Xa(g,94,m,H[j>>2]+1|0,q);break Q}Va(g,134,m,q)}db(g,130,m);m=jb(a);Lk(g,v,m);bg(a,b,h,0,0,t,m,u);if(r){Va(g,60,r,u)}lb(g,m);H[f+52>>2]=0;qc(a,1,19178,0);Sc(a,b,e);H[f+52>>2]=d;Yb(g,s);lb(g,u)}qb(H[a>>2],H[b+48>>2]);H[b+60>>2]=w;H[b+48>>2]=j;break K}d=d+1|0;continue}}Ga=e+32|0;e=0;break I}if(H[b+48>>2]){n=c;f=0;r=0;E=0;x=0;u=Ga-80|0;Ga=u;j=H[a+8>>2];s=H[a>>2];h=jb(a);v=jb(a);c=b;g=H[b+48>>2];m=H[g>>2];R:{S:{q=I[b|0];if((q|0)==135){break S}e=1;T:while(1){if(I[s+87|0]|H[H[c+28>>2]>>2]<(e|0)){break S}k=0;d=(m|0)>0?m:0;b=g+8|0;while(1){U:{if((d|0)!=(k|0)){if(J[b+12>>1]!=(e|0)){break U}d=k}V:{if((d|0)!=(m|0)){break V}d=sc(s,155,0);b=7;if(!d){break R}H[d+8>>2]=e;H[d+4>>2]=H[d+4>>2]|2048;g=sb(a,g,d);H[c+48>>2]=g;if(!g){g=0;break V}G[((m<<4)+g|0)+20>>1]=e;m=m+1|0}e=e+1|0;continue T}b=b+16|0;k=k+1|0;continue}}}e=0;y=Tb(s,(m<<2)+4|0,0);if(y){H[y>>2]=m;b=g+8|0;d=((m|0)>0?m:0)+1|0;k=1;while(1){if((d|0)!=(k|0)){H[y+(k<<2)>>2]=J[b+12>>1]-1;b=b+16|0;k=k+1|0;continue}break}E=yB(a,c)}W:{if((q|0)!=135){f=H[a+44>>2]+1|0;b=H[H[c+28>>2]>>2];H[a+44>>2]=f+b;Va(j,71,0,f);X:{e=Sg(s,b,1);if(!e){break X}b=(b|0)>0?b:0;k=0;while(1){if((b|0)==(k|0)){break X}Q=(k<<2)+e|0,R=nn(a,c,k),H[Q+20>>2]=R;F[H[e+16>>2]+k|0]=0;k=k+1|0;continue}}k=0;b=c;C=q&254;if((C|0)!=134){break W}}k=1;C=134;Y:{if(I[s+82|0]&32){break Y}b=c;while(1){d=H[b+52>>2];if(!(!d|(q|0)!=I[b|0])){k=k+1|0;b=d;continue}break}if(k>>>0<4){k=1;break Y}d=2;b=c;while(1)if(d>>>0>=k>>>0){k=1;break W}else{d=d+2|0;b=H[b+52>>2];continue}}b=c}p=H[b+52>>2];H[b+52>>2]=0;H[p+56>>2]=0;Q=p,R=rc(H[a>>2],g,0),H[Q+48>>2]=R;gs(a,c,H[c+48>>2],18830);gs(a,p,H[p+48>>2],18830);kj(a,c,h);d=0;g=H[c+8>>2];if(!(!g|(q|0)!=135)){d=H[a+44>>2];x=d+2|0;H[a+44>>2]=x;t=H[c+12>>2];d=d+1|0;Va(j,80,t?t+1|0:g,d);Va(j,80,d,x)}fb(s,H[c+60>>2]);H[c+60>>2]=0;g=H[a+44>>2];z=g+4|0;H[a+44>>2]=z;A=u+48|0;t=g+1|0;Pd(A,13,t);B=u+16|0;w=g+2|0;Pd(B,13,w);Q=u,R=ij(I[c|0]),H[Q>>2]=R;qc(a,1,24355,u);D=Xa(j,10,t,0,H[j+108>>2]+1|0);H[p+8>>2]=d;qc(a,1,18157,0);Sc(a,p,A);oj(j,t);bb(j,D);D=Xa(j,10,w,0,H[j+108>>2]+1|0);d=H[c+12>>2];K=H[c+8>>2];H[c+12>>2]=0;H[c+8>>2]=x;qc(a,1,18138,0);Sc(a,c,B);H[c+8>>2]=K;H[c+12>>2]=d;oj(j,w);d=g+3|0;x=xB(a,c,A,n,d,f,e,h);if(k){r=xB(a,c,u+16|0,n,z,f,e,h)}Fj(e);f=h;e=f;if((C|0)!=136){e=Va(j,9,z,r);f=Va(j,11,w,h);Yb(j,e);Q=c,R=Je(G[c+2>>1],G[p+2>>1]),G[Q+2>>1]=R}Z:{if((q|0)==137){g=e;n=G[p+2>>1];if((n|0)>=G[c+2>>1]){break Z}G[c+2>>1]=n;break Z}g=Va(j,9,d,x);Va(j,11,t,h);Yb(j,g)}c=Va(j,9,d,x);Va(j,11,t,e);Yb(j,v);_:{if((q|0)==135){d=c;break _}if((q|0)==137){d=c;c=d+1|0;break _}d=Va(j,11,t,e);Yb(j,v)}e=H[j+108>>2];if(k){Va(j,9,z,r)}Va(j,11,w,g);Yb(j,v);bb(j,D);Va(j,11,t,f);Va(j,11,w,g);lb(j,v);kb(j,89,0,0,0,y,-14);kb(j,90,H[u+60>>2],H[u+28>>2],m,E,-8);pb(j,1);Xa(j,13,c,d,e);lb(j,h);c=H[b+52>>2];if(c){we(a,49,c)}H[b+52>>2]=p;H[p+56>>2]=b;qb(s,H[p+48>>2]);H[p+48>>2]=0;Mh(a);b=H[a+36>>2]!=0}Ga=u+80|0;e=b;break F}if(!H[f+52>>2]){qc(a,1,17727,0);qc(a,1,17708,0)}$:{aa:{switch(I[b|0]-134|0){case 1:H[i+32>>2]=0;H[f+8>>2]=H[b+8>>2];H[f+12>>2]=H[b+12>>2];H[f+60>>2]=H[b+60>>2];e=Sc(a,f,i- -64|0);H[f+60>>2]=0;if(e){break G}H[b+52>>2]=0;e=H[f+8>>2];H[b+8>>2]=e;H[b+12>>2]=H[f+12>>2];d=0;ba:{if(!e){break ba}d=db(n,16,e);e=H[b+12>>2];if(!e){break ba}Xa(n,160,H[b+8>>2],e+1|0,e)}qc(a,1,19463,0);e=Sc(a,b,i- -64|0);k=H[b+52>>2];H[b+52>>2]=f;f=Je(G[b+2>>1],G[f+2>>1]);G[b+2>>1]=f;h=H[b+60>>2];ca:{if(!h){break ca}if(!Ng(H[h+12>>2],i+32|0)){break ca}h=H[i+32>>2];if((h|0)<=0){break ca}g=f;f=je(h,0);if((g|0)<=(f|0)){break ca}G[b+2>>1]=f}if(!d){break $}bb(n,d);break $;case 0:case 2:da:{if(I[i+64|0]==1){d=H[i+68>>2];break da}d=H[a+40>>2];H[a+40>>2]=d+1;Q=b,R=Va(n,118,d,0),H[Q+20>>2]=R;e=ms(b);H[e+4>>2]=H[e+4>>2]|32}e=i+32|0;Pd(e,1,d);e=Sc(a,f,e);if(!e){H[b+52>>2]=0;h=H[b+60>>2];H[b+60>>2]=0;e=I[b|0];F[i+32|0]=(e|0)==136?2:1;Q=i,R=ij(e),H[Q+16>>2]=R;qc(a,1,19633,i+16|0);e=Sc(a,b,i+32|0);H[b+48>>2]=0;k=H[b+52>>2];H[b+52>>2]=f;if(I[b|0]==134){Q=b,R=Je(G[b+2>>1],G[f+2>>1]),G[Q+2>>1]=R}fb(p,H[b+60>>2]);H[b+8>>2]=0;H[b+12>>2]=0;H[b+60>>2]=h;if(I[p+87|0]|I[i+64|0]==1){break $}f=jb(a);h=jb(a);kj(a,b,f);Va(n,35,d,f);g=H[n+108>>2];bg(a,b,d,0,0,i- -64|0,h,f);lb(n,h);Va(n,38,d,g);lb(n,f);Va(n,122,d,0);break $}break G;default:break aa}}d=H[a+40>>2];H[a+40>>2]=d+2;Q=b,R=Va(n,118,d,0),H[Q+20>>2]=R;e=ms(b);H[e+4>>2]=H[e+4>>2]|32;e=i+32|0;Pd(e,1,d);e=Sc(a,f,e);if(e){break G}h=d+1|0;e=Va(n,118,h,0);H[b+52>>2]=0;H[b+24>>2]=e;g=H[b+60>>2];H[b+60>>2]=0;H[i+36>>2]=h;Q=i,R=ij(I[b|0]),H[Q>>2]=R;qc(a,1,19633,i);e=Sc(a,b,i+32|0);k=H[b+52>>2];H[b+52>>2]=f;f=G[f+2>>1];if((f|0)<G[b+2>>1]){G[b+2>>1]=f}fb(p,H[b+60>>2]);H[b+60>>2]=g;if(e){break $}f=jb(a);g=jb(a);kj(a,b,f);Va(n,35,d,f);j=Db(a);m=Va(n,134,d,j);ob(n,27,h,g,j,0);xb(a,j);bg(a,b,d,0,0,i- -64|0,g,f);lb(n,g);Va(n,38,d,m);lb(n,f);Va(n,122,h,0);Va(n,122,d,0)}if(H[b+56>>2]){break I}Mh(a)}if(H[a+36>>2]|!(I[b+4|0]&32)){break G}f=H[H[b+28>>2]>>2];g=Sg(p,f,1);if(!g){e=7;break G}d=0;j=(f|0)>0?f:0;h=g+20|0;while(1){if((d|0)==(j|0)){while(1){d=0;if(b){while(1){ea:{if((d|0)==2){break ea}j=(d<<2)+b|0;h=H[j+20>>2];if((h|0)<0){break ea}$i(n,h,f);le(n,h,Zk(g),-8);H[j+20>>2]=-1;d=d+1|0;continue}break}b=H[b+52>>2];continue}break}Fj(g);break G}m=nn(a,b,d);H[h>>2]=m;if(!m){H[h>>2]=H[p+8>>2]}h=h+4|0;d=d+1|0;continue}}H[c+12>>2]=H[i+76>>2];H[c+16>>2]=H[i+80>>2];if(!k){break F}we(a,49,k)}Ga=i+96|0;h=e;if(!H[l+56>>2]){break b}break a}H[o+104>>2]=p;b=H[l+36>>2];if(!(I[u+81|0]&128|(!b|I[b|0]!=44))){b=Ga+-64|0;Ga=b;H[b+32>>2]=a;H[b+36>>2]=H[a>>2]+87;while(1){H[b+56>>2]=0;H[b+40>>2]=0;H[b+44>>2]=0;H[b+48>>2]=0;d=H[l+32>>2];fa:{if(!(!d|H[d>>2]<=0)){e=3;if(I[d+44|0]&64){break fa}}e=1}H[b+52>>2]=e;PB(b+32|0,H[l+36>>2]);if(H[b+40>>2]){H[b+12>>2]=0;H[b+16>>2]=0;H[b+8>>2]=50;H[b+4>>2]=51;H[b>>2]=a;H[b+20>>2]=0;H[b+24>>2]=b+32;Kb(b,H[l+36>>2]);_a(H[H[b+32>>2]>>2],H[b+56>>2])}if(H[b+44>>2]){continue}break}Ga=b- -64|0}f=0;while(1){if(H[h>>2]>(f|0)){d=(f<<6)+h|0;ga:{if(H[d+56>>2]|H[d+60>>2]){break ga}b=H[d+16>>2];if(!b){break ga}cc(a,20,b,29357,H[d+12>>2])}k=H[d+28>>2];if(k){g=d+8|0;Q=a,R=Ss(l)+H[a+216>>2]|0,H[Q+216>>2]=R;ha:{if(I[u+81|0]&16){break ha}if(F[d+46|0]&1){b=H[d+68>>2];if(!I[b+18|0]|H[b>>2]>1){break ha}}Rs(a,k,H[l+36>>2],g)}j=H[a+248>>2];H[a+248>>2]=H[d+16>>2];ia:{if(!((I[h+108|0]&34?0:H[h>>2]!=1)|f|(I[h+44|0]&64|(I[H[h+68>>2]+18|0]?0:F[h+46|0]&1)))){b=H[n+108>>2];d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[h+36>>2]=d;e=d;d=b+1|0;Xa(n,10,e,0,d);H[h+32>>2]=d;d=o- -64|0;Pd(d,13,H[h+36>>2]);H[o+16>>2]=g;qc(a,1,18694,o+16|0);Sc(a,k,d);G[H[h+24>>2]+38>>1]=J[k+2>>1];d=I[h+45|0]|I[h+46|0]<<8|32;F[h+45|0]=d;F[h+46|0]=d>>>8;H[h+40>>2]=H[o+76>>2];oj(n,H[h+36>>2]);bb(n,b);lj(a);break ia}ja:{if(!(F[d+46|0]&1)){break ja}b=H[d+68>>2];e=H[b+4>>2];if((e|0)<=0){break ja}Va(n,9,H[b+8>>2],e);d=H[d+48>>2];e=H[b+12>>2];if((d|0)!=(e|0)){Va(n,115,d,e)}G[k+2>>1]=J[b+16>>1];break ia}e=0;ka:{m=H[g+20>>2];if(F[m+7|0]&1){break ka}b=h+8|0;while(1){if(b>>>0>=g>>>0){break ka}la:{i=H[b+20>>2];if(!i|I[b+37|0]&32){break la}p=H[b+8>>2];if(!p){break la}q=H[H[b+16>>2]+60>>2];if((q|0)!=H[H[g+16>>2]+60>>2]){break la}if(Qb(p,H[g+8>>2])|!q&H[m+16>>2]!=H[i+16>>2]|F[i+7|0]&1){break la}e=b;break ka}b=b- -64|0;continue}}if(e){b=H[e+24>>2];if(b){Va(n,9,H[e+28>>2],b)}Va(n,115,H[d+48>>2],H[e+40>>2]);G[k+2>>1]=J[H[e+20>>2]+2>>1];break ia}b=H[a+44>>2]+1|0;H[a+44>>2]=b;H[d+36>>2]=b;b=Sb(n,8);e=b+1|0;H[d+32>>2]=e;m=I[d+45|0]|I[d+46|0]<<8;i=m|16;F[d+45|0]=i;F[d+46|0]=i>>>8;i=0;if(!(m&8)){i=Sb(n,14)}m=o- -64|0;Pd(m,12,H[d+48>>2]);H[o+32>>2]=g;qc(a,1,18678,o+32|0);Sc(a,k,m);G[H[d+24>>2]+38>>1]=J[k+2>>1];if(i){bb(n,i)}Va(n,67,H[d+36>>2],e);bb(n,b);lj(a);if(((I[d+45|0]|I[d+46|0]<<8)&264)!=256){break ia}b=H[d+68>>2];H[b+4>>2]=H[d+32>>2];H[b+8>>2]=H[d+36>>2];H[b+12>>2]=H[d+48>>2];G[b+16>>1]=J[k+2>>1]}if(I[u+87|0]){break j}b=Ss(l);H[a+248>>2]=j;H[a+216>>2]=H[a+216>>2]-b}f=f+1|0;continue}break}t=H[l+44>>2];d=H[l+40>>2];k=H[l+36>>2];q=H[l+28>>2];e=H[l+4>>2];F[o+144|0]=e&1;b=H[o+104>>2];ma:{if((e&9)!=1){break ma}if(dg(b,q,-1)|H[l+68>>2]){break ma}H[l+4>>2]=H[l+4>>2]&-2;d=rc(u,q,0);H[l+40>>2]=d;H[l+4>>2]=H[l+4>>2]|8;F[o+144|0]=2}if(b){f=Bf(a,b,0,H[q>>2]);e=H[a+40>>2];H[a+40>>2]=e+1;H[o+112>>2]=e;b=kb(n,118,e,(H[b>>2]+H[q>>2]|0)+1|0,0,f,-8)}else{b=-1}H[o+124>>2]=b;na:{if(I[c|0]!=12){break na}Va(n,118,H[c+4>>2],H[q>>2]);if(!(I[l+5|0]&8)){break na}f=H[q>>2];b=f;while(1){oa:{if((b|0)<2){break oa}b=b-1|0;e=q+(b<<4)|0;if(I[e+17|0]&64){break oa}fb(u,H[e+8>>2]);_a(u,H[e+12>>2]);f=H[q>>2]-1|0;H[q>>2]=f;continue}break}b=0;e=(f|0)>0?f:0;while(1){if((b|0)==(e|0)){break na}f=q+(b<<4)|0;if(!(I[f+17|0]&64)){F[H[f+8>>2]]=121}b=b+1|0;continue}}E=jb(a);if(!(I[l+5|0]&64)){G[l+2>>1]=320}kj(a,l,E);pa:{if(H[l+8>>2]){break pa}b=H[o+124>>2];if((b|0)<0){break pa}Qs(n,b,119);F[o+136|0]=I[o+136|0]|1}if(F[l+4|0]&1){b=H[a+40>>2];H[a+40>>2]=b+1;H[o+148>>2]=b;Q=o,R=kb(n,118,b,0,0,Bf(a,H[l+28>>2],0,0),-8),H[Q+152>>2]=R;pb(n,8);b=3}else{b=0}F[o+145|0]=b;if(!(d|s)){i=I[o+144|0];j=H[l+4>>2]&16384|((i|0)!=0)<<8;m=H[l+68>>2];if(m){d=H[H[H[H[l+32>>2]+28>>2]+28>>2]>>2];b=H[l+68>>2];e=zb(a);Va(e,118,H[b+48>>2],d);d=H[b+48>>2];Va(e,115,d+1|0,d);d=H[b+48>>2];Va(e,115,d+2|0,d);d=H[b+48>>2];Va(e,115,d+3|0,d);d=H[b+8>>2];if(d){d=H[d>>2];f=H[a+44>>2];g=f+1|0;H[b+68>>2]=g;d=d+f|0;H[a+44>>2]=d;Xa(e,75,0,g,d)}d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[b+84>>2]=d;Va(e,71,1,d);qa:{if(!I[b+20|0]){d=b;while(1){if(!d){break qa}f=H[d+44>>2];ra:{if(!(!(I[f+5|0]&16)|I[d+17|0]==90)){f=Bf(a,H[H[d+72>>2]+20>>2],0,0);g=H[a+40>>2];H[a+40>>2]=g+1;H[d+60>>2]=g;p=H[a+44>>2];H[d+64>>2]=p+1;H[a+44>>2]=p+3;if(!(!f|I[H[H[d+44>>2]+32>>2]+1|0]!=105)){F[H[f+16>>2]]=1;g=H[d+60>>2]}Va(e,118,g,2);Pc(e,f,-8);Va(e,71,0,H[d+64>>2]+1|0);break ra}f=H[f+32>>2];if(!((f|0)!=48688&(f|0)!=48698)){g=H[a+44>>2];H[d+64>>2]=g+1;f=H[a+40>>2];H[a+40>>2]=f+1;H[d+60>>2]=f;H[a+44>>2]=g+2;Va(e,115,f,H[b+48>>2]);break ra}if((f|0)!=48466&(f|0)!=48471){break ra}f=H[a+40>>2];H[a+40>>2]=f+1;H[d+60>>2]=f;Va(e,115,f,H[b+48>>2])}d=H[d+36>>2];continue}}d=H[a+44>>2];f=d+1|0;H[b+88>>2]=f;d=d+2|0;H[a+44>>2]=d;H[b+92>>2]=d;d=H[a+40>>2];H[a+40>>2]=d+1;H[b+60>>2]=d;Va(e,71,1,f);Va(e,71,0,H[b+92>>2]);Va(e,115,H[b+60>>2],H[b+48>>2])}}d=H[o+104>>2];b=Af(a,h,k,d,H[l+28>>2],l,j,G[l+2>>1]);if(!b){break j}e=G[b+54>>1];if((e|0)<G[l+2>>1]){G[l+2>>1]=e}sa:{if(!i){break sa}e=I[b+51|0];if(!e){break sa}F[o+145|0]=e}f=0;ta:{if(!d){break ta}h=F[b+49|0];H[o+108>>2]=h;if(I[b+52|0]&4){e=b+N(I[b+48|0],96)|0;e=H[e+728>>2]?b+32|0:e+688|0}else{e=b+32|0}H[o+132>>2]=H[e>>2];f=d;if((h|0)!=H[d>>2]){break ta}f=0;H[o+104>>2]=0}d=H[o+124>>2];if(!((d|0)<0|f)){ue(n,d)}if(m){z=jb(a);C=jb(a);x=jb(a);A=H[a+44>>2]+1|0;H[a+44>>2]=A;g=b;d=0;p=0;f=0;s=0;j=Ga+-64|0;Ga=j;e=H[l+68>>2];t=H[e+12>>2];i=zb(a);b=H[l+32>>2];D=H[b+48>>2];r=G[H[b+24>>2]+34>>1];w=jb(a);$a(j+28|0,0,36);H[j+24>>2]=A;H[j+16>>2]=i;H[j+12>>2]=e;H[j+8>>2]=a;H[j+20>>2]=z;y=H[e+48>>2];H[j+48>>2]=y;H[j+56>>2]=y+3;m=2;H[j+40>>2]=y+2;ua:{va:{wa:{switch(I[e+17|0]-86|0){case 0:if(I[e+16|0]==89){break ua}m=1;if(JB(a,H[e+24>>2])){break va}break ua;case 4:break wa;default:break va}}m=1;xa:{b=e;if(H[b+88>>2]){break xa}while(1){if(!b){m=0;break xa}h=H[H[b+44>>2]+32>>2];if((h|0)==48471|(h|0)==48466|((h|0)==48688|(h|0)==48698)){break xa}b=H[b+36>>2];continue}}if(m){break ua}m=1;if(I[e+18|0]!=88){break va}if(I[e+16|0]==89){break ua}m=3;if(!JB(a,H[e+28>>2])){break ua}}H[j+32>>2]=m}k=H[a+44>>2];B=k+r|0;h=B+2|0;H[a+44>>2]=h;H[j+36>>2]=h;b=h;ya:{switch(I[e+17|0]-86|0){case 0:case 2:b=B+3|0;H[a+44>>2]=b;f=b;break;default:break ya}}za:{switch(I[e+18|0]-86|0){case 0:case 2:b=b+1|0;H[a+44>>2]=b;d=b;break;default:break za}}v=k+1|0;m=0;if(I[e+16|0]!=76){k=t?H[t>>2]:0;s=v+H[e+76>>2]|0;p=H[e+8>>2];if(p){s=H[p>>2]+s|0}p=b+k|0;H[j+44>>2]=p+1;p=k+p|0;H[j+52>>2]=p+1;p=k+p|0;H[j+60>>2]=p+1;H[a+44>>2]=k+p;p=b+1|0}k=B+1|0;b=(r|0)>0?r:0;while(1){if((b|0)!=(m|0)){Xa(i,94,D,m,m+v|0);m=m+1|0;continue}break}Xa(i,97,v,r,k);m=0;b=0;r=H[e+8>>2];if(r){B=H[r>>2];b=H[e+76>>2];r=Bf(a,r,0,0);m=H[a+44>>2]+1|0;H[a+44>>2]=m;v=b+v|0;b=Xa(i,90,v,H[e+68>>2],B);Pc(i,r,-8);r=b+2|0;Xa(i,13,r,b+4|0,r);b=db(i,9,m);Xa(i,80,v,H[e+68>>2],B-1|0)}v=y+1|0;Va(i,127,v,h);Xa(i,128,v,k,h);B=Xa(i,52,H[e+84>>2],0,h);r=0;h=zb(a);k=e;while(1){if(e){y=H[e+44>>2];Va(h,75,0,H[e+52>>2]);D=Jr(e);K=(D|0)<(r|0);Aa:{if(H[k+88>>2]){break Aa}L=H[y+32>>2];if(!((L|0)!=48688&(L|0)!=48698)){Va(h,71,0,H[e+64>>2]);Va(h,71,0,H[e+64>>2]+1|0)}if(!(I[y+5|0]&16)){break Aa}y=H[e+60>>2];if(!y){break Aa}db(h,146,y);Va(h,71,0,H[e+64>>2]+1|0)}r=K?r:D;e=H[e+36>>2];continue}break}e=H[a+44>>2];H[a+44>>2]=e+r;H[j+28>>2]=e+1;if(f){oc(a,H[k+24>>2],f);Xr(a,f,I[k+16|0]==89?3:0)}if(d){oc(a,H[k+28>>2],d);Xr(a,d,I[k+16|0]==89?4:1)}Ba:{if(I[k+16|0]!=89){h=I[k+17|0];if(!f|(h|0)!=I[k+18|0]){break Ba}e=Xa(i,(h|0)==86?57:55,f,0,d);h=j+8|0;Wr(h,0);Va(i,35,H[j+48>>2],1);IB(h);db(i,146,H[j+48>>2]);Va(i,8,0,w);bb(i,e)}h=I[k+17|0]}Ca:{Da:{if((h&255)==86){if(!d|I[k+16|0]==89){break Da}Xa(i,107,f,d,f);h=I[k+17|0]}if((h&255)==90){break Ca}}Va(i,35,H[j+40>>2],1)}Va(i,35,H[j+48>>2],1);Va(i,35,H[j+56>>2],1);if(!(!p|!t)){Xa(i,80,s,p,H[t>>2]-1|0);Xa(i,80,p,H[j+44>>2],H[t>>2]-1|0);Xa(i,80,p,H[j+52>>2],H[t>>2]-1|0);Xa(i,80,p,H[j+60>>2],H[t>>2]-1|0)}Va(i,8,0,w);bb(i,B);if(p){HB(a,t,s,p,w)}e=I[k+17|0];Ea:{if((e|0)==86){jc(j+8|0,3,0,0);if(I[k+18|0]==90){break Ea}if(I[k+16|0]==89){e=jb(a);p=H[i+108>>2];h=j+8|0;Mk(h,57,H[j+48>>2],d,H[j+56>>2],e);jc(h,2,f,0);jc(h,1,0,0);Va(i,8,0,p);lb(i,e);break Ea}e=j+8|0;jc(e,1,d,0);jc(e,2,f,0);break Ea}if(I[k+18|0]==88){Fa:{if((e|0)==88){e=I[k+16|0];jc(j+8|0,3,d,0);if((e|0)!=89){break Fa}e=j+8|0;jc(e,2,f,0);jc(e,1,0,0);break Ea}jc(j+8|0,3,d,0)}e=j+8|0;jc(e,1,0,0);jc(e,2,f,0);break Ea}jc(j+8|0,3,0,0);if(I[k+18|0]==90){break Ea}if(I[k+16|0]==89){e=H[i+108>>2];h=0;if(d){h=jb(a);Mk(j+8|0,57,H[j+48>>2],d,H[j+56>>2],h)}p=j+8|0;jc(p,1,0,0);jc(p,2,f,0);if(!d){break Ea}Va(i,8,0,e);lb(i,h);break Ea}h=0;if(d){h=Xa(i,49,d,0,1)}e=j+8|0;jc(e,1,0,0);jc(e,2,f,0);if(!d){break Ea}bb(i,h)}lb(i,w);Ed(g);h=0;if(H[k+8>>2]){h=Va(i,71,0,m);bb(i,b)}H[j+36>>2]=0;g=db(i,35,v);b=I[k+17|0];Ga:{if(I[k+18|0]==88){Ha:{if((b|0)==88){b=I[k+16|0];jc(j+8|0,3,d,0);if((b|0)!=89){break Ha}jc(j+8|0,2,f,0);break Ha}jc(j+8|0,3,d,0)}jc(j+8|0,1,0,0);break Ga}jc(j+8|0,3,0,0);if((b|0)==86){Ia:{if(I[k+16|0]==89){e=H[i+108>>2];d=j+8|0;b=jc(d,2,f,1);d=jc(d,1,0,1);break Ia}e=H[i+108>>2];if(I[k+18|0]==90){b=j+8|0;d=jc(b,1,f,1);b=jc(b,2,0,1);break Ia}b=j+8|0;d=jc(b,1,d,1);b=jc(b,2,f,1)}Va(i,8,0,e);bb(i,b);b=H[i+108>>2];e=jc(j+8|0,1,0,1);Va(i,8,0,b);bb(i,d);bb(i,e);break Ga}b=H[i+108>>2];d=j+8|0;e=jc(d,1,0,1);jc(d,2,f,0);Va(i,8,0,b);bb(i,e)}bb(i,g);db(i,146,H[j+48>>2]);if(H[k+8>>2]){b=H[k+88>>2];if(b){Va(i,71,1,b);Va(i,71,0,H[k+92>>2])}GB(i,h,H[i+108>>2]);db(i,67,m)}Ga=j- -64|0;Va(n,8,0,x);lb(n,z);H[o+132>>2]=0;bg(a,l,-1,o+104|0,o+144|0,c,C,x);lb(n,C);db(n,67,A);lb(n,x);break k}bg(a,l,-1,o+104|0,o+144|0,c,H[b+32>>2],H[b+36>>2]);Ed(b);break k}Ja:{if(d){b=H[l+28>>2];f=b+8|0;b=H[b>>2];while(1){if((b|0)>0){G[f+14>>1]=0;f=f+16|0;b=b-1|0;continue}break}f=d+8|0;b=H[d>>2];while(1){if((b|0)>0){G[f+14>>1]=0;f=f+16|0;b=b-1|0;continue}break}if(G[l+2>>1]>=67){G[l+2>>1]=66}p=0;e=H[o+104>>2];if(!e){break Ja}f=H[d>>2];if((f|0)!=H[e>>2]){break Ja}b=0;f=(f|0)>0?f:0;while(1){if((b|0)!=(f|0)){g=b<<4;F[(g+d|0)+16|0]=F[(e+g|0)+16|0]&1;b=b+1|0;continue}break}p=!dg(d,e,-1);break Ja}p=0;G[l+2>>1]=0}j=jb(a);g=yb(u,52,0);if(g){we(a,34,g)}if(I[u+87|0]){break j}H[g+48>>2]=H[l+16>>2];b=0;H[o+92>>2]=0;H[o+84>>2]=0;H[o+88>>2]=0;H[o+76>>2]=0;H[o+80>>2]=0;H[o+72>>2]=g;H[o+68>>2]=h;H[o+64>>2]=a;H[g+16>>2]=H[a+44>>2]+1;b=d?H[d>>2]:b;H[g+24>>2]=d;H[g+12>>2]=b;b=o- -64|0;Yn(b,q);Yn(b,H[o+104>>2]);if(t){if(d){b=Ga-32|0;Ga=b;H[b+16>>2]=0;H[b+20>>2]=0;H[b+8>>2]=0;H[b+12>>2]=0;H[b+4>>2]=52;H[b>>2]=a;H[b+24>>2]=l;Kb(b,H[l+44>>2]);Ga=b+32|0;k=H[l+36>>2]}Xn(o- -64|0,t)}H[g+36>>2]=H[g+32>>2];b=0;f=0;Ka:{if(H[l+40>>2]){break Ka}if(H[l+44>>2]){break Ka}if(H[g+44>>2]!=1){break Ka}i=H[H[g+40>>2]>>2];e=H[i+20>>2];La:{if(!e|H[e>>2]!=1|(F[i+7|0]&1|F[u+82|0]&1)){break La}i=H[i+8>>2];Ma:{if(!hb(i,10665)){i=(($f(H[e+8>>2])|0)!=0)<<1;f=1;break Ma}if(hb(i,1547)){break La}i=1;f=2}e=rc(u,e,0);H[o+100>>2]=e;if(!e){break La}F[e+16|0]=i}}e=f;while(1){f=H[g+44>>2];if((f|0)>(b|0)){f=H[H[g+40>>2]+N(b,20)>>2];H[o+88>>2]=H[o+88>>2]|131072;Yn(o- -64|0,H[f+20>>2]);if(F[f+7|0]&1){Xn(o- -64|0,H[H[f+44>>2]+40>>2])}H[o+88>>2]=H[o+88>>2]&-131073;b=b+1|0;continue}break}i=H[a+44>>2];H[g+20>>2]=i;if(I[u+87|0]){break j}if(d){i=0;b=0;if((f|0)!=1){break m}b=H[g+40>>2];if(H[b+12>>2]<0){break n}e=H[b>>2];if(!e){break n}b=0;if(I[e+5|0]&16){break m}b=H[e+20>>2];if(!b){break n}b=nb(u,H[b+8>>2],0);i=sb(a,rc(u,d,0),b);b=i?1280:0;break m}b=0;Na:{if(H[l+36>>2]){break Na}m=H[l+28>>2];if(H[m>>2]!=1){break Na}d=H[l+32>>2];if(H[d>>2]!=1|H[d+28>>2]|(H[l+44>>2]|H[g+44>>2]!=1)){break Na}p=H[d+24>>2];if(I[p+43|0]){break Na}d=H[m+8>>2];if(!(F[H[H[g+40>>2]+4>>2]+5|0]&1)|(I[d|0]!=168|(g|0)!=H[d+40>>2])){break Na}b=H[d+4>>2]&16777220?0:p}if(b){f=Lb(H[a>>2],H[b+60>>2]);i=H[a+40>>2];H[a+40>>2]=i+1;k=H[b+20>>2];Fd(a,f);d=0;Dd(a,f,H[b+20>>2],0,H[b>>2]);if(I[b+28|0]&128){d=tc(b)}Oa:{if(F[H[l+32>>2]+45|0]&1){break Oa}h=b+8|0;while(1){e=H[h>>2];if(!e){break Oa}Pa:{if(I[e+55|0]&4){break Pa}h=G[e+48>>1];if(H[e+36>>2]|(h|0)>=G[b+40>>1]|((h|0)>=G[d+48>>1]?d:0)){break Pa}d=e}h=e+20|0;continue}}if(d){k=H[d+44>>2];e=_k(a,d)}else{e=0}ob(n,112,i,k,f,1);if(e){le(n,-1,e,-8)}Va(n,98,i,H[H[g+40>>2]+8>>2]);db(n,122,i);e=Ga-16|0;Ga=e;if(I[a+207|0]==2){Qa:{if(!d){b=H[b>>2];h=29357;f=29357;break Qa}Ra:{if(!(I[b+28|0]&128)){b=H[b>>2];break Ra}b=H[b>>2];h=29357;f=29357;if(((I[d+55|0]|I[d+56|0]<<8)&3)==2){break Qa}}h=H[d>>2];f=28800}H[e+8>>2]=h;H[e+4>>2]=f;H[e>>2]=b;qc(a,0,5743,e)}Ga=e+16|0;break o}if(!H[g+36>>2]){break r}b=0;d=(f|0)>0?f:0;while(1){Sa:{if((b|0)!=(d|0)){m=H[g+40>>2]+N(b,20)|0;if(F[H[m>>2]+7|0]&1|!(I[H[m+4>>2]+4|0]&32)){break Sa}}else{b=d}if((b|0)!=(f|0)){break q}b=i+1|0;H[a+44>>2]=b;f=0;Va(n,71,0,b);d=0;break p}b=b+1|0;continue}}H[o+104>>2]=p;break j}if((f|0)!=1){break q}d=H[g+40>>2];if(H[d+12>>2]<0){break q}b=0;f=H[H[d>>2]+20>>2];d=f?1280:0;break p}b=0;f=0;d=0}Ps(a,g);d=Af(a,h,k,H[o+100>>2],f,0,d|e,0);if(!d){break j}f=I[d+51|0];Os(a,b,g,f);Ta:{if(!f){break Ta}h=H[g+40>>2];if(!h){break Ta}Wn(a,f,H[h+12>>2],H[h+16>>2])}if(b){Va(n,71,1,b)}if(!(I[d+52|0]&4)|!I[d+49|0]?0:e){b=I[d+48|0];Ua:{Va:{while(1){if((b|0)<=0){break Va}b=b-1|0;if(!(I[H[(d+N(b,96)|0)+848>>2]+40|0]&4)){continue}break}b=(d+N(b,96)|0)+784|0;break Ua}b=d+36|0}Yb(n,H[b>>2])}Ed(d);Ns(a,g)}H[o+104>>2]=0;zc(a,t,j,16);bg(a,l,-1,0,0,c,j,j);break l}b=0}e=H[a+40>>2];H[a+40>>2]=e+1;H[g+4>>2]=e;C=Bf(a,d,0,H[g+32>>2]);L=kb(n,119,H[g+4>>2],H[g+12>>2],0,C,-8);A=H[a+44>>2];s=A+3|0;H[a+44>>2]=s;w=jb(a);v=H[a+44>>2]+1|0;H[a+44>>2]=v;x=jb(a);f=H[d>>2];e=H[a+44>>2];B=f+e|0;H[a+44>>2]=f+B;D=A+2|0;Va(n,71,0,D);K=e+1|0;Xa(n,75,0,K,e+H[d>>2]|0);Va(n,9,v,x);e=b;f=I[o+144|0];r=Af(a,h,k,d,i,0,b|(p<<9|((f|0)==2?128:64)),0);if(!r){qb(u,i);break j}y=I[r+51|0];h=0;k=0;M=F[r+49|0];O=H[d>>2];z=(M|0)==(O|0);if(!z){Vn(a,f?H[l+4>>2]&1?17915:18162:17915);b=H[g+32>>2];k=(b|0)>0?b:0;f=H[d>>2];m=f;b=f;while(1){if((h|0)!=(k|0)){P=G[(H[g+28>>2]+N(h,20)|0)+18>>1]>=(b|0);b=P+b|0;m=m+P|0;h=h+1|0;continue}break}h=0;b=Cc(a,m);Nh(a,d,b,0,0);while(1){if(H[g+32>>2]>(h|0)){k=H[g+28>>2]+N(h,20)|0;if(G[k+18>>1]>=(f|0)){Qc(n,H[k>>2],H[k+8>>2],G[k+16>>1],b+f|0);f=f+1|0}h=h+1|0;continue}break}f=Db(a);Xa(n,97,b,m,f);Va(n,139,H[g+4>>2],f);xb(a,f);md(a,b,m);Ed(r);k=H[a+40>>2];H[a+40>>2]=k+1;H[g+8>>2]=k;h=Db(a);Xa(n,121,k,h,m);Va(n,33,H[g+4>>2],j);F[g+1|0]=1}if(!(!p|I[u+80|0]&4|(I[r+52|0]>>>3&1?0:(M|0)==(O|0)))){H[o+104>>2]=0;ue(n,H[o+124>>2])}m=H[n+108>>2];if(!z){Xa(n,133,H[g+4>>2],h,k)}b=A+1|0;f=B+1|0;h=0;while(1){p=H[d>>2];if((p|0)>(h|0)){Wa:{if(!z){Xa(n,94,k,h,f+h|0);break Wa}F[g|0]=1;oc(a,H[((h<<4)+d|0)+8>>2],f+h|0)}h=h+1|0;continue}break}kb(n,90,K,f,p,Zk(C),-8);h=H[n+108>>2];k=h+1|0;Xa(n,13,k,0,k);jj(a,f,K,H[d>>2]);Va(n,9,s,w);Va(n,49,D,j);Va(n,9,v,x);bb(n,h);Os(a,b,g,y);Va(n,71,1,b);Xa:{if(!z){Va(n,36,H[g+4>>2],m);break Xa}Ed(r);ue(n,L)}qb(u,i);Va(n,9,s,w);Yb(n,j);d=H[n+108>>2];Va(n,71,1,D);db(n,67,s);lb(n,w);f=H[n+108>>2];Va(n,49,b,f+2|0);db(n,67,s);Ns(a,g);f=f+1|0;zc(a,t,f,16);bg(a,l,-1,o+104|0,o+144|0,c,f,d);db(n,67,s);lb(n,x);Ps(a,g);Va(n,71,0,b);db(n,67,v);if(!e|!y){break l}b=H[g+40>>2];Wn(a,y,H[b+12>>2],H[b+16>>2])}lb(n,j)}if(I[o+145|0]==3){Vn(a,18162)}if(H[o+104>>2]){Vn(a,H[o+108>>2]>0?17892:17906);b=H[q>>2];k=0;m=H[o+128>>2];g=H[a+8>>2];r=jb(a);t=H[l+28>>2];e=c;j=H[e+4>>2];p=I[e|0];c=H[o+104>>2];d=H[o+120>>2];if(d){Va(g,9,H[o+116>>2],d);Yb(g,m);lb(g,H[o+120>>2])}h=H[o+112>>2];Ya:{Za:{_a:{$a:{switch(p-9|0){case 0:case 4:break _a;case 1:break $a;default:break Za}}if(!H[l+12>>2]){break _a}Va(g,75,0,H[e+12>>2])}d=H[e+12>>2];break Ya}k=Db(a);if((p&253)==12){b=0;d=Db(a);break Ya}d=Cc(a,b)}i=H[c>>2]-H[o+108>>2]|0;q=1;ab:{if(F[o+136|0]&1){l=H[a+44>>2]+1|0;H[a+44>>2]=l;f=H[a+40>>2];H[a+40>>2]=f+1;if(H[o+120>>2]){c=Sb(g,14)}else{c=0}Xa(g,121,f,l,(b+i|0)+1|0);if(c){bb(g,c)}s=Va(g,33,h,m);Xa(g,133,h,l,f);q=0;break ab}s=Va(g,34,h,m);Lk(g,H[l+12>>2],r);if(H[l+12>>2]>0){Va(g,86,H[l+8>>2],-1)}f=h}l=t+8|0;c=0;t=(b|0)>0?b:0;w=i+q|0;i=w-1|0;bb:{cb:{db:{while(1){if((c|0)==(t|0)){eb:{c=b;while(1){if((c|0)>0){c=c-1|0;q=J[(l+(c<<4)|0)+12>>1];Xa(g,94,f,q?q-1|0:i,c+d|0);i=i-!q|0;continue}break}l=s+1|0;fb:{gb:{switch(p-9|0){case 3:case 5:Xa(g,94,f,w,d);Va(g,127,j,k);Xa(g,128,j,d,k);pb(g,8);break fb;case 6:c=H[e+8>>2];e=c>>>31|0;f=e+d|0;q=b-e|0;e=Db(a);Xa(g,97,f,q,e);if((c|0)<0){Xa(g,128,j,e,d);break fb}ob(g,138,j,e,d,c);break fb;case 0:Va(g,84,H[e+12>>2],b);break fb;case 2:break eb;case 1:break fb;default:break gb}}db(g,11,H[e+4>>2])}if(!k){break bb}if((p|0)==11){break db}xb(a,d);break cb}}else{i=!J[(l+(c<<4)|0)+12>>1]+i|0;c=c+1|0;continue}break}kb(g,97,d,b,k,H[e+20>>2],b);ob(g,138,j,k,d,b);if(!k){break bb}}md(a,d,b)}xb(a,k)}lb(g,r);Va(g,F[o+136|0]&1?36:38,h,l);b=H[o+116>>2];if(b){db(g,67,b)}lb(g,m)}lb(n,E);h=H[a+36>>2]>0;break c}h=1;break c}b=0}b=b+1|0;continue}}qb(u,H[o+100>>2])}Mh(a)}Ga=o+160|0;return h}function Af(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;K=Ga-32|0;Ga=K;n=H[a+8>>2];D=H[a>>2];H[K+28>>2]=0;H[K+20>>2]=0;H[K+24>>2]=0;l=d?H[d>>2]>63?0:d:l;d=H[b>>2];a:{b:{if((d|0)>=65){H[K>>2]=64;Za(a,10637,K);break b}o=g&32?1:d;k=N(o,96);j=k+775&-32;d=Tb(D,j+72|0,0);if(I[D+87|0]){_a(D,d);break b}H[d+16>>2]=c;H[d+8>>2]=l;H[d+4>>2]=b;H[d>>2]=a;H[d+12>>2]=e;F[d+48|0]=o;H[d+24>>2]=-1;H[d+28>>2]=-1;i=jb(a);G[d+46>>1]=h;G[d+44>>1]=g;H[d+36>>2]=i;H[d+32>>2]=i;i=H[a+136>>2];H[d+20>>2]=f;H[d+40>>2]=i;i=$a(d+49|0,0,39);p=d+768|0;$a(p,0,k+72|0);H[d+508>>2]=0;H[d+512>>2]=-99;k=d+j|0;H[K+16>>2]=k;E=d+88|0;H[K+12>>2]=E;H[K+8>>2]=d;mn(k);_r(E,d);ln(E,c,44);c:{if(o){x=d+504|0;while(1){c=(q<<6)+b|0;i=H[c+48>>2];k=H[x+4>>2];H[x+4>>2]=k+1;H[(x+(k<<2)|0)+8>>2]=i;j=0;m=0;k=Ga-16|0;Ga=k;d:{if(!(I[c+45|0]&4)){break d}s=H[c+64>>2];if(!s){break d}v=H[c+24>>2];while(1){if(H[s>>2]<=(m|0)){break d}i=G[v+34>>1];i=(i|0)<(j|0)?j:i;e:{while(1){if((i|0)==(j|0)){break e}if(!(I[(H[v+4>>2]+N(j,12)|0)+10|0]&2)){j=j+1|0;continue}break}i=Ac(H[a>>2],167,0,0);if(!i){break d}r=H[c+48>>2];H[i+44>>2]=v;G[i+32>>1]=j;H[i+28>>2]=r;r=H[c+60>>2];W=c,X=H[c+56>>2]|is(i),H[W+56>>2]=X;H[c+60>>2]=Ja|r;i=mb(a,53,i,mb(a,174,nb(H[a>>2],H[(s+(m<<4)|0)+8>>2],0),0));Xi(i,H[c+48>>2],I[c+44|0]&72?1:2);se(E,i,1);m=m+1|0;j=j+1|0;continue}break}c=H[v>>2];H[k+4>>2]=m;H[k>>2]=c;Za(a,16245,k)}Ga=k+16|0;q=q+1|0;if((q|0)<H[b>>2]){continue}break}break c}if(l){F[i|0]=H[l>>2]}if(!(!(g&256)|I[D+80|0]&16)){F[d+51|0]=1}qc(a,0,18005,0)}Zr(b,E);c=0;f:{if(!f){break f}j=H[f+60>>2];if(!j|I[f+4|0]&9){break f}i=H[f+32>>2];if(H[i>>2]!=1|I[H[i+24>>2]+43|0]!=1){break f}k=H[E+12>>2];q=(k|0)>0?k:0;i=H[i+48>>2];k=H[f+48>>2];while(1){if((c|0)!=(q|0)){v=H[E+24>>2]+N(c,48)|0;if(!(I[v+10|0]&4)&(i|0)!=H[v+20>>2]){break f}c=c+1|0;continue}break}g:{if(!k){break g}c=0;q=H[k>>2];q=(q|0)>0?q:0;while(1){if((c|0)==(q|0)){break g}v=k+(c<<4)|0;x=H[v+8>>2];if(I[x|0]!=167|(i|0)!=H[x+28>>2]){break f}c=c+1|0;if(!(I[v+16|0]&2)){continue}break}break f}uB(E,H[f+8>>2],H[j+12>>2],i,73);c=H[f+12>>2];if((c|0)<=0){break f}uB(E,c,H[H[f+60>>2]+16>>2],i,74)}h:{if(H[a+36>>2]){break h}q=0;while(1){if(H[d+108>>2]>(q|0)){f=H[d+112>>2]+N(q,48)|0;i:{if(I[f+10|0]&2|(H[f+40>>2]|H[f+44>>2])){break i}if(o){i=H[f>>2];c=Ga-32|0;Ga=c;H[c+8>>2]=0;H[c+12>>2]=0;H[c+16>>2]=0;H[c+20>>2]=0;H[c+24>>2]=0;H[c+8>>2]=59;H[c>>2]=0;H[c+4>>2]=0;H[c+4>>2]=81;G[c+20>>1]=1;Kb(c,i);Ga=c+32|0;if(!J[c+20>>1]){break i}}zc(a,H[f>>2],H[d+36>>2],16);G[f+10>>1]=J[f+10>>1]|4}q=q+1|0;continue}break}j:{if(!(g&256)){break j}if(I[D+80|0]&16){G[d+44>>1]=J[d+44>>1]&65279;g=g&65279;break j}j=0;k:{if(H[b>>2]!=1){break k}c=H[e>>2];i=(c|0)>0?c:0;j=H[b+24>>2];k=H[b+48>>2];c=0;l:{while(1){if((c|0)!=(i|0)){f=jd(H[((c<<4)+e|0)+8>>2]);m:{if(!f){break m}n:{switch(I[f|0]-167|0){case 0:case 2:break n;default:break m}}if((k|0)!=H[f+28>>2]){break m}if(G[f+32>>1]<0){break l}}c=c+1|0;continue}break}c=j+8|0;j=0;while(1){f=H[c>>2];if(!f){break k}if(!(H[f+36>>2]|!I[f+54|0])){c=0;while(1){o:{if(J[f+50>>1]<=c>>>0){break o}if(!Sr(E,k,c,-1,-1,2,f)){i=0;v=H[H[f+32>>2]+(c<<2)>>2];while(1){p:{if(H[e>>2]<=(i|0)){i=-1;break p}x=H[((i<<4)+e|0)+8>>2];q=jd(x);q:{if(!q){break q}r:{switch(I[q|0]-167|0){case 0:case 2:break r;default:break q}}if(J[q+32>>1]!=J[H[f+4>>2]+(c<<1)>>1]|(k|0)!=H[q+28>>2]){break q}if(!hb(H[Zf(a,x)>>2],v)){break p}}i=i+1|0;continue}break}if((i|0)<0){break o}if(!tB(f,c)){break o}}c=c+1|0;continue}break}if(J[f+50>>1]==(c|0)){break l}}c=f+20|0;continue}}j=1}if(j){F[d+51|0]=1;break j}if(l){break j}H[d+8>>2]=e;G[d+44>>1]=J[d+44>>1]|128}s:{t:{u:{if((o|0)==1){c=0;k=Ga-96|0;Ga=k;l=H[K+8>>2];v:{if(I[l+44|0]&32){break v}j=H[l+4>>2];i=H[j+24>>2];if(I[i+43|0]==1|I[j+45|0]&3){break v}v=H[j+48>>2];f=H[K+16>>2];G[f+46>>1]=0;H[f+40>>2]=0;x=l+88|0;c=hn(k,x,v,-1,130,0);w:{x:{y:{while(1){if(c){if(!(H[c+32>>2]|H[c+36>>2])){break y}c=Wi(k);continue}break}c=i+8|0;while(1){i=H[c>>2];if(i){z:{if(H[i+36>>2]|!I[i+54|0]){break z}c=J[i+50>>1];if(c>>>0>3){break z}m=I[i+55|0]&8?130:2;q=0;A:{while(1){c=c&65535;if(q>>>0>=c>>>0){break A}c=hn(k,x,v,q,m,i);B:{while(1){if(!c){break B}if(H[c+32>>2]|H[c+36>>2]){c=Wi(k);continue}break}H[H[f+52>>2]+(q<<2)>>2]=c;q=q+1|0;c=J[i+50>>1];continue}break}c=J[i+50>>1]}if((c|0)!=(q|0)){break z}m=4609;H[f+40>>2]=4609;if(H[i+64>>2]&H[j+56>>2]|H[i+68>>2]&H[j+60>>2]?I[i+55|0]&32:1){H[f+40>>2]=4673;m=4673}G[f+24>>1]=q;G[f+44>>1]=q;H[f+32>>2]=i;c=39;break x}c=i+20|0;continue}break}m=H[f+40>>2];if(m){break w}c=0;break v}m=4353;H[f+40>>2]=4353;H[H[f+52>>2]>>2]=c;G[f+24>>1]=1;G[f+44>>1]=1;c=33}G[f+20>>1]=c}G[f+22>>1]=1;H[l+848>>2]=f;H[f+8>>2]=1;H[f+12>>2]=0;G[l+54>>1]=1;H[l+772>>2]=v;c=H[l+8>>2];if(c){F[l+49|0]=H[c>>2]}if(F[l+45|0]&1){F[l+51|0]=1}c=1;if(I[k+25|0]<2){break v}H[f+40>>2]=m|2097152}Ga=k+96|0;if(c){break u}}l=0;m=0;s=0;q=K+8|0;c=H[q>>2];z=H[H[c>>2]>>2];f=H[c+4>>2];i=I[c+48|0];r=H[q+8>>2];mn(r);H[q+20>>2]=2e4;f=f+8|0;A=f+(i<<6)|0;L=c+504|0;C:{while(1){D:{if(f>>>0>=A>>>0){break D}F[r+16|0]=m;H[q+20>>2]=H[q+20>>2]+1e3;W=r,X=Ye(L,H[f+40>>2]),H[W+8>>2]=X;H[r+12>>2]=Ja;c=I[f+36|0];E:{if(c&98?1:s){u=u|w;t=t|y;s=c>>>4&1;l=c&64?1:l;break E}u=l?u:0;t=l?t:0;s=0;l=(l|0)!=0}k=0;i=0;F:{G:{c=f;H:{if(I[H[c+16>>2]+43|0]==1){while(1){I:{v=k;x=i;j=c;c=c- -64|0;if(A>>>0<=c>>>0){break I}if(!(v|x)){k=0;i=0;if(!(I[j+100|0]&34)){continue}}k=Ye(L,H[j+104>>2])|v;i=x|Ja;continue}break}c=sB(q,u,t,v,x);break H}v=0;x=0;c=rB(q,u,t)}J:{if(!c){if(!I[H[q+4>>2]+9|0]){w=w|H[r+8>>2];y=y|H[r+12>>2];break J}c=qB(q,u,t,v,x)}w=w|H[r+8>>2];y=y|H[r+12>>2];if((c|0)==101){break G}if(c){break C}}if(I[z+87|0]){break D}break F}Fc(28,11695,0)}f=f- -64|0;m=m+1|0;continue}break}c=0}pB(z,r);if(c){break h}NB(d,0);if(I[D+87|0]){break h}if(!H[d+8>>2]){break t}NB(d,(J[d+54>>1]<<16)+65536>>16);if(I[D+87|0]){break h}}if(H[d+8>>2]){break s}}if(!(I[D+33|0]&16)){break s}H[d+80>>2]=-1;H[d+84>>2]=-1}if(H[a+36>>2]){break h}v=-1;x=-1;q=I[d+48|0];K:{L:{if(!(!e|g&1024|q>>>0<2)){if(F[D+81|0]&1){break L}c=d+504|0;v=xf(c,H[d+12>>2]);x=Ja;e=H[d+8>>2];if(e){v=xf(c,e)|v;x=x|Ja}l=I[d+48|0];j=l;k=-1;i=-1;M:while(1){f=j;if((f|0)>=2){j=f-1|0;r=N(j,96)+d|0;c=H[r+848>>2];o=H[d+4>>2]+(I[c+16|0]<<6)|0;if((I[o+44|0]&24)!=8|!(I[c+41|0]&16?1:F[d+45|0]&1)){continue}q=H[c+8>>2];m=H[c+12>>2];if(v&q|x&m){continue}c=H[d+112>>2];s=c+N(H[d+100>>2],48)|0;e=c;while(1){if(e>>>0<s>>>0){if(q&H[e+40>>2]|m&H[e+44>>2]){u=H[e>>2];if(!(F[u+4|0]&1)|H[u+36>>2]!=H[o+48>>2]){continue M}}e=e+48|0;continue}break}e=r+768|0;while(1){if(c>>>0<s>>>0){if(q&H[c+40>>2]|m&H[c+44>>2]){G[c+10>>1]=J[c+10>>1]|4}c=c+48|0;continue}break}k=k&(q^-1);i=i&(m^-1);c=l&255;if((c|0)!=(f|0)){vd(e,(N(f,96)+d|0)+768|0,N(c-f|0,96));l=I[d+48|0]}l=l-1|0;F[d+48|0]=l;continue}break}q=I[d+48|0];o=q;x=i;v=k}if((q&255)>>>0<2){break K}}if(I[D+82|0]&8){break K}c=I[d+48|0];j=c>>>0>1?c:1;e=J[H[d+848>>2]+22>>1];c=1;while(1){if((c|0)!=(j|0)){f=H[(N(c,96)+d|0)+848>>2];i=H[f+40>>2];N:{if((i&8388609)!=8388609|!(i&768)){break N}l=H[(H[d+4>>2]+(I[f+16|0]<<6)|0)+24>>2];k=H[l+28>>2];H[l+28>>2]=k|256;if(!(k&16)|G[l+38>>1]>=e<<16>>16){break N}H[f+40>>2]=i&-4194369|4194304}c=c+1|0;e=J[f+22>>1]+e|0;continue}break}}c=H[d>>2];H[c+136>>2]=H[c+136>>2]+G[d+54>>1];e=0;O:{if(!(g&4)){break O}i=H[d+848>>2];f=H[i+40>>2];P:{if(f&4096){c=H[b+24>>2];l=1;break P}e=0;if(!(g&8)){break O}c=H[b+24>>2];e=0;if(I[c+43|0]==1){break O}l=2;if(g&16){break P}e=0;if(f&8192){break O}}F[d+50|0]=l;e=0;if(I[c+28|0]&128){break O}e=0;if(!(f&64)){break O}H[i+40>>2]=f&-65;e=g&8}l=e;S=(o|0)>0?o:0;o=g&32;u=!h|!o;f=0;while(1){if((f|0)!=(S|0)){m=(I[p+60|0]<<6)+b|0;j=H[m+24>>2];r=Lb(D,H[j+60>>2]);s=H[p+80>>2];Q:{if(I[j+29|0]&64){break Q}c=I[j+43|0];if((c|0)==2){break Q}e=H[s+40>>2];if(e&1024){kb(n,173,H[m+48>>2],0,0,Id(D,j),-11);break Q}if((c|0)==1){break Q}if(!(I[m+44|0]&80?0:o|e&64)){if(I[d+50|0]){H[d+24>>2]=H[m+48>>2];c=113}else{c=112}fe(a,H[m+48>>2],r,j,c);if(!(I[d+50|0]|G[j+34>>1]>63|(I[j+28|0]&224|H[s+40>>2]&4210688))){k=H[m+56>>2];i=H[m+60>>2];c=0;while(1){if(i|k){c=c+1|0;e=i;i=i>>>1|0;k=(e&1)<<31|k>>>1;continue}break}le(n,-1,c,-3)}pb(n,l);break Q}Dd(a,r,H[j+20>>2],0,H[j>>2])}R:{if(!(I[s+41|0]&2)){break R}S:{T:{e=H[s+32>>2];if(!(!(!(I[j+28|0]&128)|!o)&((I[e+55|0]|I[e+56|0]<<8)&3)==2)){if(I[d+50|0]){q=H[m+24>>2]+8|0;c=h;while(1){i=H[q>>2];if(!i|(e|0)==(i|0)){break T}q=i+20|0;c=c+1|0;continue}}c=h;i=101;if(!u){break S}c=H[a+40>>2];H[a+40>>2]=c+1;i=112;break S}H[p+8>>2]=H[p+4>>2];break R}H[d+28>>2]=c;i=113}H[p+8>>2]=c;Xa(n,i,c,H[e+44>>2],r);Od(a,e);c=H[s+40>>2];if(F[d+44|0]&1|(!(c&15)|c&32770|(c&524288|c&1048576))|I[d+51|0]==2){break R}pb(n,2)}if((r|0)>=0){Fd(a,r)}U:{if(!(I[m+44|0]&16)){break U}c=Yr(d,20);H[p+56>>2]=c;if(!c){break U}e=H[a+40>>2];H[a+40>>2]=e+1;H[c>>2]=e;e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[c+4>>2]=e;Va(n,77,65536,e);e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[c+8>>2]=e;Va(n,75,0,e);V:{if(!(I[j+28|0]&128)){Va(n,118,H[c>>2],1);c=Sg(H[a>>2],1,0);if(!c){break V}H[c+20>>2]=0;F[H[c+16>>2]]=0;Pc(n,c,-8);break V}e=H[c>>2];c=tc(j);Va(n,118,e,J[c+50>>1]);Od(a,c)}H[s+40>>2]=H[s+40>>2]&-65;F[d+51|0]=3;F[d+49|0]=0}p=p+96|0;f=f+1|0;continue}break}H[d+56>>2]=H[n+108>>2];if(I[D+87|0]){break h}q=0;while(1){if((q|0)!=(S|0)){if(H[a+36>>2]){break h}Q=N(q,96)+d|0;e=H[H[Q+848>>2]+40>>2];c=(I[Q+828|0]<<6)+b|0;f=I[c+45|0]|I[c+46|0]<<8;W:{if(!(f&16)){break W}if(f&8){Va(n,9,H[c+36>>2],H[c+32>>2]);break W}f=Sb(n,14);Va(n,9,H[c+36>>2],H[c+32>>2]);bb(n,f)}c=Q+768|0;if(e&4210688){X:{if(e&16384){r=((I[Q+828|0]<<6)+b|0)+8|0;e=0;k=0;i=0;o=0;l=0;u=Ga-16|0;Ga=u;p=H[a+8>>2];L=Sb(p,14);h=H[E+24>>2];w=h+N(H[E+12>>2],48)|0;s=H[c+80>>2];t=H[r+16>>2];Y:{while(1){if(h>>>0<w>>>0){Z:{if(I[h+10|0]&2){break Z}f=H[h>>2];if(!$r(f,r)){break Z}l=he(a,l,nb(H[a>>2],f,0))}_:{if(!Qr(h,r,v,x)){break _}m=H[h+24>>2];j=m;f=j&31;if((j&63)>>>0>=32){j=1<<f;B=0}else{B=1<<f;j=B-1&1>>>32-f}f=(m|0)>63;y=f?0:B;j=f?-2147483648:j;if(!(o&255)){f=H[t>>2];H[u+4>>2]=H[H[t+4>>2]+N(m,12)>>2];H[u>>2]=f;Fc(284,24218,u)}o=1;if(k&y|i&j){break _}f=e+1|0;if(Vi(H[a>>2],s,f)){break Y}H[H[s+52>>2]+(e<<2)>>2]=h;k=k|y;i=i|j;e=f}h=h+48|0;continue}break}H[s+40>>2]=16961;G[s+24>>1]=e;G[s+44>>1]=e;j=G[t+34>>1];f=(j|0)<63?j:63;y=(f|0)>0?f:0;z=H[r+48>>2]&(k^-1);m=H[r+52>>2];f=m&(i^-1|-2147483648);k=0;i=0;while(1){if((k|0)!=(y|0)|i){h=e;e=k&31;e=h+(((k&63)>>>0>=32?f>>>e|0:((1<<e)-1&f)<<32-e|z>>>e)&1)|0;h=k+1|0;i=h?i:i+1|0;k=h;continue}break}h=0;M=((m|0)<0?j-62|0:1)+e|0;m=Zs(H[a>>2],M<<16>>16,0,u+12|0);if(!m){break Y}H[s+32>>2]=m;H[m+12>>2]=t;H[m>>2]=1495;e=H[E+24>>2];k=0;i=0;while(1){if(e>>>0>=w>>>0){$:{e=0;k=0;i=0;while(1){if(!i&(k|0)==(y|0)){break $}o=z;j=k&31;if(((k&63)>>>0>=32?f>>>j|0:((1<<j)-1&f)<<32-j|o>>>j)&1){G[H[m+4>>2]+(h<<1)>>1]=e;H[H[m+32>>2]+(h<<2)>>2]=32112;h=h+1|0}e=e+1|0;k=k+1|0;i=k?i:i+1|0;continue}}}else{aa:{if(!Qr(e,r,v,x)){break aa}A=H[e+24>>2];j=A;o=j&31;if((j&63)>>>0>=32){j=1<<o;B=0}else{B=1<<o;j=B-1&1>>>32-o}o=(A|0)>63;C=o?0:B;o=o?-2147483648:j;if(k&C|i&o){break aa}j=H[e>>2];G[H[m+4>>2]+(h<<1)>>1]=A;j=Uj(a,j);if(j){j=H[j>>2]}else{j=32112}k=k|C;i=i|o;H[H[m+32>>2]+(h<<2)>>2]=j;h=h+1|0}e=e+48|0;continue}break}ba:{e=H[r+52>>2];if((e|0)>0|(e|0)>=0){break ba}e=63;while(1){if(G[t+34>>1]<=(e|0)){break ba}G[H[m+4>>2]+(h<<1)>>1]=e;H[H[m+32>>2]+(h<<2)>>2]=32112;e=e+1|0;h=h+1|0;continue}}G[H[m+4>>2]+(h<<1)>>1]=65535;H[H[m+32>>2]+(h<<2)>>2]=32112;e=H[a+40>>2];H[a+40>>2]=e+1;H[c+8>>2]=e;Va(p,116,e,M);Od(a,m);if(!(I[H[a>>2]+82|0]&8)){e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[c+52>>2]=e;Va(p,77,1e4,e)}t=H[H[E>>2]+4>>2];j=I[c+60|0];f=t+(j<<6)|0;ca:{if(I[f+45|0]&32){e=H[f+36>>2];r=Va(p,71,0,0);Xa(p,10,e,0,H[f+32>>2]);e=db(p,11,e);break ca}r=0;e=db(p,35,H[c+4>>2])}o=0;if(l){o=jb(a);zc(a,l,o,16);H[s+40>>2]=H[s+40>>2]|131072}i=Db(a);k=Gn(a,m,H[c+4>>2],i,0,0,0,0);m=H[c+52>>2];if(m){ob(p,180,m,0,k,J[s+24>>1])}Va(p,138,H[c+8>>2],i);pb(p,16);if(l){lb(p,o)}da:{if(I[f+45|0]&32){$i(p,r,h+k|0);BB(a,e,H[c+4>>2],H[(t+(j<<6)|0)+40>>2],H[c+8>>2]);Yb(p,e);h=(I[f+45|0]|I[f+46|0]<<8)&65503;F[f+45|0]=h;F[f+46|0]=h>>>8;break da}Va(p,38,H[c+4>>2],e+1|0);pb(p,3)}bb(p,e);xb(a,i);bb(p,L)}fb(H[a>>2],l);Ga=u+16|0;break X}f=q;e=c;p=H[c+80>>2];m=H[d>>2];k=H[m+8>>2];y=Sb(k,14);while(1){h=Ga-176|0;Ga=h;l=H[m+8>>2];i=H[d+4>>2];j=I[e+60|0];s=h+152|0;fd(s,H[m>>2],h+48|0,100,1e9);j=i+(j<<6)|0;H[h+32>>2]=j+8;F[h+173|0]=1;vb(s,26646,h+32|0);ea:{fa:{i=H[e+80>>2];if(F[i+41|0]&1){i=H[j+24>>2];j=G[i+32>>1];if((j|0)<0){break fa}H[h+16>>2]=H[H[i+4>>2]+N(j&65535,12)>>2];vb(h+152|0,20253,h+16|0);break ea}o=J[i+46>>1];while(1){if(J[i+24>>1]<=o>>>0){break ea}j=Kr(H[i+32>>2],o);if(J[i+46>>1]<o>>>0){Bb(h+152|0,29202,5)}H[h>>2]=j;vb(h+152|0,20253,h);o=o+1|0;continue}}vb(h+152|0,20274,0)}i=h+152|0;Bb(i,26644,1);i=Wd(i);kb(l,185,H[l+108>>2],H[m+220>>2],0,i,-6);Ga=h+176|0;o=jb(m);s=H[e+4>>2];u=H[m+44>>2]+1|0;H[m+44>>2]=u;H[e+52>>2]=u;z=H[d+4>>2]+(I[e+60|0]<<6)|0;r=G[H[z+24>>2]+38>>1];t=(r|0)/10|0;ga:{if((r|0)<=609){l=r-N(t,10)|0;j=l<<16;h=j>>31;i=j>>16;l=l&65535;w=l>>>0>4;j=(w?i-2|0:l?i-1|0:0)+8|0;i=w?h-(i>>>0<2)|0:l?h-!i|0:0;w=j;l=j>>>0<8?i+1|0:i;h=l;t=t<<16>>16;A=t-3|0;i=A&31;if((A&63)>>>0>=32){h=j<<i;i=0}else{h=(1<<i)-1&j>>>32-i|h<<i;i=j<<i}if((r|0)>=30){break ga}i=w;j=3-t|0;h=j&31;if((j&63)>>>0>=32){j=0;i=l>>>h|0}else{j=l>>>h|0;i=((1<<h)-1&l)<<32-h|i>>>h}h=j}else{i=-1;h=2147483647}}j=i;i=!h&i>>>0<1e7;l=i?j:1e7;h=i?h:0;Va(k,77,!h&l>>>0>1e4|h?l:1e4,u);i=z+8|0;j=db(k,35,s);h=H[d+112>>2];l=h+N(H[d+100>>2],48)|0;while(1){if(h>>>0<l>>>0){ha:{if(I[h+10|0]&2){break ha}if(!$r(H[h>>2],i)){break ha}zc(m,H[h>>2],o,16)}h=h+48|0;continue}break}ia:{if(F[p+41|0]&1){h=Db(m);Va(k,135,s,h);ob(k,180,H[e+52>>2],0,h,1);xb(m,h);break ia}r=H[p+32>>2];h=0;i=J[p+24>>1];l=Cc(m,i);while(1){if((h|0)!=(i|0)){Qc(k,H[r+12>>2],s,G[H[r+4>>2]+(h<<1)>>1],h+l|0);h=h+1|0;continue}break}ob(k,180,H[e+52>>2],0,l,i);md(m,l,i)}lb(k,o);Va(k,38,H[e+4>>2],j+1|0);bb(k,j);H[p+40>>2]=H[p+40>>2]&-4194305;ja:{if(I[H[m>>2]+82|0]&16){break ja}h=I[d+48|0];while(1){f=f+1|0;if((h|0)<=(f|0)){break ja}e=N(f,96)+d|0;if(I[(H[d+4>>2]+(I[e+828|0]<<6)|0)+44|0]&72){continue}p=H[e+848>>2];if(!p|(v&H[p>>2]|x&H[p+4>>2])|(H[p+40>>2]&4194308)!=4194304){continue}break}e=e+768|0;if((f|0)<(h|0)){continue}}break}bb(k,y)}if(I[D+87|0]){break h}}MB(a,b,c,g);H[Q+800>>2]=H[n+108>>2];r=0;m=0;s=0;M=0;A=Ga+-64|0;Ga=A;o=H[c+80>>2];y=H[a>>2];k=c;T=d+504|0;h=H[d+4>>2];f=I[c+60|0];l=h+(f<<6)|0;u=H[l+48>>2];W=c,X=v&(Ye(T,u)^-1),H[W+88>>2]=X;H[c+92>>2]=x&(Ja^-1);e=H[d+80>>2];c=H[d+84>>2];i=jb(a);H[k+12>>2]=i;H[k+16>>2]=i;R=jb(a);H[k+24>>2]=R;j=e;e=q&31;C=(q&63)>>>0>=32?c>>>e|0:((1<<e)-1&c)<<32-e|j>>>e;if(!(!I[k+60|0]|!(I[l+44|0]&8))){c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[k>>2]=c;Va(n,71,0,c)}U=d+88|0;l=l+8|0;t=C&1;e=q>>31&q;c=q;ka:{while(1){if((c|0)<=0){break ka}j=N(c,96)+d|0;if(!(H[j+768>>2]|H[j+824>>2])){c=c-1|0;continue}break}e=c}L=h+(f<<6)|0;j=I[L+45|0]|I[L+46|0]<<8;la:{ma:{if(j&32){e=0;c=H[L+36>>2];Xa(n,10,c,0,H[L+32>>2]);c=Va(n,11,c,i);F[k+61|0]=8;H[k+68>>2]=c;break ma}c=H[o+40>>2];if(c&1024){p=J[o+44>>1];h=Cc(a,p+2|0);m=h+2|0;e=H[k+12>>2];c=0;while(1){if((c|0)!=(p|0)){f=H[H[o+52>>2]+(c<<2)>>2];na:{if(!f){break na}i=c+m|0;if(F[f+12|0]&1){if(H[o+36>>2]&(c>>>0<32?1<<c:0)){l=H[a+40>>2];H[a+40>>2]=l+1;j=H[a+44>>2]+1|0;H[a+44>>2]=j;qC(a,H[f>>2],l);Xa(n,174,l,i,j);break na}fn(a,f,k,c,t,i);e=H[k+16>>2];break na}Kk(a,H[H[f>>2]+16>>2],i,1);if(!(I[o+28|0]&2)|I[f+15|0]!=74){break na}Va(n,71,0,H[H[d+20>>2]+12>>2])}c=c+1|0;continue}break}Va(n,71,H[o+24>>2],h);Va(n,71,p,h+1|0);kb(n,6,u,e,h,H[o+32>>2],F[o+28|0]&1?-6:-1);F[o+28|0]=I[o+28|0]&254;if(I[y+87|0]){H[o+32>>2]=0}H[k+64>>2]=u;F[k+61|0]=I[d+50|0]?-72:62;H[k+68>>2]=H[n+108>>2];e=0;c=0;while(1){if((c|0)==(p|0)){break ma}j=H[H[o+52>>2]+(c<<2)>>2];oa:{if(!(!(J[o+30>>1]>>>c&1)|c>>>0>15)){Gh(k,j);break oa}if(I[y+87|0]|(!(F[j+12|0]&1)|H[o+36>>2]&(c>>>0<32?1<<c:0))){break oa}f=0;h=H[k+72>>2];l=(h|0)>0?h:0;h=c+m|0;while(1){pa:{if((f|0)!=(l|0)){i=Nc(n,H[(H[k+76>>2]+N(f,20)|0)+4>>2]);s=I[i|0];qa:{if((s|0)!=135){if((s|0)!=94|(h|0)!=H[i+12>>2]){break pa}l=h;f=H[i+8>>2];break qa}if((h|0)!=H[i+8>>2]){break pa}l=H[i+12>>2];f=h}Xa(n,s,H[i+4>>2],f,l)}f=mb(a,53,0,0);if(!I[y+87|0]){i=H[H[j>>2]+12>>2];l=H[j+28>>2];if((l|0)>0){i=H[(H[i+20>>2]+(l<<4)|0)-8>>2]}H[f+12>>2]=i;i=sc(y,176,0);H[f+16>>2]=i;if(i){H[i+28>>2]=h;zc(a,f,H[k+24>>2],16)}H[f+12>>2]=0}fb(y,f);break oa}f=f+1|0;continue}}c=c+1|0;continue}}e=H[(N(e,96)+d|0)+780>>2];ra:{sa:{ta:{if(!(!(c&256)|!(c&5))){e=H[H[o+52>>2]>>2];c=H[a+44>>2]+1|0;H[a+44>>2]=c;e=fn(a,e,k,0,t,c);if((e|0)!=(c|0)){xb(a,c)}c=H[k+16>>2];f=H[k+52>>2];if(f){ob(n,63,f,c,e,1);oB(a,d,q,c,v,x)}Xa(n,29,u,c,e);F[k+61|0]=184;break ta}if((c&258)==258){f=0;h=0;l=0;if(c&32){l=1;h=H[H[o+52>>2]>>2]}f=c&16?H[H[o+52>>2]+(l<<2)>>2]:f;l=t?h:f;c=t?f:h;ua:{if(c){e=H[c>>2];f=H[e+16>>2];va:{if(Ze(f)){c=Db(a);Kk(a,H[e+16>>2],c,1);h=c;e=I[e|0]+1&2|1;break va}h=Mc(a,f,A+8|0);Gh(k,c);c=H[A+8>>2];e=I[e|0]-54|0}Xa(n,I[e+48752|0],u,i,h);xb(a,c);break ua}Va(n,t?31:35,u,e)}e=0;f=0;c=184;wa:{if(!l){break wa}c=H[l>>2];f=H[a+44>>2]+1|0;H[a+44>>2]=f;Kk(a,H[c+16>>2],f,1);xa:{ya:{if(!Ze(H[c+16>>2])){za:{switch(I[c|0]-54|0){case 0:case 2:break za;default:break ya}}c=t?55:57;break xa}c=t?56:54;break wa}c=t?56:54}Gh(k,l)}H[k+68>>2]=H[n+108>>2];H[k+64>>2]=u;F[k+61|0]=t?37:38;if((c|0)==184){break ma}h=H[a+44>>2]+1|0;H[a+44>>2]=h;Va(n,135,u,h);Xa(n,c,f,i,h);pb(n,83);break ma}if(c&512){l=J[o+26>>1];e=0;p=0;i=J[o+24>>1];j=i;if(c&32){p=H[H[o+52>>2]+(i<<2)>>2];r=l;j=i+1|0}f=J[o+28>>1];w=H[o+32>>2];z=H[k+8>>2];Aa:{if(!(c&16)){j=0;break Aa}j=H[H[o+52>>2]+(j<<2)>>2];if(F[j+11|0]&1){c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[k+44>>2]=c;Va(n,71,1,c);H[k+48>>2]=H[n+108>>2];c=H[k+44>>2]<<1;H[k+44>>2]=c;H[k+44>>2]=c|t^I[i+H[w+28>>2]|0]==1}r=f>>>0<r>>>0?r:f;if(p){break Aa}c=J[H[w+4>>2]+(i<<1)>>1];h=c<<16>>16;Ba:{if((h|0)>=0){if(!(I[(H[H[w+12>>2]+4>>2]+N(c,12)|0)+4|0]&15)){break Ba}break Aa}if((h|0)!=-2){break Aa}}e=1}c=0;if((H[o+40>>2]&524336)==524288){e=1;c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[k+36>>2]=c;if(H[k>>2]){Va(n,71,0,c)}W=k,X=jb(a),H[W+40>>2]=X;r=1}if((C&1)==(I[i+H[w+28>>2]|0]!=0|0)|i>>>0>=J[w+52>>1]){break sa}h=l&255;s=e;e=p;break ra}if(c&8192){C=H[a+40>>2];H[a+40>>2]=C+1;z=H[a+44>>2]+1|0;H[a+44>>2]=z;B=jb(a);r=H[(h+(f<<6)|0)+24>>2];O=H[H[o+52>>2]>>2];M=H[O+24>>2];H[k+64>>2]=z;F[k+61|0]=67;c=I[d+48|0];Ca:{if(c>>>0>=2){c=c-q|0;e=Uc(y,c<<6|8,0);if(!e){break la}f=c&255;H[e>>2]=f;H[e+4>>2]=f;Ya(e+8|0,l,64);f=(c|0)>1?c:1;h=H[d+4>>2]+8|0;c=1;while(1){if((c|0)==(f|0)){break Ca}Ya(((c<<6)+e|0)+8|0,h+(I[(k+N(c,96)|0)+60|0]<<6)|0,64);c=c+1|0;continue}}e=H[d+4>>2]}f=0;if(!(I[d+44|0]&16)){Da:{if(!(I[r+28|0]&128)){m=H[a+44>>2]+1|0;H[a+44>>2]=m;Va(n,75,0,m);break Da}c=tc(r);m=H[a+40>>2];H[a+40>>2]=m+1;Va(n,118,m,J[c+50>>1]);Od(a,c)}s=H[a+44>>2]+1|0;H[a+44>>2]=s}P=Va(n,71,0,z);h=H[d+100>>2];Ea:{if((h|0)<2){break Ea}l=0;c=0;while(1){if((c|0)<(h|0)){f=H[d+112>>2]+N(c,48)|0;Fa:{if((f|0)==(O|0)|J[f+10>>1]&32774|!(J[f+12>>1]&16383)){break Fa}f=H[f>>2];if(I[f+6|0]&64){break Fa}l=he(a,l,nb(y,f,0));h=H[d+100>>2]}c=c+1|0;continue}break}if(!l){f=0;break Ea}f=mb(a,65580,0,l)}qc(a,1,18787,0);h=0;p=0;j=0;while(1){if(H[M+12>>2]>(j|0)){c=H[M+24>>2]+N(j,48)|0;if(!(I[c+13|0]&4?0:(u|0)!=H[c+20>>2])){i=nb(y,H[c>>2],0);Ga:{if(I[y+87|0]){break Ga}c=i;if(f){H[f+12>>2]=i;c=f}H[A>>2]=j+1;qc(a,1,16762,A);l=Af(a,e,c,0,0,0,32,C);if(!l){break Ga}c=0;MB(a,e,l+768|0,0);Ha:{if(I[d+44|0]&16){break Ha}w=(H[M+12>>2]-1|0)==(j|0)?-1:j;if(!(I[r+28|0]&128)){Qc(n,r,u,-1,s);c=ob(n,46,m,0,s,w);break Ha}V=tc(r);o=J[V+50>>1];t=Cc(a,o);while(1){if((c|0)!=(o|0)){Qc(n,r,u,G[H[V+4>>2]+(c<<1)>>1],c+t|0);c=c+1|0;continue}break}Ia:{Ja:{if(!w){c=0;break Ja}c=ob(n,28,m,0,t,o);if((w|0)<0){break Ia}}Xa(n,97,t,o,s);ob(n,138,m,s,t,o);if(!w){break Ia}pb(n,16)}md(a,t,o)}Va(n,9,z,B);if(c){bb(n,c)}t=I[l+52|0];c=0;o=H[l+848>>2];Ka:{if(!(I[o+41|0]&2)|(H[o+32>>2]!=(h|0)?j:0)){break Ka}h=H[o+32>>2];if(((I[h+55|0]|I[h+56|0]<<8)&3)==2?I[r+28|0]&128:0){break Ka}c=h}if(Qn(l)){F[d+52|0]=I[d+52|0]|1}p=t&2?1:p;Ed(l);Mh(a);h=c}fb(y,i)}j=j+1|0;continue}break}Mh(a);H[k+72>>2]=h;if(h){H[k+8>>2]=C}if(f){H[f+12>>2]=0;fb(y,f)}GB(n,P,H[n+108>>2]);Yb(n,H[k+12>>2]);lb(n,B);H[k+68>>2]=H[n+108>>2];if(I[d+48|0]>=2){_a(y,e)}e=0;if(p){break ma}Gh(k,O);break ma}if(j&64){F[k+61|0]=184;break ta}H[k+64>>2]=u;F[k+61|0]=I[t+48768|0];c=Va(n,I[t+48770|0],u,e);F[k+63|0]=1;H[k+68>>2]=c+1}e=0;break ma}m=e;e=j;j=p;h=f;f=l}if(!(!(I[o+42|0]&16)|(q|0)<=0)){db(n,136,z)}l=nB(a,k,t,r,A+8|0);r=H[A+8>>2];if(!(!r|!h)){M=Xb(y,i+r|0)}B=1;C=1;C=j?(I[j+12|0]&40)!=0:C;B=e?(I[e+12|0]&40)!=0:B;p=H[k+(c?40:16)>>2];La:{if(j){P=H[H[j>>2]+16>>2];m=i+l|0;Kk(a,P,m,f);mB(n,k,j);Ma:{if(I[j+10|0]&128){break Ma}if(!$f(P)){break Ma}Va(n,50,m,p)}if(r){lB(P,f,i+r|0)}f=f+i|0;O=1;m=0;if(Ze(P)){C=1;break La}Gh(k,j);break La}if(m){C=0;Va(n,75,0,i+l|0);m=1;f=i+1|0;O=1;break La}if(!c){O=(i|0)!=0;m=0;f=i;break La}m=0;Va(n,75,0,i+l|0);O=1;f=i+1|0}Pr(a,l,f-m|0,r);Na:{Oa:{Pa:{Qa:{Ra:{j=J[o+46>>1];Sa:{if(!((f|0)==(j|0)?j:0)){if(c){Va(n,71,1,c)}j=H[k+52>>2];if(j){ob(n,63,j,p,l,i);oB(a,d,q,p,v,x)}j=0;O=t|((O?4:0)|(C?2:0));P=I[O+48756|0];if(!(!(I[o+42|0]&16)|(O|0)!=6)){j=db(n,124,(G[H[w+8>>2]>>1]+9|0)/10|0)}ob(n,P,z,p,l,f);if(c){Va(n,8,0,H[n+108>>2]+2|0);ob(n,I[(t|(f>>>0<2?2:6))+48756|0],z,p,l,f-C|0)}if(!e){break Sa}f=H[H[e>>2]+16>>2];if(!j){break Qa}H[k+68>>2]=H[n+108>>2];break Pa}if(e){break Ra}j=0}if(s){break Oa}h=i;break Na}f=H[H[e>>2]+16>>2]}j=0}s=i+l|0;Kk(a,f,s,h);mB(n,k,e);Ta:{if(I[e+10|0]&128){break Ta}if(!$f(f)){break Ta}Va(n,50,s,p)}if(M){lB(f,h,M);Pr(a,s,h,M)}h=h+i|0;if(Ze(f)){B=1;break Na}Gh(k,e);break Na}if(!c){Va(n,75,0,i+l|0);B=0}h=i+1|0}_a(y,r);_a(y,M);if(!H[k+68>>2]){H[k+68>>2]=H[n+108>>2]}Ua:{if(!h){break Ua}if(c){Va(n,16,c,H[n+108>>2]+3|0)}ob(n,I[(t<<1|B)+48764|0],z,p,l,h);if(!j){break Ua}bb(n,j)}if(c){Va(n,15,c,H[n+108>>2]+2|0);ob(n,I[(t<<1|m)+48764|0],z,p,l,h+m|0)}c=H[o+40>>2];if(c&262144){Xa(n,125,z,i,i);c=H[o+40>>2]}Va:{if(!(!(c&64)|J[d+44>>1]&4128)){c=1;break Va}e=H[w+12>>2];Wa:{if(!(I[e+28|0]&128)){c=H[d>>2];f=H[c+8>>2];F[d+52|0]=I[d+52|0]|1;Xa(f,141,z,0,u);Xa:{if(!(J[d+44>>1]&4128)){break Xa}e=H[c+116>>2];if(H[(e?e:c)+80>>2]){break Xa}e=H[c>>2];h=H[w+12>>2];c=G[h+34>>1];c=(c<<2)+4|0;e=yb(e,c&-4,0);if(!e){break Xa}H[e>>2]=G[h+34>>1];c=J[w+52>>1];i=(c>>>0>1?c:1)-1|0;c=0;while(1){if((c|0)!=(i|0)){l=G[H[w+4>>2]+(c<<1)>>1];j=Oc(h,l);if((l|0)<0){c=c+1|0}else{c=c+1|0;H[(e+(j<<2)|0)+4>>2]=c}continue}break}le(f,-1,e,-14)}break Wa}c=0;if((u|0)==(z|0)){break Va}c=0;e=tc(e);f=Cc(a,J[e+50>>1]);while(1){h=J[e+50>>1];if(h>>>0>c>>>0){Xa(n,94,z,Cf(w,G[H[e+4>>2]+(c<<1)>>1]),c+f|0);c=c+1|0;continue}break}ob(n,27,u,R,f,h)}c=0}Ya:{if(H[k>>2]){break Ya}if(!(J[d+44>>1]&4128)){f=Ga+-64|0;Ga=f;Za:{i=H[w+40>>2];if(!(I[w+56|0]&4?1:i)){break Za}l=H[w+12>>2];H[f+48>>2]=0;H[f+52>>2]=0;H[f+40>>2]=0;H[f+44>>2]=0;H[f+32>>2]=0;H[f+36>>2]=0;H[f+8>>2]=z;H[f+4>>2]=u;H[f+56>>2]=f;H[f+20>>2]=d;H[f+24>>2]=H[H[d>>2]>>2];e=0;while(1){if(J[w+52>>1]<=e>>>0){break Za}h=G[H[w+4>>2]+(e<<1)>>1];_a:{$a:{if((h|0)==-2){h=H[(i+(e<<4)|0)+8>>2];H[f>>2]=h;if(Me(h)){break _a}h=83;break $a}if((h|0)<0){break _a}j=H[l+4>>2]+N(h,12)|0;p=J[j+10>>1];if(!(p&32)){break _a}if(p&512){if(hb(Of(j),32112)){break _a}}H[f+16>>2]=h;h=84}H[f+12>>2]=e;H[f+36>>2]=h;h=f+32|0;Kb(h,H[d+16>>2]);gc(h,H[d+8>>2]);gc(h,H[d+12>>2])}e=e+1|0;continue}}Ga=f- -64|0}e=H[w+36>>2];if(!e){break Ya}kB(e,u,U)}e=H[o+40>>2];ab:{if(e&4096){F[k+61|0]=184;break ab}if(t){F[k+61|0]=37;break ab}F[k+61|0]=38}H[k+64>>2]=z;F[k+62|0]=e>>>16&1;if(!(e&15)){F[k+63|0]=1}e=c?0:w}h=e?1:2;while(1){j=H[d+100>>2];c=H[d+112>>2];l=0;while(1){if((j|0)>0){f=J[c+10>>1];bb:{if(f&6){break bb}p=H[k+88>>2];m=H[k+92>>2];if(p&H[c+40>>2]|m&H[c+44>>2]){F[d+52|0]=I[d+52|0]|2;break bb}i=H[c>>2];s=I[L+44|0];if(s&88){r=H[i+4>>2];if(!(r&3)|(r&1?0:s&8)){break bb}if(Ye(T,H[i+36>>2])&p|m&Ja){break bb}}cb:{db:{if((h|0)==1){if(!jB(i,H[k+4>>2],e)){l=2;break bb}f=J[c+10>>1];break db}if(h>>>0>2){break cb}}if(!(f&4096)){break cb}l=l?l:3;break bb}p=0;eb:{if(!(f&512)){break eb}f=H[k+44>>2];if(!f){break eb}p=db(n,f&1?16:15,f>>>1|0)}zc(a,i,R,16);if(p){bb(n,p)}G[c+10>>1]=J[c+10>>1]|4}c=c+48|0;j=j-1|0;continue}break}h=l;if((h|0)>0){continue}break}j=H[d+108>>2];c=H[d+112>>2];while(1){if((j|0)>0){fb:{if(I[c+10|0]&6){break fb}e=J[c+12>>1];if(I[L+44|0]&88|(!(e&130)|!(e&2048)|(u|0)!=H[c+20>>2])){break fb}h=H[c>>2];e=Sr(U,u,H[c+24>>2],v,x,131,0);if(!e|I[e+10|0]&4){break fb}f=H[e>>2];if(!(!(F[e+12|0]&1)|!(I[f+5|0]&16))&H[H[H[f+20>>2]+28>>2]>>2]>1){break fb}i=A+8|0;Ya(i,f,52);H[A+20>>2]=H[h+12>>2];zc(a,i,R,16);G[e+10>>1]=J[e+10>>1]|4}c=c+48|0;j=j-1|0;continue}break}e=H[k+56>>2];if(e){h=H[(H[d+4>>2]+(I[k+60|0]<<6)|0)+24>>2];gb:{if(!(I[h+28|0]&128)){j=1;f=Cc(a,2);c=f+1|0;Qc(n,h,H[k+4>>2],-1,c);break gb}c=0;i=tc(h);j=J[i+50>>1];f=Cc(a,j+1|0);while(1){if((c|0)!=(j|0)){l=G[H[i+4>>2]+(c<<1)>>1];c=c+1|0;Qc(n,h,u,l,f+c|0);continue}break}c=f+1|0}h=ob(n,28,H[e>>2],0,c,j);Xa(n,97,c,j,f);ob(n,138,H[e>>2],f,c,j);ob(n,180,H[e+4>>2],0,c,j);pb(n,16);bb(n,h);md(a,f,j+1|0)}hb:{c=H[k>>2];ib:{jb:{if(c){H[k+28>>2]=H[n+108>>2];Va(n,71,1,c);c=H[k+56>>2];if(c){break jb}break ib}c=H[k+56>>2];if(!c){break hb}}Va(n,74,0,H[c+8>>2]);H[c+12>>2]=H[n+108>>2];F[a+26|0]=I[a+26|0]+1}c=H[d+112>>2];j=0;while(1){if(H[d+108>>2]<=(j|0)){break hb}if(!(I[L+44|0]&64|(I[c+10|0]&6|(H[k+88>>2]&H[c+40>>2]|H[k+92>>2]&H[c+44>>2])!=0))){zc(a,H[c>>2],R,16);G[c+10>>1]=J[c+10>>1]|4}c=c+48|0;j=j+1|0;continue}}v=H[k+88>>2];x=H[k+92>>2]}Ga=A- -64|0;H[d+32>>2]=H[Q+792>>2];q=q+1|0;continue}break}H[d+60>>2]=H[n+108>>2];break a}LB(d);H[a+136>>2]=H[d+40>>2];KB(D,d)}d=0}Ga=K+32|0;return d}function rj(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;f=Ga-448|0;Ga=f;h=H[a>>2];g=zb(a);a:{if(!g){break a}Va(g,166,1,1);H[a+44>>2]=2;i=ig(a,b,c,f+444|0);if((i|0)<0){break a}k=H[h+16>>2];if((i|0)==1){if(uC(a)){break a}}w=vc(h,H[f+444>>2]);if(!w){break a}b:{c:{if(e){H[f+384>>2]=d;j=tb(h,18254,f+384|0);break c}j=vc(h,d)}e=H[c+4>>2]?H[k+(i<<4)>>2]:0;if(cc(a,19,w,j,e)){break b}H[f+428>>2]=0;H[f+424>>2]=j;H[f+420>>2]=w;H[f+416>>2]=0;H[h+452>>2]=0;d:{e:{if(!e){d=0;break e}d=Xg(h,e);b=0;if((d|0)<0){break d}}b=H[(H[h+16>>2]+(d<<4)|0)+4>>2]}if(b){Jb(b);b=H[Vc(b)+64>>2];d=H[h+452>>2];b=Ah(b,14,f+416|0);H[h+452>>2]=d}else{b=1}if((b|0)!=12){if(!b){Zj(g,1);jf(g,0,0,H[f+416>>2],-1);In(g,H[f+416>>2]);Wa(H[f+416>>2]);break b}c=H[f+416>>2];if(c){H[f>>2]=c;Za(a,8310,f);Wa(H[f+416>>2])}H[a+12>>2]=b;H[a+36>>2]=H[a+36>>2]+1;break b}m=It(w);if(!m){break b}l=I[m+5|0];if(l&1){if(kf(a)){break b}l=I[m+5|0]}if(!(l&2|(j?l&4:0))){YC(g,m)}d=-1;l=0;f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{switch(I[m+4|0]-1|0){case 12:ze(g,i);if(!j){H[a+44>>2]=H[a+44>>2]+2;a=zg(g,9,48976);H[a+4>>2]=i;H[a+124>>2]=-2e3;H[a+24>>2]=i;break b}b=Jl(ef(j));Gd(a,0,i);Xa(g,100,i,3,b);a=k+(i<<4)|0;H[H[a+12>>2]+80>>2]=b;Lj(H[a+4>>2],b);break b;case 30:b=H[(k+(i<<4)|0)+4>>2];if(!j){if(b){a=df(b);b=a;a=a>>31}else{b=0;a=0}Cd(g,b,a);break b}a=ef(j);H[h+100>>2]=a;if((Fh(b,a,0,0)|0)!=7){break b}Mb(h);break b;case 32:a=H[(k+(i<<4)|0)+4>>2];u:{if(!j){break u}if(!Qb(j,2273)){d=2;break u}d=Oj(j,0)}v:{if(H[c+4>>2]){break v}c=0;if((d|0)<0){break v}while(1){if(H[h+20>>2]<=(c|0)){break v}Hn(H[(H[h+16>>2]+(c<<4)|0)+4>>2],d);c=c+1|0;continue}}Cd(g,Hn(a,d),0);break b;case 26:H[f+408>>2]=0;H[f+412>>2]=0;Fd(a,i);d=H[a+44>>2]+1|0;H[a+44>>2]=d;w:{if((I[w|0]&223)==80){Va(g,177,i,d);break w}b=0;x:{if(!j){break x}if(kh(j,f+408|0)){break x}c=H[f+408>>2];a=H[f+412>>2];if((a|0)<0){break x}b=!a&c>>>0<4294967294?c:-2}Xa(g,178,i,d,b)}Va(g,84,d,1);break b;case 25:y:{z:{if(!j){break z}a=1;if(!hb(j,12234)){break y}if(hb(j,11206)){break z}a=0;break y}a=-1}b=H[c+4>>2];A:{if(!((a|0)!=-1|b)){a=I[h+89|0];break A}if(!b){c=2;while(1){if(H[h+20>>2]>(c|0)){As(Vc(H[(H[h+16>>2]+(c<<4)|0)+4>>2]),a);c=c+1|0;continue}break}F[h+89|0]=a}a=As(Vc(H[(k+(i<<4)|0)+4>>2]),a)}In(g,(a|0)==1?12234:11206);break b;case 22:B:{C:{if(!j){break C}e=0;b=ib(j);while(1){a=Su(e);if(!a){break C}if(Fb(j,a,b)){e=e+1|0;continue}break}if((e|0)!=2){break B}if(I[h+35|0]&16){break C}e=2;break B}e=-1;if(H[c+4>>2]){break B}H[c+4>>2]=1;i=0}b=H[h+20>>2];while(1){if((b|0)>0){b=b-1|0;if(!H[(H[h+16>>2]+(b<<4)|0)+4>>2]|(H[c+4>>2]?(b|0)!=(i|0):0)){continue}ze(g,b);Xa(g,4,b,1,e);continue}break};Va(g,84,1,1);break b;case 23:d=Vc(H[(k+(i<<4)|0)+4>>2]);H[f+408>>2]=-2;H[f+412>>2]=-1;if(j){kh(j,f+408|0);c=H[f+412>>2];b=(c|0)>0|(c|0)>=0;a=b?H[f+408>>2]:-1;b=b?c:-1}else{a=-2;b=-1}if((a|0)==-1&(b|0)>=-1|(b|0)>=0){H[d+176>>2]=a;H[d+180>>2]=b;c=H[d+232>>2];if(c){H[c+16>>2]=a;H[c+20>>2]=b}}Cd(g,H[d+176>>2],H[d+180>>2]);break b;case 2:b=H[(k+(i<<4)|0)+4>>2];if(!j){Cd(g,Lo(b),0);break b}a=0;D:{if(!hb(j,13084)){break D}a=1;if(!hb(j,11046)){break D}a=2;if(!hb(j,11171)){break D}a=ef(j);a=a>>>0<3?a&255:0}F[h+90|0]=a;if(Ko(b,a)){break b}b=a-1|0;if(b>>>0>1){break b}a=H[g+108>>2];c=zg(g,5,49024);H[c+4>>2]=i;H[c+92>>2]=b;H[c+84>>2]=i;H[c+48>>2]=a+4;H[c+24>>2]=i;ze(g,i);break b;case 18:H[f+408>>2]=0;E:{F:{if(!j){break F}if(!Ag(j,f+408|0)){break F}c=H[f+408>>2];if((c|0)>0){break E}}c=2147483647}Gd(a,0,i);Va(g,71,c,1);a=db(g,61,i);db(g,84,1);Va(g,86,1,-1);Va(g,49,1,a);bb(g,a);break b;case 5:if(!j){a=H[H[(k+(i<<4)|0)+12>>2]+80>>2];Cd(g,a,a>>31);break b}b=ef(j);a=k+(i<<4)|0;H[H[a+12>>2]+80>>2]=b;Lj(H[a+4>>2],b);break b;case 6:if(!j){if(I[h+32|0]&32){a=vl(H[(k+(i<<4)|0)+4>>2],0);b=a;a=a>>31}else{b=0;a=0}Cd(g,b,a);break b}H[f+408>>2]=1;G:{if(!Ag(j,f+408|0)){c=H[f+408>>2];break G}c=H[f+408>>2];vl(H[(k+(i<<4)|0)+4>>2],c)}a=Oj(j,(c|0)!=0);b=H[h+36>>2];c=(a|0)!=0;a=c>>>27|0;H[h+32>>2]=H[h+32>>2]&-33|c<<5;H[h+36>>2]=a|b;zs(h);break b;case 27:Cd(g,0,0);break b;case 38:if(!j){Cd(g,I[h+86|0],0);break b}b=I[j|0]-48|0;if((b&255)>>>0>2){if(hb(j,13366)){b=!hb(j,1186)<<1}else{b=1}}c=H[a>>2];H:{if(I[c+86|0]==(b|0)){break H}if(XC(a)){break H}F[c+86|0]=b}break b;case 39:if(!j){In(g,H[17599]);break b}I:{if(!I[j|0]){break I}if(!(A=pg(H[h>>2],j,1,f+408|0),B=1,C=H[f+408>>2],C?A:B)){break I}Za(a,1088,0);break b}if(I[h+86|0]<=1){XC(a)}Wa(H[17599]);if(I[j|0]){H[f+16>>2]=j;A=70396,B=Hb(8310,f+16|0),H[A>>2]=B;break b}H[17599]=0;break b;case 35:if(!j){a=I[(k+(i<<4)|0)+8|0];Cd(g,a-1|0,0-!a|0);break b}if(!I[h+85|0]){Za(a,10070,0);break b}if((i|0)==1){break b}b=Gw(j,0,1);a=k+(i<<4)|0;F[a+9|0]=1;c=a;a=b+1&7;F[c+8|0]=a?a:1;zs(h);break b;case 3:if(!j){YC(g,m);Cd(g,(H[m+8>>2]&H[h+32>>2]|H[m+12>>2]&H[h+36>>2])!=0,0);break b}a=H[m+8>>2];b=I[h+85|0];c=b?a:a&-16385;a=H[m+12>>2];b=b?a:a;J:{if(Oj(j,0)){a=b|H[h+36>>2];H[h+32>>2]=c|H[h+32>>2];H[h+36>>2]=a;break J}a=H[h+36>>2]&(b^-1);H[h+32>>2]=H[h+32>>2]&(c^-1);H[h+36>>2]=a;if(!b&(c|0)==524288){H[h+520>>2]=0;H[h+524>>2]=0;break J}if(!(c&1)){break J}if(Qb(j,3041)){break J}Yf(h)}Sb(g,166);zs(h);break b;case 36:if(!j){break b}mj(a,e);n=Sf(a,2,j,e);if(!n){break b}p=tc(n);H[a+44>>2]=7;fg(a,n);a=H[n+4>>2];b=0;while(1){d=G[n+34>>1];if((d|0)<=(b|0)){break b}e=J[a+10>>1];K:{L:{if(!(e&98)){r=0;k=0;break L}if(!(H[m+8>>2]|H[m+12>>2])){l=l+1|0;break K}if(e&32){r=2;k=1;break L}c=e&64;r=c?3:1;k=c>>>6|0}e=e&1;M:{if(!e|!p){break M}c=1;e=((d|0)>0?d:0)+1|0;while(1){if((c|0)==(e|0)){break M}if((b|0)!=G[(H[p+4>>2]+(c<<1)|0)-2>>1]){c=c+1|0;continue}break}e=c}t=cd(n,a);u=H[m+8>>2]|H[m+12>>2]?11524:11493;o=H[a>>2];i=_l(a,29357);d=0;c=(I[a+4|0]&15)!=0;d=k|!t?d:H[t+8>>2];H[f+56>>2]=r;H[f+52>>2]=e;H[f+48>>2]=d;H[f+44>>2]=c;H[f+40>>2]=i;H[f+36>>2]=o;H[f+32>>2]=b-l;Le(g,1,u,f+32|0)}a=a+12|0;b=b+1|0;continue};case 0:N:{if(!j){break N}if(kh(j,f+408|0)){break N}a=H[f+408>>2];if(H[f+412>>2]<0){break N}H[h+492>>2]=a&2147483647}a=H[h+492>>2];Cd(g,a,a>>31);break b;case 40:O:{if(!j){break O}if(kh(j,f+408|0)){break O}a=H[f+408>>2];if(H[f+412>>2]<0){break O}Ow(h,a&2147483647)}a=Ow(h,-1);Cd(g,a,a>>31);break b;case 17:P:{if(!j){break P}if(kh(j,f+408|0)){break P}c=fq(-1,-1);a=H[f+412>>2];d=a;b=H[f+408>>2];e=!b&(a|0)<=0|(a|0)<0;a=Ja;if(e|!!(a|c)&((a|0)<=(d|0)&b>>>0>=c>>>0|(a|0)<(d|0))){break P}fq(b,d)}Cd(g,fq(-1,-1),Ja);break b;case 34:Q:{if(!j){break Q}if(kh(j,f+408|0)){break Q}hy(H[f+408>>2],H[f+412>>2])}Cd(g,hy(-1,-1),Ja);break b;default:if(j){R:{a=ef(j);if((a|0)>0){Xw(h,7,h);H[h+496>>2]=a;break R}Xw(h,0,0)}}a=H[h+496>>2];Cd(g,a,a>>31);break b;case 29:S:{if(!j){c=65534;break S}c=ef(j);if(!(c&2)){break b}}t=H[a+40>>2];H[a+40>>2]=t+1;d=e?i:H[h+20>>2]-1|0;l=c&1;k=l|2;while(1){if((d|0)>=(i|0)){T:{if((i|0)==1){break T}Fd(a,i);c=i<<4;e=H[(c+H[h+16>>2]|0)+12>>2]+16|0;while(1){e=H[e>>2];if(!e){break T}p=H[e+8>>2];if(!(F[p+29|0]&1)){continue}b=p+8|0;u=J[p+38>>1]+46|0;U:{while(1){o=H[b>>2];if(o){b=o+20|0;if(I[o+55|0]&128){continue}break U}break}if(!(u&65535)){break U}fe(a,t,i,p,112);Xa(g,32,t,k+H[g+108>>2]|0,u<<16>>16)}b=H[c+H[h+16>>2]>>2];H[f+372>>2]=H[p>>2];H[f+368>>2]=b;o=tb(h,28089,f+368|0);if(l){b=Db(a);kb(g,117,0,b,0,o,-6);Va(g,84,b,1)}else{kb(g,148,0,0,0,o,-6)}continue}}i=i+1|0;continue}break};Sb(g,166);break b;case 33:a=0;Se(h);while(1){if(H[h+20>>2]>(a|0)){b=H[(H[h+16>>2]+(a<<4)|0)+4>>2];if(b){B=H[H[Vc(b)+228>>2]+44>>2],A=H[16037],Ka[A](B|0)}a=a+1|0;continue}break};break b;case 41:if(j){Rw(h,ef(j))}if(H[h+268>>2]==9){a=H[h+272>>2];b=a;a=a>>31}else{b=0;a=0}Cd(g,b,a);break b;case 42:b=H[c>>2]?i:12;c=0;V:{if(!j){break V}c=1;if(!hb(j,11046)){break V}c=2;if(!hb(j,2339)){break V}c=hb(j,12472)?0:3}H[a+44>>2]=3;Xa(g,3,b,c,1);Va(g,84,1,3);break b;case 9:H[a+44>>2]=1;c=0;while(1){a=Cw(c);if(!a){break s}Bd(g,1,a);Va(g,84,1,1);c=c+1|0;continue};case 37:break f;case 19:break g;case 20:break h;case 11:break i;case 8:break j;case 16:break k;case 28:break l;case 31:break m;case 15:break n;case 14:break o;case 7:break p;case 21:break q;case 13:break r;case 1:break t}}b=H[m+8>>2];ze(g,i);if(!(!j|I[m+5|0]&8)){c=zg(g,2,49176);H[c+4>>2]=i;H[c+28>>2]=b;H[c+24>>2]=i;a=ef(j);G[c+22>>1]=1;H[c+32>>2]=a;break b}a=zg(g,3,49184);H[a+4>>2]=i;H[a+32>>2]=b;H[a+24>>2]=i}a=H[g+108>>2];c=(a|0)>1?a:1;a=1;W:{while(1){if((a|0)==(c|0)){break W}b=N(a,20);a=a+1|0;d=b;b=H[g+104>>2];if(I[d+b|0]!=166){continue}break}F[b+20|0]=184}break b}if(!j){if(kf(a)){break b}In(g,H[(I[H[a>>2]+84|0]<<3)+49104>>2]);break b}if(I[h+24|0]&64){break b}c=49104;X:{while(1){b=H[c>>2];if(!b){break X}if(hb(j,b)){c=c+8|0;continue}break}b=I[c+4|0];b=b?b:2;F[H[H[h+16>>2]+12>>2]+77|0]=b;Kp(h,b);if(H[c>>2]){break b}}H[f+352>>2]=j;Za(a,7438,f+352|0);break b}d=I[w|0];b=H[c>>2];H[a+44>>2]=6;z=100;H[f+408>>2]=100;s=b?i:-1;Y:{if(!j){break Y}if(Ag(j,f+408|0)){b=H[f+408>>2];z=(b|0)<=0?100:b;H[f+408>>2]=z;break Y}v=Sf(a,0,j,(s|0)>=0?H[H[h+16>>2]+(s<<4)>>2]:0);z=H[f+408>>2]}p=d&-33;Va(g,71,z-1|0,1);t=(v|0)!=0;while(1){Z:{if(H[h+20>>2]<=(x|0)){break Z}_:{if((s|0)!=(x|0)&(s|0)>=0){break _}Fd(a,x);b=0;k=x<<4;l=H[(k+H[h+16>>2]|0)+12>>2]+16|0;c=l;i=0;while(1){c=H[c>>2];if(c){e=H[c+8>>2];if((e|0)!=(v|0)?v:0){continue}d=e+8|0;b=((H[e+28>>2]^-1)>>>7&1)+b|0;e=0;while(1){d=H[d>>2];if(d){e=e+1|0;d=d+20|0;b=b+1|0;continue}break}i=(e|0)>(i|0)?e:i;continue}break}if(!b){break _}d=Tb(h,(b+t<<2)+4|0,0);if(!d){break Z}if(v){H[d+4>>2]=0;e=1}else{e=0}c=l;$:while(1){c=H[c>>2];if(c){b=H[c+8>>2];if((b|0)!=(v|0)?v:0){continue}if(!(I[b+28|0]&128)){e=e+1|0;H[d+(e<<2)>>2]=H[b+20>>2]}b=b+8|0;while(1){b=H[b>>2];if(!b){continue $}e=e+1|0;H[d+(e<<2)>>2]=H[b+44>>2];b=b+20|0;continue}}break}H[d>>2]=e;c=H[a+44>>2];b=i+8|0;H[a+44>>2]=(b|0)<(c|0)?c:b;lj(a);kb(g,155,2,e,1,d,-14);pb(g,x&255);b=db(g,50,2);H[f+336>>2]=H[k+H[h+16>>2]>>2];kb(g,117,0,3,0,tb(h,29334,f+336|0),-6);Xa(g,111,2,3,3);cj(g);bb(g,b);aa:while(1){l=H[l>>2];if(!l){break _}q=H[l+8>>2];if(I[q+43|0]|!(!v|(q|0)==(v|0))){continue}c=0;r=0;if(I[q+28|0]&128){r=tc(q)}Yk(a,q,112,0,1,0,f+404|0,f+400|0);Va(g,71,0,7);k=q+8|0;b=k;while(1){b=H[b>>2];if(b){Va(g,71,0,c+8|0);c=c+1|0;b=b+20|0;continue}break}Va(g,35,H[f+404>>2],0);m=Va(g,86,7,1);u=(p&255)==81;if(!u){Xa(g,94,H[f+404>>2],G[q+36>>1]-1|0,3);pb(g,128)}n=H[q+28>>2]&65536;c=0;while(1){if(G[q+34>>1]>(c|0)){ba:{if(G[q+32>>1]==(c|0)){break ba}o=N(c,12);y=o+H[q+4>>2]|0;if(!(n?1:I[y+4|0]&15)){break ba}d=0;if(n){d=jb(a)}Qc(g,q,H[f+404>>2],c,3);if(I[Nc(g,-1)|0]==94){pb(g,128)}if(I[y+4|0]&15){e=db(g,51,3);b=H[q>>2];H[f+308>>2]=H[y>>2];H[f+304>>2]=b;kb(g,117,0,3,0,tb(h,5932,f+304|0),-6);ca:{if(!(!n|(I[y+4|0]&240)==16)){Yb(g,d);break ca}cj(g)}bb(g,e)}if(!(F[q+30|0]&1)){break ba}b=I[y+4|0]>>>4|0;if((b|0)==1){break ba}i=Xa(g,17,3,0,F[b+49055|0]);e=H[(I[y+4|0]>>>2&60)+65052>>2];b=H[q>>2];H[f+296>>2]=H[o+H[q+4>>2]>>2];H[f+292>>2]=b;H[f+288>>2]=e;kb(g,117,0,3,0,tb(h,5910,f+288|0),-6);lb(g,d);cj(g);bb(g,i)}c=c+1|0;continue}break}b=H[q+16>>2];if(!(!b|I[h+33|0]&2)){e=rc(h,b,0);if(!I[h+87|0]){d=jb(a);b=jb(a);H[a+52>>2]=H[f+404>>2]+1;c=H[e>>2];while(1){if((c|0)>=2){c=c-1|0;zc(a,H[(e+(c<<4)|0)+8>>2],d,0);continue}break}_e(a,H[e+8>>2],b,16);lb(g,d);H[a+52>>2]=0;H[f+320>>2]=H[q>>2];kb(g,117,0,3,0,tb(h,6199,f+320|0),-6);cj(g);lb(g,b)}qb(h,e)}if(u){Va(g,38,H[f+404>>2],m);bb(g,m-1|0);continue}else{i=-1;d=0;c=k;e=0;while(1){b=H[c>>2];if(b){c=jb(a);if((b|0)!=(r|0)){i=Gn(a,b,H[f+404>>2],0,0,f+396|0,e,i);Va(g,86,d+8|0,1);c=ob(g,28,H[f+400>>2]+d|0,c,i,J[b+52>>1]);Bd(g,3,28768);Xa(g,111,7,3,3);Bd(g,4,28747);Xa(g,111,4,3,3);u=Bd(g,4,H[b>>2]);Xa(g,111,4,3,3);o=cj(g);bb(g,c);if(I[b+54|0]){c=0;n=jb(a);while(1){if(J[b+50>>1]>c>>>0){e=G[H[b+4>>2]+(c<<1)>>1];if(!(I[(H[q+4>>2]+N(e&65535,12)|0)+4|0]&15?(e|0)>=0:0)){Va(g,50,c+i|0,n)}c=c+1|0;continue}break}c=db(g,38,H[f+400>>2]+d|0);Yb(g,n);bb(g,c);ob(g,40,H[f+400>>2]+d|0,n,i,J[b+50>>1]);Bd(g,3,28691);Yb(g,u);lb(g,n)}bb(g,o);ys(a,H[f+396>>2]);e=b}d=d+1|0;c=b+20|0;continue}break}Va(g,38,H[f+404>>2],m);bb(g,m-1|0);Bd(g,2,28718);b=0;while(1){d=H[k>>2];if(!d){continue aa}if((d|0)!=(r|0)){Va(g,98,H[f+400>>2]+b|0,3);c=Xa(g,53,b+8|0,0,3);pb(g,144);Bd(g,4,H[d>>2]);Xa(g,111,4,2,3);cj(g);bb(g,c)}b=b+1|0;k=d+20|0;continue}}}}x=x+1|0;continue}break}a=zg(g,7,49072);if(a){F[a+101|0]=255;H[a+56>>2]=11256;F[a+41|0]=255;H[a+8>>2]=1-z;A=a,B=Dg(11),H[A+116>>2]=B}fj(g,0,H[g+108>>2]-2|0);break b}if(!j){break b}b=Oj(j,0);a=b?49280:30012;Sj(h,13717,2,1,a,62,0,0,0,0,0);Sj(h,13717,3,1,a,62,0,0,0,0,0);a=hf(h,13717,2,1,0);b=b?12:4;H[a+4>>2]=b|H[a+4>>2];a=hf(h,13717,3,1,0);H[a+4>>2]=b|H[a+4>>2];break b}b=H[a+44>>2];m=b+5|0;H[a+44>>2]=m;u=b+3|0;o=b+2|0;t=b+1|0;k=H[H[(H[h+16>>2]+(i<<4)|0)+12>>2]+16>>2];while(1){if(!k){break b}da:{if(j){i=Sf(a,0,j,e);k=0;break da}i=H[k+8>>2];k=H[k>>2]}if(I[i+43|0]|!i){continue}c=i+48|0;if(!H[c>>2]){continue}b=H[h+16>>2];n=Lb(h,H[i+60>>2]);e=H[b+(n<<4)>>2];Fd(a,n);Dd(a,n,H[i+20>>2],0,H[i>>2]);b=m+G[i+34>>1]|0;if((b|0)>H[a+44>>2]){H[a+44>>2]=b}fe(a,0,n,i,112);Bd(g,t,H[i>>2]);l=1;b=c;while(1){d=H[b>>2];if(d){p=Dc(h,H[d+8>>2],e);ea:{if(!p){break ea}H[f+408>>2]=0;Dd(a,n,H[p+20>>2],0,H[p>>2]);if(bj(a,p,d,f+408|0,0)){break b}b=H[f+408>>2];if(!b){fe(a,l,n,p,112);break ea}Xa(g,112,l,H[b+44>>2],n);Od(a,b)}b=d+4|0;l=l+1|0;continue}break}if(H[a+40>>2]<(l|0)){H[a+40>>2]=l}r=1;l=db(g,35,0);while(1){s=H[c>>2];if(s){p=Dc(h,H[s+8>>2],e);H[f+404>>2]=0;H[f+408>>2]=0;if(p){bj(a,p,s,f+408|0,f+404|0)}n=jb(a);d=H[s+20>>2];b=m+d|0;if((b|0)>H[a+44>>2]){H[a+44>>2]=b}c=0;while(1){if((c|0)<(d|0)){b=H[f+404>>2];d=H[(b?b+(c<<2)|0:(s+(c<<3)|0)+36|0)>>2];b=c+m|0;Qc(g,i,0,d,b);Va(g,50,b,n);c=c+1|0;d=H[s+20>>2];continue}break}b=H[f+408>>2];fa:{if(b){kb(g,96,m,d,0,ej(h,b),H[s+20>>2]);ob(g,28,r,n,m,H[s+20>>2]);break fa}if(!p){break fa}Xa(g,29,r,H[g+108>>2]+2|0,m);Yb(g,n)}Va(g,H[i+28>>2]&128?75:135,0,o);b=H[s+8>>2];H[f+276>>2]=r-1;H[f+272>>2]=b;Le(g,u,17930,f+272|0);Va(g,84,t,4);lb(g,n);_a(h,H[f+404>>2]);c=s+4|0;r=r+1|0;continue}break}Va(g,38,0,l+1|0);bb(g,l);continue}}if(!j){break b}o=Dc(h,j,e);if(!o|I[o+43|0]){break b}c=H[o+48>>2];if(!c){break b}b=Lb(h,H[o+60>>2]);H[a+44>>2]=8;Fd(a,b);d=0;while(1){if(!c){break b}b=0;while(1){if(H[c+20>>2]>(b|0)){a=(b<<3)+c|0;i=H[H[o+4>>2]+N(H[a+36>>2],12)>>2];l=H[a+40>>2];k=H[c+8>>2];e=WC(I[c+26|0]);a=I[c+25|0];H[f+268>>2]=19591;A=f,B=WC(a),H[A+264>>2]=B;H[f+260>>2]=e;H[f+256>>2]=l;H[f+252>>2]=i;H[f+248>>2]=k;H[f+244>>2]=b;H[f+240>>2]=d;Le(g,1,3907,f+240|0);b=b+1|0;continue}break}d=d+1|0;c=H[c+4>>2];continue}}while(1){if((l|0)==66){break b}H[f+224>>2]=H[(l<<4)+34272>>2];Le(g,1,8311,f+224|0);l=l+1|0;continue}}H[a+44>>2]=1;c=h+392|0;while(1){c=H[c>>2];if(!c){break b}H[f+208>>2]=H[H[c+8>>2]+4>>2];Le(g,1,8311,f+208|0);continue}}b=H[h+24>>2];H[a+44>>2]=6;b=b>>>5&1;e=0;while(1){if((e|0)!=23){c=(e<<2)+70400|0;while(1){a=H[c>>2];if(a){VC(g,a,1,b);c=a+36|0;continue}break}e=e+1|0;continue}break}c=h+420|0;while(1){c=H[c>>2];if(!c){break b}VC(g,H[c+8>>2],0,b);continue}}H[a+44>>2]=2;c=h+436|0;b=0;while(1){c=H[c>>2];if(!c){break b}H[f+196>>2]=H[H[c+8>>2]>>2];H[f+192>>2]=b;Le(g,1,4984,f+192|0);b=b+1|0;continue}}H[a+44>>2]=3;c=0;while(1){if(H[h+20>>2]<=(c|0)){break b}a=H[h+16>>2]+(c<<4)|0;b=H[a+4>>2];if(b){a=H[a>>2];A=f,B=Fw(b),H[A+184>>2]=B;H[f+180>>2]=a;H[f+176>>2]=c;Le(g,1,3916,f+176|0)}c=c+1|0;continue}}if(!j){break b}c=Dc(h,j,e);if(!c){break b}b=Lb(h,H[c+60>>2]);H[a+44>>2]=5;Fd(a,b);c=c+8|0;b=0;while(1){e=H[c>>2];if(!e){break b}d=I[e+55|0]|I[e+56|0]<<8;c=I[e+54|0];a=H[e>>2];H[f+160>>2]=H[e+36>>2]!=0;H[f+148>>2]=a;H[f+152>>2]=(c|0)!=0;H[f+156>>2]=H[((d&3)<<2)+49044>>2];H[f+144>>2]=b;Le(g,1,11500,f+144|0);c=e+20|0;b=b+1|0;continue}}if(!j){break b}b=Ff(h,j,e);if(!b){b=Sf(a,2,j,e);if(!b|!(I[b+28|0]&128)){break b}b=tc(b);if(!b){break b}}d=Lb(h,H[b+24>>2]);c=!(H[m+8>>2]|H[m+12>>2]);l=J[(c?50:52)+b>>1];H[a+44>>2]=c?3:6;k=H[b+12>>2];Fd(a,d);c=0;while(1){if((c|0)==(l|0)){break b}i=G[H[b+4>>2]+(c<<1)>>1];if((i|0)>=0){d=H[H[k+4>>2]+N(i,12)>>2]}else{d=0}H[f+136>>2]=d;H[f+132>>2]=i;H[f+128>>2]=c;Le(g,1,17924,f+128|0);if(H[m+8>>2]|H[m+12>>2]){e=I[H[b+28>>2]+c|0];d=H[H[b+32>>2]+(c<<2)>>2];H[f+120>>2]=J[b+50>>1]>c>>>0;H[f+116>>2]=d;H[f+112>>2]=e;Le(g,4,17929,f+112|0)}Va(g,84,1,H[a+44>>2]);c=c+1|0;continue}}H[a+44>>2]=6;mj(a,e);while(1){if(H[h+20>>2]<=(r|0)){break b}a=H[h+16>>2];ga:{if(e){if(Qb(e,H[a+(r<<4)>>2])){break ga}}o=r<<4;i=H[(o+a|0)+12>>2];a=H[i+12>>2];while(1){b=i+16|0;ha:{ia:while(1){c=b;if(!a){break ha}while(1){c=H[c>>2];if(!c){a=0;continue ia}d=H[c+8>>2];if(J[d+34>>1]){continue}break}break}H[f+96>>2]=H[d>>2];b=tb(h,28035,f+96|0);if(b){H[f+408>>2]=0;Tp(h,b,f+408|0);dd(H[f+408>>2]);_a(h,b)}if(I[h+87|0]){Za(H[h+264>>2],1141,0);H[H[h+264>>2]+12>>2]=7}a=a-1|0;i=H[(o+H[h+16>>2]|0)+12>>2];continue}break}b=i+16|0;while(1){b=H[b>>2];if(!b){break ga}i=H[b+8>>2];if(j){if(Qb(j,H[i>>2])){continue}}a=1810;ja:{ka:{switch(I[i+43|0]-1|0){case 0:a=11157;break ja;case 1:break ja;default:break ka}}a=I[i+29|0]&16?1682:13584}l=H[o+H[h+16>>2]>>2];d=H[i>>2];la:{ma:{if(Fb(d,17563,7)){break ma}k=d+7|0;c=17468;if(!hb(k,8665)){break la}if(hb(k,8646)){break ma}d=17449}c=d}k=G[i+34>>1];d=H[i+28>>2];H[f+84>>2]=d>>>16&1;H[f+80>>2]=d>>>7&1;H[f+76>>2]=k;H[f+72>>2]=a;H[f+68>>2]=c;H[f+64>>2]=l;Le(g,1,11532,f- -64|0);continue}}r=r+1|0;continue}}_a(h,w);_a(h,j)}Ga=f+448|0}function Uo(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;M=Ga-16|0;Ga=M;O=a+124|0;k=H[a+116>>2];while(1){a:{b:{if(H[k+20>>2]>=0){break b}if(!lg(k)){break b}c=0;break a}c:{d:{if(!I[k+12|0]){c=0;if((N(H[k+20>>2],3)|0)<=H[H[a+20>>2]+40>>2]<<1){break a}f=I[a+68|0];if(!f){break a}break d}f=I[a+68|0];if(f){break d}b=H[a+20>>2]+8|0;while(1){e:{c=0;b=H[b>>2];if(!b){break e}if(!(I[b|0]|(a|0)==(b|0)|H[b+116>>2]!=H[a+116>>2])){c=ab(75589);break e}b=b+24|0;continue}break}if(c){break a}c=0;b=Ga-16|0;Ga=b;H[b+8>>2]=0;H[b+4>>2]=0;f=H[k+52>>2];f:{g:{h=_b(H[k+72>>2]);if(!h){U=b,V=If(f,b+8|0,b+4|0,H[k+4>>2],0),H[U+12>>2]=V;c=H[b+8>>2];Zt(k,c,b+12|0);if(I[f+17|0]){Jd(f,H[b+4>>2],5,H[k+4>>2],b+12|0)}h=H[b+12>>2];if(!h){break g}}H[O>>2]=0;Gb(c);break f}Ya(c+28|0,k+28|0,I[k+12|0]<<1);Ya(c+36|0,k+36|0,I[k+12|0]<<2);F[c+12|0]=I[k+12|0];li(k,I[H[c+56>>2]]&247);Cb((I[k+9|0]+H[k+56>>2]|0)+8|0,H[b+4>>2]);H[O>>2]=c;h=0}Ga=b+16|0;c=h;if(c){break a}H[a+120>>2]=k;c=0;G[a+70>>1]=0;G[a+72>>1]=0;F[a+68|0]=1;b=O;break c}b=(f<<24>>24)-1|0;p=J[((b<<1)+a|0)+72>>1];b=H[((b<<2)+a|0)+120>>2];c=_b(H[b+72>>2]);h:{if(c){break h}if(H[b+20>>2]<0){c=lg(b);if(c){break h}}i:{if(!I[k+2|0]|I[k+12|0]!=1|(H[b+4>>2]==1|J[k+28>>1]!=J[k+24>>1])){break i}if(J[b+24>>1]!=(p|0)){break i}c=b;l=M+3|0;d=Ga-96|0;Ga=d;j:{if(!J[k+24>>1]){b=ab(74500);break j}f=H[k+52>>2];b=If(f,d+92|0,d+84|0,0,0);if(b){break j}b=H[k+36>>2];H[d+80>>2]=b;U=d,V=Ka[H[k+76>>2]](k,b)|0,G[U+78>>1]=V;g=H[d+92>>2];li(g,13);H[d+12>>2]=k;H[d+8>>2]=1;H[d+20>>2]=d+78;H[d+16>>2]=d+80;b=H[k+60>>2];H[d+48>>2]=2;H[d+24>>2]=b;b=Yt(d+8|0,0,1,g);H[d+88>>2]=b;if(b){Gb(g);break j}H[g+20>>2]=(H[f+40>>2]-(J[g+18>>1]+J[d+78>>1]|0)|0)-2;k:{if(!I[f+17|0]){break k}Jd(f,H[d+84>>2],5,H[c+4>>2],d+88|0);if(J[d+78>>1]<=J[g+16>>1]){break k}Hl(g,g,H[d+80>>2],d+88|0)}j=l+4|0;b=(H[k+64>>2]+(J[k+24>>1]<<1)|0)-2|0;u=H[k+56>>2]+(J[k+26>>1]&(I[b|0]<<8|I[b+1|0]))|0;b=0;while(1){l:{h=b+1|0;f=h+u|0;H[d+80>>2]=f;q=b+u|0;if(F[q|0]>=0){break l}C=b>>>0<8;b=h;if(C){continue}}break}h=q+10|0;while(1){m:{b=f+1|0;H[d+80>>2]=b;f=F[f|0];F[j|0]=f;j=j+1|0;if((f|0)>=0){break m}f=b;if(b>>>0<h>>>0){continue}}break}if(!H[d+88>>2]){xl(c,J[c+24>>1],l,j-l|0,0,H[k+4>>2],d+88|0)}Cb((I[c+9|0]+H[c+56>>2]|0)+8|0,H[d+84>>2]);Gb(g);b=H[d+88>>2]}Ga=d+96|0;c=b;break h}l=b;C=Ij(H[H[a+20>>2]+36>>2]);S=(f|0)==1;A=F[a+3|0]&1;d=0;i=0;n=0;e=Ga-320|0;Ga=e;H[e+316>>2]=0;F[e+168|0]=0;H[e+164>>2]=0;$a(e+32|0,0,64);if(C){c=H[l+56>>2];b=J[l+24>>1];f=I[l+12|0];u=b+f|0;if(u>>>0>=2){n=0;n:{if(!p){break n}n=(p+A|0)-2|0;if((p|0)==(u|0)){break n}n=p-1|0}u=2-A|0}h=b;b=(n-f|0)+u|0;f=I[l+9|0]+8|0;o:{if((h|0)==(b|0)){break o}b=H[l+64>>2]+(b<<1)|0;f=J[l+26>>1]&(I[b|0]<<8|I[b+1|0])}b=f;w=H[l+52>>2];r=u+1|0;E=b+c|0;f=eb(E);c=u;p:{while(1){q:{if(!d){b=(e+304|0)+(c<<2)|0;h=ul(w,f,b,0,0);H[e+316>>2]=h;if(!h){break q}}H[e+172>>2]=f;g=0;$a(e+304|0,0,(c<<2)+4|0);break p}r:{b=H[b>>2];if(H[b+20>>2]>=0){break r}h=lg(b);H[e+316>>2]=h;if(!h){break r}H[e+172>>2]=f;g=0;$a(e+304|0,0,c<<2);break p}i=(J[b+24>>1]+i|0)+4|0;if(c){b=I[l+12|0];c=c-1|0;h=n+c|0;if(!(!b|(h|0)!=J[l+28>>1])){h=c<<2;b=H[l+36>>2];H[h+(e+264|0)>>2]=b;f=eb(b);U=h+(e+176|0)|0,V=Ka[H[l+76>>2]](l,b)|0,H[U>>2]=V;d=0;F[l+12|0]=0;continue}d=c<<2;g=d+(e+264|0)|0;b=H[l+64>>2]+(h-b<<1)|0;b=H[l+56>>2]+(J[l+26>>1]&(I[b|0]<<8|I[b+1|0]))|0;H[g>>2]=b;f=eb(b);j=d+(e+176|0)|0;d=Ka[H[l+76>>2]](l,b)|0;H[j>>2]=d;s:{if(!(I[w+24|0]&12)){break s}j=b-H[l+56>>2]|0;if(H[w+40>>2]<(j+d|0)){break s}Ya(j+C|0,b,d);H[g>>2]=C+(b-H[l+56>>2]|0)}yl(l,h-I[l+12|0]|0,d,e+316|0);d=H[e+316>>2];continue}break}H[e+172>>2]=f;b=i+3&2147483644;c=H[w+36>>2]+N(b,6)|0;f=Uc(0,c,c>>31);H[e+40>>2]=f;if(!f){H[e+316>>2]=7;g=0;break p}s=H[e+304>>2];H[e+36>>2]=s;m=f+(b<<2)|0;H[e+44>>2]=m;v=m+(b<<1)|0;t=((u|0)>=0?u:-1)+1|0;P=I[s+8|0];x=P<<2;o=I[s+2|0];d=0;h=0;j=0;while(1){t:{if((j|0)!=(t|0)){i=j<<2;b=H[i+(e+304|0)>>2];q=H[b+56>>2];if(I[q|0]!=I[H[s+56>>2]]){U=e,V=ab(74923),H[U+316>>2]=V;g=0;break p}c=q+J[b+18>>1]|0;D=J[b+26>>1];g=J[b+24>>1];$a(m+(d<<1)|0,0,g+I[b+12|0]<<1);z=I[b+12|0];if(!z){break t}y=J[b+28>>1];if(y>>>0<=g>>>0){g=0;while(1)if((g|0)==(y|0)){g=0;while(1){if((g|0)!=(z|0)){H[f+(d<<2)>>2]=H[(b+(g<<2)|0)+36>>2];g=g+1|0;d=d+1|0;continue}break}H[e+32>>2]=d;break t}else{H[f+(d<<2)>>2]=q+(D&(I[c+1|0]|I[c|0]<<8));g=g+1|0;d=d+1|0;c=c+2|0;continue}}U=e,V=ab(74947),H[U+316>>2]=V;g=0;break p}D=(x+H[w+40>>2]|0)-12|0;d=0;i=0;while(1){u:{if((i|0)==(t|0)){q=H[e+32>>2];b=r;j=0;break u}f=(e+32|0)+(d<<2)|0;c=i<<2;b=H[c+(e+304|0)>>2];H[f+16>>2]=H[b+60>>2];h=H[c+(e+208|0)>>2];H[f+40>>2]=h;if(d){f=d-1|0;f=(h|0)==H[((f<<2)+e|0)+72>>2]?f:d}else{f=0}if(!o){d=H[l+60>>2];f=f+1|0;g=(e+32|0)+(f<<2)|0;H[g+40>>2]=h+1;H[g+16>>2]=d}j=c+(e+176|0)|0;g=D-H[b+20>>2]|0;H[j>>2]=g;d=0;while(1){if(I[b+12|0]>d>>>0){g=((Ka[H[b+76>>2]](b,H[(b+(d<<2)|0)+36>>2])|0)+g|0)+2|0;H[j>>2]=g;d=d+1|0;continue}break}H[c+(e+240|0)>>2]=h;d=f+1|0;i=i+1|0;continue}break}while(1){v:{if((b|0)>(j|0)){h=j+2|0;t=j<<2;c=e+240|0;d=t+c|0;g=c;f=j+1|0;c=f<<2;z=g+c|0;g=c;c=e+176|0;m=g+c|0;v=c+t|0;c=H[v>>2];while(1){w:{if((c|0)<=(D|0)){H[v>>2]=c;g=H[d>>2];h=(g|0)>(q|0)?g:q;while(1){if((g|0)==(h|0)){break v}i=jg(e+32|0,g)+2|0;c=i+c|0;if((D|0)<(c|0)){break w}H[v>>2]=c;g=g+1|0;x:{if(o){break x}i=0;if((g|0)>=(q|0)){break x}i=jg(e+32|0,g)+2|0}H[m>>2]=H[m>>2]-i;continue}}if((b|0)<=(f|0)){if(j>>>0>=4){H[v>>2]=c;U=e,V=ab(75048),H[U+316>>2]=V;g=0;break p}H[m>>2]=0;H[z>>2]=q;b=h}i=H[d>>2];y=i-1|0;B=jg(e+32|0,y)+2|0;g=B;y:{if(o){break y}g=0;if((i|0)>=(q|0)){break y}g=jg(e+32|0,i)+2|0}c=c-B|0;H[m>>2]=g+H[m>>2];H[d>>2]=y;continue}break}H[d>>2]=g;c=j?H[(e+t|0)+236>>2]:0;j=f;if((c|0)<(g|0)){continue}U=e,V=ab(75081),H[U+316>>2]=V;g=0;break p}v=H[e+44>>2];z=b-1|0;j=z;while(1){z:{A:{if((j|0)>0){y=j<<2;c=e+176|0;B=y+c|0;f=H[B>>2];h=c;m=j-1|0;c=m<<2;Q=h+c|0;i=H[Q>>2];R=c+(e+240|0)|0;d=H[R>>2];g=d-o|0;jg(e+32|0,g);T=(j|0)==(z|0)?0:-2;while(1){c=d-1|0;jg(e+32|0,c);B:{if(!f){h=J[v+(g<<1)>>1]+2|0;t=J[v+(c<<1)>>1];break B}if(A){break A}h=(J[v+(g<<1)>>1]+f|0)+2|0;t=J[v+(c<<1)>>1];if((h|0)>((i+T|0)-t|0)){break A}}H[R>>2]=c;g=g-1|0;i=(i-t|0)-2|0;t=(d|0)>1;f=h;d=c;if(t){continue}break}break z}f=(b|0)>0?b:0;j=p-n|0;h=I[H[s+56>>2]];c=0;g=0;while(1){C:{if((c|0)==(f|0)){f=0;A=(g|0)>0?g:0;break C}D:{if((c|0)<=(u|0)){d=c<<2;m=d+(e+304|0)|0;b=H[m>>2];H[d+(e+272|0)>>2]=b;H[m>>2]=0;d=_b(H[b+72>>2]);H[e+316>>2]=d;if(!(G[H[b+72>>2]+30>>1]==(((c|0)==(j|0)?2:1)|0)|d)){d=ab(75156);H[e+316>>2]=d}g=g+1|0;if(!d){break D}break p}b=If(w,e+8|0,e+172|0,A?1:H[e+172>>2],0);H[e+316>>2]=b;if(b){break p}b=H[e+8>>2];li(b,h);d=c<<2;H[d+(e+208|0)>>2]=q;H[d+(e+272|0)>>2]=b;g=g+1|0;if(!I[w+17|0]){break D}Jd(w,H[b+4>>2],5,H[l+4>>2],e+316|0);if(H[e+316>>2]){break p}}c=c+1|0;continue}break}while(1){E:{F:{if((f|0)==(A|0)){i=H[e+172>>2];f=0;while(1){G:{d=0;c=1;if((f|0)==(A|0)){H[e+172>>2]=i;m=g-1|0;b=H[(e+272|0)+(m<<2)>>2];Cb(E,H[b+4>>2]);if(!(h&8|(g|0)==(r|0))){b=H[b+56>>2];c=H[H[(u<<2)+((g|0)>(r|0)?e+272|0:e+304|0)>>2]+56>>2];c=I[c+8|0]|I[c+9|0]<<8|(I[c+10|0]<<16|I[c+11|0]<<24);F[b+8|0]=c;F[b+9|0]=c>>>8;F[b+10|0]=c>>>16;F[b+11|0]=c>>>24}if(I[w+17|0]){break G}r=H[e+40>>2];break F}while(1){if((c|0)!=(g|0)){b=e+112|0;d=K[b+(c<<2)>>2]<K[b+(d<<2)>>2]?c:d;c=c+1|0;continue}break}b=d<<2;c=b+(e+112|0)|0;i=H[c>>2];H[c>>2]=-1;if((d|0)!=(f|0)){if((d|0)>(f|0)){Xt(H[H[b+(e+272|0)>>2]+72>>2],(H[w+48>>2]+d|0)+1|0,0)}b=H[(e+272|0)+(f<<2)>>2];Xt(H[b+72>>2],i,J[(e+102|0)+(d<<1)>>1]);H[b+4>>2]=i}f=f+1|0;continue}break}j=0;p=(q|0)>0?q:0;f=H[e+272>>2];d=I[f+12|0]+J[f+24>>1]|0;s=!o;r=H[e+40>>2];b=f;c=0;i=0;while(1){if((i|0)==(p|0)){break F}t=i+s|0;h=H[(i<<2)+r>>2];while(1){if((d|0)==(i|0)){c=c+1|0;f=H[((g|0)>(c|0)?e+272|0:e+304|0)+(c<<2)>>2];d=(t+J[f+24>>1]|0)+I[f+12|0]|0;continue}break}H:{if(H[(e+240|0)+(j<<2)>>2]==(i|0)){j=j+1|0;b=H[(e+272|0)+(j<<2)>>2];if(!o){break H}}if(!(H[b+4>>2]!=H[(e+144|0)+(c<<2)>>2]|(c|0)>=(g|0)|h>>>0<K[f+56>>2])){if(h>>>0<K[f+60>>2]){break H}}if(!P){Jd(w,eb(h),5,H[b+4>>2],e+316|0)}if(jg(e+32|0,i)>>>0>J[b+16>>1]){Hl(b,f,h,e+316|0)}if(H[e+316>>2]){break p}}i=i+1|0;continue}}c=f<<2;d=H[c+(e+272|0)>>2];b=H[d+4>>2];H[c+(e+144|0)>>2]=b;H[c+(e+112|0)>>2]=b;G[(e+102|0)+(f<<1)>>1]=J[H[d+72>>2]+28>>1];c=0;while(1){if((c|0)==(f|0)){break E}d=c<<2;c=c+1|0;if((b|0)!=H[d+(e+144|0)>>2]){continue}break}U=e,V=ab(75202),H[U+316>>2]=V;break p}i=0;s=(m|0)>0?m:0;h=0;while(1){if((h|0)!=(s|0)){d=i+C|0;c=h<<2;f=H[c+(e+240|0)>>2];p=J[v+(f<<1)>>1];j=p+x|0;b=H[(f<<2)+r>>2];m=H[c+(e+272|0)>>2];I:{if(!I[m+8|0]){c=H[m+56>>2];p=I[b|0]|I[b+1|0]<<8|(I[b+2|0]<<16|I[b+3|0]<<24);F[c+8|0]=p;F[c+9|0]=p>>>8;F[c+10|0]=p>>>16;F[c+11|0]=p>>>24;break I}if(o){f=f-1|0;Ka[H[m+80>>2]](m,H[(f<<2)+r>>2],e+8|0);j=Gf(d+4|0,H[e+8>>2],H[e+12>>2])+4|0;b=d;d=0;break I}b=b-4|0;if((p|0)!=4){break I}j=Ka[H[l+76>>2]](l,b)|0}c=0;while(1){p=(e+32|0)+(c<<2)|0;if(H[p+40>>2]<=(f|0)){t=c>>>0<6;c=c+1|0;if(t){continue}}break}c=H[p+16>>2];if(!(c>>>0<b>>>0|c>>>0>=b+j>>>0)){U=e,V=ab(75359),H[U+316>>2]=V;break p}xl(l,h+n|0,b,j,d,H[m+4>>2],e+316|0);h=h+1|0;i=i+j|0;if(!H[e+316>>2]){continue}break p}break}c=1-g|0;z=(c|0)<(g|0)?g:c;t=!o;j=H[e+240>>2];while(1){J:{K:{L:{M:{if((c|0)!=(z|0)){b=c>>31;d=(b^c)-b|0;y=d+(e+164|0)|0;if(I[y|0]){break K}if((c|0)<0){b=(d<<2)-4|0;if(H[b+(e+208|0)>>2]<H[b+(e+240|0)>>2]){break K}break M}if(c){break M}b=0;h=0;f=j;break L}d=0;H[e+316>>2]=0;N:{O:{P:{if(J[l+24>>1]|!S){break P}b=H[e+272>>2];if(H[b+20>>2]<I[l+9|0]){break P}U=e,V=_t(b,-1),H[U+316>>2]=V;c=e+316|0;Zt(b,l,c);Sh(b,c);break O}if(!I[w+17|0]){break N}if(P){break N}while(1){if((d|0)==(A|0)){break O}b=H[(e+272|0)+(d<<2)>>2];Jd(w,eb(H[b+56>>2]+8|0),5,H[b+4>>2],e+316|0);d=d+1|0;continue}}}c=g;while(1){if((c|0)>(u|0)){break p}Sh(H[(e+304|0)+(c<<2)>>2],e+316|0);c=c+1|0;continue}}b=d-1|0;h=q;h=(d|0)<=(u|0)?t+H[(e+208|0)+(b<<2)>>2]|0:h;f=e+240|0;b=t+H[f+(b<<2)>>2]|0;f=H[f+(d<<2)>>2]-b|0}r=e+32|0;m=Ga-16|0;Ga=m;B=d<<2;n=H[B+(e+272|0)>>2];p=H[n+64>>2];o=I[n+9|0];v=H[n+56>>2];s=I[n+12|0];i=J[n+24>>1];d=i;Q:{if((b|0)>(h|0)){d=Wt(n,h,b-h|0,r);if((d|0)>(i|0)){b=ab(74387);break Q}x=H[n+64>>2];vd(x,x+(d<<1)|0,i<<1);d=i-d|0}s=s+(h+i|0)|0;i=b+f|0;if((s|0)>(i|0)){d=d-Wt(n,i,s-i|0,r)|0}i=o+v|0;o=(v+((I[i+5|0]<<8|I[i+6|0])-1&65535)|0)+1|0;H[m+12>>2]=o;R:{s=p+(f<<1)|0;if(s>>>0>o>>>0|o>>>0>K[n+60>>2]){break R}if((b|0)<(h|0)){p=H[n+64>>2];o=h-b|0;o=(f|0)>(o|0)?o:f;vd(p+(o<<1)|0,p,d<<1);if(Eo(n,s,m+12|0,p,b,o,r)){break R}d=d+o|0}o=0;while(1){if(I[n+12|0]>o>>>0){E=J[(n+(o<<1)|0)+28>>1]+h|0;p=E-b|0;if(!((p|0)<0|(f|0)<=(p|0))){x=H[n+64>>2]+(p<<1)|0;if((d|0)>(p|0)){vd(x+2|0,x,d-p<<1)}jg(r,E);if(Eo(n,s,m+12|0,x,E,1,r)){break R}d=d+1|0}o=o+1|0;continue}break}if(Eo(n,s,m+12|0,H[n+64>>2]+(d<<1)|0,b+d|0,f-d|0,r)){break R}F[n+12|0]=0;G[n+24>>1]=f;F[i+3|0]=f>>>8;F[i+4|0]=I[n+24|0];b=H[m+12>>2]-v|0;b=b<<8|(b&65280)>>>8;F[i+5|0]=b;F[i+6|0]=b>>>8;b=0;break Q}h=b;d=f;while(1){if((d|0)>0){i=h<<1;if(!J[i+H[r+12>>2]>>1]){o=H[r+4>>2];o=Ka[H[o+76>>2]](o,H[H[r+8>>2]+(h<<2)>>2])|0;G[i+H[r+12>>2]>>1]=o}d=d-1|0;h=h+1|0;continue}break}b=Yt(r,b,f,n)}Ga=m+16|0;if(b){break J}F[y|0]=1;H[n+20>>2]=D-H[B+(e+176|0)>>2]}c=c+1|0;continue}break}H[e+316>>2]=b;break p}f=f+1|0;continue}}c=d;h=f}H[B>>2]=h;H[Q>>2]=i;d=0;d=(j|0)>=2?H[(e+y|0)+232>>2]:d;j=m;if((c|0)>(d|0)){continue}break}U=e,V=ab(75123),H[U+316>>2]=V;g=0;break p}H[d>>2]=h;b=f;j=b;continue}}g=(q+J[b+18>>1]|0)+(J[b+24>>1]<<1)|0;while(1){if(c>>>0<g>>>0){H[f+(d<<2)>>2]=q+(D&(I[c+1|0]|I[c|0]<<8));d=d+1|0;H[e+32>>2]=d;c=c+2|0;continue}break}H[i+(e+208|0)>>2]=d;if(!((j|0)>=(u|0)|o)){c=m+(d<<1)|0;g=H[i+(e+176|0)>>2];G[c>>1]=g;q=H[i+(e+264|0)>>2];i=g&65535;q=Ya(h+v|0,q,i)+x|0;H[f+(d<<2)>>2]=q;g=J[c>>1]-x|0;G[c>>1]=g;h=h+i|0;S:{if(!I[b+8|0]){b=H[b+56>>2];b=I[b+8|0]|I[b+9|0]<<8|(I[b+10|0]<<16|I[b+11|0]<<24);F[q|0]=b;F[q+1|0]=b>>>8;F[q+2|0]=b>>>16;F[q+3|0]=b>>>24;break S}while(1){if((g&65535)>>>0>3){break S}F[h+v|0]=0;g=J[c>>1]+1|0;G[c>>1]=g;h=h+1|0;continue}}d=d+1|0;H[e+32>>2]=d}j=j+1|0;continue}}c=0;_a(0,H[e+40>>2]);b=((u|0)>=0?u:-1)+1|0;while(1){if((b|0)==(c|0)){c=0;b=(g|0)>0?g:0;while(1){if((b|0)!=(c|0)){Gb(H[(e+272|0)+(c<<2)>>2]);c=c+1|0;continue}break}c=H[e+316>>2]}else{Gb(H[(e+304|0)+(c<<2)>>2]);c=c+1|0;continue}break}}else{c=7}Ga=e+320|0;if(L){Mf(L)}L=C}F[k+12|0]=0;Gb(k);b=I[a+68|0]-1|0;F[a+68|0]=b;b=((b<<24>>24<<2)+a|0)+120|0}k=H[b>>2];H[a+116>>2]=k;if(!c){continue}}break}if(L){Mf(L)}Ga=M+16|0;return c}function cC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;n=Ga-144|0;Ga=n;h=H[a+24>>2];e=H[h>>2];a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{c=I[b|0];switch(c-45|0){case 14:break m;case 5:case 6:break n;case 30:break o;case 1:case 2:case 13:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:break c;case 3:case 7:case 8:case 9:case 10:case 11:case 12:break g;case 0:break h;case 4:break i;default:break p}}q:{switch(c-138|0){case 3:break l;case 1:case 2:break c;case 0:break i;default:break q}}r:{switch(c-171|0){case 1:break j;case 0:break h;default:break r}}if((c|0)==20){break i}if(!(I[h+24|0]&46)|(c|0)!=156){break c}qn(e,h,4146,b,b);break c}a=H[h+4>>2];F[b|0]=167;H[b+44>>2]=H[a+24>>2];H[b+28>>2]=H[a+48>>2];G[b+32>>1]=J[b+32>>1]-1;F[b+1|0]=68;break c}c=h;while(1){if(!(!c|f>>>0>7)){H[(n+112|0)+(f<<2)>>2]=H[c+16>>2];f=f+1|0;c=H[c+12>>2];continue}break}Kb(a,H[b+12>>2]);a=H[b+12>>2];if($f(a)|I[e+208|0]>1){break b}c=I[b|0];F[b|0]=170;c=(c|0)==51;H[b+8>>2]=c?12244:12777;H[b+4>>2]=H[b+4>>2]|(c?268435456:536870912);c=0;while(1){if(!(!h|c>>>0>7)){H[h+16>>2]=H[(n+112|0)+(c<<2)>>2];c=c+1|0;h=H[h+12>>2];continue}break}fb(H[e>>2],a);H[b+12>>2]=0;break b}f=H[b+8>>2];c=0;a=0;break k}f=H[b+12>>2];if(I[h+24|0]&40){qn(e,h,8446,0,b)}c=0;a=H[b+16>>2];s:{if(I[a|0]==59){d=f;break s}d=H[a+12>>2];c=H[f+8>>2];a=H[a+16>>2]}g=a;f=H[a+8>>2];a=H[d+8>>2];if(I[e+208|0]<2){break k}od(e,b,g);od(e,b+44|0,d)}l=a;m=f;d=0;f=0;j=Ga-96|0;Ga=j;o=H[e>>2];H[j+92>>2]=0;g=b;H[b+28>>2]=-1;t:{if(!c|I[h+24|0]&6){break t}b=H[o+20>>2];a=(b|0)>0?b:0;while(1){u:{v:{if((a|0)==(d|0)){d=a;break v}f=H[o+16>>2];if(hb(H[f+(d<<4)>>2],c)){break u}t=H[(f+(d<<4)|0)+12>>2]}if((b|0)!=(d|0)){f=c;break t}f=c;if(hb(10683,c)){break t}a=H[o+16>>2];f=H[a>>2];t=H[a+12>>2];break t}d=d+1|0;continue}}z=g+44|0;b=0;r=167;p=h;w:{x:{y:{z:{A:{B:{C:{while(1){D:{x=H[p+4>>2];if(!x){c=0;break D}a=x+8|0;c=0;y=0;while(1){E:{F:{G:{if(H[x>>2]>(y|0)){q=H[a+16>>2];H:{I:{if(I[a+38|0]&32){k=H[H[a+20>>2]+28>>2];w=0;d=0;while(1){if(H[k>>2]>(d|0)){J:{i=k+(d<<4)|0;if(!$B(i+8|0,m,l,f)){break J}K:{if((c|0)<=0){break K}L:{if(I[a+38|0]&4){if((Og(H[a+44>>2],m)|0)>=0){break L}}qb(o,H[j+92>>2]);H[j+92>>2]=0;break K}s=I[a+36|0];if(!(s&16)){break J}if(!(s&8)){qb(o,H[j+92>>2]);c=0;H[j+92>>2]=0;break K}js(e,j+92|0,b,G[g+32>>1])}G[g+32>>1]=d;s=I[i+17|0]|I[i+18|0]<<8;b=s|64;F[i+17|0]=b;F[i+18|0]=b>>>8;w=1;c=c+1|0;u=2;b=a;if(!(s&128)){break J}break E}d=d+1|0;continue}break}if(!l){break E}if(!w){break I}break E}if(!l){break H}}M:{if(!f){break M}if(H[q+60>>2]!=(t|0)){break E}if(t){break M}if(ad(f,24097)){break E}}d=H[a+12>>2];if(d){i=d}else{i=H[q>>2]}if(hb(i,l)){break E}if(!d|I[e+208|0]<2){break H}od(e,0,z)}i=Ug(m);k=0;d=G[q+34>>1];w=(d|0)>0?d:0;d=H[q+4>>2];while(1){if((k|0)==(w|0)){break F}N:{if((i|0)!=I[d+7|0]){break N}if(hb(H[d>>2],m)){break N}O:{if((c|0)<=0){break O}P:{if(I[a+38|0]&4){if((Og(H[a+44>>2],m)|0)>=0){break P}}qb(o,H[j+92>>2]);H[j+92>>2]=0;break O}s=I[a+36|0];if(!(s&16)){break N}if(!(s&8)){qb(o,H[j+92>>2]);c=0;H[j+92>>2]=0;break O}js(e,j+92|0,b,G[g+32>>1])}G[g+32>>1]=G[q+32>>1]==(k|0)?-1:k;c=c+1|0;if(!(I[a+38|0]&32)){break G}Pk(a,k);break G}d=d+12|0;k=k+1|0;continue}}if(!b){b=0;break D}H[g+28>>2]=H[b+40>>2];a=H[b+16>>2];H[g+44>>2]=a;if(I[b+36|0]&72){H[g+4>>2]=H[g+4>>2]|2097152}t=H[a+60>>2];break D}b=a}if(c){break E}c=H[q+28>>2]&512;b=c?b:a;u=!(c>>>9|0)+u|0;c=0}a=a- -64|0;y=y+1|0;continue}}Q:{if(c|f){break Q}i=0;a=H[e+120>>2];R:{if(!a){break R}c=I[e+148|0];S:{if(I[e+149|0]){if(!(I[p+25|0]&4)){break R}if(l){if(hb(l,H[a>>2])){break R}}i=(c|0)!=128;break S}T:{if(!l|(c|0)==128){break T}if(hb(1709,l)){break T}i=1;break S}if(!l|(c|0)==127){break R}if(hb(14156,l)){break R}}H[g+28>>2]=i;i=a}U:{if(!l|!(H[p+24>>2]&512)){break U}a=H[p+8>>2];if(!a){break U}if(hb(15637,l)){break U}i=H[H[a+32>>2]+24>>2];H[g+28>>2]=2}if(!i){c=0;break Q}c=Ug(m);k=0;q=G[i+34>>1];a=(q|0)>0?q:0;u=u+1|0;d=H[i+4>>2];t=H[i+60>>2];V:{W:{while(1){if((a|0)==(k|0)){break W}X:{if((c|0)==I[d+7|0]){if(!hb(H[d>>2],m)){break X}}d=d+12|0;k=k+1|0;continue}break}a=G[i+32>>1]==(k|0)?-1:k;if((q|0)>(a|0)){break V}}if(!$l(m)){break V}a=I[i+29|0]&2?a:-1}c=0;if((a|0)>=(q|0)){break Q}Y:{Z:{b=H[g+28>>2];if((b|0)==2){if(I[e+208|0]>=2){H[g+44>>2]=i;G[g+32>>1]=a;c=1;r=167;break Y}B=g,C=H[H[p+8>>2]+36>>2]+Oc(i,a<<16>>16)|0,H[B+28>>2]=C;c=1;break Z}H[z>>2]=i;if(I[e+149|0]){F[g+2|0]=167;c=1;B=g,C=((H[p+8>>2]+Oc(i,a<<16>>16)|0)+N(b,G[i+34>>1]+1|0)|0)+1|0,H[B+28>>2]=C;break Z}G[g+32>>1]=a;_:{if((a|0)<0){F[g+1|0]=68;break _}a=a>>>0>31?-1:1<<a;if(!b){H[e+140>>2]=a|H[e+140>>2];break _}H[e+144>>2]=a|H[e+144>>2]}c=1;r=77;break Y}r=176}b=0}$:{if(!(!b|((u|0)!=1|c))){i=H[p+24>>2];if(i&40){break $}if(!$l(m)|I[H[b+16>>2]+29|0]&2){break $}F[g+1|0]=68;G[g+32>>1]=65535;k=1;break y}if(c){break C}i=H[p+24>>2]}aa:{if(l|!(i&128)){break aa}d=0;a=H[p+8>>2];c=H[a>>2];k=(c|0)>0?c:0;while(1){if((d|0)==(k|0)){break aa}ba:{c=a+(d<<4)|0;if(I[c+17|0]&3){break ba}c=H[c+12>>2];if(Qb(c,m)){break ba}b=H[(a+(d<<4)|0)+8>>2];f=H[b+4>>2];if(!(!(f&16)|i&1)){H[j+80>>2]=c;Za(e,6292,j+80|0);break z}if(!(!(f&32768)|((h|0)==(p|0)?i&16384:0))){H[j+64>>2]=c;Za(e,6096,j- -64|0);break z}if((Zc(b)|0)!=1){Za(e,14826,0);break z}_B(e,a,d,g,A);if(I[e+208|0]<2){break x}od(e,0,g);break x}d=d+1|0;continue}}A=A+1|0;p=H[p+12>>2];if(p){continue}break}a=10419;p=0;if(l){break B}ca:{if(!(I[g+4|0]&128)){break ca}c=1;da:{if(I[o+177|0]){break da}if(F[h+26|0]&1){d=H[o+32>>2];if(B=Jf(o),C=0,D=d&1073741824,D?B:C){break da}c=d>>>29&1;break da}c=H[o+32>>2]>>>30&1}if(!c){break ca}H[j+48>>2]=m;Fc(28,28152,j+48|0);b=H[e+8>>2];ea:{if(!b){break ea}c=ib(m);a=Tb(o,c+5|0,0);if(!a){break ea}H[a>>2]=H[b+204>>2];H[b+204>>2]=a;Ya(a+4|0,m,c+1|0)}H[g+44>>2]=0;H[g+48>>2]=0;F[g|0]=117;d=1;break w}d=1;if(ll(g)){break w}break B}k=1;a=13207;if((c|0)==1){break y}break A}c=0}fa:{ga:{d=H[j+92>>2];if(d){if(H[d>>2]==(c-1|0)){a=H[g+4>>2];if(!(a&8388608)){break ga}H[g+4>>2]=a&-8388609;break fa}qb(o,d);H[j+92>>2]=0}ha:{if(f){H[j+44>>2]=m;H[j+40>>2]=l;H[j+36>>2]=f;H[j+32>>2]=a;Za(e,5829,j+32|0);break ha}if(l){H[j+24>>2]=m;H[j+20>>2]=l;H[j+16>>2]=a;Za(e,5952,j+16|0);break ha}H[j+4>>2]=m;H[j>>2]=a;Za(e,7221,j)}mh(H[e>>2],g);F[e+17|0]=1;H[h+20>>2]=H[h+20>>2]+1;k=c;break y}fb(o,H[g+12>>2]);H[g+12>>2]=0;fb(o,H[g+16>>2]);H[g+16>>2]=0}js(e,j+92|0,b,G[g+32>>1]);H[g+8>>2]=13939;F[g|0]=172;H[g+20>>2]=H[j+92>>2];break x}d=2;break w}if(!(I[g+6|0]&129)){fb(o,H[g+12>>2]);H[g+12>>2]=0;fb(o,H[g+16>>2]);H[g+16>>2]=0;H[g+4>>2]=H[g+4>>2]|8388608}if(!(!b|G[g+32>>1]<0)){a=H[b+52>>2];B=b,C=H[b+48>>2]|is(g),H[B+48>>2]=C;H[b+52>>2]=Ja|a}F[g|0]=r;d=2;if((k|0)!=1){break w}}ia:{if(!H[H[e>>2]+360>>2]){break ia}a=I[g|0];if((a|0)!=167&(a|0)!=77){break ia}b=H[p+4>>2];f=Lb(H[e>>2],t);ja:{if((f|0)<0){break ja}ka:{if(I[g|0]!=77){a=0;c=H[b>>2];d=(c|0)>0?c:0;while(1){if((a|0)==(d|0)){break ja}i=b+(a<<6)|0;c=i+24|0;if(H[g+28>>2]==H[i+48>>2]){break ka}a=a+1|0;continue}}c=e+120|0}a=H[c>>2];if(!a){break ja}c=H[a>>2];i=H[a+4>>2];b=G[g+32>>1];la:{if((b|0)<0){d=G[a+32>>1];a=19671;if((d|0)<0){break la}b=d&65535}a=H[i+N(b,12)>>2]}if((ZB(e,c,a,f)|0)!=2){break ja}F[g|0]=121}}while(1){d=1;H[h+16>>2]=H[h+16>>2]+1;if((h|0)==(p|0)){break w}h=H[h+12>>2];continue}}Ga=j+96|0;c=d;break a}m=H[b+20>>2];if(m){f=H[m>>2]}c=H[e>>2];l=I[c+84|0];if(F[b+7|0]&1){d=H[b+44>>2];d=I[d+16|0]==166?0:d}o=H[h+24>>2];g=h+24|0;ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{r=H[b+8>>2];c=hf(c,r,f,l,0);va:{if(!c){c=hf(H[e>>2],r,-2,l,0);p=(c|0)!=0;l=!c;break va}r=H[c+20>>2];wa:{if(!(I[c+5|0]&4)){break wa}H[b+4>>2]=H[b+4>>2]|524288;if((f|0)==2){k=H[m+24>>2];f=Ga-16|0;Ga=f;H[f+8>>2]=0;H[f+12>>2]=-1074790400;l=-1;xa:{if(I[k|0]!=153){break xa}k=H[k+8>>2];Yd(k,f+8|0,ib(k),1);v=M[f+8>>3];if(v>1){break xa}v=v*134217728;if(P(v)<2147483648){l=~~v;break xa}l=-2147483648}Ga=f+16|0;H[b+28>>2]=l;if((l|0)>=0){break wa}H[n+96>>2]=b;Za(e,23950,n+96|0);H[h+20>>2]=H[h+20>>2]+1;break wa}H[b+28>>2]=I[H[c+32>>2]]==117?8388608:125829120}ya:{switch(cc(e,31,0,H[c+32>>2],0)|0){case 1:H[n+80>>2]=b;Za(e,18448,n+80|0);H[h+20>>2]=H[h+20>>2]+1;default:F[b|0]=121;break b;case 0:break ya}}f=H[c+4>>2];if(f&10240){H[b+4>>2]=H[b+4>>2]|1048576}k=H[g>>2];za:{if(!(f&2048)){if(!(k&42)){break za}qn(e,h,4670,0,b);f=H[c+4>>2];break za}F[b+2|0]=k&46;if(!(k&262144)){break za}H[b+4>>2]=H[b+4>>2]|1073741824}k=(r|0)!=0;if(!(I[H[e>>2]+24|0]&32?1:I[e+18|0]|!(f&262144))){break ua}Aa:{if(!(f&2621440)){l=1;break Aa}l=1;if(I[e+208|0]>1){break Aa}FC(e,b,c)}p=1}j=e+208|0;if(I[e+208|0]<2){break ta}f=c;break e}j=e+208|0;l=1;f=0;if(I[e+208|0]>1){break e}if(r){break sa}break qa}f=0;if(c){if(!(d?H[c+24>>2]:1)){break na}f=c}if(!k){break ra}}c=H[g>>2];k=H[f+4>>2]&65536;if(!(!(c&1)|(d?0:k))){i=1;if(!d|c&16384){break ra}}H[n+4>>2]=b;H[n>>2]=d|k?1675:12412;Za(e,25787,n);break oa}if(p){break pa}}if(I[H[e>>2]+177|0]){break pa}H[n+48>>2]=b;Za(e,18426,n+48|0);H[h+20>>2]=H[h+20>>2]+1;if(i){break ma}break f}if(!l){H[n+32>>2]=b;Za(e,25815,n+32|0);H[h+20>>2]=H[h+20>>2]+1;if(!i){break f}break ma}if(i){break ma}if(!(F[b+7|0]&1)){break f}H[n+16>>2]=b;Za(e,25879,n+16|0)}H[h+20>>2]=H[h+20>>2]+1;break f}H[n+64>>2]=b;Za(e,9793,n- -64|0);H[h+20>>2]=H[h+20>>2]+1;f=c;if(!k){break f}}H[g>>2]=H[g>>2]&(!d^-16385);gc(a,m);break d}if(!(I[b+5|0]&16)){break c}c=H[h+16>>2];Ba:{if(I[h+24|0]&46){qn(e,h,5482,b,b);break Ba}lc(a,H[b+20>>2])}if((c|0)==H[h+16>>2]){break c}H[b+4>>2]=H[b+4>>2]|64;H[h+24>>2]=H[h+24>>2]|64;break c}f=jd(H[b+16>>2]);if(!f){break g}c=I[f|0];if((c|0)!=170&(c|0)!=59){break g}c=2;if((cC(a,f)|0)==2){break a}if(I[f|0]!=170){break g}F[b+2|0]=I[b|0];F[b|0]=175;c=0;break a}if(I[H[e>>2]+87|0]){break c}a=Zc(H[b+12>>2]);Ca:{Da:{if(I[b|0]==48){c=H[b+20>>2];f=Zc(H[c+8>>2]);if((a|0)!=(f|0)){break Ca}c=c+24|0;break Da}c=b+16|0}f=Zc(H[c>>2])}if((a|0)==(f|0)){break c}Za(e,14826,0);mh(H[e>>2],b);break c}gc(a,m);break b}c=H[b+4>>2];gc(a,m);if(c&16777216){break d}c=1;if(!k){break a}}Ea:{Fa:{if(d){c=H[h+28>>2];if(I[j|0]<=1){b=c?H[c+72>>2]:0;h=H[d>>2];Ga:{Ha:{if(!(I[d+16|0]|!h)){b=IC(e,b,h);if(!b){break Ga}B=d,C=rc(H[e>>2],H[b+8>>2],0),H[B+8>>2]=C;B=d,C=rc(H[e>>2],H[b+12>>2],0),H[B+12>>2]=C;B=d,C=nb(H[e>>2],H[b+24>>2],0),H[B+24>>2]=C;B=d,C=nb(H[e>>2],H[b+28>>2],0),H[B+28>>2]=C;F[d+17|0]=I[b+17|0];F[d+18|0]=I[b+18|0];h=I[b+16|0];F[d+16|0]=h;F[d+20|0]=I[b+20|0];break Ha}ft(e,d,b);h=I[d+16|0]}Ia:{Ja:{if(!(H[d+28>>2]?1:H[d+24>>2])|(h|0)!=89){break Ja}b=H[d+12>>2];if(H[b>>2]==1?b:0){break Ja}Za(e,10197,0);break Ia}if(!(F[f+6|0]&1)){break Ia}if(!H[d+40>>2]){h=H[e>>2];i=H[f+32>>2];b=0;while(1){if((b|0)==8){break Ia}if((i|0)==H[(b<<4)+48480>>2]){fb(h,H[d+24>>2]);fb(h,H[d+28>>2]);F[d+20|0]=0;b=b<<4;F[d+18|0]=H[b+48492>>2];i=I[b+48488|0];F[d+17|0]=i;F[d+16|0]=H[b+48484>>2];H[d+24>>2]=0;H[d+28>>2]=0;if((i|0)!=86){break Ia}B=d,C=sc(h,155,23263),H[B+24>>2]=C;break Ia}else{b=b+1|0;continue}}}Za(e,4607,0)}H[d+44>>2]=f}if(I[H[e>>2]+87|0]){break c}}gc(a,H[d+8>>2]);gc(a,H[d+12>>2]);Kb(a,H[d+40>>2]);lC(c,d);c=H[g>>2];f=32768;a=g;break Fa}F[b+2|0]=0;F[b|0]=168;if(F[b+7|0]&1){Kb(a,H[H[b+44>>2]+40>>2])}while(1){if(!h){break Ea}c=H[h+4>>2];a=Ga+-64|0;Ga=a;H[a+40>>2]=0;H[a+44>>2]=0;H[a+48>>2]=0;H[a+52>>2]=0;H[a+24>>2]=0;H[a+28>>2]=0;H[a+40>>2]=66;H[a+32>>2]=0;H[a+36>>2]=0;H[a+36>>2]=67;H[a+16>>2]=0;H[a+20>>2]=0;H[a+44>>2]=68;H[a+56>>2]=a+8;d=H[e>>2];H[a+12>>2]=c;H[a+8>>2]=d;gc(a+32|0,H[b+20>>2]);if(F[b+7|0]&1){Kb(a+32|0,H[H[b+44>>2]+40>>2])}_a(H[e>>2],H[a+24>>2]);Ga=a- -64|0;a=J[a+52>>1];if(!(a&1?1:a?0:-1)){F[b+2|0]=I[b+2|0]+1;h=H[h+12>>2];continue}break}if(!f){break Ea}c=H[f+4>>2]&134221824^134217744;f=H[h+24>>2];a=h+24|0}H[a>>2]=c|f}H[g>>2]=H[g>>2]|o&16385;break b}c=(H[e+36>>2]!=0)<<1;break a}c=1}Ga=n+144|0;return c|0}function gz(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0,J=0,K=0,L=0,M=0;m=Ga-48|0;Ga=m;H[m+32>>2]=0;H[m+24>>2]=0;H[m+28>>2]=0;z=Ub(640);a:{if(!z){f=7;break a}e=Ga-16|0;Ga=e;H[e+12>>2]=0;k=m+24|0;H[k+4>>2]=0;g=Pb(a,22,e+12|0,0);H[e+8>>2]=g;if(!g){d=H[e+12>>2];wc(d,1,1);b:{if((Ab(d)|0)!=100){break b}h=mf(d,0);g=_d(d,0);if(!h){break b}pe(k,g,e+8|0);f=H[e+8>>2];if(f){break b}f=H[k>>2];if(f){Ya(f,h,g)}H[k+4>>2]=g;f=0}g=(K=f,L=rb(d),M=f,M?K:L)}G=(c|0)>2?c:2;t=z+584|0;J=z+568|0;Ga=e+16|0;f=g;c:{while(1){if((b|0)<=0|f){break c}d=H[a+256>>2];H[m+20>>2]=0;H[m+16>>2]=0;Pb(a,28,m+20|0,0);e=H[m+20>>2];wc(e,1,G);g=-1;d=d<<10;l=d;h=d>>31;if((Ab(e)|0)==100){s=ed(e,0);p=Ja;g=Qd(e,1)}H[m+40>>2]=g;f=rb(e);H[m+44>>2]=f;n=0;d:{if(f){break d}r=H[m+28>>2];if(!r){break d}H[m+8>>2]=0;H[m+12>>2]=0;H[m+4>>2]=0;q=m+8|0;j=m+4|0;f=267;o=H[m+28>>2];d=o-1|0;i=H[m+24>>2];e:{if(F[d+i|0]<0){break e}k=d>>31&d;f:{while(1){e=d;if((d|0)>0){d=e-1|0;if(F[i+d|0]<0){continue}break f}break}e=k;if((o|0)>0){break e}}d=((e|0)<=0?e:1)-1|0;while(1){g:{if((e|0)<2){f=d;break g}k=e+i|0;f=e-1|0;e=f;if(F[k-2|0]<0){continue}}break}H[m+28>>2]=f;e=qd(i+f|0,q)+f|0;d=e+H[m+24>>2]|0;f=F[d|0];h:{if((f|0)<0){d=uc(d,j);break h}H[j>>2]=f&255;d=1}f=(o|0)==(d+e|0)?0:267}H[m+44>>2]=f;i:{j:{if((g|0)<0){k=H[m+8>>2];e=H[m+12>>2];break j}e=UK(s,p,l,h);d=Ja;j=e;k=H[m+8>>2];e=H[m+12>>2];j=j>>>0<UK(k,e,l,h)>>>0;i=Ja;if(j&(i|0)>=(d|0)|(d|0)<(i|0)){break i}}d=(c|0)<(g|0)?g:c;p=H[m+4>>2];g=(d|0)<(p|0)?d:p;H[m+40>>2]=g;C=1;n=1;s=k;p=e;break d}H[m+28>>2]=r}if((g|0)<=0){break c}d=l;if(!((!s&(d|0)>=(p|0)|(d|0)>(p|0))&((p|0)>0|(p|0)>=0))){f=267;H[m+44>>2]=267;break c}h=$a(z,0,640);H[h+580>>2]=1;k:{l:{if(f){break l}e=Ga-16|0;Ga=e;H[e+12>>2]=0;d=Pb(a,8,e+12|0,0);if(!d){d=p;k=s+1|0;d=k?d:d+1|0;f=H[e+12>>2];Vb(f,1,k,d);Ab(f);K=m,L=Qd(f,0),H[K+16>>2]=L;d=rb(f)}Ga=e+16|0;f=d;H[m+44>>2]=d;k=H[m+16>>2];m:{if(!n|(k|0)!=1?k:0){break m}H[m+8>>2]=0;d=p;e=s+1|0;d=e?d:d+1|0;j=e;f=d;i=Ga-16|0;Ga=i;d=Pb(a,15,i+12|0,0);if(!d){e=f;d=j+1|0;e=d?e:e+1|0;l=H[i+12>>2];Vb(l,1,d,e);d=f;e=(j&-1024)+1024|0;d=e>>>0<1024?d+1|0:d;Vb(l,2,e,d);H[m+8>>2]=0;if((Ab(l)|0)==100){K=m,L=(ph(l,0)|0)==5,H[K+8>>2]=L}d=rb(l)}Ga=i+16|0;f=d;H[m+44>>2]=d;if(!H[m+8>>2]){break m}H[h+580>>2]=H[h+580>>2]|2}if(f){break l}i=Ga-16|0;Ga=i;H[i+12>>2]=0;j=$a(t,0,56);d=g<<2;e=Ib(d,0);H[j>>2]=e;n:{if(!e){d=7;break n}$a(e,0,d);d=Pb(a,12,i+12|0,0);if(d){break n}e=H[i+12>>2];Vb(e,1,s,p);f=0;l=0;while(1){o:{if(l){break o}if((Ab(e)|0)!=100|(g|0)<=(f|0)){break o}l=Ez(f,0,ed(e,1),Ja,ed(e,2),Ja,ed(e,3),Ja,mf(e,4),_d(e,4),H[j>>2]+(f<<2)|0);H[j+4>>2]=H[j+4>>2]+1;f=f+1|0;continue}break}d=(K=l,L=rb(e),M=l,M?K:L)}Ga=i+16|0;H[m+44>>2]=d;if(H[h+588>>2]!=(g|0)|d){break l}e=xk(a,t,J);H[m+44>>2]=e;if(e){break l}f=Li(a,t);if(f?(f|0)!=100:0){break k}p:{if(!(!n|(k|0)<=0)){q=k-1|0;v=H[h+624>>2];y=H[h+628>>2];i=Ga-80|0;Ga=i;H[i+72>>2]=0;e=Pb(a,32,i+72|0,0);q:{if(e){break q}H[i+64>>2]=0;H[i+68>>2]=0;H[i+60>>2]=0;e=p;d=s+1|0;e=d?e:e+1|0;j=H[i+72>>2];Vb(j,1,d,e);wc(j,2,q);r:{if((Ab(j)|0)==100){n=ed(j,1);r=Ja;w=ed(j,2);x=Ja;yy(j,3,i- -64|0,h+40|0);k=H[h+40>>2];e=H[h+44>>2];if((e|0)<0){e=0-(((k|0)!=0)+e|0)|0;k=0-k|0;H[h+40>>2]=k;H[h+44>>2]=e}F[h+48|0]=!(e|k);o=_d(j,4);u=mf(j,4);if(!u){rb(j);e=o?7:267;break q}e=H[i+68>>2];A=e;d=H[i+64>>2];g=0;k=Ga-16|0;Ga=k;H[k+12>>2]=0;l=Pb(a,34,k+12|0,0);if(!l){l=H[k+12>>2];Vb(l,1,d,e);g=(Ab(l)|0)==100;l=rb(l)}H[i+60>>2]=g;Ga=k+16|0;e=l;H[i+76>>2]=e;l=H[i+60>>2];if(!(!l|e)){H[i+56>>2]=0;H[i+52>>2]=0;e=zh(a,w,x,i+56|0,i+52|0);H[i+76>>2]=e;if(!e){e=Fq(i,H[i+56>>2],H[i+52>>2]);while(1){if(!(!H[i>>2]|e)){e=Cm(i);continue}break}H[i+76>>2]=e;if((uy(v,y,H[i+24>>2],H[i+28>>2])|0)<=0){H[i+60>>2]=0;l=0}Eq(i)}Wa(H[i+56>>2])}if(e){g=e;break r}g=e;if(!l){break r}l=F[u|0];if((l-16&255)>>>0<=240){rb(j);e=267;break q}k=l&255;e=0;H[h+32>>2]=d;H[h+36>>2]=A;H[h+24>>2]=n;H[h+28>>2]=r;H[h+16>>2]=q;H[h+8>>2]=s;H[h+12>>2]=p;g=((d-n|0)+1|0)/16|0;H[h>>2]=g;v=(l|0)>15?l:15;y=g>>31;while(1){if((k|0)!=(v|0)|e){d=k+1|0;e=d?e:e+1|0;k=d;w=(d<<5)+h|0;x=SK(d,e,g,y);q=x+n|0;d=Ja+r|0;H[w+56>>2]=q;H[w+60>>2]=q>>>0<x>>>0?d+1|0:d;continue}break}d=N(g,l);g=d;e=d+n|0;d=(d>>31)+r|0;k=h+(l<<5)|0;H[k+56>>2]=e;H[k+60>>2]=e>>>0<g>>>0?d+1|0:d;e=H[a+232>>2];pe(k+76|0,((e|0)<(o|0)?o:e)+20|0,i+76|0);e=H[i+76>>2];if(!e){Ya(H[k+76>>2],u,o);H[k+80>>2]=o;d=o+H[k+76>>2]|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[d+16|0]=0;F[d+17|0]=0;F[d+18|0]=0;F[d+19|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0}g=e;while(1){if((l|0)<0|g){break r}s:{t:{d=h+(l<<5)|0;g=H[d+76>>2];if(!g){break t}e=Fq(i,g,H[d+80>>2]);while(1){if(!(!H[i>>2]|e)){e=Cm(i);continue}break}H[i+76>>2]=e;n=d- -64|0;k=H[i+28>>2];pe(n,k,i+76|0);e=H[i+76>>2];g=e;if(e){break s}if((k|0)>0){Ya(H[n>>2],H[i+24>>2],k)}H[d+68>>2]=k;if((l|0)<=0){e=0;break t}H[i+56>>2]=0;H[i+52>>2]=0;e=H[i+20>>2];g=h+(l-1<<5)|0;d=g;k=H[i+16>>2];H[d+56>>2]=k;H[d+60>>2]=e;K=i,L=zh(a,k,e,i+56|0,i+52|0),H[K+76>>2]=L;k=d+76|0;d=H[i+52>>2];e=H[a+232>>2];pe(k,((d|0)>(e|0)?d:e)+20|0,i+76|0);e=H[i+76>>2];if(!e){Ya(H[g+76>>2],H[i+56>>2],d);H[g+80>>2]=d;d=d+H[g+76>>2]|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[d+16|0]=0;F[d+17|0]=0;F[d+18|0]=0;F[d+19|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0}Wa(H[i+56>>2]);g=e;break s}g=0}l=l-1|0;Eq(i);continue}}e=rb(j);break q}e=(K=e,L=rb(j),M=g,M?K:L)}Ga=i+80|0;break p}l=0;g=Ga-16|0;Ga=g;H[g+12>>2]=0;H[g+8>>2]=0;d=Pb(a,29,g+12|0,0);u:{if(d){break u}e=H[g+12>>2];Vb(e,1,s,p);d=H[t+4>>2];Vb(e,2,d,d>>31);if((Ab(e)|0)==100){l=Qd(e,0)}d=rb(e);if(d){break u}d=Pb(a,10,g+8|0,0);if(d){break u}d=H[g+8>>2];if((Ab(d)|0)==100){e=ed(d,0);H[h+24>>2]=e;i=Ja;H[h+28>>2]=i;n=e;e=l<<4;j=e;n=n+e|0;e=(e>>31)+i|0;e=j>>>0>n>>>0?e+1|0:e;H[h+32>>2]=n-1;H[h+36>>2]=e-!n}d=rb(d);if(d){break u}d=Hg(a,H[h+32>>2],H[h+36>>2],0,0);if(d){break u}H[h+16>>2]=k;H[h>>2]=l;H[h+8>>2]=s;H[h+12>>2]=p;i=l>>31;j=H[h+24>>2];o=H[h+28>>2];k=0;e=0;while(1){if(!(!e&(k|0)==16)){q=SK(k,e,l,i);n=q+j|0;d=Ja+o|0;r=h+(k<<5)|0;H[r+56>>2]=n;H[r+60>>2]=n>>>0<q>>>0?d+1|0:d;d=e;e=k+1|0;d=e?d:d+1|0;k=e;e=d;continue}break}d=0}Ga=g+16|0;e=d}H[m+44>>2]=e;v:{w:{if(!H[h>>2]|e){break w}x:{if(f){while(1){o=Ga-16|0;Ga=o;v=H[t+52>>2];A=H[t+48>>2];r=H[t+44>>2];u=H[t+40>>2];H[o+12>>2]=0;D=h- -64|0;d=tk(H[D>>2],H[h+68>>2],u,r);e=r-d|0;y:{if((e|0)<=0){e=267;break y}e=(ce(d,d>>31)+e|0)+ce(e,0)|0;E=ce(v,v>>31)+v|0;e=e+E|0;y=h+76|0;f=H[h+80>>2];if(!((f|0)<=0|H[a+232>>2]>=(e+f|0))){e=Hg(a,H[h+56>>2],H[h+60>>2],H[h+76>>2],f);H[o+12>>2]=e;H[h+4>>2]=H[h+4>>2]+1;if(!e){l=d+1|0;q=Ga-16|0;Ga=q;k=H[h+56>>2];e=H[h+60>>2];i=1;while(1){z:{if((i|0)==16){f=0;break z}H[q+12>>2]=0;g=h+(i<<5)|0;w=g- -64|0;j=H[g+68>>2];n=tk(H[w>>2],j,u,l);d=l-n|0;if((d|0)<=0){f=267;break z}f=n>>31;B=f;x=(ce(n,f)+d|0)+ce(d,0)|0;f=H[g+80>>2];A:{B:{if(!(H[a+232>>2]<(x+f|0)?j:0)){j=g+76|0;C:{if(f){break C}pe(j,H[a+232>>2],q+12|0);if(H[q+12>>2]){f=H[g+80>>2];break C}F[H[j>>2]]=i;f=pc(H[j>>2]+1|0,k,e)+1|0;H[g+80>>2]=f}e=q+12|0;pe(j,f+x|0,e);pe(w,l,e);k=0;e=0;f=H[q+12>>2];if(f){break A}D:{if(!H[g+68>>2]){f=H[g+80>>2];break D}f=pc(H[j>>2]+H[g+80>>2]|0,n,B)+H[g+80>>2]|0;H[g+80>>2]=f}f=pc(H[j>>2]+f|0,d,0)+H[g+80>>2]|0;H[g+80>>2]=f;Ya(f+H[j>>2]|0,n+u|0,d);H[g+80>>2]=d+H[g+80>>2];Ya(H[w>>2],u,l);f=0;d=l;break B}f=Hg(a,H[g+56>>2],H[g+60>>2],H[g+76>>2],f);F[H[g+76>>2]]=i;d=e;e=k+1|0;d=e?d:d+1|0;K=g,L=pc(H[g+76>>2]+1|0,e,d)+1|0,H[K+80>>2]=L;d=H[g+60>>2];e=d;k=H[g+56>>2];j=k+1|0;d=j?d:d+1|0;H[g+56>>2]=j;H[g+60>>2]=d;d=0}H[g+68>>2]=d}if(f){break z}i=i+1|0;if(e|k){continue}}break}Ga=q+16|0;H[o+12>>2]=f}f=0;H[h+80>>2]=0;H[h+68>>2]=0;d=H[h+60>>2];e=H[h+56>>2]+1|0;d=e?d:d+1|0;H[h+56>>2]=e;H[h+60>>2]=d;e=(ce(r,r>>31)+(r+E|0)|0)+1|0}d=H[h+44>>2]+(e>>31)|0;g=e+H[h+40>>2]|0;d=g>>>0<e>>>0?d+1|0:d;H[h+40>>2]=g;H[h+44>>2]=d;pe(y,e+f|0,o+12|0);e=H[o+12>>2];if(e){break y}if(!H[h+80>>2]){H[h+80>>2]=1;F[H[h+76>>2]]=0}e=ty(y,D,u,r,A,v)}Ga=o+16|0;f=e;if(!e){f=Li(a,t)}g=H[h+4>>2];if((f|0)==100&(g|0)>=(b|0)){break x}if((f|0)==100){continue}break}H[m+44>>2]=f;if(f){break w}}g=H[h+4>>2]}e=0;f=0;l=H[t+4>>2];while(1){if(!((l|0)<=0|e)){l=l-1|0;d=0;e=H[t+4>>2];k=(e|0)>0?e:0;e=0;while(1){if((e|0)!=(k|0)){d=e<<2;e=e+1|0;d=H[d+H[t>>2]>>2];if(H[d>>2]!=(l|0)){continue}}break}if(H[d+40>>2]){f=f+1|0;o=H[d>>2];r=H[d+64>>2];q=H[d+60>>2];n=0;k=0;e=0;u=0;v=0;j=Ga+-64|0;Ga=j;H[j+56>>2]=0;H[j+48>>2]=0;H[j+52>>2]=0;H[j+40>>2]=0;H[j+32>>2]=0;H[j+36>>2]=0;H[j+24>>2]=0;H[j+28>>2]=0;H[j+20>>2]=0;d=Pb(a,32,j+20|0,0);if(!d){d=H[j+20>>2];Vb(d,1,s,p);wc(d,2,o);if((Ab(d)|0)==100){n=mf(d,4);i=_d(d,4);u=ed(d,1);v=Ja;n=sy(n,i,j+48|0,r,q,j+24|0)}d=(K=n,L=rb(d),M=n,M?K:L)}while(1){E:{if(d){break E}i=H[j+24>>2];n=H[j+28>>2];if(!(i|n)){break E}H[j+16>>2]=0;H[j+12>>2]=0;d=zh(a,i,n,j+16|0,j+12|0);F:{if(d){break F}d=sy(H[j+16>>2],H[j+12>>2],j+32|0,r,q,j+24|0);if(d){break F}d=Hg(a,i,n,H[j+32>>2],H[j+36>>2])}Wa(H[j+16>>2]);k=i;e=n;continue}break}G:{if(!(e|k)|d){break G}H[j+16>>2]=0;d=Pb(a,17,j+16|0,0);if(d){break G}d=H[j+16>>2];Vb(d,1,u,v);Vb(d,2,k-1|0,e-!k|0);Ab(d);d=rb(d)}H:{if(d){break H}H[j+16>>2]=0;d=Pb(a,33,j+16|0,0);if(d){break H}n=H[j+16>>2];Vb(n,1,k,e);Bg(n,2,H[j+48>>2],H[j+52>>2],0);Vb(n,3,s,p);wc(n,4,o);Ab(n);d=rb(n);oh(n,2)}Wa(H[j+48>>2]);Wa(H[j+32>>2]);Ga=j- -64|0;e=d}else{e=zy(a,d);if(!e){k=H[d>>2];e=Ga-16|0;Ga=e;H[e+12>>2]=0;d=Pb(a,30,e+12|0,0);if(!d){d=H[e+12>>2];Vb(d,1,s,p);wc(d,2,k);Ab(d);d=rb(d)}Ga=e+16|0;e=d}H[m+40>>2]=0}continue}break}I:{if(e){break I}e=0;if(H[t+4>>2]==(f|0)){break I}i=0;n=0;d=0;l=0;j=Ga-16|0;Ga=j;H[j+12>>2]=0;H[j+8>>2]=0;J:{e=Pb(a,35,j+12|0,0);if(e){break J}k=H[j+12>>2];Vb(k,1,s,p);while(1){K:{o=Ab(k);if((o|0)==100){if((l|0)>(n|0)){e=d;break K}l=l+16|0;e=Ae(d,l<<2);if(e){break K}e=7}else{e=0}e=(K=e,L=rb(k),M=(o|0)==100,M?K:L);if(e){break J}e=0;k=Pb(a,31,j+8|0,0);if(k){e=k;break J}Vb(H[j+8>>2],2,s,p);break J}K=(n<<2)+e|0,L=Qd(k,0),H[K>>2]=L;n=n+1|0;d=e;continue}}F[a+240|0]=1;k=H[j+8>>2];while(1){if(!(i>>>0>=n>>>0|e)){e=0;l=H[(i<<2)+d>>2];if((l|0)!=(i|0)){wc(k,3,l);wc(k,1,i);Ab(k);e=rb(k)}i=i+1|0;continue}break}F[a+240|0]=0;Wa(d);Ga=j+16|0}H[m+40>>2]=f;H[m+44>>2]=e;b=(g^-1)+b|0;d=H[m+40>>2];k=1;if(!d){break v}pe(m+24|0,H[m+28>>2]+20|0,m+44|0);if(!H[m+44>>2]){e=pc(H[m+24>>2]+H[m+28>>2]|0,s,p)+H[m+28>>2]|0;H[m+28>>2]=e;K=m,L=pc(e+H[m+24>>2]|0,d,d>>31)+H[m+28>>2]|0,H[K+28>>2]=L}C=1}e=H[h+40>>2];d=0-(H[h+44>>2]+((e|0)!=0)|0)|0;H[h+40>>2]=0-e;H[h+44>>2]=d;k=0}l=Ga-16|0;Ga=l;g=H[m+44>>2];H[l+12>>2]=g;e=15;L:{while(1){if((e|0)<0){break L}d=h+(e<<5)|0;if(H[d+80>>2]<=0){Wa(H[d+76>>2]);Wa(H[d- -64>>2]);e=e-1|0;continue}break}M:{if(e){break M}pe(h+108|0,11,l+12|0);e=1;g=H[l+12>>2];if(g){break M}F[H[h+108>>2]]=1;K=h,L=pc(H[h+108>>2]+1|0,H[h+56>>2],H[h+60>>2])+1|0,H[K+112>>2]=L;g=0}f=0;while(1){if((e|0)!=(f|0)){d=h+(f<<5)|0;n=H[d+80>>2];if(!((n|0)<=0|g)){g=Hg(a,H[d+56>>2],H[d+60>>2],H[d+76>>2],n)}Wa(H[d+76>>2]);Wa(H[d- -64>>2]);f=f+1|0;continue}break}if(!g){d=H[h+12>>2];f=H[h+8>>2]+1|0;d=f?d:d+1|0;n=d;i=H[h+16>>2];o=H[h+24>>2];A=H[h+28>>2];B=H[h+56>>2];q=H[h+60>>2];r=H[h+32>>2];u=H[h+36>>2];if(I[h+48|0]){g=0;j=0}else{g=H[h+44>>2];j=H[h+40>>2]}d=h+(e<<5)|0;g=Hq(a,f,n,i,o,A,B,q,r,u,j,g,H[d+76>>2],H[d+80>>2])}e=h+(e<<5)|0;Wa(H[e+76>>2]);Wa(H[e- -64>>2]);H[m+44>>2]=g}Ga=l+16|0;if(I[h+48|0]|!k){break l}d=p;e=s+1|0;d=e?d:d+1|0;Ay(a,e,d,H[h+40>>2],H[h+44>>2])}Ch(t);f=H[m+44>>2];continue}break}Ch(t)}if(!(!C|f)){b=Ga-16|0;Ga=b;H[b+12>>2]=0;c=Pb(a,23,b+12|0,0);if(!c){a=H[b+12>>2];wc(a,1,1);Bg(a,2,H[m+24>>2],H[m+28>>2],0);Ab(a);c=rb(a);oh(a,2)}Ga=b+16|0;f=c}Wa(z);Wa(H[m+24>>2])}Ga=m+48|0;return f}function zi(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0,A=0,B=0,D=0,E=0,G=0,J=0,K=0,L=0,O=0,P=0;d=Ga-368|0;Ga=d;z=I[a+21|0]&2;if(z){u=H[c>>2];c=c+4|0}r=c;while(1){a:{b:{c:{d:{e=I[b|0];e:{if((e|0)==37){l=b;break e}c=b;if(!e){break d}while(1){f:{l=c+1|0;e=I[c+1|0];if((e|0)==37){break f}c=l;if(e){continue}}break}Bb(a,b,l-b|0);f=b;if(!I[l|0]){break d}}g:{h:{i:{j:{k:{l:{m:{n:{o:{c=I[l+1|0];if(c){l=l+1|0;h=-1;g=0;p=0;K=0;v=0;G=0;m=0;D=0;s=0;j=r;p:{while(1){e=1;q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{c=c<<24>>24;switch(c-32|0){case 2:case 4:case 5:case 6:case 7:case 8:case 9:case 15:break p;case 13:break q;case 14:break s;case 10:break t;case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:break u;case 12:break x;case 16:break y;case 1:break z;case 3:break A;case 0:break B;case 11:break C;default:break D}}if((c|0)!=108){break p}c=I[l+1|0];if((c|0)==108){break w}l=l+1|0;g=1;break v}m=43;break r}m=32;break r}G=1;break r}v=1;break r}K=1;break r}p=44;break r}c=I[l+2|0];l=l+2|0;g=2}c=c<<24>>24;break p}while(1){b=l+1|0;r=c-48|0;c=F[l+1|0];e=c&255;if((c-48&255)>>>0<=9){c=e+N(r,10)|0;l=b;continue}break}s=r&2147483647;if((e|0)==46|(e|0)==108){break r}l=b;break p}E:{if(z){c=dm(u);break E}c=H[j>>2];j=j+4|0}b=(c|0)<0;s=b?(c|0)==-2147483648?0:0-c|0:c;e=b?1:D;b=I[l+1|0];if((b|0)==46|(b|0)==108){break q}c=b<<24>>24;l=l+1|0;D=e;break p}F:{G:{e=I[l+1|0];if((e|0)!=42){b=l+1|0;l=0;while(1){c=e<<24>>24;if((e-48&255)>>>0>9){break G}l=(N(l,10)+c|0)-48|0;e=I[b+1|0];b=b+1|0;continue}}H:{if(z){c=dm(u);break H}c=H[j>>2];j=j+4|0}h=(c|0)<0?(c|0)==-2147483648?-1:0-c|0:c;b=l+2|0;c=F[l+2|0];break F}h=l&2147483647}if((c|0)!=108){l=b;break p}l=b-1|0}e=D}c=I[l+1|0];D=e;l=l+1|0;if(c){continue}break}c=0}e=0;while(1){if((e|0)==23){break d}E=N(e,6);if(F[E+29360|0]!=(c|0)){e=e+1|0;continue}break}I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{r=I[E+29363|0];switch(r|0){case 12:break I;case 11:break K;case 9:case 10:case 14:break L;case 5:case 6:break M;case 8:break N;case 7:break O;case 4:break P;case 1:case 2:case 3:break Q;case 16:break R;case 0:case 15:break S;case 13:break T;default:break d}}g=1}p=0}U:{if(!(4067322>>>e&1)){V:{if(z){r=j;b=dm(u);c=Ja;break V}if((g|0)==2){c=j+7&-8;r=c+8|0;b=H[c>>2];c=H[c+4>>2];break V}r=j+4|0;b=H[j>>2];c=b>>31}f=c;g=b;b=c>>31;c=b;g=g^c;q=g-c|0;t=(c^f)-((c>>>0>g>>>0)+c|0)|0;j=(f|0)<0?45:m;break U}if(z){q=dm(u);t=Ja;r=j;j=0;break U}W:{if((g|0)==2){b=j+7&-8;r=b+8|0;t=H[b+4>>2];q=H[b>>2];break W}r=j+4|0;t=0;q=H[j>>2]}j=0}if(K){b=s-((j&255)!=0)|0;h=(b|0)<(h|0)?h:b}X:{if((h|0)<37){m=0;c=d+272|0;b=70;break X}g=0;b=h+10|0;g=b>>>0<10?1:g;f=b;i=(h>>>0)/3|0;c=b+i|0;b=g;f=p?c:f;c=Rp(a,f,p?c>>>0<i>>>0?b+1|0:b:b);if(!c){break d}m=c;b=f}g=(b+c|0)-1|0;f=g;if((e|0)==22){f=g-2|0;b=VK(q,t,10,0);c=Ja;i=q-SK(b,c,10,0)|0;b=WK(b,c,10,0);b=(i>>>0>3?0:!Ja&(b|0)==1?0:i)<<1;F[f|0]=I[b+14092|0];F[g-1|0]=I[b+14093|0]}A=I[E+29364|0]+29504|0;w=I[E+29361|0];k=q;i=t;while(1){f=f-1|0;b=VK(k,i,w,0);c=Ja;O=f,P=I[A+(k-SK(b,c,w,0)|0)|0],F[O|0]=P;B=!i&k>>>0>=w>>>0|(i|0)!=0;k=b;i=c;if(B){continue}break}c=g-f|0;while(1){if((c|0)<(h|0)){f=f-1|0;F[f|0]=48;c=c+1|0;continue}break}Y:{if(!p){break Y}c=c-1|0;b=(c|0)/3|0;h=(c-N(b,3)|0)+1|0;f=f-b|0;c=0;while(1){if((b|0)<=0){break Y}F[c+f|0]=I[(b+c|0)+f|0];h=h-1|0;if(!h){c=c+1|0;F[f+c|0]=p;h=3;b=b-1|0}c=c+1|0;continue}}if(j&255){f=f-1|0;F[f|0]=j}Z:{if(7860991>>>e&1|(!G|!(q|t))){break Z}c=I[E+29365|0]+29537|0;while(1){b=I[c|0];if(!b){break Z}f=f-1|0;F[f|0]=b;c=c+1|0;continue}}h=g-f|0;break a}c=d+224|0;_:{if(z){b=H[u+4>>2];if((b|0)<H[u>>2]){H[u+4>>2]=b+1;y=Nb(H[H[u+8>>2]+(b<<2)>>2])}else{y=0}break _}b=j+7&-8;j=b+8|0;y=M[b>>3]}ok(c,y);b=H[d+228>>2];i=b;k=H[d+224>>2];H[d+352>>2]=k;H[d+356>>2]=b;b=H[d+232>>2];c=b;b=y<0;n=b?c:c;c=H[d+236>>2];c=b?c^-2147483648:c;o=c;H[d+360>>2]=n;H[d+364>>2]=c;c=(h|0)<0?6:(h|0)<1e8?h:1e8;L=(e|0)==15;h=c-((L|(e|0)==2)&(c|0)>0)|0;c=h&4095;y=M[((c>>>0)%10<<3)+29552>>3];while(1){if((c|0)>=10){c=c-10|0;y=y*1e-10;continue}break}if((e|0)==12){C(+Ei(k,i,n,o));c=x(1)|0;x(0)|0;if(((((c>>>20&2047)-1023|0)/3<<16>>16)+h|0)<=14){ok(d+208|0,y);De(d+192|0,k,i,n,o,0,-805306368,1595811444,1070291424);vm(d+176|0,H[d+192>>2],H[d+196>>2],H[d+200>>2],H[d+204>>2],H[d+208>>2],H[d+212>>2],H[d+216>>2],H[d+220>>2]);y=Ei(H[d+176>>2],H[d+180>>2],H[d+184>>2],H[d+188>>2])}ok(d+160|0,y);vm(d+144|0,k,i,n,o,H[d+160>>2],H[d+164>>2],H[d+168>>2],H[d+172>>2]);o=H[d+156>>2];n=H[d+152>>2];H[d+360>>2]=n;H[d+364>>2]=o;c=H[d+148>>2];i=c;k=H[d+144>>2];H[d+352>>2]=k;H[d+356>>2]=c}if(Op(Ei(k,i,n,o))){f=19193;h=3;break c}J=b?45:m;m=0;w=0;A=0;B=1073676288;b=0;$:{if((Fi(k,i,n,o,0,0,0,0)|0)<=0){break $}while(1){aa:{c=b;p=m;g=w;q=A;t=B;De(d+128|0,p,g,q,t,0,-805306368,-765899721,1095443610);m=H[d+128>>2];w=H[d+132>>2];A=H[d+136>>2];B=H[d+140>>2];if((Fi(k,i,n,o,m,w,A,B)|0)<0){break aa}b=c+100|0;if(c>>>0<351){continue}}break}while(1){ba:{f=c;w=g;B=t;m=p;A=q;De(d+112|0,p,g,q,t,0,0,-234881024,1075849733);p=H[d+112>>2];g=H[d+116>>2];q=H[d+120>>2];t=H[d+124>>2];if((Fi(k,i,n,o,p,g,q,t)|0)<0){break ba}c=f+10|0;if(f>>>0<351){continue}}break}while(1){ca:{b=f;c=m;g=w;q=A;p=B;De(d+96|0,c,g,q,p,0,0,0,1073889280);m=H[d+96>>2];w=H[d+100>>2];A=H[d+104>>2];B=H[d+108>>2];if((Fi(k,i,n,o,m,w,A,B)|0)<0){break ca}f=b+1|0;if(b>>>0<351){continue}}break}mq(d+80|0,k,i,n,o,c,g,q,p);n=H[d+88>>2];o=H[d+92>>2];k=H[d+80>>2];i=H[d+84>>2];while(1){if((nq(k,i,n,o,0,-1610612736,-299693885,1071929240)|0)<0){De(d,k,i,n,o,0,0,1073741824,1075412344);b=b-8|0;n=H[d+8>>2];o=H[d+12>>2];k=H[d>>2];i=H[d+4>>2];continue}break}while(1){if((nq(k,i,n,o,0,0,0,1073676288)|0)<0){De(d+16|0,k,i,n,o,0,0,0,1073889280);b=b-1|0;n=H[d+24>>2];o=H[d+28>>2];k=H[d+16>>2];i=H[d+20>>2];continue}break}H[d+352>>2]=k;H[d+356>>2]=i;H[d+360>>2]=n;H[d+364>>2]=o;if((b|0)<351){break $}F[d+272|0]=J;m=0;f=d+272|0;c=J&255;b=f|(c|0)!=0;F[b|0]=73;F[b+1|0]=110;F[b+2|0]=102;F[b+3|0]=0;h=c?4:3;break b}if((e|0)==12){break h}ok(d- -64|0,y);vm(d+48|0,k,i,n,o,H[d+64>>2],H[d+68>>2],H[d+72>>2],H[d+76>>2]);c=H[d+60>>2];g=H[d+56>>2];H[d+360>>2]=g;H[d+364>>2]=c;f=H[d+52>>2];i=H[d+48>>2];H[d+352>>2]=i;H[d+356>>2]=f;if((Fi(i,f,g,c,0,0,0,1073889280)|0)>=0){De(d+32|0,i,f,g,c,0,-1610612736,-1717986919,1073453465);c=H[d+44>>2];H[d+360>>2]=H[d+40>>2];H[d+364>>2]=c;c=H[d+36>>2];H[d+352>>2]=H[d+32>>2];H[d+356>>2]=c;b=b+1|0}if(!L&(e|0)!=2){break h}c=(b|0)<-4|(b|0)>(h|0);r=c?2:1;h=h-(c?0:b)|0;q=!G;break g}m=0;if(z){s=0;h=0;break b}H[H[j>>2]>>2]=H[a+16>>2];break J}F[d+272|0]=37;f=d+272|0;h=1;break c}da:{if(z){c=Np(u);if(c){b=I[c|0];F[d+272|0]=b;e=1;if(b>>>0<192){break da}while(1){b=I[c+1|0];if((b&192)!=128){break da}c=c+1|0;F[(d+272|0)+e|0]=b;e=e+1|0;if((e|0)!=4){continue}break}e=4;break da}F[d+272|0]=0;e=1;break da}b=j+4|0;c=H[j>>2];ea:{if(c>>>0<=127){F[d+272|0]=c;e=1;break ea}if(c>>>0<=2047){F[d+273|0]=c&63|128;F[d+272|0]=c>>>6|192;e=2;break ea}if(c>>>0<=65535){F[d+274|0]=c&63|128;F[d+272|0]=c>>>12|224;F[d+273|0]=c>>>6&63|128;e=3;break ea}F[d+275|0]=c&63|128;F[d+274|0]=c>>>6&63|128;F[d+273|0]=c>>>12&63|128;F[d+272|0]=c>>>18&7|240;e=4}j=b}f=d+272|0;v=1;m=0;if((h|0)<2){break j}s=(s-h|0)+1|0;if(!(D&255|(s|0)<2)){vi(a,s-1|0,32);s=0}while(1){if((h|0)<2){break j}Bb(a,d+272|0,e);h=h-1|0;continue}}if(!z){r=j+4|0;m=0;f=H[j>>2];if(!f){f=29357;break l}if((e|0)!=3){break l}if(H[a+16>>2]|(!H[a+12>>2]|s|(h|0)>=0)){break m}if(I[a+20|0]){m=f;break k}H[a+4>>2]=f;O=a,P=Rf(H[a>>2],f),H[O+8>>2]=P;O=a,P=ub(f)&2147483647,H[O+16>>2]=P;F[a+21|0]=I[a+21|0]|4;break n}b=Np(u);f=b?b:29357;m=0;r=j;break l}q=(e|0)==6?34:39;fa:{if(z){r=j;j=Np(u);break fa}r=j+4|0;j=H[j>>2]}t=(e|0)==5;c=j?j:t?19458:25242;n=h;o=h>>31;k=0;i=0;p=0;g=0;while(1){ga:{if(!(n|o)){break ga}b=I[c+k|0];if(!b){break ga}e=(b|0)==(q|0);ha:{if(!(b>>>0>191&v)){b=i;f=k+1|0;b=f?b:b+1|0;k=f;i=b;break ha}while(1){b=k+1|0;i=b?i:i+1|0;k=b;if((I[b+c|0]&192)==128){continue}break}}b=e+p|0;g=b>>>0<e>>>0?g+1|0:g;p=b;b=n;n=b-1|0;o=o-!b|0;continue}break}f=d+272|0;m=0;g=g+i|0;b=k+p|0;g=b>>>0<k>>>0?g+1|0:g;e=b+3|0;b=g;b=e>>>0<3?b+1|0:b;if((b|0)>=0&e>>>0>=71|(b|0)>0){m=Rp(a,e,b);f=m;if(!f){break d}}n=0;o=0;p=0;g=0;e=t&(j|0)!=0;if(e){F[f|0]=q;p=1}b=!!k&(i|0)>=0|(i|0)>0;j=b?k:0;h=b?i:0;while(1){if((j|0)!=(n|0)|(h|0)!=(o|0)){k=I[c+n|0];F[f+p|0]=k;i=g;b=p+1|0;i=b?i:i+1|0;if((k|0)!=(q|0)){g=i}else{F[b+f|0]=q;b=p+2|0;g=b>>>0<2?g+1|0:g}p=b;b=n+1|0;o=b?o:o+1|0;n=b;continue}break}if(e){F[f+p|0]=q;b=p+1|0}else{b=p}e=b;F[f+e|0]=0;break i}if(!(F[a+21|0]&1)){break d}b=H[j>>2];if(G){if(!b|I[b+5|0]&8){break J}ke(a,H[b+8>>2]);mh(H[a>>2],b);break J}if(!b){break J}c=H[b+4>>2];if(!c){break J}Bb(a,H[b>>2],c);c=H[b>>2];e=H[a>>2];ia:{if(!e|H[e+68>>2]!=-2){break ia}b=H[e+264>>2];if(!b){break ia}b=H[b+232>>2];if(!b|b>>>0>c>>>0){break ia}if(c>>>0>=ub(b)+b>>>0){break ia}H[e+68>>2]=c-b}}r=j+4|0;break n}if(!(F[a+21|0]&1)){break d}r=j+4|0;c=H[j>>2];e=H[c+12>>2];if(v?0:e){break o}b=H[c+8>>2];if(b){e=H[c+4>>2];if(e){ke(a,e);Bb(a,24059,1);b=H[c+8>>2]}ke(a,b);break n}if(e){break o}c=H[c+20>>2];b=H[c+16>>2];if(I[c+5|0]&8){H[d+256>>2]=b;vb(a,24113,d+256|0);break n}H[d+240>>2]=b;vb(a,24099,d+240|0);break n}Bb(a,28031,1);break d}ke(a,e)}m=0;s=0;h=0;break a}m=f}if((h|0)<0){break k}if(v){c=f;while(1){ja:{if((h|0)<=0){break ja}b=I[c|0];if(!b){break ja}h=h-1|0;c=c+1|0;if(b>>>0<192){continue}while(1){b=c;c=c+1|0;if((I[b|0]&192)==128){continue}break}c=b;continue}break}e=c-f|0;v=1;break i}c=0;while(1){if((c|0)==(h|0)){break a}if(I[c+f|0]){c=c+1|0;continue}else{h=c;break a}}}e=ub(f)&2147483647;break i}r=j}ka:{if(!v){break ka}c=e;if((s|0)<=0){break ka}while(1){if((c|0)<=0){break ka}c=c-1|0;s=((I[f+c|0]&192)==128)+s|0;continue}}h=e;break a}q=v}m=0;f=d+272|0;g=(h>>31)+(s>>31)|0;c=h+s|0;g=c>>>0<s>>>0?g+1|0:g;k=c;e=(r|0)==2?0:b;c=c+((e|0)>0?e:0)|0;i=g;i=c>>>0<k>>>0?i+1|0:i;g=i;if((i|0)>=0&c>>>0>=56|(i|0)>0){c=c+15|0;g=c>>>0<15?g+1|0:g;m=Rp(a,c,g);f=m;if(!f){break d}}H[d+348>>2]=N(v,10)+16;c=f;g=J&255;if(g){F[f|0]=J;c=f+1|0}i=v|G|(h|0)>0;la:{if((e|0)<0){F[c|0]=48;c=c+1|0;e=b;break la}while(1){if((e|0)>=0){O=c,P=Bw(d+352|0,d+348|0),F[O|0]=P;e=e-1|0;c=c+1|0;continue}break}e=-1}i=i&255;if(i){F[c|0]=46;c=c+1|0}k=(e|0)>=0?e:-1;while(1){if((e|0)!=(k|0)){F[c|0]=48;h=h-1|0;c=c+1|0;e=e+1|0;continue}break}while(1){if((h|0)>0){O=c,P=Bw(d+352|0,d+348|0),F[O|0]=P;c=c+1|0;h=h-1|0;continue}break}ma:{if(!(q&255)|!i){break ma}while(1){na:{oa:{e=c-1|0;switch(I[e|0]-46|0){case 0:break na;case 2:break oa;default:break ma}}F[e|0]=0;c=e;continue}break}if(v){F[c|0]=48;c=c+1|0;break ma}F[e|0]=0;c=e}if((r|0)==2){F[c|0]=I[I[E+29364|0]+29504|0];pa:{if((b|0)<0){F[c+1|0]=45;b=0-b|0;break pa}F[c+1|0]=43}if(b>>>0<100){c=c+2|0}else{e=(b>>>0)/100|0;F[c+2|0]=e+48;b=b-N(e,100)|0;c=c+3|0}e=((b&255)>>>0)/10|0;F[c|0]=e|48;F[c+1|0]=b-N(e,10)|48;c=c+2|0}F[c|0]=0;h=c-f|0;if(!K|D&255|(s|0)<=(h|0)){break b}c=s-h|0;e=s;while(1){if((c|0)<=(e|0)){F[e+f|0]=I[(e-c|0)+f|0];e=e-1|0;continue}break}e=(g|0)!=0;while(1)if(c){F[e+f|0]=48;e=e+1|0;c=c-1|0;continue}else{h=s;break b}}Ga=d+368|0;return}m=0}r=j}qa:{ra:{b=s-h|0;if((b|0)>0){if(D&255){break ra}vi(a,b,32)}Bb(a,f,h);break qa}Bb(a,f,h);vi(a,b,32)}if(m){_a(H[a>>2],m)}b=l+1|0;continue}}function Mg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0;n=Ga-32|0;Ga=n;d=H[b>>2];H[n+28>>2]=0;H[n+24>>2]=0;H[n+20>>2]=0;p=H[d>>2];u=H[p>>2];F[n+19|0]=0;a:{if(I[u+87|0]){break a}t=H[b+24>>2];e=N(c,48);h=t+e|0;k=H[h>>2];H[d+504>>2]=0;w=d+504|0;s=wf(w,H[k+12>>2]);r=Ja;q=I[k|0];b:{if((q|0)==49){if(AC(p,k)){break a}d=H[k+20>>2];g=t+N(c,48)|0;c:{if(I[k+5|0]&16){d=Nr(w,d);e=Ja;break c}d=xf(w,d);e=Ja}H[g+32>>2]=d;H[g+36>>2]=e;m=d|s;g=e|r;break b}e=e+t|0;d=wf(w,H[k+16>>2]);H[e+32>>2]=d;g=Ja;H[e+36>>2]=g;if(H[k+20>>2]?1:!H[k+12>>2]|H[k+4>>2]&266240){m=en(w,k);g=Ja;break b}m=d|s;g=g|r}if(H[w>>2]){d=t+N(c,48)|0;G[d+10>>1]=J[d+10>>1]|4096}i=H[k+4>>2];d:{if(!(i&3)){break d}d=Ye(w,H[k+36>>2]);e=Ja;if(i&1){g=e|g;l=g>>>1|0;m=d|m;v=(g&1)<<31|m>>>1;if((e|0)==(l|0)&d>>>0>v>>>0|e>>>0>l>>>0){z=d-1|0;A=e-!d|0;break d}Za(p,2967,0);break a}l=g>>>1|0;if((e|0)==(l|0)&d>>>0>((g&1)<<31|m>>>1)>>>0|e>>>0>l>>>0){break d}if(!(!(I[a+44|0]&64)|H[a>>2]<=0)){Za(p,2967,0);break a}i=i&-3;H[k+4>>2]=i}l=t+N(c,48)|0;H[l+40>>2]=m;H[l+44>>2]=g;H[l+16>>2]=-1;H[l+20>>2]=-1;G[l+12>>1]=0;e:{f:{if(gB(q)){i=gg(H[k+12>>2]);d=gg(H[k+16>>2]);j=s&H[l+32>>2]|r&H[l+36>>2]?2048:16383;e=H[l+28>>2];if((e|0)>0){i=H[(H[i+20>>2]+(e<<4)|0)-8>>2]}if(fB(a,s,r,n+8|0,i,q)){H[l+20>>2]=H[n+8>>2];H[l+24>>2]=H[n+12>>2];E=l,K=eB(q)&j,G[E+12>>1]=K}if((q|0)==45){e=t+N(c,48)|0;G[e+10>>1]=J[e+10>>1]|2048}g:{if(!d){break g}if(!fB(a,H[l+32>>2],H[l+36>>2],n+8|0,d,q)|I[d+4|0]&32){break g}d=k;e=h;f=0;h:{if(H[l+20>>2]<0){break h}d=nb(u,k,0);if(I[u+87|0]){fb(u,d);break a}e=se(b,d,3);if(!e){break a}h=H[b+24>>2];Lg(b,e,c);e=N(e,48);if((q|0)==45){f=e+h|0;G[f+10>>1]=J[f+10>>1]|2048}e=e+h|0;i=H[b+24>>2];h=i+N(c,48)|0;G[h+10>>1]=J[h+10>>1]|8;i:{if(I[H[p>>2]+80|0]&128){break i}f=I[d|0];if((f|0)!=53&(f|0)!=45|F[d+4|0]&1){break i}f=Lc(H[d+12>>2]);l=Lc(H[d+16>>2]);if((f|0)!=(l|0)&((f|0)<67|(l|0)<67)){break i}o=1;if(Tr(Uj(p,d))){break i}f=H[d+16>>2];o=Zf(p,H[d+12>>2]);f=Zf(p,f);o=!hb(H[o>>2],H[f>>2])}f=0;if(!o){break h}f=i+N(c,48)|0;G[f+12>>1]=J[f+12>>1]|2048;f=2048}i=H[d+12>>2];j:{k:{if(I[i|0]==177){break k}o=H[d+16>>2];if(I[o|0]==177){break k}if((vg(p,i,o)|0)==(vg(p,H[d+16>>2],H[d+12>>2])|0)){break j}}H[d+4>>2]=H[d+4>>2]^1024}E=d,K=ZK(H[d+12>>2],H[d+16>>2]),H[E+12>>2]=K;H[d+16>>2]=Ja;i=I[d|0];if(i>>>0>=54){F[d|0]=(i-54^2)+54}H[e+20>>2]=H[n+8>>2];i=H[n+12>>2];H[e+40>>2]=m;H[e+44>>2]=g;H[e+32>>2]=s|z;H[e+36>>2]=r|A;H[e+24>>2]=i;E=e,K=j&eB(I[d|0])+f,G[E+12>>1]=K;break f}if((q|0)!=50){break f}d=H[k+4>>2];if(d&1){break f}if($f(i)){break f}H[k+8>>2]=12777;F[k|0]=170;H[k+4>>2]=d|536870912;H[l+40>>2]=0;H[l+44>>2]=0;G[l+12>>1]=0;break f}l:{m:{n:{o:{p:{e=I[k|0];switch(e-48|0){case 1:case 2:break e;case 3:break m;case 0:break o;default:break p}}if((e|0)==43){break n}if((e|0)!=172){break e}if(I[b+8|0]!=44){break f}g=Ga-16|0;Ga=g;l=H[p>>2];d=0;e=H[k+20>>2];if(e){q:{i=H[e>>2];e=hf(l,H[k+8>>2],i,1,0);if(!e|!(I[e+4|0]&4)){break q}m=H[e+8>>2];q=I[m|0]|I[m+1|0]<<8;F[g+12|0]=q;F[g+13|0]=q>>>8;F[g+14|0]=I[m+2|0];if((i|0)>=3){f=H[H[k+20>>2]+40>>2];if(I[f|0]!=117){break q}m=H[f+8>>2];f=I[m|0];if(!f|I[m+1|0]|(I[g+12|0]==(f|0)|I[g+13|0]==(f|0))){break q}}F[g+15|0]=f;d=1;H[n+20>>2]=(H[e+4>>2]^-1)>>>3&1}}r:{s:{if(!d){break s}d=H[k+20>>2];q=H[d+24>>2];m=gg(H[d+8>>2]);v=I[m|0];t:{u:{if((v|0)==156){if(I[l+34|0]&128){break t}d=G[m+32>>1];o=tC(H[p+228>>2],d);v:{if(!o){break v}if((gb(o)|0)!=3){break v}j=cb(o)}ls(H[p+8>>2],d);break u}if((v|0)!=117){break t}j=H[m+8>>2]}w:{if(!j){break w}e=0;s=I[g+15|0];r=I[g+12|0];i=I[g+13|0];x=I[g+14|0];while(1){d=e;e=d+j|0;f=I[e|0];if(!(!f|(f|0)==(r|0)|((f|0)==(i|0)|(f|0)==(x|0)))){e=d+1|0;if((f|0)!=(s|0)){continue}e=I[e+j|0]?d+2|0:e;continue}break}if((s|0)==I[j|0]&(d|0)<=1|(!d|I[e-1|0]==255)){break w}i=0;H[n+24>>2]=!((f|0)==(r|0)?I[e+1|0]:1);x:{r=sc(l,117,j);if(!r){break x}f=H[r+8>>2];F[f+d|0]=0;e=0;while(1){if((d|0)>(i|0)){i=((s|0)==F[f+i|0])+i|0;F[e+f|0]=I[i+f|0];e=e+1|0;i=i+1|0;continue}break}d=e+f|0;F[d|0]=0;y:{if(I[q|0]!=167){break y}if((Lc(q)|0)!=66){break y}if(I[q+7|0]&3){break x}i=H[q+44>>2];if(!i|I[i+43|0]!=1){break x}}if(!((Yd(f,g,e,1)|0)>0|(e|0)==1&I[f|0]==45)){d=d-1|0;F[d|0]=I[d|0]+1;e=Yd(f,g,e,1);F[d|0]=I[d|0]-1;if((e|0)<=0){break x}}fb(l,r);id(o);break s}H[n+28>>2]=r;if((v|0)!=156){break t}d=H[p+8>>2];ls(d,G[m+32>>1]);if(!H[n+24>>2]|!I[H[m+8>>2]+1|0]){break t}e=Db(p);Ke(p,m,e);fj(d,H[d+108>>2]-1|0,0);xb(p,e);break t}j=0}id(o);d=(j|0)!=0;break r}d=0}Ga=g+16|0;if(!d){break f}g=H[H[k+20>>2]+24>>2];f=H[n+28>>2];h=nb(u,f,0);m=H[n+20>>2];if(I[H[p>>2]+87|0]|!m){break l}d=t+N(c,48)|0;G[d+10>>1]=J[d+10>>1]|1024;e=0;while(1){j=H[f+8>>2]+e|0;d=I[j|0];if(!d){break l}F[j|0]=d&(I[d+30016|0]^-1|223);F[H[h+8>>2]+e|0]=I[d+29632|0];e=e+1|0;continue}}if(I[b+8|0]!=44){break f}d=H[k+20>>2];g=N(c,48);e=0;while(1){if((e|0)==2){break f}h=mb(p,I[e+48710|0],nb(u,H[k+12>>2],0),nb(u,H[(d+(e<<4)|0)+8>>2],0));Jk(h,k);h=se(b,h,3);Mg(a,b,h);f=H[b+24>>2];Lg(b,h,c);e=e+1|0;h=g+f|0;continue}}B=H[b+24>>2];d=B+N(c,48)|0;C=H[d>>2];x=H[b>>2];y=H[x>>2];t=H[y>>2];l=yb(t,424,0);H[d+24>>2]=l;z:{if(!l){break z}G[d+10>>1]=J[d+10>>1]|16;$a(l+32|0,0,384);_r(l,x);ln(l,C,43);Zr(a,l);if(I[t+87|0]){break z}v=x+504|0;i=H[l+24>>2];h=H[l+12>>2];m=-1;g=-1;s=-1;r=-1;while(1){if(!(!(g|m)|(h|0)<=0)){d=J[i+12>>1];A:{if(!(d&511)){d=Tb(t,416,0);if(!d){s=0;r=0;break A}H[i+24>>2]=d;H[i+20>>2]=-1;G[i+12>>1]=1024;G[i+10>>1]=J[i+10>>1]|32;$a(d+32|0,0,384);_r(d,H[b>>2]);ln(d,H[i>>2],44);Zr(a,d);H[d+4>>2]=b;s=0;r=0;e=0;q=0;B:{if(I[t+87|0]){break B}o=0;j=H[d+12>>2];D=(j|0)>0?j:0;j=H[d+24>>2];while(1){if((o|0)==(D|0)){break B}if(!(!gB(I[H[j>>2]])&J[j+12>>1]!=64)){e=Ye(v,H[j+20>>2])|e;q=q|Ja}j=j+48|0;o=o+1|0;continue}}m=e&m;g=g&q;break A}j=J[i+10>>1];if(j&8){break A}e=Ye(v,H[i+20>>2]);q=Ja;if(j&2){e=Ye(v,H[(H[l+24>>2]+N(H[i+16>>2],48)|0)+20>>2])|e;q=q|Ja}d=d&2;s=d?e&s:0;r=d?q&r:0;m=e&m;g=g&q}h=h-1|0;i=i+48|0;continue}break}H[l+416>>2]=m;H[l+420>>2]=g;e=-1;d=B+N(c,48)|0;H[d+20>>2]=-1;G[d+12>>1]=512;C:{if(!(g|m)){break C}F[b+9|0]=1;if(H[l+12>>2]!=2){break C}o=H[l+24>>2];i=0;D:while(1){g=cB(o,i);if(!g){break C}i=i+1|0;j=0;while(1){h=cB(o+48|0,j);if(!h){continue D}E:{if((J[h+10>>1]|J[g+10>>1])&128){break E}d=J[g+12>>1];if(!(d&62)){break E}m=J[h+12>>1];if(!(m&62)){break E}d=d|m;if((d&26)!=(d|0)&(d|0)!=(d&38)){break E}if(mc(0,H[H[g>>2]+12>>2],H[H[h>>2]+12>>2],-1)){break E}if(mc(0,H[H[g>>2]+16>>2],H[H[h>>2]+16>>2],-1)){break E}m=nb(H[H[H[b>>2]>>2]>>2],H[g>>2],0);if(!m){break E}o=d&d-1?d&24?8:32:d;d=53;while(1){h=d;d=d+1|0;if((o|0)!=2<<h-53){continue}break}F[m|0]=h;Mg(a,b,se(b,m,3))}j=j+1|0;o=H[l+24>>2];continue}}}if(!(r|s)){break z}h=0;while(1){if(!(f>>>0>1|h)){o=H[l+12>>2];j=H[l+24>>2];while(1){if((o|0)<=0){break z}o=o-1|0;G[j+10>>1]=J[j+10>>1]&65471;F:{d=H[j+20>>2];if((d|0)!=(e|0)){if(Ye(v,d)&s|r&Ja){break F}}j=j+48|0;continue}break}e=H[j+24>>2];g=H[H[j>>2]+12>>2];h=1;while(1){if(!(!h|(o|0)<0)){G:{H:{if((d|0)!=H[j+20>>2]){G[j+10>>1]=J[j+10>>1]&65471;break H}h=0;if((e|0)!=H[j+24>>2]){break G}if((e|0)==-2){if(mc(y,H[H[j>>2]+12>>2],g,-1)){break G}}m=Lc(H[H[j>>2]+16>>2]);if((Lc(H[H[j>>2]+12>>2])|0)!=(m|0)?m:0){break G}G[j+10>>1]=J[j+10>>1]|64}h=1}j=j+48|0;o=o-1|0;continue}break}f=f+1|0;e=d;continue}break}if(!h){break z}j=H[l+24>>2];o=H[l+12>>2];i=0;e=0;while(1){if((o|0)>0){if(I[j+10|0]&64){d=nb(t,H[H[j>>2]+16>>2],0);i=sb(H[x>>2],i,d);e=H[H[j>>2]+12>>2]}o=o-1|0;j=j+48|0;continue}break}d=mb(y,49,nb(t,e,0),0);if(d){Jk(d,C);H[d+20>>2]=i;d=se(b,d,3);Mg(a,b,d);Lg(b,d,c);break z}qb(t,i)}h=H[b+24>>2]+N(c,48)|0;break f}e=H[k+12>>2];if(I[e|0]!=167|(i&1|G[e+32>>1]<0)){break f}g=se(b,mb(p,54,nb(u,e,0),Ac(u,121,0,0)),131);if(!g){break f}d=H[b+24>>2]+N(g,48)|0;H[d+32>>2]=0;H[d+36>>2]=0;H[d+20>>2]=H[e+28>>2];e=G[e+32>>1];G[d+12>>1]=4;H[d+24>>2]=e;Lg(b,g,c);h=H[b+24>>2]+N(c,48)|0;G[h+10>>1]=J[h+10>>1]|8;e=H[h+44>>2];H[d+40>>2]=H[h+40>>2];H[d+44>>2]=e;break f}if(!I[u+87|0]){d=H[h+8>>2];e=(ib(d)+d|0)-1|0;d=I[e|0];if(m){if((d|0)==64){H[n+24>>2]=0}d=I[d+29632|0]}F[e|0]=d+1}d=m?19573:32112;e=mb(p,57,Yi(p,nb(u,g,0),d),f);Jk(e,k);e=se(b,e,259);Mg(a,b,e);d=mb(p,56,Yi(p,nb(u,g,0),d),h);Jk(d,k);d=se(b,d,259);Mg(a,b,d);h=H[b+24>>2]+N(c,48)|0;if(!H[n+24>>2]){break f}Lg(b,e,c);Lg(b,d,c)}e=I[k|0]}I:{J:{K:{L:{M:{d=e&255;switch(d-49|0){case 1:case 2:case 3:break J;case 0:break K;case 4:break L;default:break M}}if((d|0)!=45){break J}}N:{g=H[k+12>>2];d=Zc(g);if((d|0)<2){break N}f=H[k+16>>2];if((Zc(f)|0)!=(d|0)|(I[f+5|0]&16?I[g+5|0]&16:0)|I[b+8|0]!=44){break N}e=0;while(1){if((d|0)!=(e|0)){h=Cs(p,H[k+12>>2],e,d);g=Cs(p,H[k+16>>2],e,d);h=mb(p,I[k|0],h,g);Jk(h,k);Mg(a,b,se(b,h,32769));e=e+1|0;continue}break}a=H[b+24>>2]+N(c,48)|0;G[a+12>>1]=8192;G[a+10>>1]=J[a+10>>1]|6;break I}if((e&255)!=49){break J}}if(H[h+28>>2]){break J}e=H[k+12>>2];if(!(I[k+5|0]&16)|I[e|0]!=177){break J}d=H[k+20>>2];if(H[d+52>>2]|H[d+68>>2]|I[b+8|0]!=44){break J}h=0;while(1){if((Zc(e)|0)<=(h|0)){break I}d=se(b,k,32770);h=h+1|0;H[(H[b+24>>2]+N(d,48)|0)+28>>2]=h;Mg(a,b,d);Lg(b,d,c);e=H[k+12>>2];continue}}if(I[b+8|0]!=44){break I}H[n+8>>2]=0;H[n+4>>2]=0;h=0;g=Ga-16|0;Ga=g;O:{P:{f=I[k|0];if(f-51>>>0<2){break P}Q:{switch(f-171|0){case 0:break P;case 1:break Q;default:break O}}a=H[k+20>>2];if(!a|H[a>>2]!=2){break O}R:{d=H[a+24>>2];if(I[d|0]!=167){break R}e=H[d+44>>2];if(!e|I[e+43|0]!=1){break R}e=H[k+8>>2];f=0;while(1){if((f|0)==4){break R}if(hb(e,H[(f<<3)+48720>>2])){f=f+1|0;continue}else{F[n+19|0]=I[(f<<3)+48724|0];H[n+8>>2]=H[a+8>>2];H[n+4>>2]=d;h=1;break O}}}d=H[a+8>>2];if(I[d|0]!=167){break O}e=H[d+44>>2];if(!e|I[e+43|0]!=1){break O}e=H[Id(u,e)+8>>2];f=H[H[e>>2]+72>>2];if(!f){break O}e=Ka[f|0](e,2,H[k+8>>2],g+12|0,g+8|0)|0;if((e|0)<150){break O}F[n+19|0]=e;H[n+8>>2]=H[a+24>>2];H[n+4>>2]=d;h=1;break O}e=H[k+16>>2];d=H[k+12>>2];h=0;S:{if(I[d|0]!=167){break S}a=H[d+44>>2];h=0;if(!a){break S}h=I[a+43|0]==1}T:{if(!e){a=d;d=0;break T}U:{if(I[e|0]!=167){break U}a=H[e+44>>2];if(!a|I[a+43|0]!=1){break U}h=h+1|0;a=e;break T}a=d;d=e}H[n+4>>2]=a;H[n+8>>2]=d;if((f|0)==52){F[n+19|0]=68;f=I[k|0]}if((f&255)==171){F[n+19|0]=69;f=I[k|0]}if((f&255)!=51){break O}F[n+19|0]=70}Ga=g+16|0;i=I[n+19|0];d=H[n+4>>2];e=H[n+8>>2];while(1){a=e;e=d;if((h|0)<=0){break I}h=h-1|0;d=a;g=wf(w,d);f=Ja;if(wf(w,e)&g|Ja&f){continue}a=mb(p,46,0,nb(u,d,0));if(!(!(F[k+4|0]&1)|!a)){H[a+4>>2]=H[a+4>>2]|1;H[a+36>>2]=H[k+36>>2]}m=se(b,a,3);j=H[b+24>>2]+N(m,48)|0;a=j;H[a+32>>2]=g;H[a+36>>2]=f;H[a+20>>2]=H[e+28>>2];g=G[e+32>>1];F[a+15|0]=i;G[a+12>>1]=64;H[a+24>>2]=g;Lg(b,m,c);a=H[b+24>>2]+N(c,48)|0;G[a+10>>1]=J[a+10>>1]|8;g=H[a+44>>2];H[j+40>>2]=H[a+40>>2];H[j+44>>2]=g;continue}}a=H[b+24>>2]+N(c,48)|0;b=H[a+32>>2];c=A|H[a+36>>2];H[a+32>>2]=b|z;H[a+36>>2]=c}Ga=n+32|0}function Ue(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=Ga-16|0;Ga=l;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{if(a>>>0<=244){f=H[17698];h=a>>>0<11?16:a+11&-8;c=h>>>3|0;b=f>>>c|0;if(b&3){c=c+((b^-1)&1)|0;a=c<<3;b=a+70832|0;d=H[a+70840>>2];a=H[d+8>>2];l:{if((b|0)==(a|0)){m=70792,n=YK(-2,c)&f,H[m>>2]=n;break l}H[a+12>>2]=b;H[b+8>>2]=a}a=d+8|0;b=c<<3;H[d+4>>2]=b|3;b=b+d|0;H[b+4>>2]=H[b+4>>2]|1;break a}k=H[17700];if(k>>>0>=h>>>0){break k}if(b){a=2<<c;a=(0-a|a)&b<<c;b=(0-a&a)-1|0;a=b>>>12&16;c=a;b=b>>>a|0;a=b>>>5&8;c=c|a;b=b>>>a|0;a=b>>>2&4;c=c|a;b=b>>>a|0;a=b>>>1&2;c=c|a;b=b>>>a|0;a=b>>>1&1;d=(c|a)+(b>>>a|0)|0;a=d<<3;b=a+70832|0;g=H[a+70840>>2];a=H[g+8>>2];m:{if((b|0)==(a|0)){f=YK(-2,d)&f;H[17698]=f;break m}H[a+12>>2]=b;H[b+8>>2]=a}H[g+4>>2]=h|3;c=g+h|0;a=d<<3;d=a-h|0;H[c+4>>2]=d|1;H[a+g>>2]=d;if(k){b=(k&-8)+70832|0;e=H[17703];a=1<<(k>>>3);n:{if(!(a&f)){H[17698]=a|f;a=b;break n}a=H[b+8>>2]}H[b+8>>2]=e;H[a+12>>2]=e;H[e+12>>2]=b;H[e+8>>2]=a}a=g+8|0;H[17703]=c;H[17700]=d;break a}j=H[17699];if(!j){break k}b=(0-j&j)-1|0;a=b>>>12&16;c=a;b=b>>>a|0;a=b>>>5&8;c=c|a;b=b>>>a|0;a=b>>>2&4;c=c|a;b=b>>>a|0;a=b>>>1&2;c=c|a;b=b>>>a|0;a=b>>>1&1;b=H[((c|a)+(b>>>a|0)<<2)+71096>>2];e=(H[b+4>>2]&-8)-h|0;c=b;while(1){o:{a=H[c+16>>2];if(!a){a=H[c+20>>2];if(!a){break o}}c=(H[a+4>>2]&-8)-h|0;d=c>>>0<e>>>0;e=d?c:e;b=d?a:b;c=a;continue}break}i=H[b+24>>2];d=H[b+12>>2];if((d|0)!=(b|0)){a=H[b+8>>2];H[a+12>>2]=d;H[d+8>>2]=a;break b}c=b+20|0;a=H[c>>2];if(!a){a=H[b+16>>2];if(!a){break j}c=b+16|0}while(1){g=c;d=a;c=a+20|0;a=H[c>>2];if(a){continue}c=d+16|0;a=H[d+16>>2];if(a){continue}break}H[g>>2]=0;break b}h=-1;if(a>>>0>4294967231){break k}a=a+11|0;h=a&-8;j=H[17699];if(!j){break k}e=0-h|0;f=0;p:{if(h>>>0<256){break p}f=31;if(h>>>0>16777215){break p}a=a>>>8|0;g=a+1048320>>>16&8;a=a<<g;c=a+520192>>>16&4;a=a<<c;b=a+245760>>>16&2;a=(a<<b>>>15|0)-(b|(c|g))|0;f=(a<<1|h>>>a+21&1)+28|0}c=H[(f<<2)+71096>>2];q:{r:{s:{if(!c){a=0;break s}a=0;b=h<<((f|0)==31?0:25-(f>>>1|0)|0);while(1){t:{g=(H[c+4>>2]&-8)-h|0;if(g>>>0>=e>>>0){break t}d=c;e=g;if(e){break t}e=0;a=c;break r}g=H[c+20>>2];c=H[((b>>>29&4)+c|0)+16>>2];a=g?(g|0)==(c|0)?a:g:a;b=b<<1;if(c){continue}break}}if(!(a|d)){d=0;a=2<<f;a=(0-a|a)&j;if(!a){break k}b=(a&0-a)-1|0;a=b>>>12&16;c=a;b=b>>>a|0;a=b>>>5&8;c=c|a;b=b>>>a|0;a=b>>>2&4;c=c|a;b=b>>>a|0;a=b>>>1&2;c=c|a;b=b>>>a|0;a=b>>>1&1;a=H[((c|a)+(b>>>a|0)<<2)+71096>>2]}if(!a){break q}}while(1){b=(H[a+4>>2]&-8)-h|0;c=b>>>0<e>>>0;e=c?b:e;d=c?a:d;b=H[a+16>>2];if(b){a=b}else{a=H[a+20>>2]}if(a){continue}break}}if(!d|H[17700]-h>>>0<=e>>>0){break k}f=H[d+24>>2];b=H[d+12>>2];if((d|0)!=(b|0)){a=H[d+8>>2];H[a+12>>2]=b;H[b+8>>2]=a;break c}c=d+20|0;a=H[c>>2];if(!a){a=H[d+16>>2];if(!a){break i}c=d+16|0}while(1){g=c;b=a;c=a+20|0;a=H[c>>2];if(a){continue}c=b+16|0;a=H[b+16>>2];if(a){continue}break}H[g>>2]=0;break c}c=H[17700];if(c>>>0>=h>>>0){d=H[17703];b=c-h|0;u:{if(b>>>0>=16){H[17700]=b;a=d+h|0;H[17703]=a;H[a+4>>2]=b|1;H[c+d>>2]=b;H[d+4>>2]=h|3;break u}H[17703]=0;H[17700]=0;H[d+4>>2]=c|3;a=c+d|0;H[a+4>>2]=H[a+4>>2]|1}a=d+8|0;break a}i=H[17701];if(i>>>0>h>>>0){b=i-h|0;H[17701]=b;c=H[17704];a=c+h|0;H[17704]=a;H[a+4>>2]=b|1;H[c+4>>2]=h|3;a=c+8|0;break a}a=0;j=h+47|0;b=j;if(H[17816]){c=H[17818]}else{H[17819]=-1;H[17820]=-1;H[17817]=4096;H[17818]=4096;H[17816]=l+12&-16^1431655768;H[17821]=0;H[17809]=0;c=4096}g=b+c|0;e=0-c|0;c=g&e;if(c>>>0<=h>>>0){break a}d=H[17808];if(d){b=H[17806];f=b+c|0;if(d>>>0<f>>>0|b>>>0>=f>>>0){break a}}if(I[71236]&4){break f}v:{w:{d=H[17704];if(d){a=71240;while(1){b=H[a>>2];if(b>>>0<=d>>>0&d>>>0<b+H[a+4>>2]>>>0){break w}a=H[a+8>>2];if(a){continue}break}}b=ik(0);if((b|0)==-1){break g}f=c;d=H[17817];a=d-1|0;if(a&b){f=(c-b|0)+(a+b&0-d)|0}if(f>>>0<=h>>>0|f>>>0>2147483646){break g}d=H[17808];if(d){a=H[17806];e=a+f|0;if(d>>>0<e>>>0|a>>>0>=e>>>0){break g}}a=ik(f);if((b|0)!=(a|0)){break v}break e}f=e&g-i;if(f>>>0>2147483646){break g}b=ik(f);if((b|0)==(H[a>>2]+H[a+4>>2]|0)){break h}a=b}if(!((a|0)==-1|h+48>>>0<=f>>>0)){b=H[17818];b=b+(j-f|0)&0-b;if(b>>>0>2147483646){b=a;break e}if((ik(b)|0)!=-1){f=b+f|0;b=a;break e}ik(0-f|0);break g}b=a;if((a|0)!=-1){break e}break g}d=0;break b}b=0;break c}if((b|0)!=-1){break e}}H[17809]=H[17809]|4}if(c>>>0>2147483646){break d}b=H[17500];c=c+7&-8;a=b+c|0;x:{y:{if(!c|a>>>0>b>>>0){if(dq()>>>0>=a>>>0){break y}if(aa(a|0)|0){break y}a=H[17500]}else{a=b}H[17665]=48;b=-1;break x}H[17500]=a}if(dq()>>>0<a>>>0){if(!(aa(a|0)|0)){break d}}H[17500]=a;if((b|0)==-1|(a|0)==-1|a>>>0<=b>>>0){break d}f=a-b|0;if(f>>>0<=h+40>>>0){break d}}a=H[17806]+f|0;H[17806]=a;if(a>>>0>K[17807]){H[17807]=a}z:{A:{B:{g=H[17704];if(g){a=71240;while(1){d=H[a>>2];c=H[a+4>>2];if((d+c|0)==(b|0)){break B}a=H[a+8>>2];if(a){continue}break}break A}a=H[17702];if(!(a>>>0<=b>>>0?a:0)){H[17702]=b}a=0;H[17811]=f;H[17810]=b;H[17706]=-1;H[17707]=H[17816];H[17813]=0;while(1){d=a<<3;c=d+70832|0;H[d+70840>>2]=c;H[d+70844>>2]=c;a=a+1|0;if((a|0)!=32){continue}break}d=f-40|0;a=b+8&7?-8-b&7:0;c=d-a|0;H[17701]=c;a=a+b|0;H[17704]=a;H[a+4>>2]=c|1;H[(b+d|0)+4>>2]=40;H[17705]=H[17820];break z}if(I[a+12|0]&8|d>>>0>g>>>0|b>>>0<=g>>>0){break A}H[a+4>>2]=c+f;a=g+8&7?-8-g&7:0;c=a+g|0;H[17704]=c;b=H[17701]+f|0;a=b-a|0;H[17701]=a;H[c+4>>2]=a|1;H[(b+g|0)+4>>2]=40;H[17705]=H[17820];break z}if(K[17702]>b>>>0){H[17702]=b}d=b+f|0;c=71240;C:{while(1){if((d|0)!=H[c>>2]){a=71240;c=H[c+8>>2];if(c){continue}break C}break}a=71240;if(I[c+12|0]&8){break C}H[c>>2]=b;H[c+4>>2]=H[c+4>>2]+f;j=(b+8&7?-8-b&7:0)+b|0;H[j+4>>2]=h|3;d=d+(d+8&7?-8-d&7:0)|0;i=h+j|0;a=d-i|0;D:{if((d|0)==(g|0)){H[17704]=i;a=H[17701]+a|0;H[17701]=a;H[i+4>>2]=a|1;break D}if(H[17703]==(d|0)){H[17703]=i;a=H[17700]+a|0;H[17700]=a;H[i+4>>2]=a|1;H[a+i>>2]=a;break D}e=H[d+4>>2];if((e&3)==1){f=e&-8;E:{if(e>>>0<=255){b=e>>>3|0;e=H[d+8>>2];c=H[d+12>>2];if((c|0)==(e|0)){m=70792,n=H[17698]&YK(-2,b),H[m>>2]=n;break E}H[e+12>>2]=c;H[c+8>>2]=e;break E}h=H[d+24>>2];b=H[d+12>>2];F:{if((d|0)!=(b|0)){c=H[d+8>>2];H[c+12>>2]=b;H[b+8>>2]=c;break F}G:{e=d+20|0;c=H[e>>2];if(c){break G}e=d+16|0;c=H[e>>2];if(c){break G}b=0;break F}while(1){g=e;b=c;e=b+20|0;c=H[e>>2];if(c){continue}e=b+16|0;c=H[b+16>>2];if(c){continue}break}H[g>>2]=0}if(!h){break E}e=H[d+28>>2];c=(e<<2)+71096|0;H:{if(H[c>>2]==(d|0)){H[c>>2]=b;if(b){break H}m=70796,n=H[17699]&YK(-2,e),H[m>>2]=n;break E}H[h+(H[h+16>>2]==(d|0)?16:20)>>2]=b;if(!b){break E}}H[b+24>>2]=h;c=H[d+16>>2];if(c){H[b+16>>2]=c;H[c+24>>2]=b}c=H[d+20>>2];if(!c){break E}H[b+20>>2]=c;H[c+24>>2]=b}d=d+f|0;e=H[d+4>>2];a=a+f|0}H[d+4>>2]=e&-2;H[i+4>>2]=a|1;H[a+i>>2]=a;if(a>>>0<=255){b=(a&-8)+70832|0;c=H[17698];a=1<<(a>>>3);I:{if(!(c&a)){H[17698]=a|c;a=b;break I}a=H[b+8>>2]}H[b+8>>2]=i;H[a+12>>2]=i;H[i+12>>2]=b;H[i+8>>2]=a;break D}e=31;if(a>>>0<=16777215){b=a>>>8|0;e=b+1048320>>>16&8;b=b<<e;d=b+520192>>>16&4;b=b<<d;c=b+245760>>>16&2;b=(b<<c>>>15|0)-(c|(d|e))|0;e=(b<<1|a>>>b+21&1)+28|0}H[i+28>>2]=e;H[i+16>>2]=0;H[i+20>>2]=0;d=(e<<2)+71096|0;J:{c=H[17699];b=1<<e;K:{if(!(c&b)){H[17699]=b|c;H[d>>2]=i;H[i+24>>2]=d;break K}e=a<<((e|0)==31?0:25-(e>>>1|0)|0);b=H[d>>2];while(1){c=b;if((H[b+4>>2]&-8)==(a|0)){break J}b=e>>>29|0;e=e<<1;d=c+(b&4)|0;b=H[d+16>>2];if(b){continue}break}H[d+16>>2]=i;H[i+24>>2]=c}H[i+12>>2]=i;H[i+8>>2]=i;break D}a=H[c+8>>2];H[a+12>>2]=i;H[c+8>>2]=i;H[i+24>>2]=0;H[i+12>>2]=c;H[i+8>>2]=a}a=j+8|0;break a}while(1){L:{c=H[a>>2];if(c>>>0<=g>>>0){e=c+H[a+4>>2]|0;if(e>>>0>g>>>0){break L}}a=H[a+8>>2];continue}break}d=f-40|0;a=b+8&7?-8-b&7:0;c=d-a|0;H[17701]=c;a=a+b|0;H[17704]=a;H[a+4>>2]=c|1;H[(b+d|0)+4>>2]=40;H[17705]=H[17820];a=(e+(e-39&7?39-e&7:0)|0)-47|0;c=a>>>0<g+16>>>0?g:a;H[c+4>>2]=27;a=H[17813];H[c+16>>2]=H[17812];H[c+20>>2]=a;a=H[17811];H[c+8>>2]=H[17810];H[c+12>>2]=a;H[17812]=c+8;H[17811]=f;H[17810]=b;H[17813]=0;a=c+24|0;while(1){H[a+4>>2]=7;b=a+8|0;a=a+4|0;if(b>>>0<e>>>0){continue}break}if((c|0)==(g|0)){break z}H[c+4>>2]=H[c+4>>2]&-2;e=c-g|0;H[g+4>>2]=e|1;H[c>>2]=e;if(e>>>0<=255){b=(e&-8)+70832|0;c=H[17698];a=1<<(e>>>3);M:{if(!(c&a)){H[17698]=a|c;a=b;break M}a=H[b+8>>2]}H[b+8>>2]=g;H[a+12>>2]=g;H[g+12>>2]=b;H[g+8>>2]=a;break z}a=31;if(e>>>0<=16777215){a=e>>>8|0;d=a+1048320>>>16&8;a=a<<d;c=a+520192>>>16&4;a=a<<c;b=a+245760>>>16&2;a=(a<<b>>>15|0)-(b|(c|d))|0;a=(a<<1|e>>>a+21&1)+28|0}H[g+28>>2]=a;H[g+16>>2]=0;H[g+20>>2]=0;b=(a<<2)+71096|0;N:{d=H[17699];c=1<<a;O:{if(!(d&c)){H[17699]=c|d;H[b>>2]=g;break O}a=e<<((a|0)==31?0:25-(a>>>1|0)|0);d=H[b>>2];while(1){b=d;if((e|0)==(H[b+4>>2]&-8)){break N}c=a>>>29|0;a=a<<1;c=(c&4)+b|0;d=H[c+16>>2];if(d){continue}break}H[c+16>>2]=g}H[g+24>>2]=b;H[g+12>>2]=g;H[g+8>>2]=g;break z}a=H[b+8>>2];H[a+12>>2]=g;H[b+8>>2]=g;H[g+24>>2]=0;H[g+12>>2]=b;H[g+8>>2]=a}a=H[17701];if(a>>>0<=h>>>0){break d}b=a-h|0;H[17701]=b;c=H[17704];a=c+h|0;H[17704]=a;H[a+4>>2]=b|1;H[c+4>>2]=h|3;a=c+8|0;break a}a=0;H[17665]=48;break a}P:{if(!f){break P}c=H[d+28>>2];a=(c<<2)+71096|0;Q:{if(H[a>>2]==(d|0)){H[a>>2]=b;if(b){break Q}j=YK(-2,c)&j;H[17699]=j;break P}H[f+(H[f+16>>2]==(d|0)?16:20)>>2]=b;if(!b){break P}}H[b+24>>2]=f;a=H[d+16>>2];if(a){H[b+16>>2]=a;H[a+24>>2]=b}a=H[d+20>>2];if(!a){break P}H[b+20>>2]=a;H[a+24>>2]=b}R:{if(e>>>0<=15){a=e+h|0;H[d+4>>2]=a|3;a=a+d|0;H[a+4>>2]=H[a+4>>2]|1;break R}H[d+4>>2]=h|3;f=d+h|0;H[f+4>>2]=e|1;H[e+f>>2]=e;if(e>>>0<=255){b=(e&-8)+70832|0;c=H[17698];a=1<<(e>>>3);S:{if(!(c&a)){H[17698]=a|c;a=b;break S}a=H[b+8>>2]}H[b+8>>2]=f;H[a+12>>2]=f;H[f+12>>2]=b;H[f+8>>2]=a;break R}a=31;if(e>>>0<=16777215){a=e>>>8|0;g=a+1048320>>>16&8;a=a<<g;c=a+520192>>>16&4;a=a<<c;b=a+245760>>>16&2;a=(a<<b>>>15|0)-(b|(c|g))|0;a=(a<<1|e>>>a+21&1)+28|0}H[f+28>>2]=a;H[f+16>>2]=0;H[f+20>>2]=0;b=(a<<2)+71096|0;T:{c=1<<a;U:{if(!(c&j)){H[17699]=c|j;H[b>>2]=f;break U}a=e<<((a|0)==31?0:25-(a>>>1|0)|0);h=H[b>>2];while(1){b=h;if((H[b+4>>2]&-8)==(e|0)){break T}c=a>>>29|0;a=a<<1;c=(c&4)+b|0;h=H[c+16>>2];if(h){continue}break}H[c+16>>2]=f}H[f+24>>2]=b;H[f+12>>2]=f;H[f+8>>2]=f;break R}a=H[b+8>>2];H[a+12>>2]=f;H[b+8>>2]=f;H[f+24>>2]=0;H[f+12>>2]=b;H[f+8>>2]=a}a=d+8|0;break a}V:{if(!i){break V}c=H[b+28>>2];a=(c<<2)+71096|0;W:{if(H[a>>2]==(b|0)){H[a>>2]=d;if(d){break W}m=70796,n=YK(-2,c)&j,H[m>>2]=n;break V}H[i+(H[i+16>>2]==(b|0)?16:20)>>2]=d;if(!d){break V}}H[d+24>>2]=i;a=H[b+16>>2];if(a){H[d+16>>2]=a;H[a+24>>2]=d}a=H[b+20>>2];if(!a){break V}H[d+20>>2]=a;H[a+24>>2]=d}X:{if(e>>>0<=15){a=e+h|0;H[b+4>>2]=a|3;a=a+b|0;H[a+4>>2]=H[a+4>>2]|1;break X}H[b+4>>2]=h|3;d=b+h|0;H[d+4>>2]=e|1;H[d+e>>2]=e;if(k){c=(k&-8)+70832|0;g=H[17703];a=1<<(k>>>3);Y:{if(!(a&f)){H[17698]=a|f;a=c;break Y}a=H[c+8>>2]}H[c+8>>2]=g;H[a+12>>2]=g;H[g+12>>2]=c;H[g+8>>2]=a}H[17703]=d;H[17700]=e}a=b+8|0}Ga=l+16|0;return a|0}function jo(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0;l=Ga-160|0;Ga=l;H[l+156>>2]=0;H[l+152>>2]=0;z=H[a>>2];a:{if(H[a+36>>2]){r=c;break a}H[l+124>>2]=0;r=0;b:{if(!c){break b}if(!(H[c+52>>2]|!(I[c+5|0]&2))){D=H[c+28>>2];H[c+28>>2]=0;hc(z,c);r=0;break b}r=c}i=Ph(a,b);if(!i){break a}c=H[i>>2];g=H[z+16>>2];x=Lb(z,H[i+60>>2]);if(cc(a,18,c,0,H[g+(x<<4)>>2])){break a}Q=H[i+28>>2];K=hj(a,i,127,0,l+116|0);P=I[i+43|0];if(fg(a,i)){break a}if(Tn(a,i,H[l+116>>2])){break a}m=zb(a);if(!m){break a}if(!I[a+18|0]){Sn(m)}Gd(a,(r|K)!=0,x);c:{if(!(!r|d|K)){p=e;d:{e:{f:{if(H[a+264>>2]|H[r+64>>2]|I[i+43|0]==1){break f}g:{if((p|0)!=11){break g}if(G[i+32>>1]>=0){p=I[i+42|0];if((p|0)!=11){break g}}p=2}c=H[r+32>>2];if(H[c>>2]!=1|H[c+28>>2]|(H[r+36>>2]|H[r+48>>2])){break f}if(H[r+40>>2]|H[r+60>>2]|(H[r+52>>2]|F[r+4|0]&1)){break f}g=H[r+28>>2];if(H[g>>2]!=1|I[H[g+8>>2]]!=180){break f}u=H[a>>2];q=Df(a,0,c+8|0);if(!q|H[q+20>>2]==H[i+20>>2]&H[q+60>>2]==H[i+60>>2]){break f}c=H[q+28>>2];g=H[i+28>>2];if(I[q+43|0]|(c^g)&128){break f}s=J[i+34>>1];if(J[i+32>>1]!=J[q+32>>1]|(c&65536?0:g&65536)|(s|0)!=J[q+34>>1]){break f}while(1){if(s<<16>>16>(k|0)){g=N(k,12);c=g+H[i+4>>2]|0;h=J[c+10>>1]&96;g=g+H[q+4>>2]|0;if((h|0)!=(J[g+10>>1]&96)){break e}if(h){if(mc(0,cd(q,g),cd(i,c),-1)){break f}}if(I[c+5|0]!=I[g+5|0]){break e}if(Qb(Of(c),Of(g))){break e}if(I[g+4|0]&15?0:I[c+4|0]&15){break f}h:{if(!k|I[c+10|0]&96){break h}c=cd(i,c);g=cd(q,g);if(((c|0)!=0|0)==(!g|0)){break f}if(!c){break h}if(ad(H[c+8>>2],H[g+8>>2])){break f}}k=k+1|0;s=J[i+34>>1];continue}break}g=q+8|0;s=0;y=i+8|0;c=y;while(1){h=H[c>>2];if(h){s=I[h+54|0]?1:s;c=g;while(1){c=H[c>>2];if(!c){break f}if(!EA(h,c)){c=c+20|0;continue}break}if(!(H[c+44>>2]!=H[h+44>>2]|H[q+60>>2]!=H[i+60>>2])){if(!uf(411)){break f}}c=h+20|0;continue}break}c=H[i+16>>2];if(c){if(dg(H[q+16>>2],c,-1)){break f}}c=H[u+36>>2];i:{if(H[u+32>>2]&16384){if(H[i+48>>2]){break f}if(!(c&1)){break i}break f}if(c&1){break f}}v=Lb(u,H[q+60>>2]);h=zb(a);Fd(a,v);j=H[a+40>>2];H[a+40>>2]=j+2;c=aD(a,x,i);A=Db(a);Va(h,75,0,A);n=Db(a);t=j+1|0;fe(a,t,x,i,113);if(!(I[u+24|0]&4|!(s|(H[i+8>>2]?G[i+32>>1]<0:0))&p-3>>>0>4294967293)){k=Va(h,35,t,0);E=Sb(h,8);bb(h,k)}j:{if(!(I[q+28|0]&128)){fe(a,j,v,q,112);s=Va(h,35,j,0);k:{if(G[i+32>>1]>=0){k=Va(h,135,j,n);if(!(I[u+24|0]&4)){C=Xa(h,30,t,0,n);Br(a,p,i);bb(h,C)}$C(a,c,n);break k}if(!(H[i+8>>2]|I[u+24|0]&8)){k=Va(h,127,t,n);break k}k=Va(h,135,j,n)}c=169;if(I[u+24|0]&4){db(h,137,t);c=152}Xa(h,129,t,j,n);Xa(h,128,t,A,n);if(!(I[u+24|0]&4)){le(h,-1,i,-5)}pb(h,c);Va(h,38,j,k);Va(h,122,j,0);Va(h,122,t,0);break j}Dd(a,x,H[i+20>>2],1,H[i>>2]);s=0;Dd(a,v,H[q+20>>2],0,H[q>>2])}while(1){c=g;l:{m:{p=H[y>>2];if(p){while(1){n:{k=H[c>>2];if(!k){break n}if(EA(p,k)){break n}c=k+20|0;continue}break}Xa(h,112,j,H[k+44>>2],v);Od(a,k);Xa(h,113,t,H[p+44>>2],x);Od(a,p);pb(h,1);y=Va(h,35,j,0);o:{p:{if(I[u+24|0]&4){C=J[k+52>>1];c=0;while(1){L=(c|0)==(C|0);if(L){break m}if(Qb(32112,H[H[k+32>>2]+(c<<2)>>2])){break p}c=c+1|0;continue}}c=8;if(!(I[q+28|0]&128)){break o}c=((I[p+55|0]|I[p+56|0]<<8)&3)==2?9:8;break o}c=8;if(L){break m}}Xa(h,134,j,A,1);break l}if(s){bb(h,s)}xb(a,n);xb(a,A);c=1;if(!E){break d}Nn(a);Va(h,70,0,0);bb(h,E);Va(h,122,t,0);break f}db(h,137,t);Va(h,129,t,j);c=152}Va(h,138,t,A);pb(h,c);Va(h,38,j,y+1|0);bb(h,y);Va(h,122,j,0);Va(h,122,t,0);y=p+20|0;continue}}c=0;break d}c=0}if(c){break c}}A=aD(a,x,i);c=H[a+44>>2];q=c+1|0;g=q+G[i+34>>1]|0;H[a+44>>2]=g;p=q;if(I[i+43|0]==1){H[a+44>>2]=g+1;p=c+2|0}v=!(J[i+28>>1]&1088);q:{r:{s:{t:{if(!d){c=-1;break t}F[d+4|0]=1;c=H[d>>2];h=(c|0)>0?c:0;while(1)if((h|0)==(o|0)){c=-1;while(1){if((h|0)==(w|0)){break t}o=0;g=G[i+34>>1];j=(g|0)>0?g:0;t=(w<<3)+d|0;g=H[t+8>>2];u:{v:{while(1){if((j|0)==(o|0)){break v}w:{u=N(o,12);if(!hb(g,H[u+H[i+4>>2]>>2])){H[t+12>>2]=o;j=H[i+4>>2];if(!(I[(j+u|0)+10|0]&96)){break w}H[l+64>>2]=H[j+N(o,12)>>2];Za(a,28286,l- -64|0);break s}o=o+1|0;continue}break}if(G[i+34>>1]<=(o|0)){break v}v=(o|0)==(w|0)?v:0;c=G[i+32>>1]==(o|0)?w:c;break u}if($l(g)){v=0;c=w;if(Q<<24>>24>=0){break u}}H[l+52>>2]=g;H[l+48>>2]=b+8;Za(a,6712,l+48|0);F[a+17|0]=1;break s}w=w+1|0;continue}}else{H[((o<<3)+d|0)+12>>2]=-1;o=o+1|0;continue}}t=p+1|0;x:{y:{if(r){g=H[a+44>>2]+1|0;H[a+44>>2]=g;o=0;h=H[m+108>>2];Xa(m,10,g,0,h+1|0);j=l+120|0;Pd(j,13,g);H[l+132>>2]=v&255?t:0;H[l+136>>2]=G[i+34>>1];if(Sc(a,r,j)|H[a+36>>2]){break a}M=H[l+132>>2];oj(m,g);bb(m,h);B=H[H[r+28>>2]>>2];if(K){break y}j=0;u=zb(a);g=H[u+108>>2];if(I[i+43|0]==1){j=Id(H[a>>2],i)}n=(g|0)>1?g:1;h=i+8|0;w=1;while(1){z:{g=0;if((n|0)==(w|0)){break z}A:{o=Nc(u,w);g=I[o|0];B:{if((g|0)!=173){if((g|0)!=112|(x|0)!=H[o+12>>2]){break A}g=h;k=H[o+8>>2];if((k|0)==H[i+20>>2]){break B}while(1){o=H[g>>2];if(!o){break A}g=o+20|0;if((k|0)!=H[o+44>>2]){continue}break}break B}if(H[o+16>>2]!=(j|0)){break A}}g=1;break z}w=w+1|0;continue}break}if(g){break y}s=0;u=1;break x}H[l+108>>2]=0;H[l+100>>2]=0;H[l+104>>2]=0;H[l+92>>2]=0;H[l+96>>2]=0;H[l+84>>2]=0;H[l+88>>2]=0;H[l+80>>2]=a;C:{if(D){B=H[D>>2];if($e(l+80|0,D)){break C}}s=-1;u=1;break x}o=0;r=0;break a}s=H[a+40>>2];H[a+40>>2]=s+1;g=Db(a);h=Db(a);Va(m,118,s,B);o=db(m,11,H[l+124>>2]);Xa(m,97,M,B,g);Va(m,127,s,h);Xa(m,128,s,g,h);Yb(m,o);bb(m,o);xb(a,g);xb(a,h);u=0}D:{if((B|0)<=0|d){break D}g=0;E:{j=H[i+28>>2];c=G[i+32>>1];if(!(j&96)|(c|0)<0){break E}o=c;while(1){if((o|0)<=0){break E}o=o-1|0;c=c-((I[(H[i+4>>2]+N(o,12)|0)+10|0]&96)!=0)|0;continue}}h=G[i+34>>1];F:{if(!(j&98)){break F}j=(h|0)>0?h:0;o=0;while(1){if((j|0)==(o|0)){break F}g=((I[(H[i+4>>2]+N(o,12)|0)+10|0]&98)!=0)+g|0;o=o+1|0;continue}}g=h-g|0;if((g|0)==(B|0)){break D}H[l+40>>2]=B;H[l+36>>2]=g;H[l+32>>2]=b+8;Za(a,15396,l+32|0);break s}G:{if(!d){break G}g=H[d>>2];if((g|0)==(B|0)){break G}H[l+20>>2]=g;H[l+16>>2]=B;Za(a,4872,l+16|0);break s}o=0;w=0;if(!(I[a+18|0]|!(F[z+36|0]&1)|(H[a+120>>2]|I[a+149|0]))){w=H[a+44>>2]+1|0;H[a+44>>2]=w;Va(m,71,0,w)}if((P|0)==2){break q}h=Yk(a,i,113,0,-1,0,l+156|0,l+152|0);o=Tb(z,(h<<2)+8|0,0);if(o){break r}}o=0;break a}g=0;h=(h|0)>0?h:0;k=i+8|0;while(1){if((h|0)!=(g|0)){j=H[k>>2];n=H[a+44>>2]+1|0;H[a+44>>2]=n;H[(g<<2)+o>>2]=n;H[a+44>>2]=H[a+44>>2]+J[j+52>>1];g=g+1|0;k=j+20|0;continue}break}g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[(h<<2)+o>>2]=g}if(f){H:{switch(I[i+43|0]-1|0){case 0:H[l>>2]=H[i>>2];Za(a,28405,l);break a;case 1:Za(a,1794,0);break a;default:break H}}if(cl(a,H[f>>2])){break a}H[b+48>>2]=H[l+156>>2];g=f;while(1){H[g+36>>2]=t;H[g+32>>2]=b;H[g+40>>2]=H[l+156>>2];H[g+44>>2]=H[l+152>>2];if(H[g>>2]){h=g;x=0;n=Ga-192|0;Ga=n;H[n+176>>2]=0;H[n+180>>2]=0;H[n+184>>2]=0;H[n+188>>2]=0;H[n+168>>2]=0;H[n+172>>2]=0;H[n+164>>2]=b;H[n+160>>2]=a;R=n+100|0;I:{while(1){J:{if(!h){break J}j=H[h>>2];if(!j){break J}C=$e(n+160|0,j);if(C){break I}C=1;if(ld(n+160|0,H[h+4>>2])){break I}L=H[b+48>>2];K:{j=H[b+24>>2];E=H[h>>2];L:{if(I[j+28|0]&128|H[E>>2]!=1){break L}k=H[E+8>>2];if(I[k|0]!=167){break L}if(J[k+32>>1]==65535){break K}}$a(n+48|0,0,104);H[n+128>>2]=L;F[n+100|0]=167;H[n+60>>2]=R;F[n+48|0]=113;k=j+8|0;M:{while(1){j=H[k>>2];if(j){N:{if(!I[j+54|0]){break N}O=J[j+50>>1];if((O|0)!=H[E>>2]){break N}k=H[j+36>>2];if(k){v=H[h+4>>2];if(!v){break N}if(mc(a,v,k,L)){break N}O=J[j+50>>1]}v=0;while(1){if((v|0)!=(O|0)){H[n+56>>2]=H[H[j+32>>2]+(v<<2)>>2];k=J[H[j+4>>2]+(v<<1)>>1];O:{if((k|0)==65534){y=H[(H[j+40>>2]+(v<<4)|0)+8>>2];if(I[y|0]==113){break O}H[n+60>>2]=y;y=n+48|0;break O}G[n+132>>1]=k;H[n+60>>2]=R;y=n+48|0}k=0;while(1){if((k|0)==(O|0)){break N}S=k<<4;k=k+1|0;if((mc(a,H[(E+S|0)+8>>2],y,L)|0)>1){continue}break}v=v+1|0;continue}break}H[h+28>>2]=j;break M}k=j+20|0;continue}break}j=H[h+28>>2]}if(j){break K}P:{if(!(H[h+16>>2]|x)){F[n+32|0]=0;break P}H[n+16>>2]=x+1;Vd(16,n+32|0,28773,n+16|0)}H[n>>2]=n+32;Za(a,2489,n);break I}x=x+1|0;h=H[h+16>>2];continue}break}C=0}Ga=n+192|0;if(C){break a}}g=H[g+16>>2];if(g){continue}break}}Q:{if(!u){j=db(m,35,s);n=H[m+108>>2];break Q}if(!r){n=0;j=0;break Q}n=db(m,11,H[l+124>>2]);if((c|0)>=0){Va(m,80,c+M|0,p)}j=n}v=0;h=t;k=0;while(1){if(G[i+34>>1]>(k|0)){R:{if(G[i+32>>1]==(k|0)){db(m,76,h);break R}S:{T:{x=H[i+4>>2]+N(k,12)|0;g=J[x+10>>1];U:{if(g&98){v=v+1|0;if(g&32){h=h-1|0;break R}if(g&64){if(!(F[l+116|0]&1)){break R}db(m,76,h);break R}if(d){break U}Wk(a,cd(i,x),h);break R}if(!d){break T}}g=0;y=H[d>>2];y=(y|0)>0?y:0;while(1){if((g|0)!=(y|0)){if(H[((g<<3)+d|0)+12>>2]==(k|0)){break S}g=g+1|0;continue}break}Wk(a,cd(i,x),h);break R}if(!B){Wk(a,cd(i,x),h);break R}g=k-v|0}if(!u){Xa(m,94,s,g,h);break R}if(r){if((t|0)==(M|0)){break R}Va(m,81,g+M|0,h);break R}oc(a,H[((g<<4)+D|0)+8>>2],h)}h=h+1|0;k=k+1|0;continue}break}k=jb(a);if(F[l+116|0]&1){g=Cc(a,G[i+34>>1]+1|0);V:{if((c|0)<0){Va(m,71,-1,g);break V}W:{if(!u){Xa(m,94,s,c,g);break W}oc(a,H[((c<<4)+D|0)+8>>2],g)}h=db(m,51,g);Va(m,71,-1,g);bb(m,h);db(m,12,g)}h=g+1|0;Xa(m,80,t,h,G[i+36>>1]-1|0);if(I[i+28|0]&96){Xk(a,h,i)}if((P|0)!=2){Vg(m,i,h)}dj(a,K,127,0,1,i,g+(G[i+34>>1]^-1)|0,e,k);md(a,g,G[i+34>>1]+1|0)}X:{if((P|0)==2){break X}if(I[i+43|0]==1){Va(m,75,0,q)}Y:{Z:{if((c|0)>=0){_:{if(!u){Xa(m,94,s,c,p);break _}if(r){break _}g=H[((c<<4)+D|0)+8>>2];if(I[g|0]==121){h=1;if(I[i+43|0]!=1){break Z}}oc(a,g,p)}$:{if(I[i+43|0]!=1){g=db(m,51,p);Xa(m,127,H[l+156>>2],p,A);bb(m,g);break $}Va(m,50,p,H[m+108>>2]+2|0)}db(m,12,p);h=0;break Y}if(!(I[i+43|0]!=1&Q<<24>>24>=0)){h=0;Va(m,75,0,p);break Y}Xa(m,127,H[l+156>>2],p,A);h=1;break Y}Xa(m,127,H[l+156>>2],p,A)}$C(a,A,p);if(I[i+28|0]&96){Xk(a,t,i)}if(I[i+43|0]==1){c=Id(z,i);Hs(a,i);kb(m,7,1,G[i+34>>1]+2|0,q,c,-11);pb(m,((e|0)==11?2:e)&65535);Rc(a);break X}H[l+80>>2]=0;cD(a,i,o,H[l+156>>2],H[l+152>>2],q,0,(c^-1)>>>31|0,e&255,k,l+80|0,0,f);Ln(a,i,0,q,0,0);Ds(a,i,H[l+156>>2],H[l+152>>2],q,o,0,h,!(H[l+80>>2]?H[m+228>>2]:0))}if(w){Va(m,86,w,1)}if(K){dj(a,K,127,0,2,i,(G[i+34>>1]^-1)+p|0,e,k)}lb(m,k);if(!u){Va(m,38,s,n);bb(m,j);db(m,122,s);break c}if(!r){break c}Yb(m,n);bb(m,j)}if(!(I[a+18|0]|H[a+120>>2])){Nn(a)}if(!w){break a}Gs(m,w,14685)}Ic(z,b);qb(z,D);ol(z,f);hc(z,r);Ie(z,d);_a(z,o);Ga=l+160|0}function DK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0;o=Ga-112|0;Ga=o;f=H[a>>2];n=H[f>>2];v=H[b+4>>2];H[b+4>>2]=v|64;t=2;a:{if(I[n+87|0]){break a}t=1;if(v&64){break a}if(J[a+20>>1]){c=H[f+100>>2]+1|0;H[f+100>>2]=c;H[b+16>>2]=c}g=H[b+64>>2];x=H[b+28>>2];y=H[b+32>>2];if(!(!H[f+264>>2]|!(v&2097152))){if(!g){g=yb(n,36,0);H[b+64>>2]=g;t=2;if(!g){break a}}H[g+4>>2]=1}ho(f,g,0);pn(f,y);B=y+8|0;g=B;b:{while(1){if(H[y>>2]>(r|0)){c:{if(H[g+16>>2]){break c}d:{if(!H[g+8>>2]){t=2;if(lc(a,H[g+20>>2])){break a}e=Ga-16|0;Ga=e;c=H[g+20>>2];h=yb(H[f>>2],64,0);H[g+16>>2]=h;if(h){H[h+24>>2]=1;d=H[f>>2];k=H[g+12>>2];e:{if(k){d=Xb(d,k);break e}H[e>>2]=g;d=tb(d,18705,e)}H[h>>2]=d;while(1){d=c;c=H[c+52>>2];if(c){continue}break}rn(f,H[d+28>>2],h+34|0,h+4|0);G[h+38>>1]=200;G[h+32>>1]=65535;H[h+28>>2]=H[h+28>>2]|16896;c=H[f+36>>2]!=0}else{c=7}Ga=e+16|0;if(!c){break d}break a}l=0;k=Ga+-64|0;Ga=k;c=H[f+264>>2];f:{if(H[f+36>>2]|!c|(H[g+4>>2]|I[g+38|0]&2)){break f}e=H[g+8>>2];g:{while(1){h:{if(!c){break h}d=0;h=H[c>>2];i=(h|0)>0?h:0;i:{while(1){if((d|0)==(i|0)){break i}h=N(d,24);d=d+1|0;h=(c+h|0)+12|0;if(hb(e,H[h>>2])){continue}break}H[k+60>>2]=c;break g}if(H[c+4>>2]){break h}c=H[c+8>>2];continue}break}h=0}e=h;if(!e){break f}c=H[e+12>>2];if(c){H[k+48>>2]=H[e>>2];Za(f,c,k+48|0);l=2;break f}c=H[f>>2];l=2;if(VB(f,g)){break f}i=yb(c,64,0);if(!i){break f}d=H[e+16>>2];if(!d){d=yb(c,20,0);H[e+16>>2]=d;j:{if(d){if(we(f,46,d)){break j}}_a(c,i);break f}F[d+18|0]=I[e+20|0]}H[g+16>>2]=i;H[i+24>>2]=1;h=Xb(c,H[e>>2]);G[i+38>>1]=200;G[i+32>>1]=65535;H[i>>2]=h;H[i+28>>2]=H[i+28>>2]|16896;h=ge(c,H[e+8>>2],0);H[g+20>>2]=h;if(I[c+87|0]){break f}H[h+4>>2]=H[h+4>>2]|67108864;c=I[g+37|0]|I[g+38|0]<<8;if(c&2){H[k+32>>2]=H[g+56>>2];Za(f,28534,k+32|0);break f}H[g+60>>2]=d;c=c|256;F[g+37|0]=c;F[g+38|0]=c>>>8;c=H[d>>2];H[d>>2]=c+1;if(!(I[d+18|0]!=1|(c|0)<=0)){F[d+18|0]=0}t=I[h|0]&-2;q=(t|0)!=134;d=h;m=-1;k:{while(1){if(q){d=h;break k}if(I[d|0]!=I[h|0]){break k}s=H[d+32>>2];u=H[s>>2];c=0;l:{while(1){if((c|0)<(u|0)){j=s+(c<<6)|0;m:{if(H[j+12>>2]){break m}p=H[j+16>>2];if(!p){break m}if(hb(p,H[e>>2])){break m}H[j+24>>2]=i;H[i+24>>2]=H[i+24>>2]+1;p=I[j+45|0]|I[j+46|0]<<8|64;F[j+45|0]=p;F[j+46|0]=p>>>8;p=H[d+4>>2];if(p&8192){break l}H[d+4>>2]=p|8192;if((m|0)<0){m=H[f+40>>2];H[f+40>>2]=m+1}H[j+48>>2]=m}c=c+1|0;continue}break}if(!(I[d+5|0]&32)){break k}d=H[d+52>>2];continue}break}H[k>>2]=H[e>>2];Za(f,7878,k);break f}H[e+12>>2]=7987;j=H[f+264>>2];c=H[k+60>>2];H[f+264>>2]=c;n:{o:{if(I[h+5|0]&32){H[d+64>>2]=H[h+64>>2];q=lc(a,d);H[d+64>>2]=0;if(!q){break o}break n}if(lc(a,h)){break n}}H[f+264>>2]=c;c=h;while(1){d=c;c=H[c+52>>2];if(c){continue}break}d=H[d+28>>2];p:{c=H[e+4>>2];if(!c){c=d;break p}if(!d){break p}d=H[d>>2];q=H[c>>2];if((d|0)==(q|0)){break p}c=H[e>>2];H[k+24>>2]=q;H[k+20>>2]=d;H[k+16>>2]=c;Za(f,4859,k+16|0);break n}rn(f,c,i+34|0,i+4|0);if((t|0)==134){H[e+12>>2]=H[h+4>>2]&8192?7143:6934;lc(a,h)}H[e+12>>2]=0;H[f+264>>2]=j;l=1;break f}H[f+264>>2]=j}Ga=k- -64|0;if(l){if((l|0)<=1){break d}break b}c=Df(f,0,g);H[g+16>>2]=c;t=2;if(!c){break a}h=H[c+24>>2];if(h>>>0>=65535){H[o>>2]=H[c>>2];Za(f,22511,o);H[g+16>>2]=0;break a}H[c+24>>2]=h+1;if(I[c+43|0]!=1){if(VB(f,g)){break a}if(!I[c+43|0]){break d}}h=I[a+20|0];if(fg(f,c)){break a}q:{r:{switch(I[c+43|0]-1|0){case 1:if(!(I[n+35|0]&128|H[c+60>>2]==H[H[n+16>>2]+28>>2])){H[o+16>>2]=H[c>>2];Za(f,14751,o+16|0)}Q=g,R=ge(n,H[c+44>>2],0),H[Q+20>>2]=R;break q;case 0:break r;default:break q}}if(!(I[g+37|0]&128)){break q}d=H[c+52>>2];if(!d|I[d+17|0]<=(H[n+32>>2]>>>7&1)>>>0){break q}H[o+32>>2]=H[c>>2];Za(f,28451,o+32|0)}d=J[c+34>>1];G[c+34>>1]=65535;G[a+20>>1]=1;lc(a,H[g+20>>2]);G[a+20>>1]=h;G[c+34>>1]=d}if(!(I[g+37|0]&2)){break c}if(UB(f,g)){break b}}g=g- -64|0;r=r+1|0;continue}break}t=2;if(H[f+36>>2]){break a}i=0;q=0;d=Ga-48|0;Ga=d;h=b;e=H[b+32>>2];c=e+72|0;m=e+8|0;s:{while(1){if((H[e>>2]-1|0)<=(i|0)){break s}t:{u:{if(!H[m+16>>2]){break u}g=H[c+16>>2];if(!g){break u}v:{w:{k=I[c+36|0];if(k&4){if(H[c+44>>2]|I[c+38|0]&4){break w}a=0;j=0;while(1){if(G[g+34>>1]>(j|0)){b=H[g+4>>2]+N(j,12)|0;x:{if(I[b+10|0]&2){break x}l=H[b>>2];if(!fs(e,0,i,l,0,0,1)){break x}b=io(f,a,0);a=0;if(!b){break x}a=Xb(H[f>>2],l);H[b+(H[b>>2]<<3)>>2]=a;a=b}j=j+1|0;continue}break}if(a){H[c+44>>2]=a;a=I[c+37|0]|I[c+38|0]<<8|5120;F[c+37|0]=a;F[c+38|0]=a>>>8}if(H[f+36>>2]){break t}}s=k&32?1:2;k=H[c+44>>2];if(!(I[c+38|0]&4)){break v}p=i+1|0;r=H[f>>2];l=0;while(1){if(H[k>>2]<=(l|0)){break u}y:{b=H[(k+(l<<3)|0)+8>>2];u=vs(g,b);if((u|0)>=0){if(fs(e,0,i,b,d+44|0,d+40|0,(I[c+37|0]|I[c+38|0]<<8)>>>12&1)){break y}}H[d>>2]=b;Za(f,5321,d);break t}a=H[d+40>>2];j=es(r,e,H[d+44>>2],a);Pk((e+(H[d+44>>2]<<6)|0)+8|0,a);a=0;z:{if(!(I[e+44|0]&64)){break z}while(1){A:{if(fs(e,H[d+44>>2]+1|0,i,b,d+44|0,d+40|0,(I[c+37|0]|I[c+38|0]<<8)>>>12&1)){w=e+(H[d+44>>2]<<6)|0;if(I[w+46|0]&4){if((Og(H[w+52>>2],b)|0)>=0){break A}}H[d+16>>2]=b;Za(f,25978,d+16|0)}if(!a){break z}j=Ef(f,sb(f,a,j),48608,0);break z}a=sb(f,a,j);w=H[d+40>>2];j=es(r,e,H[d+44>>2],w);Pk((e+(H[d+44>>2]<<6)|0)+8|0,w);continue}}b=es(r,e,p,u);Pk(c,u);a=mb(f,53,j,b);if(a){H[a+4>>2]=s|H[a+4>>2];H[a+36>>2]=H[b+28>>2]}Q=h,R=he(f,H[h+36>>2],a),H[Q+36>>2]=R;l=l+1|0;continue}}H[d+32>>2]=0;Za(f,12666,d+32|0);break t}if(!k){break u}Xi(k,H[c+40>>2],s);Q=h,R=he(f,H[h+36>>2],H[c+44>>2]),H[Q+36>>2]=R;H[c+44>>2]=0;a=I[c+37|0]|I[c+38|0]<<8|2048;F[c+37|0]=a;F[c+38|0]=a>>>8}m=m- -64|0;c=c- -64|0;i=i+1|0;continue}break}q=1}Ga=d+48|0;if(q){break a}a=H[x>>2];c=(a|0)>0?a:0;g=0;B:{C:{while(1){if((c|0)!=(g|0)){b=H[((g<<4)+x|0)+8>>2];d=I[b|0];D:{if((d|0)!=141){if((d|0)!=180){break D}break C}if(I[H[b+16>>2]]==180){break C}}g=g+1|0;z=H[b+4>>2]|z;continue}break}i=H[h+28>>2];break B}v=v&2048;D=x+8|0;E=H[H[f>>2]+32>>2]&68;i=0;while(1){E:{if((a|0)>(A|0)){a=D+(A<<4)|0;s=H[a>>2];K=H[s+4>>2];j=0;l=0;b=I[s|0];if((b|0)!=180){if(!((b|0)==141&I[H[s+16>>2]]==180)){i=sb(f,i,s);if(i){b=(H[i>>2]<<4)+i|0;H[b-4>>2]=H[a+4>>2];c=(I[b+1|0]|I[b+2|0]<<8)&65532|(I[a+9|0]|I[a+10|0]<<8)&3;F[b+1|0]=c;F[b+2|0]=c>>>8;H[a+4>>2]=0}H[a>>2]=0;break E}l=H[H[s+12>>2]+8>>2]}a=B;c=0;while(1){F:{G:{H:{I:{e=H[y>>2];if((e|0)<=(c|0)){break I}u=H[a+16>>2];r=H[a+12>>2];if(!r){r=H[u>>2]}if(I[n+87|0]){break I}b=a;J:{if(I[a+38|0]&32){p=H[H[b+20>>2]+28>>2];a=0;break J}K:{if(!l){break K}if(!hb(l,r)){break K}c=c+1|0;break F}p=0;d=Lb(n,H[u+60>>2]);a=24097;if((d|0)<0){break J}a=H[H[n+16>>2]+(d<<4)>>2]}d=a;g=0;k=c+1|0;if(!(I[b+102|0]&4)|!v|(e|0)<=(k|0)){break H}q=H[b+108>>2];a=0;while(1){if(H[q>>2]<=(a|0)){break G}e=H[((a<<3)+q|0)+8>>2];i=sb(f,i,sc(n,59,e));if(i){m=H[i>>2];H[o+80>>2]=e;e=(m<<4)+i|0;Q=e-4|0,R=tb(n,5990,o+80|0),H[Q>>2]=R;m=(I[e+1|0]|I[e+2|0]<<8)&65404|130;F[e+1|0]=m;F[e+2|0]=m>>>8}a=a+1|0;continue}}if(j){break E}if(l){H[o+96>>2]=l;Za(f,7860,o+96|0);break E}Za(f,15560,0);break E}q=0}L=(l|0)!=0&(p|0)!=0;M=c^-1;O=!v&(!l&(c|0)!=0);while(1){L:{if(G[u+34>>1]<=(g|0)){break L}C=N(g,12);a=C+H[u+4>>2]|0;m=H[a>>2];M:{if(L){if(!$B(((g<<4)+p|0)+8|0,0,l,0)){break M}}a=J[a+10>>1];if(!(a&2?I[h+6|0]&2:1)|!(v?1:!(a&1024)|l)){break M}if(!(!O|!(I[b+38|0]&4))){j=1;if((Og(H[b+44>>2],m)|0)>=0){break M}}a=sc(n,59,m);e=H[y>>2];N:{O:{if((e|0)>=2){if(v|!(I[b+36|0]&64)){break O}c=b;j=e+M|0;w=0;P:{while(1){if((j|0)<=0){break P}e=c;c=c- -64|0;j=j-1|0;if(!(I[e+102|0]&4)){continue}e=H[e+108>>2];if(!e){continue}if((Og(e,m)|0)<0){continue}break}w=1}if(!w){break O}}if(I[f+208|0]<2){break N}}c=sc(n,59,r);a=mb(f,141,c,a);Q:{if(I[f+208|0]<2){break Q}e=H[s+12>>2];if(!e){break Q}od(f,c,e)}if(!d){break N}a=mb(f,141,sc(n,59,d),a)}i=sb(f,i,a);if(!i){j=1;i=0;break L}a=H[i>>2]-1|0;R:{if(!(!v|I[f+208|0]>1)){a=(a<<4)+i|0;S:{if(p){c=Xb(n,H[((g<<4)+p|0)+12>>2]);break S}H[o+72>>2]=m;H[o+68>>2]=r;H[o+64>>2]=d;c=tb(n,5833,o- -64|0)}H[a+12>>2]=c;c=(I[a+17|0]|I[a+18|0]<<8)&-4;e=c|2;F[a+17|0]=e;F[a+18|0]=e>>>8;T:{if(I[b+38|0]&4){if((Og(H[b+44>>2],m)|0)>=0){break T}}if(q){if((Og(q,m)|0)>=0){break T}}j=1;if(!(I[(H[u+4>>2]+C|0)+11|0]&4)){break M}}c=c|258;F[a+17|0]=c;F[a+18|0]=c>>>8;break R}if(!P&(E|0)==4){H[o+52>>2]=m;H[o+48>>2]=r;a=(a<<4)+i|0;Q=a,R=tb(n,5984,o+48|0),H[Q+12>>2]=R;c=(I[a+17|0]|I[a+18|0]<<8)&65532;F[a+17|0]=c;F[a+18|0]=c>>>8;break R}a=(a<<4)+i|0;Q=a,R=Xb(n,m),H[Q+12>>2]=R;c=(I[a+17|0]|I[a+18|0]<<8)&65532;F[a+17|0]=c;F[a+18|0]=c>>>8}j=1}g=g+1|0;continue}break}c=k}a=b- -64|0;continue}}qb(n,x);H[h+28>>2]=i;break B}z=z|K;A=A+1|0;a=H[x>>2];continue}}U:{if(!i){break U}if(H[i>>2]>H[n+128>>2]){Za(f,3056,0);break a}if(!(z&4194312)){break U}H[h+4>>2]=H[h+4>>2]|262144}t=0;break a}t=2}Ga=o+112|0;return t|0}function Ke(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;i=Ga-128|0;Ga=i;g=H[a+8>>2];H[i+124>>2]=0;H[i+120>>2]=0;a:{b:{c:{d:{e:{f:{g:{h:{while(1){i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{if(!b){break J}K:{f=I[b|0];switch(f-102|0){case 72:case 79:break j;case 11:break k;case 76:break n;case 36:break o;case 70:break p;case 66:break q;case 73:break s;case 12:break t;case 71:break u;case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:break v;case 69:break y;case 74:break A;case 54:break B;case 52:break C;case 15:break D;case 51:break E;case 68:break F;case 53:break G;case 65:break H;case 67:break I;case 10:case 13:case 14:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:case 32:case 33:case 34:case 35:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:case 50:case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 78:break J;case 55:break f;case 77:break g;case 75:break h;default:break K}}L:{switch(f-19|0){case 29:break l;case 30:break m;case 1:break o;case 31:case 32:break r;case 0:break t;case 24:case 25:break v;case 33:case 34:case 35:case 36:case 37:case 38:break x;case 26:break y;case 17:break z;case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 18:case 19:case 20:case 21:case 22:case 23:case 27:case 28:break J;default:break L}}if((f|0)==71){break e}if((f|0)==77){break i}}Va(g,75,0,c);break b}d=H[b+40>>2];f=H[d+28>>2];e=G[b+34>>1];h=f+N(e,20)|0;if(!I[d|0]){d=H[h+12>>2];break a}if(!I[d+1|0]){break H}a=H[h>>2];b=f+N(e,20)|0;Xa(g,94,H[d+8>>2],G[b+18>>1],c);b=G[b+16>>1];if((b|0)<0|I[(H[a+4>>2]+N(b&65535,12)|0)+5|0]!=69){break b}db(g,87,c);break b}if(I[b+4|0]&32){d=Ke(a,H[b+12>>2],c);a=H[b+44>>2];M:{if(a){a=Uk(a,G[b+32>>1]);break M}a=I[b+1|0]}if(a<<24>>24<66){break a}kb(g,96,d,1,0,((a&255)<<1)+48220|0,-1);break a}f=H[b+28>>2];if((f|0)<0){d=H[a+52>>2];if((d|0)<0){h=J[b+32>>1];f=h<<16>>16;if((f|0)<0){d=d^-1;break a}e=H[b+44>>2];d=Oc(e,f)-d|0;b=H[e+4>>2]+N(h,12)|0;h=J[b+10>>1];if(h&96){if(h&256){H[i>>2]=H[b>>2];Za(a,28256,i);d=0;break a}c=h|256;G[b+10>>1]=c;if(h&128){us(a,e,b,d);c=J[b+10>>1]}G[b+10>>1]=c&65151;break a}if(I[b+5|0]!=69){break a}Va(g,81,d,c);db(g,87,c);break b}f=d-1|0}d=I[b+2|0];Qc(H[a+8>>2],H[b+44>>2],f,G[b+32>>1],c);N:{if(!d){break N}a=Nc(H[a+8>>2],-1);if(I[a|0]!=94){break N}G[a+2>>1]=d}d=c;if(H[b+44>>2]|I[b+1|0]!=69){break a}db(g,87,d);break a}GC(a,b,0,c);break b}Va(g,71,Tk(b),c);break b}ts(g,H[b+8>>2],0,c);break b}Bd(g,c,H[b+8>>2]);break b}a=H[b+8>>2]+2|0;b=ib(a)-1|0;kb(g,77,(b|0)/2|0,c,0,Gt(H[g>>2],a,b),-6);break b}Va(g,78,G[b+32>>1],c);if(!I[H[b+8>>2]+1|0]){break b}a=H[a+224>>2];b=vx(a,G[b+32>>1]);H[a>>2]=0;Pc(g,b,-1);break b}d=H[b+28>>2];break a}a=Ke(a,H[b+12>>2],c);if((a|0)!=(c|0)){Va(g,81,a,c)}Va(g,88,c,nl(H[b+8>>2],0));break b}f=(f|0)==45?53:52;h=1;d=128;break w}d=0}e=H[b+12>>2];if(Ze(e)){h=Ga-16|0;Ga=h;l=H[b+16>>2];e=H[a+8>>2];n=H[b+12>>2];k=Zc(n);g=jb(a);O:{if(H[a+36>>2]){break O}b=H[b+4>>2];if((Zc(l)|0)!=(k|0)){Za(a,14826,0);break O}r=b>>>10&1;s=CC(a,n);t=CC(a,l);Va(e,71,1,c);b=(f|0)==52?53:(f|0)==57?54:(f|0)==55?56:f;u=k-2|0;k=k-1|0;v=(d|0)!=128;while(1){H[h+12>>2]=0;H[h+8>>2]=0;H[h+4>>2]=0;H[h>>2]=0;if(m){bb(e,m)}o=BC(a,n,j,s,h+4|0,h+12|0);p=BC(a,l,j,t,h,h+8|0);m=H[e+108>>2];q=b&255;Cn(a,H[h+4>>2],H[h>>2],q,o,p,g,d,r);xb(a,H[h+12>>2]);xb(a,H[h+8>>2]);P:{Q:{switch(q-54|0){case 0:case 2:break Q;default:break P}}if((j|0)>=(k|0)){break P}m=Sb(e,58)}R:{if(!v){Va(e,71,0,c);break R}Xa(e,92,o,c,p)}if((j|0)!=(k|0)){S:{if((q|0)==53){Va(e,51,c,g);b=53;break S}Va(e,8,0,g);b=(j|0)==(u|0)?f:b}j=j+1|0;continue}break}bb(e,m);lb(e,g);if((f|0)!=52){break O}Va(e,19,c,c)}Ga=h+16|0;break d}j=Mc(a,e,i+124|0);m=Mc(a,H[b+16>>2],i+120|0);Va(g,71,1,c);Cn(a,e,H[b+16>>2],f,j,m,H[g+108>>2]+2|0,d,H[b+4>>2]>>>10&1);if(h){Va(g,71,0,c);break d}Xa(g,92,j,c,m);break d}d=Mc(a,H[b+12>>2],i+124|0);Xa(g,f,Mc(a,H[b+16>>2],i+120|0),d,c);break d}T:{U:{V:{d=H[b+12>>2];switch(I[d|0]-153|0){case 0:break U;case 2:break V;default:break T}}GC(a,d,1,c);break b}ts(g,H[d+8>>2],1,c);break b}H[i+68>>2]=67584;H[i+72>>2]=0;F[i+64|0]=155;d=Mc(a,i- -64|0,i+124|0);Xa(g,107,Mc(a,H[b+12>>2],i+120|0),d,c);break d}Va(g,f,Mc(a,H[b+12>>2],i+124|0),c);break d}e=Mc(a,H[b+12>>2],i+124|0);d=Tk(H[b+16>>2]);ob(g,91,e,c,!d,d^I[b+2|0]==45);break d}Va(g,71,1,c);b=db(g,f,Mc(a,H[b+12>>2],i+124|0));Va(g,71,0,c);bb(g,b);break d}W:{d=H[b+40>>2];X:{if(!d){break X}h=G[b+34>>1];if((h|0)<0){break X}if((h|0)<H[d+44>>2]){break W}}H[i+16>>2]=b;Za(a,25951,i+16|0);break d}d=H[(H[d+40>>2]+N(h,20)|0)+8>>2];break a}if(F[b+7|0]&1){d=H[H[b+44>>2]+56>>2];break a}n=H[a>>2];d=I[n+84|0];Y:{if(!I[a+23|0]){break Y}if(!Bn(b)){break Y}d=An(a,b,-1);break a}e=H[b+20>>2];if(e){j=H[e>>2]}d=hf(n,H[b+8>>2],j,d,0);if(!(!d|H[d+20>>2])){f=H[d+4>>2];if(f&4194304){g=Ga+-64|0;Ga=g;b=H[a+8>>2];Z:{_:{switch(H[d+8>>2]){case 0:d=H[e>>2];f=jb(a);oc(a,H[e+8>>2],c);d=(d|0)>1?d:1;h=1;while(1){if((d|0)!=(h|0)){Va(b,51,c,f);oc(a,H[(e+(h<<4)|0)+8>>2],c);h=h+1|0;continue}break};DC(b);lb(b,f);break Z;case 5:b=g+8|0;$a(b,0,52);H[g+28>>2]=e;F[g+8|0]=157;c=Ke(a,b,c);break Z;default:c=Ke(a,H[e+8>>2],c);break Z;case 3:Va(b,71,mc(0,H[e+8>>2],H[e+24>>2],-1),c);break Z;case 2:Va(b,71,yn(a,H[e+8>>2],H[e+24>>2],-1),c);break Z;case 1:a=H[e+24>>2];if(I[a|0]==167){Va(b,71,Zn(H[e+8>>2],H[a+28>>2]),c);break Z}Va(b,75,0,c);break Z;case 4:break _}}a=Lc(H[e+8>>2]);if((a|0)>=65){a=H[((a&255)<<2)+48108>>2]}else{a=13084}Bd(b,c,a)}Ga=g- -64|0;d=c;break a}if(f&2621440){FC(a,b,d)}l=(j|0)>0?j:0;f=0;while(1){if((f|0)!=(l|0)){$:{if(f>>>0>31){break $}if(!Me(H[(e+(f<<4)|0)+8>>2])){break $}m=1<<f|m}if(!(!(I[d+4|0]&32)|h)){h=Sd(a,H[(e+(f<<4)|0)+8>>2])}f=f+1|0;continue}break}aa:{if(!e){f=0;break aa}ba:{if(m){f=H[a+44>>2];H[a+44>>2]=f+j;f=f+1|0;break ba}f=Cc(a,j)}l=H[d+4>>2]&192;ca:{if(!l){break ca}da:{k=H[e+8>>2];switch(I[k|0]-167|0){case 0:case 2:break da;default:break ca}}F[k+2|0]=l}Nh(a,e,f,0,3)}ea:{fa:{ga:{if((j|0)>=2){if(!(F[b+5|0]&1)){break ga}e=e+24|0;break fa}if((j|0)!=1){break ea}}e=e+8|0}e=H[e>>2];l=Ga-16|0;Ga=l;H[l+12>>2]=0;H[l+8>>2]=0;ha:{ia:{if(!e|I[e|0]!=167){break ia}e=H[e+44>>2];if(!e|I[e+43|0]!=1){break ia}e=H[Id(n,e)+8>>2];k=H[H[e>>2]+72>>2];if(!k){break ia}if(!(Ka[k|0](e,j,H[d+32>>2],l+12|0,l+8|0)|0)){break ia}e=yb(n,ib(H[d+32>>2])+41|0,0);if(!e){break ia}k=Ya(e,d,40);o=k+40|0;H[k+32>>2]=o;d=H[d+32>>2];Ya(o,d,ib(d)+1|0);H[k+16>>2]=H[l+12>>2];H[k+8>>2]=H[l+8>>2];H[k+4>>2]=H[k+4>>2]|16;break ha}e=d}Ga=l+16|0;d=e}if(I[d+4|0]&32){if(!h){h=H[n+8>>2]}kb(g,85,0,0,0,h,-2)}Sk(a,m,f,c,j,d,I[b+2|0]);if(!j|m){break b}md(a,f,j);break b}H[i+32>>2]=b;Za(a,25927,i+32|0);break d}d=0;if(I[H[a>>2]+87|0]){break a}ja:{if(!(!(I[b+5|0]&16)|(f|0)!=138)){d=H[H[H[b+20>>2]+28>>2]>>2];if((d|0)!=1){break ja}}d=Rk(a,b);break a}ss(a,d,1);break d}d=H[b+12>>2];c=H[d+28>>2];if(!(I[a+26|0]<=I[d+2|0]?c:0)){c=Rk(a,d);H[d+28>>2]=c;F[d+2|0]=I[a+26|0]}h=H[b+28>>2];e=Zc(d);if((h|0)!=(e|0)){H[i+52>>2]=e;H[i+48>>2]=h;Za(a,5002,i+48|0);c=H[d+28>>2]}d=c+G[b+32>>1]|0;break a}d=jb(a);h=jb(a);Va(g,75,0,c);zn(a,b,d,h);Va(g,71,1,c);lb(g,d);Va(g,86,c,0);lb(g,h);break b}rs(a,b,c,0,0);break b}if(I[b+5|0]&2){break j}d=H[b+12>>2];if(!d|I[d|0]!=172){break j}a=Ke(a,d,c);if((a|0)!=(c|0)){Va(g,81,a,c)}db(g,179,c);break b}b=H[b+12>>2];continue}break}d=H[b+44>>2];h=G[b+32>>1];Va(g,157,(Oc(d,h)+N(H[b+28>>2],G[d+34>>1]+1|0)|0)+1|0,c);if(I[(H[d+4>>2]+N(h&65535,12)|0)+5|0]!=69|(h|0)<0){break d}db(g,87,c);break d}Za(a,14826,0);break d}e=I[a+23|0];h=db(g,18,H[b+28>>2]);F[a+23|0]=0;d=Ke(a,H[b+12>>2],c);F[a+23|0]=e;bb(g,h);fj(g,h,d);break c}d=H[a>>2];e=H[b+20>>2];j=H[e>>2];l=jb(a);f=0;k=H[b+12>>2];if(k){m=nb(d,k,0);if(I[d+87|0]){fb(d,m);break d}EC(m,qs(a,m,i+124|0));h=i- -64|0;$a(h,0,52);H[i+76>>2]=m;F[i+64|0]=53;H[i+124>>2]=0}n=e+8|0;o=j-1|0;while(1){if((f|0)<(o|0)){p=f<<4;b=H[p+n>>2];ka:{if(!k){h=b;break ka}H[i+80>>2]=b}b=jb(a);zc(a,h,b,16);oc(a,H[n+(p|16)>>2],c);Yb(g,l);lb(g,b);f=f+2|0;continue}break}la:{if(j&1){oc(a,H[(e+(o<<4)|0)+8>>2],c);break la}Va(g,75,0,c)}fb(d,m);DC(g);lb(g,l);break d}if(!(H[a+120>>2]|I[a+18|0])){d=0;Za(a,10894,0);break a}f=I[b+1|0];if((f|0)==2){Rc(a);f=I[b+1|0]}if((f&255)==4){kb(g,70,0,4,0,H[b+8>>2],0);break d}_i(a,H[a+120>>2]?1811:1,f<<24>>24,H[b+8>>2],0,0)}d=c}xb(a,H[i+124>>2]);xb(a,H[i+120>>2]);break a}d=c}Ga=i+128|0;return d}function ko(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;o=Ga-80|0;Ga=o;H[o+72>>2]=0;H[o+76>>2]=0;K=H[a>>2];a:{if(H[a+36>>2]){break a}j=Ph(a,b);if(!j){break a}q=Lb(H[a>>2],H[j+60>>2]);L=hj(a,j,129,c,o+36|0);v=H[b>>2]>=2?H[c>>2]:v;M=I[j+43|0];if(fg(a,j)){break a}if(Tn(a,j,H[o+36>>2])){break a}w=H[a+40>>2];A=w+1|0;H[a+40>>2]=A;if(I[j+28|0]&128){x=tc(j)}h=A;n=w;B=j+8|0;g=B;while(1){g=H[g>>2];if(g){l=h+1|0;H[a+40>>2]=l;n=(g|0)==(x|0)?h:n;O=O+1|0;g=g+20|0;h=l;continue}break}if(f){A=H[f+44>>2];n=H[f+40>>2];H[a+40>>2]=w}H[b+48>>2]=n;s=Tb(K,((G[j+34>>1]+O<<2)+O|0)+6|0,0);if(!s){s=0;break a}h=0;Q=(G[j+34>>1]<<2)+s|0;t=O+1|0;R=$a((Q+(O<<2)|0)+4|0,1,t);F[R+t|0]=0;g=G[j+34>>1];g=(g|0)>0?g:0;while(1){if((h|0)!=(g|0)){H[(h<<2)+s>>2]=-1;h=h+1|0;continue}break}H[o+60>>2]=0;H[o+64>>2]=0;H[o+68>>2]=0;H[o+52>>2]=0;H[o+56>>2]=0;H[o+48>>2]=f;H[o+44>>2]=b;H[o+40>>2]=a;H[o+64>>2]=512;k=zb(a);if(!k){break a}u=-1;while(1){b:{c:{if(H[c>>2]>(i|0)){g=(i<<4)+c|0;p=Ug(H[g+12>>2]);if(!v){if(ld(o+40|0,H[g+8>>2])){break a}}h=0;l=G[j+34>>1];r=(l|0)>0?l:0;while(1){if((h|0)!=(r|0)){d:{l=H[j+4>>2]+N(h,12)|0;if((p|0)!=I[l+7|0]){break d}m=H[l>>2];if(hb(m,H[g+12>>2])){break d}if(G[j+32>>1]==(h|0)){S=H[g+8>>2];z=1;u=i;break c}g=J[l+10>>1];if(!(!x|!(g&1))){X=1;break c}if(!(g&96)){break c}H[o+16>>2]=m;Za(a,28358,o+16|0);break a}h=h+1|0;continue}break}h=H[g+12>>2];e:{if(x){break e}if(!$l(h)){break e}S=H[g+8>>2];m=19671;z=1;h=-1;u=i;break b}H[o>>2]=h;Za(a,7362,o);F[a+17|0]=1;break a}U=z+X|0;f:{if(!(I[j+28|0]&96)){break f}g=0;h=0;while(1){i=g;g:{h:{if(G[j+34>>1]>(h|0)){l=(h<<2)+s|0;if(H[l>>2]>=0){break h}m=H[j+4>>2]+N(h,12)|0;if(!(I[m+10|0]&96)){break h}if(!Mn(cd(j,m),s,z)){break g}H[l>>2]=99999;i=1;break g}g=0;h=0;if(i){continue}break f}}g=i;h=h+1|0;continue}}g=I[j+43|0]==1;H[b+56>>2]=g?-1:0;H[b+60>>2]=g?-1:0;l=0;V=U&255;E=gj(a,j,s,V);p=(V|0)!=0|(E|0)>1;i=(e|0)==5;r=(e|0)!=11;while(1){i:{j:{k:{l:{m:{n:{o:{m=H[B>>2];if(m){if(p|(m|0)==(x|0)){break o}g=H[m+36>>2];if(g){g=Mn(g,s,z)}else{g=0}if(g){break o}h=0;while(1){if(J[m+50>>1]<=h>>>0){break j}g=G[H[m+4>>2]+(h<<1)>>1];p:{if((g|0)>=0){g=(H[((g&65535)<<2)+s>>2]^-1)>>>31|0;break p}g=Mn(H[(H[m+40>>2]+(h<<4)|0)+8>>2],s,z)}h=h+1|0;if(!g){continue}break}h=H[a+44>>2]+1|0;H[a+44>>2]=h+J[m+52>>1];if(r){break k}i=I[m+54|0]==5?1:i;break k}H[o+24>>2]=i;g=H[a+44>>2]+1|0;H[a+44>>2]=g;Y=(l<<2)+Q|0;H[Y>>2]=g;if(i){$a(R,1,t)}if(!I[a+18|0]){Sn(k)}l=0;_=E|L;Gd(a,(_|0)!=0,q);m=0;h=0;if(I[j+43|0]!=1){g=H[a+44>>2];l=g+1|0;q:{if(!(L|X|E)){m=G[j+34>>1];t=l;break q}$=g+2|0;m=G[j+34>>1];t=l+m|0}g=t;h=H[Y>>2];B=m;m=g+1|0;g=U&255|L|E;q=g?m:t;H[a+44>>2]=B+q;P=g?m:l;m=q+1|0}r:{s:{if((M|0)!=2){B=0;if(!v){break s}break r}Ms(a,o+72|0,H[j>>2]);B=0;if(v){break r}Ks(a,j,d,n)}if(ld(o+40|0,d)){break a}B=1}if(I[j+43|0]==1){f=S;p=Ga-16|0;Ga=p;g=H[a+8>>2];n=H[a>>2];w=Id(n,j);l=H[b+48>>2];i=G[j+34>>1];h=H[a+40>>2];H[a+40>>2]=h+1;q=i+2|0;u=Va(g,118,h,q);m=H[a+44>>2];v=m+q|0;H[a+44>>2]=v;t=m+1|0;t:{u:{v:{w:{x:{if(H[b>>2]>=2){y:{if(!(I[j+28|0]&128)){if(f){m=0;f=nb(n,f,0);break y}m=0;f=mb(a,75,0,0);break y}m=tc(j);f=G[H[m+4>>2]>>1];i=H[(f<<2)+s>>2];if((i|0)>=0){f=nb(n,H[((i<<4)+c|0)+8>>2],0);break y}f=$m(a,f)}f=sb(a,0,f);i=0;while(1){if(G[j+34>>1]<=(i|0)){break x}l=H[(i<<2)+s>>2];z:{if((l|0)>=0){l=nb(n,H[((l<<4)+c|0)+8>>2],0);break z}l=$m(a,i)}i=i+1|0;f=sb(a,f,l);continue}}A=v+2|0;H[a+44>>2]=A;z=Af(a,b,d,0,0,0,4,0);if(!z){break t}n=m+3|0;i=0;while(1){if(G[j+34>>1]>(i|0)){D=H[(i<<2)+s>>2];A:{if((D|0)>=0){oc(a,H[((D<<4)+c|0)+8>>2],i+n|0);break A}Xa(g,175,l,i,i+n|0);pb(g,1)}i=i+1|0;continue}break}B:{if(!(I[j+28|0]&128)){Va(g,135,l,t);i=m+2|0;if(f){oc(a,f,i);break B}Va(g,135,l,i);break B}f=G[H[tc(j)+4>>2]>>1];Xa(g,175,l,f,t);Va(g,81,f+n|0,m+2|0)}if(Rn(z,p+8|0)){break v}ag(a);f=v+1|0;Xa(g,97,t,q,f);Va(g,127,h,A);Xa(g,128,h,f,A);break w}eD(a,h,m,f,b,d);qb(n,f);z=0}if(H[b>>2]==1){Ed(z)}i=0;f=(q|0)>0?q:0;u=db(g,35,h);while(1)if((f|0)==(i|0)){f=1;break u}else{Xa(g,94,h,i,i+t|0);i=i+1|0;continue}}ue(g,u);db(g,122,l);f=0}Hs(a,j);kb(g,7,0,q,t,w,-11);pb(g,((e|0)==11?2:e)&65535);Rc(a);if(f){Va(g,38,h,u+1|0);bb(g,u);Va(g,122,h,0);break t}Ed(z)}Ga=p+16|0;break a}t=jb(a);if(!(H[a+120>>2]|!(F[K+36|0]&1)|(I[a+149|0]|(I[a+18|0]|f)))){T=H[a+44>>2]+1|0;H[a+44>>2]=T;Va(k,71,0,T)}C:{D:{E:{F:{G:{H:{I:{if(!(!B|I[j+28|0]&128)){g=0;Xa(k,75,0,h,l);y=H[a+40>>2];H[a+40>>2]=y+1;C=Xa(k,118,y,0,h);q=0;break I}g=H[a+44>>2];D=x?G[x+50>>1]:0;r=D<<16>>16;p=g+r|0;q=(p+v|0)+1|0;H[a+44>>2]=q;g=g+1|0;if(f){break H}C=r+v|0;r=0;r=(M|0)==2?G[j+34>>1]:r;y=H[a+40>>2];H[a+40>>2]=y+1;if(x){Xa(k,75,0,g,p)}r=r+C|0;C=Va(k,118,y,r);J:{if(!x){break J}p=_k(a,x);if(!p){break J}G[p+8>>1]=r;Pc(k,p,-8)}if(B){break I}eD(a,y,x,c,b,d);n=(M|0)==2?y:n}if(!v){break F}r=D<<16>>16;break G}if(!v){break E}}ag(a);p=0;v=1;Z=1;q=g;break l}if(!f){break D}}zc(a,d,t,16);p=1;break C}W=Af(a,b,d,0,0,0,I[a+18|0]?4:_?4:U&255?4:i?4:12,A);if(!W){break a}p=1;i=Rn(W,o+28|0);Z=Qn(W);if((i|0)==1){break C}ag(a);p=2;if((i|0)!=2){p=i;break C}i=H[o+32>>2];if((i|0)<0|(i|0)==(n|0)){break C}p=!I[(i-w|0)+R|0]<<1}K:{L:{if(I[j+28|0]&128){h=0;r=D<<16>>16;i=(r|0)>0?r:0;while(1){if((h|0)==(i|0)){break L}Qc(k,j,n,G[H[x+4>>2]+(h<<1)>>1],h+g|0);h=h+1|0;continue}}Va(k,135,n,l);if(!p){i=H[a+44>>2]+1|0;H[a+44>>2]=i;H[Y>>2]=i;Xa(k,128,y,h,l);break K}if(!C){break m}ue(k,C);break m}if(p){v=0;if(!C){break n}ue(k,C);break n}kb(k,97,g,r,q,ej(K,x),r);ob(k,138,y,q,g,r)}p=0;break m}h=H[a+44>>2]+1|0;H[a+44>>2]=h+J[m+52>>1];break k}q=g;break l}v=0;r=0}C=0;M:{if(f){i=t;break M}if((p|0)!=2&B){Ed(W)}N:{if((M|0)==2){break N}i=0;O:{if(!p){break O}i=H[o+28>>2];if((i|0)>=0){F[(i-w|0)+R|0]=0}h=H[o+32>>2];if((h|0)>=0){F[(h-w|0)+R|0]=0}i=0;if((p|0)!=2|((h>>31^-1)+O|0)<=0){break O}i=Sb(k,14)}Yk(a,j,113,0,w,R,0,0);if(!i){break N}Pn(k,i)}if(p){if(!(H[o+28>>2]==(n|0)|H[o+32>>2]==(n|0))){ob(k,27,n,t,q,r)}i=t;if((p|0)!=1){i=jb(a)}Va(k,50,x?q:l,t);break M}if(!(!x&(v^1))){i=jb(a);Va(k,35,y,t);C=H[k+108>>2];if(v){if((M|0)==2){break M}if(x){h=0;w=D<<16>>16;O=(w|0)>0?w:0;while(1){if((h|0)!=(O|0)){Xa(k,94,y,h,h+g|0);h=h+1|0;continue}break}ob(k,27,n,i,g,w);break M}Va(k,135,y,l);Xa(k,30,n,i,l);break M}Va(k,134,y,q);ob(k,27,n,i,q,0);break M}Va(k,35,y,t);i=jb(a);C=Va(k,135,y,l);Xa(k,30,n,i,l)}if(z){P:{if(B){oc(a,S,P);break P}Xa(k,94,y,u,P)}db(k,12,P)}Q:{if(!(L?1:E|X)){break Q}h=0;if(E){g=dD(a,j)}else{g=h}w=g|Fs(a,L,c,0,3,j,e);S=(w|0)==-1;while(1){R:{S:{if(G[j+34>>1]>(h|0)){g=J[(H[j+4>>2]+N(h,12)|0)+10>>1];u=Oc(j,h<<16>>16)+$|0;T:{if(S){break T}if(h>>>0<=31){if(w>>>h&1|g&1){break T}break S}if(!(g&1)){break S}}Qc(k,j,n,h,u);break R}if(x|z){break Q}Va(k,80,l,P);break Q}Va(k,75,0,u)}h=h+1|0;continue}}w=D<<16>>16;D=Fs(a,L,c,1,1,j,e);S=(M|0)==2;g=m;h=0;while(1){z=G[j+34>>1];if((z|0)>(h|0)){U:{if(G[j+32>>1]==(h|0)){Va(k,75,0,g);break U}u=J[(H[j+4>>2]+N(h,12)|0)+10>>1];if(u&96){g=(u<<26>>31)+g|0;break U}u=H[(h<<2)+s>>2];if((u|0)>=0){if(v){Xa(k,94,y,u+(S?z:w)|0,g);break U}oc(a,H[((u<<4)+c|0)+8>>2],g);break U}if(D>>>h&1|(!(F[o+36|0]&1)|h>>>0>31)){Qc(k,j,n,h,g);Z=0;break U}Va(k,75,0,g)}g=g+1|0;h=h+1|0;continue}break}if(I[j+28|0]&96){Xk(a,m,j)}V:{W:{if(!(F[o+36|0]&1)){break W}Vg(k,j,m);dj(a,L,129,c,1,j,l,e,i);if((M|0)==2){break V}X:{if(x){ob(k,27,n,i,q,r);break X}Xa(k,30,n,i,l)}h=0;g=m;while(1){if(G[j+34>>1]>(h|0)){u=J[(H[j+4>>2]+N(h,12)|0)+10>>1];Y:{if(u&96){g=(u<<26>>31)+g|0;break Y}if(G[j+32>>1]==(h|0)|H[(h<<2)+s>>2]>=0){break Y}Qc(k,j,n,h,g)}g=g+1|0;h=h+1|0;continue}break}if(!(I[j+28|0]&96)){break W}Xk(a,m,j)}if((M|0)==2){break V}g=U&255;cD(a,j,Q,n,A,P,l,g,e&255,i,o+24|0,s,0);Z:{if(!(g?1:H[o+24>>2])){break Z}if(x){ob(k,27,n,i,q,r);break Z}Xa(k,30,n,i,l)}if(E){Ln(a,j,l,0,s,V)}Es(a,j,n,A,Q,-1);if(Z){db(k,143,n)}if(!(U&255?0:(E|0)<=1)){Va(k,130,n,0)}if(E){Ln(a,j,0,P,s,V);Ds(a,j,n,A,P,Q,(p|0)==2?6:4,0,0);bD(a,j,c,l,s,V);break V}Ds(a,j,n,A,P,Q,(p|0)==2?6:4,0,0)}if(T){Va(k,86,T,1)}dj(a,L,129,c,2,j,l,e,i);_:{$:{switch(p-1|0){case 1:lb(k,i);Ed(W);break _;case 0:break _;default:break $}}lb(k,i);Va(k,38,y,C)}lb(k,t);if(!(I[a+18|0]|(H[a+120>>2]|f))){Nn(a)}if(!T){break a}Gs(k,T,14805);break a}if(!h){break j}g=l+1|0;break i}h=0;g=l+1|0;F[R+g|0]=0}H[(l<<2)+Q>>2]=h;B=m+20|0;l=g;continue}}H[(h<<2)+s>>2]=i}aa:{switch(cc(a,23,H[j>>2],m,H[H[K+16>>2]+(q<<4)>>2])-1|0){case 1:H[(h<<2)+s>>2]=-1;break;case 0:break a;default:break aa}}i=i+1|0;continue}}fD(o+72|0);_a(K,s);Ic(K,b);qb(K,c);fb(K,d);Ga=o+80|0}function nz(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0,J=0,K=0;j=Ga-128|0;Ga=j;y=I[H[e>>2]+3|0];H[j+108>>2]=0;H[j+104>>2]=0;H[j+100>>2]=0;B=ub(H[e+4>>2]);l=ub(H[e+8>>2]);i=(d<<2)-8|0;k=Ib(i,0);H[j+112>>2]=k;a:{b:{if(!k){break b}q=$a(k,0,i);x=Ib(i,0);if(!x){break b}C=B+1|0;z=l+1|0;A=$a(x,0,i);u=(y|0)!=52;m=3;while(1){c:{d:{e:{f:{if(!((d|0)<=(m|0)|h)){l=H[(m<<2)+e>>2];g:{if(H[j+108>>2]){break g}if(ub(l)>>>0<9){break g}if(Fb(l,12115,8)){break g}if(Vq(F[l+8|0])){break g}h=fz(c,l+9|0,j+108|0,g);break c}h:{if(u){break h}h=Ga-16|0;Ga=h;k=l;i:{while(1){i=I[k|0];if(!i){break i}if((i|0)!=61){k=k+1|0;continue}break}H[j+124>>2]=k-l;i=1;H[h>>2]=k+1;k=Hb(8310,h);if(k){Ni(k)}H[j+120>>2]=k}Ga=h+16|0;if(!i){break h}i=H[j+120>>2];if(!i){h=7;break c}h=0;k=H[j+124>>2];j:{while(1){if((h|0)==8){break j}k:{D=h<<3;if((k|0)==H[D+54548>>2]){if(!Fb(l,H[D+54544>>2],k)){break k}}h=h+1|0;continue}break}l:{switch(h|0){case 0:m:{if((ub(i)|0)!=4){break m}if(Fb(i,22692,4)){break m}E=1;h=0;break d}H[j+16>>2]=i;de(g,7335,j+16|0);h=1;E=1;break d;case 1:Wa(r);H[j+120>>2]=0;h=0;r=i;i=0;break d;case 2:Wa(s);H[j+120>>2]=0;h=0;s=i;i=0;break d;case 3:Wa(v);H[j+120>>2]=0;h=0;v=i;i=0;break d;case 4:n:{o:{switch(ub(i)-3|0){case 0:if(Fb(i,16820,3)){break n}break f;case 1:break o;default:break n}}if(!Fb(i,16815,4)){break f}}H[j+32>>2]=i;de(g,7312,j+32|0);h=1;break e;case 5:Wa(o);H[j+120>>2]=0;h=0;o=i;i=0;break d;case 6:Wa(p);H[j+120>>2]=0;h=0;p=i;i=0;break d;case 7:break l;default:break j}}H[(w<<2)+A>>2]=i;H[j+120>>2]=0;w=w+1|0;h=0;i=0;break d}H[j>>2]=l;de(g,7285,j);h=1;break d}i=ub(l);H[q+(n<<2)>>2]=l;n=n+1|0;t=(i+t|0)+1|0;h=0;break c}H[j+120>>2]=t;H[j+124>>2]=h;H[j+116>>2]=n;p:{q:{r:{if(!o|h){break r}Wa(s);Wa(v);v=0;s=0;if(n){break q}Wa(q);H[j+112>>2]=0;d=0;m=0;i=0;l=Ga-32|0;Ga=l;H[l+16>>2]=H[e+4>>2];H[l+28>>2]=0;H[l+20>>2]=o;k=Hb(18942,l+16|0);s:{if(!k){d=7;break s}h=Tp(b,k,l+28|0);if(!h){break s}J=l,K=xg(b),H[J>>2]=K;de(g,8310,l);d=h}Wa(k);if(!d){k=0;h=jm(H[l+28>>2]);q=(h|0)>0?h:0;while(1){if((k|0)!=(q|0)){d=m;m=ub(im(H[l+28>>2],k))+1|0;d=d+m|0;i=d>>>0<m>>>0?i+1|0:i;m=d;k=k+1|0;continue}break}t:{k=h<<2;d=k+m|0;n=Ib(d,d>>>0<k>>>0?i+1|0:i);if(!n){d=7;break t}i=k+n|0;d=0;k=0;while(1){if((k|0)==(q|0)){break t}u=im(H[l+28>>2],k);t=ub(u)+1|0;i=Ya(i,u,t);H[n+(k<<2)>>2]=i;k=k+1|0;i=i+t|0;continue}}dd(H[l+28>>2]);H[j+116>>2]=h;H[j+120>>2]=m;H[j+112>>2]=n}Ga=l+32|0;h=d;H[j+124>>2]=d;if(!p|d){break r}d=H[j+116>>2];k=(d|0)>0?d:0;i=H[j+112>>2];h=0;while(1){if((h|0)==(k|0)){break q}if(Qb(p,H[i+(h<<2)>>2])){h=h+1|0;continue}else{k=(d|0)>(h|0)?d:h;while(1){if((h|0)!=(k|0)){m=i+(h<<2)|0;h=h+1|0;H[m>>2]=H[i+(h<<2)>>2];continue}break}i=d-1|0;break p}}}d=0;if(h){break a}}i=H[j+116>>2]}if(!i){H[H[j+112>>2]>>2]=2574;H[j+116>>2]=1;H[j+120>>2]=8;i=1}if(!H[j+108>>2]){c=fz(c,13275,j+108|0,g);H[j+124>>2]=c;d=0;if(c){break a}}d=Ga-16|0;Ga=d;k=1;u:{if(!r){break u}h=I[r|0];if(!h){break u}k=2;c=r;while(1){v:{if((h|0)!=44){if(h){break v}break u}k=k+1|0}h=I[c+1|0];c=c+1|0;continue}}l=N(k,24);c=Ib(l,0);H[j+100>>2]=c;w:{if(!c){h=7;break w}h=0;n=$a(c,0,l);x:{if(!r){break x}H[d+12>>2]=r;c=1;while(1){if((c|0)>=(k|0)){break x}H[d+8>>2]=0;m=0;l=Ga-16|0;Ga=l;H[l+12>>2]=0;q=H[d+12>>2];t=dz(q,l+12|0);y:{if(!t){m=1;break y}u=H[l+12>>2];H[d+8>>2]=(u|0)>1e7?0:u;H[d+12>>2]=q+t}Ga=l+16|0;z:{A:{if(!m){l=H[d+8>>2];if(l){break A}c=c-1|0;k=k-1|0;break z}h=1;break w}H[n+N(c,24)>>2]=l}H[d+12>>2]=H[d+12>>2]+1;c=c+1|0;continue}}H[j+104>>2]=k}Ga=d+16|0;H[j+124>>2]=h;d=0;B:{switch(h|0){case 1:H[j+48>>2]=r;de(g,7250,j+48|0);break a;case 0:break B;default:break a}}c=H[j+104>>2];l=N(c,24);k=i<<2;m=(H[j+120>>2]+(l+(k+((z+B|0)+i|0)|0)|0)|0)+289|0;n=Ib(m,0);if(!n){H[j+124>>2]=7;break a}h=0;d=$a(n,0,m);H[d+268>>2]=0;H[d+24>>2]=i;H[d+12>>2]=b;m=d+288|0;H[d+28>>2]=m;b=H[j+108>>2];H[d+264>>2]=1048576;H[d+36>>2]=b;b=(y|0)==52;F[d+238|0]=b&!E;F[d+237|0]=b;F[d+239|0]=G;F[d+236|0]=b;H[d+48>>2]=255;b=k+m|0;H[d+260>>2]=b;H[d+44>>2]=p;H[d+40>>2]=o;Ya(b,H[j+100>>2],l);H[d+256>>2]=c;k=(c|0)>0?c:0;while(1){b=H[d+260>>2];if((h|0)!=(k|0)){Tz((b+N(h,24)|0)+4|0);h=h+1|0;continue}break}b=b+N(c,24)|0;H[d+32>>2]=b;b=b+i|0;H[d+20>>2]=b;b=Ya(b,H[e+8>>2],z)+z|0;H[d+16>>2]=b;i=(i|0)>0?i:0;h=Ya(b,H[e+4>>2],C)+C|0;e=H[j+112>>2];b=0;while(1){if((b|0)==(i|0)){b=0;k=(w|0)>0?w:0;e=0;while(1){if((e|0)==(i|0)){C:{h=0;while(1){if((h|0)==(k|0)){break C}c=H[(h<<2)+A>>2];if(c){H[j+80>>2]=c;de(g,7362,j+80|0);b=1}h=h+1|0;continue}}}else{h=0;p=e<<2;l=ub(H[p+H[d+28>>2]>>2]);while(1){if((h|0)!=(k|0)){o=(h<<2)+A|0;c=H[o>>2];D:{if(!c){break D}if((ub(c)|0)!=(l|0)){break D}if(Fb(H[p+H[d+28>>2]>>2],c,l)){break D}F[H[d+32>>2]+e|0]=1;Wa(c);H[o>>2]=0}h=h+1|0;continue}break}e=e+1|0;continue}break}H[j+124>>2]=b;if(!(!s^(v|0)!=0|b)){H[j+124>>2]=1;H[j+64>>2]=s?3925:3927;de(g,8405,j- -64|0)}i=j+124|0;e=0;g=0;b=Ga-80|0;Ga=b;H[b+76>>2]=0;E:{if(!H[d+40>>2]){if(v){g=ez(v);c=g}else{c=29357}pf(i,b+76|0,14399,0);while(1){if(H[d+24>>2]>(e|0)){H[b+8>>2]=H[H[d+28>>2]+(e<<2)>>2];H[b+4>>2]=e;H[b>>2]=c;pf(i,b+76|0,26411,b);e=e+1|0;continue}break}if(H[d+44>>2]){H[b+32>>2]=14381;pf(i,b+76|0,18935,b+32|0)}Wa(g);break E}pf(i,b+76|0,14302,0);while(1){if(H[d+24>>2]>(e|0)){H[b+48>>2]=H[H[d+28>>2]+(e<<2)>>2];pf(i,b+76|0,27237,b+48|0);e=e+1|0;continue}break}c=H[d+44>>2];if(!c){break E}H[b+64>>2]=c;pf(i,b+76|0,18935,b- -64|0)}e=H[d+16>>2];g=H[d+40>>2];if(g){c=29357}else{g=H[d+20>>2];c=2573}H[b+24>>2]=c;H[b+20>>2]=g;H[b+16>>2]=e;pf(i,b+76|0,1566,b+16|0);Ga=b+80|0;H[d+224>>2]=H[b+76>>2];e=0;g=0;c=Ga-16|0;Ga=c;H[c+12>>2]=0;if(s){g=ez(s);b=g}else{b=29357}pf(i,c+12|0,21009,0);while(1){if(H[d+24>>2]>(e|0)){H[c>>2]=b;pf(i,c+12|0,25449,c);e=e+1|0;continue}break}if(H[d+44>>2]){pf(i,c+12|0,21007,0)}Wa(g);Ga=c+16|0;H[d+228>>2]=H[c+12>>2];o=0;if(!H[j+124>>2]){F:{if(a){c=0;a=Ga-96|0;Ga=a;H[a+92>>2]=0;e=H[d+12>>2];if(!H[d+40>>2]){g=H[d+44>>2];b=Hb(17854,0);G:{H:{while(1){if(!b){break H}if(H[d+24>>2]>(c|0)){H[a+72>>2]=H[H[d+28>>2]+(c<<2)>>2];H[a+68>>2]=c;H[a+64>>2]=b;c=c+1|0;b=Hb(27196,a- -64|0);continue}break}if(!g){break G}H[a+84>>2]=g;H[a+80>>2]=b;b=Hb(14377,a+80|0);if(b){break G}}H[a+92>>2]=7;b=0}c=H[d+16>>2];g=H[d+20>>2];H[a+56>>2]=b;H[a+48>>2]=c;H[a+52>>2]=g;We(a+92|0,e,24291,a+48|0);Wa(b)}b=H[d+20>>2];H[a+32>>2]=H[d+16>>2];H[a+36>>2]=b;b=a+92|0;We(b,e,21136,a+32|0);c=H[d+20>>2];H[a+16>>2]=H[d+16>>2];H[a+20>>2]=c;We(b,e,21353,a+16|0);if(I[d+238|0]){b=H[d+20>>2];H[a>>2]=H[d+16>>2];H[a+4>>2]=b;We(a+92|0,e,21208,a)}if(I[d+237|0]){Tq(a+92|0,d)}Ga=a+96|0;H[j+124>>2]=H[a+92>>2];break F}if((y|0)==52){break F}F[d+237|0]=2}a=Ga-16|0;Ga=a;if(!H[j+124>>2]){H[a>>2]=H[d+16>>2];b=Hb(12091,a);I:{if(!b){c=7;break I}c=Tp(H[d+12>>2],b,a+12|0);if((c|0)!=23){if(c){break I}Ab(H[a+12>>2]);J=d,K=Qd(H[a+12>>2],0),H[J+244>>2]=K;c=dd(H[a+12>>2]);break I}H[d+244>>2]=1024;c=0}Wa(b);H[j+124>>2]=c}Ga=a+16|0;H[d+232>>2]=H[d+244>>2]-35;a=Ga+-64|0;Ga=a;if(!H[j+124>>2]){b=H[d+44>>2];c=H[d+12>>2];H[a+48>>2]=1;cx(c,1,a+48|0);H[a+32>>2]=H[H[d+28>>2]>>2];b=b?b:14368;e=Hb(29314,a+32|0);c=1;while(1){if(!(!e|H[d+24>>2]<=(c|0))){H[a+20>>2]=H[H[d+28>>2]+(c<<2)>>2];H[a+16>>2]=e;c=c+1|0;e=Hb(29312,a+16|0);continue}break}c=H[d+20>>2];H[a+8>>2]=b;H[a+4>>2]=c;H[a>>2]=e;c=7;b=Hb(25188,a);if(!(!e|!b)){c=Wj(H[d+12>>2],b)}Wa(b);Wa(e);H[j+124>>2]=c}Ga=a- -64|0}p=0;break a}H[j+96>>2]=0;k=b<<2;l=Uq(H[k+e>>2],j+96|0);c=H[j+96>>2];if((c|0)>0){Ya(h,l,c)}c=c+h|0;F[c|0]=0;Ni(h);H[k+H[d+28>>2]>>2]=h;b=b+1|0;h=c+1|0;continue}}h=0}G=(I[i|0]&223)==68}Wa(i)}m=m+1|0;continue}}H[j+124>>2]=7;x=0;d=0}Wa(r);Wa(H[j+100>>2]);Wa(s);Wa(v);Wa(o);Wa(p);h=0;a=(w|0)>0?w:0;while(1){if((a|0)!=(h|0)){Wa(H[(h<<2)+x>>2]);h=h+1|0;continue}break}Wa(H[j+112>>2]);Wa(x);b=H[j+124>>2];J:{if(b){if(d){Yq(d);break J}a=H[j+108>>2];if(!a){break J}Ka[H[H[a>>2]+8>>2]](a)|0;break J}H[f>>2]=d}Ga=j+128|0;return b}function mq(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,R=0;k=Ga-336|0;Ga=k;n=h;p=i&65535;o=d;m=e&65535;r=(e^i)&-2147483648;t=i>>>16&32767;u=e>>>16&32767;a:{b:{if(t-32767>>>0>4294934529&u-32767>>>0>=4294934530){break b}j=e&2147483647;if(!(!d&(j|0)==2147418112?!(b|c):j>>>0<2147418112)){x=d;r=e|32768;break a}e=i&2147483647;if(!(!h&(e|0)==2147418112?!(f|g):e>>>0<2147418112)){x=h;r=i|32768;b=f;c=g;break a}if(!(b|d|(j^2147418112|c))){if(!(f|h|(e^2147418112|g))){b=0;c=0;r=2147450880;break a}r=r|2147418112;b=0;c=0;break a}if(!(f|h|(e^2147418112|g))){b=0;c=0;break a}if(!(b|d|(c|j))){b=!(f|h|(e|g));x=b?0:x;r=b?2147450880:r;b=0;c=0;break a}if(!(f|h|(e|g))){r=r|2147418112;b=0;c=0;break a}if((j|0)==65535|j>>>0<65535){i=b;d=!(m|o);h=d<<6;j=Q(d?b:o)+32|0;b=Q(d?c:m);b=h+((b|0)==32?j:b)|0;ud(k+320|0,i,c,o,m,b-15|0);l=16-b|0;o=H[k+328>>2];m=H[k+332>>2];c=H[k+324>>2];b=H[k+320>>2]}if(e>>>0>65535){break b}d=!(n|p);e=d<<6;h=Q(d?f:n)+32|0;d=Q(d?g:p);d=e+((d|0)==32?h:d)|0;ud(k+304|0,f,g,n,p,d-15|0);l=(d+l|0)-16|0;n=H[k+312>>2];p=H[k+316>>2];f=H[k+304>>2];g=H[k+308>>2]}e=p|65536;C=e;D=n;d=n;j=e<<15|d>>>17;e=d<<15|g>>>17;d=0-e|0;h=j;i=1963258675-(j+((e|0)!=0)|0)|0;pd(k+288|0,e,j,0,0,d,i,0,0);j=H[k+296>>2];pd(k+272|0,0-j|0,0-(H[k+300>>2]+((j|0)!=0)|0)|0,0,0,d,i,0,0);d=H[k+280>>2];i=d<<1|H[k+276>>2]>>>31;d=H[k+284>>2]<<1|d>>>31;pd(k+256|0,i,d,0,0,e,h,0,0);j=d;d=H[k+264>>2];pd(k+240|0,i,j,0,0,0-d|0,0-(H[k+268>>2]+((d|0)!=0)|0)|0,0,0);i=H[k+248>>2];j=i<<1|H[k+244>>2]>>>31;d=H[k+252>>2]<<1|i>>>31;pd(k+224|0,j,d,0,0,e,h,0,0);i=d;d=H[k+232>>2];pd(k+208|0,j,i,0,0,0-d|0,0-(H[k+236>>2]+((d|0)!=0)|0)|0,0,0);d=H[k+216>>2];i=d<<1|H[k+212>>2]>>>31;d=H[k+220>>2]<<1|d>>>31;pd(k+192|0,i,d,0,0,e,h,0,0);j=d;d=H[k+200>>2];pd(k+176|0,i,j,0,0,0-d|0,0-(H[k+204>>2]+((d|0)!=0)|0)|0,0,0);d=e;i=H[k+184>>2];e=i<<1|H[k+180>>2]>>>31;s=e-1|0;i=(H[k+188>>2]<<1|i>>>31)-!e|0;pd(k+160|0,d,h,0,0,s,i,0,0);d=f;j=g<<15|d>>>17;pd(k+144|0,d<<15,j,0,0,s,i,0,0);h=H[k+172>>2];p=H[k+160>>2];e=H[k+152>>2];d=p+e|0;n=H[k+164>>2];j=n+H[k+156>>2]|0;j=d>>>0<e>>>0?j+1|0:j;e=d;d=j;n=(n|0)==(d|0)&e>>>0<p>>>0|d>>>0<n>>>0;j=n+H[k+168>>2]|0;h=j>>>0<n>>>0?h+1|0:h;p=!d&e>>>0>1|(d|0)!=0;n=p+j|0;j=h;h=n;pd(k+112|0,s,i,0,0,0-h|0,0-(((h|0)!=0)+(h>>>0<p>>>0?j+1|0:j)|0)|0,0,0);pd(k+128|0,1-e|0,0-((e>>>0>1)+d|0)|0,0,0,s,i,0,0);J=(u-t|0)+l|0;e=H[k+116>>2];z=e;d=H[k+112>>2];j=e<<1|d>>>31;A=d<<1;q=j;d=j;h=H[k+140>>2];y=h;e=H[k+136>>2];j=h<<1|e>>>31;i=e<<1|H[k+132>>2]>>>31;h=i+A|0;d=d+j|0;d=h>>>0<i>>>0?d+1|0:d;e=d;d=d-(h>>>0<13927)|0;n=d;l=0;j=m|65536;L=j;M=o;d=o;j=j<<1|d>>>31;P=d<<1;R=j;E=j;w=SK(n,l,j,0);d=Ja;v=d;j=b;d=c<<1|j>>>31;t=j<<1;s=d;p=d;j=0;u=j;i=h-13927|0;l=(e|0)==(n|0)&i>>>0<h>>>0|e>>>0>n>>>0;m=(e|0)==(q|0)&h>>>0<A>>>0|e>>>0<q>>>0;d=H[k+120>>2];h=H[k+124>>2]<<1|d>>>31;e=y>>>31|0;d=e+(d<<1|z>>>31)|0;j=h;j=d>>>0<e>>>0?j+1|0:j;e=d;d=m+d|0;j=d>>>0<e>>>0?j+1|0:j;e=d;d=l+d|0;l=d>>>0<e>>>0?j+1|0:j;e=d;d=d-1|0;F=l-!e|0;A=0;j=SK(p,u,F,A);e=j+w|0;h=Ja+v|0;h=e>>>0<j>>>0?h+1|0:h;l=(h|0)==(v|0)&e>>>0<w>>>0|h>>>0<v>>>0;j=0;w=l;q=d;d=o;N=c>>>31|0;v=N|d<<1;y=0;l=SK(q,j,v,y);d=l+e|0;j=Ja+h|0;j=d>>>0<l>>>0?j+1|0:j;o=d;m=j;e=(j|0)==(h|0)&d>>>0<e>>>0|h>>>0>j>>>0;d=w+e|0;l=0;l=d>>>0<e>>>0?1:l;e=SK(E,u,F,A);d=e+d|0;j=Ja+l|0;w=d;d=d>>>0<e>>>0?j+1|0:j;l=SK(E,u,q,y);h=Ja;B=SK(v,y,F,A);e=B+l|0;j=Ja+h|0;j=e>>>0<B>>>0?j+1|0:j;B=e;e=j;j=(h|0)==(j|0)&l>>>0>B>>>0|h>>>0>j>>>0;l=w+e|0;d=d+j|0;h=l;l=h>>>0<e>>>0?d+1|0:d;e=0;d=e+o|0;j=m+B|0;j=d>>>0<e>>>0?j+1|0:j;e=j;m=(j|0)==(m|0)&d>>>0<o>>>0|j>>>0<m>>>0;h=m+h|0;j=l;w=h;l=h>>>0<m>>>0?j+1|0:j;o=d;m=e;B=i;h=SK(i,0,v,y);e=Ja;i=SK(n,u,p,u);d=i+h|0;j=Ja+e|0;j=d>>>0<i>>>0?j+1|0:j;e=(e|0)==(j|0)&d>>>0<h>>>0|e>>>0>j>>>0;h=j;G=w;z=e;I=t&-2;i=SK(q,y,I,0);e=i+d|0;j=Ja+j|0;j=e>>>0<i>>>0?j+1|0:j;w=e;i=e;e=j;i=(j|0)==(h|0)&d>>>0>i>>>0|h>>>0>j>>>0;d=z+i|0;h=0;h=d>>>0<i>>>0?1:h;j=d;i=d+o|0;d=h+m|0;z=i;h=i;d=h>>>0<j>>>0?d+1|0:d;i=d;h=(d|0)==(m|0)&h>>>0<o>>>0|d>>>0<m>>>0;d=G+h|0;j=l;G=d;o=d>>>0<h>>>0?j+1|0:j;O=SK(E,u,B,x);E=Ja;h=SK(F,A,I,x);d=h+O|0;j=Ja+E|0;F=d;m=SK(n,u,v,y);l=d+m|0;h=d>>>0<h>>>0?j+1|0:j;d=h+Ja|0;d=l>>>0<m>>>0?d+1|0:d;v=l;m=SK(p,u,q,y);j=l+m|0;l=Ja+d|0;A=j;l=j>>>0<m>>>0?l+1|0:l;m=0;q=(d|0)==(l|0)&v>>>0>j>>>0|d>>>0>l>>>0;j=(d|0)==(h|0)&v>>>0<F>>>0|d>>>0<h>>>0;d=j+((h|0)==(E|0)&F>>>0<O>>>0|h>>>0<E>>>0)|0;h=0;d=q+d|0;q=l|0;h=q+z|0;j=(d|m)+i|0;j=h>>>0<q>>>0?j+1|0:j;q=h;d=h;m=j;h=(i|0)==(j|0)&d>>>0<z>>>0|i>>>0>j>>>0;d=h+G|0;j=o;v=d;i=d>>>0<h>>>0?j+1|0:j;z=SK(n,u,I,x);n=Ja;h=SK(p,u,B,x);d=h+z|0;j=Ja+n|0;j=d>>>0<h>>>0?j+1|0:j;o=0;h=(j|0)==(n|0)&d>>>0<z>>>0|j>>>0<n>>>0;n=j;d=j+w|0;j=(h|o)+e|0;h=d;j=d>>>0<n>>>0?j+1|0:j;n=(e|0)==(j|0)&d>>>0<w>>>0|e>>>0>j>>>0;e=0+d|0;d=j;l=A+d|0;l=e>>>0<o>>>0?l+1|0:l;e=(d|0)==(l|0)&e>>>0<h>>>0|d>>>0>l>>>0;d=n+e|0;j=0;j=d>>>0<e>>>0?1:j;e=d;d=d+q|0;j=j+m|0;j=d>>>0<e>>>0?j+1|0:j;e=j;j=(m|0)==(j|0)&d>>>0<q>>>0|j>>>0<m>>>0;h=j+v|0;l=i;l=h>>>0<j>>>0?l+1|0:l;i=l;c:{if((l|0)==131071|l>>>0<131071){M=P|N;L=y|R;pd(k+80|0,d,e,h,i,f,g,D,C);j=b<<17;b=0;c=H[k+88>>2];m=b-c|0;l=H[k+80>>2];p=H[k+84>>2];n=(l|p)!=0;o=m-n|0;m=(j-(H[k+92>>2]+(b>>>0<c>>>0)|0)|0)-(m>>>0<n>>>0)|0;n=0-l|0;p=0-(((l|0)!=0)+p|0)|0;b=J+16382|0;break c}d=(e&1)<<31|d>>>1;e=h<<31|e>>>1;h=(i&1)<<31|h>>>1;i=i>>>1|0;pd(k+96|0,d,e,h,i,f,g,D,C);m=0;n=H[k+104>>2];p=m-n|0;l=H[k+96>>2];s=H[k+100>>2];t=(l|s)!=0;o=p-t|0;m=((b<<16)-(H[k+108>>2]+(m>>>0<n>>>0)|0)|0)-(p>>>0<t>>>0)|0;n=0-l|0;p=0-(((l|0)!=0)+s|0)|0;t=b;s=c;b=J+16383|0}if((b|0)>=32767){r=r|2147418112;b=0;c=0;break a}d:{if((b|0)>0){c=o;l=m<<1|c>>>31;o=c<<1|p>>>31;m=l;t=h;s=i&65535|b<<16;b=n;l=p<<1|b>>>31;b=b<<1;break d}if((b|0)<=-113){b=0;c=0;break a}th(k- -64|0,d,e,h,i,1-b|0);ud(k+48|0,t,s,M,L,b+112|0);d=H[k+64>>2];e=H[k+68>>2];t=H[k+72>>2];s=H[k+76>>2];pd(k+32|0,f,g,D,C,d,e,t,s);c=H[k+40>>2];i=c<<1;c=H[k+44>>2]<<1|c>>>31;b=H[k+56>>2];h=H[k+36>>2];o=h>>>31|i;i=b-o|0;l=H[k+60>>2]-((b>>>0<o>>>0)+c|0)|0;c=H[k+32>>2];h=h<<1|c>>>31;c=c<<1;j=H[k+52>>2];b=H[k+48>>2];m=(h|0)==(j|0)&c>>>0>b>>>0|h>>>0>j>>>0;o=i-m|0;m=l-(i>>>0<m>>>0)|0;i=b;b=b-c|0;l=j-((c>>>0>i>>>0)+h|0)|0}pd(k+16|0,f,g,D,C,3,0,0,0);pd(k,f,g,D,C,5,0,0,0);j=0;h=l+j|0;n=d&1;c=b+n|0;h=c>>>0<b>>>0?h+1|0:h;i=c;b=i;g=(g|0)==(h|0)&b>>>0>f>>>0|g>>>0<h>>>0;c=(h|0)==(j|0)&b>>>0<n>>>0|h>>>0<j>>>0;b=c+o|0;l=m;l=b>>>0<c>>>0?l+1|0:l;f=b;c=(l|0)==(C|0);c=c&(b|0)==(D|0)?g:c&b>>>0>D>>>0|l>>>0>C>>>0;b=c+d|0;j=e;j=b>>>0<c>>>0?j+1|0:j;c=b;b=j;e=(j|0)==(e|0)&c>>>0<d>>>0|e>>>0>j>>>0;d=e+t|0;j=s;j=d>>>0<e>>>0?j+1|0:j;o=d;d=H[k+20>>2];g=(d|0)==(h|0)&K[k+16>>2]<i>>>0|d>>>0<h>>>0;d=H[k+28>>2];e=H[k+24>>2];g=j>>>0<2147418112&((e|0)==(f|0)&(d|0)==(l|0)?g:(d|0)==(l|0)&e>>>0<f>>>0|d>>>0<l>>>0);e=g+c|0;d=b;d=e>>>0<g>>>0?d+1|0:d;c=(b|0)==(d|0)&c>>>0>e>>>0|b>>>0>d>>>0;b=o+c|0;j=b>>>0<c>>>0?j+1|0:j;g=b;b=H[k+4>>2];h=(b|0)==(h|0)&K[k>>2]<i>>>0|b>>>0<h>>>0;b=H[k+12>>2];c=H[k+8>>2];c=j>>>0<2147418112&((c|0)==(f|0)&(b|0)==(l|0)?h:(b|0)==(l|0)&c>>>0<f>>>0|b>>>0<l>>>0);b=c+e|0;l=b>>>0<c>>>0?d+1|0:d;c=l;f=(d|0)==(l|0)&b>>>0<e>>>0|d>>>0>l>>>0;e=g+f|0;d=j;x=e|x;r=r|(e>>>0<f>>>0?d+1|0:d)}H[a>>2]=b;H[a+4>>2]=c;H[a+8>>2]=x;H[a+12>>2]=r;Ga=k+336|0}function PG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0;G=Ga-16|0;Ga=G;a:{if((b|0)>=7){fc(a,25713,-1);break a}if(Bm(a,3148,H[c>>2],G+12|0)){break a}o=15;A=-1;J=21022;L=21028;M=21018;b:{switch(b-2|0){case 4:o=ac(H[c+20>>2]);case 3:A=ac(H[c+16>>2]);case 2:J=cb(H[c+12>>2]);case 1:L=cb(H[c+8>>2]);case 0:M=cb(H[c+4>>2]);break;default:break b}}if(M?!J|!L:1){ic(a);break a}if(!o){wb(a,29357,-1,0);break a}r=H[G+12>>2];if(Jm(a,r)){break a}h=Ga-160|0;Ga=h;O=H[r>>2];H[h+152>>2]=0;H[h+144>>2]=0;H[h+148>>2]=0;c:{if(!H[r+16>>2]){wb(a,29357,0,0);break c}b=(o|0)>-64?o:-64;B=(b|0)<64?b:64;Q=0-B|0;u=1;while(1){H[h+40>>2]=0;H[h+44>>2]=0;C=(B|0)>=0?((u+B|0)-1|0)/(u|0)|0:Q;x=0;y=0;v=0;d:{e:{while(1){if((u|0)!=(v|0)){q=(h+48|0)+N(v,24)|0;b=q;H[b>>2]=0;H[b+4>>2]=0;H[b+16>>2]=0;H[b+20>>2]=0;H[b+8>>2]=0;H[b+12>>2]=0;b=0;o=-1;while(1){if(H[O+24>>2]>(b|0)){H[h+32>>2]=0;H[h+36>>2]=0;H[h+24>>2]=0;H[h+28>>2]=0;H[h+16>>2]=0;H[h+20>>2]=0;H[h+12>>2]=0;f:{if((b|0)!=(A|0)&(A|0)>=0){break f}e=Ga+-64|0;Ga=e;g=Am(r,e+60|0,0);g:{if(g){break g}c=Xe(N(H[e+60>>2],40),0);H[e+48>>2]=c;if(!c){g=7;break g}H[e+40>>2]=C;H[e+36>>2]=b;H[e+52>>2]=-1;H[e+44>>2]=H[e+60>>2];H[e+32>>2]=r;g=uh(H[r+16>>2],108,e+32|0);if(!g){f=0;c=H[e+60>>2];d=(c|0)>0?c:0;j=H[e+48>>2];while(1){if((d|0)!=(f|0)){if(H[(j+N(f,40)|0)+16>>2]){m=H[h+44>>2];i=f&63;c=i&31;if(i>>>0>=32){i=1<<c;k=0}else{k=1<<c;i=k-1&1>>>32-c}H[h+40>>2]=k|H[h+40>>2];H[h+44>>2]=i|m}f=f+1|0;continue}break}H[h+16>>2]=b;f=-1;while(1){c=0;s=0;h:{i:{if(H[e+52>>2]>=0){d=H[e+44>>2];i=(d|0)>0?d:0;n=2147483647;while(1){if((c|0)==(i|0)){break i}j=H[e+48>>2]+N(c,40)|0;if(H[j+16>>2]){m=H[j+8>>2];j=H[j+12>>2];k=n>>31;n=(j|0)<=(k|0)&n>>>0>m>>>0|(j|0)<(k|0)?m:n}c=c+1|0;continue}}H[e+52>>2]=0;while(1){if(H[e+44>>2]<=(c|0)){break h}d=H[e+48>>2]+N(c,40)|0;Dq(d+16|0,d+8|0,H[e+40>>2]);c=c+1|0;continue}}s=1;if((n|0)==2147483647){break h}j=(n-H[e+40>>2]|0)+1|0;H[e+52>>2]=j;i=n+1|0;s=0;c=0;while(1){if((c|0)>=(d|0)){break h}d=H[e+48>>2]+N(c,40)|0;Dq(d+16|0,d+8|0,i);Dq(d+32|0,d+24|0,j);c=c+1|0;d=H[e+44>>2];continue}}if(!s){c=0;d=0;n=0;D=0;E=0;s=0;p=Ga-16|0;Ga=p;w=H[e+52>>2];F=w>>31;while(1){j:{k:{if(H[e+44>>2]>(n|0)){z=H[e+48>>2]+N(n,40)|0;j=H[z+32>>2];if(!j){break k}H[p+12>>2]=j;l=H[z+28>>2];m=H[z+24>>2];H[p>>2]=m;H[p+4>>2]=l;i=n&63;j=i&31;if(i>>>0>=32){i=1<<j;k=0}else{k=1<<j;i=k-1&1>>>32-j}P=k;j=P|c;k=i;i=k|d;while(1){t=w+H[e+40>>2]|0;K=t>>31;if(m>>>0<w>>>0&(l|0)<=(F|0)|(l|0)<(F|0)|((K|0)<=(l|0)&m>>>0>=t>>>0|(l|0)>(K|0))){break k}l=m-w|0;m=l&31;if((l&63)>>>0>=32){t=1<<m;l=0}else{l=1<<m;t=l-1&1>>>32-m}K=l;s=(P&(c|x)|k&(d|y)?1:1e3)+s|0;c=H[z>>2];R=(c|0)>0?c:0;m=0;l=0;while(1){if((m|0)!=(R|0)|l){d=m&31;if((m&63)>>>0>=32){c=0;d=t>>>d|0}else{c=t>>>d|0;d=((1<<d)-1&t)<<32-d|K>>>d}D=d|D;E=c|E;m=m+1|0;l=m?l:l+1|0;continue}break}if(I[H[p+12>>2]]<2){c=j;d=i;break k}else{sk(p+12|0,p);m=H[p>>2];l=H[p+4>>2];c=j;d=i;continue}}}H[e+28>>2]=w;H[e+24>>2]=s;H[e+16>>2]=c;H[e+20>>2]=d;H[e+8>>2]=D;H[e+12>>2]=E;Ga=p+16|0;break j}n=n+1|0;continue}break}c=H[e+24>>2];if((c|0)<=(f|0)){continue}H[h+20>>2]=H[e+28>>2];f=H[e+12>>2];H[h+32>>2]=H[e+8>>2];H[h+36>>2]=f;f=H[e+20>>2];H[h+24>>2]=H[e+16>>2];H[h+28>>2]=f;f=c;continue}break}H[h+12>>2]=f}Wa(H[e+48>>2])}Ga=e- -64|0;f=g;if(g){break e}c=H[h+12>>2];if((c|0)<=(o|0)){break f}f=H[h+20>>2];H[q>>2]=H[h+16>>2];H[q+4>>2]=f;f=H[h+36>>2];H[q+16>>2]=H[h+32>>2];H[q+20>>2]=f;f=H[h+28>>2];H[q+8>>2]=H[h+24>>2];H[q+12>>2]=f;o=c}b=b+1|0;continue}break}v=v+1|0;x=x|H[q+8>>2];y=y|H[q+12>>2];continue}break}if((H[h+40>>2]!=(x|0)|H[h+44>>2]!=(y|0))&(u|0)!=4){break d}t=u-1|0;f=0;b=0;while(1){if(b>>>0>=u>>>0|f){break e}m=b;A=(b|0)==(t|0);e=h+144|0;p=0;v=0;g=Ga-48|0;Ga=g;s=H[r>>2];H[g+44>>2]=0;b=(h+48|0)+N(b,24)|0;H[g+40>>2]=H[b+4>>2];c=H[b+20>>2];H[g+32>>2]=H[b+16>>2];H[g+36>>2]=c;b=H[b>>2]+1|0;n=lf(H[r+12>>2],b);c=H[r+12>>2];l:{if(!n){b=(ph(c,b)|0)==5?0:7;break l}x=_d(c,b);b=H[s+36>>2];y=H[b>>2];b=Ig(b,H[r+20>>2],n,x,g+28|0);if(b){break l}w=H[g+28>>2];D=(m|0)>0;b=0;m:{while(1){if(b){break m}H[g+20>>2]=-1;H[g+16>>2]=0;H[g+12>>2]=0;b=Ka[H[y+20>>2]](w,g+24|0,g+20|0,g+16|0,g+12|0,g+44|0)|0;if(b){if((b|0)!=101){break m}b=Vf(e,n+p|0,-1);break m}b=0;c=H[g+44>>2];f=H[g+40>>2];if((c|0)<(f|0)){continue}if(!v){v=1;E=H[r+20>>2];c=H[g+16>>2];z=c+n|0;B=x-c|0;c=0;d=0;f=0;k=Ga-32|0;Ga=k;j=H[g+32>>2];l=H[g+36>>2];n:{if(!(j|l)){break n}while(1){i=c;c=c+1|0;d=c?d:d+1|0;o=i&31;if(!(((i&63)>>>0>=32?l>>>o|0:((1<<o)-1&l)<<32-o|j>>>o)&1)){continue}break}c=0;d=0;while(1){o=c;c=c+1|0;d=c?d:d+1|0;F=(o^-1)+C|0;q=F&31;if(!(((F&63)>>>0>=32?l>>>q|0:((1<<q)-1&l)<<32-q|j>>>q)&1)){continue}break}c=i-o|0;if((c|0)<2){break n}H[k+28>>2]=0;f=H[s+36>>2];d=H[f>>2];f=Ig(f,E,z,B,k+24|0);if(f){break n}i=((c|0)/2|0)+C|0;f=H[k+24>>2];c=0;o:{while(1){if(!c){if((i|0)<=H[k+28>>2]){Ka[H[d+16>>2]](f)|0;break o}else{H[k+16>>2]=0;H[k+12>>2]=0;H[k+8>>2]=0;c=Ka[H[d+20>>2]](f,k+20|0,k+16|0,k+12|0,k+8|0,k+28|0)|0;continue}}break}Ka[H[d+16>>2]](f)|0;if((c|0)==101){break o}f=c;break n}f=0;d=H[k+28>>2]+(((c|0)!=0)-C|0)|0;if((d|0)<=0){break n}H[g+40>>2]=d+H[g+40>>2];c=d&31;if((d&63)>>>0>=32){d=0;c=l>>>c|0}else{d=l>>>c|0;c=((1<<c)-1&l)<<32-c|j>>>c}H[g+32>>2]=c;H[g+36>>2]=d}Ga=k+32|0;if(f){b=f;continue}p:{f=H[g+40>>2];q:{if(!(!D&(f|0)<=0)){c=Vf(e,J,-1);break q}c=H[g+16>>2];if(!c){break p}c=Vf(e,n,c)}if(!c){break p}b=c;continue}c=H[g+44>>2];if((f|0)>(c|0)){continue}}r:{if((f+C|0)<=(c|0)){if(A){break r}break m}j=H[g+36>>2];i=c-f|0;d=i&31;if((i&63)>>>0>=32){d=1<<d;i=0}else{i=1<<d;d=i-1&1>>>32-d}i=i&H[g+32>>2];d=d&j;j=!(i|d);if((c|0)>(f|0)){b=Vf(e,n+p|0,H[g+16>>2]-p|0)}if(!(b|j)){b=Vf(e,M,-1)}s:{if(b){break s}b=H[g+16>>2];b=Vf(e,b+n|0,H[g+12>>2]-b|0);if(b|!(d|i)){break s}b=Vf(e,L,-1)}v=1;p=H[g+12>>2];continue}break}b=Vf(e,J,-1)}Ka[H[y+16>>2]](w)|0}Ga=g+48|0;f=b;b=m+1|0;continue}}tf(O);if(f){ne(a,f);Wa(H[h+144>>2]);break c}wb(a,H[h+144>>2],-1,3);break c}u=u+1|0;continue}}Ga=h+160|0}Ga=G+16|0}function XG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;j=Ga-16|0;Ga=j;H[j+8>>2]=0;a:{b:{if((b|0)<2){break b}e=H[a+24>>2];c:{if((gb(H[c>>2])|0)!=5){break c}f=H[((e<<2)+c|0)+8>>2];if((gb(f)|0)==5){break c}e=cb(f);d=bc(f);c=7;d:{if(!e){break d}e:{f:{g:{switch(d-7|0){case 1:if(Fb(e,12124,8)){break f}c=Dy(a,0);break d;case 0:if(Fb(e,14190,7)){break f}e=Ga-16|0;Ga=e;h:{c=Cy(a,0);if(c){break h}H[e+8>>2]=0;H[e>>2]=H[a+224>>2];i:{j:{c=Hb(6828,e);if(!c){b=7;H[e+12>>2]=7;break j}b=Rh(H[a+12>>2],c,-1,e+8|0,0);H[e+12>>2]=b;Wa(c);if(b){break j}b=H[a+24>>2];c=SK(b,b>>31,12,0)+12|0;b=Ja;h=Ib(c,c>>>0<12?b+1|0:b);if(!h){b=7;H[e+12>>2]=7;break j}b=0;d=$a(h,0,c);c=(H[a+24>>2]<<2)+4|0;i=d+c|0;g=i+c|0;break i}h=0}while(1){k:{l:{if(b){break l}if((Ab(H[e+8>>2])|0)!=100){break l}c=0;l=Kq(a,H[e+8>>2]);b=Nq(a,0,l,ed(H[e+8>>2],0),Ja);H[e+12>>2]=b;f=$a(h,0,(H[a+24>>2]<<2)+4|0);while(1){d=b;m:{while(1){if(H[a+24>>2]<=(c|0)|d){break m}if(I[H[a+32>>2]+c|0]){c=c+1|0;d=0;continue}break}d=c+1|0;b=Mq(a,l,lf(H[e+8>>2],d),c,f+(c<<2)|0);H[e+12>>2]=b;c=_d(H[e+8>>2],d);n=f+(H[a+24>>2]<<2)|0;H[n>>2]=c+H[n>>2];c=d;continue}break}if(I[a+238|0]){Fy(e+12|0,a,f);b=H[e+12>>2]}if(b){break k}c=0;while(1){if(H[a+24>>2]>=(c|0)){d=c<<2;l=d+i|0;H[l>>2]=H[l>>2]+H[d+f>>2];c=c+1|0;continue}break}m=m+1|0;continue}if(I[a+236|0]){Ey(e+12|0,a,i,g,m)}Wa(h);b=H[e+8>>2];if(!b){c=H[e+12>>2];break h}b=dd(b);c=H[e+12>>2];c=c?c:b;break h}dd(H[e+8>>2]);H[e+8>>2]=0;b=1;continue}}Ga=e+16|0;break d;default:break g}}if((d|0)!=15){b=1;if((d|0)<7){break e}break f}if(Fb(e,11416,15)){break f}m=Ga-16|0;Ga=m;H[m+12>>2]=0;b=0;f=Ga-48|0;Ga=f;H[f+40>>2]=0;d=Pb(a,27,f+40|0,0);H[f+44>>2]=d;n:{if(d){break n}l=H[f+40>>2];wc(l,1,H[a+280>>2]);wc(l,2,H[a+256>>2]);while(1){o:{p:{if(b){break p}if((Ab(l)|0)!=100){break p}d=0;s=Qd(l,0);while(1){if(H[a+256>>2]<=(d|0)){break o}q=0;r=0;g=Ga-96|0;Ga=g;H[g+88>>2]=0;H[g+80>>2]=0;H[g+84>>2]=0;b=g+24|0;$a(b,0,56);H[g+92>>2]=19;q:{h=Mi(a,s,d,-2,0,0,0,1,b);if(h){break q}h=xk(a,g+24|0,g+80|0);if(h){break q}r:while(1){h=Li(a,g+24|0);if((h|0)!=100){break q}c=H[g+76>>2];b=H[g+72>>2];i=0;e=0;H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=0;H[g+12>>2]=0;o=b+c|0;h=qd(b,g+16|0)+b|0;b=H[g+16>>2];c=H[g+20>>2];while(1){if(h>>>0>=o>>>0){continue r}H[g>>2]=0;H[g+4>>2]=0;h=yh(h,g)+h|0;if(o>>>0<=h>>>0){continue}k=H[g+4>>2];p=k;u=!k;k=H[g>>2];if(u&k>>>0<=1){H[g+8>>2]=0;H[g+12>>2]=0;if(k|p){h=qd(h,g+8|0)+h|0;i=0;e=0;continue}h=yh(h,g)+h|0;i=H[g>>2];k=H[g+4>>2];if(I[a+239|0]){e=b;b=e-i|0;c=c-((e>>>0<i>>>0)+k|0)|0;i=0;e=0;continue}c=c+k|0;e=b;b=b+i|0;c=e>>>0>b>>>0?c+1|0:c;i=0;e=0}else{e=e+p|0;u=e+1|0;p=e;e=i+k|0;k=e>>>0<k>>>0?u:p;i=e-2|0;q=Gq(H[g+64>>2],H[g+68>>2],s,d,b,c,H[g+8>>2],i)^q;r=r^Ja;e=k-(e>>>0<2)|0}continue}}}Ch(g+24|0);H[f+44>>2]=h;Ga=g+96|0;v=q^v;w=r^w;d=d+1|0;continue}}d=rb(l);if(b){d=b;break n}if(d){break n}i=H[H[a+36>>2]>>2];H[f+36>>2]=0;H[f>>2]=H[a+224>>2];b=Hb(6828,f);s:{if(!b){d=7;H[f+44>>2]=7;break s}d=Rh(H[a+12>>2],b,-1,f+36|0,0);H[f+44>>2]=d;Wa(b)}t:while(1){u:{if(d){break u}if((Ab(H[f+36>>2])|0)!=100){break u}d=0;l=ed(H[f+36>>2],0);q=Ja;e=Kq(a,H[f+36>>2]);b=0;while(1){if(H[a+24>>2]<=(b|0)|d){continue t}if(I[H[a+32>>2]+b|0]){b=b+1|0;d=0;continue}c=b+1|0;d=lf(H[f+36>>2],c);H[f+32>>2]=0;h=Ig(H[a+36>>2],e,d,-1,f+32|0);g=H[f+32>>2];v:while(1){if(!h){H[f+24>>2]=0;H[f+20>>2]=0;H[f+16>>2]=0;H[f+12>>2]=0;h=Ka[H[i+20>>2]](g,f+28|0,f+24|0,f+20|0,f+16|0,f+12|0)|0;if(h){continue}r=H[f+28>>2];k=H[f+24>>2];s=H[f+12>>2];n=Gq(r,k,e,0,l,q,b,s)^n;t=t^Ja;d=1;o=H[a+256>>2];o=(o|0)>1?o:1;while(1){if((d|0)==(o|0)){continue v}p=H[H[a+260>>2]+N(d,24)>>2];if((k|0)>=(p|0)){n=Gq(r,p,e,d,l,q,b,s)^n;t=t^Ja}d=d+1|0;continue}}break}if(g){Ka[H[i+16>>2]](g)|0}d=(h|0)==101?0:h;b=c;continue}}break}dd(H[f+36>>2]);break n}b=H[f+44>>2];continue}}H[m+12>>2]=(n|0)==(v|0)&(t|0)==(w|0);Ga=f+48|0;Ga=m+16|0;c=H[m+12>>2]|d?d:267;break d}if(!Fb(e,21068,6)){d=Ga-16|0;Ga=d;H[d+8>>2]=e+6;f=Jq(d+8|0);b=8;e=H[d+8>>2];h=I[e|0];w:{if((h|0)==44){c=1;if(!I[e+1|0]){break w}H[d+8>>2]=e+1;b=Jq(d+8|0);h=I[H[d+8>>2]]}c=1;if((b|0)<2|h){break w}H[d+12>>2]=0;x:{if(!I[a+237|0]){Tq(d+12|0,a);c=H[d+12>>2];if(c){break x}}c=gz(a,f,b)}tf(a)}Ga=d+16|0;break d}b=1;if(d>>>0<11){break e}if(Fb(e,21064,10)){break e}b=Ga-16|0;Ga=b;H[b+12>>2]=e+10;H[b+8>>2]=0;H[b+4>>2]=0;c=Jq(b+12|0);H[a+48>>2]=(c|0)==1?8:(c|0)>16?8:c;y:{if(!I[a+237|0]){Tq(b+8|0,a);c=H[b+8>>2];if(c){break y}}c=Pb(a,23,b+4|0,0);if(c){break y}c=H[b+4>>2];wc(c,1,2);wc(c,2,H[a+48>>2]);Ab(c);c=rb(c)}Ga=b+16|0;b=c}c=b}H[j+12>>2]=c;h=0;break a}if((ac(H[((e<<2)+c|0)+16>>2])|0)>=0){break b}H[j+12>>2]=19;break a}e=H[a+24>>2];f=e>>31<<3|e>>>29;e=(e<<3)+8|0;f=e>>>0<8?f+1|0:f;h=Ib(e,f);if(!h){H[j+12>>2]=7;h=0;break a}m=H[a+24>>2]+1|0;f=$a(h,0,m<<3);e=0;i=Ga-16|0;Ga=i;z:{if(H[a+268>>2]){break z}e=Pb(a,16,i+12|0,0);if(e){break z}e=H[i+12>>2];oh(e,1);Ab(e);e=rb(e)}Ga=i+16|0;H[j+12>>2]=e;if(e){break a}A:{if(H[a+40>>2]|(b|0)<2){break A}e=H[((H[a+24>>2]<<2)+c|0)+12>>2];if((gb(e)|0)==5){e=H[c+4>>2]}if((gb(e)|0)==5){break A}i=H[c>>2];if((gb(i)|0)!=5){i=ac(i);l=Ja;if((ac(e)|0)==(i|0)&(Ja|0)==(l|0)){break A}}B:{if(I[I[H[a+12>>2]+92|0]+30271|0]==5){e=Hy(a,e,j+8|0,f);break B}g=1;e=Gy(a,c,d)}H[j+12>>2]=e;if(e){break a}}e=f+(m<<2)|0;i=H[c>>2];if((gb(i)|0)!=5){i=Hy(a,i,j+8|0,f);H[j+12>>2]=i;k=!i}else{k=1}if(!(!k|(b|0)<2)){b=ac(H[((H[a+24>>2]<<2)+c|0)+16>>2]);C:{D:{if(g){break D}g=Gy(a,c,d);H[j+12>>2]=g;if(!g){break D}if(H[a+40>>2]|(g|0)!=19){break C}H[j+12>>2]=267;break C}d=Nq(a,0,b,H[d>>2],H[d+4>>2]);H[j+12>>2]=d;if(d){break C}d=2;while(1){E:{if((H[a+24>>2]+2|0)<=(d|0)){i=0;break E}g=d-2|0;if(!I[g+H[a+32>>2]|0]){m=(d<<2)+c|0;i=Mq(a,b,cb(H[m>>2]),g,e+(g<<2)|0);if(i){break E}g=bc(H[m>>2]);i=e+(H[a+24>>2]<<2)|0;H[i>>2]=g+H[i>>2]}d=d+1|0;continue}break}H[j+12>>2]=i}if(I[a+238|0]){Fy(j+12|0,a,e)}H[j+8>>2]=H[j+8>>2]+1}if(!I[a+236|0]){break a}Ey(j+12|0,a,e,f,H[j+8>>2])}Wa(h);tf(a);Ga=j+16|0;return H[j+12>>2]}function cD(a,b,c,d,e,f,g,h,i,j,k,l,m){var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;r=Ga-32|0;Ga=r;q=G[b+34>>1];o=H[a+8>>2];A=H[a>>2];n=H[b+28>>2];if(n&128){y=tc(b);E=J[y+50>>1]}else{E=1}a:{if(!(n&2048)){break a}B=(q|0)>0?q:0;q=f+1|0;s=1;while(1){n=0;while(1){if((n|0)!=(B|0)){u=H[b+4>>2]+N(n,12)|0;t=I[u+4|0]&15;b:{if(!t|G[b+32>>1]==(n|0)){break b}v=J[u+10>>1]&96;if(!(!v|x)){z=z+1|0;break b}if(!(v?1:!l|H[(n<<2)+l>>2]>=0)){break b}c:{d:{e:{f:{w=(i|0)==11?(t|0)==11?2:t:i;if((w|0)==5){if(!J[u+8>>1]|x){break f}t=Oc(b,n<<16>>16)+q|0;v=db(o,51,t);Qk(a,cd(b,u),t);bb(o,v);p=p+1|0;break b}if(!(((v|0)!=0|s)&1)){break b}t=Oc(b,n<<16>>16)+q|0;switch(w-1|0){case 0:case 2:break d;case 1:break e;default:break c}}t=Oc(b,n<<16>>16)+q|0}Rc(a);w=2}v=H[b>>2];H[r+4>>2]=H[u>>2];H[r>>2]=v;u=tb(A,5984,r);Xa(o,69,1299,w,t);Pc(o,u,-6);pb(o,1);break b}Va(o,50,t,j)}n=n+1|0;continue}break}if(!(p|z)|x){break a}x=1;s=0;if(!(I[b+28|0]&96)|(p|0)<=0){continue}Xk(a,q,b);continue}}q=H[b+16>>2];if(!(!q|I[A+33|0]&2)){H[a+52>>2]=f^-1;w=(i|0)==11?2:i;s=f+1|0;n=0;while(1){if(H[q>>2]>(n|0)){x=q+(n<<4)|0;p=H[x+8>>2];g:{if(l){if(!Mn(p,l,h)){break g}}if(!L){Vg(o,b,s);L=1}t=jb(a);p=nb(A,p,0);if(!I[A+87|0]){_e(a,p,t,16)}fb(A,p);h:{if((w|0)==4){Yb(o,j);w=4;break h}w=(w|0)==5?2:w;_i(a,275,w,H[x+12>>2],0,3)}lb(o,t)}n=n+1|0;continue}break}H[a+52>>2]=0}H[r+20>>2]=0;H[r+8>>2]=0;H[r+12>>2]=0;n=H[b+8>>2];H[r+16>>2]=n;l=b+8|0;i:{j:{if(!m){m=0;break j}if(!H[m>>2]){q=I[m+20|0];i=q?6:4;m=q?m:0;break j}if(!n){break j}p=0;while(1){if(n){p=p+1|0;n=H[n+20>>2];continue}break}H[r+8>>2]=1;H[r+16>>2]=p;s=yb(A,N(p,10),0);H[r+20>>2]=s;if(!s){break i}H[m+24>>2]=s;x=s+(p<<3)|0;t=0;q=m;while(1){if(!(!q|!H[q>>2])){p=0;n=l;u=H[q+28>>2];k:{if(!u){break k}while(1){n=H[n>>2];if(!(!n|(n|0)==(u|0))){p=p+1|0;n=n+20|0;continue}break}u=p+x|0;if(I[u|0]){break k}F[u|0]=1;u=s+(t<<3)|0;H[u+4>>2]=p;H[u>>2]=n;t=t+1|0}q=H[q+16>>2];continue}break}n=0;p=l;while(1){q=H[p>>2];if(!q){break j}if(!I[n+x|0]){p=s+(t<<3)|0;H[p+4>>2]=n;H[p>>2]=q;t=t+1|0}n=n+1|0;p=q+20|0;continue}}l:{m:{q=H[A+32>>2];if(q&24576){n:{if(q&8192){K=hj(a,b,128,0,0);q=1;if(K){break n}q=(gj(a,b,0,0)|0)!=0;break n}q=gj(a,b,0,0)}if(q){break m}}z=0;t=0;break l}z=H[a+44>>2]+1|0;H[a+44>>2]=z;Va(o,71,0,z);t=jb(a)}o:{if(!h){B=0;q=0;break o}B=0;q=0;if(y){break o}s=jb(a);n=i;if((n|0)==11){p=I[b+42|0];n=(p|0)==11?2:p}p:{if(!m){break p}q=Cr(m,0);if(q){n=I[q+20|0]?6:4}if((m|0)==(q|0)){q=m;break p}M=Sb(o,8)}if(!((i|0)==5|(n|0)!=5|(!H[l>>2]|M))){B=Sb(o,8)+1|0}if(g){Xa(o,53,f,s,g);pb(o,144)}Xa(o,30,d,s,f);q:{r:{s:{switch(n-1|0){default:n=2;case 0:case 1:case 2:Br(a,n,b);break r;case 4:if(z){ag(a);On(a,b,K,d,e,f,1,0,5,1,-1);Va(o,86,z,1);Q=1;n=1;break q}Q=1;n=0;if(!H[l>>2]){break q}ag(a);Es(a,b,d,e,0,-1);n=0;break q;case 5:FA(a,m,b,0,d);break;case 3:break s}}Yb(o,j)}n=0}R=n;lb(o,s);if(!(!m|(m|0)==(q|0))){S=Sb(o,8);break o}if(!B){B=0;break o}Y=Sb(o,8);bb(o,B-1|0)}Z=(g|0)!=0&(K|0)!=0;_=M+1|0;$=g+1|0;V=f^-1;T=f+1|0;l=r+8|0;t:{if(H[l>>2]){H[r+28>>2]=H[H[l+12>>2]+4>>2];l=H[l+12>>2];break t}H[r+28>>2]=0;l=l+8|0}p=H[l>>2];x=t;while(1){u:{v:{w:{if(p){s=H[r+28>>2];l=(s<<2)+c|0;if(!H[l>>2]){break u}x:{if(!m){break x}q=Cr(m,p);if(!M|(q|0)!=(m|0)){break x}bb(o,M);q=m}D=jb(a);if(!L){Vg(o,b,T);L=1}if(H[p+36>>2]){Va(o,75,0,H[l>>2]);H[a+52>>2]=V;TB(a,H[p+36>>2],D);H[a+52>>2]=0}C=e+s|0;W=H[l>>2];u=W+1|0;n=0;while(1){v=J[p+52>>1];if(v>>>0>n>>>0){y:{z:{A:{B:{C:{v=J[H[p+4>>2]+(n<<1)>>1];switch(v-65534|0){case 1:break A;case 0:break C;default:break B}}H[a+52>>2]=V;Qk(a,H[(H[p+40>>2]+(n<<4)|0)+8>>2],n+u|0);H[a+52>>2]=0;break y}if((v|0)!=J[b+32>>1]){break z}}Va(o,82,f,n+u|0);break y}Va(o,81,Oc(b,v<<16>>16)+T|0,n+u|0)}n=n+1|0;continue}break}Xa(o,97,u,v,H[l>>2]);if(!(!g|h)&(p|0)==(y|0)){break v}l=I[p+54|0];if(!l){break v}v=q?I[q+20|0]?6:4:(i|0)==11?(l|0)==11?2:l:i;D:{if(H[p+20>>2]|(p|0)!=(y|0)|(v|0)!=5|s){break D}l=H[A+32>>2];if(l&8192){if(hj(a,b,128,0,0)){break D}l=H[A+32>>2]}if(!(l&16384)){break v}if(H[b+48>>2]){break D}if(!Jh(b)){break v}}O=ob(o,26,C,D,u,J[p+50>>1]);s=u;P=(p|0)==(y|0);if(!P){s=Cc(a,E)}if(!g&(v|0)!=5){break w}if(!(I[b+28|0]&128)){Va(o,142,C,s);if(!g){break w}Xa(o,53,s,D,g);pb(o,144);break w}n=0;E:{if(P){break E}while(1){if(J[y+50>>1]<=n>>>0){break E}Xa(o,94,C,Cf(p,G[H[y+4>>2]+(n<<1)>>1]),n+s|0);n=n+1|0;continue}}if(!g){break w}aa=((I[p+55|0]|I[p+56|0]<<8)&3)==2?u:s;w=J[y+50>>1];l=w+H[o+108>>2]|0;n=0;U=52;while(1){if((w&65535)>>>0<=n>>>0){break w}w=nj(a,H[H[y+32>>2]+(n<<2)>>2]);X=(J[y+50>>1]-1|0)==(n|0);U=X?53:U;l=X?D:l;kb(o,U,Oc(b,G[H[y+4>>2]+(n<<1)>>1])+$|0,l,n+aa|0,w,-2);pb(o,144);n=n+1|0;w=J[y+50>>1];continue}}if(B){Yb(o,B);bb(o,Y)}if(R){Va(o,16,z,x);F:{if(!y){if(g){Xa(o,53,f,t,g);pb(o,144)}Xa(o,30,d,t,f);Br(a,2,b);break F}Yb(o,t)}lb(o,x)}G:{if(I[b+28|0]&128){break G}Xa(o,97,T,G[b+36>>1],H[(H[r+28>>2]<<2)+c>>2]);if(L){break G}Vg(o,b,0)}H[k>>2]=Q;break i}H:{I:{switch(v-1|0){case 0:case 1:case 2:cs(a,v,p);break H;case 5:FA(a,m,b,p,C);case 3:Yb(o,j);break H;default:break I}}l=H[o+108>>2];if(z){ag(a);R=R+1|0}J:{if(Z){db(o,167,d);On(a,b,K,d,e,s,E<<16>>16,0,5,P,C);db(o,168,d);break J}On(a,b,K,d,e,s,E<<16>>16,0,5,P,C)}Q=1;if(!z){break H}Va(o,86,z,1);v=Sb(o,8);lb(o,x);x=jb(a);if(H[p+36>>2]){Va(o,50,W,x)}w=l-O|0;while(1){if((w|0)>0){l=Nc(o,O);n=I[l|0];if((n|0)!=142){C=J[l+2>>1];kb(o,n,H[l+4>>2],F[n+33936|0]&1?x:H[l+8>>2],H[l+12>>2],H[l+16>>2],F[l+1|0]);pb(o,C)}O=O+1|0;w=w-1|0;continue}break}cs(a,2,p);bb(o,v)}lb(o,D);if((s|0)!=(u|0)){md(a,s,E)}if(!q|!S){break u}l=1;p=H[q+16>>2];if(!(!p|!H[p>>2])){l=!H[p+28>>2]}if(!l){break u}Yb(o,_);bb(o,S);S=0;break u}lb(o,D)}K:{if(H[r+8>>2]){l=H[r+12>>2]+1|0;H[r+12>>2]=l;if((l|0)>=H[r+16>>2]){H[r+28>>2]=l;p=0;break K}l=l<<3;H[r+28>>2]=H[(l+H[r+20>>2]|0)+4>>2];p=H[l+H[r+20>>2]>>2];break K}H[r+28>>2]=H[r+28>>2]+1;p=H[H[r+16>>2]+20>>2];H[r+16>>2]=p}continue}}Ga=r+32|0}function Ab(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;if(ct(a)){return kd(86788)|0}m=H[a>>2];a:{while(1){g=H[a>>2];b:{c:{d:{d=I[a+149|0];if((d|0)==2){break d}while(1){e:{switch((d&255)-1|0){case 0:if(I[a+150|0]&3){H[a+36>>2]=17;d=1;if(F[a+148|0]>=0){break c}d=tq(a);break c}d=H[g+184>>2];if(!d){H[g+296>>2]=0}if(!(!H[a+196>>2]|(I[g+177|0]|!(I[g+94|0]&130)))){vq(H[g>>2],a+136|0);d=H[g+184>>2]}H[g+184>>2]=d+1;b=I[a+150|0];if(!(b&64)){H[g+192>>2]=H[g+192>>2]+1;b=I[a+150|0]}if(b<<24>>24<0){H[g+188>>2]=H[g+188>>2]+1}F[a+149|0]=2;H[a+32>>2]=0;break d;case 2:break e;default:break d}}rb(a);d=I[a+149|0];continue}}f:{if(I[a+150|0]&12){b=0;e=0;q=0;k=0;l=Ga-16|0;Ga=l;n=H[a>>2];h=H[a+88>>2];r=h+40|0;d=1;d=(I[a+150|0]&12)!=4?F[n+35|0]&1:d;hi(r,8);H[a+120>>2]=0;g:{if(H[a+36>>2]==7){Mb(n);d=1;break g}w=(I[a+150|0]&12)==8;o=H[a+108>>2];h:{i=d?H[a+88>>2]+360|0:0;if(!i){break h}if(I[i+16|0]&16){k=H[i+8>>2];e=H[i+12>>2]>>>2|0}while(1){if((b|0)==(e|0)){break h}o=H[H[(b<<2)+k>>2]+4>>2]+o|0;b=b+1|0;continue}}s=a+104|0;j=H[a+32>>2];while(1){i:{c=j;j=c+1|0;if((c|0)>=(o|0)){H[a+36>>2]=0;d=101;b=c;break i}d=s;j:{b=c;f=H[a+108>>2];if((b|0)<(f|0)){break j}b=c-f|0;f=0;while(1){d=H[(f<<2)+k>>2];p=H[d+4>>2];if((p|0)>(b|0)){break j}f=f+1|0;b=b-p|0;continue}}q=H[d>>2];k:{if(!i){break k}t=N(b,20)+q|0;if(I[t+1|0]!=252){break k}f=0;d=(e|0)>0?e:0;p=e+1|0;u=p<<2;while(1){l:{if((d|0)!=(f|0)){if(H[(f<<2)+k>>2]!=H[t+16>>2]){break l}d=f}if((d|0)!=(e|0)){break k}d=Di(i,u,(e|0)!=0);H[a+36>>2]=d;if(d){d=1;break i}k=H[i+8>>2];H[k+(e<<2)>>2]=H[t+16>>2];H[i+12>>2]=u;G[i+16>>1]=J[i+16>>1]&62016|16;o=H[H[t+16>>2]+4>>2]+o|0;e=p;break k}f=f+1|0;continue}}d=0;if(!w){break i}f=I[N(b,20)+q|0];if((f|0)==185){break i}if((f|0)!=64|(c|0)<=0){continue}}break}H[a+32>>2]=j;H[l+12>>2]=b;H[l+8>>2]=q;if(d){break g}d=H[l+12>>2];i=H[l+8>>2];if(H[n+296>>2]){H[a+36>>2]=9;_c(a,Dg(9),0);d=1;break g}e=0;b=Ga-208|0;Ga=b;fd(b+184|0,0,0,0,1e9);f=10936;m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{s=i+N(d,20)|0;c=s;switch(F[c+1|0]+15|0){case 11:break n;case 10:break q;case 1:break r;case 4:break s;case 5:break t;case 3:break u;case 12:break v;case 2:break w;case 0:break x;case 8:break y;case 13:break z;case 7:break A;default:break p}}c=H[c+16>>2];H[b+16>>2]=J[c+6>>1];vb(b+184|0,15939,b+16|0);while(1){if(J[c+6>>1]>e>>>0){j=I[H[c+16>>2]+e|0];f=H[(c+(e<<2)|0)+20>>2];if(f){f=H[f>>2]}else{f=29357}x=b,y=ad(f,32112)?f:20120,H[x+8>>2]=y;H[b+4>>2]=j&2?24055:29357;H[b>>2]=j&1?24062:29357;vb(b+184|0,5735,b);e=e+1|0;continue}break}Bb(b+184|0,26644,1);break m}c=H[c+16>>2];e=I[c+4|0];H[b+32>>2]=H[c>>2];H[b+36>>2]=H[(e<<2)+32128>>2];vb(b+184|0,5995,b+32|0);break m}c=H[c+16>>2];e=H[c+32>>2];H[b+52>>2]=F[c|0];H[b+48>>2]=e;vb(b+184|0,24649,b+48|0);break m}c=H[H[c+16>>2]+4>>2];e=H[c+32>>2];H[b+68>>2]=F[c|0];H[b+64>>2]=e;vb(b+184|0,24649,b- -64|0);break m}c=H[c+16>>2];e=H[c+4>>2];H[b+80>>2]=H[c>>2];H[b+84>>2]=e;vb(b+184|0,14185,b+80|0);break m}H[b+96>>2]=H[c+16>>2];vb(b+184|0,16804,b+96|0);break m}M[b+112>>3]=M[H[c+16>>2]>>3];vb(b+184|0,11928,b+112|0);break m}c=H[c+16>>2];e=J[c+16>>1];if(e&2){c=c+8|0;break o}if(e&36){e=H[c+4>>2];H[b+144>>2]=H[c>>2];H[b+148>>2]=e;vb(b+184|0,14185,b+144|0);break m}if(e&8){M[b+128>>3]=M[c>>3];vb(b+184|0,11928,b+128|0);break m}f=e&1?19458:24814;break n}H[b+160>>2]=H[H[c+16>>2]+8>>2];vb(b+184|0,9393,b+160|0);break m}c=H[c+16>>2];f=H[c>>2];e=1;while(1){if(e>>>0<=f>>>0){H[b+180>>2]=H[c+(e<<2)>>2];H[b+176>>2]=(e|0)==1?91:44;vb(b+184|0,1832,b+176|0);e=e+1|0;continue}break}Bb(b+184|0,17703,1);break m}c=H[c+16>>2];break o}c=c+16|0}f=H[c>>2];if(!f){break m}}ke(b+184|0,f)}if(I[b+204|0]&7){Mb(n)}e=Wd(b+184|0);Ga=b+208|0;b=8;B:{if((I[a+150|0]&12)==8){b=i+N(d,20)|0;c=H[b+4>>2];Xc(r,c,c>>31);c=H[b+8>>2];Xc(h+80|0,c,c>>31);b=H[b+12>>2];Xc(h+120|0,b,b>>31);b=4;c=4;break B}Xc(r,d,d>>31);oe(h+80|0,H[(I[s|0]<<2)+32144>>2],-1,-1,1,0);c=i+N(d,20)|0;d=H[c+4>>2];Xc(h+120|0,d,d>>31);d=H[c+8>>2];Xc(h+160|0,d,d>>31);d=H[c+12>>2];Xc(h+200|0,d,d>>31);Xc(h+280|0,J[c+2>>1],0);dc(h+320|0);c=6}oe(N(c,40)+h|0,e,-1,-1,1,3);H[a+120>>2]=r;G[a+144>>1]=b;b=I[n+87|0];H[a+36>>2]=b?7:0;d=b?1:100}Ga=l+16|0;b=d;break f}H[g+196>>2]=H[g+196>>2]+1;b=Dx(a);H[g+196>>2]=H[g+196>>2]-1}if((b|0)==100){H[g+64>>2]=100;b=100;break b}c=H[a+140>>2];if(!!H[a+136>>2]&(c|0)>=0|(c|0)>0){Is(g,a)}d=101;C:{if((b|0)==101){if(!I[g+85|0]){break C}d=0;b=0;while(1){if(H[g+20>>2]>(d|0)){h=d<<4;c=H[(h+H[g+16>>2]|0)+4>>2];D:{if(!c){break D}Jb(c);e=H[Vc(c)+232>>2];if(e){c=H[e+12>>2];H[e+12>>2]=0}else{c=0}if((c|0)<=0){break D}e=H[g+268>>2];if(!e|b){break D}b=Ka[e|0](H[g+272>>2],g,H[h+H[g+16>>2]>>2],c)|0}d=d+1|0;continue}break}H[a+36>>2]=b;d=b?1:101;break C}d=b;if(F[a+148|0]>=0){break C}d=tq(a)}H[g+64>>2]=d;if((nd(H[a>>2],H[a+36>>2])|0)!=7){break c}H[a+36>>2]=7;d=F[a+148|0]>=0?d:7}b=H[g+72>>2]&d}if((b|0)!=17){break a}if((v|0)==50){return 17}f=H[a+32>>2];e=Ga-16|0;Ga=e;b=Cx(a);c=H[a>>2];h=fl(c,b,-1,I[a+148|0],a,e+12|0,0);E:{if(h){if((h|0)!=7){break E}Mb(c);break E}b=Ga-240|0;Ga=b;d=H[e+12>>2];i=Ya(b,d,240);c=Ya(d,a,240);b=Ya(a,i,240);j=H[c+8>>2];H[c+8>>2]=H[b+8>>2];H[b+8>>2]=j;j=H[c+4>>2];H[c+4>>2]=H[b+4>>2];H[b+4>>2]=j;j=H[c+196>>2];H[c+196>>2]=H[b+196>>2];H[b+196>>2]=j;j=H[c+200>>2];H[c+200>>2]=H[b+200>>2];H[b+200>>2]=j;H[b+224>>2]=H[c+224>>2];F[b+148|0]=I[c+148|0];Ya(b+160|0,c+160|0,36);H[b+180>>2]=H[b+180>>2]+1;Ga=i+240|0;b=0;while(1){if(G[d+16>>1]>(b|0)){c=N(b,40);sx(c+H[a+100>>2]|0,c+H[d+100>>2]|0);b=b+1|0;continue}break}H[d+36>>2]=0;yf(d)}Ga=e+16|0;F:{if(h){b=cb(H[m+288>>2]);_a(m,H[a+124>>2]);if(I[m+87|0]){break F}x=a,y=Xb(m,b),H[x+124>>2]=y;b=a;a=nd(m,h);H[b+36>>2]=a;return a|0}v=v+1|0;rb(a);if((f|0)<0){continue}F[a+147|0]=254;continue}break}b=7;H[a+36>>2]=7;H[a+124>>2]=0}return b|0}function po(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;k=Ga-160|0;Ga=k;a:{if(!(c|e)){break a}g=H[a+236>>2];if(!g){break a}p=H[a>>2];b:{c:{d:{if(!e){if(et(p,H[g>>2])){H[g+28>>2]=H[g+28>>2]|4096}t=p+177|0;if(!I[t|0]){break b}f=H[p+172>>2];if(!I[g+43|0]){break c}if(f){break d}H[g+20>>2]=0;break b}t=p+177|0;if(!I[t|0]){break b}}Za(a,29357,0);break a}H[g+20>>2]=f;if((f|0)!=1){break b}H[g+28>>2]=H[g+28>>2]|1}e:{if(!(d&65536)){break e}H[g+28>>2]=H[g+28>>2]|65536;while(1){if(G[g+34>>1]<=(h|0)){break e}f=H[g+4>>2];m=f+N(h,12)|0;i=I[m+4|0];if(i>>>0<=15){d=f+N(h,12)|0;c=H[d>>2];b=H[g>>2];if(I[d+10|0]&4){w=k,x=_l(d,29357),H[w+120>>2]=x;H[k+116>>2]=c;H[k+112>>2]=b;Za(a,28554,k+112|0);break a}H[k+100>>2]=c;H[k+96>>2]=b;Za(a,5842,k+96|0);break a}f=i&240;if((f|0)==16){F[m+5|0]=65}if(!(!(F[m+10|0]&1)|(i&15|G[g+32>>1]==(h|0)))){F[m+4|0]=f|2;H[g+28>>2]=H[g+28>>2]|2048}h=h+1|0;continue}}if(d&128){f=H[g+28>>2];if(f&8){Za(a,5385,0);break a}if(!(f&4)){H[k+80>>2]=H[g>>2];Za(a,6521,k+80|0);break a}H[g+28>>2]=f|640;h=0;m=Ga-16|0;Ga=m;r=H[a+8>>2];u=H[a>>2];if(!(I[u+178|0]&2)){while(1){if(G[g+34>>1]>(h|0)){i=H[g+4>>2]+N(h,12)|0;f:{if(!(F[i+10|0]&1)){break f}f=I[i+4|0];if(f&15){break f}F[i+4|0]=f&240|2}h=h+1|0;continue}break}H[g+28>>2]=H[g+28>>2]|2048}f=H[a+132>>2];if(f){fj(r,f,2)}g:{i=G[g+32>>1];h:{if((i|0)>=0){f=m+8|0;Oh(f,H[H[g+4>>2]+N(i&65535,12)>>2]);i:{f=sb(a,0,Ac(u,59,f,0));if(f){if(I[a+208|0]>=2){od(a,H[f+8>>2],g+32|0)}F[f+16|0]=I[a+206|0];G[g+32>>1]=65535;uj(a,0,0,0,f,I[g+42|0],0,0,0,0,2);if(!H[a+36>>2]){break i}}H[g+28>>2]=H[g+28>>2]&-129;break g}j=tc(g);break h}j=tc(g);h=1;l=1;while(1){if(J[j+50>>1]>h>>>0){j:{if(al(j,l,j,h)){G[j+52>>1]=J[j+52>>1]-1;break j}f=H[j+32>>2];H[f+(l<<2)>>2]=H[f+(h<<2)>>2];f=H[j+28>>2];F[f+l|0]=I[f+h|0];f=H[j+4>>2];G[f+(l<<1)>>1]=J[f+(h<<1)>>1];l=l+1|0}h=h+1|0;continue}break}G[j+50>>1]=l}i=I[j+55|0]|I[j+56|0]<<8;f=i|32;F[j+55|0]=f;F[j+56|0]=f>>>8;if(!(I[u+178|0]&2)){f=i|40;F[j+55|0]=f;F[j+56|0]=f>>>8}o=J[j+50>>1];G[j+52>>1]=o;k:{if(!r){break k}f=H[j+44>>2];if(!f){break k}Qs(r,f,8)}H[j+44>>2]=H[g+20>>2];h=g+8|0;while(1){l:{m:{i=H[h>>2];if(!i){h=0;f=G[g+34>>1];f=(f|0)>0?f:0;n=0;while(1){if((f|0)==(h|0)){break m}if(!gC(H[j+4>>2],o,h)){n=((J[(H[g+4>>2]+N(h,12)|0)+10>>1]^-1)>>>5&1)+n|0}h=h+1|0;continue}}if(((I[i+55|0]|I[i+56|0]<<8)&3)==2){break l}l=0;n=0;while(1){if((l|0)!=(o|0)){n=!al(i,J[i+50>>1],j,l)+n|0;l=l+1|0;continue}break}f=J[i+50>>1];if(!n){G[i+52>>1]=f;break l}if(fC(u,i,f+n|0)){break g}n=J[i+50>>1];l=0;while(1){if((l|0)==(o|0)){break l}if(!al(i,J[i+50>>1],j,l)){G[H[i+4>>2]+(n<<1)>>1]=J[H[j+4>>2]+(l<<1)>>1];H[H[i+32>>2]+(n<<2)>>2]=H[H[j+32>>2]+(l<<2)>>2];if(I[H[j+28>>2]+l|0]){f=I[i+55|0]|I[i+56|0]<<8|512;F[i+55|0]=f;F[i+56|0]=f>>>8}n=n+1|0}l=l+1|0;continue}}if(fC(u,j,n+o|0)){break g}h=0;while(1){if(G[g+34>>1]>(h|0)){f=H[j+4>>2];if(!(gC(f,o,h)|I[(H[g+4>>2]+N(h,12)|0)+10|0]&32)){G[f+(o<<1)>>1]=h;H[H[j+32>>2]+(o<<2)>>2]=32112;o=o+1|0}h=h+1|0;continue}break}Ys(j);break g}h=i+20|0;continue}}Ga=m+16|0}v=Lb(p,H[g+60>>2]);f=H[g+16>>2];n:{if(!f){break n}pj(a,g,4,0,f);if(!H[a+36>>2]){break n}qb(p,H[g+16>>2]);H[g+16>>2]=0}o:{if(!(I[g+28|0]&96)){break o}j=0;h=0;while(1){if(G[g+34>>1]>(h|0)){i=N(h,12);f=i+H[g+4>>2]|0;p:{if(I[f+10|0]&96){if(!pj(a,g,8,cd(g,f),0)){break p}fo(a,g,i+H[g+4>>2]|0,Ac(p,121,0,0));break p}j=j+1|0}h=h+1|0;continue}break}if(j){break o}Za(a,10434,0);break a}h=0;j=H[g+4>>2];l=G[g+34>>1];while(1){if((l|0)>0){l=l-1|0;h=I[j+6|0]+h|0;j=j+12|0;continue}break}w=g,x=je((J[g+32>>1]>>>15|0)+h<<2,0),G[w+40>>1]=x;h=g+8|0;while(1){f=H[h>>2];if(f){dt(f);h=f+20|0;continue}break}q:{if(!I[t|0]){q=zb(a);if(!q){break a}db(q,122,0);u=I[g+43|0];r:{if(e){if(I[a+208|0]){H[a+12>>2]=1;H[a+36>>2]=H[a+36>>2]+1;break a}t=H[a+44>>2];m=t+3|0;H[a+44>>2]=m;Rc(a);Xa(q,113,1,H[a+92>>2],v);pb(q,16);H[a+40>>2]=2;i=t+1|0;f=H[q+108>>2];Xa(q,10,i,0,f+1|0);if(H[a+36>>2]){break a}r=eo(a,e,65);if(!r){break a}d=J[r+34>>1];G[g+34>>1]=d;G[g+36>>1]=d;H[g+4>>2]=H[r+4>>2];H[r+4>>2]=0;G[r+34>>1]=0;ie(p,r);d=k+128|0;Pd(d,13,i);Sc(a,e,d);if(H[a+36>>2]){break a}oj(q,i);bb(q,f);f=db(q,11,H[k+132>>2]);d=t+2|0;Xa(q,97,H[k+140>>2],H[k+144>>2],d);Vg(q,g,0);Va(q,127,1,m);Xa(q,128,1,d,m);Yb(q,f);bb(q,f);db(q,122,1);n=0;d=0;s=Ga-16|0;Ga=s;i=G[g+34>>1];f=(i|0)>0?i:0;o=H[g+4>>2];while(1){if((f|0)!=(n|0)){n=n+1|0;d=(eC(H[o>>2])+d|0)+5|0;o=o+12|0;continue}break}d=eC(H[g>>2])+d|0;j=(d+N(i,6)|0)+35|0;i=Uc(0,j,j>>31);s:{if(!i){Mb(p);break s}d=(d|0)<50;t=d?26644:26643;f=d?24064:29329;h=Vd(j,i,29188,0);w=s,x=ib(h),H[w+12>>2]=x;dC(h,s+12|0,H[g>>2]);m=H[s+12>>2];F[m+h|0]=40;d=d?29357:29330;n=m+1|0;o=H[g+4>>2];l=0;while(1){r=h+n|0;m=j-n|0;if(G[g+34>>1]>(l|0)){w=s,x=ib(Vd(m,r,d,0))+n|0,H[w+12>>2]=x;dC(h,s+12|0,H[o>>2]);r=H[s+12>>2];d=H[(F[o+5|0]<<2)+48364>>2];m=ib(d);Ya(h+r|0,d,m);n=m+r|0;H[s+12>>2]=n;o=o+12|0;l=l+1|0;d=f;continue}break}H[s>>2]=t;Vd(m,r,8310,s)}Ga=s+16|0;break r}m=d?a+196|0:c;i=H[m>>2];f=H[a+188>>2];d=i-f|0;d=I[i|0]!=59?H[m+4>>2]+d|0:d;H[k+72>>2]=f;H[k+68>>2]=d;H[k+64>>2]=u?18023:19609;i=tb(p,5638,k- -64|0)}f=H[H[p+16>>2]+(v<<4)>>2];m=H[g>>2];d=H[a+92>>2];H[k+56>>2]=H[a+88>>2];H[k+52>>2]=i;H[k+48>>2]=d;H[k+44>>2]=m;H[k+40>>2]=m;H[k+36>>2]=u?1810:13584;H[k+32>>2]=f;nc(a,16011,k+32|0);_a(p,i);hg(a,v);t:{if(I[a+208|0]|!(I[g+28|0]&8)){break t}d=H[p+16>>2]+(v<<4)|0;if(H[H[d+12>>2]+72>>2]){break t}H[k+16>>2]=H[d>>2];nc(a,24366,k+16|0)}H[k>>2]=H[g>>2];Qh(q,v,tb(p,27155,k),0);if(!I[p+177|0]){break q}}if(td(H[g+60>>2]+8|0,H[g>>2],g)){Mb(p);break a}H[a+236>>2]=0;H[p+24>>2]=H[p+24>>2]|1;if(ad(H[g>>2],13948)){break q}H[H[g+60>>2]+72>>2]=g}if(I[g+43|0]|e){break a}H[g+44>>2]=(H[(H[b>>2]?b:c)>>2]-H[a+188>>2]|0)+13}Ga=k+160|0}function uj(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;m=Ga-224|0;Ga=m;n=H[a>>2];H[m+164>>2]=0;H[m+160>>2]=0;a:{if(H[a+36>>2]|I[a+208|0]==1&(k|0)!=2){break a}if(kf(a)){break a}if(cl(a,e)){break a}b:{c:{d:{e:{if(d){r=ig(a,b,c,m+164|0);if((r|0)<0){break a}f:{if(I[n+177|0]){break f}b=Ph(a,d);if(H[c+4>>2]|!b){break f}r=H[b+60>>2]==H[H[n+16>>2]+28>>2]?1:r}b=m+168|0;t=H[m+164>>2];bl(b,a,r,1513,t);$n(b,d);c=Df(a,0,d+8|0);if(!c){break a}if(!(H[H[n+16>>2]+28>>2]==H[c+60>>2]|(r|0)!=1)){H[m+144>>2]=H[c>>2];Za(a,28484,m+144|0);break d}s=0;if(!(I[c+28|0]&128)){break e}s=tc(c);break e}c=H[a+236>>2];if(!c){break a}r=Lb(n,H[c+60>>2]);s=0}o=H[n+16>>2];l=H[c>>2];if(!(Fb(l,17563,7)|!d|I[n+177|0])){H[m>>2]=l;Za(a,14584,m);break d}g:{switch(I[c+43|0]-1|0){case 1:Za(a,14525,0);break c;case 0:Za(a,14550,0);break c;default:break g}}q=o+(r<<4)|0;h:{i:{j:{if(t){p=vc(n,t);if(!p){break d}if(gl(a,p,1513,H[c>>2])){break c}if(I[a+208|0]>1){break h}k:{if(I[n+177|0]){break k}if(!Dc(n,p,0)){break k}H[m+128>>2]=p;Za(a,6744,m+128|0);break c}if(!Ff(n,p,H[q>>2])){break j}if(!j){H[m+112>>2]=p;Za(a,3424,m+112|0);break c}Fd(a,r);el(a);break c}p=c+8|0;b=1;while(1){j=H[p>>2];if(j){b=b+1|0;p=j+20|0;continue}break}H[m+100>>2]=b;H[m+96>>2]=l;p=tb(n,15776,m+96|0);if(!p){break d}if(!I[a+208|0]){break i}F[p+7|0]=I[p+7|0]+1}if(I[a+208|0]>1){break h}}b=(r|0)==1;j=H[q>>2];if(cc(a,18,b?8639:8658,0,j)){break c}if(cc(a,b?3:1,p,H[c>>2],j)){break c}}l:{if(!e){b=(H[c+4>>2]+N(G[c+34>>1],12)|0)-12|0;G[b+10>>1]=J[b+10>>1]|8;e=m+152|0;Oh(e,H[b>>2]);b=0;e=sb(a,0,Ac(n,59,e,0));if(!e){break b}mo(e,i,-1);break l}st(a,e,1513);if(H[a+36>>2]){break c}}i=0;j=H[e>>2];l=(j|0)>0?j:0;b=0;while(1){if((b|0)!=(l|0)){q=H[((b<<4)+e|0)+8>>2];if(I[q|0]==113){i=(ib(H[q+8>>2])+i|0)+1|0}b=b+1|0;continue}break}b=ib(p);l=Zs(n,j+(s?J[s+50>>1]:1)<<16>>16,(b+i|0)+1|0,m+160|0);m:{n:{if(I[n+87|0]){b=e;break n}j=H[m+160>>2];H[l>>2]=j;b=b+1|0;i=b+j|0;H[m+160>>2]=i;Ya(j,p,b);F[l+54|0]=f;H[l+12>>2]=c;u=k&3;b=u|((I[l+55|0]|I[l+56|0]<<8)&65524|((f|0)!=0)<<3);F[l+55|0]=b;F[l+56|0]=b>>>8;b=r<<4;H[l+24>>2]=H[(b+H[n+16>>2]|0)+12>>2];G[l+50>>1]=H[e>>2];if(h){pj(a,c,2,h,0);H[l+36>>2]=h}h=I[H[(b+o|0)+12>>2]+76|0];b=e;if(I[a+208|0]>=2){H[l+40>>2]=e;b=0}j=e+8|0;w=h>>>0>3;e=0;while(1){if(J[l+50>>1]>e>>>0){_s(H[j>>2]);h=0;pj(a,c,32,H[j>>2],0);if(H[a+36>>2]){break m}o=gg(H[j>>2]);o:{if(I[o|0]!=167){if(H[a+236>>2]==(c|0)){Za(a,3575,0);break m}if(!H[l+40>>2]){H[l+40>>2]=b;b=0}G[H[l+4>>2]+(e<<1)>>1]=65534;o=(I[l+55|0]|I[l+56|0]<<8)&65527;F[l+55|0]=o;F[l+56|0]=o>>>8;q=-2;break o}q=G[o+32>>1];p:{if((q|0)<0){q=G[c+32>>1];break p}v=N(q,12);o=H[c+4>>2];if(!(I[(v+o|0)+4|0]&15)){o=(I[l+55|0]|I[l+56|0]<<8)&65527;F[l+55|0]=o;F[l+56|0]=o>>>8;o=H[c+4>>2]}if(!(I[(o+v|0)+10|0]&32)){break p}o=I[l+55|0]|I[l+56|0]<<8|1024;F[l+55|0]=o;F[l+56|0]=o>>>8}G[H[l+4>>2]+(e<<1)>>1]=q}o=H[j>>2];q:{if(I[o|0]==113){q=H[o+8>>2];o=ib(q)+1|0;o=Ya(i,q,o)+o|0;H[m+160>>2]=o;break q}if((q|0)<0){o=i;i=0;break q}o=i;i=Of(H[c+4>>2]+N(q,12)|0)}i=i?i:32112;if(!I[n+177|0]){if(!nj(a,i)){break m}}H[H[l+32>>2]+(e<<2)>>2]=i;F[H[l+28>>2]+e|0]=w?I[j+8|0]:0;j=j+16|0;e=e+1|0;i=o;continue}break}r:{if(s){h=0;while(1){if(J[s+50>>1]<=h>>>0){break r}s:{if(al(l,J[l+50>>1],s,h)){G[l+52>>1]=J[l+52>>1]-1;break s}G[H[l+4>>2]+(e<<1)>>1]=J[H[s+4>>2]+(h<<1)>>1];H[H[l+32>>2]+(e<<2)>>2]=H[H[s+32>>2]+(h<<2)>>2];F[H[l+28>>2]+e|0]=I[H[s+28>>2]+h|0];e=e+1|0}h=h+1|0;continue}}G[H[l+4>>2]+(e<<1)>>1]=65535;H[H[l+32>>2]+(e<<2)>>2]=32112}ru(l);if(!H[a+236>>2]){dt(l)}Ys(l);t:{if(!d|J[l+52>>1]<G[c+34>>1]){break t}h=I[l+55|0]|I[l+56|0]<<8;e=h|32;F[l+55|0]=e;F[l+56|0]=e>>>8;e=0;i=G[c+34>>1];i=(i|0)>0?i:0;while(1){if((e|0)==(i|0)){break t}u:{if(G[c+32>>1]==(e|0)){break u}if((Cf(l,e<<16>>16)|0)>=0){break u}e=h&65503;F[l+55|0]=e;F[l+56|0]=e>>>8;break t}e=e+1|0;continue}}v:{w:{x:{if(H[a+236>>2]!=(c|0)){break x}e=c+8|0;while(1){h=H[e>>2];if(!h){break x}y:{j=J[h+50>>1];z:{if((j|0)!=J[l+50>>1]){break z}e=0;while(1){if((e|0)==(j|0)){break y}i=e<<1;if(J[i+H[h+4>>2]>>1]!=J[i+H[l+4>>2]>>1]){break z}i=e<<2;e=e+1|0;if(!hb(H[i+H[h+32>>2]>>2],H[i+H[l+32>>2]>>2])){continue}break}}e=h+20|0;continue}break}e=I[h+54|0];f=I[l+54|0];A:{if((e|0)==(f|0)){break A}if(!((e|0)==11|(f|0)==11)){H[m+80>>2]=0;Za(a,15518,m+80|0);e=I[h+54|0]}if((e&255)!=11){break A}F[h+54|0]=I[l+54|0]}if((k|0)==2){e=(I[h+55|0]|I[h+56|0]<<8)&65532|u;F[h+55|0]=e;F[h+56|0]=e>>>8}h=0;if(I[a+208|0]<2){break m}H[l+20>>2]=H[a+240>>2];break w}B:{if(I[a+208|0]>1){break B}if(I[n+177|0]){C:{if(!d){break C}H[l+44>>2]=H[n+172>>2];if(!su(l)){break C}h=0;Za(a,13812,0);x=a,y=ab(119527),H[x+12>>2]=y;break m}if(td(H[l+24>>2]+24|0,H[l>>2],l)){Mb(n);h=0;break m}H[n+24>>2]=H[n+24>>2]|1;break B}if(!(H[c+28>>2]&128?d:1)){break B}h=H[a+44>>2]+1|0;H[a+44>>2]=h;e=zb(a);if(!e){h=0;break n}Gd(a,1,r);x=l,y=Sb(e,184),H[x+44>>2]=y;Xa(e,147,r,h,2);if(g){g=H[t>>2];j=H[a+200>>2]+(H[a+196>>2]-g|0)|0;i=j-1|0;k=I[g+i|0];H[m+72>>2]=g;H[m+64>>2]=f?19543:29357;H[m+68>>2]=(k|0)==59?i:j;f=tb(n,5653,m- -64|0)}else{f=0}g=H[H[n+16>>2]+(r<<4)>>2];i=H[l>>2];j=H[c>>2];H[m+48>>2]=f;H[m+44>>2]=h;H[m+40>>2]=j;H[m+36>>2]=i;H[m+32>>2]=g;nc(a,21077,m+32|0);_a(n,f);if(d){_n(a,l,h);hg(a,r);H[m+16>>2]=H[l>>2];Qh(e,r,tb(n,26781,m+16|0),0);Va(e,166,0,1)}bb(e,H[l+44>>2])}if(!(I[n+177|0]?0:d)){H[l+20>>2]=H[c+8>>2];H[c+8>>2]=l;break v}h=0;if(I[a+208|0]<2){break n}}H[a+240>>2]=l}h=0;break b}if(!l){break b}}wl(n,l);break b}p=0}b=e}k=c+8|0;D:{while(1){c=k;e=H[c>>2];if(!e){break D}k=e+20|0;if(I[e+54|0]!=5){continue}break}while(1){a=H[k>>2];if(!a|I[a+54|0]==5){break D}H[c>>2]=a;H[e+20>>2]=H[a+20>>2];H[a+20>>2]=e;c=a+20|0;continue}}e=b}fb(n,h);qb(n,e);Ic(n,d);_a(n,p);Ga=m+224|0}function iq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,A=0,D=0,E=0,F=0;m=Ga-48|0;Ga=m;C(+a);n=x(1)|0;d=x(0)|0;a:{b:{e=n;g=e&2147483647;c:{if(g>>>0<=1074752122){if((e&1048575)==598523){break c}if(g>>>0<=1073928572){if((n|0)>0|(n|0)>=0){a=a+-1.5707963267341256;f=a+-6077100506506192e-26;M[b>>3]=f;M[b+8>>3]=a-f+-6077100506506192e-26;d=1;break a}a=a+1.5707963267341256;f=a+6077100506506192e-26;M[b>>3]=f;M[b+8>>3]=a-f+6077100506506192e-26;d=-1;break a}if((n|0)>0|(n|0)>=0){a=a+-3.1415926534682512;f=a+-1.2154201013012384e-10;M[b>>3]=f;M[b+8>>3]=a-f+-1.2154201013012384e-10;d=2;break a}a=a+3.1415926534682512;f=a+1.2154201013012384e-10;M[b>>3]=f;M[b+8>>3]=a-f+1.2154201013012384e-10;d=-2;break a}if(g>>>0<=1075594811){if(g>>>0<=1075183036){if((g|0)==1074977148){break c}if((n|0)>0|(n|0)>=0){a=a+-4.712388980202377;f=a+-1.8231301519518578e-10;M[b>>3]=f;M[b+8>>3]=a-f+-1.8231301519518578e-10;d=3;break a}a=a+4.712388980202377;f=a+1.8231301519518578e-10;M[b>>3]=f;M[b+8>>3]=a-f+1.8231301519518578e-10;d=-3;break a}if((g|0)==1075388923){break c}if((n|0)>0|(n|0)>=0){a=a+-6.2831853069365025;f=a+-2.430840202602477e-10;M[b>>3]=f;M[b+8>>3]=a-f+-2.430840202602477e-10;d=4;break a}a=a+6.2831853069365025;f=a+2.430840202602477e-10;M[b>>3]=f;M[b+8>>3]=a-f+2.430840202602477e-10;d=-4;break a}if(g>>>0>1094263290){break b}}j=a*.6366197723675814+6755399441055744+-6755399441055744;f=a+j*-1.5707963267341256;k=j*6077100506506192e-26;v=f-k;e=v<-.7853981633974483;if(P(j)<2147483648){d=~~j}else{d=-2147483648}d:{if(e){d=d-1|0;j=j+-1;k=j*6077100506506192e-26;f=a+j*-1.5707963267341256;break d}if(!(v>.7853981633974483)){break d}d=d+1|0;j=j+1;k=j*6077100506506192e-26;f=a+j*-1.5707963267341256}a=f-k;M[b>>3]=a;C(+a);c=x(1)|0;x(0)|0;e=g>>>20|0;e:{if((e-(c>>>20&2047)|0)<17){break e}k=f;a=j*6077100506303966e-26;f=f-a;k=j*20222662487959506e-37-(k-f-a);a=f-k;M[b>>3]=a;c=e;C(+a);e=x(1)|0;x(0)|0;if((c-(e>>>20&2047)|0)<50){break e}k=f;a=j*20222662487111665e-37;f=f-a;k=j*84784276603689e-45-(k-f-a);a=f-k;M[b>>3]=a}M[b+8>>3]=f-a-k;break a}if(g>>>0>=2146435072){a=a-a;M[b>>3]=a;M[b+8>>3]=a;d=0;break a}z(0,d|0);z(1,n&1048575|1096810496);a=+B();d=0;e=1;while(1){c=(m+16|0)+(d<<3)|0;if(P(a)<2147483648){d=~~a}else{d=-2147483648}f=+(d|0);M[c>>3]=f;a=(a-f)*16777216;d=1;c=e;e=0;if(c){continue}break}M[m+32>>3]=a;d=2;while(1){c=d;d=c-1|0;if(M[(m+16|0)+(c<<3)>>3]==0){continue}break}w=m+16|0;h=Ga-560|0;Ga=h;d=(g>>>20|0)-1046|0;g=(d-3|0)/24|0;t=(g|0)>0?g:0;g=N(t,-24)+d|0;p=H[14621];r=c+1|0;i=r-1|0;if((p+i|0)>=0){d=p+r|0;c=t-i|0;while(1){M[(h+320|0)+(e<<3)>>3]=(c|0)<0?0:+H[(c<<2)+58496>>2];c=c+1|0;e=e+1|0;if((d|0)!=(e|0)){continue}break}}q=g-24|0;d=0;u=(p|0)>0?p:0;e=(r|0)<=0;while(1){f:{if(e){a=0;break f}o=d+i|0;c=0;a=0;while(1){a=M[(c<<3)+w>>3]*M[(h+320|0)+(o-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}M[(d<<3)+h>>3]=a;c=(d|0)==(u|0);d=d+1|0;if(!c){continue}break}E=47-g|0;y=48-g|0;F=g-25|0;d=p;g:{while(1){a=M[(d<<3)+h>>3];c=0;e=d;l=(d|0)<=0;if(!l){while(1){o=(h+480|0)+(c<<2)|0;f=a*5.960464477539063e-8;h:{if(P(f)<2147483648){i=~~f;break h}i=-2147483648}f=+(i|0);a=f*-16777216+a;i:{if(P(a)<2147483648){i=~~a;break i}i=-2147483648}H[o>>2]=i;e=e-1|0;a=M[(e<<3)+h>>3]+f;c=c+1|0;if((c|0)!=(d|0)){continue}break}}a=pk(a,q);a=a+T(a*.125)*-8;j:{if(P(a)<2147483648){o=~~a;break j}o=-2147483648}a=a-+(o|0);k:{l:{m:{A=(q|0)<=0;n:{if(!A){c=(d<<2)+h|0;i=H[c+476>>2];e=i>>y;s=c;c=i-(e<<y)|0;H[s+476>>2]=c;o=e+o|0;i=c>>E;break n}if(q){break m}i=H[((d<<2)+h|0)+476>>2]>>23}if((i|0)<=0){break k}break l}i=2;if(a>=.5){break l}i=0;break k}c=0;e=0;if(!l){while(1){s=(h+480|0)+(c<<2)|0;D=H[s>>2];l=16777215;o:{p:{if(e){break p}l=16777216;if(D){break p}e=0;break o}H[s>>2]=l-D;e=1}c=c+1|0;if((c|0)!=(d|0)){continue}break}}q:{if(A){break q}c=8388607;r:{switch(F|0){case 1:c=4194303;break;case 0:break r;default:break q}}l=(d<<2)+h|0;H[l+476>>2]=H[l+476>>2]&c}o=o+1|0;if((i|0)!=2){break k}a=1-a;i=2;if(!e){break k}a=a-pk(1,q)}if(a==0){c=1;l=0;e=d;s:{if((d|0)<=(p|0)){break s}while(1){e=e-1|0;l=H[(h+480|0)+(e<<2)>>2]|l;if((e|0)>(p|0)){continue}break}if(!l){break s}g=q;while(1){g=g-24|0;d=d-1|0;if(!H[(h+480|0)+(d<<2)>>2]){continue}break}break g}while(1){e=c;c=c+1|0;if(!H[(h+480|0)+(p-e<<2)>>2]){continue}break}e=d+e|0;while(1){i=d+r|0;d=d+1|0;M[(h+320|0)+(i<<3)>>3]=H[(t+d<<2)+58496>>2];c=0;a=0;if((r|0)>0){while(1){a=M[(c<<3)+w>>3]*M[(h+320|0)+(i-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}M[(d<<3)+h>>3]=a;if((d|0)<(e|0)){continue}break}d=e;continue}break}a=pk(a,24-g|0);t:{if(a>=16777216){q=(h+480|0)+(d<<2)|0;f=a*5.960464477539063e-8;u:{if(P(f)<2147483648){c=~~f;break u}c=-2147483648}a=+(c|0)*-16777216+a;v:{if(P(a)<2147483648){e=~~a;break v}e=-2147483648}H[q>>2]=e;d=d+1|0;break t}if(P(a)<2147483648){c=~~a}else{c=-2147483648}g=q}H[(h+480|0)+(d<<2)>>2]=c}a=pk(1,g);if((d|0)>=0){e=d;while(1){c=e;M[(c<<3)+h>>3]=a*+H[(h+480|0)+(c<<2)>>2];e=c-1|0;a=a*5.960464477539063e-8;if(c){continue}break}g=0;e=d;while(1){q=g>>>0>u>>>0?u:g;c=0;a=0;while(1){a=M[(c<<3)+61264>>3]*M[(c+e<<3)+h>>3]+a;p=(c|0)!=(q|0);c=c+1|0;if(p){continue}break}M[(h+160|0)+(d-e<<3)>>3]=a;e=e-1|0;c=(d|0)!=(g|0);g=g+1|0;if(c){continue}break}}a=0;if((d|0)>=0){e=d;while(1){c=e;e=c-1|0;a=a+M[(h+160|0)+(c<<3)>>3];if(c){continue}break}}M[m>>3]=i?-a:a;a=M[h+160>>3]-a;c=1;if((d|0)>0){while(1){a=a+M[(h+160|0)+(c<<3)>>3];e=(d|0)!=(c|0);c=c+1|0;if(e){continue}break}}M[m+8>>3]=i?-a:a;Ga=h+560|0;d=o&7;a=M[m>>3];if((n|0)<0){M[b>>3]=-a;M[b+8>>3]=-M[m+8>>3];d=0-d|0;break a}M[b>>3]=a;M[b+8>>3]=M[m+8>>3]}Ga=m+48|0;return d}function hH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=H[a+12>>2];i=H[a+8>>2];k=H[a+4>>2];while(1){j=h;if((h|0)>=(i|0)){return 101}while(1){a:{if((i|0)<=(j|0)){break a}h=F[k+j|0];if(h&128|(I[h+54384|0]?(h|0)>=48:0)){break a}j=j+1|0;H[a+12>>2]=j;continue}break}h=j;while(1){b:{if((h|0)>=(i|0)){break b}m=F[h+k|0];if(!(m&128)&(!I[m+54384|0]|(m|0)<48)){break b}h=h+1|0;H[a+12>>2]=h;continue}break}if((h|0)<=(j|0)){continue}break}l=h-j|0;c:{if((l|0)<=H[a+24>>2]){h=H[a+20>>2];break c}h=l+20|0;H[a+24>>2]=h;h=Ae(H[a+20>>2],h);if(!h){return 7}H[a+20>>2]=h}o=k+j|0;k=h;m=c;c=0;g=Ga-48|0;Ga=g;d:{e:{if(l-21>>>0<=4294967277){break e}i=22;while(1){f:{if((c|0)!=(l|0)){h=I[c+o|0];if((h-65&255)>>>0<=25){h=h+32|0;break f}if((h-97&255)>>>0<26){break f}break e}F[g+43|0]=0;F[g+39|0]=0;F[g+40|0]=0;F[g+41|0]=0;F[g+42|0]=0;c=g+i|0;H[g+12>>2]=c+17;g:{if(I[c+17|0]!=115){break g}if(Rb(g+12|0,3920,4143,0)){break g}if(Rb(g+12|0,11539,11558,0)){break g}if(Rb(g+12|0,4143,4143,0)){break g}H[g+12>>2]=H[g+12>>2]+1}c=H[g+12>>2];h:{if(Rb(g+12|0,13875,13876,104)){break h}i:{if(!Rb(g+12|0,11513,29357,105)){if(!Rb(g+12|0,13936,29357,105)){break h}if((c|0)!=H[g+12>>2]){break i}break h}if((c|0)==H[g+12>>2]){break h}}if(Rb(g+12|0,17441,12487,0)){break h}if(Rb(g+12|0,17363,13673,0)){break h}if(Rb(g+12|0,11472,12129,0)){break h}j:{c=H[g+12>>2];if(qf(c)){h=I[c|0]==I[c+1|0]}else{h=0}if(!h){break j}h=I[c|0]-108|0;if(1<<h&16513?h>>>0<=14:0){break j}H[g+12>>2]=c+1;break h}if(!qz(c)){break h}if(!pz(c)){break h}c=c-1|0;H[g+12>>2]=c;F[c|0]=101}c=H[g+12>>2];k:{if(I[c|0]!=121){break k}if(!rz(c+1|0)){break k}F[c|0]=105}l:{m:{switch(F[c+1|0]-97|0){case 0:if(Rb(g+12|0,17413,12487,104)){break l}Rb(g+12|0,2848,10192,104);break l;case 2:if(Rb(g+12|0,13116,13979,104)){break l}Rb(g+12|0,17444,13988,104);break l;case 4:Rb(g+12|0,11462,12129,104);break l;case 6:Rb(g+12|0,10974,11794,104);break l;case 11:if(Rb(g+12|0,17362,13673,104)){break l}if(Rb(g+12|0,17540,11250,104)){break l}if(Rb(g+12|0,13073,2729,104)){break l}if(Rb(g+12|0,13367,14072,104)){break l}Rb(g+12|0,9409,3420,104);break l;case 14:if(Rb(g+12|0,11467,12129,104)){break l}if(Rb(g+12|0,17415,12487,104)){break l}Rb(g+12|0,17402,12487,104);break l;case 18:if(Rb(g+12|0,17557,11250,104)){break l}if(Rb(g+12|0,11481,12240,104)){break l}if(Rb(g+12|0,11941,10958,104)){break l}Rb(g+12|0,9401,3420,104);break l;case 19:break m;default:break l}}if(Rb(g+12|0,17551,11250,104)){break l}if(Rb(g+12|0,11475,12240,104)){break l}Rb(g+12|0,17366,13673,104)}n:{o:{p:{q:{r:{c=F[H[g+12>>2]];switch(c-105|0){case 1:case 2:break n;case 3:break p;case 0:break q;default:break r}}if((c|0)==115){break o}if((c|0)!=101){break n}if(Rb(g+12|0,11549,17177,104)){break n}if(Rb(g+12|0,17407,29357,104)){break n}Rb(g+12|0,17545,11250,104);break n}Rb(g+12|0,11543,17177,104);break n}if(Rb(g+12|0,11555,17177,104)){break n}Rb(g+12|0,11945,29357,104);break n}Rb(g+12|0,10701,29357,104)}s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{c=H[g+12>>2];switch(F[c+1|0]-97|0){case 21:case 25:break t;case 20:break u;case 19:break v;case 18:break w;case 14:break x;case 13:break y;case 11:break z;case 8:break A;case 4:break B;case 2:break C;case 0:break D;default:break s}}if(I[c|0]!=108){break s}c=c+2|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=101|I[c+2|0]!=110){break s}E:{switch(I[c+3|0]-97|0){case 0:case 4:break E;default:break s}}c=c+4|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=114){break s}c=c+2|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=99){break s}c=c+2|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=101|I[c+2|0]!=98|(I[c+3|0]|8)!=105){break s}c=c+4|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=116){break s}F:{switch(I[c+2|0]-97|0){case 0:c=c+3|0;if(!qe(c)){break s}H[g+12>>2]=c;break s;case 4:break F;default:break s}}if(Rb(g+12|0,13162,29357,106)){break s}if(Rb(g+12|0,10889,29357,106)){break s}Rb(g+12|0,13075,29357,106);break s}if(I[c|0]==117){c=c+2|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if((I[c+3|0]-115&255)>>>0>1){break s}Rb(g+12|0,11509,29357,106);break s}if(I[c|0]!=109|I[c+2|0]!=105){break s}c=c+3|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(Rb(g+12|0,17421,29357,106)){break s}Rb(g+12|0,11489,29357,106);break s}if(I[c|0]!=115|I[c+2|0]!=111){break s}c=c+3|0;if(!qe(c)){break s}H[g+12>>2]=c;break s}if(I[c|0]!=101|I[c+2|0]!=105){break s}c=c+3|0;if(!qe(c)){break s}H[g+12>>2]=c}c=H[g+12>>2];G:{if(I[c|0]!=101){break G}h=c+1|0;if(!qe(h)){if(!qz(h)){break G}if(pz(h)){break G}}H[g+12>>2]=h;c=h}if(!(!qe(c)|I[c|0]!=108|I[c+1|0]!=108)){c=c+1|0;H[g+12>>2]=c}h=ub(c);H[m>>2]=h;i=0;while(1){F[h+k|0]=i;i=I[c|0];if(!i){break d}h=h-1|0;c=c+1|0;continue}}F[(g+16|0)+i|0]=h;i=i-1|0;c=c+1|0;continue}}c=0;h=0;i=(l|0)>0?l:0;while(1){if((c|0)!=(i|0)){n=I[c+o|0];p=(n-65&255)>>>0<26;F[c+k|0]=p?n+32|0:n;h=p?h:(n-48&255)>>>0<10?1:h;c=c+1|0;continue}break}h=h?3:10;if((l|0)>h<<1){c=l-h|0;while(1){if((c|0)<(l|0)){F[h+k|0]=I[c+k|0];h=h+1|0;c=c+1|0;continue}break}i=h}F[i+k|0]=0;H[m>>2]=i}Ga=g+48|0;H[b>>2]=H[a+20>>2];H[d>>2]=j;H[e>>2]=H[a+12>>2];b=a;a=H[a+16>>2];H[b+16>>2]=a+1;H[f>>2]=a;return 0}function Si(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=O(0),q=0,r=0;e=$a(d,0,48);a:{if(!b){if(!Xm(a)){break a}return oA(a,e)}o=1;d=H[c>>2];b:{c:{if(gb(d)-1>>>0<=1){nA(e,Nb(d));break c}h=cb(d);if(!h){break b}i=Ga-16|0;Ga=i;f=Ga-32|0;Ga=f;l=I[h|0];H[f+8>>2]=f+20;H[f+4>>2]=f+24;H[f>>2]=f+28;d=1;j=h+((l|0)==45)|0;d:{if((Vm(j,15741,f)|0)!=3){break d}d=j+10|0;while(1){j=d;d=j+1|0;m=I[j|0];if(F[m+30016|0]&1|(m|0)==84){continue}break}if(or(j,e)){d=1;if(I[j|0]){break d}F[e+43|0]=0}F[e+42|0]=1;d=0;F[e+40|0]=0;j=H[f+28>>2];H[e+8>>2]=(l|0)==45?0-j|0:j;H[e+12>>2]=H[f+24>>2];H[e+16>>2]=H[f+20>>2];if(!I[e+44|0]){break d}zd(e)}Ga=f+32|0;e:{if(!d){break e}if(!or(h,e)){break e}f:{if(hb(h,1632)){break f}if(!Xm(a)){break f}k=oA(a,e);break e}k=1;if((Yd(h,i+8|0,ib(h),1)|0)<=0){break e}nA(e,M[i+8>>3]);k=0}Ga=i+16|0;if(k){break b}}d=1;q=(b|0)>1?b:1;while(1){if((d|0)!=(q|0)){b=(d<<2)+c|0;f=cb(H[b>>2]);bc(H[b>>2]);if(!f){break a}m=0;j=Ga+-64|0;Ga=j;g:{h:{i:{b=I[I[f|0]+29632|0];i=b-43|0;if(!(i>>>0>14|!(1<<i&32741))){l=1;while(1){b=f+l|0;h=I[b|0];if(!(!h|(h|0)==58|F[h+30016|0]&1)){l=l+1|0;continue}break}k=1;if((Yd(f,j+56|0,l,1)|0)<=0){break g}if(I[b|0]!=58){while(1){f=b;b=b+1|0;if(F[I[f|0]+30016|0]&1){continue}break}b=ib(f);if(b-11>>>0<4294967288){break g}h=b-1|0;i=I[h+f|0];zd(e);h=(i&223)==83?h:b;g=M[j+56>>3];r=g<0?-.5:.5;b=0;while(1){if((b|0)==6){break i}j:{i=b<<4;if((h|0)!=I[i+50496|0]){break j}if(Fb(i+50497|0,f,h)){break j}p=L[i+50504>>2];if(!(+O(-p)<g)|!(+p>g)){break j}k:{l:{m:{switch(b-4|0){case 0:Ri(e);F[e+40|0]=0;if(P(g)<2147483648){f=~~g}else{f=-2147483648}h=f+H[e+12>>2]|0;i=(((h|0)>0?-1:-12)+h|0)/12|0;H[e+8>>2]=i+H[e+8>>2];H[e+12>>2]=h+N(i,-12);g=g-+(f|0);break l;case 1:break m;default:break k}}Ri(e);F[e+40|0]=0;if(P(g)<2147483648){f=~~g}else{f=-2147483648}H[e+8>>2]=f+H[e+8>>2];g=g-+(f|0)}M[j+56>>3]=g}zd(e);g=g*1e3*+L[(b<<4)+50508>>2]+r;n:{if(P(g)<0x8000000000000000){h=P(g)>=1?~~(g>0?R(T(g*2.3283064365386963e-10),4294967295):U((g-+(~~g>>>0>>>0))*2.3283064365386963e-10))>>>0:0;f=~~g>>>0;break n}h=-2147483648;f=0}h=H[e+4>>2]+h|0;i=H[e>>2];f=i+f|0;H[e>>2]=f;H[e+4>>2]=f>>>0<i>>>0?h+1|0:h;k=0;break i}b=b+1|0;continue}}b=I[f|0];h=j+8|0;$a(h,0,48);if(or(f+(b-58>>>0<4294967286)|0,h)){break g}zd(j+8|0);f=I[f|0];b=H[j+8>>2];h=H[j+12>>2];zd(e);Wm(e);i=H[e+4>>2];l=H[e>>2];b=UK(b-432e5|0,h-(b>>>0<432e5)|0,864e5,0);h=(f|0)==45;k=h?0-b|0:b;f=l+k|0;l=i;i=Ja;b=l+(h?0-(i+((b|0)!=0)|0)|0:i)|0;H[e>>2]=f;H[e+4>>2]=f>>>0<k>>>0?b+1|0:b;k=0;break g}k=1;o:{switch(b-115|0){default:p:{switch(b-106|0){default:if((b|0)!=97){break g}if(Qb(f,9415)|(d|0)>1){break g}if(I[e+40|0]|!I[e+41|0]){break h}g=M[e+32>>3];if(!(g>=-21086676e4)|!(g<=253402300799)){break g}Wm(e);G[e+40>>1]=1;g=g*1e3+21086676e7+.5;q:{if(P(g)<0x8000000000000000){f=P(g)>=1?~~(g>0?R(T(g*2.3283064365386963e-10),4294967295):U((g-+(~~g>>>0>>>0))*2.3283064365386963e-10))>>>0:0;b=~~g>>>0;break q}f=-2147483648;b=0}H[e>>2]=b;H[e+4>>2]=f;k=0;break g;case 0:if(Qb(f,1365)|(d|0)>1|!I[e+40|0]){break g}if(I[e+41|0]){break h}break g;case 1:break g;case 2:break p}}if(Qb(f,13121)){break g}if(!Xm(a)){break g}k=kA(e,a);break g;case 2:if(!(Qb(f,11730)|!I[e+41|0])){if((d|0)>1){break g}g=M[e+32>>3]*1e3+21086676e7;if(!(g>=0)|!(g<4642690608e5)){break g}Wm(e);G[e+40>>1]=1;g=g+.5;r:{if(P(g)<0x8000000000000000){f=P(g)>=1?~~(g>0?R(T(g*2.3283064365386963e-10),4294967295):U((g-+(~~g>>>0>>>0))*2.3283064365386963e-10))>>>0:0;b=~~g>>>0;break r}f=-2147483648;b=0}H[e>>2]=b;H[e+4>>2]=f;k=0;break g}if(Qb(f,16811)){break g}if(!Xm(a)){break g}k=0;if(I[e+45|0]){break g}zd(e);n=j+16|0;b=H[e+4>>2];i=H[e>>2];f=i;l=0;while(1){$a(n,0,40);F[j+48|0]=1;k=b;b=m;m=b>>31;h=b;b=k-((f>>>0<b>>>0)+m|0)|0;f=f-h|0;H[j+8>>2]=f;H[j+12>>2]=b;k=kA(j+8|0,a);if(k){break g}zd(j+8|0);h=H[j+8>>2];m=h-i|0;if(m){k=l>>>0<3;l=l+1|0;if(k){continue}}break};k=0;$a(e+8|0,0,40);F[e+45|0]=1;F[e+40|0]=1;H[e>>2]=f;H[e+4>>2]=b;break g;case 4:if(Fb(f,28682,8)){break g}b=f+8|0;if((Yd(b,j+56|0,ib(b),1)|0)<=0){break g}g=M[j+56>>3];f=!(g<7);if(P(g)<2147483648){b=~~g}else{b=-2147483648}if(f|(b|0)<0|g!=+(b|0)){break g}Ri(e);k=0;F[e+40|0]=0;F[e+44|0]=0;zd(e);f=H[e+4>>2];i=f;h=b;b=f;f=H[e>>2];l=f+1296e5|0;b=l>>>0<1296e5?b+1|0:b;b=UK(TK(l,b,864e5,0),Ja,7,0);l=b;m=b>>>0>h>>>0;b=Ja;m=m&(b|0)>=0|(b|0)>0;n=m?l-7|0:l;b=SK(h-n|0,0-((h>>>0<n>>>0)+(m?b-(l>>>0<7)|0:b)|0)|0,864e5,0)+f|0;h=i+Ja|0;H[e>>2]=b;H[e+4>>2]=b>>>0<f>>>0?h+1|0:h;break i;case 1:case 3:break g;case 0:break o}}if(Fb(f,28777,9)|!(I[e+43|0]?1:I[e+40|0]|I[e+42|0])){break g}qr(e);F[e+43|0]=1;F[e+44|0]=0;H[e+32>>2]=0;H[e+36>>2]=0;H[e+20>>2]=0;H[e+24>>2]=0;k=0;G[e+40>>1]=0;b=f+9|0;if(!Qb(b,11565)){H[e+16>>2]=1;break g}if(!Qb(b,9242)){H[e+12>>2]=1;H[e+16>>2]=1;break g}k=(Qb(b,1371)|0)!=0;break g}Wm(e);break g}k=0;F[e+41|0]=0}Ga=j- -64|0;d=d+1|0;if(!k){continue}break b}break}zd(e);if(I[e+46|0]){break b}o=!mA(H[e>>2],H[e+4>>2])}return o}return 1}function MG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;r=Ga-16|0;Ga=r;if(!Bm(a,9547,H[c>>2],r+12|0)){if((b|0)>=2){k=cb(H[c+4>>2])}h=H[r+12>>2];a:{if(!H[h+16>>2]){Ci(a,29357,0,0);break a}x=H[h>>2];t=a;q=k?k:1543;i=Ga-48|0;Ga=i;b=H[h>>2];H[i+32>>2]=0;H[i+36>>2]=0;H[i+40>>2]=0;H[i+44>>2]=0;H[i+24>>2]=0;H[i+28>>2]=0;H[i+16>>2]=h;H[i+12>>2]=0;H[i+20>>2]=H[b+24>>2];b:{c:{d:{e:{a=H[h+92>>2];f:{g:{if(a){if(!ad(H[a+12>>2],q)){k=1;break g}cz(a);H[h+92>>2]=0}c=H[h+16>>2];a=Ga-16|0;Ga=a;H[a+12>>2]=0;uh(c,110,a+12|0);Ga=a+16|0;a=H[a+12>>2];H[h+24>>2]=a;H[i+24>>2]=a;k=0;a=0;h:{while(1){f=a+q|0;e=I[f|0];if(!e){break h}H[i+8>>2]=0;g=i+8|0;m=0;c=Ga-16|0;Ga=c;i:{j:{k:{j=e<<24>>24;e=j-108|0;if(e>>>0>13){break k}if(1<<e&12432){break i}if(e){if((e|0)!=2){break k}if(!I[b+236|0]){break j}break i}if(I[b+238|0]){break i}break j}l:{switch(j-97|0){case 1:case 2:break i;case 0:break l;default:break j}}if(I[b+236|0]){break i}}H[c>>2]=j;de(g,17291,c);m=1}Ga=c+16|0;if(!m){a=a+1|0;k=Cq(i+16|0,F[f|0])+k|0;continue}break}a=H[i+8>>2];fc(t,a,-1);Wa(a);break b}m=1;a=k>>>29|0;c=k<<3;e=ub(q);b=c+e|0;a=b>>>0<e>>>0?a+1|0:a;b=b+25|0;a=b>>>0<25?a+1|0:a;a=Xe(b,a);if(a){H[a+16>>2]=20;b=k<<2;H[(b+a|0)+20>>2]=b+24;b=(a+c|0)+24|0;H[a+12>>2]=b;H[a+4>>2]=k;Ya(b,q,e+1|0);F[a|0]=1}H[h+88>>2]=1;H[h+92>>2]=a;k=0;if(!a){break f}}c=0;b=a;m:{if(!I[a+1|0]){F[b+1|0]=1;a=b+20|0;c=111;break m}if(!I[b+2|0]){F[b+2|0]=1;a=(b+(H[b+4>>2]<<2)|0)+24|0;c=111;break m}a=Ib(H[b+4>>2]<<2,0);if(!a){a=0;break m}c=3;if(!H[b+8>>2]){break m}Ya(a,b+20|0,H[b+4>>2]<<2)}H[i+12>>2]=a;if(c){break e}}a=7;c=0;break d}v=H[i+12>>2];H[i+44>>2]=v;H[i+24>>2]=H[h+24>>2];b=Ga-32|0;Ga=b;s=H[h>>2];H[b+24>>2]=0;f=i+16|0;y=f+16|0;while(1){n:{o:{p:{q:{r:{s:{t:{u:{v:{if(d){break v}u=q+w|0;a=I[u|0];if(!a){break v}F[f+24|0]=a;w:{x:{y:{z:{A:{a=F[u|0];switch(a-108|0){case 0:break p;case 7:break q;case 1:case 3:case 5:case 6:break t;case 2:break x;case 4:break z;default:break A}}switch(a-97|0){case 1:break r;case 0:break w;case 2:break y;default:break u}}d=0;if(!m){break o}H[H[f+28>>2]>>2]=H[f+8>>2];break o}d=0;if(!m){break o}H[H[f+28>>2]>>2]=H[f+4>>2];break o}if(!m){break s}H[b+16>>2]=0;H[b+20>>2]=0;d=Bq(s,b+24|0,b+16|0,0,0);H[b+28>>2]=d;H[H[f+28>>2]>>2]=H[b+16>>2];break o}if(!m){break s}d=Bq(s,b+24|0,b+16|0,b+12|0,b+8|0);H[b+28>>2]=d;if(d){break o}a=H[b+20>>2];l=a;n=H[b+16>>2];o=TK(n,a,2,0);j=Ja;d=0;a=0;while(1){if(H[f+4>>2]<=(a|0)){break o}e=qd(H[b+12>>2],b)+H[b+12>>2]|0;H[b+12>>2]=e;if(e>>>0>K[b+8>>2]){d=267;H[b+28>>2]=267;break o}else{e=j;p=H[b>>2];g=p+o|0;A=H[f+28>>2]+(a<<2)|0,B=TK(g,g>>>0<p>>>0?e+1|0:e,n,l),H[A>>2]=B;a=a+1|0;continue}}}rb(H[b+24>>2]);Ga=b+32|0;a=d;break n}if((a|0)==121){break r}}a=H[h+16>>2];d=Am(h,0,0);H[b+28>>2]=d;if(d){break o}if(m){if(H[h+28>>2]){d=Bq(s,b+24|0,y,0,0);H[b+28>>2]=d;if(d){break o}}A=b,B=uh(a,112,f),H[A+28>>2]=B;Oq(h,b+28|0);d=H[b+28>>2];if(d){break o}}uh(a,113,f)}d=0;break o}$a(H[f+28>>2],0,Cq(f,a)<<2);d=oy(H[h+16>>2],f);H[b+28>>2]=d;break o}d=Am(h,0,0);H[b+28>>2]=d;if(d){break o}a=0;g=0;n=0;l=Xe(H[h+24>>2]<<4,0);d=7;B:{if(!l){break B}uh(H[h+16>>2],114,l);d=H[f+8>>2];d=(d|0)>0?d:0;while(1){if((d|0)==(g|0)){C:while(1){D:{o=0;g=0;if(H[f+4>>2]<=(n|0)){a=0;break D}while(1){E:{if(H[f+8>>2]<=(g|0)){p=0;break E}d=l+(g<<4)|0;a=zm(h,H[d>>2],n,d+8|0);if(a){break D}if(H[d+8>>2]){H[d+12>>2]=H[d+4>>2];ny(d);if(!H[d+8>>2]){a=267;break D}o=o+1|0}g=g+1|0;continue}break}while(1){F:{if((o|0)>0){g=0;a=H[f+8>>2];z=(a|0)>0?a:0;d=0;a=0;while(1){if((g|0)==(z|0)){break F}j=g<<4;e=l+j|0;G:{if(!H[e+8>>2]){a=0;break G}d=(H[(j+l|0)+12>>2]>=H[d+12>>2]?d:0)?d:e;H:{if(a){j=1;if(H[e+12>>2]!=H[e-4>>2]){break H}}j=a+1|0}a=j;p=(a|0)>(p|0)?a:p}g=g+1|0;continue}}H[H[f+28>>2]+(n<<2)>>2]=p;n=n+1|0;continue C}o=o-((ny(d)|0)!=0)|0;continue}}break}}else{e=l+(g<<4)|0;a=a-H[H[H[e>>2]+20>>2]+64>>2]|0;H[e+4>>2]=a;g=g+1|0;continue}break}Wa(l);d=a}H[b+28>>2]=d;break o}H[b>>2]=0;j=H[h+32>>2];g=H[h+36>>2];e=Ga-16|0;Ga=e;H[e+12>>2]=0;d=Pb(s,21,e+12|0,0);a=H[e+12>>2];I:{if(d){break I}Vb(a,1,j,g);if((Ab(a)|0)==100){d=0;if((ph(a,0)|0)==4){break I}}a=rb(a);d=a?a:267;a=0}H[b>>2]=a;Ga=e+16|0;H[b+28>>2]=d;e=H[b>>2];J:{if(d){break J}d=0;g=mf(e,0);j=g+_d(e,0)|0;a=0;while(1){if(H[f+4>>2]<=(a|0)){break J}g=Gm(g,j,b+16|0)+g|0;if(j>>>0<g>>>0){H[b+28>>2]=267}else{H[H[f+28>>2]+(a<<2)>>2]=H[b+16>>2];a=a+1|0;continue}break}d=267}rb(e)}A=f,B=H[f+28>>2]+(Cq(f,F[u|0])<<2)|0,H[A+28>>2]=B;w=w+1|0;continue}break}if(!k){b=H[h+92>>2];H[b+8>>2]=1;d=H[b+4>>2]<<2;Ya((d+b|0)+24|0,b+20|0,d)}if(!a){break c}}k=c;ne(t,a);if(!k){break b}Ka[k|0](H[i+12>>2]);break b}Ci(t,v,H[H[h+92>>2]+4>>2]<<2,c)}Ga=i+48|0;tf(x)}}Ga=r+16|0}function rk(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=H[a>>2];if(I[d+87|0]){H[a+36>>2]=7}c=H[a+212>>2];if(c){while(1){e=c;c=H[c+4>>2];if(c){continue}break}hv(e);H[a+220>>2]=0;H[a+212>>2]=0}gv(a);hi(H[a+88>>2],H[a+20>>2]);while(1){c=H[a+216>>2];if(c){H[a+216>>2]=H[c+4>>2];e=0;i=c+88|0;f=i+N(H[c+60>>2],40)|0;while(1){if(H[c+64>>2]>(e|0)){g=H[f+(e<<2)>>2];if(g){El(H[c>>2],g)}e=e+1|0;continue}break}hi(i,H[c+60>>2]);Fl(H[H[c>>2]>>2],c+40|0,-1,0);_a(H[H[c>>2]>>2],c);continue}break}if(H[a+232>>2]){Fl(H[a>>2],a+232|0,-1,0)}a:{b:{if(F[a+150|0]>=0){break b}iv(a);c=H[a+36>>2];c:{d:{if(!c){break d}e:{e=c&255;if(e>>>0>13){break e}b=1;if(!(1<<e&9856)){break e}e=I[a+150|0];c=c&255;if(!(!(e&64)|(c|0)!=9)){m=1;break c}if(!(!(e&32)|(c|0)!=13&(c|0)!=7)){h=2;break c}Gi(d,516);Dm(d);F[d+85|0]=1;H[a+40>>2]=0;H[a+44>>2]=0;m=1;if(!H[a+36>>2]){break d}break c}b=0;m=1;if(I[a+146|0]!=3){break c}}Ej(a,0);m=1}f:{g:{h:{if(!(!I[d+85|0]|(H[d+404>>2]?0:H[d+380>>2]>0)|H[d+192>>2]!=((I[a+150|0]^-1)>>>6&1))){i:{if(!(I[a+146|0]!=3|b?H[a+36>>2]:0)){c=1;j:{k:{if(Ej(a,1)){b=787;if(!(I[a+150|0]&64)){break k}break a}c=H[d+32>>2];b=H[d+36>>2];if(b&2){H[d+32>>2]=c;H[d+36>>2]=b&-3;b=11;break k}i=0;f=Ga-80|0;Ga=f;e=0;g=0;c=H[d+404>>2];H[d+404>>2]=0;while(1){if(!(H[d+380>>2]<=(g|0)|e)){e=0;b=H[H[c+(g<<2)>>2]+8>>2];l:{if(!b){break l}l=H[H[b>>2]+60>>2];if(!l){break l}e=Ka[l|0](b)|0;Hf(a,b)}g=g+1|0;continue}break}H[d+404>>2]=c;b=e;c=0;m:{while(1){if(b){break m}if(H[d+20>>2]>(c|0)){b=0;g=c<<4;e=H[(g+H[d+16>>2]|0)+4>>2];if((Pg(e)|0)==2){Jb(e);b=Vc(e);if(!(52>>>I[b+5|0]&1|I[(g+H[d+16>>2]|0)+8|0]==1)){j=!rr(b)+j|0}k=1;b=cw(b)}c=c+1|0;continue}break}n:{if(!k){break n}c=H[d+232>>2];if(!c){break n}b=531;if(Ka[c|0](H[d+228>>2])|0){break m}}b=0;o:{p:{e=Fw(H[H[d+16>>2]+4>>2]);q:{if(!ib(e)){c=0;break q}c=0;if((j|0)>1){break p}}while(1)if(!b&H[d+20>>2]>(c|0)){b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=bn(b,0)}else{b=0}c=c+1|0;continue}else{c=0;while(1){if(b){break m}if(H[d+20>>2]<=(c|0)){break o}b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=Hk(b,0)}else{b=0}c=c+1|0;continue}}}j=H[d>>2];H[f+76>>2]=0;b=ib(e);H[f+56>>2]=0;H[f+52>>2]=e;H[f+48>>2]=0;l=tb(d,17201,f+48|0);if(!l){b=7;break m}e=l+4|0;g=e+b|0;r:{s:{t:{u:{while(1){v:{if(!c){break v}if(c>>>0>100){break u}if((c|0)!=1){break v}H[f+32>>2]=e;Fc(13,7941,f+32|0)}Oe(4,f+68|0);b=H[f+68>>2];H[f>>2]=b>>>8;H[f+4>>2]=b&255;Vd(13,g,17992,f);b=pg(j,e,0,f+72|0);if(!b){c=c+1|0;if(H[f+72>>2]){continue}}break}if(b){break s}break t}H[f+16>>2]=e;Fc(13,7489,f+16|0);Pe(j,e,0)}c=0;b=fv(j,e,f+76|0,16406,0);if(b){break s}g=H[f+76>>2];w:{x:{while(1){if(H[d+20>>2]>(c|0)){b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];y:{if((Pg(b)|0)!=2){break y}k=H[H[H[b+4>>2]>>2]+188>>2];if(!k){break y}b=Bc(g,k,ib(k)+1|0,n,i);k=ib(k);if(b){break x}b=k+1|0;n=b+n|0;i=n>>>0<b>>>0?i+1|0:i}c=c+1|0;continue}break}if(fh(g)&1024){break w}b=Ge(g,2);if(!b){break w}gi(g);Pe(j,e,0);break s}gi(g);Pe(j,e,0);break s}b=0;c=0;z:{while(1){if(!b){if(H[d+20>>2]<=(c|0)){break z}b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=bn(b,e)}else{b=0}c=c+1|0;continue}break}gi(g);break s}gi(g);b=Pe(j,e,1);_a(d,l);if(b){break m}Md();c=0;while(1){if(H[d+20>>2]<=(c|0)){break r}b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){Hk(b,1)}c=c+1|0;continue}}_a(d,l);break m}Ld()}av(d,64);b=0}Ga=f+80|0;if(!b){break j}c=5;if((b|0)!=5){break k}b=5;if(I[a+150|0]&64){break a}}H[a+36>>2]=b;Gi(d,0);H[a+40>>2]=0;H[a+44>>2]=0;break i}H[d+512>>2]=0;H[d+516>>2]=0;H[d+520>>2]=0;H[d+524>>2]=0;b=H[d+36>>2];H[d+32>>2]=H[d+32>>2]&-524289;H[d+36>>2]=b;Lw(d);break i}Gi(d,0);H[a+40>>2]=0;H[a+44>>2]=0}c=0;H[d+504>>2]=0;if(!m){break h}break f}if(!m){break h}h=1;if(!H[a+36>>2]){break h}c=0;A:{switch(I[a+146|0]-2|0){case 1:break h;case 0:break A;default:break g}}h=2}c=h;h=0;if(!(!H[H[a>>2]+504>>2]|!H[a+48>>2])){e=0;g=0;i=H[a+48>>2]-1|0;h=H[a>>2];j=(c|0)!=2;while(1){if(H[h+20>>2]>(g|0)){f=H[(H[h+16>>2]+(g<<4)|0)+4>>2];if(f){B:{if(!j){b=ap(f,2,i);if(b){break B}}b=ap(f,1,i)}e=e?e:b}g=g+1|0;continue}break}H[h+504>>2]=H[h+504>>2]-1;H[a+48>>2]=0;C:{D:{if(!e){if((c|0)==2){e=Dj(h,2,i);if(e){break D}}e=Dj(h,1,i)}if((c|0)!=2){break C}}b=H[a+76>>2];H[h+512>>2]=H[a+72>>2];H[h+516>>2]=b;b=H[a+84>>2];H[h+520>>2]=H[a+80>>2];H[h+524>>2]=b}h=e}if(!h){break f}b=H[a+36>>2];if(!((b&255)!=19?b:0)){H[a+36>>2]=h;_a(d,H[a+124>>2]);H[a+124>>2]=0}}Gi(d,516);Dm(d);F[d+85|0]=1;H[a+40>>2]=0;H[a+44>>2]=0}if(!(I[a+150|0]&16)){break b}if((c|0)!=2){c=H[a+44>>2];b=H[a+40>>2]}else{c=0;b=0}cp(d,b,c);H[a+40>>2]=0;H[a+44>>2]=0}H[d+184>>2]=H[d+184>>2]-1;b=I[a+150|0];if(!(b&64)){H[d+192>>2]=H[d+192>>2]-1;b=I[a+150|0]}if(b<<24>>24<0){H[d+188>>2]=H[d+188>>2]-1}F[a+149|0]=3;if(!I[d+87|0]){return H[a+36>>2]==5?5:0}H[a+36>>2]=7;c=0}return c}function Qj(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;n=Ga-112|0;Ga=n;a:{b:{c:{if(b){i=I[b|0];if(!ad(b,22256)){g=!i;break b}if(i){break c}}g=1;if(Er(c)){break b}}q=0;if(!(f&128)){break a}}e=e|2;q=1}i=7;j=Ad(48,0);d:{if(!j){break d}H[j>>2]=c;F[j+8|0]=0;H[j+36>>2]=1;H[j+32>>2]=j;e:{f:{g:{h:{i:{j:{h=f&-769|512;p=(f&256)>>>8|0?q?h:g?h:f:f;if(!(!(p&64)&q|g|!(p&131072))){f=H[a+8>>2]+1|0;g=ib(b)+1|0;h=(f|0)>(g|0)?f:g;h=xc(h,h>>31);F[j+9|0]=1;if(!h){break e}k:{if(q){Ya(h,b,g);break k}i=lw(a,b,f,h);if((i|512)==512){break k}Wa(h);break e}f=70608;l:{while(1){f=H[f>>2];if(!f){break l}m:{i=H[f>>2];if(!(ad(h,Fp(i,0))|H[i>>2]!=(a|0))){i=H[c+20>>2];while(1){if((i|0)<=0){break m}i=i-1|0;g=H[(H[c+16>>2]+(i<<4)|0)+4>>2];if(!g|H[g+4>>2]!=(f|0)){continue}break}Wa(h);Wa(j);i=19;break d}f=f+72|0;continue}break}H[j+4>>2]=f;H[f+68>>2]=H[f+68>>2]+1}Wa(h);if(f){break j}}f=Ad(92,0);if(!f){i=7;break g}i=0;m=Ga-16|0;Ga=m;H[m+12>>2]=4096;h=H[a+4>>2];r=(h|0)>64?h:64;H[f>>2]=0;n:{o:{p:{q:{r:{s=e&2;if(s){if(!b){u=1;v=1;break q}if(!I[b|0]){v=1;i=b;break q}l=Xb(0,b);if(!l){break r}u=1;v=1;k=ib(l);break p}o=1;s:{if(!b){u=1;break s}if(!I[b|0]){i=b;break s}i=H[a+8>>2]+1|0;h=i<<1;l=Uc(0,h,h>>31);if(!l){break r}F[l|0]=0;g=p<<7>>31&1550;h=lw(a,b,i,l);k=ib(l);t=(ib(b)+b|0)+1|0;i=t;while(1){if(I[i|0]){i=(ub(i)+i|0)+1|0;i=(ub(i)+i|0)+1|0;continue}break}t:{u:{g=(h|0)==512?g:h;if(g){break u}o=(i-t|0)+1|0;if(H[a+8>>2]>=(k+8|0)){break t}g=xe(58663);if(g){break u}break t}_a(0,l);break n}i=b;break o}break o}g=7;break n}k=0}o=1}g=7;r=r+7&-8;h=Ad((((N(k,3)+(r<<1)|0)+o|0)+(H[a+4>>2]+7&-8)|0)+314|0,0);if(!h){_a(0,l);break n}g=h+288|0;H[h+64>>2]=g;H[h+228>>2]=h+240;g=g+(H[a+4>>2]+7&-8)|0;H[h+72>>2]=g;g=g+r|0;H[h+68>>2]=g;g=g+r|0;F[g|0]=h;F[g+1|0]=h>>>8;F[g+2|0]=h>>>16;F[g+3|0]=h>>>24;g=g+8|0;H[h+184>>2]=g;v:{w:{if((k|0)>0){g=(Ya(g,l,k)+k|0)+1|0;if(t){Ya(g,t,o)}else{o=1}g=g+o|0;H[h+188>>2]=g;g=Ya(g,l,k)+k|0;F[g|0]=45;F[g+1|0]=106;F[g+2|0]=111;F[g+3|0]=117;F[g+4|0]=114;F[g+5|0]=110;F[g+6|0]=97;F[g+7|0]=108;g=g+9|0;H[h+236>>2]=g;k=Ya(g,l,k)+k|0;F[k|0]=45;F[k+1|0]=119;F[k+2|0]=97;F[k+3|0]=108;break w}H[h+236>>2]=0;H[h+188>>2]=0;if(!k){break v}}_a(0,l)}H[h+152>>2]=p;H[h>>2]=a;k=0;x:{y:{z:{A:{if(!(!I[i|0]|u)){H[m+8>>2]=0;g=ff(a,H[h+184>>2],H[h+64>>2],p,m+8|0);a=H[m+8>>2];i=a>>>7&1;F[h+16|0]=i;if(g){break y}g=fh(H[h+64>>2]);l=a&1;B:{if(l){break B}Bp(h);a=H[h+156>>2];if(a>>>0<=K[m+12>>2]){break B}if(a>>>0>=8193){H[m+12>>2]=8192;break B}H[m+12>>2]=a}w=h,x=Zl(H[h+184>>2],11299,0),F[w+13|0]=x;C:{if(g&8192){break C}if(Zl(H[h+184>>2],13371,0)){break C}k=1;a=0;break z}p=1;break A}i=0}F[h+13|0]=1;F[h+17|0]=1;F[h+18|0]=4;l=p&1;a=1}g=ui(h,m+12|0,-1);if(g){break y}o=H[m+12>>2];g=$a(H[h+228>>2],0,48);H[g+40>>2]=h;H[g+36>>2]=s?0:14;F[g+33|0]=2;F[g+32|0]=!(s>>>1|0);H[g+24>>2]=1;H[g+28>>2]=88;H[g+16>>2]=100;H[g+20>>2]=1;g=iw(g,o);if(!g){break x}}$c(H[h+64>>2]);Mf(H[h+224>>2]);Wa(h);break n}H[h+160>>2]=1073741823;F[h+12|0]=a;F[h+19|0]=a;F[h+4|0]=a;F[h+15|0]=v;F[h+14|0]=l;F[h+7|0]=a;g=e&1;F[h+6|0]=!g;if(k){H[h+8>>2]=167903233}H[h+176>>2]=-1;H[h+180>>2]=-1;G[h+148>>1]=88;Bp(h);a=2;D:{if(!g){a=4;if(!(i|s)){break D}}F[h+5|0]=a}H[h+216>>2]=15;Xl(h);H[f>>2]=h;g=0}Ga=m+16|0;i=g;if(g){break h}i=H[c+52>>2];a=H[f>>2];H[a+136>>2]=H[c+48>>2];H[a+140>>2]=i;a=H[f>>2];i=$a(n,0,100);a=H[a+64>>2];if(H[a>>2]){a=Jc(a,i,100,0,0);i=(a|0)==522?0:a}else{i=0}if(i){break h}H[f+4>>2]=c;F[f+16|0]=e;a=H[f>>2];H[a+196>>2]=f;H[a+192>>2]=16;gh(H[a+64>>2],15,a+192|0);H[j+4>>2]=f;H[f+8>>2]=0;H[f+12>>2]=0;h=H[f>>2];if(I[h+14|0]){G[f+24>>1]=J[f+24>>1]|1}a=I[n+17|0]<<16|I[n+16|0]<<8;H[f+36>>2]=a;i=f+36|0;E:{if(!(a&a-1?0:a-65537>>>0>=4294902271)){e=0;H[i>>2]=0;if(!b|q){break E}F[f+17|0]=0;F[f+18|0]=0;break E}e=I[n+20|0];G[f+24>>1]=J[f+24>>1]|2;w=f,x=(eb(n+52|0)|0)!=0,F[w+17|0]=x;w=f,x=(eb(n- -64|0)|0)!=0,F[w+18|0]=x}i=ui(h,i,e);if(i){break h}H[f+68>>2]=1;H[f+40>>2]=H[f+36>>2]-e;if(!I[j+9|0]){break f}H[f+72>>2]=H[17652];H[17652]=f;break i}if(!I[j+9|0]){break f}}b=0;a=H[c+20>>2];a=(a|0)>0?a:0;while(1){if((a|0)==(b|0)){break f}e=H[(H[c+16>>2]+(b<<4)|0)+4>>2];if(!e|!I[e+9|0]){b=b+1|0;continue}else{while(1){b=e;e=H[b+28>>2];if(e){continue}break}a=H[j+4>>2];F:{if(a>>>0<K[b+4>>2]){H[j+24>>2]=b;e=b+28|0;c=0;b=j;break F}while(1){c=b;b=H[b+24>>2];if(!b){H[j+24>>2]=0;e=c+24|0;b=j;break F}if(a>>>0>K[b+4>>2]){continue}break}H[j+28>>2]=c;H[j+24>>2]=b;e=c+24|0;c=j}H[b+28>>2]=c;H[e>>2]=j;break f}}}a=H[f>>2];if(!a){break g}kw(a,0)}Wa(f);Wa(j);H[d>>2]=0;break d}H[d>>2]=j;i=0;if(!jw(j,0,0)){Lj(j,-2e3)}a=H[H[f>>2]+64>>2];if(!H[a>>2]){break d}gh(a,30,f+4|0);break d}Wa(j)}Ga=n+112|0;return i}function Zy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;p=Ga-16|0;Ga=p;H[p+12>>2]=0;q=1;t=c;while(1){a:{b:{c:{d:{e:{f:{g:{if(!g){H[p+8>>2]=0;H[p+4>>2]=0;v=p+8|0;j=p+4|0;h=0;u=Ga-16|0;Ga=u;H[a+24>>2]=0;i=t>>31&t;w=b;g=b;b=t;h:{i:{while(1){if((b|0)>0){if(Wy(F[g|0])){g=g+1|0;b=b-1|0;continue}else{i=b;break i}}break}h=101;if((t|0)>=0){break h}}l=g-w|0;b=0;while(1){j:{k:{l:{m:{if((b|0)!=4){m=b<<3;f=I[m+54740|0];if((i|0)<(f|0)){break j}if(Ob(g,H[m+54736>>2],f)){break j}H[u+12>>2]=10;if(!((b|0)!=3|I[g+4|0]!=47|(I[g+5|0]-48&255)>>>0>9)){f=f+1|0;f=dz(f+g|0,u+12|0)+f|0}n=F[f+g|0];k=n&255;n=Wy(n);if(n){break l}r=k-34|0;if(r>>>0>7|!(1<<r&193)){break m}break l}n:{o:{p:{b=I[g|0];switch(b-40|0){case 0:break n;case 1:break o;default:break p}}if((b|0)==34){f=(i|0)>1?i:1;b=1;while(1){q:{if((b|0)!=(f|0)){if(I[b+g|0]!=34){break q}f=b}h=1;H[j>>2]=((f-w|0)+g|0)+1;if((f|0)==(i|0)){break h}h=0;i=0;m=0;l=0;k=0;b=0;j=Ga-32|0;Ga=j;r=H[a>>2];n=H[r>>2];H[j+28>>2]=0;r:{s:{o=r;r=g+1|0;x=f-1|0;f=Ig(o,H[a+4>>2],r,x,j+28|0);t:{if(!f){g=H[j+28>>2];f=0;while(1){if(!f){H[j+20>>2]=0;H[j+16>>2]=0;H[j+12>>2]=0;H[j+8>>2]=0;f=Ka[H[n+20>>2]](g,j+24|0,j+20|0,j+16|0,j+12|0,j+8|0)|0;if(f){k=k+1|0;b=k?b:b+1|0;continue}h=SK(k,b,24,0)+144|0;i=Qq(i,h&-8,0);if(!i){break t}h=H[j+20>>2]+l|0;m=Qq(m,h,h>>31);if(m){h=(i+120|0)+N(k,24)|0;H[h>>2]=0;H[h+4>>2]=0;H[h+16>>2]=0;H[h+20>>2]=0;H[h+8>>2]=0;H[h+12>>2]=0;Ya(l+m|0,H[j+24>>2],H[j+20>>2]);y=H[j+20>>2];H[h+4>>2]=y;o=H[j+12>>2];if((x|0)>(o|0)){o=I[r+o|0]==42}else{o=0}H[h+8>>2]=o;l=l+y|0;o=H[j+16>>2];if((o|0)>0){o=I[(r+o|0)-1|0]==94}else{o=0}H[h+12>>2]=o;h=k+1|0;b=h?b:b+1|0;k=h;continue}else{m=0;break t}}break}Ka[H[n+16>>2]](g)|0;H[j+28>>2]=0}if((f|0)!=101){break r}g=N(h,24);i=Qq(i,(g+l|0)+144|0,0);if(i){break s}i=0;g=H[j+28>>2]}if(g){Ka[H[n+16>>2]](g)|0}Wa(m);Wa(i);f=7;i=0;break r}f=0;b=$a(i,0,120);k=b+48|0;H[b+20>>2]=k;H[b>>2]=5;n=H[a+20>>2];H[b+112>>2]=h;H[b+116>>2]=n;h=(g+k|0)+72|0;if(m){Ya(h,m,l);Wa(m);k=H[b+20>>2]}b=H[k+64>>2];b=(b|0)>0?b:0;while(1){if((b|0)!=(f|0)){g=N(f,24)+k|0;H[g+72>>2]=h;f=f+1|0;h=H[g+76>>2]+h|0;continue}break}f=0}H[v>>2]=i;Ga=j+32|0;h=f;break h}b=b+1|0;continue}}k=0;b=H[a+16>>2];m=(b|0)>0?b:0;f=H[a+20>>2];b=0;while(1){u:{v:{if((b|0)==(m|0)){b=f;break v}n=H[H[a+8>>2]+(b<<2)>>2];h=ub(n);if((h|0)>=(i|0)|I[g+h|0]!=58){break u}if(Fb(n,g,h)){break u}k=(h+l|0)+1|0}h=b;m=k+w|0;b=0;g=Ga-32|0;Ga=g;n=t-k|0;f=(n|0)>0?n:0;i=H[a>>2];r=H[i>>2];w:{x:{while(1){y:{z:{if((b|0)!=(f|0)){l=I[b+m|0]-34|0;if(l>>>0>7|!(1<<l&193)){break z}f=b}H[j>>2]=f;b=0;l=Ig(i,H[a+4>>2],m,f,g+28|0);if(l){break w}H[g+20>>2]=0;H[g+16>>2]=0;H[g+12>>2]=0;H[g+8>>2]=0;o=H[g+28>>2];i=Ka[H[r+20>>2]](o,g+24|0,g+20|0,g+16|0,g+12|0,g+8|0)|0;if(!i){b=Xe(H[g+20>>2]+144|0,0);if(!b){l=7;f=H[g+12>>2];break y}H[b>>2]=5;H[b+116>>2]=h;H[b+112>>2]=1;H[b+20>>2]=b+48;f=H[g+20>>2];h=b+144|0;H[b+120>>2]=h;H[b+124>>2]=f;Ya(h,H[g+24>>2],f);f=H[g+12>>2];if(!((n|0)<=(f|0)|I[f+m|0]!=42)){H[b+128>>2]=1;f=f+1|0;H[g+12>>2]=f}l=0;if(!H[a+12>>2]){break y}i=H[g+16>>2];while(1){if((i|0)<=0){break y}i=i-1|0;if(I[m+i|0]!=94){break y}H[b+132>>2]=1;H[g+16>>2]=i;continue}}l=f?(i|0)==101?0:i:i;break x}b=b+1|0;continue}break}H[j>>2]=f}Ka[H[r+16>>2]](o)|0}H[v>>2]=b;Ga=g+32|0;h=l;H[j>>2]=H[j>>2]+k;break h}b=b+1|0;continue}}H[a+32>>2]=H[a+32>>2]-1;H[j>>2]=l+1;H[v>>2]=0;h=101;break h}H[u+8>>2]=0;h=1;b=H[a+32>>2];H[a+32>>2]=b+1;if((b|0)>999){break h}h=Zy(a,g+1|0,i-1|0,v,u+8|0);H[j>>2]=(l+H[u+8>>2]|0)+1;break h}if(k){break k}}h=Xe(48,0);if(h){H[h>>2]=I[m+54742|0];H[h+4>>2]=H[u+12>>2];H[v>>2]=h;H[j>>2]=f+l;h=0}else{h=7}if(n){break h}}f=k-34|0;if(!k|(1<<f&193?f>>>0<=7:0)){break h}}b=b+1|0;continue}}Ga=u+16|0;g=h;if(g){break b}f=H[p+8>>2];if(!f){break b}k=H[f>>2];l=(k|0)!=5;if(!l){i=0;b=(q|0)!=0;g=1;break g}b=(q|0)!=0;h=H[f+12>>2];g=(h|0)!=0;i=!h;if(h|!q){break g}break f}f=H[p+12>>2];H[e>>2]=c-t;q=(g|0)==101?f?q?1:g:g:g;a=0;if((q|0)==101){break c}break d}A:{B:{C:{if(!(b|i)){b=Xe(48,0);if(b){break C}q=7;break e}if(s){break B}s=0;break A}H[b>>2]=3;Xy(p+12|0,s,b);s=b}if(!((k|0)!=1|g)&H[s>>2]!=5){break f}if(!(g&l)){break A}q=1;if(H[s>>2]==1){break e}}D:{E:{if(g){if(!H[p+12>>2]){break E}H[s+16>>2]=f;H[f+8>>2]=s;break D}Xy(p+12|0,s,f);break D}H[p+12>>2]=f}g=0;break a}q=1}of(f);f=H[p+12>>2]}of(f);f=0;of(0);a=q}H[d>>2]=f;Ga=p+16|0;return a}i=q;f=s}h=H[p+4>>2];b=h+w|0;t=t-h|0;q=i;s=f;continue}}function De(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0;k=Ga-96|0;Ga=k;t=h;u=i&65535;m=(e^i)&-2147483648;l=e&65535;p=l;v=l;J=i>>>16&32767;K=e>>>16&32767;a:{b:{if(J-32767>>>0>4294934529&K-32767>>>0>=4294934530){break b}l=e&2147483647;j=d;if(!(!d&(l|0)==2147418112?!(b|c):l>>>0<2147418112)){o=d;m=e|32768;break a}e=i&2147483647;if(!(!h&(e|0)==2147418112?!(f|g):e>>>0<2147418112)){o=h;m=i|32768;b=f;c=g;break a}if(!(b|j|(l^2147418112|c))){if(!(f|h|(e|g))){m=2147450880;b=0;c=0;break a}m=m|2147418112;b=0;c=0;break a}if(!(f|h|(e^2147418112|g))){d=b|j;e=c|l;b=0;c=0;if(!(d|e)){m=2147450880;break a}m=m|2147418112;break a}if(!(b|j|(c|l))){b=0;c=0;break a}if(!(f|h|(e|g))){b=0;c=0;break a}if((l|0)==65535|l>>>0<65535){j=b;h=!(d|p);i=h<<6;l=Q(h?b:d)+32|0;b=Q(h?c:p);b=i+((b|0)==32?l:b)|0;ud(k+80|0,j,c,d,p,b-15|0);s=16-b|0;d=H[k+88>>2];v=H[k+92>>2];c=H[k+84>>2];b=H[k+80>>2]}if(e>>>0>65535){break b}e=!(t|u);h=e<<6;i=Q(e?f:t)+32|0;e=Q(e?g:u);e=h+((e|0)==32?i:e)|0;ud(k- -64|0,f,g,t,u,e-15|0);s=(s-e|0)+16|0;t=H[k+72>>2];u=H[k+76>>2];f=H[k+64>>2];g=H[k+68>>2]}e=f;j=g<<15|e>>>17;h=e<<15;e=j;p=h&-32768;q=c;z=SK(p,0,c,0);c=Ja;x=c;A=e;i=0;j=SK(e,0,b,i);e=j+z|0;h=Ja+c|0;h=e>>>0<j>>>0?h+1|0:h;c=e;j=e;n=SK(b,i,p,i);l=0+n|0;e=Ja+e|0;e=l>>>0<n>>>0?e+1|0:e;y=l;n=l;l=e;B=(j|0)==(e|0)&r>>>0>n>>>0|e>>>0<j>>>0;r=d;L=SK(p,i,d,0);F=Ja;e=SK(q,i,A,i);d=e+L|0;j=Ja+F|0;n=d;d=d>>>0<e>>>0?j+1|0:j;e=t;j=u<<15|e>>>17;C=e<<15|g>>>17;g=SK(C,0,b,i);e=g+n|0;f=Ja+d|0;G=e;f=e>>>0<g>>>0?f+1|0:f;u=f;e=f;f=(h|0)==(x|0)&c>>>0<z>>>0|h>>>0<x>>>0;c=h+G|0;f=e+f|0;z=c;f=c>>>0<h>>>0?f+1|0:f;t=f;c=f;D=v|65536;v=w;M=SK(p,i,D,w);I=Ja;g=SK(r,o,A,i);f=g+M|0;e=Ja+I|0;N=f;e=f>>>0<g>>>0?e+1|0:e;w=e;E=j|-2147483648;x=0;g=SK(E,x,b,i);b=g+f|0;f=Ja+e|0;f=b>>>0<g>>>0?f+1|0:f;O=b;e=SK(C,o,q,i);b=b+e|0;p=f;j=f+Ja|0;P=b;g=b>>>0<e>>>0?j+1|0:j;f=0;b=f+z|0;e=c+P|0;e=b>>>0<f>>>0?e+1|0:e;R=b;c=b;b=b+B|0;B=e;f=b>>>0<c>>>0?e+1|0:e;c=f;s=((K+J|0)+s|0)-16383|0;j=SK(E,x,q,i);h=Ja;i=SK(D,v,A,i);e=i+j|0;f=Ja+h|0;f=e>>>0<i>>>0?f+1|0:f;i=(f|0)==(h|0)&e>>>0<j>>>0|f>>>0<h>>>0;h=e;q=i;i=SK(C,o,r,o);e=i+e|0;j=Ja+f|0;j=e>>>0<i>>>0?j+1|0:j;i=(f|0)==(j|0)&e>>>0<h>>>0|f>>>0>j>>>0;f=q+i|0;h=0;h=f>>>0<i>>>0?1:h;q=SK(E,x,D,v);i=q+f|0;f=Ja+h|0;f=i>>>0<q>>>0?f+1|0:f;q=e;h=j;A=i;e=(d|0)==(u|0)&n>>>0>G>>>0|d>>>0>u>>>0;d=e+((d|0)==(F|0)&n>>>0<L>>>0|d>>>0<F>>>0)|0;j=0;j=d>>>0<e>>>0?1:j;i=d;d=q+d|0;e=h+j|0;e=d>>>0<i>>>0?e+1|0:e;n=d;i=e;e=(e|0)==(h|0)&d>>>0<q>>>0|e>>>0<h>>>0;d=A+e|0;h=d>>>0<e>>>0?f+1|0:f;q=d;j=SK(C,o,D,v);e=Ja;r=SK(E,x,r,o);d=r+j|0;f=Ja+e|0;f=d>>>0<r>>>0?f+1|0:f;r=d;d=f;f=(e|0)==(f|0)&j>>>0>r>>>0|e>>>0>f>>>0;v=d+q|0;e=f+h|0;e=v>>>0<d>>>0?e+1|0:e;h=0;d=h+n|0;f=i+r|0;f=d>>>0<h>>>0?f+1|0:f;h=f;j=(i|0)==(f|0)&d>>>0<n>>>0|f>>>0<i>>>0;i=j+v|0;n=i;i=i>>>0<j>>>0?e+1|0:e;r=d;e=d;d=h;j=(p|0)==(w|0)&N>>>0>O>>>0|p>>>0<w>>>0;f=j+((w|0)==(I|0)&N>>>0<M>>>0|w>>>0<I>>>0)|0;h=0;j=f+((g|0)==(p|0)&O>>>0>P>>>0|g>>>0<p>>>0)|0;f=g+e|0;e=d+j|0;e=f>>>0<g>>>0?e+1|0:e;g=f;h=(d|0)==(e|0)&f>>>0<r>>>0|d>>>0>e>>>0;d=h+n|0;f=i;f=d>>>0<h>>>0?f+1|0:f;h=e;n=d;i=(t|0)==(B|0)&z>>>0>R>>>0|t>>>0>B>>>0;d=i+((t|0)==(u|0)&z>>>0<G>>>0|t>>>0<u>>>0)|0;j=0;j=d>>>0<i>>>0?1:j;i=d;d=d+g|0;e=e+j|0;e=d>>>0<i>>>0?e+1|0:e;h=(e|0)==(h|0)&d>>>0<g>>>0|e>>>0<h>>>0;g=n+h|0;f=g>>>0<h>>>0?f+1|0:f;h=g;i=f;c:{if(f&65536){s=s+1|0;break c}w=l>>>31|0;f=i<<1|h>>>31;h=g<<1|e>>>31;i=f;f=e<<1|d>>>31;d=d<<1|c>>>31;e=f;g=y;f=l<<1|g>>>31;y=g<<1;l=f;f=c<<1|b>>>31;b=b<<1|w;c=f}if((s|0)>=32767){m=m|2147418112;b=0;c=0;break a}d:{if((s|0)<=0){f=1-s|0;if(f>>>0>=128){b=0;c=0;break a}g=s+127|0;ud(k+48|0,y,l,b,c,g);ud(k+32|0,d,e,h,i,g);th(k+16|0,y,l,b,c,f);th(k,d,e,h,i,f);y=H[k+32>>2]|H[k+16>>2]|(H[k+48>>2]|H[k+56>>2]|(H[k+52>>2]|H[k+60>>2]))!=0;l=H[k+36>>2]|H[k+20>>2];b=H[k+40>>2]|H[k+24>>2];c=H[k+44>>2]|H[k+28>>2];d=H[k>>2];e=H[k+4>>2];f=H[k+8>>2];g=H[k+12>>2];break d}f=h;g=i&65535|s<<16}o=f|o;m=g|m;if(!(!b&(c|0)==-2147483648?!(l|y):(c|0)>0|(c|0)>=0)){b=d+1|0;j=b?e:e+1|0;c=j;f=(e|0)==(j|0)&b>>>0<d>>>0|e>>>0>j>>>0;d=f+o|0;e=m;o=d;m=d>>>0<f>>>0?e+1|0:e;break a}if(b|y|(c^-2147483648|l)){b=d;c=e;break a}j=m;c=d&1;b=c+d|0;f=b>>>0<c>>>0?e+1|0:e;c=f;e=(e|0)==(f|0)&b>>>0<d>>>0|e>>>0>f>>>0;d=e+o|0;o=d;m=d>>>0<e>>>0?j+1|0:j}H[a>>2]=b;H[a+4>>2]=c;H[a+8>>2]=o;H[a+12>>2]=m;Ga=k+96|0}function Ed(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;w=H[a+4>>2];k=H[a>>2];s=H[k>>2];f=H[k+8>>2];u=H[f+108>>2];d=I[a+48|0];while(1){if((d|0)>0){b=d-1|0;c=N(b,96)+a|0;e=H[c+824>>2];if(e){lb(f,H[c+792>>2]);H[c+792>>2]=0;H[e+16>>2]=H[f+108>>2];Xa(f,67,H[e+8>>2],H[e+12>>2],1);v=v+1|0}h=H[c+848>>2];a:{if(I[c+829|0]!=184){e=0;b:{if(!(I[h+41|0]&2)|(I[a+51|0]!=2|I[a+48|0]!=(d|0))){break b}d=H[h+32>>2];if(!(I[d+55|0]&128)){break b}g=J[h+30>>1];if(!g|G[H[d+8>>2]+(g<<1)>>1]<36){break b}e=H[k+44>>2]+1|0;d=0;while(1){if((d|0)!=(g|0)){Xa(f,94,H[c+776>>2],d,d+e|0);d=d+1|0;continue}break}H[k+44>>2]=(g+H[k+44>>2]|0)+1;e=ob(f,I[c+829|0]==37?20:23,H[c+776>>2],0,e,g);Va(f,8,1,H[c+836>>2])}d=H[c+792>>2];if(d){lb(f,d)}Xa(f,I[c+829|0],H[c+832>>2],H[c+836>>2],I[c+830|0]);pb(f,I[c+831|0]);if(H[c+804>>2]){lb(f,H[c+808>>2]);Va(f,60,H[c+804>>2],H[c+836>>2]-1|0)}if(!e){break a}bb(f,e);break a}d=H[c+792>>2];if(!d){break a}lb(f,d)}c:{if(!(I[h+41|0]&8)|H[c+840>>2]<=0){break c}lb(f,H[c+784>>2]);e=H[c+840>>2];d=(H[c+844>>2]+N(e,20)|0)-20|0;while(1){if((e|0)<=0){break c}bb(f,H[d+4>>2]+1|0);if(I[d+16|0]!=184){d:{if(!H[d+12>>2]){break d}g=H[h+40>>2]&263168;if(H[c+768>>2]){Va(f,24,H[d>>2],H[f+108>>2]+((g|0)==262144?3:2)|0)}if((g|0)!=262144){break d}ob(f,25,H[c+776>>2],H[f+108>>2]+2|0,H[d+8>>2],H[d+12>>2]);bb(f,H[d+4>>2]+1|0)}Va(f,I[d+16|0],H[d>>2],H[d+4>>2])}bb(f,H[d+4>>2]-1|0);d=d-20|0;e=e-1|0;continue}}lb(f,H[c+780>>2]);d=H[c+824>>2];if(d){Xa(f,67,H[d+8>>2],0,1)}d=H[c+788>>2];if(d){Yb(f,d);bb(f,H[c+788>>2]);bb(f,H[c+788>>2]-2|0)}d=H[c+816>>2];if(d){Va(f,60,H[c+812>>2]>>>1|0,d)}d=b;e=H[c+768>>2];if(!e){continue}b=H[h+40>>2];h=db(f,49,e);if(!(b&64)){db(f,136,H[c+772>>2])}e=b&8192;e:{f:{g:{if(!(b&512)){if(!e){break e}if(H[c+840>>2]){break g}break e}if(!e){break f}}b=H[c+840>>2];Xa(f,101,H[c+776>>2],H[b+44>>2],Lb(s,H[b+24>>2]));Od(k,b)}db(f,136,H[c+776>>2])}h:{if(I[c+829|0]==67){Va(f,9,H[c+832>>2],H[c+796>>2]);break h}Yb(f,H[c+796>>2])}bb(f,h);continue}break}if(H[a+68>>2]){LB(a)}d=a+768|0;while(1){if(I[a+48|0]>q>>>0){i:{if(H[d+56>>2]){b=0;e=0;j=0;h=Ga-80|0;Ga=h;m=H[d+80>>2];o=H[d+56>>2];c=H[a>>2];g=H[c+8>>2];n=H[a+4>>2];l=I[d+60|0];p=n+(l<<6)|0;H[h>>2]=H[H[p+24>>2]>>2];qc(c,1,6903,h);t=(q|0)>0?q:0;while(1){if((b|0)!=(t|0)){i=N(b,96)+a|0;r=H[i+848>>2];x=H[r+8>>2];r=H[r+12>>2];db(g,136,H[i+772>>2]);i=H[i+776>>2];if(i){db(g,136,i)}e=e|x;j=j|r;b=b+1|0;continue}break}b=n+(l<<6)|0;l=b+8|0;i=0;j:{if(I[b+44|0]&64){break j}n=(e|H[m+8>>2])^-1;j=(j|H[m+12>>2])^-1;b=0;while(1){if(H[a+100>>2]<=(b|0)){break j}e=H[a+112>>2]+N(b,48)|0;if(J[e+12>>1]!=8192?J[e+10>>1]&32770:0){break j}k:{if(n&H[e+40>>2]|j&H[e+44>>2]){break k}e=H[e>>2];if(I[e+4|0]&3){break k}i=he(c,i,nb(H[c>>2],e,0))}b=b+1|0;continue}}H[h+8>>2]=1;H[h+12>>2]=1;Ya(h+16|0,l,64);F[h+52|0]=0;F[c+26|0]=I[c+26|0]+1;l=Af(c,h+8|0,i,0,0,0,4096,0);if(l){n=H[d+4>>2];b=H[c+44>>2];j=b+1|0;H[c+44>>2]=j;t=H[l+32>>2];l:{m=H[p+24>>2];if(!(I[m+28|0]&128)){Qc(g,m,n,-1,j);e=1;break l}p=tc(m);e=J[p+50>>1];H[c+44>>2]=b+e;b=0;while(1){if((b|0)==(e|0)){break l}Qc(g,m,n,G[H[p+4>>2]+(b<<1)>>1],b+j|0);b=b+1|0;continue}}b=ob(g,63,H[o+4>>2],0,j,e);ob(g,28,H[o>>2],t,j,e);bb(g,b);Va(g,9,H[o+8>>2],H[o+12>>2]);Ed(l)}fb(H[c>>2],i);Mh(c);F[c+26|0]=I[c+26|0]-1;Ga=h+80|0;break i}b=(I[d+60|0]<<6)+w|0;if(I[b+45|0]&32){BB(k,H[d+32>>2],H[d+4>>2],H[b+40>>2],0);break i}h=H[b+24>>2];e=I[s+87|0];b=H[d+80>>2];c=H[b+40>>2];m:{if(c&576){b=b+32|0;break m}if(!(c&8192)){break i}b=d+72|0}c=H[b>>2];if(e|!c){break i}b=u;n:{if(!I[a+50|0]){break n}b=u;if(I[H[c+12>>2]+28|0]&128){break n}b=H[a+60>>2]}g=H[d+32>>2]+1|0;e=Nc(f,g);o=e+N(b-g|0,20)|0;i=H[d+4>>2];while(1){o:{if((i|0)!=H[e+4>>2]){break o}b=I[e|0];if((b|0)!=18){if((b|0)!=135){if((b|0)!=94){break o}b=H[e+8>>2];p:{if(I[h+28|0]&128){b=J[H[tc(h)+4>>2]+(b<<1)>>1];break p}b=b<<16>>16;g=0;q:{if(!(I[h+28|0]&32)){break q}while(1){if(b<<16>>16<(g|0)){break q}b=(J[(H[h+4>>2]+N(g,12)|0)+10>>1]>>>5&1)+b|0;g=g+1|0;continue}}b=b<<16>>16}b=Cf(c,b<<16>>16);if((b|0)<0){break o}H[e+8>>2]=b&65535;H[e+4>>2]=H[d+8>>2];break o}b=H[d+8>>2];F[e|0]=142;H[e+4>>2]=b;break o}H[e+4>>2]=H[d+8>>2]}e=e+20|0;if(o>>>0>e>>>0){continue}break}}d=d+96|0;q=q+1|0;continue}break}lb(f,H[a+36>>2]);H[k+136>>2]=H[a+40>>2];KB(s,a);F[k+26|0]=I[k+26|0]-v}function Lq(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;i=Ga-96|0;Ga=i;H[i+92>>2]=0;H[i+88>>2]=0;H[i+8>>2]=0;H[i+12>>2]=0;e=Mi(a,b,c,d,0,0,1,0,i+16|0);a:{if(e){break a}k=H[i+20>>2];if(!k){break a}b:{c:{if((d|0)==-1){break c}f=Ga-16|0;Ga=f;e=Pb(a,15,f+12|0,0);if(!e){e=H[f+12>>2];Vb(e,1,rf(a,b,c,0),Ja);Vb(e,2,rf(a,b,c,1023),Ja);if((Ab(e)|0)==100){y=i,z=ed(e,0),H[y+8>>2]=z;H[i+12>>2]=Ja}e=rb(e)}Ga=f+16|0;if(e){break a}if((d|0)!=-2){break c}if(!(H[H[H[i+16>>2]>>2]+56>>2]|(k|0)!=1)){e=101;break a}H[i+80>>2]=0;H[i+84>>2]=0;H[i+72>>2]=0;H[i+76>>2]=0;q=H[i+12>>2];u=q;v=H[i+8>>2];r=v;e=3;break b}j=d+1|0;r=rf(a,b,c,j);q=Ja;f=0;k=Ga-16|0;Ga=k;h=Pb(a,8,k+12|0,0);d:{if(h){break d}e=H[k+12>>2];Vb(e,1,rf(a,b,c,j),Ja);if((Ab(e)|0)==100){f=Qd(e,0)}h=rb(e);if(h){break d}h=0;e=i;if((f|0)>=16){h=Lq(a,b,c,j);f=0}H[e+92>>2]=f}Ga=k+16|0;e=h;if(e){break a}H[i+80>>2]=0;H[i+84>>2]=0;H[i+72>>2]=0;H[i+76>>2]=0;u=H[i+12>>2];e=u;v=H[i+8>>2];e=(d|0)==-1?1:(q|0)<=(e|0)&r>>>0<=v>>>0|(e|0)>(q|0)?1:3}H[i+84>>2]=e;e=xk(a,i+16|0,i+72|0);while(1){e:{f:{g:{if(e){break g}e=Li(a,i+16|0);if((e|0)==100){break f}if(e){break g}if((d|0)!=-1){k=H[i+16>>2];h=H[i+20>>2];g=0;e=0;f=Ga-16|0;Ga=f;H[f+12>>2]=0;while(1){if(!((g|0)>=(h|0)|e)){e=zy(a,H[k+(g<<2)>>2]);g=g+1|0;continue}break}h:{if(e){break h}i:{if((d|0)==-2){e=Pb(a,26,f+12|0,0);if(e){break h}g=H[f+12>>2];Vb(g,1,rf(a,b,c,0),Ja);Vb(g,2,rf(a,b,c,1023),Ja);break i}e=Pb(a,16,f+12|0,0);if(e){break h}g=H[f+12>>2];Vb(g,1,rf(a,b,c,d),Ja)}Ab(g);e=rb(g)}Ga=f+16|0;g=H[i+88>>2];if(!g|e){break a}break e}g=H[i+88>>2];if(g){break e}g=0;e=0;break a}g=H[i+88>>2];break a}l=H[i+56>>2];k=H[i+60>>2];w=H[i+64>>2];p=H[i+68>>2];o=Ga-16|0;Ga=o;h=H[i+88>>2];j:{if(!h){f=7;h=Ub(64);if(!h){break j}e=$a(h,0,64);H[i+88>>2]=e;j=Ub(H[a+232>>2]);H[e+48>>2]=j;if(!j){break j}H[e+40>>2]=H[a+232>>2];f=Pb(a,10,o+12|0,0);if(f){break j}f=H[o+12>>2];if((Ab(f)|0)==100){j=ed(f,0);H[e+8>>2]=j;m=Ja;H[e+12>>2]=m;H[e+16>>2]=j;H[e+20>>2]=m}f=rb(f);if(f){break j}}g=H[h+44>>2];f=267;m=tk(H[h+24>>2],H[h+28>>2],l,k);e=k-m|0;if((e|0)<=0){break j}j=ce(m,m>>31);n=p>>31;t=n;x=ce(e,0);s=ce(p,n)+p|0;n=x+(j+(s+e|0)|0)|0;if(!((g|0)<=0|H[a+232>>2]>=(g+n|0))){e=H[h+20>>2];j=e;n=H[h+16>>2];if((n|0)==-1&(e|0)==2147483647){break j}e=j;f=n+1|0;e=f?e:e+1|0;H[h+16>>2]=f;H[h+20>>2]=e;f=Hg(a,n,j,H[h+48>>2],g);if(f){break j}H[a+52>>2]=H[a+52>>2]+1;f=Iq(a,h,l,m+1|0);if(f){break j}g=0;H[h+28>>2]=0;n=(ce(k,k>>31)+(k+s|0)|0)+1|0;m=0;e=k}j=H[h+60>>2]+(n>>31)|0;f=n+H[h+56>>2]|0;j=f>>>0<n>>>0?j+1|0:j;H[h+56>>2]=f;H[h+60>>2]=j;f=H[h+48>>2];k:{if(H[h+40>>2]<(n|0)){f=Ae(f,n);if(!f){break k}H[h+40>>2]=n;H[h+48>>2]=f}f=pc(f+g|0,m,m>>31)+g|0;f=f+pc(f+H[h+48>>2]|0,e,e>>31)|0;Ya(f+H[h+48>>2]|0,l+m|0,e);e=e+f|0;e=e+pc(e+H[h+48>>2]|0,p,t)|0;Ya(e+H[h+48>>2]|0,w,p);H[h+44>>2]=e+p;l:{if((k|0)<=H[h+32>>2]){f=H[h+24>>2];break l}e=k<<1;f=Ae(H[h+36>>2],e);if(!f){break k}H[h+36>>2]=f;H[h+32>>2]=e;H[h+24>>2]=f}Ya(f,l,k);H[h+28>>2]=k;f=0;break j}f=7}Ga=o+16|0;e=f;continue}break}w=H[i+92>>2];l=Ga-16|0;Ga=l;m:{if(H[g>>2]){H[l+8>>2]=0;H[l+12>>2]=0;H[l+4>>2]=0;H[l>>2]=0;t=H[g+20>>2];b=t;s=H[g+16>>2];c=s+1|0;b=c?b:b+1|0;H[g+16>>2]=c;H[g+20>>2]=b;c=Hg(a,s,t,H[g+48>>2],H[g+44>>2]);if(c){break m}c=H[g>>2];m=H[g+8>>2];j=H[g+12>>2];b=H[g+16>>2];k=H[g+20>>2];h=1;while(1){n:{if(!H[c>>2]){e=wy(c,h,m,j);H[l+8>>2]=b-1;H[l+12>>2]=k-!b;H[l>>2]=H[c+32>>2]-e;H[l+4>>2]=e+H[c+36>>2];e=0;break n}n=c+8|0;e=0;p=b;f=k;while(1){o=H[n>>2];if(!(!o|e)){n=o+4|0;e=wy(o,h,m,j);e=Hg(a,p,f,e+H[o+36>>2]|0,H[o+32>>2]-e|0);o=H[o+12>>2]+1|0;m=o+m|0;j=(o>>31)+j|0;j=m>>>0<o>>>0?j+1|0:j;p=p+1|0;f=p?f:f+1|0;continue}break}if(e){break n}h=h+1|0;c=H[c>>2];m=b;j=k;b=p;k=f;continue}break}c=e;if(e){break m}c=Hq(a,r,q,w,H[g+8>>2],H[g+12>>2],s,t,H[l+8>>2],H[l+12>>2],H[g+56>>2],H[g+60>>2],H[l+4>>2],H[l>>2]);break m}c=Hq(a,r,q,w,0,0,0,0,0,0,H[g+56>>2],H[g+60>>2],H[g+48>>2],H[g+44>>2])}H[a+52>>2]=H[a+52>>2]+1;Ga=l+16|0;e=c;if(e){break a}if((d|0)!=-1){e=0;if((q|0)>=(u|0)&r>>>0>=v>>>0|(q|0)>(u|0)){break a}}e=Ay(a,r,q,H[g+56>>2],H[g+60>>2])}if(g){Wa(H[g+48>>2]);Wa(H[g+36>>2]);xy(H[g>>2]);Wa(g)}Ch(i+16|0);Ga=i+96|0;return e}function gn(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0;a:{if(I[H[H[a>>2]>>2]+80|0]&64?e:0){break a}s=J[b>>1];if(s>>>0>63){break a}K=d&2051?387:386;S=a+504|0;T=d&64;U=d&192;V=a+88|0;L=d&128;W=d&2048;i=s;h=i&31;if((i&63)>>>0>=32){i=-1<<h;h=0}else{j=(1<<h)-1&-1>>>32-h;h=-1<<h;i=j|h}C=h^-1;B=i^-1;M=e;k=1;while(1){b:{c:{d:{e:{f:{g:{if(!(!(k&255)|((p|0)==(B|0)&r>>>0>=C>>>0|p>>>0>B>>>0)|(!x&u>>>0>M>>>0|(x|0)!=0))){if(u|x){O=O|H[m+12>>2];P=P|H[m+8>>2]}m=f;if(!x&u>>>0<M>>>0){m=H[H[c+24>>2]+(u<<2)>>2];if(W){break b}}if(!(I[m+41|0]&4)){break g}a=I[m+29|0];b=(d&640)==128;r=b?r:a?C:r;p=b?p:a?B:p}if((r|0)!=(C|0)|(p|0)!=(B|0)){break f}h=s;break a}if(L){G[m+30>>1]=0}q=P^-1;o=O^-1;v=H[(H[a+4>>2]+(I[m+16|0]<<6)|0)+48>>2];i=0;h=0;while(1){if(!(!h&(i|0)==(s|0))){l=i&31;if((i&63)>>>0>=32){e=1<<l;j=0}else{j=1<<l;e=j-1&1>>>32-l}l=e;h:{if(r&j|p&e){break h}y=(i<<4)+b|0;t=jd(H[y+8>>2]);if(!t){break h}i:{switch(I[t|0]-167|0){case 0:case 2:break i;default:break h}}if(H[t+28>>2]!=(v|0)){break h}n=Sr(V,v,G[t+32>>1],q,o,K,0);if(!n){break h}w=J[n+12>>1];if((w|0)==1){z=J[m+44>>1];e=0;while(1){if((e|0)==(z|0)){break h}A=e<<2;e=e+1|0;if((n|0)!=H[A+H[m+52>>2]>>2]){continue}break}}if(!(!(w&130)|G[t+32>>1]<0)){e=H[a>>2];t=Zf(e,H[y+8>>2]);e=Uj(e,H[n>>2]);if(!e){break h}if(hb(H[t>>2],H[e>>2])){break h}}r=j|r;p=l|p}e=h;h=i+1|0;e=h?e:e+1|0;i=h;h=e;continue}break}e=H[m+40>>2];if(e&4096){break c}l=0;j:{if(e&256){n=0;Q=0;h=1;break j}h=0;n=H[m+32>>2];if(!n|I[n+55|0]&4){break a}k=!(e&32768)&I[n+54|0]!=0;Q=J[n+50>>1];h=J[n+52>>1]}i=u&31;if((u&63)>>>0>=32){e=1<<i;j=0}else{j=1<<i;e=j-1&1>>>32-i}X=j;t=e;Y=h&65535;y=0;w=0;z=0;while(1){if((l|0)==(Y|0)){break d}e=1;k:{i=J[m+24>>1];l:{if(i>>>0<=l>>>0|J[m+46>>1]>l>>>0){break l}q=H[m+52>>2];h=H[q+(l<<2)>>2];e=J[h+12>>1];if(e&K){k=e&384?0:k;break k}m:{if(!(e&1)){break m}o=i-1|0;j=H[h>>2];h=l;while(1){if((h|0)==(o|0)){break m}e=0;h=h+1|0;if((j|0)!=H[H[q+(h<<2)>>2]>>2]){continue}break}break l}e=1}n:{o:{p:{q:{if(n){h=J[H[n+4>>2]+(l<<1)>>1];o=H[n+12>>2];q=((h|0)==J[o+32>>1]?-1:h)<<16>>16;A=F[H[n+28>>2]+l|0]&1;if(k&255){break q}k=0;break n}i=k&255;q=-1;A=0;k=0;h=1;if(i){break p}break n}if((q|0)<0){break o}h=1;if(i>>>0>l>>>0){break p}h=(I[(H[o+4>>2]+N(q,12)|0)+4|0]&15)!=0}k=h;break n}k=(q|0)!=-2}i=0;h=0;while(1){if(!(e&255)|(!h&i>>>0>=s>>>0|h)){break e}r:{o=i&31;if(((i&63)>>>0>=32?p>>>o|0:((1<<o)-1&p)<<32-o|r>>>o)&1){break r}o=(i<<4)+b|0;D=H[o+8>>2];j=jd(D);if(!j){break r}e=U?e:0;s:{t:{if((q|0)>=-1){u:{switch(I[j|0]-167|0){case 0:case 2:break u;default:break r}}if(H[j+28>>2]!=(v|0)|G[j+32>>1]!=(q|0)){break r}if((q|0)!=-1){break t}break s}if(dn(j,H[(H[n+40>>2]+(l<<4)|0)+8>>2],v)){break r}D=H[o+8>>2]}if(hb(H[Zf(H[a>>2],D)>>2],H[H[n+32>>2]+(l<<2)>>2])){break r}}if(L){G[m+30>>1]=l+1}v:{if(T){e=I[o+16|0];break v}if(z){z=1;e=I[o+16|0];if(((w^A)&255)==(e&1)){break v}break e}z=1;e=I[o+16|0];w=e&1^A;if(!w){w=0;break v}h=t|H[g+4>>2];H[g>>2]=X|H[g>>2];H[g+4>>2]=h}if(e&2){if(J[m+24>>1]!=(l|0)){break e}H[m+40>>2]=H[m+40>>2]|524288}y=(q|0)==-1?1:y;h=i&31;if((i&63)>>>0>=32){e=1<<h;j=0}else{j=1<<h;e=j-1&1>>>32-h}r=j|r;p=e|p;break k}i=i+1|0;h=i?h:h+1|0;continue}}l=l+1|0;continue}}h=255;if(k&255){break a}while(1){if(s>>>0<2&(E|0)<=0|(E|0)<0){h=0;break a}a=s;s=a-1|0;E=E-!a|0;a=s&31;if((s&63)>>>0>=32){i=-1<<a;a=0}else{b=(1<<a)-1&-1>>>32-a;a=-1<<a;i=b|a}a=a^-1;b=(a&r)!=(a|0);a=i^-1;if(b|(a&p)!=(a|0)){continue}break}h=s;break a}k=l?l>>>0<Q>>>0?0:k:0}e=k|y;k=0;if(!(e&255)){break b}}e=Z|H[m+12>>2];Z=e;R=R|H[m+8>>2];l=R^-1;t=e^-1;i=0;h=0;while(1){if(!(!h&(i|0)==(s|0))){k=i&31;if((i&63)>>>0>=32){e=1<<k;j=0}else{j=1<<k;e=j-1&1>>>32-k}n=j;w:{if(r&n|e&p){break w}q=H[((i<<4)+b|0)+8>>2];k=wf(S,q);v=Ja;if(!(k|v)){if(!Me(q)){break w}}k=!(k&l|t&v);r=r|(k?n:0);p=p|(k?e:0)}e=h;h=i+1|0;e=h?e:e+1|0;i=h;h=e;continue}break}k=1}e=u+1|0;x=e?x:x+1|0;u=e;continue}}return h<<24>>24}function wd(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;a:{b:{if(H[c>>2]){break b}e=I[a+52|0];F[b+33|0]=1;c:{switch(H[b>>2]-1|0){case 0:case 2:d=H[b+16>>2];f=H[b+12>>2];if(I[f+34|0]){wd(a,d,c);a=H[d+28>>2];H[b+24>>2]=H[d+24>>2];H[b+28>>2]=a;F[b+32|0]=I[d+32|0];return}k=I[d+34|0];wd(a,f,c);if(k){a=H[f+28>>2];H[b+24>>2]=H[f+24>>2];H[b+28>>2]=a;F[b+32|0]=I[f+32|0];return}wd(a,d,c);d:{while(1){if(I[f+32|0]){e=H[f+28>>2];H[b+24>>2]=H[f+24>>2];H[b+28>>2]=e;e=1;break d}e:{h=I[d+32|0];if(h|H[c>>2]){break e}i=H[f+24>>2];j=H[d+24>>2];k=H[f+28>>2];g=H[d+28>>2];k=(g|0)<=(k|0)&i>>>0>j>>>0|(g|0)<(k|0)?1:(i|0)!=(j|0)|(k|0)!=(g|0)?-1:0;k=e?0-k|0:k;if(!k){break e}wd(a,(k|0)<0?f:d,c);continue}break}e=H[f+28>>2];H[b+24>>2]=H[f+24>>2];H[b+28>>2]=e;e=(h|0)!=0}F[b+32|0]=e;if(!e|H[b>>2]!=1){break b}f:{b=H[d+20>>2];if(!H[b>>2]){break f}while(1){if(H[c>>2]|I[d+32|0]){break f}$a(H[b+28>>2],0,H[b+32>>2]);wd(a,d,c);continue}}g:{b=H[f+20>>2];if(!b|!H[b>>2]){break g}while(1){if(H[c>>2]|I[f+32|0]){break g}$a(H[b+28>>2],0,H[b+32>>2]);wd(a,f,c);continue}}F[f+32|0]=1;F[d+32|0]=1;return;case 3:k=e?-1:1;e=H[b+12>>2];d=H[b+16>>2];j=e;h:{if(I[d+32|0]){break h}h=H[e+24>>2];i=H[d+24>>2];f=H[e+28>>2];g=H[d+28>>2];g=N(k,h>>>0>i>>>0&(f|0)>=(g|0)|(f|0)>(g|0)?1:(h|0)!=(i|0)|(f|0)!=(g|0)?-1:0);h=I[e+32|0];if(!h){j=e;if((g|0)<0){break h}}j=d;if(h){break h}j=d;if((g|0)>0){break h}wd(a,e,c);j=d}wd(a,j,c);F[b+32|0]=I[e+32|0]?I[d+32|0]!=0:0;c=H[e+24>>2];a=H[e+28>>2];i:{if(!I[d+32|0]){f=H[d+24>>2];d=H[d+28>>2];if(I[e+32|0]|(N(k,c>>>0>f>>>0&(a|0)>=(d|0)|(a|0)>(d|0)?1:(c|0)!=(f|0)|(a|0)!=(d|0)?-1:0)|0)>=0){break i}}H[b+24>>2]=c;H[b+28>>2]=a;return}H[b+24>>2]=f;H[b+28>>2]=d;return;case 1:break c;default:break a}}f=H[b+12>>2];d=H[b+16>>2];if(!I[d+33|0]){wd(a,d,c)}wd(a,f,c);k=I[f+32|0];if(!k){while(1){j:{if(H[c>>2]|I[d+32|0]){break j}h=H[f+24>>2];i=H[d+24>>2];k=H[f+28>>2];g=H[d+28>>2];if(((e?h>>>0<i>>>0&(k|0)<=(g|0)|(g|0)>(k|0):(g|0)<=(k|0)&h>>>0>i>>>0|(g|0)<(k|0))|0)!=1){break j}wd(a,d,c);continue}break}k=I[f+32|0]}a=H[f+28>>2];c=H[f+24>>2];F[b+32|0]=k;H[b+24>>2]=c;H[b+28>>2]=a}return}g=H[b+20>>2];Ji(g);k=c;m=b+32|0;k:{if(H[g+40>>2]){h=Ga-128|0;Ga=h;n=H[a>>2];F[h+127|0]=0;l:{m:{if(H[g+64>>2]==1){f=Ly(n,H[g+92>>2],g+16|0,g+28|0,g+32|0);l=!H[g+28>>2];break m}o=I[a+52|0];$a(h+16|0,0,96);p=o?-1:1;n:while(1){i=0;c=0;a=0;j=0;if(l){break m}while(1){if(!(I[h+127|0]|(H[g+64>>2]<=(i|0)|f))){d=(h+16|0)+N(i,24)|0;f=Ky(n,g,i,d,h+127|0);o:{if(H[d>>2]){break o}e=H[d+8>>2];d=H[d+12>>2];if(j){j=1;l=c>>>0>e>>>0&(a|0)>=(d|0)|(a|0)>(d|0)?1:(c|0)!=(e|0)|(a|0)!=(d|0)?-1:0;if(((o?0-l|0:l)|0)>=0){break o}}j=1;c=e;a=d}i=i+1|0;continue}break}i=0;while(1){p:{d=H[g+64>>2];if((d|0)>(i|0)){while(1){if(I[h+127|0]|f){break p}d=(h+16|0)+N(i,24)|0;if(H[d>>2]){f=0;break p}f=0;j=H[d+8>>2];e=H[d+12>>2];if((N(p,c>>>0<j>>>0&(a|0)<=(e|0)|(a|0)<(e|0)?1:(c|0)!=(j|0)|(a|0)!=(e|0)?-1:0)|0)>=0){break p}f=Ky(n,g,i,d,h+127|0);e=H[d+8>>2];j=e;d=H[d+12>>2];e=(N(p,c>>>0<e>>>0&(a|0)<=(d|0)|(a|0)<(d|0)?1:(c|0)!=(e|0)|(d|0)!=(a|0)?-1:0)|0)>0;c=e?j:c;a=e?d:a;i=e?0:i;continue}}l=I[h+127|0];if(l){continue n}d=H[(N(d,24)+h|0)+12>>2];e=Ub(d+8|0);if(e){e=Ya(e,H[(N(H[g+64>>2],24)+h|0)+8>>2],d+1|0);d=d+e|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;i=0;d=0;q:{while(1){q=H[g+64>>2];j=q-1|0;if((j|0)<=(i|0)){break q}r:{j=(h+16|0)+N(i,24)|0;if(!H[j>>2]){H[h+12>>2]=H[j+16>>2];H[h+8>>2]=e;H[h+4>>2]=e;if(!Hi(h+4|0,q+(i^-1)|0,0,1,h+12|0,h+8|0)){break r}d=H[h+4>>2]-e|0}i=i+1|0;continue}break}j=H[g+64>>2]-1|0}if((i|0)==(j|0)){H[g+32>>2]=d;H[g+28>>2]=e;H[g+16>>2]=c;H[g+20>>2]=a;H[g+24>>2]=1;l=0;break m}Wa(e);continue n}f=7;break l}i=i+1|0;continue}}}F[m|0]=l}Ga=h+128|0;break k}s:{t:{e=I[a+52|0];a=H[a>>2];c=I[a+239|0];if((e|0)==(c|0)){break t}f=H[g+4>>2];if(!f){break t}Lm(c,H[g>>2],f,g+8|0,g+16|0,g+32|0,m);H[g+28>>2]=H[g+8>>2];break s}My(a,g,m)}f=0}H[k>>2]=f;a=H[g+20>>2];H[b+24>>2]=H[g+16>>2];H[b+28>>2]=a}function NB(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0;g=Ga-16|0;Ga=g;j=I[a+48|0];p=j>>>0<2?1:(j|0)==2?5:10;z=H[a>>2];C=H[z>>2];a:{if(!b){break a}c=H[a+8>>2];if(!c){break a}n=H[c>>2]}c=N((j<<2)+32|0,p)+n<<1;s=Tb(C,c,c>>31);if(s){e=n<<1;h=p<<5;f=h+s|0;c=f;H[c>>2]=0;H[c+4>>2]=0;H[c+24>>2]=0;H[c+28>>2]=0;H[c+16>>2]=0;H[c+20>>2]=0;H[c+8>>2]=0;H[c+12>>2]=0;t=c+h|0;c=p<<1;h=j<<2;d=s;while(1){if((c|0)>0){H[d+24>>2]=t;d=d+32|0;c=c-1|0;t=h+t|0;continue}break}b:{if(!n){t=0;break b}$a(t,0,e)}c=(p<<5)+s|0;e=H[z+136>>2];G[c+16>>1]=e>>>0<48?e:48;if(n){F[c+22|0]=j?-1:n}K=a- -64|0;c=1;e=s;while(1){c:{h=f;if((j|0)==(v|0)){break c}f=0;L=(c|0)>0?c:0;D=v<<2;k=h;A=0;while(1){if((A|0)!=(L|0)){c=K;while(1){i=H[c>>2];if(i){o=F[k+22|0];H[g+8>>2]=0;H[g+12>>2]=0;d:{q=H[k>>2];r=H[k+4>>2];if(H[i>>2]&(q^-1)|H[i+4>>2]&(r^-1)){break d}w=H[i+8>>2];x=H[i+12>>2];if(q&w|r&x){break d}c=G[k+16>>1];if((c|0)<3?I[i+41|0]&64:0){break d}m=Je(Je(G[i+18>>1],c+J[i+20>>1]<<16>>16),G[k+20>>1]);c=c+J[i+22>>1]|0;e:{if((o|0)<0){o=gn(a,H[a+8>>2],k,J[a+44>>1],v&65535,i,g+8|0);break e}d=H[k+12>>2];H[g+8>>2]=H[k+8>>2];H[g+12>>2]=d}M=c<<16;f:{if(!((o|0)<0|(n|0)<=(o|0))){c=(o<<1)+t|0;d=J[c>>1];if(!d){d=c;c=(N(n-o|0,100)|0)/(n|0)|0;l=je(c,c>>31);y=J[a+44>>1];g:{if(y&16384){c=G[a+46>>1];if((c|0)<(b|0)){break g}}c=(b|0)>10?(y&256)>>>8|0?b-10|0:b:b}y=d;d=(cn(c<<16>>16)+(b+l|0)<<16)-3276800>>16;G[y>>1]=d}l=Je(m,d<<16>>16)+5|0;break f}l=m;m=l-2|0}w=q|w;r=r|x;q=M>>16;d=0;x=(f|0)>0?f:0;c=e;h:{i:{while(1){if((d|0)!=(x|0)){if(H[c>>2]==(w|0)&H[c+4>>2]==(r|0)&(I[c+22|0]^o)<<24>>24>=0){break i}c=c+32|0;d=d+1|0;continue}break}c=f;d=(p|0)>(c|0);j:{if(d){break j}if(l<<16>>16>u<<16>>16){break d}c=E;if((l&65535)!=(u&65535)){break j}if(m<<16>>16>=B<<16>>16){break d}}c=(c<<5)+e|0;f=d+f|0;break h}d=G[c+18>>1];if((d|0)<l<<16>>16){break d}if((d&65535)!=(l&65535)){break h}d=G[c+16>>1];if((d|0)<(q|0)){break d}if((d|0)!=(q|0)){break h}if(G[c+20>>1]<=m<<16>>16){break d}}d=H[i+12>>2]|H[k+4>>2];H[c>>2]=H[i+8>>2]|H[k>>2];H[c+4>>2]=d;d=H[g+12>>2];r=H[g+8>>2];F[c+22|0]=o;G[c+20>>1]=m;G[c+18>>1]=l;G[c+16>>1]=q;H[c+8>>2]=r;H[c+12>>2]=d;Ya(H[c+24>>2],H[k+24>>2],D);H[H[c+24>>2]+D>>2]=i;if((f|0)<(p|0)){break d}B=G[e+16>>1];u=G[e+18>>1];d=1;E=0;c=e;while(1){if((d|0)==(p|0)){break d}m=G[c+50>>1];k:{l:{if((m|0)>u<<16>>16){l=J[c+52>>1];break l}if((m&65535)!=(u&65535)){break k}l=G[c+52>>1];if((l|0)<=B<<16>>16){break k}}B=l;u=m;E=d}c=c+32|0;d=d+1|0;continue}}c=i+56|0;continue}break}k=k+32|0;A=A+1|0;continue}break}v=v+1|0;c=f;f=e;e=h;continue}break}m:{if(c){e=(c|0)>1?c:1;d=h;c=1;while(1)if((c|0)==(e|0)){f=a+768|0;c=0;while(1){if((c|0)!=(j|0)){e=f+N(c,96)|0;h=H[H[d+24>>2]+(c<<2)>>2];H[e+80>>2]=h;h=I[h+16|0];F[e+60|0]=h;H[e+4>>2]=H[(H[a+4>>2]+(h<<6)|0)+48>>2];c=c+1|0;continue}break}n:{if(I[a+51|0]|(!b|(J[a+44>>1]&384)!=256)){break n}b=j-1|0;if((gn(a,H[a+12>>2],d,128,b&65535,H[H[d+24>>2]+(b<<2)>>2],g+8|0)|0)!=H[H[a+12>>2]>>2]){break n}F[a+51|0]=2}e=I[a+52|0];F[a+52|0]=e&251;c=H[a+8>>2];o:{if(!c){break o}b=F[d+22|0];F[a+49|0]=b;f=J[a+44>>1];p:{if(f&128){if((b|0)!=H[c>>2]){break p}F[a+51|0]=2;break p}h=H[d+12>>2];H[a+80>>2]=H[d+8>>2];H[a+84>>2]=h;if((b|0)<=0){F[a+49|0]=0;if(!j){break p}b=j-1|0;e=H[H[d+24>>2]+(b<<2)>>2];h=H[e+40>>2];if(h&4096|(h&260)==260){break p}H[g+8>>2]=0;H[g+12>>2]=0;b=gn(a,c,d,2048,b&65535,e,g+8|0);c=H[a+8>>2];if((b|0)==H[c>>2]){F[a+52|0]=I[a+52|0]|4;b=H[g+12>>2];H[a+80>>2]=H[g+8>>2];H[a+84>>2]=b}f=J[a+44>>1];break p}if(!(f&3)|(!j|(b|0)!=1)){break p}F[a+52|0]=e|4}if(!(f&512)|(!j|H[c>>2]!=F[a+49|0])){break o}H[g+8>>2]=0;H[g+12>>2]=0;b=j-1|0;if((gn(a,c,d,0,b&65535,H[H[d+24>>2]+(b<<2)>>2],g+8|0)|0)!=H[H[a+8>>2]>>2]){break o}F[a+52|0]=I[a+52|0]|8;b=H[g+12>>2];H[a+80>>2]=H[g+8>>2];H[a+84>>2]=b}G[a+54>>1]=J[d+16>>1];break m}else{f=h+(c<<5)|0;d=G[d+18>>1]>G[f+18>>1]?f:d;c=c+1|0;continue}}Za(z,9621,0)}$b(C,s)}Ga=g+16|0}function RF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;if((b|0)==2){a:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break a}}Wb(a);return}e=Nb(H[c>>2]);j=Nb(H[c+4>>2]);H[17665]=0;s=a;b=0;k=1;C(+j);f=x(1)|0;a=x(0)|0;b:{c:{d:{l=f&2147483647;c=a;e:{if(!(l|a)){break e}C(+e);a=x(1)|0;p=x(0)|0;if(!p&(a|0)==1072693248){break e}m=a&2147483647;d=e+j;if(!(!(m>>>0>2146435072|(m|0)==2146435072&(p|0)!=0|l>>>0>2146435072)&(!c|(l|0)!=2146435072))){break b}f:{g:{h:{n=0;i:{if((a|0)>0|(a|0)>=0){break i}n=2;if(l>>>0>1128267775){break i}n=0;if(l>>>0<1072693248){break i}h=l>>>20|0;if(l>>>0<1094713344){break h}b=1075-h|0;h=c>>>b|0;n=0;if((c|0)!=h<<b){break i}n=2-(h&1)|0}b=n;if(!c){break g}break f}if(c){break f}c=1043-h|0;h=l>>>c|0;b=0;if((l|0)!=h<<c){break g}b=2-(h&1)|0}if((l|0)==2146435072){if(!(m-1072693248|p)){break e}d=(f|0)>0|(f|0)>=0?j:0;if(m>>>0>=1072693248){break b}d=(f|0)>0|(f|0)>=0?0:-j;break b}if((l|0)==1072693248){d=e;if((f|0)>0|(f|0)>=0){break b}d=1/e;break b}d=e*e;if((f|0)==1073741824){break b}if((f|0)!=1071644672|(a|0)<0){break f}d=W(e);break b}g=P(e);j:{if(p){break j}k:{if((a|0)<0){if((a|0)==-2147483648|(a|0)==-1074790400){break k}if((a|0)!=-1048576){break j}break k}if(!a|(a|0)==2146435072){break k}if((a|0)!=1072693248){break j}}k=(f|0)<0?1/g:g;if((a|0)>0|(a|0)>=0){break e}if(!(m-1072693248|b)){d=k-k;d=d/d;break b}d=(b|0)==1?-k:k;break b}l:{if((a|0)>0|(a|0)>=0){break l}m:{switch(b|0){case 0:d=e-e;d=d/d;break b;case 1:break m;default:break l}}k=-1}n:{if(l>>>0>=1105199105){if(l>>>0>=1139802113){d=(f|0)<0?Z:0;if(m>>>0<=1072693247){break b}d=(f|0)>0?Z:0;break b}d=(f|0)<0?k*1e300*1e300:k*1e-300*1e-300;if(m>>>0<=1072693246){break b}d=(f|0)>0?k*1e300*1e300:k*1e-300*1e-300;if(m>>>0>=1072693249){break b}d=g+-1;e=d*1.9259629911266175e-8+d*d*(.5-d*(d*-.25+.3333333333333333))*-1.4426950408889634;i=e;e=d*1.4426950216293335;C(+(i+e));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=i-(d-e);break n}d=g*9007199254740992;a=m>>>0<1048576;e=a?d:g;C(+d);b=x(1)|0;x(0)|0;b=a?b:m;h=b&1048575;c=h|1072693248;b=(b>>20)+(a?-1076:-1023)|0;a=0;o:{if(h>>>0<235663){break o}if(h>>>0<767610){a=1;break o}c=h|1071644672;b=b+1|0}h=a<<3;t=M[h+56160>>3];C(+e);x(1)|0;m=0;z(0,x(0)|m);z(1,c|0);g=+B();o=M[h+56144>>3];i=g-o;q=1/(o+g);e=i*q;C(+e);l=x(1)|0;x(0)|0;z(0,0);z(1,l|0);d=+B();u=d;z(0,m|0);z(1,((a<<18)+(c>>>1|0)|0)+537395200|0);r=d*d;v=i;i=+B();g=q*(v-d*i-d*(g-(i-o)));i=g*(e+d);d=e*e;o=i+d*d*(d*(d*(d*(d*(d*.20697501780033842+.23066074577556175)+.272728123808534)+.33333332981837743)+.4285714285785502)+.5999999999999946);C(+(r+3+o));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();i=u*d;e=g*d+e*(o-(d+-3-r));C(+(i+e));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=t+(d*-7.028461650952758e-9+(e-(d-i))*.9617966939259756);i=e;g=M[h+56176>>3];e=d*.9617967009544373;o=+(b|0);C(+(g+(i+e)+o));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=i-(d-o-g-e)}z(0,0);z(1,f|0);g=+B();e=(j-g)*d+e*j;d=d*g;j=e+d;C(+j);c=x(1)|0;b=x(0)|0;p:{f=c;if((f|0)>=1083179008){if(b|f-1083179008){break d}if(!(e+8008566259537294e-32>j-d)){break p}break d}if((f&2147482624)>>>0<1083231232){break p}if(b|f+1064252416){break c}if(!(e<=j-d)){break p}break c}a=0;h=f&2147483647;if(h>>>0>=1071644673){b=f+(1048576>>>(h>>>20|0)-1022|0)|0;f=b>>>20&2047;a=(b&1048575|1048576)>>>1043-f|0;a=(c|0)<0?0-a|0:a;z(0,0);z(1,b&-1048576>>f-1023);d=d-+B();C(+(e+d));c=x(1)|0;x(0)|0}z(0,0);z(1,c|0);j=+B();g=j*.6931471824645996;j=(e-(j-d))*.6931471805599453+j*-1.904654299957768e-9;d=g+j;e=d*d;e=d-e*(e*(e*(e*(e*4.1381367970572385e-8+-16533902205465252e-22)+6613756321437934e-20)+-.0027777777777015593)+.16666666666666602);i=d*e/(e+-2);e=d;d=j-(d-g);d=e-(i-(e*d+d))+1;C(+d);b=x(1)|0;c=x(0)|0;b=(a<<20)+b|0;q:{if((b|0)<=1048575){e=pk(d,a);break q}z(0,c|0);z(1,b|0);e=+B()}k=k*e}d=k;break b}d=k*1e300*1e300;break b}d=k*1e-300*1e-300}Zb(s,d);return}_(22830,17213,546,16925);X()}function bk(a,b){var c=0,d=0,e=0,f=0;d=1;c=1;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{f=I[a|0];e=I[f+33232|0];switch(e|0){case 30:break j;case 0:break k;case 1:break l;case 4:case 5:break m;case 6:break n;case 9:break o;case 3:break p;case 26:break q;case 8:break r;case 25:break s;case 24:break t;case 23:break u;case 10:break v;case 15:break w;case 13:break x;case 12:break y;case 14:break z;case 22:break A;case 16:break B;case 21:break C;case 20:break D;case 19:break E;case 18:break F;case 17:break G;case 11:break H;case 7:break I;case 2:case 27:break e;case 29:break i;default:break h}}while(1){d=c;c=c+1|0;if(F[I[a+d|0]+30016|0]&1){continue}break}H[b>>2]=183;break b}J:{c=I[a+1|0];if((c|0)!=62){if((c|0)!=45){break J}c=2;while(1){d=I[a+c|0];if(!(!d|(d|0)==10)){c=c+1|0;continue}break}H[b>>2]=183;return c}H[b>>2]=112;return I[a+2|0]==62?3:2}H[b>>2]=107;break f}H[b>>2]=22;break f}H[b>>2]=23;break f}H[b>>2]=1;return 1}H[b>>2]=106;break f}H[b>>2]=108;break f}if(I[a+1|0]!=42){break g}c=I[a+2|0];if(!c){break g}d=3;K:{while(1){e=(c&255)==42;c=I[a+d|0];if(!(e&(c|0)==47)){if(!(c&255)){break K}d=d+1|0;continue}break}d=d+1|0}H[b>>2]=183;break b}H[b>>2]=110;break f}H[b>>2]=53;return I[a+1|0]==61?2:1}L:{switch(I[a+1|0]-60|0){case 1:H[b>>2]=55;break a;case 2:H[b>>2]=52;break a;case 0:H[b>>2]=104;break a;default:break L}}H[b>>2]=56;break f}M:{switch(I[a+1|0]-61|0){case 0:H[b>>2]=57;break a;case 1:H[b>>2]=105;break a;default:break M}}H[b>>2]=54;break f}if(I[a+1|0]!=61){H[b>>2]=184;break f}H[b>>2]=52;break a}if(I[a+1|0]!=124){H[b>>2]=103;break f}H[b>>2]=111;break a}H[b>>2]=25;break f}H[b>>2]=102;break f}H[b>>2]=114;break f}N:{while(1){c=I[a+d|0];if(!c){break N}O:{if((c|0)==(f|0)){d=d+1|0;if(I[d+a|0]!=(f|0)){break O}}d=d+1|0;continue}break}if((f|0)==39){H[b>>2]=117;break b}H[b>>2]=59;break b}H[b>>2]=184;break b}if(I[a+1|0]-58>>>0>4294967285){break p}H[b>>2]=141;break f}H[b>>2]=155;if(!(I[I[a+2|0]+30016|0]&8)|(I[a|0]!=48|(I[a+1|0]|32)!=120)){break d}d=3;while(1){c=d;d=c+1|0;if(I[I[a+c|0]+30016|0]&8){continue}break}break c}P:{while(1){c=59;if((f|0)==93){break P}f=I[a+d|0];if(f){d=d+1|0;continue}break}c=184}H[b>>2]=c;break b}H[b>>2]=156;while(1){c=d;d=c+1|0;if(I[a+c|0]-58>>>0>=4294967286){continue}break}break c}H[b>>2]=156;e=0;Q:{while(1){d=I[a+c|0];if(!d){break Q}R:{S:{if(I[d+30016|0]&70){e=e+1|0;break S}if(!((d|0)!=40|(e|0)<=0)){while(1){d=c;c=c+1|0;f=I[c+a|0];if(!f){break R}if(!(F[f+30016|0]&1)&(f|0)!=41){continue}break}if((f|0)!=41){break R}c=d+2|0;break Q}if((d|0)!=58){break Q}d=c+1|0;if(I[d+a|0]!=58){break Q}c=d}c=c+1|0;continue}break}H[b>>2]=184}if(e){break c}H[b>>2]=184;return c}while(1){d=e;e=d+1|0;f=I[a+d|0];if(I[f+33232|0]<3){continue}break}c=e;if(I[f+30016|0]&70){break e}H[b>>2]=59;return bx(a,d,b)}if(I[a+1|0]!=39){break e}H[b>>2]=154;d=2;while(1){c=d;d=c+1|0;e=I[a+c|0];if(I[e+30016|0]&8){continue}break}T:{if((e|0)==39){d=1;if(!(c&1)){break T}}H[b>>2]=184;while(1){b=I[a+c|0];if(!(!b|(b|0)==39)){c=c+1|0;continue}break}d=(b|0)!=0}return c+d|0}if(I[a+1|0]!=187|I[a+2|0]!=191){break e}H[b>>2]=183;return 3}H[b>>2]=184;return 0}H[b>>2]=184;break f}H[b>>2]=109}c=1;break c}while(1){d=c;c=c+1|0;if(I[I[a+d|0]+30016|0]&70){continue}break}H[b>>2]=59;break b}d=0;while(1){c=d;d=c+1|0;e=I[a+c|0];if(e-58>>>0>4294967285){continue}break}if((e|0)==46){while(1){c=c+1|0;d=c+a|0;if(I[d|0]-58>>>0>4294967285){continue}break}H[b>>2]=153;e=I[d|0]}U:{if(((e|32)&255)!=101){break U}d=I[(a+c|0)+1|0];V:{if(d-58>>>0>=4294967286){d=c+2|0;break V}W:{switch(d-43|0){case 0:case 2:break W;default:break U}}d=c+2|0;if(I[d+a|0]-58>>>0<4294967286){break U}}while(1){c=d;d=c+1|0;if(I[a+c|0]-58>>>0>4294967285){continue}break}H[b>>2]=153}while(1){if(!(I[I[a+c|0]+30016|0]&70)){break c}H[b>>2]=184;c=c+1|0;continue}}return c}return d}return 2}function zv(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0;y=Ga-16|0;Ga=y;H[y+12>>2]=0;n=8;if(!I[a+46|0]){t=c;n=sg(a,1,1);a:{if(n){break a}F[a+45|0]=1;b:{c:{if(!c){t=0;break c}t=0;n=Ll(a,d,e,0,1);if((n|0)==5){d=0;break c}if(n){t=c;break b}F[a+44|0]=1;t=c}n=Rv(a,y+12|0)}if(n){break a}d:{e:{if(!H[a+68>>2]){break e}if((yv(a)|0)==(g|0)){break e}k=ab(65572);break d}D=b;p=Ga-32|0;Ga=p;H[p+28>>2]=0;H[p+24>>2]=0;H[p+20>>2]=0;b=yv(a);u=pi(a);n=H[a+68>>2];f:{if(n>>>0<=K[u>>2]){k=0}else{l=u+4|0;E=H[a+72>>2];g=1;while(1){if((g|0)!=5){o=l+(g<<2)|0;q=H[o>>2];g:{if(q>>>0>=n>>>0){break g}r=g+3|0;k=Ll(a,d,e,r,1);if((k|0)==5){n=q;d=0;break g}if(k){break f}H[o>>2]=(g|0)==1?n:-1;Qe(a,r,1);k=0}g=g+1|0;continue}break}m=0;h:{if(K[u>>2]>=n>>>0){break h}g=H[u>>2];k=Ga-32|0;Ga=k;s=H[a+68>>2];x=rg(s);q=(N(x,20)+(s<<1)|0)+28|0;m=Ib(q,0);i:{if(!m){q=7;break i}v=$a(m,0,q);H[v+4>>2]=x+1;w=Ib((s>>>0<4096?s:4096)<<1,0);q=w?0:7;r=rg(g+1|0);while(1){if(!((r|0)>(x|0)|q)){q=Sl(a,r,k+16|0);if(!q){j:{if((r|0)==(x|0)){o=H[k+24>>2];l=s-o|0;break j}o=H[k+24>>2];l=H[k+16>>2]-H[k+20>>2]>>2}H[k+12>>2]=l;A=((v+N(H[v+4>>2],20)|0)+(o<<1)|0)+8|0;g=0;l=(l|0)>0?l:0;L=o+1|0;while(1){if((g|0)!=(l|0)){G[A+(g<<1)>>1]=g;g=g+1|0;continue}break}B=H[k+20>>2];o=0;l=0;g=Ga-112|0;Ga=g;C=H[k+12>>2];H[g+108>>2]=0;H[g+104>>2]=0;g=$a(g,0,104);M=(C|0)>0?C:0;while(1){if((l|0)==(M|0)){while(1){o=o+1|0;if(o>>>0<=12){if(!(C>>>o&1)){continue}l=(o<<3)+g|0;xv(B,H[l+4>>2],H[l>>2],g+104|0,g+108|0,w);continue}break}}else{H[g+108>>2]=1;H[g+104>>2]=A+(l<<1);o=0;while(1){if(l>>>o&1){z=(o<<3)+g|0;xv(B,H[z+4>>2],H[z>>2],g+104|0,g+108|0,w);o=o+1|0;continue}break}z=(o<<3)+g|0;H[z+4>>2]=H[g+104>>2];H[z>>2]=H[g+108>>2];l=l+1|0;continue}break}H[k+12>>2]=H[g+108>>2];Ga=g+112|0;g=v+N(r,20)|0;H[g+24>>2]=L;l=H[k+12>>2];H[g+16>>2]=B;H[g+12>>2]=A;H[g+20>>2]=l}r=r+1|0;continue}break}Wa(w);if(q){Wa(v);m=0}H[p+28>>2]=m}Ga=k+32|0;k=q;q=H[p+28>>2];m=0;if(!q){break h}k=Ll(a,d,e,3,1);if(!k){o=H[u>>2];H[u+32>>2]=n;r=f>>>2&3;g=Ge(H[a+8>>2],r);k:{if(g){break k}k=SK(b,0,E,0);H[p+8>>2]=k;f=Ja;H[p+12>>2]=f;Ah(H[a+4>>2],39,0);g=Nd(H[a+4>>2],p);if(g){break k}m=H[p>>2];l=H[p+4>>2];g=l;if(m>>>0<k>>>0&(g|0)<=(f|0)|(f|0)>(g|0)){g=f;s=k;f=m;m=SK(H[a+68>>2],0,b,0);k=f+m|0;f=Ja+l|0;f=k>>>0<m>>>0?f+1|0:f;k=k+65536|0;f=k>>>0<65536?f+1|0:f;if(s>>>0>k>>>0&(f|0)<=(g|0)|(f|0)<(g|0)){g=ab(63767);break k}gh(H[a+4>>2],5,p+8|0)}g=0}s=b+24|0;while(1){l:{k=g;if(g){break l}l=H[q+4>>2];x=H[q>>2];f=-1;m:while(1){if((l|0)>0){l=l-1|0;k=q+N(l,20)|0;m=H[k+8>>2];v=H[k+20>>2];while(1){if((m|0)>=(v|0)){continue m}w=J[H[k+12>>2]+(m<<1)>>1];g=H[H[k+16>>2]+(w<<2)>>2];if(g>>>0>x>>>0){if(f>>>0<=g>>>0){continue m}H[p+20>>2]=w+H[k+24>>2];f=g;continue m}else{m=m+1|0;H[k+8>>2]=m;continue}}}break}H[q>>2]=f;H[p+24>>2]=f;if((f|0)==-1){k=0;break l}if(H[D+296>>2]){k=I[D+87|0]?7:9;break l}g=0;f=H[p+20>>2];if(f>>>0<=o>>>0|f>>>0>n>>>0){continue}m=H[p+24>>2];if(m>>>0>E>>>0){continue}l=H[a+8>>2];k=SK(f-1|0,0,s,0)+56|0;f=Ja;k=Jc(l,h,b,k,k>>>0<56?f+1|0:f);if(k){break l}k=Bc(H[a+4>>2],h,b,SK(b,0,m-1|0,0),Ja);if(!k){continue}}break}Ah(H[a+4>>2],37,0);n:{if(k){break n}if(H[Lf(a)+16>>2]==(n|0)){k=sf(H[a+4>>2],SK(b,0,H[a+72>>2],0),Ja);if(k){break n}k=Ge(H[a+4>>2],r);if(k){break n}}H[u>>2]=n;k=0}Qe(a,3,1)}m=q}k=(k|0)==5?0:k}if(k|!t){break f}k=5;if(K[u>>2]<K[a+68>>2]){break f}k=0;if((t|0)<2){break f}Oe(4,p+8|0);k=Ll(a,d,e,4,4);if(k){break f}k=0;if((t|0)==3){Xv(a,H[p+8>>2]);k=sf(H[a+8>>2],0,0)}Qe(a,4,4)}Wa(m);Ga=p+32|0}n=k;if(k?(k|0)!=5:0){break a}if(i){H[i>>2]=H[a+68>>2]}if(!j){break a}O=j,P=H[pi(a)>>2],H[O>>2]=P}if(H[y+12>>2]){$a(a+52|0,0,48)}pp(a);if(I[a+45|0]){Qe(a,1,1);F[a+45|0]=0}n=(c|0)==(t|0)?n:n?n:5}Ga=y+16|0;return n}function Ku(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=Ga+-64|0;Ga=f;H[f+56>>2]=d;H[f+52>>2]=0;g=H[a+8>>2];p=H[g+4>>2];a:{b:{if(!(I[a+1|0]&32)){break b}e=Jg(p,H[a+64>>2],a);if(e){break a}if(!d|F[a+68|0]>=0){break b}e=ab(75895);break a}if(I[a|0]>=3){e=ng(a);if(e&-17){break a}}c:{e=H[a+112>>2];if(!e){if(I[g+11|0]){Yo(g,H[a+64>>2],H[b+8>>2],H[b+12>>2],0)}if(!(!(I[a+1|0]&2)|(H[b+8>>2]!=H[a+32>>2]|H[b+12>>2]!=H[a+36>>2]))){if(!J[a+50>>1]|H[a+44>>2]!=(H[b+32>>2]+H[b+28>>2]|0)){break c}e=zu(a,b);break a}if(d){break c}e=Xh(a,H[b+8>>2],H[b+12>>2],c>>>3&1,f+56|0);if(e){break a}break c}if(!(c&2|d)){d=J[b+24>>1];d:{if(d){H[f+8>>2]=e;e=H[b+20>>2];F[f+34|0]=0;F[f+30|0]=0;G[f+28>>1]=d;H[f+12>>2]=e;e=Yh(a,f+8|0,f+56|0);break d}e=yu(a,H[b>>2],H[b+8>>2],H[b+12>>2],c>>>3&1,f+56|0)}H[f+60>>2]=e;if(e){break a}d=H[f+56>>2]}if(d){break c}ii(a);d=H[a+32>>2];if((d|0)!=H[b+8>>2]|H[a+36>>2]!=H[b+12>>2]){break c}b=H[b>>2];H[f+40>>2]=0;H[f+36>>2]=d;H[f+24>>2]=b;e=zu(a,f+8|0);break a}h=H[a+116>>2];if(H[h+20>>2]<0){e:{if(I[a|0]>=2){e=ab(76018);break e}e=lg(h)}if(e){break a}}i=H[p+84>>2];f:{g:{if(c&128){H[f+60>>2]=0;d=H[p+88>>2];d=(d|0)>4?d:4;H[f+52>>2]=d;if(!I[p+17|0]|d>>>0<=J[h+14>>1]){break f}Ka[H[h+80>>2]](h,i,f+8|0);e=0;if(H[f+20>>2]==J[f+24>>1]){break g}Jd(p,eb((d+i|0)-4|0),3,H[h+4>>2],f+60|0);e=H[f+60>>2];break g}j=Ga-16|0;Ga=j;e=I[h+10|0];h:{if(I[h+1|0]){q=H[b+16>>2];g=H[b+28>>2];k=g+H[b+32>>2]|0;i:{if(k>>>0<=127){F[e+i|0]=k;d=1;break i}d=Gf(e+i|0,k,k>>31)&255}d=d+e|0;e=Gf(d+i|0,H[b+8>>2],H[b+12>>2])+d|0;break h}q=H[b>>2];g=H[b+8>>2];j:{if(g>>>0<=127){F[e+i|0]=g;d=1;break j}d=g;l=d>>31;d=Gf(e+i|0,d,l)&255}e=d+e|0;k=g}n=e+i|0;m=J[h+14>>1];k:{if((m|0)>=(k|0)){d=e+k|0;H[f+52>>2]=(d|0)>4?d:4;d=0;$a(Ya(n,q,g)+g|0,0,k-g|0);break k}d=J[h+16>>1];o=H[h+52>>2];l=((k-d>>>0)%(H[o+40>>2]-4>>>0)|0)+d|0;m=(l|0)>(m|0)?d:l;d=m+e|0;H[f+52>>2]=d+4;H[j+8>>2]=0;s=d+i|0;e=0;l:{while(1){d=(k|0)<(m|0)?k:m;m:{if((g|0)>=(d|0)){Ya(n,q,d);break m}if((g|0)>0){Ya(n,q,g);d=g;break m}$a(n,0,d)}k=k-d|0;if((k|0)>0){g=g-d|0;q=d+q|0;n=d+n|0;m=m-d|0;if(m){continue}H[j+4>>2]=0;d=e;if(I[o+17|0]){n=H[16164];while(1){l=d;d=d+1|0;if((d|0)==(Ud(o,d)|0)|(l|0)==((n>>>0)/K[o+36>>2]|0)){continue}break}H[j+8>>2]=d}d=If(o,j+4|0,j+8|0,d,0);H[j+12>>2]=d;n:{if(!(!I[o+17|0]|d)){l=H[j+8>>2];Jd(o,l,e?4:3,e,j+12|0);d=H[j+12>>2];if(!d){break n}Gb(H[j+4>>2]);break l}if(d){break l}l=H[j+8>>2]}Cb(s,l);Gb(r);r=H[j+4>>2];s=H[r+56>>2];Cb(s,0);m=H[o+40>>2]-4|0;n=H[r+56>>2]+4|0;e=l;continue}break}Gb(r);d=0;break k}Gb(r)}Ga=j+16|0;H[f+60>>2]=d;e=d}if(e){break a}}d=J[a+70>>1];e=H[f+56>>2];o:{if(!e){if(J[h+24>>1]<=d>>>0){e=ab(76054);break a}e=_b(H[h+72>>2]);if(e){break a}e=H[h+64>>2]+(d<<1)|0;e=H[h+56>>2]+(J[h+26>>1]&(I[e|0]<<8|I[e+1|0]))|0;if(!I[h+8|0]){g=I[e|0]|I[e+1|0]<<8|(I[e+2|0]<<16|I[e+3|0]<<24);F[i|0]=g;F[i+1|0]=g>>>8;F[i+2|0]=g>>>16;F[i+3|0]=g>>>24}Ka[H[h+80>>2]](h,e,f+8|0);if(H[f+20>>2]!=J[f+24>>1]){g=Vo(h,e,f+8|0)}else{g=0}H[f+60>>2]=g;F[a+1|0]=I[a+1|0]&251;g=J[f+26>>1];if(!((g|0)!=H[f+52>>2]|H[f+20>>2]!=J[f+24>>1]|(g>>>0>=J[h+16>>1]?I[p+17|0]:0))){if(e>>>0<(H[h+56>>2]+I[h+9|0]|0)+10>>>0){e=ab(76081);break a}if(K[h+60>>2]<e+g>>>0){e=ab(76084);break a}Ya(e,i,g);e=0;break a}yl(h,d,g,f+60|0);e=H[f+60>>2];if(!e){break o}break a}if(!J[h+24>>1]|(e|0)>=0){break o}d=d+1|0;G[a+70>>1]=d;F[a+1|0]=I[a+1|0]&253;d=d&65535}xl(h,d,i,H[f+52>>2],0,0,f+60|0);G[a+50>>1]=0;if(!I[h+12|0]){e=H[f+60>>2];break a}F[a+1|0]=I[a+1|0]&253;e=Uo(a);F[H[a+116>>2]+12|0]=0;F[a|0]=1;if(!(c&2)|e){break a}ki(a);e=0;p:{if(!H[a+112>>2]){break p}c=xc(H[b+8>>2],H[b+12>>2]);H[a+16>>2]=c;if(!c){e=7;H[f+60>>2]=7;break p}Ya(c,H[b>>2],H[b+8>>2])}F[a|0]=3;c=H[b+12>>2];H[a+56>>2]=H[b+8>>2];H[a+60>>2]=c}Ga=f- -64|0;return e}function Lr(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0;p=Ga-96|0;Ga=p;g=7;t=H[H[a>>2]>>2];o=H[t>>2];a:{if(I[o+87|0]){break a}e=H[a+8>>2];v=J[e+28>>1];q=J[e+22>>1];w=H[e>>2];x=H[e+4>>2];y=J[e+46>>1];z=J[e+26>>1];r=J[e+44>>1];j=J[e+24>>1];s=H[e+40>>2];f=s&32?24:447;f=hn(p,H[a+4>>2],H[b+40>>2],j,(I[c+55|0]|I[c+56|0]<<8)&4?f&387:f,c);G[e+18>>1]=0;A=r+1|0;B=G[H[c+8>>2]>>1];u=cn(B);D=u&65535;g=0;while(1){b:{if(!f|g){break b}k=J[f+12>>1];c:{if(!(I[f+10|0]&128?0:(k|0)!=256)){g=0;if(tB(c,j)){break c}}g=0;if(F[f+11|0]&1&(k|0)==16|(H[e+8>>2]&H[f+32>>2]|H[e+12>>2]&H[f+36>>2])){break c}if(I[b+36|0]&88){h=H[f>>2];if(!(I[h+4|0]&3)|H[h+36>>2]!=H[b+40>>2]){break c}}d:{if(I[c+54|0]){h=2;if((J[c+50>>1]-1|0)==(j|0)){break d}}h=1}F[a+16|0]=h|I[a+16|0];G[e+44>>1]=r;G[e+28>>1]=v;G[e+26>>1]=z;G[e+24>>1]=j;H[e+40>>2]=s;if(Vi(o,e,A)){break b}h=J[e+44>>1];m=h+1|0;G[e+44>>1]=m;H[H[e+52>>2]+(h<<2)>>2]=f;h=(x|H[f+36>>2])&(H[e+12>>2]^-1);H[e>>2]=(w|H[f+32>>2])&(H[e+8>>2]^-1);H[e+4>>2]=h;e:{if(k&1){l=H[f>>2];f:{if(I[l+5|0]&16){g=m&65535;m=(g>>>0>1?g:1)-1|0;g=0;h=46;while(1){if((g|0)==(m|0)){break f}C=H[H[e+52>>2]+(g<<2)>>2];if(C){h=(l|0)==H[C>>2]?0:h}g=g+1|0;continue}}h=0;g=H[l+20>>2];if(!g){break f}g=H[g>>2];if(!g){break f}h=je(g,g>>31)&65535}g:{if(!(I[c+55|0]&128)|(u|0)<10){break g}if(!(((J[H[c+8>>2]+(j<<1)>>1]-(h+D|0)|0)+cn(h<<16>>16)|0)+10&32768)){break g}g=0;if(I[o+82|0]&2|(d|0)>1){break c}H[e+40>>2]=H[e+40>>2]|1048576}g=H[e+40>>2]|4;H[e+40>>2]=g;break e}if(k&130){l=G[H[c+4>>2]+(j<<1)>>1];m=H[e+40>>2];g=m|1;H[e+40>>2]=g;h=4097;h:{i:{if((l|0)==-1){break i}if((l|0)<0|d){break h}l=J[c+50>>1];if((l-1|0)!=(j|0)){break h}if(I[c+55|0]&8|!(!I[c+54|0]|(l|0)!=1)&(k|0)==2){break i}h=65537}g=h|m;H[e+40>>2]=g}h=0;if(I[p+25|0]<2){break e}g=g|2097152;H[e+40>>2]=g;break e}if(k&256){g=H[e+40>>2]|8;H[e+40>>2]=g;h=0;break e}i=H[e+40>>2];if(k&36){H[e+40>>2]=i|34;E=e,K=UA(t,H[b+40>>2],c,j,f),G[E+26>>1]=K;if(!(F[f+11|0]&1)){g=H[e+40>>2];h=0;i=f;n=0;break e}if(Vi(o,e,J[e+44>>1]+1|0)){break b}i=J[e+44>>1];G[e+44>>1]=i+1;n=f+48|0;H[H[e+52>>2]+(i<<2)>>2]=n;G[e+28>>1]=1;g=H[e+40>>2]|16;H[e+40>>2]=g;h=0;i=f;break e}H[e+40>>2]=i|18;E=e,K=UA(t,H[b+40>>2],c,j,f),G[E+28>>1]=K;h=0;g=H[e+40>>2];i=g&32?H[(H[e+52>>2]+(J[e+44>>1]<<2)|0)-8>>2]:0;n=f}j:{if(g&2){g=G[e+22>>1];f=TA(n,TA(i,g));g=g+((i?-1:0)-((n|0)!=0)|0)|0;f=(!i|!n|G[i+8>>1]<=0?f:G[n+8>>1]>0?f-20|0:f)<<16>>16;f=(f|0)>10?f:10;G[e+22>>1]=(f|0)>(g|0)?g:f;g=H[e+40>>2];f=J[e+22>>1];break j}l=J[e+24>>1]+1|0;G[e+24>>1]=l;f=G[f+8>>1];if(!(G[H[c+4>>2]+(j<<1)>>1]<0|(f|0)>0)){f=J[e+22>>1]+(f-h|0)|0;break j}f=H[c+8>>2]+((l&65535)<<1)|0;f=J[e+22>>1]+(J[f>>1]-J[f-2>>1]|0)|0;f=k&256?f+10|0:f}k=Je(u,(f+((N(G[c+48>>1],15)|0)/G[H[b+16>>2]+40>>1]|0)<<16)+65536>>16);if(!(g&320)){k=Je(k,(f<<16)- -1048576>>16)}h=d+h|0;G[e+22>>1]=h+f;G[e+20>>1]=h+k;Mr(H[a+4>>2],e,B);g=Ik(a,e);k=f;f=H[e+40>>2];G[e+22>>1]=f&2?q:k;k:{if(f&16){break k}f=J[e+24>>1];if(f>>>0>=J[c+52>>1]|((I[c+55|0]|I[c+56|0]<<8)&3)==2&f>>>0>=J[c+50>>1]){break k}Lr(a,b,c,h<<16>>16)}G[e+22>>1]=q}f=Wi(p);continue}break}G[e+46>>1]=y;G[e+28>>1]=v;G[e+26>>1]=z;G[e+24>>1]=j;H[e>>2]=w;H[e+4>>2]=x;H[e+40>>2]=s;G[e+44>>1]=r;G[e+22>>1]=q;if((j|0)!=(y|0)){break a}f=j+1|0;if((j|0)!=(r|0)|f>>>0>=J[c+50>>1]|((I[c+55|0]|I[c+56|0]<<8)&192)!=128|(I[o+81|0]&64|G[H[c+8>>2]+(f<<1)>>1]<42)){break a}g=Vi(o,e,A);if(g){break a}G[e+24>>1]=J[e+24>>1]+1;G[e+46>>1]=J[e+46>>1]+1;i=J[e+44>>1];G[e+44>>1]=i+1;g=0;H[H[e+52>>2]+(i<<2)>>2]=0;H[e+40>>2]=H[e+40>>2]|32768;i=H[c+8>>2];f=J[i+(j<<1)>>1]-J[i+(f<<1)>>1]|0;G[e+22>>1]=J[e+22>>1]-f;Lr(a,b,c,(d+f<<16)+327680>>16);G[e+46>>1]=j;G[e+24>>1]=j;G[e+22>>1]=q;H[e+40>>2]=s}Ga=p+96|0;return g}function Zz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;s=Ga-16|0;Ga=s;H[s+12>>2]=b;a:{if(!d){n=1;break a}i=s+12|0;while(1){H[i>>2]=b;if(b){h=H[b+24>>2];i=h>>>0>c>>>0?i:b+16|0;n=(c>>>0>=h>>>0)+n|0;b=H[b+16>>2];continue}break}b=H[s+12>>2]}H[a+208>>2]=H[a+208>>2]+n;if(H[b+24>>2]==1){zp(b)}p=H[a+168>>2];n=b;v=c;q=I[a+11|0];j=Ga-48|0;Ga=j;f=H[a+232>>2];c=Lf(f);if(Ob(f+52|0,c,48)){h=H[c+16>>2]+1|0}else{h=0}c=0;i=Ga-16|0;Ga=i;b:{if(J[f+40>>1]){break b}c:{if(!H[pi(f)>>2]){break c}Oe(4,i+12|0);c=sg(f,4,4);if((c|0)==5){break c}if(c){break b}Xv(f,H[i+12>>2]);Qe(f,4,4)}dh(f,3);G[f+40>>1]=65535;while(1){l=l+1|0;c=Wv(f,i+8|0,1,l);if((c|0)==-1){continue}break}}Ga=i+16|0;e=c;d:{if(c){break d}l=H[f+68>>2];e:{if(l){break e}c=j+16|0;Cb(c,931071618);Cb(c|4,3007e3);Cb(c|8,p);e=c|12;c=H[f+112>>2];Cb(e,c);if(!c){Oe(8,f+84|0)}c=H[f+88>>2];H[j+32>>2]=H[f+84>>2];H[j+36>>2]=c;c=j+16|0;tg(1,c,24,0,j+8|0);i=H[j+8>>2];Cb(j+40|0,i);g=H[j+12>>2];Cb(j+44|0,g);H[f+80>>2]=g;H[f+76>>2]=i;F[f+65|0]=0;H[f+36>>2]=p;F[f+47|0]=1;e=Bc(H[f+8>>2],c,32,0,0);if(e){break d}if(!I[f+48|0]){break e}e=Ge(H[f+8>>2],q>>>2&3);if(e){break d}}H[j+16>>2]=f;x=H[f+8>>2];H[j+32>>2]=q;H[j+24>>2]=0;H[j+28>>2]=0;H[j+20>>2]=x;H[j+36>>2]=p;c=p+24|0;r=c;t=c>>31;i=SK(c,t,l,0)+32|0;c=Ja;o=i;i=i>>>0<32?c+1|0:c;c=b;while(1){if(c){e=j+16|0;f:{g:{h:{i:{if(!h){break i}if(!(H[c+16>>2]|!d)){l=l+1|0;g=0;break h}H[j+8>>2]=0;_v(f,H[c+24>>2],j+8|0);g=H[j+8>>2];if(g>>>0<h>>>0){break i}e=H[f+104>>2];if(!(e>>>0<=g>>>0?e:0)){H[f+104>>2]=g}k=H[f+8>>2];m=H[c+4>>2];e=SK(g-1|0,0,r,t)+56|0;g=Ja;e=Bc(k,m,p,e,e>>>0<56?g+1|0:g);if(e){break d}G[c+28>>1]=J[c+28>>1]&65471;break f}l=l+1|0;g=0;if(!d){break g}g=H[c+16>>2]}g=g?0:v}e=Zv(e,c,g,o,i);if(e){break d}G[c+28>>1]=J[c+28>>1]|64;i=i+t|0;g=r+o|0;i=g>>>0<r>>>0?i+1|0:i;o=g;y=c}c=H[c+16>>2];continue}break}j:{if(!d){e=0;c=0;break j}if(H[f+104>>2]){u=Ga-32|0;Ga=u;h=H[f+36>>2]+24|0;c=Ub(h);k:{if(!c){e=7;break k}m=H[f+8>>2];e=H[f+104>>2];l:{if((e|0)==1){g=h>>31;e=0;k=24;break l}g=h>>31;k=SK(h,g,e-2|0,0)+48|0;e=Ja;e=k>>>0<48?e+1|0:e}e=Jc(m,c,8,k,e);C=f,D=eb(c),H[C+76>>2]=D;z=c+4|0;C=f,D=eb(z),H[C+80>>2]=D;m=H[f+104>>2];H[f+104>>2]=0;A=c+24|0;while(1){if(!(l>>>0<m>>>0|e)){B=H[f+8>>2];e=h;w=SK(e,g,m-1|0,0)+32|0;k=Ja;k=w>>>0<32?k+1|0:k;e=Jc(B,c,e,w,k);if(!e){Tv(f,eb(c),eb(z),A,u);e=Bc(H[f+8>>2],u,24,w,k)}m=m+1|0;continue}break}Wa(c)}Ga=u+32|0;if(e){break d}}q=q&3;m:{if(!q){c=0;e=0;break m}n:{if(!I[f+49|0]){c=0;break n}g=dw(H[f+8>>2]);h=g+o|0;c=i;c=g>>>0>h>>>0?c+1|0:c;e=h;h=e-1|0;e=c-!e|0;c=UK(h,e,g,0);m=h-c|0;H[j+24>>2]=m;k=e-(Ja+(c>>>0>h>>>0)|0)|0;H[j+28>>2]=k;c=0;h=o;g=i;while(1){if(h>>>0<m>>>0&(g|0)<=(k|0)|(g|0)<(k|0)){e=Zv(j+16|0,y,v,h,g);if(e){break d}c=c+1|0;e=g+t|0;h=h+r|0;e=h>>>0<r>>>0?e+1|0:e;g=e;continue}break}e=0;if((m|0)!=(o|0)|(i|0)!=(k|0)){break m}}e=Ge(x,q)}if(!I[f+47|0]){break j}h=H[f+16>>2];i=H[f+20>>2];if((i|0)<0){break j}g=SK(c+l|0,0,r,t)+32|0;k=Ja;k=g>>>0<32?k+1|0:k;o=h;h=(i|0)<=(k|0)&g>>>0>h>>>0|(i|0)<(k|0);Yv(f,h?g:o,h?k:i);F[f+47|0]=0}l=H[f+68>>2];while(1){if(!(!n|e)){e=0;if(I[n+28|0]&64){l=l+1|0;e=up(f,l,H[n+24>>2])}n=H[n+16>>2];continue}break}while(1){if(!((c|0)<=0|e)){c=c-1|0;l=l+1|0;e=up(f,l,H[y+24>>2]);continue}break}if(e){break d}H[f+68>>2]=l;G[f+66>>1]=p&65280|p>>>16;e=0;if(!d){break d}H[f+72>>2]=v;H[f+60>>2]=H[f+60>>2]+1;tp(f);H[f+12>>2]=l}Ga=j+48|0;o:{if(!H[a+96>>2]|e){break o}while(1){if(!b){break o}yp(H[a+96>>2],H[b+24>>2],H[b+4>>2]);b=H[b+16>>2];continue}}Ga=s+16|0;return e}function JK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=Ga-32|0;Ga=e;p=1;c=H[b+4>>2];a:{if(c&4){break a}f=H[a>>2];g=H[a+24>>2];if(!(c&64)){ve(f,b,g);p=H[f+36>>2]?2:1;break a}m=H[b+52>>2];n=H[f>>2];i=e|4;a=b;while(1){if(a){H[a+4>>2]=H[a+4>>2]|4;H[i+16>>2]=0;H[i+20>>2]=0;H[i+8>>2]=0;H[i+12>>2]=0;H[i>>2]=0;H[i+4>>2]=0;H[e+28>>2]=a;H[e>>2]=f;p=2;if(ld(e,H[a+60>>2])){break a}c=a;if(F[a+6|0]&1){H[H[H[c+32>>2]+28>>2]+48>>2]=H[c+48>>2];H[c+48>>2]=0}a=0;while(1){d=H[c+32>>2];if(H[d>>2]>(a|0)){j=d+(a<<6)|0;o=H[j+28>>2];b:{if(!o|I[o+4|0]&4){break b}h=g?H[g+16>>2]:0;k=H[f+248>>2];d=H[j+16>>2];if(d){H[f+248>>2]=d}bC(f,o,g);H[f+248>>2]=k;if(H[f+36>>2]){break a}if(!g){break b}d=(I[j+45|0]|I[j+46|0]<<8)&65527|((h|0)<H[g+16>>2])<<3;F[j+45|0]=d;F[j+46|0]=d>>>8}a=a+1|0;continue}break}H[e+12>>2]=g;H[e+4>>2]=d;H[e+24>>2]=16385;if($e(e,H[c+28>>2])){break a}k=H[c+40>>2];a=H[e+24>>2];c:{if(a&16?1:k){H[c+4>>2]=H[c+4>>2]|a&134221824|8;d=a&-16385;break c}d=a&-16386}a=H[c+28>>2];H[e+24>>2]=d|128;H[e+8>>2]=a;a=H[c+44>>2];if(a){if(!(I[c+4|0]&8)){Za(f,1193,0);break a}if(ld(e,a)){break a}}a=0;if(ld(e,H[c+36>>2])){break a}while(1){d=H[c+32>>2];if(H[d>>2]>(a|0)){d=d+(a<<6)|0;if(I[d+45|0]&4){if($e(e,H[d- -64>>2])){break a}}a=a+1|0;continue}break}d:{if(I[f+208|0]<2){break d}h=c+72|0;while(1){a=H[h>>2];if(!a){break d}if($e(e,H[a+12>>2])){break a}h=a+36|0;if(!$e(e,H[a+8>>2])){continue}break}break a}H[e+12>>2]=0;H[e+24>>2]=H[e+24>>2]|16385;if(F[c+6|0]&1){a=H[H[c+32>>2]+28>>2];H[c+48>>2]=H[a+48>>2];H[a+48>>2]=0}a=H[c+48>>2];if(!(!a|!q&(m|0)!=0)){if(aC(e,c,a,18830)){break a}}if(I[n+87|0]){break a}H[e+24>>2]=H[e+24>>2]&-16385;e:{if(!k){break e}if(aC(e,c,k,19172)|I[n+87|0]){break a}a=0;d=H[k>>2];d=(d|0)>0?d:0;h=k+8|0;while(1){if((a|0)==(d|0)){break e}if(I[H[h>>2]+4|0]&16){Za(f,12590,0);break a}else{h=h+16|0;a=a+1|0;continue}}}d=H[c+56>>2];if(!(!d|H[H[c+28>>2]>>2]==H[H[d+28>>2]>>2])){a=Ga-16|0;Ga=a;f:{if(I[d+5|0]&2){Za(f,4905,0);break f}r=a,s=ij(I[d|0]),H[r>>2]=s;Za(f,4716,a)}Ga=a+16|0;break a}q=q+1|0;a=H[c+52>>2];continue}break}if(m){p=2;h=0;i=Ga-16|0;Ga=i;j=H[b+48>>2];g:{if(!j){b=0;break g}a=H[j>>2];m=H[f>>2];h:{if((a|0)<=H[m+128>>2]){a=(a|0)>0?a:0;c=0;while(1){if((a|0)!=(c|0)){k=j+(c<<4)|0;d=(I[k+17|0]|I[k+18|0]<<8)&65531;F[k+17|0]=d;F[k+18|0]=d>>>8;c=c+1|0;continue}break}while(1){a=b;H[a+56>>2]=h;h=a;b=H[a+52>>2];if(b){continue}break}q=j+8|0;d=1;i:while(1){if(!(d?a:0)){b=0;a=H[j>>2];d=(a|0)>0?a:0;c=0;while(1){if((c|0)==(d|0)){break g}a=c<<4;c=c+1|0;if(I[(a+j|0)+17|0]&4){continue}break}H[i>>2]=c;Za(f,3087,i);break h}o=H[a+28>>2];c=0;b=q;h=0;while(1){d=c;j:{k:{if(H[j>>2]>(h|0)){H[i+12>>2]=-1;if(I[b+9|0]&4){break k}g=jd(H[b>>2]);if(!g){break k}l:{if(Ng(g,i+12|0)){l=H[i+12>>2];c=H[o>>2];if((l|0)>0&(c|0)>=(l|0)){break l}hs(f,18830,h+1|0,c,g);break h}l=XB(o,g);if(!l){l=0;c=nb(m,g,0);m:{if(I[m+87|0]){break m}l=WB(f,a,c);if(I[f+208|0]<2|(l|0)<=0){break m}WB(f,a,g)}fb(m,c)}c=1;if((l|0)<=0){break j}}if(I[f+208|0]<=1){n=sc(m,155,0);if(!n){break h}H[n+8>>2]=l;H[n+4>>2]=H[n+4>>2]|2048;c=H[b>>2];if((g|0)!=(c|0)){while(1){k=c;c=H[c+12>>2];if(I[c|0]==113){continue}break}c=k+12|0}else{c=b}H[c>>2]=n;fb(m,g);G[b+12>>1]=l}c=I[b+9|0]|I[b+10|0]<<8|4;F[b+9|0]=c;F[b+10|0]=c>>>8;break k}a=H[a+56>>2];continue i}c=d}b=b+16|0;h=h+1|0;continue}}}Za(f,12556,0)}b=1}Ga=i+16|0;if(b){break a}}p=1}Ga=e+32|0;return p|0}function If(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=Ga-16|0;Ga=k;H[k+12>>2]=0;o=H[a+48>>2];n=H[a+12>>2];p=eb(H[n+56>>2]+36|0);a:{if(o>>>0<=p>>>0){f=ab(73125);break a}b:{c:{if(p){d:{e:{switch(e-1|0){case 0:if(d>>>0>o>>>0){break d}f=Hj(a,d,k+11|0,0);if(f){break a}i=I[k+11|0]==2;break d;case 1:break e;default:break d}}i=1}f=_b(H[n+72>>2]);if(f){break a}Cb(H[n+56>>2]+36|0,p-1|0);while(1){f:{g:{l=h;h:{if(h){g=eb(H[l+56>>2]);break h}g=eb(H[n+56>>2]+32|0)}if(g>>>0<=o>>>0){f=q+1|0;if(q>>>0<=p>>>0){break g}q=f}f=ab(73181);break f}q=f;f=Gj(a,g,k+12|0,0)}if(f){h=0;H[k+12>>2]=0;break b}i:{j:{k:{l:{m:{h=H[k+12>>2];j=H[h+56>>2];s=j+4|0;m=eb(s);r=i&255;n:{if(!(m|r)){f=_b(H[h+72>>2]);if(f){break b}H[c>>2]=g;f=H[n+56>>2];g=H[h+56>>2];g=I[g|0]|I[g+1|0]<<8|(I[g+2|0]<<16|I[g+3|0]<<24);F[f+32|0]=g;F[f+33|0]=g>>>8;F[f+34|0]=g>>>16;F[f+35|0]=g>>>24;H[b>>2]=h;break n}if((H[a+40>>2]>>>2|0)-2>>>0<m>>>0){f=ab(73210);break b}if(!r|((e|0)==2&d>>>0>g>>>0?0:(d|0)!=(g|0))){break m}H[c>>2]=g;H[b>>2]=h;f=_b(H[h+72>>2]);if(f){break b}if(!m){if(!l){f=H[n+56>>2];h=H[h+56>>2];h=I[h|0]|I[h+1|0]<<8|(I[h+2|0]<<16|I[h+3|0]<<24);F[f+32|0]=h;F[f+33|0]=h>>>8;F[f+34|0]=h>>>16;F[f+35|0]=h>>>24;break n}f=_b(H[l+72>>2]);if(f){break b}f=H[l+56>>2];h=H[h+56>>2];h=I[h|0]|I[h+1|0]<<8|(I[h+2|0]<<16|I[h+3|0]<<24);F[f|0]=h;F[f+1|0]=h>>>8;F[f+2|0]=h>>>16;F[f+3|0]=h>>>24;break n}i=eb(H[h+56>>2]+8|0);if(i>>>0>o>>>0){f=ab(73244);break b}f=Gj(a,i,k+4|0,0);if(f){break b}g=H[k+4>>2];f=_b(H[g+72>>2]);if(f){Gb(g);break b}f=H[g+56>>2];j=H[h+56>>2];j=I[j|0]|I[j+1|0]<<8|(I[j+2|0]<<16|I[j+3|0]<<24);F[f|0]=j;F[f+1|0]=j>>>8;F[f+2|0]=j>>>16;F[f+3|0]=j>>>24;f=m-1|0;Cb(H[g+56>>2]+4|0,f);Ya(H[g+56>>2]+8|0,H[h+56>>2]+12|0,f<<2);Gb(g);if(!l){Cb(H[n+56>>2]+32|0,i);break n}f=_b(H[l+72>>2]);if(f){break b}Cb(H[l+56>>2],i)}h=0;H[k+12>>2]=0;break l}if(!m){break j}o:{if(!d){g=0;break o}g=0;f=0;if((e|0)==2){while(1){if((f|0)==(m|0)){break o}if(eb(((f<<2)+j|0)+8|0)>>>0<=d>>>0){g=f;break o}else{f=f+1|0;continue}}}f=1;i=Jl(eb(j+8|0)-d|0);while(1){if((f|0)==(m|0)){break o}t=Jl(eb(((f<<2)+j|0)+8|0)-d|0);u=(t|0)<(i|0);i=u?t:i;g=u?f:g;f=f+1|0;continue}}i=(g<<2)+j|0;f=eb(i+8|0);if(!(f>>>0<=o>>>0&f>>>0>1)){f=ab(73309);break b}if(!((e|0)==2&d>>>0>f>>>0|(!r|(d|0)==(f|0)))){f=0;i=1;break i}H[c>>2]=f;f=_b(H[h+72>>2]);if(f){break b}f=g;g=m-1|0;if(f>>>0<g>>>0){f=(m<<2)+j|0;f=I[f+4|0]|I[f+5|0]<<8|(I[f+6|0]<<16|I[f+7|0]<<24);F[i+8|0]=f;F[i+9|0]=f>>>8;F[i+10|0]=f>>>16;F[i+11|0]=f>>>24}Cb(s,g);i=0;f=H[c>>2];g=H[a+64>>2];if(g){if(f>>>0<=K[g>>2]){g=(Tl(g,f)|0)!=0}else{g=1}}else{g=0}f=Gj(a,f,b,!g);if(f){break i}f=_b(H[H[b>>2]+72>>2]);if(f){break k}}i=0;break j}Gb(H[b>>2]);H[b>>2]=0;break i}f=0}Gb(l);l=i&255;i=1;if(l){continue}break}break c}e=I[a+19|0];f=_b(H[n+72>>2]);if(f){break a}d=H[a+48>>2];f=d+1|0;H[a+48>>2]=f;if((d|0)==(K[16164]/K[a+36>>2]|0)){f=d+2|0;H[a+48>>2]=f}d=!e;p:{if(!I[a+17|0]){break p}if((Ud(a,f)|0)!=(f|0)){break p}H[k>>2]=0;f=Gj(a,f,k,d);if(f){break a}e=H[k>>2];f=_b(H[e+72>>2]);Gb(e);if(f){break a}e=H[a+48>>2];f=e+1|0;H[a+48>>2]=f;if((e|0)!=(K[16164]/K[a+36>>2]|0)){break p}f=e+2|0;H[a+48>>2]=f}Cb(H[H[a+12>>2]+56>>2]+28|0,f);e=c;c=H[a+48>>2];H[e>>2]=c;f=Gj(a,c,b,d);if(f){break a}f=_b(H[H[b>>2]+72>>2]);if(!f){f=0;break b}Gb(H[b>>2]);H[b>>2]=0}l=0}Gb(h);Gb(l)}Ga=k+16|0;return f}function sB(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;m=Ga-16|0;Ga=m;H[m+4>>2]=0;j=H[a>>2];w=H[j>>2];k=7;t=H[a+4>>2];f=H[t+12>>2];q=(f|0)>0?f:0;f=H[t+24>>2];o=H[a+8>>2];i=H[j+4>>2]+(I[o+16|0]<<6)|0;r=H[i+24>>2];u=H[j+8>>2];p=H[j>>2];while(1){if((g|0)!=(q|0)){h=J[f+10>>1];G[f+10>>1]=h&65471;v=H[f+20>>2];a:{if((v|0)!=H[i+48>>2]|(d&H[f+32>>2]|e&H[f+36>>2])|(!(J[f+12>>1]&63487)|h&128)){break a}if(I[i+44|0]&88){s=H[f>>2];if(!(I[s+4|0]&3)|(v|0)!=H[s+36>>2]){break a}}G[f+10>>1]=h|64;l=l+1|0}f=f+48|0;g=g+1|0;continue}break}b:{if(!u){i=0;d=0;break b}h=H[u>>2];e=(h|0)>0?h:0;f=0;c:{while(1){if((e|0)==(f|0)){break c}d:{g=(f<<4)+u|0;d=H[g+8>>2];e:{if(Me(d)){break e}if(I[g+16|0]&2){break d}g=I[d|0];if((g|0)!=113){if((g|0)!=167|H[d+28>>2]!=H[i+48>>2]){break d}break e}g=H[d+12>>2];if(I[g|0]!=167|H[g+28>>2]!=H[i+48>>2]){break d}G[d+32>>1]=J[g+32>>1];g=G[g+32>>1];if((g|0)<0){break e}q=H[d+8>>2];d=Of(H[r+4>>2]+N(g&65535,12)|0);if(Qb(q,d?d:32112)){break d}}f=f+1|0;continue}break}e=f}i=0;d=0;if((e|0)!=(h|0)){break b}i=h;d=J[j+44>>1];f:{if(d&128){d=d>>>9&1|2;break f}d=d>>>6&1}}e=d;g:{f=i<<3;d=yb(H[p>>2],(f+N(l,24)|0)+96|0,0);if(!d){Za(p,1141,0);break g}H[d+72>>2]=t;H[d+84>>2]=0;H[d+80>>2]=e;H[d+76>>2]=p;p=((l<<2)+d|0)+92|0;H[d+4>>2]=p;q=p+N(l,12)|0;H[d+12>>2]=q;H[d+16>>2]=f+q;e=H[t+12>>2];v=(e|0)>0?e:0;f=H[t+24>>2];r=0;l=0;g=0;while(1){h:{i:{j:{k:{if((g|0)!=(v|0)){s=J[f+10>>1];if(!(s&64)){break h}e=H[f+24>>2];j=p+N(n,12)|0;H[j+8>>2]=g;H[j>>2]=e;l:{h=J[f+12>>1];e=h&16383;if((e|0)!=64){if((e|0)!=1){break l}if(s<<16>>16<0){break k}r=((n|0)<32?1<<n:0)|r;H[d+84>>2]=r;break k}F[j+4|0]=I[f+15|0];break i}if(!(e&384)){break j}if((e|0)==256){F[j+4|0]=71;break i}F[j+4|0]=72;break i}H[d>>2]=n;h=0;e=(i|0)>0?i:0;f=0;while(1){if((e|0)!=(f|0)){i=(f<<4)+u|0;g=H[i+8>>2];if(!Me(g)){n=q+(h<<3)|0;H[n>>2]=G[g+32>>1];F[n+4|0]=F[i+16|0]&1;h=h+1|0}f=f+1|0;continue}break}H[d+8>>2]=h;G[m+10>>1]=l;break g}h=2;e=2}F[j+4|0]=h;if(!(e&60)){break i}if(!Ze(H[H[f>>2]+16>>2])){break i}l=((n|0)<16?1<<n:0)|l;e=h&16383;if((e|0)!=4){if((e|0)!=16){break i}F[j+4|0]=8;break i}F[j+4|0]=32}n=n+1|0}f=f+48|0;g=g+1|0;continue}}f=d;m:{if(!f){break m}G[o+44>>1]=0;H[o+40>>2]=1024;G[o+18>>1]=0;F[o+28|0]=I[o+28|0]&254;d=H[f>>2];if(Vi(H[w>>2],o,d)){aB(H[w>>2],f);break m}h=J[m+10>>1];k=Ui(a,b,c,-1,-1,0,f,h,m+12|0,m+4|0);if(H[m+4>>2]){k=Ui(a,b,c,-1,-1,0,f,h,m+12|0,0)}n:{if(k){break n}e=H[m+12>>2];g=c^-1;i=g&H[o+4>>2];u=i;n=b^-1;p=n&H[o>>2];if(!(i|p)){k=0;if(!e){break n}}k=0;q=(d|0)>0?d:0;if(e){k=Ui(a,b,c,-1,-1,1,f,h,m+12|0,0);d=g&H[o+4>>2];B=d;z=n&H[o>>2];x=!(d|z)}i=x;while(1){if(k){break n}d=-1;e=-1;k=0;while(1){if((k|0)!=(q|0)){l=H[t+24>>2]+N(H[(H[f+4>>2]+N(k,12)|0)+8>>2],48)|0;j=n&H[l+32>>2];l=g&H[l+36>>2];r=(l|0)==(e|0)&d>>>0>j>>>0|e>>>0>l>>>0;s=r?j:d;j=(l|0)==(y|0)&j>>>0>A>>>0|l>>>0>y>>>0;d=j?s:d;e=j?r?l:e:e;k=k+1|0;continue}break}if((d&e)!=-1){k=0;y=e;A=d;if((d|0)==(p|0)&(e|0)==(u|0)|(d|0)==(z|0)&(e|0)==(B|0)){continue}k=Ui(a,b,c,b|A,c|y,0,f,h,m+12|0,0);if((b|0)!=H[o>>2]|(c|0)!=H[o+4>>2]){continue}x=1;i=H[m+12>>2]?i:1;continue}break}k=0;if(!x){k=Ui(a,b,c,b,c,0,f,h,m+12|0,0);i=H[m+12>>2]?i:1}if(i|k){break n}k=Ui(a,b,c,b,c,1,f,h,m+12|0,0)}if(H[f+28>>2]){Wa(H[f+24>>2])}aB(H[w>>2],f)}Ga=m+16|0;return k}function _f(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=H[a+4>>2];g=H[e>>2];Jb(a);a:{b:{d=I[a+8|0];if((d|0)==2|!b&(d|0)==1){break b}if(!(I[g+14|0]|!(I[H[a>>2]+35|0]&2))){G[e+24>>1]=J[e+24>>1]&65534}f=J[e+24>>1];if(b){d=8;if(f&1){break a}}c:{d:{e:{if(b){if(f&128|I[e+20|0]==2){break e}if((b|0)<2){break c}f=e+76|0;while(1){d=H[f>>2];if(!d){break c}f=d+12|0;i=H[d>>2];if((i|0)==(a|0)){continue}break}break d}if(!(f&128)){break c}}i=H[e+80>>2]}d=262;if(H[i>>2]){break a}}d=Hr(a,1,1);if(d){break a}d=J[e+24>>1];G[e+24>>1]=d&65519;if(!H[e+48>>2]){G[e+24>>1]=d|16}o=(b|0)>1;f=0;while(1){f:{if(!H[e+12>>2]){f=0;j=Ga-16|0;Ga=j;H[j+8>>2]=0;d=wv(H[e>>2]);g:{if(d){break g}d=xd(e,1,j+12|0,0);if(d){break g}n=H[j+12>>2];h=H[n+56>>2];i=eb(h+28|0);k=H[e>>2];Vr(k,j+8|0);h:{i:{i=((I[h+24|0]|I[h+25|0]<<8|(I[h+26|0]<<16|I[h+27|0]<<24))==(I[h+92|0]|I[h+93|0]<<8|(I[h+94|0]<<16|I[h+95|0]<<24))?i:0)?i:H[j+8>>2];j:{if(i?I[H[e+4>>2]+35|0]&2:1){l=H[e+40>>2];i=0;break j}d=26;if(Ob(h,32032,16)){break h}if(I[h+18|0]>=3){G[e+24>>1]=J[e+24>>1]|1}l=I[h+19|0];if(l>>>0>2){break h}k:{if(I[e+24|0]&32|(l|0)!=2){break k}H[j+4>>2]=0;k=vv(k,j+4|0);if(k){break i}if(H[j+4>>2]){break k}vk(n);d=0;break g}if(Ob(h+21|0,29325,3)){break h}m=I[h+17|0]<<16|I[h+16|0]<<8;if(m-65537>>>0<4294902016|m-1&m){break h}G[e+24>>1]=J[e+24>>1]|2;k=I[h+20|0];l=m-k|0;if(H[e+36>>2]!=(m|0)){vk(n);H[e+36>>2]=m;H[e+40>>2]=l;Gp(e);d=ui(H[e>>2],e+36|0,k);break g}l:{k=H[j+8>>2];if(k>>>0>=i>>>0){break l}i=k;if(Jf(H[e+4>>2])){break l}d=ab(70154);break h}if(l>>>0<480){break h}H[e+40>>2]=l;H[e+36>>2]=m;p=e,q=(eb(h+52|0)|0)!=0,F[p+17|0]=q;p=e,q=(eb(h- -64|0)|0)!=0,F[p+18|0]=q}H[e+48>>2]=i;H[e+12>>2]=n;G[e+30>>1]=l-35;d=(((l<<5)-384>>>0)/255|0)-23|0;G[e+32>>1]=d;G[e+28>>1]=d;d=(((l<<6)-768>>>0)/255|0)-23|0;G[e+26>>1]=d;d=d&65535;F[e+21|0]=d>>>0<127?d:127;d=0;break g}d=k}vk(n);H[e+12>>2]=0}Ga=j+16|0;if(!d){continue}break f}m:{n:{if(!b){d=f;break n}d=f;if(d){break n}d=8;if(F[e+24|0]&1){break f}f=Er(H[a>>2]);d=H[g+44>>2];o:{if(d){break o}F[g+22|0]=f;d=0;if(I[g+17|0]!=1){break o}d=H[g+232>>2];p:{if(d){q:{if(!I[g+4|0]){break q}if(!kp(d,-1)){break q}d=qg(g,4);if(d){break o}kp(H[g+232>>2],1)}f=8;d=H[g+232>>2];r:{if(I[d+46|0]){break r}f=sg(d,0,1);if(f){break r}F[d+44|0]=1;f=0;if(!Ob(d+52|0,Lf(d),48)){break r}Qe(d,0,1);F[d+44|0]=0;f=517}d=f;break p}d=qg(g,2);if(d|!o){break p}d=op(g,4)}if(d){break o}F[g+17|0]=2;H[g+80>>2]=0;H[g+84>>2]=0;d=H[g+28>>2];H[g+40>>2]=d;H[g+36>>2]=d;H[g+32>>2]=d;d=0}if((d|0)==517){break m}if(d){break n}d=Ar(e)}if(d){break f}s:{if(I[a+8|0]){break s}H[e+44>>2]=H[e+44>>2]+1;if(!I[a+9|0]){break s}F[a+40|0]=1;H[a+44>>2]=H[e+76>>2];H[e+76>>2]=a+32}d=b?2:1;F[a+8|0]=d;if(d>>>0>I[e+20|0]){F[e+20|0]=d}if(!b){break b}H[e+80>>2]=a;G[e+24>>1]=J[e+24>>1]&65471|((b|0)>1)<<6;f=H[e+12>>2];if(H[e+48>>2]==(eb(H[f+56>>2]+28|0)|0)){break b}d=_b(H[f+72>>2]);if(d){break a}Cb(H[f+56>>2]+28|0,H[e+48>>2]);break b}d=I[e+20|0]?517:5}vr(e);if(I[e+20|0]|(d&255)!=5){break a}f=d;if(zA(e)){continue}break}break a}if(c){p=c,q=eb(H[H[e+12>>2]+56>>2]+40|0),H[p>>2]=q}if(!b){return 0}d=yA(g,H[H[a>>2]+500>>2])}return d}function rB(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=Ga-80|0;Ga=h;G[h+2>>1]=65535;p=H[a>>2];m=H[p+4>>2]+8|0;e=H[a+8>>2];o=I[e+16|0];j=m+(o<<6)|0;k=H[j+16>>2];r=H[a+4>>2];a:{if(I[j+37|0]&2){f=H[j+60>>2];break a}if(I[k+28|0]&128){f=H[k+8>>2];break a}f=h+8|0;$a(f,0,72);F[h+62|0]=5;G[h+58>>1]=1;G[h+60>>1]=1;H[h+16>>2]=h+4;H[h+12>>2]=h+2;H[h+20>>2]=k;l=J[k+40>>1];F[h+63|0]=3;F[h+64|0]=0;G[h+56>>1]=l;l=J[k+38>>1];G[h+6>>1]=0;G[h+4>>1]=l;if(F[j+37|0]&1){break a}H[h+28>>2]=H[H[j+16>>2]+8>>2]}b:{if(!(I[H[H[p>>2]>>2]+33|0]&128)|(H[a+12>>2]|J[p+44>>1]&4128)){break b}l=I[j+37|0]|I[j+38|0]<<8;if(I[j+36|0]&16|(l&3|(l&64|(I[k+28|0]&128|l&8)))){break b}g=H[r+24>>2];q=g+N(H[r+12>>2],48)|0;d=J[k+38>>1];n=cn(d<<16>>16);d=d+n|0;l=d-10|0;i=d+28|0;d=0;while(1){if(g>>>0>=q>>>0|d){break b}d=0;c:{if(H[e+8>>2]&H[g+32>>2]|H[e+12>>2]&H[g+36>>2]){break c}if(!Qr(g,j,0,0)){break c}G[e+24>>1]=1;H[e+44>>2]=1;H[e+32>>2]=0;H[H[e+52>>2]>>2]=g;d:{if(I[k+43|0]!=2){d=i;if(!(I[k+29|0]&64)){break d}}d=l}G[e+22>>1]=43;d=d<<16>>16;G[e+18>>1]=(d|0)>0?d:0;H[e+40>>2]=16384;v=e,w=Je(n,43),G[v+20>>1]=w;d=c|H[g+36>>2];H[e>>2]=b|H[g+32>>2];H[e+4>>2]=d;d=Ik(a,e)}g=g+48|0;continue}}o=m+(o<<6)|0;l=1;while(1){e:{f:{if(!(!f|d)){g:{d=H[f+36>>2];if(!d){break g}if($A(H[o+40>>2],I[j+36|0],r,d)){break g}d=0;break e}d=0;if(F[f+56|0]&1){break e}n=J[H[f+8>>2]>>1];G[e+28>>1]=0;H[e+24>>2]=0;H[e+44>>2]=0;G[e+18>>1]=0;F[e+17|0]=0;H[e+32>>2]=f;G[e+22>>1]=n;H[e>>2]=b;H[e+4>>2]=c;m=H[o+40>>2];i=0;g=0;h:{i:{j:{if(I[f+55|0]&4){break j}q=H[H[a>>2]+8>>2];if(!q){break j}while(1){i=0;if(H[q>>2]<=(g|0)){break h}k:{i=jd(H[(q+(g<<4)|0)+8>>2]);if(!i){break k}if(!(I[i|0]!=167|(m|0)!=H[i+28>>2])){s=G[i+32>>1];if((s|0)<0){break i}t=J[f+50>>1];d=0;while(1){if((d|0)==(t|0)){break k}i=1;u=d<<1;d=d+1|0;if(J[H[f+4>>2]+u>>1]!=(s&65535)){continue}break}break j}d=0;s=H[f+40>>2];if(!s){break k}while(1){if(J[f+50>>1]<=d>>>0){break k}if(J[H[f+4>>2]+(d<<1)>>1]==65534){if(!dn(i,H[(s+(d<<4)|0)+8>>2],m)){break i}}d=d+1|0;continue}}g=g+1|0;continue}}break h}i=1}l:{d=I[f+55|0]|I[f+56|0]<<8;if((d&3)==3){H[e+40>>2]=256;G[e+20>>1]=n+16;F[e+17|0]=i?l:0;Mr(r,e,n<<16>>16);break l}m:{if(d&32){g=0;m=0;d=576;break m}d=H[f+68>>2]&H[o+52>>2];m=d;g=H[f+64>>2]&H[o+48>>2];d=d|g?512:576}H[e+40>>2]=d;d=l;n:{if(i){break n}d=0;if(I[j+37|0]&2|(H[f+36>>2]|I[k+28|0]&128)){break n}if(I[f+55|0]&4|(g|m)|(I[p+44|0]&4|G[f+48>>1]>=G[k+40>>1])){break f}if(!I[64007]|I[H[H[p>>2]>>2]+80|0]&32){break f}}F[e+17|0]=d;G[e+20>>1]=(n+((N(G[f+48>>1],15)|0)/G[k+40>>1]|0)|0)+1;if(g|m){g=n+16|0;q=H[o+40>>2];d=0;while(1){o:{if(H[p+100>>2]<=(d|0)){break o}m=H[p+112>>2]+N(d,48)|0;if(!jB(H[m>>2],q,f)){break o}d=d+1|0;i=G[m+8>>1];if((i|0)>0){i=I[m+12|0]&130?-20:-1}g=g+i|0;continue}break}v=e,w=Je(G[e+20>>1],g<<16>>16),G[v+20>>1]=w}Mr(r,e,n<<16>>16);if(!(I[j+36|0]&16)|!H[f+40>>2]){break l}G[e+22>>1]=n;break f}d=Ik(a,e);G[e+22>>1]=n;if(!d){break f}}Ga=h+80|0;return d}F[a+16|0]=0;d=Lr(a,j,f,0);if(I[a+16|0]!=1){break e}H[k+28>>2]=H[k+28>>2]|256}l=l+1|0;f=I[j+37|0]&2?0:H[f+20>>2];continue}}function Te(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(!a){break a}d=a-8|0;b=H[a-4>>2];a=b&-8;f=d+a|0;b:{if(b&1){break b}if(!(b&3)){break a}b=H[d>>2];d=d-b|0;if(d>>>0<K[17702]){break a}a=a+b|0;if(H[17703]!=(d|0)){if(b>>>0<=255){e=H[d+8>>2];b=b>>>3|0;c=H[d+12>>2];if((c|0)==(e|0)){i=70792,j=H[17698]&YK(-2,b),H[i>>2]=j;break b}H[e+12>>2]=c;H[c+8>>2]=e;break b}h=H[d+24>>2];b=H[d+12>>2];c:{if((d|0)!=(b|0)){c=H[d+8>>2];H[c+12>>2]=b;H[b+8>>2]=c;break c}d:{e=d+20|0;c=H[e>>2];if(c){break d}e=d+16|0;c=H[e>>2];if(c){break d}b=0;break c}while(1){g=e;b=c;e=b+20|0;c=H[e>>2];if(c){continue}e=b+16|0;c=H[b+16>>2];if(c){continue}break}H[g>>2]=0}if(!h){break b}e=H[d+28>>2];c=(e<<2)+71096|0;e:{if(H[c>>2]==(d|0)){H[c>>2]=b;if(b){break e}i=70796,j=H[17699]&YK(-2,e),H[i>>2]=j;break b}H[h+(H[h+16>>2]==(d|0)?16:20)>>2]=b;if(!b){break b}}H[b+24>>2]=h;c=H[d+16>>2];if(c){H[b+16>>2]=c;H[c+24>>2]=b}c=H[d+20>>2];if(!c){break b}H[b+20>>2]=c;H[c+24>>2]=b;break b}b=H[f+4>>2];if((b&3)!=3){break b}H[17700]=a;H[f+4>>2]=b&-2;H[d+4>>2]=a|1;H[a+d>>2]=a;return}if(d>>>0>=f>>>0){break a}b=H[f+4>>2];if(!(b&1)){break a}f:{if(!(b&2)){if(H[17704]==(f|0)){H[17704]=d;a=H[17701]+a|0;H[17701]=a;H[d+4>>2]=a|1;if(H[17703]!=(d|0)){break a}H[17700]=0;H[17703]=0;return}if(H[17703]==(f|0)){H[17703]=d;a=H[17700]+a|0;H[17700]=a;H[d+4>>2]=a|1;H[a+d>>2]=a;return}a=(b&-8)+a|0;g:{if(b>>>0<=255){e=H[f+8>>2];b=b>>>3|0;c=H[f+12>>2];if((c|0)==(e|0)){i=70792,j=H[17698]&YK(-2,b),H[i>>2]=j;break g}H[e+12>>2]=c;H[c+8>>2]=e;break g}h=H[f+24>>2];b=H[f+12>>2];h:{if((f|0)!=(b|0)){c=H[f+8>>2];H[c+12>>2]=b;H[b+8>>2]=c;break h}i:{e=f+20|0;c=H[e>>2];if(c){break i}e=f+16|0;c=H[e>>2];if(c){break i}b=0;break h}while(1){g=e;b=c;e=b+20|0;c=H[e>>2];if(c){continue}e=b+16|0;c=H[b+16>>2];if(c){continue}break}H[g>>2]=0}if(!h){break g}e=H[f+28>>2];c=(e<<2)+71096|0;j:{if(H[c>>2]==(f|0)){H[c>>2]=b;if(b){break j}i=70796,j=H[17699]&YK(-2,e),H[i>>2]=j;break g}H[h+(H[h+16>>2]==(f|0)?16:20)>>2]=b;if(!b){break g}}H[b+24>>2]=h;c=H[f+16>>2];if(c){H[b+16>>2]=c;H[c+24>>2]=b}c=H[f+20>>2];if(!c){break g}H[b+20>>2]=c;H[c+24>>2]=b}H[d+4>>2]=a|1;H[a+d>>2]=a;if(H[17703]!=(d|0)){break f}H[17700]=a;return}H[f+4>>2]=b&-2;H[d+4>>2]=a|1;H[a+d>>2]=a}if(a>>>0<=255){b=(a&-8)+70832|0;c=H[17698];a=1<<(a>>>3);k:{if(!(c&a)){H[17698]=a|c;a=b;break k}a=H[b+8>>2]}H[b+8>>2]=d;H[a+12>>2]=d;H[d+12>>2]=b;H[d+8>>2]=a;return}e=31;if(a>>>0<=16777215){b=a>>>8|0;g=b+1048320>>>16&8;b=b<<g;e=b+520192>>>16&4;b=b<<e;c=b+245760>>>16&2;b=(b<<c>>>15|0)-(c|(e|g))|0;e=(b<<1|a>>>b+21&1)+28|0}H[d+28>>2]=e;H[d+16>>2]=0;H[d+20>>2]=0;g=(e<<2)+71096|0;l:{m:{c=H[17699];b=1<<e;n:{if(!(c&b)){H[17699]=b|c;H[g>>2]=d;H[d+24>>2]=g;break n}e=a<<((e|0)==31?0:25-(e>>>1|0)|0);b=H[g>>2];while(1){c=b;if((H[b+4>>2]&-8)==(a|0)){break m}b=e>>>29|0;e=e<<1;g=c+(b&4)|0;b=H[g+16>>2];if(b){continue}break}H[g+16>>2]=d;H[d+24>>2]=c}H[d+12>>2]=d;H[d+8>>2]=d;break l}a=H[c+8>>2];H[a+12>>2]=d;H[c+8>>2]=d;H[d+24>>2]=0;H[d+12>>2]=c;H[d+8>>2]=a}a=H[17706]-1|0;H[17706]=a?a:-1}}function ID(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=Ga-544|0;Ga=j;m=d&1048320;l=d&4;g=0;a:{if(!l){break a}g=1;if((m|0)==2048){break a}g=1;if((m|0)==16384){break a}g=1;if((m|0)==524288){break a}g=0}q=g;if(H[17624]!=42){H[17624]=42;Oe(0,0)}h=$a(c,0,52);b:{c:{d:{e:{if((m|0)==256){i=Ga-112|0;Ga=i;f:{if(!H[17623]){break f}g:{if(Ka[H[16181]](b,i)|0){break g}f=70492;k=H[i+104>>2];g=H[i+108>>2];c=H[i>>2];while(1){f=H[f>>2];if(!f){break g}if(!((k|0)==H[f+8>>2]&(g|0)==H[f+12>>2]&(c|0)==H[f>>2])){f=f+44|0;continue}break}c=f+32|0;k=d&3;while(1){g=c;f=H[c>>2];if(!f){break g}c=f+8|0;if((k|0)!=H[f+4>>2]){continue}break}H[g>>2]=H[c>>2];break f}f=0}Ga=i+112|0;c=f;if(c){f=H[c>>2];break e}f=-1;c=Ib(12,0);if(c){break e}c=7;break b}f=-1;if(b){break d}c=ev(H[a+8>>2],j+16|0);if(c){break b}g=j+16|0;break c}H[h+28>>2]=c}g=b}n=d&1;h:{i:{j:{if((f|0)>=0){c=d;break j}f=0;p=Ga-528|0;Ga=p;o=j+12|0;H[o>>2]=0;i=j+8|0;H[i>>2]=0;k=j+4|0;H[k>>2]=0;k:{if(d&526336){c=ib(g);while(1){if((c|0)<2){break k}l:{c=c-1|0;switch(I[g+c|0]-45|0){case 1:break k;case 0:break l;default:continue}}break}f=c;c=Ya(p,g,c);F[f+c|0]=0;f=ow(c,o,i,k);break k}if(d&8){H[o>>2]=384;break k}if(!(d&64)){break k}c=Hw(g,11963);if(!c){break k}f=ow(c,o,i,k)}Ga=p+528|0;c=f;if(c){break b}c=d;i=c&2;k=i|(c<<3&128|l<<4)|131072;l=H[j+12>>2];f=fi(g,k,l);if((f|0)<0){if(!(!q|H[17665]!=2)){n=0;c=1544;if(Ka[H[16175]](g,0)|0){break i}}n=1;c=0;if(!i|H[17665]==31){break i}f=fi(g,k&131200,l);if((f|0)<0){break i}c=d&-8|1}if(!l|!(c&526336)){break j}Yu(f,H[j+8>>2],H[j+4>>2])}if(e){H[e>>2]=c}e=H[h+28>>2];if(e){H[e>>2]=f;H[e+4>>2]=c&3}e=d&8;if(e){Ka[H[16217]](g)|0}g=Ga-16|0;Ga=g;H[h+32>>2]=b;d=a;H[h+4>>2]=d;H[h+12>>2]=f;a=e<<2;a=n?a|2:a;a=(m|0)==256?a:a|128;c=c&64|(q?a|8:a);G[h+18>>1]=c&255;if(Zl(c<<25>>31&b,1607,1)){G[h+18>>1]=J[h+18>>1]|16}if(!ad(H[d+16>>2],11139)){G[h+18>>1]=J[h+18>>1]|1}a=31676;m:{n:{if(c&128){break n}a=31600;c=Ka[H[H[d+20>>2]>>2]](b,h)|0;if((c|0)==31600){d=Ga-128|0;Ga=d;o:{if(Ka[H[16184]](H[h+12>>2],d)|0){gd(h,H[17665]);c=H[h+20>>2]==61?22:10;break o}H[d+112>>2]=0;H[d+116>>2]=0;b=H[d+108>>2];H[d+120>>2]=H[d+104>>2];H[d+124>>2]=b;H[d+112>>2]=H[d>>2];b=70492;p:{q:{while(1){b=H[b>>2];if(b){if(!Ob(d+112|0,b,16)){break q}b=b+44|0;continue}break}b=Ib(56,0);c=7;if(!b){break o}$a(b+16|0,0,40);c=H[d+124>>2];H[b+8>>2]=H[d+120>>2];H[b+12>>2]=c;c=H[d+116>>2];H[b>>2]=H[d+112>>2];H[b+4>>2]=c;if(I[64004]){H[b+16>>2]=8}H[b+36>>2]=1;c=H[17623];H[b+48>>2]=0;H[b+44>>2]=c;if(c){H[c+48>>2]=b}H[17623]=b;break p}H[b+36>>2]=H[b+36>>2]+1}H[h+8>>2]=b;c=0}Ga=d+128|0;b=c;if(!c){break n}og(h,f,41188);f=-1;break m}if((c|0)!=31752){a=c;break n}c=ub(b)+6|0;a=Ib(c,c>>31);if(a){H[g>>2]=b;Vd(c,a,11325,g);b=0}else{b=7}H[h+24>>2]=a;a=31752;break m}b=0}gd(h,0);r:{if(b){if((f|0)<0){break r}og(h,f,41273);break r}H[h>>2]=a;Aw(h)}Ga=g+16|0;break h}b=(r=Td(xe(41714),10706,g,41714),s=c,t=n,t?r:s)}c=b;if(!c){c=0;break b}Wa(H[h+28>>2])}Ga=j+544|0;return c|0}function lo(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;e=Ga+-64|0;Ga=e;H[e+60>>2]=0;H[e+56>>2]=0;H[e+48>>2]=0;H[e+52>>2]=0;s=H[a>>2];a:{if(H[a+36>>2]){break a}f=Ph(a,b);if(!f){break a}x=hj(a,f,128,0,0);v=I[f+43|0];l=1;if(!x){l=(gj(a,f,0,0)|0)!=0}if(fg(a,f)){break a}if(Tn(a,f,(x|0)!=0)){break a}g=H[f>>2];i=H[s+16>>2];o=Lb(s,H[f+60>>2]);g=cc(a,9,g,0,H[i+(o<<4)>>2]);if((g|0)==1){break a}m=H[a+40>>2];j=m+1|0;H[a+40>>2]=j;H[b+48>>2]=m;h=j;n=f+8|0;k=n;while(1){i=H[k>>2];if(i){h=h+1|0;H[a+40>>2]=h;r=r+1|0;k=i+20|0;continue}break}if((v|0)==2){Ms(a,e+48|0,H[f>>2])}k=0;d=zb(a);if(!d){break a}if(!I[a+18|0]){Sn(d)}Gd(a,l,o);if((v|0)==2){Ks(a,f,c,m);H[e+60>>2]=m;H[e+56>>2]=m}H[e+40>>2]=0;H[e+44>>2]=0;H[e+32>>2]=0;H[e+36>>2]=0;H[e+24>>2]=0;H[e+28>>2]=0;H[e+20>>2]=b;H[e+16>>2]=a;if(ld(e+16|0,c)){break a}if(!(I[a+18|0]|!(F[s+36|0]&1)|(H[a+120>>2]|I[a+149|0]))){q=H[a+44>>2]+1|0;H[a+44>>2]=q;Va(d,71,0,q)}b:{if(!(c|g|l|I[f+43|0]==1)){Dd(a,o,H[f+20>>2],1,H[f>>2]);if(!(I[f+28|0]&128)){kb(d,145,H[f+20>>2],o,q?q:-1,H[f>>2],-1)}i=q?q:-1;while(1){h=H[n>>2];if(h){Va(d,145,H[h+44>>2],o);if(!(!(I[f+28|0]&128)|((I[h+55|0]|I[h+56|0]<<8)&3)!=2)){fj(d,-1,i)}n=h+20|0;continue}else{h=0;break b}}}h=I[e+40|0]&64?20:l?20:28;c:{if(!(I[f+28|0]&128)){i=1;w=H[a+44>>2]+1|0;H[a+44>>2]=w;l=0;Va(d,75,0,w);g=0;break c}g=H[a+44>>2];l=tc(f);i=G[l+50>>1];H[a+44>>2]=g+i;t=H[a+40>>2];H[a+40>>2]=t+1;p=Va(d,118,t,i);Od(a,l);g=g+1|0}u=Af(a,b,c,0,0,0,h,j);if(!u){break a}o=Rn(u,e+8|0);if((o|0)!=1){ag(a)}if(Qn(u)){db(d,143,m)}if(q){Va(d,86,q,1)}d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{if(l){h=0;j=(i|0)>0?i:0;while(1){if((h|0)!=(j|0)){Qc(d,f,m,G[H[l+4>>2]+(h<<1)>>1],h+g|0);h=h+1|0;continue}break}if(!o){break o}j=g;break p}g=1;j=H[a+44>>2]+1|0;H[a+44>>2]=j;Qc(d,f,m,-1,j);if(!o){break m}}h=Tb(s,r+2|0,0);if(!h){Ed(u);break a}g=r+1|0;k=$a(h,1,g);F[g+k|0]=0;g=H[e+8>>2];if((g|0)>=0){F[k+(g-m|0)|0]=0}g=H[e+12>>2];if((g|0)>=0){F[k+(g-m|0)|0]=0}if(p){ue(d,p)}k=jb(a);if((v|0)!=2){break n}g=i;break j}j=H[a+44>>2]+1|0;H[a+44>>2]=j;kb(d,97,g,i,j,ej(H[a>>2],l),i);ob(d,138,t,j,g,i);g=0;break l}r=0;if((o|0)!=2){n=0;g=i;p=0;break k}n=0;r=1;p=Sb(d,14);g=i;break k}Va(d,156,w,j)}Ed(u);n=1;r=0;h=0;p=0;i=0;if((v|0)==2){break i}}Yk(a,f,113,8,m,h,e+60|0,e+56|0);if(r){Pn(d,p)}r=h;i=k;if(n){break i}}p=0;if(I[f+43|0]==1){n=0;break g}i=H[e+60>>2];if(I[(i-m|0)+h|0]){ob(d,27,i,k,j,g)}n=0;break h}q:{if(l){p=db(d,35,t);n=1;if(I[f+43|0]==1){Xa(d,94,t,0,j);break q}Va(d,134,t,j);break q}n=1;p=Xa(d,45,w,0,j)}h=r;k=i}if(I[f+43|0]!=1){break f}}i=Id(s,f);Hs(a,f);Rc(a);r:{if((o|0)!=1){break r}db(d,122,m);if(H[a+116>>2]){break r}F[a+20|0]=0}kb(d,7,0,1,j,i,-11);pb(d,2);if(n){break e}break d}On(a,f,x,H[e+60>>2],H[e+56>>2],j,g,!I[a+18|0],11,o&255,H[e+12>>2]);if(!n){break d}}s:{if(l){Va(d,38,t,p+1|0);break s}Yb(d,p)}bb(d,p);break b}lb(d,k);Ed(u)}if(!(I[a+18|0]|H[a+120>>2])){Nn(a)}if(q){Gs(d,q,14782)}k=h}fD(e+48|0);Ic(s,b);fb(s,c);_a(s,k);Ga=e- -64|0}function vm(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=Ga-112|0;Ga=j;k=i&2147483647;l=e&2147483647;m=l;a:{b:{p=!(b|c);if(!(d|l?l-2147418112>>>0<2147549184:p)){n=k-2147418112|0;if(!h&(n|0)==-2147418112?f|g:(n|0)==-2147418112&(h|0)!=0|n>>>0>2147549184){break b}}if(!(!d&(m|0)==2147418112?p:m>>>0<2147418112)){h=d;i=e|32768;f=b;g=c;break a}if(!(!h&(k|0)==2147418112?!(f|g):k>>>0<2147418112)){i=i|32768;break a}if(!(b|d|(m^2147418112|c))){m=d;d=!(b^f|d^h|(c^g|e^i^-2147483648));h=d?0:m;i=d?2147450880:e;f=d?0:b;g=d?0:c;break a}if(!(f|h|(k^2147418112|g))){break a}if(!(b|d|(c|m))){if(f|h|(g|k)){break a}f=b&f;g=c&g;h=d&h;i=e&i;break a}if(f|h|(g|k)){break b}f=b;g=c;h=d;i=e;break a}l=(k|0)==(m|0);k=l&(d|0)==(h|0)?(c|0)==(g|0)&b>>>0<f>>>0|c>>>0<g>>>0:l&d>>>0<h>>>0|k>>>0>m>>>0;o=k?f:b;l=k?g:c;m=k?i:e;r=m;q=k?h:d;n=m&65535;e=k?e:i;s=e;h=k?d:h;m=e>>>16&32767;p=r>>>16&32767;if(!p){d=!(n|q);e=d<<6;i=Q(d?o:q)+32|0;d=Q(d?l:n);d=e+((d|0)==32?i:d)|0;ud(j+96|0,o,l,q,n,d-15|0);q=H[j+104>>2];n=H[j+108>>2];o=H[j+96>>2];p=16-d|0;l=H[j+100>>2]}f=k?b:f;g=k?c:g;i=s&65535;if(!m){b=!(h|i);c=b<<6;d=Q(b?f:h)+32|0;b=Q(b?g:i);b=c+((b|0)==32?d:b)|0;ud(j+80|0,f,g,h,i,b-15|0);m=16-b|0;h=H[j+88>>2];i=H[j+92>>2];g=H[j+84>>2];f=H[j+80>>2]}b=h;k=i<<3|b>>>29;d=b<<3|g>>>29;e=k|524288;b=q;c=n<<3|b>>>29;h=b<<3|l>>>29;i=c;b=f;c=g<<3|b>>>29;b=b<<3;g=r^s;c:{if((m|0)==(p|0)){break c}f=p-m|0;if(f>>>0>127){d=0;e=0;b=1;c=0;break c}ud(j- -64|0,b,c,d,e,128-f|0);th(j+48|0,b,c,d,e,f);b=H[j+48>>2]|(H[j+64>>2]|H[j+72>>2]|(H[j+68>>2]|H[j+76>>2]))!=0;c=H[j+52>>2];d=H[j+56>>2];e=H[j+60>>2]}m=h;q=i|524288;f=o;k=l<<3|f>>>29;n=f<<3;d:{if((g|0)<0){f=0;g=0;h=0;i=0;if(!(b^n|d^m|(c^k|e^q))){break a}o=n-b|0;l=k-((b>>>0>n>>>0)+c|0)|0;f=m-d|0;b=(c|0)==(k|0)&b>>>0>n>>>0|c>>>0>k>>>0;i=(q-((d>>>0>m>>>0)+e|0)|0)-(f>>>0<b>>>0)|0;h=f-b|0;if(i>>>0>524287){break d}b=!(h|i);c=b<<6;d=Q(b?o:h)+32|0;b=Q(b?l:i);b=c+((b|0)==32?d:b)|0;b=b-12|0;ud(j+32|0,o,l,h,i,b);p=p-b|0;h=H[j+40>>2];i=H[j+44>>2];o=H[j+32>>2];l=H[j+36>>2];break d}k=c+k|0;f=b+n|0;k=f>>>0<n>>>0?k+1|0:k;o=f;l=k;f=(c|0)==(k|0)&b>>>0>f>>>0|c>>>0>k>>>0;c=e+q|0;b=d+m|0;c=b>>>0<m>>>0?c+1|0:c;d=b;b=f+b|0;h=b;i=b>>>0<d>>>0?c+1|0:c;if(!(i&1048576)){break d}o=o&1|((l&1)<<31|o>>>1);c=h;l=c<<31|l>>>1;p=p+1|0;h=(i&1)<<31|c>>>1;i=i>>>1|0}d=0;e=r&-2147483648;if((p|0)>=32767){h=d;i=e|2147418112;f=0;g=0;break a}m=0;e:{if((p|0)>0){m=p;break e}ud(j+16|0,o,l,h,i,p+127|0);th(j,o,l,h,i,1-p|0);o=H[j>>2]|(H[j+16>>2]|H[j+24>>2]|(H[j+20>>2]|H[j+28>>2]))!=0;l=H[j+4>>2];h=H[j+8>>2];i=H[j+12>>2]}c=h<<29;b=l>>>3|0;n=(l&7)<<29|o>>>3;l=o&7;g=l>>>0>4;f=n+g|0;b=b|c;k=f>>>0<g>>>0?b+1|0:b;c=f;g=k;b=(b|0)==(k|0)&c>>>0<n>>>0|b>>>0>k>>>0;c=d|((i&7)<<29|h>>>3);b=b+c|0;i=e|(i>>>3&65535|m<<16);i=b>>>0<c>>>0?i+1|0:i;h=b;f:{if((l|0)==4){c=g+0|0;e=f&1;b=f+e|0;c=b>>>0<f>>>0?c+1|0:c;f=b;g=c;c=(d|0)==(c|0)&b>>>0<e>>>0|c>>>0<d>>>0;b=c+h|0;i=b>>>0<c>>>0?i+1|0:i;h=b;break f}if(!l){break a}}}H[a>>2]=f;H[a+4>>2]=g;H[a+8>>2]=h;H[a+12>>2]=i;Ga=j+112|0}function wh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=1;a:{if(H[c>>2]){break a}b:{switch(H[b>>2]-1|0){case 0:case 2:c:{if(!wh(a,H[b+12>>2],c)){break c}if(!wh(a,H[b+16>>2],c)){break c}h=b;d=Ga-16|0;Ga=d;i=1;d:{if(H[c>>2]|H[b>>2]!=1){break d}m=c;c=H[b+8>>2];if(H[c>>2]==1?c:0){break d}c=b;while(1){e=H[c+12>>2];if(e){c=H[H[H[c+16>>2]+20>>2]+32>>2];k=c;j=c+j|0;c=(c>>31)+g|0;c=j>>>0<k>>>0?c+1|0:c;g=c;c=e;continue}break}e=j;j=H[H[c+20>>2]+32>>2];e=e+j|0;g=(j>>31)+g|0;g=e>>>0<j>>>0?g+1|0:g;e:{g=Ib(e<<1,g<<1|e>>>31);if(!g){H[m>>2]=7;i=0;break e}e=H[c+20>>2];H[d+12>>2]=H[e+28>>2];H[d+8>>2]=H[e+64>>2];while(1){f:{if(!i){break f}c=H[c+8>>2];if(!c|H[c>>2]!=1){break f}i=Iy(H[c+4>>2],g,d+12|0,d+8|0,H[H[c+16>>2]+20>>2]);continue}break}c=H[H[h+16>>2]+20>>2];H[d+12>>2]=H[c+28>>2];H[d+8>>2]=H[c+64>>2];while(1){h=H[h+12>>2];if(!h|!i){break e}i=Iy(H[H[h+8>>2]+4>>2],g,d+12|0,d+8|0,H[(H[h>>2]==1?H[h+16>>2]:h)+20>>2]);continue}}Wa(g)}Ga=d+16|0;if(i){break a}}f=0;if(H[b>>2]!=1){break a}c=H[b+8>>2];if(H[c>>2]==1?c:0){break a}while(1){c=H[b+20>>2];if(!c){c=H[b+16>>2];if(H[c+24>>2]==H[a+32>>2]&H[c+28>>2]==H[a+36>>2]){Ji(H[c+20>>2])}b=H[b+12>>2];continue}break};if(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2]){break a}Ji(c);return 0;case 3:return(wh(a,H[b+12>>2],c)|wh(a,H[b+16>>2],c))!=0;case 1:if(!wh(a,H[b+12>>2],c)){return 0}return!wh(a,H[b+16>>2],c);default:break b}}g:{h:{i:{if(!H[a+28>>2]){break i}if(I[b+34|0]){break h}if(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2]){break i}f=H[b+20>>2];if(H[f+28>>2]){break g}}f=0;if(I[b+32|0]|(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2])){break a}return H[H[b+20>>2]+32>>2]>0}f=H[b+20>>2];Ji(f)}m=c;d=Ga-32|0;Ga=d;j=H[f+24>>2]?H[f+28>>2]:j;h=-1;while(1){j:{k:{l:{m:{if(H[f+64>>2]>(i|0)){e=H[(N(i,24)+f|0)+88>>2];if(!e){break k}c=0;k=Ga-16|0;Ga=k;H[d+28>>2]=0;H[d+24>>2]=0;l=H[e+12>>2];n:{if(!l){break n}l=Ub(H[l>>2]);if(!l){c=7;break n}n=qd(H[H[e+12>>2]+4>>2],k+8|0);o=H[H[e+12>>2]>>2]-n|0;H[d+24>>2]=o;H[d+28>>2]=l;Ya(l,n+H[H[e+12>>2]+4>>2]|0,o)}Ga=k+16|0;if(c){break m}e=H[d+28>>2];if(!e){Wa(g);Wa(j);H[f+28>>2]=0;H[f+32>>2]=0;break m}if(!g){k=H[d+24>>2];break l}H[d+20>>2]=e;H[d+16>>2]=g;H[d+12>>2]=e;Hi(d+20|0,i-h|0,0,1,d+16|0,d+12|0);Wa(g);k=H[d+20>>2]-e|0;if(k){break l}Wa(e);Wa(j);H[f+28>>2]=0;H[f+32>>2]=0;break m}c=0;o:{p:{if((h|0)<0){break p}e=H[f+44>>2];if((e|0)<0){H[f+32>>2]=k;H[f+28>>2]=g;h=H[a+36>>2];g=H[a+32>>2];H[f+24>>2]=1;H[f+16>>2]=g;H[f+20>>2]=h;break p}q:{if(e>>>0>h>>>0){H[d+28>>2]=g;H[d+24>>2]=H[f+28>>2];h=e-h|0;break q}i=H[f+28>>2];H[d+24>>2]=g;H[d+28>>2]=i;h=h-e|0}e=k+8|0;e=Xe(e,e>>31);H[d+20>>2]=e;if(!e){break o}H[f+28>>2]=e;i=0;r:{if(Hi(d+20|0,h,0,1,d+28|0,d+24|0)){H[f+24>>2]=1;i=H[d+20>>2]-H[f+28>>2]|0;break r}Wa(H[d+20>>2]);H[f+28>>2]=0}H[f+32>>2]=i;Wa(g)}if(H[f+28>>2]==(j|0)){break m}Wa(j);break m}Wa(g);c=7}Ga=d+32|0;break j}h=i;g=e}i=i+1|0;continue}break}H[m>>2]=c;c=H[f+28>>2];h=H[a+36>>2];H[b+24>>2]=H[a+32>>2];H[b+28>>2]=h;f=(c|0)!=0}return f}function _h(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;i=Ga+-64|0;Ga=i;j=H[c+4>>2];a:{b:{c:{d:{if(d){e=F[b+1|0];d=e&255;H[i+16>>2]=d;n=1;m=2;j=j+40|0;if((e|0)<0){m=$d(b+1|0,i+16|0)+1|0;d=H[i+16>>2]}d=yi(d);o=I[b|0];d=d+o|0;break d}d=F[b|0];o=d&255;H[i+60>>2]=o;m=1;if((d|0)<0){m=$d(b,i+60|0);o=H[i+60>>2]}d=o}l=d;e:{if(l>>>0<=a>>>0){p=c+23|0;while(1){f:{g:{h:{i:{j:{k:{l:{d=J[j+16>>1];m:{if(d&36){h=1;d=I[b+m|0];if(d>>>0>9){break m}if((d|0)==7){break h}if(!d){break j}f=b+l|0;n:{o:{switch(d|0){case 0:case 1:e=F[f|0];g=e>>31;break n;case 2:e=I[f+1|0]|F[f|0]<<8;g=e>>31;break n;case 3:e=I[f+2|0]|(I[f+1|0]<<8|F[f|0]<<16);g=e>>31;break n;case 4:e=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);e=e<<24|e<<8&16711680|(e>>>8&65280|e>>>24);g=e>>31;break n;case 5:e=I[f+3|0];g=e>>>16|0;k=e<<16;e=g;q=k;k=I[f+2|0];g=k>>>8|0;k=q|k<<24;q=e|g;e=I[f+4|0];g=e>>>24|0;e=I[f+5|0]|(e<<8|k);g=g|q|(I[f+1|0]|F[f|0]<<8);break n;case 6:e=I[f+4|0]|I[f+5|0]<<8|(I[f+6|0]<<16|I[f+7|0]<<24);k=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);g=k<<24|k<<8&16711680|((e<<24|k>>>8)&65280|(e<<8|k>>>24)&255);e=((e&255)<<24|k>>>8)&-16777216|((e&16777215)<<8|k>>>24)&16711680|(e>>>8&65280|e>>>24);break n;default:break o}}e=d-8|0;g=0}k=H[j>>2];f=H[j+4>>2];if(k>>>0>e>>>0&(f|0)>=(g|0)|(f|0)>(g|0)){break j}if(e>>>0<=k>>>0&(f|0)>=(g|0)|(f|0)>(g|0)){break f}e=d;break b}if(d&8){e=1;d=I[b+m|0];if(d>>>0>9){break c}h=-1;if(!d){e=0;break b}qh(b+l|0,d,i+16|0);if((d|0)==7){r=M[i+16>>3];s=M[j>>3];if(r<s){break b}d=7;h=1;if(r>s){break b}break f}e=d;h=Aj(H[i+16>>2],H[i+20>>2],M[j>>3]);break g}if(d&2){e=b+m|0;g=F[e|0];d=g&255;H[i+12>>2]=d;if((g|0)<0){$d(e,i+12|0);d=H[i+12>>2]}if(d>>>0<12){h=-1;e=d;break b}e=1;if(!(d&1)){break c}g=d-12>>>1|0;H[i+28>>2]=g;p:{if(g+l>>>0<=a>>>0){h=H[c>>2];if(J[h+8>>1]>n>>>0){break p}}t=p,u=ab(85321),F[t|0]=u;break e}f=H[(h+(n<<2)|0)+20>>2];if(f){F[i+34|0]=I[h+4|0];e=H[h+12>>2];G[i+32>>1]=2;H[i+36>>2]=e;H[i+24>>2]=b+l;e=d;h=Eu(i+16|0,j,f,p);break g}f=H[j+12>>2];h=Ob(b+l|0,H[j+8>>2],(f|0)>(g|0)?g:f);if(h){break b}e=d;h=g-f|0;break g}h=b+m|0;e=I[h|0];g=e<<24>>24;if(!(d&16)){break k}H[i+12>>2]=e;if((g|0)<0){$d(h,i+12|0);e=H[i+12>>2]}h=-1;if(e&1|e>>>0<12){break b}d=e-12>>>1|0;if(d+l>>>0>a>>>0){break i}if(I[j+17|0]&4){if(!To(b+l|0,d)){e=1;break c}h=d-H[j>>2]|0;break g}g=H[j+12>>2];h=Ob(b+l|0,H[j+8>>2],(d|0)<(g|0)?d:g);if(!h){break l}}e=1;break b}h=d-g|0;break g}h=(g|0)!=0;break g}e=d;h=-1;break b}t=p,u=ab(85351),F[t|0]=u;break e}e=7;qh(b+l|0,7,i+16|0);h=0-Aj(H[j>>2],H[j+4>>2],M[i+16>>3])|0}d=e;if(h){break b}}n=n+1|0;q:{if((n|0)==J[c+20>>1]){break q}e=yi(d);m=Vh(d,0)+m|0;if(o>>>0<=m>>>0){break q}j=j+40|0;l=e+l|0;if(l>>>0<=a>>>0){continue}}break}F[c+26|0]=1;h=F[c+22|0];break a}t=c,u=ab(85244),F[t+23|0]=u}h=0;break a}h=1}a=I[H[H[c>>2]+16>>2]+n|0];if(!a){break a}r:{if(!(a&2)){break r}if(!e){if(!(a&1)){break r}break a}if((I[j+16|0]^!(a&1))&1){break a}}h=0-h|0}Ga=i- -64|0;return h}function Yd(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Ga-128|0;Ga=f;H[b>>2]=0;H[b+4>>2]=0;a:{if(!c){break a}b:{if((d|0)==1){i=1;m=1;e=a;break b}e=3-d|0;c=c&-2;while(1){c:{if((c|0)<=(e|0)){m=1}else{if(!I[a+e|0]){break c}m=-100}c=e^1;e=(d&1)+a|0;i=2;break b}e=e+2|0;continue}}n=a+c|0;while(1){if(e>>>0>=n>>>0){break a}k=I[e|0];if(F[k+30016|0]&1){e=e+i|0;continue}break}e=((k|0)==45?i:(k|0)==43?i:0)+e|0;d=0;d:{e:{f:while(1){c=0;o=1;if(e>>>0>=n>>>0){break e}a=I[e|0];if(a-58>>>0>=4294967286){d=d+1|0;e=e+i|0;c=SK(g,h,10,0);a=a<<24;g=a>>31;j=a>>24;c=c+j|0;a=g+Ja|0;a=c>>>0<j>>>0?a+1|0:a;g=c-48|0;a=a-(c>>>0<48)|0;h=a;if(g>>>0<3435973835&(a|0)<=214748364|(a|0)<214748364){continue}while(1){if(I[e|0]-58>>>0<4294967286|e>>>0>=n>>>0){continue f}l=l+1|0;e=e+i|0;continue}}break}g:{if((a|0)!=46){break g}m=m+1|0;while(1){e=e+i|0;if(n>>>0<=e>>>0){break g}a=I[e|0];if(a-58>>>0<4294967286){break g}if(g>>>0>3435973834&(h|0)>=214748364|(h|0)>214748364){continue}d=d+1|0;l=l-1|0;h=SK(g,h,10,0);a=a<<24;g=a>>31;j=a>>24;h=h+j|0;a=g+Ja|0;a=h>>>0<j>>>0?a+1|0:a;g=h-48|0;h=a-(h>>>0<48)|0;continue}}if(e>>>0>=n>>>0){break e}h:{if((I[e|0]|32)!=101){j=1;break h}m=m+1|0;e=e+i|0;if(n>>>0<=e>>>0){j=0;break d}i:{j:{switch(I[e|0]-43|0){case 2:e=e+i|0;o=-1;break i;case 0:break j;default:break i}}e=e+i|0}j=0;while(1){if(e>>>0>=n>>>0){break h}a=I[e|0];if(a-58>>>0<4294967286){break h}c=(c|0)<1e4?(N(c,10)+(a<<24>>24)|0)-48|0:1e4;e=e+i|0;j=1;continue}}while(1){if(!(F[I[e|0]+30016|0]&1)|e>>>0>=n>>>0){break d}e=e+i|0;continue}}j=1}q=b;k:{if(g|h){c=N(c,o)+l|0;a=c>>31;i=(a^c)-a|0;l=(c|0)<0;l:{while(1){if((i|0)>0){m:{if(!l){if(g>>>0>3435973835&(h|0)>=214748364|(h|0)>214748364){break l}a=SK(g,h,10,0);b=Ja;break m}a=TK(g,h,10,0);b=Ja;if((SK(a,b,10,0)|0)!=(g|0)|(Ja|0)!=(h|0)){break l}}i=i-1|0;g=a;h=b;continue}break}a=(k|0)==45;p=+((a?0-g|0:g)>>>0)+ +((a?0-(((g|0)!=0)+h|0)|0:h)|0)*4294967296;break k}b=(k|0)==45;a=b?0-g|0:g;b=b?0-(((g|0)!=0)+h|0)|0:h;if(i>>>0>=308){if(i>>>0<=341){_u(f+48|0,i-308|0);lq(f+32|0,a,b);a=H[f+40>>2];b=H[f+44>>2];g=H[f+56>>2];h=H[f+60>>2];i=H[f+32>>2];k=H[f+36>>2];l=H[f+48>>2];o=H[f+52>>2];if((c|0)<0){mq(f,i,k,a,b,l,o,g,h);p=Ei(H[f>>2],H[f+4>>2],H[f+8>>2],H[f+12>>2])/1e308;break k}De(f+16|0,l,o,g,h,i,k,a,b);p=Ei(H[f+16>>2],H[f+20>>2],H[f+24>>2],H[f+28>>2])*1e308;break k}p=(+(a>>>0)+ +(b|0)*4294967296)*0;if((c|0)<0){break k}p=+O(O(+(a>>>0)+ +(b|0)*4294967296)*O(Z));break k}_u(f+112|0,i);lq(f+96|0,a,b);a=H[f+104>>2];b=H[f+108>>2];g=H[f+120>>2];h=H[f+124>>2];i=H[f+96>>2];k=H[f+100>>2];l=H[f+112>>2];o=H[f+116>>2];n:{if((c|0)<0){mq(f- -64|0,i,k,a,b,l,o,g,h);b=H[f+68>>2];c=H[f+72>>2];g=H[f+76>>2];a=H[f+64>>2];break n}De(f+80|0,l,o,g,h,i,k,a,b);b=H[f+84>>2];c=H[f+88>>2];g=H[f+92>>2];a=H[f+80>>2]}p=Ei(a,b,c,g);break k}p=(k|0)==45?-0:0}M[q>>3]=p;if(!(!j|(e|0)!=(n|0)|((d|0)<=0|(m|0)<=0))){j=m;break a}if(!(!j&(m|0)!=3|(m|0)<2)){j=-1;if((d|0)>0){break a}}j=0}Ga=f+128|0;return j}function Rm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=H[a+12>>2];while(1){e=b;b=b+1|0;i=e+f|0;c=I[i|0];if(I[c+50592|0]){continue}break}a:{b:{c:{if((c|0)==34){c=0;b=e;while(1){g=-1;d=b;b=b+1|0;h=I[f+b|0];if(h>>>0<32){break c}if((h|0)!=92){if((h|0)!=34){continue}g=d+2|0;yd(a,5,g-e|0,i);if(I[a+20|0]){break c}F[(H[a+8>>2]+N(H[a>>2],12)|0)-11|0]=c;return g}c=2;d:{e:{b=d+2|0;h=f+b|0;d=I[h|0];switch(d-110|0){case 1:case 2:case 3:case 5:break c;case 0:case 4:case 6:continue;case 7:break d;default:break e}}f:{switch(d-98|0){case 1:case 2:case 3:break c;case 0:case 4:continue;default:break f}}if((d|0)==34|(d|0)==47|(d|0)==92){continue}break c}j=h+1|0;d=0;h=1;g:{while(1){if((d|0)==4){break g}k=d+j|0;d=d+1|0;if(I[I[k|0]+30016|0]&8){continue}break}h=0}if(h){continue}break}break c}h:{i:{j:{k:{l:{if((c|0)!=91){if((c|0)==102){break j}if((c|0)==110){break l}if((c|0)==116){break k}if((c|0)!=123){break i}d=yd(a,7,0,0);if((d|0)<0){break h}while(1){c=e;e=c+1|0;if(I[I[f+e|0]+50592|0]){continue}b=J[a+22>>1]+1|0;G[a+22>>1]=b;g=-1;if((b&65535)>>>0>2e3){break c}b=Rm(a,e);if((b|0)<0){G[a+22>>1]=J[a+22>>1]-1;if((b|0)!=-2){break c}break b}if(I[a+20|0]){break c}e=H[a+8>>2]+N(H[a>>2]-1|0,12)|0;if(I[e|0]!=5){break c}F[e+1|0]=I[e+1|0]|64;while(1){e=b+f|0;b=b+1|0;e=I[e|0];if(I[e+50592|0]){continue}break}if((e|0)!=58){break c}b=Rm(a,b);G[a+22>>1]=J[a+22>>1]-1;if((b|0)<0){break c}while(1){e=b;b=b+1|0;c=I[e+f|0];if(I[c+50592|0]){continue}break}if((c|0)==44){continue}break}if((c|0)!=125){break c}break a}d=yd(a,6,0,0);if((d|0)<0){break h}H[(H[a+8>>2]+N(d,12)|0)+8>>2]=0;while(1){c=e;e=c+1|0;if(I[I[f+e|0]+50592|0]){continue}b=J[a+22>>1]+1|0;G[a+22>>1]=b;g=-1;if((b&65535)>>>0>2e3){break c}b=Rm(a,e);G[a+22>>1]=J[a+22>>1]-1;if((b|0)<0){if((b|0)!=-3){break c}break b}while(1){e=b;b=b+1|0;c=I[e+f|0];if(I[c+50592|0]){continue}break}if((c|0)==44){continue}break}if((c|0)!=93){break c}break a}if(Be(i,11021,4)){break i}b=e+4|0;if(I[I[b+f|0]+30016|0]&6){break i}yd(a,0,0,0);return b}if(Be(i,12244,4)){break i}b=e+4|0;if(I[I[b+f|0]+30016|0]&6){break i}yd(a,1,0,0);return b}if(Be(i,12777,5)){break i}b=e+5|0;if(I[I[b+f|0]+30016|0]&6){break i}yd(a,2,0,0);return b}if(!((c|0)!=45&(c-48&255)>>>0>9)){m:{if(c>>>0>48){break m}b=(((c|0)==45)+e|0)+f|0;if(I[b|0]!=48){break m}g=-1;if((I[b+1|0]-48&255)>>>0<10){break c}}c=0;b=e;h=1;while(1){d=b;b=b+1|0;g=I[f+b|0];if((g-48&255)>>>0<10){continue}if((g|0)==46){g=-1;if(I[d+f|0]==45){break c}d=c;c=1;if(!d){continue}break c}k=d+f|0;j=F[k|0];if((g&223)==69){g=-1;if((h^-1|(j|0)<48)&1){break c}n:{o:{c=d+2|0;d=I[c+f|0];switch(d-43|0){case 0:case 2:break o;default:break n}}d=I[k+3|0];b=c}c=1;h=0;if((d-58&255)>>>0>=246){continue}break c}break}g=-1;if((j|0)<48){break c}yd(a,c?4:3,b-e|0,i);return b}if(c){if((c|0)==125){return-2}if((c|0)!=93){break h}return-3}return 0}g=-1}return g}return H[a>>2]==(d+1|0)?c+2|0:-1}H[(H[a+8>>2]+N(d,12)|0)+4>>2]=H[a>>2]+(d^-1);return b}function Qo(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0;f=Ga-144|0;Ga=f;H[f+136>>2]=d;H[f+140>>2]=e;H[f+132>>2]=0;a:{if(!b){break a}A=H[a+36>>2];B=H[a+32>>2];C=H[a+28>>2];p=H[a>>2];r=H[p+40>>2];if(xo(a,b)){break a}H[a+32>>2]=b;H[a+28>>2]=29228;g=xd(p,b,f+132|0,0);b:{if(g){H[f+96>>2]=g;Tc(a,15871,f+96|0);n=-1;break b}h=H[f+132>>2];D=I[h|0];F[h|0]=0;g=si(h);if(g){H[f+80>>2]=g;Tc(a,16473,f+80|0);n=-1;break b}g=lg(h);if(g){H[f+64>>2]=g;Tc(a,9676,f- -64|0);n=-1;break b}u=I[h+9|0];l=H[h+56>>2];H[a+28>>2]=29282;n=-1;o=l+u|0;q=(I[o+5|0]<<8|I[o+6|0])-1&65535;g=I[h+8|0];y=(u-(g<<2)|0)+12|0;j=(I[o+4|0]|I[o+3|0]<<8)-1|0;m=y+(j<<1)|0;c:{if(!g){g=eb(o+8|0);if(I[p+17|0]){H[a+28>>2]=29254;Zg(a,g,5,b)}n=Qo(a,g,f+136|0,d,e);k=0;break c}i=H[a+64>>2];H[i>>2]=0;k=1}E=q+1|0;s=l+m|0;G=r-5|0;v=r-4|0;w=1;g=j;while(1){if(!(!H[a+16>>2]|(g|0)<0)){H[a+36>>2]=g;m=I[s+1|0]|I[s|0]<<8;d:{if(!(m>>>0>q>>>0&m>>>0<=v>>>0)){H[f+40>>2]=v;H[f+36>>2]=E;H[f+32>>2]=m;Tc(a,15909,f+32|0);w=0;break d}x=l+m|0;Ka[H[h+80>>2]](h,x,f+104|0);if(m+J[f+122>>1]>>>0>r>>>0){w=0;Tc(a,13829,0);break d}if(I[h+1|0]){z=H[f+136>>2];t=H[f+140>>2];d=H[f+104>>2];e=H[f+108>>2];e:{f:{if(k){if(d>>>0>z>>>0&(e|0)>=(t|0)|(e|0)>(t|0)){break f}break e}if(d>>>0<z>>>0&(e|0)<=(t|0)|(e|0)<(t|0)){break e}}H[f+48>>2]=d;H[f+52>>2]=e;Tc(a,9091,f+48|0);d=H[f+104>>2];e=H[f+108>>2]}H[f+136>>2]=d;H[f+140>>2]=e;k=0}d=H[f+116>>2];e=J[f+120>>1];if(d>>>0>e>>>0){e=((d+G|0)-e>>>0)/(v>>>0)|0;d=eb((J[f+122>>1]+x|0)-4|0);if(I[p+17|0]){Zg(a,d,3,b)}ou(a,0,d,e)}if(!I[h+8|0]){d=eb(x);if(I[p+17|0]){Zg(a,d,5,b)}k=0;d=Qo(a,d,f+136|0,H[f+136>>2],H[f+140>>2]);if((d|0)==(n|0)){break d}Tc(a,4440,0);n=d;break d}wo(i,(m+J[f+122>>1]|0)-1|m<<16)}s=s-2|0;g=g-1|0;continue}break}d=H[f+140>>2];H[c>>2]=H[f+136>>2];H[c+4>>2]=d;H[a+28>>2]=0;if(w){if(H[a+16>>2]<=0){break b}g:{if(I[h+8|0]){break g}i=H[a+64>>2];H[i>>2]=0;while(1){if((j|0)<0){break g}c=l+((j<<1)+y|0)|0;c=I[c|0]<<8|I[c+1|0];wo(i,((Ka[H[h+76>>2]](h,c+l|0)|0)+c|0)-1|c<<16);j=j-1|0;continue}}g=u+1|0;while(1){c=g+l|0;g=I[c|0]<<8|I[c+1|0];if(g){c=g+l|0;wo(i,((I[c+2|0]<<8|I[c+3|0])+g|0)-1|g<<16);continue}else{c=0;while(1){e=q&65535;h:{g=0;i:{j:{d=H[i>>2];if(!d){break j}H[f+104>>2]=H[i+4>>2];d=(d<<2)+i|0;H[i+4>>2]=H[d>>2];H[d>>2]=-1;g=H[i>>2]-1|0;H[i>>2]=g;j=1;while(1){k=j<<1;d=1;if(k>>>0>g>>>0){break i}g=1;d=(j<<2)+i|0;h=H[d>>2];j=k|1;j=K[(k<<2)+i>>2]>K[(j<<2)+i>>2]?j:k;k=(j<<2)+i|0;l=H[k>>2];if(h>>>0<l>>>0){break j}H[d>>2]=l;H[k>>2]=h;g=H[i>>2];continue}}d=g}if(d){q=H[f+104>>2];d=q>>>16|0;if(d>>>0>e>>>0){break h}H[f+20>>2]=b;H[f+16>>2]=d;Tc(a,1897,f+16|0)}if(H[i>>2]){break b}c=((e^-1)+r|0)+c|0;d=I[o+7|0];if((c|0)==(d|0)){break b}H[f+8>>2]=b;H[f+4>>2]=d;H[f>>2]=c;Tc(a,1845,f);break b}c=d+((e^-1)+c|0)|0;continue}}}}F[h|0]=D}Gb(H[f+132>>2]);H[a+36>>2]=A;H[a+32>>2]=B;H[a+28>>2]=C;g=n+1|0}Ga=f+144|0;return g}function pm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=a+b|0;c=H[a+4>>2];a:{b:{if(c&1){break b}if(!(c&3)){break a}c=H[a>>2];b=c+b|0;c:{a=a-c|0;if((a|0)!=H[17703]){if(c>>>0<=255){e=H[a+8>>2];c=c>>>3|0;d=H[a+12>>2];if((d|0)!=(e|0)){break c}i=70792,j=H[17698]&YK(-2,c),H[i>>2]=j;break b}h=H[a+24>>2];c=H[a+12>>2];d:{if((c|0)!=(a|0)){d=H[a+8>>2];H[d+12>>2]=c;H[c+8>>2]=d;break d}e:{e=a+20|0;d=H[e>>2];if(d){break e}e=a+16|0;d=H[e>>2];if(d){break e}c=0;break d}while(1){g=e;c=d;e=c+20|0;d=H[e>>2];if(d){continue}e=c+16|0;d=H[c+16>>2];if(d){continue}break}H[g>>2]=0}if(!h){break b}e=H[a+28>>2];d=(e<<2)+71096|0;f:{if(H[d>>2]==(a|0)){H[d>>2]=c;if(c){break f}i=70796,j=H[17699]&YK(-2,e),H[i>>2]=j;break b}H[h+(H[h+16>>2]==(a|0)?16:20)>>2]=c;if(!c){break b}}H[c+24>>2]=h;d=H[a+16>>2];if(d){H[c+16>>2]=d;H[d+24>>2]=c}d=H[a+20>>2];if(!d){break b}H[c+20>>2]=d;H[d+24>>2]=c;break b}c=H[f+4>>2];if((c&3)!=3){break b}H[17700]=b;H[f+4>>2]=c&-2;H[a+4>>2]=b|1;H[f>>2]=b;return}H[e+12>>2]=d;H[d+8>>2]=e}c=H[f+4>>2];g:{if(!(c&2)){if(H[17704]==(f|0)){H[17704]=a;b=H[17701]+b|0;H[17701]=b;H[a+4>>2]=b|1;if(H[17703]!=(a|0)){break a}H[17700]=0;H[17703]=0;return}if(H[17703]==(f|0)){H[17703]=a;b=H[17700]+b|0;H[17700]=b;H[a+4>>2]=b|1;H[a+b>>2]=b;return}b=(c&-8)+b|0;h:{if(c>>>0<=255){e=H[f+8>>2];c=c>>>3|0;d=H[f+12>>2];if((d|0)==(e|0)){i=70792,j=H[17698]&YK(-2,c),H[i>>2]=j;break h}H[e+12>>2]=d;H[d+8>>2]=e;break h}h=H[f+24>>2];c=H[f+12>>2];i:{if((f|0)!=(c|0)){d=H[f+8>>2];H[d+12>>2]=c;H[c+8>>2]=d;break i}j:{d=f+20|0;e=H[d>>2];if(e){break j}d=f+16|0;e=H[d>>2];if(e){break j}c=0;break i}while(1){g=d;c=e;d=c+20|0;e=H[d>>2];if(e){continue}d=c+16|0;e=H[c+16>>2];if(e){continue}break}H[g>>2]=0}if(!h){break h}e=H[f+28>>2];d=(e<<2)+71096|0;k:{if(H[d>>2]==(f|0)){H[d>>2]=c;if(c){break k}i=70796,j=H[17699]&YK(-2,e),H[i>>2]=j;break h}H[h+(H[h+16>>2]==(f|0)?16:20)>>2]=c;if(!c){break h}}H[c+24>>2]=h;d=H[f+16>>2];if(d){H[c+16>>2]=d;H[d+24>>2]=c}d=H[f+20>>2];if(!d){break h}H[c+20>>2]=d;H[d+24>>2]=c}H[a+4>>2]=b|1;H[a+b>>2]=b;if(H[17703]!=(a|0)){break g}H[17700]=b;return}H[f+4>>2]=c&-2;H[a+4>>2]=b|1;H[a+b>>2]=b}if(b>>>0<=255){c=(b&-8)+70832|0;d=H[17698];b=1<<(b>>>3);l:{if(!(d&b)){H[17698]=b|d;b=c;break l}b=H[c+8>>2]}H[c+8>>2]=a;H[b+12>>2]=a;H[a+12>>2]=c;H[a+8>>2]=b;return}e=31;if(b>>>0<=16777215){c=b>>>8|0;g=c+1048320>>>16&8;c=c<<g;e=c+520192>>>16&4;c=c<<e;d=c+245760>>>16&2;c=(c<<d>>>15|0)-(d|(e|g))|0;e=(c<<1|b>>>c+21&1)+28|0}H[a+28>>2]=e;H[a+16>>2]=0;H[a+20>>2]=0;g=(e<<2)+71096|0;m:{d=H[17699];c=1<<e;n:{if(!(d&c)){H[17699]=c|d;H[g>>2]=a;H[a+24>>2]=g;break n}e=b<<((e|0)==31?0:25-(e>>>1|0)|0);c=H[g>>2];while(1){d=c;if((H[c+4>>2]&-8)==(b|0)){break m}c=e>>>29|0;e=e<<1;g=d+(c&4)|0;c=H[g+16>>2];if(c){continue}break}H[g+16>>2]=a;H[a+24>>2]=d}H[a+12>>2]=a;H[a+8>>2]=a;return}b=H[d+8>>2];H[b+12>>2]=a;H[d+8>>2]=a;H[a+24>>2]=0;H[a+12>>2]=d;H[a+8>>2]=b}}function IE(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ga-16|0;Ga=g;H[g+8>>2]=0;H[g+4>>2]=0;H[b>>2]=0;f=He();if(!f){d=I[64004]?I[64005]:d;f=H[16050]?131078:6;e=f&-655129;H[g+12>>2]=e;c=Ad(536,0);a:{if(!c){break a}if(d){H[c+12>>2]=8}F[c+97|0]=109;H[c+20>>2]=2;H[c+304>>2]=1;G[c+308>>1]=0;H[c+16>>2]=c+456;H[c+72>>2]=f&33554432?-1:255;Ya(c+120|0,31552,48);F[c+90|0]=255;F[c+85|0]=1;H[c+164>>2]=0;d=H[16042];h=H[16043];H[c+180>>2]=65056;H[c+100>>2]=0;H[c+48>>2]=d;H[c+52>>2]=h;d=H[c+36>>2];H[c+32>>2]=H[c+32>>2]|-536575776;H[c+36>>2]=d;Qf(c+428|0);Qf(c+384|0);Rj(c,32112,1,10);Rj(c,32112,3,10);Rj(c,32112,2,10);Rj(c,19573,1,11);Rj(c,19321,1,12);if(I[c+87|0]){break a}H[c+60>>2]=e;b:{if(!(1<<(f&7)&70)){a=kd(174042);break b}a=Mw(0,a,g+12|0,c,g+8|0,g+4|0)}if(a){if((a|0)==7){Mb(c)}d=H[g+4>>2];H[g>>2]=d;te(c,a,d?8310:0,g);Wa(d);break a}a=Qj(H[c>>2],H[g+8>>2],c,H[c+16>>2]+4|0,0,H[g+12>>2]|256);if(a){Yc(c,(a|0)==3082?7:a);break a}Jb(H[H[c+16>>2]+4>>2]);a=Lp(c,H[H[c+16>>2]+4>>2]);H[H[c+16>>2]+12>>2]=a;if(!I[c+87|0]){Kp(c,I[a+77|0])}f=0;d=Lp(c,0);a=H[c+16>>2];H[a+16>>2]=9321;F[a+8|0]=3;H[a>>2]=10683;F[a+24|0]=1;H[a+28>>2]=d;F[c+97|0]=118;if(I[c+87|0]){break a}Yc(c,0);if((wi(c,19507,2)|0)==7){Mb(c)}d=Mp(c);while(1){if(!(f>>>0>2|d)){d=Ka[H[(f<<2)+51124>>2]](c)|0;f=f+1|0;continue}break}c:{if(!d){f=0;a=Ga-16|0;Ga=a;d:{if(!H[17597]){break d}d=1;while(1){if(!d){break d}e:{if(K[17597]<=f>>>0){d=0;H[a+12>>2]=0;break e}e=H[H[17598]+(f<<2)>>2];H[a+12>>2]=0;d=1;if(!e){break e}e=Ka[e|0](c,a+12|0,0)|0;if(!e){break e}H[a>>2]=H[a+12>>2];te(c,e,8100,a);d=0}Wa(H[a+12>>2]);f=f+1|0;continue}}Ga=a+16|0;if(!Mp(c)){break c}break a}Yc(c,d)}a=H[16005];d=H[16006];f=ql(H[c+332>>2]);e=ql(H[c+336>>2]);f=ql(H[c+340>>2])+f|0;h=ql(H[c+344>>2]);if((H[c+316>>2]-(h+(e+f|0)|0)|0)<=0){if(I[c+312|0]){Wa(H[c+352>>2])}f=a&-8;e=(f|0)<5;f:{if(!(e|(d|0)<=0)){e=e?0:f;Md();a=SK(d,d>>31,a,a>>31);d=Ja;h=d;d=xc(a,d);Ld();g:{if(!d){d=0;break g}a=af(d);h=a>>31}if(e>>>0>=384){i=TK(a,h,e+384|0,0);e=N(e,i);j=TK(a-e|0,h-((e>>31)+(a>>>0<e>>>0)|0)|0,128,0);break f}if(e>>>0>=256){i=TK(a,h,e+128|0,0);e=N(e,i);j=TK(a-e|0,h-((e>>31)+(a>>>0<e>>>0)|0)|0,128,0);break f}i=TK(a,h,e,0);f=e;break f}d=0;f=0}H[c+332>>2]=0;H[c+336>>2]=0;H[c+352>>2]=d;G[c+310>>1]=f;G[c+308>>1]=f;h:{if(d){a=0;h=(i|0)>0?i:0;e=0;while(1){if((e|0)!=(h|0)){H[d>>2]=a;H[c+332>>2]=d;e=e+1|0;a=d;d=f+a|0;continue}break}H[c+348>>2]=d;H[c+340>>2]=0;H[c+344>>2]=0;a=0;f=(j|0)>0?j:0;e=0;while(1){if((e|0)!=(f|0)){H[d>>2]=a;H[c+340>>2]=d;e=e+1|0;a=d;d=a+128|0;continue}break}H[c+304>>2]=0;F[c+312|0]=1;H[c+356>>2]=d;a=i+j|0;break h}F[c+312|0]=0;G[c+308>>1]=0;H[c+304>>2]=1;H[c+356>>2]=c;H[c+348>>2]=c;H[c+340>>2]=0;H[c+344>>2]=0;H[c+352>>2]=c;a=0}H[c+316>>2]=a}Rw(c,1e3)}f=Mp(c);i:{if((f&255)==7){Zw(c,0);c=0;break i}if(!f){break i}F[c+97|0]=186}H[b>>2]=c;Jp(H[g+8>>2])}Ga=g+16|0;return f|0}function Ui(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0;p=Ga-32|0;Ga=p;q=H[g+16>>2];u=H[a+4>>2];k=H[a+8>>2];s=I[k+16|0];m=H[a>>2];t=H[m+4>>2];m=H[m>>2];r=H[g>>2];H[i>>2]=0;H[k>>2]=b;H[k+4>>2]=c;w=(r|0)>0?r:0;c=H[g+4>>2];while(1){if((n|0)!=(w|0)){b=H[u+24>>2];F[c+5|0]=0;b=b+N(H[c+8>>2],48)|0;o=H[b+32>>2];v=(d&o)!=(o|0);o=H[b+36>>2];a:{if(v|(e&o)!=(o|0)|J[b+12>>1]&f){break a}if(!j){if(XA(b)){break a}}F[c+5|0]=1}c=c+12|0;n=n+1|0;continue}break}c=0;o=$a(q,0,r<<3);H[g+56>>2]=0;H[g+48>>2]=25;H[g+52>>2]=0;H[g+40>>2]=-1568170194;H[g+44>>2]=1416446638;H[g+32>>2]=0;H[g+20>>2]=0;H[g+24>>2]=0;q=t+(s<<6)|0;b=q;d=H[b+60>>2];e=H[b+56>>2];H[g+88>>2]=0;H[g+64>>2]=e;H[g+68>>2]=d;d=Ga-32|0;Ga=d;f=H[m>>2];e=H[Id(f,H[b+24>>2])+8>>2];H[f+56>>2]=H[f+56>>2]+1;b=Ka[H[H[e>>2]+12>>2]](e,g)|0;f=H[m>>2];H[f+56>>2]=H[f+56>>2]-1;b:{if(!b|(b|0)==19){break b}if((b|0)==7){Mb(f);break b}f=H[e+8>>2];if(!f){y=d,z=Dg(b),H[y>>2]=z;Za(m,8310,d);break b}H[d+16>>2]=f;Za(m,8310,d+16|0)}Wa(H[e+8>>2]);H[e+8>>2]=0;Ga=d+32|0;c:{if(b){if((b|0)==19){break c}c=b;break c}$a(H[k+52>>2],0,r<<2);H[k+32>>2]=0;H[k+36>>2]=0;H[k+24>>2]=0;H[k+28>>2]=0;n=H[g+4>>2];f=-1;while(1){if((c|0)!=(w|0)){d:{s=(c<<3)+o|0;b=H[s>>2];if((b|0)<=0){break d}e:{f:{if((b|0)>(r|0)){break f}e=H[n+8>>2];if((e|0)<0|(e|0)>=H[u+12>>2]){break f}d=b-1|0;t=H[k+52>>2]+(d<<2)|0;if(H[t>>2]){break f}if(I[n+5|0]){break e}}H[p+16>>2]=H[H[q+24>>2]>>2];Za(m,9744,p+16|0);c=1;break c}b=H[u+24>>2]+N(e,48)|0;e=H[b+32>>2];v=H[k+4>>2]|H[b+36>>2];H[k>>2]=e|H[k>>2];H[k+4>>2]=v;H[t>>2]=b;g:{if(!I[s+4|0]){break g}if(!(h>>>c&1|c>>>0>15)){G[k+30>>1]=J[k+30>>1]|1<<d}if(I[b+15|0]!=74){break g}F[k+28|0]=I[k+28|0]|2}e=(d|0)>(f|0);h:{if(H[g+88>>2]&(c>>>0<32?1<<c:0)){H[k+36>>2]=H[k+36>>2]|1<<d;break h}if(!(F[b+12|0]&1)){break h}H[g+32>>2]=0;H[g+56>>2]=H[g+56>>2]&-2;H[i>>2]=1}f=e?d:f;if(!XA(b)|!H[i>>2]){break d}if(H[g+28>>2]){Wa(H[g+24>>2]);H[g+24>>2]=0;H[g+28>>2]=0}H[j>>2]=1;c=0;break c}n=n+12|0;c=c+1|0;continue}break}G[k+44>>1]=f+1;b=((f|0)>=0?f:-1)+1|0;c=0;i:{while(1){if((b|0)==(c|0)){break i}d=c<<2;c=c+1|0;if(H[d+H[k+52>>2]>>2]){continue}break}H[p>>2]=H[H[q+24>>2]>>2];Za(m,9744,p);c=1;break c}H[k+24>>2]=H[g+20>>2];F[k+28|0]=I[k+28|0]&254|F[g+28|0]&1;H[g+28>>2]=0;H[k+32>>2]=H[g+24>>2];c=0;c=H[g+32>>2]?H[g+8>>2]:c;G[k+18>>1]=0;F[k+29|0]=c;l=M[g+40>>3];b=0;j:{if(l<=1){break j}if(l<=2e9){k:{if(l<0x10000000000000000&l>=0){c=P(l)>=1?~~(l>0?R(T(l*2.3283064365386963e-10),4294967295):U((l-+(~~l>>>0>>>0))*2.3283064365386963e-10))>>>0:0;b=~~l>>>0;break k}c=0;b=0}b=je(b,c);break j}C(+l);b=x(1)|0;x(0)|0;b=N(b>>>20|0,10)-10220|0}G[k+20>>1]=b;y=k,z=je(H[g+48>>2],H[g+52>>2]),G[y+22>>1]=z;H[k+40>>2]=H[k+40>>2]&-4097|H[g+56>>2]<<12&4096;c=Ik(a,k);if(!(F[k+28|0]&1)){break c}Wa(H[k+32>>2]);F[k+28|0]=I[k+28|0]&254}Ga=p+32|0;return c}function Li(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;j=Ga-16|0;Ga=j;s=H[b+4>>2];a:{if(!s){break a}v=I[a+239|0]?98:99;k=H[b>>2];w=(s|0)>1?s:1;t=H[b+12>>2];c=H[t+12>>2];x=c&2;y=c&1;A=c&4;B=c&16;z=c&32;C=!(c&8);b:while(1){e=0;while(1){c=H[b+8>>2];if((c|0)>(e|0)){c=H[(e<<2)+k>>2];c:{if(I[c+4|0]){_q(c);break c}d=Cz(a,c);if(d){break a}}e=e+1|0;continue}break}Ki(k,s,c,100);d=0;H[b+8>>2]=0;f=H[k>>2];if(!H[f+40>>2]){break a}c=H[f+60>>2];H[b+44>>2]=c;f=H[f+64>>2];H[b+40>>2]=f;e=H[t>>2];if(!(!e|B)){g=H[t+4>>2];if((g|0)>(c|0)|(c|0)>(g|0)&C){break a}if(Ob(f,e,g)){break a}}g=1;while(1){d:{if((g|0)==(w|0)){g=w;break d}e=H[(g<<2)+k>>2];if(!H[e+40>>2]|(c|0)!=H[e+60>>2]){break d}if(Ob(f,H[e+64>>2],c)){break d}g=g+1|0;continue}break}e:{if((g|0)!=1|x|z){break e}c=H[k>>2];f=H[c+56>>2];f:{g:{h:{i:{if(I[a+239|0]){if(f){break e}H[b+52>>2]=H[c+76>>2];break i}a=H[c+76>>2];H[b+52>>2]=a;if(f){break h}}H[b+48>>2]=H[c+72>>2];break g}d=zz(b,H[c+72>>2],a);H[b+48>>2]=H[b+16>>2];if(d){break f}}d=100}H[b+8>>2]=1;break a}e=0;while(1){if((e|0)!=(g|0)){yz(a,H[(e<<2)+k>>2]);e=e+1|0;continue}break}Ki(k,g,g,v);c=0;n=0;h=0;while(1){j:{if(H[H[k>>2]+80>>2]){H[j+12>>2]=0;H[j+8>>2]=0;e=H[k>>2];f=H[e+88>>2];o=H[e+92>>2];Mm(a,e,j+12|0,j+8|0);e=1;while(1){if((e|0)==(g|0)){e=g;break j}l=H[(e<<2)+k>>2];if(!H[l+80>>2]|((f|0)!=H[l+88>>2]|(o|0)!=H[l+92>>2])){break j}Mm(a,l,0,0);e=e+1|0;continue}}if((h|0)>0){d=xz(b,h+20|0);if(d){break a}a=H[b+16>>2]+h|0;F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;F[a+16|0]=0;F[a+17|0]=0;F[a+18|0]=0;F[a+19|0]=0;F[a+8|0]=0;F[a+9|0]=0;F[a+10|0]=0;F[a+11|0]=0;F[a+12|0]=0;F[a+13|0]=0;F[a+14|0]=0;F[a+15|0]=0;H[b+52>>2]=h;H[b+8>>2]=g;H[b+48>>2]=H[b+16>>2];d=100;break a}H[b+8>>2]=g;continue b}if(A){wz(H[t+8>>2],0,j+12|0,j+8|0)}k:{q=H[j+8>>2];l:{if((q|0)<=0?x:0){break l}m:{if(!(!I[a+239|0]|(h|0)<=0)){if((n|0)<=(o|0)&c>>>0<=f>>>0|(n|0)<(o|0)){break k}r=n-((c>>>0<f>>>0)+o|0)|0;l=c-f|0;break m}if(((n|0)>=(o|0)&c>>>0>=f>>>0|(n|0)>(o|0))&(h|0)>0){break k}r=o-((c>>>0>f>>>0)+n|0)|0;l=f-c|0}d=xz(b,(ce(l,r)+((y?q+1|0:0)+h|0)|0)+20|0);if(d){break a}p=H[b+16>>2]+h|0;if(z){d=0;u=0;m=Ga-16|0;Ga=m;i=H[j+12>>2];H[m+12>>2]=i;n:{switch(I[i|0]-1|0){case 1:d=pc(p,l,r);F[d+p|0]=2;u=1;d=d+1|0;default:Wf(0,m+12|0);break;case 0:break n}}q=i+q|0;while(1){i=H[m+12>>2];if(i>>>0<q>>>0){i=i+1|0;i=qd(i,m)+i|0;H[m+12>>2]=i;if(I[i|0]==2){if(!u){d=pc(d+p|0,l,r)+d|0}F[d+p|0]=1;d=d+1|0;d=pc(d+p|0,H[m>>2],H[m+4>>2])+d|0;F[d+p|0]=2;u=1;d=d+1|0}Wf(0,m+12|0);continue}break}Ga=m+16|0;if(u){F[d+p|0]=0;d=d+1|0}c=d?f:c;n=d?o:n;h=d+h|0;break l}h=pc(p,l,r)+h|0;if(y){Ya(H[b+16>>2]+h|0,H[j+12>>2],q);c=h+q|0;F[c+H[b+16>>2]|0]=0;h=c+1|0}c=f;n=o}Ki(k,g,e,v);continue}break}break}d=267}Ga=j+16|0;return d}function Hz(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;o=Ga-32|0;Ga=o;H[o+28>>2]=0;a:{b:{if((d|0)<0){c:{if(!H[a+260>>2]|H[a+280>>2]!=(b|0)){break c}H[o+16>>2]=0;t=Ga-16|0;Ga=t;j=H[a+260>>2];d:{e:{f:{g:{u=(g|h)!=0;if(u){k=(j+N(c,24)|0)+12|0;while(1){k=H[k>>2];H[t+12>>2]=k;h:{if(k){if(f){if(H[k+16>>2]<(f|0)){continue}if(Ob(H[k+12>>2],e,f)){continue}}if((q|0)!=(r|0)){j=l;break h}q=q+16|0;j=Ae(l,q<<2);if(j){break h}break f}if(r>>>0>=2){q=l;m=Ga-208|0;Ga=m;H[m+8>>2]=1;H[m+12>>2]=0;s=r<<2;i:{if(!s){break i}H[m+16>>2]=4;H[m+20>>2]=4;k=4;n=4;p=2;while(1){j=k;k=j+(n+4|0)|0;H[(m+16|0)+(p<<2)>>2]=k;p=p+1|0;n=j;if(k>>>0<s>>>0){continue}break}n=(q+s|0)-4|0;j:{if(n>>>0<=q>>>0){n=0;p=1;k=1;s=0;j=0;break j}p=1;k=1;while(1){k:{if((p&3)==3){eq(q,k,m+16|0);tm(m+8|0,2);k=k+2|0;break k}j=k-1|0;l:{if(K[(m+16|0)+(j<<2)>>2]>=n-q>>>0){sm(q,p,H[m+12>>2],k,0,m+16|0);break l}eq(q,k,m+16|0)}if((k|0)==1){rm(m+8|0,1);k=0;break k}rm(m+8|0,j);k=1}j=H[m+8>>2];p=j|1;H[m+8>>2]=p;q=q+4|0;if(n>>>0>q>>>0){continue}break}n=H[m+12>>2];s=(n|0)!=0;j=j>>>0>1}sm(q,p,n,k,0,m+16|0);if(!(s?1:(k|0)!=1|j)){break i}while(1){m:{if((k|0)<=1){j=Wx(p,n);tm(m+8|0,j);n=H[m+12>>2];p=H[m+8>>2];j=j+k|0;break m}p=m+8|0;rm(p,2);H[m+8>>2]=H[m+8>>2]^7;tm(p,1);n=q-4|0;s=m+16|0;j=k-2|0;sm(n-H[s+(j<<2)>>2]|0,H[m+8>>2],H[m+12>>2],k-1|0,1,s);rm(p,1);p=H[m+8>>2]|1;H[m+8>>2]=p;k=n;n=H[m+12>>2];sm(k,p,n,j,1,s)}k=j;q=q-4|0;if((k|0)!=1|(p|0)!=1|n){continue}break}}Ga=m+208|0;j=r;break g}j=1;k=0;n=0;if((r|0)!=1){break e}break g}H[(r<<2)+j>>2]=k;r=r+1|0;k=H[t+12>>2];l=j;continue}}j=Dz((j+N(c,24)|0)+4|0,e,f);H[t+12>>2]=j;if(j){j=1;l=t+12|0;break g}j=0;break d}n=j<<2;j=n+100|0;k=Ib(j,0);if(!k){break f}r=$a(k,0,j);j=r+96|0;H[r+56>>2]=j;H[r>>2]=2147483647;Ya(j,l,n);n=0;break e}k=0;n=7}j=n;if(!u){break d}Wa(l)}H[o+16>>2]=k;Ga=t+16|0;l=j;if(j){break c}j=H[o+16>>2];if(!j){break c}l=Fz(i,j)}j=0;if((d|0)==-1){break a}if(l){break b}}l=Ga-16|0;Ga=l;H[l+12>>2]=0;n:{if((d|0)<0){j=Pb(a,13,l+12|0,0);if(j){break n}j=0;d=H[l+12>>2];Vb(d,1,rf(a,b,c,0),Ja);Vb(d,2,rf(a,b,c,1023),Ja);break n}j=Pb(a,12,l+12|0,0);if(j){break n}Vb(H[l+12>>2],1,rf(a,b,c,d),Ja);j=0}H[o+28>>2]=H[l+12>>2];Ga=l+16|0;l=j;j=H[o+28>>2]}k=g?o+8|0:0;h=g|h;g=!h;while(1){if(l){break a}l=Ab(j);if((l|0)!=100){break a}H[o+24>>2]=0;v=o,w=ed(j,1),H[v+16>>2]=w;H[o+20>>2]=Ja;v=o,w=ed(j,2),H[v+8>>2]=w;H[o+12>>2]=Ja;d=ed(j,3);c=Ja;n=_d(j,4);r=mf(j,4);l=H[o+16>>2];b=H[o+20>>2];o:{if(!r|(!e|!(l|b))){break o}l=$q(a,e,f,r,n,o+16|0,k);if(l){break a}l=H[o+16>>2];b=H[o+20>>2];if(h){break o}H[o+8>>2]=l;H[o+12>>2]=b}l=Ez(H[i+4>>2]+1|0,g,l,b,H[o+8>>2],H[o+12>>2],d,c,r,n,o+24|0);if(l){break a}l=Fz(i,H[o+24>>2]);continue}}a=rb(j);Ga=o+32|0;return(l|0)==101?a:l}function zm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=Ga-32|0;Ga=e;m=H[a>>2];o=H[b+20>>2];H[d>>2]=0;i=H[o+68>>2];a:{if((i|0)!=(c|0)&(i|0)<H[m+24>>2]){break a}i=H[b+28>>2];h=H[b+24>>2];H[e+16>>2]=h;H[e+20>>2]=i;f=H[o+28>>2];H[e+28>>2]=f;b:{j=i;if(I[b+32|0]?0:(h|0)==H[a+32>>2]&(i|0)==H[a+36>>2]){break b}H[e+24>>2]=0;m=I[m+239|0];f=0;i=b;while(1){b=H[b+8>>2];if(b){f=I[b+32|0]?1:f;l=H[b>>2];i=(l|0)==1?b:i;g=(l|0)==4?1:g;continue}break}if(!g){g=0;break a}if(H[o+40>>2]){b=I[i+32|0];ym(a,i,e+24|0);c:{while(1){g=H[e+24>>2];if(g){break a}l=I[i+32|0];if(l){break c}wd(a,i,e+24|0);if((h|0)!=H[i+24>>2]|(j|0)!=H[i+28>>2]|b){continue}break}g=H[e+24>>2];if(g){break a}l=I[i+32|0]}g=267;if((b|0)!=(l|0)){break a}}d:{if(!(f&255)){break d}while(1){if(I[i+32|0]){break d}wd(a,i,e+24|0);g=H[e+24>>2];if(!g){continue}break}break a}l=1;while(1){e:{f:{g:{if(i){j=H[(H[i>>2]==1?H[i+16>>2]:i)+20>>2];g=H[j+48>>2];H[e+28>>2]=g;b=H[j+60>>2];H[e+16>>2]=H[j+56>>2];H[e+20>>2]=b;b=H[j+4>>2];if((m|0)!=I[a+52|0]){break g}F[e+15|0]=b?b+H[j>>2]>>>0<=g>>>0:1;while(1){h:{if(g){f=I[e+15|0];k=H[e+16>>2];n=H[a+32>>2];b=H[e+20>>2];h=H[a+36>>2];b=k>>>0>n>>>0&(b|0)>=(h|0)|(b|0)>(h|0)?1:(k|0)!=(n|0)|(b|0)!=(h|0)?-1:0;if(f|((m?0-b|0:b)|0)>=0){break e}break h}f=I[e+15|0];if(f){break f}}f=H[j>>2];h=H[j+4>>2];b=e+16|0;g=Ga-16|0;Ga=g;k=H[e+28>>2];H[g+12>>2]=k;i:{if(!k){f=qd(f,b)+f|0;break i}Fe(0,g+12|0);h=f+h|0;f=H[g+12>>2];j:{while(1){if(f>>>0<h>>>0){if(I[f|0]){break j}f=f+1|0;continue}break}F[e+15|0]=1;break i}n=qd(f,g);h=H[g>>2];p=m?0-h|0:h;k=p+H[b>>2]|0;q=(h|0)!=0;h=H[g+4>>2];h=H[b+4>>2]+(m?0-(q+h|0)|0:h)|0;H[b>>2]=k;H[b+4>>2]=k>>>0<p>>>0?h+1|0:h;f=f+n|0}H[e+28>>2]=f;Ga=g+16|0;g=H[e+28>>2];continue}}f=l?H[o+48>>2]:0;H[e+28>>2]=f;break b}f=1;k:{if(!b){break k}f=0;if(!g){break k}f=K[j>>2]>=g>>>0}F[e+15|0]=f;while(1){l:{if(g){f=I[e+15|0];k=H[e+16>>2];n=H[a+32>>2];b=H[e+20>>2];h=H[a+36>>2];if(((m?k>>>0<n>>>0&(b|0)<=(h|0)|(b|0)<(h|0):k>>>0>n>>>0&(b|0)>=(h|0)|(b|0)>(h|0))|0)!=1){break e}if(!(f&255)){break l}break e}f=I[e+15|0];if(f){break f}}Lm(m,H[j>>2],H[j+4>>2],e+28|0,e+16|0,e+8|0,e+15|0);g=H[e+28>>2];continue}}g=0}H[j+48>>2]=g;b=H[e+20>>2];g=H[e+16>>2];H[j+56>>2]=g;H[j+60>>2]=b;l=!(f&255)&(H[a+32>>2]==(g|0)&H[a+36>>2]==(b|0))?l:0;i=H[i+12>>2];continue}}g=0;if(!f){break a}m:{if(I[f|0]==1){a=f+1|0;H[e+28>>2]=a;b=F[f+1|0];n:{if((b|0)<0){b=uc(a,e+24|0);break n}H[e+24>>2]=b&255;b=1}f=b+a|0;H[e+28>>2]=f;break m}H[e+24>>2]=0}while(1){a=H[e+24>>2];if((a|0)<(c|0)){Wf(0,e+28|0);a=H[e+28>>2];if(!I[a|0]){break a}b=a+1|0;a=F[a+1|0];o:{if((a|0)<0){a=uc(b,e+24|0);break o}H[e+24>>2]=a&255;a=1}f=a+b|0;H[e+28>>2]=f;continue}break}H[d>>2]=(a|0)==(c|0)?I[f|0]?f:0:0}Ga=e+32|0;return g}function be(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if(!(I[a+16|0]&2)){F[a+18|0]=b;return 0}if(I[a+18|0]!=(b|0)){k=b&255;f=a;a:{if(!((k|0)==1|I[a+18|0]==1)){c=7;if(Fg(f)){break a}b=H[f+8>>2];c=b+(H[f+12>>2]&-2)|0;while(1){if(b>>>0<c>>>0){a=I[b+1|0];F[b+1|0]=I[b|0];F[b|0]=a;b=b+2|0;continue}break}F[f+18|0]=k;c=0;break a}b=H[f+12>>2];b:{if((k|0)==1){b=b&-2;H[f+12>>2]=b;c=b>>31<<1|b>>>31;a=b<<1|1;break b}c=b>>31<<1|b>>>31;a=(b<<1)+2|0;c=a>>>0<2?c+1|0:c}g=a;a=H[f+8>>2];g=Uc(H[f+20>>2],g,c);c=7;if(!g){break a}j=a+b|0;b=g;c:{d:{e:{f:{g:{switch(I[f+18|0]-1|0){case 0:if((k|0)!=2){break e}c=g;h:while(1){if(a>>>0>=j>>>0){break d}b=a+1|0;i:{e=I[a|0];if(e>>>0<192){a=b;break i}d=I[e+31856|0];while(1){j:{if((b|0)==(j|0)){a=j}else{a=I[b|0];if((a&192)==128){break j}a=b}e=65533;if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break i}if(d>>>0<=65535){e=d;break i}F[c+2|0]=d;F[c+3|0]=d>>>8&3|220;b=d-65536|0;F[c+1|0]=b>>>18&3|216;F[c|0]=b>>>10&192|d>>>10&63;c=c+4|0;continue h}d=a&63|d<<6;b=b+1|0;continue}}F[c|0]=e;F[c+1|0]=e>>>8;c=c+2|0;continue};default:while(1){if(a>>>0>=j>>>0){break f}h=I[a+1|0];e=I[a|0];i=h|e<<8;c=a+2|0;if(!((e&248)!=216|c>>>0>=j>>>0)){l=I[a+2|0];d=I[a+3|0];F[b+3|0]=d&63|128;e=(i<<10&983040)+65536|0;F[b|0]=e>>>18|240;c=h<<10;F[b+1|0]=(e|c&61440)>>>12&63|128;F[b+2|0]=(c|(d|l<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(i>>>0<=127){F[b|0]=h;b=b+1|0}else{if(i>>>0<=2047){F[b+1|0]=h&63|128;F[b|0]=i>>>6|192;b=b+2|0}else{F[b+2|0]=h&63|128;F[b|0]=e>>>4|224;F[b+1|0]=i>>>6&63|128;b=b+3|0}}a=c;continue};case 1:break g}}while(1){if(a>>>0>=j>>>0){break f}h=I[a|0];e=I[a+1|0];i=h|e<<8;c=a+2|0;if(!((e&248)!=216|c>>>0>=j>>>0)){l=I[a+3|0];d=I[a+2|0];F[b+3|0]=d&63|128;e=(i<<10&983040)+65536|0;F[b|0]=e>>>18|240;c=h<<10;F[b+1|0]=(e|c&61440)>>>12&63|128;F[b+2|0]=(c|(d|l<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(i>>>0<=127){F[b|0]=h;b=b+1|0}else{if(i>>>0<=2047){F[b+1|0]=h&63|128;F[b|0]=i>>>6|192;b=b+2|0}else{F[b+2|0]=h&63|128;F[b|0]=e>>>4|224;F[b+1|0]=i>>>6&63|128;b=b+3|0}}a=c;continue}}H[f+12>>2]=b-g;break c}c=g;while(1){if(a>>>0>=j>>>0){break d}b=a+1|0;d=I[a|0];k:{l:{if(d>>>0<192){a=b;break l}d=I[d+31856|0];while(1){m:{n:{if((b|0)==(j|0)){a=j}else{a=I[b|0];if((a&192)==128){break n}a=b}if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break m}if(d>>>0<=65535){break l}F[c+2|0]=d>>>8&3|220;b=d-65536|0;F[c+1|0]=b>>>10&192|d>>>10&63;F[c|0]=b>>>18&3|216;e=4;b=c+3|0;break k}d=a&63|d<<6;b=b+1|0;continue}break}d=65533}F[c|0]=d>>>8;e=2;b=c+1|0}F[b|0]=d;c=c+e|0;continue}}H[f+12>>2]=c-g;F[c|0]=0;b=c+1|0}F[b|0]=0;a=J[f+16>>1];hd(f);F[f+18|0]=k;H[f+32>>2]=g;H[f+8>>2]=g;G[f+16>>1]=a&2109|514;m=f,n=Rf(H[f+20>>2],g),H[m+24>>2]=n;c=0}}else{c=0}return c}function wn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;p=Ga-32|0;Ga=p;o=zb(a);n=H[a+40>>2];H[a+40>>2]=n+1;a:{if(!d){d=0;break a}if(!(I[b+5|0]&16)){break a}h=H[H[b+20>>2]+28>>2];i=H[h>>2];j=(i|0)>0?i:0;while(1){b:{if((g|0)!=(j|0)){if(!$f(H[(h+(g<<4)|0)+8>>2])){break b}}else{g=j}d=(g|0)==(i|0)?0:d;break a}g=g+1|0;continue}}u=c&4;c:{d:{if(H[a+36>>2]){break d}e:{f:{if((H[b+4>>2]&4160)!=4096){break f}g=H[b+20>>2];if(H[g+52>>2]|I[g+4|0]&9|(H[g+60>>2]|H[g+36>>2])){break f}j=H[g+32>>2];if(H[j>>2]!=1|H[j+28>>2]|I[H[j+24>>2]+43|0]==1){break f}h=0;j=H[g+28>>2];i=H[j>>2];i=(i|0)>0?i:0;while(1){if((h|0)==(i|0)){break e}k=h<<4;h=h+1|0;if(I[H[(j+k|0)+8>>2]]==167){continue}break}}g=0}if(!g){break d}q=H[g+28>>2];j=H[q>>2];i=H[H[g+32>>2]+24>>2];r=Lb(H[a>>2],H[i+60>>2]);Fd(a,r);g=0;Dd(a,r,H[i+20>>2],0,H[i>>2]);if(!((j|0)!=1|G[H[q+8>>2]+32>>1]>=0)){c=Sb(o,14);fe(a,n,r,i,112);H[p>>2]=H[i>>2];qc(a,0,18740,p);bb(o,c);h=1;break c}h=1;while(1){if(!(!h|(g|0)>=(j|0))){h=Rg(H[b+12>>2],g);k=Uk(i,G[H[(q+(g<<4)|0)+8>>2]+32>>1]);h=(k|0)>66|Qg(h,k)-65>>>0<2;g=g+1|0;continue}break}if(!h){break d}v=(j|0)>0?j:0;g=i+8|0;i=j&31;if((j&63)>>>0>=32){h=-1<<i;l=0}else{l=-1<<i;h=l|(1<<i)-1&-1>>>32-i}w=l^-1;x=h^-1;h=0;while(1){k=H[g>>2];if(!(!k|h)){h=0;g=J[k+52>>1];g:{if((g|0)<(j|0)|(H[k+36>>2]|g>>>0>62)){break g}h:{if(!u){break h}if((j|0)<J[k+50>>1]){break g}if((g|0)<=(j|0)){break h}if(!I[k+54|0]){break g}}s=0;t=0;while(1){i:{if((h|0)==(v|0)){break i}g=0;l=Rg(H[b+12>>2],h);m=H[(q+(h<<4)|0)+8>>2];i=vg(a,l,m);while(1){l=(g|0)==(j|0);if(l){break i}j:{if(J[H[k+4>>2]+(g<<1)>>1]==J[m+32>>1]){if(!i){break j}if(!hb(H[i>>2],H[H[k+32>>2]+(g<<2)>>2])){break j}}g=g+1|0;continue}break}if(l){break i}m=g&31;if((g&63)>>>0>=32){i=1<<m;l=0}else{l=1<<m;i=l-1&1>>>32-m}m=l;if(s&m|i&t){break i}if(e){H[(h<<2)+e>>2]=g}s=m|s;t=i|t;h=h+1|0;continue}break}h=0;if((s|0)!=(w|0)|(t|0)!=(x|0)){break g}i=Sb(o,14);H[p+16>>2]=H[k>>2];qc(a,0,18709,p+16|0);Xa(o,112,n,H[k+44>>2],r);Od(a,k);h=I[H[k+28>>2]];k:{if(!d){break k}g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[d>>2]=g;if((j|0)!=1){break k}rC(o,n,g)}h=h+3|0;bb(o,i)}g=k+20|0;continue}break}if(h){break c}}l:{if(!(c&1)|I[b+5|0]&16){break l}c=H[b+12>>2];H[b+12>>2]=0;g=Me(b);H[b+12>>2]=c;if(H[H[b+20>>2]>>2]>2?g:0){break l}n=-1;H[a+40>>2]=H[a+40>>2]-1;h=5;break c}c=H[a+136>>2];m:{if(u){g=0;H[a+136>>2]=0;break m}if(!d){g=0;break m}g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[d>>2]=g}qC(a,b,n);if(g){rC(o,n,g)}H[a+136>>2]=c;h=2}n:{if(!e|(h|0)==3|(h|0)==4){break n}g=0;a=Zc(H[b+12>>2]);a=(a|0)>0?a:0;while(1){if((a|0)==(g|0)){break n}H[(g<<2)+e>>2]=g;g=g+1|0;continue}}H[f>>2]=n;Ga=p+32|0;return h}function Hv(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=Ga-32|0;Ga=g;d=H[a>>2];H[g+16>>2]=0;H[g+12>>2]=1;H[g+8>>2]=H[a+168>>2];a:{b:{c=Nd(H[a+68>>2],g+24|0);if(c){break b}e=H[a+224>>2];c=jp(H[a+68>>2],e,H[H[a>>2]+8>>2]+1|0);c:{if(c){break c}if(!I[e|0]){c=0;break c}c=pg(d,e,0,g+12|0)}d:{e:{if(!H[g+12>>2]|c){break e}H[a+80>>2]=0;H[a+84>>2]=0;j=a+80|0;e=b;f:while(1){c=Ev(a,b,H[g+24>>2],H[g+28>>2],g+20|0,g+16|0);if(c){if((c|0)==101){break d}break b}h=H[g+20>>2];if((h|0)==-1){d=H[g+24>>2];c=H[a+156>>2];i=d-c|0;f=H[g+28>>2]-(c>>>0>d>>>0)|0;c=H[a+172>>2];d=H[a+168>>2]+8|0;c=d>>>0<8?c+1|0:c;h=TK(i,f,d,c);H[g+20>>2]=h}g:{if(b|h){k=H[a+156>>2];d=H[a+80>>2];c=H[a+84>>2];break g}k=H[a+156>>2];f=H[a+88>>2];d=k+f|0;c=H[a+92>>2];c=d>>>0<f>>>0?c+1|0:c;f=H[a+80>>2];i=H[a+84>>2];if((d|0)!=(f|0)|(i|0)!=(c|0)){d=f;c=i;break g}f=H[g+24>>2];o=f-d|0;h=H[g+28>>2]-((d>>>0>f>>>0)+c|0)|0;f=H[a+172>>2];i=H[a+168>>2]+8|0;f=i>>>0<8?f+1|0:f;h=TK(o,h,i,f);H[g+20>>2]=h}h:{if((d|0)!=(k|0)|c){break h}d=H[g+16>>2];c=ar(a,d);if(c){break b}H[a+28>>2]=d;if(d>>>0<=K[a+160>>2]){break h}H[a+160>>2]=d}d=h+m|0;f=0;while(1){if((f|0)==(h|0)){m=d;continue f}if(e){eh(a)}i:{c=Nl(a,j,0,1,0);if(c){if((c|0)==101){break i}if((c|0)==522){break d}break e}f=f+1|0;m=m+1|0;e=0;continue}break}e=H[g+28>>2];H[j>>2]=H[g+24>>2];H[j+4>>2]=e;e=0;continue}}if(c){break b}}c=ui(a,g+8|0,-1);F[a+19|0]=I[a+12|0];if(c){break a}e=H[a+224>>2];l=e+4|0;c=jp(H[a+68>>2],l,H[H[a>>2]+8>>2]+1|0);if(c){break a}if((I[a+17|0]-4&255)>>>0<=252){c=Or(a,0);if(c){break a}}c=Jj(a,I[l|0]!=0,0);if(c){break a}if(!(!I[l|0]|!H[g+12>>2])){F[e|0]=0;F[e+1|0]=0;F[e+2|0]=0;F[e+3|0]=0;h=Ga-16|0;Ga=h;d=7;k=H[a>>2];e=H[k+4>>2]<<1;j=Ad(e,e>>31);j:{if(!j){e=0;break j}e=0;c=ff(k,l,j,16385,0);if(c){d=c;break j}n=H[k+4>>2];c=Nd(j,h+8|0);if(c){d=c;break j}o=H[k+8>>2]+1|0;c=o;i=c;f=c+H[h+8>>2]|0;c=H[h+12>>2]+(c>>31)|0;c=f>>>0<i>>>0?c+1|0:c;f=f+6|0;c=f>>>0<6?c+1|0:c;c=xc(f,c);if(!c){break j}F[c|0]=0;F[c+1|0]=0;F[c+2|0]=0;F[c+3|0]=0;k:{i=c+4|0;e=H[h+8>>2];d=Jc(j,i,e,0,0);l:{if(d){break l}n=j+n|0;p=(e+i|0)+2|0;F[i+H[h+8>>2]|0]=0;F[(i+H[h+8>>2]|0)+1|0]=0;e=i;while(1){d=e-i|0;q=d>>>0<K[h+8>>2];f=H[h+12>>2];d=d>>31;if(q&(f|0)>=(d|0)|(d|0)<(f|0)){d=pg(k,e,0,h+4|0);if(d){break l}m:{if(!H[h+4>>2]){break m}f=ff(k,e,n,16385,0);if(f){break k}f=jp(n,p,o);$c(n);if(f){break k}if(!I[p|0]){break m}if(!ad(p,l)){break l}}e=(ib(e)+e|0)+1|0;continue}break}$c(j);d=Pe(k,l,0)}e=c;break j}e=c;d=f}Wa(e);if(j){$c(j);Wa(j)}Ga=h+16|0;c=d;break a}c=0;break a}F[a+19|0]=I[a+12|0]}if(!(!b|!m)){H[g+4>>2]=H[a+188>>2];H[g>>2]=m;Fc(539,6265,g)}Bp(a);Ga=g+32|0;return c}function fn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;m=Ga-16|0;Ga=m;p=H[a+8>>2];a:{b:{c:{d:{e:{f:{g:{j=H[b>>2];g=I[j|0];switch(g-50|0){case 1:case 2:break d;case 0:break e;case 3:break f;default:break g}}if((g|0)!=45){break d}}f=Ke(a,H[j+16>>2],f);break c}Va(p,75,0,f);break c}k=H[c+80>>2];h:{if(I[k+41|0]&4){break h}g=H[k+32>>2];if(!g|!I[H[g+28>>2]+d|0]){break h}e=!e}h=(d|0)>0?d:0;while(1){i:{if((h|0)==(w|0)){g=J[k+44>>1];i=(d|0)>(g|0)?d:g;h=0;g=d;while(1){if((g|0)==(i|0)){break i}h=(H[H[H[k+52>>2]+(g<<2)>>2]>>2]==(j|0))+h|0;g=g+1|0;continue}}g=H[H[k+52>>2]+(w<<2)>>2];if(H[g>>2]==(j|0)?g:0){break b}w=w+1|0;continue}break}H[m+12>>2]=0;g=H[j+4>>2];j:{if(!(H[H[H[j+20>>2]+28>>2]>>2]!=1?g&4096:0)){g=wn(a,j,4,0,0,m+12|0);break j}if(!(g&33554432?H[j+28>>2]:0)){x=H[a>>2];g=d;u=H[a>>2];n=nb(u,j,0);k:{if(I[u+87|0]){break k}q=H[H[n+12>>2]+20>>2];r=H[H[n+20>>2]+28>>2];while(1){if(J[k+44>>1]>(g|0)){i=H[H[k+52>>2]+(g<<2)>>2];l:{if(H[i>>2]!=(j|0)){break l}v=H[i+28>>2]-1<<4;l=v+r|0;i=H[l+8>>2];if(!i){break l}o=sb(a,o,i);H[l+8>>2]=0;i=q+v|0;s=sb(a,s,H[i+8>>2]);H[i+8>>2]=0}g=g+1|0;continue}break}qb(u,r);qb(u,q);H[H[n+12>>2]+20>>2]=s;H[H[n+20>>2]+28>>2]=o;if(!(!s|H[s>>2]!=1)){g=H[s+8>>2];H[s+8>>2]=0;fb(u,H[n+12>>2]);H[n+12>>2]=g}l=H[H[n+20>>2]+48>>2];if(!l){break k}i=H[l>>2];g=0;while(1){if((g|0)>=(i|0)){break k}G[(l+(g<<4)|0)+20>>1]=0;g=g+1|0;continue}}m:{if(I[x+87|0]){g=5;break m}t=yb(H[a>>2],h<<2,0);g=wn(a,n,4,0,t,m+12|0);H[j+28>>2]=H[m+12>>2]}fb(x,n);break j}i=H[a>>2];g=Zc(H[j+12>>2]);t=yb(i,((g|0)<(h|0)?h:g)<<2,0);g=wn(a,j,4,0,t,m+12|0)}i=(g|0)==4?!e:e;Va(p,i?31:35,H[m+12>>2],0);H[k+40>>2]=H[k+40>>2]|2048;if(!H[c+72>>2]){y=c,z=jb(a),H[y+16>>2]=z}n:{if((d|0)<=0){break n}e=H[k+40>>2];if(e&1048576){break n}H[k+40>>2]=e|262144}e=h;h=H[c+72>>2];e=e+h|0;H[c+72>>2]=e;l=H[c+76>>2];e=Yr(H[H[b+4>>2]>>2],N(e,20));if(!(!l|!e)){Ya(e,l,H[l-8>>2])}H[c+76>>2]=e;o:{if(e){l=i?37:38;v=f-d|0;h=e+N(h,20)|0;i=(g|0)!=1;g=d;q=0;while(1){if(J[k+44>>1]>(g|0)){if(H[H[H[k+52>>2]+(g<<2)>>2]>>2]==(j|0)){r=g+v|0;p:{if(!i){o=H[m+12>>2];e=Va(p,135,o,r);break p}q:{if(!t){e=0;break q}e=H[(q<<2)+t>>2];q=q+1|0}o=H[m+12>>2];e=Xa(p,94,o,e,r)}H[h+4>>2]=e;db(p,50,r);r:{if((d|0)==(g|0)){F[h+16|0]=l;H[h>>2]=o;if((d|0)>0){H[h+12>>2]=d;H[h+8>>2]=v;break r}H[h+12>>2]=0;break r}F[h+16|0]=184}h=h+20|0}g=g+1|0;continue}break}if(H[k+40>>2]&1049600|(d|0)<=0){break o}Xa(p,125,H[c+8>>2],0,d);break o}H[c+72>>2]=0}_a(H[a>>2],t);if((d|0)>(w|0)){break a}}if(!(I[H[c+80>>2]+42|0]&32)){break b}if(I[b+13|0]&8){break a}}Gh(c,b)}Ga=m+16|0;return f}function Iv(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=H[a+44>>2];a:{if(d){break a}d=0;f=H[a+104>>2];if((f|0)<=(c|0)){break a}e=((b|0)!=1)+c|0;c=e;while(1){if((c|0)<(f|0)){ug(H[(H[a+100>>2]+N(c,48)|0)+16>>2]);c=c+1|0;f=H[a+104>>2];continue}break}H[a+104>>2]=e;if((b|0)==1){c=H[a+100>>2];if(!H[(c+N(e,48)|0)+28>>2]){break a}b=H[a+72>>2];if(!H[b>>2]){break a}if(lp(b)){g=b;b=H[a+172>>2];d=H[a+168>>2]+4|0;b=d>>>0<4?b+1|0:b;b=sf(g,SK(H[(c+N(e,48)|0)+24>>2],0,d,b),Ja)}else{b=0}H[a+56>>2]=H[(c+N(e,48)|0)+24>>2];return b}if(!(H[H[a+68>>2]>>2]?1:H[a+232>>2])){break a}b=0;i=Ga-16|0;Ga=i;b:{c:{e=e?(H[a+100>>2]+N(e,48)|0)-48|0:0;if(!e){break c}k=Pj(H[e+20>>2]);if(k){break c}b=7;break b}H[a+28>>2]=H[(e?e+20|0:a+32|0)>>2];F[a+19|0]=I[a+12|0];d:{e:{f:{if(!e){if(!H[a+232>>2]){f=a+80|0;h=H[a+80>>2];j=H[a+84>>2];break f}H[a+28>>2]=H[a+32>>2];c=H[a+232>>2];if(I[c+44|0]){e=H[c+68>>2];Ya(c+52|0,Lf(c),48);d=H[c+68>>2];while(1){g:{if(b){break g}d=d+1|0;if(e>>>0<d>>>0){break g}b=H[c+32>>2];h=rg(d);h:{if(!h){b=(H[b>>2]+(d<<2)|0)+132|0;break h}b=H[b+(h<<2)>>2]+((d+33&4095)<<2)|0}b=Dv(a,H[b>>2]);continue}break}if((e|0)!=H[c+68>>2]){sp(c)}}d=b;b=jr(H[a+228>>2]);while(1){if(!(!b|d)){c=H[b+16>>2];d=Dv(a,H[b+24>>2]);b=c;continue}break}b=d;break b}f=a+80|0;h=H[a+80>>2];j=H[a+84>>2];if(H[a+232>>2]){break f}c=H[e+8>>2];d=H[e+12>>2];g=H[e+4>>2];H[f>>2]=H[e>>2];H[f+4>>2]=g;g=c;c=!(c|d);g=c?h:g;c=c?j:d;while(1){if(b){break d}b=H[f+4>>2];if((c|0)<=(b|0)&g>>>0<=K[f>>2]|(b|0)>(c|0)){break e}b=Nl(a,f,k,1,1);continue}}H[f>>2]=0;H[f+4>>2]=0}b=0}i:while(1){j:{if(b){break j}c=H[f+4>>2];if((j|0)<=(c|0)&h>>>0<=K[f>>2]|(c|0)>(j|0)){break j}H[i>>2]=0;b=Ev(a,0,h,j,i,i+12|0);c=H[i>>2];k:{if(c){break k}c=0;l=H[a+156>>2];g=l+H[a+88>>2]|0;d=H[a+92>>2];d=g>>>0<l>>>0?d+1|0:d;if((g|0)!=H[a+80>>2]|H[a+84>>2]!=(d|0)){break k}l=j-(d+(g>>>0>h>>>0)|0)|0;c=H[a+172>>2];d=H[a+168>>2]+8|0;c=d>>>0<8?c+1|0:c;c=TK(h-g|0,l,d,c)}d=0;while(1){if(c>>>0<=d>>>0|b){continue i}b=H[f+4>>2];if((b|0)>=(j|0)&K[f>>2]>=h>>>0|(b|0)>(j|0)){b=0;continue i}else{d=d+1|0;b=Nl(a,f,k,1,1);continue}}}break}l:{if(!e){break l}c=H[a+172>>2];g=H[a+168>>2]+4|0;c=g>>>0<4?c+1|0:c;d=H[e+24>>2];m=i,n=SK(d,0,g,c),H[m>>2]=n;H[i+4>>2]=Ja;c=H[a+232>>2];if(c){if(H[e+44>>2]==H[c+112>>2]){b=H[e+32>>2]}else{H[e+32>>2]=0;H[e+44>>2]=H[c+112>>2];b=0}if(b>>>0<K[c+68>>2]){H[c+68>>2]=b;H[c+76>>2]=H[e+36>>2];H[c+80>>2]=H[e+40>>2];sp(c)}d=H[e+24>>2];b=0}while(1){if(K[a+56>>2]<=d>>>0|b){break l}d=d+1|0;b=Nl(a,i,k,0,1);continue}}ug(k);if(b){break b}H[f>>2]=h;H[f+4>>2]=j;b=0}Ga=i+16|0;d=b}return d}function Mw(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;l=Ga+-64|0;Ga=l;h=ib(b);a:{b:{s=f;c:{d:{e:{f:{g:{j=H[c>>2];if(!(I[64006]|j&64)|(h|0)<5){break g}if(Ob(b,22265,5)){break g}i=h+8|0;f=0;while(1){if((g|0)!=(h|0)){k=I[b+g|0]==38;i=k+i|0;f=i>>>0<k>>>0?f+1|0:f;g=g+1|0;continue}break}h=Ib(i,f);if(!h){break b}o=j|64;f=0;F[h|0]=0;F[h+1|0]=0;F[h+2|0]=0;F[h+3|0]=0;k=h+4|0;h=5;if(I[b+5|0]!=47|I[b+6|0]!=47){break f}g=7;while(1){h=I[b+g|0];if(!(!h|(h|0)==47)){g=g+1|0;continue}break}if((g|0)==7){h=g;break f}h=16;if((g|0)==16){if(!Ob(2032,b+7|0,9)){break f}}H[l+4>>2]=b+7;H[l>>2]=g-7;g=1;a=Hb(5673,l);break d}f=Ib(h+8|0,0);if(!f){break b}F[f|0]=0;F[f+1|0]=0;F[f+2|0]=0;F[f+3|0]=0;k=f+4|0;if(h){Ya(k,b,h)}b=h+k|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;o=j&-65;break e}while(1){n=k+m|0;p=n-1|0;h:{i:{j:{k:{l:{m:while(1){g=I[b+h|0];n:while(1){j=g&255;if(!j|(j|0)==35){break h}i=h+1|0;o:{if((j|0)!=37){break o}q=I[b+i|0];if(!(I[q+30016|0]&8)){break o}r=I[(b+h|0)+2|0];if(!(I[r+30016|0]&8)){break o}h=h+3|0;g=(gf(q<<24>>24)<<4)+gf(r<<24>>24)|0;if(g){break i}while(1){g=I[b+h|0];if(!g|(g|0)==35|!f&(g|0)==63){continue n}p:{if((f|0)==1){if((g|0)==38|(g|0)==61){continue n}break p}if((f|0)!=2){break p}if((g|0)==38){continue n}}h=h+1|0;continue}}break}if((f|0)!=1){break l}if(!((j|0)==61|(j|0)==38)){f=1;break j}if(!I[p|0]){h=i;while(1){f=1;i=b+h|0;g=I[i|0];if(!g|(g|0)==35|I[i-1|0]==38){continue m}h=h+1|0;continue}}break}f=2;if((j|0)!=38){break k}g=0;F[n|0]=0;f=1;m=m+1|0;break j}if(!(!f&(j|0)==63)&((f|0)!=2|(j|0)!=38)){break j}f=1}g=0}h=i}F[k+m|0]=g;m=m+1|0;continue}break}if((f|0)==1){F[n|0]=0;m=m+1|0}b=k+m|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;h=ib(k);f=k;while(1){b=(f+h|0)+1|0;if(!I[b|0]){break e}i=ib(b);f=(i+b|0)+1|0;h=ib(f);q:{r:{switch(i-3|0){case 0:if(Ob(4998,b,3)){continue}a=f;continue;case 2:i=13743;if(Ob(13743,b,5)){continue}m=-393217;j=49328;b=393216;break q;case 1:break r;default:continue}}if((I[b|0]|I[b+1|0]<<8|(I[b+2|0]<<16|I[b+3|0]<<24))!=1701080941){continue}m=-136;i=4139;j=49360;b=o&135}g=0;s:{t:{while(1){p=(g<<3)+j|0;n=H[p>>2];if(!n){break t}u:{if((ib(n)|0)==(h|0)){if(!Ob(f,n,h)){break u}}g=g+1|0;continue}break}g=H[p+4>>2];if(g){break s}}H[l+36>>2]=f;H[l+32>>2]=i;g=1;a=Hb(7921,l+32|0);break d}if((b|0)<(g&-129)){H[l+52>>2]=f;H[l+48>>2]=i;g=3;a=Hb(8046,l+48|0);break d}else{o=g|m&o;continue}}}b=Qm(a);H[d>>2]=b;g=0;if(b){break c}H[l+16>>2]=a;g=1;a=Hb(7127,l+16|0)}H[s>>2]=a;Jp(k);k=0}H[c>>2]=o;H[e>>2]=k;break a}g=7}Ga=l- -64|0;return g}function Rv(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;i=Ga-16|0;Ga=i;c=Ol(a,0,i+12|0);a:{if(c){if((c|0)!=1288){break a}F[a+43|0]=2;F[a+50|0]=1;H[b>>2]=1}b:{c:{d:{e:{if(H[i+12>>2]){if(!Qv(a,b)){break e}}if(!(I[a+50|0]|!(I[a+46|0]&2))){c=oi(a,0);if(c){break d}dh(a,0);c=264;if(!I[a+50|0]){break a}break c}o=I[a+44|0];if(!o){c=sg(a,0,1);if(c){break d}}F[a+44|0]=1;c=Ol(a,0,i+12|0);d=0;f:{if(c){break f}if(!Qv(a,b)){c=0;d=1;break f}e=Ga-80|0;Ga=e;c=I[a+45|0];p=c+1|0;q=2-c|0;d=sg(a,p,q);if(!d){$a(a+52|0,0,48);d=Nd(H[a+8>>2],e+72|0);g:{if(d){break g}c=H[e+76>>2];h:{if(K[e+72>>2]<33&(c|0)<=0|(c|0)<0){break h}d=Jc(H[a+8>>2],e+32|0,32,0,0);if(d){break g}c=e+32|0;d=eb(c);c=eb(c|8);if(c-1&c|(d&-2)!=931071618|c-65537>>>0<4294902271){break h}H[a+36>>2]=c;d=d&1;F[a+65|0]=d;f=e+32|0;B=a,C=eb(f|12),H[B+112>>2]=C;g=H[e+52>>2];H[a+84>>2]=H[e+48>>2];H[a+88>>2]=g;tg(!d,f,24,0,a+76|0);if(H[a+76>>2]!=(eb(e+56|0)|0)){break h}if(H[a+80>>2]!=(eb(e+60|0)|0)){break h}i:{if((eb(e+32|4)|0)!=3007e3){d=xe(62953);break i}j=Ib(c+32792|0,0);if(!j){d=7;break g}w=c&65280|c>>>16;r=j+24|0;s=c+r|0;d=H[e+72>>2];l=c+24|0;m=TK(d-32|0,H[e+76>>2]-(d>>>0<32)|0,l,0);x=rg(m);g=0;d=0;while(1){j:{if(g>>>0>x>>>0){break j}d=Ol(a,g,e+28|0);n=H[e+28>>2];if(!n){break j}t=g<<2;H[t+H[a+32>>2]>>2]=s;c=g<<12;f=c|4062;y=f>>>0<m>>>0?f:m;k=g?c-33|0:1;f=k;c=0;while(1){k:{u=!c&f>>>0>y>>>0|(c|0)!=0;if(u){break k}z=H[a+8>>2];v=SK(k-1|0,0,l,0)+32|0;d=Ja;d=Jc(z,j,l,v,v>>>0<32?d+1|0:d);if(d){break k}if(!Ov(a,e+24|0,e+20|0,r,j)){d=0;break k}d=up(a,f,H[e+24>>2]);if(d){break k}d=H[e+20>>2];if(d){H[a+72>>2]=d;H[a+68>>2]=f;G[a+66>>1]=w;A=H[a+80>>2];h=H[a+76>>2]}d=f+1|0;c=d?c:c+1|0;f=d;k=k+1|0;d=0;continue}break}H[H[a+32>>2]+t>>2]=n;c=g?0:136;Ya(c+n|0,c+s|0,32768-c|0);if(!u){break j}g=g+1|0;continue}break}Wa(j)}if(d){break g}}H[a+80>>2]=A;H[a+76>>2]=h;tp(a);d=0;c=pi(a);H[c>>2]=0;H[c+32>>2]=H[a+68>>2];H[c+4>>2]=0;h=1;while(1){if((h|0)!=5){f=h+3|0;d=sg(a,f,1);if((d|0)!=5){if(d){break g}l:{m:{if((h|0)!=1){break m}g=H[a+68>>2];if(!g){break m}H[c+8>>2]=g;break l}H[(c+(h<<2)|0)+4>>2]=-1}Qe(a,f,1)}h=h+1|0;continue}break}if(!H[a+72>>2]){break g}c=H[a+68>>2];H[e+4>>2]=H[a+108>>2];H[e>>2]=c;Fc(283,6484,e)}Qe(a,p,q)}Ga=e+80|0;c=d;H[b>>2]=1;d=0}if(!o){F[a+44|0]=0;Qe(a,0,1)}if(!d){break d}}if(H[a+52>>2]==3007e3){break d}c=xe(64116)}if(!I[a+50|0]){break a}if(c){break c}c=0;break b}rp(a,0);F[a+50|0]=0;c=(c|0)==522?-1:c}F[a+43|0]=0}Ga=i+16|0;return c}function bg(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=Ga-16|0;Ga=r;q=e?I[e+1|0]:q;n=H[f+4>>2];o=I[f|0];i=H[a+8>>2];l=d?H[d>>2]?d:0:l;if(!(q|l)){Lk(i,H[b+12>>2],g)}k=H[H[b+28>>2]>>2];j=H[f+12>>2];a:{b:{if(!j){if(l){p=H[H[l>>2]>>2]+((I[l+32|0]^-1)&1)|0;d=p+H[a+44>>2]|0}else{d=H[a+44>>2]}j=d+1|0;H[f+12>>2]=j;m=a+44|0;break b}d=H[a+44>>2];if((d|0)>=(j+k|0)){break a}m=a+44|0}H[m>>2]=d+k}H[f+16>>2]=k;d=0;c:{d:{if((c|0)>=0){m=(k|0)>0?k:0;while(1){if((d|0)==(m|0)){break d}Xa(i,94,c,d,d+j|0);d=d+1|0;continue}}m=1;e:{if(o-9>>>0<2){break e}if((o|0)==3){break d}if((o|0)==13){break e}m=0}f:{if(!(!l|q|((o|0)==12|(o|0)==14))){d=H[l+4>>2];while(1){c=H[l>>2];if(H[c>>2]>(d|0)){c=J[(c+(d<<4)|0)+20>>1];if(c){d=d+1|0;G[(H[b+28>>2]+(c<<4)|0)+4>>1]=d-H[l+4>>2]}else{d=d+1|0}continue}break}s=H[b+28>>2];c=H[s>>2];u=(c|0)>0?c:0;c=j;d=0;while(1){if((d|0)!=(u|0)){t=J[((d<<4)+s|0)+20>>1];c=t?0:c;d=d+1|0;k=k-((t|0)!=0)|0;continue}break}m=m|12;break f}c=j}F[r+12|0]=m;H[r+8>>2]=j;if(!(!H[b+8>>2]|!(m&8)|(p|0)<=0)){H[l+36>>2]=r+8;c=0;break c}EB(a,b,r+8|0);break c}c=j}g:{if(!q){break g}d=I[e+1|0];m=DB(a,d,H[e+4>>2],g,H[b+28>>2],j);Wn(a,d,m,H[e+8>>2]);if(l){break g}Lk(i,H[b+12>>2],g)}h:{i:{j:{k:{l:{switch(o-1|0){case 0:c=Db(a);Xa(i,97,j,k,c);ob(i,138,n,c,j,k);xb(a,c);break k;case 1:Xa(i,140,n,j,k);break k;case 4:case 7:case 11:case 13:e=p+1|0;d=Cc(a,e);f=d+p|0;Xa(i,97,j,k,f);if((o|0)==5){g=n+1|0;ob(i,28,g,H[i+108>>2]+4|0,d,0);ob(i,138,g,d,j,k)}m:{if(l){CB(a,l,b,f,c,1,p);break m}c=Db(a);Va(i,127,n,c);Xa(i,128,n,d,c);pb(i,8);xb(a,c)}md(a,d,e);break k;case 14:if(l){break i}c=H[f+8>>2];a=Db(a);Va(i,50,j,h);d=c>>>31|0;Xa(i,97,d+j|0,k-d|0,a);if((c|0)<0){Xa(i,128,n,a,j);break j}ob(i,138,n,a,j,c);break j;case 10:if(l){break i}c=Db(a);kb(i,97,j,k,c,H[f+20>>2],k);ob(i,138,n,c,j,k);xb(a,c);break j;case 2:Va(i,71,1,n);break k;case 9:if(l){break i}break j;case 8:case 12:if(l){break i}if((o|0)==13){db(i,11,H[f+4>>2]);break j}Va(i,84,j,k);break j;case 5:case 6:break l;default:break k}}m=H[f+24>>2];c=H[m>>2];g=Db(a);p=c+2|0;f=Cc(a,p);q=f+c|0;d=q+1|0;e=0;o=(o|0)!=6;if(!o){e=ob(i,28,n+1|0,0,j,k)}Xa(i,97,j,k,d);if(!o){Va(i,138,n+1|0,d);pb(i,16)}d=0;c=(c|0)>0?c:0;j=j-1|0;while(1){if((c|0)!=(d|0)){Va(i,81,j+J[(m+(d<<4)|0)+20>>1]|0,d+f|0);d=d+1|0;continue}break}Va(i,126,n,q);Xa(i,97,f,p,g);ob(i,138,n,g,f,p);if(e){bb(i,e)}xb(a,g);md(a,f,p)}if(l){break h}}a=H[b+8>>2];if(!a){break h}Va(i,60,a,h);break h}CB(a,l,b,j,c,k,p)}Ga=r+16|0}function xi(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=Ga-16|0;Ga=e;H[e+8>>2]=b;H[e+12>>2]=a;l=I[c+3|0];h=I[c|0];k=I[c+1|0];a:{b:{c:{d:while(1){e:{f:{g:{a=H[e+12>>2];b=F[a|0];h:{if((b|0)>=0){H[e+12>>2]=a+1;a=b&255;break h}a=Xd(e+12|0)}if(a){if((a|0)==(h|0)){while(1){a=H[e+12>>2];b=F[a|0];i:{if((b|0)>=0){H[e+12>>2]=a+1;a=b&255;break i}a=Xd(e+12|0)}if(!((a|0)==(k|0)&(k|0)!=0?0:(h|0)!=(a|0))){if((a|0)!=(k|0)){continue}if(Xd(e+8|0)){continue}break b}break}if(!a){g=0;break a}if((a|0)==(d|0)){if(I[c+2|0]){b=H[e+12>>2]-1|0;f=H[e+8>>2];while(1){if(!I[f|0]){g=2;break c}g=xi(b,f,c,d);if((g|0)!=1){break c}h=I[f|0];a=f+1|0;f=a;if(h>>>0<192){continue}while(1){h=I[a|0];f=a;a=a+1|0;if((h&192)==128){continue}break}continue}}a=Xd(e+12|0);if(!a){break b}}if(a>>>0<129){break e}f=H[e+12>>2];while(1){b=H[e+8>>2];h=F[b|0];j:{if((h|0)>=0){H[e+8>>2]=b+1;b=h&255;break j}b=Xd(e+8|0)}if(!b){break b}if((a|0)!=(b|0)){continue}g=xi(f,H[e+8>>2],c,d);if((g|0)==1){continue}break}break a}if((a|0)==(d|0)){k:{if(!I[c+2|0]){a=Xd(e+12|0);if(a){break k}g=1;break a}g=1;j=Xd(e+8|0);if(!j){break a}a=0;m=0;i=0;f=Xd(e+12|0);if((f|0)==94){m=1;f=Xd(e+12|0)}if((f|0)!=93){break g}i=(j|0)==93;b=0;break f}o=H[e+12>>2]}b=H[e+8>>2];f=F[b|0];l:{if((f|0)>=0){H[e+8>>2]=b+1;b=f&255;break l}b=Xd(e+8|0)}if((b|0)==(a|0)|!(!l|(I[(a&255)+29632|0]!=I[(b&255)+29632|0]|a>>>0>127))&b>>>0<128){continue}g=1;if(H[e+12>>2]==(o|0)|(a|0)!=(k|0)){break a}if(b){continue}break a}g=I[H[e+8>>2]]!=0;break a}b=1}while(1){m:{n:{o:{p:{if(!b){a=0;break p}b=a;a=f;q:{if((a|0)!=45){if((a|0)==93){break n}if(!a){break a}break q}n=I[H[e+12>>2]];if((n|0)==93|!n){break q}if(b){break o}}i=(a|0)==(j|0)?1:i}f=Xd(e+12|0);b=1;continue}i=(p=i,q=Xd(e+12|0)>>>0<j>>>0?i:1,r=b>>>0>j>>>0,r?p:q);break m}if((i|0)!=(m|0)){continue d}break a}b=0;continue}}break}r:{if(l){F[e+7|0]=0;F[e+5|0]=(I[a+30016|0]^-1|223)&a;a=I[a+29632|0];break r}F[e+5|0]=a;a=0}F[e+6|0]=a;i=H[e+12>>2];a=H[e+8>>2];while(1){h=Ga-32|0;Ga=h;b=e+5|0;f=F[b|0];s:{if(!(I[b+1|0]?f:0)){b=Yx(a,f);break s}$a(h,0,32);f=I[b|0];if(f){while(1){g=h+(f>>>3&28)|0;H[g>>2]=H[g>>2]|1<<f;f=I[b+1|0];b=b+1|0;if(f){continue}break}}b=a;f=I[a|0];if(!f){break s}while(1){if(H[h+(f>>>3&28)>>2]>>>f&1){break s}f=I[b+1|0];b=b+1|0;if(f){continue}break}}Ga=h+32|0;a=(b-a|0)+a|0;if(!I[a|0]){H[e+8>>2]=a;break b}a=a+1|0;g=xi(i,a,c,d);if((g|0)==1){continue}break}H[e+8>>2]=a;break a}H[e+8>>2]=f;break a}g=2}Ga=e+16|0;return g}function zh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;q=Ga-16|0;Ga=q;r=a+252|0;f=H[a+252>>2];a:{b:{if(f){k=Ga-16|0;Ga=k;c:{if(!f){a=kd(97585);break c}p=H[f+20>>2];a=H[f+16>>2];d:{if(!a){a=4;break d}H[a+36>>2]=0;a=ox(f,b,c,k+12|0);if(!a){break d}b=H[k+12>>2];H[k>>2]=b;te(p,a,b?8310:0,k);_a(p,b)}a=nd(p,a)}Ga=k+16|0;break b}e:{f=H[a+248>>2];if(f){break e}H[q>>2]=H[a+20>>2];f=Hb(3730,q);H[a+248>>2]=f;if(f){break e}a=7;break a}h=H[a+12>>2];k=H[a+16>>2];p=f;g=Ga-336|0;Ga=g;H[g+332>>2]=0;H[r>>2]=0;i=yb(h,32,0);f:{g:{h:{i:{j:while(1){k:{un(g+56|0,h);if(!i){break k}_a(h,H[g+332>>2]);H[g+332>>2]=0;Se(h);l:{j=Sf(g+56|0,0,p,k);if(j){a=I[j+43|0];f=7830;m:{if((a|0)==1){break m}f=8010;if(I[j+28|0]&128){break m}if((a|0)!=2){break l}f=7084}H[g+16>>2]=p;Za(g+56|0,f,g+16|0)}l=1;if(!H[g+60>>2]){break h}_a(h,0);H[g+332>>2]=H[g+60>>2];H[g+60>>2]=0;break h}H[i+28>>2]=j;t=i,u=H[H[h+16>>2]+(Lb(h,H[j+60>>2])<<4)>>2],H[t+24>>2]=u;a=0;m=G[j+34>>1];f=(m|0)>0?m:0;while(1){n:{if((a|0)!=(f|0)){if(hb(H[H[j+4>>2]+N(a,12)>>2],11319)){break n}f=a}o:{p:{if((f|0)==(m|0)){_a(h,0);H[g+32>>2]=11319;t=g,u=tb(h,28615,g+32|0),H[t+332>>2]=u;break p}break o}l=1;break i}n=qx(g+56|0);H[i+16>>2]=n;q:{r:{if(n){a=H[j+60>>2];m=Lb(h,a);ob(n,2,m,0,H[a>>2],H[a+4>>2]);pb(n,1);o=zg(n,6,29984);ze(n,m);if(I[h+87|0]){break r}H[o+4>>2]=m;a=H[j+20>>2];H[o+12>>2]=0;H[o+8>>2]=a;le(n,2,H[j>>2],0);if(I[h+87|0]){break r}a=H[j+20>>2];H[o+32>>2]=m;H[o+28>>2]=a;F[o+21|0]=253;H[o+36>>2]=G[j+34>>1]+1;H[o+68>>2]=G[j+34>>1];G[g+260>>1]=0;H[g+96>>2]=1;H[g+100>>2]=1;px(n,g+56|0)}a=I[h+87|0];H[i+20>>2]=h;G[i+8>>1]=f;if(a){break q}l=ox(i,b,c,g+332|0);if((l|0)!=17|s>>>0>48){break q}s=s+1|0;Zi(g+56|0);l=17;continue j}H[i+20>>2]=h;G[i+8>>1]=f}if(l){break i}break k}a=a+1|0;continue}}break}l=0;if(I[h+87|0]){break i}H[r>>2]=i;break f}if(!i){break g}}a=H[i+16>>2];if(!a){break g}yf(a)}_a(h,i)}a=H[g+332>>2];H[g>>2]=a;te(h,l,a?8310:0,g);_a(h,a);Zi(g+56|0);a=nd(h,l);Ga=g+336|0}if(!a){a=0;b=H[r>>2];if(!(!b|!H[b+16>>2])){a=H[b>>2]}b=a;H[e>>2]=a;if(!d){a=0;break a}f=Ub(b+20|0);s:{if(!f){f=0;a=7;break s}a=lx(H[r>>2],f,b,0);b=b+f|0;F[b+16|0]=0;F[b+17|0]=0;F[b+18|0]=0;F[b+19|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0;F[b+12|0]=0;F[b+13|0]=0;F[b+14|0]=0;F[b+15|0]=0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;if(!a){a=0;break s}Wa(f);f=0}H[d>>2]=f;break a}a=(a|0)==1?267:a}Ga=q+16|0;return a}function $G(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;i=Ga-48|0;Ga=i;d=1;g=H[a>>2];a:{if(H[g+56>>2]){break a}l=b&65535;if(l){m=H[e>>2];d=1}else{d=0}if(b&65536){h=H[(d<<2)+e>>2];d=d+1|0}if(b&131072){n=H[(d<<2)+e>>2];d=d+1|0}o=b&262144?H[(d<<2)+e>>2]:0;Xq(a);t=a,u=mz(n,0,-2147483648),H[t+72>>2]=u;H[a+76>>2]=Ja;t=a,u=mz(o,-1,2147483647),H[t+80>>2]=u;H[a+84>>2]=Ja;c=c?I[c|0]==68:I[g+239|0];G[a+4>>1]=b;F[a+52|0]=c;if(l>>>0>=2){k=cb(m);if(!k){d=7;if((gb(m)|0)!=5){break a}}d=0;H[a+20>>2]=0;if(h){d=ac(h);H[a+20>>2]=d}e=H[g+36>>2];q=H[g+28>>2];r=I[g+236|0];s=H[g+24>>2];p=g+8|0;j=Ga-32|0;Ga=j;h=a+16|0;c=Ga-48|0;Ga=c;H[c+40>>2]=0;H[c+32>>2]=0;H[c+36>>2]=0;H[c+28>>2]=l-2;H[c+24>>2]=s;H[c+16>>2]=q;H[c+12>>2]=d;H[c+8>>2]=e;H[c+20>>2]=r;b:{if(!k){H[h>>2]=0;break b}d=Zy(c+8|0,k,ub(k),h,c+44|0);f=d?d:H[c+40>>2]?1:d}Ga=c+48|0;e=f;c:{d:{if(f){break d}d=0;if(!H[h>>2]){break c}e=Hm(h,12);if(e){break d}e=bz(H[h>>2],12);if(!e){break c}}of(H[h>>2]);H[h>>2]=0;d=1;if((e|0)!=1){d=e;if((d|0)!=18){break c}H[j>>2]=12;de(p,24714,j);d=1;break c}H[j+16>>2]=k;de(p,17660,j+16|0)}Ga=j+32|0;if(d){break a}f=Ga-32|0;Ga=f;c=H[a>>2];H[f+28>>2]=0;H[f+24>>2]=0;H[f+20>>2]=0;az(a,H[a+16>>2],f+24|0,f+20|0,f+28|0);e:{if(H[f+28>>2]){break e}d=!I[c+236|0];c=H[f+24>>2];if(d|(c|0)<2){break e}d=Ib(N(c,24)+(H[f+20>>2]<<3)|0,0);if(!d){H[f+28>>2]=7;break e}c=H[f+24>>2];H[f+16>>2]=d;h=d+N(c,24)|0;H[f+12>>2]=h;e=0;$y(a,0,H[a+16>>2],f+16|0,f+12|0,f+28|0);c=(H[f+16>>2]-d|0)/24|0;H[f+24>>2]=c;H[f+20>>2]=H[f+12>>2]-h>>2;f:{if(H[f+28>>2]){break f}c=_y(a,0,d,c);H[f+28>>2]=c;while(1){if(H[f+20>>2]<=(e|0)|c){break f}c=_y(a,H[h+(e<<2)>>2],d,H[f+24>>2]);H[f+28>>2]=c;e=e+1|0;continue}}Wa(d)}Rq(a,H[a+16>>2],f+28|0);d=H[f+28>>2];Ga=f+32|0;tf(g);if(d){break a}H[a+32>>2]=0;H[a+36>>2]=0;H[a+40>>2]=H[a+44>>2]}g:{h:{i:{switch(b&65535){case 0:b=H[g+224>>2];j:{if(n|o){c=H[a+72>>2];d=H[a+76>>2];e=I[a+52|0];f=H[a+84>>2];H[i+16>>2]=H[a+80>>2];H[i+20>>2]=f;H[i+24>>2]=e?19681:20095;H[i+8>>2]=c;H[i+12>>2]=d;H[i>>2]=b;b=Hb(6615,i);break j}c=I[a+52|0];H[i+32>>2]=b;H[i+36>>2]=c?19681:20095;b=Hb(6587,i+32|0)}if(!b){d=7;break a}H[g+56>>2]=H[g+56>>2]+1;d=Sp(H[g+12>>2],b,1,a+12|0);H[g+56>>2]=H[g+56>>2]-1;Wa(b);break h;case 1:break i;default:break g}}d=lz(a);if(d){break a}d=Yp(H[a+12>>2],1,m)}if(d){break a}}d=kz(a)}Ga=i+48|0;return d|0}function eJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;b=Ga-336|0;Ga=b;g=Gc(a);l=cb(H[c>>2]);j=cb(H[c+12>>2]);i=cb(H[c+16>>2]);f=ac(H[c+20>>2]);m=cb(H[c+24>>2]);n=ac(H[c+28>>2]);d=ac(H[c+32>>2]);a:{if(!l|!i|(!m|(f|0)<0)){break a}o=H[g+360>>2];Se(g);e=Dc(g,i,j);if(!e|(f|0)>=G[e+34>>1]){break a}k=H[H[e+4>>2]+N(f,12)>>2];H[b+328>>2]=0;H[b+320>>2]=0;H[b+324>>2]=0;H[b+312>>2]=0;H[b+316>>2]=0;H[b+320>>2]=(f|0)==G[e+32>>1]?-1:f;H[g+360>>2]=0;h=b+40|0;d=Fk(h,j,g,l,d);H[b+28>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+16>>2]=88;H[b+12>>2]=89;H[b+324>>2]=e;H[b+32>>2]=b+312;H[b+8>>2]=h;b:{if(d){break b}c:{d:{d=H[b+276>>2];if(d){e:{switch(I[d+43|0]){case 2:e=H[d+44>>2];H[e+4>>2]=H[e+4>>2]&-2097153;H[b+52>>2]=0;ve(b+40|0,e,0);d=I[g+87|0]?7:H[b+52>>2];if(d){break b}lc(b+8|0,e);break c;case 0:break e;default:break c}}j=Qb(i,H[d>>2]);H[b+324>>2]=d;if(j){break d}if((f|0)<G[d+34>>1]){bd(b+40|0,b+312|0,H[H[d+4>>2]+N(f,12)>>2])}if(H[b+320>>2]<0){bd(b+40|0,b+312|0,H[b+276>>2]+32|0)}gc(b+8|0,H[H[b+276>>2]+16>>2]);e=H[b+276>>2]+8|0;while(1){d=H[e>>2];if(d){gc(b+8|0,H[d+40>>2]);e=d+20|0;continue}break}e=b+280|0;while(1){d=H[e>>2];if(d){gc(b+8|0,H[d+40>>2]);e=d+20|0;continue}else{e=0;while(1){d=H[b+276>>2];if(G[d+34>>1]<=(e|0)){break d}Kb(b+8|0,cd(d,H[d+4>>2]+N(e,12)|0));e=e+1|0;continue}}}}d=H[b+280>>2];if(d){e=b+8|0;gc(e,H[d+40>>2]);Kb(e,H[H[b+280>>2]+36>>2]);break c}d=_m(b+40|0);if(d){break b}d=H[b+284>>2]+28|0;while(1){d=H[d>>2];if(d){f=H[d+12>>2];f:{if(!f){break f}if((Sf(b+40|0,0,f,j)|0)!=(e|0)){break f}f=H[d+32>>2];if(f){xA(b+40|0,b+312|0,H[f+8>>2],k)}f=b+40|0;i=b+312|0;wA(f,i,H[d+28>>2],k);xA(f,i,H[d+24>>2],k)}d=d+40|0;continue}break}if((e|0)==H[b+160>>2]){wA(b+40|0,b+312|0,H[H[b+284>>2]+16>>2],k)}ur(b+8|0,H[b+284>>2]);break c}e=d+48|0;while(1){d=H[e>>2];if(!d){break c}e=0;while(1){if((e|0)<H[d+20>>2]){g:{if(j){break g}h=(d+(e<<3)|0)+36|0;if((f|0)!=H[h>>2]){break g}bd(b+40|0,b+312|0,h)}h:{if(Qb(H[d+8>>2],i)){break h}h=H[(d+(e<<3)|0)+40>>2];if(Qb(h,k)){break h}bd(b+40|0,b+312|0,h)}e=e+1|0;continue}break}e=d+4|0;continue}}d=tr(a,b+312|0,l,m,n)}i:{j:{k:{switch(d|0){case 0:break i;case 1:break k;default:break j}}if(!Jf(g)){break j}ae(a,H[c>>2]);break i}if(H[b+44>>2]){sr(a,29357,H[c+4>>2],H[c+8>>2],b+40|0);break i}ne(a,d)}Ek(b+40|0);Zm(g,H[b+312>>2]);H[g+360>>2]=o}Ga=b+336|0}function Hi(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=Ga-48|0;Ga=g;H[g+44>>2]=H[a>>2];j=H[e>>2];H[g+40>>2]=j;h=H[f>>2];H[g+36>>2]=h;H[g+32>>2]=0;H[g+28>>2]=0;if(I[j|0]==1){i=j+1|0;j=F[j+1|0];a:{if((j|0)<0){j=uc(i,g+32|0);break a}H[g+32>>2]=j&255;j=1}H[g+40>>2]=j+i}if(I[h|0]==1){j=1;i=h+1|0;h=F[h+1|0];b:{if((h|0)<0){j=uc(i,g+28|0);break b}H[g+28>>2]=h&255}H[g+36>>2]=i+j}j=b;q=b>>31;r=(c|0)!=0;while(1){c:{h=H[g+32>>2];b=H[g+28>>2];if((h|0)==(b|0)){b=H[g+44>>2];H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=0;H[g+12>>2]=0;H[g>>2]=0;H[g+4>>2]=0;if(h){F[b|0]=1;i=b+1|0;s=g,t=pc(i,h,h>>31)+i|0,H[s+44>>2]=t}Ii(g+40|0,g+8|0);n=H[g+8>>2];h=n;o=h-2|0;k=H[g+12>>2];h=k-(h>>>0<2)|0;i=h;H[g+8>>2]=o;H[g+12>>2]=h;Ii(g+36|0,g);p=H[g>>2];h=p;l=h-2|0;m=H[g+4>>2];h=m-(h>>>0<2)|0;H[g>>2]=l;H[g+4>>2]=h;if(n>>>0<2&(k|0)<=0|(k|0)<0|(p>>>0<2&(m|0)<=0|(m|0)<0)){break c}while(1){k=i+q|0;m=j+o|0;k=m>>>0<j>>>0?k+1|0:k;d:{while(1){if(!((h|0)<=(i|0)&l>>>0<=o>>>0|(h|0)<(i|0)|d|(l>>>0>m>>>0&(h|0)>=(k|0)|(h|0)>(k|0))?(l|0)!=(m|0)|(h|0)!=(k|0):0)){b=c?i:h;n=(c?o:l)+2|0;b=n>>>0<2?b+1|0:b;Py(g+44|0,g+16|0,n,b);b=H[g+16>>2];n=H[g+20>>2]-(b>>>0<2)|0;H[g+16>>2]=b-2;H[g+20>>2]=n;b=0}if(!((r|(l>>>0>m>>>0&(h|0)>=(k|0)|(h|0)>(k|0)))&(l>>>0>o>>>0&(h|0)>=(i|0)|(h|0)>(i|0)))){if(I[H[g+36>>2]]<2){break d}Ii(g+36|0,g);l=H[g>>2];h=H[g+4>>2]-(l>>>0<2)|0;l=l-2|0;H[g>>2]=l;H[g+4>>2]=h;continue}break}if(I[H[g+40>>2]]<2){break d}Ii(g+40|0,g+8|0);k=H[g+8>>2];i=H[g+12>>2]-(k>>>0<2)|0;o=k-2|0;H[g+8>>2]=o;H[g+12>>2]=i;continue}break}if(b){H[g+44>>2]=b}Wf(0,g+40|0);Wf(0,g+36|0);b=H[g+40>>2];if(!I[b|0]){break c}h=H[g+36>>2];if(!I[h|0]){break c}i=b+1|0;b=F[b+1|0];e:{if((b|0)<0){b=uc(i,g+32|0);break e}H[g+32>>2]=b&255;b=1}H[g+40>>2]=b+i;b=h+1|0;h=F[h+1|0];f:{if((h|0)<0){h=uc(b,g+28|0);break f}H[g+28>>2]=h&255;h=1}H[g+36>>2]=h+b;continue}if((b|0)>(h|0)){Wf(0,g+40|0);b=H[g+40>>2];if(!I[b|0]){break c}h=b+1|0;b=F[b+1|0];g:{if((b|0)<0){b=uc(h,g+32|0);break g}H[g+32>>2]=b&255;b=1}H[g+40>>2]=b+h;continue}Wf(0,g+36|0);b=H[g+36>>2];if(!I[b|0]){break c}h=b+1|0;b=F[b+1|0];h:{if((b|0)<0){b=uc(h,g+28|0);break h}H[g+28>>2]=b&255;b=1}H[g+36>>2]=b+h;continue}break}j=0;Fe(0,g+36|0);Fe(0,g+40|0);H[e>>2]=H[g+40>>2];H[f>>2]=H[g+36>>2];Ga=g+48|0;b=H[g+44>>2];if((b|0)!=H[a>>2]){F[b|0]=0;H[a>>2]=b+1;j=1}return j}function tE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;m=Ga-128|0;Ga=m;n=tw();f=H[a+36>>2];a:{if(!f){f=0;j=Ga-128|0;Ga=j;h=Ib(16,0);b:{if(!h){f=7;break b}H[h>>2]=0;H[h+4>>2]=0;H[h+8>>2]=0;H[h+12>>2]=0;c:{o=H[a+8>>2];i=H[o+40>>2];d:{if(i){break d}k=H[a+32>>2];f=1802;if(Ka[H[16184]](H[a+12>>2],j+16|0)|0){break c}p=ub(k);g=p+74|0;i=Ib(g,0);if(!i){f=7;break c}f=0;g=$a(i,0,g);l=g+68|0;H[g+8>>2]=l;H[j>>2]=k;k=Vd(p+6|0,l,10882,j);H[g+12>>2]=-1;l=H[a+8>>2];H[l+40>>2]=g;H[g>>2]=l;if(I[64004]){H[g+4>>2]=8}if(I[o+29|0]){break d}e:{if(!Zl(H[a+32>>2],10869,0)){f=fi(k,131138,H[j+28>>2]&511);H[g+12>>2]=f;break e}f=H[g+12>>2]}if((f|0)<0){f=fi(k,131072,H[j+28>>2]&511);H[g+12>>2]=f;if((f|0)<0){f=Td(xe(40140),10706,k,40140);break c}F[g+22|0]=1}Yu(f,H[j+36>>2],H[j+40>>2]);f=sw(a,g);if((f|0)==1288){break d}if(f){break c}}H[h>>2]=i;H[i+28>>2]=H[i+28>>2]+1;H[a+36>>2]=h;H[h+4>>2]=H[i+32>>2];H[i+32>>2]=h;break b}qw(a);Wa(h)}Ga=j+128|0;if(f){break a}f=H[a+36>>2]}f=H[f>>2];f:{if(I[f+23|0]){g=sw(a,f);if(g){break f}F[f+23|0]=0}g=0;a=b+n|0;j=a-((a|0)%(n|0)|0)|0;if((j|0)<=J[f+20>>1]){break f}H[f+16>>2]=c;g:{h:{a=H[f+12>>2];if((a|0)<0){break h}g=4874;if(Ka[H[16184]](a,m+16|0)|0){break f}h=H[m+60>>2];a=N(c,j);i=a>>31;k=H[m+56>>2];if((h|0)>=(i|0)&a>>>0<=k>>>0|(h|0)>(i|0)){break h}if(!d){g=0;break f}a=(a|0)/4096|0;d=TK(k,h,4096,0);a=(a|0)>(d|0)?a:d;i=a;k=a>>31;a=d;d=a>>31;h=a;a=d;while(1){if((h|0)==(i|0)&(a|0)==(k|0)){break h}d=h<<12|4095;if((rw(H[f+12>>2],d,d>>31,29357,1,m+12|0)|0)!=1){break g}d=h+1|0;a=d?a:a+1|0;h=d;continue}}a=Ae(H[f+24>>2],j<<2);if(!a){g=3082;break f}H[f+24>>2]=a;g=0;i=(n|0)>0?n:0;h=N(c,n);k=h>>31;a=J[f+20>>1];l=c>>31;while(1){if((j|0)<=(a&65535)){break f}d=H[f+12>>2];i:{if((d|0)>=0){d=(r=0,s=h,t=I[f+22|0]?1:3,u=1,v=d,w=SK(a&65535,0,c,l),x=Ja,q=H[16235],Ka[q](r|0,s|0,t|0,u|0,v|0,w|0,x|0)|0);if((d|0)!=-1){break i}g=5386;Td(5386,9381,H[f+8>>2],40311);break f}d=Ib(h,k);if(!d){g=7;break f}$a(d,0,h)}a=0;while(1){if((a|0)!=(i|0)){H[H[f+24>>2]+(J[f+20>>1]+a<<2)>>2]=N(a,c)+d;a=a+1|0;continue}break}a=J[f+20>>1]+n|0;G[f+20>>1]=a;continue}}Td(4874,12354,H[f+8>>2],40284)}H[e>>2]=J[f+20>>1]>(b|0)?H[H[f+24>>2]+(b<<2)>>2]:0;f=I[f+22|0]?g?g:8:g}Ga=m+128|0;return f|0}function ep(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;k=Ga-16|0;Ga=k;l=H[b+4>>2];a:{if(l>>>0<=2){f=ab(70647);break a}g=H[b+72>>2];m=Ga-16|0;Ga=m;j=H[a>>2];b:{if(I[j+12|0]){h=_b(g);if(h){break b}}h=J[g+28>>1];if(h&2){h=Um(g);if(h){break b}h=J[g+28>>1]}if(!(!(h&8)|f)){i=H[g+24>>2]}G[g+28>>1]=h&65527;f=ni(j,e);c:{if(!f){break c}if(G[f+30>>1]>=2){zf(f);h=ab(61057);break b}G[g+28>>1]=J[g+28>>1]|J[f+28>>1]&8;if(I[j+12|0]){Il(f,H[j+28>>2]+1|0);break c}mp(f)}h=H[g+24>>2];Il(g,e);Ml(g);if(!(!I[j+12|0]|!f)){Il(f,h);zf(f)}if(i){h=sd(j,i,m+12|0,0);if(h){if(K[j+32>>2]<i>>>0){break b}n=H[j+224>>2];d:{g=H[j+60>>2];if(!g){break d}f=i-1|0;while(1){i=H[g+8>>2];if(i){j=i;i=(f>>>0)/(i>>>0)|0;f=f-N(j,i)|0;g=H[((i<<2)+g|0)+12>>2];if(g){continue}break d}break}if(K[g>>2]<=4e3){g=(f>>>3|0)+g|0;i=I[g+12|0];r=g,s=YK(-2,f&7)&i,F[r+12|0]=s;break d}i=g+12|0;j=Ya(n,i,500);n=$a(i,0,500);H[g+4>>2]=0;q=f+1|0;i=0;while(1){if((i|0)==125){break d}o=j+(i<<2)|0;f=H[o>>2];if(!(!f|(f|0)==(q|0))){H[g+4>>2]=H[g+4>>2]+1;f=(f-1>>>0)%125|0;while(1){p=n+(f<<2)|0;if(H[p>>2]){f=f+1|0;f=f>>>0>124?0:f;continue}break}H[p>>2]=H[o>>2]}i=i+1|0;continue}}break b}f=H[m+12>>2];G[f+28>>1]=J[f+28>>1]|8;Ml(f);zf(H[m+12>>2])}h=0}Ga=m+16|0;f=h;H[k+8>>2]=f;if(f){break a}H[b+4>>2]=e;e:{if((c&251)==1){f=kv(b);if(!f){break e}break a}b=eb(H[b+56>>2]);if(!b){break e}Jd(a,b,4,e,k+8|0);f=H[k+8>>2];if(f){break a}}f=0;if((c|0)==1){break a}f=xd(a,d,k+12|0,0);if(f){break a}h=H[k+12>>2];f=_b(H[h+72>>2]);if(f){Gb(h);break a}g=Ga-32|0;Ga=g;f:{g:{if((c|0)==4){f=H[h+56>>2];if((eb(f)|0)!=(l|0)){b=ab(70575);break f}break g}if(!I[h|0]){b=si(h);if(b){break f}}i=J[h+24>>1];b=0;j=(c|0)!=3;h:{while(1){if((b|0)==(i|0)){break h}f=H[h+64>>2]+(b<<1)|0;f=H[h+56>>2]+(J[h+26>>1]&(I[f|0]<<8|I[f+1|0]))|0;i:{j:{if(!j){Ka[H[h+80>>2]](h,f,g+8|0);if(K[g+20>>2]<=J[g+24>>1]){break j}f=J[g+26>>1]+f|0;if(f>>>0>H[h+56>>2]+H[H[h+52>>2]+40>>2]>>>0){b=ab(70594);break f}f=f-4|0;if((eb(f)|0)!=(l|0)){break j}break g}if((eb(f)|0)==(l|0)){break i}}b=b+1|0;continue}break}break g}k:{if((c|0)==5){f=(I[h+9|0]+H[h+56>>2]|0)+8|0;if((eb(f)|0)==(l|0)){break k}}b=ab(70612);break f}}Cb(f,e);b=0}Ga=g+32|0;f=b;H[k+8>>2]=f;Gb(h);if(f){break a}Jd(a,e,c,d,k+8|0);f=H[k+8>>2]}Ga=k+16|0;return f}function bD(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;a:{if(!(I[H[a>>2]+33|0]&64)){break a}k=Jh(b);while(1){if(!k){break a}b:{if(e){if(!Gr(b,k,e,f)){break b}}h=0;n=0;l=0;r=0;i=Ga-48|0;Ga=i;j=(c|0)!=0;o=I[(j+k|0)+25|0];g=H[a>>2];c:{if(I[g+34|0]&8?(o|0)==7:0){break c}u=(j<<2)+k|0;h=H[u+28>>2];if(h|!o){break c}H[i+44>>2]=0;H[i+40>>2]=0;d:{if(!bj(a,b,k,i+44|0,i+40|0)){s=((c|0)!=0|(o|0)!=10)&(o|0)!=7;q=b+32|0;t=k+36|0;w=H[12232];x=H[12233];y=H[12230];z=H[12231];m=H[i+44>>2];A=o-9|0;h=0;while(1){if(H[k+20>>2]>(h|0)){H[i+32>>2]=y;H[i+36>>2]=z;H[i+24>>2]=w;H[i+28>>2]=x;j=H[i+40>>2];p=H[(j?j+(h<<2)|0:t)>>2];v=i+8|0;Oh(v,H[H[b+4>>2]+N(G[(m?H[m+4>>2]+(h<<1)|0:q)>>1],12)>>2]);j=i+16|0;p=N(p,12);Oh(j,H[p+H[H[k>>2]+4>>2]>>2]);l=he(a,l,mb(a,53,mb(a,141,Ac(g,59,i+32|0,0),Ac(g,59,v,0)),Ac(g,59,j,0)));if(c){n=he(a,n,mb(a,45,mb(a,141,Ac(g,59,i+32|0,0),Ac(g,59,i+8|0,0)),mb(a,141,Ac(g,59,i+24|0,0),Ac(g,59,i+8|0,0))))}if(s){e:{f:{g:{switch(A|0){case 1:j=mb(a,141,Ac(g,59,i+24|0,0),Ac(g,59,i+8|0,0));break e;case 0:break g;default:break f}}j=H[k>>2];p=p+H[j+4>>2]|0;if(I[p+10|0]&96){break f}j=cd(j,p);if(!j){break f}j=nb(g,j,0);break e}j=Ac(g,121,0,0)}r=sb(a,r,j);Wg(a,r,i+16|0,0)}h=h+1|0;continue}break}_a(g,H[i+40>>2]);q=0;s=H[H[k>>2]>>2];m=ib(s);h:{if((o|0)!=7){j=l;l=0;break h}j=Lb(g,H[b+60>>2]);H[i+36>>2]=m;H[i+32>>2]=s;j=H[H[g+16>>2]+(j<<4)>>2];H[i+24>>2]=j;B=i,C=ib(j),H[B+28>>2]=C;h=sc(g,71,15201);if(h){F[h+1|0]=2}j=0;l=Hd(a,sb(a,0,h),Rd(a,0,i+24|0,i+32|0),l,0,0,0,0,0)}G[g+308>>1]=0;H[g+304>>2]=H[g+304>>2]+1;h=yb(g,m+85|0,0);i:{if(!h){break i}t=h+84|0;H[h+48>>2]=t;q=h+36|0;H[h+28>>2]=q;Ya(t,s,m);B=h,C=nb(g,j,1),H[B+56>>2]=C;B=h,C=rc(g,r,1),H[B+60>>2]=C;B=h,C=ge(g,l,1),H[B+44>>2]=C;if(!n){n=0;break i}n=mb(a,19,n,0);B=h,C=nb(g,n,1),H[B+12>>2]=C}m=H[g+304>>2]-1|0;H[g+304>>2]=m;G[g+308>>1]=m?0:J[g+310>>1];fb(g,j);fb(g,n);qb(g,r);hc(g,l);if(I[g+87|0]!=1){break d}zj(g,h)}h=0;break c}l=138;j:{k:{l:{switch(o-7|0){case 0:break j;case 3:break l;default:break k}}if(c){break k}l=128;break j}l=129}H[q+4>>2]=h;F[q|0]=l;g=H[b+60>>2];H[h+24>>2]=g;H[h+20>>2]=g;H[u+28>>2]=h;F[h+8|0]=c?-127:-128}Ga=i+48|0;if(!h){break b}KA(a,h,b,d,2,0)}k=H[k+12>>2];continue}}}function bK(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Ga+-64|0;Ga=e;b=Gc(a);H[e+60>>2]=0;H[e+56>>2]=0;H[e+48>>2]=0;d=cb(H[c>>2]);i=d?d:29357;c=cb(H[c+4>>2]);a:{b:{c:{d:{e:{if(I[b+178|0]&4){c=Qm(17373);H[e+44>>2]=c;if(!c){break a}g=I[b+176|0]<<4;j=H[b+16>>2];d=g+j|0;f=d+4|0;h=H[d+4>>2];if(h){Gg(h)}h=0;H[f>>2]=0;H[(g+j|0)+12>>2]=0;c=Qj(c,49324,b,f,0,256);break e}f:{d=H[b+20>>2];f=H[b+148>>2];g:{if((d|0)<(f+2|0)){f=c?c:29357;c=0;g=(d|0)>0?d:0;while(1){if((c|0)==(g|0)){break f}h=rl(b,c,f);c=c+1|0;if(!h){continue}break}H[e+16>>2]=f;d=tb(b,12716,e+16|0);break g}H[e+32>>2]=f;d=tb(b,16208,e+32|0)}H[e+48>>2]=d;c=0;break d}c=H[b+16>>2];h:{if((c|0)==(b+456|0)){c=Tb(b,48,0);if(!c){break a}d=H[b+16>>2];g=H[d+4>>2];H[c>>2]=H[d>>2];H[c+4>>2]=g;g=H[d+28>>2];H[c+24>>2]=H[d+24>>2];H[c+28>>2]=g;g=H[d+20>>2];H[c+16>>2]=H[d+16>>2];H[c+20>>2]=g;g=H[d+12>>2];H[c+8>>2]=H[d+8>>2];H[c+12>>2]=g;break h}c=Kd(b,c,(d<<4)+16|0,0);if(!c){break a}}H[b+16>>2]=c;d=(H[b+20>>2]<<4)+c|0;H[d>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[e+52>>2]=H[b+60>>2];c=Mw(H[H[b>>2]+16>>2],i,e+52|0,e+44|0,e+60|0,e+56|0);if(c){if((c|0)==7){Mb(b)}b=a;a=H[e+56>>2];fc(b,a,-1);Wa(a);break a}c=H[e+52>>2]|256;H[e+52>>2]=c;h=H[e+60>>2];c=Qj(H[e+44>>2],h,b,d+4|0,0,c);H[b+20>>2]=H[b+20>>2]+1;k=d,l=Xb(b,f),H[k>>2]=l}f=0;F[b+95|0]=0;i:{if(c){if((c|0)==19){k=e,l=tb(b,15580,0),H[k+48>>2]=l;c=1}F[d+8|0]=3;break i}g=Lp(b,H[d+4>>2]);H[d+12>>2]=g;c=7;j:{if(!g){break j}f=1;c=0;if(!I[g+76|0]|I[g+77|0]==I[b+84|0]){break j}f=0;k=e,l=tb(b,12837,0),H[k+48>>2]=l;c=1}Jb(H[d+4>>2]);As(Vc(H[d+4>>2]),I[b+89|0]);Hn(H[d+4>>2],Hn(H[H[b+16>>2]+4>>2],-1));No(H[d+4>>2],H[b+32>>2]&56|3);F[d+8|0]=3;if(!f){break i}c=H[d>>2]?0:7}Jp(h);if(!c){Se(b);F[b+176|0]=0;H[b+24>>2]=H[b+24>>2]&-17;if(I[b+178|0]&4){break a}c=Ip(b,e+48|0);if(!c){break a}}if(!(I[b+178|0]&4)){d=H[b+20>>2]-1|0;f=H[(H[b+16>>2]+(d<<4)|0)+4>>2];if(f){Gg(f);f=H[b+16>>2]+(d<<4)|0;H[f+12>>2]=0;H[f+4>>2]=0}Yf(b);H[b+20>>2]=d;if(!((c|0)!=3082&(c|0)!=7)){Mb(b);_a(b,H[e+48>>2]);d=tb(b,1141,0);H[e+48>>2]=d;break d}d=H[e+48>>2];if(d){break c}H[e>>2]=i;d=tb(b,7620,e);H[e+48>>2]=d;break d}d=H[e+48>>2]}if(!d){break b}}fc(a,d,-1);_a(b,H[e+48>>2])}if(!c){break a}ne(a,c)}Ga=e- -64|0}function Yh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;d=27;e=H[b>>2];a:{if(J[e+8>>1]>13){break a}i=H[b+4>>2];f=J[i+16>>1];h=I[H[e+16>>2]];b:{if(!h){j=1;k=255;break b}if(h&2){break a}j=255;k=1}h=k;F[b+25|0]=j;F[b+24|0]=h;if(f&4){d=H[i+4>>2];H[b+8>>2]=H[i>>2];H[b+12>>2]=d;d=28;break a}if(H[e+20>>2]|f&57){break a}H[b+8>>2]=H[i+8>>2];H[b+16>>2]=H[i+12>>2];d=29}i=d;F[b+23|0]=0;c:{d:{e:{if(I[a|0]){break e}f=H[a+116>>2];if(!I[f+8|0]){break e}e=0;d=F[a+68|0];h=(d|0)>0?d:0;d=1;f:{while(1){if((e|0)==(h|0)){break f}j=e<<1;g=e<<2;e=e+1|0;if(J[(a+j|0)+72>>1]>=J[H[(a+g|0)+120>>2]+24>>1]){continue}break}d=0}if(!d){break e}g:{d=J[a+70>>1];if((d|0)!=(J[f+24>>1]-1|0)){break g}d=Au(a,d,b,i);if((d|0)>0|I[b+23|0]){break g}H[c>>2]=d;return 0}h:{if(F[a+68|0]<=0){break h}if((Au(a,0,b,i)|0)>0|I[b+23|0]){break h}F[a+1|0]=I[a+1|0]&251;if(I[H[a+116>>2]]){break d}return ab(72703)}F[b+23|0]=0}e=ng(a);if(!e){break d}if((e|0)!=16){break c}H[c>>2]=-1;return 0}m=a+32|0;while(1){f=H[a+116>>2];e=J[f+24>>1]-1|0;k=e;h=0;i:{j:{while(1){d=H[f+64>>2]+(e&-2)|0;d=H[f+68>>2]+(J[f+26>>1]&(I[d|0]<<8|I[d+1|0]))|0;g=d+1|0;j=e>>1;e=I[d|0];k:{if(e>>>0<=I[f+11|0]){e=Ka[i|0](e,g,b)|0;break k}l:{g=F[g|0];if((g|0)<0){break l}e=(e<<7&16256)+(g&255)|0;if(e>>>0>J[f+14>>1]){break l}e=Ka[i|0](e,d+2|0,b)|0;break k}Ka[H[f+80>>2]](f,d-I[f+10|0]|0,m);m:{e=H[m>>2];l=e;if((e|0)>=2){g=H[a+20>>2];if((l>>>0)/K[g+40>>2]>>>0<=K[g+48>>2]){break m}}e=ab(72790);break i}d=e;d=d+18|0;e=d>>31;g=xc(d,e);if(!g){e=7;break i}G[a+70>>1]=j;e=em(a,0,l,g);d=g+l|0;F[d+16|0]=0;F[d+17|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[a+1|0]=I[a+1|0]&251;if(e){Wa(g);break i}e=yj(l,g,b);Wa(g)}n:{o:{if((e|0)<0){h=j+1|0;break o}if(!e){break n}k=j-1|0}if((h|0)>(k|0)){break j}e=h+k|0;continue}break}e=0;H[c>>2]=0;G[a+70>>1]=j;if(!I[b+23|0]){break i}e=ab(72822);break i}if(I[f+8|0]){G[a+70>>1]=j;H[c>>2]=e;e=0;break i}d=H[f+56>>2];p:{if(J[f+24>>1]<=(h|0)){d=eb((d+I[f+9|0]|0)+8|0);break p}e=H[f+64>>2]+(h<<1)|0;d=eb(d+(J[f+26>>1]&(I[e|0]<<8|I[e+1|0]))|0)}G[a+70>>1]=h;e=mg(a,d);if(!e){continue}}break}G[a+50>>1]=0}return e}function AI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;d=Ga-288|0;Ga=d;a:{if(!b){break a}i=cb(H[c>>2]);if(!i){break a}if(Si(a,b-1|0,c+4|0,d+240|0)){break a}c=0;fd(d+216|0,0,0,0,H[Gc(a)+120>>2]);b=d+240|0;zd(b);Ri(b);g=H[d+240>>2];b=H[d+244>>2];l=+(g>>>0)+ +(b|0)*4294967296;e=TK(g,b,1e3,0);f=Ja;k=g+1296e5|0;h=k>>>0<1296e5?b+1|0:b;m=UK(TK(k,h,864e5,0),Ja,7,0)+48|0;h=g+432e5|0;b=h>>>0<432e5?b+1|0:b;g=b;k=UK(TK(h,b,864e5,0),Ja,7,0);j=M[d+272>>3];b:{if(P(j)<2147483648){n=~~j;break b}n=-2147483648}j=R(j,59.999);l=l/864e5;o=e-413362496|0;p=f-((e>>>0<413362496)+49|0)|0;q=H[d+256>>2];r=H[d+260>>2];s=H[d+252>>2];t=H[d+264>>2];u=H[d+248>>2];m=m<<24>>24;b=0;while(1){e=I[b+i|0];c:{if((e|0)!=37){if(e){break c}if(b>>>0>c>>>0){Bb(d+216|0,c+i|0,b-c|0)}xr(a,d+216|0);break a}if(b>>>0>c>>>0){Bb(d+216|0,c+i|0,b-c|0)}c=b+2|0;d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{b=b+1|0;e=F[i+b|0];switch(e-100|0){case 0:break e;case 1:case 3:case 4:case 5:case 7:case 8:break f;case 9:break m;case 6:break o;case 2:break q;default:break r}}s:{switch(e-72|0){case 1:case 3:case 4:break f;case 5:break l;case 2:break n;case 0:break p;default:break s}}t:{switch(e-83|0){case 1:case 2:case 3:case 5:break f;case 6:break h;case 0:break j;case 4:break o;default:break t}}switch(e-115|0){case 1:case 2:case 3:break f;case 4:break i;case 0:break k;default:break g}}M[d+16>>3]=j;vb(d+216|0,12030,d+16|0);break c}H[d+32>>2]=r;vb(d+216|0,15736,d+32|0);break c}f=d+168|0;Ya(f,d+240|0,48);H[d+180>>2]=1;H[d+184>>2]=1;F[d+208|0]=0;zd(f);f=H[d+168>>2];f=TK(h-f|0,g-(H[d+172>>2]+(h>>>0<f>>>0)|0)|0,864e5,0);if((e|0)==87){H[d+48>>2]=((f-k|0)+7|0)/7;vb(d+216|0,15736,d+48|0);break c}H[d+64>>2]=f+1;vb(d+216|0,15731,d- -64|0);break c}M[d+80>>3]=l;vb(d+216|0,11928,d+80|0);break c}H[d+96>>2]=s;vb(d+216|0,15736,d+96|0);break c}H[d+112>>2]=t;vb(d+216|0,15736,d+112|0);break c}H[d+128>>2]=o;H[d+132>>2]=p;vb(d+216|0,14185,d+128|0);break c}H[d+144>>2]=n;vb(d+216|0,15736,d+144|0);break c}vi(d+216|0,1,m);break c}H[d+160>>2]=u;vb(d+216|0,15726,d+160|0);break c}if((e|0)==37){break d}}Nf(d+216|0);break a}H[d>>2]=q;vb(d+216|0,15736,d);break c}vi(d+216|0,1,37)}b=b+1|0;continue}}Ga=d+288|0}function wt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Ga-48|0;Ga=j;i=H[a>>2];a:{if(I[i+87|0]){break a}if(kf(a)){break a}if(d){F[i+91|0]=I[i+91|0]+1}e=Df(a,c,b+8|0);b:{if(!d){if(!e){break a}break b}F[i+91|0]=I[i+91|0]-1;if(e){break b}mj(a,H[b+12>>2]);el(a);break a}g=Lb(i,H[e+60>>2]);if(I[e+43|0]==1){if(fg(a,e)){break a}}h=H[H[i+16>>2]+(g<<4)>>2];if(cc(a,9,(g|0)==1?8639:8658,0,h)){break a}c:{if(c){d=(g|0)==1?15:17}else{if(I[e+43|0]==1){d=30;f=H[H[Id(i,e)+4>>2]+4>>2];break c}d=(g|0)==1?13:11}f=0}if(cc(a,d,H[e>>2],f,h)){break a}if(cc(a,9,H[e>>2],0,h)){break a}f=H[e>>2];d:{if(!Fb(f,17563,7)){f=f+7|0;d=0;if(!Fb(f,3288,4)){break d}d=(Fb(f,4146,10)|0)!=0;break d}f=H[e+28>>2];e:{if(f&4096){d=1;if(sn(i)){break e}}d=f>>>15&1}}if(d){H[j+32>>2]=H[e>>2];Za(a,15080,j+32|0);break a}d=I[e+43|0];f:{if(c){if((d|0)==2){break f}H[j+16>>2]=H[e>>2];Za(a,6553,j+16|0);break a}if((d|0)!=2){break f}H[j>>2]=H[e>>2];Za(a,6035,j);break a}if(!zb(a)){break a}Gd(a,1,g);if(!c){Ws(a,g,11149,H[e>>2]);d=0;f=H[a>>2];g:{if(I[e+43|0]|!(I[f+33|0]&64)){break g}h=zb(a);if(!Jh(e)){d=e+48|0;while(1){d=H[d>>2];if(!d){break g}if(!I[d+24|0]){d=d+4|0;if(!(I[f+34|0]&8)){continue}}break}d=jb(a);Va(h,48,1,d)}F[a+151|0]=1;lo(a,aj(f,b,0),0);F[a+151|0]=0;if(!(I[f+34|0]&8)){Va(h,48,0,H[h+108>>2]+2|0);_i(a,787,2,0,-1,4)}if(!d){break g}lb(h,d)}}k=Ga-32|0;Ga=k;h=H[a>>2];d=H[h+16>>2];m=zb(a);Gd(a,1,g);if(I[e+43|0]==1){Sb(m,170)}f=d+(g<<4)|0;d=SB(a,e);while(1){if(d){TC(a,d);d=H[d+32>>2];continue}break}if(I[e+28|0]&8){d=H[f>>2];H[k+20>>2]=H[e>>2];H[k+16>>2]=d;nc(a,18890,k+16|0)}d=H[f>>2];H[k+4>>2]=H[e>>2];H[k>>2]=d;nc(a,27088,k);h:{i:{if(!c){if(I[e+43|0]==1){break i}d=0;f=e+8|0;n=H[e+20>>2];while(1){c=d?d>>>0>n>>>0?n:0:n;l=f;while(1){o=H[l>>2];if(o){p=H[o+44>>2];l=c>>>0<p>>>0?p:c;c=d?d>>>0>p>>>0?l:c:l;l=o+20|0;continue}break}if(c){ZC(a,c,Lb(H[a>>2],H[e+60>>2]));d=c;continue}break}}if(I[e+43|0]!=1){break h}}kb(m,172,g,0,0,H[e>>2],0);Rc(a)}kb(m,151,g,0,0,H[e>>2],0);hg(a,g);a=H[(H[h+16>>2]+(g<<4)|0)+12>>2];if(I[a+78|0]&2){c=a+16|0;while(1){c=H[c>>2];if(c){a=H[c+8>>2];if(I[a+43|0]!=2){continue}to(h,a);continue}break}a=H[(H[h+16>>2]+(g<<4)|0)+12>>2];G[a+78>>1]=J[a+78>>1]&65533}Ga=k+32|0}Ic(i,b);Ga=j+48|0}function Wv(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{if((d|0)>=6){f=15;if(d>>>0>100){break a}e=d-9|0;Ww(H[a>>2],d>>>0>9?N(N(e,e),39):1)}b:{if(c){break b}if(!I[a+50|0]){f=Rv(a,b);if((f|0)==5){f=-1;if(!H[H[a+32>>2]>>2]){break a}d=oi(a,2);if(!d){dh(a,2);return-1}f=(d|0)==5?261:d}if(f){break a}if(!I[a+50|0]){break b}}d=0;g=Ga+-64|0;Ga=g;c=oi(a,3);c:{if(c){c=(c|0)==5?-1:c;break c}G[a+40>>1]=0;d:{e:{c=Pv(H[a+4>>2],0,0,g+12|0);if((c|0)!=8){if((c|0)!=1288){break c}Ya(a+52|0,Lf(a),48);c=Nd(H[a+8>>2],g+56|0);if(c){break c}c=H[g+60>>2];if((c|0)<=0&K[g+56>>2]<=31|(c|0)<0){H[b>>2]=1;c=H[a+68>>2]?-1:0;break c}c=Jc(H[a+8>>2],g+16|0,32,0,0);if(c){break c}c=-1;if(H[g+32>>2]!=(I[a+84|0]|I[a+85|0]<<8|(I[a+86|0]<<16|I[a+87|0]<<24))|H[g+36>>2]!=(I[a+88|0]|I[a+89|0]<<8|(I[a+90|0]<<16|I[a+91|0]<<24))){break c}h=H[a+36>>2]+24|0;d=h;c=d>>31;h=d;i=c;d=Ib(d,c);if(!d){c=7;d=0;break c}e=SK(H[a+68>>2],0,H[a+36>>2]+24|0,0)+32|0;c=Ja;c=e>>>0<32?c+1|0:c;f=e;l=d+24|0;m=H[a+80>>2];n=H[a+76>>2];while(1){e=c+i|0;j=f+h|0;e=j>>>0<h>>>0?e+1|0:e;k=H[g+60>>2];if((k|0)<=(e|0)&j>>>0>K[g+56>>2]|(e|0)>(k|0)){break e}c=Jc(H[a+8>>2],d,h,f,c);if(c){break d}if(!Ov(a,g+8|0,g+4|0,l,d)){break e}if(H[g+4>>2]){c=-1;break d}else{f=j;c=e;continue}}}c=-1;break c}c=0}H[a+80>>2]=m;H[a+76>>2]=n}Wa(d);if(c){d=0;while(1){if(H[a+24>>2]>(d|0)){e=d<<2;Wa(H[e+H[a+32>>2]>>2]);H[e+H[a+32>>2]>>2]=0;d=d+1|0;continue}break}F[a+50|0]=0;qp(a);H[b>>2]=1}Ga=g- -64|0;return c}b=0;f=0;f:{j=pi(a);if(H[j>>2]!=H[a+68>>2]|c){break f}f=oi(a,3);Ql(a);if((f|0)==5){break f}if(f){break a}if(Ob(Lf(a),a+52|0,48)){dh(a,3);return-1}G[a+40>>1]=0;return 0}h=j+4|0;e=H[a+68>>2];d=1;c=0;while(1){if((d|0)!=5){i=H[h+(d<<2)>>2];g=i>>>0>e>>>0|c>>>0>i>>>0;c=g?c:i;b=g?b:d;d=d+1|0;continue}break}g:{h:{if(I[a+46|0]&2){break h}d=1;if(b?c>>>0>=e>>>0:0){break g}while(1){if((d|0)==5){break h}i=d+3|0;f=sg(a,i,1);if((f|0)!=5){if(f){break a}H[h+(d<<2)>>2]=e;Qe(a,i,1);c=e;b=d;break g}else{d=d+1|0;f=5;continue}}}if(b){break g}return(f|0)==5?-1:1288}e=b+3|0;d=oi(a,e);if(d){return(d|0)==5?-1:d}H[a+100>>2]=H[j>>2]+1;Ql(a);i:{if(H[h+(b<<2)>>2]==(c|0)){if(!Ob(Lf(a),a+52|0,48)){break i}}dh(a,e);return-1}G[a+40>>1]=b;f=0}return f}function nr(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;n=H[a+8>>2];a:{b:while(1){h=N(b,12);j=h+n|0;f=I[c|0];if(!f){return j}if(I[(h+n|0)+1|0]&8){break a}c:{d:{if((f|0)==91){g=0;h=1;while(1){f=I[c+h|0];if(f-58>>>0<4294967286){break d}h=h+1|0;g=(N(g,10)+(f<<24>>24)|0)-48|0;continue}}if((f|0)!=46){break c}if(I[j|0]!=7){break a}i=c+1|0;f=0;e:{f:{g=I[c+1|0];g:{if((g|0)==34){h=c+2|0;g=1;while(1){c=I[g+i|0];if(!c){break g}if((c|0)==34){break f}g=g+1|0;continue}}while(1){c=g&255;if(!(!c|(c|0)==46|(c|0)==91)){f=f+1|0;g=I[i+f|0];continue}break}h=i;c=f;if(c){break e}}H[e>>2]=i;break a}c=g+1|0;f=g-1|0}while(1){o=H[j+4>>2];g=1;while(1){if(g>>>0<=o>>>0){k=g+1|0;l=N(g,12)+j|0;g=H[l+4>>2];h:{i:{if(F[l+1|0]&1){m=0;if((g|0)!=(f|0)){break i}m=!Be(H[l+8>>2],h,f);break h}m=0;if((g|0)!=(f+2|0)){break i}m=!Be(H[l+8>>2]+1|0,h,f)}}if(m){c=c+i|0;b=b+k|0;continue b}else{g=re(N(k,12)+j|0)+k|0;continue}}break}if(I[j+1|0]&32){b=H[j+8>>2]+b|0;j=N(b,12)+n|0;continue}break}if(!d){break a}j=yd(a,7,2,0);f=yd(a,5,f,h);c=cA(a,c+i|0,d,e);if(I[a+20|0]|!c){break a}d=H[a+8>>2]+N(b,12)|0;H[d+8>>2]=j-b;F[d+1|0]=I[d+1|0]|32;a=H[a+8>>2]+N(f,12)|0;F[a+1|0]=I[a+1|0]|1;return c}j:{if(!((f|0)==93&h>>>0>=2)){if(I[c+1|0]!=35){break c}i=j;f=b;if(I[j|0]!=6){break a}while(1){k=H[i+4>>2];while(1){if(h>>>0<=k>>>0){l=N(h,12)+i|0;h=re(l)+h|0;g=((I[l+1|0]^-1)>>>2&1)+g|0;continue}break}if(I[i+1|0]&32){f=H[i+8>>2]+f|0;i=N(f,12)+n|0;h=1;continue}break}h=2;f=I[c+2|0];k:{if((f|0)==45){f=I[c+3|0];if(f-58>>>0<4294967286){break k}i=0;h=3;while(1){i=(N(i,10)+(f<<24>>24)|0)-48|0;h=h+1|0;f=I[h+c|0];if(f-58>>>0>4294967285){continue}break}if(g>>>0<i>>>0){break a}g=g-i|0}if((f|0)==93){break j}}H[e>>2]=c;return 0}if(I[j|0]!=6){break a}}c=(c+h|0)+1|0;while(1){f=H[j+4>>2];h=1;l:{m:{n:{while(1){if(f>>>0>=h>>>0){i=N(h,12)+j|0;k=I[i+1|0];if(!(k&4?1:g)){break n}h=re(i)+h|0;g=((k>>>2&1)+g|0)-1|0;continue}break}if(I[j+1|0]&32){break m}if(!d|g){break a}f=yd(a,6,1,0);c=cA(a,c,d,e);if(I[a+20|0]|!c){break a}a=H[a+8>>2]+N(b,12)|0;H[a+8>>2]=f-b;F[a+1|0]=I[a+1|0]|32;return c}g=0;if(!(I[j+1|0]&32)){break l}}b=H[j+8>>2]+b|0;j=N(b,12)+n|0;continue}break}b=b+h|0;continue}break}H[e>>2]=c}return 0}function BH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;k=H[a+4>>2];o=k+H[a+8>>2]|0;k=k+H[a+12>>2]|0;r=H[a>>2];while(1){s=k;if(k>>>0>=o>>>0){return 101}k=s+1|0;i=I[s|0];if(i>>>0>=192){g=I[i+31856|0];while(1){a:{if((k|0)==(o|0)){k=o;break a}h=I[k|0];if((h&192)!=128){break a}g=h&63|g<<6;k=k+1|0;continue}break}i=(g&-2)==65534?65533:g>>>0<128?65533:(g&-2048)==55296?65533:g}if(!Lz(r,i)){continue}break}l=H[a+20>>2];j=l;while(1){g=H[a+24>>2];if((g-4|0)<=(j-l|0)){g=g- -64|0;h=ye(l,g,g>>31);if(!h){return 7}g=H[a+20>>2];H[a+20>>2]=h;H[a+24>>2]=H[a+24>>2]- -64;j=h+(j-g|0)|0}g=0;h=i-65>>>0<26?i+32|0:i;b:{if((i|0)<=127){break b}p=H[r+4>>2];c:{if(i>>>0<=65535){l=162;m=-1;while(1){if((g|0)<=(l|0)){n=(g+l|0)/2|0;h=J[(n<<2)+52912>>1]>(i|0);l=h?n-1|0:l;m=h?m:n;g=h?g:n+1|0;continue}break}h=m<<2;g=J[h+52912>>1];d:{if((g+I[h+52915|0]|0)<=(i|0)){break d}l=g^i;g=I[h+52914|0];if(l&g&1){break d}i=J[(g&254)+53568>>1]+i&65535}if(!p){break c}p=(p|0)==2;g=0;l=0;h=i<<3|7;m=125;while(1){if((l|0)<=(m|0)){q=(l+m|0)/2|0;n=J[(q<<1)+53728>>1]>h>>>0;l=n?l:q+1|0;m=n?q-1|0:m;g=n?g:q;continue}break}e:{if(!p&F[g+53984|0]<0){break e}h=J[(g<<1)+53728>>1];if(((h>>>3|0)+(h&7)|0)<(i|0)){break e}i=I[g+53984|0]&127}h=i;break b}i=i-66560>>>0<40?i+40|0:i}h=i}f:{if(!h){break f}if((h|0)<=127){F[j|0]=h;j=j+1|0;break f}if(h>>>0<=2047){F[j+1|0]=h&63|128;F[j|0]=h>>>6|192;j=j+2|0;break f}if(h>>>0<=65535){F[j+2|0]=h&63|128;F[j|0]=h>>>12|224;F[j+1|0]=h>>>6&63|128;j=j+3|0;break f}F[j+3|0]=h&63|128;F[j+2|0]=h>>>6&63|128;F[j+1|0]=h>>>12&63|128;F[j|0]=h>>>18&7|240;j=j+4|0}g:{h:{i:{if(k>>>0<o>>>0){g=k+1|0;i=I[k|0];if(i>>>0<192){break h}i=I[i+31856|0];while(1){if((g|0)==(o|0)){g=o;break i}h=I[g|0];if((h&192)!=128){break i}i=h&63|i<<6;g=g+1|0;continue}}g=k;break g}i=(i&-2)==65534?65533:i>>>0<128?65533:(i&-2048)==55296?65533:i}if(!Lz(r,i)){if(!cr(i)){break g}}l=H[a+20>>2];k=g;continue}break}H[a+12>>2]=g-H[a+4>>2];H[b>>2]=H[a+20>>2];H[c>>2]=j-H[a+20>>2];b=H[a+4>>2];H[d>>2]=s-b;H[e>>2]=k-b;b=a;a=H[a+16>>2];H[b+16>>2]=a+1;H[f>>2]=a;return 0}function TH(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;m=Ga-16|0;Ga=m;i=b+8|0;h=a-8|0;a:{if(!h){c=Ue(i);break a}if(i>>>0>=4294967232){H[17665]=48;c=0;break a}e=i>>>0<11?16:i+11&-8;k=h-4|0;l=H[k>>2];c=l&-8;b:{c:{if(!(l&3)){if(e>>>0<256|c>>>0<(e|4)>>>0){break c}if(c-e>>>0<=H[17818]<<1>>>0){break b}break c}j=h-8|0;f=c+j|0;if(c>>>0>=e>>>0){c=c-e|0;if(c>>>0<16){break b}H[k>>2]=l&1|e|2;d=e+j|0;H[d+4>>2]=c|3;H[f+4>>2]=H[f+4>>2]|1;pm(d,c);c=h;break a}if(H[17704]==(f|0)){c=c+H[17701]|0;if(c>>>0<=e>>>0){break c}H[k>>2]=l&1|e|2;d=e+j|0;c=c-e|0;H[d+4>>2]=c|1;H[17701]=c;H[17704]=d;c=h;break a}if(H[17703]==(f|0)){c=c+H[17700]|0;if(c>>>0<e>>>0){break c}d=c-e|0;d:{if(d>>>0>=16){H[k>>2]=l&1|e|2;g=e+j|0;H[g+4>>2]=d|1;c=c+j|0;H[c>>2]=d;H[c+4>>2]=H[c+4>>2]&-2;break d}H[k>>2]=c|l&1|2;c=c+j|0;H[c+4>>2]=H[c+4>>2]|1;d=0}H[17703]=g;H[17700]=d;c=h;break a}d=H[f+4>>2];if(d&2){break c}n=c+(d&-8)|0;if(n>>>0<e>>>0){break c}p=n-e|0;e:{if(d>>>0<=255){c=H[f+8>>2];g=d>>>3|0;d=H[f+12>>2];if((d|0)==(c|0)){q=70792,r=H[17698]&YK(-2,g),H[q>>2]=r;break e}H[c+12>>2]=d;H[d+8>>2]=c;break e}o=H[f+24>>2];c=H[f+12>>2];f:{if((f|0)!=(c|0)){d=H[f+8>>2];H[d+12>>2]=c;H[c+8>>2]=d;break f}g:{d=f+20|0;g=H[d>>2];if(g){break g}d=f+16|0;g=H[d>>2];if(g){break g}c=0;break f}while(1){i=d;c=g;d=c+20|0;g=H[d>>2];if(g){continue}d=c+16|0;g=H[c+16>>2];if(g){continue}break}H[i>>2]=0}if(!o){break e}d=H[f+28>>2];g=(d<<2)+71096|0;h:{if(H[g>>2]==(f|0)){H[g>>2]=c;if(c){break h}q=70796,r=H[17699]&YK(-2,d),H[q>>2]=r;break e}H[(H[o+16>>2]==(f|0)?16:20)+o>>2]=c;if(!c){break e}}H[c+24>>2]=o;d=H[f+16>>2];if(d){H[c+16>>2]=d;H[d+24>>2]=c}d=H[f+20>>2];if(!d){break e}H[c+20>>2]=d;H[d+24>>2]=c}if(p>>>0<=15){H[k>>2]=l&1|n|2;c=j+n|0;H[c+4>>2]=H[c+4>>2]|1;c=h;break a}H[k>>2]=l&1|e|2;c=e+j|0;H[c+4>>2]=p|3;d=j+n|0;H[d+4>>2]=H[d+4>>2]|1;pm(c,p);c=h;break a}d=Ue(i);c=0;if(!d){break a}c=H[k>>2];c=(c&3?-4:-8)+(c&-8)|0;Ya(d,h,c>>>0<i>>>0?c:i);Te(h);h=d}c=h}i:{if(c){H[c>>2]=b;H[c+4>>2]=b>>31;a=c+8|0;break i}a=$z(a);H[m+4>>2]=b;H[m>>2]=a;Fc(7,5061,m);a=0}Ga=m+16|0;return a|0}function wv(a){var b=0,c=0,d=0,e=0,f=0,g=0;d=Ga-32|0;Ga=d;a:{b:{if(!H[a+232>>2]){if(I[a+17|0]){break b}H[d+28>>2]=1;b=op(a,1);if(b){break a}c:{if(I[a+18|0]<=1){b=Ga-16|0;Ga=b;f=H[a>>2];H[b+12>>2]=1;e=H[H[a+68>>2]>>2];H[d+28>>2]=0;if(e){g=1}else{c=pg(f,H[a+188>>2],0,b+12|0);g=H[b+12>>2]!=0}d:{if(!g|c){break d}H[b+8>>2]=0;c=H[a+64>>2];c=Ka[H[H[c>>2]+36>>2]](c,b+8|0)|0;if(c|H[b+8>>2]){break d}c=hp(a,b+4|0);if(c){break d}e:{if(!(e|H[b+4>>2])){Md();f:{if(qg(a,2)){break f}Pe(f,H[a+188>>2],0);if(I[a+4|0]){break f}ch(a,1)}Ld();break e}g:{if(!e){H[b>>2]=2049;c=ff(f,H[a+188>>2],H[a+68>>2],2049,b);if((c|0)==14){break g}if(c){break d}}F[b|0]=0;c=Jc(H[a+68>>2],b,1,0,0);f=(c|0)==522;if(!e){$c(H[a+68>>2])}c=f?0:c;H[d+28>>2]=I[b|0]!=0;break d}H[d+28>>2]=1}c=0}Ga=b+16|0;b=c;if(b){break a}if(!H[d+28>>2]){break c}}b=776;if(I[a+14|0]){break a}b=qg(a,4);if(b){break a}h:{i:{j:{if(!H[H[a+68>>2]>>2]){b=0;if(I[a+5|0]==2){break j}c=H[a>>2];b=pg(c,H[a+188>>2],0,d);k:{if(b|!H[d>>2]){break k}H[d+24>>2]=0;b=ff(c,H[a+188>>2],H[a+68>>2],2050,d+24|0);if(b){break k}b=0;if(!(F[d+24|0]&1)){break k}b=xe(59193);$c(H[a+68>>2])}if(!H[H[a+68>>2]>>2]){break j}}b=fw(a);if(b){break h}b=Hv(a,!I[a+12|0]);F[a+17|0]=0;break i}if(I[a+4|0]){break i}ch(a,1)}if(!b){break c}}b=Kj(a,b);break a}l:{if(I[a+12|0]|!I[a+24|0]){break l}b=Jc(H[a+64>>2],d,16,24,0);if(b){if((b|0)!=522){break a}H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0}if(!Ob(a+112|0,d,16)){break l}eh(a)}b=0;c=Ga-16|0;Ga=c;m:{if(I[a+12|0]){break m}b=pg(H[a>>2],H[a+236>>2],0,c+12|0);if(b){break m}if(H[c+12>>2]){b=hp(a,c+8|0);if(b){break m}if(!H[c+8>>2]){b=Pe(H[a>>2],H[a+236>>2],0);break m}b=vv(a,0);break m}b=0;if(I[a+5|0]!=5){break m}F[a+5|0]=0}Ga=c+16|0;if(!H[a+232>>2]){break b}}e=Ga-16|0;Ga=e;H[e+12>>2]=0;qp(H[a+232>>2]);f=H[a+232>>2];g=e+12|0;b=0;while(1){b=b+1|0;c=Wv(f,g,0,b);if((c|0)==-1){continue}break}b=c;if(b|H[e+12>>2]){eh(a)}Ga=e+16|0}if(I[a+12|0]|(I[a+17|0]|b)){break a}b=hp(a,a+28|0)}n:{if(b){Wl(a);break n}F[a+24|0]=1;F[a+17|0]=1}Ga=d+32|0;return b}function Nl(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=Ga-16|0;Ga=j;k=H[a+224>>2];l=H[(d?68:72)+a>>2];h=Kf(l,H[b>>2],H[b+4>>2],j+8|0);a:{if(h){break a}f=H[b+4>>2];i=H[b>>2]+4|0;f=i>>>0<4?f+1|0:f;h=Jc(l,k,H[a+168>>2],i,f);if(h){break a}h=H[b+4>>2];g=d<<2;i=g+H[a+168>>2]|0;f=H[a+172>>2];f=g>>>0>i>>>0?f+1|0:f;g=i;i=g+H[b>>2]|0;f=f+h|0;f=g>>>0>i>>>0?f+1|0:f;i=i+4|0;f=i>>>0<4?f+1|0:f;H[b>>2]=i;H[b+4>>2]=f;h=101;g=H[j+8>>2];if(!g|H[a+164>>2]==(g|0)){break a}h=0;if(K[a+28>>2]<g>>>0){break a}if(Jw(c,g)){break a}b:{if(!d){break b}h=Kf(l,i-4|0,f-(i>>>0<4)|0,j+4|0);if(h){break a}if(e){break b}h=101;if((Cv(a,k)|0)!=H[j+4>>2]){break a}}if(c){h=lh(c,g);if(h){break a}}c:{if((g|0)!=1){break c}c=I[k+20|0];if((c|0)==G[a+150>>1]){break c}G[a+150>>1]=c}d:{e:{f:{if(!H[a+232>>2]){c=ni(a,g);H[j+12>>2]=c;if(!d){break f}break e}c=0;H[j+12>>2]=0;if(d){break e}e=1;break d}if(!c){c=0;e=1;break d}e=(J[c+28>>1]^-1)>>>3&1;break d}e=1;if(I[a+7|0]){break d}e=H[b+4>>2];f=H[a+92>>2];e=(e|0)<=(f|0)&K[b>>2]<=K[a+88>>2]|(e|0)<(f|0)}g:{h:{b=H[a+64>>2];if(!H[b>>2]){break h}i=!e;e=I[a+17|0];if(i|(e?e>>>0<=3:0)){break h}d=b;b=H[a+168>>2];h=Bc(d,k,b,SK(b,H[a+172>>2],g-1|0,0),Ja);if(K[a+36>>2]<g>>>0){H[a+36>>2]=g}b=H[a+96>>2];if(!b){break g}yp(b,g,k);break g}h=0;if(c|d){break g}F[a+21|0]=I[a+21|0]|2;h=sd(a,g,j+12|0,1);F[a+21|0]=I[a+21|0]&253;if(h){break a}Ml(H[j+12>>2]);c=H[j+12>>2];h=0}if(!c){break a}b=Ya(H[c+4>>2],k,H[a+168>>2]);Ka[H[a+216>>2]](H[j+12>>2]);if((g|0)==1){c=I[b+28|0]|I[b+29|0]<<8|(I[b+30|0]<<16|I[b+31|0]<<24);d=I[b+24|0]|I[b+25|0]<<8|(I[b+26|0]<<16|I[b+27|0]<<24);F[a+112|0]=d;F[a+113|0]=d>>>8;F[a+114|0]=d>>>16;F[a+115|0]=d>>>24;F[a+116|0]=c;F[a+117|0]=c>>>8;F[a+118|0]=c>>>16;F[a+119|0]=c>>>24;c=I[b+36|0]|I[b+37|0]<<8|(I[b+38|0]<<16|I[b+39|0]<<24);b=I[b+32|0]|I[b+33|0]<<8|(I[b+34|0]<<16|I[b+35|0]<<24);F[a+120|0]=b;F[a+121|0]=b>>>8;F[a+122|0]=b>>>16;F[a+123|0]=b>>>24;F[a+124|0]=c;F[a+125|0]=c>>>8;F[a+126|0]=c>>>16;F[a+127|0]=c>>>24}Cp(H[j+12>>2])}Ga=j+16|0;return h}function Ln(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=Ga-16|0;Ga=j;a:{m=H[a>>2];if(I[b+43|0]|!(I[m+33|0]&64)){break a}t=c+1|0;h=b+48|0;g=H[m+16>>2];o=Lb(m,H[b+60>>2]);r=H[g+(o<<4)>>2];s=I[a+151|0];while(1){i=H[h>>2];if(i){H[j+12>>2]=0;H[j+8>>2]=0;b:{c:{if(!e){break c}if(!Qb(H[b>>2],H[i+8>>2])){break c}if(!MA(b,i,e,f)){break b}}g=H[i+8>>2];d:{e:{f:{if(I[a+151|0]){g=Dc(m,g,r);break f}g=Sf(a,0,g,r)}if(g){if(!bj(a,g,i,j+12|0,j+8|0)){break e}}if(I[m+87|0]|!s){break a}if(g){break b}g=zb(a);h=H[i+20>>2];l=(h+H[g+108>>2]|0)+1|0;k=0;while(1){if((h|0)<=(k|0)){break d}Va(g,50,Oc(H[i>>2],G[(i+(k<<3)|0)+36>>1])+t|0,l);k=k+1|0;h=H[i+20>>2];continue}}p=H[j+8>>2];if(!p){H[j+4>>2]=H[i+36>>2];p=j+4|0}l=g+32|0;h=0;q=H[j+12>>2];k=0;while(1){if(H[i+20>>2]>(k|0)){n=(k<<2)+p|0;if(H[n>>2]==G[b+32>>1]){H[n>>2]=-1}if(H[m+360>>2]){h=(ZB(a,H[g>>2],H[H[g+4>>2]+N(G[(q?H[q+4>>2]+(k<<1)|0:l)>>1],12)>>2],o)|0)==2}k=k+1|0;continue}break}Dd(a,o,H[g+20>>2],0,H[g>>2]);H[a+40>>2]=H[a+40>>2]+1;if(c){JA(a,o,g,q,i,p,c,-1,h)}g:{if(!d){break g}k=H[a+116>>2];k=H[(k?k:a)+124>>2];n=0;h:{if(!k){break h}k=H[k>>2];if((k|0)==H[i+28>>2]){n=1;if(I[i+25|0]==8){break h}}if((k|0)==H[i+32>>2]){n=1;if(I[i+26|0]==8){break h}}n=0}if(n){break g}JA(a,o,g,q,i,p,d,1,h)}_a(m,H[j+8>>2]);break b}Va(g,158,I[i+24|0],-1)}h=i+4|0;continue}break}i=(e|0)!=0;h=Jh(b);while(1){if(!h){break a}H[j+12>>2]=0;H[j+8>>2]=0;i:{if(e){if(!Gr(b,h,e,f)){break i}}if(!(H[a+116>>2]|(I[h+24|0]|I[m+34|0]&8))){if(!I[a+20|0]){break i}}if(bj(a,b,h,j+12|0,j+8|0)){if(!s){break a}if(!I[m+87|0]){break i}break a}g=Rd(a,0,0,0);if(g){l=H[h>>2];H[g+24>>2]=l;H[g+16>>2]=H[l>>2];H[l+24>>2]=H[l+24>>2]+1;l=H[a+40>>2];H[a+40>>2]=l+1;H[g+48>>2]=l;if(d){IA(a,g,b,H[j+12>>2],h,H[j+8>>2],d,-1)}j:{if(!c){break j}l=I[(h+i|0)+25|0];IA(a,g,b,H[j+12>>2],h,H[j+8>>2],c,1);if(I[h+24|0]){break j}k:{switch(l-8|0){case 0:case 2:break j;default:break k}}Rc(a)}H[g+16>>2]=0;Ic(m,g)}_a(m,H[j+8>>2])}h=H[h+12>>2];continue}}Ga=j+16|0}function dj(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;w=(c|0)!=129;while(1){if(b){k=I[b+8|0];a:{if((k|0)!=(c|0)&(!I[b+10|0]|w|(k|0)!=127)|I[b+9|0]!=(e|0)){break a}if(!Fr(H[b+16>>2],d)){break a}if(!I[b+10|0]){KA(a,b,f,g,h,i);break a}if(H[a+116>>2]){break a}k=Ga-192|0;Ga=k;t=H[a+8>>2];s=H[a>>2];q=H[a+132>>2];n=k+112|0;$a(n,0,76);j=k+40|0;$a(j,0,72);o=rc(s,H[q+4>>2],0);H[k+88>>2]=-1;H[k- -64>>2]=f;H[k+140>>2]=o;H[k+40>>2]=1;H[k+144>>2]=j;ve(a,n,0);if(!H[a+36>>2]){Ts(a,k+112|0)}qb(s,H[k+140>>2]);u=H[q+4>>2];n=0;o=0;j=H[a>>2];while(1){if(H[u>>2]>(o|0)){p=u+(o<<4)|0;l=H[p+8>>2];b:{if(!l){break b}m=0;v=I[l|0];c:{if((v|0)!=141){r=1;if((v|0)==180){break c}r=0;break c}r=0;if(I[H[l+16>>2]]!=180){break c}Za(a,5578,0);r=1}if(r){while(1){if(G[f+34>>1]<=(m|0)){break b}p=N(m,12);l=p+H[f+4>>2]|0;d:{if(I[l+10|0]&2){break d}n=sb(a,n,sc(j,59,H[l>>2]));if(I[j+87|0]){break d}l=(H[n>>2]<<4)+n|0;x=l-4|0,y=Xb(j,H[p+H[f+4>>2]>>2]),H[x>>2]=y;p=(I[l+1|0]|I[l+2|0]<<8)&65532;F[l+1|0]=p;F[l+2|0]=p>>>8}m=m+1|0;continue}}n=sb(a,n,nb(j,l,0));if(I[j+87|0]){break b}l=H[p+12>>2];if(!l){break b}m=(H[n>>2]<<4)+n|0;x=m-4|0,y=Xb(j,l),H[x>>2]=y;l=(I[m+1|0]|I[m+2|0]<<8)&65532|(I[p+17|0]|I[p+18|0]<<8)&3;F[m+1|0]=l;F[m+2|0]=l>>>8}o=o+1|0;continue}break}e:{if(I[s+87|0]){break e}H[k+36>>2]=0;H[k+28>>2]=0;H[k+32>>2]=0;H[k+20>>2]=0;H[k+24>>2]=0;H[k+12>>2]=0;H[k+16>>2]=0;if(!H[q+96>>2]){H[q+96>>2]=H[n>>2];j=H[a+40>>2];H[a+40>>2]=j+1;H[q+92>>2]=j}H[k+32>>2]=1024;H[k+16>>2]=g;H[k+8>>2]=a;j=I[b+8|0];H[a+120>>2]=f;F[a+148|0]=j;if($e(k+8|0,n)|I[s+87|0]){break e}m=H[n>>2];j=H[a+44>>2];H[a+44>>2]=(m+j|0)+2;o=j+1|0;H[q+100>>2]=o;j=0;m=(m|0)>0?m:0;while(1){if((j|0)!=(m|0)){l=H[((j<<4)+n|0)+8>>2];p=j+o|0;Wk(a,l,p);if((Lc(l)|0)==69){db(t,87,p)}j=j+1|0;continue}break}j=m+o|0;Xa(t,97,o,m,j);o=j+1|0;Va(t,127,H[q+92>>2],o);Xa(t,128,H[q+92>>2],j,o)}qb(s,n);H[a+120>>2]=0;F[a+148|0]=0;Ga=k+192|0}b=H[b+32>>2];continue}break}}function _y(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;i=Ga-16|0;Ga=i;o=H[a>>2];H[i+12>>2]=0;a:{if(H[o+40>>2]){break a}q=(d|0)>0?d:0;d=0;while(1){if((d|0)!=(q|0)){e=N(d,24)+c|0;if(H[e+12>>2]==(b|0)){n=n+1|0;f=H[e+16>>2]+f|0}d=d+1|0;continue}break}e=0;if(!f|(n|0)<2){break a}r=n-1|0;f=0;e=Ga-32|0;Ga=e;d=H[a+60>>2];b:{if(!d){h=H[a>>2];H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;f=Sy(h,e+28|0);if(f){break b}c:{d=H[e+28>>2];f=mf(d,0);d:{if(!f){break d}g=_d(d,0)+f|0;f=Gm(f,g,e+16|0)+f|0;while(1){if(f>>>0<g>>>0){f=Gm(f,g,e+8|0)+f|0;continue}break}f=H[e+16>>2];g=H[e+20>>2];if(!(f|g)){break d}j=H[e+8>>2];k=H[e+12>>2];if(j|k){break c}}rb(d);f=267;break b}H[a+64>>2]=f;H[a+68>>2]=g;m=H[h+244>>2];g=TK(j,k,f,g);h=m+g|0;j=m>>31;f=j+Ja|0;s=a,t=TK(h,g>>>0>h>>>0?f+1|0:f,m,j),H[s+60>>2]=t;f=rb(d);d=H[a+60>>2]}H[i+12>>2]=d}Ga=e+32|0;e=f;j=H[i+12>>2];h=1;while(1){if((l|0)>=(n|0)){break a}d=0;f=0;if(e){break a}while(1){if((d|0)!=(q|0)){g=N(d,24);e=g+c|0;e:{if(!H[e+8>>2]){break e}g=c+g|0;if(H[g+12>>2]!=(b|0)|(H[g+16>>2]>=H[f+16>>2]?f:0)){break e}f=e}d=d+1|0;continue}break}f:{g:{if(!l){h=h<<2;break g}d=(h|0)/4|0;if(H[f+16>>2]>=(N(j,((d+p|0)-1|0)/(d|0)|0)|0)){g=H[f+8>>2];k=H[f+20>>2];d=Ub(16);e=7;h:{if(!d){break h}H[d+4>>2]=0;H[d+8>>2]=0;H[d>>2]=g;H[d+12>>2]=0;e=H[a+28>>2];H[d+4>>2]=k;H[d+8>>2]=e;H[a+28>>2]=d;H[g+16>>2]=d;e=0}Sq(H[g+20>>2]);H[g+20>>2]=0;break f}h=l>>>0<12?h<<2:h;e=0;if((l|0)==(r|0)|H[H[f>>2]+64>>2]<2){break f}}d=H[f+8>>2];H[i+8>>2]=0;H[i+4>>2]=0;e=Vy(o,d,H[f+20>>2],i+8|0,i+4|0);if(e){break f}e=Uy(o,H[f>>2],H[f+4>>2],H[i+4>>2],H[i+8>>2]);if(e){break f}e=H[f>>2];d=H[e>>2];e=H[e+4>>2];g=Ga-16|0;Ga=g;i:{if(!d){e=0;break i}k=d+e|0;e=0;while(1){if(d>>>0>=k>>>0){break i}while(1){m=F[d|0];d=d+1|0;if((m|0)<0){continue}break}H[g+12>>2]=d;Fe(0,g+12|0);e=e+1|0;d=H[g+12>>2];continue}}Ga=g+16|0;p=l?(e|0)<(p|0)?e:p:e;e=0}H[f+8>>2]=0;l=l+1|0;continue}}Ga=i+16|0;return e}function OG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;b=Ga-16|0;Ga=b;a:{if(Bm(a,3873,H[c>>2],b+12|0)){break a}g=H[b+12>>2];if(Jm(a,g)){break a}m=a;d=Ga-160|0;Ga=d;k=H[g>>2];n=H[H[k+36>>2]>>2];H[d+152>>2]=0;H[d+144>>2]=0;H[d+148>>2]=0;b:{if(!H[g+16>>2]){wb(m,29357,0,0);break b}H[d+136>>2]=0;H[d+140>>2]=0;H[d+128>>2]=0;H[d+132>>2]=0;H[d+120>>2]=0;H[d+124>>2]=0;H[d+112>>2]=0;H[d+116>>2]=0;e=Am(g,0,d+156|0);c:{if(e){break c}a=Xe(N(H[d+156>>2],24),0);H[d+136>>2]=a;d:{if(!a){break d}a=H[g+36>>2];c=H[g+32>>2];H[d+112>>2]=g;H[d+128>>2]=c;H[d+132>>2]=a;a=0;while(1){if(H[k+24>>2]<=(a|0)){e=0;break c}H[d+100>>2]=0;H[d+96>>2]=0;H[d+92>>2]=0;H[d+120>>2]=0;H[d+116>>2]=a;H[d+88>>2]=0;e=uh(H[g+16>>2],107,d+112|0);if(e){break c}c=a+1|0;f=lf(H[g+12>>2],c);e=_d(H[g+12>>2],c);e:{if(!f){if((ph(H[g+12>>2],c)|0)!=5){break d}break e}e=Ig(H[k+36>>2],H[g+20>>2],f,e,d+108|0);if(e){break c}l=H[d+108>>2];e=Ka[H[n+20>>2]](l,d+104|0,d+100|0,d+96|0,d+92|0,d+88|0)|0;while(1){f=H[d+156>>2];q=(f|0)>0?f:0;r=H[d+136>>2];f:{while(1){if(e){break f}e=0;h=2147483647;i=0;while(1){if((e|0)!=(q|0)){f=N(e,24)+r|0;if(H[f>>2]){j=H[f+8>>2];o=H[f+16>>2];p=j-o|0;s=h;t=h>>>0>p>>>0;j=H[f+12>>2]-(H[f+20>>2]+(j>>>0<o>>>0)|0)|0;h=h>>31;j=t&(j|0)<=(h|0)|(h|0)>(j|0);h=j?p:s;i=j?f:i}e=e+1|0;continue}break}e=101;if(!i){continue}break}g:{if(I[H[i>>2]]<=1){H[i>>2]=0;break g}sk(i,i+8|0)}e=0;l=H[d+108>>2];while(1){if(!(H[d+88>>2]>=(h|0)|e)){e=Ka[H[n+20>>2]](l,d+104|0,d+100|0,d+96|0,d+92|0,d+88|0)|0;continue}break}if(!e){H[d>>2]=a;f=H[d+96>>2];H[d+8>>2]=f;H[d+12>>2]=H[d+92>>2]-f;H[d+4>>2]=(i-H[d+136>>2]|0)/24;e=Vf(d+144|0,Vd(64,d+16|0,28787,d),-1);continue}if((e|0)!=101){continue}e=H[k+40>>2]?101:267;continue}break}Ka[H[n+16>>2]](l)|0;if((e|0)!=101){break c}}a=c;continue}}e=7}Wa(H[d+136>>2]);tf(k);if(e){ne(m,e);Wa(H[d+144>>2]);break b}wb(m,H[d+144>>2],H[d+148>>2]-1|0,3)}Ga=d+160|0}Ga=b+16|0}function Lu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=Ga-32|0;Ga=e;g=H[a+8>>2];h=H[g+4>>2];a:{b:{c=I[a|0];if(c){if(c>>>0<3){break b}c=Yj(a);if(c){break a}c=0;if(I[a|0]){break a}}i=J[a+70>>1];d=H[a+116>>2];if(i>>>0>=J[d+24>>1]){c=ab(76317);break a}k=F[a+68|0];c=H[d+64>>2]+(i<<1)|0;f=I[c|0];c=I[c+1|0];j=J[d+26>>1];l=H[d+56>>2];c:{if(H[d+20>>2]>=0){break c}if(!lg(d)){break c}c=ab(76321);break a}f=l+(j&(c|f<<8))|0;j=0;l=b&2;d:{if(!l){break d}e:{if(!I[d+8|0]){break e}j=1;if(((H[d+20>>2]+(Ka[H[d+76>>2]](d,f)|0)|0)+2|0)>((H[h+40>>2]<<1>>>0)/3|0)){break e}if(J[d+24>>1]!=1){break d}}c=ov(a);H[e+28>>2]=c;j=0;if(c){break a}}if(!I[d+8|0]){c=Bl(a);if(c){break a}}if(I[a+1|0]&32){c=Jg(h,H[a+64>>2],a);if(c){break a}}if(!(H[a+112>>2]|!I[g+11|0])){Yo(g,H[a+64>>2],H[a+32>>2],H[a+36>>2],0)}c=_b(H[d+72>>2]);if(c){break a}Ka[H[d+80>>2]](d,f,e);if(H[e+12>>2]!=J[e+16>>1]){b=Vo(d,f,e)}else{b=0}H[e+28>>2]=b;yl(d,i,J[e+18>>1],e+28|0);c=H[e+28>>2];if(c){break a}if(!I[d+8|0]){f=a+116|0;b=H[f>>2];if(H[b+20>>2]<0){c=lg(b);if(c){break a}}c=(H[b+64>>2]+(J[b+24>>1]<<1)|0)-2|0;c=J[b+26>>1]&(I[c|0]<<8|I[c+1|0]);if(c>>>0<=3){c=ab(76412);break a}f=H[H[((F[a+68|0]-1|0)>(k|0)?((k<<2)+a|0)+124|0:f)>>2]+4>>2];g=c+H[b+56>>2]|0;c=Ka[H[b+76>>2]](b,g)|0;h=H[h+84>>2];m=_b(H[b+72>>2]);H[e+28>>2]=m;if(!m){xl(d,i,g-4|0,c+4|0,h,f,e+28|0)}yl(b,J[b+24>>1]-1|0,c,e+28|0);c=H[e+28>>2];if(c){break a}}if((N(H[H[a+116>>2]+20>>2],3)|0)>H[H[a+20>>2]+40>>2]<<1){c=Uo(a);if(c){break a}}if(F[a+68|0]>(k|0)){ji(H[a+116>>2]);c=I[a+68|0]-1|0;F[a+68|0]=c;while(1){b=c<<24>>24;if((k|0)<(b|0)){F[a+68|0]=c-1;Gb(H[((b<<2)+a|0)+120>>2]);c=I[a+68|0];continue}break}H[a+116>>2]=H[((b<<2)+a|0)+120>>2];c=Uo(a);if(c){break a}}if(j){F[a|0]=2;b=J[d+24>>1];if(b>>>0<=i>>>0){H[a+4>>2]=-1;G[a+70>>1]=b-1;c=0;break a}H[a+4>>2]=1;c=0;break a}c=ng(a);if(l){ki(a);F[a|0]=3}if((c|0)!=16){break a}c=0;H[e+28>>2]=0;break a}c=ab(76308)}Ga=e+32|0;return c}function Ak(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Ga-16|0;Ga=j;a:{b:{c:{d:{e:{switch(I[a|0]-1|0){default:Wb(b);break a;case 0:Hc(b,1);break a;case 1:Hc(b,0);break a;case 2:c=H[a+8>>2];f=I[c|0];a=((f|0)==45)+c|0;while(1){g=I[a|0];if((g-48&255)>>>0<=9){a=a+1|0;f:{if(e>>>0<3435973836&(d|0)<=214748364|(d|0)<214748364){break f}if((e|0)!=-858993460|(d|0)!=214748364|(I[a|0]-48&255)>>>0<10){break d}g:{switch(g-56|0){case 0:break g;case 1:break d;default:break f}}if((f|0)!=45){break d}ec(b,0,-2147483648);break a}e=SK(e,d,10,0);d=g-48|0;g=d;e=e+d|0;d=Ja;d=e>>>0<g>>>0?d+1|0:d;continue}break};a=(f|0)==45;ec(b,a?0-e|0:e,a?0-(d+((e|0)!=0)|0)|0:d);break a;case 5:case 6:break b;case 4:break c;case 3:break e}}c=H[a+8>>2]}Yd(c,j+8|0,ib(c),1);Zb(b,M[j+8>>3]);break a}if(!(I[a+1|0]&2)){wb(b,H[a+8>>2]+1|0,H[a+4>>2]-2|0,-1);break a}k=H[a+8>>2];a=H[a+4>>2];g=Ub(a+1|0);if(g){n=k+3|0;o=a-6|0;p=a-1|0;a=1;while(1){h:{i:{j:{k:{if(a>>>0>=p>>>0){break k}h=1;l=a+k|0;c=I[l|0];if((c|0)!=92){e=d;f=a;break h}c=8;e=d;l:{m:{n:{o:{p:{f=a+1|0;m=k+f|0;i=I[m|0];switch(i-98|0){case 0:break h;case 1:case 2:case 3:break l;case 4:break o;default:break p}}q:{switch(i-114|0){case 1:case 2:break l;case 0:break n;case 3:break q;default:break m}}c=aA(m+1|0);if(!c){break k}f=a+5|0;if(c>>>0<=127){break i}if(c>>>0<=2047){F[d+g|0]=c>>>6|192;e=d+1|0;c=c&63|-128;h=2;break h}r:{if((c&64512)!=55296|f>>>0>=o>>>0|I[l+6|0]!=92|I[l+7|0]!=117){break r}h=aA(f+n|0);if((h&64512)!=56320){break r}e=d+g|0;f=(h&1023|c<<10&1047552)+65536|0;F[e|0]=f>>>18|240;F[e+2|0]=f>>>6&63|128;F[e+1|0]=f>>>12&63|128;e=d+3|0;f=a+11|0;c=h&63|-128;h=4;break h}a=d+g|0;F[a|0]=c>>>12|224;F[a+1|0]=c>>>6&63|128;e=d+2|0;c=c&63|-128;h=3;break h}c=12;break i}c=13;break i}if((i|0)==110){break j}}c=(i|0)==116?9:i;break i}F[d+g|0]=0;wb(b,g,d,3);break a}c=10}e=d}F[e+g|0]=c;a=f+1|0;d=d+h|0;continue}}ic(b);break a}Qi(a,b,0)}Ga=j+16|0}function aJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;b=Ga-368|0;Ga=b;i=Gc(a);d=cb(H[c>>2]);j=cb(H[c+12>>2]);g=cb(H[c+16>>2]);k=cb(H[c+20>>2]);e=ac(H[c+24>>2]);if(!(!k|(!j|!g))){l=H[i+360>>2];H[i+360>>2]=0;Se(i);H[b+88>>2]=0;H[b+80>>2]=0;H[b+84>>2]=0;H[b+72>>2]=0;H[b+76>>2]=0;f=Dc(i,g,d);H[b+60>>2]=0;H[b+52>>2]=0;H[b+56>>2]=0;H[b+84>>2]=f;H[b+48>>2]=90;H[b+44>>2]=91;H[b+64>>2]=b+72;f=b+96|0;H[b+40>>2]=f;d=Fk(f,d,i,j,e);a:{if(d){break a}d=H[i+32>>2];f=d&67108864;b:{c:{e=H[b+332>>2];if(e){h=I[e+43|0];if((h|0)==2){if(f){break b}d=H[e+44>>2];H[b+36>>2]=0;H[b+28>>2]=0;H[b+32>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;g=b+96|0;H[b+8>>2]=g;H[d+4>>2]=H[d+4>>2]&-2097153;ve(g,H[e+44>>2],b+8|0);if(H[b+132>>2]){break c}lc(b+40|0,H[e+44>>2]);break b}d:{if(!(d&16384)&(f|0)!=0|(h|0)==1){break d}d=e+48|0;while(1){d=H[d>>2];if(!d){break d}h=H[d+8>>2];if(!Qb(h,g)){bd(b+96|0,b+72|0,h)}d=d+4|0;continue}}d=H[e>>2];if(Qb(g,d)){break b}H[b+84>>2]=e;g=b+96|0;h=b+72|0;if(!f){gc(b+40|0,H[e+16>>2]);d=H[e>>2]}bd(g,h,d);break b}d=H[b+336>>2];if(d){bd(b+96|0,b+72|0,H[d>>2]);if(f){break b}Kb(b+40|0,H[H[b+336>>2]+36>>2]);break b}e=H[b+340>>2];d=H[e+4>>2];if(!(Qb(d,g)|H[H[b+84>>2]+60>>2]!=H[e+24>>2])){bd(b+96|0,b+72|0,d)}if(f){break b}d=_m(b+96|0);if(d){break a}ur(b+40|0,e);d=e+28|0;while(1){e=H[d>>2];if(!e){break b}d=H[e+12>>2];e:{if(!d){break e}if(Qb(d,g)){break e}bd(b+96|0,b+72|0,d)}d=0;f:{f=H[e+16>>2];if(!f){break f}while(1){if(H[f>>2]<=(d|0)){break f}h=H[((d<<6)+f|0)+16>>2];if(!Qb(h,g)){bd(b+96|0,b+72|0,h);f=H[e+16>>2]}d=d+1|0;continue}}d=e+40|0;continue}}d=H[b+108>>2];if(d){break a}}d=tr(a,b+72|0,j,k,1)}g:{h:{i:{switch(d|0){case 0:break g;case 1:break i;default:break h}}if(!Jf(i)){break h}ae(a,H[c+12>>2]);break g}if(H[b+100>>2]){sr(a,29357,H[c+4>>2],H[c+8>>2],b+96|0);break g}ne(a,d)}Ek(b+96|0);Zm(i,H[b+72>>2]);H[i+360>>2]=l}Ga=b+368|0}function Sm(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;a:{if(!b){break a}l=H[a+8>>2];f=H[a+12>>2];n=c;g=H[a+16>>2];e=c+g|0;h=H[a+20>>2];d=h;d=e>>>0<g>>>0?d+1|0:d;e=e+2|0;d=e>>>0<2?d+1|0:d;if((d|0)==(f|0)&e>>>0>=l>>>0|d>>>0>f>>>0){if(Oi(a,c+2|0)){break a}g=H[a+16>>2];d=H[a+20>>2]}else{d=h}h=g+1|0;d=h?d:d+1|0;H[a+16>>2]=h;H[a+20>>2]=d;F[g+H[a+4>>2]|0]=34;q=c+7|0;d=0;h=n+7|0;d=h>>>0<7?1:d;l=h;r=d;s=c+3|0;d=0;c=n+3|0;d=c>>>0<3?1:d;p=c;t=d;g=0;h=0;while(1){b:{c:{if((g|0)!=(n|0)|h){c=I[b+g|0];if(!((c|0)!=92&(c|0)!=34)){e=c;break c}if(c>>>0>31){e=c;break b}e=I[c+50848|0];if(e){break c}o=H[a+8>>2];k=H[a+12>>2];d=H[a+20>>2];f=d;e=h+r|0;j=g+l|0;e=j>>>0<l>>>0?e+1|0:e;i=H[a+16>>2];m=j;j=i+j|0;d=d+e|0;e=j;d=e>>>0<m>>>0?d+1|0:d;if((d|0)==(k|0)&e>>>0>o>>>0|d>>>0>k>>>0){if(Oi(a,q-g|0)){break a}i=H[a+16>>2];d=H[a+20>>2]}else{d=f}f=i+1|0;d=f?d:d+1|0;H[a+16>>2]=f;H[a+20>>2]=d;F[i+H[a+4>>2]|0]=92;d=H[a+20>>2];f=H[a+16>>2];e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=117;e=H[a+20>>2];d=H[a+16>>2];f=d+1|0;e=f?e:e+1|0;H[a+16>>2]=f;H[a+20>>2]=e;F[d+H[a+4>>2]|0]=48;d=H[a+20>>2];f=H[a+16>>2];e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=48;d=H[a+20>>2];f=H[a+16>>2];e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=c>>>4|48;e=I[(c&15)+12010|0];break b}e=H[a+20>>2];b=H[a+16>>2];c=b+1|0;e=c?e:e+1|0;H[a+16>>2]=c;H[a+20>>2]=e;F[b+H[a+4>>2]|0]=34;break a}o=H[a+8>>2];i=H[a+16>>2];c=g;m=p-c|0;j=i+m|0;f=H[a+20>>2];d=f+(t-(h+(c>>>0>p>>>0)|0)|0)|0;c=j;k=H[a+12>>2];d=c>>>0<m>>>0?d+1|0:d;if((k|0)==(d|0)&c>>>0>o>>>0|d>>>0>k>>>0){if(Oi(a,s-g|0)){break a}i=H[a+16>>2];d=H[a+20>>2]}else{d=f}c=i+1|0;d=c?d:d+1|0;H[a+16>>2]=c;H[a+20>>2]=d;F[i+H[a+4>>2]|0]=92}d=H[a+20>>2];c=H[a+16>>2];f=c+1|0;d=f?d:d+1|0;H[a+16>>2]=f;H[a+20>>2]=d;F[c+H[a+4>>2]|0]=e;d=h;c=g+1|0;d=c?d:d+1|0;g=c;h=d;continue}}}function CA(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;j=H[a+44>>2];o=e+9|0;H[a+44>>2]=(j|0)>(o|0)?j:o;q=H[a>>2];g=zb(a);a:{if(!b|!g|I[b+43|0]){break a}if(!xi(28023,H[b>>2],30012,92)){break a}i=H[b>>2];j=H[q+16>>2];s=Lb(q,H[b+60>>2]);if(cc(a,28,i,0,H[j+(s<<4)>>2])){break a}t=e+8|0;x=e+7|0;z=e+5|0;l=e+4|0;A=e+3|0;r=e+2|0;u=e+1|0;Dd(a,s,H[b+20>>2],0,H[b>>2]);j=H[a+40>>2];i=f+2|0;H[a+40>>2]=(j|0)>(i|0)?j:i;fe(a,f,s,b,112);v=e+6|0;Bd(g,v,H[b>>2]);h=b+8|0;n=f+1|0;w=1;while(1){k=H[h>>2];if(k){b:{if((c|0)!=(k|0)?c:0){break b}m=H[k+36>>2];c:{d:{i=I[k+55|0]|I[k+56|0]<<8;e:{if(!(!(I[b+28|0]&128)|(i&3)!=2)){h=H[b>>2];j=J[k+50>>1];break e}h=H[k>>2];j=J[k+52>>1];if(i&8){break d}}i=j;break c}i=J[k+50>>1]}w=m?w:0;Bd(g,x,h);h=H[a+44>>2];m=i-1|0;p=m+o|0;H[a+44>>2]=(h|0)>(p|0)?h:p;Xa(g,112,n,H[k+44>>2],s);Od(a,k);Va(g,71,j,r);Va(g,71,J[k+50>>1],A);B=db(g,35,n);Xa(g,98,n,l,1);Va(g,71,H[q+492>>2],z);Sk(a,0,r,u,4,49464,0);Va(g,71,0,r);j=H[g+108>>2];if(i>>>0>=2){i=jb(a);p=Tb(q,m<<2,0);if(!p){break b}Sb(g,8);j=H[g+108>>2];if(!(!I[k+54|0]|((m|0)!=1|J[k+50>>1]!=1))){Va(g,51,o,i)}h=0;while(1){if((h|0)!=(m|0)){y=h<<2;C=nj(a,H[y+H[k+32>>2]>>2]);Va(g,71,h,r);Xa(g,94,n,h,l);D=p+y|0,E=kb(g,52,l,0,h+o|0,C,-2),H[D>>2]=E;pb(g,128);h=h+1|0;continue}break}Va(g,71,m,r);Yb(g,i);bb(g,j-1|0);h=0;while(1){if((h|0)!=(m|0)){bb(g,H[p+(h<<2)>>2]);Xa(g,94,n,h,h+o|0);h=h+1|0;continue}break}lb(g,i);_a(q,p)}Sk(a,1,u,l,2,49504,0);f:{if(H[q+492>>2]){i=db(g,50,l);h=db(g,15,l);m=ob(g,23,n,0,o,1);bb(g,i);Va(g,38,n,j);bb(g,h);bb(g,m);break f}Va(g,38,n,j)}Sk(a,0,u,t,1,49544,0);kb(g,97,v,3,l,20118,0);Va(g,127,d,e);Xa(g,128,d,l,e);pb(g,8);bb(g,B)}h=k+20|0;continue}break}if(!(w&255)|c){break a}Va(g,98,f,t);a=db(g,16,t);Va(g,75,0,x);kb(g,97,v,3,l,20118,0);Va(g,127,d,e);Xa(g,128,d,l,e);pb(g,8);bb(g,a)}}function LA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=H[a+116>>2];f=(f?f:a)+124|0;a:{while(1){f=H[f>>2];if(f){if(H[f>>2]==(b|0)&H[f+12>>2]==(d|0)){break a}f=f+4|0;continue}break}k=b;b=0;e=Ga-320|0;Ga=e;g=H[a+116>>2];h=H[a>>2];f=yb(h,24,0);b:{if(!f){break b}l=g?g:a;H[f+4>>2]=H[l+124>>2];H[l+124>>2]=f;i=yb(h,28,0);H[f+8>>2]=i;if(!i){break b}b=H[l+8>>2];H[i+24>>2]=H[b+228>>2];H[b+228>>2]=i;H[f+16>>2]=-1;H[f+20>>2]=-1;H[f+12>>2]=d;H[f>>2]=k;b=e+16|0;un(b,h);H[e+316>>2]=0;H[e+308>>2]=0;H[e+312>>2]=0;H[e+300>>2]=0;H[e+304>>2]=0;H[e+292>>2]=0;H[e+296>>2]=0;H[e+136>>2]=c;H[e+132>>2]=l;H[e+288>>2]=b;H[e+264>>2]=H[k>>2];F[e+164|0]=I[k+8|0];H[e+152>>2]=H[a+136>>2];F[e+41|0]=I[a+25|0];j=zb(b);c:{if(j){b=H[k>>2];if(b){H[e>>2]=b;le(j,-1,tb(h,6889,e),-6)}b=H[k+12>>2];if(b){b=nb(h,b,0);d:{if(I[h+87|0]){break d}if(ld(e+288|0,b)){break d}c=e+16|0;o=jb(c);zc(c,b,o,16)}fb(h,b)}c=H[k+28>>2];m=Ga-48|0;Ga=m;h=d&255;b=e+16|0;g=H[b>>2];n=H[b+8>>2];q=(d|0)!=11;while(1){if(c){F[b+150|0]=q?h:I[c+1|0];d=H[c+36>>2];if(d){H[m>>2]=d;kb(n,181,2147483647,1,0,tb(g,8268,m),-6)}e:{f:{switch(I[c|0]-127|0){case 2:ko(b,an(b,c),rc(g,H[c+24>>2],0),nb(g,H[c+20>>2],0),I[b+150|0],0);Sb(n,131);break e;case 0:jo(b,an(b,c),ge(g,H[c+8>>2],0),nC(g,H[c+28>>2]),I[b+150|0],GA(g,H[c+32>>2]));Sb(n,131);break e;case 1:lo(b,an(b,c),nb(g,H[c+20>>2],0));Sb(n,131);break e;default:break f}}d=ge(g,H[c+8>>2],0);p=m+16|0;Pd(p,4,0);Sc(b,d,p);hc(g,d)}c=H[c+40>>2];continue}break}Ga=m+48|0;if(o){lb(j,o)}Sb(j,70);HA(a,e+16|0);if(!H[a+36>>2]){b=H[j+104>>2];mx(j,l+96|0);H[i+4>>2]=H[j+108>>2];H[j+104>>2]=0;H[i>>2]=b}H[i+8>>2]=H[e+60>>2];b=H[e+56>>2];H[i+20>>2]=k;H[i+12>>2]=b;H[f+16>>2]=H[e+156>>2];H[f+20>>2]=H[e+160>>2];Bu(j);break c}HA(a,e+16|0)}Zi(e+16|0);b=f}Ga=e+320|0;f=b;H[H[a>>2]+68>>2]=-1}return f}function NH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=H[a+56>>2]+((b>>>0)%K[a+52>>2]<<2)|0;a:{b:{while(1){d=H[d>>2];if(!d){break b}if(H[d+8>>2]!=(b|0)){d=d+16|0;continue}break}if(!H[d+24>>2]){break a}d=Pm(d);break a}d=0;if(!c){break a}e=H[a>>2];c:{d:{if((c|0)!=1){break d}g=H[a+48>>2]-H[a+44>>2]|0;if(g>>>0>=K[e+12>>2]|g>>>0>=K[a+32>>2]){break c}if(!Vz(a)){break d}if(g>>>0>K[a+44>>2]){break c}}if(K[a+48>>2]>=K[a+52>>2]){Yz(a)}e:{f:{g:{if(!H[a+20>>2]){break g}d=H[e+48>>2];if(J[d+14>>1]){break g}if(K[a+28>>2]>H[a+48>>2]+1>>>0){if(!Vz(a)){break g}d=H[e+48>>2]}hr(d,0);d=Pm(d);g=H[d+20>>2];if(H[g+16>>2]==H[a+16>>2]){break f}fr(d)}g=(c|0)==1;h:{i:{j:{c=H[a+60>>2];if(!c){if(H[a+48>>2]){break j}c=0;if(!(!H[17642]|K[a+28>>2]<3)){Md();c=H[17642];k:{if((c|0)>0){d=H[a+16>>2];e=d;f=d>>31;c=SK(d,f,c,0);d=Ja;break k}d=H[a+16>>2];e=d;f=d>>31;d=c>>31;d=d<<10|c>>>22;h=c<<10;c=0-h|0;d=0-(d+((h|0)!=0)|0)|0}f=SK(e,f,H[a+28>>2],0);h=Ja;e=h;e=c>>>0<f>>>0&(d|0)<=(e|0)|(d|0)<(e|0);e=xc(e?c:f,e?d:h);H[a+64>>2]=e;Ld();l:{if(!e){c=H[a+60>>2];break l}c=af(e);h=H[a+16>>2];f=(c|0)/(h|0)|0;d=H[a+60>>2];i=H[a+8>>2];while(1){c=e+i|0;H[c+28>>2]=0;H[c+16>>2]=d;H[c+12>>2]=1;H[c>>2]=e;H[c+4>>2]=c+32;e=e+h|0;d=c;f=f-1|0;if(f){continue}break}H[a+60>>2]=c}c=(c|0)!=0}if(!c){break j}c=H[a+60>>2]}H[a+60>>2]=H[c+16>>2];d=c+16|0;break i}if(g){Md()}d=Ij(H[a+16>>2]);if(g){Ld()}c=0;if(!d){break h}c=d+H[a+8>>2]|0;H[c+12>>2]=0;H[c>>2]=d;H[c+4>>2]=c+32;d=c+28|0}H[d>>2]=0;d=H[a+4>>2];H[d>>2]=H[d>>2]+1}d=c;if(d){break e}d=0;break c}H[e+16>>2]=H[e+16>>2]+(H[a+20>>2]-H[g+20>>2]|0)}H[a+48>>2]=H[a+48>>2]+1;c=H[a+52>>2];H[d+8>>2]=b;c=(b>>>0)%(c>>>0)<<2;e=H[c+H[a+56>>2]>>2];H[d+24>>2]=0;H[d+20>>2]=a;H[d+16>>2]=e;H[H[d+4>>2]>>2]=0;H[c+H[a+56>>2]>>2]=d;if(K[a+36>>2]>=b>>>0){break c}H[a+36>>2]=b}}return d|0}function Hp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Ga-112|0;Ga=e;F[a+177|0]=1;f=H[a+24>>2];H[e+100>>2]=0;H[e+96>>2]=24123;H[e+92>>2]=23263;j=(b|0)==1?8639:8658;H[e+88>>2]=j;H[e+84>>2]=j;H[e+80>>2]=13584;H[e+28>>2]=0;H[e+24>>2]=b;H[e+16>>2]=a;H[e+36>>2]=0;H[e+40>>2]=0;H[e+32>>2]=d;H[e+20>>2]=c;Ou(e+16|0,e,e+80|0,e);H[a+24>>2]=H[a+24>>2]&(f|-65);d=H[e+28>>2];a:{b:{if(d){break b}h=H[a+16>>2];i=h+(b<<4)|0;d=H[i+4>>2];if(!d){b=H[h+28>>2];G[b+78>>1]=J[b+78>>1]|1;d=0;break a}Jb(d);c:{d=H[i+4>>2];k=Pg(d);if(k){break c}d=_f(d,0,0);if(!d){break c}kg(c,a,Dg(d));break b}d=0;while(1){if((d|0)!=5){f=d+1|0;Wh(H[i+4>>2],f,(e+48|0)+(d<<2)|0);d=f;continue}break}d:{if(!(I[a+35|0]&2)){l=H[e+48>>2];f=H[e+64>>2];break d}H[e- -64>>2]=0;H[e+56>>2]=0;H[e+60>>2]=0;H[e+48>>2]=0;H[e+52>>2]=0;f=0}g=(b<<4)+h|0;d=H[g+12>>2];H[d>>2]=l;e:{f:{if(!f){break f}if(!(I[a+24|0]&64|b)){d=f&3;Kp(a,d?d:1);d=H[g+12>>2];break f}if(I[a+84|0]==(f&3)){break f}kg(c,a,12837);d=1;break e}F[d+77|0]=I[a+84|0];if(!H[d+80>>2]){f=d;d=Jl(H[e+56>>2]);d=d?d:-2e3;H[f+80>>2]=d;Lj(H[i+4>>2],d);d=H[g+12>>2]}f=H[e+52>>2];F[d+76|0]=f;g:{g=f&255;if(!g){F[d+76|0]=1;break g}if(g>>>0<5){break g}kg(c,a,3293);d=1;break e}if(!((f|0)<4|b)){c=H[a+36>>2];H[a+32>>2]=H[a+32>>2]&-3;H[a+36>>2]=c}m=e,n=Kh(H[i+4>>2]),H[m+40>>2]=n;c=H[H[a+16>>2]+(b<<4)>>2];H[e+4>>2]=j;H[e>>2]=c;c=tb(a,14231,e);f=H[a+360>>2];H[a+360>>2]=0;d=Re(a,c,5,e+16|0,0);H[a+360>>2]=f;f=H[e+28>>2];_a(a,c);h:{i:{d=d?d:f;j:{if(!d){Pu(a,b);if(I[a+87|0]){break j}break h}if(!I[a+87|0]){break i}}Yf(a);h=H[a+16>>2];d=7;break e}if(!(I[a+35|0]&8)|(d|0)==7){break e}}c=H[(H[a+16>>2]+(b<<4)|0)+12>>2];G[c+78>>1]=J[c+78>>1]|1;d=0}if(k){break b}So(H[((b<<4)+h|0)+4>>2])}if(!d){break a}if(!((d|0)!=3082&(d|0)!=7)){Mb(a)}Xj(a,b)}F[a+177|0]=0;Ga=e+112|0;return d}function qK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=H[a+24>>2];e=H[d+8>>2];f=H[d>>2];a:{b:{c:{switch(I[b|0]-167|0){case 0:case 2:a=H[d+4>>2];if(!a){break b}d=H[a>>2];d=(d|0)>0?d:0;a=a+8|0;g=1;while(1){if((c|0)==(d|0)){break a}h=H[b+28>>2];if((h|0)==H[a+40>>2]){a=0;c=H[e+32>>2];d=(c|0)>0?c:0;c=H[e+28>>2];d:{while(1){if((a|0)!=(d|0)){if((h|0)==H[c+8>>2]&J[c+16>>1]==J[b+32>>1]){break d}c=c+20|0;a=a+1|0;continue}break}a=Ga-16|0;Ga=a;k=e,l=NA(H[f>>2],H[e+28>>2],e+32|0,a+12|0),H[k+28>>2]=l;Ga=a+16|0;a=H[a+12>>2];if((a|0)<0){break d}d=H[e+28>>2]+N(a,20)|0;H[d>>2]=H[b+44>>2];h=H[b+28>>2];H[d+8>>2]=h;i=J[b+32>>1];G[d+16>>1]=i;c=H[f+44>>2]+1|0;H[f+44>>2]=c;G[d+18>>1]=65535;H[d+12>>2]=c;H[d+4>>2]=b;f=H[e+24>>2];e:{if(!f){break e}c=0;g=H[f>>2];j=(g|0)>0?g:0;f=f+8|0;while(1){if((c|0)==(j|0)){break e}g=H[f>>2];if(!(!(I[g|0]!=167|(h|0)!=H[g+28>>2])&J[g+32>>1]==(i|0))){f=f+16|0;c=c+1|0;continue}break}G[d+18>>1]=c;if(c<<16>>16>=0){break d}}c=H[e+12>>2];H[e+12>>2]=c+1;G[d+18>>1]=c}G[b+34>>1]=a;F[b|0]=169;H[b+40>>2]=e;break b}else{a=a- -64|0;c=c+1|0;continue}};case 1:break c;default:break a}}if(I[d+26|0]&2|H[a+16>>2]!=I[b+2|0]){break a}a=H[e+40>>2];while(1){f:{d=H[e+44>>2];g:{if((d|0)<=(c|0)){break g}g=H[a>>2];if((g|0)==(b|0)){break g}if(mc(0,g,b,-1)){break f}d=H[e+44>>2]}h:{if((c|0)<(d|0)){break h}c=H[f>>2];g=I[c+84|0];a=Ga-16|0;Ga=a;k=e,l=NA(c,H[e+40>>2],e+44|0,a+12|0),H[k+40>>2]=l;Ga=a+16|0;c=H[a+12>>2];if((c|0)<0){break h}h=H[e+40>>2];a=h+N(c,20)|0;H[a>>2]=b;d=H[f+44>>2]+1|0;H[f+44>>2]=d;H[a+8>>2]=d;i=H[f>>2];j=H[b+8>>2];d=H[b+20>>2];if(d){d=H[d>>2]}else{d=0}k=a,l=hf(i,j,d,g,0),H[k+4>>2]=l;a=-1;if(I[b+4|0]&4){a=H[f+40>>2];H[f+40>>2]=a+1}H[(h+N(c,20)|0)+12>>2]=a}H[b+40>>2]=e;G[b+34>>1]=c;break b}a=a+20|0;c=c+1|0;continue}}g=1}return g|0}function zn(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=Ga-16|0;Ga=j;H[j+12>>2]=0;H[j+4>>2]=0;s=H[b+12>>2];l=I[a+23|0];if(!AC(a,b)){p=zC(a,b);h=H[a>>2];k=Zc(H[b+12>>2]);q=yb(h,N(k,5)+1|0,0);a:{if(I[H[a>>2]+87|0]){break a}f=H[a+8>>2];o=(c|0)==(d|0);m=wn(a,b,3,o?0:j+12|0,q,j+4|0);F[a+23|0]=0;r=qs(a,s,j+8|0);F[a+23|0]=l;i=(k|0)>0?k:0;while(1){b:{if((e|0)==(i|0)){e=i;break b}if(H[(e<<2)+q>>2]!=(e|0)){break b}e=e+1|0;continue}break}g=r;c:{if((e|0)==(k|0)){break c}g=Cc(a,k);e=0;while(1){if((e|0)==(i|0)){break c}Xa(f,80,e+r|0,H[(e<<2)+q>>2]+g|0,0);e=e+1|0;continue}}d:{if((m|0)==5){n=jb(a);m=H[b+20>>2];e=0;h=Sd(a,H[b+12>>2]);b=0;if(!o){b=Db(a);Xa(f,102,g,g,b)}while(1){if((e|0)<H[m>>2]){l=m+(e<<4)|0;i=Mc(a,H[l+8>>2],j);e:{if(!b){break e}if(!$f(H[l+8>>2])){break e}Xa(f,102,b,i,b)}xb(a,H[j>>2]);l=f;f:{if(!((c|0)==(d|0)&(H[m>>2]-1|0)<=(e|0))){kb(f,(g|0)==(i|0)?51:53,g,n,i,h,-2);i=F[p|0];break f}kb(f,(g|0)==(i|0)?50:52,g,c,i,h,-2);i=I[p|0]|16}pb(l,i<<24>>24&65535);e=e+1|0;continue}break}if(b){Va(f,50,b,d);Yb(f,c)}lb(f,n);xb(a,b);break d}e=0;h=c;if(!o){n=jb(a);h=n}while(1){if((e|0)!=(i|0)){if(H[a+36>>2]){break a}if($f(Rg(H[b+12>>2],e))){Va(f,50,e+g|0,h)}e=e+1|0;continue}break}g:{if((m|0)==1){h=H[j+4>>2];Xa(f,29,h,c,g);b=Sb(f,8);break g}kb(f,96,g,k,0,p,k);h=H[j+4>>2];if((c|0)==(d|0)){ob(f,27,h,c,g,k);break d}b=ob(f,28,h,0,g,k)}l=b;b=H[j+12>>2];if(!(!b|(k|0)!=1)){Va(f,51,b,c)}if((c|0)==(d|0)){Yb(f,c)}if(n){lb(f,n)}m=Va(f,35,h,c);b=c;if((k|0)>=2){b=jb(a)}e=0;while(1){if((e|0)!=(i|0)){o=Db(a);n=Sd(a,Rg(s,e));Xa(f,94,h,e,o);kb(f,52,e+g|0,b,o,n,-2);xb(a,o);e=e+1|0;continue}break}Va(f,8,0,d);if((k|0)>=2){lb(f,b);Va(f,38,h,m+1|0);Va(f,8,0,c)}bb(f,l)}if((g|0)==(r|0)){break a}xb(a,g)}_a(H[a>>2],q);_a(H[a>>2],p)}Ga=j+16|0}function _w(a,b){var c=0,d=0,e=0;c=Ga-16|0;Ga=c;a:{if(H[16052]){kd(171105);break a}H[c+12>>2]=b;b:{switch(a-4|0){case 0:a=H[c+12>>2];H[c+12>>2]=a+4;a=H[a>>2];b=H[a+4>>2];H[16008]=H[a>>2];H[16009]=b;b=H[a+28>>2];H[16014]=H[a+24>>2];H[16015]=b;b=H[a+20>>2];H[16012]=H[a+16>>2];H[16013]=b;b=H[a+12>>2];H[16010]=H[a+8>>2];H[16011]=b;break a;case 1:if(!H[16008]){ax()}a=H[c+12>>2];H[c+12>>2]=a+4;b=H[16009];a=H[a>>2];H[a>>2]=H[16008];H[a+4>>2]=b;b=H[16015];H[a+24>>2]=H[16014];H[a+28>>2]=b;b=H[16013];H[a+16>>2]=H[16012];H[a+20>>2]=b;b=H[16011];H[a+8>>2]=H[16010];H[a+12>>2]=b;break a;case 5:a=H[c+12>>2];H[c+12>>2]=a+4;H[16e3]=H[a>>2];break a;case 23:a=H[c+12>>2];H[c+12>>2]=a+4;F[64008]=H[a>>2];break a;case 3:a=H[c+12>>2];H[c+12>>2]=a+4;H[16046]=H[a>>2];H[16047]=H[a+4>>2];H[c+12>>2]=a+12;H[16048]=H[a+8>>2];break a;case 20:a=H[c+12>>2];H[c+12>>2]=a+4;H[H[a>>2]>>2]=160;break a;case 14:a=H[c+12>>2];H[c+12>>2]=a+4;Ya(64100,H[a>>2],52);break a;case 15:if(!H[16027]){$w()}a=H[c+12>>2];H[c+12>>2]=a+4;Ya(H[a>>2],64100,52);break a;case 9:a=H[c+12>>2];H[c+12>>2]=a+4;H[16005]=H[a>>2];H[c+12>>2]=a+8;H[16006]=H[a+4>>2];break a;case 12:a=H[c+12>>2];H[c+12>>2]=a+4;H[16059]=H[a>>2];H[c+12>>2]=a+8;H[16060]=H[a+4>>2];break a;case 13:a=H[c+12>>2];H[c+12>>2]=a+4;F[64006]=H[a>>2];break a;case 16:a=H[c+12>>2];H[c+12>>2]=a+4;F[64007]=H[a>>2];break a;case 18:d=H[c+12>>2]+7&-8;b=H[d>>2];a=H[d+4>>2];H[16044]=0;H[16045]=0;e=b;b=!!b&(a|0)>=0|(a|0)>0;H[16042]=b?0:b?e:0;H[16043]=b?0:b?a:0;H[c+12>>2]=d+16;break a;case 21:a=H[c+12>>2];H[c+12>>2]=a+4;H[16051]=H[a>>2];break a;case 22:a=H[c+12>>2];H[c+12>>2]=a+4;H[16007]=H[a>>2];break a;case 25:a=H[c+12>>2]+7&-8;H[c+12>>2]=a+8;b=H[a+4>>2];H[16062]=H[a>>2];H[16063]=b;break;case 10:break a;default:break b}}}Ga=c+16|0}function wE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;i=Ga-16|0;Ga=i;d=12;a:{b:{switch(b-1|0){case 0:H[c>>2]=I[a+16|0];d=0;break a;case 3:H[c>>2]=H[a+20>>2];d=0;break a;case 5:H[a+40>>2]=H[c>>2];d=0;break a;case 4:b=H[c>>2];c=H[c+4>>2];h=Ga-112|0;Ga=h;c:{d:{if(H[a+40>>2]<=0){break d}d=1802;if(Ka[H[16184]](H[a+12>>2],h)|0){break c}d=H[a+40>>2];f=d;b=d+b|0;e=c;c=d>>31;d=e+c|0;d=b>>>0<f>>>0?d+1|0:d;e=b-1|0;b=d-!b|0;c=UK(e,b,f,c);f=e-c|0;j=b-(Ja+(c>>>0>e>>>0)|0)|0;b=j;c=H[h+44>>2];d=H[h+40>>2];if((b|0)<=(c|0)&d>>>0>=f>>>0|(b|0)<(c|0)){break d}b=H[h+48>>2];k=b>>31;e=UK(d,c,b,k)^-1;l=Ja^-1;c=c+k|0;d=b+d|0;c=d>>>0<b>>>0?c+1|0:c;g=e;e=d;d=g+d|0;c=c+l|0;c=d>>>0<e>>>0?c+1|0:c;e=d;m=j-!f|0;d=k+m|0;n=f-1|0;l=b+n|0;d=l>>>0<b>>>0?d+1|0:d;while(1){if((c|0)>=(d|0)&e>>>0>=l>>>0|(c|0)>(d|0)){break d}g=e>>>0<f>>>0&(c|0)<=(j|0)|(c|0)<(j|0);o=g?e:n;e=b+o|0;g=g?c:m;c=k+g|0;c=b>>>0>e>>>0?c+1|0:c;if((yw(a,o,g,29357,1)|0)==1){continue}break}d=778;break c}d=0}Ga=h+112|0;break a;case 9:ww(a,4,c);d=0;break a;case 12:ww(a,16,c);d=0;break a;case 11:H[i>>2]=H[H[a+4>>2]+16>>2];p=c,q=Hb(8310,i),H[p>>2]=q;d=0;break a;case 15:d=0;b=H[H[a+4>>2]+8>>2];b=Ib(b,b>>31);if(!b){break a}ev(H[H[a+4>>2]+8>>2],b);H[c>>2]=b;break a;case 19:p=c,q=vw(a),H[p>>2]=q;d=0;break a;case 1:case 2:case 6:case 7:case 8:case 10:case 13:case 14:case 16:case 17:case 18:break a;default:break b}}if((b|0)!=40){break a}d=0;b=Ga-48|0;Ga=b;H[c>>2]=0;a=H[a+36>>2];e:{if(!a){break e}f=H[a>>2];a=b;H[a+40>>2]=0;H[a+44>>2]=0;H[a+32>>2]=5;H[a+36>>2]=0;H[a+24>>2]=123;H[a+28>>2]=0;H[a+16>>2]=0;H[a+20>>2]=0;G[a+16>>1]=1;f=H[f+12>>2];H[a>>2]=a+16;if((Ka[H[16190]](f,5,a)|0)<0){d=3850;break e}H[c>>2]=J[b+16>>1]!=2}Ga=b+48|0}Ga=i+16|0;return d|0}function hx(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0;h=Ga-304|0;Ga=h;i=h+32|0;$a(i|4,0,148);$a(h+228|0,0,76);H[h+216>>2]=H[a+264>>2];H[a+264>>2]=i;H[h+260>>2]=e;H[h+32>>2]=a;if(I[a+87|0]){Za(h+32|0,1141,0)}if(d&1){F[h+56|0]=I[h+56|0]+1;G[a+308>>1]=0;H[a+304>>2]=H[a+304>>2]+1}F[h+57|0]=d>>>2&1;a:{b:{if(I[a+95|0]){break b}e=0;while(1){if(H[a+20>>2]<=(e|0)){break b}c:{i=H[(H[a+16>>2]+(e<<4)|0)+4>>2];if(!i){break c}Jb(i);i=Hr(i,1,1);if(!i){break c}H[h>>2]=H[H[a+16>>2]+(e<<4)>>2];te(a,i,8168,h);break a}e=e+1|0;continue}}Ym(a);d:{e:{if(!((c|0)<0|(I[(b+c|0)-1|0]?0:c))){if(H[a+124>>2]<(c|0)){break d}e=me(a,b,c,0);if(e){Vj(h+32|0,e);H[h+264>>2]=(H[h+264>>2]-e|0)+b;_a(a,e);break e}H[h+264>>2]=b+c;break e}Vj(h+32|0,b)}if(g){H[g>>2]=H[h+264>>2]}if(!I[a+177|0]){e=H[h+264>>2]-b|0;d=d&255;c=H[h+40>>2];if(c){F[c+148|0]=d;if(d<<24>>24>=0){H[c+224>>2]=0}j=c,k=me(H[c>>2],b,e,e>>31),H[j+196>>2]=k}}f:{g:{h:{if(I[a+87|0]){F[h+49|0]=0;H[h+44>>2]=7;break h}b=H[h+44>>2];if(!b|(b|0)==101){break g}}if(!(I[a+177|0]|!I[h+49|0])){b=0;e=Ga-16|0;Ga=e;c=H[h+32>>2];while(1){i:{j:{k:{l:{if(H[c+20>>2]<=(b|0)){break l}g=b<<4;d=H[(g+H[c+16>>2]|0)+4>>2];if(!d){break j}i=Pg(d);if(i){break k}f=_f(d,0,0);if(!f){break k}if((f|0)!=3082&(f|0)!=7){break l}Mb(c);H[h+44>>2]=7}Ga=e+16|0;break i}Wh(d,1,e+12|0);if(H[e+12>>2]!=H[H[(g+H[c+16>>2]|0)+12>>2]>>2]){Xj(c,b);H[h+44>>2]=17}if(i){break j}So(d)}b=b+1|0;continue}break}}b=H[h+40>>2];if(b){yf(b)}i=H[h+44>>2];b=H[h+36>>2];if(b){H[h+16>>2]=b;te(a,i,8310,h+16|0);_a(a,H[h+36>>2]);break f}Yc(a,i);break f}H[f>>2]=H[h+40>>2];H[a+64>>2]=0;H[a+68>>2]=-1;b=H[a+288>>2];if(b){dc(b)}i=0}while(1){b=H[h+156>>2];if(!b){break a}H[h+156>>2]=H[b+4>>2];_a(a,b);continue}}te(a,18,11798,0);i=nd(a,18)}Zi(h+32|0);Ga=h+304|0;return i}function qB(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f=Ga-608|0;Ga=f;g=H[a>>2];n=H[a+4>>2];m=H[n+24>>2];j=H[n+12>>2];i=H[a+8>>2];$a(f+112|0,0,56);a:{p=(H[g+4>>2]+8|0)+(I[i+16|0]<<6)|0;if(I[p+36|0]&16){break a}q=H[p+40>>2];r=N(j,48)+m|0;while(1){if(m>>>0>=r>>>0|h){break a}h=0;b:{if(!(I[m+13|0]&2)){break b}g=H[m+24>>2];if(!(H[i+8>>2]&H[g+416>>2]|H[i+12>>2]&H[g+420>>2])){break b}j=H[g+24>>2];g=H[g+12>>2];k=H[a+12>>2];H[f+176>>2]=H[a+8>>2];H[f+180>>2]=k;k=H[a+20>>2];H[f+184>>2]=H[a+16>>2];H[f+188>>2]=k;k=H[a+4>>2];H[f+168>>2]=H[a>>2];H[f+172>>2]=k;s=N(g,48)+j|0;H[f+180>>2]=f+56;g=1;while(1){c:{d:{e:{if(j>>>0<s>>>0){if(I[j+13|0]&4){h=H[j+24>>2]}else{if(H[j+20>>2]!=(q|0)){break c}h=H[n>>2];H[f+216>>2]=j;H[f+212>>2]=1;H[f+204>>2]=1;F[f+200|0]=44;H[f+196>>2]=n;H[f+192>>2]=h;h=f+192|0}G[f+56>>1]=0;H[f+172>>2]=h;f:{if(I[H[p+16>>2]+43|0]==1){h=sB(f+168|0,b,c,d,e);break f}h=rB(f+168|0,b,c)}if(!h){h=qB(f+168|0,b,c,d,e)}l=J[f+56>>1];if(!l){G[f+112>>1]=0;j=0;break e}if(g){_A(f+112|0,f+56|0);break d}_A(f,f+112|0);k=0;G[f+112>>1]=0;t=J[f>>1];while(1){if((k|0)==(t|0)){break d}o=(k<<4)+f|0;g=0;while(1){if(g>>>0<l>>>0){l=(f+56|0)+(g<<4)|0;ZA(f+112|0,H[l+8>>2]|H[o+8>>2],H[l+12>>2]|H[o+12>>2],Je(G[o+16>>1],G[l+16>>1]),Je(G[o+18>>1],G[l+18>>1]));g=g+1|0;l=J[f+56>>1];continue}break}k=k+1|0;continue}}j=J[f+112>>1]}G[i+44>>1]=1;H[H[i+52>>2]>>2]=m;g=0;G[i+18>>1]=0;H[i+40>>2]=8192;F[i+17|0]=0;H[i+32>>2]=0;H[i+36>>2]=0;H[i+24>>2]=0;H[i+28>>2]=0;j=j&65535;while(1){if(g>>>0>=j>>>0|h){break b}h=(f+112|0)+(g<<4)|0;G[i+20>>1]=J[h+16>>1]+1;G[i+22>>1]=J[h+18>>1];k=H[h+12>>2];H[i>>2]=H[h+8>>2];H[i+4>>2]=k;g=g+1|0;h=Ik(a,i);continue}}g=0}j=j+48|0;continue}}m=m+48|0;continue}}Ga=f+608|0;return h}function $q(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;j=Ga-16|0;Ga=j;h=F[d|0];a:{if((h|0)<0){uc(d,j+12|0);p=H[j+12>>2];break a}p=h&255}q=b;o=c;l=f;m=g;i=Ga-16|0;Ga=i;h=267;b:{b=i+8|0;c=yh(d,b)+d|0;k=yh(c,b)+c|0;r=d+e|0;if(k>>>0>r>>>0){break b}c=0;e=0;b=0;while(1){c:{d:{if(k>>>0<r>>>0){if(!(l|m)){h=0;break d}h=0;H[i>>2]=0;e:{if(e&1){e=F[k|0];f:{if((e|0)<0){e=uc(k,i);h=H[i>>2];break f}h=e&255;H[i>>2]=h;e=1}if((b|0)<(h|0)){break e}k=e+k|0}b=F[k|0];g:{if((b|0)<0){b=uc(k,i+4|0);break g}H[i+4>>2]=b&255;b=1}k=b+k|0;if((k-d|0)<(h|0)){break e}e=H[i+4>>2];if((e|0)>(r-k|0)|!e){break e}b=(e>>31)+(h>>31)|0;n=e+h|0;b=n>>>0<h>>>0?b+1|0:b;if((b|0)<=(s|0)&n>>>0<=t>>>0|(b|0)<(s|0)){b=c;break c}b=b<<1|n>>>31;t=n<<1;s=b;b=ye(c,t,b);if(b){break c}h=7;break d}h=267;break d}if(l){b=H[i+12>>2];H[l>>2]=H[i+8>>2];H[l+4>>2]=b}h=0;if(!m){break d}b=H[i+12>>2];H[m>>2]=H[i+8>>2];H[m+4>>2]=b}Wa(c);break b}Ya(b+h|0,k,e);c=b;b=e+h|0;h=Ob(q,c,(b|0)<(o|0)?b:o);h:{if(l){if(h|(b|0)<=(o|0)?(h|0)>=0:0){break h}n=H[i+12>>2];H[l>>2]=H[i+8>>2];H[l+4>>2]=n}l=0;if(!m|(h|0)>=0){break h}h=H[i+12>>2];H[m>>2]=H[i+8>>2];H[m+4>>2]=h;m=0}k=e+k|0;e=H[i+12>>2];h=H[i+8>>2]+1|0;e=h?e:e+1|0;H[i+8>>2]=h;H[i+12>>2]=e;e=1;continue}}Ga=i+16|0;d=h;if(!(h|(p|0)<2)){H[j+8>>2]=0;H[j+4>>2]=0;i:{j:{if(!f|!g){break j}b=H[f>>2];c=H[f+4>>2];if((b|0)==H[g>>2]&(c|0)==H[g+4>>2]){break j}d=zh(a,b,c,j+8|0,j+4|0);if(!d){d=$q(a,q,o,H[j+8>>2],H[j+4>>2],f,0)}Wa(H[j+8>>2]);f=0;H[j+8>>2]=0;if(d){break i}}b=f?f:g;d=zh(a,H[b>>2],H[b+4>>2],j+8|0,j+4|0);if(d){break i}H[j>>2]=0;d=267;b=H[j+8>>2];c=F[b|0];k:{if((c|0)<0){uc(b,j);c=H[j>>2];break k}c=c&255}if((c|0)>=(p|0)){break i}d=$q(a,q,o,b,H[j+4>>2],f,g)}Wa(H[j+8>>2])}Ga=j+16|0;return d}function PE(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{if(!a){break a}c=H[a+200>>2];if(c){break a}c=0;l=H[a+196>>2];if(!l){break a}f=Ga-16|0;Ga=f;m=a;h=H[a>>2];H[f+12>>2]=-1;c=Ib(24,0);if(c){fd(c,0,0,0,h?H[h+120>>2]:1e9)}else{c=64280}b=c;a=-1;while(1){b:{c=a;c:{d=n+l|0;g=I[d|0];if(I[b+20|0]|!g){a=c}else{i=bk(d,f+12|0);a=H[f+12>>2];if((i|0)>0){break c}}if((a|0)!=1){Bb(b,22254,1)}a=0;if(!(!b|(b|0)==64280)){a=Wd(b);Wa(b)}Ga=f+16|0;break b}k=(c|0)==183?k:c;d:{e:{f:{if(a-153>>>0<4){break f}g:{h:{i:{j:{switch(a-22|0){default:k:{switch(a-117|0){default:if((a|0)==59){break i}if((a|0)==138){break h}if((a|0)!=183){break g}break d;case 0:break f;case 1:case 2:case 3:break g;case 4:break k}}if((k|0)!=45&(k|0)!=19){break f}Bb(b,19457,5);break d;case 0:j=j+1|0;if((k|0)==49){e=H[b+16>>2];o=j}Bb(b,26665,1);break d;case 1:break j}}if(!((j|0)!=(o|0)|(e|0)<=0)){H[b+16>>2]=e+1;Bb(b,20371,5);e=0}Bb(b,26644,1);j=j-1|0;break d}c=H[b+16>>2];l:{if(F[g+30016|0]<0){e=me(h,d,i,0);H[f+8>>2]=0;if(!e){break e}Tf(e);m:{if(I[d|0]!=34){break m}g=0;d=H[m+204>>2];n:{if(!d){break n}while(1){if(!d){break n}if(ad(e,d+4|0)){d=H[d>>2];continue}break}g=1}if(!g){break m}Bb(b,21009,1);_a(h,e);break e}d=ib(e);o:{if(!((bk(e,f+8|0)|0)!=(d|0)|H[f+8>>2]!=59)){Xp(b);Bb(b,e,d);break o}H[f>>2]=e;vb(b,28182,f)}_a(h,e);break l}Xp(b);Bb(b,d,i)}while(1){if(K[b+16>>2]<=c>>>0){break e}e=H[b+4>>2]+c|0;F[e|0]=I[I[e|0]+29632|0];c=c+1|0;continue}}e=0}if(gm(g)){Xp(b)}c=H[b+16>>2];Bb(b,d,i);while(1){if(K[b+16>>2]<=c>>>0){break d}g=H[b+4>>2]+c|0;d=I[g|0];F[g|0]=d&(I[d+30016|0]^-1|223);c=c+1|0;continue}}Bb(b,21009,1);break d}e=0}n=i+n|0;continue}break}c=a;H[m+200>>2]=c}return c|0}function IB(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=H[a+8>>2];a:{e=H[a+4>>2];if(H[e+88>>2]){g=H[a>>2];b=H[a+4>>2];e=H[b+12>>2];if(e){h=H[e>>2]}c=H[a+8>>2];i=H[b+60>>2];k=jb(g);m=jb(g);l=Db(g);j=Db(g);if(h){n=Cc(g,h);d=Cc(g,h)}Va(c,135,H[b+48>>2],l);Gk(a,H[b+48>>2],n);e=b;while(1){if(e){Va(c,75,0,H[e+52>>2]);e=H[e+36>>2];continue}break}Xa(c,22,i,m,H[b+88>>2]);o=H[c+108>>2];Va(c,135,i,j);Xa(c,54,H[b+92>>2],m,j);e=I[b+20|0];b:{if((e|0)==66){break b}if((e|0)==85){Xa(c,53,l,k,j);break b}m=H[b+12>>2];if(m){p=Bf(g,m,0,0);e=I[b+20|0]}if((e|0)==94){q=Xa(c,53,l,0,j)}c:{if(p){Gk(a,i,d);Xa(c,90,d,n,h);Pc(c,p,-8);e=H[c+108>>2]+1|0;Xa(c,13,e,k,e);break c}Va(c,8,0,k)}if(!q){break b}bb(c,q)}Ir(a,b,i,0,H[a+20>>2]);lb(c,k);Va(c,38,i,o);bb(c,o-1|0);bb(c,o+1|0);xb(g,j);xb(g,l);if(h){md(g,d,h);md(g,n,h)}Wr(a,1);break a}c=H[a>>2];b=e;while(1){if(!b){break a}i=H[b+44>>2];d=H[i+32>>2];d:{e:{if(!((d|0)!=48688&(d|0)!=48698)){h=H[b+60>>2];g=jb(c);d=Db(c);Va(f,75,0,H[b+56>>2]);f:{if(H[i+32>>2]==48688){Xa(f,94,H[e+48>>2],H[b+80>>2]+1|0,d);Xr(c,d,2);break f}Va(f,71,1,d)}Xa(f,106,d,H[b+64>>2],d);Xa(f,54,H[b+64>>2]+1|0,g,d);Xa(f,29,h,0,d);Xa(f,94,h,H[b+80>>2],H[b+56>>2]);break e}if((d|0)!=48466&(d|0)!=48471){break d}j=H[H[H[b+72>>2]+20>>2]>>2];k=H[b+60>>2];g=jb(c);d=Db(c);h=H[e+48>>2];g:{if((j|0)<=2){Va(f,75,0,H[b+56>>2]);break g}Xa(f,94,h,H[b+80>>2]+2|0,H[b+56>>2])}Va(f,135,h,d);l=H[i+32>>2];h:{if((j|0)<=1){Va(f,86,d,(l|0)==48466?1:-1);break h}i=Db(c);Xa(f,94,h,H[b+80>>2]+1|0,i);Xa(f,(l|0)==48466?106:107,i,d,d);xb(c,i)}Xa(f,29,k,g,d);Xa(f,94,k,H[b+80>>2],H[b+56>>2])}lb(f,g);xb(c,d)}b=H[b+36>>2];continue}}Va(f,9,H[a+16>>2],H[a+12>>2])}function QD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;g=e+(c>>31)|0;j=c+d|0;g=j>>>0<d>>>0?g+1|0:g;a:{f=H[a+8>>2];if(!((f|0)<=0|((g|0)<=0&f>>>0>=j>>>0|(g|0)<0))){i=Ga-32|0;Ga=i;m=H[a+16>>2];n=H[a+20>>2];o=H[a+12>>2];u=H[a+8>>2];p=H[a+4>>2];v=H[a>>2];f=H[a+44>>2];H[i+24>>2]=H[a+40>>2];H[i+28>>2]=f;f=H[a+36>>2];H[i+16>>2]=H[a+32>>2];H[i+20>>2]=f;f=H[a+28>>2];H[i+8>>2]=H[a+24>>2];H[i+12>>2]=f;w=H[a+60>>2];q=H[a+48>>2];b:{c:{r=H[a+52>>2];s=H[a+56>>2];h=$a(a,0,64);g=ff(r,s,h,q,0);if(g){break c}f=p;j=o;while(1){if(j){t=f;g=(f>>31)+k|0;f=f+l|0;g=t>>>0>f>>>0?g+1|0:g;f=f>>>0>m>>>0&(g|0)>=(n|0)|(g|0)>(n|0)?m-l|0:t;g=Bc(h,j+4|0,f,l,k);if(g){break c}g=(f>>31)+k|0;l=f+l|0;g=l>>>0<f>>>0?g+1|0:g;k=g;j=H[j>>2];continue}break}vp(o);g=0;break b}$c(h);H[h+16>>2]=m;H[h+20>>2]=n;H[h+12>>2]=o;H[h+8>>2]=u;H[h+4>>2]=p;H[h>>2]=v;f=H[i+28>>2];H[h+40>>2]=H[i+24>>2];H[h+44>>2]=f;f=H[i+20>>2];H[h+32>>2]=H[i+16>>2];H[h+36>>2]=f;f=H[i+12>>2];H[h+24>>2]=H[i+8>>2];H[h+28>>2]=f;H[h+60>>2]=w;H[h+56>>2]=s;H[h+52>>2]=r;H[h+48>>2]=q}Ga=i+32|0;k=g;if(g){break a}return Bc(a,b,c,d,e)|0}d:{if(!!d&(e|0)>=0|(e|0)>0){if((d|0)==H[a+16>>2]&(e|0)==H[a+20>>2]){break d}aw(a,d,e);break d}if(d|e){break d}d=H[a+12>>2];if(!d){break d}Ya(d+4|0,b,c);break a}j=a+12|0;while(1){if((c|0)<=0){break a}d=H[a+24>>2];e=H[a+4>>2];g=UK(H[a+16>>2],H[a+20>>2],e,e>>31);e:{if(g){f=d;break e}f=Ub(e+4|0);if(!f){return 3082}H[f>>2]=0;H[(d?d:j)>>2]=f;H[a+24>>2]=f}d=e-g|0;d=(c|0)<(d|0)?c:d;Ya((f+g|0)+4|0,b,d);e=H[a+20>>2]+(d>>31)|0;f=d+H[a+16>>2]|0;e=f>>>0<d>>>0?e+1|0:e;H[a+16>>2]=f;H[a+20>>2]=e;c=c-d|0;b=b+d|0;continue}}return k|0}function Rr(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;h=Ga-16|0;Ga=h;d=H[a+44>>2];a:{if(d){break a}d=10;if(uf(400)){break a}b:{if(I[a+17|0]<3){break b}c:{if(!fA(a,1)){lr(H[a+96>>2]);break c}d:{if(H[a+232>>2]){H[h+12>>2]=0;d=jr(H[a+228>>2]);if(!d){sd(a,1,h+12|0,0);d=H[h+12>>2];H[d+16>>2]=0}d=Zz(a,d,H[a+28>>2],1);rd(H[h+12>>2]);if(d){break d}gr(H[a+228>>2]);break d}e=Ga-16|0;Ga=e;if(!(I[a+19|0]|!H[a+28>>2])){f=sd(a,1,e+12|0,0);e:{if(f){break e}f=_b(H[e+12>>2]);if(f){break e}zp(H[e+12>>2]);F[a+19|0]=1;f=0}rd(H[e+12>>2])}Ga=e+16|0;d=f;if(d){break a}d=0;f=0;i=Ga-16|0;Ga=i;f:{if(!b|I[a+5|0]==4){break f}j=H[a+68>>2];if(!H[j>>2]){break f}F[a+20|0]=1;while(1){e=F[b+f|0];if(e){f=f+1|0;k=e+k|0;continue}break}g:{if(!I[a+8|0]){g=H[a+80>>2];e=H[a+84>>2];break g}g=Ul(a);H[a+80>>2]=g;e=Ja;H[a+84>>2]=e}d=qi(j,g,e,H[a+164>>2]);if(d){break f}g=g+4|0;e=g>>>0<4?e+1|0:e;d=Bc(H[a+68>>2],b,f,g,e);if(d){break f}d=f+g|0;e=d>>>0<f>>>0?e+1|0:e;g=d;d=qi(H[a+68>>2],d,e,f);if(d){break f}d=e;j=g+4|0;d=j>>>0<4?d+1|0:d;d=qi(H[a+68>>2],j,d,k);if(d){break f}d=g+8|0;e=d>>>0<8?e+1|0:e;d=Bc(H[a+68>>2],31988,8,d,e);if(d){break f}d=f+20|0;e=d+H[a+80>>2]|0;f=H[a+84>>2];H[a+80>>2]=e;H[a+84>>2]=d>>>0>e>>>0?f+1|0:f;d=Nd(H[a+68>>2],i+8|0);if(d){break f}d=0;f=H[a+84>>2];e=H[i+12>>2];g=H[a+80>>2];if((f|0)>=(e|0)&g>>>0>=K[i+8>>2]|(e|0)<(f|0)){break f}d=sf(H[a+68>>2],g,f)}Ga=i+16|0;if(d){break a}d=Sz(a,0);if(d){break a}d=Oz(a,jr(H[a+228>>2]));if(d){break a}gr(H[a+228>>2]);f=H[a+28>>2];if(f>>>0>K[a+36>>2]){d=ar(a,f-((f|0)==H[a+164>>2])|0);if(d){break a}}if(c){break c}d=Or(a,b)}if(d){break a}}if(H[a+232>>2]){break b}F[a+17|0]=5}d=0}Ga=h+16|0;return d}function Cz(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;a:{b:{c=H[b+72>>2];if(c){c=c+H[b+76>>2]|0}else{c=H[b+40>>2]}if(!(H[b+40>>2]+H[b+44>>2]>>>0>c>>>0?c:0)){c=H[b+56>>2];if(c){a=H[c>>2];Wa(H[b+40>>2]);H[b+40>>2]=0;if(!a){break a}e=H[a+8>>2];f=H[e>>2];d=H[b+64>>2];c=H[a+16>>2];if((c|0)>=H[b+68>>2]){Wa(d);h=(c<<1)+2|0;d=Ub(h);H[b+64>>2]=d;if(!d){break b}H[b+68>>2]=h}Ya(d,H[a+12>>2],c);d=0;F[c+H[b+64>>2]|0]=0;H[b+60>>2]=c;a=f+1|0;c=Ub(a);if(!c){break b}c=Ya(c,H[e+4>>2],a);H[b+72>>2]=c;H[b+44>>2]=a;H[b+76>>2]=a;H[b+40>>2]=c;H[b+56>>2]=H[b+56>>2]+4;break a}_q(b);c=H[b+36>>2];e=H[b+20>>2];f=H[b+32>>2];if((c|0)>=(e|0)&f>>>0>=K[b+16>>2]|(c|0)>(e|0)){break a}d=f+1|0;c=d?c:c+1|0;H[b+32>>2]=d;H[b+36>>2]=c;d=zh(a,d,c,b+40|0,b+44|0);if(d){break a}c=H[b+40>>2]}d=Nm(b,c,20);if(d){break a}a=F[c|0];c:{if((a|0)<0){a=uc(c,g+12|0);break c}H[g+12>>2]=a&255;a=1}d=a+c|0;a=F[d|0];d:{if((a|0)<0){a=uc(d,g+8|0);c=H[g+8>>2];break d}c=a&255;H[g+8>>2]=c;a=1}e:{if((c|0)<=0){break e}f=a+d|0;if(((H[b+40>>2]+H[b+44>>2]|0)-f|0)<(c|0)){break e}e=H[g+12>>2];if((e|0)>H[b+60>>2]){break e}a=e>>31;d=c+e|0;a=d>>>0<c>>>0?a+1|0:a;h=H[b+68>>2];i=d>>>0>h>>>0;h=h>>31;if(i&(h|0)<=(a|0)|(a|0)>(h|0)){a=a<<1|d>>>31;d=d<<1;a=ye(H[b+64>>2],d,a);if(!a){break b}H[b+68>>2]=d;H[b+64>>2]=a}d=Nm(b,f,c+10|0);if(d){break a}Ya(e+H[b+64>>2]|0,f,c);H[b+60>>2]=c+e;d=c+f|0;a=F[d|0];f:{if((a|0)<0){a=uc(d,b+76|0);c=H[b+76>>2];break f}c=a&255;H[b+76>>2]=c;a=1}H[b+80>>2]=0;a=a+d|0;H[b+72>>2]=a;if((H[b+40>>2]+(H[b+44>>2]-a|0)|0)<(c|0)){break e}if(!H[b+48>>2]){d=267;if(I[(a+c|0)-1|0]){break a}}d=c?0:267;break a}d=267;break a}d=7}Ga=g+16|0;return d}function sJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{d=H[c+4>>2];b:{if((gb(d)|0)==5){break b}if((b|0)==3){if((gb(H[c+8>>2])|0)==5){break b}}n=gb(H[c>>2]);f=ac(d);d=H[c>>2];c:{if((n|0)==4){j=bc(d);g=nf(H[c>>2]);if(!g){break b}break c}g=cb(d);if(!g){break b}if((f|0)>=0){break c}e=g;while(1){i=I[e|0];if(!i){break c}d=e+1|0;e=d;if(i>>>0>=192){while(1){e=d;d=d+1|0;if((I[e|0]&192)==128){continue}break}}j=j+1|0;continue}}d:{if((b|0)==3){c=ac(H[c+8>>2]);b=c>>31;b=(b^c)-b|0;k=(c|0)>=0;h=0;break d}k=1;b=H[Gc(a)+120>>2];h=b>>31}d=f>>31;e:{if((f|0)<0){c=d+(j>>31)|0;d=c+1|0;e=c;c=f+j|0;e=c>>>0<f>>>0?d:e;if((e|0)>0|(e|0)>=0){break e}d=e+h|0;b=b+c|0;f=b>>>0<c>>>0?d+1|0:d;c=0;e=0;d=!!b&(f|0)>=0|(f|0)>0;b=d?b:0;h=d?f:0;break e}if(f){c=f-1|0;e=d-!f|0;break e}c=0;e=0;d=b;f=!!d&(h|0)>=0|(h|0)>0;b=d-f|0;h=h-(d>>>0<f>>>0)|0}d=c-b|0;i=e-((b>>>0>c>>>0)+h|0)|0;f=!!d&(i|0)>=0|(i|0)>0;d=k?c:f?d:0;l=k?e:f?i:0;m=c;c=(i|0)<0;b=k?b:c?m:b;h=k?h:c?e:h;if((n|0)!=4){while(1){c=I[g|0];if(!c|!(d|l)){break a}e=g+1|0;g=e;if(c>>>0>=192){while(1){g=e;e=e+1|0;if((I[g|0]&192)==128){continue}break}}c=d;d=c-1|0;l=l-!c|0;continue}}i=d+g|0;c=j-d|0;f=j>>31;g=f-((d>>>0>j>>>0)+l|0)|0;e=!!c&(g|0)>=0|(g|0)>0;k=e?c:0;m=b;c=b+d|0;b=h+l|0;b=c>>>0<d>>>0?b+1|0:b;b=c>>>0>j>>>0&(f|0)<=(b|0)|(b|0)>(f|0);c=b?k:m;b=b?e?g:0:h;f:{if(!b&c>>>0>=2147483648|b){Gx(i,-1,a);break f}gk(a,i,c,0,-1)}}return}d=g;while(1){if(!(!(c&255)|!(b|h))){e=d+1|0;g:{if((c&255)>>>0>191){while(1){d=e;e=d+1|0;c=I[d|0];if((c&192)==128){continue}break g}}c=I[e|0];d=e}e=b;b=b-1|0;h=h-!e|0;continue}break}b=a;a=d-g|0;$p(b,g,a,a>>31,-1)}function Pp(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Ga-16|0;Ga=h;H[h+12>>2]=0;a:{while(1){b:{c:{d:{g=I[b|0];switch(g-174|0){case 1:break a;case 2:break b;case 0:break c;default:break d}}if((g|0)!=181){break a}}b=H[b+12>>2];continue}break}g=I[b+2|0]}e:{f:{g:{h:{i:{if((g|0)!=173){if((g|0)!=36){j=29357;k=1;break i}f=nl(H[b+8>>2],0)&255;i=Pp(a,H[b+12>>2],c,f,e);a=H[e>>2];if(!a){break e}Wu(a,f,c);Uh(H[e>>2],d,c);break e}j=24062;k=-1;l=-1;j:{b=H[b+12>>2];g=I[b|0];switch(g-153|0){case 0:case 2:break i;default:break j}}a=Pp(a,b,c,d,h+12|0);f=H[h+12>>2];if(a|!f){break h}Fu(f);b=J[f+16>>1];k:{if(b&8){M[f>>3]=-M[f>>3];break k}a=H[f>>2];g=H[f+4>>2];if(!a&(g|0)==-2147483648){H[f>>2]=0;H[f+4>>2]=1138753536;G[f+16>>1]=b&62016|8;break k}H[f>>2]=0-a;H[f+4>>2]=0-(g+((a|0)!=0)|0)}Uh(f,d,c);break h}l:{m:{n:{o:{p:{switch(g-153|0){case 1:break m;case 0:case 2:break o;default:break p}}switch(g-117|0){case 4:break n;case 0:break o;case 1:case 2:case 3:break h;default:break l}}f=Tg(a);if(!f){break g}q:{if(I[b+5|0]&8){a=H[b+8>>2];Xc(f,SK(k,l,a,a>>31),Ja);break q}H[h+4>>2]=H[b+8>>2];H[h>>2]=j;b=tb(a,5750,h);if(!b){break f}xn(f,b,1)}Uh(f,(d|0)==65?(g&253)==153?67:d:d,1);a=J[f+16>>1];if(a&44){G[f+16>>1]=a&65533}if((c|0)==1){break h}i=be(f,c);break h}f=Tg(a);H[h+12>>2]=f;if(!f){break g}dc(f);break h}f=Tg(a);H[h+12>>2]=f;if(!f){break g}c=H[b+8>>2]+2|0;b=ib(c)-1|0;oe(f,Gt(a,c,b),(b|0)/2|0,0,0,1);break h}if((g|0)!=170){break h}f=Tg(a);H[h+12>>2]=f;if(!f){f=0;break h}G[f+16>>1]=4;H[f>>2]=!I[H[b+8>>2]+4|0];H[f+4>>2]=0}H[e>>2]=f;break e}f=0}Mb(a);_a(a,0);id(f);i=7}Ga=h+16|0;return i}function Qy(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Ga-48|0;Ga=d;H[d+44>>2]=H[a>>2];g=H[b>>2];H[d+40>>2]=g;H[d+36>>2]=H[c>>2];while(1){a:{b:{c:{d:{e:{f:{g:{f=I[g|0];h:{i:{if(!f){e=H[d+36>>2];if(!I[e|0]){break e}e=2147483647;break i}e=0;if((f|0)!=1){break i}e=F[g+1|0];j:{if((e|0)<0){uc(g+1|0,d+32|0);e=H[d+32>>2];break j}e=e&255}if(!e){break h}}f=2147483647;k:{h=H[d+36>>2];switch(I[h|0]){case 1:break k;case 0:break f;default:break g}}f=F[h+1|0];l:{if((f|0)<0){uc(h+1|0,d+28|0);f=H[d+28>>2];break l}f=f&255}if(f){break f}}f=267;break a}f=0}if((e|0)!=(f|0)){break c}H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0;e=Pq(d+44|0,e);H[d+36>>2]=e+h;H[d+40>>2]=e+g;Ii(d+40|0,d+16|0);Ii(d+36|0,d+8|0);e=H[d+20>>2];g=H[d+16>>2];if((e|0)>=0&g>>>0>=2|(e|0)>0){h=H[d+8>>2];f=H[d+12>>2];if(h>>>0>1&(f|0)>=0|(f|0)>0){break d}}e=H[d+36>>2];g=H[d+40>>2]}h=H[d+44>>2];H[d+44>>2]=h+1;f=0;F[h|0]=0;H[a>>2]=H[d+44>>2];H[b>>2]=g+1;H[c>>2]=e+1;break a}while(1){i=g>>>0<h>>>0&(e|0)<=(f|0)|(e|0)<(f|0);Py(d+44|0,d,i?g:h,i?e:f);i=H[d>>2];j=H[d+4>>2]-(i>>>0<2)|0;H[d>>2]=i-2;H[d+4>>2]=j;m:{if((g|0)==(h|0)&(e|0)==(f|0)){Em(d+40|0,d+16|0);Em(d+36|0,d+8|0);break m}if(g>>>0<h>>>0&(e|0)<=(f|0)|(e|0)<(f|0)){Em(d+40|0,d+16|0);break m}Em(d+36|0,d+8|0)}g=H[d+16>>2];e=H[d+20>>2];h=H[d+8>>2];f=H[d+12>>2];if((g|0)!=-1|(e|0)!=2147483647|((h|0)!=-1|(f|0)!=2147483647)){continue}break}break b}if((e|0)<(f|0)){f=d+44|0;k=d,l=Pq(f,e)+g|0,H[k+40>>2]=l;Wf(f,d+40|0);break b}e=d+44|0;k=d,l=Pq(e,f)+h|0,H[k+36>>2]=l;Wf(e,d+36|0)}g=H[d+40>>2];continue}break}Ga=d+48|0;return f}function Kz(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Ga-16|0;Ga=i;f=H[H[a>>2]+12>>2];g=H[a+100>>2];e=H[a+96>>2]+1|0;g=e?g:g+1|0;H[a+96>>2]=e;H[a+100>>2]=g;g=H[a+108>>2];h=H[a+104>>2];e=h+1|0;c=(e|0)<(g|0)?g:e;a:{b:{while(1){h=h+1|0;if((g|0)<=(h|0)){break b}d=H[a+112>>2]+(h<<4)|0;e=H[d+4>>2];if(!H[d>>2]&(e|0)<=0|(e|0)<0){continue}break}H[a+104>>2]=h;g=0;break a}H[a+104>>2]=c;g=Li(f,a+4|0);if((g|0)==100){l=H[a+52>>2];m=H[a+56>>2];c:{e=H[a+76>>2];if(!e){break c}g=0;d=e;e=H[a+80>>2];h=H[a+48>>2];f=Ob(d,H[a+44>>2],(e|0)<(h|0)?e:h);if(f|(e|0)>=(h|0)?(f|0)>=0:0){break c}H[a+88>>2]=1;break a}g=7;if(Jz(a,2)){break a}h=0;$a(H[a+112>>2],0,H[a+108>>2]<<4);f=0;e=0;while(1){if((h|0)<(m|0)){H[i+8>>2]=0;H[i+12>>2]=0;n=qd(h+l|0,i+8|0);d:{e:{f:{g:{h:{switch(b|0){case 2:c=H[i+8>>2];d=H[i+12>>2];break g;case 0:f=H[a+112>>2];b=H[f+4>>2];c=H[f>>2]+1|0;b=c?b:b+1|0;H[f>>2]=c;H[f+4>>2]=b;b=1;f=0;break d;case 1:break h;default:break f}}b=H[i+12>>2];d=b;c=H[i+8>>2];if(c>>>0<2&(b|0)<=0|(b|0)<0){break g}j=H[a+112>>2];b=H[j+20>>2];k=H[j+16>>2]+1|0;b=k?b:b+1|0;H[j+16>>2]=k;H[j+20>>2]=b}if(!d&c>>>0<=1){b=0;if(c-1|0){break d}b=3;break d}b=H[a+112>>2];d=b+(f<<4)|0;j=d+24|0;c=H[d+28>>2];d=H[d+24>>2]+1|0;c=d?c:c+1|0;H[j>>2]=d;H[j+4>>2]=c;c=H[b+12>>2];d=H[b+8>>2]+1|0;c=d?c:c+1|0;H[b+8>>2]=d;H[b+12>>2]=c;break e}f=H[i+8>>2];if((f|0)<=0){e=267;break d}if(Jz(a,f+2|0)){break a}c=H[a+112>>2]+(f<<4)|0;d=c+16|0;b=H[c+20>>2];c=H[c+16>>2]+1|0;b=c?b:b+1|0;H[d>>2]=c;H[d+4>>2]=b}b=2}h=h+n|0;continue}break}H[a+104>>2]=0;g=e;break a}H[a+88>>2]=1}Ga=i+16|0;return g|0}function zt(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=Ga-32|0;Ga=m;n=H[a>>2];j=H[a+236>>2];a:{if(!j|I[a+208|0]==1){break a}b:{if(!b){h=1;f=G[j+34>>1];if((f|0)<=0){break a}if(!d|H[d>>2]==1){break b}e=H[H[j+4>>2]+N(f-1|0,12)>>2];H[m+20>>2]=c;H[m+16>>2]=e;Za(a,18312,m+16|0);break a}if(!d){h=H[b>>2];break b}h=H[d>>2];if((h|0)==H[b>>2]){break b}Za(a,13496,0);break a}k=(H[c+4>>2]+(h<<3)|0)+37|0;f=0;c:{if(!d){break c}l=H[d>>2];l=(l|0)>0?l:0;while(1){if((g|0)==(l|0)){break c}o=ib(H[((g<<4)+d|0)+12>>2])+1|0;k=o+k|0;f=k>>>0<o>>>0?f+1|0:f;g=g+1|0;continue}}f=yb(n,k,f);if(!f){break a}H[f>>2]=j;H[f+4>>2]=H[j+48>>2];g=(f+(h<<3)|0)+36|0;H[f+8>>2]=g;if(I[a+208|0]>=2){Ne(a,g,c)}k=Ya(g,H[c>>2],H[c+4>>2]);F[k+H[c+4>>2]|0]=0;Tf(k);l=H[c+4>>2];H[f+20>>2]=h;d:{e:{if(b){o=(h|0)>0?h:0;while(1){if((i|0)==(o|0)){break e}g=0;c=G[j+34>>1];q=(c|0)>0?c:0;c=(i<<4)+b|0;while(1){if((g|0)==(q|0)){break d}p=H[c+12>>2];if(hb(H[H[j+4>>2]+N(g,12)>>2],p)){g=g+1|0;continue}break}c=(f+(i<<3)|0)+36|0;H[c>>2]=g;if(I[a+208|0]>=2){od(a,c,p)}i=i+1|0;continue}}H[f+36>>2]=G[j+34>>1]-1}f:{if(!d){break f}c=(k+l|0)+1|0;k=(h|0)>0?h:0;g=0;while(1){if((g|0)==(k|0)){break f}l=(g<<4)+d|0;i=H[l+12>>2];h=ib(i);H[(f+(g<<3)|0)+40>>2]=c;if(I[a+208|0]>=2){od(a,c,i);i=H[l+12>>2]}c=Ya(c,i,h)+h|0;F[c|0]=0;g=g+1|0;c=c+1|0;continue}}F[f+25|0]=e;F[f+24|0]=0;F[f+26|0]=e>>>8;a=td(H[j+60>>2]+56|0,H[f+8>>2],f);if((a|0)==(f|0)){Mb(n);i=f;break a}if(a){H[f+12>>2]=a;H[a+16>>2]=f}H[j+48>>2]=f;i=0;break a}H[m>>2]=H[c+12>>2];Za(a,9698,m);i=f}_a(n,i);qb(n,b);qb(n,d);Ga=m+32|0}function Hm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ga-16|0;Ga=g;c=H[a>>2];a:{b:{if(!b){f=1;break b}j=H[c>>2];c:{if(j-3>>>0<=1){d=b<<2;i=Ib(d,0);if(!i){f=7;break b}k=$a(i,0,d);e=c;while(1)if(H[e>>2]!=(j|0)){H[g+12>>2]=e;m=b-1|0;d=0;d:{e:{while(1){h=H[e+8>>2];H[e+8>>2]=0;i=0;if(h){H[h+12>>2]=0;i=c}f:{f=Hm(g+12|0,m);if(!f){e=0;c=H[g+12>>2];while(1){if(!(!c|(b|0)<=(e|0))){l=(e<<2)+k|0;f=H[l>>2];g:{if(!f){f=c;c=0;break g}H[d+16>>2]=c;H[d+12>>2]=f;H[f+8>>2]=d;H[c+8>>2]=d;n=H[d+8>>2];f=0;H[d+8>>2]=0;c=d;d=n}H[l>>2]=f;e=e+1|0;continue}break}if(!c){break f}of(c);f=18}e=0;b=(b|0)>0?b:0;while(1){if((b|0)==(e|0)){break e}of(H[(e<<2)+k>>2]);e=e+1|0;continue}}if(h){c=h+16|0;while(1){e=H[c>>2];c=e+12|0;if(H[e>>2]==(j|0)){continue}break}H[g+12>>2]=e;c=H[h+16>>2];H[c+8>>2]=H[h+8>>2];f=H[h+8>>2];if(f){H[f+12>>2]=c;c=i}H[h+8>>2]=d;d=h;continue}break}f=0;i=(b|0)>0?b:0;c=0;e=0;while(1){if((e|0)==(i|0)){break d}h=(e<<2)+k|0;b=H[h>>2];if(b){h:{if(!c){c=b;break h}H[d+16>>2]=c;b=H[h>>2];H[d+12>>2]=b;H[b+8>>2]=d;H[c+8>>2]=d;c=d;d=H[c+8>>2]}H[c+8>>2]=0}e=e+1|0;continue}}while(1){if(d){b=H[d+8>>2];Wa(d);d=b;continue}break}c=i}Wa(k);break c}else{e=H[e+12>>2];continue}}if((j|0)!=2){break a}i=H[c+12>>2];H[g+8>>2]=i;d=H[c+16>>2];H[g+4>>2]=d;H[c+12>>2]=0;H[c+16>>2]=0;H[i+8>>2]=0;H[d+8>>2]=0;i:{b=b-1|0;f=Hm(g+8|0,b);if(!f){f=Hm(g+4|0,b);if(!f){break i}d=H[g+4>>2]}of(d);of(H[g+8>>2]);break c}b=H[g+8>>2];H[c+12>>2]=b;H[b+8>>2]=c;b=H[g+4>>2];H[c+16>>2]=b;H[b+8>>2]=c;f=0}if(f){break b}f=0;break a}of(c);c=0}H[a>>2]=c;Ga=g+16|0;return f}function qo(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;j=Ga-32|0;Ga=j;h=H[a>>2];a:{b:{if(!(!I[h+177|0]|H[h+172>>2]!=1)){i=I[h+176|0];c=Xb(h,(i|0)==1?8639:8658);H[j+28>>2]=b;break b}b=ig(a,b,c,j+28|0);if((b|0)<0){break a}c:{if(!d){i=b;break c}i=1;if(!H[c+4>>2]|(b|0)==1){break c}Za(a,15448,0);break a}b=H[j+28>>2];c=vc(h,b);if(I[a+208|0]<2){break b}c=Ne(a,c,b)}k=H[b+4>>2];H[a+188>>2]=H[b>>2];H[a+192>>2]=k;if(!c){break a}d:{if(gl(a,c,e?1810:13584,c)){break d}d=I[h+176|0]==1?1:d;k=H[H[h+16>>2]+(i<<4)>>2];if(cc(a,18,(d|0)==1?8639:8658,0,k)){break d}if(!f){if(cc(a,I[(d+(e<<1)|0)+48400|0],c,0,k)){break d}}e:{f:{if(I[a+208|0]){break f}d=H[H[h+16>>2]+(i<<4)>>2];if(kf(a)){break d}k=Dc(h,c,d);if(k){if(g){break e}d=I[k+43|0];H[j+20>>2]=b;H[j+16>>2]=(d|0)==2?1810:13584;Za(a,3475,j+16|0);break d}if(!Ff(h,c,d)){break f}H[j>>2]=c;Za(a,6677,j);break d}b=yb(h,64,0);if(!b){H[a+12>>2]=7;H[a+36>>2]=H[a+36>>2]+1;break d}G[b+32>>1]=65535;H[b>>2]=c;c=H[(H[h+16>>2]+(i<<4)|0)+12>>2];G[b+38>>1]=200;H[b+24>>2]=1;H[b+60>>2]=c;H[a+236>>2]=b;if(I[h+177|0]){break a}b=zb(a);if(!b){break a}Gd(a,1,i);if(f){Sb(b,170)}c=H[a+44>>2];d=c+2|0;H[a+92>>2]=d;g=c+1|0;H[a+88>>2]=g;c=c+3|0;H[a+44>>2]=c;Xa(b,99,i,c,2);ze(b,i);k=db(b,15,c);Xa(b,100,i,2,H[h+32>>2]&2?1:4);Xa(b,100,i,5,I[h+84|0]);bb(b,k);g:{if(e|f){Va(b,71,0,d);break g}l=a,m=Xa(b,147,i,d,1),H[l+132>>2]=m}d=zb(a);Dd(a,i,1,1,8658);ob(d,113,0,1,i,5);if(!H[a+40>>2]){H[a+40>>2]=1}Va(b,127,0,g);kb(b,77,6,c,0,48404,-1);Xa(b,128,0,c,g);pb(b,8);Sb(b,122);break a}Fd(a,i);el(a)}F[a+17|0]=1;_a(h,c)}Ga=j+32|0}function Jo(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Ga-80|0;Ga=g;i=H[b+44>>2];H[g+60>>2]=0;h=a+400|0;j=H[b+48>>2];a:{b:{while(1){f=H[h>>2];if(!f){break b}h=f+8|0;if(H[f+4>>2]!=(b|0)){continue}break}H[g+48>>2]=H[b>>2];n=e,o=tb(a,6972,g+48|0),H[n>>2]=o;h=6;break a}h=7;l=Xb(a,H[b>>2]);if(!l){break a}f=Ad(28,0);c:{if(!f){Mb(a);break c}F[f+17|0]=1;H[f+4>>2]=c;H[f>>2]=a;n=H[b+48>>2],o=H[H[a+16>>2]+(Lb(a,H[b+60>>2])<<4)>>2],H[n+4>>2]=o;H[g+64>>2]=f;H[g+68>>2]=b;h=H[a+400>>2];H[g+76>>2]=0;H[g+72>>2]=h;H[a+400>>2]=g- -64;h=Ka[d|0](a,H[c+12>>2],i,j,f+8|0,g+60|0)|0;H[a+400>>2]=H[g+72>>2];if(h){if((h|0)==7){Mb(a)}b=H[g+60>>2];d:{if(!b){H[g>>2]=l;n=e,o=tb(a,8070,g),H[n>>2]=o;break d}H[g+16>>2]=b;n=e,o=tb(a,8310,g+16|0),H[n>>2]=o;Wa(H[g+60>>2])}_a(a,f);break c}h=0;d=H[f+8>>2];if(!d){break c}H[d>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[H[f+8>>2]>>2]=H[c>>2];h=1;H[c+8>>2]=H[c+8>>2]+1;H[f+12>>2]=1;if(!H[g+76>>2]){H[g+32>>2]=H[b>>2];n=e,o=tb(a,8198,g+32|0),H[n>>2]=o;bh(f);break c}H[f+24>>2]=H[b+52>>2];H[b+52>>2]=f;d=0;c=0;while(1){if((d|0)<G[b+34>>1]){h=0;m=N(d,12);i=_l(m+H[b+4>>2]|0,29357);j=ib(i);e=(j|0)>0?j:0;e:{f:{while(1){if((e|0)==(h|0)){break f}g:{f=h+i|0;if(!(Fb(10738,f,6)|(I[f-1|0]!=32?h:0))){k=I[f+6|0];if((k|32)==32){break g}}h=h+1|0;continue}break}c=k?7:6;e=h;while(1){k=c+e|0;if((j|0)>=(k|0)){F[e+i|0]=I[i+k|0];e=e+1|0;continue}break}if(!(I[f|0]|!h)){F[f-1|0]=0}c=H[b+4>>2]+m|0;G[c+10>>1]=J[c+10>>1]|2;c=1024;e=2;break e}e=c}H[b+28>>2]=e|H[b+28>>2];d=d+1|0;continue}break}h=0}_a(a,l)}Ga=g+80|0;return h}function _t(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;m=J[a+18>>1];p=J[a+24>>1];n=m+(p<<1)|0;c=H[H[a+52>>2]+40>>2];a:{b:{g=H[a+56>>2];h=g+I[a+9|0]|0;if(I[h+7|0]>(b|0)){k=c-4|0;break b}k=c-4|0;i=I[h+2|0]|I[h+1|0]<<8;if((k|0)<(i|0)){return ab(68384)}if(!i){break b}b=g+i|0;e=I[b|0]<<8|I[b+1|0];if((e|0)>(k|0)){return ab(68387)}if(e){d=g+e|0;if(I[d|0]|I[d+1|0]){break b}}f=I[h+6|0]|I[h+5|0]<<8;if(f>>>0>=i>>>0){return ab(68395)}d=I[b+3|0]|I[b+2|0]<<8;b=i+d|0;c:{d:{if(e){if(b>>>0>e>>>0){return ab(68398)}j=g+e|0;j=I[j+2|0]<<8|I[j+3|0];if((c|0)>=(e+j|0)){break d}return ab(68400)}if((b|0)<=(c|0)){break c}return ab(68404)}vd((b+j|0)+g|0,b+g|0,e-b|0);d=d+j|0}l=g+n|0;b=f+d|0;vd(g+b|0,f+g|0,i-f|0);f=g+m|0;while(1){if(f>>>0<l>>>0){c=d;k=I[f+1|0]|I[f|0]<<8;e:{if(k>>>0>=i>>>0){c=j;if(e>>>0<=k>>>0){break e}}c=c+k|0;c=c<<8|(c&65280)>>>8;F[f|0]=c;F[f+1|0]=c>>>8}f=f+2|0;continue}break}d=I[h+7|0];break a}i=I[h+6|0]|I[h+5|0]<<8;r=c-i|0;s=g+i|0;d=g;b=c;while(1){if((f|0)!=(p|0)){l=((f<<1)+m|0)+g|0;e=I[l|0]<<8|I[l+1|0];if(!(e>>>0>=i>>>0&(e|0)<=(k|0))){return ab(68433)}o=Ka[H[a+76>>2]](a,e+d|0)|0;b=b-o|0;if((i|0)<=(b|0)&(c|0)>=(e+o|0)){q=b<<8|(b&65280)>>>8;F[l|0]=q;F[l+1|0]=q>>>8;f:{if(!j){j=0;if((b|0)==(e|0)){break f}d=H[H[H[a+52>>2]>>2]+224>>2];Ya(i+d|0,s,r);j=d}Ya(b+g|0,e+d|0,o)}f=f+1|0;continue}else{return ab(68439)}}break}F[h+7|0]=0;d=0}c=H[a+20>>2];a=b-n|0;if((c|0)!=(a+d|0)){return ab(68458)}F[h+1|0]=0;F[h+2|0]=0;b=b<<8|(b&65280)>>>8;F[h+5|0]=b;F[h+6|0]=b>>>8;$a(g+n|0,0,a);return 0}function mc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;if(!(c?b:0)){return((b|0)!=(c|0))<<1}a:{b:{if(!(!a|I[b|0]!=156)){e=Ga-16|0;Ga=e;H[e+12>>2]=0;bm(H[a>>2],c,1,65,e+12|0);i=H[e+12>>2];if(i){g=G[b+32>>1];ls(H[a+8>>2],g);h=tC(H[a+228>>2],g);if(h){if((gb(h)|0)==3){cb(h)}g=!bi(h,i,0)}else{g=0}id(i);id(h)}Ga=e+16|0;if(g){break b}}h=H[c+4>>2];g=H[b+4>>2];i=h|g;if(i&2048){if(!(h&g&2048)){break a}if(H[b+8>>2]==H[c+8>>2]){break b}break a}e=I[b|0];f=I[c|0];if(!((e|0)!=71&(f|0)==(e|0))){if((e|0)==113){f=1;if((mc(a,H[b+12>>2],c,d)|0)<2){break b}f=I[c|0]}if((f|0)!=113){break a}f=1;if((mc(a,b,H[c+12>>2],d)|0)>=2){break a}break b}j=H[b+8>>2];c:{if(!j){break c}d:{e:{switch(e-168|0){default:if((e|0)==113){break d}f=0;if((e|0)==121){break b}case 1:case 2:case 3:k=H[c+8>>2];if(!k|(e|0)==167|(e|0)==169){break c}f=2;if(!ad(j,k)){break c}break b;case 0:case 4:break e}}f=2;if(hb(j,H[c+8>>2])){break b}e=g&16777216;if((h>>>24&1)!=(e>>>24|0)){break b}if(!e){break c}if(vC(a,H[b+44>>2],H[c+44>>2],1)){break b}h=H[c+4>>2];g=H[b+4>>2];break c}f=2;if(Qb(j,H[c+8>>2])){break b}}f=2;if((h^g)&1028){break b}f:{if(i&65536){break f}if(i&4096){break b}if(!(i&32)){if(mc(a,H[b+12>>2],H[c+12>>2],d)){break b}}if(mc(a,H[b+16>>2],H[c+16>>2],d)){break b}if(dg(H[b+20>>2],H[c+20>>2],d)){break b}a=I[b|0];if(i&16384|((a|0)==117|(a|0)==170)){break f}if((a|0)==175&I[b+2|0]!=I[c+2|0]|J[b+32>>1]!=J[c+32>>1]){break b}if((a|0)==49){break f}a=H[b+28>>2];if((a|0)==(d|0)){break f}if((a|0)!=H[c+28>>2]){break b}}f=0}return f}return 2}function Jj(a,b,c){var d=0,e=0,f=0,g=0;a:{if(I[a+17|0]<=1){e=0;if(I[a+18|0]<2){break a}}Gv(a);e=H[a+68>>2];b:{if(!H[e>>2]){break b}if(lp(e)){$c(e);break b}c:{d:{e:{f:{d=I[a+5|0];switch(d-1|0){case 0:break d;case 2:break f;default:break e}}d=0;g:{if(!(H[a+80>>2]|H[a+84>>2])){break g}d=sf(e,0,0);if(d){break g}d=0;if(!I[a+8|0]){break g}d=Ge(H[a+68>>2],I[a+10|0])}H[a+80>>2]=0;H[a+84>>2]=0;break b}if(!I[a+4|0]|(d|0)==5){break c}}b=b?1:I[a+12|0]!=0;e=Ga-16|0;Ga=e;h:{if(!(H[a+80>>2]|H[a+84>>2])){b=0;break h}f=H[a+68>>2];g=H[a+176>>2];d=H[a+180>>2];i:{if(!(!b&(g|d)!=0)){b=sf(f,0,0);break i}b=Bc(f,32e3,28,0,0)}if(b){break h}b=0;if(!I[a+7|0]){b=Ge(H[a+68>>2],I[a+10|0]|16)}if(!g&(d|0)<=0|(d|0)<0|b){break h}b=Nd(H[a+68>>2],e+8|0);if(b){break h}b=0;f=H[e+12>>2];if((d|0)>=(f|0)&g>>>0>=K[e+8>>2]|(d|0)>(f|0)){break h}b=sf(H[a+68>>2],g,d)}Ga=e+16|0;d=b;H[a+80>>2]=0;H[a+84>>2]=0;break b}b=I[a+12|0];$c(e);d=0;if(b){break b}d=Pe(H[a>>2],H[a+188>>2],I[a+9|0])}ug(H[a+60>>2]);H[a+48>>2]=0;H[a+60>>2]=0;if(!d){j:{k:{if(!I[a+15|0]){if(!fA(a,c)){break k}}gr(H[a+228>>2]);break j}e=H[a+228>>2];b=e;while(1){b=H[b>>2];if(b){G[b+28>>1]=J[b+28>>1]&65523;b=b+32|0;continue}break}H[e+8>>2]=H[e+4>>2]}Fv(H[a+228>>2],H[a+28>>2])}b=H[a+232>>2];l:{if(b){pp(b);break l}if(!c|d){break l}d=0;b=H[a+28>>2];if(b>>>0>=K[a+36>>2]){break l}d=ar(a,b)}if(!(!c|d)){b=Ah(H[a+64>>2],22,0);d=(b|0)==12?0:b}b=0;m:{if(I[a+4|0]){break m}c=H[a+232>>2];if(c){b=0;if(!kp(c,0)){break m}}b=ch(a,1)}F[a+20|0]=0;F[a+17|0]=1;e=d?d:b}return e}function Vy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Ga-144|0;Ga=h;m=H[b+20>>2];$a(h+16|0,0,128);f=H[b+8>>2];i=H[b+12>>2];g=H[a+24>>2];H[h+8>>2]=c;H[h+12>>2]=((i|0)!=0)<<5|(f?11:3)|((c|0)<(g|0))<<2;H[h>>2]=H[b>>2];H[h+4>>2]=H[b+4>>2];c=xk(a,m,h);while(1){a:{b:{c:{d:{if(c){break d}c=Li(a,m);if((c|0)==100){break a}if(c){break d}l=h+16|0;f=0;j=0;k=0;i=Ga-16|0;Ga=i;e:{f:{while(1){if((k|0)!=16){g=l+(k<<2)|0;c=H[g>>2];g:{if(!c){break g}if(!f){j=H[g- -64>>2];H[g>>2]=0;f=c;break g}c=Ry(I[a+239|0],c,H[g- -64>>2],f,j,i+8|0,i+12|0);if(c){break f}Wa(H[g>>2]);Wa(f);H[g>>2]=0;j=H[i+12>>2];f=H[i+8>>2]}k=k+1|0;continue}break}H[l+64>>2]=j;H[l>>2]=f;c=0;break e}Wa(f)}Ga=i+16|0;if(!c){break c}}a=0;while(1){if((a|0)==16){break b}Wa(H[(h+16|0)+(a<<2)>>2]);a=a+1|0;continue}}H[e>>2]=H[h+16>>2];H[d>>2]=H[h+80>>2];c=0}Sq(m);H[b+20>>2]=0;Ga=h+144|0;return c}i=H[m+48>>2];c=H[m+52>>2];g=0;j=Ga-16|0;Ga=j;h:{i:{k=h+16|0;if(H[k>>2]){f=i;while(1){if((g|0)==16){break i}l=k+(g<<2)|0;n=H[l>>2];if(!n){H[l>>2]=f;H[(k+(g<<2)|0)- -64>>2]=c;break i}o=n;n=l- -64|0;c=Ry(I[a+239|0],f,c,o,H[n>>2],j+12|0,j+8|0);if(c){if((f|0)==(i|0)){break h}Wa(f);break h}if((f|0)!=(i|0)){Wa(f)}Wa(H[l>>2]);H[l>>2]=0;c=H[j+8>>2];f=H[j+12>>2];if((g|0)==15){H[l>>2]=f;H[n>>2]=c}g=g+1|0;continue}}f=Ub(c+11|0);H[k+64>>2]=c;H[k>>2]=f;if(!f){c=7;break h}Ya(f,i,c);f=H[k>>2]+c|0;F[f|0]=0;F[f+1|0]=0;F[f+2|0]=0;F[f+3|0]=0;F[f+4|0]=0;F[f+5|0]=0;F[f+6|0]=0;F[f+7|0]=0;c=0;F[f+8|0]=0;F[f+9|0]=0;break h}c=0}Ga=j+16|0;continue}}function rn(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Ga-48|0;Ga=f;h=H[a>>2];Qf(f+24|0);a:{if(!b){a=0;i=0;break a}i=H[b>>2];a=(i|0)<32767?i:32767;i=yb(h,N(i,12),0)}G[c>>1]=a;H[d>>2]=i;m=(a|0)>0?a:0;j=i;while(1){b:{c:{d:{e:{f:{g:{if((k|0)!=(m|0)){if(!I[h+87|0]){break g}m=k}Uf(f+24|0);if(!I[h+87|0]){break e}a=0;while(1){if((a|0)==(m|0)){break f}_a(h,H[N(a,12)+i>>2]);a=a+1|0;continue}}l=(k<<4)+b|0;n=l+8|0;g=H[l+12>>2];if(I[l+17|0]&3?0:g){break d}a=jd(H[n>>2]);while(1){e=I[a|0];if((e|0)!=141){h:{i:{if((e|0)!=59){if(I[a+7|0]&3|(e|0)!=167){break h}e=H[a+44>>2];if(!e){break h}j:{a=G[a+32>>1];if((a|0)>=0){break j}a=G[e+32>>1];if((a|0)>=0){break j}g=14302;break d}a=H[e+4>>2]+N(a&65535,12)|0;break i}a=a+8|0}g=H[a>>2]}if(!g){break c}break d}else{a=H[a+16>>2];continue}}}_a(h,i);H[d>>2]=0;G[c>>1]=0}Ga=f+48|0;return}if($s(g)){break c}e=Xb(h,g);break b}H[f+16>>2]=k+1;e=tb(h,15767,f+16|0)}H[f+44>>2]=0;while(1){k:{if(!e){break k}a=Wc(f+24|0,e);if(!a){break k}if(I[a+9|0]&128){G[j+10>>1]=J[j+10>>1]|1024}o=ib(e);a=o;if((a|0)<=0){a=0}else{while(1){l:{if((a|0)<=1){g=I[e|0];a=0;break l}a=a-1|0;g=I[e+a|0];if(g-58>>>0>4294967285){continue}}break}a=(g&255)==58?a:o}H[f>>2]=a;H[f+4>>2]=e;a=H[f+44>>2]+1|0;H[f+44>>2]=a;H[f+8>>2]=a;e=tb(h,1837,f);if(K[f+44>>2]<4){continue}Oe(4,f+44|0);continue}break}H[j>>2]=e;p=j,q=Ug(e),F[p+7|0]=q;if(F[l+18|0]&1){G[j+10>>1]=J[j+10>>1]|1024}m:{if(!e){break m}if((td(f+24|0,e,n)|0)!=(n|0)){break m}Mb(h)}j=j+12|0;k=k+1|0;continue}}function MB(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=Ga-224|0;Ga=e;f=H[a+116>>2];a:{if(I[(f?f:a)+207|0]!=2){break a}h=H[c+80>>2];f=H[h+40>>2];if(f&8192|d&32){break a}k=I[c+60|0];g=((k<<6)+b|0)+8|0;i=H[a>>2];j=f&48;c=1;b:{if(j){break b}if(!(f&1024)){c=1;if(J[h+24>>1]){break b}}c=(d&3)!=0}l=H[a+8>>2];d=e+200|0;fd(d,i,e+96|0,100,1e9);H[e+80>>2]=c?19513:19292;F[e+221|0]=1;H[e+84>>2]=g;vb(d,18551,e+80|0);c:{if(!(f&1280)){g=H[h+32>>2];d:{if(!(((I[g+55|0]|I[g+56|0]<<8)&3)==2?I[H[((k<<6)+b|0)+24>>2]+28|0]&128:0)){d=17934;if(f&131072){break d}d=17967;if(f&16384){break d}d=f&64?6810:6819;break d}d=17868;if(!c){break c}}c=e+200|0;Bb(c,29172,7);H[e>>2]=H[g>>2];vb(c,d,e);d=c;g=0;i=Ga-16|0;Ga=i;j=H[h+32>>2];c=J[h+46>>1];f=J[h+24>>1];if(I[h+40|0]&48?1:f){Bb(d,26664,2);while(1){if((f|0)!=(g|0)){m=Kr(j,g);if(g){Bb(d,29202,5)}H[i>>2]=m;vb(d,c>>>0>g>>>0?24244:20253,i);g=g+1|0;continue}break}c=f;g=H[h+40>>2];if(g&32){SA(d,j,J[h+26>>1],f,f,21038);g=H[h+40>>2];c=1}if(g&16){SA(d,j,J[h+28>>1],f,c,21075)}Bb(d,26644,1)}Ga=i+16|0;break c}if(!(!(f&256)|!(f&15))){H[e+64>>2]=14302;vb(e+200|0,6004,e- -64|0);c=61;e:{if(f&5){break e}if((j|0)==48){H[e+48>>2]=14302;vb(e+200|0,6917,e+48|0);c=60;break e}c=f&32?62:60}H[e+32>>2]=c;vb(e+200|0,25249,e+32|0);break c}if(!(f&1024)){break c}c=H[h+24>>2];H[e+20>>2]=H[h+32>>2];H[e+16>>2]=c;vb(e+200|0,5802,e+16|0)}if(I[((k<<6)+b|0)+44|0]&8){vb(e+200|0,19248,0)}b=Wd(e+200|0);kb(l,185,H[l+108>>2],H[a+220>>2],0,b,-6)}Ga=e+224|0}function qC(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=Ga+-64|0;Ga=e;f=H[a+8>>2];d=H[b+4>>2];a:{if(!(H[a+52>>2]|d&64)){if(d&33554432){h=Sb(f,14);if(I[b+5|0]&16){H[e+16>>2]=H[H[b+20>>2]+16>>2];qc(a,0,16700,e+16|0)}Va(f,9,H[b+48>>2],H[b+44>>2]);Va(f,115,c,H[b+28>>2]);bb(f,h);break a}H[b+4>>2]=d|33554432;h=H[a+44>>2]+1|0;H[a+44>>2]=h;H[b+48>>2]=h;n=b,o=Va(f,74,0,h)+1|0,H[n+44>>2]=o;h=Sb(f,14)}i=H[b+12>>2];g=Zc(i);H[b+28>>2]=c;m=Va(f,118,c,g);j=Sg(H[a>>2],g,1);d=H[b+20>>2];b:{if(I[b+5|0]&16){k=H[d+28>>2];H[e+4>>2]=H[d+16>>2];H[e>>2]=h?29357:29208;qc(a,1,16681,e);if((g|0)!=H[k>>2]){break b}Pd(e+32|0,11,c);n=e,o=zC(a,b),H[n+52>>2]=o;H[d+8>>2]=0;c=ge(H[a>>2],d,0);d=H[a>>2];c:{if(!I[d+87|0]){d=Sc(a,c,e+32|0);hc(H[a>>2],c);_a(H[a>>2],H[e+52>>2]);if(d){break c}c=0;d=(g|0)>0?g:0;while(1){if((c|0)==(d|0)){break b}n=(c<<2)+j|0,o=vg(a,Rg(i,c),H[(k+(c<<4)|0)+8>>2]),H[n+20>>2]=o;c=c+1|0;continue}}hc(d,c);_a(H[a>>2],H[e+52>>2])}Fj(j);break a}if(!d){break b}g=Lc(i);F[e+32|0]=g;d:{if((g|0)<=64){F[e+32|0]=65;break d}if((g|0)!=69){break d}F[e+32|0]=67}if(j){n=j,o=Sd(a,H[b+12>>2]),H[n+20>>2]=o}i=d+8|0;g=Db(a);k=Db(a);d=H[d>>2];while(1){if((d|0)>0){l=H[i>>2];e:{if(h){if(Me(l)){break e}ue(f,h-1|0);ue(f,h);H[b+4>>2]=H[b+4>>2]&-33554433}h=0}oc(a,l,g);kb(f,97,g,1,k,e+32|0,1);ob(f,138,c,k,g,1);i=i+16|0;d=d-1|0;continue}break}xb(a,g);xb(a,k)}if(j){le(f,m,j,-8)}if(!h){break a}bb(f,h);Xa(f,67,H[b+48>>2],H[b+44>>2],1);lj(a)}Ga=e- -64|0}function Xh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=Ga-16|0;Ga=j;a:{b:{if(I[a|0]){break b}h=I[a+1|0];if(!(h&2)){break b}g=H[a+32>>2];f=H[a+36>>2];if((g|0)==(b|0)&(f|0)==(c|0)){f=0;H[e>>2]=0;break a}if((c|0)<=(f|0)&b>>>0<=g>>>0|(c|0)<(f|0)){break b}if(h&8){H[e>>2]=-1;f=0;break a}g=g+1|0;f=g?f:f+1|0;if((b|0)!=(g|0)|(c|0)!=(f|0)){break b}H[e>>2]=0;f=ek(a);if((f|0)==101){break b}if(f){break a}ii(a);f=0;if((b|0)==H[a+32>>2]&H[a+36>>2]==(c|0)){break a}}f=ng(a);if((f|0)!=16){if(f){break a}o=1-d|0;while(1){i=H[a+116>>2];l=J[i+24>>1];k=l-1|0;g=k>>o;p=I[i+2|0];m=H[i+64>>2];n=J[i+26>>1];q=H[i+68>>2];h=0;c:{d:{e:{f:{while(1){d=(g<<1)+m|0;f=((I[d|0]<<8|I[d+1|0])&n)+q|0;g:{if(!p){break g}while(1){d=f+1|0;if(F[f|0]>=0){f=d;break g}f=d;if(f>>>0<K[i+60>>2]){continue}break}f=ab(72507);break a}mi(f,j+8|0);h:{f=H[j+8>>2];d=H[j+12>>2];i:{if(f>>>0<b>>>0&(d|0)<=(c|0)|(c|0)>(d|0)){h=g+1|0;if((g|0)<(k|0)){break i}d=-1;break e}if((c|0)>=(d|0)&b>>>0>=f>>>0|(c|0)>(d|0)){break h}if((g|0)<=(h|0)){break f}k=g-1|0}g=h+k>>1;continue}break}G[a+70>>1]=g;if(!I[i+8|0]){h=g;break d}H[a+32>>2]=f;H[a+36>>2]=d;f=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]|2;H[e>>2]=0;break a}d=1}if(!I[i+8|0]){break d}G[a+70>>1]=g;H[e>>2]=d;f=0;break c}d=H[i+56>>2];j:{if((h|0)>=(l|0)){d=eb((d+I[i+9|0]|0)+8|0);break j}f=(h<<1)+m|0;d=eb(d+((I[f|0]<<8|I[f+1|0])&n)|0)}G[a+70>>1]=h;f=mg(a,d);if(!f){continue}}break}G[a+50>>1]=0;break a}H[e>>2]=-1;f=0}Ga=j+16|0;return f}function Oq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;h=Ga-16|0;Ga=h;e=H[b>>2];H[h+12>>2]=e;if(!e){a:{if(!H[a+28>>2]){break a}g=Jm(0,a);H[h+12>>2]=g;if(g){break a}c=Ga-32|0;Ga=c;b:{if(!H[a+28>>2]){break b}n=a+28|0;l=H[a>>2];r=H[l+36>>2];s=H[r>>2];t=ed(H[a+12>>2],0);u=Ja;while(1){g=H[l+24>>2];o=g;j=g>>31;e=d;c:{while(1){if((f|0)>=(j|0)&i>>>0>=o>>>0|(f|0)>(j|0)|e){break c}if(I[i+H[l+32>>2]|0]){g=i+1|0;f=g?f:f+1|0;i=g;e=0;continue}break}d=i+1|0;g=d?f:f+1|0;o=d;d=lf(H[a+12>>2],d);H[c+24>>2]=0;d=Ig(r,H[a+20>>2],d,-1,c+24|0);p=H[c+24>>2];d:while(1){if(!d){H[c+16>>2]=0;H[c+12>>2]=0;H[c+8>>2]=0;H[c+4>>2]=0;d=Ka[H[s+20>>2]](p,c+20|0,c+16|0,c+12|0,c+8|0,c+4|0)|0;H[c+28>>2]=d;e=n;while(1){k=H[e>>2];if(!k|d){continue d}m=H[k>>2];d=0;e=H[k+4>>2];e:{if((e|0)<H[l+24>>2]&((e|0)!=(i|0)|(f|0)!=0)){break e}q=H[c+4>>2];if(q?H[m+12>>2]:0){break e}e=H[c+16>>2];j=H[m+4>>2];if((e|0)!=(j|0)&(!H[m+8>>2]|(e|0)<=(j|0))){break e}if(Ob(H[c+20>>2],H[m>>2],j)){break e}Jy(k+12|0,t,u,i,f,q,q>>31,c+28|0);d=H[c+28>>2]}e=k+8|0;continue}}break}if(p){Ka[H[s+16>>2]](p)|0}if((d|0)==101){H[c+28>>2]=0;d=0}i=o;f=g;continue}break}while(1){f=H[n>>2];if(!f|d){break b}if(H[f+12>>2]){d=uk(f+12|0,0,0)}else{d=0}n=f+8|0;continue}}Ga=c+32|0;H[h+12>>2]=d}f=wh(a,H[a+16>>2],h+12|0);a=a+28|0;while(1){a=H[a>>2];if(a){Wa(H[a+12>>2]);H[a+12>>2]=0;a=a+8|0;continue}break}e=H[h+12>>2];H[b>>2]=e;d=!f}Ga=h+16|0;return!e&d}function jA(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;c=H[a+20>>2];a:{if(I[c+17|0]==2){b=H[c+44>>2];if(!b){b:{c:{if(H[c+232>>2]|I[c+5|0]==2){break c}e=H[c>>2];d=Pj(H[c+28>>2]);H[c+60>>2]=d;b=7;if(!d){break b}b=H[c+68>>2];d:{e:{if(H[b>>2]){break e}if(I[c+5|0]==4){wp(0,0,b,0,-1);break e}f=H[16007];d=I[c+12|0];b=hw(c);if(b){break d}b=wp(e,H[c+188>>2],H[c+68>>2],d?4110:2054,d?f:0);if(b){break d}}H[c+80>>2]=0;H[c+84>>2]=0;F[c+20|0]=0;H[c+48>>2]=0;H[c+88>>2]=0;H[c+92>>2]=0;b=bw(c);if(!b){break c}}ug(H[c+60>>2]);H[c+80>>2]=0;H[c+84>>2]=0;H[c+60>>2]=0;break b}F[c+17|0]=3;b=0}}if(b){break a}}Ml(a);b=H[c+60>>2];f:{if(!b){break f}e=b;b=H[a+24>>2];if(Tl(e,b)){break f}if(b>>>0<=K[c+32>>2]){d=H[a+20>>2];g=H[d+80>>2];b=H[d+84>>2];e=b;f=H[a+4>>2];h=Cv(d,f);G[a+28>>1]=J[a+28>>1]|8;b=qi(H[d+68>>2],g,b,H[a+24>>2]);g:{if(b){break g}b=e;e=g+4|0;b=e>>>0<4?b+1|0:b;g=e;e=b;b=Bc(H[d+68>>2],f,H[d+168>>2],g,b);if(b){break g}b=H[d+172>>2]+e|0;e=g;g=H[d+168>>2];f=e+g|0;b=qi(H[d+68>>2],f,f>>>0<g>>>0?b+1|0:b,h);if(b){break g}H[d+48>>2]=H[d+48>>2]+1;f=H[d+80>>2];e=f+H[d+168>>2]|0;b=H[d+172>>2]+H[d+84>>2]|0;b=e>>>0<f>>>0?b+1|0:b;e=e+8|0;b=e>>>0<8?b+1|0:b;H[d+80>>2]=e;H[d+84>>2]=b;b=lh(H[d+60>>2],H[a+24>>2])|xp(d,H[a+24>>2])}if(!b){break f}break a}if(I[c+17|0]==4){break f}G[a+28>>1]=J[a+28>>1]|8}G[a+28>>1]=J[a+28>>1]|4;if(H[c+104>>2]<=0){b=0}else{b=Um(a)}a=H[a+24>>2];if(a>>>0<=K[c+28>>2]){break a}H[c+28>>2]=a}return b}function xl(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;j=Ga-16|0;Ga=j;H[j+12>>2]=0;a:{b:{if(!I[a+12|0]){n=d+2|0;if((n|0)<=H[a+20>>2]){break b}}c:{if(!e){e=c;break c}Ya(e,c,d)}if(f){Cb(e,f)}c=I[a+12|0];F[a+12|0]=c+1;H[((c<<2)+a|0)+36>>2]=e;G[((c<<1)+a|0)+28>>1]=b;break a}e=_b(H[a+72>>2]);if(e){H[g>>2]=e;break a}m=H[a+56>>2];k=Ga-16|0;Ga=k;o=H[a+56>>2];e=I[a+9|0];H[k+12>>2]=0;d:{e:{h=e+o|0;i=I[h+5|0]<<8|I[h+6|0];l=J[a+18>>1]+(J[a+24>>1]<<1)|0;if(i>>>0>=l>>>0){break e}if(!i){i=65536;if(H[H[a+52>>2]+40>>2]==65536){break e}}e=ab(68587);break d}f:{g:{if(!I[h+2|0]){e=l+2|0;if(!I[h+1|0]){break f}if(e>>>0<=i>>>0){break g}break f}e=l+2|0;if(i>>>0<e>>>0){break f}}e=$t(a,d,k+12|0);if(e){h=e-o|0;H[j+12>>2]=h;e=0;if((h|0)>(l|0)){break d}e=ab(68605);break d}e=H[k+12>>2];if(e){break d}e=l+2|0}if((d+e|0)>(i|0)){e=(H[a+20>>2]-d|0)-2|0;e=_t(a,(e|0)<4?e:4);if(e){break d}i=((I[h+6|0]|I[h+5|0]<<8)-1&65535)+1|0}e=i-d|0;i=e<<8|(e&65280)>>>8;F[h+5|0]=i;F[h+6|0]=i>>>8;H[j+12>>2]=e;e=0}Ga=k+16|0;if(e){H[g>>2]=e;break a}H[a+20>>2]=H[a+20>>2]-(n&65535);e=H[j+12>>2];h:{if(f){h=e+m|0;Ya(h+4|0,c+4|0,d-4|0);Cb(h,f);break h}Ya(e+m|0,c,d)}d=H[a+64>>2]+(b<<1)|0;vd(d+2|0,d,J[a+24>>1]-b<<1);b=e<<8|(e&65280)>>>8;F[d|0]=b;F[d+1|0]=b>>>8;G[a+24>>1]=J[a+24>>1]+1;d=I[a+9|0]+m|0;b=I[d+4|0]+1|0;F[d+4|0]=b;if((b|0)!=(b&255)){b=I[a+9|0]+m|0;F[b+3|0]=I[b+3|0]+1}if(!I[H[a+52>>2]+17|0]){break a}Hl(a,a,c,g)}Ga=j+16|0}function au(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;e=Ga-16|0;Ga=e;H[e+12>>2]=0;a:{if(!(c>>>0>=2&K[a+48>>2]>=c>>>0)){d=ab(73436);break a}g=H[a+12>>2];b:{if(b){H[e+8>>2]=b;d=H[b+72>>2];G[d+30>>1]=J[d+30>>1]+1;d=H[d+12>>2];H[d+12>>2]=H[d+12>>2]+1;break b}b=bu(a,c);H[e+8>>2]=b}d=_b(H[g+72>>2]);H[e+4>>2]=d;c:{if(d){break c}d=H[g+56>>2]+36|0;f=eb(d);Cb(d,f+1|0);if(I[a+24|0]&4){if(!b){d=xd(a,c,e+8|0,0);if(d){break c}b=H[e+8>>2]}d=_b(H[b+72>>2]);H[e+4>>2]=d;if(d){break c}$a(H[b+56>>2],0,H[H[b+52>>2]+36>>2])}if(I[a+17|0]){Jd(a,c,2,0,e+4|0);d=H[e+4>>2];if(d){break c}}d:{if(!f){break d}i=eb(H[g+56>>2]+32|0);e:{if(i>>>0>K[a+48>>2]){a=ab(73483);break e}d=xd(a,i,e+12|0,0);if(d){break c}h=H[e+12>>2];f=eb(H[h+56>>2]+4|0);d=H[a+40>>2]>>>2|0;if(f>>>0>d-2>>>0){a=ab(73494);break e}if(d-8>>>0<=f>>>0){break d}d=_b(H[h+72>>2]);if(d){break c}Cb(H[h+56>>2]+4|0,f+1|0);Cb((H[h+56>>2]+(f<<2)|0)+8|0,c);if(!(!b|I[a+24|0]&4)){f:{f=H[b+72>>2];d=H[f+20>>2];if(I[d+12|0]){break f}b=J[f+28>>1];if(H[d+104>>2]|!(b&2)){break f}G[f+28>>1]=b&65515|16}}g:{h:{b=H[a+64>>2];if(b){break h}b=Pj(H[a+48>>2]);H[a+64>>2]=b;if(b){break h}a=7;break g}if(K[b>>2]>=c>>>0){a=lh(b,c)}else{a=0}}}d=a;H[e+4>>2]=d;break c}if(!b){d=xd(a,c,e+8|0,0);if(d){break c}b=H[e+8>>2]}d=_b(H[b+72>>2]);if(d){break c}Cb(H[b+56>>2],i);d=0;Cb(H[b+56>>2]+4|0,0);Cb(H[g+56>>2]+32|0,c)}a=H[e+8>>2];if(a){F[a|0]=0}Gb(a);Gb(H[e+12>>2])}Ga=e+16|0;return d}function Uy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=Ga-16|0;Ga=g;a:{if(!d){Wa(H[b>>2]);H[b>>2]=0;H[b+4>>2]=0;d=0;break a}f=H[b+44>>2];if((f|0)<0){H[b+4>>2]=e;H[b>>2]=d;d=0;break a}l=H[b>>2];if(!l){Wa(d);d=0;break a}b:{if((c|0)>(f|0)){m=H[b+4>>2];H[g+8>>2]=e;H[g+12>>2]=d;d=c-f|0;break b}H[g+12>>2]=l;H[g+8>>2]=H[b+4>>2];l=d;m=e;d=f-c|0}j=I[a+239|0];e=d;f=Ga-48|0;Ga=f;H[f+40>>2]=0;H[f+44>>2]=0;H[f+32>>2]=0;H[f+36>>2]=0;H[f+24>>2]=0;H[f+28>>2]=0;k=H[g+8>>2];a=H[g+12>>2];H[f+20>>2]=l;H[f+16>>2]=a;H[f+8>>2]=0;d=a;c:{d:{if(!j){break d}d=k>>31;h=k+10|0;d=h>>>0<10?d+1|0:d;d=Ib(h,d);if(d){break d}e=7;break c}H[f+12>>2]=d;m=l+m|0;Ee(f+20|0,m,0,f+40|0);k=a+k|0;Ee(f+16|0,k,0,f+32|0);while(1){if(!(!H[f+20>>2]|!H[f+16>>2])){h=H[f+40>>2];n=H[f+32>>2];o=H[f+44>>2];i=H[f+36>>2];i=(i|0)<=(o|0)&h>>>0>n>>>0|(i|0)<(o|0)?1:(h|0)!=(n|0)|(o|0)!=(i|0)?-1:0;i=j?0-i|0:i;if(!i){i=H[f+8>>2];n=H[f+24>>2];q=H[f+28>>2];r=H[f+12>>2];p=f+12|0;Fm(p,j,f+24|0,f+8|0,h,o);if(!Hi(p,e,0,1,f+20|0,f+16|0)){H[f+24>>2]=n;H[f+28>>2]=q;H[f+12>>2]=r;H[f+8>>2]=i}Ee(f+20|0,m,j,f+40|0);Ee(f+16|0,k,j,f+32|0);continue}if((i|0)<0){h=f+20|0;Fe(0,h);Ee(h,m,j,f+40|0)}else{h=f+16|0;Fe(0,h);Ee(h,k,j,f+32|0)}continue}break}H[g+8>>2]=H[f+12>>2]-d;e=0;if(!j){break c}Wa(a);H[g+12>>2]=d}Ga=f+48|0;Wa(l);H[b>>2]=H[g+12>>2];H[b+4>>2]=H[g+8>>2];d=e}if(H[b+44>>2]<(c|0)){H[b+44>>2]=c}Ga=g+16|0;return d}function GG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=H[c+28>>2]+N(N(H[c+4>>2],b),12)|0;b=0;d=H[c>>2];j=H[d>>2];a:{if(!(!I[a+34|0]|H[H[a+8>>2]>>2]==1)){while(1){if(H[j+24>>2]<=(b|0)){break a}a=N(b,12)+h|0;c=H[d+64>>2];H[a+8>>2]=c;H[a+4>>2]=c;b=b+1|0;continue}}f=Ga-16|0;Ga=f;H[f+12>>2]=0;c=a;b:{if(H[c+40>>2]){break b}l=H[d+32>>2];m=H[d+36>>2];i=H[d>>2];while(1){e=c;c=H[e+8>>2];if(H[c>>2]==1?c:0){continue}break}k=I[e+32|0];n=H[e+24>>2];o=H[e+28>>2];c=e;while(1){if(c){p=H[c>>2]!=5?H[c+16>>2]:c;g=Ib(N(H[i+24>>2],12),0);H[p+40>>2]=g;if(g){$a(g,0,N(H[i+24>>2],12));c=H[c+12>>2];continue}else{g=7;break b}}break}ym(d,e,f+12|0);while(1){g=H[f+12>>2];if(!(g|I[d+6|0])){while(1){if(!I[d+7|0]){rb(H[d+12>>2])}wd(d,e,f+12|0);c=I[e+32|0];H[d+88>>2]=1;F[d+7|0]=1;F[d+6|0]=c;g=H[e+28>>2];H[d+32>>2]=H[e+24>>2];H[d+36>>2]=g;if(!(H[e>>2]!=1|c)){if(Oq(d,f+12|0)){continue}}break}if(H[f+12>>2]|I[d+6|0]){continue}ly(e,H[i+24>>2]);continue}break}H[d+32>>2]=l;H[d+36>>2]=m;F[d+6|0]=0;if(k){F[e+32|0]=k;break b}ym(d,e,f+12|0);while(1){wd(d,e,f+12|0);if(I[e+32|0]){H[f+12>>2]=267;g=267}else{g=H[f+12>>2]}if(H[e+24>>2]==(n|0)&(o|0)==H[e+28>>2]){break b}if(!g){continue}break}}Ga=f+16|0;if(g){break a}g=0;while(1){if(H[j+24>>2]<=(b|0)){break a}c=N(b,12);e=c+4|0;f=e+h|0;d=e;e=H[a+40>>2];H[f>>2]=H[d+e>>2];c=c+8|0;H[c+h>>2]=H[c+e>>2];b=b+1|0;continue}}return g|0}function dH(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c=1;a:{if(H[a+56>>2]){break a}H[b+40>>2]=0;H[b+44>>2]=1095963344;H[b+20>>2]=0;c=H[b>>2];m=(c|0)>0?c:0;h=-1;f=-1;i=-1;e=-1;c=0;while(1){b:{c:{d:{if((c|0)!=(m|0)){d=H[b+4>>2]+N(c,12)|0;if(!I[d+5|0]){if(I[d+4|0]!=64){break b}H[b+40>>2]=-981572454;H[b+44>>2]=1246829326;H[b+20>>2]=0;H[b+48>>2]=0;H[b+52>>2]=262144;return 0}g=H[d>>2];l=(g|0)<0;if(l){j=1}else{j=(H[a+24>>2]+1|0)==(g|0)}d=I[d+4|0];if(!(!j|((d|0)!=2|(e|0)>=0))){H[b+40>>2]=0;H[b+44>>2]=1072693248;k=1;H[b+20>>2]=1;e=c;break d}if((d|0)==2){break d}if((d|0)!=64){break c}d=64;if(H[a+24>>2]<(g|0)|l){break c}H[b+40>>2]=0;H[b+44>>2]=1073741824;k=g+2|0;H[b+20>>2]=k;e=c;break c}c=1;if((k|0)==1){H[b+56>>2]=H[b+56>>2]|1}if((e|0)>=0){c=H[b+16>>2]+(e<<3)|0;F[c+4|0]=1;H[c>>2]=1;c=2}if((h|0)>=0){H[b+20>>2]=H[b+20>>2]|65536;H[H[b+16>>2]+(h<<3)>>2]=c;c=c+1|0}if((f|0)>=0){H[b+20>>2]=H[b+20>>2]|131072;H[H[b+16>>2]+(f<<3)>>2]=c;c=c+1|0}if((i|0)>=0){H[b+20>>2]=H[b+20>>2]|262144;H[H[b+16>>2]+(i<<3)>>2]=c}c=0;if(H[b+8>>2]!=1){break a}e=H[b+12>>2];f=H[e>>2];if((f|0)>=0&(f|0)!=(H[a+24>>2]+1|0)){break a}a=I[e+4|0];H[b+32>>2]=1;H[b+24>>2]=a?19681:20095;break a}d=2;h=(H[a+24>>2]+2|0)==(g|0)?c:h}if(!j){break b}e:{switch(YK(d-4|0,30)|0){case 1:case 3:i=c;break b;case 0:case 7:break e;default:break b}}f=c}c=c+1|0;continue}}return c|0}function hG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((b|0)==2){a:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break a}}Wb(a);return}k=a;e=Nb(H[c>>2]);C(+e);a=x(1)|0;a=a&2147483647;b=!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072;f=Nb(H[c+4>>2]);C(+f);a=x(1)|0;a=a&2147483647;b:{if(!(b&(!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072))){d=e+f;break b}C(+f);b=x(1)|0;g=x(0)|0;h=b;if(!(g|b-1072693248)){d=jq(e);break b}C(+e);a=x(1)|0;b=x(0)|0;j=h>>>30&2;c=j|a>>>31;a=a&2147483647;c:{if(!(a|b)){d:{switch(c-2|0){case 0:d=3.141592653589793;break b;case 1:break d;default:break c}}d=-3.141592653589793;break b}C(1.5707963267948966);b=x(1)|0;i=x(0)|0;C(+e);l=x(1)|0;x(0)|0;z(0,i|0);z(1,b&2147483647|l&-2147483648);d=+B();b=h&2147483647;if(!(b|g)){break b}e:{if((b|0)==2146435072){if((a|0)!=2146435072){break e}d=M[(c<<3)+58416>>3];break b}C(1.5707963267948966);h=x(1)|0;i=x(0)|0;C(+e);g=x(1)|0;x(0)|0;z(0,i|0);z(1,h&2147483647|g&-2147483648);d=+B();if(!((a|0)!=2146435072&a>>>0<=b+67108864>>>0)){break b}f:{if(j){d=0;if(b>>>0>a+67108864>>>0){break f}}d=jq(P(e/f))}e=d;g:{switch(c|0){case 1:d=-e;break b;case 2:d=3.141592653589793-(e+-12246467991473532e-32);break b;case 0:break c;default:break g}}d=e+-12246467991473532e-32+-3.141592653589793;break b}e=M[(c<<3)+58448>>3]}d=e}Zb(k,d);return}_(22830,17213,570,17149);X()}function zc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=Ga-16|0;Ga=g;f=H[a+8>>2];H[g+12>>2]=0;H[g+8>>2]=0;if(!(!b|!f)){e=I[b|0];h=e^1;a:{b:{c:{d:{e:{f:{g:{h:{i:{switch(e-43|0){default:j:{switch(e-171|0){case 1:case 2:case 3:break b;case 0:break g;case 4:break h;default:break j}}if((e|0)!=19){break b}_e(a,H[b+12>>2],c,d);e=0;break a;case 0:case 1:break i;case 3:case 4:break b;case 6:break c;case 5:break d;case 7:case 8:break e;case 9:case 10:case 11:case 12:case 13:case 14:break f;case 2:break g}}h=vn(b);if((h|0)!=(b|0)){zc(a,h,c,d);e=0;break a}if((e|0)==44){zc(a,H[b+12>>2],c,d);zc(a,H[b+16>>2],c,d);e=0;break a}e=jb(a);_e(a,H[b+12>>2],e,d^16);zc(a,H[b+16>>2],c,d);lb(f,e);e=0;break a}f=I[b+2|0];d=((f|0)!=171)<<4;e=H[b+12>>2];if((Tk(H[b+16>>2])|0)!=((f|0)==171|0)){zc(a,e,c,d);e=0;break a}_e(a,e,c,d);e=0;break a}h=(e|0)==45?52:53;d=128}e=H[b+12>>2];if(Ze(e)){break b}e=Mc(a,e,g+12|0);f=Mc(a,H[b+16>>2],g+8|0);Cn(a,H[b+12>>2],H[b+16>>2],h,e,f,c,d,H[b+4>>2]>>>10&1);e=H[g+8>>2];break a}Va(f,h,Mc(a,H[b+12>>2],g+12|0),c);e=0;break a}rs(a,b,c,54,d);e=0;break a}if(d){zn(a,b,c,c);e=0;break a}d=b;b=jb(a);zn(a,d,c,b);lb(f,b);e=0;break a}h=H[b+4>>2];if((h&536870913)==536870912){Yb(f,c);e=0;break a}e=0;if((h&268435457)==268435456){break a}Xa(f,16,Mc(a,b,g+12|0),c,(d|0)!=0);e=0}xb(a,H[g+12>>2]);xb(a,e)}Ga=g+16|0}function yE(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=Ga-32|0;Ga=c;e=I[a+16|0];a:{if((e|0)>=(b|0)){break a}f=H[a+8>>2];g=I[f+28|0];if((e|0)!=(g|0)){d=5;if((b|0)>1|g>>>0>2){break a}}b:{c:{d:{e:{f:{g:{h:{i:{j:{if((b|0)==1){if((g-1&255)>>>0>=2){G[c+2>>1]=0;H[c+16>>2]=1;H[c+20>>2]=0;break j}F[a+16|0]=1;H[f+20>>2]=H[f+20>>2]+1;H[f+24>>2]=H[f+24>>2]+1;d=0;break a}G[c+2>>1]=0;H[c+16>>2]=1;H[c+20>>2]=0;if((b|0)!=4){break i}if(e>>>0>2){break h}}d=(b|0)!=1;G[c>>1]=d;e=H[16164];H[c+8>>2]=e;H[c+12>>2]=e>>31;if(ih(a,c)){d=5;f=H[17665];b=Yl(f);if((b|0)==5){break a}gd(a,f);d=b;break a}if(d){break i}H[c+16>>2]=510;H[c+20>>2]=0;d=H[16164]+2|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;d=0;e=0;if(ih(a,c)){e=H[17665];d=Yl(e)}H[c+16>>2]=1;H[c+20>>2]=0;G[c>>1]=2;g=H[16164];H[c+8>>2]=g;H[c+12>>2]=g>>31;k:{l:{if(!(!ih(a,c)|d)){e=H[17665];d=2058;break l}if(!d){break k}if((d|0)==5){break a}}gd(a,e);break a}H[f+20>>2]=1;H[f+24>>2]=H[f+24>>2]+1;break d}if((b|0)!=4){break g}}d=5;if(H[f+20>>2]>1){break b}G[c>>1]=1;break f}G[c>>1]=1;e=1;d=1;if((b|0)==2){break e}}e=2;d=510}H[c+16>>2]=d;H[c+20>>2]=0;d=e+H[16164]|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;if(!ih(a,c)){break d}e=H[17665];d=Yl(e);if((d|0)==5){break c}gd(a,e);if(d){break c}}F[a+16|0]=b;F[f+28|0]=b;d=0;break a}if((b|0)!=4){break a}}F[a+16|0]=3;F[f+28|0]=3}Ga=c+32|0;return d|0}function jc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=H[a+8>>2];f=H[a+4>>2];k=I[f+16|0];h=H[a>>2];j=jb(h);if(!((b|0)==2&I[f+17|0]==90)){a:{b:{if((c|0)<=0){break b}if(I[f+16|0]==89){l=H[e+108>>2];if((b|0)==2){if(I[f+17|0]==86){Mk(a,55,H[a+40>>2],c,H[a+32>>2],j);break a}Mk(a,57,H[a+32>>2],c,H[a+40>>2],j);break a}Mk(a,54,H[a+48>>2],c,H[a+40>>2],j);break b}Xa(e,49,c,j,1)}if(H[f+88>>2]|(b|0)!=1){break a}Wr(a,0)}m=H[e+108>>2];if(!(!c|I[f+17|0]!=I[f+18|0]|I[f+16|0]!=89)){i=Db(h);c=Db(h);c:{d:{if((b|0)==2){Va(e,135,H[a+32>>2],i);Va(e,135,H[a+48>>2],c);g=c;break d}if(!H[a+28>>2]){break c}Va(e,135,H[a+48>>2],i);g=H[a+28>>2]}Xa(e,57,g,j,i)}xb(h,i);xb(h,c)}e:{f:{switch(b-1|0){case 0:i=H[a+44>>2];c=H[a+40>>2];IB(a);break e;case 1:i=H[a+36>>2];c=H[a+32>>2];g=H[f+88>>2];if(g){Va(e,86,g,1);break e}Ir(a,f,c,1,H[a+20>>2]);break e;default:break f}}i=H[a+52>>2];c=H[a+48>>2];if(H[f+88>>2]){Va(e,86,H[f+92>>2],1);break e}Ir(a,f,c,0,H[a+20>>2])}if(H[a+24>>2]==(b|0)){db(e,130,c);pb(e,2)}b=H[e+108>>2];g:{h:{if(!d){d=(k|0)==76;Va(e,38,c,b+(d?1:2)|0);if(d){break g}Va(e,8,0,j);break h}Va(e,38,c,b+2|0);n=Sb(e,8);if((k|0)==76){break g}}d=0;b=a;g=H[f+12>>2];a=0;i:{if(!g){break i}g=H[g>>2];a=0;if(!g){break i}d=g;a=Cc(h,g)}Gk(b,c,a);HB(h,H[f+12>>2],a,i,m);md(h,a,d)}if(l){Va(e,8,0,l)}lb(e,j)}return n}function _e(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=Ga-16|0;Ga=g;f=H[a+8>>2];H[g+12>>2]=0;H[g+8>>2]=0;if(!(!b|!f)){a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{e=I[b|0];switch(e-43|0){case 0:case 1:break i;case 3:case 4:break b;case 6:break c;case 5:break d;case 7:case 8:break e;case 9:case 10:case 11:case 12:case 13:case 14:break f;case 2:break g;default:break j}}k:{switch(e-171|0){case 1:case 2:case 3:break b;case 0:break g;case 4:break h;default:break k}}if((e|0)!=19){break b}zc(a,H[b+12>>2],c,d);e=0;break a}h=vn(b);if((h|0)!=(b|0)){_e(a,h,c,d);e=0;break a}if((e|0)==44){e=jb(a);zc(a,H[b+12>>2],e,d^16);_e(a,H[b+16>>2],c,d);lb(f,e);e=0;break a}_e(a,H[b+12>>2],c,d);_e(a,H[b+16>>2],c,d);e=0;break a}f=I[b+2|0]==171;d=f<<4;e=H[b+12>>2];if((Tk(H[b+16>>2])|0)!=(f|0)){_e(a,e,c,d);e=0;break a}zc(a,e,c,d);e=0;break a}e=(e|0)==45?53:52;d=128}h=H[b+12>>2];if(Ze(h)){break b}f=Mc(a,h,g+12|0);h=Mc(a,H[b+16>>2],g+8|0);Cn(a,H[b+12>>2],H[b+16>>2],e,f,h,c,d,H[b+4>>2]>>>10&1);e=H[g+8>>2];break a}Va(f,e,Mc(a,H[b+12>>2],g+12|0),c);e=0;break a}rs(a,b,c,61,d);e=0;break a}e=b;b=jb(a);zn(a,e,b,d?c:b);Yb(f,c);lb(f,b);e=0;break a}h=H[b+4>>2];if((h&268435457)==268435456){Yb(f,c);e=0;break a}e=0;if((h&536870913)==536870912){break a}Xa(f,15,Mc(a,b,g+12|0),c,(d|0)!=0);e=0}xb(a,H[g+12>>2]);xb(a,e)}Ga=g+16|0}function Wi(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=I[a+25|0];e=H[a+4>>2];f=H[a+16>>2];while(1){b=(c&255)-1|0;i=G[((b<<1)+a|0)+72>>1];j=H[((b<<2)+a|0)+28>>2];while(1){c=H[e+24>>2]+N(f,48)|0;while(1){if(H[e+12>>2]>(f|0)){a:{if(H[c+20>>2]!=(j|0)|H[c+24>>2]!=(i|0)){break a}if((i|0)==-2){if(dn(H[H[c>>2]+12>>2],H[a+12>>2],j)){break a}}if(F[H[c>>2]+4|0]&1&I[a+25|0]>=2){break a}d=J[c+12>>1];b:{if(!(d&2048)){break b}g=I[a+26|0];if(g>>>0>10){break b}b=jd(H[H[c>>2]+16>>2]);if(I[b+4|0]&32?1:!b|I[b|0]!=167){b=0}if(!b){break b}h=b;b=0;c:{while(1){if((b|0)==(g|0)){break c}if(!(H[((b<<2)+a|0)+28>>2]==H[h+28>>2]&J[((b<<1)+a|0)+72>>1]==J[h+32>>1])){b=b+1|0;continue}break}if((b|0)!=(g|0)){break b}}H[((g<<2)+a|0)+28>>2]=H[h+28>>2];G[((g<<1)+a|0)+72>>1]=J[h+32>>1];F[a+26|0]=g+1;d=J[c+12>>1]}if(!(H[a+20>>2]&d)){break a}if(!(!H[a+8>>2]|d&256)){d=H[H[e>>2]>>2];b=H[c>>2];if(!bB(b,F[a+24|0])){break a}b=Uj(d,b);if(!b){b=H[H[d>>2]+8>>2]}if(hb(H[b>>2],H[a+8>>2])){break a}d=J[c+12>>1]}d:{if(!(d&130)){break d}b=H[H[c>>2]+16>>2];if(!b|I[b|0]!=167|H[b+28>>2]!=H[a+28>>2]){break d}if(J[b+32>>1]==J[a+72>>1]){break a}}H[a+4>>2]=e;H[a+16>>2]=f+1;return c}c=c+48|0;f=f+1|0;continue}break}f=0;e=H[e+4>>2];if(e){continue}break}b=I[a+25|0];if(b>>>0<I[a+26|0]){c=b+1|0;F[a+25|0]=c;e=H[a>>2];continue}break}return 0}function jk(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;a:{b:{c:{C(+a);b=x(1)|0;x(0)|0;d:{e:{e=b&2147483647;if(e>>>0>=1078159482){C(+a);e=x(1)|0;e=e&2147483647;if((e|0)==2146435072&(x(0)|0)!=0|e>>>0>2146435072){break a}if((b|0)<0){return-1}if(!(a>709.782712893384)){break e}return a*898846567431158e293}if(e>>>0<1071001155){break c}if(e>>>0>1072734897){break e}if((b|0)>0|(b|0)>=0){b=1;c=1.9082149292705877e-10;g=a+-.6931471803691238;break d}b=-1;c=-1.9082149292705877e-10;g=a+.6931471803691238;break d}C(.5);b=x(1)|0;h=x(0)|0;C(+a);e=x(1)|0;x(0)|0;z(0,h|0);z(1,b&2147483647|e&-2147483648);c=a*1.4426950408889634+ +B();f:{if(P(c)<2147483648){b=~~c;break f}b=-2147483648}d=+(b|0);c=d*1.9082149292705877e-10;g=a+d*-.6931471803691238}a=g;a=a-c;c=g-a-c;break b}if(e>>>0<1016070144){break a}b=0}f=a*.5;d=a*f;g=d*(d*(d*(d*(d*-2.0109921818362437e-7+4008217827329362e-21)+-793650757867488e-19)+.0015873015872548146)+-.03333333333333313)+1;f=3-g*f;f=d*((g-f)/(6-a*f));if(!b){return a-(a*f-d)}c=a*(f-c)-c-d;g:{switch(b+1|0){case 0:return(a-c)*.5+-.5;case 2:if(a<-.25){return(c-(a+.5))*-2}a=a-c;return a+a+1;default:break g}}z(0,0);z(1,b+1023<<20);d=+B();if(b>>>0>=57){a=a-c+1;return((b|0)==1024?(a+a)*898846567431158e293:a*d)+-1}z(0,0);z(1,1023-b<<20);f=+B();a=(b>>>0<=19?1-f+(a-c):a-(c+f)+1)*d}return a}function px(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c=Ga-32|0;Ga=c;H[a+128>>2]=H[b+224>>2];H[b+224>>2]=0;i=G[b+204>>1];g=H[a>>2];d=H[b+44>>2];h=H[b+40>>2];H[c+28>>2]=H[b+96>>2];e=N(H[a+108>>2],20)+7&-8;H[c>>2]=e+H[a+104>>2];e=H[b+48>>2]-e&-8;H[c+8>>2]=e;H[c+12>>2]=e>>31;mx(a,c+28|0);d=d+h|0;e=d+(!h&(d|0)>0)|0;d=I[a+150|0]&-33|(I[b+20|0]?(I[b+21|0]!=0)<<5:0);F[a+150|0]=d;f=I[b+207|0];if(f){F[a+150|0]=f<<2&12|d&243;b=I[b+207|0]==2;Zj(a,b?4:8);e=(e|0)>10?e:10;d=b?12:8;f=b<<3;b=f;while(1){if((b|0)!=(d|0)){jf(a,b-f|0,0,H[(b<<2)+34128>>2],0);b=b+1|0;continue}break}d=I[a+150|0]}F[a+150|0]=d&252;H[c+16>>2]=0;H[c+20>>2]=0;f=N(e,40);n=a,o=yg(c,0,f),H[n+88>>2]=o;k=N(i,40);n=a,o=yg(c,0,k),H[n+100>>2]=o;l=H[c+28>>2]<<2;n=a,o=yg(c,0,l),H[n+92>>2]=o;j=h<<2;n=a,o=yg(c,0,j),H[n+96>>2]=o;a:{b:{d=H[c+16>>2];b=H[c+20>>2];c:{if(d|b){m=Tb(g,d,b);H[a+208>>2]=m;H[c+8>>2]=d;H[c+12>>2]=b;H[c>>2]=m;if(I[g+87|0]){break c}n=a,o=yg(c,H[a+88>>2],f),H[n+88>>2]=o;n=a,o=yg(c,H[a+100>>2],k),H[n+100>>2]=o;n=a,o=yg(c,H[a+92>>2],l),H[n+92>>2]=o;n=a,o=yg(c,H[a+96>>2],j),H[n+96>>2]=o;break b}if(!I[g+87|0]){break b}}G[a+16>>1]=0;H[a+20>>2]=0;H[a+24>>2]=0;break a}G[a+16>>1]=i;H[a+24>>2]=h;Vp(H[a+100>>2],i,g,1);H[a+20>>2]=e;Vp(H[a+88>>2],e,g,0);$a(H[a+96>>2],0,j)}ey(a);Ga=c+32|0}function Re(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Ga-16|0;Ga=f;H[f+8>>2]=0;a:{if(!jx(a)){b=kd(129429);break a}Yc(a,0);b=b?b:29357;b:{while(1){c:{if(g){break c}if(!I[b|0]){g=0;break c}H[f+8>>2]=0;g=Rh(a,b,-1,f+8|0,f+12|0);if(g){continue}h=0;b=0;i=0;k=0;if(!H[f+8>>2]){g=0;b=H[f+12>>2];continue}while(1){d:{g=Ab(H[f+8>>2]);e:{if(!c){break e}f:{g:{h:{if((g|0)!=100){if(!(F[a+33|0]&1)|((g|0)!=101|b)){break d}break h}if(!b){break h}j=(i|0)>0?i:0;break g}i=jm(H[f+8>>2]);h=Uc(a,i<<3|4,0);if(!h){break c}b=0;j=(i|0)>0?i:0;while(1){if((b|0)!=(j|0)){m=(b<<2)+h|0,n=im(H[f+8>>2],b),H[m>>2]=n;b=b+1|0;continue}break}if((g|0)!=100){break f}}k=(i<<2)+h|0;b=0;while(1){if((b|0)!=(j|0)){l=lf(H[f+8>>2],b);H[(b<<2)+k>>2]=l;i:{if(l){break i}if((ph(H[f+8>>2],b)|0)==5){break i}Mb(a);g=100;break b}b=b+1|0;continue}break}H[(j<<2)+k>>2]=0}b=1;if(!(Ka[c|0](d,i,k,h)|0)){break e}yf(H[f+8>>2]);H[f+8>>2]=0;g=4;Yc(a,4);break b}if((g|0)==100){continue}}break}g=yf(H[f+8>>2]);H[f+8>>2]=0;j=H[f+12>>2];while(1){b=j;j=b+1|0;if(F[I[b|0]+30016|0]&1){continue}break}_a(a,h);continue}break}h=0}b=H[f+8>>2];if(b){yf(b)}_a(a,h);b=nd(a,g);if(!(!e|!b)){c=Xb(0,xg(a));H[e>>2]=c;if(c){break a}b=7;Yc(a,7);break a}if(!e){break a}H[e>>2]=0}Ga=f+16|0;return b|0}function Ir(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;n=d?161:162;o=1-d|0;p=e+1|0;j=H[a>>2];g=zb(j);f=b;while(1){if(f){l=H[f+44>>2];a=0;i=0;if(!I[f+96|0]){i=Jr(f)}h=(i|0)>0?i:0;while(1){if((a|0)!=(h|0)){a:{if(!((a|0)==1&H[l+32>>2]==48688)){Xa(g,94,c,H[f+80>>2]+a|0,a+e|0);break a}Xa(g,94,H[b+48>>2],H[f+80>>2]+1|0,p)}a=a+1|0;continue}break}b:{if(!(H[b+88>>2]|!(I[l+5|0]&16)|I[f+17|0]==90)){a=db(g,50,e);c:{if(!d){Va(g,86,H[f+64>>2]+1|0,1);Va(g,81,e,H[f+64>>2]);h=H[f+64>>2];Xa(g,97,h,2,h+2|0);Va(g,138,H[f+60>>2],H[f+64>>2]+2|0);break c}ob(g,22,H[f+60>>2],0,e,1);db(g,130,H[f+60>>2]);bb(g,H[g+108>>2]-2|0)}bb(g,a);break b}a=H[f+64>>2];if(a){Va(g,86,a+o|0,1);break b}if(H[l+16>>2]==86){break b}d:{if(!H[f+40>>2]){m=0;break d}a=Db(j);Xa(g,94,c,H[f+80>>2]+i|0,a);m=Xa(g,16,a,0,1);xb(j,a)}h=e;e:{if(!I[f+96|0]){break e}a=H[g+108>>2];i=H[H[H[f+72>>2]+20>>2]>>2];h=Cc(j,i);Nh(j,H[H[f+72>>2]+20>>2],h,0,0);k=H[g+108>>2];q=(a|0)>(k|0)?a:k;while(1){if((a|0)==(q|0)){break e}k=Nc(g,a);if(!(I[k|0]!=94|H[k+4>>2]!=H[b+48>>2])){H[k+4>>2]=c}a=a+1|0;continue}}if(I[l+4|0]&32){kb(g,85,0,0,0,Zf(j,H[H[H[f+72>>2]+20>>2]+8>>2]),-2)}Xa(g,n,d,h,H[f+52>>2]);Pc(g,l,-7);pb(g,i&255);if(I[f+96|0]){md(j,h,i)}if(!m){break b}bb(g,m)}f=H[f+36>>2];continue}break}}function em(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Ga-16|0;Ga=f;g=H[a+116>>2];a:{if(J[a+70>>1]>=J[g+24>>1]){b=ab(71814);break a}k=H[a+20>>2];ii(a);e=H[a+40>>2];h=J[a+48>>1];if(e-H[g+56>>2]>>>0>H[k+40>>2]-h>>>0){b=ab(71829);break a}b:{if(b>>>0<h>>>0){j=h>>>0<b+c>>>0?h-b|0:c;c=c-j|0;h=d+j|0;b=mv(b+e|0,d,j);break b}i=b-h|0;h=d;b=0}c:{if(b|!c){break c}b=H[k+40>>2];d=J[a+48>>1];l=f,m=eb(d+e|0),H[l+12>>2]=m;g=b-4|0;d:{if(!(I[a+1|0]&4)){d=((H[a+44>>2]+(b-d|0)|0)-5>>>0)/(g>>>0)|0;b=H[a+12>>2];e:{f:{if(!b){b=0;break f}j=af(b);b=H[a+12>>2];e=d<<2;if((j|0)>=(e|0)){break e}}b=Zd(b,d<<3,0);if(!b){b=7;break a}H[a+12>>2]=b;e=d<<2}d=0;$a(b,0,e);F[a+1|0]=I[a+1|0]|4;break d}d=(i>>>0)/(g>>>0)|0;b=H[H[a+12>>2]+(d<<2)>>2];if(!b){d=0;break d}H[f+12>>2]=b;i=i-N(d,g)|0}while(1){b=H[f+12>>2];if(!b){b=0;break c}if(b>>>0>K[k+48>>2]){b=ab(71891);break a}e=H[a+12>>2];H[e+(d<<2)>>2]=b;g:{if(i>>>0>=g>>>0){d=d+1|0;e=H[e+(d<<2)>>2];h:{if(e){H[f+12>>2]=e;b=0;break h}b=lv(k,b,0,f+12|0)}i=i-g|0;break g}e=g>>>0<c+i>>>0?g-i|0:c;b=sd(H[k>>2],b,f+8|0,2);if(!b){b=H[f+8>>2];j=H[b+4>>2];l=f,m=eb(j),H[l+12>>2]=m;b=mv((i+j|0)+4|0,h,e);rd(H[f+8>>2]);i=0}c=c-e|0;if(!c){break a}d=d+1|0;h=e+h|0}if(!b){continue}break}}if(!c|b){break a}b=ab(71976)}Ga=f+16|0;return b}function _m(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-32|0;Ga=d;g=H[a>>2];c=H[a+244>>2];H[d+28>>2]=0;H[d+20>>2]=0;H[d+24>>2]=0;H[d+12>>2]=0;H[d+16>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[d>>2]=a;b=Dc(g,H[c+4>>2],H[H[g+16>>2]+(Lb(g,H[c+24>>2])<<4)>>2]);H[a+120>>2]=b;F[a+148|0]=I[c+8|0];a:{if(b){b=fg(a,b);if(b){break a}}b=0;e=H[c+12>>2];if(!e){break a}b=ld(d,e)}f=c+28|0;while(1){b:{if(b){break b}e=H[f>>2];if(!e){break b}c=H[e+8>>2];c:{d:{if(!c){break d}ve(a,c,d);if(!H[a+36>>2]){break d}b=H[a+12>>2];if(b){break c}}if(!H[e+12>>2]){b=0;break c}h=an(a,e);if(!h){b=7;break c}c=Hd(a,H[e+24>>2],h,0,0,0,0,0,0);e:{if(!c){h=0;H[e+24>>2]=0;c=7;break e}ve(a,c,0);b=H[a+36>>2];if(H[e+24>>2]){H[c+28>>2]=0}H[c+32>>2]=0;hc(g,c);c=(b|0)!=0}f:{f=H[e+16>>2];if(!f){break f}b=0;if(c){break f}while(1){if(H[f>>2]<=(b|0)){break f}i=H[((b<<6)+f|0)+28>>2];if(i){ve(a,i,0);f=H[e+16>>2]}b=b+1|0;continue}}b=I[g+87|0];H[d+4>>2]=h;b=b?7:c;g:{if(b){break g}c=H[e+20>>2];if(c){b=ld(d,c);if(b){break g}}b=$e(d,H[e+24>>2])}c=H[e+32>>2];if(!(!c|b)){H[c+32>>2]=h;H[d+24>>2]=512;H[d+8>>2]=c;b=$e(d,H[c>>2]);h:{if(b){break h}b=$e(d,H[c+8>>2]);if(b){break h}b=ld(d,H[c+12>>2]);if(b){break h}b=ld(d,H[c+4>>2])}H[d+24>>2]=0}H[d+4>>2]=0;Ic(g,h)}f=e+40|0;continue}break}Ga=d+32|0;return b}function rG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0;d=Ga-16|0;Ga=d;xm(a);c=0;a:{if(!b){break a}h=cb(H[e>>2]);if(!h){break a}g=bc(H[e>>2]);f=g+1|0;c=g>>31;f=Ib(f,f?c:c+1|0);H[a+24>>2]=f;c=7;if(!f){break a}Ya(f,h,g+1|0);b:{g=a+32|0;if(Eh(g,0,H[a+24>>2])){if(I[a+52|0]){break b}Wa(H[H[a>>2]+8>>2]);b=Hb(19197,0);H[H[a>>2]+8>>2]=b;c=b?1:7;break b}if(I[a+21|0]){f=Ib(H[g>>2]<<2,0);H[g+16>>2]=f;c:{if(!f){F[g+20|0]=1;f=7;break c}uq(g,0,0);f=0}if(f){break b}}d:{if((b|0)==3){c=0;H[d+12>>2]=0;b=cb(H[e+4>>2]);if(!b){break a}e=bc(H[e+4>>2]);f=e+1|0;c=e>>31;c=Ib(f,f?c:c+1|0);H[a+28>>2]=c;if(!c){c=7;break a}Ya(c,b,e+1|0);e:{f:{if(I[b|0]!=36){H[d+12>>2]=b;break f}c=0;e=nr(g,0,H[a+28>>2]+1|0,0,d+12|0);b=H[d+12>>2];if(!b){break e}}Wa(H[H[a>>2]+8>>2]);b=dA(b);H[H[a>>2]+8>>2]=b;xm(a);c=H[H[a>>2]+8>>2]?1:7;break a}if(!e){break a}c=H[a+40>>2];break d}c=H[a+40>>2];e=c}b=(e-c|0)/12|0;H[a+8>>2]=b;H[a+12>>2]=b;c=I[e|0];F[a+20|0]=c;if(c>>>0>=6){c=0;H[e+8>>2]=0;f=H[e+4>>2];b=H[a+12>>2];e=b+1|0;H[a+16>>2]=f+e;if(I[a+21|0]){e=H[a+40>>2];F[a+20|0]=I[e+N(H[H[a+48>>2]+(b<<2)>>2],12)|0];if(!b){break a}b=b-1|0;if(!(I[(e+N(b,12)|0)+1|0]&64)){break a}H[a+12>>2]=b;break a}H[a+12>>2]=e;break a}H[a+16>>2]=b+1;c=0;break a}xm(a)}Ga=d+16|0;return c|0}function oe(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{b:{if(!b){dc(a);break b}l=H[a+20>>2];if(l){g=H[l+120>>2];j=g>>31}else{g=1e9;j=0}m=g;c:{d:{e:{if((d|0)<0){g=1;if((e|0)==1){break e}while(1){k=514;if(!(I[(h|1)+b|0]|I[b+h|0])|(h>>>0>m>>>0&(i|0)>=(j|0)|(i|0)>(j|0))){break d}g=i;i=h+2|0;g=i>>>0<2?g+1|0:g;h=i;i=g;continue}}k=e?2:16;g=e?e:1;h=c;i=d;break c}h=ub(b);k=514;break c}g=e}if(h>>>0>m>>>0&(i|0)>=(j|0)|(i|0)>(j|0)){f:{if(f+1>>>0<2){break f}if((f|0)==1){_a(l,b);break f}Ka[f|0](b)}dc(a);aq(H[a+20>>2],18);return 18}g:{if((f|0)==-1){e=7;c=d>>31;d=h+(((g|0)==1?1:2)&c)|0;c=i;c=d>>>0<h>>>0?c+1|0:c;if(Bi(a,d>>>0>32&(c|0)>=0|(c|0)>0?d:32)){break a}Ya(H[a+8>>2],b,d);break g}hd(a);H[a+8>>2]=b;if((f|0)==1){H[a+32>>2]=b;n=a,o=Rf(H[a+20>>2],b),H[n+24>>2]=o;break g}H[a+36>>2]=f;k=(f?4096:8192)|k}F[a+18|0]=g;G[a+16>>1]=k;H[a+12>>2]=h&2147483647;if(g>>>0<2){break b}b=0;e=2;h:{if(H[a+12>>2]<2){break h}d=H[a+8>>2];c=I[d+1|0];d=I[d|0];if(!((d|0)==255&(c|0)==254)){if((d|0)!=254){break h}e=3;if((c|0)!=255){break h}}b=Fg(a);if(b){break h}b=H[a+12>>2]-2|0;H[a+12>>2]=b;c=H[a+8>>2];vd(c,c+2|0,b);b=0;F[H[a+8>>2]+H[a+12>>2]|0]=0;F[(H[a+12>>2]+H[a+8>>2]|0)+1|0]=0;F[a+18|0]=e;G[a+16>>1]=J[a+16>>1]|512}e=7;if(b){break a}}e=0}return e}function He(){var a=0,b=0,c=0,d=0,e=0,f=0,g=0;a:{if(H[16052]){break a}H[16054]=1;if(!H[16055]){if(!H[16008]){ax()}H[17524]=8;if(!(!(!H[16046]|H[16047]<512)&H[16048]>0)){H[16046]=0;H[16047]=0}a=Ka[H[16013]](H[16015])|0;if(a){H[17530]=0;H[17531]=0;H[17528]=0;H[17529]=0;H[17526]=0;H[17527]=0;H[17524]=0;H[17525]=0}if(a){break a}}H[16055]=1;if(!H[16058]){H[16058]=8}c=H[16057]+1|0;H[16057]=c;a=0;if(!(H[16052]|H[16053])){H[16053]=1;$a(70400,0,92);Tj(67776,5);Tj(67984,15);Tj(68592,9);Tj(68960,19);Tj(65088,67);b:{if(!H[16056]){c=H[16027];if(!c){$w();c=H[16027]}a=Ka[c|0](H[16026])|0;if(a){break b}}H[16056]=1;a=Ub(10);if(a){Wa(a);while(1){if((b|0)!=4){Oy(N(b,88)+64304|0,!b);b=b+1|0;continue}break}f=65024,g=Zx(18802),H[f>>2]=g;f=65028,g=Zx(18809),H[f>>2]=g;a=0}else{a=7}if(a){break b}a=Qm(0);if(a){b=H[a+4>>2];H[17435]=a;H[17431]=b>>>0>12?b:12;a=Oy(69720,0)}else{a=1}if(a){break b}a=0;b=H[16046];c=H[16047];d=H[16048];if(H[17640]){d=b?d:0;H[17650]=d;H[17644]=d;e=b?d?c&-8:0:0;H[17643]=e;H[17646]=b;H[17645]=(d|0)<=90?((d|0)/10|0)+1|0:10;H[17651]=0;H[17649]=0;c=0;while(1){if(d){H[b>>2]=c;H[17649]=b;d=d-1|0;c=b;b=b+e|0;continue}break}H[17647]=b}H[16052]=1}H[16053]=0;c=H[16057]}H[16057]=c-1;if((c|0)>1){break a}H[16058]=0}return a}function Ik(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=H[a+20>>2];a:{if(!c){f=101;a=H[a+12>>2];if(!a){break a}G[a>>1]=0;return 101}g=H[a>>2];f=H[H[g>>2]>>2];H[a+20>>2]=c-1;c=H[g+64>>2];if(!(!c|!(H[b+40>>2]&512))){h=I[b+16|0];while(1){b:{if(!(I[c+41|0]&2)|I[c+16|0]!=(h|0)){break b}c:{if(VA(c,b)){d=G[c+20>>1];e=G[b+20>>1];G[b+20>>1]=(d|0)<(e|0)?d:e;d=G[b+22>>1];e=G[c+22>>1];d=(d|0)<(e|0)?d:e-1|0;break c}if(!VA(b,c)){break b}d=G[c+20>>1];e=G[b+20>>1];G[b+20>>1]=(d|0)>(e|0)?d:e;d=G[b+22>>1];e=G[c+22>>1];d=(d|0)>(e|0)?d:e+1|0}G[b+22>>1]=d}c=H[c+56>>2];if(c){continue}break}}a=H[a+12>>2];if(a){f=0;if(!J[b+44>>1]){break a}ZA(a,H[b>>2],H[b+4>>2],G[b+20>>1],G[b+22>>1]);return 0}a=WA(g- -64|0,b);if(!a){return 0}d:{e:{c=H[a>>2];if(!c){c=Tb(f,72,0);H[a>>2]=c;if(c){break e}return 7}a=c+56|0;while(1){if(!H[a>>2]){break d}a=WA(a,b);if(!a){break d}g=H[a>>2];if(!g){break d}H[a>>2]=H[g+56>>2];hB(f,g);continue}}mn(c);H[c+56>>2]=0}YA(f,c);f:{if(Vi(f,c,J[b+44>>1])){$a(c,0,48);f=7;break f}a=Ya(c,b,48);Ya(H[a+52>>2],H[b+52>>2],J[a+44>>1]<<2);a=H[b+40>>2];if(a&1024){F[b+28|0]=I[b+28|0]&254;f=0;break f}if(a&16384){H[b+32>>2]=0}f=0}if(I[c+41|0]&4){break a}a=H[c+32>>2];if(!a|((I[a+55|0]|I[a+56|0]<<8)&3)!=3){break a}H[c+32>>2]=0}return f}function Ty(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=H[a>>2];e=0;a:{if(!b){break a}e=0;if(I[a+52|0]!=I[h+239|0]){break a}b=H[c+64>>2];e=0;if((b|0)>4){break a}e=(b|0)>0}b=0;b:{c:{while(1){if(!e){break c}if(H[c+64>>2]>(b|0)){e=N(b,24)+c|0;d=H[e+92>>2];d:{if(!H[e+84>>2]){e=1;if(!d){d=0;break d}if(H[d+36>>2]){break d}}e=0}f=d?1:f;b=b+1|0;continue}break}if(!f){break c}a=H[c+68>>2];l=(a|0)<H[h+24>>2]?a:-1;b=0;e=1;d=0;while(1){if(H[c+64>>2]<=(b|0)|d){break b}a=N(b,24)+c|0;f=H[a+92>>2];if(f){i=I[h+239|0];g=H[f+4>>2];j=H[a+72>>2];k=H[a+76>>2];d=Gz(h,f,j,k);e:{if(d){break e}i=i?98:99;a=0;d=(g|0)>0?g:0;f:{while(1){if((a|0)==(d|0)){break f}g:{g=H[H[f>>2]+(a<<2)>>2];if(!H[g+40>>2]){break g}if(Bz(g,j,k)){break g}a=a+1|0;continue}break}d=a}H[f+8>>2]=d;a=0;while(1){h:{g=H[f>>2];if((a|0)>=(d|0)){break h}d=yz(h,H[g+(a<<2)>>2]);if(d){break e}a=a+1|0;d=H[f+8>>2];continue}break}Ki(g,a,a,i);H[f+24>>2]=l;d=0}}else{d=0}b=b+1|0;continue}}e=0;d=0;b=Ga-16|0;Ga=b;f=H[a>>2];a=0;while(1){if(!(H[c+64>>2]<=(a|0)|d)){d=N(a,24)+c|0;i:{if(!H[d+92>>2]){d=0;break i}H[b+12>>2]=0;H[b+8>>2]=0;d=Vy(f,d+72|0,H[c+68>>2],b+12|0,b+8|0);if(d){break i}d=Uy(f,c,a,H[b+8>>2],H[b+12>>2])}a=a+1|0;continue}break}Ga=b+16|0}H[c+40>>2]=e;return d}function fg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=Ga-16|0;Ga=j;c=H[a>>2];a:{if(I[b+43|0]==1){H[c+56>>2]=H[c+56>>2]+1;e=Ga-32|0;Ga=e;h=H[a>>2];b:{if(Id(h,b)){break b}d=Wc(h+384|0,H[H[b+48>>2]>>2]);if(!d){H[e>>2]=H[H[b+48>>2]>>2];Za(a,7784,e);f=1;break b}H[e+28>>2]=0;f=Jo(h,b,d,H[H[d>>2]+8>>2],e+28|0);b=H[e+28>>2];if(f){H[e+16>>2]=b;Za(a,8310,e+16|0);H[a+12>>2]=f}_a(h,b)}Ga=e+32|0;H[c+56>>2]=H[c+56>>2]-1;break a}d=G[b+34>>1];if((d|0)>0){break a}if((d|0)<0){H[j>>2]=H[b>>2];Za(a,15108,j);f=1;break a}i=ge(c,H[b+44>>2],0);c:{if(!i){f=1;break c}l=I[a+208|0];F[a+208|0]=0;e=H[a+40>>2];h=H[a+100>>2];pn(a,H[i+32>>2]);k=b+34|0;G[k>>1]=65535;G[c+308>>1]=0;d=H[c+360>>2];H[c+360>>2]=0;f=1;H[c+304>>2]=H[c+304>>2]+1;g=eo(a,i,64);H[c+360>>2]=d;H[a+100>>2]=h;H[a+40>>2]=e;d:{if(!g){G[k>>1]=0;break d}d=H[b+16>>2];if(d){rn(a,d,k,b+4|0);f=0;if(H[a+36>>2]|H[H[i+28>>2]>>2]!=G[k>>1]){break d}ks(a,b,i,64);break d}G[b+34>>1]=J[g+34>>1];H[b+4>>2]=H[g+4>>2];H[b+28>>2]=H[b+28>>2]|H[g+28>>2]&98;f=0;H[g+4>>2]=0;G[g+34>>1]=0}G[b+36>>1]=J[b+34>>1];ie(c,g);hc(c,i);d=H[c+304>>2]-1|0;H[c+304>>2]=d;G[c+308>>1]=d?0:J[c+310>>1];F[a+208|0]=l}a=H[b+60>>2];G[a+78>>1]=J[a+78>>1]|2;if(!I[c+87|0]){break a}to(c,b)}Ga=j+16|0;return f}function RK(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{e=b;if(e){if(!c){break j}f=d;if(!f){break i}e=Q(f)-Q(e)|0;if(e>>>0<=31){break h}break b}if((d|0)==1|d>>>0>1){break b}b=(a>>>0)/(c>>>0)|0;Ha=a-N(b,c)|0;Ia=0;Ja=0;return b}f=d;if(!a){break g}if(!f){break f}g=f-1|0;if(g&f){break f}Ha=a;Ia=e&g;a=e>>>_K(f)|0;Ja=0;return a}f=c-1|0;if(!(f&c)){break e}h=(Q(c)+33|0)-Q(e)|0;g=0-h|0;break c}h=e+1|0;g=63-e|0;break c}Ha=0;a=(e>>>0)/(f>>>0)|0;Ia=e-N(a,f)|0;Ja=0;return a}e=Q(f)-Q(e)|0;if(e>>>0<31){break d}break b}Ha=a&f;Ia=0;if((c|0)==1){break a}d=a;c=_K(c);a=c&31;if((c&63)>>>0>=32){e=0;a=b>>>a|0}else{e=b>>>a|0;a=((1<<a)-1&b)<<32-a|d>>>a}Ja=e;return a}h=e+1|0;g=63-e|0}i=a;e=h&63;f=e&31;if((e&63)>>>0>=32){e=0;k=b>>>f|0}else{e=b>>>f|0;k=((1<<f)-1&b)<<32-f|i>>>f}f=e;e=g&63;a=e&31;if((e&63)>>>0>=32){e=i<<a;a=0}else{e=(1<<a)-1&i>>>32-a|b<<a;a=i<<a}b=e;if(h){e=d-1|0;g=c-1|0;e=(g|0)!=-1?e+1|0:e;i=e;while(1){j=k;e=f<<1|j>>>31;f=j<<1;j=e;f=b>>>31|f;e=i-((f>>>0>g>>>0)+e|0)>>31;l=e;m=c&e;k=f-m|0;f=j-((d&e)+(f>>>0<m>>>0)|0)|0;e=b<<1|a>>>31;a=n|a<<1;b=e|o;j=0;l=l&1;n=l;h=h-1|0;if(h){continue}break}}Ha=k;Ia=f;e=b<<1|a>>>31;a=l|a<<1;Ja=e|j;return a}Ha=a;Ia=b;a=0;b=0}Ja=b;return a}function Ao(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=Ga-16|0;Ga=g;H[g+8>>2]=0;H[g+12>>2]=0;c=H[a+4>>2];e=H[a+12>>2];a:{if((c|0)>=(e|0)&K[a>>2]>=K[a+8>>2]|(c|0)>(e|0)){b:{c=H[a+48>>2];c:{if(!c){break c}e=Ga-48|0;Ga=e;n=H[c+4>>2];o=H[c+8>>2];p=H[c+12>>2];Rt(H[c+48>>2],e+8|0,H[H[H[c>>2]+8>>2]+12>>2],o,p);while(1){d:{if(i){break d}k=H[n+12>>2]+N(H[H[n+8>>2]+4>>2],56)|0;if(!H[k+24>>2]){break d}b=H[e+24>>2];f=b>>31;l=b;j=H[k+20>>2];b=j;h=H[e+32>>2];d=b+h|0;m=b>>31;b=m+H[e+36>>2]|0;b=d>>>0<h>>>0?b+1|0:b;h=d;d=l+d|0;b=b+f|0;b=d>>>0<h>>>0?b+1|0:b;f=Vh(j,m);d=f+d|0;b=(f>>31)+b|0;b=d>>>0<f>>>0?b+1|0:b;l=d;d=H[c+16>>2];h=d;f=d+o|0;d=(d>>31)+p|0;d=f>>>0<h>>>0?d+1|0:d;if(l>>>0>f>>>0&(d|0)<=(b|0)|(b|0)>(d|0)){break d}b=e+8|0;Do(b,j,m);Co(b,H[k+32>>2],j);i=uu(H[c+4>>2],e+4|0);continue}break}b=Qt(e+8|0,c+56|0);Ga=e+48|0;b=i?i:b;e=H[c+60>>2];d=H[c+56>>2];H[c+40>>2]=d;H[c+44>>2]=e;i=H[c+52>>2];H[c+32>>2]=H[c+48>>2];H[c+36>>2]=i;if((d|0)==H[c+8>>2]&(e|0)==H[c+12>>2]){H[c+20>>2]=1}if(b){break c}b=0;if(!H[c+20>>2]){break b}}cv(a);break a}b=Nt(H[c>>2],a,c+32|0,H[c+8>>2],H[c+12>>2]);if(b){break a}}b=Mt(a,g+8|0);if(b){break a}b=H[g+8>>2];H[a+20>>2]=b;b=zo(a,b,a+32|0)}Ga=g+16|0;return b}function jh(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if((d|0)==1){f=1;d=a;break a}e=3-d|0;j=c&-2;while(1){if(!(I[a+e|0]|(e|0)>=(j|0))){e=e+2|0;continue}break}c=e^1;j=(e|0)<(j|0);f=2;d=(d&1)+a|0}k=a+c|0;b:{while(1){i=1;if(d>>>0>=k>>>0){break b}a=I[d|0];if(F[a+30016|0]&1){d=d+f|0;continue}break}c:{switch(a-43|0){case 2:d=d+f|0;i=0;break b;case 0:break c;default:break b}}d=d+f|0}e=d;while(1){if(I[e|0]==48&e>>>0<k>>>0){e=e+f|0;continue}else{c=0;while(1){d:{a=c+e|0;l=a>>>0>=k>>>0;if(l){break d}a=I[a|0];if((a-48&255)>>>0>9){break d}c=c+f|0;h=SK(h,g,10,0);g=a&255;h=h+g|0;a=Ja;a=g>>>0>h>>>0?a+1|0:a;g=h;h=g-48|0;g=a-(g>>>0<48)|0;continue}break}a=(g|0)<0;H[b>>2]=a?i?-1:0:i?h:0-h|0;H[b+4>>2]=a?i?2147483647:-2147483648:i?g:0-(((h|0)!=0)+g|0)|0;e:{if(!c){a=-1;if((d|0)==(e|0)){break e}}a=j;if(a){break e}if(l){break e}d=c;while(1){a=1;if(!(F[I[d+e|0]+30016|0]&1)){break e}d=d+f|0;if(k>>>0>e+d>>>0){continue}break}a=0}d=a;j=N(f,19);f:{if(j>>>0>c>>>0){break f}a=1;if(c>>>0<=j>>>0){a=0;c=0;while(1){if(!(a>>>0>17|c)){c=N(F[N(a,f)+e|0]-F[a+23639|0]|0,10);a=a+1|0;continue}break}a=c?c:F[N(f,18)+e|0]-56|0;if((a|0)<0){break f}}H[b>>2]=i?-1:0;H[b+4>>2]=i?2147483647:-2147483648;d=a?2:i?3:d}}break}return d}function oG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Ga-144|0;Ga=d;g=H[a+40>>2];f=H[a+12>>2];e=g+N(f,12)|0;a:{b:{c:{d:{switch(c|0){case 0:if(!f){break a}e:{switch(I[a+20|0]-6|0){case 1:Ak(e,b);break a;case 0:break e;default:break a}}c=a+4|0;if(I[a+21|0]){if(!H[a+4>>2]){break a}c=(N(H[H[a+48>>2]+(f<<2)>>2],12)+g|0)+8|0}ec(b,H[c>>2],0);break a;case 1:Ak(N(I[e+1|0]>>>6&1,12)+e|0,b);break a;case 2:wb(b,H[(I[N(I[e+1|0]>>>6&1,12)+e|0]<<2)+50880>>2],-1,0);break a;case 3:a=N(I[e+1|0]>>>6&1,12)+e|0;if(I[a|0]>5){break a}Ak(a,b);break a;case 4:g=b;b=0;a=I[e+1|0]>>>6&1;c=a+f|0;ec(g,c,a>>>0>c>>>0?1:b);break a;case 5:if(!I[a+21|0]|K[a+8>>2]>=f>>>0){break a}ec(b,H[H[a+48>>2]+(f<<2)>>2],0);break a;case 6:vf(d+16|0,b);f:{if(I[a+21|0]){xq(a,d+16|0,H[a+12>>2]);break f}b=H[a+28>>2];g:{if(b){ee(d+16|0,b,ub(b));break g}Kc(d+16|0,36)}h:{switch(I[a+20|0]-6|0){case 0:H[d>>2]=H[a+4>>2];wq(30,d+16|0,17693,d);break f;case 1:break h;default:break f}}iy(d+16|0,e)}Dh(d+16|0);break a;case 8:break b;case 7:break d;default:break c}}if(!I[a+21|0]){break c}c=d+16|0;vf(c,b);xq(a,c,H[H[a+48>>2]+(H[a+12>>2]<<2)>>2]);Dh(c);break a}a=H[a+28>>2];wb(b,a?a:28033,-1,0);break a}wb(b,H[a+44>>2],-1,0)}Ga=d+144|0;return 0}function qh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;a:{switch(b|0){case 10:H[c+12>>2]=0;G[c+16>>1]=1025;H[c>>2]=0;return;case 0:case 11:G[c+16>>1]=1;return;case 1:a=F[a|0];b=a>>31;G[c+16>>1]=4;H[c>>2]=a;H[c+4>>2]=b;return;case 2:b=I[a+1|0];a=F[a|0];G[c+16>>1]=4;a=b|a<<8;H[c>>2]=a;H[c+4>>2]=a>>31;return;case 3:e=I[a+2|0];b=I[a+1|0];a=F[a|0];G[c+16>>1]=4;a=e|(b<<8|a<<16);H[c>>2]=a;H[c+4>>2]=a>>31;return;case 4:a=I[a|0]|I[a+1|0]<<8|(I[a+2|0]<<16|I[a+3|0]<<24);G[c+16>>1]=4;a=a<<8&16711680|a<<24|(a>>>8&65280|a>>>24);H[c>>2]=a;H[c+4>>2]=a>>31;return;case 5:i=I[a+1|0];h=F[a|0];b=I[a+5|0];f=I[a+4|0];d=I[a+3|0];e=I[a+2|0];G[c+16>>1]=4;a=d>>>16|0;g=d<<16;d=e>>>8|0;H[c>>2]=b|(g|e<<24|f<<8);H[c+4>>2]=a|d|f>>>24|(i|h<<8);return;case 6:case 7:d=I[a+5|0];e=d>>>16|0;f=d<<16;d=e;g=f;f=I[a+4|0];e=f>>>8|0;g=g|f<<24;i=d|e;e=I[a+1|0];d=e>>>16|0;f=e<<16;d=f;f=I[a|0];h=d|f<<24;d=I[a+2|0];d=I[a+3|0]|d<<8;e=d|h;f=e|i;e=I[a+7|0];a=I[a+6|0];d=a>>>24|0;e=e|(g|a<<8);H[c>>2]=e;a=d|f;H[c+4>>2]=a;G[c+16>>1]=(b|0)!=6?(h&2146435072)==2146435072?a&1048575|e?1:8:8:4;return;case 8:case 9:G[c+16>>1]=4;H[c>>2]=b-8;H[c+4>>2]=0;return;default:break a}}H[c+8>>2]=a;H[c+12>>2]=b-12>>>1;G[c+16>>1]=J[((b&1)<<1)+33072>>1]}function Fo(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=b+c|0;d=I[a+9|0];m=d+1|0;h=H[a+56>>2];k=d+h|0;a:{if(!(I[k+2|0]|I[h+m|0])){f=m;d=c;i=b;j=b>>>8|0;break a}d=m;b:{while(1){f=d;i=d&65535;n=i+h|0;g=I[n|0];o=I[n+1|0];d=o|g<<8;if(d>>>0>=b>>>0){break b}if(i+4>>>0<=d>>>0){continue}break}if(!(d&65535)){break b}return ab(68684)}p=H[H[a+52>>2]+40>>2];if(p-4>>>0<d>>>0){return ab(68689)}c:{if(!(!(d&65535)|e+3>>>0<d>>>0)){if(d>>>0<e>>>0){return ab(68701)}g=d+h|0;j=(I[g+2|0]<<8|I[g+3|0])+d|0;if(p>>>0<j>>>0){return ab(68704)}l=d-e|0;o=I[g+1|0];g=I[g|0];d=j-b|0;break c}j=e;d=c}d:{if(i>>>0<=m>>>0){break d}e=i+(I[n+3|0]|I[n+2|0]<<8)|0;if(e+3>>>0<b>>>0){break d}if(b>>>0>=e>>>0){d=j-f|0;l=(b-e|0)+l|0;b=f;break d}return ab(68717)}i=b;b=I[k+7|0];if(b>>>0<(l&255)>>>0){return ab(68723)}F[k+7|0]=b-l;e=j;b=i&65535;j=b>>>8|0}l=I[k+6|0]|I[k+5|0]<<8;e:{if(l>>>0>=b>>>0){if(b>>>0<l>>>0){return ab(68732)}if((f&65535)!=(m|0)){return ab(68733)}f=h+m|0;F[f+1|0]=o;F[f|0]=g;F[k+6|0]=e;F[k+5|0]=e>>>8;break e}f=(f&65535)+h|0;F[f+1|0]=i;F[f|0]=j}if(I[H[a+52>>2]+24|0]&12){$a(b+h|0,0,d&65535)}b=b+h|0;F[b+1|0]=o;F[b|0]=g;F[b+3|0]=d;F[b+2|0]=d>>>8;H[a+20>>2]=H[a+20>>2]+c;return 0}function Oz(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;h=Ga-16|0;Ga=h;c=H[a+64>>2];a:{if(!H[c>>2]){e=ff(H[a>>2],0,c,H[a+152>>2]|30,0);if(e){break a}}e=0;c=H[a+40>>2];f=H[a+28>>2];if(c>>>0>=f>>>0|!H[b+16>>2]&c>>>0>=K[b+24>>2]){break a}j=h,k=SK(H[a+168>>2],H[a+172>>2],f,0),H[j+8>>2]=k;H[h+12>>2]=Ja;gh(H[a+64>>2],5,h+8|0);H[a+40>>2]=H[a+28>>2]}while(1){if(!(!b|e)){e=0;f=H[b+24>>2];if(!(I[b+28|0]&16|f>>>0>K[a+28>>2])){e=H[a+168>>2];d=SK(e,H[a+172>>2],f-1|0,0);g=Ja;i=(f|0)!=1;if(!i){zp(b);e=H[a+168>>2]}c=H[b+4>>2];e=Bc(H[a+64>>2],c,e,d,g);if(!i){d=I[c+28|0]|I[c+29|0]<<8|(I[c+30|0]<<16|I[c+31|0]<<24);g=I[c+24|0]|I[c+25|0]<<8|(I[c+26|0]<<16|I[c+27|0]<<24);F[a+112|0]=g;F[a+113|0]=g>>>8;F[a+114|0]=g>>>16;F[a+115|0]=g>>>24;F[a+116|0]=d;F[a+117|0]=d>>>8;F[a+118|0]=d>>>16;F[a+119|0]=d>>>24;d=I[c+36|0]|I[c+37|0]<<8|(I[c+38|0]<<16|I[c+39|0]<<24);c=I[c+32|0]|I[c+33|0]<<8|(I[c+34|0]<<16|I[c+35|0]<<24);F[a+120|0]=c;F[a+121|0]=c>>>8;F[a+122|0]=c>>>16;F[a+123|0]=c>>>24;F[a+124|0]=d;F[a+125|0]=d>>>8;F[a+126|0]=d>>>16;F[a+127|0]=d>>>24}if(f>>>0>K[a+36>>2]){H[a+36>>2]=f}H[a+208>>2]=H[a+208>>2]+1;yp(H[a+96>>2],f,H[b+4>>2])}b=H[b+16>>2];continue}break}Ga=h+16|0;return e}function Ih(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=Ga+-64|0;Ga=e;a:{if(!b){break a}c=H[b+4>>2];if(!(!(c&3)|H[b+36>>2]!=H[a+4>>2])){H[b+36>>2]=H[a+8>>2]}d=I[b|0];b:{c:{if((d|0)!=179){if(c&32|H[b+28>>2]!=H[a+4>>2]|(d|0)!=167){break c}d=H[a>>2];c=H[(H[a+16>>2]+(G[b+32>>1]<<4)|0)+8>>2];if(Ze(c)){sC(d,c);break b}f=H[d>>2];if(!(!H[a+12>>2]|I[c|0]==167)){d=e+8|0;$a(d,0,52);H[e+20>>2]=c;F[e+8|0]=179;c=H[a+8>>2];H[e+12>>2]=262144;H[e+36>>2]=c;c=d}c=nb(f,c,0);if(!I[f+87|0]){if(H[a+12>>2]){H[c+4>>2]=H[c+4>>2]|2097152}d=H[b+4>>2]&3;if(d){Xi(c,H[b+36>>2],d)}fb(f,b);d:{e:{f:{g:{b=I[c|0];switch(b-167|0){case 0:break d;case 1:case 2:break e;case 3:break f;default:break g}}if((b|0)!=113){break e}break d}b=Tk(c);F[c|0]=155;H[c+8>>2]=b;H[c+4>>2]=H[c+4>>2]|2048}b=Sd(H[a>>2],c);c=Yi(H[a>>2],c,b?H[b>>2]:32112)}H[c+4>>2]=H[c+4>>2]&-513;break a}fb(f,c);break b}if(H[b+28>>2]!=H[a+4>>2]){break c}H[b+28>>2]=H[a+8>>2]}g=b,h=Ih(a,H[b+12>>2]),H[g+12>>2]=h;g=b,h=Ih(a,H[b+16>>2]),H[g+16>>2]=h;c=H[b+20>>2];h:{if(I[b+5|0]&16){as(a,c,1);break h}Hh(a,c)}if(!(F[b+7|0]&1)){break b}c=H[b+44>>2];g=c,h=Ih(a,H[c+40>>2]),H[g+40>>2]=h;Hh(a,H[c+8>>2]);Hh(a,H[c+12>>2])}c=b}Ga=e- -64|0;return c}function Ou(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;f=Ga-16|0;Ga=f;e=H[a+8>>2];b=H[a>>2];H[b+24>>2]=H[b+24>>2]|64;d=0;a:{if(!c){break a}d=1;H[a+20>>2]=H[a+20>>2]+1;if(I[b+87|0]){Th(a,c,0);break a}b:{h=H[c+12>>2];if(!h){break b}d=H[c+16>>2];c:{if(d){g=I[d|0];if(!((g&223)!=67|(I[d+1|0]&223)!=82)){g=I[b+176|0];F[b+176|0]=e;d:{e:{if(tu(h,b+172|0)){d=H[a+24>>2];if(d>>>0>=K[b+172>>2]|!d){break d}if(I[64009]){break e}break d}if(!I[64009]){break d}}Th(a,c,13812)}H[b+180>>2]=c;F[b+178|0]=I[b+178|0]&254;d=0;H[f+12>>2]=0;hx(b,H[c+16>>2],-1,0,0,f+12|0,0);F[b+176|0]=g;e=H[b+64>>2];f:{if(!e|F[b+178|0]&1){break f}if((e|0)>H[a+12>>2]){H[a+12>>2]=e}g:{switch(e-7|0){case 0:Mb(b);break f;case 2:break f;default:break g}}if((e&255)==6){break f}Th(a,c,xg(b))}H[b+180>>2]=65056;dd(H[f+12>>2]);break a}d=H[c+4>>2];if(g|!d){break b}break c}d=H[c+4>>2];if(!d){break b}}b=Ff(b,d,H[H[b+16>>2]+(e<<4)>>2]);h:{if(!b){Th(a,c,1506);break h}i:{j:{if(!tu(H[c+12>>2],b+44|0)){break j}d=H[b+44>>2];if(d>>>0<2|d>>>0>K[a+24>>2]){break j}d=0;if(!su(b)){break a}if(I[64009]){break i}break a}d=0;if(!I[64009]){break a}}Th(a,c,13812)}d=0;break a}d=0;Th(a,c,0)}Ga=f+16|0;return d|0}function Lm(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ga-16|0;Ga=h;i=H[d>>2];H[h+12>>2]=i;a:{if(!i){j=1;i=a?-1:1;g=a?-1:0;l=b+c|0;a=0;while(1){if(b>>>0<l>>>0){a=qd(b,h)+b|0;H[h+8>>2]=a;c=H[h>>2];b=H[h+4>>2];Fe(0,h+8|0);c=SK(j,m,c,b);b=n;c=c+b|0;k=k+Ja|0;k=b>>>0>c>>>0?k+1|0:k;n=c;b=H[h+8>>2];while(1){if(!(I[b|0]|b>>>0>=l>>>0)){b=b+1|0;continue}break}H[h+8>>2]=b;j=i;m=g;continue}break}H[f>>2]=l-a;H[d>>2]=a;H[e>>2]=n;H[e+4>>2]=k;break a}i=Ga-16|0;Ga=i;c=H[h+12>>2]-2|0;while(1){if(!(b>>>0>c>>>0|F[c|0]>=0)){c=c-1|0;continue}break}c=c+1|0;H[h+12>>2]=c;qd(c,i+8|0);c=H[i+12>>2];H[h>>2]=H[i+8>>2];H[h+4>>2]=c;Ga=i+16|0;i=H[h>>2];m=i;c=0-i|0;i=a?i:c;j=i+H[e>>2]|0;c=H[h+4>>2];a=H[e+4>>2]+(a?c:0-(c+((m|0)!=0)|0)|0)|0;H[e>>2]=j;H[e+4>>2]=i>>>0>j>>>0?a+1|0:a;i=H[h+12>>2];b:{if((i|0)==(b|0)){F[g|0]=1;break b}g=H[h+12>>2];a=g-2|0;while(1){c:{if(a>>>0<=b>>>0){c=0;break c}c=I[a|0];a=a-1|0;if(!c){continue}}break}d:{e:{while(1){if(a>>>0>b>>>0){e=c<<24;c=I[a|0];if(!(c&128|e>>24)){break e}a=a-1|0;continue}break}if(g>>>0<=a+2>>>0|c){break d}}a=a+2|0}while(1){b=F[a|0];a=a+1|0;if((b|0)<0){continue}break}H[h+12>>2]=a;b=H[h+12>>2];H[f>>2]=i-b}H[d>>2]=b}Ga=h+16|0}function JA(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=zb(a);j=H[a+40>>2];m=jb(a);if((h|0)<0){Va(k,48,I[e+24|0],m)}n=j-1|0;o=g+1|0;j=0;while(1){l=H[e+20>>2];if((l|0)>(j|0)){Va(k,50,Oc(H[e>>2],G[(j<<2)+f>>1])+o|0,m);j=j+1|0;continue}break}a:{if(i){break a}if(!d){d=Db(a);Va(k,81,Oc(H[e>>2],G[f>>1])+o|0,d);f=Va(k,12,d,0);if(!((h|0)!=1|H[e>>2]!=(c|0))){Xa(k,53,g,m,d);pb(k,144)}fe(a,n,b,c,112);Xa(k,30,n,0,d);Yb(k,m);bb(k,H[k+108>>2]-2|0);bb(k,f);xb(a,d);break a}i=Cc(a,l);Xa(k,112,n,H[d+44>>2],b);Od(a,d);j=0;b=(l|0)>0?l:0;while(1){p=H[e>>2];if((b|0)!=(j|0)){Va(k,80,Oc(p,G[(j<<2)+f>>1])+o|0,i+j|0);j=j+1|0;continue}break}if(!((h|0)!=1|(c|0)!=(p|0))){p=(H[k+108>>2]+l|0)+1|0;j=0;while(1){if((b|0)!=(j|0)){r=Oc(H[e>>2],G[(j<<2)+f>>1])+o|0;q=J[H[d+4>>2]+(j<<1)>>1];Xa(k,52,r,p,(s=g,t=Oc(H[d+12>>2],q<<16>>16)+o|0,u=J[c+32>>1]==(q|0),u?s:t));pb(k,16);j=j+1|0;continue}break}Yb(k,m)}kb(k,96,i,l,0,ej(H[a>>2],d),l);ob(k,28,n,m,i,l);md(a,i,l)}j=I[e+24|0];b:{c:{if(j){break c}if(!(I[a+20|0]|(H[a+116>>2]|I[H[a>>2]+34|0]&8))){_i(a,787,2,0,-1,4);break b}if((h|0)<=0){j=0;break c}Rc(a);j=I[e+24|0]}Va(k,158,j&255,h)}lb(k,m);db(k,122,n)}function CB(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;l=H[H[b>>2]>>2];j=F[b+32|0]&1;m=!j;n=(l+m|0)+f|0;k=H[b+4>>2];if(g){i=d-g|0}else{h=H[a+44>>2];H[a+44>>2]=h+n;i=h+1|0}h=H[c+12>>2];a:{if(h){o=h+1|0;break a}o=H[c+8>>2]}h=H[a+8>>2];q=b,r=jb(a),H[q+24>>2]=r;Nh(a,H[b>>2],i,e,e?5:1);if(!j){Va(h,126,H[b+8>>2],i+l|0)}if(!((f|0)<=0|g)){jj(a,d,m+(i+l|0)|0,f)}g=0;f=0;b:{if((k|0)>0){f=OA(a,b,c,i,n);e=H[b+4>>2];d=H[a+44>>2];H[a+44>>2]=e+d;m=d+1|0;c:{if(!j){d=db(h,16,i+l|0);break c}d=db(h,120,H[b+8>>2])}Xa(h,90,m,i,H[b+4>>2]);if(I[H[a>>2]+87|0]){break b}j=Nc(h,H[b+20>>2]);H[j+8>>2]=n-e;e=H[j+16>>2];$a(H[e+16>>2],0,J[e+6>>1]);le(h,-1,e,-8);q=j,r=Bf(a,H[b>>2],k,J[e+8>>1]+(J[e+6>>1]^-1)|0),H[q+16>>2]=r;j=H[h+108>>2];e=j+1|0;Xa(h,13,e,0,e);p=jb(a);H[b+16>>2]=p;e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[b+12>>2]=e;Va(h,9,e,p);db(h,146,H[b+8>>2]);if(o){Va(h,16,o,H[b+24>>2])}bb(h,d);jj(a,i,m,H[b+4>>2]);bb(h,j)}if(o){d=H[b+8>>2];Va(h,59,o,H[h+108>>2]+4|0);Va(h,31,d,0);g=ob(h,39,d,0,i+k|0,l-k|0);db(h,130,d)}if(!f){f=OA(a,b,c,i,n)}ob(h,F[b+32|0]&1?139:138,H[b+8>>2],f,i+k|0,n-k|0);if(!g){break b}a=H[b+28>>2];if(!a){a=H[h+108>>2]}$i(h,g,a)}}function Ev(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=Ga-16|0;Ga=g;k=Ul(a);H[a+80>>2]=k;i=Ja;H[a+84>>2]=i;h=101;j=H[a+156>>2];l=j+k|0;j=j>>>0>l>>>0?i+1|0:i;a:{if(c>>>0<l>>>0&(d|0)<=(j|0)|(d|0)<(j|0)){break a}if(!(!b&(H[a+88>>2]==(k|0)&H[a+92>>2]==(i|0)))){h=Jc(H[a+68>>2],g+8|0,8,k,i);if(h){break a}h=101;if((I[g+8|0]|I[g+9|0]<<8|(I[g+10|0]<<16|I[g+11|0]<<24))!=-117058087|(I[g+12|0]|I[g+13|0]<<8|(I[g+14|0]<<16|I[g+15|0]<<24))!=-681336544){break a}}b=i;c=k+8|0;b=c>>>0<8?b+1|0:b;h=Kf(H[a+68>>2],c,b,e);if(h){break a}b=i;c=k+12|0;b=c>>>0<12?b+1|0:b;h=Kf(H[a+68>>2],c,b,a+52|0);if(h){break a}b=k+16|0;j=b>>>0<16?i+1|0:i;h=Kf(H[a+68>>2],b,j,f);if(h){break a}c=H[a+80>>2];d=H[a+84>>2];b:{if(c|d){b=H[a+156>>2];h=0;break b}b=i;c=k+20|0;b=c>>>0<20?b+1|0:b;h=Kf(H[a+68>>2],c,b,g);if(h){break a}b=k+24|0;i=b>>>0<24?i+1|0:i;h=Kf(H[a+68>>2],b,i,g+4|0);if(h){break a}e=H[g+4>>2];if(!e){e=H[a+168>>2];H[g+4>>2]=e}h=101;if(e-512>>>0>65024){break a}b=H[g>>2];if(b>>>0<32|b>>>0>65536|(XK(e)>>>0>1|XK(b)>>>0>=2)){break a}h=ui(a,g+4|0,-1);H[a+156>>2]=b;c=H[a+80>>2];d=H[a+84>>2]}j=d;c=b+c|0;j=c>>>0<b>>>0?j+1|0:j;H[a+80>>2]=c;H[a+84>>2]=j}Ga=g+16|0;return h}function tr(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;k=Ga-32|0;Ga=k;r=ib(d);j=ib(c);f=j;n=Gc(a);a:{b:{c:{d:{e:{if(d){H[k+16>>2]=d;p=tb(n,29319,k+16|0);if(p){break e}f=7;break a}g=f<<1|1;f=yb(n,SK(g,f>>>31|0,3,0),Ja);if(f){break d}f=7;break b}g=f;f=H[b+4>>2];l=f;i=f>>31;q=ib(p)-1|0;f=q;l=SK(l,i,f,f>>31);g=g+l|0;f=Ja;f=g>>>0<l>>>0?f+1|0:f;g=g+1|0;f=g?f:f+1|0;f=yb(n,g,f);if(f){break c}f=7;break b}s=((j<<2)+f|0)+2|0;h=f+g|0}l=h;m=Ya(f,c,j);t=j<<1;while(1){if(H[b>>2]){f=b;g=H[f>>2];h=g;while(1){h=H[h+12>>2];if(h){g=K[h+4>>2]>K[g+4>>2]?h:g;continue}else{while(1){h=f;i=H[f>>2];f=i+12|0;if((g|0)!=(i|0)){continue}break}H[h>>2]=H[g+12>>2]}break}i=H[g+4>>2];f:{if(d){g:{if(e){break g}if(!gm(I[i|0])){break g}h=r;f=d;break f}h=(I[H[g+8>>2]+i|0]==34)+q|0;f=p;break f}f=Ya(l,i,H[g+8>>2]);F[f+H[g+8>>2]|0]=0;Tf(f);h=I[H[g+4>>2]+H[g+8>>2]|0];H[k>>2]=f;H[k+4>>2]=(h|0)==39?29332:29357;f=Vd(t,s,5797,k);h=ib(f);i=H[g+4>>2]}i=i-c|0;o=H[g+8>>2];if((o|0)!=(h|0)){o=i+o|0;vd((h+i|0)+m|0,o+m|0,j-o|0);j=(h-H[g+8>>2]|0)+j|0;F[m+j|0]=0}Ya(i+m|0,f,h);_a(n,g);continue}break}wb(a,m,-1,-1);_a(n,m);f=0}Wa(p)}Ga=k+32|0;return f}function zd(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;a:{if(I[a+40|0]){break a}b:{c:{d:{if(!I[a+42|0]){c=2e3;b=1;d=1;break d}c=H[a+8>>2];if(c-1e4>>>0<4294952583){break c}b=H[a+16>>2];d=H[a+12>>2]}if(!I[a+41|0]){break b}}lA(a);return}F[a+40|0]=1;f=(d|0)<3;g=c-f|0;c=g<<16>>16;e=(+((((((N(f?d+12|0:d,306001)+306001|0)/1e4|0)+b|0)+((N(g,36525)+172251900>>>0)/100|0)|0)+((c|0)/400<<16>>16)|0)+(((c|0)/-100<<16)+131072>>16)|0)+-1524.5)*864e5;e:{if(P(e)<0x8000000000000000){c=P(e)>=1?~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0:0;d=~~e>>>0;break e}c=-2147483648;d=0}H[a>>2]=d;H[a+4>>2]=c;if(!I[a+43|0]){break a}b=N(H[a+24>>2],6e4)+N(H[a+20>>2],36e5)|0;g=b;h=b>>31;e=M[a+32>>3]*1e3;f:{if(P(e)<0x8000000000000000){f=P(e)>=1?~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0:0;b=~~e>>>0;break f}f=-2147483648;b=0}c=c+f|0;b=b+d|0;c=b>>>0<d>>>0?c+1|0:c;f=b;b=b+g|0;d=c+h|0;c=b;H[a>>2]=b;d=b>>>0<f>>>0?d+1|0:d;H[a+4>>2]=d;if(!I[a+44|0]){break a}F[a+44|0]=0;G[a+42>>1]=0;b=N(H[a+28>>2],6e4);H[a>>2]=c-b;H[a+4>>2]=d-((b>>31)+(c>>>0<b>>>0)|0)}}function UJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{e=H[c>>2];if((gb(e)|0)==5){break a}i=cb(e);if(!i){break a}e=bc(H[c>>2]);b:{c:{d:{if((b|0)==1){j=50404;h=50408;f=1;break d}k=cb(H[c+4>>2]);if(!k){break a}b=0;c=k;while(1){f=I[c|0];if(f){d=c+1|0;c=d;if(f>>>0>=192){while(1){c=d;d=c+1|0;if((I[c|0]&192)==128){continue}break}}b=b+1|0;continue}break}if(!b){break c}h=Ti(a,b<<3,b>>>29|0);if(!h){break a}j=(b<<2)+h|0;f=0;b=k;while(1){if(I[b|0]){g=f<<2;H[g+h>>2]=b;d=b+1|0;c=d;if(I[b|0]>=192){while(1){c=d;d=c+1|0;if((I[c|0]&192)==128){continue}break}}H[g+j>>2]=c-b;f=f+1|0;b=c;continue}break}if(!f){break c}}b=Cg(a);e:{if(!(b&1)|!e){break e}while(1){c=0;d=0;while(1){f:{if((c|0)==(f|0)){break f}g=c<<2;d=H[g+j>>2];if(d>>>0<=e>>>0){if(!Ob(i,H[h+g>>2],d)){break f}}c=c+1|0;continue}break}if(c>>>0>=f>>>0){break e}i=d+i|0;e=e-d|0;if(e){continue}break}e=0}g:{if(!(!(b&2)|!e)){while(1){b=e;c=0;while(1){if((c|0)==(f|0)){break g}h:{g=c<<2;d=H[g+j>>2];if(d>>>0<=b>>>0){e=b-d|0;if(!Ob(i+e|0,H[h+g>>2],d)){break h}}c=c+1|0;continue}break}b=0;if(e){continue}break g}}b=e}if(!k){break b}Wa(h);break b}b=e}wb(a,i,b,-1)}}function bj(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Ga-16|0;Ga=j;m=H[c+40>>2];a:{b:{h=H[c+20>>2];c:{d:{if((h|0)==1){e=G[b+32>>1];if((e|0)<0){break d}if(!m){break c}if(hb(H[H[b+4>>2]+N(e,12)>>2],m)){break d}break a}if(!e){break d}f=Tb(H[a>>2],h<<2,0);if(!f){break b}H[e>>2]=f}n=(h|0)>0?h:0;e=b+8|0;while(1){e:{f:{g:{h:{g=H[e>>2];if(g){if(H[g+36>>2]|(!I[g+54|0]|J[g+50>>1]!=(h|0))){break f}if(!m){break h}i=0;i:while(1){if((i|0)==(n|0)){i=n;break g}e=G[H[g+4>>2]+(i<<1)>>1];if((e|0)<0){break g}o=i<<2;k=H[o+H[g+32>>2]>>2];e=H[b+4>>2]+N(e&65535,12)|0;l=Of(e);if(hb(k,l?l:32112)){break g}l=H[e>>2];e=0;while(1){k=(e|0)==(h|0);if(k){break g}p=(e<<3)+c|0;if(hb(H[p+40>>2],l)){e=e+1|0;continue}else{if(f){H[f+o>>2]=H[p+36>>2]}if(k){break g}i=i+1|0;continue i}}}}if(!I[a+151|0]){b=H[H[c>>2]>>2];H[j+4>>2]=H[c+8>>2];H[j>>2]=b;Za(a,28107,j)}_a(H[a>>2],f);break b}if(((I[g+55|0]|I[g+56|0]<<8)&3)!=2){break f}if(!f){break e}e=0;while(1){if((e|0)==(n|0)){break e}H[(e<<2)+f>>2]=H[((e<<3)+c|0)+36>>2];e=e+1|0;continue}}if((i|0)==(h|0)){break e}}e=g+20|0;continue}break}H[d>>2]=g}f=0;break a}f=1}Ga=j+16|0;return f}function zo(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=Ga-16|0;Ga=j;d=H[a>>2];f=H[a+4>>2];e=H[a+44>>2];a:{b:{if(e){H[c>>2]=d+e;c=b+d|0;d=(b>>31)+f|0;H[a>>2]=c;H[a+4>>2]=b>>>0>c>>>0?d+1|0:d;break b}e=H[a+40>>2];h=e>>31;k=UK(d,f,e,h);if(!k){l=e;g=H[a+8>>2];i=g-d|0;m=e>>>0<i>>>0;e=H[a+12>>2]-(f+(d>>>0>g>>>0)|0)|0;d=Jc(H[a+24>>2],H[a+36>>2],m&(e|0)>=(h|0)|(e|0)>(h|0)?l:i,d,f);if(d){break a}e=H[a+40>>2]}e=e-k|0;if((e|0)>=(b|0)){H[c>>2]=k+H[a+36>>2];c=H[a+4>>2]+(b>>31)|0;d=b+H[a>>2]|0;c=d>>>0<b>>>0?c+1|0:c;H[a>>2]=d;H[a+4>>2]=c;break b}d=H[a+16>>2];c:{if((d|0)>=(b|0)){d=H[a+28>>2];break c}f=d;g=d>>31<<1|d>>>31;d=(d|0)<64;h=d?128:f<<1;d=d?0:g;i=b>>31;while(1){g=d;f=h;d=d<<1|f>>>31;h=f<<1;if((g|0)<=(i|0)&b>>>0>f>>>0|(g|0)<(i|0)){continue}break}d=Zd(H[a+28>>2],f,g);if(!d){d=7;break a}H[a+28>>2]=d;H[a+16>>2]=f}Ya(d,k+H[a+36>>2]|0,e);d=H[a+4>>2]+(e>>31)|0;f=e+H[a>>2]|0;d=f>>>0<e>>>0?d+1|0:d;H[a>>2]=f;H[a+4>>2]=d;e=b-e|0;while(1){if((e|0)>0){d=H[a+40>>2];f=(d|0)>(e|0)?e:d;d=zo(a,f,j+12|0);if(d){break a}Ya(H[a+28>>2]+(b-e|0)|0,H[j+12>>2],f);e=e-f|0;continue}break}H[c>>2]=H[a+28>>2]}d=0}Ga=j+16|0;return d}function Ry(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ga-48|0;Ga=h;H[h+40>>2]=0;H[h+44>>2]=0;H[h+32>>2]=0;H[h+36>>2]=0;H[h+24>>2]=0;H[h+28>>2]=0;H[h+20>>2]=b;H[h+16>>2]=d;H[h+8>>2]=0;H[f>>2]=0;H[g>>2]=0;i=(c>>31)+(e>>31)|0;j=c+e|0;i=j>>>0<e>>>0?i+1|0:i;j=j+17|0;i=j>>>0<17?i+1|0:i;i=Ib(j,i);a:{if(!i){b=7;break a}H[h+12>>2]=i;c=b+c|0;Ee(h+20|0,c,0,h+40|0);d=d+e|0;Ee(h+16|0,d,0,h+32|0);b:{c:{while(1){e=H[h+20>>2];j=H[h+16>>2];if(!(e|j)){break c}d:{b=H[h+40>>2];n=H[h+32>>2];k=H[h+44>>2];m=H[h+36>>2];l=b>>>0>n>>>0&(k|0)>=(m|0)|(k|0)>(m|0)?1:(b|0)!=(n|0)|(k|0)!=(m|0)?-1:0;l=a?0-l|0:l;if(!(l|(!j|!e))){e=h+12|0;Fm(e,a,h+24|0,h+8|0,b,k);b=Qy(e,h+20|0,h+16|0);if(b){break d}Ee(h+20|0,c,a,h+40|0);Ee(h+16|0,d,a,h+32|0);continue}if(!((e|0)!=0&(l|0)<0?0:j)){e=h+12|0;Fm(e,a,h+24|0,h+8|0,b,k);b=h+20|0;Fe(e,b);Ee(b,c,a,h+40|0);continue}b=h+12|0;Fm(b,a,h+24|0,h+8|0,n,m);e=b;b=h+16|0;Fe(e,b);Ee(b,d,a,h+32|0);continue}break}Wa(i);a=0;H[h+12>>2]=0;i=0;break b}a=H[h+12>>2];F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;b=0}H[f>>2]=i;H[g>>2]=a-i}Ga=h+48|0;return b}function TD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;g=Ga-16|0;Ga=g;a:{if(!b){e=ab(59406);break a}e=Mv(H[a+228>>2],b,3);H[g+12>>2]=e;b:{c:{if(e){break c}e=0;f=H[a+228>>2];d:{if(I[f+33|0]==2){break d}e:{if((Ka[H[16031]](H[f+44>>2])|0)<=H[f+20>>2]){break e}e=f+8|0;f:{g:{while(1){e=H[e>>2];if(e){if(!(I[e+28|0]&8?1:J[e+30>>1])){break g}e=e+36|0;continue}break}H[f+8>>2]=0;e=f+4|0;while(1){e=H[e>>2];if(!e){break e}if(!J[e+30>>1]){break f}e=e+36|0;continue}}H[f+8>>2]=e}e=Ka[H[f+36>>2]](H[f+40>>2],e)|0;if((e|0)==5){break e}if(e){break d}}e=Ka[H[16032]](H[f+44>>2],b,2)|0;H[g+12>>2]=e;e=e?0:7}if(e){break b}e=H[g+12>>2];if(e){break c}e=7;break b}f=np(H[a+228>>2],b,e);H[c>>2]=f;h:{d=d&1;i:{if(!(d|!H[f+20>>2])){H[a+200>>2]=H[a+200>>2]+1;break i}if(H[a+164>>2]==(b|0)){e=ab(59438);break h}H[f+20>>2]=a;if(!(!(d|!H[H[a+64>>2]>>2])&K[a+28>>2]>=b>>>0)){e=13;if(K[a+160>>2]<b>>>0){break h}if(d){Md();if(K[a+32>>2]>=b>>>0){lh(H[a+60>>2],b)}xp(a,b);Ld()}e=0;$a(H[f+4>>2],0,H[a+168>>2]);break a}H[a+204>>2]=H[a+204>>2]+1;e=Lv(f);if(e){break h}}e=0;break a}mp(f)}Jv(a);H[c>>2]=0}Ga=g+16|0;return e|0}function ge(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=Ga-16|0;Ga=g;H[g+12>>2]=0;i=g+12|0;while(1){a:{b:{if(!b){break b}d=Tb(a,76,0);if(!d){break b}k=d,l=rc(a,H[b+28>>2],c),H[k+28>>2]=l;k=d,l=aj(a,H[b+32>>2],c),H[k+32>>2]=l;k=d,l=nb(a,H[b+36>>2],c),H[k+36>>2]=l;k=d,l=rc(a,H[b+40>>2],c),H[k+40>>2]=l;k=d,l=nb(a,H[b+44>>2],c),H[k+44>>2]=l;k=d,l=rc(a,H[b+48>>2],c),H[k+48>>2]=l;f=I[b|0];H[d+56>>2]=e;F[d|0]=f;H[d+52>>2]=0;e=nb(a,H[b+60>>2],c);H[d+8>>2]=0;H[d+12>>2]=0;H[d+60>>2]=e;e=H[b+4>>2];H[d+20>>2]=-1;H[d+24>>2]=-1;H[d+4>>2]=e&-33;G[d+2>>1]=J[b+2>>1];e=oC(a,H[b+64>>2]);H[d+68>>2]=0;H[d+64>>2]=e;h=H[b+72>>2];f=Ga-16|0;Ga=f;H[f+12>>2]=0;e=f+12|0;while(1){c:{if(!h){break c}j=e;e=mC(a,0,h);H[j>>2]=e;if(!e){break c}e=e+36|0;h=H[h+36>>2];continue}break}Ga=f+16|0;H[d+72>>2]=H[f+12>>2];d:{if(H[b+68>>2]){if(I[a+87|0]){H[d+16>>2]=H[b+16>>2];break d}e=Ga-32|0;Ga=e;H[e+12>>2]=0;H[e+8>>2]=64;H[e+4>>2]=65;H[e+24>>2]=d;H[e>>2]=0;lc(e,d);Ga=e+32|0}e=I[a+87|0];H[d+16>>2]=H[b+16>>2];if(!e){break a}}H[d+56>>2]=0;hc(a,d)}Ga=g+16|0;return H[g+12>>2]}H[i>>2]=d;b=H[b+52>>2];i=d+52|0;e=d;continue}}function Lv(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Ga-16|0;Ga=e;c=H[a+20>>2];H[e+12>>2]=0;a:{b:{c:{b=H[c+232>>2];if(!b){break c}b=_v(b,H[a+24>>2],e+12|0);if(b){break a}d=H[e+12>>2];if(!d){break c}b=H[c+232>>2];g=H[b+8>>2];h=H[a+4>>2];b=J[b+66>>1];b=(b<<16|b)&130560;f=H[c+168>>2];f=(b|0)<(f|0)?b:f;d=SK(b|24,0,d-1|0,0)+56|0;b=Ja;b=Jc(g,h,f,d,d>>>0<56?b+1|0:b);break b}b=H[c+168>>2];b=Jc(H[c+64>>2],H[a+4>>2],b,SK(b,H[c+172>>2],H[a+24>>2]-1|0,0),Ja);b=(b|0)==522?0:b}if(H[a+24>>2]!=1){break a}if(b){H[c+112>>2]=-1;H[c+116>>2]=-1;H[c+120>>2]=-1;H[c+124>>2]=-1;break a}a=H[a+4>>2];b=I[a+28|0]|I[a+29|0]<<8|(I[a+30|0]<<16|I[a+31|0]<<24);d=I[a+24|0]|I[a+25|0]<<8|(I[a+26|0]<<16|I[a+27|0]<<24);F[c+112|0]=d;F[c+113|0]=d>>>8;F[c+114|0]=d>>>16;F[c+115|0]=d>>>24;F[c+116|0]=b;F[c+117|0]=b>>>8;F[c+118|0]=b>>>16;F[c+119|0]=b>>>24;b=I[a+36|0]|I[a+37|0]<<8|(I[a+38|0]<<16|I[a+39|0]<<24);a=I[a+32|0]|I[a+33|0]<<8|(I[a+34|0]<<16|I[a+35|0]<<24);F[c+120|0]=a;F[c+121|0]=a>>>8;F[c+122|0]=a>>>16;F[c+123|0]=a>>>24;F[c+124|0]=b;F[c+125|0]=b>>>8;F[c+126|0]=b>>>16;F[c+127|0]=b>>>24;b=0}Ga=e+16|0;return b}function bn(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{if(I[a+8|0]!=2){break a}i=H[a+4>>2];Jb(a);if(I[i+17|0]){d=H[a+4>>2];m=H[d>>2];fp(d);b:{c:{if(I[d+18|0]){break c}d:{e=H[d+48>>2];if((e|0)!=(Ud(d,e)|0)){j=H[d+36>>2];if(((K[16164]/(j>>>0)|0)+1|0)!=(e|0)){break d}}c=ab(70916);break b}g=eb(H[H[d+12>>2]+56>>2]+36|0);f=g;e:{h=H[a>>2];k=H[h+260>>2];if(!k){break e}f=H[h+20>>2];f=(f|0)>0?f:0;l=H[h+16>>2];while(1){f:{n=H[h+252>>2];if((c|0)!=(f|0)){if(H[((c<<4)+l|0)+4>>2]!=(a|0)){break f}}else{c=f}a=Ka[k|0](n,H[(c<<4)+l>>2],e,g,j)|0;f=a>>>0<g>>>0?a:g;if(f){break e}c=0;break b}c=c+1|0;continue}}a=rv(d,e,f);if(a>>>0>e>>>0){c=ab(70943);break b}c=0;if(a>>>0<e>>>0){c=Jg(d,0,0)}h=(f|0)==(g|0);while(1){if(!(a>>>0>=e>>>0|c)){c=qv(d,a,e,h);e=e-1|0;continue}break}e=0;if(!(!g|(c|0)!=101&(c|0)!=0)){c=_b(H[H[d+12>>2]+72>>2]);if((f|0)==(g|0)){Cb(H[H[d+12>>2]+56>>2]+32|0,0);Cb(H[H[d+12>>2]+56>>2]+36|0,0)}Cb(H[H[d+12>>2]+56>>2]+28|0,a);H[d+48>>2]=a;F[d+19|0]=1}if(!c){break c}Wq(m);e=c}c=e}if(c){break a}}if(I[i+19|0]){dB(H[i>>2],H[i+48>>2])}c=Rr(H[i>>2],b,0)}return c}function yD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;e=(I[b|0]&63)+b|0;a:{b:{switch(I[b+1|0]-1|0){case 1:d=I[e+1|0]|F[e|0]<<8;f=d;d=d>>31;break a;case 2:d=I[e+2|0]|(I[e+1|0]<<8|F[e|0]<<16);f=d;d=d>>31;break a;case 3:d=I[e|0]|I[e+1|0]<<8|(I[e+2|0]<<16|I[e+3|0]<<24);d=d<<24|d<<8&16711680|(d>>>8&65280|d>>>24);f=d;d=d>>31;break a;case 4:d=I[e+3|0];g=d>>>16|0;f=d<<16;d=g;h=f;f=I[e+2|0];g=f>>>8|0;f=h|f<<24;h=d|g;d=I[e+4|0];g=d>>>24|0;f=I[e+5|0]|(d<<8|f);d=g|h|(I[e+1|0]|F[e|0]<<8);break a;case 5:d=I[e+4|0]|I[e+5|0]<<8|(I[e+6|0]<<16|I[e+7|0]<<24);f=I[e|0]|I[e+1|0]<<8|(I[e+2|0]<<16|I[e+3|0]<<24);g=f;e=g<<24|g<<8&16711680;f=((d&255)<<24|g>>>8)&-16777216|((d&16777215)<<8|g>>>24)&16711680|(d>>>8&65280|d>>>24);d=e|((d<<24|g>>>8)&65280|(d<<8|g>>>24)&255);break a;case 8:f=1;break a;default:return yj(a,b,c)|0;case 7:break a;case 0:break b}}d=F[e|0];f=d;d=d>>31}e=H[c+8>>2];g=H[c+12>>2];if(e>>>0>f>>>0&(g|0)>=(d|0)|(d|0)<(g|0)){return F[c+24|0]}if(e>>>0<f>>>0&(d|0)>=(g|0)|(d|0)>(g|0)){return F[c+25|0]}if(J[c+20>>1]>=2){return _h(a,b,c,1)|0}F[c+26|0]=1;return F[c+22|0]}function Iq(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ga-16|0;Ga=g;a:{b:{c:{d:{e:{f=H[b>>2];if(!f){h=H[a+232>>2];break e}e=H[f+32>>2];k=H[f+16>>2];j=tk(k,H[f+20>>2],c,d);i=d-j|0;if((i|0)<=0){d=267;break a}h=j>>31;m=h;l=(ce(j,h)+(e+i|0)|0)+ce(i,0)|0;h=H[a+232>>2];if((l|0)>(h|0)){if(k){break e}a=Ub(l);H[f+36>>2]=a;if(!a){break d}k=H[f+16>>2]}if(k){e=pc(H[f+36>>2]+e|0,j,m)+e|0}a=pc(H[f+36>>2]+e|0,i,0)+e|0;Ya(a+H[f+36>>2]|0,c+j|0,i);H[f+32>>2]=a+i;H[f+12>>2]=H[f+12>>2]+1;e=H[f+28>>2];if(H[f+24>>2]<(d|0)){a=d<<1;e=Ae(e,a);if(!e){break d}H[f+28>>2]=e;H[f+24>>2]=a}H[f+16>>2]=e;Ya(e,c,d);H[f+20>>2]=d;d=0;break a}e=Ub(h+40|0);H[g+12>>2]=e;if(!e){break d}H[e>>2]=0;H[e+4>>2]=0;H[e+32>>2]=11;H[e+24>>2]=0;H[e+28>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e+36>>2]=e+40;if(!f){break c}H[g+8>>2]=H[f>>2];d=Iq(a,g+8|0,c,d);a=H[g+8>>2];if(!H[f>>2]){H[f>>2]=a}H[f+4>>2]=e;c=H[f+8>>2];H[e>>2]=a;H[e+8>>2]=c;H[e+28>>2]=H[f+28>>2];H[e+24>>2]=H[f+24>>2];H[f+28>>2]=0;break b}d=7;break a}H[e+8>>2]=e;d=Iq(a,g+12|0,c,d);e=H[g+12>>2]}H[b>>2]=e}Ga=g+16|0;return d}function Sf(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=Ga-32|0;Ga=h;e=H[a>>2];a:{if(!(I[e+24|0]&16)){if(kf(a)){break a}}f=Dc(e,c,d);b:{if(!f){c:{if(I[a+25|0]|I[e+177|0]){break c}f=Wc(e+384|0,c);if(!f){if(Fb(c,17571,7)){break c}f=0;g=It(c+7|0);if(!(!g|!(I[g+5|0]&48))){f=dx(e,c,34176,g,0)}if(!f){break c}}i=Ga-16|0;Ga=i;k=H[f>>2];H[i+12>>2]=0;j=1;d:{if(H[f+20>>2]){break d}g=H[a>>2];e=H[k+4>>2];if(e){j=0;if((e|0)!=H[k+8>>2]){break d}}j=0;e=yb(g,64,0);if(!e){break d}l=Xb(g,H[f+4>>2]);H[e>>2]=l;if(!l){_a(g,e);break d}H[f+20>>2]=e;j=1;F[e+43|0]=1;H[e+24>>2]=1;m=H[H[g+16>>2]+12>>2];G[e+32>>1]=65535;H[e+60>>2]=m;H[e+28>>2]=H[e+28>>2]|32768;Yg(a,e,Xb(g,l));Yg(a,e,0);Yg(a,e,Xb(g,H[e>>2]));if(!Jo(g,e,f,H[k+8>>2],i+12|0)){break d}e=H[i+12>>2];H[i>>2]=e;Za(a,8310,i);_a(g,e);Aq(g,f)}Ga=i+16|0;if(!j){break c}f=H[f+20>>2];break a}f=0;if(b&2){break a}F[a+17|0]=1;break b}if(!I[a+25|0]|I[f+43|0]!=1){break a}}b=b&1?1713:13482;e:{if(d){H[h+24>>2]=c;H[h+20>>2]=d;H[h+16>>2]=b;Za(a,5952,h+16|0);break e}H[h+4>>2]=c;H[h>>2]=b;Za(a,7221,h)}f=0}Ga=h+32|0;return f}function Tm(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;j=cb(H[b>>2]);g=bc(H[b>>2]);if(j){k=-1;b=0;while(1){a:{b:{if((b|0)!=4){d=Ax(a,b-429938|0);if(d){break b}f=b}if(!e){break a}F[e+21|0]=0;H[e+28>>2]=i+1;return e}c:{d:{if(H[d+24>>2]!=(g|0)|e){break d}if(Ob(H[d+12>>2],j,g)){break d}F[d+21|0]=0;h=H[d+28>>2];e=d;break c}h=H[d+28>>2];d=k>>>0>h>>>0;k=d?h:k;f=d?b:f}i=i>>>0<h>>>0?h:i;b=b+1|0;continue}break}b=Ib(g+33|0,0);if(!b){ic(a);return 0}H[b+8>>2]=0;H[b+12>>2]=0;H[b>>2]=0;H[b+4>>2]=0;H[b+24>>2]=0;H[b+28>>2]=0;H[b+16>>2]=0;H[b+20>>2]=0;d=b+32|0;H[b+12>>2]=d;if(Eh(b,c,Ya(d,j,g+1|0))){Wa(b);return 0}H[b+24>>2]=g;H[b+28>>2]=i+1;d=f-429938|0;f=(d|0)<0;e=H[a+12>>2];c=e+232|0;e:{f:{g:{h:{while(1){c=H[c>>2];if(c){if(H[c>>2]==H[a+16>>2]|f?(d|0)==H[c+4>>2]:0){break h}c=c+16|0;continue}break}c=yb(H[e>>2],20,0);if(!c){break f}f=H[a+16>>2];H[c+4>>2]=d;H[c>>2]=f;H[c+16>>2]=H[e+232>>2];H[e+232>>2]=c;if(H[a+20>>2]){break g}H[a+20>>2]=-1;break g}e=H[c+12>>2];if(!e){break g}Ka[e|0](H[c+8>>2])}H[c+12>>2]=93;H[c+8>>2]=b;break e}bA(b)}a=Ax(a,d)}else{a=0}return a}function kA(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c=Ga-112|0;Ga=c;$a(c+56|0,0,44);zd(a);d=H[a+4>>2];f=d;e=H[a>>2];d=d-((e>>>0<947587585)+49596|0)|0;g=e-947587585|0;a:{if((d|0)==-500&g>>>0<=98047998|d>>>0<4294966796){d=c+8|0;Ya(d,a,48);Ri(d);F[c+48|0]=0;f=H[c+16>>2];e=((f|0)%4|0)+2e3|0;H[c+16>>2]=e;zd(d);d=TK(H[c+8>>2],H[c+12>>2],1e3,0);H[c+104>>2]=d-413362496;H[c+108>>2]=Ja-((d>>>0<413362496)+49|0);g=(f-e|0)+1900|0;break a}d=VK(e,f,1e3,0);H[c+104>>2]=d-413362496;H[c+108>>2]=Ja-((d>>>0<413362496)+49|0);g=1900}d=c+56|0;la(70664,70668,70672);h=c+104|0;ha(h|0,70684);H[17681]=H[(H[17679]?70676:70672)>>2];f=70684;b:{if(H[16065]){e=1;i=H[16066];if(!i){break b}f=d;if(Ka[i|0](h,d)|0){break b}}e=1;if(!f){break b}Ya(d,f,44);e=0}c:{if(e){fc(b,13590,-1);a=1;break c}H[a+8>>2]=H[c+76>>2]+g;H[a+12>>2]=H[c+72>>2]+1;H[a+16>>2]=H[c+68>>2];H[a+20>>2]=H[c+64>>2];H[a+24>>2]=H[c+60>>2];b=H[c+56>>2];F[a+46|0]=0;F[a+44|0]=0;H[a+40>>2]=16842752;j=a,k=(+(UK(H[a>>2],H[a+4>>2],1e3,0)>>>0)+ +(Ja|0)*4294967296)*.001+ +(b|0),M[j+32>>3]=k;a=0}Ga=c+112|0;return a}function or(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-48|0;Ga=d;H[d+16>>2]=d+44;H[d+20>>2]=d+40;c=1;a:{if((Vm(a,14051,d+16|0)|0)!=2){break a}b:{if(I[a+5|0]==58){H[d>>2]=d+36;c=1;if((Vm(a+6|0,14070,d)|0)!=1){break a}c=a+8|0;f=0;if(I[a+8|0]!=46){break b}e=I[a+9|0];f=0;if(e-58>>>0<4294967286){break b}c=a+9|0;f=1;while(1){if(e-58>>>0>=4294967286){h=h*10+ +(e<<24>>24)+-48;f=f*10;e=I[c+1|0];c=c+1|0;continue}break}f=h/f;break b}c=a+5|0;H[d+36>>2]=0;f=0}F[b+43|0]=1;G[b+40>>1]=0;H[b+20>>2]=H[d+44>>2];H[b+24>>2]=H[d+40>>2];M[b+32>>3]=f+ +H[d+36>>2];a=c;e=Ga-16|0;Ga=e;while(1){c=a;a=a+1|0;if(F[I[c|0]+30016|0]&1){continue}break}H[b+28>>2]=0;i=-1;c:{d:{e:{f:{g:{g=I[c|0];switch(g-43|0){case 0:break f;case 2:break e;default:break g}}if((g&223)==90){break d}g=(g|0)!=0;break c}i=1}H[e+4>>2]=e+8;H[e>>2]=e+12;g=1;if((Vm(a,14059,e)|0)!=2){break c}H[b+28>>2]=N(H[e+8>>2]+N(H[e+12>>2],60)|0,i);a=c+6|0}while(1){c=a;a=a+1|0;if(F[I[c|0]+30016|0]&1){continue}break}F[b+45|0]=1;g=I[c|0]!=0}Ga=e+16|0;c=1;if(g){break a}F[b+44|0]=H[b+28>>2]!=0;c=0}Ga=d+48|0;return c}function Ro(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;while(1){f=c;while(1){h=b+f|0;d=I[h|0];if(!(!d|(d|0)==47)){f=f+1|0;continue}break}if((c|0)<(f|0)){g=f-c|0;e=Ga-4224|0;Ga=e;a:{b:{c:{d=b+c|0;if(I[d|0]!=46){break c}if((g|0)==1){break a}if((g|0)!=2|I[d+1|0]!=46){break c}c=H[a+16>>2];if((c|0)<2){break b}d=H[a+8>>2];while(1){c=c-1|0;H[a+16>>2]=c;if(I[c+d|0]!=47){continue}break}break a}c=H[a+16>>2];if(H[a+12>>2]<=((c+g|0)+2|0)){H[a>>2]=1;break a}H[a+16>>2]=c+1;F[c+H[a+8>>2]|0]=47;Ya(H[a+8>>2]+H[a+16>>2]|0,d,g);c=H[a+16>>2]+g|0;H[a+16>>2]=c;if(H[a>>2]){break a}F[c+H[a+8>>2]|0]=0;d=H[a+8>>2];if(Ka[H[16250]](d,e+4112|0)|0){if(H[17665]==44){break a}i=a,j=Td(xe(41961),3260,d,41961),H[i>>2]=j;break a}if((H[e+4124>>2]&61440)!=40960){break a}c=H[a+4>>2];H[a+4>>2]=c+1;d:{e:{if((c|0)>=201){c=xe(41967);break e}c=Ka[H[16247]](d,e,4096)|0;if(c-4096>>>0>4294963200){break d}c=Td(xe(41972),11266,d,41972)}H[a>>2]=c;break a}F[c+e|0]=0;H[a+16>>2]=I[e|0]!=47?H[a+16>>2]+(g^-1)|0:0;Ro(a,e);break a}H[a>>2]=1}Ga=e+4224|0;d=I[h|0]}c=f+1|0;if(d){continue}break}}function Ut(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;H[b+4>>2]=a;c=H[b>>2];m=(c|0)>0?c:0;a:{while(1){if((g|0)!=(m|0)){c=N(g,56);g=g+1|0;i=c+H[b+12>>2]|0;if(H[i+48>>2]){h=0;j=0;e=H[i+48>>2];d=H[e>>2];k=H[H[d+8>>2]+24>>2];c=Ut(d,H[e+4>>2]);b:{if(c){break b}c=H[e+16>>2];f=c;l=c>>31;c=H[d+56>>2];c:{if(c){h=H[d+64>>2];j=H[d+68>>2];break c}c=St(k,d+56|0);H[d+64>>2]=0;H[d+68>>2]=0;if(c){break b}c=H[d+56>>2]}H[e+8>>2]=h;H[e+12>>2]=j;H[e+48>>2]=c;e=d- -64|0;c=j+l|0;d=f+h|0;c=d>>>0<f>>>0?c+1|0:c;H[e>>2]=d;H[e+4>>2]=c;c=Ao(i)}}else{c=0}if(!c){continue}break a}break}g=H[b>>2];while(1){if((g|0)>=2){d=Ga-16|0;Ga=d;g=g-1|0;c=H[b>>2]/2|0;d:{if((g|0)>=(c|0)){f=g-c<<1;c=f|1;break d}c=H[b+8>>2]+(g<<3)|0;f=H[c>>2];c=H[c+4>>2]}e=H[b+12>>2];e:{if(!H[(e+N(f,56)|0)+24>>2]){break e}if(!H[(e+N(c,56)|0)+24>>2]){c=f;break e}h=H[b+4>>2];H[d+12>>2]=0;k=f;l=c;f=e+N(f,56)|0;c=e+N(c,56)|0;c=(Ka[H[h+32>>2]](h,d+12|0,H[f+32>>2],H[f+20>>2],H[c+32>>2],H[c+20>>2])|0)<=0?k:l}H[H[b+8>>2]+(g<<2)>>2]=c;Ga=d+16|0;continue}break}c=I[H[a+12>>2]+23|0]}return c}function Nz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;h=c+d|0;f=c;while(1){a:{if(f>>>0<h>>>0){d=f+1|0;e=I[f|0];if(e>>>0<192){f=d;break a}e=I[e+31856|0];while(1){b:{if((d|0)==(h|0)){d=h}else{f=I[d|0];if((f&192)==128){break b}}f=d;e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break a}e=f&63|e<<6;d=d+1|0;continue}}c:{if(!g){break c}i=ye(H[a+12>>2],H[a+8>>2]+g<<2,0);if(!i){return 7}g=H[a+8>>2];d:while(1){e:{if(c>>>0<h>>>0){d=c+1|0;e=I[c|0];if(e>>>0<192){c=d;break e}e=I[e+31856|0];while(1){f:{if((d|0)==(h|0)){c=h}else{c=I[d|0];if((c&192)==128){break f}c=d}e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break e}e=c&63|e<<6;d=d+1|0;continue}}H[a+8>>2]=g;H[a+12>>2]=i;break c}if((br(e)|0)==(b|0)){continue}if(cr(e)){continue}d=0;f=(g|0)>0?g:0;while(1){g:{if((d|0)!=(f|0)){if(H[(d<<2)+i>>2]<(e|0)){break g}f=d}d=g;while(1){if((d|0)>(f|0)){j=(d<<2)+i|0;d=d-1|0;H[j>>2]=H[(d<<2)+i>>2];continue}break}H[(f<<2)+i>>2]=e;g=g+1|0;continue d}d=d+1|0;continue}}}return 0}if((br(e)|0)==(b|0)){continue}g=!cr(e)+g|0;continue}}function Sz(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=Ga-32|0;Ga=d;c=cw(a);a:{if(c){break a}b:{if(I[a+7|0]){break b}if(!(!H[H[a+68>>2]>>2]|I[a+5|0]==4)){e=fh(H[a+64>>2]);f=e&512;c:{if(f){e=e&1024;break c}H[d+8>>2]=-117058087;H[d+12>>2]=-681336544;Cb(d+16|0,H[a+48>>2]);c=H[a+68>>2];g=Ul(a);h=Ja;c=Jc(c,d+24|0,8,g,h);d:{if(!c){if((I[d+24|0]|I[d+25|0]<<8|(I[d+26|0]<<16|I[d+27|0]<<24))!=-117058087|(I[d+28|0]|I[d+29|0]<<8|(I[d+30|0]<<16|I[d+31|0]<<24))!=-681336544){break d}c=Bc(H[a+68>>2],31996,1,g,h)}if((c|0)==522){break d}if(c){break a}}e=e&1024;if(!(e|!I[a+8|0])){c=Ge(H[a+68>>2],I[a+10|0]);if(c){break a}}c=Bc(H[a+68>>2],d+8|0,12,H[a+88>>2],H[a+92>>2]);if(c){break a}}if(!e){c=I[a+10|0];c=Ge(H[a+68>>2],((c|0)==3)<<4|c);if(c){break a}}c=H[a+84>>2];H[a+88>>2]=H[a+80>>2];H[a+92>>2]=c;if(!b|f){break b}H[a+48>>2]=0;c=bw(a);if(!c){break b}break a}b=H[a+84>>2];H[a+88>>2]=H[a+80>>2];H[a+92>>2]=b}c=H[a+228>>2];b=c;while(1){b=H[b>>2];if(b){G[b+28>>1]=J[b+28>>1]&65527;b=b+32|0;continue}break}H[c+8>>2]=H[c+4>>2];F[a+17|0]=4;c=0}Ga=d+32|0;return c}function Rk(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ga+-64|0;Ga=e;a:{if(H[a+36>>2]){break a}g=H[a+8>>2];f=H[b+20>>2];c=H[b+4>>2];if(c&33554432){H[e+16>>2]=H[f+16>>2];qc(a,0,16744,e+16|0);Va(g,9,H[b+48>>2],H[b+44>>2]);c=H[b+28>>2];break a}H[b+4>>2]=c|33554432;c=1;d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[b+48>>2]=d;j=b,k=Va(g,74,0,d)+1|0,H[j+44>>2]=k;if(!(I[b+4|0]&64)){h=Sb(g,14)}H[e+4>>2]=H[f+16>>2];H[e>>2]=h?29357:29208;qc(a,1,16723,e);d=I[b|0]!=138;c=d?c:H[H[f+28>>2]>>2];i=H[a+44>>2];Pd(e+32|0,0,i+1|0);H[a+44>>2]=c+i;b:{if(!d){F[e+32|0]=10;d=H[e+36>>2];H[e+44>>2]=d;H[e+48>>2]=c;Xa(g,75,0,d,(c+d|0)-1|0);break b}F[e+32|0]=3;Va(g,71,0,H[e+36>>2])}c=H[a>>2];c:{if(H[f+60>>2]){d=sc(c,155,24034);if(d){F[d+1|0]=67;d=mb(a,52,nb(c,H[H[f+60>>2]+12>>2],0),d)}else{d=0}fb(c,H[H[f+60>>2]+12>>2]);H[H[f+60>>2]+12>>2]=d;break c}j=f,k=mb(a,148,sc(c,155,23263),0),H[j+60>>2]=k}c=0;H[f+8>>2]=0;if(Sc(a,f,e+32|0)){F[b+2|0]=I[b|0];F[b|0]=182;break a}c=H[e+36>>2];H[b+28>>2]=c;if(h){bb(g,h)}Xa(g,67,H[b+48>>2],H[b+44>>2],1);lj(a)}Ga=e- -64|0;return c}function Os(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=H[a+8>>2];F[c|0]=1;h=H[c+40>>2];while(1){if(H[c+44>>2]>(n|0)){e=H[h>>2];f=H[e+20>>2];l=0;a:{if(!(F[e+7|0]&1)){k=0;break a}e=H[H[e+44>>2]+40>>2];if(!(!(H[H[h+4>>2]+4>>2]&32)|(!H[c+36>>2]|!b))){if(!g){g=H[a+44>>2]+1|0;H[a+44>>2]=g}Va(j,80,b,g)}k=jb(a);zc(a,e,k,16)}b:{if(!f){m=0;break b}m=H[f>>2];l=Cc(a,m);Nh(a,f,l,0,1);e=H[h+12>>2];if((e|0)<0){break b}if(!k){k=jb(a);e=H[h+12>>2]}o=h,p=DB(a,d,e,k,f,l),H[o+12>>2]=p}if(I[H[h+4>>2]+4|0]&32){e=f+8|0;i=0;f=0;while(1){if(!((f|0)>=(m|0)|i)){f=f+1|0;i=Sd(a,H[e>>2]);e=e+16|0;continue}break}i=i?i:H[H[a>>2]+8>>2];c:{if(g){break c}if(!H[c+36>>2]){g=0;break c}g=H[a+44>>2]+1|0;H[a+44>>2]=g}kb(j,85,g,0,0,i,-2)}Xa(j,162,0,l,H[h+8>>2]);Pc(j,H[h+4>>2],-7);pb(j,m&255);md(a,l,m);if(k){lb(j,k)}h=h+20|0;n=n+1|0;continue}break}d:{if(!g){i=0;if(!b){break d}g=b;if(!H[c+36>>2]){break d}}i=db(j,15,g)}f=H[c+28>>2];e=0;while(1){if((e|0)<H[c+36>>2]){oc(a,H[f+4>>2],H[f+12>>2]);f=f+20|0;e=e+1|0;continue}break}F[c|0]=0;if(i){Pn(j,i)}}function Bw(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Ga-48|0;Ga=d;c=H[b>>2];if((c|0)<=0){a=48}else{H[b>>2]=c-1;i=H[a>>2];h=i;j=H[a+4>>2];b=H[a+12>>2];l=b;e=Ga-16|0;Ga=e;k=H[a+8>>2];f=k;g=b>>>16&32767;c=0;a:{if(g>>>0<16383){break a}c=b>>31^2147483647;if(g-16415>>>0<=4294967263){break a}th(e,h,j,f,b&65535|65536,16495-g|0);c=H[e>>2];c=(b|0)>0|(b|0)>=0?c:0-c|0}Ga=e+16|0;g=0;e=0;f=Ga-16|0;Ga=f;b=c;if(c){c=b>>31;e=(c^b)-c|0;c=Q(e);ud(f,e,0,0,0,c+81|0);h=0;e=h+H[f+8>>2]|0;c=(H[f+12>>2]^65536)+(16414-c<<16)|0;c=e>>>0<h>>>0?c+1|0:c;g=e;e=b&-2147483648|c;h=H[f+4>>2];c=H[f>>2]}else{h=0;c=0}H[d+32>>2]=c;H[d+36>>2]=h;H[d+40>>2]=g;H[d+44>>2]=e;Ga=f+16|0;c=Ga-16|0;Ga=c;vm(c,i,j,k,l,H[d+32>>2],H[d+36>>2],H[d+40>>2],H[d+44>>2]^-2147483648);e=H[c>>2];f=H[c+4>>2];g=H[c+12>>2];H[d+24>>2]=H[c+8>>2];H[d+28>>2]=g;H[d+16>>2]=e;H[d+20>>2]=f;Ga=c+16|0;De(d,H[d+16>>2],H[d+20>>2],H[d+24>>2],H[d+28>>2],0,0,0,1073889280);c=H[d+4>>2];H[a>>2]=H[d>>2];H[a+4>>2]=c;c=H[d+12>>2];H[a+8>>2]=H[d+8>>2];H[a+12>>2]=c;a=b+48|0}Ga=d+48|0;return a<<24>>24}function ht(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c=Ga+-64|0;Ga=c;d=H[a+236>>2];a:{if(!d){break a}e=H[a>>2];JC(a);H[a+252>>2]=0;if(H[d+44>>2]<=0){break a}if(!I[e+177|0]){Rc(a);if(b){H[a+192>>2]=H[b+4>>2]+(H[b>>2]-H[a+188>>2]|0)}H[c+48>>2]=a+188;f=tb(e,18375,c+48|0);b=H[e+16>>2];g=Lb(e,H[d+60>>2]);h=H[b+(g<<4)>>2];b=H[d>>2];H[c+32>>2]=H[a+88>>2];H[c+28>>2]=f;H[c+24>>2]=b;H[c+20>>2]=b;H[c+16>>2]=h;nc(a,16109,c+16|0);b=zb(a);hg(a,g);Sb(b,166);h=H[d>>2];H[c+4>>2]=f;H[c>>2]=h;Qh(b,g,tb(e,18871,c),0);_a(e,f);e=a;a=H[a+44>>2]+1|0;H[e+44>>2]=a;Bd(b,a,H[d>>2]);Va(b,171,g,a);break a}j=H[d>>2];k=H[d+60>>2];b:{g=Wc(e+384|0,H[H[d+48>>2]>>2]);if(!g){break b}b=H[g>>2];if(!b|H[b>>2]<3|!H[b+92>>2]){break b}h=ib(H[d>>2]);f=H[d+60>>2]+16|0;while(1){f=H[f>>2];if(!f){break b}b=H[f+8>>2];if(I[b+43|0]|I[b+29|0]&16){continue}i=H[b>>2];if(Fb(i,H[d>>2],h)){continue}i=h+i|0;if(I[i|0]!=95){continue}if(!(Ka[H[H[g>>2]+92>>2]](i+1|0)|0)){continue}H[b+28>>2]=H[b+28>>2]|4096;continue}}if(td(k+8|0,j,d)){Mb(e);break a}H[a+236>>2]=0}Ga=c- -64|0}function SF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}d=Nb(H[c>>2]);H[17665]=0;o=a;C(+d);a=x(1)|0;b=x(0)|0;a:{b:{c:{d:{e:{if((a|0)>0|(a|0)>=0){g=a;if(a>>>0>1048575){break e}}e=-1/(d*d);if(!(a&2147483647|b)){break a}if((a|0)>0|(a|0)>=0){break d}e=(d-d)/0;break a}if(g>>>0>2146435071){break b}a=1072693248;c=-1023;if((g|0)!=1072693248){a=g;break c}if(b){break c}e=0;break a}C(+(d*0x40000000000000));a=x(1)|0;b=x(0)|0;c=-1077}a=a+614242|0;l=+((a>>>20|0)+c|0);h=l*.30102999566361177;z(0,b|0);z(1,(a&1048575)+1072079006|0);f=+B()+-1;i=f*(f*.5);j=f/(f+2);k=j*j;d=k*k;C(+(f-i));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);e=+B();m=e*.4342944818781689;n=h+m;d=j*(i+(d*(d*(d*.15313837699209373+.22222198432149784)+.3999999999940942)+k*(d*(d*(d*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(f-e-i);d=n+(m+(h-n)+(d*.4342944818781689+(l*3694239077158931e-28+(d+e)*25082946711645275e-27)))}e=d}Zb(o,e);return}_(22968,17213,473,17158);X()}function nK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=I[b|0];g=H[a>>2];a:{b:{c:{d=H[a+24>>2];if(H[d+16>>2]){if((c|0)!=167){break a}a=0;e=H[d+4>>2];f=H[e>>2];c=(f|0)>0?f:0;while(1){d:{if((a|0)!=(c|0)){if(H[b+28>>2]!=H[(e+(a<<6)|0)+48>>2]){break d}c=a}e=0;if((c|0)==(f|0)){break a}break c}a=a+1|0;continue}}e:{switch(c-167|0){case 0:case 1:break c;case 5:break e;default:break b}}if(!(F[b+7|0]&1)){break b}c=d;while(1){a=H[c>>2];if(!a){break c}c=a+36|0;e=1;if((a|0)!=H[b+44>>2]){continue}break}break a}e=2;a=H[g>>2];if(I[a+87|0]){break a}f:{g:{c=H[d+8>>2];if(c){a=0;while(1){if(H[c>>2]>(a|0)){if(!mc(0,H[((a<<4)+c|0)+8>>2],b,-1)){break g}a=a+1|0;c=H[d+8>>2];continue}break}a=H[g>>2]}a=nb(a,b,0);if(!(!a|I[a|0]!=168)){F[a|0]=172}c=sb(g,H[d+8>>2],a);H[d+8>>2]=c;a=-1;f=1;break f}c=H[d+8>>2];f=0}if(c){c=H[b+4>>2];H[b+4>>2]=c|134217728;fb(H[g>>2],b);b=$a(b,0,52);F[b|0]=167;if(f){a=H[H[d+8>>2]>>2]-1|0}G[b+32>>1]=a;H[b+28>>2]=H[H[d>>2]+48>>2];a=H[d+12>>2];H[b+4>>2]=c&512;H[b+44>>2]=a}if(I[H[g>>2]+87|0]){break a}}e=0}return e|0}function Sd(a,b){var c=0,d=0,e=0,f=0,g=0;e=H[a>>2];a:{b:{c:{d:{e:while(1){c=b;if(!b){break d}f:{b=I[c|0];if((b|0)==176){b=I[c+2|0]}g:{h:{i:{j:{k:{l:{m:{b=b&255;switch(b-167|0){case 0:case 2:break l;case 1:break i;default:break m}}n:{switch(b-174|0){case 0:break h;case 1:case 2:break i;case 3:break k;default:break n}}if((b|0)==36){break h}if((b|0)==77){break l}if((b|0)!=113){break i}break f}d=H[c+44>>2];if(!d){break j}c=G[c+32>>1];b=0;if((c|0)<0){break c}b=Pf(e,I[e+84|0],Of(H[d+4>>2]+N(c&65535,12)|0),0);break c}b=H[c+20>>2]+8|0;break g}if((b|0)==113){break f}}if(!(I[c+5|0]&2)){break d}b=H[c+12>>2];if(I[b+5|0]&2?b:0){continue}d=H[c+16>>2];b=d;f=H[c+20>>2];if(!f){continue}b=d;if(I[e+87|0]){continue}c=0;b=H[f>>2];g=(b|0)>0?b:0;while(1){if((c|0)==(g|0)){b=d;continue e}b=c<<4;c=c+1|0;b=H[(b+f|0)+8>>2];if(!(I[b+5|0]&2)){continue}break}continue}b=c+12|0}b=H[b>>2];continue}break}b=so(a,I[e+84|0],0,H[c+8>>2]);break c}b=0}if(!b|H[b+12>>2]){break b}if(so(a,I[H[a>>2]+84|0],b,H[b>>2])){break b}a=1;break a}a=0}return a?0:b}function nB(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=H[b+80>>2];g=H[l+32>>2];f=J[l+46>>1];k=J[l+24>>1];o=k+d|0;j=H[a+44>>2];H[a+44>>2]=o+j;h=j+1|0;i=H[a+8>>2];d=H[a>>2];m=Xb(d,ej(d,g));a:{if(!f){f=0;break a}n=H[b+8>>2];d=0;Xa(i,75,0,h,f+j|0);db(i,c?31:35,n);g=Sb(i,8);p=b,q=ob(i,c?20:23,n,0,h,f),H[p+20>>2]=q;bb(i,g);while(1){if((d|0)==(f|0)){break a}Xa(i,94,n,d,d+h|0);d=d+1|0;continue}}k=f>>>0>k>>>0?f:k;d=f;while(1){if((d|0)==(k|0)){while(1){if((f|0)!=(k|0)){d=H[H[l+52>>2]+(f<<2)>>2];c=J[d+12>>1];b:{c:{if(c&1){if(!(I[H[d>>2]+5|0]&16)|!m){break b}d=f+m|0;break c}if(c&256){break b}c=H[H[d>>2]+16>>2];d:{if(I[d+11|0]&8){break d}if(!$f(c)){break d}Va(i,50,f+h|0,H[b+12>>2])}if(H[a+36>>2]){break b}d=f+m|0;e:{if((Qg(c,F[d|0])|0)!=65){g=F[d|0];break e}F[d|0]=65;g=65}if(!RA(c,g<<24>>24)){break b}}F[d|0]=65}f=f+1|0;continue}break}H[e>>2]=m}else{j=d+h|0;g=fn(a,H[H[l+52>>2]+(d<<2)>>2],b,d,c,j);f:{if((g|0)==(j|0)){break f}if((o|0)==1){xb(a,h);h=g;break f}Va(i,80,g,j)}d=d+1|0;continue}break}return h}function bi(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;e=J[b+16>>1];d=J[a+16>>1];f=e|d;if(f&1){return(e&1)-(d&1)|0}a:{b:{if(f&44){c=e&d;if(c&36){f=-1;c=H[a>>2];e=H[b>>2];a=H[a+4>>2];b=H[b+4>>2];if(c>>>0<e>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break b}break a}if(c&8){f=-1;g=M[a>>3];h=M[b>>3];if(g<h){break b}return g>h}if(d&36){if(e&8){return Aj(H[a>>2],H[a+4>>2],M[b>>3])}f=-1;if(!(e&36)){break b}c=H[a>>2];e=H[b>>2];a=H[a+4>>2];b=H[b+4>>2];if(c>>>0<e>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break b}break a}f=1;if(!(d&8)){break b}if(!(e&36)){return-1}return 0-Aj(H[b>>2],H[b+4>>2],M[a>>3])|0}c:{if(!(f&2)){break c}f=1;if(!(d&2)){break b}f=-1;if(!(e&2)){break b}if(!c){break c}return Eu(a,b,c,0)}c=H[b+12>>2];e=H[a+12>>2];f=J[b+16>>1];d=J[a+16>>1];d:{if((f|d)&1024){i=f;f=d&1024;d=H[a>>2]-H[b>>2]|0;if(i&f){break d}if(f){d=-1;if(!To(H[b+8>>2],c)){break d}d=H[a>>2]-c|0;break d}d=1;if(!To(H[a+8>>2],e)){break d}d=e-H[b>>2]|0;break d}a=Ob(H[a+8>>2],H[b+8>>2],(c|0)>(e|0)?e:c);d=a?a:e-c|0}f=d}return f}return c>>>0>e>>>0&(a|0)>=(b|0)|(a|0)>(b|0)}function sE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=5130;f=H[a+36>>2];a:{if(!f){break a}g=H[f>>2];if(!g){break a}e=b+c|0;k=1<<b;h=(1<<e)-k|0;g=g+36|0;b:{if(d&1){i=J[f+10>>1];j=J[f+12>>1];if(!((i|j)&h)){break b}l=(b|0)>(e|0)?b:e;e=b;d=1;while(1){if((e|0)!=(l|0)){d=H[g+(e<<2)>>2]>(i>>>e&1)?0:d;e=e+1|0;continue}break}c:{if(d){e=Nj(a,2,b+120|0,c);if(e){break a}$a(g+(b<<2)|0,0,c<<2);i=J[f+10>>1];j=J[f+12>>1];break c}if(!(i&k)){break c}a=g+(b<<2)|0;H[a>>2]=H[a>>2]-1}a=h^-1;G[f+10>>1]=a&i;G[f+12>>1]=a&j;break b}d:{e:{f:{if(!(d&4)){d=(b|0)>(e|0)?b:e;e=b;while(1){if((d|0)==(e|0)){break d}if(!(H[g+(e<<2)>>2]?J[f+12>>1]>>>e&1:1)){break f}e=e+1|0;continue}}e=0;d=J[f+10>>1];if(d&h){break a}g=g+(b<<2)|0;e=H[g>>2];if((e|0)>=0){break e}}return 5}if(!e){e=Nj(a,0,b+120|0,c);if(e){break a}e=H[g>>2];d=J[f+10>>1]}G[f+10>>1]=d|h;H[g>>2]=e+1;break b}e=Nj(a,1,b+120|0,c);if(e){break a}G[f+12>>1]=J[f+12>>1]|h;while(1){if((b|0)==(d|0)){break b}H[g+(b<<2)>>2]=-1;b=b+1|0;continue}}e=0}return e|0}function Nu(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;Jb(a);d=Ga-32|0;Ga=d;h=a;a:{b:{c:{f=H[a+4>>2];d:{if(I[f+17|0]){fp(f);Wh(h,4,d+24|0);g=H[d+24>>2];if(g>>>0>K[f+48>>2]){break c}e=H[16164];while(1){a=g;g=a+1|0;if((g|0)==(Ud(f,g)|0)|(a|0)==((e>>>0)/K[f+36>>2]|0)){continue}break}H[d+24>>2]=g;e=If(f,d+12|0,d+16|0,g,1);H[d+20>>2]=e;if(e){break a}i=H[d+16>>2];e:{if((i|0)!=(g|0)){F[d+11|0]=0;H[d+4>>2]=0;e=Jg(f,0,0);Gb(H[d+12>>2]);if(e){break a}e=xd(f,g,d+28|0,0);if(e){break a}e=Hj(f,g,d+11|0,d+4|0);j=I[d+11|0];if((j-1&255)>>>0<=1){e=ab(76576)}a=H[d+28>>2];if(e){Gb(a);break a}e=ep(f,a,j,H[d+4>>2],i,0);Gb(a);if(e){break a}e=xd(f,g,d+28|0,0);if(e){break a}a=H[d+28>>2];e=_b(H[a+72>>2]);H[d+20>>2]=e;if(!e){break e}break b}a=H[d+12>>2];H[d+28>>2]=a}Jd(f,g,1,0,d+20|0);e=H[d+20>>2];if(e){break b}e=Nk(h,4,g);H[d+20>>2]=e;if(e){break b}break d}e=If(f,d+28|0,d+24|0,1,0);H[d+20>>2]=e;if(e){break a}a=H[d+28>>2]}li(a,c&1?13:10);rd(H[a+72>>2]);H[b>>2]=H[d+24>>2];e=0;break a}e=ab(76528);break a}Gb(a)}Ga=d+32|0;return e}function Xk(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ga-48|0;Ga=g;Vg(H[a+8>>2],c,b);a:{if(!(I[c+28|0]&64)){break a}b:{c:{e=Nc(H[a+8>>2],-1);switch(I[e|0]-95|0){case 0:break b;case 1:break c;default:break a}}e=H[e+16>>2];while(1){h=d+e|0;if(!I[h|0]){break a}i=J[(H[c+4>>2]+N(f,12)|0)+10>>1];if(!(i&32)){if(i&64){F[h|0]=64}d=d+1|0}f=f+1|0;continue}}H[e+12>>2]=1}f=0;h=G[c+34>>1];e=(h|0)>0?h:0;while(1){if((f|0)!=(e|0)){d=H[c+4>>2]+N(f,12)|0;i=J[d+10>>1];if(i&96){G[d+10>>1]=i|128}f=f+1|0;continue}break}H[g+24>>2]=0;H[g+28>>2]=0;H[g+20>>2]=58;H[g+40>>2]=c;H[a+52>>2]=0-b;e=0;d=0;f=0;d:while(1){j=h<<16>>16;while(1){i=d;h=e;if((f|0)<(j|0)){d=H[c+4>>2]+N(f,12)|0;e=J[d+10>>1];e:{if(e&128){G[d+10>>1]=e|256;G[g+36>>1]=0;Kb(g+16|0,cd(c,d));G[d+10>>1]=J[d+10>>1]&65279;if(I[g+36|0]&128){e=h;break e}us(a,c,d,Oc(c,f<<16>>16)+b|0);G[d+10>>1]=J[d+10>>1]&65407;e=1}else{e=h}d=i}f=f+1|0;h=J[c+34>>1];continue d}if(i){e=0;d=0;f=0;if(h){continue}}break}break}if(i){H[g>>2]=H[i>>2];Za(a,28256,g)}H[a+52>>2]=0;Ga=g+48|0}function DG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ga-16|0;Ga=g;H[g+12>>2]=0;H[g+8>>2]=0;H[g+4>>2]=0;a=Wj(a,24408);if(!a){a:{b:{j=d+12|0;d=0;a=0;h=c-3|0;c:{d:{if(h){k=(h|0)>0?h:0;while(1){if((a|0)!=(k|0)){d=(ub(H[(a<<2)+j>>2])+d|0)+1|0;a=a+1|0;continue}break}a=d;d=h<<2;h=Ib(a+d|0,0);H[g+4>>2]=h;a=7;if(!h){break c}d=d+h|0;a=0;while(1){if((a|0)==(k|0)){break d}i=a<<2;l=i+j|0;m=ub(H[l>>2]);H[h+i>>2]=d;i=d;d=m+1|0;i=Ya(i,H[l>>2],d);Ni(i);a=a+1|0;d=d+i|0;continue}}H[g+4>>2]=0}a=0}e:{if(a){break e}h=Ga-16|0;Ga=h;d=1;a=(c|0)>=4?H[H[g+4>>2]>>2]:13275;b=Km(b,a,ub(a)+1|0);f:{if(!b){H[h>>2]=a;de(f,7228,h);break f}H[g+12>>2]=b;d=0}Ga=h+16|0;a=d;if(a){break e}a=(c|0)>4;b=a?c-4|0:0;c=H[g+12>>2];a=Ka[H[c+4>>2]](b,a?H[g+4>>2]+4|0:0,g+8|0)|0;if(a){break e}b=Ub(20);if(b){break b}a=7}b=H[g+8>>2];if(!b){break a}Ka[H[H[g+12>>2]+8>>2]](b)|0;break a}H[b>>2]=0;H[b+4>>2]=0;H[b+12>>2]=c;a=0;H[b+8>>2]=0;H[b+16>>2]=H[g+8>>2];H[e>>2]=b}Wa(H[g+4>>2])}Ga=g+16|0;return a|0}function ns(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ga-16|0;Ga=g;a:{if(d){k=134217728;f=H[d>>2];break a}f=kC(b,c);f=Tb(a,f,f>>31)}b:{if(!f){break b}h=jC(b,c);c:{if(I[b+5|0]&8){break c}e=H[b+8>>2];if(!e){break c}i=ib(e)+1|0}j=h&4095;d:{if(c){Ya(f,b,j);break d}e=H[b+4>>2];e=e&65536?12:e&16384?28:52;l=Ya(f,b,e);if(e>>>0>51){break d}$a(e+l|0,0,52-e|0)}e=H[f+4>>2]&-134430721|(h&81920|k);H[f+4>>2]=e;if(i){e=f+j|0;H[f+8>>2]=e;Ya(e,H[b+8>>2],i);e=H[f+4>>2]}h=H[b+4>>2];if(!((e|h)&8454144)){e=H[b+20>>2];e:{if(h&4096){e=ge(a,e,c);break e}e=rc(a,e,c)}H[f+20>>2]=e}e=H[f+4>>2];if(e&16859136){m=g,n=iC(b,c)+f|0,H[m+12>>2]=n;if(!(e&8454144)){c=H[b+12>>2];if(c){c=ns(a,c,1,g+12|0)}else{c=0}H[f+12>>2]=c;c=H[b+16>>2];if(c){c=ns(a,c,1,g+12|0)}else{c=0}H[f+16>>2]=c}if(F[b+7|0]&1){m=f,n=mC(a,f,H[b+44>>2]),H[m+44>>2]=n}if(!d){break b}H[d>>2]=H[g+12>>2];break b}if(I[b+6|0]&129){break b}c=H[b+12>>2];if(I[f|0]!=178){c=nb(a,c,0)}H[f+12>>2]=c;m=f,n=nb(a,H[b+16>>2],0),H[m+16>>2]=n}Ga=g+16|0;return f}function uJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;t=Gc(a);a:{n=cb(H[c>>2]);if(!n){break a}j=bc(H[c>>2]);k=cb(H[c+4>>2]);if(!k){break a}if(!I[k|0]){ae(a,H[c>>2]);return}h=bc(H[c+4>>2]);p=cb(H[c+8>>2]);if(!p){break a}l=bc(H[c+8>>2]);b=j+1|0;m=b>>31;i=b;b=Ti(a,b,m);if(!b){break a}u=h-1|0;v=j-h|0;c=j^-1;q=c;w=c>>31;c=l-h|0;r=c;x=c>>31;c=0;while(1){b:{c:{d:{if((c|0)<=(v|0)){e:{d=c+n|0;e=I[d|0];if((e|0)==I[k|0]){if(!Ob(d,k,h)){break e}}F[b+f|0]=e;f=f+1|0;break b}if((h|0)>=(l|0)){break d}d=H[t+120>>2];e=d>>31;o=d;d=m+x|0;g=i+r|0;d=g>>>0<r>>>0?d+1|0:d;i=g;m=d;d=d-!g|0;if(o>>>0<g-1>>>0&(d|0)>=(e|0)|(d|0)>(e|0)){rh(a);Wa(b);return}d=s;s=d+1|0;if(s&d){break d}d=m+w|0;e=i+q|0;d=e>>>0<q>>>0?d+1|0:d;g=d;o=e;e=i;d=e>>31;e=o+e|0;d=d+g|0;d=Zd(b,e,e>>>0<i>>>0?d+1|0:d);if(d){break c}ic(a);Wa(b);return}d=c+n|0;c=j-c|0;Ya(b+f|0,d,c);c=c+f|0;F[c+b|0]=0;wb(a,b,c,3);break a}d=b}Ya(d+f|0,p,l);c=c+u|0;b=d;f=f+l|0}c=c+1|0;continue}}}function $y(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;while(1){a:{if(H[f>>2]){break a}b:{switch(H[c>>2]-2|0){case 3:j=H[c+20>>2];c=0;e=0;while(1){if(H[j+64>>2]<=(e|0)|c){break a}h=H[d>>2];H[d>>2]=h+24;H[h+12>>2]=b;H[h+4>>2]=e;H[h>>2]=j;c=N(e,24)+j|0;H[h+8>>2]=c+72;H[h+20>>2]=H[j+68>>2];o=H[c+92>>2];k=0;n=0;l=Ga-16|0;Ga=l;p=H[a>>2];q=H[p+244>>2];g=0;while(1){c:{d:{e:{if(!(H[o+4>>2]<=(k|0)|g)){i=H[H[o>>2]+(k<<2)>>2];if(H[i+56>>2]|I[i+5|0]){break e}m=H[i+8>>2];c=H[i+12>>2];while(1){g=H[i+20>>2];if(K[i+16>>2]<m>>>0&(g|0)<=(c|0)|(c|0)>(g|0)){break e}g=zh(p,m,c,0,l+12|0);if(g){break d}g=H[l+12>>2];if((g+35|0)>(q|0)){n=((g+34|0)/(q|0)|0)+n|0}g=m+1|0;c=g?c:c+1|0;m=g;continue}}H[h+16>>2]=n;Ga=l+16|0;c=g;break c}g=0}k=k+1|0;continue}break}H[f>>2]=c;e=e+1|0;continue};case 2:b=H[c+12>>2];H[H[e>>2]>>2]=b;H[e>>2]=H[e>>2]+4;break;case 0:break a;default:break b}}$y(a,b,H[c+12>>2],d,e,f);if(H[c>>2]==4){b=H[c+16>>2];H[H[e>>2]>>2]=b;H[e>>2]=H[e>>2]+4}c=H[c+16>>2];continue}break}}function Ei(a,b,c,d){var e=0,f=0,g=0,h=0;g=Ga-32|0;Ga=g;e=d&2147483647;h=e;f=e-1006698496|0;e=e-1140785152|0;a:{if((f|0)==(e|0)&0|e>>>0>f>>>0){e=d<<4|c>>>28;f=c<<4|b>>>28;c=e;b=b&268435455;if((b|0)==134217728&(a|0)!=0|b>>>0>134217728){e=c+1073741824|0;a=f+1|0;e=a?e:e+1|0;f=a;break a}e=c+1073741824|0;if(a|(b|0)!=134217728){break a}b=f&1;a=b+f|0;e=a>>>0<b>>>0?e+1|0:e;f=a;break a}if(!(!c&(h|0)==2147418112?!(a|b):h>>>0<2147418112)){e=c;c=d<<4|e>>>28;f=e<<4|b>>>28;e=c&524287|2146959360;break a}f=0;e=2146435072;if(h>>>0>1140785151){break a}e=0;h=h>>>16|0;if(h>>>0<15249){break a}e=d&65535|65536;ud(g+16|0,a,b,c,e,h-15233|0);th(g,a,b,c,e,15361-h|0);e=H[g+4>>2];h=e;a=H[g+8>>2];c=H[g+12>>2]<<4|a>>>28;f=a<<4|e>>>28;e=c;a=h&268435455;b=H[g>>2]|(H[g+16>>2]|H[g+24>>2]|(H[g+20>>2]|H[g+28>>2]))!=0;if((a|0)==134217728&(b|0)!=0|a>>>0>134217728){a=f+1|0;e=a?e:e+1|0;f=a;break a}if(b|(a|0)!=134217728){break a}a=f+(f&1)|0;e=a>>>0<f>>>0?e+1|0:e;f=a}Ga=g+32|0;z(0,f|0);z(1,d&-2147483648|e);return+B()}function Ey(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=Ga-16|0;Ga=j;a:{if(H[a>>2]){break a}k=H[b+24>>2]+2|0;h=Ib(SK(k,k>>31,14,0),Ja);if(!h){H[a>>2]=7;break a}f=Pb(b,22,j+8|0,0);if(f){Wa(h);H[a>>2]=f;break a}g=H[j+8>>2];wc(g,1,0);b:{if((Ab(g)|0)==100){n=mf(g,0);i=_d(g,0);f=0;l=Ga-16|0;Ga=l;c:{if(!i|F[(i+n|0)-1|0]<0){break c}while(1){if((i|0)<=(m|0)|(f|0)>=(k|0)){break c}o=qd(m+n|0,l+8|0);H[(f<<2)+h>>2]=H[l+8>>2];f=f+1|0;m=m+o|0;continue}}i=(f|0)>(k|0)?f:k;while(1){if((f|0)!=(i|0)){H[(f<<2)+h>>2]=0;f=f+1|0;continue}break}Ga=l+16|0;break b}$a(h,0,k<<2)}f=rb(g);if(f){Wa(h);H[a>>2]=f;break a}f=(k<<2)+h|0;g=H[h>>2];i=g+e|0;H[h>>2]=(e|0)<0?g>>>0<0-e>>>0?0:i:i;e=0;while(1){if(H[b+24>>2]>=(e|0)){g=e<<2;e=e+1|0;i=(e<<2)+h|0;l=H[g+c>>2]+H[i>>2]|0;g=l-H[d+g>>2]|0;H[i>>2]=g>>>0>l>>>0?0:g;continue}break}By(k,h,f,j+12|0);b=Pb(b,23,j+8|0,0);if(b){Wa(h);H[a>>2]=b;break a}b=H[j+8>>2];wc(b,1,0);Bg(b,2,f,H[j+12>>2],0);Ab(b);p=a,q=rb(b),H[p>>2]=q;oh(b,2);Wa(h)}Ga=j+16|0}function bw(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;c=H[a+104>>2];f=(c|0)>0?c:0;h=H[a+156>>2];c=H[a+168>>2];b=H[a+224>>2];while(1){if((e|0)!=(f|0)){d=H[a+100>>2]+N(e,48)|0;if(!(H[d+8>>2]|H[d+12>>2])){g=H[a+84>>2];H[d+8>>2]=H[a+80>>2];H[d+12>>2]=g}e=e+1|0;continue}break}e=Ul(a);H[a+88>>2]=e;d=Ja;H[a+92>>2]=d;H[a+80>>2]=e;H[a+84>>2]=d;c=c>>>0>h>>>0?h:c;a:{b:{if(!(I[a+7|0]|I[a+5|0]==4)){if(!(fh(H[a+64>>2])&512)){break b}}F[b|0]=217;F[b+1|0]=213;F[b+2|0]=5;F[b+3|0]=249;F[b+4|0]=32;F[b+5|0]=161;F[b+6|0]=99;F[b+7|0]=215;Cb(b+8|0,-1);break a}F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0}Oe(4,a+52|0);Cb(b+12|0,H[a+52>>2]);Cb(b+16|0,H[a+32>>2]);Cb(b+20|0,H[a+156>>2]);Cb(b+24|0,H[a+168>>2]);d=0;$a(b+28|0,0,c-28|0);e=0;while(1){if(!(K[a+156>>2]<=e>>>0|d)){d=Bc(H[a+68>>2],b,c,H[a+80>>2],H[a+84>>2]);f=H[a+84>>2];g=H[a+80>>2]+c|0;H[a+80>>2]=g;H[a+84>>2]=c>>>0>g>>>0?f+1|0:f;e=c+e|0;continue}break}return d}function Hy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Ga-16|0;Ga=e;H[e+12>>2]=b;H[e+8>>2]=0;H[e+4>>2]=0;h=Ga-16|0;Ga=h;H[h+12>>2]=b;if(!H[e+8>>2]){g=Pb(a,7,h+8|0,h+12|0);f=H[h+8>>2];a:{if(!g){if((Ab(f)|0)==100){k=Kq(a,f);g=Nq(a,1,k,ed(f,0),Ja);i=1;b:{while(1){if(!g){if(H[a+24>>2]<(i|0)){break b}g=0;j=i-1|0;if(!I[j+H[a+32>>2]|0]){g=Mq(a,k,lf(f,i),-1,(j<<2)+d|0);j=_d(f,i);l=(H[a+24>>2]<<2)+d|0;H[l>>2]=j+H[l>>2]}i=i+1|0;continue}break}rb(f);break a}H[e+4>>2]=1}g=rb(f);break a}rb(f)}H[e+8>>2]=g}Ga=h+16|0;f=H[e+8>>2];if(!(f|!H[e+4>>2])){H[e>>2]=0;f=Ga-16|0;Ga=f;H[f+12>>2]=b;c:{if(H[a+40>>2]){b=0;H[e>>2]=0;break c}b=Pb(a,1,f+8|0,f+12|0);if(b){break c}b=H[f+8>>2];if((Ab(b)|0)==100){m=e,n=Qd(b,0),H[m>>2]=n}b=rb(b)}Ga=f+16|0;H[e+8>>2]=b;d:{if(b){break d}if(H[e>>2]){m=e,n=Cy(a,1),H[m+8>>2]=n;H[c>>2]=0;$a(d,0,(H[a+24>>2]<<3)+8|0);break d}H[c>>2]=H[c>>2]-1;if(!H[a+40>>2]){vh(e+8|0,a,0,e+12|0)}if(!I[a+238|0]){break d}vh(e+8|0,a,19,e+12|0)}f=H[e+8>>2]}Ga=e+16|0;return f}function Cm(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;d=Ga-16|0;Ga=d;h=H[a+28>>2];H[d+12>>2]=0;H[d+8>>2]=0;H[d+4>>2]=0;b=H[a+16>>2];c=H[a+20>>2];if(!(!h|!(b|c))){b=b+1|0;c=b?c:c+1|0;H[a+16>>2]=b;H[a+20>>2]=c}c=H[a+8>>2];e=H[a+4>>2];a:{if((c|0)>=(e|0)){c=0;H[a>>2]=0;break a}g=H[a>>2];if(h){f=c+g|0;b=F[f|0];b:{if((b|0)<0){b=uc(f,d+12|0);break b}H[d+12>>2]=b&255;b=1}c=b+c|0;H[a+8>>2]=c}f=c+g|0;b=F[f|0];c:{if((b|0)<0){b=uc(f,d+8|0);break c}H[d+8>>2]=b&255;b=1}b=b+c|0;H[a+8>>2]=b;c=267;g=H[d+12>>2];if((g|0)>(h|0)){break a}b=e-b|0;e=H[d+8>>2];if((b|0)<(e|0)|!e){break a}f=e+g|0;pe(a+24|0,f,d+4|0);c=H[d+4>>2];if(c){break a}c=0;b=H[a+24>>2];if(!b){break a}Ya(b+g|0,H[a>>2]+H[a+8>>2]|0,e);H[a+28>>2]=f;e=e+H[a+8>>2]|0;H[a+8>>2]=e;if(H[a+16>>2]|H[a+20>>2]){break a}b=H[a>>2]+e|0;c=F[b|0];d:{if((c|0)<0){c=uc(b,a+40|0);f=H[a+40>>2];e=H[a+8>>2];break d}f=c&255;H[a+40>>2]=f;c=1}b=c+e|0;H[a+8>>2]=b;c=267;if((H[a+4>>2]-b|0)<(f|0)){break a}H[a+8>>2]=b+f;H[a+36>>2]=b+H[a>>2];c=0}Ga=d+16|0;return c}function az(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{while(1){if(H[e>>2]|!b){break a}b:{f=H[b>>2];if((f|0)==5){d=c;f=H[c>>2];c=H[H[b+20>>2]+64>>2];H[d>>2]=f+c;d=0;o=(c|0)>0?c:0;while(1){c=H[b+20>>2];if((d|0)==(o|0)){break b}f=N(d,24);d=d+1|0;k=c+f|0;l=H[k+72>>2];i=H[k+76>>2];n=H[k+80>>2];j=0;g=Ub(56);c:{if(!g){h=7;break c}f=H[a>>2];d:{if(!n){break d}h=7;m=1;c=1;while(1){e:{if(!j){if(H[f+256>>2]>(c|0)){break e}m=0}j=i+1|0;c=1;while(1){if(m){break c}if(H[f+256>>2]<=(c|0)){break d}m=0;f:{if((j|0)!=H[H[f+260>>2]+N(c,24)>>2]){break f}m=1;h=Mi(f,H[a+20>>2],c,-2,l,i,1,0,g);if(h){break f}h=Hz(f,H[a+20>>2],0,-2,l,i,0,0,g)}c=c+1|0;continue}}j=0;if(H[H[f+260>>2]+N(c,24)>>2]==(i|0)){h=Mi(f,H[a+20>>2],c,-2,l,i,0,0,g);H[g+36>>2]=1;j=1}c=c+1|0;continue}}h=Mi(f,H[a+20>>2],0,-2,l,i,n,0,g);H[g+36>>2]=!n}H[k+92>>2]=g;if(!h){continue}break}H[e>>2]=h;return}H[d>>2]=H[d>>2]+((f|0)==4);az(a,H[b+12>>2],c,d,e);b=H[b+16>>2];continue}break}H[c+44>>2]=-1}}function _b(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=H[a+20>>2];if(!(!(I[a+28|0]&4)|K[c+28>>2]<K[a+24>>2])){if(!H[c+104>>2]){return 0}return Um(a)}b=H[c+44>>2];if(!b){if(K[c+156>>2]>K[c+168>>2]){i=Ga-16|0;Ga=i;d=H[a+20>>2];F[d+21|0]=I[d+21|0]|4;f=TK(H[d+156>>2],0,H[d+168>>2],H[d+172>>2]);e=H[a+24>>2];j=f-1|0-e;c=e-1&0-f;b=H[d+28>>2];a:{if(b>>>0<e>>>0){f=(e+j|0)+1|0;break a}if(b>>>0>=c+f>>>0){break a}f=(b+j|0)+1|0}j=c+1|0;e=0;while(1){if(!((g|0)>=(f|0)|h)){b:{c:{b=g+j|0;if((b|0)!=H[a+24>>2]){if(Jw(H[d+60>>2],b)){break c}}h=0;if((b|0)==H[d+164>>2]){break b}h=sd(d,b,i+12|0,0);if(h){break b}h=jA(H[i+12>>2]);c=H[i+12>>2];b=J[c+28>>1];zf(c);e=b&8?1:e;break b}c=ni(d,b);H[i+12>>2]=c;h=0;if(!c){break b}b=J[c+28>>1];zf(c);e=b&8?1:e}g=g+1|0;continue}break}d:{if(!e|h){break d}g=0;a=(f|0)>0?f:0;while(1){if((a|0)==(g|0)){break d}b=ni(d,g+j|0);if(b){G[b+28>>1]=J[b+28>>1]|8;zf(b)}g=g+1|0;continue}}F[d+21|0]=I[d+21|0]&251;Ga=i+16|0;return h}b=jA(a)}return b}function td(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Ga-16|0;Ga=f;e=Lt(a,b,f+12|0);d=H[e+8>>2];a:{if(d){if(!c){g=H[f+12>>2];b=H[e>>2];c=H[e+4>>2];b:{if(c){H[c>>2]=b;b=H[e>>2];break b}H[a+8>>2]=b}if(b){H[b+4>>2]=c}c=H[a+12>>2];if(c){c=c+(g<<3)|0;if((e|0)==H[c+4>>2]){H[c+4>>2]=b}H[c>>2]=H[c>>2]-1}Wa(e);b=H[a+4>>2]-1|0;H[a+4>>2]=b;if(!b){Uf(a)}break a}H[e+12>>2]=b;H[e+8>>2]=c;break a}if(!c){d=0;break a}e=xc(16,0);if(!e){d=c;break a}H[e+8>>2]=c;H[e+12>>2]=b;d=H[a+4>>2]+1|0;H[a+4>>2]=d;c:{if(d>>>0<10|d>>>0<=H[a>>2]<<1>>>0){break c}c=0;d=d<<1;d=d<<3>>>0>1024?128:d;d:{if((d|0)==H[a>>2]){break d}Md();d=xc(d<<3,0);Ld();if(!d){break d}Wa(H[a+12>>2]);H[a+12>>2]=d;c=af(d);g=c>>>3|0;H[a>>2]=g;h=$a(d,0,c&-8);c=H[a+8>>2];H[a+8>>2]=0;while(1){if(c){d=H[c>>2];Kt(a,h+((yo(H[c+12>>2])>>>0)%(g>>>0)<<3)|0,c);c=d;continue}break}c=1}if(!c){break c}i=f,j=(yo(b)>>>0)%K[a>>2]|0,H[i+12>>2]=j}d=0;b=a;a=H[a+12>>2];Kt(b,a?a+(H[f+12>>2]<<3)|0:0,e)}Ga=f+16|0;return d}function hA(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{if(I[c|0]!=7){break a}b:{m=N(b,12);d=m+H[a+8>>2]|0;if(I[d|0]==7){i=b;g=1;c:while(1){if(K[c+4>>2]<=g>>>0){break b}e=N(g,12)+c|0;j=H[e+8>>2];k=H[e+4>>2];h=H[d+4>>2];f=1;while(1){d:{e:{if(f>>>0>=h>>>0){break e}l=N(f,12)+d|0;if((k|0)!=H[l+4>>2]){break d}if(Be(H[l+8>>2],j,k)){break d}h=f+1|0;l=N(h,12);n=l+d|0;o=I[n+1|0];if(o&20){break e}e=e+12|0;if(!I[e|0]){F[n+1|0]=o|4;break e}h=hA(a,b+h|0,e);if(!h){d=0;break b}d=H[a+8>>2]+m|0;e=l+d|0;if((e|0)==(h|0)){break e}H[e+8>>2]=h;F[e+1|0]=I[e+1|0]|16}g=g+1|0;f:{if(K[d+4>>2]>f>>>0){break f}e=N(g,12)+c|0;if(!I[e|0]){break f}d=0;f=yd(a,7,2,0);yd(a,5,k,j);k=yd(a,1,0,0);if(I[a+20|0]){break b}kr(c);j=H[a+8>>2];d=j+N(i,12)|0;H[d+8>>2]=f-i;F[d+1|0]=I[d+1|0]|32;i=H[a+8>>2]+N(k,12)|0;H[i+8>>2]=e;F[i+1|0]=I[i+1|0]|16;d=j+m|0;i=f}g=re(N(g,12)+c|0)+g|0;continue c}f=f+1|0;f=re(N(f,12)+d|0)+f|0;continue}}}kr(c);break a}return d}return c}function XI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;b=Ga-336|0;Ga=b;f=Gc(a);d=cb(H[c>>2]);g=cb(H[c+4>>2]);h=H[f+360>>2];H[f+360>>2]=0;Se(f);if(!(!d|!g)){d=Fk(b- -64|0,d,f,g,0);a:{if(!d){H[b+48>>2]=0;H[b+52>>2]=0;H[b+56>>2]=0;H[b+28>>2]=0;H[b+40>>2]=0;H[b+44>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+16>>2]=88;H[b+12>>2]=92;H[b+32>>2]=b+40;H[b+8>>2]=b- -64;d=H[b+300>>2];b:{c:{if(d){if(I[d+43|0]==2){e=H[d+44>>2];H[e+4>>2]=H[e+4>>2]&-2097153;H[b+76>>2]=0;ve(b- -64|0,e,0);d=I[f+87|0]?7:H[b+76>>2];if(d){break b}lc(b+8|0,e);break c}gc(b+8|0,H[d+16>>2]);d=0;while(1){e=H[b+300>>2];if(G[e+34>>1]<=(d|0)){break c}Kb(b+8|0,cd(e,H[e+4>>2]+N(d,12)|0));d=d+1|0;continue}}d=H[b+304>>2];if(d){e=b+8|0;gc(e,H[d+40>>2]);Kb(e,H[H[b+304>>2]+36>>2]);break c}d=_m(b- -64|0);if(d){break b}ur(b+8|0,H[b+308>>2])}d=tr(a,b+40|0,g,0,0)}Zm(f,H[b+40>>2]);if(!d){break a}}if(!(!Jf(f)|(d|0)!=1)){ae(a,H[c+4>>2]);break a}ne(a,d)}Ek(b- -64|0)}H[f+360>>2]=h;Ga=b+336|0}function yJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=Ga-32|0;Ga=b;e=b+8|0;d=Gc(a);fd(e,d,0,0,H[d+120>>2]);d=Ga+-64|0;Ga=d;a:{b:{c:{d:{e:{f:{c=H[c>>2];switch(gb(c)-1|0){case 2:break c;case 3:break d;case 0:break e;case 1:break f;default:break b}}g=Nb(c);M[d+16>>3]=g;vb(e,11934,d+16|0);c=$v(e);if(!c){break a}Yd(c,d+56|0,H[e+16>>2],1);if(M[d+56>>3]==g){break a}Nf(e);M[d>>3]=g;vb(e,14067,d);break a}m=d,n=ac(c),H[m+32>>2]=n;H[d+36>>2]=Ja;vb(e,14185,d+32|0);break a}k=nf(c);c=bc(c);h=c<<1;Dp(e,h+4|0);if(I[e+20|0]){break a}l=(c|0)>0?c:0;c=H[e+4>>2];while(1){if((f|0)!=(l|0)){i=c+(f<<1)|0;j=f+k|0;F[i+2|0]=I[(I[j|0]>>>4|0)+50448|0];F[i+3|0]=I[(I[j|0]&15)+50448|0];f=f+1|0;continue}break}f=c+h|0;F[f+2|0]=39;F[f+3|0]=0;F[c|0]=88;F[c+1|0]=39;H[e+16>>2]=h+3;break a}m=d,n=cb(c),H[m+48>>2]=n;vb(e,19163,d+48|0);break a}Bb(e,19458,4)}Ga=d- -64|0;wb(a,Wd(e),H[b+24>>2],1);if(I[b+28|0]){Wb(a);ne(a,I[b+28|0])}Ga=b+32|0}function pq(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);e=x(1)|0;c=x(0)|0;a:{b:{d=e>>>20&2047;if(d-969>>>0<63){j=d;break b}if(d>>>0<=968){return a+1}if(d>>>0<1033){break b}b=0;if(!c&(e|0)==-1048576){break a}if((d|0)==2047){return a+1}if((e|0)<0){return _x(12882297539194267e-247)}return _x(3105036184601418e216)}b=M[7025];f=M[7024]*a+b;b=f-b;b=b*M[7027]+(b*M[7026]+a);a=b*b;g=a*a*(b*M[7031]+M[7030]);a=a*(b*M[7029]+M[7028]);C(+f);x(1)|0;h=x(0)|0;c=h<<4&2032;b=g+(a+(M[c+56304>>3]+b));d=c+56312|0;c=h<<13;e=0;i=H[d>>2]+e|0;c=c+H[d+4>>2]|0;c=e>>>0>i>>>0?c+1|0:c;d=i;if(!j){c:{if(!(h&-2147483648)){z(0,d|0);z(1,c-1058013184|0);a=+B();a=(a*b+a)*5486124068793689e288;break c}e=Ga-16|0;z(0,d|0);z(1,c+1071644672|0);g=+B();f=g*b;a=f+g;if(a<1){H[e+8>>2]=0;H[e+12>>2]=1048576;M[e+8>>3]=M[e+8>>3]*22250738585072014e-324;b=a+1;a=b+(f+(g-a)+(a+(1-b)))+-1;a=a==0?0:a}a=a*22250738585072014e-324}return a}z(0,d|0);z(1,c|0);a=+B();b=a*b+a}return b}function Yt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=H[d+64>>2];e=H[d+52>>2];n=H[H[e>>2]+224>>2];k=H[d+56>>2];h=k+I[d+9|0]|0;f=I[h+5|0]<<8|I[h+6|0];e=H[e+40>>2];f=e>>>0<f>>>0?0:f;o=f+k|0;Ya(n+f|0,o,e-f|0);l=e+k|0;while(1){e=g;if(H[((e<<2)+a|0)+40>>2]<=(b|0)){g=e+1|0;if(e>>>0<6){continue}}break}r=b+c|0;f=l;while(1){g=(e<<2)+a|0;s=g;p=H[g+16>>2];a:{while(1){g=H[H[a+8>>2]+(b<<2)>>2];m=J[H[a+12>>2]+(b<<1)>>1];i=g+m|0;b:{c:{if(!(g>>>0<o>>>0|g>>>0>=l>>>0)){if(i>>>0<=l>>>0){break c}return ab(74180)}if(i>>>0<=p>>>0|g>>>0>=p>>>0){break b}return ab(74185)}g=(g-k|0)+n|0}f=f-m|0;i=f-k|0;q=i<<8|(i&65280)>>>8;F[j|0]=q;F[j+1|0]=q>>>8;j=j+2|0;if(j>>>0>f>>>0){return ab(74191)}vd(f,g,m);b=b+1|0;if((r|0)<=(b|0)){break a}if(H[s+40>>2]>(b|0)){continue}break}e=e+1|0;continue}break}F[d+12|0]=0;G[d+24>>1]=c;F[h+1|0]=0;F[h+2|0]=0;F[h+3|0]=I[d+25|0];F[h+4|0]=I[d+24|0];F[h+6|0]=i;F[h+5|0]=i>>>8;F[h+7|0]=0;return 0}function eF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=Ga-128|0;Ga=d;a:{b:{switch(b-1|0){default:if((b|0)==9){break a}break;case 0:case 2:break a;case 1:break b}}H[d+120>>2]=c+4;e=H[c>>2]}c=(b|0)==4?e|32768:e;c:{d:{if(b>>>0>16){break d}e:{if(!(1<<b&98400)){if((b|0)==7){break e}if((b|0)!=9){break d}H[d+48>>2]=d+120;H[d+52>>2]=0;b=$(a|0,16,d+48|0)|0;if(b){if((b|0)==-28){H[d+32>>2]=c;H[d+36>>2]=0;a=$(a|0,9,d+32|0)|0;break c}a=yc(b);break c}a=H[d+124>>2];a=H[d+120>>2]==2?0-a|0:a;break c}H[d+112>>2]=c;H[d+116>>2]=0;a=yc($(a|0,b|0,d+112|0)|0);break c}H[d+16>>2]=c;H[d+20>>2]=0;a=yc($(a|0,7,d+16|0)|0);break c}if((b|0)!=1030){H[d>>2]=c;H[d+4>>2]=0;a=yc($(a|0,b|0,d|0)|0);break c}H[d+96>>2]=c;H[d+100>>2]=0;b=$(a|0,1030,d+96|0)|0;if((b|0)!=-28){a=yc(b);break c}H[d+80>>2]=0;H[d+84>>2]=0;b=$(a|0,1030,d+80|0)|0;if((b|0)!=-28){if((b|0)>=0){da(b|0)|0}a=yc(-28);break c}H[d+64>>2]=c;H[d+68>>2]=0;a=yc($(a|0,0,d- -64|0)|0)}Ga=d+128|0;return a|0}function jq(a){var b=0,c=0,d=0,e=0,f=0,g=0;C(+a);e=x(1)|0;x(0)|0;d=e&2147483647;if(d>>>0>=1141899264){C(1.5707963267948966);e=x(1)|0;d=x(0)|0;C(+a);b=x(1)|0;x(0)|0;z(0,d|0);z(1,e&2147483647|b&-2147483648);g=+B();C(+a);b=x(1)|0;e=x(0)|0;b=b&2147483647;return(b|0)==2146435072&(e|0)!=0|b>>>0>2146435072?a:g}a:{b:{if(d>>>0<=1071382527){b=-1;if(d>>>0>=1044381696){break b}break a}a=P(a);if(d>>>0<=1072889855){if(d>>>0<=1072037887){a=(a+a+-1)/(a+2);b=0;break b}a=(a+-1)/(a+1);b=1;break b}if(d>>>0<=1073971199){a=(a+-1.5)/(a*1.5+1);b=2;break b}a=-1/a;b=3}f=a*a;c=f*f;g=c*(c*(c*(c*(c*-.036531572744216916+-.058335701337905735)+-.0769187620504483)+-.11111110405462356)+-.19999999999876483);f=f*(c*(c*(c*(c*(c*.016285820115365782+.049768779946159324)+.06661073137387531)+.09090887133436507)+.14285714272503466)+.3333333333333293);if(d>>>0<=1071382527){return a-a*(g+f)}b=b<<3;a=M[b+58352>>3]-(a*(g+f)-M[b+58384>>3]-a);a=(e|0)<0?-a:a}return a}function Mr(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=Ga-16|0;Ga=h;i=H[b+8>>2];o=(i|H[b>>2])^-1;j=H[b+12>>2];p=(j|H[b+4>>2])^-1;k=H[a+20>>2];m=H[a+24>>2];e=m;while(1){if((k|0)>0){f=H[e+40>>2];l=H[e+44>>2];a:{if(I[e+10|0]&2|(o&f|p&l|!(f&i|j&l))){break a}d=J[b+44>>1];while(1){if(d){d=d-1|0;g=H[H[b+52>>2]+(d<<2)>>2];if(!g){continue}if((e|0)==(g|0)){break a}g=H[g+16>>2];if((g|0)<0|(N(g,48)+m|0)!=(e|0)){continue}break a}break}if(!(!(I[(H[H[a>>2]+4>>2]+(I[b+16|0]<<6)|0)+44|0]&72?I[e+12|0]&63:1)|((f|0)!=(i|0)|(j|0)!=(l|0)))){H[b+40>>2]=H[b+40>>2]|8388608}d=J[b+22>>1];f=G[e+8>>1];if((f|0)<=0){G[b+22>>1]=d+f;break a}G[b+22>>1]=d-1;if(!(I[e+12|0]&130)){break a}d=H[H[e>>2]+16>>2];H[h+12>>2]=0;d=Ng(d,h+12|0);f=H[h+12>>2];d=d?(f|0)>-2?(f|0)<2?10:20:20:20;if(d>>>0<=(n&65535)>>>0){break a}G[e+10>>1]=J[e+10>>1]|8192;n=d}e=e+48|0;k=k-1|0;continue}break}a=c-(n&65535)|0;if((a|0)<G[b+22>>1]){G[b+22>>1]=a}Ga=h+16|0}function MD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;f=F[b|0];i=f&255;a:{if((f|0)>=0){f=b;break a}i=i&127;while(1){e=g+1|0;f=e+b|0;d=F[f|0];i=d&127|i<<7;if((d|0)>=0){break a}d=g>>>0<7;g=e;if(d){continue}break}}d=F[f+1|0];e=d&255;g=0;h=f+1|0;b:{if((d|0)>=0){break b}d=F[f+2|0];e=d&127|e<<7&16256;h=f+2|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+3|0];e=d&127|e<<7;h=f+3|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+4|0];e=d&127|e<<7;h=f+4|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+5|0];e=d&127|e<<7;h=f+5|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+6|0];e=d&127|e<<7;h=f+6|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+7|0];e=d&127|e<<7;h=f+7|0;if((d|0)>=0){break b}g=g<<7|e>>>25;d=F[f+8|0];e=d&127|e<<7;h=f+8|0;if((d|0)>=0){break b}g=g<<8|e>>>24;e=I[f+9|0]|e<<8;h=f+9|0}d=h;H[c+12>>2]=i;H[c>>2]=e;H[c+4>>2]=g;g=d+1|0;H[c+8>>2]=g;if(J[a+14>>1]>=i>>>0){G[c+16>>1]=i;a=(g-b|0)+i|0;G[c+18>>1]=a&65532?a:4;return}Av(a,b,c)}function aj(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{if(!b){break a}d=H[b>>2];d=(d|0)>0?d<<6|8:72;h=Tb(a,d,d>>31);if(!h){break a}d=H[b>>2];H[h>>2]=d;H[h+4>>2]=d;while(1){if(H[b>>2]<=(i|0)){return h}e=i<<6;d=e+h|0;f=b+e|0;H[d+8>>2]=H[f+8>>2];j=d,k=Xb(a,H[f+12>>2]),H[j+12>>2]=k;j=d,k=Xb(a,H[f+16>>2]),H[j+16>>2]=k;j=d,k=Xb(a,H[f+20>>2]),H[j+20>>2]=k;H[d+44>>2]=H[f+44>>2];H[d+48>>2]=H[f+48>>2];H[d+32>>2]=H[f+32>>2];H[d+36>>2]=H[f+36>>2];e=I[d+45|0]|I[d+46|0]<<8;if(e&2){j=d- -64|0,k=Xb(a,H[f- -64>>2]),H[j>>2]=k;e=I[d+45|0]|I[d+46|0]<<8}g=H[f+68>>2];H[d+68>>2]=g;if(e&256){H[g>>2]=H[g>>2]+1;e=I[d+45|0]|I[d+46|0]<<8}if(e&4){j=d- -64|0,k=rc(a,H[f- -64>>2],c),H[j>>2]=k}e=H[f+24>>2];H[d+24>>2]=e;if(e){H[e+24>>2]=H[e+24>>2]+1}j=d,k=ge(a,H[f+28>>2],c),H[j+28>>2]=k;e=H[f+52>>2];b:{if(I[f+46|0]&4){g=nC(a,e);break b}g=nb(a,e,c)}H[d+52>>2]=g;e=H[f+60>>2];H[d+56>>2]=H[f+56>>2];H[d+60>>2]=e;i=i+1|0;continue}}return 0}function Ts(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Ga-32|0;Ga=f;if(!(I[a+207|0]|I[a+16|0])){h=H[a>>2];d=H[a+8>>2];while(1){c=b;b=H[b+52>>2];if(b){continue}break}j=H[c+32>>2];g=H[c+28>>2];F[a+16|0]=1;b=H[h+32>>2];Zj(d,H[g>>2]);k=b&68;l=b&4;b=0;while(1){if(H[g>>2]>(b|0)){i=g+(b<<4)|0;c=H[i+8>>2];e=H[i+12>>2];a:{if(!(!e|I[i+17|0]&3)){jf(d,b,0,e,-1);break a}if(!(!(m|k)|I[c|0]!=167)){e=H[c+44>>2];b:{c:{c=G[c+32>>1];if((c|0)>=0){break c}c=G[e+32>>1];if((c|0)>=0){break c}c=14302;break b}c=H[H[e+4>>2]+N(c&65535,12)>>2]}if(m|l){e=H[e>>2];H[f+20>>2]=c;H[f+16>>2]=e;jf(d,b,0,tb(h,5984,f+16|0),1);break a}jf(d,b,0,c,-1);break a}d:{if(!e){H[f>>2]=b+1;c=tb(h,15767,f);break d}c=Xb(h,e)}jf(d,b,0,c,1)}b=b+1|0;continue}break}b=0;d=Ga-32|0;Ga=d;c=H[a+8>>2];H[d+12>>2]=0;H[d>>2]=a;H[d+4>>2]=j;while(1){if(H[g>>2]>(b|0)){jf(c,b,1,on(d,H[(g+(b<<4)|0)+8>>2]),-1);b=b+1|0;continue}break}Ga=d+32|0}Ga=f+32|0}function IA(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=Ga-32|0;Ga=i;l=H[a>>2];m=zb(a);if((h|0)<0){o=Va(m,48,I[e+24|0],0)}n=e+36|0;while(1){if(H[e+20>>2]>(j|0)){k=he(a,k,mb(a,53,Dr(a,c,g,(d?G[H[d+4>>2]+(j<<1)>>1]:65535)<<16>>16),sc(l,59,H[H[H[e>>2]+4>>2]+N(G[(f?(j<<2)+f|0:n)>>1],12)>>2])));j=j+1|0;continue}break}if(!(H[e>>2]!=(c|0)|(h|0)<=0)){a:{if(I[c+28|0]&128){f=0;j=0;while(1){if(J[d+50>>1]>j>>>0){n=f;f=G[H[d+4>>2]+(j<<1)>>1];f=he(a,n,mb(a,45,Dr(a,c,g,f),sc(l,59,H[H[c+4>>2]+N(f,12)>>2])));j=j+1|0;continue}break}c=mb(a,19,f,0);break a}d=a;g=Dr(a,c,g,-1);j=H[b+48>>2];f=sc(l,167,0);if(f){G[f+32>>1]=65535;H[f+28>>2]=j;H[f+44>>2]=c}c=mb(d,52,g,f)}k=he(a,k,c)}H[i+24>>2]=0;H[i+28>>2]=0;H[i+16>>2]=0;H[i+20>>2]=0;H[i+8>>2]=0;H[i+12>>2]=0;H[i+4>>2]=b;H[i>>2]=a;ld(i,k);b:{if(H[a+36>>2]){break b}a=Af(a,b,k,0,0,0,0,0);Va(m,158,I[e+24|0],h);if(!a){break b}Ed(a)}fb(l,k);if(o){Pn(m,o)}Ga=i+32|0}function xF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;e=Ga-16|0;Ga=e;if((b|0)==1){d=nh(H[c>>2]);if((d|0)!=5){a=Eb(a,64);a:{if(H[a+56>>2]){break a}b=qm(12);H[a+56>>2]=b;if((d|0)==1){dy(e,416);H[b+8>>2]=H[e+8>>2];d=H[e+4>>2];H[b>>2]=H[e>>2];H[b+4>>2]=d;H[a+48>>2]=0;H[a+52>>2]=0;break a}H[a+48>>2]=1;H[a+52>>2]=0;dy(e,417);H[b+8>>2]=H[e+8>>2];d=H[e+4>>2];H[b>>2]=H[e>>2];H[b+4>>2]=d}b=H[a+20>>2];d=H[a+16>>2]+1|0;b=d?b:b+1|0;H[a+16>>2]=d;H[a+20>>2]=b;b=H[c>>2];b:{if(!(H[a+48>>2]|H[a+52>>2])){b=ac(b);d=Ja;c=qm(8);H[c>>2]=b;H[c+4>>2]=d;break b}f=Nb(b);c=qm(8);M[c>>3]=f}a=H[a+56>>2];b=H[a+4>>2];while(1){c:{d=H[a>>2];if(!d){b=qm(24);H[b+16>>2]=1;H[b+20>>2]=0;H[b+8>>2]=c;H[a>>2]=b;break c}d=Ka[b|0](H[d+8>>2],c)|0;if(d){a=H[a>>2];a=(d|0)>0?a:a+4|0;continue}else{b=H[a>>2];a=H[b+20>>2];d=H[b+16>>2]+1|0;a=d?a:a+1|0;H[b+16>>2]=d;H[b+20>>2]=a;Te(c)}}break}}Ga=e+16|0;return}_(22968,17213,1418,9352);X()}function ZI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=Ga-304|0;Ga=b;d=Gc(a);f=cb(H[c>>2]);e=cb(H[c+4>>2]);h=ac(H[c+16>>2]);j=H[d+32>>2];i=cb(H[c+20>>2]);k=ac(H[c+24>>2]);l=H[d+360>>2];H[d+360>>2]=0;if(!(!f|!e)){g=H[d+32>>2];m=H[d+36>>2];if(k){H[d+32>>2]=g&-1610612737;H[d+36>>2]=m}e=Fk(b+32|0,f,d,e,h);h=H[d+36>>2];H[d+32>>2]=H[d+32>>2]|g&1610612736;H[d+36>>2]=h;a:{b:{if(e){break b}c:{g=j&67108864;if(g){break c}e=H[b+268>>2];if(!e|I[e+43|0]!=2){break c}H[b+28>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;H[b+4>>2]=0;H[b+8>>2]=0;f=b+32|0;H[b>>2]=f;ve(f,H[e+44>>2],b);e=H[b+68>>2]?H[b+44>>2]:0;break b}e=H[b+276>>2];if(!e){break a}if(!g){e=_m(b+32|0);if(e){break b}e=H[b+276>>2]}if((Lb(d,H[e+24>>2])|0)!=(Xg(d,f)|0)){break a}Hc(a,1);break a}if(!e|!i){break a}if(Jf(d)){break a}sr(a,i,H[c+8>>2],H[c+12>>2],b+32|0)}Ek(b+32|0)}H[d+360>>2]=l;Ga=b+304|0}function jp(a,b,c){var d=0,e=0,f=0,g=0,h=0;d=Ga-32|0;Ga=d;F[b|0]=0;e=Nd(a,d+16|0);a:{if(e){break a}f=H[d+16>>2];g=H[d+20>>2];if(f>>>0<16&(g|0)<=0|(g|0)<0){break a}e=Kf(a,f-16|0,g-(f>>>0<16)|0,d+28|0);if(e){break a}e=0;g=c;c=H[d+28>>2];if(g>>>0<=c>>>0|!c){break a}f=H[d+16>>2];g=H[d+20>>2];h=g-(f>>>0<16)|0;if((h|0)<=0&c>>>0>f-16>>>0|(h|0)<0){break a}e=Kf(a,f-12|0,g-(f>>>0<12)|0,d+12|0);if(e){break a}f=H[d+16>>2];e=Jc(a,d+4|0,8,f-8|0,H[d+20>>2]-(f>>>0<8)|0);if(e){break a}e=0;if((I[d+4|0]|I[d+5|0]<<8|(I[d+6|0]<<16|I[d+7|0]<<24))!=-117058087|(I[d+8|0]|I[d+9|0]<<8|(I[d+10|0]<<16|I[d+11|0]<<24))!=-681336544){break a}g=a;f=H[d+16>>2];a=c;e=f-a|0;e=Jc(g,b,a,e-16|0,(H[d+20>>2]-(a>>>0>f>>>0)|0)-(e>>>0<16)|0);if(e){break a}e=0;a=H[d+12>>2];while(1){if((c|0)!=(e|0)){a=a-F[b+e|0]|0;e=e+1|0;continue}break}H[d+12>>2]=a;e=0;if(a){H[d+28>>2]=0;c=0}a=b+c|0;F[a|0]=0;F[a+1|0]=0}Ga=d+32|0;return e}function qv(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;f=Ga-32|0;Ga=f;a:{b:{if((Ud(a,c)|0)==(c|0)|((K[16164]/K[a+36>>2]|0)+1|0)==(c|0)){break b}if(!eb(H[H[a+12>>2]+56>>2]+36|0)){e=101;break a}e=Hj(a,c,f+31|0,f+24|0);if(e){break a}c:{d:{e:{g=I[f+31|0];switch(g-1|0){case 1:break d;case 0:break e;default:break c}}e=ab(70745);break a}if(d){break b}e=If(a,f+16|0,f+20|0,c,1);if(e){break a}Gb(H[f+16>>2]);break b}e=xd(a,c,f+16|0,0);if(e){break a}h=d?0:b;i=!d<<1;while(1){j=H[a+48>>2];e=If(a,f+12|0,f+20|0,h,i);if(e){Gb(H[f+16>>2]);break a}Gb(H[f+12>>2]);e=H[f+20>>2];if(e>>>0>j>>>0){Gb(H[f+16>>2]);e=ab(70797);break a}if(b>>>0<e>>>0?d:0){continue}break}b=H[f+16>>2];e=ep(a,b,g,H[f+24>>2],e,d);Gb(b);if(e){break a}}e=0;if(d){break a}b=(K[16164]/K[a+36>>2]|0)+2|0;while(1){d=(b|0)==(c|0);c=c-1|0;if(d){continue}if((Ud(a,c)|0)==(c|0)){continue}break}H[a+48>>2]=c;F[a+19|0]=1}Ga=f+32|0;return e}function pA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-80|0;Ga=d;a:{if(Si(a,b,c,d+32|0)){break a}Ri(d+32|0);F[d+5|0]=45;F[d+8|0]=45;F[d+11|0]=32;F[d+14|0]=58;b=H[d+44>>2];c=(b|0)/10|0;F[d+6|0]=((c|0)%10|0)+48;e=H[d+48>>2];f=(e|0)/10|0;F[d+9|0]=((f|0)%10|0)+48;g=H[d+52>>2];h=(g|0)/10|0;F[d+12|0]=((h|0)%10|0)+48;F[d+7|0]=(b-N(c,10)|0)+48;F[d+10|0]=(e-N(f,10)|0)+48;F[d+13|0]=(g-N(h,10)|0)+48;c=H[d+40>>2];b=c>>31;b=(b^c)-b|0;F[d+2|0]=((b>>>0)/100>>>0)%10|48;F[d+1|0]=((b>>>0)/1e3>>>0)%10|48;e=(b>>>0)/10|0;F[d+3|0]=(e>>>0)%10|48;F[d+4|0]=b-N(e,10)|48;b=H[d+56>>2];F[d+17|0]=58;e=b;b=(b|0)/10|0;F[d+16|0]=(e-N(b,10)|0)+48;F[d+15|0]=((b|0)%10|0)+48;F[d+20|0]=0;i=M[d+64>>3];b:{if(P(i)<2147483648){b=~~i;break b}b=-2147483648}e=(b|0)/10|0;F[d+18|0]=((e|0)%10|0)+48;F[d+19|0]=(b-N(e,10)|0)+48;if((c|0)<0){F[d|0]=45;wb(a,d,20,-1);break a}wb(a,d|1,19,-1)}Ga=d+80|0}function hj(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{b:{c:{if(!H[b+56>>2]){h=H[H[H[a>>2]+16>>2]+28>>2];if(h){h=H[h+48>>2]!=0}else{h=0}if(!h){break c}}if(!I[a+151|0]){break b}}a=0;if(!e){break a}H[e>>2]=0;return 0}k=d;i=Ga-16|0;Ga=i;d=b;d:{e:{b=SB(a,b);if(!b){break e}h=a;f:{if(I[H[a>>2]+34|0]&4){break f}f=H[d+56>>2];if(!f){break f}if((b|0)==(f|0)){break e}a=b;while(1){g=a;a=H[a+32>>2];if((a|0)!=(f|0)?a:0){continue}break}H[g+32>>2]=0}l=(c|0)==128?19551:19558;g=0;m=(c|0)==127;n=(c|0)!=129;a=b;while(1){g:{h:{f=I[a+8|0];if((f|0)!=(c|0)){break h}if(!Fr(H[a+16>>2],k)){break h}g=I[a+9|0]|g;break g}if((f|0)==150){F[a+8|0]=c;j=I[d+43|0]!=1;f=j?2:1;if(!(m|j)){H[i>>2]=l;Za(h,5273,i);f=1}F[a+9|0]=f;g=g|f;break g}if(H[h+116>>2]|(!I[a+10|0]|n|(f|0)!=127)){break g}g=I[a+9|0]|g}a=H[a+32>>2];if(a){continue}break}break d}b=0}if(e){H[e>>2]=g}Ga=i+16|0;a=g?b:0}return a}function Xo(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Ga-32|0;Ga=g;a:{if(K[a+48>>2]<b>>>0){e=ab(76666);break a}e=ul(a,b,g+28|0,0,0);if(e){break a}f=H[g+28>>2];b:{if(!(I[a+16|0]&4|G[H[f+72>>2]+30>>1]==(((b|0)==1?2:1)|0))){e=ab(76673);break b}i=I[f+9|0];b=0;while(1){e=J[f+24>>1];if(e>>>0>b>>>0){e=H[f+64>>2]+(b<<1)|0;h=H[f+56>>2]+(J[f+26>>1]&(I[e|0]<<8|I[e+1|0]))|0;if(!I[f+8|0]){e=Xo(a,eb(h),1,d);if(e){break b}}Ka[H[f+80>>2]](f,h,g);if(H[g+12>>2]!=J[g+16>>1]){e=Vo(f,h,g);if(e){break b}}b=b+1|0;continue}break}H[g+24>>2]=0;c:{d:{if(!I[f+8|0]){e=Xo(a,eb((H[f+56>>2]+i|0)+8|0),1,d);H[g+24>>2]=e;if(e){break b}if(I[f+1|0]|!d){break c}e=J[f+24>>1];break d}if(!d){break c}}a=H[d+4>>2];b=e&65535;e=b+H[d>>2]|0;a=e>>>0<b>>>0?a+1|0:a;H[d>>2]=e;H[d+4>>2]=a}if(c){Sh(f,g+24|0);e=H[g+24>>2];break b}e=_b(H[f+72>>2]);if(e){break b}li(f,I[H[f+56>>2]+i|0]|8);e=0}Gb(f)}Ga=g+32|0;return e}function xB(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;i=H[a+8>>2];k=H[i+108>>2];j=jb(a);if(f){m=db(i,16,f);l=f+1|0;g=kb(i,90,H[c+12>>2],l,H[c+16>>2],Zk(g),-8)+2|0;Xa(i,13,g,j,g);bb(i,m);Xa(i,80,H[c+12>>2],l,H[c+16>>2]-1|0);Va(i,71,1,f)}if(I[H[a>>2]+87|0]){k=0}else{Lk(i,H[b+12>>2],j);a:{b:{switch(I[d|0]-10|0){case 2:g=Db(a);f=Db(a);Xa(i,97,H[c+12>>2],H[c+16>>2],g);Va(i,127,H[d+4>>2],f);Xa(i,128,H[d+4>>2],g,f);pb(i,8);xb(a,f);xb(a,g);break a;case 1:g=Db(a);f=H[c+16>>2];kb(i,97,H[c+12>>2],f,g,H[d+20>>2],f);ob(i,138,H[d+4>>2],g,H[c+12>>2],H[c+16>>2]);xb(a,g);break a;case 0:jj(a,H[c+12>>2],H[d+4>>2],H[c+16>>2]);break a;case 3:f=H[d+12>>2];if(!f){f=Cc(a,H[c+16>>2]);H[d+12>>2]=f;H[d+16>>2]=H[c+16>>2]}jj(a,H[c+12>>2],f,H[c+16>>2]);db(i,11,H[d+4>>2]);break a;default:break b}}Va(i,84,H[c+12>>2],H[c+16>>2])}a=H[b+8>>2];if(a){Va(i,60,a,h)}lb(i,j);db(i,67,e)}return k}function Kn(a){var b=0,c=0,d=0,e=0,f=0;a:{if(I[a+97|0]!=167){break a}if(Ny(a)){break a}Gi(a,0);Dm(a);while(1){c=H[a+16>>2];if((b|0)<H[a+20>>2]){d=c+(b<<4)|0;c=H[d+4>>2];b:{if(!c){break b}Gg(c);H[d+4>>2]=0;if((b|0)==1){break b}H[d+12>>2]=0}b=b+1|0;continue}break}c=H[c+28>>2];if(c){Dk(c)}Ym(a);pr(a);d=a+420|0;while(1){d=H[d>>2];if(d){b=H[d+8>>2];while(1){qy(a,b);c=H[b+12>>2];_a(a,b);b=c;if(b){continue}break}continue}break}Uf(a+412|0);e=a+436|0;while(1){e=H[e>>2];if(e){f=H[e+8>>2];b=0;while(1){if((b|0)!=3){d=N(b,20)+f|0;c=H[d+16>>2];if(c){Ka[c|0](H[d+8>>2])}b=b+1|0;continue}break}_a(a,f);continue}break}Uf(a+428|0);b=a+392|0;while(1){b=H[b>>2];if(b){c=H[b+8>>2];Aq(a,c);zq(a,c);continue}break}Uf(a+384|0);Yc(a,0);id(H[a+288>>2]);F[a+97|0]=213;_a(a,H[H[a+16>>2]+28>>2]);c=H[a+256>>2];if(c){Ka[c|0](H[a+252>>2])}F[a+97|0]=206;if(I[a+312|0]){Wa(H[a+352>>2])}Wa(a)}}function ie(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;a:{if(!b){break a}if(!(H[a+528>>2]?a:0)){d=H[b+24>>2]-1|0;H[b+24>>2]=d;if(d){break a}}c=a;a=H[b+8>>2];while(1){if(a){d=H[a+20>>2];if(!(I[b+43|0]==1|(H[c+528>>2]?c:0))){td(H[a+24>>2]+24|0,H[a>>2],0)}wl(c,a);a=d;continue}break}b:{c:{switch(I[b+43|0]){case 0:a=H[b+48>>2];while(1){if(a){d:{if(H[c+528>>2]?c:0){break d}d=H[a+12>>2];e=H[a+16>>2];e:{if(e){H[e+12>>2]=d;break e}td(H[b+60>>2]+56|0,H[(d?d:a)+8>>2],d)}d=H[a+12>>2];if(!d){break d}H[d+16>>2]=H[a+16>>2]}zj(c,H[a+28>>2]);zj(c,H[a+32>>2]);d=H[a+4>>2];_a(c,a);a=d;continue}break};break b;case 1:a=0;if(!(H[c+528>>2]?c:0)){gu(0,b)}if(H[b+48>>2]){while(1){if(H[b+44>>2]>(a|0)){if((a|0)!=1){_a(c,H[H[b+48>>2]+(a<<2)>>2])}a=a+1|0;continue}break}_a(c,H[b+48>>2])}break b;default:break c}}hc(c,H[b+44>>2])}to(c,b);_a(c,H[b>>2]);_a(c,H[b+12>>2]);qb(c,H[b+16>>2]);_a(c,b)}}function _n(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=Ga-16|0;Ga=k;f=H[b+12>>2];i=H[a+40>>2];H[a+40>>2]=i+2;d=H[b>>2];g=H[a>>2];e=H[g+16>>2];j=Lb(g,H[b+24>>2]);a:{if(cc(a,27,d,0,H[e+(j<<4)>>2])){break a}Dd(a,j,H[f+20>>2],1,H[f>>2]);d=zb(a);if(!d){break a}g=c;l=(g|0)>=0;if(!l){g=H[b+44>>2]}e=_k(a,b);h=H[a+40>>2];H[a+40>>2]=h+1;n=J[b+50>>1];m=Zk(e);kb(d,119,h,0,n,m,-8);fe(a,i,j,f,112);e=Va(d,35,i,0);f=Db(a);ag(a);Gn(a,b,i,f,0,k+12|0,0,0);Va(d,139,h,f);ys(a,H[k+12>>2]);Va(d,38,i,e+1|0);bb(d,e);if(!l){Va(d,145,g,j)}e=i+1|0;kb(d,113,e,g,j,m,-8);pb(d,c>>>27&16^17);j=Va(d,33,h,0);b:{if(I[b+54|0]){c=Yb(d,1);g=H[d+108>>2];ob(d,132,h,c,f,J[b+50>>1]);cs(a,2,b);bb(d,c);break b}Rc(a);g=H[d+108>>2]}Xa(d,133,h,f,e);if(!(I[b+56|0]&2)){db(d,137,e)}Va(d,138,e,f);pb(d,16);xb(a,f);Va(d,36,h,g);bb(d,j);db(d,122,i);db(d,122,e);db(d,122,h)}Ga=k+16|0}function Ag(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{b:{c:{i=I[a|0];if((i|0)==45){a=a+1|0;g=-1;break c}if((i|0)!=48){if((i|0)!=43){break c}a=a+1|0;break c}if(!(I[I[a+2|0]+30016|0]&8)|(I[a+1|0]|32)!=120){break c}e=a+2|0;while(1){d=e;e=d+1|0;a=I[d|0];if((a|0)==48){continue}break}e=0;while(1){g=I[(a&255)+30016|0]&8;if(!(!g|e>>>0>7)){c=gf(a<<24>>24)+(c<<4)|0;e=e+1|0;a=I[d+e|0];continue}break}e=0;if((c|0)<0){break a}if(!g){break b}break a}c=I[a|0];if(c-58>>>0<4294967286){break a}while(1){if((c&255)!=48){d:{c=0;while(1){if((c|0)==11){break d}h=I[a+c|0];if((h-48&255)>>>0>9){break d}f=SK(f,d,10,0);d=(h&255)-48|0;h=d;f=f+d|0;d=Ja;d=f>>>0<h>>>0?d+1|0:d;c=c+1|0;continue}}}else{c=I[a+1|0];a=a+1|0;continue}break}h=c>>>0>10;a=d+g|0;c=f+g|0;a=c>>>0<g>>>0?a+1|0:a;if(h|(c>>>0>2147483647&(a|0)>=0|(a|0)>0)){break a}c=(i|0)==45?0-f|0:f}H[b>>2]=c;e=1}return e}function tn(a,b,c,d,e){var f=0,g=0;while(1){if(!mc(a,b,c,d)){return I[c|0]!=121}g=0;a:{b:{c:{d:{e:{f:{g:{h:{f=I[b|0];switch(f-102|0){case 11:break a;case 12:break b;case 10:break c;case 0:case 6:case 7:case 8:break f;case 1:case 2:case 3:case 4:case 5:case 9:break g;default:break h}}i:{switch(f-48|0){default:switch(f-173|0){case 0:case 1:case 8:break a;case 3:case 4:case 5:case 6:case 7:break c;case 2:break e;default:break d};case 1:if(!e){break b}e=1;if(I[b+5|0]&16){break c}break a;case 0:break i;case 2:case 3:break c;case 4:case 5:case 6:case 7:case 8:case 9:break g}}if(e){break c}g=1;f=H[b+20>>2];if(tn(a,H[f+8>>2],c,d,1)){break c}e=1;if(!tn(a,H[f+24>>2],c,d,1)){break a}break c}e=1}if(!tn(a,H[b+16>>2],c,d,e)){break a}return 1}if(e){break c}e=1;if(I[b+2|0]==45){break a}break c}if((f|0)==19){break b}}return g}e=1}b=H[b+12>>2];continue}}function Mm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Ga-16|0;Ga=f;e=H[b+80>>2];H[f+12>>2]=e;a:{if(!(!I[a+239|0]|!H[b+56>>2])){F[f+11|0]=0;if(c){H[c>>2]=e;H[d>>2]=H[b+84>>2]-1}Lm(0,H[b+72>>2],H[b+76>>2],f+12|0,b+88|0,b+84|0,f+11|0);H[b+80>>2]=I[f+11|0]?0:H[f+12>>2];break a}h=H[b+72>>2]+H[b+76>>2]|0;while(1){g=I[e|0];if(g|i){i=g&128;e=e+1|0;continue}if(!(!H[b+52>>2]|H[b+40>>2]+H[b+48>>2]>>>0>e>>>0)){g=Az(b);if(!g){continue}break a}break}e=e+1|0;H[f+12>>2]=e;if(c){H[c>>2]=H[b+80>>2];H[d>>2]=(H[b+80>>2]^-1)+e}b:{while(1){if(e>>>0<h>>>0){if(I[e|0]){break b}e=e+1|0;continue}break}g=0;H[b+80>>2]=0;break a}g=Nm(b,e,10);if(g){break a}j=b,k=yh(e,f)+e|0,H[j+80>>2]=k;c=H[f>>2];d=c;a=I[a+239|0];e=a?0-c|0:c;c=e+H[b+88>>2]|0;g=(d|0)!=0;d=H[f+4>>2];a=H[b+92>>2]+(a?0-(g+d|0)|0:d)|0;H[b+88>>2]=c;H[b+92>>2]=c>>>0<e>>>0?a+1|0:a;g=0}Ga=f+16|0;return g}function Dc(a,b,c){var d=0,e=0,f=0,g=0;a:{b:{if(c){f=H[a+20>>2];d=(f|0)>0?f:0;f=a;g=a+16|0;c:{while(1){if((e|0)!=(d|0)){a=H[f+16>>2];if(!hb(c,H[a+(e<<4)>>2])){break c}e=e+1|0;continue}break}d=0;if(hb(c,10683)){break a}a=H[f+16>>2];e=0}d=Wc(H[((e<<4)+a|0)+12>>2]+8|0,b);if(d){break a}d=0;if(Fb(b,17563,7)){break a}c=b+7|0;a=1;if((e|0)==1){b=8639;if(!hb(c,17456)){break b}if(!hb(c,17475)){break b}if(!hb(c,8665)){break b}break a}if(hb(c,17475)){break a}b=8658;a=e;break b}d=Wc(H[H[a+16>>2]+28>>2]+8|0,b);if(d){break a}g=a+16|0;d=Wc(H[H[g>>2]+12>>2]+8|0,b);if(d){break a}e=2;while(1){if(H[a+20>>2]>(e|0)){c=e<<4;e=e+1|0;d=Wc(H[(c+H[a+16>>2]|0)+12>>2]+8|0,b);if(!d){continue}break a}break}d=0;if(Fb(b,17563,7)){break a}a=b+7|0;if(!hb(a,17475)){b=8658;a=0;break b}if(hb(a,17456)){break a}b=8639;a=1}d=Wc(H[(H[g>>2]+(a<<4)|0)+12>>2]+8|0,b)}return d}function Bt(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;j=Ga-16|0;Ga=j;f=H[a+236>>2];a:{if(!f){break a}g=H[f+28>>2];if(g&4){H[j>>2]=H[f>>2];Za(a,1284,j);break a}H[f+28>>2]=g|4;b:{if(!b){g=G[f+34>>1]-1|0;k=H[f+4>>2]+N(g,12)|0;ao(a,k);h=1;break b}l=H[b>>2];n=(l|0)>0?l:0;g=-1;while(1){c:{if((m|0)!=(n|0)){i=gg(H[((m<<4)+b|0)+8>>2]);_s(i);if(I[i|0]!=59){break c}g=0;h=G[f+34>>1];h=(h|0)>0?h:0;o=H[i+8>>2];while(1){if((g|0)==(h|0)){g=h;break c}i=H[f+4>>2]+N(g,12)|0;if(hb(o,H[i>>2])){g=g+1|0;continue}else{ao(a,i);k=i;break c}}}h=(l|0)==1;break b}m=m+1|0;continue}}if(!(!h|!k|(e|0)==1|(I[k+4|0]&-16)!=64)){if(!(!b|I[a+208|0]<2)){od(a,f+32|0,gg(H[b+8>>2]))}F[f+42|0]=c;G[f+32>>1]=g;H[f+28>>2]=H[f+28>>2]|d<<3;if(b){F[a+206|0]=I[b+16|0]}cl(a,b);break a}if(d){Za(a,17798,0);break a}uj(a,0,0,0,b,c,0,0,e,0,2);b=0}qb(H[a>>2],b);Ga=j+16|0}function zH(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(H[b+8>>2]!=1){break a}a=H[b+12>>2];if(H[a>>2]|I[a+4|0]){break a}H[b+32>>2]=1}a=H[b>>2];j=(a|0)>0?a:0;g=-1;h=-1;f=-1;i=-1;while(1){if((c|0)!=(j|0)){d=H[b+4>>2]+N(c,12)|0;if(I[d+5|0]){a=I[d+4|0];d=H[d>>2];if(!d){h=(a|0)==8?c:(a|0)==16?c:h;i=(a|0)==2?c:i;g=(a|0)==32?c:(a|0)==4?c:g}f=(d|0)==4?(a|0)==2?c:f:f}c=c+1|0;continue}break}b:{if((i|0)>=0){H[b+20>>2]=1;H[H[b+16>>2]+(i<<3)>>2]=1;H[b+40>>2]=0;H[b+44>>2]=1075052544;c=2;e=5;break b}H[b+40>>2]=0;H[b+44>>2]=1087604736;H[b+20>>2]=0;c:{if((g|0)<0){c=1;e=2e4;a=4;break c}c=2;H[b+20>>2]=2;H[H[b+16>>2]+(g<<3)>>2]=1;H[b+40>>2]=0;H[b+44>>2]=1086556160;e=1e4;a=6}if((h|0)<0){break b}H[b+20>>2]=a;H[H[b+16>>2]+(h<<3)>>2]=c;e=e*.5;M[b+40>>3]=e;c=c+1|0}if((f|0)>=0){H[H[b+16>>2]+(f<<3)>>2]=c;M[b+40>>3]=e+-1}return 0}function Jy(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;j=Ga-16|0;Ga=j;i=H[a>>2];H[j+12>>2]=i;m=j+12|0;a:{b:{if(i){k=H[i+16>>2];l=H[i+20>>2];if((b|0)==(k|0)&(c|0)==(l|0)){break b}H[i>>2]=H[i>>2]+1;i=b-k|0;k=c-((b>>>0<k>>>0)+l|0)|0}else{i=b;k=c}i=uk(m,i,k);if(i){break a}i=H[j+12>>2];H[i+32>>2]=0;H[i+36>>2]=0;H[i+24>>2]=-1;H[i+28>>2]=-1;H[i+16>>2]=b;H[i+20>>2]=c}c:{d:{if(!!d&(e|0)>=0|(e|0)>0){if((d|0)==H[i+24>>2]&(e|0)==H[i+28>>2]){break d}i=uk(j+12|0,1,0);if(i){break a}i=uk(j+12|0,d,e);if(i){break a}i=H[j+12>>2];H[i+32>>2]=0;H[i+36>>2]=0;H[i+24>>2]=d;H[i+28>>2]=e;break d}if((e|0)<0){break c}}b=H[i+32>>2];c=(f-b|0)+2|0;b=g-(H[i+36>>2]+(b>>>0>f>>>0)|0)|0;i=uk(j+12|0,c,c>>>0<2?b+1|0:b);if(i){break a}b=H[j+12>>2];H[b+32>>2]=f;H[b+36>>2]=g}i=0}H[h>>2]=i;Ga=j+16|0;b=H[j+12>>2];if((b|0)==H[a>>2]){a=0}else{H[a>>2]=b;a=1}return a}function yk(a,b,c,d){var e=0,f=0,g=0;g=Ka[er(F[a|0])|0](b,c)|0;f=g&H[a+12>>2]-1;e=Rz(a,b,c,f);if(e){g=H[e+8>>2];if(!d){c=H[e>>2];b=H[e+4>>2];a:{if(b){H[b>>2]=c;c=H[e>>2];break a}H[a+8>>2]=c}if(c){H[c+4>>2]=b}b=H[a+16>>2]+(f<<3)|0;if((e|0)==H[b+4>>2]){H[b+4>>2]=c}c=H[b>>2];H[b>>2]=c-1;if((c|0)<=1){H[b+4>>2]=0}b:{if(!I[a+1|0]){break b}b=H[e+12>>2];if(!b){break b}Wa(b)}Wa(e);b=H[a+4>>2];H[a+4>>2]=b-1;if((b|0)<=1){Om(a)}return g}H[e+8>>2]=d;return g}c:{if(d){d:{e=H[a+12>>2];e:{if(!e){if(Qz(a,8)){break e}e=H[a+12>>2]}if(H[a+4>>2]<(e|0)){break d}if(!Qz(a,e<<1)){break d}}H[a+4>>2]=0;return d}e=Xe(20,0);if(!e){break c}f:{if(!(!b|!I[a+1|0])){f=Xe(c,c>>31);H[e+12>>2]=f;if(!f){Wa(e);return d}Ya(f,b,c);break f}H[e+12>>2]=b}H[e+16>>2]=c;H[a+4>>2]=H[a+4>>2]+1;Pz(a,H[a+16>>2]+((g&H[a+12>>2]-1)<<3)|0,e);H[e+8>>2]=d}d=0}return d}function Ay(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;g=Ga-32|0;Ga=g;f=Pb(a,37,g+28|0,0);a:{if(f){break a}f=c;i=b+1|0;f=i?f:f+1|0;h=H[g+28>>2];Vb(h,1,i,f);f=TK(b,c,1024,0);Vb(h,2,f<<10|1023,Ja<<10|f>>>22);i=TK(SK(d,e,3,0),Ja,2,0);e=Ja;while(1){b:{d=k;if((Ab(h)|0)!=100){break b}H[g+16>>2]=0;H[g+20>>2]=0;yy(h,2,g+8|0,g+16|0);d=0;j=H[g+16>>2];f=H[g+20>>2];if(!j&(f|0)<=0|(f|0)<0){break b}k=1;if((e|0)>=(f|0)&i>>>0>=j>>>0|(e|0)>(f|0)){continue}}break}f=rb(h);if(!d){break a}H[g+16>>2]=0;H[g+8>>2]=0;if(f){break a}f=Pb(a,38,g+16|0,0);if(f){break a}f=Pb(a,39,g+8|0,0);if(f){break a}Vb(h,1,b,c);a=H[g+16>>2];d=0;c:{while(1){if((Ab(h)|0)!=100){break c}wc(a,1,d);wc(a,2,Qd(h,0));wc(a,3,Qd(h,1));Ab(a);d=d+1|0;f=rb(a);if(!f){continue}break}rb(h);break a}f=rb(h);if(f){break a}a=H[g+8>>2];Vb(a,1,b,c);Ab(a);f=rb(a)}Ga=g+32|0;return f}function zk(a,b,c){var d=0,e=0,f=0;d=I[a+1|0];if(d&24){if(!(!c|!(d&8))){Pi(b,H[(H[a+8>>2]<<2)+c>>2]);return}a=H[a+8>>2]}a:{b:{c:{d:{switch(I[a|0]-1|0){default:ee(b,11021,4);return;case 0:ee(b,12244,4);return;case 1:ee(b,12777,5);return;case 6:break a;case 5:break b;case 2:case 3:break c;case 4:break d}}if(!(F[a+1|0]&1)){break c}Sm(b,H[a+8>>2],H[a+4>>2]);return}ee(b,H[a+8>>2],H[a+4>>2]);return}Kc(b,91);while(1){d=1;while(1){if(K[a+4>>2]>=d>>>0){e=N(d,12)+a|0;if(!(I[e+1|0]&4)){Ck(b);zk(e,b,c)}d=re(e)+d|0;continue}break}if(I[a+1|0]&32){a=N(H[a+8>>2],12)+a|0;continue}break}Kc(b,93);return}Kc(b,123);while(1){d=1;while(1){if(K[a+4>>2]>=d>>>0){f=d+1|0;e=N(f,12)+a|0;if(!(I[e+1|0]&4)){Ck(b);zk(N(d,12)+a|0,b,c);Kc(b,58);zk(e,b,c)}d=re(e)+f|0;continue}break}if(I[a+1|0]&32){a=N(H[a+8>>2],12)+a|0;continue}break}Kc(b,125)}function ox(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Ga-48|0;Ga=g;f=H[a+16>>2];e=H[f+88>>2];H[e+40>>2]=b;H[e+44>>2]=c;G[e+56>>1]=4;a:{b:{c:{d:{if(H[f+32>>2]>=5){H[f+32>>2]=4;e=Dx(f);break d}e=Ab(H[a+16>>2])}if((e|0)==100){b=J[a+8>>1];e=H[H[f+96>>2]>>2];if(b>>>0>=J[e+54>>1]){f=H[a+20>>2];break c}c=H[(e+(b<<2)|0)+80>>2];if(c>>>0<=11){f=H[a+20>>2];if(!c){break c}b=(c|0)==7?11243:9075;break b}H[a+4>>2]=H[(e+(G[e+52>>1]+b<<2)|0)+80>>2];h=a,i=yi(c),H[h>>2]=i;b=a;a=H[e+36>>2];H[b+12>>2]=a;F[a+1|0]=I[a+1|0]|16;F[H[a+8>>2]+11|0]=1;f=0;e=0;break a}f=H[a+16>>2];if(!f){f=0;break a}e=dd(f);H[a+16>>2]=0;a=H[a+20>>2];if(!e){H[g+16>>2]=b;H[g+20>>2]=c;e=1;f=tb(a,14170,g+16|0);break a}h=g,i=xg(a),H[h+32>>2]=i;f=tb(a,8310,g+32|0);break a}b=11021}H[g>>2]=b;f=tb(f,6431,g);dd(H[a+16>>2]);H[a+16>>2]=0;e=1}H[d>>2]=f;Ga=g+48|0;return e}function JF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((b&-2)==2){a:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break a}}Wb(a);return}f=cb(H[c>>2]);if(f){l=a;d=cb(H[c+4>>2]);if((b|0)==3){a=ac(H[c+8>>2]);e=((a|0)>1?a:1)-1|0}else{e=0}b=0;i=-1;b:{if(!I[f|0]){break b}a=(e|0)>0?e:0;while(1){if(!(!Ve(d)|(a|0)==(b|0))){b=b+1|0;while(1){c=I[d+1|0];d=d+1|0;if((c&192)==128){continue}break}continue}break}while(1){a=f;b=d;if(!Ve(b)){break b}while(1){g=Ve(a);j=Ve(b);while(1){h=I[a+1|0];c=a+1|0;a=c;if((h&192)==128){continue}break}a=b;while(1){h=I[a+1|0];b=a+1|0;a=b;if((h&192)==128){continue}break}if(!(!j|!g)){a=c;if((g|0)==(j|0)){continue}}break}if(g){while(1){a=I[d+1|0];d=d+1|0;if((a&192)==128){continue}break}k=k+1|0;continue}break}i=e+k|0}Hc(l,i+1|0)}return}_(22820,17213,1038,16856);X()}function oy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;a:{while(1){c=0;if(I[a+32|0]){break a}d=H[b>>2];if(H[d+32>>2]!=H[a+24>>2]|H[a+28>>2]!=H[d+36>>2]){break a}c=H[a+12>>2];if(c){c=oy(c,b);if(c){break a}a=H[a+16>>2];continue}break}d=Ga-16|0;Ga=d;h=H[H[b>>2]>>2];g=H[a+20>>2];f=H[g+28>>2];H[d+12>>2]=f;H[d+8>>2]=0;a=H[a+36>>2];c=H[b+4>>2];e=I[b+24|0]!=121?(c+31|0)/32|0:c;c=0;b:{if(!f){break b}f=N(a,e);a=0;while(1){c=my(d+12|0);e=H[g+68>>2];c:{if((e|0)<H[h+24>>2]&(a|0)!=(e|0)){break c}if(I[b+24|0]==121){H[H[b+28>>2]+(a+f<<2)>>2]=c;break c}if(!c){break c}c=H[b+28>>2]+(f+((a+1|0)/32|0)<<2)|0;H[c>>2]=H[c>>2]|1<<a}a=H[d+12>>2];c=0;if(I[a|0]!=1){break b}c=a+1|0;a=F[a+1|0];d:{if((a|0)<0){e=uc(c,d+8|0);a=H[d+8>>2];break d}a=a&255;H[d+8>>2]=a;e=1}H[d+12>>2]=c+e;if(H[b+4>>2]>(a|0)){continue}break}c=267}Ga=d+16|0}return c}function bf(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;i=Ga-16|0;Ga=i;j=H[a>>2];a:{b:{c:{if(!g|b){break c}h=19245;if(!H[g>>2]){h=19520;if(!H[g+4>>2]){break c}}H[i>>2]=h;Za(a,6395,i);break b}b=Rd(a,b,c,d);if(!b){break b}h=H[b>>2]-1|0;d:{if(I[a+208|0]<2){break d}k=H[((h<<6)+b|0)+16>>2];if(!k){break d}Ne(a,k,(H[d>>2]?d:0)?d:c)}if(H[e+4>>2]){l=(h<<6)+b|0,m=vc(j,e),H[l+20>>2]=m}e:{if(!f){break e}a=(h<<6)+b|0;H[a+28>>2]=f;if(!(I[f+5|0]&8)){break e}c=I[a+45|0]|I[a+46|0]<<8|8192;F[a+45|0]=c;F[a+46|0]=c>>>8}if(!g){H[((h<<6)+b|0)+52>>2]=0;break a}if(H[g+4>>2]){a=(h<<6)+b|0;c=I[a+45|0]|I[a+46|0]<<8|1024;F[a+45|0]=c;F[a+46|0]=c>>>8;H[a+52>>2]=H[g+4>>2];break a}H[((h<<6)+b|0)+52>>2]=H[g>>2];break a}f:{if(!g){break f}a=H[g>>2];if(a){wj(j,a);break f}a=H[g+4>>2];if(!a){break f}Ie(j,a)}hc(j,f);b=0}Ga=i+16|0;return b}function ek(a){var b=0,c=0,d=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&249;a:{if(I[a|0]){break a}d=J[a+70>>1];c=d+1|0;G[a+70>>1]=c;b=H[a+116>>2];if(J[b+24>>1]<=(c&65535)>>>0){G[a+70>>1]=d;break a}if(I[b+8|0]){a=0}else{a=Wo(a)}return a}c=I[a|0];b:{c:{if(!c){break c}if(c>>>0>=3){b=Yj(a);if(b){break b}c=I[a|0]}b=101;d:{switch(c-1|0){case 0:break b;case 1:break d;default:break c}}b=0;F[a|0]=0;if(H[a+4>>2]>0){break b}}b=J[a+70>>1]+1|0;G[a+70>>1]=b;e:{d=H[a+116>>2];if(I[d|0]){if(!uf(412)){break e}}b=ab(72945);break b}c=I[d+8|0];f:{if(J[d+24>>1]<=(b&65535)>>>0){if(!c){b=mg(a,eb((I[d+9|0]+H[d+56>>2]|0)+8|0));if(!b){break f}break b}while(1){if(!I[a+68|0]){F[a|0]=1;b=101;break b}Zo(a);c=H[a+116>>2];if(J[a+70>>1]>=J[c+24>>1]){continue}break}b=0;if(!I[c+1|0]){break b}b=ek(a);break b}b=0;if(c){break b}}b=Wo(a)}return b}function Wj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=Ga-288|0;Ga=c;g=H[a+400>>2];a:{if(!(H[g+12>>2]?0:g)){Yc(a,21);a=kd(148048);break a}d=H[g+4>>2];f=c+16|0;un(f,a);e=1;F[c+167|0]=1;F[c+224|0]=1;h=I[a+177|0];F[a+177|0]=0;H[c+152>>2]=1;b:{c:{if(Vj(f,b)){break c}b=H[c+252>>2];if(I[a+87|0]|!b|I[b+43|0]){break c}e=0;d:{if(H[d+4>>2]){break d}H[d+4>>2]=H[b+4>>2];qb(a,H[b+52>>2]);e=J[b+34>>1];G[d+36>>1]=e;G[d+34>>1]=e;H[d+28>>2]=H[d+28>>2]|H[b+28>>2]&640;e=0;H[b+4>>2]=0;G[b+34>>1]=0;if(!(!(I[b+28|0]&128)|!H[H[H[H[g>>2]+4>>2]>>2]+52>>2])){e=J[tc(b)+50>>1]!=1}f=H[b+8>>2];if(!f){break d}H[d+8>>2]=f;H[b+8>>2]=0;H[f+12>>2]=d}H[g+12>>2]=1;break b}b=H[c+20>>2];H[c>>2]=b;te(a,1,b?8310:0,c);_a(a,H[c+20>>2])}F[c+224|0]=0;b=H[c+24>>2];if(b){yf(b)}ie(a,H[c+252>>2]);Zi(c+16|0);F[a+177|0]=h;a=nd(a,e)}Ga=c+288|0;return a}function yK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=Ga-16|0;Ga=g;e=H[a+24>>2];j=H[H[e>>2]>>2];k=Xg(j,H[e+40>>2]);h=H[b+32>>2];a:{if(!h){break a}l=e+4|0;c=h+8|0;b:{while(1){if(H[h>>2]>(f|0)){if(!I[e+36|0]){d=H[c+4>>2];c:{if(!d){d=I[c+37|0]|I[c+38|0]<<8;break c}if((Xg(j,d)|0)!=(k|0)){a=H[e>>2];b=H[e+48>>2];c=H[e+44>>2];H[g+8>>2]=d;H[g>>2]=c;H[g+4>>2]=b;Za(a,6323,g);break b}_a(j,d);H[c+4>>2]=0;i=c+37|0;d=I[c+37|0]|I[c+38|0]<<8|512;F[i|0]=d;F[i+1|0]=d>>>8}i=H[e+32>>2];d=d|128;F[c+37|0]=d;F[c+38|0]=d>>>8;H[c>>2]=i}d=h+(f<<6)|0;if(!(I[d+46|0]&4)){if(Kb(l,H[d+52>>2])){break b}}c=c- -64|0;f=f+1|0;continue}break}c=0;if(!H[b+64>>2]){break a}f=0;while(1){e=H[b+64>>2];if(H[e>>2]<=(f|0)){break a}h=N(f,24);f=f+1|0;if(!lc(a,H[(e+h|0)+20>>2])){continue}break}}c=2}Ga=g+16|0;return c|0}function Gn(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;j=H[a+8>>2];if(f){if(H[b+36>>2]){l=f,m=jb(a),H[l>>2]=m;H[a+52>>2]=c+1;TB(a,H[b+36>>2],H[f>>2]);g=0;f=a+52|0}H[f>>2]=0}if(!e|!(I[b+55|0]&8)){e=b+52|0}else{e=b+50|0}k=J[e>>1];i=Cc(a,k);e=0;a:{if(!g){break a}if((h|0)==(i|0)){e=g;if(!H[g+36>>2]){break a}}e=0}f=0;while(1){if((f|0)!=(k|0)){b:{c:{if(!e){break c}g=f<<1;h=J[g+H[e+4>>2]>>1];if((h|0)==65534){break c}if((h|0)==J[g+H[b+4>>2]>>1]){break b}}g=f+i|0;h=G[H[b+4>>2]+(f<<1)>>1];d:{if((h|0)==-2){H[a+52>>2]=c+1;Qk(a,H[(H[b+40>>2]+(f<<4)|0)+8>>2],g);H[a+52>>2]=0;break d}Qc(H[a+8>>2],H[b+12>>2],c,h,g)}if(G[H[b+4>>2]+(f<<1)>>1]<0){break b}g=H[j+108>>2];e:{if((g|0)<=0){break e}g=g-1|0;if(I[H[j+104>>2]+N(g,20)|0]!=87){break e}ue(j,g)}}f=f+1|0;continue}break}if(d){Xa(j,97,i,k,d)}md(a,i,k);return i}function jJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;a:{if((gb(H[c>>2])|0)==5){break a}d=Eb(a,36);if(!d){break a}e=H[d+12>>2];h=d,i=H[Gc(a)+120>>2],H[h+12>>2]=i;b:{if((b|0)==1){if(e){vi(d,1,44);break b}H[d+28>>2]=1;break b}a=H[c+4>>2];c:{d:{e:{if(e){a=cb(a);e=bc(H[c+4>>2]);f:{if(!a){e=0;break f}Bb(d,a,e)}a=H[d+32>>2];if(H[d+28>>2]==(e|0)){if(!a){break b}f=d+32|0;break e}f=d+32|0;if(a){break e}b=Ib((H[d+24>>2]<<2)+4|0,0);if(!b){break c}a=H[d+24>>2];g=((a|0)>1?a:1)-1|0;a=0;while(1){if((a|0)==(g|0)){break d}H[(a<<2)+b>>2]=H[d+28>>2];a=a+1|0;continue}}h=d,i=bc(a),H[h+28>>2]=i;break b}b=ye(a,H[d+24>>2]<<2,0);if(!b){break c}}a=H[d+24>>2];if((a|0)>0){H[((a<<2)+b|0)-4>>2]=e}H[f>>2]=b;break b}ti(d,7)}H[d+24>>2]=H[d+24>>2]+1;a=cb(H[c>>2]);b=bc(H[c>>2]);if(!a){break a}Bb(d,a,b)}}function vH(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c=Ga-32|0;Ga=c;g=1;i=H[H[a>>2]+12>>2];f=a+4|0;Ch(f);Wa(H[a+60>>2]);Wa(H[a+112>>2]);Wa(H[a+76>>2]);j=$a(f,0,116);k=(b|0)==1;a:{if(k){f=-1;b=3;break a}m=1;g=b&2;h=g>>>1|0;b=b&4;g=b?g?2:1:h;f=b?h:-1;b=19}H[a+72>>2]=b;l=a+60|0;b:{c:{d:{if(!(h|k)){break d}b=cb(H[e>>2]);if(!b){break d}H[c+16>>2]=b;b=Hb(8310,c+16|0);H[l>>2]=b;if(!b){break c}n=a- -64|0,o=ub(b),H[n>>2]=o}b=0;if((f|0)>=0){n=c,o=cb(H[(f<<2)+e>>2]),H[n>>2]=o;f=Hb(8310,c);H[a+76>>2]=f;if(!f){break c}n=a,o=ub(f),H[n+80>>2]=o}if((d|0)>(g|0)){b=ac(H[(((d|0)>(g|0)?g:-1)<<2)+e>>2]);b=(b|0)>0?b:0}H[a+84>>2]=b;b=Mi(i,b,0,-2,H[a+60>>2],H[a- -64>>2],0,m,j);if(b){break b}b=xk(i,j,l);if(b){break b}b=Kz(a);break b}b=7}Ga=c+32|0;return b|0}function CF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if((b|0)==2){if((gb(H[c>>2])|0)==5){Wb(a);return}i=cb(H[c>>2]);g=ac(H[c+4>>2]);b=Ja;h=b;if((b|0)<0){fc(a,8512,-1);return}b=sq(i);j=b;l=b>>31;c=l;b:{if((h|0)<=(c|0)&b>>>0>=g>>>0|(c|0)>(h|0)){b=wm(i);if(!b){break a}wb(a,b,-1,-1);break b}m=ub(i);b=Ub((m+(g-b|0)|0)+1|0);if(!b){break a}c=h-(l+(g>>>0<j>>>0)|0)|0;d=c>>>1|0;c=((c&1)<<31|g-j>>>1)+1|0;d=c?d:d+1|0;f=c;k=d;e=1;d=0;c=b;while(1){if((e|0)!=(f|0)|(d|0)!=(k|0)){F[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}e=f;d=0;c=sh(c,i)+m|0;while(1){f=d+l|0;k=e+j|0;f=k>>>0<j>>>0?f+1|0:f;if((f|0)<=(h|0)&g>>>0>=k>>>0|(f|0)<(h|0)){F[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}F[c|0]=0}wb(a,b,-1,-1);Wa(b);return}_(22830,17213,880,17140);X()}ic(a)}function Um(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=H[a+20>>2];c=H[f+104>>2];g=(c|0)>0?c:0;e=H[a+24>>2];while(1){a:{if((d|0)==(g|0)){break a}b:{h=H[f+100>>2];i=h+N(d,48)|0;if(K[i+20>>2]<e>>>0){break b}if(Tl(H[i+16>>2],e)){break b}while(1){b=1;d=d+1|0;if((c|0)<=(d|0)){break a}H[(N(d,48)+h|0)+28>>2]=0;continue}}d=d+1|0;continue}break}if(!b){return 0}c=H[a+20>>2];c:{if(I[c+5|0]!=2){b=H[c+72>>2];if(H[b>>2]){b=0}else{e=H[c>>2];if(I[c+22|0]|I[c+5|0]==4){d=-1}else{d=H[16007]}b=wp(e,0,b,8222,d)}if(b){break c}f=H[a+4>>2];g=H[c+72>>2];b=H[c+172>>2];d=H[c+168>>2]+4|0;b=d>>>0<4?b+1|0:b;e=SK(H[c+56>>2],0,d,b);b=Ja;d=b;b=qi(g,e,b,H[a+24>>2]);if(b){break c}b=d;d=e+4|0;b=d>>>0<4?b+1|0:b;b=Bc(H[c+72>>2],f,H[c+168>>2],d,b);if(b){break c}}H[c+56>>2]=H[c+56>>2]+1;b=xp(c,H[a+24>>2])}return b}function Oe(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=Ga-256|0;Ga=f;a:{if(He()){break a}if(!(b?(a|0)>0:0)){F[70128]=0;break a}if(!I[70128]){c=Qm(0);F[70129]=0;F[70130]=0;b:{if(!c){$a(f,0,256);break b}c:{if(H[16069]){c=$a(f,0,256);d=H[16069];F[c|0]=d;F[c+1|0]=d>>>8;F[c+2|0]=d>>>16;F[c+3|0]=d>>>24;break c}Ka[H[c+56>>2]](c,256,f)|0}}c=0;while(1){if((c|0)==256){c=0;d=I[70130];while(1){if((c|0)!=256){e=c+70131|0;g=I[e|0];d=(g+I[c+f|0]|0)+d|0;h=(d&255)+70131|0;i=I[h|0];F[h|0]=g;F[e|0]=i;c=c+1|0;continue}break}F[70128]=1;F[70130]=d}else{F[c+70131|0]=c;c=c+1|0;continue}break}}while(1){c=I[70129]+1|0;F[70129]=c;c=(c&255)+70131|0;d=I[c|0];e=d+I[70130]|0;F[70130]=e;e=(e&255)+70131|0;F[c|0]=I[e|0];F[e|0]=d;F[b|0]=I[(d+I[c|0]&255)+70131|0];b=b+1|0;a=a-1|0;if(a){continue}break}}Ga=f+256|0}function lc(a,b){var c=0,d=0,e=0,f=0,g=0;a:{if(!(!b|!H[a+8>>2])){while(1){c=Ka[H[a+8>>2]](a,b)|0;if(c){return c&2}g=2;c=2;b:{if(gc(a,H[b+28>>2])){break b}if(Kb(a,H[b+36>>2])){break b}if(gc(a,H[b+40>>2])){break b}if(Kb(a,H[b+44>>2])){break b}if(gc(a,H[b+48>>2])){break b}if(Kb(a,H[b+60>>2])){break b}c=0;e=H[b+72>>2];if(!e){break b}d=H[a+12>>2];c:{if((d|0)==39){break c}f=H[a>>2];if(f){if((d|0)==63|I[f+208|0]>1){break c}break b}if((d|0)!=63){break b}}c=wC(a,e,0)}if(c){break a}e=0;d=H[b+32>>2];d:{if(!d){break d}c=d+8|0;d=H[d>>2];while(1){if((d|0)<=0){break d}e:{f=H[c+20>>2];if(f){if(lc(a,f)){break e}}if(I[c+37|0]&4){if(gc(a,H[c+56>>2])){break e}}c=c- -64|0;d=d-1|0;continue}break}e=2}if(e){break a}c=H[a+12>>2];if(c){Ka[c|0](a,b)}b=H[b+52>>2];if(b){continue}break}}g=0}return g}function kz(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;if(J[a+4>>1]<=1){b=H[a>>2];H[b+56>>2]=H[b+56>>2]+1;a:{if((Ab(H[a+12>>2])|0)!=100){F[a+6|0]=1;a=rb(H[a+12>>2]);break a}g=a,h=ed(H[a+12>>2],0),H[g+32>>2]=h;H[a+36>>2]=Ja;a=0}H[b+56>>2]=H[b+56>>2]-1;return a|0}b=Ga-16|0;Ga=b;H[b+12>>2]=0;c=H[a+16>>2];b:{c:{if(c){while(1){if(!I[a+7|0]){rb(H[a+12>>2])}wd(a,c,b+12|0);d=I[c+32|0];H[a+88>>2]=1;F[a+7|0]=1;F[a+6|0]=d;e=H[c+28>>2];H[a+32>>2]=H[c+24>>2];H[a+36>>2]=e;if(!d){if(Oq(a,b+12|0)){continue}}break}d=H[b+12>>2];if(d){break b}break c}F[a+6|0]=1}e=H[a+32>>2];c=H[a+36>>2];d:{if(!I[a+52|0]){d=0;f=K[a+80>>2]<e>>>0;e=H[a+84>>2];if(f&(e|0)<=(c|0)|(c|0)>(e|0)){break d}break b}d=0;f=H[a+76>>2];if((f|0)<=(c|0)&K[a+72>>2]<=e>>>0|(c|0)>(f|0)){break b}}F[a+6|0]=1}Ga=b+16|0;return d|0}function eD(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;i=Ga-32|0;Ga=i;h=H[e+24>>2];j=H[a>>2];g=aj(j,e,0);k=nb(j,f,0);if(g){H[g+48>>2]=-1;e=I[g+45|0]|I[g+46|0]<<8|512;F[g+45|0]=e;F[g+46|0]=e>>>8;e=H[g+24>>2];H[e+24>>2]=H[e+24>>2]-1;H[g+24>>2]=0}a:{if(c){e=0;f=0;while(1){if(f>>>0<J[c+50>>1]){e=sb(a,e,$m(a,G[H[c+4>>2]+(f<<1)>>1]));f=f+1|0;continue}break}h=I[h+43|0]==1?14:15;break a}e=I[h+43|0];if((e|0)==2){e=0;f=0;while(1)if(G[h+34>>1]<=(f|0)){h=14;break a}else{e=sb(a,e,$m(a,f));f=f+1|0;continue}}h=(e|0)==1?14:15;e=sb(a,0,mb(a,75,0,0))}b:{if(!d){break b}f=0;while(1){if(H[d>>2]<=(f|0)){break b}e=sb(a,e,nb(j,H[((f<<4)+d|0)+8>>2],0));f=f+1|0;continue}}d=Hd(a,e,g,k,0,0,0,8519680,0);if(d){H[d+4>>2]=H[d+4>>2]|134217728}Pd(i,h,b);H[i+8>>2]=c?J[c+50>>1]:-1;Sc(a,d,i);hc(j,d);Ga=i+32|0}function Sx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);f=x(1)|0;x(0)|0;h=f;i=(f&2147483640)>>>0<1072010280;if(!i){f=(f|0)>0|(f|0)>=0;a=.7853981633974483-(f?a:-a)+(3061616997868383e-32-(f?b:-b));h=h>>>31|0;b=0}e=a*a;d=a*e;j=d*.3333333333333341;g=d;d=e*e;e=j+(e*(g*(d*(d*(d*(d*(d*-18558637485527546e-21+7817944429395571e-20)+.0005880412408202641)+.0035920791075913124)+.021869488294859542)+.13333333333320124+e*(d*(d*(d*(d*(d*2590730518636337e-20+7140724913826082e-20)+.0002464631348184699)+.0014562094543252903)+.0088632398235993)+.05396825397622605))+b)+b);b=a+e;if(!i){g=b*b;d=b;b=+(1-(c<<1)|0);a=a+(e-g/(d+b));a=b-(a+a);return h?-a:a}if(c){g=-1/b;C(+g);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();C(+b);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);b=+B();b=g*(d*(e-(b-a))+(d*b+1))+d}return b}function tI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Ga-128|0;Ga=d;e=Cg(a);a:{if((b|0)<2){break a}f=Tm(a,c,a);if(!f){break a}if((b|0)==2){b=cb(H[c+4>>2]);if(!b){break a}if(e&3){b:{if(I[b|0]!=36){vf(d,a);c=I[b|0];c:{if(c-58>>>0>=4294967286){ee(d,17705,2);ee(d,b,ub(b));ee(d,17703,2);break c}ee(d,24058,(c|0)==91?1:2);ee(d,b,ub(b));Kc(d,0)}b=0;if(!I[d+25|0]){b=Xf(f,H[d+4>>2],0,a)}Bk(d);break b}b=Xf(f,b,0,a)}if(!b){break a}if(e&1){Qi(b,a,0);break a}Ak(b,a);Eg(a,0);break a}b=Xf(f,b,0,a);if(I[f+21|0]|!b){break a}Ak(b,a);break a}vf(d,a);Kc(d,91);e=1;d:{e:{while(1){if((b|0)==(e|0)){break e}g=Xf(f,cb(H[(e<<2)+c>>2]),0,a);if(!I[f+21|0]){Ck(d);f:{if(g){zk(g,d,0);break f}ee(d,11021,4)}e=e+1|0;continue}break}if((b|0)!=(e|0)){break d}}Kc(d,93);Dh(d);Eg(a,74)}Bk(d)}Ga=d+128|0}function lh(a,b){var c=0,d=0,e=0,f=0;a:{b:{if(a){c=b-1|0;c:{while(1){if(K[a>>2]>=4001){b=H[a+8>>2];if(!b){break c}d=(c>>>0)/(b>>>0)|0;c=c-N(d,b)|0;d=(d<<2)+a|0;a=H[d+12>>2];if(a){continue}a=Pj(b);H[d+12>>2]=a;if(a){continue}break a}break}a=(c>>>3|0)+a|0;F[a+12|0]=I[a+12|0]|1<<(c&7);return 0}e=c+1|0;d=a+12|0;b=(c>>>0)%125|0;c=H[d+(b<<2)>>2];d:{if(c){while(1){if((c|0)==(e|0)){return 0}b=b+1|0;b=b>>>0>124?0:b;c=H[d+(b<<2)>>2];if(c){continue}break}c=H[a+4>>2];if(c>>>0<62){break d}break b}c=H[a+4>>2];if(c>>>0>=124){break b}}H[a+4>>2]=c+1;H[d+(b<<2)>>2]=e}return 0}b=0;c=Uc(0,500,0);if(!c){break a}f=Ya(c,d,500);$a(d,0,500);H[a+8>>2]=(H[a>>2]+124>>>0)/125;c=lh(a,e);while(1){if((b|0)!=125){d=H[(b<<2)+f>>2];if(d){c=lh(a,d)|c}b=b+1|0;continue}break}_a(0,f);return c}return 7}function IH(a){a=a|0;var b=0,c=0,d=0;d=Ga-16|0;Ga=d;H[d+12>>2]=0;H[d+8>>2]=0;H[d+4>>2]=0;H[d+4>>2]=51232;b=fx(a,1375,54112);a:{if(b){break a}H[d+12>>2]=54368;H[d+8>>2]=54396;c=Ub(24);if(!c){b=7;break a}Tz(c);H[c+20>>2]=0;b=7;b:{if(yk(c,13275,7,H[d+12>>2])){break b}if(yk(c,8672,7,H[d+8>>2])){break b}if(yk(c,22976,10,H[d+4>>2])){break b}b=am(a,8594,1,524289,c,95,0,0);if(!b){b=am(a,8594,2,524289,c,95,0,0)}if(b){break b}b=wi(a,3148,-1);if(b){break b}b=wi(a,3873,1);if(b){break b}b=wi(a,9547,1);if(b){break b}b=wi(a,9547,2);if(b){break b}b=wi(a,12124,1);if(b){break b}H[c+20>>2]=H[c+20>>2]+1;b=Qp(a,22692,51136,c);if(b){break a}H[c+20>>2]=H[c+20>>2]+1;b=Qp(a,22563,51136,c);if(b){break a}H[c+20>>2]=H[c+20>>2]+1;b=Qp(a,12111,54820,c);break a}Om(c);Wa(c)}Ga=d+16|0;return b|0}function jH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=H[a+4>>2];m=H[a>>2];while(1){h=H[a+12>>2];i=H[a+8>>2];if((h|0)>=(i|0)){return 101}while(1){a:{if((h|0)>=(i|0)){break a}if(!tz(m,I[h+k|0])){break a}h=h+1|0;H[a+12>>2]=h;continue}break}g=h;while(1){b:{if((g|0)>=(i|0)){break b}if(tz(m,I[g+k|0])){break b}g=g+1|0;H[a+12>>2]=g;continue}break}n=(g|0)<=(h|0);if(n){continue}j=g-h|0;if((j|0)>H[a+24>>2]){g=j+20|0;H[a+24>>2]=g;g=Ae(H[a+20>>2],g);if(!g){return 7}H[a+20>>2]=g}g=0;i=(j|0)>0?j:0;while(1){if((g|0)!=(i|0)){l=I[(g+h|0)+k|0];F[H[a+20>>2]+g|0]=(l-65&255)>>>0<26?l+32|0:l;g=g+1|0;continue}break}H[b>>2]=H[a+20>>2];H[c>>2]=j;H[d>>2]=h;H[e>>2]=H[a+12>>2];h=H[a+16>>2];H[a+16>>2]=h+1;H[f>>2]=h;if(n){continue}break}return 0}function Rs(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Ga-32|0;Ga=f;a:{if(I[d+36|0]&80|(!c|H[b+4>>2]&33562624)){break a}b:{if(H[b+52>>2]){e=b;while(1){if(!e){break b}if(H[e+68>>2]){break a}e=H[e+52>>2];continue}}e=H[b+68>>2];if(!e){break b}if(!H[e+8>>2]){break a}}if(H[b+60>>2]){break a}while(1){if(I[c|0]==44){i=Rs(a,b,H[c+16>>2],d)+i|0;c=H[c+12>>2];continue}break}if(!$r(c,d)){break a}H[b+4>>2]=H[b+4>>2]|16777216;e=i+1|0;while(1){if(!b){i=e;break a}h=nb(H[a>>2],c,0);$k(h,-1,1);H[f+8>>2]=a;g=H[d+40>>2];H[f+20>>2]=0;H[f+16>>2]=g;H[f+12>>2]=g;H[f+24>>2]=H[b+28>>2];g=Ih(f+8|0,h);c:{if(!H[b+68>>2]){break c}if(vB(a,g,H[H[b+68>>2]+8>>2])){break c}fb(H[a>>2],g);break a}h=(H[b+4>>2]&8?44:36)+b|0;j=h,k=he(a,H[h>>2],g),H[j>>2]=k;b=H[b+52>>2];continue}}Ga=f+32|0;return i}function Et(a,b,c){a=H[a+4>>2];a:{switch(b-204|0){case 0:case 35:case 36:case 48:hc(H[a>>2],H[c>>2]);return;case 12:case 13:case 42:case 44:case 63:case 74:case 76:case 79:case 86:case 91:case 107:fb(H[a>>2],H[c>>2]);return;case 17:case 27:case 28:case 40:case 43:case 45:case 49:case 50:case 57:case 64:case 73:case 75:case 106:qb(H[a>>2],H[c>>2]);return;case 34:case 41:case 52:case 53:case 58:Ic(H[a>>2],H[c>>2]);return;case 37:sl(H[a>>2],H[c>>2]);return;case 47:case 102:Ho(H[a>>2],H[c>>2]);return;case 59:case 66:Ie(H[a>>2],H[c>>2]);return;case 69:case 103:case 104:case 105:case 108:tl(H[a>>2],H[c>>2]);return;case 82:case 87:Js(H[a>>2],H[c>>2]);return;case 84:Ie(H[a>>2],H[c+4>>2]);return;case 110:case 111:case 112:fb(H[a>>2],H[c+4>>2]);break;default:break a}}}function mi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=I[a|0];d=c<<24>>24;a:{if((d|0)>=0){a=0;d=1;break a}e=F[a+1|0];if((e|0)>=0){c=d&127;a=c>>>25|0;c=e&255|c<<7;d=2;break a}e=e&255;d=F[a+2|0];h=(d&127|c<<14)&2080895;if((d|0)>=0){c=h|e<<7&16256;a=0;d=3;break a}c=F[a+3|0];f=(c&127|e<<14)&2080895;if((c|0)>=0){c=f|h<<7;a=0;d=4;break a}c=I[a+4|0];e=c|h<<14;d=c<<24>>24;if((d|0)>=0){a=h>>>18|0;c=f<<7|e;d=5;break a}c=F[a+5|0];g=c&255|f<<14;f=f|h<<7;if((c|0)>=0){a=f>>>18|0;c=e<<7&266354560|g;d=6;break a}c=F[a+6|0];e=c&255|e<<14;if((c|0)>=0){a=f>>>11|0;c=e&-266354561|g<<7&266354560;d=7;break a}c=F[a+7|0];g=c&255|g<<14;e=e&2080895;if((c|0)>=0){a=f>>>4|0;c=g&-266354561|e<<7;d=8;break a}c=g<<8&532709120|(I[a+8|0]|e<<15);a=d>>>3&15|f<<4;c=c|0;d=9}H[b>>2]=c;H[b+4>>2]=a;return d}function eI(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;H[c>>2]=0;H[c+4>>2]=0;H[c+8>>2]=0;h=ib(b);a:{b:{if(!((h|0)<2|I[b|0]!=47)){a=H[17625];g=(a|0)>0?a:0;i=H[17626];c:{while(1){if((f|0)==(g|0)){break c}a=f<<2;f=f+1|0;a=H[a+i>>2];if(ad(H[a+52>>2],b)){continue}break}H[a+48>>2]=H[a+48>>2]+1;break b}a=xc(h+59|0,0);f=7;if(!a){break a}f=Zd(H[17626],(H[17625]<<2)+4|0,0);if(!f){Wa(a);return 7}g=H[17625];H[17625]=g+1;H[f+(g<<2)>>2]=a;H[17626]=f;f=$a(a,0,56);H[f+36>>2]=3;g=H[16063];i=H[16062];j=f+56|0;H[f+52>>2]=j;H[f+16>>2]=i;H[f+20>>2]=g;Ya(j,b,h+1|0);H[f+48>>2]=1;H[f+28>>2]=8;break b}a=xc(56,0);if(!a){return 7}b=$a(a,0,56);H[b+36>>2]=3;f=H[16063];H[b+16>>2]=H[16062];H[b+20>>2]=f}H[c+4>>2]=a;if(e){H[e>>2]=d|128}H[c>>2]=31828;f=0}return f|0}function ou(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ga-48|0;Ga=e;k=H[a+20>>2];f=d;a:{while(1){b:{if(!c|!H[a+16>>2]){break b}if(xo(a,c)){break b}g=f-1|0;if(sd(H[a+4>>2],c,e+44|0,0)){H[e+32>>2]=c;Tc(a,16387,e+32|0);break a}else{i=H[H[e+44>>2]+4>>2];c:{d:{e:{if(b){j=eb(i+4|0);h=H[a>>2];if(I[h+17|0]){Zg(a,c,2,0);h=H[a>>2]}if((H[h+40>>2]>>>2|0)-2>>>0<j>>>0){break e}c=0;h=(j|0)>0?j:0;while(1){if((c|0)!=(h|0)){f=eb(((c<<2)+i|0)+8|0);if(I[H[a>>2]+17|0]){Zg(a,f,2,0)}xo(a,f);c=c+1|0;continue}break}f=g-j|0;break c}if(!I[H[a>>2]+17|0]|!g){break d}Zg(a,eb(i),4,c);break d}H[e+16>>2]=c;Tc(a,16434,e+16|0);f=f-2|0;break c}f=g}c=eb(i);rd(H[e+44>>2]);continue}}break}g=f}if(!(!g|H[a+20>>2]!=(k|0))){H[e>>2]=b?12106:11589;H[e+8>>2]=d;H[e+4>>2]=d-g;Tc(a,16511,e)}Ga=e+48|0}function uu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;i=H[a+4>>2];c=H[H[a+8>>2]+4>>2];d=Ao(H[a+12>>2]+N(c,56)|0);if(!d){H[g+12>>2]=0;d=c+H[a>>2]|0;e=H[a+12>>2];h=e+N(c|1,56)|0;f=N(c&65534,56)+e|0;while(1){a:{c=d;d=(c|0)/2|0;if((c|0)<2){break a}b:{if(!H[f+24>>2]){break b}c:{d:{if(!H[h+24>>2]){break d}c=Ka[H[i+32>>2]](i,g+12|0,H[f+32>>2],H[f+20>>2],H[h+32>>2],H[h+20>>2])|0;if((c|0)<0){break d}if(c|f>>>0>=h>>>0){break c}}c=H[a+8>>2];e=H[a+12>>2];H[c+(d<<2)>>2]=(f-e|0)/56;c=H[c+((d^1)<<2)>>2];H[g+12>>2]=0;h=N(c,56)+e|0;continue}if(!H[f+24>>2]){break b}H[g+12>>2]=0}c=H[a+8>>2];e=H[a+12>>2];H[c+(d<<2)>>2]=(h-e|0)/56;f=N(H[c+((d^1)<<2)>>2],56)+e|0;continue}break}H[b>>2]=!H[(N(H[H[a+8>>2]+4>>2],56)+e|0)+24>>2];d=I[H[i+12>>2]+23|0]}Ga=g+16|0;return d}function pD(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;c=Ga-272|0;Ga=c;d=c+248|0;fd(d,0,c+48|0,200,0);ke(d,1589);d=I[b+6|0];g=40;while(1){if(h>>>0<I[b+7|0]){H[c>>2]=g;H[c+4>>2]=H[(d<<2)+35328>>2];vb(c+248|0,28225,c);d=d+1|0;h=h+1|0;g=44;continue}break}if(!h){H[c+32>>2]=H[b>>2];vb(c+248|0,28232,c+32|0);h=1}g=0;d=I[b+5|0];if(d&32){ke(c+248|0,19265);g=1;d=I[b+5|0]}if((d&255)>>>0>=64){ke(c+248|0,19277);g=g+1|0}d=c+248|0;Bb(d,26644,1);Wd(d);i=Wj(a,c+48|0);a:{b:{if(!i){d=Ub(24);if(!d){i=7;break b}f=d+16|0;H[f>>2]=0;H[f+4>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0;H[d+16>>2]=b;F[d+21|0]=h;H[d+12>>2]=a;F[d+20|0]=g;i=0;break a}j=c,k=xg(a),H[j+16>>2]=k;j=f,k=Hb(8310,c+16|0),H[j>>2]=k}d=0}H[e>>2]=d;Ga=c+272|0;return i|0}function bE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=778;g=H[a+4>>2];a:{if(I[g+36|0]&4){break a}a=e+(c>>31)|0;f=c+d|0;a=f>>>0<d>>>0?a+1|0:a;h=H[g+4>>2];k=f;f=H[g>>2];if((h|0)<=(a|0)&k>>>0>f>>>0|(a|0)>(h|0)){j=H[g+12>>2];if(k>>>0>K[g+8>>2]&(a|0)>=(j|0)|(a|0)>(j|0)){f=13;b:{if(!(I[g+36|0]&2)|H[g+32>>2]>0){break b}j=H[g+16>>2];h=H[g+20>>2];if(k>>>0>j>>>0&(a|0)>=(h|0)|(a|0)>(h|0)){break b}i=k;f=a<<1|i>>>31;i=i<<1;l=i;i=(f|0)<=(h|0)&j>>>0>i>>>0|(f|0)<(h|0);j=i?l:j;h=i?f:h;f=3082;i=Zd(H[g+24>>2],j,h);if(!i){break b}H[g+8>>2]=j;H[g+12>>2]=h;H[g+24>>2]=i;f=0}if(f){break a}h=H[g+4>>2];f=H[g>>2]}if(d>>>0>f>>>0&(e|0)>=(h|0)|(e|0)>(h|0)){$a(f+H[g+24>>2]|0,0,d-f|0)}H[g>>2]=k;H[g+4>>2]=a}Ya(d+H[g+24>>2]|0,b,c);f=0}return f|0}function MJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=H[c>>2];e=gb(d);b=gb(H[c+4>>2]);if(!((e|0)==5|(b|0)==5)){g=bc(d);f=1;a:{b:{h=bc(H[c+4>>2]);if((h|0)<=0){e=0;c=0;break b}c:{d:{e:{f:{g:{h:{f=(e|0)==4;i=f&(b|0)==4;i:{if(i){b=nf(H[c>>2]);d=nf(H[c+4>>2]);break i}d=H[c>>2];if(f|(b|0)==4){break h}b=cb(d);d=cb(H[c+4>>2])}if(d){break e}e=0;break g}e=hk(d);b=cb(e);if(b){break f}}c=0;break c}g=bc(e);c=hk(H[c+4>>2]);d=cb(c);if(!d){break c}h=bc(c);break d}e=0;if(!g){c=0;break d}c=0;if(!b){break c}}j=I[d|0];f=1;j:while(1){if((g|0)<(h|0)){f=0;break b}k:{if(I[b|0]!=(j|0)){break k}if(Ob(b,d,h)){break k}break b}f=f+1|0;while(1){b=b+1|0;g=g-1|0;if(i){continue j}if((I[b|0]&192)==128){continue}break}continue}}ic(a);break a}Hc(a,f)}id(e);id(c)}}function nl(a,b){var c=0,d=0,e=0,f=0,g=0;f=Ga-16|0;Ga=f;d=67;while(1){a:{b:{c:{d:{g=I[a|0];if(g){a=a+1|0;e:{c=I[g+29632|0]|c<<8;if((c|0)!=1651273570){if((c|0)==1667785074){d=66;e=a;continue}if((c|0)!=1952807028&(c|0)!=1668050786){break e}d=66;continue}f:{switch((d&7)-3|0){case 0:case 2:break f;default:break e}}e=I[a|0]==40?a:e;d=65;continue}g=(d|0)==67;if(g&(c|0)==1685026146|g&((c|0)==1919246700|(c|0)==1718382433)){break a}if((c&16777215)!=6909556){continue}if(b){break d}d=68;break b}if(!b){break b}a=0;H[f+12>>2]=0;if(d>>>0>66){break c}if(!e){a=4;break c}while(1){c=I[e|0];if(!c){break c}if(c-58>>>0>=4294967286){Ag(e,f+12|0);a=H[f+12>>2]/4|0;break c}else{e=e+1|0;continue}}}d=68;a=0}F[b+6|0]=((a|0)<254?a:254)+1}Ga=f+16|0;return d}d=69;continue}}function MK(a,b){a=a|0;b=b|0;var c=0,d=0;d=1;a:{if(F[b+4|0]&1){break a}b:{c:{d:{e:{f:{c=I[b|0];switch(c-43|0){case 0:case 2:case 6:case 7:case 8:break a;case 3:case 4:break b;case 9:case 10:case 11:case 12:case 13:case 14:break c;case 5:break d;case 1:break e;default:break f}}c=c-157|0;if(c>>>0>20){break b}if(1<<c&1359873){break a}if((c|0)!=10){break b}if(H[a+24>>2]!=H[b+28>>2]){break a}G[a+20>>1]=1;return 2}if(J[a+20>>1]){break a}Kb(a,H[b+12>>2]);if(!J[a+20>>1]){break a}G[a+20>>1]=0;Kb(a,H[b+16>>2]);return 1}return((Kb(a,H[b+12>>2])|0)==2?2:1)|0}a=H[b+16>>2];b=H[b+12>>2];g:{if(I[b|0]!=167){break g}b=H[b+44>>2];if(!b){break g}if(I[b+43|0]==1){break a}}if(I[a|0]!=167){break b}a=H[a+44>>2];if(!a){break b}if(I[a+43|0]==1){break a}}d=0}return d|0}function si(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=H[a+52>>2];b=H[a+56>>2]+I[a+9|0]|0;if(Bv(a,I[b|0])){return ab(68961)}d=H[c+36>>2];F[a+12|0]=0;G[a+26>>1]=d-1;f=H[a+56>>2];e=I[a+10|0];H[a+68>>2]=f+e;H[a+60>>2]=d+f;H[a+64>>2]=(b+e|0)+8;G[a+18>>1]=(e+I[a+9|0]|0)+8;b=I[b+3|0]|I[b+4|0]<<8;b=b<<8|b>>>8;G[a+24>>1]=b;if((d-8>>>0)/6>>>0<(b&65535)>>>0){return ab(68975)}F[a|0]=1;H[a+20>>2]=-1;if(I[H[c+4>>2]+34|0]&32){d=0;b=0;f=H[H[a+52>>2]+40>>2];i=f+(I[a+8|0]?-4:-5)|0;h=J[a+18>>1];j=h+(J[a+24>>1]<<1)|0;e=H[a+56>>2];a:{b:{while(1){if(J[a+24>>1]<=d>>>0){break a}c=e+((d<<1)+h|0)|0;c=I[c|0]<<8|I[c+1|0];g=68924;if(c>>>0<j>>>0|(c|0)>(i|0)){break b}d=d+1|0;if((f|0)>=((Ka[H[a+76>>2]](a,c+e|0)|0)+c|0)){continue}break}g=68929}b=ab(g)}}else{b=0}return b}function ui(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ga-16|0;Ga=g;a:{b:{f=H[b>>2];if(!(H[H[a+228>>2]+12>>2]|!f|(H[a+28>>2]?I[a+15|0]:0)|H[a+168>>2]==(f|0))){H[g+8>>2]=0;H[g+12>>2]=0;c:{if(!I[a+17|0]){break c}d=H[a+64>>2];if(!H[d>>2]){break c}d=Nd(d,g+8|0);if(d){break b}}e=Ij(f+8|0);if(!e){e=0;d=7;break b}d=e+f|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;eh(a);d=iw(H[a+228>>2],f);if(d){break b}Mf(H[a+224>>2]);H[a+224>>2]=e;d=H[g+8>>2];e=H[g+12>>2];H[a+168>>2]=f;H[a+172>>2]=0;h=d;d=d+f|0;e=h>>>0>d>>>0?e+1|0:e;i=a,j=TK(d-1|0,e-!d|0,f,0),H[i+28>>2]=j;H[a+164>>2]=(K[16164]/(f>>>0)|0)+1}H[b>>2]=H[a+168>>2];if((c|0)<0){c=J[a+150>>1]}G[a+150>>1]=c;d=0;break a}Mf(e);H[b>>2]=H[a+168>>2]}Ga=g+16|0;return d}function Sj(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0;a:{if(!(!b|(h?f:0)|((!h|0)==((g|0)!=0|0)|c-128>>>0<4294967167|!i^!j))){if((ib(b)|0)<256){break a}}return kd(172505)}m=d&3672064;b:{c:{d:{e:{f:{d=d&7;switch(d-1|0){case 0:case 1:case 2:break c;case 4:break e;case 3:break f;default:break d}}d=2;break c}l=Sj(a,b,c,m|1,e,f,g,h,i,j,k);if(l){break b}l=Sj(a,b,c,m|2,e,f,g,h,i,j,k);if(l){break b}d=3;break c}d=1}l=0;n=hf(a,b,c,d,0);g:{if(!(!n|(H[n+4>>2]&3)!=(d|0)|F[n|0]!=(c|0))){if(H[a+184>>2]){te(a,5,3742,0);return 5}wg(a,0);break g}if(!(f|h)){break b}}b=hf(a,b,c,d,1);if(!b){return 7}qy(a,b);if(k){H[k>>2]=H[k>>2]+1}H[b+36>>2]=k;H[b+28>>2]=j;H[b+24>>2]=i;H[b+20>>2]=h;H[b+8>>2]=e;F[b|0]=c;H[b+16>>2]=f?f:g;H[b+4>>2]=(H[b+4>>2]&3|m)^2097152}return l}function EK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;e=Ga-16|0;Ga=e;a:{if(!H[b+52>>2]){break a}d=H[b+48>>2];if(!d){break a}c=b;while(1){if(!c){break a}b:{switch(I[c|0]-135|0){case 0:case 3:c=H[c+52>>2];continue;default:break b}}break}if(J[d+20>>1]){break a}f=d+8|0;c=H[d>>2];while(1){if((c|0)<=0){break a}c=c-1|0;if(!(I[H[f+(c<<4)>>2]+5|0]&2)){continue}break}g=2;c=H[a>>2];d=H[c>>2];a=yb(d,76,0);if(!a){break a}H[e+8>>2]=0;H[e+12>>2]=0;f=bf(c,0,0,0,e+8|0,a,0);if(!f){break a}a=Ya(a,b,76);H[b+32>>2]=f;c=sb(c,0,sc(d,180,0));H[b+36>>2]=0;F[b|0]=138;H[b+28>>2]=c;H[a+48>>2]=0;H[a+40>>2]=0;H[a+44>>2]=0;H[b+72>>2]=0;H[b+64>>2]=0;H[b+52>>2]=0;H[b+56>>2]=0;H[b+4>>2]=H[b+4>>2]&-65793|65536;H[H[a+52>>2]+56>>2]=a;H[a+60>>2]=0;g=0}Ga=e+16|0;return g|0}function yC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;a:{d=J[a+20>>1];b:{c:{if(!(!(F[b+4|0]&1)|(d|0)!=2)){break c}d:{e:{f:{g:{h:{e=I[b|0];switch(e-167|0){case 3:case 4:case 6:case 7:case 8:case 10:case 11:break b;case 9:case 12:break c;case 0:case 1:case 2:break e;case 5:break g;default:break h}}if((e|0)==59){break f}if((e|0)==141){break c}if((e|0)==156){break d}break a}c=H[b+4>>2];if(!((c&1048576?0:d>>>0<=3)|c&16777216)){if((d|0)!=5){break a}H[b+4>>2]=c|1073741824;break a}break c}c=1;if(ll(b)){break b}}d=J[a+20>>1];if(I[b+4|0]&32){c=0;if((d|0)==2){break c}break b}if((d|0)!=3){break c}c=0;if(H[b+28>>2]==H[a+24>>2]){break b}break c}i:{switch(d-4|0){case 1:F[b|0]=121;break a;case 0:break i;default:break b}}}G[a+20>>1]=0;c=2}return c|0}return 0}function kq(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;C(+a);b=x(1)|0;x(0)|0;a:{e=b;b:{c:{d:{if(!(((b|0)>0|(b|0)>=0)&b>>>0>1071284857)){if(e>>>0>=3220176896){d=-Z;if(a==-1){break b}return(a-a)/0}if(e<<1>>>0<2034237440){break a}if(e>>>0>=3218259653){break d}d=0;break c}if(e>>>0>2146435071){break a}}c=a+1;C(+c);b=x(1)|0;e=x(0)|0;b=b+614242|0;h=b>>>0<=1129316351?(b>>>0>1074790399?a-c+1:a-(c+-1))/c:0;z(0,e|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;d=+((b>>>20|0)-1023|0)}f=a/(a+2);g=f*f;c=g*g;i=a;a=a*(a*.5);d=d*.6931471803691238+(i+(f*(a+(c*(c*(c*.15313837699209373+.22222198432149784)+.3999999999940942)+g*(c*(c*(c*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(d*1.9082149292705877e-10+h)-a))}return d}return a}function Ox(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;if(a>>>0<=8){return Ue(b)|0}c=16;d=a>>>0>16?a:16;a:{if(!(d-1&d)){a=d;break a}while(1){a=c;c=a<<1;if(a>>>0<d>>>0){continue}break}}if(-64-a>>>0<=b>>>0){H[17665]=48;return 0}d=b>>>0<11?16:b+11&-8;c=Ue((d+a|0)+12|0);if(!c){return 0}b=c-8|0;b:{if(!(c&a-1)){a=b;break b}f=c-4|0;g=H[f>>2];e=a;a=((a+c|0)-1&0-a)-8|0;a=(a-b>>>0>15?0:e)+a|0;c=a-b|0;e=(g&-8)-c|0;if(!(g&3)){b=H[b>>2];H[a+4>>2]=e;H[a>>2]=b+c;break b}H[a+4>>2]=e|H[a+4>>2]&1|2;e=a+e|0;H[e+4>>2]=H[e+4>>2]|1;H[f>>2]=c|H[f>>2]&1|2;e=b+c|0;H[e+4>>2]=H[e+4>>2]|1;pm(b,c)}b=H[a+4>>2];c:{if(!(b&3)){break c}c=b&-8;if(c>>>0<=d+16>>>0){break c}H[a+4>>2]=d|b&1|2;b=a+d|0;d=c-d|0;H[b+4>>2]=d|3;c=a+c|0;H[c+4>>2]=H[c+4>>2]|1;pm(b,d)}return a+8|0}function qk(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;C(+a);b=x(1)|0;d=x(0)|0;a:{b:{c:{d:{if((b|0)>0|(b|0)>=0){f=b;if(b>>>0>1048575){break d}}if(!(b&2147483647|d)){return-1/(a*a)}if((b|0)>0|(b|0)>=0){break c}return(a-a)/0}if(f>>>0>2146435071){break a}b=1072693248;g=-1023;if((f|0)!=1072693248){b=f;break b}if(d){break b}return 0}C(+(a*0x40000000000000));b=x(1)|0;d=x(0)|0;g=-1077}b=b+614242|0;h=+((b>>>20|0)+g|0);e=h*.6931471803691238;z(0,d|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;c=a/(a+2);i=e;j=a;k=c;e=a*(a*.5);c=c*c;a=c*c;a=i+(j+(k*(e+(a*(a*(a*.15313837699209373+.22222198432149784)+.3999999999940942)+c*(a*(a*(a*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+h*1.9082149292705877e-10-e))}return a}function ei(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(Bi(a,32)){F[a+18|0]=0;return 7}j=H[a+8>>2];f=Ga-32|0;Ga=f;a:{if(I[a+16|0]&4){e=H[a>>2];d=H[a+4>>2];n=d;g=Ga-32|0;Ga=g;F[g+21|0]=0;h=d;k=e;e=d>>31;d=e;i=k^d;d=i-d|0;h=(h^e)-((e>>>0>i>>>0)+e|0)|0;e=20;while(1){k=e;i=VK(d,h,10,0);l=Ja;p=e+g|0,q=d-SK(i,l,10,0)|48,F[p|0]=q;e=e-1|0;o=!h&d>>>0>9|(h|0)!=0;d=i;h=l;if(o){continue}break}if((n|0)<0){F[e+g|0]=45;e=k-2|0}Ya(j,(e+g|0)+1|0,21-e|0);Ga=g+32|0;break a}fd(f+8|0,0,j,32,0);d=f;if(I[a+16|0]&32){m=+K[a>>2]+ +H[a+4>>2]*4294967296}else{m=M[a>>3]}M[d>>3]=m;vb(f+8|0,11934,f);F[H[f+24>>2]+j|0]=0}Ga=f+32|0;d=ub(H[a+8>>2]);F[a+18|0]=1;H[a+12>>2]=d&1073741823;d=J[a+16>>1]|514;G[a+16>>1]=c?d&65491:d;be(a,b);return 0}function Mq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Ga-32|0;Ga=f;H[f+28>>2]=0;H[f+24>>2]=0;H[f+20>>2]=0;H[f+12>>2]=0;a:{if(!c){H[e>>2]=0;break a}g=H[a+36>>2];j=H[g>>2];g=Ig(g,b,c,-1,f+8|0);if(g){break a}m=H[j+20>>2];k=H[f+8>>2];b=0;c=0;b:while(1){c:{if(c){break c}c=Ka[m|0](k,f+16|0,f+12|0,f+28|0,f+24|0,f+20|0)|0;if(c){break c}c=1;h=H[f+20>>2];b=(b|0)>(h|0)?b:h+1|0;if((h|0)<0){break c}i=H[f+16>>2];if(!i){break c}l=H[f+12>>2];if((l|0)<=0){break c}g=1;c=vy(a,d,h,H[a+260>>2]+4|0,i,l);while(1){if(H[a+256>>2]<=(g|0)|c){continue b}c=0;h=H[a+260>>2]+N(g,24)|0;i=H[h>>2];if((i|0)<=H[f+12>>2]){c=vy(a,d,H[f+20>>2],h+4|0,H[f+16>>2],i)}g=g+1|0;continue}}break}Ka[H[j+16>>2]](k)|0;H[e>>2]=H[e>>2]+b;g=(c|0)==101?0:c}Ga=f+32|0;return g}function zw(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=Ga-32|0;Ga=c;d=I[a+16|0];a:{if((d|0)<=(b|0)){break a}e=H[a+8>>2];b:{if(d>>>0>=2){c:{if((b|0)!=1){break c}H[c+16>>2]=510;H[c+20>>2]=0;H[c>>2]=0;d=H[16164]+2|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;if(!ih(a,c)){break c}gd(a,H[17665]);g=2314;break a}H[c>>2]=2;H[c+16>>2]=2;H[c+20>>2]=0;d=H[16164];H[c+8>>2]=d;H[c+12>>2]=d>>31;if(ih(a,c)){break b}F[e+28|0]=1}d=a+16|0;if(!b){f=H[e+20>>2]-1|0;H[e+20>>2]=f;if(f){f=1}else{H[c+16>>2]=0;H[c+20>>2]=0;H[c+8>>2]=0;H[c+12>>2]=0;H[c>>2]=2;f=ih(a,c);if(f){gd(a,H[17665]);F[e+28|0]=0;g=2058;h=d}else{h=e+28|0}F[h|0]=0;f=!f}h=e;e=H[e+24>>2]-1|0;H[h+24>>2]=e;if(!e){pw(a)}if(!f){break a}}F[d|0]=b;g=0;break a}gd(a,H[17665]);g=2058}Ga=c+32|0;return g|0}function on(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-32|0;Ga=d;e=I[b|0];a:{if((e|0)!=138){if((e|0)!=167){break a}e=G[b+32>>1];while(1){c=0;b:{while(1){if(!a|c){break b}c=0;h=H[a+4>>2];f=H[h>>2];i=(f|0)>0?f:0;c:{while(1){if((c|0)==(i|0)){break c}f=(c<<6)+h|0;if(H[f+48>>2]!=H[b+28>>2]){c=c+1|0;continue}break}g=H[f+28>>2];c=H[f+24>>2];continue}break}a=H[a+12>>2];continue}break}if(!c){c=0;break a}if(g){c=0;if((e|0)<0){break a}b=H[g+28>>2];if((e|0)>=H[b>>2]){break a}b=H[(b+(e<<4)|0)+8>>2];H[d+4>>2]=H[g+32>>2];H[d+12>>2]=a;H[d>>2]=H[a>>2];c=on(d,b);break a}if((e|0)<0){c=18822;break a}c=_l(H[c+4>>2]+N(e,12)|0,0);break a}b=H[b+20>>2];c=H[H[b+28>>2]+8>>2];H[d+4>>2]=H[b+32>>2];H[d+12>>2]=a;H[d>>2]=H[a>>2];c=on(d,c)}Ga=d+32|0;return c}function Qc(a,b,c,d,e){var f=0,g=0,h=0;h=Ga-16|0;Ga=h;a:{if(!b){Xa(a,94,c,d,e);break a}if(!(G[b+32>>1]!=(d|0)&(d|0)>=0)){Va(a,135,c,e);break a}g=175;f=d;b:{if(I[b+43|0]==1){break b}f=H[b+4>>2]+N(d,12)|0;g=J[f+10>>1];if(g&32){a=H[a+12>>2];if(g&256){H[h>>2]=H[f>>2];Za(a,28256,h);break a}d=H[a+52>>2];G[f+10>>1]=g|256;H[a+52>>2]=c+1;us(a,b,f,e);H[a+52>>2]=d;G[f+10>>1]=J[f+10>>1]&65279;break a}if(I[b+28|0]&128){g=94;f=Cf(tc(b),d<<16>>16);break b}g=94;f=Oc(b,d<<16>>16)}Xa(a,g,c,f,e);c=Ga-16|0;Ga=c;c:{if(I[b+43|0]==2){break c}H[c+12>>2]=0;f=H[a>>2];g=H[b+4>>2]+N(d,12)|0;bm(f,cd(b,g),I[f+84|0],I[g+5|0],c+12|0);f=H[c+12>>2];if(!f){break c}Pc(a,f,-10)}if(!(I[b+43|0]==1|I[(H[b+4>>2]+N(d,12)|0)+5|0]!=69)){db(a,87,e)}Ga=c+16|0}Ga=h+16|0}function aC(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Ga-16|0;Ga=h;g=c+8|0;k=H[a>>2];l=H[H[b+28>>2]>>2];a:{while(1){if(H[c>>2]>(j|0)){i=H[g>>2];e=jd(i);b:{if(!e){break b}c:{if(I[d|0]!=71){f=XB(H[b+28>>2],e);H[h+12>>2]=f;if((f|0)>0){break c}}if(Ng(e,h+12|0)){f=H[h+12>>2];if(f-65536>>>0>4294901760){break c}hs(k,d,j+1|0,l,e);e=1;break a}f=0;G[g+12>>1]=0;e=1;if(ld(a,i)){break a}while(1){e=H[b+28>>2];if(H[e>>2]<=(f|0)){break b}if(!mc(0,i,H[(e+(f<<4)|0)+8>>2],-1)){e=Ga-32|0;Ga=e;if(H[b+68>>2]){H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e>>2]=0;H[e+4>>2]=0;H[e+24>>2]=b;H[e+4>>2]=75;Kb(e,i)}Ga=e+32|0;G[g+12>>1]=f+1}f=f+1|0;continue}}G[g+12>>1]=f}g=g+16|0;j=j+1|0;continue}break}e=gs(k,b,c,d)}Ga=h+16|0;return e}function Ly(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=Ga-16|0;Ga=h;a:{b:{j=H[b+8>>2];if(!j){break b}m=I[a+239|0]?98:99;i=H[b>>2];g=i;while(1){if(!H[H[g>>2]+80>>2]){break b}f=H[i>>2];k=H[f+88>>2];l=H[f+92>>2];g=1;f=Mm(a,f,h+12|0,h+8|0);c:{while(1){if(!((g|0)>=(j|0)|f)){f=H[(g<<2)+i>>2];if(!H[f+80>>2]|(H[f+88>>2]!=(k|0)|H[f+92>>2]!=(l|0))){break c}g=g+1|0;f=Mm(a,f,0,0);continue}break}if(f){break a}}Ki(H[b>>2],j,g,m);g=H[h+8>>2];if(!(!H[H[i>>2]+56>>2]|(g|0)<=0)){f=zz(b,H[h+12>>2],g+1|0);if(f){break a}H[h+12>>2]=H[b+16>>2]}f=H[b+24>>2];if((f|0)>=0){wz(f,1,h+12|0,h+8|0);g=H[h+8>>2]}if((g|0)>0){H[d>>2]=H[h+12>>2];H[c>>2]=k;H[c+4>>2]=l;H[e>>2]=g;f=0;break a}else{g=H[b>>2];continue}}}f=0;H[d>>2]=0}Ga=h+16|0;return f}function On(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;l=H[a+8>>2];o=jb(a);s=I[b+28|0]&128?27:30;if(!j){ob(l,s,d,o,f,g)}if(gj(a,b,0,0)?1:c){p=Fs(a,c,0,0,3,b,i);r=dD(a,b);q=H[a+44>>2];n=q+1|0;H[a+44>>2]=n+G[b+34>>1];Va(l,80,f,n);q=q+2|0;p=p|r;r=(p|0)==-1;while(1){if(G[b+34>>1]>(m|0)){if(!(!r&(!(p>>>m&1)|m>>>0>31))){Qc(l,b,d,m,Oc(b,m<<16>>16)+q|0)}m=m+1|0;continue}break}m=H[l+108>>2];dj(a,c,128,0,1,b,n,i,o);if((m|0)<H[l+108>>2]){ob(l,s,d,o,f,g);k=-1}Ln(a,b,n,0,0,0)}if(I[b+43|0]!=2){Es(a,b,d,e,0,k);Va(l,130,d,(h|0)!=0);a:{if(I[a+18|0]){if(Qb(H[b>>2],22893)){break a}}Pc(l,b,-5)}if(j){pb(l,4)}if(!((d|0)==(k|0)|(k|0)<0)){db(l,130,k)}pb(l,((j|0)==2)<<1)}bD(a,b,0,n,0,0);dj(a,c,128,0,2,b,n,i,o);lb(l,o)}function YI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;b=Ga-288|0;Ga=b;e=Gc(a);d=ac(H[c>>2]);h=cb(H[c+4>>2]);f=ac(H[c+8>>2]);c=H[H[e+16>>2]+(d<<4)>>2];i=H[e+360>>2];H[e+360>>2]=0;c=Fk(b+16|0,c,e,h,(d|0)==1);a:{if(c){break a}b:{c=H[b+252>>2];c:{if(!c){break c}d=G[c+34>>1];if((d|0)==1){break c}if((d|0)>(f|0)){break b}}c=ab(112167);break a}g=N(f,12);d=bd(b+16|0,0,H[g+H[c+4>>2]>>2]);d:{if((f|0)<(G[c+34>>1]-1|0)){f=H[bd(b+16|0,0,H[(g+H[c+4>>2]|0)+12>>2])+4>>2];c=H[d+4>>2];break d}f=H[c+44>>2]+h|0;c=H[d+4>>2];while(1){g=I[c|0];if(!g|(g|0)==44){break d}c=c-1|0;H[d+4>>2]=c;continue}}H[b+8>>2]=f;H[b+4>>2]=h;H[b>>2]=c-h;c=tb(e,5728,b);wb(a,c,-1,-1);Wa(c);c=0}Ek(b+16|0);H[e+360>>2]=i;if(c){ne(a,c)}Ga=b+288|0}function Jt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;while(1){e=I[a|0];if(!(!e|(b|0)<=(g|0))){f=0;while(1){if((e-48&255)>>>0<=9){f=(N(f,10)+(e&255)|0)-48|0;e=I[a+1|0];a=a+1|0;continue}break}h=(g<<1)+c|0,i=je(f,0),G[h>>1]=i;g=g+1|0;a=(I[a|0]==32)+a|0;continue}break}b=(I[d+55|0]|I[d+56|0]<<8)&65467;F[d+55|0]=b;F[d+56|0]=b>>>8;f=I[a|0];a:while(1){if(f&255){b:{if(!Up(24078,a)){b=I[d+55|0]|I[d+56|0]<<8|4;F[d+55|0]=b;F[d+56|0]=b>>>8;break b}if(!Up(24089,a)){b=ef(a+3|0);h=d,i=je((b|0)>2?b:2,0),G[h+48>>1]=i;break b}if(Up(24066,a)){break b}b=I[d+55|0]|I[d+56|0]<<8|64;F[d+55|0]=b;F[d+56|0]=b>>>8}while(1)if((I[a|0]|32)==32){e=a;while(1){f=I[e|0];a=e;e=a+1|0;if((f|0)==32){continue}break}continue a}else{a=a+1|0;continue}}break}}function ng(a){var b=0,c=0;a:{b:{c:{c=F[a+68|0];d:{if((c|0)>=0){b=H[a+116>>2];if(!c){break d}while(1){ji(b);b=I[a+68|0]-1|0;F[a+68|0]=b;if(!(b&255)){break c}b=H[((b<<24>>24<<2)+a|0)+120>>2];continue}}b=H[a+64>>2];if(!b){break a}c=I[a|0];if(c>>>0>=3){if((c|0)==4){return H[a+4>>2]}Gl(a);b=H[a+64>>2]}b=ul(H[H[a+8>>2]+4>>2],b,a+116|0,0,I[a+2|0]);if(b){F[a|0]=1;return b}F[a+68|0]=0;b=H[a+116>>2];F[a+69|0]=I[b+1|0]}if(I[b+1|0]==(!H[a+112>>2]|0)?I[b|0]:0){break b}return ab(72253)}b=H[a+120>>2];H[a+116>>2]=b}G[a+70>>1]=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&241;if(J[b+24>>1]){F[a|0]=0;return 0}if(!I[b+8|0]){if(H[b+4>>2]==1){b=eb((I[b+9|0]+H[b+56>>2]|0)+8|0);F[a|0]=0;return mg(a,b)}return ab(72265)}}F[a|0]=1;return 16}function jG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}d=Nb(H[c>>2]);H[17665]=0;h=a;C(+d);a=x(1)|0;b=x(0)|0;c=a&2147483647;a:{if(c>>>0>=1072693248){e=d*1.5707963267948966+752316384526264e-51;if(!(c-1072693248|b)){break a}e=0/(d-d);break a}b:{if(c>>>0<=1071644671){if(c+-1048576>>>0<1044381696){break b}e=d*nk(d*d)+d;break a}f=(1-P(d))*.5;d=W(f);g=nk(f);c:{if(c>>>0>=1072640819){d=d*g+d;d=1.5707963267948966-(d+d+-6123233995736766e-32);break c}C(+d);b=x(1)|0;x(0)|0;z(0,0);z(1,b|0);e=f;f=+B();e=(e-f*f)/(d+f);d=.7853981633974483-(f+f)-((d+d)*g-(6123233995736766e-32-(e+e)))+.7853981633974483}d=(a|0)<0?-d:d}e=d}Zb(h,e);return}_(22968,17213,379,16977);X()}function Mk(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=H[a>>2];g=zb(h);m=H[H[a+4>>2]+12>>2];i=Db(h);j=Db(h);k=H[h+44>>2]+1|0;H[h+44>>2]=k;l=jb(h);Gk(a,c,i);Gk(a,e,j);e=(b|0)==57?55:(b|0)==54?56:57;a=b;c=I[m+16|0];b=c&1;a=b?e:a;a:{if(!(c&2)){break a}c=db(g,51,i);b:{c:{d:{e:{e=a-54|0;switch(e|0){case 1:break c;case 0:break d;case 3:break e;default:break b}}Va(g,8,0,f);break b}Va(g,51,j,f);break b}Va(g,50,j,f)}Va(g,8,0,l);bb(g,c);Va(g,50,j,f);f:{switch(e|0){case 0:case 3:break f;default:break a}}$i(g,-1,l)}kb(g,117,0,k,0,29357,-1);c=Xa(g,57,k,0,i);if(((b?(a|0)==55:(a|0)==57)|0)==1){Xa(g,a,j,f,i)}Xa(g,b?107:106,d,i,i);bb(g,c);Xa(g,a,j,f,i);Pc(g,Zf(h,H[m+8>>2]),-2);pb(g,128);lb(g,l);xb(h,i);xb(h,j)}function QB(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=Ga-16|0;Ga=g;f=H[a+4>>2];o=Vc(f);h=df(H[a+24>>2]);f=df(f);e=(h|0)<(f|0);k=h>>31;l=SK(h,k,b,0);m=Ja;b=0;if((f|0)!=(h|0)){b=((rr(o)|0)!=0)<<3}p=e?h:f;i=l-h|0;e=m-((h>>>0>l>>>0)+k|0)|0;n=f>>31;while(1){if(!((e|0)>=(m|0)&i>>>0>=l>>>0|(e|0)>(m|0)|b)){b=0;H[g+12>>2]=0;j=TK(i,e,f,n);q=Ja;if((j|0)!=(K[16164]/K[H[H[a+4>>2]+4>>2]+36>>2]|0)){b=sd(o,j+1|0,g+12|0,0);a:{if(b){break a}b=_b(H[g+12>>2]);if(b){break a}j=Ya(H[H[g+12>>2]+4>>2]+(i-SK(f,n,j,q)|0)|0,UK(i,e,h,k)+c|0,p);b=0;F[H[H[g+12>>2]+8>>2]]=0;if(e|i|d){break a}Cb(j+28|0,Kh(H[a+24>>2]))}rd(H[g+12>>2])}e=e+n|0;i=f+i|0;e=i>>>0<f>>>0?e+1|0:e;continue}break}Ga=g+16|0;return b}function mx(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=H[b>>2];f=H[a+12>>2];g=H[f+64>>2];F[a+150|0]=I[a+150|0]&63|64;h=H[a+104>>2];c=(h+N(H[a+108>>2],20)|0)-20|0;while(1){e=c;c=I[c|0];a:{if(c>>>0>64){break a}b:{c:{d:{e:{f:{g:{switch(c|0){case 6:break c;case 7:break d;case 3:case 4:case 5:break e;case 0:case 1:break f;case 2:break g;default:break b}}if(!H[e+8>>2]){break f}F[a+150|0]=I[a+150|0]&191}F[a+150|0]=I[a+150|0]|128;break a}F[a+150|0]=I[a+150|0]&63|128;break a}c=H[e+8>>2];d=(c|0)>(d|0)?c:d;break a}c=H[e-16>>2];d=(c|0)>(d|0)?c:d}c=H[e+8>>2];if((c|0)>=0){break a}H[e+8>>2]=H[((c^-1)<<2)+g>>2]}c=e-20|0;if((e|0)!=(h|0)){continue}break}if(g){$b(H[a>>2],H[f+64>>2]);H[f+64>>2]=0}H[f+56>>2]=0;H[b>>2]=d}function ks(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=Ga-32|0;Ga=f;i=H[a>>2];if(!I[i+87|0]){H[f+24>>2]=0;H[f+28>>2]=0;H[f+16>>2]=0;H[f+20>>2]=0;H[f+8>>2]=0;H[f+12>>2]=0;H[f>>2]=0;H[f+4>>2]=0;H[f+4>>2]=H[c+32>>2];o=H[c+28>>2]+8|0;c=H[b+4>>2];while(1){if(G[b+34>>1]>(j|0)){H[b+28>>2]=H[b+28>>2]|J[c+10>>1]&98;k=H[(j<<4)+o>>2];l=on(f,k);e=Lc(k);F[c+5|0]=e;if(l){e=H[c>>2];h=e;n=ib(l);m=ib(e);g=n+m|0;e=0;e=g>>>0<m>>>0?1:e;g=g+2|0;e=g>>>0<2?e+1|0:e;e=Cj(i,h,g,e);H[c>>2]=e;a:{if(e){Ya((e+m|0)+1|0,l,n+1|0);h=J[c+10>>1]|4;break a}h=J[c+10>>1]&-517}G[c+10>>1]=h;e=F[c+5|0]}if(e<<24>>24<=64){F[c+5|0]=d}e=Sd(a,k);if(e){Xs(i,c,H[e>>2])}c=c+12|0;j=j+1|0;continue}break}G[b+40>>1]=1}Ga=f+32|0}function RD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=(c>>31)+e|0;f=c+d|0;h=f>>>0<d>>>0?h+1|0:h;k=f;f=H[a+20>>2];if((f|0)>=(h|0)&K[a+16>>2]>=k>>>0|(h|0)<(f|0)){a:{if(!(!!(d|e)&((d|0)==H[a+32>>2]&(e|0)==H[a+36>>2]))){g=a+12|0;while(1){g=H[g>>2];if(!g){g=0;break a}f=j;j=H[a+4>>2];f=f+j|0;i=(j>>31)+i|0;i=f>>>0<j>>>0?i+1|0:i;j=f;if((e|0)>=(i|0)&d>>>0>=f>>>0|(e|0)>(i|0)){continue}break}break a}g=H[a+40>>2]}f=d;d=H[a+4>>2];d=UK(f,e,d,d>>31);while(1){b:{f=(d+g|0)+4|0;e=H[a+4>>2]-d|0;d=(c|0)<(e|0)?c:e;b=Ya(b,f,d);c=c-e|0;if((c|0)<0){break b}g=H[g>>2];if(!g){break b}b=b+d|0;d=0;if(c){continue}}break}H[a+40>>2]=g;H[a+32>>2]=g?k:0;H[a+36>>2]=g?h:0;a=0}else{a=522}return a|0}function wu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Ga-256|0;Ga=f;d=a;a:{if(!H[a+12>>2]){a=Al(H[H[d+8>>2]+28>>2]);H[d+12>>2]=a;c=7;if(!a){break a}c=J[H[H[d+8>>2]+28>>2]+6>>1];F[a+23|0]=0;G[a+20>>1]=c}c=0}if(!c){a=H[b>>2];c=I[H[d+8>>2]+60|0];H[d+32>>2]=(c|0)==1?30:(c|0)==2?31:32;i=$a(f,0,256);while(1){if(a){c=H[b+4>>2];b:{if(c){e=0;if((a|0)==(c|0)){break b}e=c+H[a+4>>2]|0;break b}e=H[a+4>>2]}c=0;H[a+4>>2]=0;while(1){g=(c<<2)+i|0;j=H[g>>2];if(j){a=Vt(d,a,j);H[g>>2]=0;c=c+1|0;continue}break}H[g>>2]=a;a=e;continue}else{c=0;while(1){if((h|0)!=64){a=H[(h<<2)+i>>2];c:{if(!a){break c}if(!c){c=a;break c}c=Vt(d,c,a)}h=h+1|0;continue}break}H[b>>2]=c;c=I[H[d+12>>2]+23|0]}break}}Ga=f+256|0;return c}function lD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;b=Ga-80|0;Ga=b;f=H[a>>2];uo(a);c=0;h=(d|0)>0?d:0;d=(I[H[f+16>>2]+5|0]^-1)>>>5&1;a:{b:{while(1){if((c|0)!=(h|0)){g=cb(H[(c<<2)+e>>2]);if(g){H[b+48>>2]=g;g=Hb(8310,b+48|0);H[((d<<2)+a|0)+16>>2]=g;if(!g){break b}}d=d+1|0;c=c+1|0;continue}break}c=b+56|0;fd(c,0,0,0,H[H[f+12>>2]+124>>2]);ke(c,29220);c=H[a+20>>2];if(c){H[b+32>>2]=c;vb(b+56|0,24051,b+32|0)}ke(b+56|0,H[H[f+16>>2]>>2]);c=H[a+16>>2];if(c){H[b+16>>2]=c;vb(b+56|0,18931,b+16|0)}d=Wd(b+56|0);if(!d){break b}c=Rh(H[f+12>>2],d,-1,a+4|0,0);Wa(d);if(c){i=b,j=xg(H[f+12>>2]),H[i>>2]=j;i=f,j=Hb(8310,b),H[i+8>>2]=j;break a}c=Ht(a);break a}c=7}Ga=b+80|0;return c|0}function Bl(a){var b=0,c=0,d=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&241;a:{b:{if(I[a|0]){break b}b=J[a+70>>1];if(!b){break b}if(I[H[a+116>>2]+8|0]){break a}}c=I[a|0];c:{d:{if(!c){break d}if(c>>>0>=3){b=Yj(a);if(b){break c}c=I[a|0]}b=101;e:{switch(c-1|0){case 0:break c;case 1:break e;default:break d}}b=0;F[a|0]=0;if(H[a+4>>2]<0){break c}}b=H[a+116>>2];if(!I[b+8|0]){c=H[b+56>>2];d=J[b+26>>1];b=H[b+64>>2]+(J[a+70>>1]<<1)|0;b=mg(a,eb(c+(d&(I[b|0]<<8|I[b+1|0]))|0));if(b){break c}b=Cu(a);break c}f:{while(1){b=J[a+70>>1];if(b){break f}if(I[a+68|0]){Zo(a);continue}break}F[a|0]=1;b=101;break c}G[a+70>>1]=b-1;b=0;c=H[a+116>>2];if(!I[c+1|0]|I[c+8|0]){break c}b=Bl(a)}return b}G[a+70>>1]=b-1;return 0}function Nt(a,b,c,d,e){var f=0,g=0,h=0,i=0;f=266;a:{if(uf(201)){break a}f=b+44|0;if(H[b+44>>2]){H[f>>2]=0}H[b>>2]=d;H[b+4>>2]=e;d=H[c+12>>2];H[b+8>>2]=H[c+8>>2];H[b+12>>2]=d;H[b+24>>2]=H[c>>2];d=H[H[H[a+8>>2]+24>>2]+168>>2];g=d>>>0<K[c+8>>2];e=H[c+12>>2];d=d>>31;if(!(g&(e|0)>=(d|0)|(d|0)<(e|0)|H[H[H[c>>2]>>2]>>2]<3)){H[f>>2]=0}f=0;if(H[b+44>>2]){break a}d=H[H[a+8>>2]+12>>2];e=d>>31;a=UK(H[b>>2],H[b+4>>2],d,e);c=H[b+36>>2];if(!c){c=xc(d,e);H[b+40>>2]=d;H[b+36>>2]=c;f=c?0:7}if(!a|f){break a}h=H[b+24>>2];i=a+c|0;c=H[b+12>>2];f=H[b+8>>2];e=H[b>>2];g=H[b+4>>2];b=g;a=d-a|0;b=(a>>31)+b|0;d=a+e|0;b=d>>>0<a>>>0?b+1|0:b;f=Jc(h,i,d>>>0>f>>>0&(b|0)>=(c|0)|(b|0)>(c|0)?f-e|0:a,e,g)}return f}function qr(a){var b=0,c=0,d=0,e=0,f=0;if(!I[a+42|0]){a:{if(!I[a+40|0]){H[a+16>>2]=1;H[a+8>>2]=2e3;H[a+12>>2]=1;break a}c=H[a>>2];b=H[a+4>>2];if(!mA(c,b)){lA(a);return}c=c+432e5|0;b=c>>>0<432e5?b+1|0:b;b=TK(c,b,864e5,0);d=(+(b|0)+-1867216.25)/36524.25;b:{if(P(d)<2147483648){c=~~d;break b}c=-2147483648}b=((b+c|0)+((c|0)/-4|0)|0)+1525|0;d=(+(b|0)+-122.1)/365.25;c:{if(P(d)<2147483648){c=~~d;break c}c=-2147483648}b=b-((N(c&32767,36525)>>>0)/100|0)|0;d=+(b|0)/30.6001;d:{if(P(d)<2147483648){e=~~d;break d}e=-2147483648}f=((e|0)<14?-1:-13)+e|0;H[a+12>>2]=f;d=+(e|0)*30.6001;e:{if(P(d)<2147483648){e=~~d;break e}e=-2147483648}H[a+16>>2]=b-e;H[a+8>>2]=c+((f|0)>2?-4716:-4715)}F[a+42|0]=1}}function Ar(a){var b=0,c=0,d=0,e=0,f=0;a:{if(H[a+48>>2]){break a}e=H[a+12>>2];b=H[e+56>>2];f=_b(H[e+72>>2]);if(f){break a}f=0;c=H[8011];d=H[8010];F[b+8|0]=d;F[b+9|0]=d>>>8;F[b+10|0]=d>>>16;F[b+11|0]=d>>>24;F[b+12|0]=c;F[b+13|0]=c>>>8;F[b+14|0]=c>>>16;F[b+15|0]=c>>>24;c=H[8009];d=H[8008];F[b|0]=d;F[b+1|0]=d>>>8;F[b+2|0]=d>>>16;F[b+3|0]=d>>>24;F[b+4|0]=c;F[b+5|0]=c>>>8;F[b+6|0]=c>>>16;F[b+7|0]=c>>>24;F[b+16|0]=H[a+36>>2]>>>8;F[b+17|0]=J[a+38>>1];F[b+18|0]=1;F[b+19|0]=1;c=H[a+40>>2];d=H[a+36>>2];F[b+21|0]=64;F[b+22|0]=32;F[b+23|0]=32;F[b+20|0]=d-c;$a(b+24|0,0,76);li(e,13);G[a+24>>1]=J[a+24>>1]|2;Cb(b+52|0,I[a+17|0]);Cb(b- -64|0,I[a+18|0]);H[a+48>>2]=1;F[b+31|0]=1}return f}function so(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;h=Ga-16|0;Ga=h;e=H[a>>2];a:{b:{if(!c){c=Pf(e,b,d,0);if(!c){break b}}if(H[c+12>>2]){break a}}c:{if(H[e+276>>2]){c=Xb(e,d);if(!c){break c}Ka[H[e+276>>2]](H[e+284>>2],e,b,c);_a(e,c)}if(!H[e+280>>2]){break c}f=Tg(e);xn(f,d,0);c=um(f,2);if(c){Ka[H[e+280>>2]](H[e+284>>2],e,I[e+84|0],c)}id(f)}c=Pf(e,b,d,0);if(c){if(H[c+12>>2]){break a}f=H[c>>2];j=1;d:{while(1){if((i|0)==3){break d}b=i+35556|0;i=i+1|0;g=Pf(e,I[b|0],f,0);if(!H[g+12>>2]){continue}break}b=H[g+4>>2];H[c>>2]=H[g>>2];H[c+4>>2]=b;b=H[g+12>>2];H[c+8>>2]=H[g+8>>2];H[c+12>>2]=b;j=0;H[c+16>>2]=0}if(!j){break a}}H[h>>2]=d;Za(a,7956,h);H[a+12>>2]=257;c=0}Ga=h+16|0;return c}function kG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}e=Nb(H[c>>2]);H[17665]=0;g=a;C(+e);a=x(1)|0;b=x(0)|0;c=a&2147483647;a:{if(c>>>0>=1072693248){f=(a|0)>0|(a|0)>=0?0:3.141592653589793;if(!(c-1072693248|b)){break a}f=0/(e-e);break a}b:{if(c>>>0<=1071644671){f=1.5707963267948966;if(c>>>0<1012924417){break b}f=6123233995736766e-32-e*nk(e*e)-e+1.5707963267948966;break a}if((a|0)<0){d=(e+1)*.5;e=W(d);d=1.5707963267948966-(e+(e*nk(d)+-6123233995736766e-32));f=d+d;break a}d=(1-e)*.5;e=W(d);h=e*nk(d);C(+e);a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);f=d;d=+B();d=h+(f-d*d)/(e+d)+d;f=d+d}}Zb(g,f);return}_(22968,17213,378,16906);X()}function hf(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=ib(b);l=a+412|0;f=Wc(l,b);while(1){if(f){i=Tw(f,c,d);j=(i|0)>(h|0);h=j?i:h;g=j?f:g;f=H[f+12>>2];continue}break}a:{b:{c:{d:{if(e){break d}if(g){f=0;if(!(I[a+24|0]&2)){break c}}h=0;f=Sw((I[I[b|0]+29632|0]+k|0)%23|0,b);while(1){if(!f){break d}i=Tw(f,c,d);j=(i|0)>(h|0);h=j?i:h;g=j?f:g;f=H[f+12>>2];continue}}if(!(!e|(h|0)>5)){e=yb(a,k+41|0,0);if(!e){break b}H[e+4>>2]=d;F[e|0]=c;f=e+40|0;H[e+32>>2]=f;Ya(f,b,k+1|0);while(1){b=I[f|0];if(b){F[f|0]=I[b+29632|0];f=f+1|0;continue}break}b=td(l,H[e+32>>2],e);if((b|0)==(e|0)){_a(a,e);Mb(a);break b}H[e+12>>2]=b;return e}if(!g){break b}f=e}if(f|H[g+16>>2]){break a}}g=0}return g}function CD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;a=Ga-16|0;Ga=a;d=$a(c,0,b);H[17624]=42;c=fi(10837,0,0);a:{if((c|0)>=0){while(1){if((Ka[H[16193]](c,d,b)|0)<0&H[17665]==27){continue}break}og(0,c,42137);break a}f=a+8|0;e=+ca()/1e3;b:{if(P(e)<0x8000000000000000){c=~~e>>>0;b=P(e)>=1?~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0:0;break b}c=0;b=-2147483648}if(f){H[f>>2]=c;H[f+4>>2]=b}b=H[a+12>>2];c=H[a+8>>2];F[d|0]=c;F[d+1|0]=c>>>8;F[d+2|0]=c>>>16;F[d+3|0]=c>>>24;F[d+4|0]=b;F[d+5|0]=b>>>8;F[d+6|0]=b>>>16;F[d+7|0]=b>>>24;b=H[17624];F[d+8|0]=b;F[d+9|0]=b>>>8;F[d+10|0]=b>>>16;F[d+11|0]=b>>>24;b=12}Ga=a+16|0;return b|0}function Eo(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Ga-16|0;Ga=j;a:{if((f|0)<=0){break a}o=e+f|0;i=H[c>>2];k=H[a+56>>2];while(1){f=h;if(H[((h<<2)+g|0)+40>>2]<=(e|0)){h=f+1|0;if(f>>>0<6){continue}}break}l=H[((f<<2)+g|0)+16>>2];while(1){h=J[H[g+12>>2]+(e<<1)>>1];b:{c:{d:{if(I[k+2|0]?1:I[k+1|0]){m=$t(a,h,j+12|0);if(m){break d}}if((h|0)>(i-b|0)){break c}i=i-h|0;m=i}n=H[H[g+8>>2]+(e<<2)>>2];if(n>>>0>=l>>>0|h+n>>>0<=l>>>0){break b}ab(74276)}p=1;break a}h=vd(m,n,h)-k|0;h=h<<8|(h&65280)>>>8;F[d|0]=h;F[d+1|0]=h>>>8;e=e+1|0;if((o|0)>(e|0)){if(H[((f<<2)+g|0)+40>>2]<=(e|0)){f=f+1|0;l=H[((f<<2)+g|0)+16>>2]}d=d+2|0;continue}break}H[c>>2]=i}Ga=j+16|0;return p}function $t(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=H[a+56>>2];h=I[a+9|0];g=h+1|0;d=f+g|0;d=I[d|0]<<8|I[d+1|0];i=H[H[a+52>>2]+40>>2];j=i-b|0;a:{b:{while(1){a=d;if((d|0)>(j|0)){break b}d=a+f|0;k=I[d+2|0]<<8|I[d+3|0];e=k-b|0;if((e|0)>=0){if(e>>>0<=3){a=f+h|0;if(I[a+7|0]>57){break a}b=f+g|0;c=I[d|0]|I[d+1|0]<<8;F[b|0]=c;F[b+1|0]=c>>>8;F[a+7|0]=I[a+7|0]+e;return d}a=a+e|0;if((a|0)>(j|0)){l=c,m=ab(68516),H[l>>2]=m;return 0}b=e<<8|(e&65280)>>>8;F[d+2|0]=b;F[d+3|0]=b>>>8;return a+f|0}g=a;d=I[d+1|0]|I[d|0]<<8;if(d>>>0>a+k>>>0){continue}break}if(!d){break a}l=c,m=ab(68531),H[l>>2]=m;return 0}if((a|0)<=(i-4|0)){break a}l=c,m=ab(68538),H[l>>2]=m}return 0}function TG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=Ga-80|0;Ga=c;f=H[a+12>>2];d=iz(a);H[c+76>>2]=d;if(!d){g=c,h=Im(a),H[g+76>>2]=h}if(!H[a+40>>2]){d=H[a+20>>2];e=H[a+16>>2];H[c+72>>2]=b;H[c+64>>2]=e;H[c+68>>2]=d;We(c+76|0,f,21997,c- -64|0)}if(I[a+238|0]){d=H[a+20>>2];e=H[a+16>>2];H[c+56>>2]=b;H[c+48>>2]=e;H[c+52>>2]=d;We(c+76|0,f,22203,c+48|0)}if(I[a+237|0]){d=H[a+20>>2];e=H[a+16>>2];H[c+40>>2]=b;H[c+32>>2]=e;H[c+36>>2]=d;We(c+76|0,f,22050,c+32|0)}d=H[a+20>>2];e=H[a+16>>2];H[c+24>>2]=b;H[c+16>>2]=e;H[c+20>>2]=d;d=c+76|0;We(d,f,22097,c+16|0);e=H[a+20>>2];a=H[a+16>>2];H[c+8>>2]=b;H[c>>2]=a;H[c+4>>2]=e;We(d,f,22151,c);Ga=c+80|0;return H[c+76>>2]}function zu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;f=H[b+32>>2];h=H[b+28>>2];d=H[a+116>>2];H[g+12>>2]=d;c=H[a+40>>2];e=J[a+48>>1];a:{if(!(K[d+60>>2]>=c+e>>>0&c>>>0>=H[d+56>>2]+J[d+18>>1]>>>0)){c=ab(75789);break a}c=Go(d,c,b,0,e);if(c){break a}c=0;e=J[a+48>>1];f=f+h|0;if((e|0)==(f|0)){break a}h=eb(H[a+40>>2]+e|0);i=H[d+52>>2];d=H[i+40>>2]-4|0;while(1){c=xd(i,h,g+12|0,0);if(c){break a}a=H[g+12>>2];b:{if(!(I[a|0]?0:G[H[a+72>>2]+30>>1]==1)){c=ab(75808);break b}c:{if(f>>>0>d+e>>>0){c=H[a+56>>2];h=eb(c);break c}d=f-e|0;c=H[a+56>>2]}c=Go(a,c+4|0,b,e,d)}rd(H[a+72>>2]);if(c){break a}c=0;e=d+e|0;if((f|0)>(e|0)){continue}break}}Ga=g+16|0;return c}function Dp(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if(I[a+20|0]){b=0}else{e=H[a+12>>2];if(!e){ti(a,18);return H[a+8>>2]+(H[a+16>>2]^-1)|0}g=I[a+21|0]&4?H[a+4>>2]:g;c=b>>31;f=H[a+16>>2];d=b+f|0;c=d>>>0<b>>>0?c+1|0:c;d=d+1|0;c=d?c:c+1|0;h=c;f=d+f|0;c=f>>>0<d>>>0?c+1|0:c;i=d;d=f;j=d;d=e;f=f>>>0>d>>>0&(c|0)>=0|(c|0)>0;e=f?i:j;c=f?h:c;if(e>>>0>d>>>0&(c|0)>=0|(c|0)>0){Nf(a);ti(a,18);return 0}H[a+8>>2]=e;c=0;d=H[a>>2];b:{if(d){c=Kd(d,g,e,c);break b}c=Zd(g,e,c)}if(!c){break a}c:{if(I[a+21|0]&4){break c}e=H[a+16>>2];if(!e){break c}Ya(c,H[a+4>>2],e)}H[a+4>>2]=c;k=a,l=Rf(H[a>>2],c),H[k+8>>2]=l;F[a+21|0]=I[a+21|0]|4}return b}Nf(a);ti(a,7);return 0}function Gq(a,b,c,d,e,f,g,h){var i=0,j=0;i=f+(c>>31)|0;j=c+e|0;i=j>>>0<e>>>0?i+1|0:i;c=e;e=f<<3|c>>>29;f=j;j=c<<3;f=f+j|0;c=e+i|0;c=f>>>0<j>>>0?c+1|0:c;i=f;f=d+f|0;e=c;c=c+(d>>31)|0;c=d>>>0>f>>>0?c+1|0:c;d=i;e=e<<3|d>>>29;i=d<<3;d=i+f|0;f=c+e|0;f=d>>>0<i>>>0?f+1|0:f;c=g+d|0;i=(g>>31)+f|0;i=c>>>0<g>>>0?i+1|0:i;g=c;c=d;e=f<<3|c>>>29;f=c<<3;d=g+f|0;c=e+i|0;c=d>>>0<f>>>0?c+1|0:c;f=d;e=h+f|0;d=c;c=c+(h>>31)|0;c=e>>>0<h>>>0?c+1|0:c;h=e;e=d<<3|f>>>29;g=f<<3;d=h+g|0;f=c+e|0;f=d>>>0<g>>>0?f+1|0:f;e=d;c=0;d=(b|0)>0?b:0;while(1){if((c|0)!=(d|0)){g=F[a+c|0];e=SK(e,f,9,0);b=g+e|0;i=Ja+(g>>31)|0;i=b>>>0<e>>>0?i+1|0:i;e=b;f=i;c=c+1|0;continue}break}Ja=f;return e}function yh(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c=F[a|0];if((c|0)>=0){H[b>>2]=c&255;H[b+4>>2]=0;return 1}d=F[a+1|0];c=c&127|(d&255)<<7;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 2}d=F[a+2|0];c=c&16383|(d&255)<<14;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 3}d=F[a+3|0];c=c&2097151|(d&255)<<21;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 4}l=a+10|0;d=a+4|0;h=c&268435455;f=28;c=0;while(1){a:{if(!c&f>>>0>63|c){d=l;break a}j=F[d|0];i=j&127;e=f&31;if((f&63)>>>0>=32){k=i<<e;e=0}else{k=(1<<e)-1&i>>>32-e;e=i<<e}e=e+h|0;g=g+k|0;g=e>>>0<h>>>0?g+1|0:g;h=e;f=f+7|0;c=f>>>0<7?c+1|0:c;d=d+1|0;if((j|0)<0){continue}}break}H[b>>2]=h;H[b+4>>2]=g;return d-a|0}function oD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;d=Ga-16|0;H[b+40>>2]=0;H[b+44>>2]=1072693248;a:{if(!I[a+20|0]){break a}c=H[b+4>>2];H[d+8>>2]=0;H[d+12>>2]=0;e=H[b>>2];e=(e|0)>0?e:0;while(1){if((e|0)!=(f|0)){b:{if(!I[c+5|0]|I[c+4|0]!=2){break b}g=H[c>>2];h=I[a+21|0];if((g|0)<(h|0)){break b}H[(d+8|0)+(g-h<<2)>>2]=f+1}c=c+12|0;f=f+1|0;continue}break}a=H[d+8>>2];if(!a){H[b+48>>2]=2147483647;H[b+52>>2]=0;H[b+40>>2]=-4194304;H[b+44>>2]=1105199103;break a}c=a<<3;a=H[b+16>>2];c=(c+a|0)-8|0;F[c+4|0]=1;H[c>>2]=1;d=H[d+12>>2];if(!d){break a}H[b+48>>2]=20;H[b+52>>2]=0;H[b+40>>2]=0;H[b+44>>2]=1077149696;a=(a+(d<<3)|0)-8|0;F[a+4|0]=1;H[a>>2]=2}return 0}function Iy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ga-16|0;Ga=g;h=H[e+64>>2];l=H[d>>2];f=H[e+28>>2];H[g+12>>2]=f;H[g+8>>2]=f;j=g+8|0;f=Ga-16|0;Ga=f;H[f+12>>2]=b;i=g+12|0;m=H[i>>2];n=H[c>>2];H[f+8>>2]=b;Hi(f+8|0,a+h|0,0,0,c,i);h=H[f+8>>2];H[f+4>>2]=h;H[f>>2]=h;H[c>>2]=n;H[i>>2]=m;Hi(f+4|0,a+l|0,1,0,i,c);a=H[f+4>>2];a:{b:{if((b|0)!=(h|0)){if((a|0)!=(h|0)){Qy(j,f+12|0,f);break b}Fe(j,f+12|0);break b}if((a|0)==(b|0)){break a}Fe(j,f)}k=1}Ga=f+16|0;if(k){b=H[e+28>>2];a=H[g+8>>2]+(b^-1)|0;c:{if((a|0)<0){break c}f=H[e+32>>2];if((f|0)<(a|0)){break c}$a(a+b|0,0,f-a|0);H[e+32>>2]=a;b=H[e+28>>2]}H[c>>2]=b;H[d>>2]=H[e+64>>2]}Ga=g+16|0;return k}function _g(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;f=H[a+88>>2];f=(b|0)>0?N(H[a+20>>2]-b|0,40)+f|0:f;h=(c<<3)+88|0;g=h+(d?0:200)|0;e=b<<2;i=H[e+H[a+96>>2]>>2];if(i){El(a,i);H[e+H[a+96>>2]>>2]=0}e=H[f+24>>2];a:{if((e|0)>=(g|0)){e=H[f+32>>2];break a}if((e|0)>0){$b(H[f+20>>2],H[f+32>>2])}e=Uc(H[f+20>>2],g,g>>31);H[f+8>>2]=e;H[f+32>>2]=e;if(!e){H[f+24>>2]=0;return 0}H[f+24>>2]=g}H[H[a+96>>2]+(b<<2)>>2]=e;H[e>>2]=0;H[e+4>>2]=0;H[e+24>>2]=0;H[e+28>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e+64>>2]=((c<<2)+e|0)+80;G[e+52>>1]=c;F[e|0]=d;if(!d){a=H[f+8>>2]+h|0;H[e+36>>2]=a;H[a>>2]=0;H[a+4>>2]=0;H[a+16>>2]=0;H[a+8>>2]=0;H[a+12>>2]=0}return e}function qG(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;a:{if(I[a+21|0]){b=H[a+40>>2];d=H[a+12>>2];c=I[(b+N(d,12)|0)+1|0];H[a+4>>2]=H[a+4>>2]+1;d=d+(c>>>6&1)|0;c=d+1|0;H[a+12>>2]=c;if(c>>>0>=K[a+16>>2]){break a}e=a;a=H[H[a+48>>2]+(c<<2)>>2];c=I[b+N(a,12)|0];F[e+20|0]=c;if((c|0)!=6){break a}if((a|0)==(d|0)){H[(b+N(d,12)|0)+8>>2]=0;break a}a=b+N(a,12)|0;H[a+8>>2]=H[a+8>>2]+1;break a}b:{switch(I[a+20|0]-6|0){case 0:b=H[a+12>>2];f=a,g=re(H[a+40>>2]+N(b,12)|0)+b|0,H[f+12>>2]=g;H[a+4>>2]=H[a+4>>2]+1;break a;case 1:b=H[a+12>>2]+1|0;f=a,g=re(H[a+40>>2]+N(b,12)|0)+b|0,H[f+12>>2]=g;H[a+4>>2]=H[a+4>>2]+1;break a;default:break b}}H[a+12>>2]=H[a+16>>2]}return 0}function KD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=F[b|0];e=c&255;a:{if((c|0)>=0){c=b;break a}e=e&127;while(1){f=d+1|0;c=f+b|0;g=F[c|0];e=g&127|e<<7;if((g|0)>=0){break a}g=d>>>0<7;d=f;if(g){continue}break}}d=c+2|0;b:{if(F[c+1|0]>=0){break b}d=c+3|0;if(F[c+2|0]>=0){break b}d=c+4|0;if(F[c+3|0]>=0){break b}d=c+5|0;if(F[c+4|0]>=0){break b}d=c+6|0;if(F[c+5|0]>=0){break b}d=c+7|0;if(F[c+6|0]>=0){break b}d=c+8|0;if(F[c+7|0]>=0){break b}d=(F[c+8|0]<0?10:9)+c|0}f=J[a+14>>1];c:{if(f>>>0>=e>>>0){a=d+(e-b|0)|0;a=a>>>0>4?a:4;break c}c=J[a+16>>1];a=((e-c>>>0)%(H[H[a+52>>2]+40>>2]-4>>>0)|0)+c|0;a=((d-b&65535)+(a>>>0>f>>>0?c:a)|0)+4|0}return a&65535}function yA(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;if(!I[a+6|0]|H[a+104>>2]>=(b|0)){a=c}else{c=H[a+104>>2];h=7;a:{e=Zd(H[a+100>>2],N(b,48),0);if(!e){break a}$a(N(c,48)+e|0,0,N(b-c|0,48));H[a+100>>2]=e;i=(b|0)<(c|0)?c:b;while(1){if((c|0)==(i|0)){h=0;break a}d=N(c,48)+e|0;b=H[a+28>>2];H[d+20>>2]=b;b:{if(H[H[a+68>>2]>>2]){g=H[a+80>>2];f=H[a+84>>2];if(!!g&(f|0)>=0|(f|0)>0){break b}}g=H[a+156>>2];f=0}H[d>>2]=g;H[d+4>>2]=f;H[d+24>>2]=H[a+56>>2];b=Pj(b);H[d+28>>2]=1;H[d+16>>2]=b;if(!b){break a}b=H[a+232>>2];if(b){H[d+32>>2]=H[b+68>>2];H[d+36>>2]=H[b+76>>2];H[d+40>>2]=H[b+80>>2];H[d+44>>2]=H[b+112>>2]}c=c+1|0;H[a+104>>2]=c;continue}}a=h}return a}function Pt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=Ga-16|0;Ga=h;f=H[c>>2];e=H[c+4>>2];l=Bo(b);H[d>>2]=l;i=l?0:7;p=a+40|0;while(1){if(!((b|0)<=(m|0)|i)){H[h+8>>2]=0;H[h+12>>2]=0;j=Ga-16|0;Ga=j;g=H[l+12>>2]+N(m,56)|0;i=Nt(a,g,p,f,e);a:{if(i){break a}H[j+8>>2]=0;H[j+12>>2]=0;i=Mt(g,j+8|0);n=H[j+12>>2];f=n+H[g+4>>2]|0;k=H[j+8>>2];o=H[g>>2];e=k+o|0;H[g+8>>2]=e;H[g+12>>2]=e>>>0<o>>>0?f+1|0:f;f=H[h+12>>2]+n|0;e=k;k=H[h+8>>2];e=e+k|0;H[h+8>>2]=e;H[h+12>>2]=e>>>0<k>>>0?f+1|0:f;if(i){break a}i=Ao(g)}Ga=j+16|0;f=H[g+8>>2];e=H[g+12>>2];m=m+1|0;continue}break}if(i){ah(l);H[d>>2]=0}H[c>>2]=f;H[c+4>>2]=e;Ga=h+16|0;return i}function DD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;d=Ga-80|0;Ga=d;a:{if(!c){break a}b=H[c>>2];if(!b|!H[c+8>>2]){break a}b=Dc(H[a>>2],b,H[a+4>>2]);if(!b){break a}b:{e=H[c+4>>2];if(!e){c=H[c+8>>2];break b}c:{if(!Qb(H[c>>2],e)){a=tc(b);break c}a=Ff(H[a>>2],e,H[a+4>>2])}c=H[c+8>>2];if(!a){break b}e=(I[a+55|0]|I[a+56|0]<<8)&65531;F[a+55|0]=e;F[a+56|0]=e>>>8;Jt(c,J[a+50>>1]+1|0,H[a+8>>2],a);c=I[a+55|0]|I[a+56|0]<<8|128;F[a+55|0]=c;F[a+56|0]=c>>>8;if(H[a+36>>2]){break a}G[b+38>>1]=J[H[a+8>>2]>>1];H[b+28>>2]=H[b+28>>2]|16;break a}G[d+56>>1]=J[b+40>>1];Jt(c,1,b+38|0,d+8|0);G[b+40>>1]=J[d+56>>1];H[b+28>>2]=H[b+28>>2]|16}Ga=d+80|0;return 0}function ar(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ga-16|0;Ga=e;g=H[a+64>>2];a:{if(!H[g>>2]|(I[a+17|0]-4&255)>>>0>252){break a}f=H[a+168>>2];c=Nd(g,e+8|0);g=f;k=g>>31;j=SK(g,k,b,0);d=Ja;h=d;H[e>>2]=j;H[e+4>>2]=d;if(c){break a}c=0;d=H[e+8>>2];i=H[e+12>>2];if((j|0)==(d|0)&(h|0)==(i|0)){break a}b:{c:{if((h|0)<=(i|0)&d>>>0>j>>>0|(h|0)<(i|0)){f=sf(H[a+64>>2],j,h);break c}c=i+k|0;i=d;d=d+g|0;c=i>>>0>d>>>0?c+1|0:c;if(d>>>0>j>>>0&(c|0)>=(h|0)|(c|0)>(h|0)){break b}c=$a(H[a+224>>2],0,f);gh(H[a+64>>2],5,e);d=f;f=H[e>>2];f=Bc(H[a+64>>2],c,d,f-g|0,H[e+4>>2]-(k+(f>>>0<g>>>0)|0)|0)}c=f;if(c){break a}}H[a+36>>2]=b;c=0}Ga=e+16|0;return c}function sy(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;g=Ga-80|0;Ga=g;H[g+24>>2]=0;H[g+16>>2]=0;H[g+20>>2]=0;H[g+12>>2]=0;a:{if((b|0)<=0){h=267;break a}j=I[a|0];pe(c,b,g+12|0);h=H[g+12>>2];if(h){break a}H[c+4>>2]=0;h=Fq(g+32|0,a,b);j=(j|0)!=0;while(1){b:{if(!H[g+32>>2]|h){break b}b=H[g+60>>2];h=H[g+56>>2];c:{if(!H[c+4>>2]){i=uy(h,b,d,e);if((i|0)<0|j&!i){break c}i=H[g+48>>2];k=H[g+52>>2];ry(c,F[a|0],i,k);H[f>>2]=i;H[f+4>>2]=k}h=ty(c,g+16|0,h,b,H[g+68>>2],H[g+72>>2]);if(h){break b}}h=Cm(g+32|0);continue}break}if(!H[c+4>>2]){d=F[a|0];a=H[g+48>>2];b=H[g+52>>2];ry(c,d,a,b);H[f>>2]=a;H[f+4>>2]=b}Eq(g+32|0);Wa(H[g+16>>2])}Ga=g+80|0;return h}function xc(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=Ga-16|0;Ga=e;c=b-(a>>>0<2147483392)|0;b=a-2147483392|0;d=0;a:{if((c|0)==-1&b>>>0<2147483905|(c|0)!=-1){break a}if(H[16e3]){d=Ka[H[16012]](a)|0;hm(5,a);a=H[17527];f=a;b=H[17526];b:{c:{if(!b&(a|0)<=0|(a|0)<0){break c}a=d;c=b-a|0;g=a>>31;b=f-(g+(a>>>0>b>>>0)|0)|0;if((b|0)<=0&c>>>0<=K[17502]|(b|0)<0){c=0;H[17530]=1;b=H[17528];f=H[17529];if(!(b|f)){break c}h=K[17502]<b-a>>>0;a=f-((a>>>0>b>>>0)+g|0)|0;if(h&(a|0)>=0|(a|0)>0){break c}break b}H[17530]=0}c=0;a=Ka[H[16008]](d)|0;if(!a){break b}$j(0,af(a));$j(9,1);c=a}H[e+12>>2]=c;d=H[e+12>>2];break a}d=Ka[H[16008]](a)|0}Ga=e+16|0;return d}function Du(a,b,c,d,e){var f=0;f=H[a+4>>2];if(b>>>0<=1){if(!b){return ab(71407)}b=H[f+48>>2]!=0}H[e+112>>2]=d;F[e+68|0]=255;H[e+64>>2]=b;H[e+20>>2]=f;H[e+8>>2]=a;d=0;F[e+1|0]=0;a=f+8|0;while(1){a=H[a>>2];if(a){if(H[a+64>>2]==(b|0)){F[a+1|0]=I[a+1|0]|32;F[e+1|0]=32;d=32}a=a+24|0;continue}break}F[e|0]=1;H[e+24>>2]=H[f+8>>2];H[f+8>>2]=e;a:{if(c){F[e+2|0]=0;F[e+1|0]=d|1;if(H[f+84>>2]){break a}a=Ij(H[f+36>>2]);H[f+84>>2]=a;b:{if(!a){a=H[f+8>>2];H[f+8>>2]=H[a+24>>2];$a(a,0,200);a=7;break b}F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;H[f+84>>2]=H[f+84>>2]+4;a=0}return a}F[e+2|0]=2}return 0}function GI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{b=Eb(a,16);if(!b){break a}b:{c:{d:{switch(nh(H[c+4>>2])-1|0){case 0:g=ac(H[c+4>>2]);d=Ja;break c;case 1:break d;default:break b}}e=Nb(H[c+4>>2]);e:{if(P(e)<0x8000000000000000){g=~~e>>>0;d=P(e)>=1?~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0:0;break e}d=-2147483648}if(+(g>>>0)+ +(d|0)*4294967296!=e){break b}}if(!g&(d|0)<=0|(d|0)<0){break b}f=H[b+4>>2];h=H[b>>2]+1|0;f=h?f:f+1|0;H[b>>2]=h;H[b+4>>2]=f;if((g|0)!=(h|0)|(d|0)!=(f|0)){break a}d=b;b=hk(H[c>>2]);H[d+8>>2]=b;if(b){break a}ic(a);return}fc(a,8878,-1)}}function sz(a){var b=0,c=0,d=0,e=0;b=H[a>>2];d=H[a+4>>2];F[d+19|0]=0;a:{if(!I[a+8|0]){break a}if(H[b+188>>2]>=2){b:{b=H[a+4>>2];if(H[b+80>>2]!=(a|0)){break b}H[b+80>>2]=0;G[b+24>>1]=J[b+24>>1]&65343;b=b+76|0;while(1){b=H[b>>2];if(!b){break b}F[b+8|0]=1;b=b+12|0;continue}}F[a+8|0]=1;return}b=H[a+4>>2];e=b+76|0;while(1){c=H[e>>2];if(c){if(H[c>>2]!=(a|0)){e=c+12|0;continue}H[e>>2]=H[c+12>>2];if(H[c+4>>2]==1){continue}Wa(c);continue}break}c:{d:{if(H[b+80>>2]==(a|0)){H[b+80>>2]=0;c=65343;break d}c=65407;if(H[b+44>>2]!=2){break c}}G[b+24>>1]=J[b+24>>1]&c}b=H[d+44>>2]-1|0;H[d+44>>2]=b;if(b){break a}F[d+20|0]=0}F[a+8|0]=0;vr(d)}function Pb(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=Ga-48|0;Ga=e;i=(b<<2)+a|0;f=H[i+60>>2];H[e+44>>2]=f;a:{if(f){break a}b:{c:{if((b|0)!=7){if((b|0)!=18){break c}h=H[a+20>>2];b=H[a+16>>2];H[e+24>>2]=H[a+228>>2];H[e+16>>2]=b;H[e+20>>2]=h;g=5;b=Hb(24252,e+16|0);break b}H[e+32>>2]=H[a+224>>2];g=1;b=Hb(20258,e+32|0);break b}h=H[a+20>>2];H[e>>2]=H[a+16>>2];H[e+4>>2]=h;g=5;b=Hb(H[(b<<2)+54208>>2],e)}if(!b){g=7;f=0;break a}g=Sp(H[a+12>>2],b,g,e+44|0);Wa(b);f=H[e+44>>2];H[i+60>>2]=f}d:{if(!d){break d}b=0;h=f?G[f+16>>1]:0;while(1){if((b|0)>=(h|0)|g){break d}a=b+1|0;g=Yp(f,a,H[(b<<2)+d>>2]);b=a;continue}}H[c>>2]=f;Ga=e+48|0;return g}function HJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;e=Ga-32|0;Ga=e;a:{if((b|0)==2){b=H[c+4>>2];if((gb(b)|0)==5){break a}b=ac(b);b=(b|0)<30?b:30;f=(b|0)>0?b:0}b=H[c>>2];if((gb(b)|0)==5){break a}d=Nb(b);M[e+24>>3]=d;b:{if(d<-4503599627370496|d>4503599627370496){break b}if(!f){d=d+(d<0?-.5:.5);c:{if(P(d)<0x8000000000000000){c=P(d)>=1?~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0:0;b=~~d>>>0;break c}c=-2147483648;b=0}d=+(b>>>0)+ +(c|0)*4294967296;break b}M[e+8>>3]=d;H[e>>2]=f;b=Hb(12037,e);if(!b){ic(a);break a}Yd(b,e+24|0,ib(b),1);Wa(b);d=M[e+24>>3]}Zb(a,d)}Ga=e+32|0}function Di(a,b,c){var d=0,e=0,f=0,g=0;a:{b:{d=H[a+24>>2];if(!c|(d|0)<=0){break b}e=H[a+8>>2];if((e|0)!=H[a+32>>2]){break b}c=b>>31;d=H[a+20>>2];c:{if(d){b=Cj(d,e,b,c);H[a+32>>2]=b;break c}b=Zd(e,b,c);H[a+32>>2]=b;if(b){break c}Wa(H[a+8>>2]);b=H[a+32>>2]}H[a+8>>2]=b;c=0;break a}if((d|0)>0){$b(H[a+20>>2],H[a+32>>2])}b=Uc(H[a+20>>2],b,b>>31);H[a+32>>2]=b}if(!b){dc(a);H[a+24>>2]=0;H[a+8>>2]=0;return 7}f=a,g=Rf(H[a+20>>2],b),H[f+24>>2]=g;d:{if(!c){break d}b=H[a+8>>2];if(!b){break d}Ya(H[a+32>>2],b,H[a+12>>2])}b=J[a+16>>1];if(b&4096){Ka[H[a+36>>2]](H[a+8>>2]);b=J[a+16>>1]}G[a+16>>1]=b&36863;H[a+8>>2]=H[a+32>>2];return 0}function Nh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=d-1|0;d=b+8|0;f=I[a+23|0]?e:e&253;m=f&2;n=f&8;o=f&4;f=H[b>>2];h=H[a+8>>2];b=0;i=e&1^81;p=(i|0)!=80;while(1){if((b|0)<(f|0)){e=H[d>>2];a:{b:{if(!o){break b}g=J[d+12>>1];if(!g){break b}if(n){f=f-1|0;b=b-1|0;break a}Va(h,i,g+l|0,b+c|0);break a}c:{if(!m){break c}if(!Bn(e)){break c}An(a,e,b+c|0);break a}g=b+c|0;j=Ke(a,e,g);if((j|0)==(g|0)){break a}d:{if(p){break d}e=Nc(h,-1);if(I[e|0]!=80){break d}k=H[e+12>>2]+1|0;if(J[e+2>>1]|((k+H[e+4>>2]|0)!=(j|0)|(g|0)!=(H[e+8>>2]+k|0))){break d}H[e+12>>2]=k;break a}Va(h,i,j,g)}d=d+16|0;b=b+1|0;continue}break}}function An(a,b,c){var d=0,e=0,f=0;a:{f=H[a+68>>2];if(!f|(c|0)>=0){break a}e=f+8|0;d=H[f>>2];while(1){if((d|0)<=0){break a}b:{if(!(I[e+9|0]&8)){break b}if(mc(0,H[e>>2],b,-1)){break b}return H[e+12>>2]}d=d-1|0;e=e+16|0;continue}}b=nb(H[a>>2],b,0);if(!(!b|!(I[b+4|0]&8))){e=H[a+8>>2];f=Sb(e,14);F[a+23|0]=0;d=H[a>>2];if(!I[d+87|0]){if((c|0)<0){c=H[a+44>>2]+1|0;H[a+44>>2]=c}oc(a,b,c);d=H[a>>2]}F[a+23|0]=1;fb(d,b);bb(e,f);return c}b=sb(a,f,b);if(b){d=b+(H[b>>2]-1<<4)|0;e=d+17|0;f=(I[d+17|0]|I[d+18|0]<<8)&65527|c>>>28&8;F[e|0]=f;F[e+1|0]=f>>>8;if((c|0)<0){c=H[a+44>>2]+1|0;H[a+44>>2]=c}H[d+20>>2]=c}H[a+68>>2]=b;return c}function fB(a,b,c,d,e,f){var g=0;g=I[e|0];if(!((g|0)!=177|f-54>>>0>3)){e=H[H[e+20>>2]+8>>2];g=I[e|0]}if((g&255)==167){H[d>>2]=H[e+28>>2];H[d+4>>2]=G[e+32>>1];return 1}if(!(b|c)|(b-1&b|c-!b&c)){a=0}else{a:{f=0;while(1){if(!c&b>>>0>=2|c){g=c;c=c>>>1|0;b=(g&1)<<31|b>>>1;f=f+1|0;continue}break}a=(f<<6)+a|0;f=H[a+24>>2]+8|0;b=H[a+48>>2];while(1){a=0;c=H[f>>2];if(!c){break a}b:{if(!H[c+40>>2]){break b}f=0;while(1){if(J[c+50>>1]<=f>>>0){break b}c:{if(J[H[c+4>>2]+(f<<1)>>1]!=65534){break c}if(dn(e,H[(H[c+40>>2]+(f<<4)|0)+8>>2],b)){break c}H[d+4>>2]=-2;H[d>>2]=b;a=1;break a}f=f+1|0;continue}}f=c+20|0;continue}}}return a}function Un(a,b,c,d){var e=0,f=0,g=0,h=0;f=Ga-16|0;Ga=f;a:{e=H[b>>2];g=e+c|0;if(g>>>0>K[b+4>>2]){b:{c:{if((g|0)>=200){H[f>>2]=200;Za(a,16771,f);break c}h=H[a>>2];g=b;a=e;e=a>>31<<1|a>>>31;b=a<<1;a=b+c|0;e=e+(c>>31)|0;e=a>>>0<b>>>0?e+1|0:e;b=a>>>0<200&(e|0)<=0|(e|0)<0;a=b?a:200;b=Kd(h,g,a<<6|8,(b?e:0)<<6|a>>>26);if(b){break b}}b=0;break a}H[b+4>>2]=a;e=H[b>>2]}a=b+8|0;while(1){if((d|0)<(e|0)){e=e-1|0;Ya(a+(e+c<<6)|0,a+(e<<6)|0,64);continue}break}H[b>>2]=H[b>>2]+c;$a(((d<<6)+b|0)+8|0,0,c<<6);a=c+d|0;a=(a|0)<(d|0)?d:a;while(1){if((a|0)==(d|0)){break a}H[((d<<6)+b|0)+48>>2]=-1;d=d+1|0;continue}}Ga=f+16|0;return b}function lg(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=J[a+24>>1];k=I[a+10|0];f=I[a+9|0];g=H[a+56>>2];b=f+g|0;c=(I[b+5|0]<<8|I[b+6|0])-1&65535;d=(c+I[b+7|0]|0)+1|0;e=H[H[a+52>>2]+40>>2];a:{b:{b=I[b+2|0]|I[b+1|0]<<8;if(!b){break b}if(b>>>0<=c>>>0){break a}l=e-4|0;while(1){if((b|0)>(l|0)){return ab(68867)}c=b+g|0;h=I[c+2|0]<<8|I[c+3|0];i=b+h|0;d=d+h|0;b=I[c+1|0]|I[c|0]<<8;if(b>>>0>i+3>>>0){continue}break}if(b){return ab(68877)}if(e>>>0>=i>>>0){break b}return ab(68881)}c:{if((d|0)<=(e|0)){b=((k+f|0)+(j<<1)|0)+8|0;if((b|0)<=(d|0)){break c}}return ab(68893)}H[a+20>>2]=d-b&65535;return 0}return ab(68862)}function UA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=Zc(H[H[e>>2]+12>>2]);h=J[c+52>>1]-d|0;h=(g|0)<(h|0)?g:h;h=(h|0)>1?h:1;g=1;a:{while(1){if((g|0)==(h|0)){break a}f=H[e>>2];i=H[f+16>>2];k=i+20|0;l=g<<4;j=H[(l+H[H[f+12>>2]+20>>2]|0)+8>>2];k=I[i+5|0]&16?H[i+20>>2]+28|0:k;b:{if(I[j|0]!=167|H[j+28>>2]!=(b|0)){break b}i=d+g|0;if(J[j+32>>1]!=J[H[c+4>>2]+(i<<1)>>1]){break b}f=H[c+28>>2];if(I[f+i|0]!=I[d+f|0]){break b}f=H[(H[k>>2]+l|0)+8>>2];if((Qg(f,Lc(j))|0)!=(Uk(H[c+12>>2],G[j+32>>1])|0)){break b}f=vg(a,j,f);if(!f){break b}if(hb(H[f>>2],H[H[c+32>>2]+(i<<2)>>2])){break b}g=g+1|0;continue}break}h=g}return h}function fz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=Ga-32|0;Ga=e;H[e+16>>2]=b;H[e+28>>2]=0;f=7;g=Hb(8310,e+16|0);a:{if(!g){break a}h=ub(g);b=Uq(g,e+28|0);b=b?b:g;i=H[e+28>>2];F[b+i|0]=0;Ni(b);f=1;k=Km(a,b,ub(b)+1|0);b:{if(k){f=g+h|0;c:{while(1){d:{h=l;a=(b+i|0)+1|0;if(a>>>0>=f>>>0){break d}b=Uq(a,e+28|0);if(!b){break d}a=l+1|0;m=a?m:m+1|0;l=a;a=ye(j,a<<2&-4,0);if(!a){break c}H[a+(h<<2)>>2]=b;i=H[e+28>>2];F[i+b|0]=0;Ni(b);j=a;continue}break}f=Ka[H[k+4>>2]](h,j,c)|0;e:{if(f){de(d,8609,0);break e}H[H[c>>2]>>2]=k}Wa(j);break b}Wa(g);Wa(j);f=7;break a}H[e>>2]=b;de(d,7228,e)}Wa(g)}Ga=e+32|0;return f}function FA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=H[b+40>>2];i=H[a>>2];g=H[a+8>>2];j=Cr(b,d);a:{if(!d|(e|0)==(h|0)){break a}if(!(I[c+28|0]&128)){d=Db(a);Va(g,142,e,d);Xa(g,29,h,0,d);xb(a,d);break a}f=H[a+44>>2];l=tc(c);k=J[l+50>>1];H[a+44>>2]=f+k;m=f+1|0;f=0;while(1){if((f|0)!=(k|0)){Xa(g,94,e,Cf(d,G[H[l+4>>2]+(f<<1)>>1]),f+m|0);f=f+1|0;continue}break}d=ob(g,28,h,0,m,k);kb(g,70,11,2,0,12820,-1);Rc(a);bb(g,d)}f=0;d=aj(i,H[b+32>>2],0);while(1){if(G[c+34>>1]>(f|0)){if(I[(H[c+4>>2]+N(f,12)|0)+5|0]==69){db(g,87,H[b+36>>2]+f|0)}f=f+1|0;continue}break}ko(a,d,rc(i,H[j+8>>2],0),nb(i,H[j+12>>2],0),2,j)}function Ez(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0;a:{if(!(c|d)){l=267;if(e|f){break a}m=j+20|0}l=Ub(m+96|0);if(!l){return 7}l=$a(l,0,96);H[l+24>>2]=g;H[l+28>>2]=h;H[l+16>>2]=e;H[l+20>>2]=f;H[l+8>>2]=c;H[l+12>>2]=d;F[l+4|0]=(b|0)!=0;H[l>>2]=a;b:{if(m){H[l+44>>2]=j;F[l+5|0]=1;a=l+96|0;H[l+40>>2]=a;if(j){Ya(a,i,j)}a=a+j|0;F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;F[a+16|0]=0;F[a+17|0]=0;F[a+18|0]=0;F[a+19|0]=0;F[a+8|0]=0;F[a+9|0]=0;F[a+10|0]=0;F[a+11|0]=0;F[a+12|0]=0;F[a+13|0]=0;F[a+14|0]=0;F[a+15|0]=0;break b}H[l+32>>2]=c-1;H[l+36>>2]=d-!c}H[k>>2]=l;l=0}return l}function vD(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=I[e|0]+e|0;l=I[c|0]+c|0;a:{j=I[c+1|0];h=I[e+1|0];b:{c:{if((j|0)==(h|0)){j=I[j+33108|0];while(1){if((g|0)==(j|0)){break b}h=g+k|0;i=g+l|0;g=g+1|0;i=I[i|0]-I[h|0]|0;if(!i){continue}break}g=F[l|0];if((g^I[k|0])<<24>>24>=0){break c}g=g>>31|1;break a}i=j-h|0;if(h>>>0>7&j>>>0>=8){break c}g=1;i=j>>>0>7?-1:i;h=h>>>0>7?1:i;if((h|0)>0){i=F[l|0]>=0?h:-1;break c}if(F[k|0]<0){break a}}g=i;if(g){break a}}if(J[H[H[a+8>>2]+28>>2]+6>>1]>=2){a=Tt(a,b,c,d,e,f)}else{a=0}return a|0}return(I[H[H[H[a+8>>2]+28>>2]+16>>2]]?0-g|0:g)|0}function es(a,b,c,d){var e=0,f=0,g=0;e=Ac(a,167,0,0);if(e){f=(c<<6)+b|0;a=H[f+24>>2];H[e+44>>2]=a;H[e+28>>2]=H[f+48>>2];if(G[a+32>>1]==(d|0)){G[e+32>>1]=65535;return e}G[e+32>>1]=d;if(!(!(I[a+28|0]&96)|!(I[(H[a+4>>2]+N(d,12)|0)+10|0]&96))){a=G[a+34>>1];d=a;f=(c<<6)+b|0;b=a>>31;a=a&31;if((d&63)>>>0>=32){c=-1<<a;g=0}else{c=(1<<a)-1&-1>>>32-a;a=-1<<a;c=c|a;g=a}a=d>>>0>63&(b|0)>=0|(b|0)>0;H[f+56>>2]=a?-1:g^-1;H[f+60>>2]=a?-1:c^-1;return e}b=(c<<6)+b|0;a=b+56|0;f=H[b+60>>2];g=H[b+56>>2];c=(d|0)<63?d:63;b=c&31;if((c&63)>>>0>=32){c=1<<b;d=0}else{d=1<<b;c=d-1&1>>>32-b}H[a>>2]=g|d;H[a+4>>2]=c|f}return e}function ev(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;c=Ga-32|0;Ga=c;F[b|0]=0;e=Ga-112|0;Ga=e;d=70396;while(1){a:{b:{d=H[d>>2];c:{d:{if(!d){break d}if(Ka[H[16181]](d,e)|(H[e+12>>2]&61440)!=16384){break d}if(!(Ka[H[16175]](d,3)|0)){break c}}if((f|0)!=6){break b}d=0}Ga=e+112|0;break a}d=(f<<2)+65024|0;f=f+1|0;continue}break}e:{if(!d){g=6410;break e}e=(a+b|0)-2|0;while(1){Oe(8,c+24|0);F[e|0]=0;H[c+16>>2]=0;H[c>>2]=d;f=H[c+28>>2];H[c+8>>2]=H[c+24>>2];H[c+12>>2]=f;f=Vd(a,b,17274,c);i=h>>>0>10;j=I[e|0];g=j?1:i?1:g;if(i|j){break e}h=h+1|0;if(!(Ka[H[16175]](f,0)|0)){continue}break}}Ga=c+32|0;return g}function Vo(a,b,c){var d=0,e=0;d=Ga-16|0;Ga=d;a:{b=J[c+18>>1]+b|0;if(b>>>0>K[a+60>>2]){c=ab(73583);break a}b=eb(b-4|0);e=H[a+52>>2];a=H[e+40>>2]-4|0;a=((a+H[c+12>>2]|0)+(J[c+16>>1]^-1)>>>0)/(a>>>0)|0;while(1){if(!a){c=0;break a}H[d+12>>2]=0;H[d+8>>2]=0;if(!(b>>>0>=2&K[e+48>>2]>=b>>>0)){c=ab(73600);break a}b:{c:{d:{a=a-1|0;if(a){c=lv(e,b,d+8|0,d+12|0);if(c){break a}c=H[d+8>>2];if(c){break d}}c=bu(e,b);H[d+8>>2]=c;if(c){break d}c=0;break c}if(G[H[c+72>>2]+30>>1]==1){break c}c=ab(73620);break b}c=au(e,c,b)}b=H[d+8>>2];if(b){rd(H[b+72>>2])}if(c){break a}b=H[d+12>>2];continue}}Ga=d+16|0;return c}function Pu(a,b){var c=0,d=0,e=0,f=0,g=0;f=Ga-16|0;Ga=f;c=H[(H[a+16>>2]+(b<<4)|0)+12>>2];d=c+16|0;while(1){d=H[d>>2];if(d){e=H[d+8>>2];H[e+28>>2]=H[e+28>>2]&-17;continue}break}d=c+32|0;c=d;while(1){c=H[c>>2];if(c){e=H[c+8>>2];g=(I[e+55|0]|I[e+56|0]<<8)&65407;F[e+55|0]=g;F[e+56|0]=g>>>8;continue}break}H[f+8>>2]=a;c=H[H[a+16>>2]+(b<<4)>>2];H[f+12>>2]=c;b=0;e=Dc(a,22893,c);a:{if(!e|I[e+43|0]){break a}H[f>>2]=c;c=tb(a,22865,f);if(!c){b=7;break a}b=Re(a,c,26,f+8|0,0);_a(a,c)}while(1){d=H[d>>2];if(d){c=H[d+8>>2];if(I[c+55|0]&128){continue}ru(c);continue}break}if((b|0)==7){Mb(a)}Ga=f+16|0;return b}function xD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;f=Ga-16|0;Ga=f;d=F[b+1|0];H[f+12>>2]=d;e=b+1|0;a:{b:{while(1){if((d|0)<=11){if((d|0)>=0){break b}$d(e,f+12|0);d=H[f+12>>2];if((d|0)>11){continue}break b}break}c:{if(!(d&1)){break c}d=d-12>>>1|0;e=I[b|0];if((d+e|0)<=(a|0)){g=b+e|0;e=H[c+16>>2];g=Ob(g,H[c+8>>2],(d|0)>(e|0)?e:d);if((g|0)>0){break c}if((g|0)<0){break b}if((d|0)==(e|0)){if(J[c+20>>1]>=2){a=_h(a,b,c,1);break a}F[c+26|0]=1;a=F[c+22|0];break a}if((d|0)<=(e|0)){break b}break c}h=c,i=ab(85553),F[h+23|0]=i;a=0;break a}a=F[c+25|0];break a}a=F[c+24|0]}Ga=f+16|0;return a|0}function BF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{if((b|0)==2){b:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break b}}Wb(a);return}e=cb(H[c>>2]);h=cb(H[c+4>>2]);f=Ub(ub(e)+1|0);if(!f){break a}g=f;while(1){c=h;b=Ve(e);if(b){while(1){d=Ve(c);if(!(!d|(b|0)==(d|0))){while(1){d=I[c+1|0];c=c+1|0;if((d&192)==128){continue}break}continue}break}b=c;if(d){while(1){d=I[b+1|0];b=b+1|0;if((d&192)==128){continue}break}b=b-c|0;g=Tx(g,c,b)+b|0}while(1){b=I[e+1|0];e=e+1|0;if((b&192)==128){continue}break}continue}break}F[g|0]=0;wb(a,f,-1,-1);Wa(f);return}_(22830,17213,939,16935);X()}ic(a)}function tv(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{if(I[a+4|0]){c=sv(a);if(c){break a}c=I[a+4|0]}else{c=0}f=H[a>>2];g=H[a+64>>2];h=H[a+236>>2];e=H[a+176>>2];i=H[a+180>>2];d=Ga-16|0;Ga=d;H[a+232>>2]=0;b=Ad(H[f+4>>2]+120|0,0);b:{if(!b){c=7;break b}H[b>>2]=f;G[b+40>>1]=65535;H[b+4>>2]=g;H[b+108>>2]=h;H[b+16>>2]=e;H[b+20>>2]=i;G[b+48>>1]=257;e=b+120|0;H[b+8>>2]=e;F[b+43|0]=((c|0)!=0)<<1;H[d+12>>2]=524294;c=ff(f,h,e,524294,d+12|0);if(!c){if(F[d+12|0]&1){F[b+46|0]=1}c=fh(g);if(c&1024){F[b+48|0]=0}if(c&4096){F[b+49|0]=0}H[a+232>>2]=b;c=0;break b}rp(b,0);$c(H[b+8>>2]);Wa(b)}Ga=d+16|0}return c}function aK(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;f=Ga-144|0;Ga=f;e=cb(H[c>>2]);c=0;g=Gc(a);b=H[g+20>>2];d=(b|0)>0?b:0;i=e?e:29357;a:{b:{while(1){if((c|0)==(d|0)){d=7648;break b}c:{e=H[g+16>>2];b=e+(c<<4)|0;h=H[b+4>>2];if(h){if(rl(g,c,i)){break c}}c=c+1|0;continue}break}d=6369;if(c>>>0<2){break b}d=15284;if(Pg(h)){break b}if(DA(h)){break b}d=e+(c<<4)|0;c=H[e+28>>2]+48|0;while(1){c=H[c>>2];if(c){a=H[c+8>>2];if(H[a+24>>2]!=H[d+12>>2]){continue}H[a+24>>2]=H[a+20>>2];continue}break}Gg(h);H[b+4>>2]=0;H[d+12>>2]=0;pr(g);break a}H[f>>2]=i;fc(a,Vd(128,f+16|0,d,f),-1)}Ga=f+144|0}function en(a,b){var c=0,d=0,e=0,f=0;c=H[b+4>>2];if(!(c&32|I[b|0]!=167)){a=Ye(a,H[b+28>>2]);return a}if(!(c&8454144)){if(I[b|0]==179){d=Ye(a,H[b+28>>2]);e=Ja}c=H[b+12>>2];if(c){d=en(a,c)|d;e=e|Ja}c=H[b+16>>2];a:{if(c){d=en(a,c)|d;e=e|Ja;break a}c=H[b+4>>2];if(c&4096){if(c&64){H[a>>2]=1}d=Nr(a,H[b+20>>2])|d;e=e|Ja;break a}c=H[b+20>>2];if(!c){break a}d=xf(a,c)|d;e=e|Ja}b:{c:{switch(I[b|0]-168|0){case 0:case 4:break c;default:break b}}if(!(F[b+7|0]&1)){break b}c=xf(a,H[H[b+44>>2]+8>>2]);f=Ja;c=xf(a,H[H[b+44>>2]+12>>2])|c;f=Ja|f;d=d|(wf(a,H[H[b+44>>2]+40>>2])|c);e=e|(Ja|f)}}Ja=e;return d}function MI(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{c=Eb(a,24);if(!c){break a}e=H[c+8>>2];b=H[c+12>>2];if(!e&(b|0)<=0|(b|0)<0){break a}j=a;d=H[c>>2];a=H[c+4>>2];i=TK(d,a,e,b);b:{if(!i){a=H[c+20>>2];b=H[c+16>>2]+1|0;a=b?a:a+1|0;break b}g=H[c+16>>2];h=H[c+20>>2];c=a;f=b;a=i;b=a>>31;k=b;f=SK(e,f,a,b);b=c-(Ja+(d>>>0<f>>>0)|0)|0;c=d-f|0;d=b;a=a+1|0;b=a>>31;e=a;a=SK(c,d,a,b);f=Ja;if(a>>>0>g>>>0&(f|0)>=(h|0)|(f|0)>(h|0)){b=TK(g,h,e,b)+1|0;a=Ja;a=b?a:a+1|0;break b}e=TK(g-a|0,h-((a>>>0>g>>>0)+f|0)|0,i,k);a=e+c|0;b=Ja+d|0;d=a+1|0;a=a>>>0<e>>>0?b+1|0:b;a=d?a:a+1|0;b=d}ec(j,b,a)}}function Gy(a,b,c){var d=0,e=0,f=0;d=Ga-16|0;Ga=d;e=c;a:{b:{if(H[a+40>>2]){c=19;a=H[((H[a+24>>2]<<2)+b|0)+12>>2];if((gb(a)|0)==5){a=H[b+4>>2]}if((gb(a)|0)!=1){break a}c=0;a=ac(a);b=Ja;break b}c=Pb(a,18,d+12|0,b+4|0);if(c){break a}if(H[a+44>>2]){c=H[a+24>>2];c=wc(H[d+12>>2],c+2|0,ac(H[((c<<2)+b|0)+16>>2]));if(c){break a}}f=H[((H[a+24>>2]<<2)+b|0)+12>>2];c:{if((gb(f)|0)==5){b=H[d+12>>2];break c}if((gb(H[b>>2])|0)==5){c=1;if((gb(H[b+4>>2])|0)!=5){break a}}b=H[d+12>>2];c=Yp(b,1,f);if(c){break a}}Ab(b);c=rb(b);b=H[a+12>>2];a=H[b+40>>2];b=H[b+44>>2]}H[e>>2]=a;H[e+4>>2]=b}Ga=d+16|0;return c}function nq(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0;i=1;j=d&2147483647;l=j;k=(j|0)==2147418112;a:{if(k&!c?a|b:k&(c|0)!=0|j>>>0>2147418112){break a}j=h&2147483647;k=(j|0)==2147418112;if(k&!g?e|f:k&(g|0)!=0|j>>>0>2147418112){break a}if(!(a|e|(c|g)|(b|f|(j|l)))){return 0}i=d&h;if((i|0)>0|(i|0)>=0){i=-1;if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0<e>>>0|b>>>0<f>>>0:c>>>0<g>>>0&(d|0)<=(h|0)|(d|0)<(h|0)){break a}return(a^e|c^g|(b^f|d^h))!=0}i=-1;if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0>e>>>0|b>>>0>f>>>0:c>>>0>g>>>0&(d|0)>=(h|0)|(d|0)>(h|0)){break a}i=(a^e|c^g|(b^f|d^h))!=0}return i}function mC(a,b,c){var d=0,e=0,f=0,g=0;a:{if(!c){break a}d=yb(a,100,0);if(!d){break a}f=d,g=Xb(a,H[c>>2]),H[f>>2]=g;f=d,g=Xb(a,H[c+4>>2]),H[f+4>>2]=g;f=d,g=nb(a,H[c+40>>2],0),H[f+40>>2]=g;H[d+44>>2]=H[c+44>>2];f=d,g=rc(a,H[c+8>>2],0),H[f+8>>2]=g;f=d,g=rc(a,H[c+12>>2],0),H[f+12>>2]=g;F[d+16|0]=I[c+16|0];F[d+18|0]=I[c+18|0];F[d+17|0]=I[c+17|0];F[d+20|0]=I[c+20|0];H[d+56>>2]=H[c+56>>2];H[d+52>>2]=H[c+52>>2];H[d+80>>2]=H[c+80>>2];H[d+48>>2]=H[c+48>>2];F[d+96|0]=I[c+96|0];f=d,g=nb(a,H[c+24>>2],0),H[f+24>>2]=g;a=nb(a,H[c+28>>2],0);H[d+72>>2]=b;H[d+28>>2]=a;F[d+19|0]=I[c+19|0];e=d}return e}function Vg(a,b,c){var d=0,e=0,f=0,g=0;if(F[b+30|0]&1){if(!c){Pc(a,b,-5);b=Nc(a,-1);F[b|0]=95;Xa(a,97,H[b+4>>2],H[b+8>>2],H[b+12>>2]);return}Va(a,95,c,G[b+36>>1]);Pc(a,b,-5);return}a:{d=H[b+12>>2];if(d){break a}g=H[a>>2];d=G[b+34>>1];e=d+1|0;d=d>>31;d=Uc(0,e,e?d:d+1|0);if(d){e=0;while(1)if(G[b+34>>1]<=(e|0)){while(1){b:{F[d+f|0]=0;if((f|0)<=0){break b}f=f-1|0;if(F[f+d|0]<66){continue}}break}H[b+12>>2]=d;break a}else{g=H[b+4>>2]+N(e,12)|0;if(!(I[g+10|0]&32)){F[d+f|0]=I[g+5|0];f=f+1|0}e=e+1|0;continue}}Mb(g);return}b=ub(d)&1073741823;if(b){if(c){kb(a,96,c,b,0,d,b);return}le(a,-1,d,b)}}function pr(a){var b=0,c=0,d=0,e=0,f=0;c=2;d=2;while(1){if((d|0)<H[a+20>>2]){e=H[a+16>>2];b=e+(d<<4)|0;a:{if(!H[b+4>>2]){_a(a,H[b>>2]);H[b>>2]=0;break a}if((c|0)<(d|0)){f=H[b+4>>2];e=e+(c<<4)|0;H[e>>2]=H[b>>2];H[e+4>>2]=f;f=H[b+12>>2];H[e+8>>2]=H[b+8>>2];H[e+12>>2]=f}c=c+1|0}d=d+1|0;continue}break}H[a+20>>2]=c;b:{if((c|0)>2){break b}c=H[a+16>>2];b=a+456|0;if((c|0)==(b|0)){break b}d=H[c+4>>2];H[b>>2]=H[c>>2];H[b+4>>2]=d;d=H[c+28>>2];H[b+24>>2]=H[c+24>>2];H[b+28>>2]=d;d=H[c+20>>2];H[b+16>>2]=H[c+16>>2];H[b+20>>2]=d;d=H[c+12>>2];H[b+8>>2]=H[c+8>>2];H[b+12>>2]=d;_a(a,c);H[a+16>>2]=b}}function Gf(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;if(!c&b>>>0<=127){F[a|0]=b;return 1}if(!c&b>>>0<=16383){F[a+1|0]=b&127;F[a|0]=b>>>7|128;return 2}g=a;f=Ga-16|0;a:{if(c>>>0<16777216){e=1;while(1){d=h;F[d+(f+6|0)|0]=b|128;a=e;e=a+1|0;h=d+1|0;i=!c&b>>>0>127|(c|0)!=0;j=c;c=c>>>7|0;b=(j&127)<<25|b>>>7;if(i){continue}break}F[f+6|0]=I[f+6|0]&127;e=0;while(1){if((a|0)==(e|0)){break a}F[e+g|0]=I[(f+6|0)+d|0];e=e+1|0;d=d-1|0;continue}}F[g+8|0]=b;a=c;c=a>>>8|0;b=(a&255)<<24|b>>>8;d=7;while(1){if((d|0)>=0){F[d+g|0]=b|128;d=d-1|0;a=c;c=a>>>7|0;b=(a&127)<<25|b>>>7;continue}break}h=9}return h}function Bu(a){var b=0,c=0,d=0;c=H[a>>2];b=a;a=H[a+116>>2];if(a){hi(a,J[b+144>>1]<<1);$b(c,H[b+116>>2])}a=H[b+228>>2];while(1){if(a){d=H[a+24>>2];jv(c,H[a>>2],H[a+4>>2]);_a(c,a);a=d;continue}break}a:{if(!I[b+149|0]){break a}hi(H[b+100>>2],G[b+16>>1]);a=H[b+128>>2];if(a){$b(c,a)}a=H[b+208>>2];if(!a){break a}$b(c,a)}jv(c,H[b+104>>2],H[b+108>>2]);_a(c,H[b+196>>2]);_a(c,H[b+200>>2]);a=H[b+204>>2];while(1){if(a){d=H[a>>2];_a(c,a);a=d;continue}break}b:{if(H[c+528>>2]){break b}a=H[b+8>>2];d=H[b+4>>2];c:{if(d){H[d+8>>2]=a;a=H[b+8>>2];break c}H[c+4>>2]=a}if(!a){break b}H[a+4>>2]=d}$b(c,b)}function cu(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;a=Ga-16|0;Ga=a;f=+ca();d=f/1e3;a:{if(P(d)<0x8000000000000000){e=P(d)>=1?~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0:0;c=~~d>>>0;break a}e=-2147483648;c=0}H[a>>2]=c;H[a+4>>2]=e;d=(f-(+(SK(c,e,1e3,0)>>>0)+ +(Ja|0)*4294967296))*1e3;b:{if(P(d)<2147483648){c=~~d;break b}c=-2147483648}H[a+8>>2]=c;c=H[a+8>>2]/1e3|0;g=SK(H[a>>2],H[a+4>>2],1e3,0);e=c+g|0;c=Ja+(c>>31)|0;c=e>>>0<g>>>0?c+1|0:c;e=e+1045635584|0;c=c+49096|0;H[b>>2]=e;H[b+4>>2]=e>>>0<1045635584?c+1|0:c;Ga=a+16|0;return 0}function Yk(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0;if(I[b+43|0]==1){H[h>>2]=-999;H[g>>2]=-999;return 0}j=Lb(H[a>>2],H[b+60>>2]);e=(e|0)<0?H[a+40>>2]:e;k=H[a+8>>2];if(g){H[g>>2]=e}a:{if(!(I[b+28|0]&128|(I[f|0]?0:f))){fe(a,e,j,b,c);break a}Dd(a,j,H[b+20>>2],(c|0)==113,H[b>>2])}i=e+1|0;if(h){H[h>>2]=i}e=b+8|0;h=0;while(1){e=H[e>>2];if(e){b:{if(((I[e+55|0]|I[e+56|0]<<8)&3)!=2){break b}l=H[b+28>>2]&128;d=l?0:d;if(!g|!l){break b}H[g>>2]=i;d=0}h=h+1|0;if(!(I[h+f|0]?0:f)){Xa(k,c,i,H[e+44>>2],j);Od(a,e);pb(k,d&255)}i=i+1|0;e=e+20|0;continue}break}if(H[a+40>>2]<(i|0)){H[a+40>>2]=i}return h}function My(a,b,c){var d=0,e=0,f=0,g=0,h=0;e=Ga-16|0;Ga=e;f=H[b>>2];a:{b:{d=H[b+8>>2];c:{if(!d){d=f;if(!d){break c}}g=f+H[b+4>>2]|0;if(g>>>0>d>>>0){break b}}F[c|0]=1;break a}h=qd(d,e)+d|0;H[e+12>>2]=h;d:{if(!(H[b+8>>2]?I[a+239|0]:0)){d=H[b+20>>2]+H[e+4>>2]|0;a=H[e>>2];f=a+H[b+16>>2]|0;H[b+16>>2]=f;H[b+20>>2]=a>>>0>f>>>0?d+1|0:d;break d}d=H[b+16>>2];f=H[e>>2];a=H[b+20>>2]-(H[e+4>>2]+(d>>>0<f>>>0)|0)|0;H[b+16>>2]=d-f;H[b+20>>2]=a}H[b+28>>2]=h;Fe(0,e+12|0);d=H[e+12>>2];H[b+32>>2]=d-H[b+28>>2];while(1){if(!(I[d|0]|d>>>0>=g>>>0)){d=d+1|0;continue}break}H[b+8>>2]=d;F[c|0]=0}Ga=e+16|0}function DF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{if((b|0)==2){if((gb(H[c>>2])|0)==5){Wb(a);return}h=cb(H[c>>2]);c=ac(H[c+4>>2]);b=Ja;g=b;if((b|0)<0){fc(a,8512,-1);return}b=sq(h);e=b>>31;d=e;b:{if((g|0)<=(d|0)&b>>>0>=c>>>0|(d|0)>(g|0)){b=wm(h);if(!b){break a}wb(a,b,-1,-1);break b}f=ub(h);d=Ub((f+(c-b|0)|0)+1|0);if(!d){break a}e=g-(e+(b>>>0>c>>>0)|0)|0;g=(c-b|0)+1|0;e=g?e:e+1|0;b=sh(d,h);c=f+b|0;f=1;d=0;while(1){if((g|0)!=(f|0)|(d|0)!=(e|0)){F[c|0]=32;f=f+1|0;d=f?d:d+1|0;c=c+1|0;continue}break}F[c|0]=0}wb(a,b,-1,-1);Wa(b);return}_(22830,17213,825,16960);X()}ic(a)}function Fi(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0;k=-1;i=d&2147483647;l=i;j=(i|0)==2147418112;a:{if(j&!c?a|b:j&(c|0)!=0|i>>>0>2147418112){break a}i=h&2147483647;j=(i|0)==2147418112;if(j&!g?e|f:j&(g|0)!=0|i>>>0>2147418112){break a}if(!(a|e|(c|g)|(b|f|(i|l)))){return 0}i=d&h;if((i|0)>0|(i|0)>=0){if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0<e>>>0|b>>>0<f>>>0:c>>>0<g>>>0&(d|0)<=(h|0)|(d|0)<(h|0)){break a}return(a^e|c^g|(b^f|d^h))!=0}if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0>e>>>0|b>>>0>f>>>0:c>>>0>g>>>0&(d|0)>=(h|0)|(d|0)>(h|0)){break a}k=(a^e|c^g|(b^f|d^h))!=0}return k}function WA(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;while(1){a:{c=H[a>>2];if(!c){break a}b:{if(I[c+16|0]!=I[b+16|0]|I[c+17|0]!=I[b+17|0]){break b}if(!(J[b+46>>1]|!(I[c+41|0]&64)|(H[b+40>>2]&513)!=513)){d=H[b>>2];e=(d&H[c>>2])==(d|0);d=H[b+4>>2];if(e&(d&H[c+4>>2])==(d|0)){break a}}d=H[b>>2];e=H[c>>2];f=d&e;i=(f|0)!=(e|0);e=H[b+4>>2];g=H[c+4>>2];h=e&g;if(!(i|(h|0)!=(g|0)|G[c+18>>1]>G[b+18>>1]|(G[c+20>>1]>G[b+20>>1]|G[c+22>>1]>G[b+22>>1]))){a=0;break a}if((d|0)!=(f|0)|(e|0)!=(h|0)|G[c+20>>1]<G[b+20>>1]){break b}if(G[c+22>>1]>=G[b+22>>1]){break a}}a=c+56|0;continue}break}return a}function _E(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;if(f&4095|g&-4096){H[17665]=28;return-1}if(b>>>0>=2147483647){H[17665]=48;return-1}f=(g&4095)<<20|f>>>12;a:{if(a){e=-28}else{h=f<<12;b:{if(d&32){f=Ox(65536,b+40|0);e=-48;if(!f){break a}$a(f,0,b);g=b+f|0;H[g>>2]=f;H[g+8>>2]=1;H[g+12>>2]=-1;break b}g=Ue(40);f=ua(b|0,c|0,d|0,e|0,h|0,g+8|0)|0;if((f|0)<0){Te(g);e=f;break a}H[g+12>>2]=e;H[g>>2]=f}H[g+32>>2]=c;H[g+16>>2]=d;H[g+4>>2]=b;H[g+24>>2]=h;H[g+28>>2]=0;H[g+36>>2]=H[17682];H[17682]=g;e=H[g>>2]}}return yc(a?e:(e|0)!=-63?e:d&32?d&16?-63:-48:-63)|0}function rc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{if(!b){break a}f=Rf(a,b);f=Tb(a,f,f>>31);if(!f){break a}H[f>>2]=H[b>>2];H[f+4>>2]=H[b+4>>2];g=b+8|0;e=f+8|0;while(1){if(H[b>>2]<=(k|0)){a=f}else{h=H[g>>2];i=nb(a,h,c);H[e>>2]=i;if(!(!h|(!i|I[h|0]!=178))){d=H[i+16>>2];b:{if(d){l=H[h+16>>2];j=d;break b}d=H[h+12>>2];if((d|0)==(l|0)){break b}j=nb(a,d,c);H[i+16>>2]=j;l=d}H[i+12>>2]=j}m=e,n=Xb(a,H[g+4>>2]),H[m+4>>2]=n;d=H[g+8>>2];H[e+8>>2]=d;d=d>>>8&65531;F[e+9|0]=d;F[e+10|0]=d>>>8;H[e+12>>2]=H[g+12>>2];g=g+16|0;e=e+16|0;k=k+1|0;continue}break}e=a}return e}function hn(a,b,c,d,e,f){var g=0,h=0,i=0;F[a+24|0]=0;H[a+4>>2]=b;H[a>>2]=b;H[a+20>>2]=e;H[a+8>>2]=0;H[a+12>>2]=0;H[a+28>>2]=c;H[a+16>>2]=0;F[a+25|0]=1;F[a+26|0]=1;a:{b:{if(f){b=-1;e=J[H[f+4>>2]+(d<<1)>>1];c=H[f+12>>2];if((e|0)==J[c+32>>1]){break b}b=e<<16>>16;if((b|0)>=0){F[a+24|0]=I[(H[c+4>>2]+N(b,12)|0)+5|0];H[a+8>>2]=H[H[f+32>>2]+(d<<2)>>2];break b}if((b|0)!=-2){break b}H[a+12>>2]=H[(H[f+40>>2]+(d<<4)|0)+8>>2];b=H[H[f+32>>2]+(d<<2)>>2];G[a+72>>1]=65534;H[a+8>>2]=b;h=a,i=Lc(H[a+12>>2]),F[h+24|0]=i;return Wi(a)}b=d;if((b|0)==-2){break a}}G[a+72>>1]=b;g=Wi(a)}return g}function ZA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;i=J[a>>1];h=i;k=a+8|0;f=k;a:{b:{while(1){if(h&65535){g=G[f+8>>1];if((b|0)==(b&H[f>>2])&(c&H[f+4>>2])==(c|0)&(g|0)>=(d|0)){break b}if((d|0)>=(g|0)){g=H[f>>2];j=(b&g)==(g|0);g=H[f+4>>2];if(j&(c&g)==(g|0)){break a}}f=f+16|0;h=h-1|0;continue}break}if(i>>>0>2){h=1;f=k;while(1){j=G[f+8>>1];if((h|0)!=(i|0)){g=h<<4;f=G[(a+g|0)+16>>1]<(j|0)?g+k|0:f;h=h+1|0;continue}break}if((d|0)>=(j|0)){break a}break b}G[a>>1]=i+1;a=(i<<4)+a|0;G[a+18>>1]=e;f=a+8|0}G[f+8>>1]=d;H[f>>2]=b;H[f+4>>2]=c;if(G[f+10>>1]<=(e|0)){break a}G[f+10>>1]=e}}function yl(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;if(!H[d>>2]){e=H[a+64>>2]+(b<<1)|0;f=I[e|0]<<8|I[e+1|0];if(K[H[a+52>>2]+40>>2]<f+c>>>0){i=d,j=ab(73879),H[i>>2]=j;return}g=I[a+9|0];h=H[a+56>>2];c=Fo(a,f,c&65535);if(c){H[d>>2]=c;return}c=J[a+24>>1]-1|0;G[a+24>>1]=c;if(!(c&65535)){b=g+h|0;F[b+7|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=H[H[a+52>>2]+40>>2]>>>8;F[b+6|0]=H[H[a+52>>2]+40>>2];H[a+20>>2]=(H[H[a+52>>2]+40>>2]-(I[a+9|0]+I[a+10|0]|0)|0)-8;return}vd(e,e+2|0,(c&65535)-b<<1);b=g+h|0;F[b+3|0]=I[a+25|0];F[b+4|0]=I[a+24|0];H[a+20>>2]=H[a+20>>2]+2}}function tG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-16|0;H[d+8>>2]=-1;H[d+12>>2]=-1;a=H[b>>2];i=(a|0)>0?a:0;a=H[b+4>>2];while(1){if((c|0)!=(i|0)){e=H[a>>2];a:{if((e|0)<8){break a}f=e-8|0;e=1<<f;if(!I[a+5|0]){g=e|g;break a}if(I[a+4|0]!=2){break a}H[(d+8|0)+(f<<2)>>2]=c;h=e|h}a=a+12|0;c=c+1|0;continue}break}a=19;if(!((h^-1)&g)){a=0;e=H[d+8>>2];c=0;b:{if((e|0)<0){break b}H[b+40>>2]=0;H[b+44>>2]=1072693248;c=e<<3;e=H[b+16>>2];c=c+e|0;F[c+4|0]=1;H[c>>2]=1;d=H[d+12>>2];c=1;if((d|0)<0){break b}d=e+(d<<3)|0;F[d+4|0]=1;H[d>>2]=2;c=3}H[b+20>>2]=c}return a|0}function sF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;a:{b:{if(!(H[d+48>>2]|H[d+52>>2])){f=H[d+32>>2];e=H[d+36>>2];if((f|0)==(b|0)&(e|0)==(c|0)){break a}if((c|0)<=(e|0)&b>>>0<=f>>>0|(c|0)<(e|0)){break b}a=H[a>>2];H[d+40>>2]=1;H[d+44>>2]=0;H[d+32>>2]=b;H[d+36>>2]=c;H[d>>2]=a;H[d+4>>2]=a>>31;return}f=H[d+32>>2];e=H[d+36>>2];if((f|0)==(b|0)&(e|0)==(c|0)){break a}if((c|0)<=(e|0)&b>>>0<=f>>>0|(c|0)<(e|0)){break b}g=M[a>>3];H[d+40>>2]=1;H[d+44>>2]=0;H[d+32>>2]=b;H[d+36>>2]=c;M[d+8>>3]=g}return}a=H[d+44>>2];b=H[d+40>>2]+1|0;a=b?a:a+1|0;H[d+40>>2]=b;H[d+44>>2]=a}function EF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{if((b|0)==2){if((gb(H[c>>2])|0)==5){Wb(a);return}h=cb(H[c>>2]);d=ac(H[c+4>>2]);b=Ja;g=b;if((b|0)<0){fc(a,8512,-1);return}c=sq(h);e=c>>31;b=e;b:{if((g|0)<=(b|0)&c>>>0>=d>>>0|(b|0)>(g|0)){b=wm(h);if(!b){break a}wb(a,b,-1,-1);break b}b=Ub((ub(h)+(d-c|0)|0)+1|0);if(!b){break a}e=g-(e+(c>>>0>d>>>0)|0)|0;f=(d-c|0)+1|0;e=f?e:e+1|0;g=f;f=1;d=0;c=b;while(1){if((f|0)!=(g|0)|(d|0)!=(e|0)){F[c|0]=32;f=f+1|0;d=f?d:d+1|0;c=c+1|0;continue}break}sh(c,h)}wb(a,b,-1,-1);Wa(b);return}_(22830,17213,771,17013);X()}ic(a)}function Ol(a,b,c){var d=0,e=0,f=0;a:{if(H[a+24>>2]>(b|0)){d=H[H[a+32>>2]+(b<<2)>>2];H[c>>2]=d;e=0;if(d){break a}}e=c;b:{if(H[a+24>>2]<=(b|0)){c=b+1|0;d=Zd(H[a+32>>2],c<<2,0);if(!d){c=7;a=0;break b}f=H[a+24>>2];$a(d+(f<<2)|0,0,c-f<<2);H[a+24>>2]=c;H[a+32>>2]=d}c:{if(I[a+43|0]==2){c=Ad(32768,0);d=b<<2;H[d+H[a+32>>2]>>2]=c;c=H[d+H[a+32>>2]>>2]?0:7;break c}c=Pv(H[a+4>>2],b,I[a+44|0],H[a+32>>2]+(b<<2)|0);if(!c){if((b|0)<=0){c=0;break c}c=uf(600)?7:0;break c}if((c&255)!=8){break c}F[a+46|0]=I[a+46|0]|2;c=(c|0)==8?0:c}a=H[H[a+32>>2]+(b<<2)>>2]}H[e>>2]=a;e=c}return e}function yr(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Ga-48|0;Ga=f;m=H[a>>2];i=zb(a);if(i){l=H[m+16>>2]+(b<<4)|0;while(1){if((h|0)!=3){g=(f+33|0)+h|0;F[g|0]=0;j=H[(h<<3)+49440>>2];k=Dc(m,j,H[l>>2]);a:{if(!k){if(h){break a}k=H[l>>2];H[f+8>>2]=3280;H[f+4>>2]=j;H[f>>2]=k;nc(a,24195,f);H[f+36>>2]=H[a+92>>2];F[g|0]=16;break a}g=H[k+20>>2];H[(f+36|0)+(h<<2)>>2]=g;Dd(a,b,g,1,j);if(d){g=H[l>>2];H[f+28>>2]=d;H[f+24>>2]=e;H[f+20>>2]=j;H[f+16>>2]=g;nc(a,18841,f+16|0);break a}Va(i,145,g,b)}h=h+1|0;continue}break}ob(i,113,c,H[f+36>>2],b,3);pb(i,I[f+33|0])}Ga=f+48|0}function ym(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;while(1){if(!(H[c>>2]|!b)){d=H[b+20>>2];if(d){Ji(d);if(H[d+40>>2]){h=0;while(1){if(H[d+64>>2]>(h|0)){g=H[(N(h,24)+d|0)+92>>2];if(g){H[g+28>>2]=1;H[g+8>>2]=0;e=H[g+4>>2];i=(e|0)>0?e:0;e=0;while(1){if((e|0)!=(i|0)){f=H[g>>2]+(e<<2)|0;H[H[f>>2]+80>>2]=0;f=H[f>>2];H[f+88>>2]=0;H[f+92>>2]=0;H[f+84>>2]=0;e=e+1|0;continue}break}}h=h+1|0;continue}break}j=c,k=Ty(a,0,d),H[j>>2]=k}H[d+48>>2]=0;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=0}G[b+32>>1]=0;H[b+24>>2]=0;H[b+28>>2]=0;ym(a,H[b+12>>2],c);b=H[b+16>>2];continue}break}}function Uq(a,b){var c=0,d=0,e=0,f=0,g=0;while(1){e=F[a|0];c=0;a:{b:while(1){if(c){break a}c:{d:{e:{if((e|0)==34|(e|0)==39){break e}c=a;if((e|0)==91){break d}if((e|0)==96){break e}if(e){break c}return 0}c=a;while(1){d=c;c=d+1|0;f=I[d+1|0];if(!f){continue b}g=e&255;if((f|0)!=(g|0)){continue}c=d+2|0;if(I[d+2|0]==(g|0)){continue}break}continue}while(1){f:{d=c;c=d+1|0;f=I[d+1|0];if((f|0)==93){break f}if(f){continue}}break}c=f?d+2|0:c;continue}if(Vq(e)){while(1){d=F[c+1|0];c=c+1|0;if(Vq(d)){continue}continue b}}break}a=a+1|0;continue}break}H[b>>2]=c-a;return a}function dD(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;a:{if(I[b+43|0]|!(I[H[a>>2]+33|0]&64)){break a}c=b+48|0;while(1){e=H[c>>2];if(e){c=0;f=H[e+20>>2];f=(f|0)>0?f:0;while(1){if((c|0)!=(f|0)){h=d;d=H[(e+(c<<3)|0)+36>>2];d=h|((d|0)>31?-1:1<<d);c=c+1|0;continue}break}c=e+4|0;continue}break}e=Jh(b);while(1){if(!e){break a}H[g+12>>2]=0;bj(a,b,e,g+12|0,0);b:{f=H[g+12>>2];if(!f){break b}i=J[f+50>>1];c=0;while(1){if((c|0)==(i|0)){break b}h=d;d=J[H[f+4>>2]+(c<<1)>>1];d=h|(d<<16>>16>31?-1:1<<d);c=c+1|0;continue}}e=H[e+12>>2];continue}}Ga=g+16|0;return d}function $e(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=Ga-32|0;Ga=d;a:{if(b){f=H[a>>2];H[d+24>>2]=a;H[d+12>>2]=0;H[d+8>>2]=56;H[d+4>>2]=55;H[d>>2]=f;e=H[a+24>>2];c=e&-134254609;H[a+24>>2]=c;g=e&134254608;while(1){if(H[b>>2]>(h|0)){e=H[((h<<4)+b|0)+8>>2];if(e){c=H[f+216>>2]+H[e+24>>2]|0;H[f+216>>2]=c;i=2;if(dl(f,c)){break a}Kb(d,e);f=H[d>>2];H[f+216>>2]=H[f+216>>2]-H[e+24>>2];c=H[a+24>>2];j=c&134254608;if(j){H[e+4>>2]=H[e+4>>2]|c&32784;c=c&-134254609;H[a+24>>2]=c;g=g|j}if(H[f+36>>2]>0){break a}}h=h+1|0;continue}break}H[a+24>>2]=c|g}i=0}Ga=d+32|0;return i}function DE(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;g=a;h=b;a=c;while(1){a:{Xx(H[g+12>>2],d,e);if((Ja|0)<0){gd(g,H[17665]);a=-1;break a}b:{f=Ka[H[16193]](H[g+12>>2],h,a)|0;c:{if((f|0)==(a|0)){f=a;break c}if((f|0)<0){j=H[17665];if((j|0)==27){continue}gd(g,j);i=0;break c}if(f){break b}f=0}a=f+i|0;break a}h=f+h|0;i=f+i|0;a=a-f|0;d=d+f|0;e=f>>>0>d>>>0?e+1|0:e;continue}break}d=0;d:{if((a|0)==(c|0)){break d}if((a|0)<0){a=H[g+20>>2];d=8458;if((a|0)==29|(a|0)==60|(a|0)==68){break d}return 266}gd(g,0);$a(a+b|0,0,c-a|0);d=522}return d|0}function DH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=Ub(16);if(!d){return 7}H[d>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d+4>>2]=1;while(1){if(!((a|0)<=(h|0)|e)){e=H[(h<<2)+b>>2];g=ub(e);a:{b:{if((g|0)==19){if(!Ob(22915,e,19)){H[d+4>>2]=1;f=0;break a}if(!Ob(23524,e,19)){H[d+4>>2]=0;f=0;break a}if(Ob(22752,e,19)){break b}H[d+4>>2]=2;f=0;break a}f=1;if((g|0)<11){break a}}if(!Ob(21052,e,11)){f=Nz(d,1,e+11|0,g-11|0);break a}f=1;if(Ob(21040,e,11)){break a}f=Nz(d,0,e+11|0,g-11|0)}e=f;h=h+1|0;continue}break}if(e){Mz(d);d=0}H[c>>2]=d;return e|0}function ak(a,b){var c=0,d=0,e=0,f=0;e=Ga-16|0;Ga=e;c=Yd(H[a+8>>2],e+8|0,H[a+12>>2],I[a+18|0]);if((c|0)>0){d=M[e+8>>3];a:{b:{if((c|0)!=1){break b}c:{if(P(d)<0x8000000000000000){f=P(d)>=1?~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0:0;c=~~d>>>0;break c}f=-2147483648;c=0}d:{if(fu(d,c,f)){H[a>>2]=c;H[a+4>>2]=f;c=1;break d}c=!jh(H[a+8>>2],a,H[a+12>>2],I[a+18|0])}if(!c){break b}c=J[a+16>>1]|4;break a}M[a>>3]=d;c=J[a+16>>1]|8;G[a+16>>1]=c;if(!b){break a}rx(a);c=J[a+16>>1]}G[a+16>>1]=c&65533}Ga=e+16|0}
function ZJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;b=nf(H[c>>2]);c=ac(H[c+4>>2]);a:{if(H[b+8>>2]){e=(c|0)>0?c:0;while(1)if((d|0)==(e|0)){while(1){if(H[b+16>>2]<=(c|0)){break a}d=c<<2;e=d+H[b+32>>2]|0;H[e>>2]=H[e>>2]+1;H[d+H[b+28>>2]>>2]=1;c=c+1|0;continue}}else{f=H[b+28>>2]+(d<<2)|0;H[f>>2]=H[f>>2]+1;d=d+1|0;continue}}c=0;while(1){if(H[b+16>>2]<=(c|0)){break a}H[H[b+28>>2]+(c<<2)>>2]=1;c=c+1|0;continue}}c=H[b+8>>2]+1|0;H[b+8>>2]=c;d=H[b+12>>2];b:{if(!d){break b}e=I[b+24|0];if(c>>>0<=N(d,e+1|0)>>>0){break b}F[b+24|0]=e+1;Hc(a,H[H[b+32>>2]>>2]!=0)}}function oz(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=Ga-16|0;Ga=b;d=Gc(a);H[b>>2]=-1;H[b+12>>2]=0;H[b+4>>2]=b+12;e=Ga-16|0;Ga=e;H[e+12>>2]=b;a:{while(1){if((f|0)==16){break a}if(H[(f<<3)+31424>>2]!=1004){f=f+1|0;continue}break}c=H[e+12>>2];H[e+12>>2]=c+4;g=H[c>>2];H[e+12>>2]=c+8;h=H[d+32>>2];a=H[d+36>>2];c=H[c+4>>2];b:{if((g|0)>0){g=H[(f<<3)+31428>>2]|h}else{if(g){break b}g=(H[(f<<3)+31428>>2]^-1)&h}H[d+32>>2]=g;H[d+36>>2]=a;if((g|0)==(h|0)){break b}wg(d,0)}if(!c){break a}H[c>>2]=(H[d+32>>2]&H[(f<<3)+31428>>2])!=0}Ga=e+16|0;Ga=b+16|0;return H[b+12>>2]}function JJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;e=b<<2|1;e=Ib(e,e>>31);if(e){h=(b|0)>0?b:0;b=e;while(1){if((f|0)!=(h|0)){d=ac(H[(f<<2)+c>>2]);g=Ja;d=!g&d>>>0>1114111|g?65533:d&2097151;a:{if(d>>>0<=127){F[b|0]=d;b=b+1|0;break a}if(d>>>0<=2047){F[b+1|0]=d&63|128;F[b|0]=d>>>6|192;b=b+2|0;break a}if(d>>>0<=65535){F[b+2|0]=d&63|128;F[b|0]=d>>>12|224;F[b+1|0]=d>>>6&63|128;b=b+3|0;break a}F[b+3|0]=d&63|128;F[b|0]=d>>>18|240;F[b+2|0]=d>>>6&63|128;F[b+1|0]=d>>>12&63|128;b=b+4|0}f=f+1|0;continue}break}c=a;a=b-e|0;$p(c,e,a,a>>31,3);return}ic(a)}function Zd(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;if(!a){return xc(b,c)}if(!(b|c)){Wa(a);return 0}a:{if(!c&b>>>0>2147483391|c){break a}f=af(a);e=Ka[H[16012]](b)|0;if((f|0)==(e|0)){return a}if(H[16e3]){hm(5,b);b=e-f|0;b:{if((b|0)<=0){break b}g=H[17502];c=H[17526];d=g>>>0<c-b>>>0;c=H[17527]-(b>>>0>c>>>0)|0;if(d&(c|0)>=0|(c|0)>0){break b}c=H[17528];d=H[17529];if(!c&(d|0)<=0|(d|0)<0){break b}h=c-b|0;b=d-(b>>>0>c>>>0)|0;if((b|0)<=0&g>>>0>=h>>>0|(b|0)<0){break a}}a=Ka[H[16010]](a,e)|0;if(!a){break a}$j(0,af(a)-f|0);return a}i=Ka[H[16010]](a,e)|0}return i}function El(a,b){var c=0,d=0,e=0;a:{switch(I[b|0]){case 1:c=H[a>>2];a=H[b+36>>2];if(a){dv(c,a);Wa(H[a+40>>2]);_a(c,a);H[b+36>>2]=0}return;case 0:c=H[b+36>>2];e=H[c+8>>2];if(e){d=H[c+20>>2];Jb(e);a=H[d+8>>2];b:{if((c|0)==(a|0)){H[d+8>>2]=H[c+24>>2];break b}while(1){b=H[a+24>>2];if((b|0)==(c|0)){H[a+24>>2]=H[c+24>>2];break b}a=b;if(a){continue}break}}ki(c);vr(d);Wa(H[c+12>>2]);Wa(H[c+16>>2]);if(!(H[d+8>>2]|!(I[d+16|0]&4))){Gg(e)}H[c+8>>2]=0}return;case 2:b=H[b+36>>2];a=H[b>>2];H[a+4>>2]=H[a+4>>2]-1;Ka[H[H[a>>2]+28>>2]](b)|0;break;default:break a}}}function aD(a,b,c){var d=0,e=0,f=0,g=0;a:{if(!(I[c+28|0]&8)){break a}f=H[a>>2];if(I[f+24|0]&4){break a}b:{d=H[H[(H[f+16>>2]+(b<<4)|0)+12>>2]+72>>2];if(!(!d|I[d+28|0]&128|I[d+43|0]==1)){if(J[d+34>>1]==2){break b}}H[a+12>>2]=523;H[a+36>>2]=H[a+36>>2]+1;return 0}d=H[a+116>>2];d=d?d:a;e=d+112|0;c:{while(1){e=H[e>>2];if(!e){break c}if(H[e+4>>2]!=(c|0)){continue}break}return H[e+12>>2]}e=Tb(f,16,0);we(d,46,e);if(I[H[a>>2]+87|0]){break a}H[e>>2]=H[d+112>>2];H[d+112>>2]=e;H[e+8>>2]=b;H[e+4>>2]=c;a=H[d+44>>2];g=a+2|0;H[e+12>>2]=g;H[d+44>>2]=a+4}return g}function xt(a,b,c){var d=0,e=0,f=0,g=0,h=0;g=Ga-16|0;Ga=g;d=H[a+236>>2];a:{if(!d){break a}if(I[a+208|0]==1){Za(a,4798,0);break a}b:{c:{e=H[d+4>>2];f=G[d+34>>1]-1|0;h=e+N(f,12)|0;d:{if(J[h+8>>1]){break d}if(!c){break c}e:{switch(H[c+4>>2]-6|0){case 0:if(Fb(14904,H[c>>2],6)){break d}c=64;break b;case 1:break e;default:break d}}if(!Fb(11157,H[c>>2],7)){break c}}H[g>>2]=H[h>>2];Za(a,28327,g);break a}G[d+36>>1]=J[d+36>>1]-1;c=32}e=e+N(f,12)|0;f=J[e+10>>1];G[e+10>>1]=c|f;H[d+28>>2]=c|H[d+28>>2];if(f&1){ao(a,h)}fo(a,d,h,b);b=0}fb(H[a>>2],b);Ga=g+16|0}function AK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;g=H[a>>2];c=2;a:{if(H[g+36>>2]){break a}c=1;if(J[b+6>>1]&1056){break a}b:{c=H[b+28>>2];if(!c){break b}while(1){if(H[c>>2]<=(d|0)){break b}e=c+(d<<4)|0;f=H[e+12>>2];if(!(!f|I[e+17|0]&3)){od(g,0,f)}d=d+1|0;continue}}c:{f=H[b+32>>2];if(!f){break c}d=0;while(1){if(H[f>>2]<=(d|0)){break c}c=f+(d<<6)|0;od(g,0,H[c+16>>2]);e=H[c+52>>2];d:{if(!(I[c+46|0]&4)){Kb(a,e);break d}c=0;while(1){if(H[e>>2]>(c|0)){od(g,0,H[(e+(c<<3)|0)+8>>2]);c=c+1|0;continue}break}}d=d+1|0;continue}}ds(a,b);c=0}return c|0}function gF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0;e=Ga-32|0;Ga=e;d=ga(a|0,b|0)|0;a:{if((d|0)!=-8){a=yc(d);break a}d=Ga-32|0;Ga=d;c=ka(a|0,d+8|0)|0;if(c){H[17665]=c;c=0}else{c=1}Ga=d+32|0;if(!c){a=yc(-8);break a}c=0;while(1){d=c+e|0;F[d|0]=I[c+24036|0];f=(c|0)!=14;c=c+1|0;if(f){continue}break}b:{if(a){c=14;d=a;while(1){c=c+1|0;f=d>>>0>9;d=(d>>>0)/10|0;if(f){continue}break}F[c+e|0]=0;while(1){c=c-1|0;d=(a>>>0)/10|0;F[e+c|0]=N(d,246)+a|48;f=a>>>0>9;a=d;if(f){continue}break}break b}F[d|0]=48;F[e+15|0]=0}a=yc(fa(e|0,b|0)|0)}Ga=e+32|0;return a|0}function no(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ga-32|0;Ga=e;H[e+28>>2]=d;H[e+24>>2]=c;H[e+20>>2]=b;a:{while(1){if((h|0)==3){break a}i=H[(e+20|0)+(h<<2)>>2];if(!i){break a}k=H[i+4>>2];g=0;b:{while(1){if((g|0)==7){break b}c:{j=N(g,3);if(I[j+48897|0]==(k|0)){if(!Fb(H[i>>2],I[j+48896|0]+48848|0,k)){break c}}g=g+1|0;continue}break}h=h+1|0;f=I[j+48898|0]|f;continue}break}f=f|128}if(!(!(f&128|(f&33)==33)&(f&56)!=32)){H[e+16>>2]=d;H[e>>2]=b;H[e+12>>2]=d?29332:29333;H[e+8>>2]=c;H[e+4>>2]=c?29332:29333;Za(a,18224,e);f=1}Ga=e+32|0;return f}function gt(a,b,c){var d=0,e=0,f=0,g=0;f=Ga-16|0;Ga=f;a:{if(!c){break a}e=H[a>>2];b:{if(!b){break b}g=H[c>>2];if(!g){break b}while(1){if(H[b>>2]<=(d|0)){break b}if(!hb(g,H[(N(d,24)+b|0)+12>>2])){H[f>>2]=g;Za(a,7754,f)}d=d+1|0;continue}}c:{if(b){a=Kd(e,b,N(H[b>>2],24)+36|0,0);break c}a=yb(e,36,0)}if(I[e+87|0]){du(e,c);_a(e,c);break a}b=H[a>>2];H[a>>2]=b+1;d=H[c+20>>2];b=a+N(b,24)|0;H[b+28>>2]=H[c+16>>2];H[b+32>>2]=d;d=H[c+12>>2];H[b+20>>2]=H[c+8>>2];H[b+24>>2]=d;d=H[c+4>>2];H[b+12>>2]=H[c>>2];H[b+16>>2]=d;_a(e,c);b=a}Ga=f+16|0;return b}function Bj(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ga-16|0;Ga=g;F[d+22|0]=0;e=H[d+4>>2];f=F[c|0];a:{if((f|0)>=0){k=f&255;H[g+12>>2]=k;i=1;break a}i=$d(c,g+12|0);k=H[g+12>>2]}f=k;while(1){if(!(b>>>0<f>>>0|i>>>0>=k>>>0)){h=c+i|0;j=F[h|0];b:{if((j|0)>=0){h=j&255;j=1;break b}j=$d(h,g+8|0);h=H[g+8>>2]}F[e+18|0]=I[a+4|0];m=H[a+12>>2];H[e+24>>2]=0;H[e+20>>2]=m;H[e+8>>2]=0;qh(c+f|0,h,e);e=e+40|0;i=i+j|0;f=yi(h)+f|0;l=l+1|0;if(J[d+20>>1]>(l&65535)>>>0){continue}}break}if(!(!(l&65535)|b>>>0>=f>>>0)){dc(e-40|0)}G[d+20>>1]=l;Ga=g+16|0}function ty(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;h=Ga-16|0;Ga=h;H[h+12>>2]=0;k=H[b+4>>2];pe(b,d,h+12|0);g=H[h+12>>2];a:{if(g){break a}j=H[b>>2];g=tk(j,H[b+4>>2],c,d);i=d-g|0;if((i|0)<=0){g=267;break a}Ya(j,c,d);H[b+4>>2]=d;b:{if(!k){b=H[a+4>>2];break b}b=pc(H[a>>2]+H[a+4>>2]|0,g,g>>31)+H[a+4>>2]|0;H[a+4>>2]=b}b=pc(H[a>>2]+b|0,i,0)+H[a+4>>2]|0;H[a+4>>2]=b;Ya(b+H[a>>2]|0,c+g|0,i);b=i+H[a+4>>2]|0;H[a+4>>2]=b;g=0;if(!e){break a}b=pc(b+H[a>>2]|0,f,f>>31)+H[a+4>>2]|0;H[a+4>>2]=b;Ya(b+H[a>>2]|0,e,f);H[a+4>>2]=f+H[a+4>>2]}Ga=h+16|0;return g}function Rj(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;f=2;a:{b:{e=c-4|0;switch(e|0){case 0:case 4:break a;default:break b}}f=c;if(e>>>0>4294967292){break a}kd(173386);return}c:{g=Pf(a,f,b,0);if(!g|!H[g+12>>2]){break c}if(H[a+184>>2]){te(a,5,3805,0);return}wg(a,0);if((I[g+4|0]&247)!=(f|0)){break c}j=Wc(a+428|0,b);e=0;while(1){if((e|0)==3){break c}h=N(e,20)+j|0;if(I[h+4|0]==I[g+4|0]){i=H[h+16>>2];if(i){Ka[i|0](H[h+8>>2])}H[h+12>>2]=0}e=e+1|0;continue}}b=Pf(a,f,b,1);if(!b){return}H[b+16>>2]=0;H[b+8>>2]=0;H[b+12>>2]=d;F[b+4|0]=c&8|f;Yc(a,0)}function _v(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=Ga-16|0;Ga=e;a:{h=H[a+68>>2];if(!(J[a+40>>1]|I[a+50|0]?h:0)){H[c>>2]=0;break a}l=rg(H[a+100>>2]);f=rg(h);while(1){g=0;b:{if((f|0)>=(l|0)){d=Sl(a,f,e);if(d){break a}i=8192;d=Vv(b);m=H[e+4>>2];n=H[e+8>>2];o=H[e>>2];while(1){j=J[(d<<1)+o>>1];if(j){k=j+n|0;if(!(k>>>0>h>>>0|K[a+100>>2]>k>>>0)){g=H[((j<<2)+m|0)-4>>2]==(b|0)?k:g}if(i){i=i-1|0;d=Uv(d);continue}else{d=ab(64853);break a}}break}if(!g){break b}}H[c>>2]=g;d=0;break a}f=f-1|0;continue}}Ga=e+16|0;return d}function sA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=Ga+-64|0;Ga=d;a:{if(Si(a,b,c,d+16|0)){break a}qr(d+16|0);F[d+5|0]=45;F[d+8|0]=45;F[d+11|0]=0;b=H[d+28>>2];c=(b|0)/10|0;F[d+6|0]=((c|0)%10|0)+48;e=H[d+32>>2];f=(e|0)/10|0;F[d+9|0]=((f|0)%10|0)+48;F[d+7|0]=(b-N(c,10)|0)+48;F[d+10|0]=(e-N(f,10)|0)+48;c=H[d+24>>2];b=c>>31;b=(b^c)-b|0;F[d+2|0]=((b>>>0)/100>>>0)%10|48;F[d+1|0]=((b>>>0)/1e3>>>0)%10|48;e=(b>>>0)/10|0;F[d+3|0]=(e>>>0)%10|48;F[d+4|0]=b-N(e,10)|48;if((c|0)<0){F[d|0]=45;wb(a,d,11,-1);break a}wb(a,d|1,10,-1)}Ga=d- -64|0}function qt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;h=b?H[b>>2]:0;i=H[a>>2];a:{if(!c|!d){break a}b:{if(I[d|0]==138){break b}f=H[c>>2];e=Zc(d);if((f|0)==(e|0)){break b}H[g+4>>2]=e;H[g>>2]=f;Za(a,5002,g);break a}f=0;while(1){e=H[c>>2];if((f|0)<(e|0)){e=Cs(a,d,f,e);c:{if(!e){break c}b=sb(a,b,e);if(!b){b=0;break c}e=(f<<3)+c|0;H[((H[b>>2]<<4)+b|0)-4>>2]=H[e+8>>2];H[e+8>>2]=0}f=f+1|0;continue}break}if(I[i+87|0]|(!b|I[d|0]!=138)){break a}h=H[((h<<4)+b|0)+8>>2];H[h+28>>2]=e;H[h+16>>2]=d;d=0}mt(a,d);Ie(i,c);Ga=g+16|0;return b}function Lc(a){var b=0;while(1){a:{if(H[a+4>>2]&270336){a=a+12|0;break a}b=I[a|0];if((b|0)==176){b=I[a+2|0]}b:{c:{d:{e:{f:{switch(b-177|0){default:if((b|0)!=138){g:{switch(b-167|0){case 0:case 2:break g;case 1:break d;default:break e}}b=H[a+44>>2];if(!b){break d}a=Uk(b,G[a+32>>1]);break b}a=H[H[a+20>>2]+28>>2]+8|0;break a;case 1:a=(H[H[H[a+12>>2]+20>>2]+28>>2]+(G[a+32>>1]<<4)|0)+8|0;break a;case 0:break f}}a=H[a+20>>2]+8|0;break a}if((b|0)==36){break c}}a=I[a+1|0];break b}a=nl(H[a+8>>2],0)}return a<<24>>24}a=H[a>>2];continue}}function cK(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;e=Ga-16|0;Ga=e;f=Gc(a);d=Cg(a);a:{if((bc(H[c>>2])|0)>H[f+152>>2]){fc(a,1418,-1);break a}b:{if((b|0)==3){b=cb(H[c+8>>2]);H[e+4>>2]=b;if(!b){break a}if((gx(b)|0)!=1){fc(a,8764,-1);break a}b=Xd(e+4|0);if((b|0)!=I[d|0]&I[d+1|0]!=(b|0)){break b}f=I[d|0]|I[d+1|0]<<8|(I[d+2|0]<<16|I[d+3|0]<<24);H[e+8>>2]=f;if((f&255)==(b|0)){F[e+8|0]=0}d=e+8|0;if((f>>>8&255)!=(b|0)){break b}F[e+9|0]=0;break b}b=I[d+2|0]}f=cb(H[c>>2]);c=cb(H[c+4>>2]);if(!c|!f){break a}Hc(a,!xi(f,c,d,b))}Ga=e+16|0}function aG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}e=Nb(H[c>>2]);H[17665]=0;b=Ga-16|0;Ga=b;C(+e);c=x(1)|0;x(0)|0;c=c&2147483647;a:{if(c>>>0<=1072243195){d=1;if(c>>>0<1044816030){break a}d=lk(e,0);break a}d=e-e;if(c>>>0>=2146435072){break a}b:{switch(iq(e,b)&3){case 0:d=lk(M[b>>3],M[b+8>>3]);break a;case 1:d=-kk(M[b>>3],M[b+8>>3],1);break a;case 2:d=-lk(M[b>>3],M[b+8>>3]);break a;default:break b}}d=kk(M[b>>3],M[b+8>>3],1)}e=d;Ga=b+16|0;Zb(a,e);return}_(22968,17213,420,16907);X()}function jr(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;b=H[a>>2];a=b;while(1){if(a){c=a;a=H[a+32>>2];H[c+16>>2]=a;continue}break}a=b;b=Ga-128|0;Ga=b;d=$a(b,0,128);a:while(1){if(a){b=H[a+16>>2];c=0;H[a+16>>2]=0;while(1){if((c|0)!=31){e=(c<<2)+d|0;f=H[e>>2];if(f){a=ip(f,a);H[e>>2]=0;c=c+1|0;continue}else{H[e>>2]=a;a=b;continue a}}break}g=d,h=ip(H[d+124>>2],a),H[g+124>>2]=h;a=b;continue}break}a=H[d>>2];c=1;while(1){if((c|0)!=32){b=H[(c<<2)+d>>2];b:{if(!b){break b}if(!a){a=b;break b}a=ip(a,b)}c=c+1|0;continue}break}Ga=d+128|0;return a}function kj(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;h=Ga-16|0;Ga=h;a:{if(H[b+8>>2]){break a}g=H[b+60>>2];if(!g){break a}e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[b+8>>2]=e;f=zb(a);d=H[g+12>>2];b:{if(Ng(d,h+12|0)){d=H[h+12>>2];Va(f,71,d,e);if(!d){Yb(f,c);break b}if((d|0)<0){break b}i=G[b+2>>1];c=je(d,0);if((i|0)<=(c|0)){break b}G[b+2>>1]=c;H[b+4>>2]=H[b+4>>2]|16384;break b}oc(a,d,e);db(f,12,e);Va(f,16,e,c)}c=H[g+16>>2];if(!c){break a}g=b;d=H[a+44>>2];b=d+1|0;H[g+12>>2]=b;d=d+2|0;H[a+44>>2]=d;oc(a,c,b);db(f,12,b);Xa(f,160,e,d,b)}Ga=h+16|0}function ok(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=Ga-16|0;Ga=f;C(+b);g=x(1)|0;d=x(0)|0;c=g&2147483647;e=c+-1048576|0;a:{if((e|0)==2145386495|e>>>0<2145386495){h=d<<28;e=c>>>4|0;c=(c&15)<<28|d>>>4;d=e+1006632960|0;break a}if((c|0)==2146435072|c>>>0>2146435072){h=d<<28;c=(g&15)<<28|d>>>4;d=g>>>4|2147418112;break a}if(!(c|d)){c=0;d=0;break a}e=c;c=c?Q(c):Q(d)+32|0;ud(f,d,e,0,0,c+49|0);i=H[f>>2];h=H[f+4>>2];e=15372-c<<16;c=H[f+8>>2];d=e|H[f+12>>2]^65536}H[a>>2]=i;H[a+4>>2]=h;H[a+8>>2]=c;H[a+12>>2]=g&-2147483648|d;Ga=f+16|0}function Zw(a,b){var c=0,d=0,e=0;if(a){if(!cm(a)){return kd(171876)}if(I[a+94|0]&8){Ka[H[a+212>>2]](8,H[a+216>>2],a,0)|0}Se(a);while(1){if(H[a+20>>2]>(d|0)){a:{c=H[(H[a+16>>2]+(d<<4)|0)+12>>2];if(!c){break a}c=c+16|0;while(1){c=H[c>>2];if(!c){break a}e=H[c+8>>2];if(I[e+43|0]!=1){continue}Uz(a,e);continue}}d=d+1|0;continue}break}c=a+392|0;while(1){c=H[c>>2];if(c){d=H[H[c+8>>2]+20>>2];if(!d){continue}Uz(a,d);continue}break}Ym(a);Yw(a);b:{if(b){break b}if(!Ny(a)){break b}te(a,5,4465,0);return 5}F[a+97|0]=167;Kn(a)}return 0}function Tx(a,b,c){var d=0,e=0;e=a;a:{b:{c:{d:{if((e^b)&3){break d}d=(c|0)!=0;e:{if(!(b&3)|!c){break e}while(1){d=I[b|0];F[e|0]=d;if(!d){break a}e=e+1|0;c=c-1|0;d=(c|0)!=0;b=b+1|0;if(!(b&3)){break e}if(c){continue}break}}if(!d){break b}if(!I[b|0]){break a}if(c>>>0<4){break d}while(1){d=H[b>>2];if((d^-1)&d-16843009&-2139062144){break c}H[e>>2]=d;e=e+4|0;b=b+4|0;c=c-4|0;if(c>>>0>3){continue}break}}if(!c){break b}}while(1){d=I[b|0];F[e|0]=d;if(!d){break a}e=e+1|0;b=b+1|0;c=c-1|0;if(c){continue}break}}c=0}$a(e,0,c);return a}function HK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{b:{switch(I[b|0]-167|0){case 0:case 2:break b;default:break a}}f=H[a+24>>2];e=H[f+4>>2];if(e){d=H[e>>2]}g=(d|0)>0?d:0;while(1){c:{if((c|0)==(g|0)){c=H[f+8>>2];e=c;d=!!c;c=H[f+12>>2];d=d&(c|0)>=0|(c|0)>0;e=d?e:0;g=d?c:0;d=2;while(1){if((e|0)==(h|0)&(g|0)==(i|0)){break c}c=h;h=c+1|0;i=h?i:i+1|0;if(H[H[f+16>>2]+(c<<2)>>2]!=H[b+28>>2]){continue}break}break a}d=1;j=c<<6;c=c+1|0;if(H[b+28>>2]!=H[(e+j|0)+48>>2]){continue}}break}G[a+20>>1]=J[a+20>>1]|d}return 0}function Fu(a){var b=0,c=0,d=0,e=0;d=Ga-16|0;Ga=d;b=J[a+16>>1];if(!(b&45)){a:{b:{c:{if(Yd(H[a+8>>2],a,H[a+12>>2],I[a+18|0])>>>0>1){break c}if((jh(H[a+8>>2],d+8|0,H[a+12>>2],I[a+18|0])|0)>1){break c}e=H[d+8>>2];b=H[d+12>>2];break b}c=M[a>>3];d:{if(P(c)<0x8000000000000000){e=~~c>>>0;b=P(c)>=1?~~(c>0?R(T(c*2.3283064365386963e-10),4294967295):U((c-+(~~c>>>0>>>0))*2.3283064365386963e-10))>>>0:0;break d}b=-2147483648}if(fu(c,e,b)){break b}b=8;break a}H[a>>2]=e;H[a+4>>2]=b;b=4}b=b|J[a+16>>1]&-3520}G[a+16>>1]=b&64493;Ga=d+16|0}function ly(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;f=Ga-16|0;Ga=f;while(1){if(a){c=H[a+20>>2];a:{if(!c){break a}c=H[c+28>>2];if(!c){break a}d=0;H[f+12>>2]=0;while(1){g=0;e=0;while(1){h=I[c|0];if(h&254|g){c=c+1|0;e=!g+e|0;g=h&128;continue}break}d=H[a+40>>2]+N(d,12)|0;H[d+4>>2]=H[d+4>>2]+e;H[d+8>>2]=H[d+8>>2]+((e|0)!=0);if(!I[c|0]){break a}e=c+1|0;c=F[c+1|0];b:{if((c|0)<0){c=uc(e,f+12|0);d=H[f+12>>2];break b}d=c&255;H[f+12>>2]=d;c=1}c=c+e|0;if((b|0)>(d|0)){continue}break}}ly(H[a+12>>2],b);a=H[a+16>>2];continue}break}Ga=f+16|0}function $F(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}d=Nb(H[c>>2]);H[17665]=0;b=Ga-16|0;Ga=b;C(+d);c=x(1)|0;x(0)|0;c=c&2147483647;a:{if(c>>>0<=1072243195){if(c>>>0<1045430272){break a}d=kk(d,0,0);break a}if(c>>>0>=2146435072){d=d-d;break a}b:{switch(iq(d,b)&3){case 0:d=kk(M[b>>3],M[b+8>>3],1);break a;case 1:d=lk(M[b>>3],M[b+8>>3]);break a;case 2:d=-kk(M[b>>3],M[b+8>>3],1);break a;default:break b}}d=-lk(M[b>>3],M[b+8>>3])}Ga=b+16|0;Zb(a,d);return}_(22968,17213,419,16978);X()}function it(a,b,c){var d=0,e=0,f=0;f=Ga-16|0;Ga=f;d=H[a>>2];a:{if(kf(a)){break a}b:{if(!b){b=0;while(1){if(H[d+20>>2]<=(b|0)){break b}if((b|0)!=1){PC(a,b)}b=b+1|0;continue}}c:{if(H[c+4>>2]){break c}e=OC(d,b);if((e|0)<0){break c}PC(a,e);break b}e=0;b=ig(a,b,c,f+12|0);if((b|0)<0){break b}e=H[c+4>>2]?H[H[d+16>>2]+(b<<4)>>2]:e;b=vc(d,H[f+12>>2]);if(!b){break b}c=Ff(d,b,e);d:{if(c){NC(a,H[c+12>>2],c);break d}c=Sf(a,0,b,e);if(!c){break d}NC(a,c,0)}_a(d,b)}if(I[d+96|0]){break a}a=zb(a);if(!a){break a}Sb(a,166)}Ga=f+16|0}function Dd(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0;if(!(!I[H[(H[H[a>>2]+16>>2]+(b<<4)|0)+4>>2]+9|0]|(b|0)==1)){g=H[a+116>>2];a=g?g:a;g=H[a+104>>2];j=(g|0)>0?g:0;a:{while(1){if((f|0)!=(j|0)){h=H[a+108>>2];i=h+(f<<4)|0;if(!(H[i>>2]!=(b|0)|H[i+4>>2]!=(c|0))){a=(f<<4)+h|0;F[a+8|0]=(I[a+8|0]|d)!=0;break a}f=f+1|0;continue}break}f=(g<<4)+16|0;f=Cj(H[a>>2],H[a+108>>2],f,f>>31);H[a+108>>2]=f;if(f){g=a;a=H[a+104>>2];H[g+104>>2]=a+1;a=f+(a<<4)|0;H[a+12>>2]=e;F[a+8|0]=d;H[a+4>>2]=c;H[a>>2]=b;break a}H[a+104>>2]=0;Mb(H[a>>2])}}}function oF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;if(H[d+60>>2]<=0){f=M[d+24>>3];c=H[d+36>>2]+c|0;e=b;b=H[d+32>>2];e=e+b|0;g=e;e=b>>>0>e>>>0?c+1|0:c;a:{if(!(+(g|0)>=f)){break a}c=H[d+16>>2];if(+(c>>>0)+ +H[d+20>>2]*4294967296-f<=+(c-b|0)){c=H[d+44>>2];b=H[d+40>>2]+1|0;c=b?c:c+1|0;H[d+40>>2]=b;H[d+44>>2]=c;if(!(H[d+48>>2]|H[d+52>>2])){a=H[a>>2];b=a+H[d>>2]|0;c=H[d+4>>2]+(a>>31)|0;H[d>>2]=b;H[d+4>>2]=a>>>0>b>>>0?c+1|0:c;break a}M[d+8>>3]=M[a>>3]+M[d+8>>3];break a}H[d+60>>2]=1}H[d+32>>2]=g;H[d+36>>2]=e}}function AH(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:{b:{if(c-6>>>0<4294967294){break b}g=H[d+4>>2];h=ub(g);if((c|0)==5){if((h|0)!=4){break b}if(Fb(9321,g,4)){break b}g=H[d+12>>2];h=ub(g);b=4}else{b=3}f=H[(b<<2)+d>>2];d=ub(f);c=Wj(a,25119);if(c){break a}b=(d+h|0)+306|0;c=Ib(b,0);if(!c){return 7}b=$a(c,0,b);c=b+304|0;H[b+32>>2]=c;H[b+12>>2]=b+16;H[b+272>>2]=1;H[b+28>>2]=a;a=(c+h|0)+1|0;H[b+36>>2]=a;Ya(c,g,h);Ya(a,f,d);Ni(H[H[b+12>>2]+20>>2]);H[e>>2]=b;return 0}de(f,8364,0);c=1}return c|0}function Ur(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=1;a:{if(I[H[a+4>>2]]){break a}d=0;if(I[b|0]!=167){break a}g=H[b+4>>2];if(g&(H[a+20>>2]|32)){break a}d=H[a+8>>2];i=(d|0)>0?d:0;d=1;while(1){if((e|0)==(i|0)){break a}h=H[a+24>>2];f=H[h+(e<<3)>>2];if(!((f|0)==(b|0)|H[f+28>>2]!=H[b+28>>2]|J[f+32>>1]!=J[b+32>>1])){if(c){if((Lc(f)|0)==65){break a}h=H[a+24>>2];g=H[b+4>>2]}H[a+12>>2]=H[a+12>>2]+1;H[b+4>>2]=g&-8388641|32;j=b,k=nb(H[H[a>>2]>>2],H[(e<<3|4)+h>>2],0),H[j+12>>2]=k;break a}e=e+1|0;continue}}return d}function Pw(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;l=(b|0)==12;while(1){if(!(H[a+20>>2]<=(i|0)|f)){a:{if(!l){f=0;if((b|0)!=(i|0)){break a}}f=H[(H[a+16>>2]+(i<<4)|0)+4>>2];if(f){h=H[f+4>>2];Jb(f);if(I[h+20|0]){g=6}else{j=H[f>>2];f=H[h>>2];h=H[f+232>>2];b:{if(!h){g=0;if(I[f+5|0]!=5){break b}Re(j,2181,0,0,0);h=H[f+232>>2];g=0;if(!h){break b}}g=zv(h,j,c,c?H[f+192>>2]:0,H[f+196>>2],I[f+11|0],H[f+168>>2],H[f+224>>2],d,e)}}}else{g=0}e=g;d=0;e=(e|0)==5;f=e?0:g;k=e?1:k;e=0}i=i+1|0;continue}break}return f?f:k?5:f}function Dk(a){a=a|0;var b=0,c=0,d=0;c=Ga-32|0;Ga=c;b=H[a+20>>2];H[c+24>>2]=H[a+16>>2];H[c+28>>2]=b;b=H[a+12>>2];H[c+16>>2]=H[a+8>>2];H[c+20>>2]=b;d=H[a+52>>2];b=c+8|0;H[b>>2]=H[a+48>>2];H[b+4>>2]=d;d=H[a+44>>2];H[c>>2]=H[a+40>>2];H[c+4>>2]=d;Qf(a+40|0);Uf(a+24|0);d=a+8|0;while(1){b=H[b>>2];if(b){ri(0,H[b+8>>2]);continue}break}Uf(c);Qf(d);b=c+24|0;while(1){b=H[b>>2];if(b){ie(0,H[b+8>>2]);continue}break}Uf(c+16|0);Uf(a+56|0);H[a+72>>2]=0;b=J[a+78>>1];if(b&1){H[a+4>>2]=H[a+4>>2]+1}G[a+78>>1]=b&65526;Ga=c+32|0}function yy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;a=lf(a,b);if(a){b=0;while(1){g=I[a+b|0];if((g-48&255)>>>0<=9){h=SK(f,e,10,0);e=(g&255)-48|0;g=e;f=h+e|0;e=Ja;e=f>>>0<g>>>0?e+1|0:e;b=b+1|0;continue}break}H[c>>2]=f;H[c+4>>2]=e;c=1;g=0;while(1){e=I[a+b|0];if((e|0)!=32){if((e|0)==45){c=-1;g=-1;b=b+1|0}f=0;e=0;while(1){h=I[a+b|0];if((h-48&255)>>>0<=9){f=SK(f,e,10,0);e=(h&255)-48|0;h=e;f=f+e|0;e=Ja;e=f>>>0<h>>>0?e+1|0:e;b=b+1|0;continue}break}i=d,j=SK(f,e,c,g),H[i>>2]=j;H[d+4>>2]=Ja}else{b=b+1|0;continue}break}}}function le(a,b,c,d){var e=0,f=0;a:{e=H[a>>2];if(I[e+87|0]){if((d|0)==-11){break a}_j(e,d,c);return}f=H[a+104>>2];b=(b|0)<0?H[a+108>>2]-1|0:b;e=f+N(b,20)|0;if(!(I[e+1|0]?0:(d|0)<0)){b=F[e+1|0];if(b){_j(H[a>>2],b,H[e+16>>2]);H[e+16>>2]=0;F[e+1|0]=0}b:{if((d|0)<0){le(a,(e-H[a+104>>2]|0)/20|0,c,d);break b}if(!d){d=ib(c)}a=me(H[a>>2],c,d,0);F[e+1|0]=250;H[e+16>>2]=a}return}if((d|0)==-3){H[(N(b,20)+f|0)+16>>2]=c;F[e+1|0]=253;return}if(!c){break a}H[(N(b,20)+f|0)+16>>2]=c;F[e+1|0]=d;if((d|0)!=-11){break a}Wp(c)}}function wz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=Ga-16|0;Ga=i;h=H[d>>2];e=H[c>>2];H[i+12>>2]=0;k=e+h|0;f=e;while(1){g=0;while(1){a:{if(f>>>0>=k>>>0){break a}j=g;g=I[f|0];if(!(j|g&254)){break a}g=g&128;f=f+1|0;continue}break}b:{if(H[i+12>>2]==(a|0)){h=f-e|0;break b}h=(e-f|0)+h|0;if((h|0)<=0){e=f;break b}j=f+1|0;e=F[f+1|0];c:{if((e|0)<0){g=uc(j,i+12|0);break c}H[i+12>>2]=e&255;g=1}e=f;f=g+j|0;continue}break}d:{if(!b){break d}b=e+h|0;a=k-b|0;if((a|0)<=0){break d}$a(b,0,a)}H[c>>2]=e;H[d>>2]=h;Ga=i+16|0}function HF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;if((b|0)==2){a:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break a}}Wb(a);return}b=cb(H[c>>2]);e=ac(H[c+4>>2]);c=b;while(1){if(Ve(c)){while(1){f=I[c+1|0];c=c+1|0;if((f&192)==128){continue}break}d=d+1|0;continue}break}d=d-e|0;d=(d|0)>0?d:0;while(1){if((d|0)>0){d=d-1|0;while(1){e=I[b+1|0];b=b+1|0;if((e&192)==128){continue}break}continue}break}c=Ub((c-b|0)+1|0);if(!c){ic(a);return}d=a;a=sh(c,b);wb(d,a,-1,-1);Wa(a);return}_(22830,17213,1113,16887);X()}function of(a){var b=0,c=0,d=0,e=0;while(1){b=a;if(b){a=H[b+12>>2];if(a){continue}a=H[b+16>>2];if(a){continue}}break}while(1){a=b;if(b){c=H[a+8>>2];a:{b=H[a+20>>2];if(!b){break a}Wa(H[b>>2]);Ji(b);d=$a(b,0,40);b=0;while(1){if(H[d+64>>2]<=(b|0)){break a}e=N(b,24)+d|0;Sq(H[e+92>>2]);H[e+92>>2]=0;b=b+1|0;continue}}Wa(H[a+40>>2]);Wa(a);b=0;if(!c){continue}b=c;if((a|0)!=H[b+12>>2]){continue}a=H[b+16>>2];if(!a){continue}while(1){b=a;a=H[b+12>>2];if(a){continue}a=H[b+16>>2];if(a){continue}break}continue}break}}function iz(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;g=Ga-16|0;Ga=g;b=0;a:{if(I[a+237|0]!=2){break a}H[g>>2]=H[a+20>>2];h=Hb(3272,g);b=7;if(!h){break a}e=H[a+12>>2];d=H[a+16>>2];c=Ga-32|0;Ga=c;H[c+28>>2]=0;Se(e);f=Ip(e,c+28|0);b=0;b:{if(f){break b}d=Dc(e,h,d);if(d){b=0;if(I[d+43|0]==2){break b}b=d;break b}b=0}d=H[c+28>>2];if(!(f|b)){_a(e,d);H[c+20>>2]=0;H[c+16>>2]=h;d=tb(e,5962,c+16|0);H[c+28>>2]=d;f=1}H[c>>2]=d;te(e,f,d?8310:0,c);_a(e,H[c+28>>2]);b=nd(e,f);Ga=c+32|0;Wa(h);F[a+237|0]=!b;b=0}Ga=g+16|0;return b}function EH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=Ga-16|0;Ga=d;f=Cg(a);e=cb(H[c>>2]);g=bc(H[c>>2])+1|0;a:{b:{if((b|0)==2){h=oz(a);b=H[c+4>>2];c:{if(!h){if(!Ix(b)){break c}}if(!(!e|(bc(b)|0)!=4)){b=H[nf(H[c+4>>2])>>2];H[d+12>>2]=b;if((yk(f,e,g,b)|0)!=(b|0)){break b}fc(a,1141,-1);break b}fc(a,11672,-1);break a}fc(a,15262,-1);break a}if(e){b=Km(f,e,g);H[d+12>>2]=b;if(b){break b}}H[d>>2]=e;b=a;a=Hb(7228,d);fc(b,a,-1);Wa(a);break a}if(!oz(a)){if(!Ix(H[c>>2])){break a}}Ci(a,d+12|0,4,-1)}Ga=d+16|0}function Hd(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0;k=Ga-80|0;Ga=k;l=Tb(H[a>>2],76,0);j=l?l:k;if(!b){b=sb(a,0,sc(H[a>>2],180,0))}H[j+28>>2]=b;F[j|0]=138;H[j+8>>2]=0;H[j+12>>2]=0;H[j+4>>2]=h;b=H[a+100>>2]+1|0;H[a+100>>2]=b;H[j+20>>2]=-1;H[j+24>>2]=-1;H[j+16>>2]=b;G[j+2>>1]=0;if(!c){c=yb(H[a>>2],72,0)}H[j+72>>2]=0;H[j+64>>2]=0;H[j+68>>2]=0;H[j+60>>2]=i;H[j+52>>2]=0;H[j+56>>2]=0;H[j+48>>2]=g;H[j+44>>2]=f;H[j+40>>2]=e;H[j+36>>2]=d;H[j+32>>2]=c;a=H[a>>2];if(I[a+87|0]){eu(a,j,(j|0)!=(k|0));l=0}Ga=k+80|0;return l}function Nr(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;while(1){if(b){h=H[b+32>>2];d=xf(a,H[b+28>>2]);c=Ja;d=xf(a,H[b+40>>2])|d;c=Ja|c;d=xf(a,H[b+48>>2])|d;c=Ja|c;d=wf(a,H[b+36>>2])|d;c=Ja|c;e=e|(wf(a,H[b+44>>2])|d);f=f|(Ja|c);g=0;a:{if(!h){break a}while(1){if(H[h>>2]<=(g|0)){break a}c=(g<<6)+h|0;e=Nr(a,H[c+28>>2])|e;f=f|Ja;d=I[c+45|0]|I[c+46|0]<<8;if(!(d&1024)){e=wf(a,H[c+52>>2])|e;f=f|Ja;d=I[c+45|0]|I[c+46|0]<<8}if(d&4){e=xf(a,H[c- -64>>2])|e;f=f|Ja}g=g+1|0;continue}}b=H[b+52>>2];continue}break}Ja=f;return e}function Co(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=c;while(1){if(!(H[a>>2]|(f|0)<=0)){d=H[a+16>>2];g=H[a+8>>2]-d|0;g=(f|0)<(g|0)?f:g;Ya(d+H[a+4>>2]|0,(c-f|0)+b|0,g);e=g+H[a+16>>2]|0;H[a+16>>2]=e;if(H[a+8>>2]==(e|0)){d=H[a+12>>2];i=e-d|0;e=H[a+28>>2]+(d>>31)|0;h=d+H[a+24>>2]|0;e=h>>>0<d>>>0?e+1|0:e;j=a,k=Bc(H[a+32>>2],d+H[a+4>>2]|0,i,h,e),H[j>>2]=k;H[a+12>>2]=0;H[a+16>>2]=0;d=H[a+8>>2];h=d;e=d+H[a+24>>2]|0;d=H[a+28>>2]+(d>>31)|0;H[a+24>>2]=e;H[a+28>>2]=e>>>0<h>>>0?d+1|0:d}f=f-g|0;continue}break}}function Tv(a,b,c,d,e){Cb(e,b);Cb(e+4|0,c);if(!H[a+104>>2]){b=H[a+88>>2];c=H[a+84>>2];F[e+8|0]=c;F[e+9|0]=c>>>8;F[e+10|0]=c>>>16;F[e+11|0]=c>>>24;F[e+12|0]=b;F[e+13|0]=b>>>8;F[e+14|0]=b>>>16;F[e+15|0]=b>>>24;c=!I[a+65|0];b=a+76|0;tg(c,e,8,b,b);tg(c,d,H[a+36>>2],b,b);Cb(e+16|0,H[b>>2]);Cb(e+20|0,H[a+80>>2]);return}F[e+8|0]=0;F[e+9|0]=0;F[e+10|0]=0;F[e+11|0]=0;F[e+12|0]=0;F[e+13|0]=0;F[e+14|0]=0;F[e+15|0]=0;F[e+16|0]=0;F[e+17|0]=0;F[e+18|0]=0;F[e+19|0]=0;F[e+20|0]=0;F[e+21|0]=0;F[e+22|0]=0;F[e+23|0]=0}function Mt(a,b){var c=0,d=0,e=0,f=0,g=0;e=Ga-32|0;Ga=e;c=H[a>>2];d=H[a+4>>2];f=H[a+44>>2];a:{b:{if(f){b=mi(c+f|0,b);c=H[a+4>>2];d=b+H[a>>2]|0;c=d>>>0<b>>>0?c+1|0:c;H[a>>2]=d;H[a+4>>2]=c;break b}g=c;f=d;d=H[a+40>>2];c=d;c=UK(g,f,c,c>>31);if(!(!c|(d-c|0)<9)){b=mi(c+H[a+36>>2]|0,b);c=H[a+4>>2];d=b+H[a>>2]|0;c=d>>>0<b>>>0?c+1|0:c;H[a>>2]=d;H[a+4>>2]=c;break b}c=0;while(1){d=zo(a,1,e+12|0);if(d){break a}d=F[H[e+12>>2]];F[e+16|c&15]=d;c=c+1|0;if((d|0)<0){continue}break}mi(e+16|0,b)}d=0}Ga=e+32|0;return d}function vu(a){var b=0,c=0,d=0,e=0,f=0,g=0;F[a+56|0]=1;d=a+36|0;c=Ga-48|0;Ga=c;b=a- -64|0;a=H[H[b+8>>2]+24>>2];$a(c+8|0,0,40);a:{if(!H[b+40>>2]){a=St(a,b+40|0);if(a){break a}}a=wu(b,d);if(a){break a}a=c+8|0;e=b+48|0;Rt(H[b+40>>2],a,H[H[b+8>>2]+12>>2],H[e>>2],H[e+4>>2]);H[b+28>>2]=H[b+28>>2]+1;b=a;a=H[d+8>>2];Do(b,a,a>>31);a=H[d>>2];while(1){b=a;if(b){a=H[b+4>>2];f=c+8|0;g=H[b>>2];Do(f,g,g>>31);Co(f,b+8|0,H[b>>2]);if(H[d+4>>2]){continue}Wa(b);continue}break}H[d>>2]=0;a=Qt(c+8|0,e)}Ga=c+48|0;return a}function sm(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;g=Ga-240|0;Ga=g;H[g+236>>2]=c;H[g+232>>2]=b;H[g>>2]=a;k=1;a:{b:{c:{if(!((b|0)!=1|c)){h=a;break c}i=a;while(1){j=(d<<2)+f|0;h=i-H[j>>2]|0;if((Bh(h,a)|0)<=0){h=i;break c}d:{if(!((d|0)<2|e)){e=H[j-8>>2];j=i-4|0;if((Bh(j,h)|0)>=0){break d}if((Bh(j-e|0,h)|0)>=0){break d}}H[(k<<2)+g>>2]=h;b=Wx(b,c);tm(g+232|0,b);k=k+1|0;d=b+d|0;e=0;i=h;c=H[g+236>>2];b=H[g+232>>2];if(c|(b|0)!=1){continue}break b}break}h=i;break b}if(e){break a}}Vx(g,k);eq(h,d,f)}Ga=g+240|0}function th(a,b,c,d,e,f){var g=0,h=0,i=0,j=0;a:{if(f&64){c=f+-64|0;b=c&31;if((c&63)>>>0>=32){c=0;b=e>>>b|0}else{c=e>>>b|0;b=((1<<b)-1&e)<<32-b|d>>>b}d=0;e=0;break a}if(!f){break a}i=d;h=64-f|0;g=h&31;if((h&63)>>>0>=32){h=i<<g;j=0}else{h=(1<<g)-1&i>>>32-g|e<<g;j=i<<g}i=b;b=f&31;if((f&63)>>>0>=32){g=0;b=c>>>b|0}else{g=c>>>b|0;b=((1<<b)-1&c)<<32-b|i>>>b}b=j|b;c=g|h;g=d;d=f&31;if((f&63)>>>0>=32){h=0;d=e>>>d|0}else{h=e>>>d|0;d=((1<<d)-1&e)<<32-d|g>>>d}e=h}H[a>>2]=b;H[a+4>>2]=c;H[a+8>>2]=d;H[a+12>>2]=e}function EA(a,b){var c=0,d=0,e=0;a:{b:{if(J[a+50>>1]!=J[b+50>>1]|J[a+52>>1]!=J[b+52>>1]|I[a+54|0]!=I[b+54|0]){break b}while(1){if(J[b+50>>1]>d>>>0){c=d<<1;e=J[c+H[b+4>>2]>>1];if((e|0)!=J[c+H[a+4>>2]>>1]){break a}if((e|0)==65534){e=0;c=d<<4;if(mc(0,H[(c+H[b+40>>2]|0)+8>>2],H[(c+H[a+40>>2]|0)+8>>2],-1)){break b}}if(I[H[b+28>>2]+d|0]!=I[H[a+28>>2]+d|0]){break a}c=d<<2;d=d+1|0;e=0;if(!Qb(H[c+H[b+32>>2]>>2],H[c+H[a+32>>2]>>2])){continue}break b}break}e=!mc(0,H[b+36>>2],H[a+36>>2],-1)}return e}return 0}function DB(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=H[a+8>>2];g=H[e>>2];a:{switch(b-1|0){case 1:c=H[a+44>>2];H[a+44>>2]=c+g;b=0;k=(g|0)>0?g:0;i=g-1|0;c=c+1|0;l=g+H[h+108>>2]|0;while(1){if((b|0)!=(k|0)){g=b+c|0;j=b+f|0;m=Sd(a,H[((b<<4)+e|0)+8>>2]);b:{if((b|0)<(i|0)){Xa(h,52,j,l,g);break b}Xa(h,53,j,d,g)}le(h,-1,m,-2);pb(h,128);b=b+1|0;continue}break};Xa(h,80,f,c,i);return c;default:b=Db(a);ob(h,28,c,d,f,g);Xa(h,97,f,g,b);ob(h,138,c,b,f,g);pb(h,16);xb(a,b);i=c;break;case 0:break a}}return i}function Ds(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=((i|0)!=0)<<4;q=o|g&2|1;j=b+8|0;k=H[a+8>>2];while(1){l=H[j>>2];if(l){m=(n<<2)+f|0;j=H[m>>2];if(j){if(H[l+36>>2]){Va(k,50,j,H[k+108>>2]+2|0)}j=o;p=I[l+55|0]|I[l+56|0]<<8;j=(p&3)==2?I[b+28|0]&128?q:j:j;m=H[m>>2];ob(k,138,d+n|0,m,m+1|0,J[(p&8?50:52)+l>>1]);pb(k,j)}n=n+1|0;j=l+20|0;continue}break}if(!(I[b+28|0]&128)){d=I[a+18|0];Xa(k,128,c,H[(n<<2)+f>>2],e);c=d?0:g?g|1:33;c=h?c|8:c;c=i?c|16:c;if(!I[a+18|0]){Pc(k,b,-5)}pb(k,c&255)}}function sI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Ga-48|0;Ga=d;g=Cg(a);a:{if((b|0)<=0){break a}if(!(b&1)){iA(a,g?3144:2309);break a}if(Eh(d+16|0,a,cb(H[c>>2]))){break a}f=1;b:{while(1){if(b>>>0>f>>>0){e=cb(H[(f<<2)+c>>2]);H[d+12>>2]=0;e=Xf(d+16|0,e,d+12|0,a);if(I[d+36|0]){ic(a);break b}if(I[d+37|0]){break b}if(!(!e|!(g?1:H[d+12>>2]))){H[e+8>>2]=f+1;F[e+1|0]=I[e+1|0]|8}f=f+2|0;continue}break}b=H[d+24>>2];if(I[b+1|0]&8){ae(a,H[(H[b+8>>2]<<2)+c>>2]);break b}Qi(b,a,c)}Kg(d+16|0)}Ga=d+48|0}function ds(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Ga-32|0;Ga=e;f=H[b+64>>2];a:{if(!f){break a}c=H[a>>2];if(!(I[H[f+20>>2]+4|0]&64)){g=ho(c,oC(H[c>>2],f),1)}d=e|4;b=0;while(1){if(H[f>>2]>(b|0)){h=N(b,24)+f|0;i=H[h+20>>2];H[d+24>>2]=0;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0;H[e>>2]=c;if(g){ve(c,i,e);j=H[e>>2]}else{j=c}if(I[H[j>>2]+87|0]){break a}lc(a,i);Vs(c,H[h+16>>2]);b=b+1|0;continue}break}if(!g|H[c+264>>2]!=(g|0)){break a}H[c+264>>2]=H[g+8>>2]}Ga=e+32|0}function se(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;e=H[a+12>>2];d=H[a+16>>2];if((e|0)>=(d|0)){e=H[a+24>>2];f=H[a>>2];g=H[H[f>>2]>>2];d=Yr(f,N(d,96));H[a+24>>2]=d;if(!d){if(c&1){fb(g,b)}H[a+24>>2]=e;return 0}Ya(d,e,N(H[a+12>>2],48));H[a+16>>2]=H[a+16>>2]<<1;e=H[a+12>>2]}f=1;g=e+1|0;H[a+12>>2]=g;d=H[a+24>>2];if(!(c&2)){H[a+20>>2]=g}g=d+N(e,48)|0;d=d+N(e,48)|0;if(!(!b|!(I[b+6|0]&8))){f=H[b+28>>2];f=je(f,f>>31)-270|0}G[d+8>>1]=f;h=g,i=jd(b),H[h>>2]=i;H[d+4>>2]=a;G[d+10>>1]=c;$a(d+12|0,0,36);return e}function fy(a,b){var c=0,d=0,e=0,f=0,g=0;a:{while(1){c=I[a+d|0];if(!c){break a}if((c|32)-97>>>0>=26){d=d+1|0;continue}break}f=b,g=Px(c),F[f|0]=g;c=1;while(1){b:{if((c|0)>3){break b}e=I[a+d|0];if(!e){break b}e=I[(e&127)+55728|0];if(e){F[b+c|0]=e+48;c=c+1|0}d=d+1|0;continue}break}a=(c|0)>4?c:4;while(1){if((a|0)!=(c|0)){F[b+c|0]=48;c=c+1|0;continue}break}F[a+b|0]=0;return}F[b+4|0]=I[23733];a=I[23729]|I[23730]<<8|(I[23731]<<16|I[23732]<<24);F[b|0]=a;F[b+1|0]=a>>>8;F[b+2|0]=a>>>16;F[b+3|0]=a>>>24}function lG(a){a=a|0;var b=0,c=0,d=0,e=0,f=0;while(1){if((c|0)==40){while(1){if((e|0)!=6){b=e<<4;d=b+55632|0;c=0;a:{b:{switch(I[b+55637|0]-1|0){case 0:c=a;break a;case 1:break b;default:break a}}c=-1}am(a,H[d>>2],F[b+55636|0],1,c,0,H[b+55640>>2],H[b+55644>>2]);e=e+1|0;continue}break}}else{d=N(c,12);f=d+55152|0;b=0;c:{d:{switch(I[d+55157|0]-1|0){case 0:b=a;break c;case 1:break d;default:break c}}b=-1}am(a,H[f>>2],F[d+55156|0],I[d+55158|0],b,H[d+55160>>2],0,0);c=c+1|0;continue}break}return 0}function dG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-16|0;Ga=d;if((b|0)==2){a:{b:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break b}}Wb(a);break a}b=cb(H[c>>2]);e=cb(H[c+4>>2]);c=d+8|0;fy(b,c);fy(e,d);b=d;while(1){if((g|0)!=4){i=(Ve(c)|0)==(Ve(b)|0);while(1){f=I[c+1|0];e=c+1|0;c=e;if((f&192)==128){continue}break}c=b;while(1){f=I[c+1|0];b=c+1|0;c=b;if((f&192)==128){continue}break}g=g+1|0;h=h+i|0;c=e;continue}break}Hc(a,h)}Ga=d+16|0;return}_(22830,17213,1680,17113);X()}function Ov(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;a:{if((I[a+84|0]|I[a+85|0]<<8|(I[a+86|0]<<16|I[a+87|0]<<24))!=(I[e+8|0]|I[e+9|0]<<8|(I[e+10|0]<<16|I[e+11|0]<<24))|(I[a+88|0]|I[a+89|0]<<8|(I[a+90|0]<<16|I[a+91|0]<<24))!=(I[e+12|0]|I[e+13|0]<<8|(I[e+14|0]<<16|I[e+15|0]<<24))){break a}g=eb(e);if(!g){break a}h=!I[a+65|0];f=a+76|0;tg(h,e,8,f,f);tg(h,d,H[a+36>>2],f,f);if(H[a+76>>2]!=(eb(e+16|0)|0)){break a}if(H[a+80>>2]!=(eb(e+20|0)|0)){break a}H[b>>2]=g;j=c,k=eb(e+4|0),H[j>>2]=k;i=1}return i}function IK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{g=H[b+32>>2];d=H[g>>2];if(!d){break a}c=H[a+24>>2];b=H[c+12>>2];e=b+(d>>31)|0;f=H[c+8>>2];a=d+f|0;e=a>>>0<d>>>0?e+1|0:e;H[c+8>>2]=a;H[c+12>>2]=e;e=Kd(H[c>>2],H[c+16>>2],a<<2,e<<2|a>>>30);if(!e){H[c+8>>2]=0;H[c+12>>2]=0;i=2;break a}H[c+16>>2]=e;d=0;a=0;while(1){c=H[g>>2];h=c>>31;if((h|0)<=(a|0)&c>>>0<=d>>>0|(a|0)>(h|0)){break a}H[e+(f<<2)>>2]=H[(g+(d<<6)|0)+48>>2];c=f+1|0;b=c?b:b+1|0;f=c;d=d+1|0;a=d?a:a+1|0;continue}}return i|0}function Ac(a,b,c,d){var e=0,f=0,g=0;f=Ga-16|0;Ga=f;H[f+12>>2]=0;a:{if(!c){break a}b:{if((b|0)!=155){break b}e=H[c>>2];if(!e){break b}if(Ag(e,f+12|0)){break a}}g=H[c+4>>2]+1|0}e=Tb(a,g+52|0,0);if(e){a=$a(e,0,52);G[a+34>>1]=65535;F[a|0]=b;c:{if(!c){break c}if(!g){b=H[f+12>>2];H[a+8>>2]=b;H[a+4>>2]=b?276826112:545261568;break c}b=a+52|0;H[a+8>>2]=b;g=H[c+4>>2];if(g){Ya(b,H[c>>2],g);c=H[c+4>>2]}else{c=0}F[c+b|0]=0;if(!d|F[I[H[a+8>>2]]+30016|0]>=0){break c}at(a)}H[a+24>>2]=1}Ga=f+16|0;return e}function lv(a,b,c,d){var e=0,f=0,g=0,h=0;f=Ga-16|0;Ga=f;H[f+12>>2]=0;a:{b:{if(!I[a+17|0]){break b}h=H[16164];g=b;while(1){e=g;g=e+1|0;if((g|0)==(Ud(a,g)|0)|(e|0)==((h>>>0)/K[a+36>>2]|0)){continue}break}if(K[a+48>>2]<g>>>0){break b}e=Hj(a,g,f+7|0,f+8|0);if(!(e|I[f+7|0]!=4)){if(H[f+8>>2]!=(b|0)){break b}e=101;break a}g=0;if(e){break a}}g=0;e=xd(a,b,f+12|0,!c<<1);if(e){break a}e=0;g=eb(H[H[f+12>>2]+56>>2])}H[d>>2]=g;a=H[f+12>>2];c:{if(c){H[c>>2]=a;break c}Gb(a)}Ga=f+16|0;return(e|0)==101?0:e}function bx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;a:{if((b|0)<2){break a}e=I[a|0];d=(((N(I[I[(a+b|0)-1|0]+29632|0],3)^I[e+29632|0]<<2^b)>>>0)%127|0)+33488|0;g=e&223;while(1){d=I[d|0];if(!d){break a}b:{e=d-1|0;c:{if(I[e+31264|0]!=(b|0)){break c}f=J[(e<<1)+30960>>1]+30288|0;if(I[f|0]!=(g|0)){break c}d=2;if(I[f+1|0]!=(I[a+1|0]&223)){break c}while(1){if((b|0)==(d|0)){break b}h=a+d|0;i=d+f|0;d=d+1|0;if(I[i|0]==(I[h|0]&223)){continue}break}}d=e+33776|0;continue}break}H[c>>2]=I[e+33616|0]}return b}function hz(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0;d=Ga-16|0;Ga=d;b=H[a+12>>2];e=H[b+40>>2];f=H[b+44>>2];b=Im(a);a:{if(b){break a}b=0;if(K[a+52>>2]<5){break a}c=H[a+48>>2];if(!c|(c|0)==255){break a}H[d+12>>2]=0;c=Ga-16|0;Ga=c;H[c+12>>2]=0;b=Pb(a,36,c+12|0,0);if(!b){b=H[c+12>>2];if((Ab(b)|0)==100){g=Qd(b,0)}b=rb(b)}H[d+12>>2]=g;Ga=c+16|0;c=N(H[d+12>>2],H[a+52>>2]);c=((c|0)/2|0)+c|0;if((c|0)<65){break a}b=gz(a,c,H[a+48>>2])}tf(a);a=H[a+12>>2];H[a+40>>2]=e;H[a+44>>2]=f;Ga=d+16|0;return b|0}function Az(a){var b=0,c=0;c=H[a+48>>2];b=H[a+44>>2]-c|0;b=(b|0)<4096?b:4096;c=lx(H[a+52>>2],c+H[a+40>>2]|0,b,c);a:{if(c){break a}b=b+H[a+48>>2]|0;H[a+48>>2]=b;b=b+H[a+40>>2]|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;F[b+16|0]=0;F[b+17|0]=0;F[b+18|0]=0;F[b+19|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0;F[b+12|0]=0;F[b+13|0]=0;F[b+14|0]=0;F[b+15|0]=0;if(H[a+48>>2]!=H[a+44>>2]){break a}fm(H[a+52>>2]);H[a+48>>2]=0;H[a+52>>2]=0}return c}function $o(a,b){var c=0,d=0;c=I[a+5|0];a:{b:{if(!I[a+15|0]){break b}switch(b-2|0){case 0:case 2:break b;default:break a}}if((b|0)==(c|0)){break a}F[a+5|0]=b;if(!(b&1|(I[a+4|0]|(c&5)!=1))){$c(H[a+68>>2]);if(I[a+18|0]>=2){Pe(H[a>>2],H[a+188>>2],0);break a}b=0;c=I[a+17|0];if(c){d=c}else{b=wv(a);d=I[a+17|0]}if((d|0)==1){b=qg(a,2)}c:{if(b){break c}Pe(H[a>>2],H[a+188>>2],0);if((c|0)!=1){break c}ch(a,1);break a}if(c){break a}Wl(a);break a}if((b|0)!=2){break a}$c(H[a+68>>2])}return I[a+5|0]}function Gg(a){var b=0,c=0,d=0;d=H[a+4>>2];Jb(a);Zq(a,0,0);a:{if(I[a+9|0]){b=H[d+68>>2];H[d+68>>2]=b-1;if((b|0)<=1){b=H[17652];b:{if((d|0)==(b|0)){c=70608}else{while(1){c=b;if(!b){break b}b=H[c+72>>2];if((d|0)!=(b|0)){continue}break}c=c+72|0}H[c>>2]=H[d+72>>2]}c=1}else{c=0}if(!c){break a}}kw(H[d>>2],H[a>>2]);b=H[d+56>>2];c:{if(!b){break c}c=H[d+52>>2];if(!c){break c}Ka[b|0](c)}_a(0,H[d+52>>2]);Gp(d);Wa(d)}b=H[a+28>>2];if(b){H[b+24>>2]=H[a+24>>2]}c=H[a+24>>2];if(c){H[c+28>>2]=b}Wa(a)}function oB(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;j=Ga-16|0;Ga=j;while(1){c=c+1|0;if((c|0)<I[b+48|0]){h=N(c,96)+b|0;if(!H[h+820>>2]){continue}g=H[h+848>>2];if(J[g+46>>1]|(e&H[g>>2]|f&H[g+4>>2])){continue}i=h+768|0;H[h+780>>2]=d;a:{if(F[g+41|0]&1){g=fn(a,H[H[g+52>>2]>>2],i,0,0,Db(a));ob(H[a+8>>2],63,H[h+820>>2],d,g,1);break a}g=J[g+24>>1];i=nB(a,i,0,0,j+12|0);k=H[j+12>>2];Pr(a,i,g,k);_a(H[a>>2],k);ob(H[a+8>>2],63,H[h+820>>2],d,i,g)}H[h+820>>2]=0;H[h+780>>2]=0;continue}break}Ga=j+16|0}function Th(a,b,c){var d=0,e=0,f=0,g=0;d=Ga-48|0;Ga=d;f=H[a>>2];e=7;a:{b:{if(I[f+87|0]){break b}if(H[H[a+4>>2]>>2]){break a}e=H[a+16>>2]&3;if(e){g=H[b+4>>2];b=H[b>>2];H[d+44>>2]=c;H[d+32>>2]=b;H[d+36>>2]=g;H[d+40>>2]=H[(e<<2)+33116>>2];b=tb(f,7200,d+32|0);H[H[a+4>>2]>>2]=b;e=1;break b}if(F[f+32|0]&1){e=ab(134567);break b}b=H[b+4>>2];H[d+16>>2]=b?b:21009;b=tb(f,24324,d+16|0);if(!(!c|!I[c|0])){H[d+4>>2]=c;H[d>>2]=b;b=tb(f,8274,d)}H[H[a+4>>2]>>2]=b;e=ab(134574)}H[a+12>>2]=e}Ga=d+48|0}function Tu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;f=H[b+12>>2];b=f+H[b+16>>2]|0;h=(b|0)<(f|0)?f:b;while(1){if((f|0)!=(h|0)){b=N(f,40)+a|0;e=J[b+16>>1];a:{if(e&36){c=c+H[b+4>>2]|0;e=d+H[b>>2]|0;c=e>>>0<d>>>0?c+1|0:c;d=e;break a}if(e&8){b=ac(b)+d|0;c=c+Ja|0;c=b>>>0<d>>>0?c+1|0:c;d=b;break a}if(!(e&18)){break a}g=H[b+12>>2];d=g+d|0;c=(g>>31)+c|0;c=d>>>0<g>>>0?c+1|0:c;if(!(e&1024)){break a}e=d;d=H[b>>2];b=e+d|0;c=(d>>31)+c|0;c=b>>>0<d>>>0?c+1|0:c;d=b}f=f+1|0;continue}break}Ja=c;return d}function ud(a,b,c,d,e,f){var g=0,h=0,i=0;a:{if(f&64){d=b;e=f+-64|0;b=e&31;if((e&63)>>>0>=32){e=d<<b;d=0}else{e=(1<<b)-1&d>>>32-b|c<<b;d=d<<b}b=0;c=0;break a}if(!f){break a}g=d;d=f&31;if((f&63)>>>0>=32){h=g<<d;i=0}else{h=(1<<d)-1&g>>>32-d|e<<d;i=g<<d}g=b;e=64-f|0;d=e&31;if((e&63)>>>0>=32){e=0;b=c>>>d|0}else{e=c>>>d|0;b=((1<<d)-1&c)<<32-d|g>>>d}d=i|b;e=e|h;b=f&31;if((f&63)>>>0>=32){h=g<<b;b=0}else{h=(1<<b)-1&g>>>32-b|c<<b;b=g<<b}c=h}H[a>>2]=b;H[a+4>>2]=c;H[a+8>>2]=d;H[a+12>>2]=e}function iI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;c=Eb(a,0);if(c){e=H[c+16>>2];g=H[c+20>>2];f=H[c+4>>2];b=0;a=1;a:{while(1){if(!g&a>>>0>=e>>>0){break a}d=I[a+f|0];if(h?1:(d|0)!=44|b){b:{c:{if((d|0)!=92){if((d|0)!=34){break c}b=!b;break b}a=a+1|0;break b}if(b){b=1;break b}b=d&223;h=(((b|0)==91)+h|0)-((b|0)==93)|0;b=0}a=a+1|0;continue}break}d=e-a|0;H[c+16>>2]=d;H[c+20>>2]=g-(a>>>0>e>>>0);b=f+1|0;vd(b,a+b|0,d-1|0);F[H[c+16>>2]+f|0]=0;return}H[c+16>>2]=1;H[c+20>>2]=0}}function YJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;b=Ga-48|0;Ga=b;d=b+24|0;e=nf(H[c>>2]);fd(d,0,0,0,N(H[e+20>>2],100)+100|0);H[b+16>>2]=H[e+(I[e+24|0]?4:8)>>2];H[b+20>>2]=0;vb(d,1827,b+16|0);while(1){if((f|0)<H[e+20>>2]){g=H[H[e+32>>2]+(f<<2)>>2]+1|0;h=H[e+8>>2];c=g+h|0;d=0;d=c>>>0<h>>>0?1:d;c=VK(c-1|0,d-!c|0,g,0);d=Ja;if(!d&(c|0)==2){c=SK(g,0,11,0);c=!Ja&c>>>0<N(h,10)>>>0?2:1;d=0}H[b>>2]=c;H[b+4>>2]=d;vb(b+24|0,1826,b);f=f+1|0;continue}break}xr(a,b+24|0);Ga=b+48|0}function SC(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0;h=Ga-32|0;Ga=h;i=H[a>>2];a:{if(H[a+36>>2]){break a}H[h+28>>2]=0;H[h+20>>2]=0;H[h+24>>2]=0;H[h+12>>2]=0;H[h+16>>2]=0;H[h+4>>2]=0;H[h+8>>2]=0;H[h>>2]=a;if(zr(h,e)){break a}if(zr(h,f)){break a}if(zr(h,g)){break a}if(d){if(cc(a,b,I[d|0]==117?H[d+8>>2]:0,0,0)){break a}}j=zb(a);d=Cc(a,4);oc(a,e,d);oc(a,f,d+1|0);oc(a,g,d+2|0);if(!j){break a}k=a;a=d+3|0;d=F[c|0];Sk(k,0,a-d|0,a,d,c,0);db(j,166,(b|0)==24)}fb(i,e);fb(i,f);fb(i,g);Ga=h+32|0}function XF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}e=Nb(H[c>>2]);H[17665]=0;C(.5);b=x(1)|0;g=x(0)|0;C(+e);c=x(1)|0;x(0)|0;z(0,g|0);z(1,b&2147483647|c&-2147483648);f=+B();C(+e);c=x(1)|0;z(0,x(0)|0);c=c&2147483647;z(1,c|0);d=+B();b=c;a:{if(c>>>0<=1082535489){d=jk(d);if(b>>>0<=1072693247){if(b>>>0<1045430272){break a}e=f*(d+d-d*d/(d+1));break a}e=f*(d+d/(d+1));break a}e=$x(d,f+f)}Zb(a,e);return}_(22968,17213,438,17042);X()}function ZD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;f=Ga-16|0;Ga=f;d=H[a+4>>2];a:{b:{if((b|0)!=36){a=12;if((b|0)!=12){break a}b=H[d+24>>2];e=H[d+4>>2];a=f;H[a+8>>2]=H[d>>2];H[a+12>>2]=e;H[a>>2]=b;h=c,i=Hb(24580,a),H[h>>2]=i;break b}e=H[c+4>>2];a=H[d+4>>2];g=H[c>>2];b=H[d>>2];c:{if((e|0)>=(a|0)&g>>>0>=b>>>0|(a|0)<(e|0)){b=g;a=e;break c}if((e|0)>0|(e|0)>=0){break c}b=H[d+16>>2];a=H[d+20>>2]}H[d+16>>2]=b;H[d+20>>2]=a;H[c>>2]=b;H[c+4>>2]=a}a=0}Ga=f+16|0;return a|0}function VA(a,b){var c=0,d=0,e=0,f=0,g=0;e=J[a+44>>1];c=J[a+46>>1];f=J[b+44>>1];d=J[b+46>>1];a:{if((e-c|0)>=(f-d|0)){break a}b:{if(G[a+20>>1]>G[b+20>>1]){if(G[a+22>>1]>G[b+22>>1]){break a}if(c>>>0>=d>>>0){break b}break a}if(c>>>0<d>>>0){break a}}while(1){if((e|0)>0){c=f;e=e-1|0;d=H[H[a+52>>2]+(e<<2)>>2];if(!d){continue}while(1){if((c|0)<=0){break a}c=c-1|0;if((d|0)!=H[H[b+52>>2]+(c<<2)>>2]){continue}break}continue}break}if(I[b+40|0]&64?0:I[a+40|0]&64){break a}g=1}return g}function Mj(a,b){var c=0,d=0,e=0;c=H[a+12>>2];a:{if(!(b&1)){break a}if(H[c+8>>2]==(a|0)){H[c+8>>2]=H[a+36>>2]}d=H[a+36>>2];b:{c:{e=H[a+32>>2];if(!e){H[c+4>>2]=d;if(!d){break c}break b}H[e+36>>2]=d;d=H[a+36>>2];if(d){break b}H[c>>2]=e;break a}F[c+33|0]=2;H[c>>2]=0;break a}H[d+32>>2]=e}d:{if(!(b&2)){break d}H[a+36>>2]=0;b=H[c>>2];H[a+32>>2]=b;e:{if(b){H[b+36>>2]=a;break e}H[c+4>>2]=a;if(!I[c+32|0]){break e}F[c+33|0]=1}H[c>>2]=a;if(H[c+8>>2]|I[a+28|0]&8){break d}H[c+8>>2]=a}}function ZE(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;e=Ga-16|0;Ga=e;H[e+12>>2]=0;d=-28;g=!b;f=e+12|0;c=H[17682];a:{if(c){while(1){if(H[c>>2]==(a|0)){break a}if(f){H[f>>2]=c}c=H[c+36>>2];if(c){continue}break}}c=0}b:{if(!c|g|H[c+4>>2]!=(b|0)){break b}d=H[e+12>>2];H[(d?d+36|0:70728)>>2]=H[c+36>>2];d=H[c+16>>2];if(!(d&32)){d=va(a|0,b|0,H[c+32>>2],d|0,H[c+12>>2],H[c+24>>2])|0;if(d){break b}}if(H[c+8>>2]){Te(H[c>>2])}d=0;if(I[c+16|0]&32){break b}Te(c)}Ga=e+16|0;return yc(d)|0}function _k(a,b){var c=0,d=0,e=0,f=0,g=0;a:{if(H[a+36>>2]){break a}f=J[b+52>>1];c=H[a>>2];b:{if(I[b+55|0]&8){e=c;c=J[b+50>>1];c=Sg(e,c,f-c|0);break b}c=Sg(c,f,0)}if(!c){break a}while(1){if((d|0)!=(f|0)){g=d<<2;e=H[g+H[b+32>>2]>>2];if((e|0)==32112){e=0}else{e=nj(a,e)}H[(c+g|0)+20>>2]=e;F[H[c+16>>2]+d|0]=I[H[b+28>>2]+d|0];d=d+1|0;continue}break}if(!H[a+36>>2]){return c}d=I[b+55|0]|I[b+56|0]<<8;if(!(d&256)){d=d|256;F[b+55|0]=d;F[b+56|0]=d>>>8;H[a+12>>2]=513}Fj(c)}return 0}function wB(a,b,c,d){var e=0,f=0;a:{if(I[b+4|0]&32){break a}if(Lc(c)){break a}if(!Tr(Uj(H[a>>2],d))){break a}d=0;e=H[a+8>>2];e=(e|0)>0?e:0;while(1){if((d|0)!=(e|0)){f=H[H[a+24>>2]+(d<<3)>>2];if(H[f+28>>2]==H[b+28>>2]&J[f+32>>1]==J[b+32>>1]){break a}d=d+1|0;continue}break}if((Lc(b)|0)==65){H[a+16>>2]=1}d=H[a+8>>2]+1|0;H[a+8>>2]=d;d=Cj(H[H[a>>2]>>2],H[a+24>>2],d<<3,0);H[a+24>>2]=d;if(!d){H[a+8>>2]=0;return}e=d;d=H[a+8>>2]<<3;H[(e+d|0)-8>>2]=b;H[(d+H[a+24>>2]|0)-4>>2]=c}}function GC(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;e=Ga-16|0;Ga=e;f=H[a+8>>2];a:{if(I[b+5|0]&8){a=H[b+8>>2];Va(f,71,c?0-a|0:a,d);break a}b:{g=H[b+8>>2];h=kh(g,e+8|0);if(!(!((c|0)!=0|(h|0)!=3)|(h|0)==2)){i=H[e+8>>2];j=H[e+12>>2];if(!c|(i|(j|0)!=-2147483648)){break b}}if(!Fb(g,1563,2)){H[e+4>>2]=b;H[e>>2]=c?24062:29357;Za(a,18399,e);break a}ts(f,g,c,d);break a}if(c){a=(h|0)==3;H[e+8>>2]=a?0:0-i|0;H[e+12>>2]=a?-2147483648:0-(j+((i|0)!=0)|0)|0}os(f,72,d,e+8|0,-13)}Ga=e+16|0}function dC(a,b,c){var d=0,e=0,f=0,g=0,h=0;d=H[b>>2];while(1){g=I[c+f|0];if(!(!g|!(I[g+30016|0]&6)&(g|0)!=95)){f=f+1|0;continue}break}a:{b:{if(I[c|0]-58>>>0>4294967285){break b}e=Ga-16|0;Ga=e;H[e+12>>2]=59;bx(c,f,e+12|0);Ga=e+16|0;if(H[e+12>>2]!=59|g){break b}g=0;if(f){break a}}F[a+d|0]=34;d=d+1|0;g=1}f=0;while(1){h=c+f|0;e=I[h|0];if(e){F[a+d|0]=e;e=d+1|0;if(I[h|0]!=34){d=e}else{F[a+e|0]=34;d=d+2|0}f=f+1|0;continue}break}if(g){F[a+d|0]=34;d=d+1|0}F[a+d|0]=0;H[b>>2]=d}function Tb(a,b,c){var d=0;a:{b:{c:{if(!c&J[a+308>>1]<b>>>0|c){if(!H[a+304>>2]){H[a+324>>2]=H[a+324>>2]+1;break c}if(!I[a+87|0]){break c}break b}d:{if(!c&b>>>0>128|c){break d}d=H[a+344>>2];if(d){H[a+344>>2]=H[d>>2];break a}d=H[a+340>>2];if(!d){break d}H[a+340>>2]=H[d>>2];break a}d=H[a+336>>2];if(d){H[a+336>>2]=H[d>>2];break a}d=H[a+332>>2];if(d){H[a+332>>2]=H[d>>2];break a}H[a+328>>2]=H[a+328>>2]+1}d=xc(b,c);if(!d){Mb(a)}}return d}H[a+320>>2]=H[a+320>>2]+1;return d}function JG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;b=Ga-16|0;Ga=b;H[b>>2]=0;H[b+4>>2]=0;h=zm(H[c>>2],a,H[c+4>>2],b+12|0);d=H[H[a+20>>2]+64>>2];if(H[b+12>>2]){sk(b+12|0,b);i=H[b+12>>2];j=H[b>>2];k=H[b+4>>2]}l=(d|0)>0?d:0;while(1){if(!(!e&(f|0)==(l|0))){a=H[c+8>>2];H[c+8>>2]=a+1;g=H[c+24>>2]+N(a,24)|0;a=g;H[a+8>>2]=j;H[a+12>>2]=k;H[a>>2]=i;a=d+(f^-1)|0;H[g+16>>2]=a;H[g+20>>2]=a>>31;a=f+1|0;e=a?e:e+1|0;f=a;continue}break}Ga=b+16|0;return h|0}function sb(a,b,c){var d=0;if(!b){b=H[a>>2];a=Tb(b,88,0);a:{if(!a){fb(b,c);break a}H[a>>2]=1;H[a+4>>2]=4;H[a+8>>2]=c;H[a+12>>2]=0;H[a+16>>2]=0;H[a+20>>2]=0}return a}d=H[b>>2];if((d|0)>=H[b+4>>2]){d=H[a>>2];a=H[b+4>>2];H[b+4>>2]=a<<1;a=Kd(d,b,a<<5|8,0);b:{if(!a){qb(d,b);fb(d,c);break b}b=H[a>>2];H[a>>2]=b+1;b=a+(b<<4)|0;H[b+20>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;H[b+8>>2]=c}return a}H[b>>2]=d+1;a=(d<<4)+b|0;H[a+20>>2]=0;H[a+12>>2]=0;H[a+16>>2]=0;H[a+8>>2]=c;return b}function _C(a){var b=0,c=0,d=0,e=0,f=0;c=Ga-16|0;Ga=c;b=H[a+12>>2];if(b){b=H[b+24>>2]}else{b=0}H[c+12>>2]=b;d=H[a+16>>2];a:{if(!d){break a}e=b;b=H[d+24>>2];if((e|0)>=(b|0)){break a}H[c+12>>2]=b}b=H[a+20>>2];b:{if(I[a+5|0]&16){OB(b,c+12|0);break b}if(!b){break b}jn(b,c+12|0);d=0;e=H[a+20>>2];b=H[e>>2];f=(b|0)>0?b:0;b=0;while(1){if((b|0)!=(f|0)){d=H[H[((b<<4)+e|0)+8>>2]+4>>2]|d;b=b+1|0;continue}break}H[a+4>>2]=H[a+4>>2]|d&4194824}H[a+24>>2]=H[c+12>>2]+1;Ga=c+16|0}function Wr(a,b){var c=0,d=0,e=0,f=0;d=H[a+4>>2];c=zb(H[a>>2]);a=d;while(1){if(a){a:{if(!(H[d+88>>2]|!(I[H[a+44>>2]+5|0]&16)|I[a+17|0]==90)){Va(c,75,0,H[a+56>>2]);db(c,31,H[a+60>>2]);Xa(c,94,H[a+60>>2],0,H[a+56>>2]);bb(c,H[c+108>>2]-2|0);break a}if(H[a+64>>2]){break a}e=Jr(a);f=H[a+52>>2];if(b){Va(c,165,f,e);Pc(c,H[a+44>>2],-7);Va(c,80,H[a+52>>2],H[a+56>>2]);Va(c,75,0,H[a+52>>2]);break a}Xa(c,164,f,e,H[a+56>>2]);Pc(c,H[a+44>>2],-7)}a=H[a+36>>2];continue}break}}function pd(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0;h=SK(b,c,h,i);i=Ja;j=h;h=SK(d,e,f,g);e=j+h|0;d=Ja+i|0;i=e;h=i>>>0<h>>>0?d+1|0:d;j=i;k=g;e=0;l=c;d=0;i=SK(g,e,c,d);g=j+i|0;c=Ja+h|0;j=g;g=g>>>0<i>>>0?c+1|0:c;h=f;i=b;f=SK(h,0,i,0);b=Ja;c=0;d=SK(h,c,l,d);b=b+d|0;c=Ja+c|0;c=b>>>0<d>>>0?c+1|0:c;h=c;c=c+j|0;d=g;d=c>>>0<h>>>0?d+1|0:d;h=c;c=d;d=SK(i,m,k,e)+b|0;e=Ja;e=b>>>0>d>>>0?e+1|0:e;g=a;i=e;h=i+h|0;H[g+8>>2]=h;H[g+12>>2]=h>>>0<i>>>0?c+1|0:c;H[g>>2]=f;H[g+4>>2]=d}function Wl(a){var b=0;ug(H[a+60>>2]);H[a+60>>2]=0;Gv(a);b=H[a+232>>2];a:{b:{if(b){qp(b);break b}if(I[a+4|0]){break a}b=H[a+64>>2];c:{d:{if(!H[b>>2]){break d}if(!(fh(b)&2048)){break d}if((I[a+5|0]&5)==1){break c}}$c(H[a+68>>2])}if(!ch(a,0)|I[a+17|0]!=6){break b}F[a+18|0]=5}F[a+17|0]=0}if(H[a+44>>2]){e:{if(!I[a+12|0]){eh(a);F[a+19|0]=0;b=0;break e}b=!H[H[a+68>>2]>>2]}H[a+44>>2]=0;F[a+17|0]=b;Xl(a)}H[a+80>>2]=0;H[a+84>>2]=0;F[a+20|0]=0;H[a+88>>2]=0;H[a+92>>2]=0}function ej(a,b){var c=0,d=0,e=0;a:{c=H[b+16>>2];if(!c){e=H[b+12>>2];c=J[b+52>>1]+1|0;d=c?d:1;c=Uc(0,c,d);H[b+16>>2]=c;if(!c){break a}d=0;while(1){if(d>>>0<J[b+52>>1]){c=J[H[b+4>>2]+(d<<1)>>1];a=c<<16>>16;b:{if((a|0)>=0){c=I[(H[e+4>>2]+N(c,12)|0)+5|0];break b}c=68;if((a|0)==-1){break b}c=Lc(H[(H[b+40>>2]+(d<<4)|0)+8>>2])}a=c<<24>>24;a=(a|0)>65?a:65;F[H[b+16>>2]+d|0]=a>>>0<67?a:67;d=d+1|0;continue}break}F[H[b+16>>2]+d|0]=0;c=H[b+16>>2]}return c}Mb(a);return 0}function Ps(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;e=Ga-16|0;Ga=e;a:{if(H[a+36>>2]|H[b+44>>2]==(0-H[b+32>>2]|0)){break a}f=H[a+8>>2];Xa(f,75,0,H[b+16>>2],H[b+20>>2]);c=H[b+40>>2];while(1){if(H[b+44>>2]<=(g|0)){break a}b:{if(H[c+12>>2]<0){break b}d=H[H[c>>2]+20>>2];if(!(H[d>>2]==1?d:0)){Za(a,2589,0);H[c+12>>2]=-1;break b}d=Bf(a,d,0,0);h=c,i=kb(f,118,H[c+12>>2],0,0,d,-8),H[h+16>>2]=i;H[e>>2]=H[H[c+4>>2]+32>>2];qc(a,0,24821,e)}c=c+20|0;g=g+1|0;continue}}Ga=e+16|0}function Jd(a,b,c,d,e){var f=0,g=0,h=0,i=0;g=Ga-16|0;Ga=g;a:{if(H[e>>2]){break a}if(!b){h=e,i=ab(67862),H[h>>2]=i;break a}f=H[a>>2];a=Ud(a,b);f=sd(f,a,g+12|0,0);if(f){H[e>>2]=f;break a}f=H[g+12>>2];b:{if(I[H[f+8>>2]]){h=e,i=ab(67875),H[h>>2]=i;break b}a=N((a^-1)+b|0,5);if((a|0)<0){h=e,i=ab(67880),H[h>>2]=i;break b}a=a+H[f+4>>2]|0;if(I[a|0]==(c|0)){if((eb(a+1|0)|0)==(d|0)){break b}}b=_b(f);H[e>>2]=b;if(b){break b}F[a|0]=c;Cb(a+1|0,d)}rd(H[g+12>>2])}Ga=g+16|0}function rs(a,b,c,d,e){var f=0,g=0,h=0,i=0;f=Ga-176|0;Ga=f;H[f+4>>2]=0;h=H[a>>2];$a(f- -64|0,0,52);$a(f+8|0,0,52);$a(f+120|0,0,52);g=nb(h,H[b+12>>2],0);if(!I[h+87|0]){F[f+120|0]=44;H[f+76>>2]=g;F[f+64|0]=57;H[f+136>>2]=f+8;H[f+132>>2]=f- -64;b=H[b+20>>2];i=H[b+8>>2];H[f+20>>2]=g;F[f+8|0]=55;H[f+80>>2]=i;H[f+24>>2]=H[b+24>>2];EC(g,qs(a,g,f+4|0));a:{if(d){Ka[d|0](a,f+120|0,c,e);break a}H[g+4>>2]=H[g+4>>2]|1;Ke(a,f+120|0,c)}xb(a,H[f+4>>2])}fb(h,g);Ga=f+176|0}function aw(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;g=H[a+20>>2];if(K[a+16>>2]>b>>>0&(g|0)>=(c|0)|(c|0)<(g|0)){a:{b:{if(!(b|c)){d=a+12|0;break b}d=a+12|0;e=H[a+4>>2];g=e>>31;h=e;f=g;while(1){d=H[d>>2];if(d){i=b>>>0>h>>>0&(c|0)>=(f|0)|(c|0)>(f|0);f=f+g|0;h=e+h|0;f=e>>>0>h>>>0?f+1|0:f;if(i){continue}}break}e=d;if(d){break b}e=0;break a}vp(H[d>>2]);H[d>>2]=0}H[a+16>>2]=b;H[a+20>>2]=c;H[a+32>>2]=0;H[a+36>>2]=0;H[a+40>>2]=0;H[a+24>>2]=e}return 0}function Vm(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ga-16|0;H[e+12>>2]=c;while(1){j=I[b+1|0]-48|0;c=I[b|0]-48|0;g=(c&255)+a|0;k=J[(F[b+2|0]<<1)+50282>>1];f=I[b+3|0];d=0;a:{while(1){if(c&255){h=I[a|0];if(h-58>>>0<4294967286){break a}c=c-1|0;a=a+1|0;d=(N(d,10)+(h<<24>>24)|0)-48|0;continue}break}if(j<<24>>24>(d|0)|(d|0)>(k|0)|(I[g|0]!=(f|0)?f:0)){break a}a=H[e+12>>2];H[e+12>>2]=a+4;H[H[a>>2]>>2]=d;b=b+4|0;i=i+1|0;a=g+1|0;if(f){continue}}break}return i}function ov(a){var b=0,c=0,d=0,e=0;if(I[a+69|0]){d=a,e=Kl(a),H[d+56>>2]=e;H[a+60>>2]=Ja;return 0}c=Ai(a);H[a+56>>2]=c;H[a+60>>2]=0;c=c+17|0;b=c>>>0<17?1:b;c=xc(c,b);if(!c){return 7}b=nv(a,0,H[a+56>>2],c);if(!b){b=H[a+56>>2]+c|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;F[b+16|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0;F[b+12|0]=0;F[b+13|0]=0;F[b+14|0]=0;F[b+15|0]=0;H[a+16>>2]=c;return 0}Wa(c);return b}function NA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=H[c>>2];H[d>>2]=e;a:{f=e>>31;if(e-1&e|f&f-!e){a=b;break a}a=Kd(a,b,(g=SK(e,f,40,0),h=20,i=e,i?g:h),e?Ja:0);if(a){break a}H[d>>2]=-1;return b}b=N(e,20)+a|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;F[b+16|0]=0;F[b+17|0]=0;F[b+18|0]=0;F[b+19|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0;F[b+12|0]=0;F[b+13|0]=0;F[b+14|0]=0;F[b+15|0]=0;H[c>>2]=H[c>>2]+1;return a}function uD(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;h=Ga-16|0;Ga=h;i=I[c|0];k=I[e|0];g=F[c+1|0];H[h+12>>2]=g&255;if((g|0)<0){$d(c+1|0,h+12|0)}j=F[e+1|0];g=j&255;H[h+8>>2]=g;if((j|0)<0){$d(e+1|0,h+8|0);g=H[h+8>>2]}j=H[H[a+8>>2]+28>>2];l=c+i|0;i=H[h+12>>2];k=Ob(l,e+k|0,(((g|0)>(i|0)?i:g)-13|0)/2|0);g=k?k:i-g|0;a:{if(!g){g=0;if(J[j+6>>1]<2){break a}g=Tt(a,b,c,d,e,f);break a}g=I[H[j+16>>2]]?0-g|0:g}Ga=h+16|0;return g|0}function ZG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;a:{b:{c:{d:{e:{f:{e=H[a>>2];d=H[e+24>>2];switch(c-d|0){case 2:break d;case 1:break e;case 0:break f;default:break c}}b=H[b>>2];hd(b);G[b+16>>1]=1;Ex(b,a,8463,0);return 0}ec(b,H[a+32>>2],H[a+36>>2]);break b}if(H[a+16>>2]){a=H[a+20>>2];ec(b,a,a>>31);break b}c=d;if(H[e+44>>2]){break c}Hc(b,0);return 0}d=Jm(0,a);if(d){break a}a=H[a+12>>2];if((zx(a)-1|0)<=(c|0)){break b}ae(b,yx(a,c+1|0))}d=0}return d|0}function sw(a,b){var c=0,d=0,e=0;c=Ga-48|0;Ga=c;H[c+32>>2]=1;H[c+36>>2]=0;H[c+24>>2]=128;H[c+28>>2]=0;H[c+16>>2]=1;e=H[b+12>>2];H[c>>2]=c+16;d=3850;a:{if(Ka[H[16190]](e,5,c)|0){break a}d=5;b:{c:{switch(J[c+16>>1]-1|0){case 0:break a;case 1:break c;default:break b}}if(I[b+22|0]){F[b+23|0]=1;d=1288;break a}d=Nj(a,1,128,1);if(d){break a}if(!xw(H[b+12>>2],3,0)){break b}d=4618;Td(4618,12471,H[b+8>>2],40015);break a}d=Nj(a,0,128,1)}Ga=c+48|0;return d}function ld(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=Ga-32|0;Ga=c;a:{if(!b){break a}f=H[a+24>>2];H[a+24>>2]=f&-134254609;d=H[a>>2];H[c+24>>2]=a;H[c+4>>2]=55;H[c>>2]=d;H[c+12>>2]=0;H[c+8>>2]=f&524288?0:56;e=H[d+216>>2]+H[b+24>>2]|0;H[d+216>>2]=e;g=1;if(dl(d,e)){break a}Kb(c,b);d=H[c>>2];H[d+216>>2]=H[d+216>>2]-H[b+24>>2];e=b;h=H[b+4>>2];b=H[a+24>>2];H[e+4>>2]=h|b&32784;H[a+24>>2]=b|f&134254608;if(H[a+20>>2]>0){break a}g=H[d+36>>2]>0}Ga=c+32|0;return g}function Wt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c=b+c|0;l=(b|0)>(c|0)?b:c;f=H[a+56>>2];i=f+H[H[a+52>>2]+40>>2]|0;m=((I[a+9|0]+I[a+10|0]|0)+f|0)+8|0;while(1){if((b|0)!=(l|0)){g=H[H[d+8>>2]+(b<<2)>>2];if(!(m>>>0>g>>>0|g>>>0>=i>>>0)){c=J[H[d+12>>2]+(b<<1)>>1];j=g+c|0;a:{if((j|0)!=(e|0)){if(e){Fo(a,e-f&65535,h&65535)}if(i>>>0>=j>>>0){break a}return 0}c=c+h|0}k=k+1|0;e=g;h=c}b=b+1|0;continue}break}if(e){Fo(a,e-f&65535,h&65535)}return k}function Bv(a,b){var c=0,d=0;d=b>>>3|0;F[a+8|0]=d;F[a+10|0]=4-(d<<2);c=H[a+52>>2];a:{b:{switch((b&-9)-2|0){case 0:H[a+80>>2]=19;H[a+76>>2]=20;F[a+1|0]=0;F[a+2|0]=0;G[a+14>>1]=J[c+26>>1];b=c+28|0;break a;default:H[a+80>>2]=19;H[a+76>>2]=20;F[a+1|0]=0;F[a+2|0]=0;return ab(68811);case 3:break b}}F[a+1|0]=1;b=d&255;H[a+80>>2]=b?21:22;H[a+76>>2]=b?23:24;F[a+2|0]=(b|0)!=0;G[a+14>>1]=J[c+30>>1];b=c+32|0}G[a+16>>1]=J[b>>1];F[a+11|0]=I[c+21|0];return 0}function Oi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=H[a+12>>2];c=H[a+8>>2];f=d<<1|c>>>31;g=b;e=c+b|0;b=d;b=c>>>0>e>>>0?b+1|0:b;e=e+10|0;b=e>>>0<10?b+1|0:b;h=c<<1;c=!d&c>>>0>g>>>0|(d|0)!=0;d=c?h:e;c=c?f:b;a:{b:{c:{if(I[a+24|0]){b=1;if(I[a+25|0]){break b}b=Ib(d,c);if(!b){break a}b=Ya(b,H[a+4>>2],H[a+16>>2]);F[a+24|0]=0;break c}b=ye(H[a+4>>2],d,c);if(!b){break a}}H[a+4>>2]=b;H[a+8>>2]=d;H[a+12>>2]=c;b=0}return b}F[a+25|0]=1;ic(H[a>>2]);Bk(a);return 7}function rA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Ga+-64|0;Ga=d;if(!Si(a,b,c,d+16|0)){qA(d+16|0);F[d+2|0]=58;F[d+5|0]=58;F[d+8|0]=0;b=H[d+36>>2];c=(b|0)/10|0;F[d|0]=((c|0)%10|0)+48;e=H[d+40>>2];f=(e|0)/10|0;F[d+3|0]=((f|0)%10|0)+48;F[d+1|0]=(b-N(c,10)|0)+48;F[d+4|0]=(e-N(f,10)|0)+48;g=M[d+48>>3];a:{if(P(g)<2147483648){b=~~g;break a}b=-2147483648}c=(b|0)/10|0;F[d+6|0]=((c|0)%10|0)+48;F[d+7|0]=(b-N(c,10)|0)+48;wb(a,d,8,-1)}Ga=d- -64|0}function Dj(a,b,c){var d=0,e=0,f=0,g=0,h=0;a:{b:{if(!H[a+404>>2]){break b}h=c+1|0;while(1){if(f){break a}if(H[a+380>>2]<=(g|0)){break b}f=0;e=H[H[a+404>>2]+(g<<2)>>2];c:{if(!H[e+8>>2]){break c}d=H[H[e+4>>2]>>2];if(H[d>>2]<2){break c}Wp(e);d:{e:{switch(b|0){case 0:d=H[d+80>>2];H[e+20>>2]=h;break d;case 2:d=H[d+88>>2];break d;default:break e}}d=H[d+84>>2]}if(!(!d|H[e+20>>2]<=(c|0))){f=Ka[d|0](H[e+8>>2],c)|0}bh(e)}g=g+1|0;continue}}f=0}return f}function $k(a,b,c){var d=0,e=0,f=0;f=(b|0)<0;while(1){a:{if(a){d=H[a+4>>2];b:{if(!f&(!(d&1)|H[a+36>>2]!=(b|0))){break b}d=d&-4;H[a+4>>2]=d;if(f){break b}d=d|2;H[a+4>>2]=d}e=I[a|0];if((e|0)!=172){if((e|0)!=167|c|H[a+28>>2]!=(b|0)){break a}H[a+4>>2]=d&-2097153;break a}d=0;e=H[a+20>>2];if(!e){break a}while(1){if(H[e>>2]<=(d|0)){break a}$k(H[((d<<4)+e|0)+8>>2],b,c);d=d+1|0;e=H[a+20>>2];continue}}return}$k(H[a+12>>2],b,c);a=H[a+16>>2];continue}}function kv(a){var b=0,c=0,d=0,e=0,f=0,g=0;c=Ga-16|0;Ga=c;e=H[a+4>>2];f=H[a+52>>2];a:{b:{if(I[a|0]){H[c+12>>2]=0;break b}b=si(a);H[c+12>>2]=b;if(b){break a}}g=J[a+24>>1];b=0;while(1){if((b|0)!=(g|0)){d=H[a+64>>2]+(b<<1)|0;d=H[a+56>>2]+(J[a+26>>1]&(I[d|0]<<8|I[d+1|0]))|0;Hl(a,a,d,c+12|0);if(!I[a+8|0]){Jd(f,eb(d),5,e,c+12|0)}b=b+1|0;continue}break}if(!I[a+8|0]){Jd(f,eb((I[a+9|0]+H[a+56>>2]|0)+8|0),5,e,c+12|0)}b=H[c+12>>2]}Ga=c+16|0;return b}function _B(a,b,c,d,e){var f=0,g=0;f=Ga+-64|0;Ga=f;g=H[a>>2];c=nb(g,H[((c<<4)+b|0)+8>>2],0);a:{if(I[g+87|0]){fb(g,c);break a}b=Ga-32|0;Ga=b;if((e|0)>0){H[b+16>>2]=0;H[b+20>>2]=0;H[b+8>>2]=0;H[b+12>>2]=0;H[b>>2]=0;H[b+4>>2]=0;H[b+24>>2]=e;H[b+4>>2]=70;Kb(b,c)}Ga=b+32|0;if(I[d|0]==113){c=Yi(a,c,H[d+8>>2])}b=f+8|0;Ya(b,c,52);c=Ya(c,d,52);b=Ya(d,b,52);b:{if(!(F[b+7|0]&1)){break b}d=H[b+44>>2];if(!d){break b}H[d+72>>2]=b}we(a,69,c)}Ga=f- -64|0}function PH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=N(H[17641],52)+68|0;d=Ad(d,d>>31);if(d){if(H[17641]){H[d+80>>2]=10;e=d+68|0}else{e=70508}if(!J[e+34>>1]){G[e+34>>1]=1;f=e+20|0;H[e+48>>2]=f;H[e+44>>2]=f}H[d+12>>2]=b;H[d+8>>2]=a;H[d>>2]=e;H[d+20>>2]=(c|0)!=0;H[d+16>>2]=(a+b|0)+32;Yz(d);a:{if(c){H[d+24>>2]=10;a=H[e+8>>2];H[e+8>>2]=a+10;H[e+12>>2]=H[e+4>>2]-a;a=e+16|0;break a}a=d+40|0}H[d+4>>2]=a;if(H[d+52>>2]){return d|0}Xz(d)}return 0}function zg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;d=H[a+108>>2];a:{if(H[a+112>>2]<(d+b|0)){if(nx(a)){break a}d=H[a+108>>2]}i=(b|0)>0?b:0;f=H[a+104>>2]+N(d,20)|0;d=f;while(1){if((g|0)!=(i|0)){h=I[c|0];F[d|0]=h;H[d+4>>2]=F[c+1|0];e=F[c+2|0];H[d+8>>2]=e;if(!(!(F[h+33936|0]&1)|(e|0)<=0)){H[d+8>>2]=e+H[a+108>>2]}e=F[c+3|0];H[d+16>>2]=0;F[d+1|0]=0;H[d+12>>2]=e;G[d+2>>1]=0;d=d+20|0;c=c+4|0;g=g+1|0;continue}break}H[a+108>>2]=H[a+108>>2]+b}return f}function Yx(a,b){var c=0,d=0;a:{d=b&255;if(d){if(a&3){while(1){c=I[a|0];if(!c|(c|0)==(b&255)){break a}a=a+1|0;if(a&3){continue}break}}c=H[a>>2];b:{if((c^-1)&c-16843009&-2139062144){break b}d=N(d,16843009);while(1){c=c^d;if((c^-1)&c-16843009&-2139062144){break b}c=H[a+4>>2];a=a+4|0;if(!(c-16843009&(c^-1)&-2139062144)){continue}break}}while(1){c=a;d=I[c|0];if(d){a=c+1|0;if((d|0)!=(b&255)){continue}}break}return c}return ub(a)+a|0}return a}function Im(a){var b=0,c=0,d=0;d=Ga-16|0;Ga=d;a:{b:{while(1){if(b){break b}if(H[a+256>>2]>(c|0)){b=Lq(a,H[a+280>>2],c,-1);b=(b|0)==101?0:b;c=c+1|0;continue}break}wk(a);b=0;if(!H[a+52>>2]|(!I[a+237|0]|H[a+48>>2]!=255)){break a}c=0;H[d+12>>2]=0;b=Pb(a,22,d+12|0,0);if(b){break a}b=H[d+12>>2];wc(b,1,2);c:{switch(Ab(b)-100|0){case 0:c=Qd(b,0);c=(c|0)==1?8:c;case 1:H[a+48>>2]=c;break;default:break c}}b=rb(b);break a}wk(a)}Ga=d+16|0;return b}function gJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;a:{if((gb(H[c>>2])|0)==5){break a}a=Eb(a,36);if(!a){break a}cb(H[c>>2]);c=bc(H[c>>2]);d=H[a+24>>2];H[a+24>>2]=d-1;b=H[a+32>>2];b:{if(b){if((d|0)<2){break b}e=H[b>>2];vd(b,b+4|0,(d<<2)-8|0);c=c+e|0;break b}c=H[a+28>>2]+c|0}b=H[a+16>>2];c:{if((b|0)<=(c|0)){H[a+16>>2]=0;break c}b=b-c|0;H[a+16>>2]=b;d=H[a+4>>2];vd(d,c+d|0,b);if(H[a+16>>2]){break a}}H[a+12>>2]=0;Wa(H[a+32>>2]);H[a+32>>2]=0}}function jt(a,b,c){var d=0,e=0,f=0,g=0;f=Ga-16|0;Ga=f;e=H[a>>2];a:{if(kf(a)){break a}if(!b){RC(a,0);break a}if(!(H[c>>2]?c:0)){d=vc(H[a>>2],b);if(!d){break a}if(Pf(e,I[e+84|0],d,0)){RC(a,d);_a(e,d);break a}_a(e,d)}c=ig(a,b,c,f+12|0);if((c|0)<0){break a}b=vc(e,H[f+12>>2]);if(!b){break a}d=H[H[e+16>>2]+(c<<4)>>2];g=Dc(e,b,d);if(g){QC(a,g,0);_a(e,b);break a}d=Ff(e,b,d);_a(e,b);if(d){Gd(a,0,c);_n(a,d,-1);break a}Za(a,14479,0)}Ga=f+16|0}function Es(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ga-16|0;Ga=g;j=H[a+8>>2];if(I[b+28|0]&128){k=tc(b)}b=b+8|0;h=-1;while(1){b=H[b>>2];if(b){a:{b:{if(e){if(!H[(i<<2)+e>>2]){break a}if((b|0)!=(k|0)){break b}break a}if((b|0)==(k|0)){break a}}l=d+i|0;if((l|0)==(f|0)){break a}h=Gn(a,b,c,0,1,g+12|0,m,h);Xa(j,140,l,h,J[b+((I[b+55|0]|I[b+56|0]<<8)&8?50:52)>>1]);pb(j,1);ys(a,H[g+12>>2]);m=b}b=b+20|0;i=i+1|0;continue}break}Ga=g+16|0}function vj(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=Ga+-64|0;Ga=e;f=H[a>>2];g=H[a+236>>2];a:{if(!g){break a}h=H[g+4>>2]+N(G[g+34>>1]-1|0,12)|0;if(!Jn(b,(I[f+177|0]?I[f+176|0]!=1:0)+4|0,0)){H[e>>2]=H[h>>2];Za(a,2742,e);break a}if(I[h+10|0]&96){Za(a,10478,0);break a}i=e+8|0;$a(i,0,52);F[e+8|0]=181;c=co(f,c,d);H[e+20>>2]=b;H[e+16>>2]=c;H[e+12>>2]=8192;c=nb(f,i,1);_a(f,H[e+16>>2]);fo(a,g,h,c)}if(I[a+208|0]>=2){bo(a,b)}fb(f,b);Ga=e- -64|0}function hy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=-1;f=-1;a:{if(He()){break a}e=H[17526];f=H[17527];if((b|0)<0){break a}c=H[17528];d=H[17529];g=(d|0)<=(b|0)&a>>>0>c>>>0|(b|0)>(d|0);h=!(a|b);i=h?c:g?c:a;j=a;a=!!c&(d|0)>=0|(d|0)>0;c=a?i:j;H[17526]=c;a=a?h?d:g?d:b:b;H[17527]=a;H[17530]=((a|0)<=0&K[17502]>=c>>>0|(a|0)<0)&(a|c)!=0;a=Ga-16|0;Ga=a;H[a+8>>2]=H[17502];H[a+12>>2]=0;H[a>>2]=H[17512];H[a+4>>2]=0;Ga=a+16|0}Ja=f;return e}function fi(a,b,c){var d=0,e=0,f=0;d=Ga-128|0;Ga=d;e=b|524288;f=c?c:420;a:{b:{while(1){b=Ka[H[16169]](a,e,f)|0;if((b|0)<0){if(H[17665]==27){continue}break a}if(b>>>0>2){break b}Ka[H[16172]](b)|0;H[d+4>>2]=b;H[d>>2]=a;Fc(28,16321,d);if((Ka[H[16169]](11016,0,c)|0)>=0){continue}break}b=-1;break a}if(!c){break a}if(Ka[H[16184]](b,d+16|0)|(H[d+56>>2]|H[d+60>>2])|(H[d+28>>2]&511)==(c|0)){break a}Ka[H[16211]](b,c)|0}Ga=d+128|0;return b}function RA(a,b){var c=0,d=0,e=0;d=1;a:{if((b|0)==65){break a}b:{while(1){c:{d:{c=I[a|0];switch(c-173|0){case 3:break c;case 0:case 1:break d;default:break b}}e=(c|0)==173?1:e;a=H[a+12>>2];continue}break}c=I[a+2|0]}e:{f:{g:{switch(c-153|0){default:if((c|0)==117){break f}d=0;if((c|0)!=167|(b|0)<67){break a}return J[a+32>>1]>>>15|0;case 2:return(b|0)>66;case 1:break e;case 0:break g}}return(b|0)>66}return!e&(b|0)==66}d=!e}return d}function ut(a){var b=0,c=0,d=0,e=0,f=0,g=0;a:{if(!a){break a}c=H[a>>2];if((c|0)<2){break a}e=a+8|0;b=c;while(1){f=b-1|0;d=I[((b<<6)+e|0)-92|0];F[((f<<6)+e|0)+36|0]=d;g=d|g&255;d=b>>>0>2;b=f;if(d){continue}break}F[a+44|0]=0;if(!(g&16)){break a}while(1){b:{b=c;if((b|0)<2){b=1;break b}c=b-1|0;if(!(I[((c<<6)+a|0)+44|0]&16)){continue}}break}b=b-2|0;while(1){c=(b<<6)+a|0;F[c+44|0]=I[c+44|0]|64;c=(b|0)>0;b=b-1|0;if(c){continue}break}}}function cf(a,b,c){var d=0,e=0,f=0,g=0,h=0;e=H[c+4>>2];d=Tb(H[a>>2],e+53|0,0);a:{if(!d){break a}H[d+4>>2]=8388608;F[d|0]=b;H[d+40>>2]=0;H[d+12>>2]=0;H[d+16>>2]=0;H[d+44>>2]=0;H[d+48>>2]=0;H[d+20>>2]=0;G[d+32>>1]=0;H[d+28>>2]=0;F[d+1|0]=0;F[d+2|0]=0;b=d+52|0;H[d+8>>2]=b;f=b;b=H[c>>2];g=Ya(f,b,e)+e|0,h=0,F[g|0]=h;H[d+36>>2]=b-H[a+232>>2];if(F[I[H[d+8>>2]]+30016|0]<0){at(d)}H[d+24>>2]=1;if(I[a+208|0]<2){break a}Ne(a,d,c)}return d}function GF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;if((b|0)==1){if((gb(H[c>>2])|0)==5){Wb(a);return}d=cb(H[c>>2]);b=ub(d);e=Ub(b+1|0);if(!e){ic(a);return}b=b+e|0;F[b|0]=0;g=b-1|0;a:while(1){b=d;if(Ve(b)){while(1){c=1;f=I[b+1|0];b=b+1|0;if((f&192)==128){continue}break}while(1){f=b-c|0;if(f>>>0<d>>>0){d=b;continue a}else{F[g|0]=I[f|0];c=c+1|0;g=g-1|0;continue}}}break}wb(a,e,-1,-1);Wa(e);return}_(17180,17213,1323,17081);X()}function At(a,b,c,d){var e=0,f=0,g=0;f=Ga-16|0;Ga=f;e=H[a>>2];a:{b:{g=H[a+236>>2];if(!g|I[a+208|0]==1){break b}if(Ew(H[(H[e+16>>2]+(I[e+176|0]<<4)|0)+4>>2])){break b}e=sb(a,H[g+16>>2],b);H[g+16>>2]=e;if(H[a+76>>2]){Wg(a,e,a+72|0,1);break a}while(1){b=I[c+1|0];c=c+1|0;if(F[b+30016|0]&1){continue}break}while(1){b=d;d=b-1|0;if(F[I[d|0]+30016|0]&1){continue}break}H[f+8>>2]=c;H[f+12>>2]=b-c;Wg(a,e,f+8|0,1);break a}fb(e,b)}Ga=f+16|0}function xv(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=H[d>>2];l=H[e>>2];while(1){if(!((c|0)<=(g|0)&(h|0)>=(l|0))){a:{if(!((h|0)<(l|0)&K[(J[(g<<1)+b>>1]<<2)+a>>2]>=K[(J[(h<<1)+k>>1]<<2)+a>>2]|(c|0)<=(g|0))){i=(g<<1)+b|0;g=g+1|0;break a}i=(h<<1)+k|0;h=h+1|0}i=J[i>>1];m=H[(i<<2)+a>>2];G[(j<<1)+f>>1]=i;j=j+1|0;if((c|0)<=(g|0)){continue}g=(H[(J[(g<<1)+b>>1]<<2)+a>>2]==(m|0))+g|0;continue}break}H[d>>2]=b;H[e>>2]=j;Ya(b,f,j<<1)}function Zu(a){var b=0,c=0,d=0;b=J[a+16>>1];c=b&44;if(!c){if(!(b&18)){return 0}b=Ga-16|0;Ga=b;a:{b:{if(I[a+17|0]&4){c=0;if(Ce(a)){break b}}d=Yd(H[a+8>>2],a,H[a+12>>2],I[a+18|0]);c:{if((d|0)<=0){c=8;if(d){break a}if((jh(H[a+8>>2],b+8|0,H[a+12>>2],I[a+18|0])|0)<=1){break c}break a}c=8;if((d|0)!=1){break a}if(jh(H[a+8>>2],b+8|0,H[a+12>>2],I[a+18|0])){break a}}d=H[b+12>>2];c=H[b+8>>2]}H[a>>2]=c;H[a+4>>2]=d;c=4}Ga=b+16|0}return c}function ul(a,b,c,d,e){var f=0,g=0;f=Ga-16|0;Ga=f;a:{b:{if(K[a+48>>2]<b>>>0){e=ab(69130);break b}e=sd(H[a>>2],b,f+12|0,e);if(e){break b}e=H[f+12>>2];g=H[e+8>>2];H[c>>2]=g;c:{if(!I[g|0]){gp(e,b,a);e=si(H[c>>2]);if(e){break c}}e=0;if(!d){break a}a=H[c>>2];if(I[a+1|0]==I[d+69|0]?J[a+24>>1]:0){break a}e=ab(69151)}Gb(H[c>>2])}if(!d){break a}a=I[d+68|0]-1|0;F[d+68|0]=a;H[d+116>>2]=H[((a<<24>>24<<2)+d|0)+120>>2]}Ga=f+16|0;return e}function ND(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;d=I[a+10|0]+b|0;c=F[d|0];e=c&255;a:{if((c|0)>=0){f=d;break a}e=e&127;c=0;while(1){h=c+1|0;f=d+h|0;g=F[f|0];e=g&127|e<<7;if((g|0)>=0){break a}g=c>>>0<7;c=h;if(g){continue}break}}c=f+1|0;f=J[a+14>>1];b:{if(f>>>0>=e>>>0){a=c+(e-b|0)|0;a=a>>>0>4?a:4;break b}d=J[a+16>>1];a=((e-d>>>0)%(H[H[a+52>>2]+40>>2]-4>>>0)|0)+d|0;a=((c-b&65535)+(a>>>0>f>>>0?d:a)|0)+4|0}return a&65535}function $A(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;a:{if(b&64){break a}e=H[H[c>>2]>>2];while(1){if(I[d|0]==44){if(!$A(a,b,c,H[d+12>>2])){break a}d=H[d+16>>2];continue}break}g=I[H[e>>2]+34|0]&128?0:e;h=b&32;b=H[c+24>>2];e=0;while(1){if(H[c+12>>2]<=(e|0)){break a}b:{f=H[b>>2];c:{if(F[f+4|0]&1){if(H[f+36>>2]==(a|0)){break c}break b}if(h){break b}}if(!yn(g,f,d,a)|I[b+10|0]&128){break b}i=1;break a}b=b+48|0;e=e+1|0;continue}}return i}function IF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;if((b|0)==2){a:{if((gb(H[c>>2])|0)!=5){if((gb(H[c+4>>2])|0)!=5){break a}}Wb(a);return}b=cb(H[c>>2]);c=ac(H[c+4>>2]);e=(c|0)>0?c:0;c=b;while(1){if(!(!Ve(c)|(d|0)==(e|0))){d=d+1|0;while(1){f=I[c+1|0];c=c+1|0;if((f&192)==128){continue}break}continue}break}c=c-b|0;d=Ub(c+1|0);if(!d){ic(a);return}b=Tx(d,b,c);F[b+c|0]=0;wb(a,b,-1,-1);Wa(b);return}_(22830,17213,1073,16897);X()}function an(a,b){var c=0,d=0,e=0,f=0,g=0;d=Ga-16|0;Ga=d;f=H[a>>2];g=Xb(f,H[b+12>>2]);a:{b:{c:{e=Rd(a,0,0,0);if(e){c=H[H[b+4>>2]+20>>2];H[e+16>>2]=g;if((c|0)!=H[H[f+16>>2]+28>>2]){H[e+8>>2]=c}c=H[b+16>>2];if(!c){c=e;break a}c=aj(f,c,0);b=0;if(!c){break b}if(H[c>>2]<2|I[a+208|0]>1){break c}b=Hd(a,0,c,0,0,0,0,2048,0);H[d+8>>2]=0;H[d+12>>2]=0;b=bf(a,0,0,0,d+8|0,b,0);break b}_a(f,g);break a}b=c}c=rt(a,e,b)}Ga=d+16|0;return c}function Kd(a,b,c,d){var e=0;if(!b){return Tb(a,c,d)}a:{b:{if(K[a+356>>2]<=b>>>0){break b}if(K[a+348>>2]<=b>>>0){if(!d&c>>>0>=129|d){break b}break a}if(K[a+352>>2]>b>>>0){break b}if(!d&c>>>0<=J[a+310>>1]){break a}}c:{d:{if(I[a+87|0]){break d}if(K[a+352>>2]<=b>>>0&K[a+356>>2]>b>>>0){c=Tb(a,c,d);if(!c){break d}c=Ya(c,b,K[a+348>>2]>b>>>0?J[a+310>>1]:128);_a(a,b);b=c;break c}e=Zd(b,c,d);if(e){break d}Mb(a);e=0}b=e}}return b}function Dl(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;f=H[a>>2];e=H[a+4>>2];a:{b:{if((c|0)>0|(c|0)>=0){if(!f&(e|0)<=0|(e|0)<0){break b}h=1;d=e^2147483647;if((c|0)==(d|0)&b>>>0<=(f^-1)>>>0|c>>>0<d>>>0){break b}break a}if((e|0)>0|(e|0)>=0){break b}h=1;d=c;g=b+1|0;d=g?d:d+1|0;i=1-f>>>0>g>>>0;g=-2147483648-(e+(f>>>0>1)|0)|0;if(i&(g|0)>=(d|0)|(d|0)<(g|0)){break a}}d=b+f|0;b=c+e|0;H[a>>2]=d;H[a+4>>2]=d>>>0<f>>>0?b+1|0:b;h=0}return h}function KF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;a:{if((b|0)!=2){break a}if((gb(H[c>>2])|0)==5){break a}h=ac(H[c+4>>2]);b=Ja;i=b;if((b|0)<0){fc(a,8512,-1);return}e=bc(H[c>>2]);d=Ub(N(h,e)+1|0);b=Ub(e+1|0);if(!(b?d:0)){ic(a);if(d){Wa(d)}if(!b){break a}Wa(b);return}c=sh(b,cb(H[c>>2]));while(1){if((f|0)!=(h|0)|(g|0)!=(i|0)){sh(d+N(f,e)|0,c);b=f+1|0;g=b?g:g+1|0;f=b;continue}break}wb(a,d,-1,-1);Wa(d);Wa(c)}}function Gi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;Md();Se(a);c=F[a+24|0]&1?!I[a+177|0]:c;g=!c;while(1){if((d|0)<H[a+20>>2]){e=H[(H[a+16>>2]+(d<<4)|0)+4>>2];if(e){h=Pg(e);Zq(e,b,g);f=(h|0)==2?1:f}d=d+1|0;continue}break}Yw(a);Ld();if(c){wg(a,0);Yf(a)}H[a+512>>2]=0;H[a+516>>2]=0;H[a+520>>2]=0;H[a+524>>2]=0;b=H[a+36>>2]&-3;H[a+32>>2]=H[a+32>>2]&-524289;H[a+36>>2]=b;b=H[a+240>>2];if(!(!b|!(I[a+85|0]?f:1))){Ka[b|0](H[a+236>>2])}}function Dy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=Ga-16|0;Ga=d;H[d+12>>2]=0;c=Im(a);a:{if(c){break a}c=Pb(a,27,d+12|0,0);if(c){break a}e=H[d+12>>2];wc(e,1,H[a+280>>2]);wc(e,2,H[a+256>>2]);b:while(1){if((Ab(e)|0)==100){c=0;g=Qd(e,0);while(1){if(H[a+256>>2]<=(c|0)|f){continue b}f=Lq(a,g,c,-2);c=c+1|0;if((f|0)!=101){continue}f=0;h=1;continue}}break}c=(i=f,j=rb(e),k=f,k?i:j)}tf(a);Ga=d+16|0;return b?c?c:h?101:c:c}function Nn(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;if(H[a+112>>2]){c=a+112|0;h=H[a>>2];f=H[a+8>>2];while(1){a:{c=H[c>>2];if(!c){break a}e=H[c+12>>2];b=H[h+16>>2];d=H[c+8>>2];g=Db(a);Xa(f,55,e+2|0,H[f+108>>2]+7|0,e);fe(a,0,H[c+8>>2],H[H[(b+(d<<4)|0)+12>>2]+72>>2],113);b=zg(f,5,48944);if(!b){break a}d=e+1|0;H[b+72>>2]=d;H[b+68>>2]=g;H[b+52>>2]=g;H[b+44>>2]=e-1;H[b+28>>2]=d;H[b+4>>2]=d;G[b+62>>1]=8;xb(a,g);continue}break}}}function kl(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ga-16|0;Ga=d;a:{if(!H[b+52>>2]){break a}g=1;e=b;b:{c:{while(1){c=e;H[c+56>>2]=f;H[c+4>>2]=H[c+4>>2]|256;e=H[c+52>>2];if(!e){break b}g=g+1|0;f=17906;if(H[e+48>>2]){break c}f=c;if(!H[e+60>>2]){continue}break}f=18132}h=d,i=ij(I[c|0]),H[h+4>>2]=i;H[d>>2]=f;Za(a,12939,d)}if(I[b+5|0]&4){break a}b=H[H[a>>2]+136>>2];if((b|0)<=0|(b|0)>=(g|0)){break a}Za(a,18190,0)}Ga=d+16|0}function sh(a,b){var c=0,d=0;d=a;a:{b:{if((d^b)&3){c=I[b|0];break b}if(b&3){while(1){c=I[b|0];F[d|0]=c;if(!c){break a}d=d+1|0;b=b+1|0;if(b&3){continue}break}}c=H[b>>2];if((c^-1)&c-16843009&-2139062144){break b}while(1){H[d>>2]=c;c=H[b+4>>2];d=d+4|0;b=b+4|0;if(!(c-16843009&(c^-1)&-2139062144)){continue}break}}F[d|0]=c;if(!(c&255)){break a}while(1){c=I[b+1|0];F[d+1|0]=c;d=d+1|0;b=b+1|0;if(c){continue}break}}return a}function li(a,b){var c=0,d=0,e=0,f=0;f=I[a+9|0];e=H[a+56>>2];d=H[a+52>>2];if(I[d+24|0]&12){$a(e+f|0,0,H[d+40>>2]-f|0)}c=e+f|0;F[c|0]=b;F[c+7|0]=0;F[c+1|0]=0;F[c+2|0]=0;F[c+3|0]=0;F[c+4|0]=0;F[c+5|0]=H[d+40>>2]>>>8;F[c+6|0]=H[d+40>>2];c=f+(b&8?8:12)|0;H[a+20>>2]=H[d+40>>2]-c&65535;Bv(a,b);G[a+18>>1]=c;b=H[d+36>>2];H[a+64>>2]=c+e;H[a+68>>2]=I[a+10|0]+e;F[a+12|0]=0;G[a+24>>1]=0;F[a|0]=1;H[a+60>>2]=b+e;G[a+26>>1]=b-1}function ck(a,b){var c=0,d=0,e=0,f=0;d=Ga-16|0;Ga=d;a:{if(ct(a)){c=kd(87434);break a}if(I[a+149|0]!=1){Yc(H[a>>2],21);H[d>>2]=H[a+196>>2];Fc(21,17620,d);c=kd(87442);break a}if(!((b|0)>0&G[a+16>>1]>=(b|0))){c=25;Yc(H[a>>2],25);break a}e=b-1|0;c=H[a+100>>2]+N(e,40)|0;hd(c);G[c+16>>1]=1;c=0;H[H[a>>2]+64>>2]=0;f=H[a+224>>2];if(!f|!((b>>>0>31?-2147483648:1<<e)&f)){break a}F[a+150|0]=I[a+150|0]&252|1}Ga=d+16|0;return c}function Yp(a,b,c){var d=0,e=0;a:{switch(gb(c)-1|0){case 0:return Vb(a,b,H[c>>2],H[c+4>>2]);case 1:if(I[c+16|0]&8){e=M[c>>3]}else{e=+K[c>>2]+ +H[c+4>>2]*4294967296}return xx(a,b,e);case 3:if(I[c+17|0]&4){c=H[c>>2];d=ck(a,b);if(!d){_p((H[a+100>>2]+N(b,40)|0)-40|0,c)}return d}return Bg(a,b,H[c+8>>2],H[c+12>>2],-1);case 2:d=a;a=H[c+12>>2];return Zp(d,b,H[c+8>>2],a,a>>31,-1,I[c+18|0]);default:break a}}return oh(a,b)}function LG(a,b,c){a=a|0;b=b|0;c=c|0;v